import{s as is,o as os,n as xa}from"../chunks/scheduler.182ea377.js";import{S as rs,i as ps,g as n,s as i,p as c,x as v,A as hs,h as s,f as l,c as o,j as w,q as m,m as r,y as _,k as p,v as d,a,r as u,d as f,t as y,u as M}from"../chunks/index.008d68e4.js";import{T as Ca}from"../chunks/Tip.4f096367.js";import{I as C}from"../chunks/IconCopyLink.96bbb92b.js";import{C as g}from"../chunks/CodeBlock.5ed6eb7b.js";function ds(Z){let h,T='🤗 Accelerate is a library for helping you train on multiple GPUs/TPUs or with mixed-precision. It’ll automatically configure your training setup based on your hardware and environment. Take a look at the 🤗 Accelerate <a href="https://huggingface.co/docs/accelerate/quicktour" rel="nofollow">Quick tour</a> to learn more.';return{c(){h=n("p"),h.innerHTML=T},l(b){h=s(b,"P",{"data-svelte-h":!0}),r(h)!=="svelte-1qbiqsn"&&(h.innerHTML=T)},m(b,J){a(b,h,J)},p:xa,d(b){b&&l(h)}}}function cs(Z){let h,T='The following sections highlight parts of the training script that are important for understanding how to modify it, but it doesn’t cover every aspect of the script in detail. If you’re interested in learning more, feel free to read through the <a href="https://github.com/huggingface/diffusers/blob/main/examples/dreambooth/train_dreambooth.py" rel="nofollow">script</a> and let us know if you have any questions or concerns.';return{c(){h=n("p"),h.innerHTML=T},l(b){h=s(b,"P",{"data-svelte-h":!0}),r(h)!=="svelte-ag3huc"&&(h.innerHTML=T)},m(b,J){a(b,h,J)},p:xa,d(b){b&&l(h)}}}function ms(Z){let h,T='DreamBooth is very sensitive to training hyperparameters, and it is easy to overfit. Read the <a href="https://huggingface.co/blog/dreambooth" rel="nofollow">Training Stable Diffusion with Dreambooth using 🧨 Diffusers</a> blog post for recommended settings for different subjects to help you choose the appropriate hyperparameters.';return{c(){h=n("p"),h.innerHTML=T},l(b){h=s(b,"P",{"data-svelte-h":!0}),r(h)!=="svelte-1gadrly"&&(h.innerHTML=T)},m(b,J){a(b,h,J)},p:xa,d(b){b&&l(h)}}}function us(Z){let h,T="Can’t wait to try your model for inference before training is complete? 🤭 Make sure you have the latest version of 🤗 Accelerate installed.",b,J,j;return J=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTJDJTIwVU5ldDJEQ29uZGl0aW9uTW9kZWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQ0xJUFRleHRNb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJwYXRoJTJGdG8lMkZtb2RlbCUyRmNoZWNrcG9pbnQtMTAwJTJGdW5ldCUyMiklMEElMEElMjMlMjBpZiUyMHlvdSUyMGhhdmUlMjB0cmFpbmVkJTIwd2l0aCUyMCU2MC0tYXJncy50cmFpbl90ZXh0X2VuY29kZXIlNjAlMjBtYWtlJTIwc3VyZSUyMHRvJTIwYWxzbyUyMGxvYWQlMjB0aGUlMjB0ZXh0JTIwZW5jb2RlciUwQXRleHRfZW5jb2RlciUyMCUzRCUyMENMSVBUZXh0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnBhdGglMkZ0byUyRm1vZGVsJTJGY2hlY2twb2ludC0xMDAlMkZjaGVja3BvaW50LTEwMCUyRnRleHRfZW5jb2RlciUyMiklMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHVuZXQlM0R1bmV0JTJDJTIwdGV4dF9lbmNvZGVyJTNEdGV4dF9lbmNvZGVyJTJDJTIwZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTIyQSUyMHBob3RvJTIwb2YlMjBza3MlMjBkb2clMjBpbiUyMGElMjBidWNrZXQlMjIlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDcuNSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyZG9nLWJ1Y2tldC5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, UNet2DConditionModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPTextModel
<span class="hljs-keyword">import</span> torch

unet = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;path/to/model/checkpoint-100/unet&quot;</span>)

<span class="hljs-comment"># if you have trained with \`--args.train_text_encoder\` make sure to also load the text encoder</span>
text_encoder = CLIPTextModel.from_pretrained(<span class="hljs-string">&quot;path/to/model/checkpoint-100/checkpoint-100/text_encoder&quot;</span>)

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, unet=unet, text_encoder=text_encoder, dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipeline(<span class="hljs-string">&quot;A photo of sks dog in a bucket&quot;</span>, num_inference_steps=<span class="hljs-number">50</span>, guidance_scale=<span class="hljs-number">7.5</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;dog-bucket.png&quot;</span>)`}}),{c(){h=n("p"),h.textContent=T,b=i(),c(J.$$.fragment)},l(U){h=s(U,"P",{"data-svelte-h":!0}),r(h)!=="svelte-fduxd"&&(h.textContent=T),b=o(U),m(J.$$.fragment,U)},m(U,q){a(U,h,q),a(U,b,q),u(J,U,q),j=!0},p:xa,i(U){j||(f(J.$$.fragment,U),j=!0)},o(U){y(J.$$.fragment,U),j=!1},d(U){U&&(l(h),l(b)),M(J,U)}}}function fs(Z){let h,T,b,J,j,U,q,vt,Va="DreamBooth",Ht,K,Ea='<a href="https://huggingface.co/papers/2208.12242" rel="nofollow">DreamBooth</a> is a training technique that updates the entire diffusion model by training on just a few images of a subject or style. It works by associating a special word in the prompt with the example images.',St,O,Ya='If you’re training on a GPU with limited vRAM, you should try enabling the <code>gradient_checkpointing</code> and <code>mixed_precision</code> parameters in the training command. You can also reduce your memory footprint by using memory-efficient attention with <a href="../optimization/xformers">xFormers</a>. JAX/Flax training is also supported for efficient training on TPUs and GPUs, but it doesn’t support gradient checkpointing or xFormers. You should have a GPU with &gt;30GB of memory if you want to train faster with Flax.',Lt,ee,Fa='This guide will explore the <a href="https://github.com/huggingface/diffusers/blob/main/examples/dreambooth/train_dreambooth.py" rel="nofollow">train_dreambooth.py</a> script to help you become more familiar with it, and how you can adapt it for your own use-case.',Qt,te,za="Before running the script, make sure you install the library from source:",Pt,le,Dt,ae,Aa="Navigate to the example folder with the training script and install the required dependencies for the script you’re using:",qt,ne,Kt,se,Ot,N,el,ie,Ha="Initialize an 🤗 Accelerate environment:",tl,oe,ll,re,Sa="To setup a default 🤗 Accelerate environment without choosing any configurations:",al,pe,nl,he,La="Or if your environment doesn’t support an interactive shell, like a notebook, you can use:",sl,de,il,ce,Qa='Lastly, if you want to train a model on your own dataset, take a look at the <a href="create_dataset">Create a dataset for training</a> guide to learn how to create a dataset that works with the training script.',ol,V,rl,x,E,Rt,me,$a,_t,Pa="Script parameters",pl,Y,hl,ue,Da='The training script offers many parameters for customizing your training run. All of the parameters and their descriptions are found in the <a href="https://github.com/huggingface/diffusers/blob/072e00897a7cf4302c347a63ec917b4b8add16d4/examples/dreambooth/train_dreambooth.py#L228" rel="nofollow"><code>parse_args()</code></a> function. The parameters are set with default values that should work pretty well out-of-the-box, but you can also set your own values in the training command if you’d like.',dl,fe,qa="For example, to train in the bf16 format:",cl,ye,ml,Me,Ka="Some basic and important parameters to know and specify are:",ul,be,Oa="<li><code>--pretrained_model_name_or_path</code>: the name of the model on the Hub or a local path to the pretrained model</li> <li><code>--instance_data_dir</code>: path to a folder containing the training dataset (example images)</li> <li><code>--instance_prompt</code>: the text prompt that contains the special word for the example images</li> <li><code>--train_text_encoder</code>: whether to also train the text encoder</li> <li><code>--output_dir</code>: where to save the trained model</li> <li><code>--push_to_hub</code>: whether to push the trained model to the Hub</li> <li><code>--checkpointing_steps</code>: frequency of saving a checkpoint as the model trains; this is useful if for some reason training is interrupted, you can continue training from that checkpoint by adding <code>--resume_from_checkpoint</code> to your training command</li>",fl,$,F,kt,we,Ga,Zt,en="Min-SNR weighting",yl,ge,tn='The <a href="https://huggingface.co/papers/2303.09556" rel="nofollow">Min-SNR</a> weighting strategy can help with training by rebalancing the loss to achieve faster convergence. The training script supports predicting <code>epsilon</code> (noise) or <code>v_prediction</code>, but Min-SNR is compatible with both prediction types. This weighting strategy is only supported by PyTorch and is unavailable in the Flax training script.',Ml,Je,ln="Add the <code>--snr_gamma</code> parameter and set it to the recommended value of 5.0:",bl,Ue,wl,G,z,Bt,Te,Wa,jt,an="Prior preservation loss",gl,ve,nn="Prior preservation loss is a method that uses a model’s own generated samples to help it learn how to generate more diverse images. Because these generated sample images belong to the same class as the images you provided, they help the model retain what it has learned about the class and how it can use what it already knows about the class to make new compositions.",Jl,_e,sn="<li><code>--with_prior_preservation</code>: whether to use prior preservation loss</li> <li><code>--prior_loss_weight</code>: controls the influence of the prior preservation loss on the model</li> <li><code>--class_data_dir</code>: path to a folder containing the generated class sample images</li> <li><code>--class_prompt</code>: the text prompt describing the class of the generated sample images</li>",Ul,Ze,Tl,W,A,It,je,Xa,Ct,on="Train text encoder",vl,Ce,rn="To improve the quality of the generated outputs, you can also train the text encoder in addition to the UNet. This requires additional memory and you’ll need a GPU with at least 24GB of vRAM. If you have the necessary hardware, then training the text encoder produces better results, especially when generating images of faces. Enable this option by:",_l,xe,Zl,X,H,Nt,$e,Ra,xt,pn="Training script",jl,Ge,hn="DreamBooth comes with its own dataset classes:",Cl,We,dn='<li><a href="https://github.com/huggingface/diffusers/blob/072e00897a7cf4302c347a63ec917b4b8add16d4/examples/dreambooth/train_dreambooth.py#L604" rel="nofollow"><code>DreamBoothDataset</code></a>: preprocesses the images and class images, and tokenizes the prompts for training</li> <li><a href="https://github.com/huggingface/diffusers/blob/072e00897a7cf4302c347a63ec917b4b8add16d4/examples/dreambooth/train_dreambooth.py#L738" rel="nofollow"><code>PromptDataset</code></a>: generates the prompt embeddings to generate the class images</li>',xl,Xe,cn='If you enabled <a href="https://github.com/huggingface/diffusers/blob/072e00897a7cf4302c347a63ec917b4b8add16d4/examples/dreambooth/train_dreambooth.py#L842" rel="nofollow">prior preservation loss</a>, the class images are generated here:',$l,Re,Gl,ke,mn='Next is the <a href="https://github.com/huggingface/diffusers/blob/072e00897a7cf4302c347a63ec917b4b8add16d4/examples/dreambooth/train_dreambooth.py#L799" rel="nofollow"><code>main()</code></a> function which handles setting up the dataset for training and the training loop itself. The script loads the <a href="https://github.com/huggingface/diffusers/blob/072e00897a7cf4302c347a63ec917b4b8add16d4/examples/dreambooth/train_dreambooth.py#L898" rel="nofollow">tokenizer</a>, <a href="https://github.com/huggingface/diffusers/blob/072e00897a7cf4302c347a63ec917b4b8add16d4/examples/dreambooth/train_dreambooth.py#L912C1-L912C1" rel="nofollow">scheduler and models</a>:',Wl,Be,Xl,Ie,un='Then, it’s time to <a href="https://github.com/huggingface/diffusers/blob/072e00897a7cf4302c347a63ec917b4b8add16d4/examples/dreambooth/train_dreambooth.py#L1073" rel="nofollow">create the training dataset</a> and DataLoader from <code>DreamBoothDataset</code>:',Rl,Ne,kl,Ve,fn='Lastly, the <a href="https://github.com/huggingface/diffusers/blob/072e00897a7cf4302c347a63ec917b4b8add16d4/examples/dreambooth/train_dreambooth.py#L1151" rel="nofollow">training loop</a> takes care of the remaining steps such as converting images to latent space, adding noise to the input, predicting the noise residual, and calculating the loss.',Bl,Ee,yn='If you want to learn more about how the training loop works, check out the <a href="../using-diffusers/write_own_pipeline">Understanding pipelines, models and schedulers</a> tutorial which breaks down the basic pattern of the denoising process.',Il,R,S,Vt,Ye,ka,$t,Mn="Launch the script",Nl,Fe,bn="You’re now ready to launch the training script! 🚀",Vl,ze,wn='For this guide, you’ll download some images of a <a href="https://huggingface.co/datasets/diffusers/dog-example" rel="nofollow">dog</a> and store them in a directory. But remember, you can create and use your own dataset if you want (see the <a href="create_dataset">Create a dataset for training</a> guide).',El,Ae,Yl,He,gn="Set the environment variable <code>MODEL_NAME</code> to a model id on the Hub or a path to a local model, <code>INSTANCE_DIR</code> to the path where you just downloaded the dog images to, and <code>OUTPUT_DIR</code> to where you want to save the model. You’ll use <code>sks</code> as the special word to tie the training to.",Fl,Se,Jn="If you’re interested in following along with the training process, you can periodically save generated images as training progresses. Add the following parameters to the training command:",zl,Le,Al,Qe,Un="One more thing before you launch the script! Depending on the GPU you have, you may need to enable certain optimizations to train DreamBooth.",Hl,Pe,Tn="On a 16GB GPU, you can use bitsandbytes 8-bit optimizer and gradient checkpointing to help you train a DreamBooth model. Install bitsandbytes:",Sl,De,Ll,qe,vn="Then, add the following parameter to your training command:",Ql,Ke,Pl,Oe,_n="On a 12GB GPU, you’ll need bitsandbytes 8-bit optimizer, gradient checkpointing, xFormers, and set the gradients to <code>None</code> instead of zero to reduce your memory-usage.",Dl,et,ql,tt,Zn='On a 8GB GPU, you’ll need <a href="https://www.deepspeed.ai/" rel="nofollow">DeepSpeed</a> to offload some of the tensors from the vRAM to either the CPU or NVME to allow training with less GPU memory.',Kl,lt,jn="Run the following command to configure your 🤗 Accelerate environment:",Ol,at,ea,nt,Cn='During configuration, confirm that you want to use DeepSpeed. Now it should be possible to train on under 8GB vRAM by combining DeepSpeed stage 2, fp16 mixed precision, and offloading the model parameters and the optimizer state to the CPU. The drawback is that this requires more system RAM (~25 GB). See the <a href="https://huggingface.co/docs/accelerate/usage_guides/deepspeed" rel="nofollow">DeepSpeed documentation</a> for more configuration options.',ta,st,xn='You should also change the default Adam optimizer to DeepSpeed’s optimized version of Adam <a href="https://deepspeed.readthedocs.io/en/latest/optimizers.html#adam-cpu" rel="nofollow"><code>deepspeed.ops.adam.DeepSpeedCPUAdam</code></a> for a substantial speedup. Enabling <code>DeepSpeedCPUAdam</code> requires your system’s CUDA toolchain version to be the same as the one installed with PyTorch.',la,it,$n="bitsandbytes 8-bit optimizers don’t seem to be compatible with DeepSpeed at the moment.",aa,ot,Gn="That’s it! You don’t need to add any additional parameters to your training command.",na,rt,sa,pt,ia,ht,Wn="Once training is complete, you can use your newly trained model for inference!",oa,L,ra,dt,pa,ct,ha,k,Q,Et,mt,Ba,Gt,Xn="LoRA",da,ut,Rn='LoRA is a training technique for significantly reducing the number of trainable parameters. As a result, training is faster and it is easier to store the resulting weights because they are a lot smaller (~100MBs). Use the <a href="https://github.com/huggingface/diffusers/blob/main/examples/dreambooth/train_dreambooth_lora.py" rel="nofollow">train_dreambooth_lora.py</a> script to train with LoRA.',ca,ft,kn='The LoRA training script is discussed in more detail in the <a href="lora">LoRA training</a> guide.',ma,B,P,Yt,yt,Ia,Wt,Bn="Stable Diffusion XL",ua,Mt,In='Stable Diffusion XL (SDXL) is a powerful text-to-image model that generates high-resolution images, and it adds a second text-encoder to its architecture. Use the <a href="https://github.com/huggingface/diffusers/blob/main/examples/dreambooth/train_dreambooth_lora_sdxl.py" rel="nofollow">train_dreambooth_lora_sdxl.py</a> script to train a SDXL model with LoRA.',fa,bt,Nn='The SDXL training script is discussed in more detail in the <a href="sdxl">SDXL training</a> guide.',ya,I,D,Ft,wt,Na,Xt,Vn="Next steps",Ma,gt,En="Congratulations on training your DreamBooth model! To learn more about how to use your new model, the following guide may be helpful:",ba,Jt,Yn='<li>Learn how to <a href="../using-diffusers/loading_adapters">load a DreamBooth</a> model for inference if you trained your model with LoRA.</li>',wa;return U=new C({}),le=new g({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUwQWNkJTIwZGlmZnVzZXJzJTBBcGlwJTIwaW5zdGFsbCUyMC4=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/huggingface/diffusers
<span class="hljs-built_in">cd</span> diffusers
pip install .`}}),ne=new g({props:{code:"Y2QlMjBleGFtcGxlcyUyRmRyZWFtYm9vdGglMEFwaXAlMjBpbnN0YWxsJTIwLXIlMjByZXF1aXJlbWVudHMudHh0",highlighted:`<span class="hljs-built_in">cd</span> examples/dreambooth
pip install -r requirements.txt`}}),se=new g({props:{code:"Y2QlMjBleGFtcGxlcyUyRmRyZWFtYm9vdGglMEFwaXAlMjBpbnN0YWxsJTIwLXIlMjByZXF1aXJlbWVudHNfZmxheC50eHQ=",highlighted:`<span class="hljs-built_in">cd</span> examples/dreambooth
pip install -r requirements_flax.txt`}}),N=new Ca({props:{$$slots:{default:[ds]},$$scope:{ctx:Z}}}),oe=new g({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config"}}),pe=new g({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMGRlZmF1bHQ=",highlighted:"accelerate config default"}}),de=new g({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjB3cml0ZV9iYXNpY19jb25maWclMEElMEF3cml0ZV9iYXNpY19jb25maWcoKQ==",highlighted:`from accelerate.utils import write_basic_config

write_basic_config()`}}),V=new Ca({props:{$$slots:{default:[cs]},$$scope:{ctx:Z}}}),me=new C({}),Y=new Ca({props:{warning:!0,$$slots:{default:[ms]},$$scope:{ctx:Z}}}),ye=new g({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2RyZWFtYm9vdGgucHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1peGVkX3ByZWNpc2lvbiUzRCUyMmJmMTYlMjI=",highlighted:`accelerate launch train_dreambooth.py \\
    --mixed_precision=<span class="hljs-string">&quot;bf16&quot;</span>`}}),we=new C({}),Ue=new g({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2RyZWFtYm9vdGgucHklMjAlNUMlMEElMjAlMjAtLXNucl9nYW1tYSUzRDUuMA==",highlighted:`accelerate launch train_dreambooth.py \\
  --snr_gamma=5.0`}}),Te=new C({}),Ze=new g({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2RyZWFtYm9vdGgucHklMjAlNUMlMEElMjAlMjAtLXdpdGhfcHJpb3JfcHJlc2VydmF0aW9uJTIwJTVDJTBBJTIwJTIwLS1wcmlvcl9sb3NzX3dlaWdodCUzRDEuMCUyMCU1QyUwQSUyMCUyMC0tY2xhc3NfZGF0YV9kaXIlM0QlMjJwYXRoJTJGdG8lMkZjbGFzcyUyRmltYWdlcyUyMiUyMCU1QyUwQSUyMCUyMC0tY2xhc3NfcHJvbXB0JTNEJTIydGV4dCUyMHByb21wdCUyMGRlc2NyaWJpbmclMjBjbGFzcyUyMg==",highlighted:`accelerate launch train_dreambooth.py \\
  --with_prior_preservation \\
  --prior_loss_weight=1.0 \\
  --class_data_dir=<span class="hljs-string">&quot;path/to/class/images&quot;</span> \\
  --class_prompt=<span class="hljs-string">&quot;text prompt describing class&quot;</span>`}}),je=new C({}),xe=new g({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2RyZWFtYm9vdGgucHklMjAlNUMlMEElMjAlMjAtLXRyYWluX3RleHRfZW5jb2Rlcg==",highlighted:`accelerate launch train_dreambooth.py \\
  --train_text_encoder`}}),$e=new C({}),Re=new g({props:{code:"c2FtcGxlX2RhdGFzZXQlMjAlM0QlMjBQcm9tcHREYXRhc2V0KGFyZ3MuY2xhc3NfcHJvbXB0JTJDJTIwbnVtX25ld19pbWFnZXMpJTBBc2FtcGxlX2RhdGFsb2FkZXIlMjAlM0QlMjB0b3JjaC51dGlscy5kYXRhLkRhdGFMb2FkZXIoc2FtcGxlX2RhdGFzZXQlMkMlMjBiYXRjaF9zaXplJTNEYXJncy5zYW1wbGVfYmF0Y2hfc2l6ZSklMEElMEFzYW1wbGVfZGF0YWxvYWRlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUoc2FtcGxlX2RhdGFsb2FkZXIpJTBBcGlwZWxpbmUudG8oYWNjZWxlcmF0b3IuZGV2aWNlKSUwQSUwQWZvciUyMGV4YW1wbGUlMjBpbiUyMHRxZG0oJTBBJTIwJTIwJTIwJTIwc2FtcGxlX2RhdGFsb2FkZXIlMkMlMjBkZXNjJTNEJTIyR2VuZXJhdGluZyUyMGNsYXNzJTIwaW1hZ2VzJTIyJTJDJTIwZGlzYWJsZSUzRG5vdCUyMGFjY2VsZXJhdG9yLmlzX2xvY2FsX21haW5fcHJvY2VzcyUwQSklM0ElMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjBwaXBlbGluZShleGFtcGxlJTVCJTIycHJvbXB0JTIyJTVEKS5pbWFnZXM=",highlighted:`sample_dataset = PromptDataset(args.class_prompt, num_new_images)
sample_dataloader = torch.utils.data.DataLoader(sample_dataset, batch_size=args.sample_batch_size)

sample_dataloader = accelerator.prepare(sample_dataloader)
pipeline.to(accelerator.device)

<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> tqdm(
    sample_dataloader, desc=<span class="hljs-string">&quot;Generating class images&quot;</span>, disable=<span class="hljs-keyword">not</span> accelerator.is_local_main_process
):
    images = pipeline(example[<span class="hljs-string">&quot;prompt&quot;</span>]).images`}}),Be=new g({props:{code:"JTIzJTIwTG9hZCUyMHRoZSUyMHRva2VuaXplciUwQWlmJTIwYXJncy50b2tlbml6ZXJfbmFtZSUzQSUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKGFyZ3MudG9rZW5pemVyX25hbWUlMkMlMjByZXZpc2lvbiUzRGFyZ3MucmV2aXNpb24lMkMlMjB1c2VfZmFzdCUzREZhbHNlKSUwQWVsaWYlMjBhcmdzLnByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTNBJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXJncy5wcmV0cmFpbmVkX21vZGVsX25hbWVfb3JfcGF0aCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRva2VuaXplciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldmlzaW9uJTNEYXJncy5yZXZpc2lvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHVzZV9mYXN0JTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTBBJTIzJTIwTG9hZCUyMHNjaGVkdWxlciUyMGFuZCUyMG1vZGVscyUwQW5vaXNlX3NjaGVkdWxlciUyMCUzRCUyMEREUE1TY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKGFyZ3MucHJldHJhaW5lZF9tb2RlbF9uYW1lX29yX3BhdGglMkMlMjBzdWJmb2xkZXIlM0QlMjJzY2hlZHVsZXIlMjIpJTBBdGV4dF9lbmNvZGVyJTIwJTNEJTIwdGV4dF9lbmNvZGVyX2Nscy5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwYXJncy5wcmV0cmFpbmVkX21vZGVsX25hbWVfb3JfcGF0aCUyQyUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2RlciUyMiUyQyUyMHJldmlzaW9uJTNEYXJncy5yZXZpc2lvbiUwQSklMEElMEFpZiUyMG1vZGVsX2hhc192YWUoYXJncyklM0ElMEElMjAlMjAlMjAlMjB2YWUlMjAlM0QlMjBBdXRvZW5jb2RlcktMLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhcmdzLnByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTJDJTIwc3ViZm9sZGVyJTNEJTIydmFlJTIyJTJDJTIwcmV2aXNpb24lM0RhcmdzLnJldmlzaW9uJTBBJTIwJTIwJTIwJTIwKSUwQWVsc2UlM0ElMEElMjAlMjAlMjAlMjB2YWUlMjAlM0QlMjBOb25lJTBBJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBhcmdzLnByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTJDJTIwc3ViZm9sZGVyJTNEJTIydW5ldCUyMiUyQyUyMHJldmlzaW9uJTNEYXJncy5yZXZpc2lvbiUwQSk=",highlighted:`<span class="hljs-comment"># Load the tokenizer</span>
<span class="hljs-keyword">if</span> args.tokenizer_name:
    tokenizer = AutoTokenizer.from_pretrained(args.tokenizer_name, revision=args.revision, use_fast=<span class="hljs-literal">False</span>)
<span class="hljs-keyword">elif</span> args.pretrained_model_name_or_path:
    tokenizer = AutoTokenizer.from_pretrained(
        args.pretrained_model_name_or_path,
        subfolder=<span class="hljs-string">&quot;tokenizer&quot;</span>,
        revision=args.revision,
        use_fast=<span class="hljs-literal">False</span>,
    )
    
<span class="hljs-comment"># Load scheduler and models</span>
noise_scheduler = DDPMScheduler.from_pretrained(args.pretrained_model_name_or_path, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
text_encoder = text_encoder_cls.from_pretrained(
    args.pretrained_model_name_or_path, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>, revision=args.revision
)

<span class="hljs-keyword">if</span> model_has_vae(args):
    vae = AutoencoderKL.from_pretrained(
        args.pretrained_model_name_or_path, subfolder=<span class="hljs-string">&quot;vae&quot;</span>, revision=args.revision
    )
<span class="hljs-keyword">else</span>:
    vae = <span class="hljs-literal">None</span>

unet = UNet2DConditionModel.from_pretrained(
    args.pretrained_model_name_or_path, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, revision=args.revision
)`}}),Ne=new g({props:{code:"dHJhaW5fZGF0YXNldCUyMCUzRCUyMERyZWFtQm9vdGhEYXRhc2V0KCUwQSUyMCUyMCUyMCUyMGluc3RhbmNlX2RhdGFfcm9vdCUzRGFyZ3MuaW5zdGFuY2VfZGF0YV9kaXIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV9wcm9tcHQlM0RhcmdzLmluc3RhbmNlX3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMGNsYXNzX2RhdGFfcm9vdCUzRGFyZ3MuY2xhc3NfZGF0YV9kaXIlMjBpZiUyMGFyZ3Mud2l0aF9wcmlvcl9wcmVzZXJ2YXRpb24lMjBlbHNlJTIwTm9uZSUyQyUwQSUyMCUyMCUyMCUyMGNsYXNzX3Byb21wdCUzRGFyZ3MuY2xhc3NfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwY2xhc3NfbnVtJTNEYXJncy5udW1fY2xhc3NfaW1hZ2VzJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwc2l6ZSUzRGFyZ3MucmVzb2x1dGlvbiUyQyUwQSUyMCUyMCUyMCUyMGNlbnRlcl9jcm9wJTNEYXJncy5jZW50ZXJfY3JvcCUyQyUwQSUyMCUyMCUyMCUyMGVuY29kZXJfaGlkZGVuX3N0YXRlcyUzRHByZV9jb21wdXRlZF9lbmNvZGVyX2hpZGRlbl9zdGF0ZXMlMkMlMEElMjAlMjAlMjAlMjBjbGFzc19wcm9tcHRfZW5jb2Rlcl9oaWRkZW5fc3RhdGVzJTNEcHJlX2NvbXB1dGVkX2NsYXNzX3Byb21wdF9lbmNvZGVyX2hpZGRlbl9zdGF0ZXMlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfbWF4X2xlbmd0aCUzRGFyZ3MudG9rZW5pemVyX21heF9sZW5ndGglMkMlMEEpJTBBJTBBdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMHRvcmNoLnV0aWxzLmRhdGEuRGF0YUxvYWRlciglMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzRGFyZ3MudHJhaW5fYmF0Y2hfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMHNodWZmbGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwY29sbGF0ZV9mbiUzRGxhbWJkYSUyMGV4YW1wbGVzJTNBJTIwY29sbGF0ZV9mbihleGFtcGxlcyUyQyUyMGFyZ3Mud2l0aF9wcmlvcl9wcmVzZXJ2YXRpb24pJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3dvcmtlcnMlM0RhcmdzLmRhdGFsb2FkZXJfbnVtX3dvcmtlcnMlMkMlMEEp",highlighted:`train_dataset = DreamBoothDataset(
    instance_data_root=args.instance_data_dir,
    instance_prompt=args.instance_prompt,
    class_data_root=args.class_data_dir <span class="hljs-keyword">if</span> args.with_prior_preservation <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>,
    class_prompt=args.class_prompt,
    class_num=args.num_class_images,
    tokenizer=tokenizer,
    size=args.resolution,
    center_crop=args.center_crop,
    encoder_hidden_states=pre_computed_encoder_hidden_states,
    class_prompt_encoder_hidden_states=pre_computed_class_prompt_encoder_hidden_states,
    tokenizer_max_length=args.tokenizer_max_length,
)

train_dataloader = torch.utils.data.DataLoader(
    train_dataset,
    batch_size=args.train_batch_size,
    shuffle=<span class="hljs-literal">True</span>,
    collate_fn=<span class="hljs-keyword">lambda</span> examples: collate_fn(examples, args.with_prior_preservation),
    num_workers=args.dataloader_num_workers,
)`}}),Ye=new C({}),Ae=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBJTBBbG9jYWxfZGlyJTIwJTNEJTIwJTIyLiUyRmRvZyUyMiUwQXNuYXBzaG90X2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMCUyMmRpZmZ1c2VycyUyRmRvZy1leGFtcGxlJTIyJTJDJTBBJTIwJTIwJTIwJTIwbG9jYWxfZGlyJTNEbG9jYWxfZGlyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUwQSUyMCUyMCUyMCUyMGlnbm9yZV9wYXR0ZXJucyUzRCUyMi5naXRhdHRyaWJ1dGVzJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download

local_dir = <span class="hljs-string">&quot;./dog&quot;</span>
snapshot_download(
    <span class="hljs-string">&quot;diffusers/dog-example&quot;</span>,
    local_dir=local_dir,
    repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
    ignore_patterns=<span class="hljs-string">&quot;.gitattributes&quot;</span>,
)`}}),Le=new g({props:{code:"LS12YWxpZGF0aW9uX3Byb21wdCUzRCUyMmElMjBwaG90byUyMG9mJTIwYSUyMHNrcyUyMGRvZyUyMiUwQS0tbnVtX3ZhbGlkYXRpb25faW1hZ2VzJTNENCUwQS0tdmFsaWRhdGlvbl9zdGVwcyUzRDEwMA==",highlighted:`--validation_prompt=<span class="hljs-string">&quot;a photo of a sks dog&quot;</span>
--num_validation_images=4
--validation_steps=100`}}),De=new g({props:{code:"cGlwJTIwaW5zdGFsbCUyMGJpdHNhbmRieXRlcw==",highlighted:"pip install bitsandbytes"}}),Ke=new g({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2RyZWFtYm9vdGgucHklMjAlNUMlMEElMjAlMjAtLWdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjAlNUMlMEElMjAlMjAtLXVzZV84Yml0X2FkYW0lMjAlNUM=",highlighted:`accelerate launch train_dreambooth.py \\
  --gradient_checkpointing \\
  --use_8bit_adam \\`}}),et=new g({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2RyZWFtYm9vdGgucHklMjAlNUMlMEElMjAlMjAtLXVzZV84Yml0X2FkYW0lMjAlNUMlMEElMjAlMjAtLWdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjAlNUMlMEElMjAlMjAtLWVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbiUyMCU1QyUwQSUyMCUyMC0tc2V0X2dyYWRzX3RvX25vbmUlMjAlNUM=",highlighted:`accelerate launch train_dreambooth.py \\
  --use_8bit_adam \\
  --gradient_checkpointing \\
  --enable_xformers_memory_efficient_attention \\
  --set_grads_to_none \\`}}),at=new g({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config"}}),rt=new g({props:{code:"ZXhwb3J0JTIwTU9ERUxfTkFNRSUzRCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBZXhwb3J0JTIwSU5TVEFOQ0VfRElSJTNEJTIyLiUyRmRvZyUyMiUwQWV4cG9ydCUyME9VVFBVVF9ESVIlM0QlMjJwYXRoX3RvX3NhdmVkX21vZGVsJTIyJTBBJTBBYWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2RyZWFtYm9vdGgucHklMjAlNUMlMEElMjAlMjAtLXByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTNEJTI0TU9ERUxfTkFNRSUyMCUyMCU1QyUwQSUyMCUyMC0taW5zdGFuY2VfZGF0YV9kaXIlM0QlMjRJTlNUQU5DRV9ESVIlMjAlNUMlMEElMjAlMjAtLW91dHB1dF9kaXIlM0QlMjRPVVRQVVRfRElSJTIwJTVDJTBBJTIwJTIwLS1pbnN0YW5jZV9wcm9tcHQlM0QlMjJhJTIwcGhvdG8lMjBvZiUyMHNrcyUyMGRvZyUyMiUyMCU1QyUwQSUyMCUyMC0tcmVzb2x1dGlvbiUzRDUxMiUyMCU1QyUwQSUyMCUyMC0tdHJhaW5fYmF0Y2hfc2l6ZSUzRDElMjAlNUMlMEElMjAlMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDElMjAlNUMlMEElMjAlMjAtLWxlYXJuaW5nX3JhdGUlM0Q1ZS02JTIwJTVDJTBBJTIwJTIwLS1scl9zY2hlZHVsZXIlM0QlMjJjb25zdGFudCUyMiUyMCU1QyUwQSUyMCUyMC0tbHJfd2FybXVwX3N0ZXBzJTNEMCUyMCU1QyUwQSUyMCUyMC0tbWF4X3RyYWluX3N0ZXBzJTNENDAwJTIwJTVDJTBBJTIwJTIwLS1wdXNoX3RvX2h1Yg==",highlighted:`<span class="hljs-built_in">export</span> MODEL_NAME=<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-built_in">export</span> INSTANCE_DIR=<span class="hljs-string">&quot;./dog&quot;</span>
<span class="hljs-built_in">export</span> OUTPUT_DIR=<span class="hljs-string">&quot;path_to_saved_model&quot;</span>

accelerate launch train_dreambooth.py \\
  --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_NAME</span>  \\
  --instance_data_dir=<span class="hljs-variable">$INSTANCE_DIR</span> \\
  --output_dir=<span class="hljs-variable">$OUTPUT_DIR</span> \\
  --instance_prompt=<span class="hljs-string">&quot;a photo of sks dog&quot;</span> \\
  --resolution=512 \\
  --train_batch_size=1 \\
  --gradient_accumulation_steps=1 \\
  --learning_rate=5e-6 \\
  --lr_scheduler=<span class="hljs-string">&quot;constant&quot;</span> \\
  --lr_warmup_steps=0 \\
  --max_train_steps=400 \\
  --push_to_hub`}}),pt=new g({props:{code:"ZXhwb3J0JTIwTU9ERUxfTkFNRSUzRCUyMmR1b25nbmElMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQtZmxheCUyMiUwQWV4cG9ydCUyMElOU1RBTkNFX0RJUiUzRCUyMi4lMkZkb2clMjIlMEFleHBvcnQlMjBPVVRQVVRfRElSJTNEJTIycGF0aC10by1zYXZlLW1vZGVsJTIyJTBBJTBBcHl0aG9uJTIwdHJhaW5fZHJlYW1ib290aF9mbGF4LnB5JTIwJTVDJTBBJTIwJTIwLS1wcmV0cmFpbmVkX21vZGVsX25hbWVfb3JfcGF0aCUzRCUyNE1PREVMX05BTUUlMjAlMjAlNUMlMEElMjAlMjAtLWluc3RhbmNlX2RhdGFfZGlyJTNEJTI0SU5TVEFOQ0VfRElSJTIwJTVDJTBBJTIwJTIwLS1vdXRwdXRfZGlyJTNEJTI0T1VUUFVUX0RJUiUyMCU1QyUwQSUyMCUyMC0taW5zdGFuY2VfcHJvbXB0JTNEJTIyYSUyMHBob3RvJTIwb2YlMjBza3MlMjBkb2clMjIlMjAlNUMlMEElMjAlMjAtLXJlc29sdXRpb24lM0Q1MTIlMjAlNUMlMEElMjAlMjAtLXRyYWluX2JhdGNoX3NpemUlM0QxJTIwJTVDJTBBJTIwJTIwLS1sZWFybmluZ19yYXRlJTNENWUtNiUyMCU1QyUwQSUyMCUyMC0tbWF4X3RyYWluX3N0ZXBzJTNENDAwJTIwJTVDJTBBJTIwJTIwLS1wdXNoX3RvX2h1Yg==",highlighted:`<span class="hljs-built_in">export</span> MODEL_NAME=<span class="hljs-string">&quot;duongna/stable-diffusion-v1-4-flax&quot;</span>
<span class="hljs-built_in">export</span> INSTANCE_DIR=<span class="hljs-string">&quot;./dog&quot;</span>
<span class="hljs-built_in">export</span> OUTPUT_DIR=<span class="hljs-string">&quot;path-to-save-model&quot;</span>

python train_dreambooth_flax.py \\
  --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_NAME</span>  \\
  --instance_data_dir=<span class="hljs-variable">$INSTANCE_DIR</span> \\
  --output_dir=<span class="hljs-variable">$OUTPUT_DIR</span> \\
  --instance_prompt=<span class="hljs-string">&quot;a photo of sks dog&quot;</span> \\
  --resolution=512 \\
  --train_batch_size=1 \\
  --learning_rate=5e-6 \\
  --max_train_steps=400 \\
  --push_to_hub`}}),L=new Ca({props:{$$slots:{default:[us]},$$scope:{ctx:Z}}}),dt=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJwYXRoX3RvX3NhdmVkX21vZGVsJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSkudG8oJTIyY3VkYSUyMiklMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUyMkElMjBwaG90byUyMG9mJTIwc2tzJTIwZG9nJTIwaW4lMjBhJTIwYnVja2V0JTIyJTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q3LjUpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmRvZy1idWNrZXQucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;path_to_saved_model&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
image = pipeline(<span class="hljs-string">&quot;A photo of sks dog in a bucket&quot;</span>, num_inference_steps=<span class="hljs-number">50</span>, guidance_scale=<span class="hljs-number">7.5</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;dog-bucket.png&quot;</span>)`}}),ct=new g({props:{code:"aW1wb3J0JTIwamF4JTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGZsYXguamF4X3V0aWxzJTIwaW1wb3J0JTIwcmVwbGljYXRlJTBBZnJvbSUyMGZsYXgudHJhaW5pbmcuY29tbW9uX3V0aWxzJTIwaW1wb3J0JTIwc2hhcmQlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmxheFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMkMlMjBwYXJhbXMlMjAlM0QlMjBGbGF4U3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnBhdGgtdG8teW91ci10cmFpbmVkLW1vZGVsJTIyJTJDJTIwZHR5cGUlM0RqYXgubnVtcHkuYmZsb2F0MTYpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMHBob3RvJTIwb2YlMjBza3MlMjBkb2clMjBpbiUyMGElMjBidWNrZXQlMjIlMEFwcm5nX3NlZWQlMjAlM0QlMjBqYXgucmFuZG9tLlBSTkdLZXkoMCklMEFudW1faW5mZXJlbmNlX3N0ZXBzJTIwJTNEJTIwNTAlMEElMEFudW1fc2FtcGxlcyUyMCUzRCUyMGpheC5kZXZpY2VfY291bnQoKSUwQXByb21wdCUyMCUzRCUyMG51bV9zYW1wbGVzJTIwKiUyMCU1QnByb21wdCU1RCUwQXByb21wdF9pZHMlMjAlM0QlMjBwaXBlbGluZS5wcmVwYXJlX2lucHV0cyhwcm9tcHQpJTBBJTBBJTIzJTIwc2hhcmQlMjBpbnB1dHMlMjBhbmQlMjBybmclMEFwYXJhbXMlMjAlM0QlMjByZXBsaWNhdGUocGFyYW1zKSUwQXBybmdfc2VlZCUyMCUzRCUyMGpheC5yYW5kb20uc3BsaXQocHJuZ19zZWVkJTJDJTIwamF4LmRldmljZV9jb3VudCgpKSUwQXByb21wdF9pZHMlMjAlM0QlMjBzaGFyZChwcm9tcHRfaWRzKSUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKHByb21wdF9pZHMlMkMlMjBwYXJhbXMlMkMlMjBwcm5nX3NlZWQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTJDJTIwaml0JTNEVHJ1ZSkuaW1hZ2VzJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUubnVtcHlfdG9fcGlsKG5wLmFzYXJyYXkoaW1hZ2VzLnJlc2hhcGUoKG51bV9zYW1wbGVzJTJDKSUyMCUyQiUyMGltYWdlcy5zaGFwZSU1Qi0zJTNBJTVEKSkpJTBBaW1hZ2Uuc2F2ZSglMjJkb2ctYnVja2V0LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> jax
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> flax.jax_utils <span class="hljs-keyword">import</span> replicate
<span class="hljs-keyword">from</span> flax.training.common_utils <span class="hljs-keyword">import</span> shard
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxStableDiffusionPipeline

pipeline, params = FlaxStableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;path-to-your-trained-model&quot;</span>, dtype=jax.numpy.bfloat16)

prompt = <span class="hljs-string">&quot;A photo of sks dog in a bucket&quot;</span>
prng_seed = jax.random.PRNGKey(<span class="hljs-number">0</span>)
num_inference_steps = <span class="hljs-number">50</span>

num_samples = jax.device_count()
prompt = num_samples * [prompt]
prompt_ids = pipeline.prepare_inputs(prompt)

<span class="hljs-comment"># shard inputs and rng</span>
params = replicate(params)
prng_seed = jax.random.split(prng_seed, jax.device_count())
prompt_ids = shard(prompt_ids)

images = pipeline(prompt_ids, params, prng_seed, num_inference_steps, jit=<span class="hljs-literal">True</span>).images
images = pipeline.numpy_to_pil(np.asarray(images.reshape((num_samples,) + images.shape[-<span class="hljs-number">3</span>:])))
image.save(<span class="hljs-string">&quot;dog-bucket.png&quot;</span>)`}}),mt=new C({}),yt=new C({}),wt=new C({}),{c(){h=n("meta"),T=i(),b=n("h1"),J=n("a"),j=n("span"),c(U.$$.fragment),q=i(),vt=n("span"),vt.textContent=Va,Ht=i(),K=n("p"),K.innerHTML=Ea,St=i(),O=n("p"),O.innerHTML=Ya,Lt=i(),ee=n("p"),ee.innerHTML=Fa,Qt=i(),te=n("p"),te.textContent=za,Pt=i(),c(le.$$.fragment),Dt=i(),ae=n("p"),ae.textContent=Aa,qt=v(`
<hfoptions id="installation">
<hfoption id="PyTorch">

	`),c(ne.$$.fragment),Kt=v(`
</hfoption>
<hfoption id="Flax">

	`),c(se.$$.fragment),Ot=v(`
</hfoption>
</hfoptions>
`),c(N.$$.fragment),el=i(),ie=n("p"),ie.textContent=Ha,tl=i(),c(oe.$$.fragment),ll=i(),re=n("p"),re.textContent=Sa,al=i(),c(pe.$$.fragment),nl=i(),he=n("p"),he.textContent=La,sl=i(),c(de.$$.fragment),il=i(),ce=n("p"),ce.innerHTML=Qa,ol=i(),c(V.$$.fragment),rl=i(),x=n("h2"),E=n("a"),Rt=n("span"),c(me.$$.fragment),$a=i(),_t=n("span"),_t.textContent=Pa,pl=i(),c(Y.$$.fragment),hl=i(),ue=n("p"),ue.innerHTML=Da,dl=i(),fe=n("p"),fe.textContent=qa,cl=i(),c(ye.$$.fragment),ml=i(),Me=n("p"),Me.textContent=Ka,ul=i(),be=n("ul"),be.innerHTML=Oa,fl=i(),$=n("h3"),F=n("a"),kt=n("span"),c(we.$$.fragment),Ga=i(),Zt=n("span"),Zt.textContent=en,yl=i(),ge=n("p"),ge.innerHTML=tn,Ml=i(),Je=n("p"),Je.innerHTML=ln,bl=i(),c(Ue.$$.fragment),wl=i(),G=n("h3"),z=n("a"),Bt=n("span"),c(Te.$$.fragment),Wa=i(),jt=n("span"),jt.textContent=an,gl=i(),ve=n("p"),ve.textContent=nn,Jl=i(),_e=n("ul"),_e.innerHTML=sn,Ul=i(),c(Ze.$$.fragment),Tl=i(),W=n("h3"),A=n("a"),It=n("span"),c(je.$$.fragment),Xa=i(),Ct=n("span"),Ct.textContent=on,vl=i(),Ce=n("p"),Ce.textContent=rn,_l=i(),c(xe.$$.fragment),Zl=i(),X=n("h2"),H=n("a"),Nt=n("span"),c($e.$$.fragment),Ra=i(),xt=n("span"),xt.textContent=pn,jl=i(),Ge=n("p"),Ge.textContent=hn,Cl=i(),We=n("ul"),We.innerHTML=dn,xl=i(),Xe=n("p"),Xe.innerHTML=cn,$l=i(),c(Re.$$.fragment),Gl=i(),ke=n("p"),ke.innerHTML=mn,Wl=i(),c(Be.$$.fragment),Xl=i(),Ie=n("p"),Ie.innerHTML=un,Rl=i(),c(Ne.$$.fragment),kl=i(),Ve=n("p"),Ve.innerHTML=fn,Bl=i(),Ee=n("p"),Ee.innerHTML=yn,Il=i(),R=n("h2"),S=n("a"),Vt=n("span"),c(Ye.$$.fragment),ka=i(),$t=n("span"),$t.textContent=Mn,Nl=i(),Fe=n("p"),Fe.textContent=bn,Vl=i(),ze=n("p"),ze.innerHTML=wn,El=i(),c(Ae.$$.fragment),Yl=i(),He=n("p"),He.innerHTML=gn,Fl=i(),Se=n("p"),Se.textContent=Jn,zl=i(),c(Le.$$.fragment),Al=i(),Qe=n("p"),Qe.textContent=Un,Hl=v(`
<hfoptions id="gpu-select">
<hfoption id="16GB">
`),Pe=n("p"),Pe.textContent=Tn,Sl=i(),c(De.$$.fragment),Ll=i(),qe=n("p"),qe.textContent=vn,Ql=i(),c(Ke.$$.fragment),Pl=v(`
</hfoption>
<hfoption id="12GB">
`),Oe=n("p"),Oe.innerHTML=_n,Dl=i(),c(et.$$.fragment),ql=v(`
</hfoption>
<hfoption id="8GB">
`),tt=n("p"),tt.innerHTML=Zn,Kl=i(),lt=n("p"),lt.textContent=jn,Ol=i(),c(at.$$.fragment),ea=i(),nt=n("p"),nt.innerHTML=Cn,ta=i(),st=n("p"),st.innerHTML=xn,la=i(),it=n("p"),it.textContent=$n,aa=i(),ot=n("p"),ot.textContent=Gn,na=v(`
</hfoption>
</hfoptions>
<hfoptions id="training-inference">
<hfoption id="PyTorch">

	`),c(rt.$$.fragment),sa=v(`
</hfoption>
<hfoption id="Flax">

	`),c(pt.$$.fragment),ia=v(`
</hfoption>
</hfoptions>
`),ht=n("p"),ht.textContent=Wn,oa=i(),c(L.$$.fragment),ra=v(`
<hfoptions id="training-inference">
<hfoption id="PyTorch">

	`),c(dt.$$.fragment),pa=v(`
</hfoption>
<hfoption id="Flax">

	`),c(ct.$$.fragment),ha=v(`
</hfoption>
</hfoptions>
`),k=n("h2"),Q=n("a"),Et=n("span"),c(mt.$$.fragment),Ba=i(),Gt=n("span"),Gt.textContent=Xn,da=i(),ut=n("p"),ut.innerHTML=Rn,ca=i(),ft=n("p"),ft.innerHTML=kn,ma=i(),B=n("h2"),P=n("a"),Yt=n("span"),c(yt.$$.fragment),Ia=i(),Wt=n("span"),Wt.textContent=Bn,ua=i(),Mt=n("p"),Mt.innerHTML=In,fa=i(),bt=n("p"),bt.innerHTML=Nn,ya=i(),I=n("h2"),D=n("a"),Ft=n("span"),c(wt.$$.fragment),Na=i(),Xt=n("span"),Xt.textContent=Vn,Ma=i(),gt=n("p"),gt.textContent=En,ba=i(),Jt=n("ul"),Jt.innerHTML=Yn,this.h()},l(e){const t=hs("svelte-1phssyn",document.head);h=s(t,"META",{name:!0,content:!0}),t.forEach(l),T=o(e),b=s(e,"H1",{class:!0});var Ut=w(b);J=s(Ut,"A",{id:!0,class:!0,href:!0});var zt=w(J);j=s(zt,"SPAN",{});var At=w(j);m(U.$$.fragment,At),At.forEach(l),zt.forEach(l),q=o(Ut),vt=s(Ut,"SPAN",{"data-svelte-h":!0}),r(vt)!=="svelte-13nggkq"&&(vt.textContent=Va),Ut.forEach(l),Ht=o(e),K=s(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-yz6jri"&&(K.innerHTML=Ea),St=o(e),O=s(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-en2tmp"&&(O.innerHTML=Ya),Lt=o(e),ee=s(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1ol1kd9"&&(ee.innerHTML=Fa),Qt=o(e),te=s(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-l7dm2q"&&(te.textContent=za),Pt=o(e),m(le.$$.fragment,e),Dt=o(e),ae=s(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1nancx8"&&(ae.textContent=Aa),qt=_(e,`
<hfoptions id="installation">
<hfoption id="PyTorch">

	`),m(ne.$$.fragment,e),Kt=_(e,`
</hfoption>
<hfoption id="Flax">

	`),m(se.$$.fragment,e),Ot=_(e,`
</hfoption>
</hfoptions>
`),m(N.$$.fragment,e),el=o(e),ie=s(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-60q53m"&&(ie.textContent=Ha),tl=o(e),m(oe.$$.fragment,e),ll=o(e),re=s(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-di6juu"&&(re.textContent=Sa),al=o(e),m(pe.$$.fragment,e),nl=o(e),he=s(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-tsz4qp"&&(he.textContent=La),sl=o(e),m(de.$$.fragment,e),il=o(e),ce=s(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1fkfdql"&&(ce.innerHTML=Qa),ol=o(e),m(V.$$.fragment,e),rl=o(e),x=s(e,"H2",{class:!0});var Tt=w(x);E=s(Tt,"A",{id:!0,class:!0,href:!0});var Fn=w(E);Rt=s(Fn,"SPAN",{});var zn=w(Rt);m(me.$$.fragment,zn),zn.forEach(l),Fn.forEach(l),$a=o(Tt),_t=s(Tt,"SPAN",{"data-svelte-h":!0}),r(_t)!=="svelte-r00uw2"&&(_t.textContent=Pa),Tt.forEach(l),pl=o(e),m(Y.$$.fragment,e),hl=o(e),ue=s(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-gb0mrm"&&(ue.innerHTML=Da),dl=o(e),fe=s(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1aa3zni"&&(fe.textContent=qa),cl=o(e),m(ye.$$.fragment,e),ml=o(e),Me=s(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1ug35mp"&&(Me.textContent=Ka),ul=o(e),be=s(e,"UL",{"data-svelte-h":!0}),r(be)!=="svelte-pohxvr"&&(be.innerHTML=Oa),fl=o(e),$=s(e,"H3",{class:!0});var ga=w($);F=s(ga,"A",{id:!0,class:!0,href:!0});var An=w(F);kt=s(An,"SPAN",{});var Hn=w(kt);m(we.$$.fragment,Hn),Hn.forEach(l),An.forEach(l),Ga=o(ga),Zt=s(ga,"SPAN",{"data-svelte-h":!0}),r(Zt)!=="svelte-ulysw7"&&(Zt.textContent=en),ga.forEach(l),yl=o(e),ge=s(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-isitbv"&&(ge.innerHTML=tn),Ml=o(e),Je=s(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-tp3kp"&&(Je.innerHTML=ln),bl=o(e),m(Ue.$$.fragment,e),wl=o(e),G=s(e,"H3",{class:!0});var Ja=w(G);z=s(Ja,"A",{id:!0,class:!0,href:!0});var Sn=w(z);Bt=s(Sn,"SPAN",{});var Ln=w(Bt);m(Te.$$.fragment,Ln),Ln.forEach(l),Sn.forEach(l),Wa=o(Ja),jt=s(Ja,"SPAN",{"data-svelte-h":!0}),r(jt)!=="svelte-1cavofy"&&(jt.textContent=an),Ja.forEach(l),gl=o(e),ve=s(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1oc83h6"&&(ve.textContent=nn),Jl=o(e),_e=s(e,"UL",{"data-svelte-h":!0}),r(_e)!=="svelte-1e6kqrs"&&(_e.innerHTML=sn),Ul=o(e),m(Ze.$$.fragment,e),Tl=o(e),W=s(e,"H3",{class:!0});var Ua=w(W);A=s(Ua,"A",{id:!0,class:!0,href:!0});var Qn=w(A);It=s(Qn,"SPAN",{});var Pn=w(It);m(je.$$.fragment,Pn),Pn.forEach(l),Qn.forEach(l),Xa=o(Ua),Ct=s(Ua,"SPAN",{"data-svelte-h":!0}),r(Ct)!=="svelte-7a5m2a"&&(Ct.textContent=on),Ua.forEach(l),vl=o(e),Ce=s(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-n5xd96"&&(Ce.textContent=rn),_l=o(e),m(xe.$$.fragment,e),Zl=o(e),X=s(e,"H2",{class:!0});var Ta=w(X);H=s(Ta,"A",{id:!0,class:!0,href:!0});var Dn=w(H);Nt=s(Dn,"SPAN",{});var qn=w(Nt);m($e.$$.fragment,qn),qn.forEach(l),Dn.forEach(l),Ra=o(Ta),xt=s(Ta,"SPAN",{"data-svelte-h":!0}),r(xt)!=="svelte-339bde"&&(xt.textContent=pn),Ta.forEach(l),jl=o(e),Ge=s(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-76mqwg"&&(Ge.textContent=hn),Cl=o(e),We=s(e,"UL",{"data-svelte-h":!0}),r(We)!=="svelte-1sge1kf"&&(We.innerHTML=dn),xl=o(e),Xe=s(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-c9697n"&&(Xe.innerHTML=cn),$l=o(e),m(Re.$$.fragment,e),Gl=o(e),ke=s(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-e2s2vm"&&(ke.innerHTML=mn),Wl=o(e),m(Be.$$.fragment,e),Xl=o(e),Ie=s(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-s7uwdj"&&(Ie.innerHTML=un),Rl=o(e),m(Ne.$$.fragment,e),kl=o(e),Ve=s(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-4ixpqk"&&(Ve.innerHTML=fn),Bl=o(e),Ee=s(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-6gmbd2"&&(Ee.innerHTML=yn),Il=o(e),R=s(e,"H2",{class:!0});var va=w(R);S=s(va,"A",{id:!0,class:!0,href:!0});var Kn=w(S);Vt=s(Kn,"SPAN",{});var On=w(Vt);m(Ye.$$.fragment,On),On.forEach(l),Kn.forEach(l),ka=o(va),$t=s(va,"SPAN",{"data-svelte-h":!0}),r($t)!=="svelte-zp6p5k"&&($t.textContent=Mn),va.forEach(l),Nl=o(e),Fe=s(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-1fq45yi"&&(Fe.textContent=bn),Vl=o(e),ze=s(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-191fegd"&&(ze.innerHTML=wn),El=o(e),m(Ae.$$.fragment,e),Yl=o(e),He=s(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-bekdku"&&(He.innerHTML=gn),Fl=o(e),Se=s(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-196wtq5"&&(Se.textContent=Jn),zl=o(e),m(Le.$$.fragment,e),Al=o(e),Qe=s(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-7wz93i"&&(Qe.textContent=Un),Hl=_(e,`
<hfoptions id="gpu-select">
<hfoption id="16GB">
`),Pe=s(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-fd1675"&&(Pe.textContent=Tn),Sl=o(e),m(De.$$.fragment,e),Ll=o(e),qe=s(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-1rkm1uq"&&(qe.textContent=vn),Ql=o(e),m(Ke.$$.fragment,e),Pl=_(e,`
</hfoption>
<hfoption id="12GB">
`),Oe=s(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-13zq302"&&(Oe.innerHTML=_n),Dl=o(e),m(et.$$.fragment,e),ql=_(e,`
</hfoption>
<hfoption id="8GB">
`),tt=s(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-5k52bm"&&(tt.innerHTML=Zn),Kl=o(e),lt=s(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-1fx999v"&&(lt.textContent=jn),Ol=o(e),m(at.$$.fragment,e),ea=o(e),nt=s(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-wvaz2k"&&(nt.innerHTML=Cn),ta=o(e),st=s(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-14m6rf5"&&(st.innerHTML=xn),la=o(e),it=s(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-z8cdsf"&&(it.textContent=$n),aa=o(e),ot=s(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-lwtx0u"&&(ot.textContent=Gn),na=_(e,`
</hfoption>
</hfoptions>
<hfoptions id="training-inference">
<hfoption id="PyTorch">

	`),m(rt.$$.fragment,e),sa=_(e,`
</hfoption>
<hfoption id="Flax">

	`),m(pt.$$.fragment,e),ia=_(e,`
</hfoption>
</hfoptions>
`),ht=s(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-1x6in5t"&&(ht.textContent=Wn),oa=o(e),m(L.$$.fragment,e),ra=_(e,`
<hfoptions id="training-inference">
<hfoption id="PyTorch">

	`),m(dt.$$.fragment,e),pa=_(e,`
</hfoption>
<hfoption id="Flax">

	`),m(ct.$$.fragment,e),ha=_(e,`
</hfoption>
</hfoptions>
`),k=s(e,"H2",{class:!0});var _a=w(k);Q=s(_a,"A",{id:!0,class:!0,href:!0});var es=w(Q);Et=s(es,"SPAN",{});var ts=w(Et);m(mt.$$.fragment,ts),ts.forEach(l),es.forEach(l),Ba=o(_a),Gt=s(_a,"SPAN",{"data-svelte-h":!0}),r(Gt)!=="svelte-erj1xh"&&(Gt.textContent=Xn),_a.forEach(l),da=o(e),ut=s(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-1bstso5"&&(ut.innerHTML=Rn),ca=o(e),ft=s(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-1sxi0tl"&&(ft.innerHTML=kn),ma=o(e),B=s(e,"H2",{class:!0});var Za=w(B);P=s(Za,"A",{id:!0,class:!0,href:!0});var ls=w(P);Yt=s(ls,"SPAN",{});var as=w(Yt);m(yt.$$.fragment,as),as.forEach(l),ls.forEach(l),Ia=o(Za),Wt=s(Za,"SPAN",{"data-svelte-h":!0}),r(Wt)!=="svelte-1g3g87b"&&(Wt.textContent=Bn),Za.forEach(l),ua=o(e),Mt=s(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-1stipnz"&&(Mt.innerHTML=In),fa=o(e),bt=s(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-6dxtva"&&(bt.innerHTML=Nn),ya=o(e),I=s(e,"H2",{class:!0});var ja=w(I);D=s(ja,"A",{id:!0,class:!0,href:!0});var ns=w(D);Ft=s(ns,"SPAN",{});var ss=w(Ft);m(wt.$$.fragment,ss),ss.forEach(l),ns.forEach(l),Na=o(ja),Xt=s(ja,"SPAN",{"data-svelte-h":!0}),r(Xt)!=="svelte-pr7lub"&&(Xt.textContent=Vn),ja.forEach(l),Ma=o(e),gt=s(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-1lopwzr"&&(gt.textContent=En),ba=o(e),Jt=s(e,"UL",{"data-svelte-h":!0}),r(Jt)!=="svelte-nczfxk"&&(Jt.innerHTML=Yn),this.h()},h(){p(h,"name","hf:doc:metadata"),p(h,"content",JSON.stringify(ys)),p(J,"id","dreambooth"),p(J,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(J,"href","#dreambooth"),p(b,"class","relative group"),p(E,"id","script-parameters"),p(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(E,"href","#script-parameters"),p(x,"class","relative group"),p(F,"id","minsnr-weighting"),p(F,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(F,"href","#minsnr-weighting"),p($,"class","relative group"),p(z,"id","prior-preservation-loss"),p(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(z,"href","#prior-preservation-loss"),p(G,"class","relative group"),p(A,"id","train-text-encoder"),p(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(A,"href","#train-text-encoder"),p(W,"class","relative group"),p(H,"id","training-script"),p(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(H,"href","#training-script"),p(X,"class","relative group"),p(S,"id","launch-the-script"),p(S,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(S,"href","#launch-the-script"),p(R,"class","relative group"),p(Q,"id","lora"),p(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Q,"href","#lora"),p(k,"class","relative group"),p(P,"id","stable-diffusion-xl"),p(P,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(P,"href","#stable-diffusion-xl"),p(B,"class","relative group"),p(D,"id","next-steps"),p(D,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(D,"href","#next-steps"),p(I,"class","relative group")},m(e,t){d(document.head,h),a(e,T,t),a(e,b,t),d(b,J),d(J,j),u(U,j,null),d(b,q),d(b,vt),a(e,Ht,t),a(e,K,t),a(e,St,t),a(e,O,t),a(e,Lt,t),a(e,ee,t),a(e,Qt,t),a(e,te,t),a(e,Pt,t),u(le,e,t),a(e,Dt,t),a(e,ae,t),a(e,qt,t),u(ne,e,t),a(e,Kt,t),u(se,e,t),a(e,Ot,t),u(N,e,t),a(e,el,t),a(e,ie,t),a(e,tl,t),u(oe,e,t),a(e,ll,t),a(e,re,t),a(e,al,t),u(pe,e,t),a(e,nl,t),a(e,he,t),a(e,sl,t),u(de,e,t),a(e,il,t),a(e,ce,t),a(e,ol,t),u(V,e,t),a(e,rl,t),a(e,x,t),d(x,E),d(E,Rt),u(me,Rt,null),d(x,$a),d(x,_t),a(e,pl,t),u(Y,e,t),a(e,hl,t),a(e,ue,t),a(e,dl,t),a(e,fe,t),a(e,cl,t),u(ye,e,t),a(e,ml,t),a(e,Me,t),a(e,ul,t),a(e,be,t),a(e,fl,t),a(e,$,t),d($,F),d(F,kt),u(we,kt,null),d($,Ga),d($,Zt),a(e,yl,t),a(e,ge,t),a(e,Ml,t),a(e,Je,t),a(e,bl,t),u(Ue,e,t),a(e,wl,t),a(e,G,t),d(G,z),d(z,Bt),u(Te,Bt,null),d(G,Wa),d(G,jt),a(e,gl,t),a(e,ve,t),a(e,Jl,t),a(e,_e,t),a(e,Ul,t),u(Ze,e,t),a(e,Tl,t),a(e,W,t),d(W,A),d(A,It),u(je,It,null),d(W,Xa),d(W,Ct),a(e,vl,t),a(e,Ce,t),a(e,_l,t),u(xe,e,t),a(e,Zl,t),a(e,X,t),d(X,H),d(H,Nt),u($e,Nt,null),d(X,Ra),d(X,xt),a(e,jl,t),a(e,Ge,t),a(e,Cl,t),a(e,We,t),a(e,xl,t),a(e,Xe,t),a(e,$l,t),u(Re,e,t),a(e,Gl,t),a(e,ke,t),a(e,Wl,t),u(Be,e,t),a(e,Xl,t),a(e,Ie,t),a(e,Rl,t),u(Ne,e,t),a(e,kl,t),a(e,Ve,t),a(e,Bl,t),a(e,Ee,t),a(e,Il,t),a(e,R,t),d(R,S),d(S,Vt),u(Ye,Vt,null),d(R,ka),d(R,$t),a(e,Nl,t),a(e,Fe,t),a(e,Vl,t),a(e,ze,t),a(e,El,t),u(Ae,e,t),a(e,Yl,t),a(e,He,t),a(e,Fl,t),a(e,Se,t),a(e,zl,t),u(Le,e,t),a(e,Al,t),a(e,Qe,t),a(e,Hl,t),a(e,Pe,t),a(e,Sl,t),u(De,e,t),a(e,Ll,t),a(e,qe,t),a(e,Ql,t),u(Ke,e,t),a(e,Pl,t),a(e,Oe,t),a(e,Dl,t),u(et,e,t),a(e,ql,t),a(e,tt,t),a(e,Kl,t),a(e,lt,t),a(e,Ol,t),u(at,e,t),a(e,ea,t),a(e,nt,t),a(e,ta,t),a(e,st,t),a(e,la,t),a(e,it,t),a(e,aa,t),a(e,ot,t),a(e,na,t),u(rt,e,t),a(e,sa,t),u(pt,e,t),a(e,ia,t),a(e,ht,t),a(e,oa,t),u(L,e,t),a(e,ra,t),u(dt,e,t),a(e,pa,t),u(ct,e,t),a(e,ha,t),a(e,k,t),d(k,Q),d(Q,Et),u(mt,Et,null),d(k,Ba),d(k,Gt),a(e,da,t),a(e,ut,t),a(e,ca,t),a(e,ft,t),a(e,ma,t),a(e,B,t),d(B,P),d(P,Yt),u(yt,Yt,null),d(B,Ia),d(B,Wt),a(e,ua,t),a(e,Mt,t),a(e,fa,t),a(e,bt,t),a(e,ya,t),a(e,I,t),d(I,D),d(D,Ft),u(wt,Ft,null),d(I,Na),d(I,Xt),a(e,Ma,t),a(e,gt,t),a(e,ba,t),a(e,Jt,t),wa=!0},p(e,[t]){const Ut={};t&2&&(Ut.$$scope={dirty:t,ctx:e}),N.$set(Ut);const zt={};t&2&&(zt.$$scope={dirty:t,ctx:e}),V.$set(zt);const At={};t&2&&(At.$$scope={dirty:t,ctx:e}),Y.$set(At);const Tt={};t&2&&(Tt.$$scope={dirty:t,ctx:e}),L.$set(Tt)},i(e){wa||(f(U.$$.fragment,e),f(le.$$.fragment,e),f(ne.$$.fragment,e),f(se.$$.fragment,e),f(N.$$.fragment,e),f(oe.$$.fragment,e),f(pe.$$.fragment,e),f(de.$$.fragment,e),f(V.$$.fragment,e),f(me.$$.fragment,e),f(Y.$$.fragment,e),f(ye.$$.fragment,e),f(we.$$.fragment,e),f(Ue.$$.fragment,e),f(Te.$$.fragment,e),f(Ze.$$.fragment,e),f(je.$$.fragment,e),f(xe.$$.fragment,e),f($e.$$.fragment,e),f(Re.$$.fragment,e),f(Be.$$.fragment,e),f(Ne.$$.fragment,e),f(Ye.$$.fragment,e),f(Ae.$$.fragment,e),f(Le.$$.fragment,e),f(De.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(at.$$.fragment,e),f(rt.$$.fragment,e),f(pt.$$.fragment,e),f(L.$$.fragment,e),f(dt.$$.fragment,e),f(ct.$$.fragment,e),f(mt.$$.fragment,e),f(yt.$$.fragment,e),f(wt.$$.fragment,e),wa=!0)},o(e){y(U.$$.fragment,e),y(le.$$.fragment,e),y(ne.$$.fragment,e),y(se.$$.fragment,e),y(N.$$.fragment,e),y(oe.$$.fragment,e),y(pe.$$.fragment,e),y(de.$$.fragment,e),y(V.$$.fragment,e),y(me.$$.fragment,e),y(Y.$$.fragment,e),y(ye.$$.fragment,e),y(we.$$.fragment,e),y(Ue.$$.fragment,e),y(Te.$$.fragment,e),y(Ze.$$.fragment,e),y(je.$$.fragment,e),y(xe.$$.fragment,e),y($e.$$.fragment,e),y(Re.$$.fragment,e),y(Be.$$.fragment,e),y(Ne.$$.fragment,e),y(Ye.$$.fragment,e),y(Ae.$$.fragment,e),y(Le.$$.fragment,e),y(De.$$.fragment,e),y(Ke.$$.fragment,e),y(et.$$.fragment,e),y(at.$$.fragment,e),y(rt.$$.fragment,e),y(pt.$$.fragment,e),y(L.$$.fragment,e),y(dt.$$.fragment,e),y(ct.$$.fragment,e),y(mt.$$.fragment,e),y(yt.$$.fragment,e),y(wt.$$.fragment,e),wa=!1},d(e){e&&(l(T),l(b),l(Ht),l(K),l(St),l(O),l(Lt),l(ee),l(Qt),l(te),l(Pt),l(Dt),l(ae),l(qt),l(Kt),l(Ot),l(el),l(ie),l(tl),l(ll),l(re),l(al),l(nl),l(he),l(sl),l(il),l(ce),l(ol),l(rl),l(x),l(pl),l(hl),l(ue),l(dl),l(fe),l(cl),l(ml),l(Me),l(ul),l(be),l(fl),l($),l(yl),l(ge),l(Ml),l(Je),l(bl),l(wl),l(G),l(gl),l(ve),l(Jl),l(_e),l(Ul),l(Tl),l(W),l(vl),l(Ce),l(_l),l(Zl),l(X),l(jl),l(Ge),l(Cl),l(We),l(xl),l(Xe),l($l),l(Gl),l(ke),l(Wl),l(Xl),l(Ie),l(Rl),l(kl),l(Ve),l(Bl),l(Ee),l(Il),l(R),l(Nl),l(Fe),l(Vl),l(ze),l(El),l(Yl),l(He),l(Fl),l(Se),l(zl),l(Al),l(Qe),l(Hl),l(Pe),l(Sl),l(Ll),l(qe),l(Ql),l(Pl),l(Oe),l(Dl),l(ql),l(tt),l(Kl),l(lt),l(Ol),l(ea),l(nt),l(ta),l(st),l(la),l(it),l(aa),l(ot),l(na),l(sa),l(ia),l(ht),l(oa),l(ra),l(pa),l(ha),l(k),l(da),l(ut),l(ca),l(ft),l(ma),l(B),l(ua),l(Mt),l(fa),l(bt),l(ya),l(I),l(Ma),l(gt),l(ba),l(Jt)),l(h),M(U),M(le,e),M(ne,e),M(se,e),M(N,e),M(oe,e),M(pe,e),M(de,e),M(V,e),M(me),M(Y,e),M(ye,e),M(we),M(Ue,e),M(Te),M(Ze,e),M(je),M(xe,e),M($e),M(Re,e),M(Be,e),M(Ne,e),M(Ye),M(Ae,e),M(Le,e),M(De,e),M(Ke,e),M(et,e),M(at,e),M(rt,e),M(pt,e),M(L,e),M(dt,e),M(ct,e),M(mt),M(yt),M(wt)}}}const ys={local:"dreambooth",sections:[{local:"script-parameters",sections:[{local:"minsnr-weighting",title:"Min-SNR weighting"},{local:"prior-preservation-loss",title:"Prior preservation loss"},{local:"train-text-encoder",title:"Train text encoder"}],title:"Script parameters"},{local:"training-script",title:"Training script"},{local:"launch-the-script",title:"Launch the script"},{local:"lora",title:"LoRA"},{local:"stable-diffusion-xl",title:"Stable Diffusion XL"},{local:"next-steps",title:"Next steps"}],title:"DreamBooth"};function Ms(Z){return os(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ts extends rs{constructor(h){super(),ps(this,h,Ms,fs,is,{})}}export{Ts as component};
