import{s as Sl,o as Pl,n as Al}from"../chunks/scheduler.182ea377.js";import{S as Zl,i as Bl,g as n,s,p as c,A as Xl,h as i,f as t,c as a,j as d,q as f,m as h,k as r,v as p,a as l,r as u,d as m,t as v,u as y}from"../chunks/index.008d68e4.js";import{T as Wl}from"../chunks/Tip.4f096367.js";import{I as M}from"../chunks/IconCopyLink.96bbb92b.js";import{C as Y}from"../chunks/CodeBlock.5ed6eb7b.js";function Hl(rt){let w,R='You can also run the <code>diffusers</code> Python codebase on Apple Silicon Macs using the <code>mps</code> accelerator built into PyTorch. This approach is explained in depth in <a href="mps">the mps guide</a>, but it is not compatible with native apps.';return{c(){w=n("p"),w.innerHTML=R},l(b){w=i(b,"P",{"data-svelte-h":!0}),h(w)!=="svelte-1gipn5x"&&(w.innerHTML=R)},m(b,g){l(b,w,g)},p:Al,d(b){b&&t(w)}}}function Il(rt){let w,R,b,g,De,F,mo,We,ko="How to run Stable Diffusion with Core ML",pt,E,_o='<a href="https://developer.apple.com/documentation/coreml" rel="nofollow">Core ML</a> is the model format and machine learning library supported by Apple frameworks. If you are interested in running Stable Diffusion models inside your macOS or iOS/iPadOS apps, this guide will show you how to convert existing PyTorch checkpoints into the Core ML format and use them for inference with Python or Swift.',ht,q,xo="Core ML models can leverage all the compute engines available in Apple devices: the CPU, the GPU, and the Apple Neural Engine (or ANE, a tensor-optimized accelerator available in Apple Silicon Macs and modern iPhones/iPads). Depending on the model and the device it’s running on, Core ML can mix and match compute engines too, so some portions of the model may run on the CPU while others run on GPU, for example.",dt,N,ct,C,G,Oe,V,vo,He,Jo="Stable Diffusion Core ML Checkpoints",ft,Q,jo="Stable Diffusion weights (or checkpoints) are stored in the PyTorch format, so you need to convert them to the Core ML format before we can use them inside native apps.",ut,z,Lo='Thankfully, Apple engineers developed <a href="https://github.com/apple/ml-stable-diffusion#-converting-models-to-core-ml" rel="nofollow">a conversion tool</a> based on <code>diffusers</code> to convert the PyTorch checkpoints to Core ML.',mt,D,No="Before you convert a model, though, take a moment to explore the Hugging Face Hub – chances are the model you’re interested in is already available in Core ML format:",vt,O,Go='<li>the <a href="https://huggingface.co/apple" rel="nofollow">Apple</a> organization includes Stable Diffusion versions 1.4, 1.5, 2.0 base, and 2.1 base</li> <li><a href="https://huggingface.co/coreml-community" rel="nofollow">coreml community</a> includes custom finetuned models</li> <li>use this <a href="https://huggingface.co/models?pipeline_tag=text-to-image&amp;library=coreml&amp;p=2&amp;sort=likes" rel="nofollow">filter</a> to return all available Core ML checkpoints</li>',yt,K,So='If you can’t find the model you’re interested in, we recommend you follow the instructions for <a href="https://github.com/apple/ml-stable-diffusion#-converting-models-to-core-ml" rel="nofollow">Converting Models to Core ML</a> by Apple.',wt,U,S,Ke,ee,yo,Ie,Po="Selecting the Core ML Variant to Use",bt,te,Ao="Stable Diffusion models can be converted to different Core ML variants intended for different purposes:",Mt,oe,Zo='<li><p>The type of attention blocks used. The attention operation is used to “pay attention” to the relationship between different areas in the image representations and to understand how the image and text representations are related. Attention is compute- and memory-intensive, so different implementations exist that consider the hardware characteristics of different devices. For Core ML Stable Diffusion models, there are two attention variants:</p> <ul><li><code>split_einsum</code> (<a href="https://machinelearning.apple.com/research/neural-engine-transformers" rel="nofollow">introduced by Apple</a>) is optimized for ANE devices, which is available in modern iPhones, iPads and M-series computers.</li> <li>The “original” attention (the base implementation used in <code>diffusers</code>) is only compatible with CPU/GPU and not ANE. It can be <em>faster</em> to run your model on CPU + GPU using <code>original</code> attention than ANE. See <a href="https://huggingface.co/blog/fast-mac-diffusers#performance-benchmarks" rel="nofollow">this performance benchmark</a> as well as some <a href="https://github.com/huggingface/swift-coreml-diffusers/issues/31" rel="nofollow">additional measures provided by the community</a> for additional details.</li></ul></li> <li><p>The supported inference framework.</p> <ul><li><code>packages</code> are suitable for Python inference. This can be used to test converted Core ML models before attempting to integrate them inside native apps, or if you want to explore Core ML performance but don’t need to support native apps. For example, an application with a web UI could perfectly use a Python Core ML backend.</li> <li><code>compiled</code> models are required for Swift code. The <code>compiled</code> models in the Hub split the large UNet model weights into several files for compatibility with iOS and iPadOS devices. This corresponds to the <a href="https://github.com/apple/ml-stable-diffusion#-converting-models-to-core-ml" rel="nofollow"><code>--chunk-unet</code> conversion option</a>. If you want to support native apps, then you need to select the <code>compiled</code> variant.</li></ul></li>',gt,le,Bo='The official Core ML Stable Diffusion <a href="https://huggingface.co/apple/coreml-stable-diffusion-v1-4/tree/main" rel="nofollow">models</a> include these variants, but the community ones may vary:',Ct,ne,Ut,ie,Xo="You can download and use the variant you need as shown below.",Tt,T,P,et,se,wo,Ye,Wo="Core ML Inference in Python",$t,ae,Ho="Install the following libraries to run Core ML inference in Python:",kt,re,_t,$,A,tt,pe,bo,Re,Io="Download the Model Checkpoints",xt,he,Yo="To run inference in Python, use one of the versions stored in the <code>packages</code> folders because the <code>compiled</code> ones are only compatible with Swift. You may choose whether you want to use <code>original</code> or <code>split_einsum</code> attention.",Jt,de,Ro="This is how you’d download the <code>original</code> attention variant from the Hub to a directory called <code>models</code>:",jt,ce,Lt,k,Z,ot,fe,Mo,Fe,Fo="Inference",Nt,ue,Eo="Once you have downloaded a snapshot of the model, you can test it using Apple’s Python script.",Gt,me,St,ve,qo="Pass the path of the downloaded checkpoint with <code>-i</code> flag to the script. <code>--compute-unit</code> indicates the hardware you want to allow for inference. It must be one of the following options: <code>ALL</code>, <code>CPU_AND_GPU</code>, <code>CPU_ONLY</code>, <code>CPU_AND_NE</code>. You may also provide an optional output path, and a seed for reproducibility.",Pt,ye,Vo="The inference script assumes you’re using the original version of the Stable Diffusion model, <code>CompVis/stable-diffusion-v1-4</code>. If you use another model, you <em>have</em> to specify its Hub id in the inference command line, using the <code>--model-version</code> option. This works for models already supported and custom models you trained or fine-tuned yourself.",At,we,Qo='For example, if you want to use <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a>:',Zt,be,Bt,_,B,lt,Me,go,Ee,zo="Core ML inference in Swift",Xt,ge,Do="Running inference in Swift is slightly faster than in Python because the models are already compiled in the <code>mlmodelc</code> format. This is noticeable on app startup when the model is loaded but shouldn’t be noticeable if you run several generations afterward.",Wt,x,X,nt,Ce,Co,qe,Oo="Download",Ht,Ue,Ko="To run inference in Swift on your Mac, you need one of the <code>compiled</code> checkpoint versions. We recommend you download them locally using Python code similar to the previous example, but with one of the <code>compiled</code> variants:",It,Te,Yt,J,W,it,$e,Uo,Ve,el="Inference",Rt,ke,tl="To run inference, please clone Apple’s repo:",Ft,_e,Et,xe,ol='And then use Apple’s command line tool, <a href="https://www.swift.org/package-manager/#" rel="nofollow">Swift Package Manager</a>:',qt,Je,Vt,je,ll="You have to specify in <code>--resource-path</code> one of the checkpoints downloaded in the previous step, so please make sure it contains compiled Core ML bundles with the extension <code>.mlmodelc</code>. The <code>--compute-units</code> has to be one of these values: <code>all</code>, <code>cpuOnly</code>, <code>cpuAndGPU</code>, <code>cpuAndNeuralEngine</code>.",Qt,Le,nl='For more details, please refer to the <a href="https://github.com/apple/ml-stable-diffusion" rel="nofollow">instructions in Apple’s repo</a>.',zt,j,H,st,Ne,To,Qe,il="Supported Diffusers Features",Dt,Ge,sl="The Core ML models and inference code don’t support many of the features, options, and flexibility of 🧨 Diffusers. These are some of the limitations to keep in mind:",Ot,Se,al="<li>Core ML models are only suitable for inference. They can’t be used for training or fine-tuning.</li> <li>Only two schedulers have been ported to Swift, the default one used by Stable Diffusion and <code>DPMSolverMultistepScheduler</code>, which we ported to Swift from our <code>diffusers</code> implementation. We recommend you use <code>DPMSolverMultistepScheduler</code>, since it produces the same quality in about half the steps.</li> <li>Negative prompts, classifier-free guidance scale, and image-to-image tasks are available in the inference code. Advanced features such as depth guidance, ControlNet, and latent upscalers are not available yet.</li>",Kt,Pe,rl='Apple’s <a href="https://github.com/apple/ml-stable-diffusion" rel="nofollow">conversion and inference repo</a> and our own <a href="https://github.com/huggingface/swift-coreml-diffusers" rel="nofollow">swift-coreml-diffusers</a> repos are intended as technology demonstrators to enable other developers to build upon.',eo,Ae,pl="If you feel strongly about any missing features, please feel free to open a feature request or, better yet, a contribution PR 🙂.",to,L,I,at,Ze,$o,ze,hl="Native Diffusers Swift app",oo,Be,dl='One easy way to run Stable Diffusion on your own Apple hardware is to use <a href="https://github.com/huggingface/swift-coreml-diffusers" rel="nofollow">our open-source Swift repo</a>, based on <code>diffusers</code> and Apple’s conversion and inference repo. You can study the code, compile it with <a href="https://developer.apple.com/xcode/" rel="nofollow">Xcode</a> and adapt it for your own needs. For your convenience, there’s also a <a href="https://apps.apple.com/app/diffusers/id1666309574" rel="nofollow">standalone Mac app in the App Store</a>, so you can play with it without having to deal with the code or IDE. If you are a developer and have determined that Core ML is the best solution to build your Stable Diffusion app, then you can use the rest of this guide to get started with your project. We can’t wait to see what you’ll build 🙂.',lo;return F=new M({}),N=new Wl({props:{$$slots:{default:[Hl]},$$scope:{ctx:rt}}}),V=new M({}),ee=new M({}),ne=new Y({props:{code:"Y29yZW1sLXN0YWJsZS1kaWZmdXNpb24tdjEtNCUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMFJFQURNRS5tZCUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMG9yaWdpbmFsJTBBJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29tcGlsZWQlMEElRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBwYWNrYWdlcyUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHNwbGl0X2VpbnN1bSUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGNvbXBpbGVkJTBBJTIwJTIwJTIwJTIwJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwcGFja2FnZXM=",highlighted:`coreml-stable-<span class="hljs-keyword">diffusion-v1-4
</span>├── README.md
├── <span class="hljs-keyword">original
</span>│   ├── compiled
│   └── packages
└── split_einsum
    ├── compiled
    └── packages`}}),se=new M({}),re=new Y({props:{code:"cGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlX2h1YiUwQXBpcCUyMGluc3RhbGwlMjBnaXQlMkJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZhcHBsZSUyRm1sLXN0YWJsZS1kaWZmdXNpb24=",highlighted:`pip install huggingface_hub
pip install git+https://github.com/apple/ml-stable-diffusion`}}),pe=new M({}),ce=new Y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMmFwcGxlJTJGY29yZW1sLXN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUwQXZhcmlhbnQlMjAlM0QlMjAlMjJvcmlnaW5hbCUyRnBhY2thZ2VzJTIyJTBBJTBBbW9kZWxfcGF0aCUyMCUzRCUyMFBhdGgoJTIyLiUyRm1vZGVscyUyMiklMjAlMkYlMjAocmVwb19pZC5zcGxpdCglMjIlMkYlMjIpJTVCLTElNUQlMjAlMkIlMjAlMjJfJTIyJTIwJTJCJTIwdmFyaWFudC5yZXBsYWNlKCUyMiUyRiUyMiUyQyUyMCUyMl8lMjIpKSUwQXNuYXBzaG90X2Rvd25sb2FkKHJlcG9faWQlMkMlMjBhbGxvd19wYXR0ZXJucyUzRGYlMjIlN0J2YXJpYW50JTdEJTJGKiUyMiUyQyUyMGxvY2FsX2RpciUzRG1vZGVsX3BhdGglMkMlMjBsb2NhbF9kaXJfdXNlX3N5bWxpbmtzJTNERmFsc2UpJTBBcHJpbnQoZiUyMk1vZGVsJTIwZG93bmxvYWRlZCUyMGF0JTIwJTdCbW9kZWxfcGF0aCU3RCUyMik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path

repo_id = <span class="hljs-string">&quot;apple/coreml-stable-diffusion-v1-4&quot;</span>
variant = <span class="hljs-string">&quot;original/packages&quot;</span>

model_path = Path(<span class="hljs-string">&quot;./models&quot;</span>) / (repo_id.split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">1</span>] + <span class="hljs-string">&quot;_&quot;</span> + variant.replace(<span class="hljs-string">&quot;/&quot;</span>, <span class="hljs-string">&quot;_&quot;</span>))
snapshot_download(repo_id, allow_patterns=<span class="hljs-string">f&quot;<span class="hljs-subst">{variant}</span>/*&quot;</span>, local_dir=model_path, local_dir_use_symlinks=<span class="hljs-literal">False</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Model downloaded at <span class="hljs-subst">{model_path}</span>&quot;</span>)`}}),fe=new M({}),me=new Y({props:{code:"cHl0aG9uJTIwLW0lMjBweXRob25fY29yZW1sX3N0YWJsZV9kaWZmdXNpb24ucGlwZWxpbmUlMjAtLXByb21wdCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMjAtaSUyMG1vZGVscyUyRmNvcmVtbC1zdGFibGUtZGlmZnVzaW9uLXYxLTRfb3JpZ2luYWxfcGFja2FnZXMlMjAtbyUyMCUzQyUyRnBhdGglMkZ0byUyRm91dHB1dCUyRmltYWdlJTNFJTIwLS1jb21wdXRlLXVuaXQlMjBDUFVfQU5EX0dQVSUyMC0tc2VlZCUyMDkz",highlighted:"python -m python_coreml_stable_diffusion.pipeline --prompt &quot;a photo of an astronaut riding a horse on mars&quot; -i models/coreml-stable-diffusion-v1-4_original_packages -o &lt;/path/to/output/image&gt; --compute-unit CPU_AND_GPU --seed 93"}}),be=new Y({props:{code:"cHl0aG9uJTIwLW0lMjBweXRob25fY29yZW1sX3N0YWJsZV9kaWZmdXNpb24ucGlwZWxpbmUlMjAtLXByb21wdCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMjAtLWNvbXB1dGUtdW5pdCUyMEFMTCUyMC1vJTIwb3V0cHV0JTIwLS1zZWVkJTIwOTMlMjAtaSUyMG1vZGVscyUyRmNvcmVtbC1zdGFibGUtZGlmZnVzaW9uLXYxLTVfb3JpZ2luYWxfcGFja2FnZXMlMjAtLW1vZGVsLXZlcnNpb24lMjBydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNQ==",highlighted:"python -m python_coreml_stable_diffusion.pipeline --prompt &quot;a photo of an astronaut riding a horse on mars&quot; --compute-unit ALL -o output --seed 93 -i models/coreml-stable-diffusion-v1-5_original_packages --model-version runwayml/stable-diffusion-v1-5"}}),Me=new M({}),Ce=new M({}),Te=new Y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMmFwcGxlJTJGY29yZW1sLXN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUwQXZhcmlhbnQlMjAlM0QlMjAlMjJvcmlnaW5hbCUyRmNvbXBpbGVkJTIyJTBBJTBBbW9kZWxfcGF0aCUyMCUzRCUyMFBhdGgoJTIyLiUyRm1vZGVscyUyMiklMjAlMkYlMjAocmVwb19pZC5zcGxpdCglMjIlMkYlMjIpJTVCLTElNUQlMjAlMkIlMjAlMjJfJTIyJTIwJTJCJTIwdmFyaWFudC5yZXBsYWNlKCUyMiUyRiUyMiUyQyUyMCUyMl8lMjIpKSUwQXNuYXBzaG90X2Rvd25sb2FkKHJlcG9faWQlMkMlMjBhbGxvd19wYXR0ZXJucyUzRGYlMjIlN0J2YXJpYW50JTdEJTJGKiUyMiUyQyUyMGxvY2FsX2RpciUzRG1vZGVsX3BhdGglMkMlMjBsb2NhbF9kaXJfdXNlX3N5bWxpbmtzJTNERmFsc2UpJTBBcHJpbnQoZiUyMk1vZGVsJTIwZG93bmxvYWRlZCUyMGF0JTIwJTdCbW9kZWxfcGF0aCU3RCUyMik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path

repo_id = <span class="hljs-string">&quot;apple/coreml-stable-diffusion-v1-4&quot;</span>
variant = <span class="hljs-string">&quot;original/compiled&quot;</span>

model_path = Path(<span class="hljs-string">&quot;./models&quot;</span>) / (repo_id.split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">1</span>] + <span class="hljs-string">&quot;_&quot;</span> + variant.replace(<span class="hljs-string">&quot;/&quot;</span>, <span class="hljs-string">&quot;_&quot;</span>))
snapshot_download(repo_id, allow_patterns=<span class="hljs-string">f&quot;<span class="hljs-subst">{variant}</span>/*&quot;</span>, local_dir=model_path, local_dir_use_symlinks=<span class="hljs-literal">False</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Model downloaded at <span class="hljs-subst">{model_path}</span>&quot;</span>)`}}),$e=new M({}),_e=new Y({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZhcHBsZSUyRm1sLXN0YWJsZS1kaWZmdXNpb24lMEFjZCUyMG1sLXN0YWJsZS1kaWZmdXNpb24=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/apple/ml-stable-diffusion
<span class="hljs-built_in">cd</span> ml-stable-diffusion`}}),Je=new Y({props:{code:"c3dpZnQlMjBydW4lMjBTdGFibGVEaWZmdXNpb25TYW1wbGUlMjAtLXJlc291cmNlLXBhdGglMjBtb2RlbHMlMkZjb3JlbWwtc3RhYmxlLWRpZmZ1c2lvbi12MS00X29yaWdpbmFsX2NvbXBpbGVkJTIwLS1jb21wdXRlLXVuaXRzJTIwYWxsJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMg==",highlighted:'swift run StableDiffusionSample --resource-path models/coreml-stable-diffusion-v1-4_original_compiled --compute-units all <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>'}}),Ne=new M({}),Ze=new M({}),{c(){w=n("meta"),R=s(),b=n("h1"),g=n("a"),De=n("span"),c(F.$$.fragment),mo=s(),We=n("span"),We.textContent=ko,pt=s(),E=n("p"),E.innerHTML=_o,ht=s(),q=n("p"),q.textContent=xo,dt=s(),c(N.$$.fragment),ct=s(),C=n("h2"),G=n("a"),Oe=n("span"),c(V.$$.fragment),vo=s(),He=n("span"),He.textContent=Jo,ft=s(),Q=n("p"),Q.textContent=jo,ut=s(),z=n("p"),z.innerHTML=Lo,mt=s(),D=n("p"),D.textContent=No,vt=s(),O=n("ul"),O.innerHTML=Go,yt=s(),K=n("p"),K.innerHTML=So,wt=s(),U=n("h2"),S=n("a"),Ke=n("span"),c(ee.$$.fragment),yo=s(),Ie=n("span"),Ie.textContent=Po,bt=s(),te=n("p"),te.textContent=Ao,Mt=s(),oe=n("ul"),oe.innerHTML=Zo,gt=s(),le=n("p"),le.innerHTML=Bo,Ct=s(),c(ne.$$.fragment),Ut=s(),ie=n("p"),ie.textContent=Xo,Tt=s(),T=n("h2"),P=n("a"),et=n("span"),c(se.$$.fragment),wo=s(),Ye=n("span"),Ye.textContent=Wo,$t=s(),ae=n("p"),ae.textContent=Ho,kt=s(),c(re.$$.fragment),_t=s(),$=n("h3"),A=n("a"),tt=n("span"),c(pe.$$.fragment),bo=s(),Re=n("span"),Re.textContent=Io,xt=s(),he=n("p"),he.innerHTML=Yo,Jt=s(),de=n("p"),de.innerHTML=Ro,jt=s(),c(ce.$$.fragment),Lt=s(),k=n("h3"),Z=n("a"),ot=n("span"),c(fe.$$.fragment),Mo=s(),Fe=n("span"),Fe.textContent=Fo,Nt=s(),ue=n("p"),ue.textContent=Eo,Gt=s(),c(me.$$.fragment),St=s(),ve=n("p"),ve.innerHTML=qo,Pt=s(),ye=n("p"),ye.innerHTML=Vo,At=s(),we=n("p"),we.innerHTML=Qo,Zt=s(),c(be.$$.fragment),Bt=s(),_=n("h2"),B=n("a"),lt=n("span"),c(Me.$$.fragment),go=s(),Ee=n("span"),Ee.textContent=zo,Xt=s(),ge=n("p"),ge.innerHTML=Do,Wt=s(),x=n("h3"),X=n("a"),nt=n("span"),c(Ce.$$.fragment),Co=s(),qe=n("span"),qe.textContent=Oo,Ht=s(),Ue=n("p"),Ue.innerHTML=Ko,It=s(),c(Te.$$.fragment),Yt=s(),J=n("h3"),W=n("a"),it=n("span"),c($e.$$.fragment),Uo=s(),Ve=n("span"),Ve.textContent=el,Rt=s(),ke=n("p"),ke.textContent=tl,Ft=s(),c(_e.$$.fragment),Et=s(),xe=n("p"),xe.innerHTML=ol,qt=s(),c(Je.$$.fragment),Vt=s(),je=n("p"),je.innerHTML=ll,Qt=s(),Le=n("p"),Le.innerHTML=nl,zt=s(),j=n("h2"),H=n("a"),st=n("span"),c(Ne.$$.fragment),To=s(),Qe=n("span"),Qe.textContent=il,Dt=s(),Ge=n("p"),Ge.textContent=sl,Ot=s(),Se=n("ul"),Se.innerHTML=al,Kt=s(),Pe=n("p"),Pe.innerHTML=rl,eo=s(),Ae=n("p"),Ae.textContent=pl,to=s(),L=n("h2"),I=n("a"),at=n("span"),c(Ze.$$.fragment),$o=s(),ze=n("span"),ze.textContent=hl,oo=s(),Be=n("p"),Be.innerHTML=dl,this.h()},l(e){const o=Xl("svelte-1phssyn",document.head);w=i(o,"META",{name:!0,content:!0}),o.forEach(t),R=a(e),b=i(e,"H1",{class:!0});var Xe=d(b);g=i(Xe,"A",{id:!0,class:!0,href:!0});var cl=d(g);De=i(cl,"SPAN",{});var fl=d(De);f(F.$$.fragment,fl),fl.forEach(t),cl.forEach(t),mo=a(Xe),We=i(Xe,"SPAN",{"data-svelte-h":!0}),h(We)!=="svelte-1wu890j"&&(We.textContent=ko),Xe.forEach(t),pt=a(e),E=i(e,"P",{"data-svelte-h":!0}),h(E)!=="svelte-qaabbu"&&(E.innerHTML=_o),ht=a(e),q=i(e,"P",{"data-svelte-h":!0}),h(q)!=="svelte-1orjtw1"&&(q.textContent=xo),dt=a(e),f(N.$$.fragment,e),ct=a(e),C=i(e,"H2",{class:!0});var no=d(C);G=i(no,"A",{id:!0,class:!0,href:!0});var ul=d(G);Oe=i(ul,"SPAN",{});var ml=d(Oe);f(V.$$.fragment,ml),ml.forEach(t),ul.forEach(t),vo=a(no),He=i(no,"SPAN",{"data-svelte-h":!0}),h(He)!=="svelte-1y6w30"&&(He.textContent=Jo),no.forEach(t),ft=a(e),Q=i(e,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-17hueww"&&(Q.textContent=jo),ut=a(e),z=i(e,"P",{"data-svelte-h":!0}),h(z)!=="svelte-x5a2v2"&&(z.innerHTML=Lo),mt=a(e),D=i(e,"P",{"data-svelte-h":!0}),h(D)!=="svelte-4w8fdi"&&(D.textContent=No),vt=a(e),O=i(e,"UL",{"data-svelte-h":!0}),h(O)!=="svelte-1lfif8r"&&(O.innerHTML=Go),yt=a(e),K=i(e,"P",{"data-svelte-h":!0}),h(K)!=="svelte-eg00q0"&&(K.innerHTML=So),wt=a(e),U=i(e,"H2",{class:!0});var io=d(U);S=i(io,"A",{id:!0,class:!0,href:!0});var vl=d(S);Ke=i(vl,"SPAN",{});var yl=d(Ke);f(ee.$$.fragment,yl),yl.forEach(t),vl.forEach(t),yo=a(io),Ie=i(io,"SPAN",{"data-svelte-h":!0}),h(Ie)!=="svelte-akb0et"&&(Ie.textContent=Po),io.forEach(t),bt=a(e),te=i(e,"P",{"data-svelte-h":!0}),h(te)!=="svelte-1tgahft"&&(te.textContent=Ao),Mt=a(e),oe=i(e,"UL",{"data-svelte-h":!0}),h(oe)!=="svelte-1mnjc4n"&&(oe.innerHTML=Zo),gt=a(e),le=i(e,"P",{"data-svelte-h":!0}),h(le)!=="svelte-1uzdjfm"&&(le.innerHTML=Bo),Ct=a(e),f(ne.$$.fragment,e),Ut=a(e),ie=i(e,"P",{"data-svelte-h":!0}),h(ie)!=="svelte-1xkemdi"&&(ie.textContent=Xo),Tt=a(e),T=i(e,"H2",{class:!0});var so=d(T);P=i(so,"A",{id:!0,class:!0,href:!0});var wl=d(P);et=i(wl,"SPAN",{});var bl=d(et);f(se.$$.fragment,bl),bl.forEach(t),wl.forEach(t),wo=a(so),Ye=i(so,"SPAN",{"data-svelte-h":!0}),h(Ye)!=="svelte-8ygikr"&&(Ye.textContent=Wo),so.forEach(t),$t=a(e),ae=i(e,"P",{"data-svelte-h":!0}),h(ae)!=="svelte-19xoujm"&&(ae.textContent=Ho),kt=a(e),f(re.$$.fragment,e),_t=a(e),$=i(e,"H3",{class:!0});var ao=d($);A=i(ao,"A",{id:!0,class:!0,href:!0});var Ml=d(A);tt=i(Ml,"SPAN",{});var gl=d(tt);f(pe.$$.fragment,gl),gl.forEach(t),Ml.forEach(t),bo=a(ao),Re=i(ao,"SPAN",{"data-svelte-h":!0}),h(Re)!=="svelte-11iey86"&&(Re.textContent=Io),ao.forEach(t),xt=a(e),he=i(e,"P",{"data-svelte-h":!0}),h(he)!=="svelte-1k484f2"&&(he.innerHTML=Yo),Jt=a(e),de=i(e,"P",{"data-svelte-h":!0}),h(de)!=="svelte-1vn0h7b"&&(de.innerHTML=Ro),jt=a(e),f(ce.$$.fragment,e),Lt=a(e),k=i(e,"H3",{class:!0});var ro=d(k);Z=i(ro,"A",{id:!0,class:!0,href:!0});var Cl=d(Z);ot=i(Cl,"SPAN",{});var Ul=d(ot);f(fe.$$.fragment,Ul),Ul.forEach(t),Cl.forEach(t),Mo=a(ro),Fe=i(ro,"SPAN",{"data-svelte-h":!0}),h(Fe)!=="svelte-199uz7g"&&(Fe.textContent=Fo),ro.forEach(t),Nt=a(e),ue=i(e,"P",{"data-svelte-h":!0}),h(ue)!=="svelte-83ivzw"&&(ue.textContent=Eo),Gt=a(e),f(me.$$.fragment,e),St=a(e),ve=i(e,"P",{"data-svelte-h":!0}),h(ve)!=="svelte-hcctjd"&&(ve.innerHTML=qo),Pt=a(e),ye=i(e,"P",{"data-svelte-h":!0}),h(ye)!=="svelte-hhlwnj"&&(ye.innerHTML=Vo),At=a(e),we=i(e,"P",{"data-svelte-h":!0}),h(we)!=="svelte-ixiq1r"&&(we.innerHTML=Qo),Zt=a(e),f(be.$$.fragment,e),Bt=a(e),_=i(e,"H2",{class:!0});var po=d(_);B=i(po,"A",{id:!0,class:!0,href:!0});var Tl=d(B);lt=i(Tl,"SPAN",{});var $l=d(lt);f(Me.$$.fragment,$l),$l.forEach(t),Tl.forEach(t),go=a(po),Ee=i(po,"SPAN",{"data-svelte-h":!0}),h(Ee)!=="svelte-10xqvm6"&&(Ee.textContent=zo),po.forEach(t),Xt=a(e),ge=i(e,"P",{"data-svelte-h":!0}),h(ge)!=="svelte-1j3moem"&&(ge.innerHTML=Do),Wt=a(e),x=i(e,"H3",{class:!0});var ho=d(x);X=i(ho,"A",{id:!0,class:!0,href:!0});var kl=d(X);nt=i(kl,"SPAN",{});var _l=d(nt);f(Ce.$$.fragment,_l),_l.forEach(t),kl.forEach(t),Co=a(ho),qe=i(ho,"SPAN",{"data-svelte-h":!0}),h(qe)!=="svelte-wvpur9"&&(qe.textContent=Oo),ho.forEach(t),Ht=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),h(Ue)!=="svelte-1u2q3bb"&&(Ue.innerHTML=Ko),It=a(e),f(Te.$$.fragment,e),Yt=a(e),J=i(e,"H3",{class:!0});var co=d(J);W=i(co,"A",{id:!0,class:!0,href:!0});var xl=d(W);it=i(xl,"SPAN",{});var Jl=d(it);f($e.$$.fragment,Jl),Jl.forEach(t),xl.forEach(t),Uo=a(co),Ve=i(co,"SPAN",{"data-svelte-h":!0}),h(Ve)!=="svelte-199uz7g"&&(Ve.textContent=el),co.forEach(t),Rt=a(e),ke=i(e,"P",{"data-svelte-h":!0}),h(ke)!=="svelte-1a6a1za"&&(ke.textContent=tl),Ft=a(e),f(_e.$$.fragment,e),Et=a(e),xe=i(e,"P",{"data-svelte-h":!0}),h(xe)!=="svelte-1sx1rnz"&&(xe.innerHTML=ol),qt=a(e),f(Je.$$.fragment,e),Vt=a(e),je=i(e,"P",{"data-svelte-h":!0}),h(je)!=="svelte-12c7wn6"&&(je.innerHTML=ll),Qt=a(e),Le=i(e,"P",{"data-svelte-h":!0}),h(Le)!=="svelte-14s5isr"&&(Le.innerHTML=nl),zt=a(e),j=i(e,"H2",{class:!0});var fo=d(j);H=i(fo,"A",{id:!0,class:!0,href:!0});var jl=d(H);st=i(jl,"SPAN",{});var Ll=d(st);f(Ne.$$.fragment,Ll),Ll.forEach(t),jl.forEach(t),To=a(fo),Qe=i(fo,"SPAN",{"data-svelte-h":!0}),h(Qe)!=="svelte-ms2u0v"&&(Qe.textContent=il),fo.forEach(t),Dt=a(e),Ge=i(e,"P",{"data-svelte-h":!0}),h(Ge)!=="svelte-q86h2"&&(Ge.textContent=sl),Ot=a(e),Se=i(e,"UL",{"data-svelte-h":!0}),h(Se)!=="svelte-1jpknop"&&(Se.innerHTML=al),Kt=a(e),Pe=i(e,"P",{"data-svelte-h":!0}),h(Pe)!=="svelte-5goosl"&&(Pe.innerHTML=rl),eo=a(e),Ae=i(e,"P",{"data-svelte-h":!0}),h(Ae)!=="svelte-fa2zni"&&(Ae.textContent=pl),to=a(e),L=i(e,"H2",{class:!0});var uo=d(L);I=i(uo,"A",{id:!0,class:!0,href:!0});var Nl=d(I);at=i(Nl,"SPAN",{});var Gl=d(at);f(Ze.$$.fragment,Gl),Gl.forEach(t),Nl.forEach(t),$o=a(uo),ze=i(uo,"SPAN",{"data-svelte-h":!0}),h(ze)!=="svelte-1q6eai7"&&(ze.textContent=hl),uo.forEach(t),oo=a(e),Be=i(e,"P",{"data-svelte-h":!0}),h(Be)!=="svelte-m342fh"&&(Be.innerHTML=dl),this.h()},h(){r(w,"name","hf:doc:metadata"),r(w,"content",JSON.stringify(Yl)),r(g,"id","how-to-run-stable-diffusion-with-core-ml"),r(g,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(g,"href","#how-to-run-stable-diffusion-with-core-ml"),r(b,"class","relative group"),r(G,"id","stable-diffusion-core-ml-checkpoints"),r(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(G,"href","#stable-diffusion-core-ml-checkpoints"),r(C,"class","relative group"),r(S,"id","selecting-the-core-ml-variant-to-use"),r(S,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(S,"href","#selecting-the-core-ml-variant-to-use"),r(U,"class","relative group"),r(P,"id","core-ml-inference-in-python"),r(P,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(P,"href","#core-ml-inference-in-python"),r(T,"class","relative group"),r(A,"id","download-the-model-checkpoints"),r(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(A,"href","#download-the-model-checkpoints"),r($,"class","relative group"),r(Z,"id","python-inference"),r(Z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Z,"href","#python-inference"),r(k,"class","relative group"),r(B,"id","core-ml-inference-in-swift"),r(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(B,"href","#core-ml-inference-in-swift"),r(_,"class","relative group"),r(X,"id","download"),r(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(X,"href","#download"),r(x,"class","relative group"),r(W,"id","swift-inference"),r(W,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(W,"href","#swift-inference"),r(J,"class","relative group"),r(H,"id","supported-diffusers-features"),r(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(H,"href","#supported-diffusers-features"),r(j,"class","relative group"),r(I,"id","native-diffusers-swift-app"),r(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(I,"href","#native-diffusers-swift-app"),r(L,"class","relative group")},m(e,o){p(document.head,w),l(e,R,o),l(e,b,o),p(b,g),p(g,De),u(F,De,null),p(b,mo),p(b,We),l(e,pt,o),l(e,E,o),l(e,ht,o),l(e,q,o),l(e,dt,o),u(N,e,o),l(e,ct,o),l(e,C,o),p(C,G),p(G,Oe),u(V,Oe,null),p(C,vo),p(C,He),l(e,ft,o),l(e,Q,o),l(e,ut,o),l(e,z,o),l(e,mt,o),l(e,D,o),l(e,vt,o),l(e,O,o),l(e,yt,o),l(e,K,o),l(e,wt,o),l(e,U,o),p(U,S),p(S,Ke),u(ee,Ke,null),p(U,yo),p(U,Ie),l(e,bt,o),l(e,te,o),l(e,Mt,o),l(e,oe,o),l(e,gt,o),l(e,le,o),l(e,Ct,o),u(ne,e,o),l(e,Ut,o),l(e,ie,o),l(e,Tt,o),l(e,T,o),p(T,P),p(P,et),u(se,et,null),p(T,wo),p(T,Ye),l(e,$t,o),l(e,ae,o),l(e,kt,o),u(re,e,o),l(e,_t,o),l(e,$,o),p($,A),p(A,tt),u(pe,tt,null),p($,bo),p($,Re),l(e,xt,o),l(e,he,o),l(e,Jt,o),l(e,de,o),l(e,jt,o),u(ce,e,o),l(e,Lt,o),l(e,k,o),p(k,Z),p(Z,ot),u(fe,ot,null),p(k,Mo),p(k,Fe),l(e,Nt,o),l(e,ue,o),l(e,Gt,o),u(me,e,o),l(e,St,o),l(e,ve,o),l(e,Pt,o),l(e,ye,o),l(e,At,o),l(e,we,o),l(e,Zt,o),u(be,e,o),l(e,Bt,o),l(e,_,o),p(_,B),p(B,lt),u(Me,lt,null),p(_,go),p(_,Ee),l(e,Xt,o),l(e,ge,o),l(e,Wt,o),l(e,x,o),p(x,X),p(X,nt),u(Ce,nt,null),p(x,Co),p(x,qe),l(e,Ht,o),l(e,Ue,o),l(e,It,o),u(Te,e,o),l(e,Yt,o),l(e,J,o),p(J,W),p(W,it),u($e,it,null),p(J,Uo),p(J,Ve),l(e,Rt,o),l(e,ke,o),l(e,Ft,o),u(_e,e,o),l(e,Et,o),l(e,xe,o),l(e,qt,o),u(Je,e,o),l(e,Vt,o),l(e,je,o),l(e,Qt,o),l(e,Le,o),l(e,zt,o),l(e,j,o),p(j,H),p(H,st),u(Ne,st,null),p(j,To),p(j,Qe),l(e,Dt,o),l(e,Ge,o),l(e,Ot,o),l(e,Se,o),l(e,Kt,o),l(e,Pe,o),l(e,eo,o),l(e,Ae,o),l(e,to,o),l(e,L,o),p(L,I),p(I,at),u(Ze,at,null),p(L,$o),p(L,ze),l(e,oo,o),l(e,Be,o),lo=!0},p(e,[o]){const Xe={};o&2&&(Xe.$$scope={dirty:o,ctx:e}),N.$set(Xe)},i(e){lo||(m(F.$$.fragment,e),m(N.$$.fragment,e),m(V.$$.fragment,e),m(ee.$$.fragment,e),m(ne.$$.fragment,e),m(se.$$.fragment,e),m(re.$$.fragment,e),m(pe.$$.fragment,e),m(ce.$$.fragment,e),m(fe.$$.fragment,e),m(me.$$.fragment,e),m(be.$$.fragment,e),m(Me.$$.fragment,e),m(Ce.$$.fragment,e),m(Te.$$.fragment,e),m($e.$$.fragment,e),m(_e.$$.fragment,e),m(Je.$$.fragment,e),m(Ne.$$.fragment,e),m(Ze.$$.fragment,e),lo=!0)},o(e){v(F.$$.fragment,e),v(N.$$.fragment,e),v(V.$$.fragment,e),v(ee.$$.fragment,e),v(ne.$$.fragment,e),v(se.$$.fragment,e),v(re.$$.fragment,e),v(pe.$$.fragment,e),v(ce.$$.fragment,e),v(fe.$$.fragment,e),v(me.$$.fragment,e),v(be.$$.fragment,e),v(Me.$$.fragment,e),v(Ce.$$.fragment,e),v(Te.$$.fragment,e),v($e.$$.fragment,e),v(_e.$$.fragment,e),v(Je.$$.fragment,e),v(Ne.$$.fragment,e),v(Ze.$$.fragment,e),lo=!1},d(e){e&&(t(R),t(b),t(pt),t(E),t(ht),t(q),t(dt),t(ct),t(C),t(ft),t(Q),t(ut),t(z),t(mt),t(D),t(vt),t(O),t(yt),t(K),t(wt),t(U),t(bt),t(te),t(Mt),t(oe),t(gt),t(le),t(Ct),t(Ut),t(ie),t(Tt),t(T),t($t),t(ae),t(kt),t(_t),t($),t(xt),t(he),t(Jt),t(de),t(jt),t(Lt),t(k),t(Nt),t(ue),t(Gt),t(St),t(ve),t(Pt),t(ye),t(At),t(we),t(Zt),t(Bt),t(_),t(Xt),t(ge),t(Wt),t(x),t(Ht),t(Ue),t(It),t(Yt),t(J),t(Rt),t(ke),t(Ft),t(Et),t(xe),t(qt),t(Vt),t(je),t(Qt),t(Le),t(zt),t(j),t(Dt),t(Ge),t(Ot),t(Se),t(Kt),t(Pe),t(eo),t(Ae),t(to),t(L),t(oo),t(Be)),t(w),y(F),y(N,e),y(V),y(ee),y(ne,e),y(se),y(re,e),y(pe),y(ce,e),y(fe),y(me,e),y(be,e),y(Me),y(Ce),y(Te,e),y($e),y(_e,e),y(Je,e),y(Ne),y(Ze)}}}const Yl={local:"how-to-run-stable-diffusion-with-core-ml",sections:[{local:"stable-diffusion-core-ml-checkpoints",title:"Stable Diffusion Core ML Checkpoints"},{local:"selecting-the-core-ml-variant-to-use",title:"Selecting the Core ML Variant to Use"},{local:"core-ml-inference-in-python",sections:[{local:"download-the-model-checkpoints",title:"Download the Model Checkpoints"},{local:"python-inference",title:"Inference"}],title:"Core ML Inference in Python"},{local:"core-ml-inference-in-swift",sections:[{local:"download",title:"Download"},{local:"swift-inference",title:"Inference"}],title:"Core ML inference in Swift"},{local:"supported-diffusers-features",title:"Supported Diffusers Features"},{local:"native-diffusers-swift-app",title:"Native Diffusers Swift app"}],title:"How to run Stable Diffusion with Core ML"};function Rl(rt){return Pl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zl extends Zl{constructor(w){super(),Bl(this,w,Rl,Il,Sl,{})}}export{zl as component};
