import{s as xe,n as Ce,o as Ie}from"../chunks/scheduler.182ea377.js";import{S as Be,i as Se,g as i,s as a,r as p,A as Re,h as o,f as l,c as n,j as Ge,u as r,x as m,k as be,y as Ye,a as s,v as d,d as c,t as u,w as f}from"../chunks/index.abf12888.js";import{C as N}from"../chunks/CodeBlock.57fe6e13.js";import{D as ze}from"../chunks/DocNotebookDropdown.d9060979.js";import{H as ge}from"../chunks/Heading.16916d63.js";function Ne(Me){let h,E,Y,F,b,Q,M,D,Z,Ze='<a href="https://huggingface.co/papers/2311.15127" rel="nofollow">Stable Video Diffusion (SVD)</a> is a powerful image-to-video generation model that can generate 2-4 second high resolution (576x1024) videos conditioned on an input image.',L,J,Je="This guide will show you how to use SVD to generate short videos from images.",H,w,we="Before you begin, make sure you have the following libraries installed:",q,y,P,v,ye='The are two variants of this model, <a href="https://huggingface.co/stabilityai/stable-video-diffusion-img2vid" rel="nofollow">SVD</a> and <a href="https://huggingface.co/stabilityai/stable-video-diffusion-img2vid-xt" rel="nofollow">SVD-XT</a>. The SVD checkpoint is trained to generate 14 frames and the SVD-XT checkpoint is further finetuned to generate 25 frames.',K,T,ve="You’ll use the SVD-XT checkpoint for this guide.",A,k,O,g,Te='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/rocket.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">&quot;source image of a rocket&quot;</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/output_rocket.gif"/> <figcaption class="mt-2 text-center text-sm text-gray-500">&quot;generated video from source image&quot;</figcaption></div>',ee,U,te,W,ke='You can gain a 20-25% speedup at the expense of slightly increased memory by <a href="../optimization/torch2.0#torchcompile">compiling</a> the UNet.',le,_,se,j,ae,V,Ue="Video generation is very memory intensive because you’re essentially generating <code>num_frames</code> all at once, similar to text-to-image generation with a high batch size. To reduce the memory requirement, there are multiple options that trade-off inference speed for lower memory requirement:",ne,X,We="<li>enable model offloading: each component of the pipeline is offloaded to the CPU once it’s not needed anymore.</li> <li>enable feed-forward chunking: the feed-forward layer runs in a loop instead of running a single feed-forward with a huge batch size.</li> <li>reduce <code>decode_chunk_size</code>: the VAE decodes frames in chunks instead of decoding them all together. Setting <code>decode_chunk_size=1</code> decodes one frame at a time and uses the least amount of memory (we recommend adjusting this value based on your GPU memory) but the video might have some flickering.</li>",ie,$,oe,G,_e="Using all these tricks togethere should lower the memory requirement to less than 8GB VRAM.",me,x,pe,C,je="Stable Diffusion Video also accepts micro-conditioning, in addition to the conditioning image, which allows more control over the generated video:",re,I,Ve="<li><code>fps</code>: the frames per second of the generated video.</li> <li><code>motion_bucket_id</code>: the motion bucket id to use for the generated video. This can be used to control the motion of the generated video. Increasing the motion bucket id increases the motion of the generated video.</li> <li><code>noise_aug_strength</code>: the amount of noise added to the conditioning image. The higher the values the less the video resembles the conditioning image. Increasing this value also increases the motion of the generated video.</li>",de,B,Xe="For example, to generate a video with more motion, use the <code>motion_bucket_id</code> and <code>noise_aug_strength</code> micro-conditioning parameters:",ce,S,ue,R,$e='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/output_rocket_with_conditions.gif"/>',fe,z,he;return b=new ge({props:{title:"Stable Video Diffusion",local:"stable-video-diffusion",headingTag:"h1"}}),M=new ze({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/svd.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/svd.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/svd.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/svd.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/svd.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/svd.ipynb"}]}}),y=new N({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMC1VJTIwZGlmZnVzZXJzJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZSUyMA==",highlighted:"!pip install -q -U diffusers transformers accelerate ",wrap:!1}}),k=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlVmlkZW9EaWZmdXNpb25QaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZVZpZGVvRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLXZpZGVvLWRpZmZ1c2lvbi1pbWcydmlkLXh0JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMEEpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQSUyMyUyMExvYWQlMjB0aGUlMjBjb25kaXRpb25pbmclMjBpbWFnZSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZzdmQlMkZyb2NrZXQucG5nJTIyKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2UucmVzaXplKCgxMDI0JTJDJTIwNTc2KSklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCg0MiklMEFmcmFtZXMlMjAlM0QlMjBwaXBlKGltYWdlJTJDJTIwZGVjb2RlX2NodW5rX3NpemUlM0Q4JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5mcmFtZXMlNUIwJTVEJTBBJTBBZXhwb3J0X3RvX3ZpZGVvKGZyYW1lcyUyQyUyMCUyMmdlbmVyYXRlZC5tcDQlMjIlMkMlMjBmcHMlM0Q3KQ==",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableVideoDiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, export_to_video

pipe = StableVideoDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-video-diffusion-img2vid-xt&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># Load the conditioning image</span>
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/rocket.png&quot;</span>)
image = image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">576</span>))

generator = torch.manual_seed(<span class="hljs-number">42</span>)
frames = pipe(image, decode_chunk_size=<span class="hljs-number">8</span>, generator=generator).frames[<span class="hljs-number">0</span>]

export_to_video(frames, <span class="hljs-string">&quot;generated.mp4&quot;</span>, fps=<span class="hljs-number">7</span>)`,wrap:!1}}),U=new ge({props:{title:"torch.compile",local:"torchcompile",headingTag:"h2"}}),_=new N({props:{code:"LSUyMHBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMkIlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTJCJTIwcGlwZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnVuZXQlMkMlMjBtb2RlJTNEJTIycmVkdWNlLW92ZXJoZWFkJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSk=",highlighted:`<span class="hljs-deletion">- pipe.enable_model_cpu_offload()</span>
<span class="hljs-addition">+ pipe.to(&quot;cuda&quot;)</span>
<span class="hljs-addition">+ pipe.unet = torch.compile(pipe.unet, mode=&quot;reduce-overhead&quot;, fullgraph=True)</span>`,wrap:!1}}),j=new ge({props:{title:"Reduce memory usage",local:"reduce-memory-usage",headingTag:"h2"}}),$=new N({props:{code:"LSUyMHBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEEtJTIwZnJhbWVzJTIwJTNEJTIwcGlwZShpbWFnZSUyQyUyMGRlY29kZV9jaHVua19zaXplJTNEOCUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvcikuZnJhbWVzJTVCMCU1RCUwQSUyQiUyMHBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMkIlMjBwaXBlLnVuZXQuZW5hYmxlX2ZvcndhcmRfY2h1bmtpbmcoKSUwQSUyQiUyMGZyYW1lcyUyMCUzRCUyMHBpcGUoaW1hZ2UlMkMlMjBkZWNvZGVfY2h1bmtfc2l6ZSUzRDIlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1fZnJhbWVzJTNEMjUpLmZyYW1lcyU1QjAlNUQ=",highlighted:`<span class="hljs-deletion">- pipe.enable_model_cpu_offload()</span>
<span class="hljs-deletion">- frames = pipe(image, decode_chunk_size=8, generator=generator).frames[0]</span>
<span class="hljs-addition">+ pipe.enable_model_cpu_offload()</span>
<span class="hljs-addition">+ pipe.unet.enable_forward_chunking()</span>
<span class="hljs-addition">+ frames = pipe(image, decode_chunk_size=2, generator=generator, num_frames=25).frames[0]</span>`,wrap:!1}}),x=new ge({props:{title:"Micro-conditioning",local:"micro-conditioning",headingTag:"h2"}}),S=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlVmlkZW9EaWZmdXNpb25QaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZVZpZGVvRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLXZpZGVvLWRpZmZ1c2lvbi1pbWcydmlkLXh0JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMEEpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQSUyMyUyMExvYWQlMjB0aGUlMjBjb25kaXRpb25pbmclMjBpbWFnZSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZzdmQlMkZyb2NrZXQucG5nJTIyKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2UucmVzaXplKCgxMDI0JTJDJTIwNTc2KSklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCg0MiklMEFmcmFtZXMlMjAlM0QlMjBwaXBlKGltYWdlJTJDJTIwZGVjb2RlX2NodW5rX3NpemUlM0Q4JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwbW90aW9uX2J1Y2tldF9pZCUzRDE4MCUyQyUyMG5vaXNlX2F1Z19zdHJlbmd0aCUzRDAuMSkuZnJhbWVzJTVCMCU1RCUwQWV4cG9ydF90b192aWRlbyhmcmFtZXMlMkMlMjAlMjJnZW5lcmF0ZWQubXA0JTIyJTJDJTIwZnBzJTNENyk=",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableVideoDiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, export_to_video

pipe = StableVideoDiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;stabilityai/stable-video-diffusion-img2vid-xt&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># Load the conditioning image</span>
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/rocket.png&quot;</span>)
image = image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">576</span>))

generator = torch.manual_seed(<span class="hljs-number">42</span>)
frames = pipe(image, decode_chunk_size=<span class="hljs-number">8</span>, generator=generator, motion_bucket_id=<span class="hljs-number">180</span>, noise_aug_strength=<span class="hljs-number">0.1</span>).frames[<span class="hljs-number">0</span>]
export_to_video(frames, <span class="hljs-string">&quot;generated.mp4&quot;</span>, fps=<span class="hljs-number">7</span>)`,wrap:!1}}),{c(){h=i("meta"),E=a(),Y=i("p"),F=a(),p(b.$$.fragment),Q=a(),p(M.$$.fragment),D=a(),Z=i("p"),Z.innerHTML=Ze,L=a(),J=i("p"),J.textContent=Je,H=a(),w=i("p"),w.textContent=we,q=a(),p(y.$$.fragment),P=a(),v=i("p"),v.innerHTML=ye,K=a(),T=i("p"),T.textContent=ve,A=a(),p(k.$$.fragment),O=a(),g=i("div"),g.innerHTML=Te,ee=a(),p(U.$$.fragment),te=a(),W=i("p"),W.innerHTML=ke,le=a(),p(_.$$.fragment),se=a(),p(j.$$.fragment),ae=a(),V=i("p"),V.innerHTML=Ue,ne=a(),X=i("ul"),X.innerHTML=We,ie=a(),p($.$$.fragment),oe=a(),G=i("p"),G.textContent=_e,me=a(),p(x.$$.fragment),pe=a(),C=i("p"),C.textContent=je,re=a(),I=i("ul"),I.innerHTML=Ve,de=a(),B=i("p"),B.innerHTML=Xe,ce=a(),p(S.$$.fragment),ue=a(),R=i("p"),R.innerHTML=$e,fe=a(),z=i("p"),this.h()},l(e){const t=Re("svelte-u9bgzb",document.head);h=o(t,"META",{name:!0,content:!0}),t.forEach(l),E=n(e),Y=o(e,"P",{}),Ge(Y).forEach(l),F=n(e),r(b.$$.fragment,e),Q=n(e),r(M.$$.fragment,e),D=n(e),Z=o(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-6831zo"&&(Z.innerHTML=Ze),L=n(e),J=o(e,"P",{"data-svelte-h":!0}),m(J)!=="svelte-9hcj9z"&&(J.textContent=Je),H=n(e),w=o(e,"P",{"data-svelte-h":!0}),m(w)!=="svelte-cwruts"&&(w.textContent=we),q=n(e),r(y.$$.fragment,e),P=n(e),v=o(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-iibvlr"&&(v.innerHTML=ye),K=n(e),T=o(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-u5kxxd"&&(T.textContent=ve),A=n(e),r(k.$$.fragment,e),O=n(e),g=o(e,"DIV",{class:!0,"data-svelte-h":!0}),m(g)!=="svelte-25rdw"&&(g.innerHTML=Te),ee=n(e),r(U.$$.fragment,e),te=n(e),W=o(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1hgzo8e"&&(W.innerHTML=ke),le=n(e),r(_.$$.fragment,e),se=n(e),r(j.$$.fragment,e),ae=n(e),V=o(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1aihuum"&&(V.innerHTML=Ue),ne=n(e),X=o(e,"UL",{"data-svelte-h":!0}),m(X)!=="svelte-carvgs"&&(X.innerHTML=We),ie=n(e),r($.$$.fragment,e),oe=n(e),G=o(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1n5xf7a"&&(G.textContent=_e),me=n(e),r(x.$$.fragment,e),pe=n(e),C=o(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-crombe"&&(C.textContent=je),re=n(e),I=o(e,"UL",{"data-svelte-h":!0}),m(I)!=="svelte-hs8jkz"&&(I.innerHTML=Ve),de=n(e),B=o(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-3jffic"&&(B.innerHTML=Xe),ce=n(e),r(S.$$.fragment,e),ue=n(e),R=o(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-19qaph4"&&(R.innerHTML=$e),fe=n(e),z=o(e,"P",{}),Ge(z).forEach(l),this.h()},h(){be(h,"name","hf:doc:metadata"),be(h,"content",Ee),be(g,"class","flex gap-4")},m(e,t){Ye(document.head,h),s(e,E,t),s(e,Y,t),s(e,F,t),d(b,e,t),s(e,Q,t),d(M,e,t),s(e,D,t),s(e,Z,t),s(e,L,t),s(e,J,t),s(e,H,t),s(e,w,t),s(e,q,t),d(y,e,t),s(e,P,t),s(e,v,t),s(e,K,t),s(e,T,t),s(e,A,t),d(k,e,t),s(e,O,t),s(e,g,t),s(e,ee,t),d(U,e,t),s(e,te,t),s(e,W,t),s(e,le,t),d(_,e,t),s(e,se,t),d(j,e,t),s(e,ae,t),s(e,V,t),s(e,ne,t),s(e,X,t),s(e,ie,t),d($,e,t),s(e,oe,t),s(e,G,t),s(e,me,t),d(x,e,t),s(e,pe,t),s(e,C,t),s(e,re,t),s(e,I,t),s(e,de,t),s(e,B,t),s(e,ce,t),d(S,e,t),s(e,ue,t),s(e,R,t),s(e,fe,t),s(e,z,t),he=!0},p:Ce,i(e){he||(c(b.$$.fragment,e),c(M.$$.fragment,e),c(y.$$.fragment,e),c(k.$$.fragment,e),c(U.$$.fragment,e),c(_.$$.fragment,e),c(j.$$.fragment,e),c($.$$.fragment,e),c(x.$$.fragment,e),c(S.$$.fragment,e),he=!0)},o(e){u(b.$$.fragment,e),u(M.$$.fragment,e),u(y.$$.fragment,e),u(k.$$.fragment,e),u(U.$$.fragment,e),u(_.$$.fragment,e),u(j.$$.fragment,e),u($.$$.fragment,e),u(x.$$.fragment,e),u(S.$$.fragment,e),he=!1},d(e){e&&(l(E),l(Y),l(F),l(Q),l(D),l(Z),l(L),l(J),l(H),l(w),l(q),l(P),l(v),l(K),l(T),l(A),l(O),l(g),l(ee),l(te),l(W),l(le),l(se),l(ae),l(V),l(ne),l(X),l(ie),l(oe),l(G),l(me),l(pe),l(C),l(re),l(I),l(de),l(B),l(ce),l(ue),l(R),l(fe),l(z)),l(h),f(b,e),f(M,e),f(y,e),f(k,e),f(U,e),f(_,e),f(j,e),f($,e),f(x,e),f(S,e)}}}const Ee='{"title":"Stable Video Diffusion","local":"stable-video-diffusion","sections":[{"title":"torch.compile","local":"torchcompile","sections":[],"depth":2},{"title":"Reduce memory usage","local":"reduce-memory-usage","sections":[],"depth":2},{"title":"Micro-conditioning","local":"micro-conditioning","sections":[],"depth":2}],"depth":1}';function Fe(Me){return Ie(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pe extends Be{constructor(h){super(),Se(this,h,Fe,Ne,xe,{})}}export{Pe as component};
