import{s as Ne,o as ze,n as Fe}from"../chunks/scheduler.182ea377.js";import{S as Qe,i as Le,g as i,s,r as c,A as De,h as o,f as l,c as a,j as Re,u as f,x as m,k as Ee,y as He,a as n,v as u,d as h,t as g,w as b,m as qe,n as Pe}from"../chunks/index.abf12888.js";import{T as Ke}from"../chunks/Tip.230e2334.js";import{C as D}from"../chunks/CodeBlock.57fe6e13.js";import{D as Ae}from"../chunks/DocNotebookDropdown.d9060979.js";import{H}from"../chunks/Heading.16916d63.js";function Oe(q){let d,r,y='Additionally, we also use <a href="../../optimization/memory#model-offloading">model cpu offloading</a> to reduce the memory usage.';return{c(){d=qe("Since generating videos is more memory intensive we can use the `decode_chunk_size` argument to control how many frames are decoded at once. This will reduce the memory usage. It's recommended to tweak this value based on your GPU memory.\nSetting `decode_chunk_size=1` will decode one frame at a time and will use the least amount of memory but the video might have some flickering.\n"),r=i("p"),r.innerHTML=y},l(p){d=Pe(p,"Since generating videos is more memory intensive we can use the `decode_chunk_size` argument to control how many frames are decoded at once. This will reduce the memory usage. It's recommended to tweak this value based on your GPU memory.\nSetting `decode_chunk_size=1` will decode one frame at a time and will use the least amount of memory but the video might have some flickering.\n"),r=o(p,"P",{"data-svelte-h":!0}),m(r)!=="svelte-dumqni"&&(r.innerHTML=y)},m(p,w){n(p,d,w),n(p,r,w)},p:Fe,d(p){p&&(l(d),l(r))}}}function et(q){let d,r,y,p,w,P,Z,K,v,Te='<a href="https://static1.squarespace.com/static/6213c340453c3f502425776e/t/655ce779b9d47d342a93c890/1700587395994/stable_video_diffusion.pdf" rel="nofollow">Stable Video Diffusion</a> is a powerful image-to-video generation model that can generate high resolution (576x1024) 2-4 second videos conditioned on the input image.',A,J,_e="This guide will show you how to use SVD to short generate videos from images.",O,T,ke="Before you begin, make sure you have the following libraries installed:",ee,_,te,k,le,W,We=`The are two variants of SVD. <a href="https://huggingface.co/stabilityai/stable-video-diffusion-img2vid" rel="nofollow">SVD</a>
and <a href="https://huggingface.co/stabilityai/stable-video-diffusion-img2vid-xt" rel="nofollow">SVD-XT</a>. The svd checkpoint is trained to generate 14 frames and the svd-xt checkpoint is further
finetuned to generate 25 frames.`,ne,$,$e="We will use the <code>svd-xt</code> checkpoint for this guide.",se,U,ae,j,Ue='<thead><tr><th align="center"><strong>Source Image</strong></th> <th align="center"><strong>Video</strong></th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/rocket.png"/></td> <td align="center"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/output_rocket.gif"/></td></tr></tbody>',ie,M,oe,V,me,X,je="You can achieve a 20-25% speed-up at the expense of slightly increased memory by compiling the UNet as follows:",de,G,re,C,pe,x,Ve="Video generation is very memory intensive as we have to essentially generate <code>num_frames</code> all at once. The mechanism is very comparable to text-to-image generation with a high batch size. To reduce the memory requirement you have multiple options. The following options trade inference speed against lower memory requirement:",ce,I,Xe="<li>enable model offloading: Each component of the pipeline is offloaded to CPU once it’s not needed anymore.</li> <li>enable feed-forward chunking: The feed-forward layer runs in a loop instead of running with a single huge feed-forward batch size</li> <li>reduce <code>decode_chunk_size</code>: This means that the VAE decodes frames in chunks instead of decoding them all together. <strong>Note that</strong>, in addition to leading to a small slowdown, this method also slightly leads to video quality deterioration.</li>",fe,B,Ge="You can enable them as follows:",ue,S,he,Y,Ce="Including all these tricks should lower the memory requirement to less than 8GB VRAM.",ge,R,be,E,xe=`Along with conditioning image Stable Diffusion Video also allows providing micro-conditioning that allows more control over the generated video.
It accepts the following arguments:`,we,N,Ie="<li><code>fps</code>: The frames per second of the generated video.</li> <li><code>motion_bucket_id</code>: The motion bucket id to use for the generated video. This can be used to control the motion of the generated video. Increasing the motion bucket id will increase the motion of the generated video.</li> <li><code>noise_aug_strength</code>: The amount of noise added to the conditioning image. The higher the values the less the video will resemble the conditioning image. Increasing this value will also increase the motion of the generated video.</li>",ye,z,Be="Here is an example of using micro-conditioning to generate a video with more motion.",Me,F,Ze,Q,Se='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/output_rocket_with_conditions.gif"/>',ve,L,Je;return w=new H({props:{title:"Stable Video Diffusion",local:"stable-video-diffusion",headingTag:"h1"}}),Z=new Ae({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/svd.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/svd.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/svd.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/svd.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/svd.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/svd.ipynb"}]}}),_=new D({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMC1VJTIwZGlmZnVzZXJzJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZSUyMA==",highlighted:"!pip install -q -U diffusers transformers accelerate ",wrap:!1}}),k=new H({props:{title:"Image to Video Generation",local:"image-to-video-generation",headingTag:"h2"}}),U=new D({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlVmlkZW9EaWZmdXNpb25QaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZVZpZGVvRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLXZpZGVvLWRpZmZ1c2lvbi1pbWcydmlkLXh0JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMEEpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQSUyMyUyMExvYWQlMjB0aGUlMjBjb25kaXRpb25pbmclMjBpbWFnZSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZzdmQlMkZyb2NrZXQucG5nJTIyKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2UucmVzaXplKCgxMDI0JTJDJTIwNTc2KSklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCg0MiklMEFmcmFtZXMlMjAlM0QlMjBwaXBlKGltYWdlJTJDJTIwZGVjb2RlX2NodW5rX3NpemUlM0Q4JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5mcmFtZXMlNUIwJTVEJTBBJTBBZXhwb3J0X3RvX3ZpZGVvKGZyYW1lcyUyQyUyMCUyMmdlbmVyYXRlZC5tcDQlMjIlMkMlMjBmcHMlM0Q3KQ==",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableVideoDiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, export_to_video

pipe = StableVideoDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-video-diffusion-img2vid-xt&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># Load the conditioning image</span>
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/rocket.png&quot;</span>)
image = image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">576</span>))

generator = torch.manual_seed(<span class="hljs-number">42</span>)
frames = pipe(image, decode_chunk_size=<span class="hljs-number">8</span>, generator=generator).frames[<span class="hljs-number">0</span>]

export_to_video(frames, <span class="hljs-string">&quot;generated.mp4&quot;</span>, fps=<span class="hljs-number">7</span>)`,wrap:!1}}),M=new Ke({props:{$$slots:{default:[Oe]},$$scope:{ctx:q}}}),V=new H({props:{title:"Torch.compile",local:"torchcompile",headingTag:"h3"}}),G=new D({props:{code:"LSUyMHBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMkIlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTJCJTIwcGlwZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnVuZXQlMkMlMjBtb2RlJTNEJTIycmVkdWNlLW92ZXJoZWFkJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSk=",highlighted:`<span class="hljs-deletion">- pipe.enable_model_cpu_offload()</span>
<span class="hljs-addition">+ pipe.to(&quot;cuda&quot;)</span>
<span class="hljs-addition">+ pipe.unet = torch.compile(pipe.unet, mode=&quot;reduce-overhead&quot;, fullgraph=True)</span>`,wrap:!1}}),C=new H({props:{title:"Low-memory",local:"low-memory",headingTag:"h3"}}),S=new D({props:{code:"LXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEEtZnJhbWVzJTIwJTNEJTIwcGlwZShpbWFnZSUyQyUyMGRlY29kZV9jaHVua19zaXplJTNEOCUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvcikuZnJhbWVzJTVCMCU1RCUwQSUyQnBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMkJwaXBlLnVuZXQuZW5hYmxlX2ZvcndhcmRfY2h1bmtpbmcoKSUwQSUyQmZyYW1lcyUyMCUzRCUyMHBpcGUoaW1hZ2UlMkMlMjBkZWNvZGVfY2h1bmtfc2l6ZSUzRDIlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1fZnJhbWVzJTNEMjUpLmZyYW1lcyU1QjAlNUQ=",highlighted:`<span class="hljs-deletion">-pipe.enable_model_cpu_offload()</span>
<span class="hljs-deletion">-frames = pipe(image, decode_chunk_size=8, generator=generator).frames[0]</span>
<span class="hljs-addition">+pipe.enable_model_cpu_offload()</span>
<span class="hljs-addition">+pipe.unet.enable_forward_chunking()</span>
<span class="hljs-addition">+frames = pipe(image, decode_chunk_size=2, generator=generator, num_frames=25).frames[0]</span>`,wrap:!1}}),R=new H({props:{title:"Micro-conditioning",local:"micro-conditioning",headingTag:"h3"}}),F=new D({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlVmlkZW9EaWZmdXNpb25QaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZVZpZGVvRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLXZpZGVvLWRpZmZ1c2lvbi1pbWcydmlkLXh0JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMEEpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQSUyMyUyMExvYWQlMjB0aGUlMjBjb25kaXRpb25pbmclMjBpbWFnZSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZzdmQlMkZyb2NrZXQucG5nJTIyKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2UucmVzaXplKCgxMDI0JTJDJTIwNTc2KSklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCg0MiklMEFmcmFtZXMlMjAlM0QlMjBwaXBlKGltYWdlJTJDJTIwZGVjb2RlX2NodW5rX3NpemUlM0Q4JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwbW90aW9uX2J1Y2tldF9pZCUzRDE4MCUyQyUyMG5vaXNlX2F1Z19zdHJlbmd0aCUzRDAuMSkuZnJhbWVzJTVCMCU1RCUwQWV4cG9ydF90b192aWRlbyhmcmFtZXMlMkMlMjAlMjJnZW5lcmF0ZWQubXA0JTIyJTJDJTIwZnBzJTNENyk=",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableVideoDiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, export_to_video

pipe = StableVideoDiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;stabilityai/stable-video-diffusion-img2vid-xt&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># Load the conditioning image</span>
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/rocket.png&quot;</span>)
image = image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">576</span>))

generator = torch.manual_seed(<span class="hljs-number">42</span>)
frames = pipe(image, decode_chunk_size=<span class="hljs-number">8</span>, generator=generator, motion_bucket_id=<span class="hljs-number">180</span>, noise_aug_strength=<span class="hljs-number">0.1</span>).frames[<span class="hljs-number">0</span>]
export_to_video(frames, <span class="hljs-string">&quot;generated.mp4&quot;</span>, fps=<span class="hljs-number">7</span>)`,wrap:!1}}),{c(){d=i("meta"),r=s(),y=i("p"),p=s(),c(w.$$.fragment),P=s(),c(Z.$$.fragment),K=s(),v=i("p"),v.innerHTML=Te,A=s(),J=i("p"),J.textContent=_e,O=s(),T=i("p"),T.textContent=ke,ee=s(),c(_.$$.fragment),te=s(),c(k.$$.fragment),le=s(),W=i("p"),W.innerHTML=We,ne=s(),$=i("p"),$.innerHTML=$e,se=s(),c(U.$$.fragment),ae=s(),j=i("table"),j.innerHTML=Ue,ie=s(),c(M.$$.fragment),oe=s(),c(V.$$.fragment),me=s(),X=i("p"),X.textContent=je,de=s(),c(G.$$.fragment),re=s(),c(C.$$.fragment),pe=s(),x=i("p"),x.innerHTML=Ve,ce=s(),I=i("ul"),I.innerHTML=Xe,fe=s(),B=i("p"),B.textContent=Ge,ue=s(),c(S.$$.fragment),he=s(),Y=i("p"),Y.textContent=Ce,ge=s(),c(R.$$.fragment),be=s(),E=i("p"),E.textContent=xe,we=s(),N=i("ul"),N.innerHTML=Ie,ye=s(),z=i("p"),z.textContent=Be,Me=s(),c(F.$$.fragment),Ze=s(),Q=i("p"),Q.innerHTML=Se,ve=s(),L=i("p"),this.h()},l(e){const t=De("svelte-u9bgzb",document.head);d=o(t,"META",{name:!0,content:!0}),t.forEach(l),r=a(e),y=o(e,"P",{}),Re(y).forEach(l),p=a(e),f(w.$$.fragment,e),P=a(e),f(Z.$$.fragment,e),K=a(e),v=o(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-1vbef9r"&&(v.innerHTML=Te),A=a(e),J=o(e,"P",{"data-svelte-h":!0}),m(J)!=="svelte-xwqusf"&&(J.textContent=_e),O=a(e),T=o(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-cwruts"&&(T.textContent=ke),ee=a(e),f(_.$$.fragment,e),te=a(e),f(k.$$.fragment,e),le=a(e),W=o(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-d5kpr9"&&(W.innerHTML=We),ne=a(e),$=o(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-ovrr6i"&&($.innerHTML=$e),se=a(e),f(U.$$.fragment,e),ae=a(e),j=o(e,"TABLE",{"data-svelte-h":!0}),m(j)!=="svelte-n37d2y"&&(j.innerHTML=Ue),ie=a(e),f(M.$$.fragment,e),oe=a(e),f(V.$$.fragment,e),me=a(e),X=o(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1avdrs5"&&(X.textContent=je),de=a(e),f(G.$$.fragment,e),re=a(e),f(C.$$.fragment,e),pe=a(e),x=o(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-19vtt0c"&&(x.innerHTML=Ve),ce=a(e),I=o(e,"UL",{"data-svelte-h":!0}),m(I)!=="svelte-1o1glvy"&&(I.innerHTML=Xe),fe=a(e),B=o(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-xt0ph2"&&(B.textContent=Ge),ue=a(e),f(S.$$.fragment,e),he=a(e),Y=o(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-yldnwm"&&(Y.textContent=Ce),ge=a(e),f(R.$$.fragment,e),be=a(e),E=o(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-zhhgyp"&&(E.textContent=xe),we=a(e),N=o(e,"UL",{"data-svelte-h":!0}),m(N)!=="svelte-1tco7lo"&&(N.innerHTML=Ie),ye=a(e),z=o(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1vov4p7"&&(z.textContent=Be),Me=a(e),f(F.$$.fragment,e),Ze=a(e),Q=o(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-19qaph4"&&(Q.innerHTML=Se),ve=a(e),L=o(e,"P",{}),Re(L).forEach(l),this.h()},h(){Ee(d,"name","hf:doc:metadata"),Ee(d,"content",tt)},m(e,t){He(document.head,d),n(e,r,t),n(e,y,t),n(e,p,t),u(w,e,t),n(e,P,t),u(Z,e,t),n(e,K,t),n(e,v,t),n(e,A,t),n(e,J,t),n(e,O,t),n(e,T,t),n(e,ee,t),u(_,e,t),n(e,te,t),u(k,e,t),n(e,le,t),n(e,W,t),n(e,ne,t),n(e,$,t),n(e,se,t),u(U,e,t),n(e,ae,t),n(e,j,t),n(e,ie,t),u(M,e,t),n(e,oe,t),u(V,e,t),n(e,me,t),n(e,X,t),n(e,de,t),u(G,e,t),n(e,re,t),u(C,e,t),n(e,pe,t),n(e,x,t),n(e,ce,t),n(e,I,t),n(e,fe,t),n(e,B,t),n(e,ue,t),u(S,e,t),n(e,he,t),n(e,Y,t),n(e,ge,t),u(R,e,t),n(e,be,t),n(e,E,t),n(e,we,t),n(e,N,t),n(e,ye,t),n(e,z,t),n(e,Me,t),u(F,e,t),n(e,Ze,t),n(e,Q,t),n(e,ve,t),n(e,L,t),Je=!0},p(e,[t]){const Ye={};t&2&&(Ye.$$scope={dirty:t,ctx:e}),M.$set(Ye)},i(e){Je||(h(w.$$.fragment,e),h(Z.$$.fragment,e),h(_.$$.fragment,e),h(k.$$.fragment,e),h(U.$$.fragment,e),h(M.$$.fragment,e),h(V.$$.fragment,e),h(G.$$.fragment,e),h(C.$$.fragment,e),h(S.$$.fragment,e),h(R.$$.fragment,e),h(F.$$.fragment,e),Je=!0)},o(e){g(w.$$.fragment,e),g(Z.$$.fragment,e),g(_.$$.fragment,e),g(k.$$.fragment,e),g(U.$$.fragment,e),g(M.$$.fragment,e),g(V.$$.fragment,e),g(G.$$.fragment,e),g(C.$$.fragment,e),g(S.$$.fragment,e),g(R.$$.fragment,e),g(F.$$.fragment,e),Je=!1},d(e){e&&(l(r),l(y),l(p),l(P),l(K),l(v),l(A),l(J),l(O),l(T),l(ee),l(te),l(le),l(W),l(ne),l($),l(se),l(ae),l(j),l(ie),l(oe),l(me),l(X),l(de),l(re),l(pe),l(x),l(ce),l(I),l(fe),l(B),l(ue),l(he),l(Y),l(ge),l(be),l(E),l(we),l(N),l(ye),l(z),l(Me),l(Ze),l(Q),l(ve),l(L)),l(d),b(w,e),b(Z,e),b(_,e),b(k,e),b(U,e),b(M,e),b(V,e),b(G,e),b(C,e),b(S,e),b(R,e),b(F,e)}}}const tt='{"title":"Stable Video Diffusion","local":"stable-video-diffusion","sections":[{"title":"Image to Video Generation","local":"image-to-video-generation","sections":[{"title":"Torch.compile","local":"torchcompile","sections":[],"depth":3},{"title":"Low-memory","local":"low-memory","sections":[],"depth":3},{"title":"Micro-conditioning","local":"micro-conditioning","sections":[],"depth":3}],"depth":2}],"depth":1}';function lt(q){return ze(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dt extends Qe{constructor(d){super(),Le(this,d,lt,et,Ne,{})}}export{dt as component};
