# Building an End-to-End MCP Application

Welcome to Unit 2 of the MCP Course! 

In this unit, we'll build a complete MCP application from scratch, focusing on creating a server with Gradio and connecting it with multiple clients. This hands-on approach will give you practical experience with the entire MCP ecosystem.

> [!TIP]
> In this unit, we're going to build a simple MCP server and client using Gradio and the HuggingFace hub. In the next unit, we'll build a more complex server that tackles a real-world use case.

## What You'll Learn

In this unit, you will:

- Create an MCP Server using Gradio's built-in MCP support
- Build a sentiment analysis tool that can be used by AI models
- Connect to the server using different client implementations:
  - A HuggingFace.js-based client
  - A SmolAgents-based client for Python
- Deploy your MCP Server to Hugging Face Spaces
- Test and debug the complete system

By the end of this unit, you'll have a working MCP application that demonstrates the power and flexibility of the protocol.

## Prerequisites

Before proceeding with this unit, make sure you:

- Have completed Unit 1 or have a basic understanding of MCP concepts
- Are comfortable with both Python and JavaScript/TypeScript
- Have a basic understanding of APIs and client-server architecture
- Have a development environment with:
  - Python 3.10+
  - Node.js 18+
  - A Hugging Face account (for deployment)

## Our End-to-End Project

We'll build a sentiment analysis application that consists of three main parts: the server, the client, and the deployment.

![sentiment analysis application](https://huggingface.co/datasets/mcp-course/images/resolve/main/unit2/1.png)

### Server Side

- Uses Gradio to create a web interface and MCP server via `gr.Interface`
- Implements a sentiment analysis tool using TextBlob
- Exposes the tool through both HTTP and MCP protocols

### Client Side

- Implements a HuggingFace.js client
- Or, creates a smolagents Python client
- Demonstrates how to use the same server with different client implementations

### Deployment

- Deploys the server to Hugging Face Spaces
- Configures the clients to work with the deployed server

## Let's Get Started!

Are you ready to build your first end-to-end MCP application? Let's begin by setting up the development environment and creating our Gradio MCP server.

<EditOnGithub source="https://github.com/huggingface/mcp-course/blob/main/units/en/unit2/introduction.mdx" />