import{s as kl,n as bl,o as hl}from"../chunks/scheduler.e4ff9b64.js";import{S as _l,i as Al,e as p,s as a,c as i,h as Cl,a as M,d as s,b as n,f as wl,g as o,j as c,k as fl,l as Bl,m as t,n as j,t as m,o as U,p as T}from"../chunks/index.09f1bca0.js";import{C as $l,H as Ml,E as Il}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.2e1a29f5.js";import{C as il}from"../chunks/CodeBlock.f899176c.js";function Ql(ol){let r,x,Y,N,J,V,y,X,d,cl="<code>LoopSequentialPipelineBlocks</code> 是一种多块类型，它将其他 <code>ModularPipelineBlocks</code> 以循环方式组合在一起。数据循环流动，使用 <code>intermediate_inputs</code> 和 <code>intermediate_outputs</code>，并且每个块都是迭代运行的。这通常用于创建一个默认是迭代的去噪循环。",Z,u,jl="本指南向您展示如何创建 <code>LoopSequentialPipelineBlocks</code>。",L,w,g,f,ml="<code>LoopSequentialPipelineBlocks</code>，也被称为 <em>循环包装器</em>，因为它定义了循环结构、迭代变量和配置。在循环包装器内，您需要以下变量。",H,k,Ul="<li><code>loop_inputs</code> 是用户提供的值，等同于 <code>inputs</code>。</li> <li><code>loop_intermediate_inputs</code> 是来自 <code>PipelineState</code> 的中间变量，等同于 <code>~modular_pipelines.ModularPipelineBlocks.intermediate_inputs</code>。</li> <li><code>loop_intermediate_outputs</code> 是由块创建并添加到 <code>PipelineState</code> 的新中间变量。它等同于 <code>intermediate_outputs</code>。</li> <li><code>__call__</code> 方法定义了循环结构和迭代逻辑。</li>",q,b,O,h,Tl="循环包装器可以传递额外的参数，如当前迭代索引，到循环块。",P,_,F,A,rl="循环块是一个 <code>ModularPipelineBlocks</code>，但 <code>__call__</code> 方法的行为不同。",z,C,Jl="<li>它从循环包装器。</li> <li>它直接与<code>BlockState</code>一起工作，而不是<code>PipelineState</code>。</li> <li>它不需要检索或更新<code>BlockState</code>。</li>",W,B,yl="循环块共享相同的<code>BlockState</code>，以允许值在循环的每次迭代中累积和变化。",D,$,K,I,ll,Q,dl="使用<code>from_blocks_dict()</code>方法将循环块添加到循环包装器中，以创建<code>LoopSequentialPipelineBlocks</code>。",el,E,sl,R,ul="添加更多的循环块以在每次迭代中运行，使用<code>from_blocks_dict()</code>。这允许您在不改变循环逻辑本身的情况下修改块。",tl,G,al,S,nl,v,pl;return J=new $l({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),y=new Ml({props:{title:"LoopSequentialPipelineBlocks",local:"loopsequentialpipelineblocks",headingTag:"h1"}}),w=new Ml({props:{title:"循环包装器",local:"循环包装器",headingTag:"h2"}}),b=new il({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLm1vZHVsYXJfcGlwZWxpbmVzJTIwaW1wb3J0JTIwTG9vcFNlcXVlbnRpYWxQaXBlbGluZUJsb2NrcyUyQyUyME1vZHVsYXJQaXBlbGluZUJsb2NrcyUyQyUyMElucHV0UGFyYW0lMkMlMjBPdXRwdXRQYXJhbSUwQSUwQWNsYXNzJTIwTG9vcFdyYXBwZXIoTG9vcFNlcXVlbnRpYWxQaXBlbGluZUJsb2NrcyklM0ElMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTIwJTNEJTIwJTIydGVzdCUyMiUwQSUyMCUyMCUyMCUyMCU0MHByb3BlcnR5JTBBJTIwJTIwJTIwJTIwZGVmJTIwZGVzY3JpcHRpb24oc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlMjJJJ20lMjBhJTIwbG9vcCEhJTIyJTBBJTIwJTIwJTIwJTIwJTQwcHJvcGVydHklMEElMjAlMjAlMjAlMjBkZWYlMjBsb29wX2lucHV0cyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCU1QklucHV0UGFyYW0obmFtZSUzRCUyMm51bV9zdGVwcyUyMiklNUQlMEElMjAlMjAlMjAlMjAlNDB0b3JjaC5ub19ncmFkKCklMEElMjAlMjAlMjAlMjBkZWYlMjBfX2NhbGxfXyhzZWxmJTJDJTIwY29tcG9uZW50cyUyQyUyMHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX3N0YXRlJTIwJTNEJTIwc2VsZi5nZXRfYmxvY2tfc3RhdGUoc3RhdGUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwJUU1JUJFJUFBJUU3JThFJUFGJUU3JUJCJTkzJUU2JTlFJTg0JTIwLSUyMCVFNSU4RiVBRiVFNCVCQiVBNSVFNiVBMCVCOSVFNiU4RCVBRSVFNiU4MiVBOCVFNyU5QSU4NCVFOSU5QyU4MCVFNiVCMSU4MiVFNSVBRSU5QSVFNSU4OCVCNiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGJsb2NrX3N0YXRlLm51bV9zdGVwcyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBsb29wX3N0ZXAlMjAlRTYlOEMlODklRTklQTElQkElRTUlQkElOEYlRTYlODklQTclRTglQTElOEMlRTYlODklODAlRTYlOUMlODklRTYlQjMlQTglRTUlODYlOEMlRTclOUElODQlRTUlOUQlOTclMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb21wb25lbnRzJTJDJTIwYmxvY2tfc3RhdGUlMjAlM0QlMjBzZWxmLmxvb3Bfc3RlcChjb21wb25lbnRzJTJDJTIwYmxvY2tfc3RhdGUlMkMlMjBpJTNEaSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnNldF9ibG9ja19zdGF0ZShzdGF0ZSUyQyUyMGJsb2NrX3N0YXRlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGNvbXBvbmVudHMlMkMlMjBzdGF0ZQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> LoopSequentialPipelineBlocks, ModularPipelineBlocks, InputParam, OutputParam

<span class="hljs-keyword">class</span> <span class="hljs-title class_">LoopWrapper</span>(<span class="hljs-title class_ inherited__">LoopSequentialPipelineBlocks</span>):
    model_name = <span class="hljs-string">&quot;test&quot;</span>
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">description</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;I&#x27;m a loop!!&quot;</span>
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">loop_inputs</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> [InputParam(name=<span class="hljs-string">&quot;num_steps&quot;</span>)]
<span class="hljs-meta">    @torch.no_grad()</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, components, state</span>):
        block_state = self.get_block_state(state)
        <span class="hljs-comment"># 循环结构 - 可以根据您的需求定制</span>
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(block_state.num_steps):
            <span class="hljs-comment"># loop_step 按顺序执行所有注册的块</span>
            components, block_state = self.loop_step(components, block_state, i=i)
        self.set_block_state(state, block_state)
        <span class="hljs-keyword">return</span> components, state`,wrap:!1}}),_=new Ml({props:{title:"循环块",local:"循环块",headingTag:"h2"}}),$=new il({props:{code:"Y2xhc3MlMjBMb29wQmxvY2soTW9kdWxhclBpcGVsaW5lQmxvY2tzKSUzQSUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWUlMjAlM0QlMjAlMjJ0ZXN0JTIyJTBBJTIwJTIwJTIwJTIwJTQwcHJvcGVydHklMEElMjAlMjAlMjAlMjBkZWYlMjBpbnB1dHMoc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlNUJJbnB1dFBhcmFtKG5hbWUlM0QlMjJ4JTIyKSU1RCUwQSUyMCUyMCUyMCUyMCU0MHByb3BlcnR5JTBBJTIwJTIwJTIwJTIwZGVmJTIwaW50ZXJtZWRpYXRlX291dHB1dHMoc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjAlRTglQkYlOTklRTQlQjglQUElRTUlOUQlOTclRTQlQkElQTclRTclOTQlOUYlRTclOUElODQlRTglQkUlOTMlRTUlODclQkElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlNUJPdXRwdXRQYXJhbShuYW1lJTNEJTIyeCUyMiklNUQlMEElMjAlMjAlMjAlMjAlNDBwcm9wZXJ0eSUwQSUyMCUyMCUyMCUyMGRlZiUyMGRlc2NyaXB0aW9uKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyJUU2JTg4JTkxJUU2JTk4JUFGJUU0JUI4JTgwJUU0JUI4JUFBJUU1JTlDJUE4JTYwTG9vcFdyYXBwZXIlNjAlRTclQjElQkIlRTUlODYlODUlRTklODMlQTglRTQlQkQlQkYlRTclOTQlQTglRTclOUElODQlRTUlOUQlOTclMjIlMEElMjAlMjAlMjAlMjBkZWYlMjBfX2NhbGxfXyhzZWxmJTJDJTIwY29tcG9uZW50cyUyQyUyMGJsb2NrX3N0YXRlJTJDJTIwaSUzQSUyMGludCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19zdGF0ZS54JTIwJTJCJTNEJTIwMSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGNvbXBvbmVudHMlMkMlMjBibG9ja19zdGF0ZQ==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">LoopBlock</span>(<span class="hljs-title class_ inherited__">ModularPipelineBlocks</span>):
    model_name = <span class="hljs-string">&quot;test&quot;</span>
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">inputs</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> [InputParam(name=<span class="hljs-string">&quot;x&quot;</span>)]
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">intermediate_outputs</span>(<span class="hljs-params">self</span>):
        <span class="hljs-comment"># 这个块产生的输出</span>
        <span class="hljs-keyword">return</span> [OutputParam(name=<span class="hljs-string">&quot;x&quot;</span>)]
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">description</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;我是一个在\`LoopWrapper\`类内部使用的块&quot;</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, components, block_state, i: <span class="hljs-built_in">int</span></span>):
        block_state.x += <span class="hljs-number">1</span>
        <span class="hljs-keyword">return</span> components, block_state`,wrap:!1}}),I=new Ml({props:{title:"LoopSequentialPipelineBlocks",local:"loopsequentialpipelineblocks",headingTag:"h2"}}),E=new il({props:{code:"bG9vcCUyMCUzRCUyMExvb3BXcmFwcGVyLmZyb21fYmxvY2tzX2RpY3QoJTdCJTIyYmxvY2sxJTIyJTNBJTIwTG9vcEJsb2NrJTdEKQ==",highlighted:'loop = LoopWrapper.from_blocks_dict({<span class="hljs-string">&quot;block1&quot;</span>: LoopBlock})',wrap:!1}}),G=new il({props:{code:"bG9vcCUyMCUzRCUyMExvb3BXcmFwcGVyLmZyb21fYmxvY2tzX2RpY3QoJTdCJTIyYmxvY2sxJTIyJTNBJTIwTG9vcEJsb2NrKCklMkMlMjAlMjJibG9jazIlMjIlM0ElMjBMb29wQmxvY2slN0Qp",highlighted:'loop = LoopWrapper.from_blocks_dict({<span class="hljs-string">&quot;block1&quot;</span>: LoopBlock(), <span class="hljs-string">&quot;block2&quot;</span>: LoopBlock})',wrap:!1}}),S=new Il({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/zh/modular_diffusers/loop_sequential_pipeline_blocks.md"}}),{c(){r=p("meta"),x=a(),Y=p("p"),N=a(),i(J.$$.fragment),V=a(),i(y.$$.fragment),X=a(),d=p("p"),d.innerHTML=cl,Z=a(),u=p("p"),u.innerHTML=jl,L=a(),i(w.$$.fragment),g=a(),f=p("p"),f.innerHTML=ml,H=a(),k=p("ul"),k.innerHTML=Ul,q=a(),i(b.$$.fragment),O=a(),h=p("p"),h.textContent=Tl,P=a(),i(_.$$.fragment),F=a(),A=p("p"),A.innerHTML=rl,z=a(),C=p("ul"),C.innerHTML=Jl,W=a(),B=p("p"),B.innerHTML=yl,D=a(),i($.$$.fragment),K=a(),i(I.$$.fragment),ll=a(),Q=p("p"),Q.innerHTML=dl,el=a(),i(E.$$.fragment),sl=a(),R=p("p"),R.innerHTML=ul,tl=a(),i(G.$$.fragment),al=a(),i(S.$$.fragment),nl=a(),v=p("p"),this.h()},l(l){const e=Cl("svelte-u9bgzb",document.head);r=M(e,"META",{name:!0,content:!0}),e.forEach(s),x=n(l),Y=M(l,"P",{}),wl(Y).forEach(s),N=n(l),o(J.$$.fragment,l),V=n(l),o(y.$$.fragment,l),X=n(l),d=M(l,"P",{"data-svelte-h":!0}),c(d)!=="svelte-1nq98f"&&(d.innerHTML=cl),Z=n(l),u=M(l,"P",{"data-svelte-h":!0}),c(u)!=="svelte-w57vj0"&&(u.innerHTML=jl),L=n(l),o(w.$$.fragment,l),g=n(l),f=M(l,"P",{"data-svelte-h":!0}),c(f)!=="svelte-dkpdu7"&&(f.innerHTML=ml),H=n(l),k=M(l,"UL",{"data-svelte-h":!0}),c(k)!=="svelte-b3mxxd"&&(k.innerHTML=Ul),q=n(l),o(b.$$.fragment,l),O=n(l),h=M(l,"P",{"data-svelte-h":!0}),c(h)!=="svelte-ei0hxj"&&(h.textContent=Tl),P=n(l),o(_.$$.fragment,l),F=n(l),A=M(l,"P",{"data-svelte-h":!0}),c(A)!=="svelte-1xvtemk"&&(A.innerHTML=rl),z=n(l),C=M(l,"UL",{"data-svelte-h":!0}),c(C)!=="svelte-ncxq9e"&&(C.innerHTML=Jl),W=n(l),B=M(l,"P",{"data-svelte-h":!0}),c(B)!=="svelte-1mh9h4f"&&(B.innerHTML=yl),D=n(l),o($.$$.fragment,l),K=n(l),o(I.$$.fragment,l),ll=n(l),Q=M(l,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-otwhdq"&&(Q.innerHTML=dl),el=n(l),o(E.$$.fragment,l),sl=n(l),R=M(l,"P",{"data-svelte-h":!0}),c(R)!=="svelte-arh6gb"&&(R.innerHTML=ul),tl=n(l),o(G.$$.fragment,l),al=n(l),o(S.$$.fragment,l),nl=n(l),v=M(l,"P",{}),wl(v).forEach(s),this.h()},h(){fl(r,"name","hf:doc:metadata"),fl(r,"content",El)},m(l,e){Bl(document.head,r),t(l,x,e),t(l,Y,e),t(l,N,e),j(J,l,e),t(l,V,e),j(y,l,e),t(l,X,e),t(l,d,e),t(l,Z,e),t(l,u,e),t(l,L,e),j(w,l,e),t(l,g,e),t(l,f,e),t(l,H,e),t(l,k,e),t(l,q,e),j(b,l,e),t(l,O,e),t(l,h,e),t(l,P,e),j(_,l,e),t(l,F,e),t(l,A,e),t(l,z,e),t(l,C,e),t(l,W,e),t(l,B,e),t(l,D,e),j($,l,e),t(l,K,e),j(I,l,e),t(l,ll,e),t(l,Q,e),t(l,el,e),j(E,l,e),t(l,sl,e),t(l,R,e),t(l,tl,e),j(G,l,e),t(l,al,e),j(S,l,e),t(l,nl,e),t(l,v,e),pl=!0},p:bl,i(l){pl||(m(J.$$.fragment,l),m(y.$$.fragment,l),m(w.$$.fragment,l),m(b.$$.fragment,l),m(_.$$.fragment,l),m($.$$.fragment,l),m(I.$$.fragment,l),m(E.$$.fragment,l),m(G.$$.fragment,l),m(S.$$.fragment,l),pl=!0)},o(l){U(J.$$.fragment,l),U(y.$$.fragment,l),U(w.$$.fragment,l),U(b.$$.fragment,l),U(_.$$.fragment,l),U($.$$.fragment,l),U(I.$$.fragment,l),U(E.$$.fragment,l),U(G.$$.fragment,l),U(S.$$.fragment,l),pl=!1},d(l){l&&(s(x),s(Y),s(N),s(V),s(X),s(d),s(Z),s(u),s(L),s(g),s(f),s(H),s(k),s(q),s(O),s(h),s(P),s(F),s(A),s(z),s(C),s(W),s(B),s(D),s(K),s(ll),s(Q),s(el),s(sl),s(R),s(tl),s(al),s(nl),s(v)),s(r),T(J,l),T(y,l),T(w,l),T(b,l),T(_,l),T($,l),T(I,l),T(E,l),T(G,l),T(S,l)}}}const El='{"title":"LoopSequentialPipelineBlocks","local":"loopsequentialpipelineblocks","sections":[{"title":"循环包装器","local":"循环包装器","sections":[],"depth":2},{"title":"循环块","local":"循环块","sections":[],"depth":2},{"title":"LoopSequentialPipelineBlocks","local":"loopsequentialpipelineblocks","sections":[],"depth":2}],"depth":1}';function Rl(ol){return hl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xl extends _l{constructor(r){super(),Al(this,r,Rl,Ql,kl,{})}}export{xl as component};
