# ConsistencyDecoderScheduler

This scheduler is a part of the `ConsistencyDecoderPipeline` and was introduced in [DALL-E 3](https://openai.com/dall-e-3).

The original codebase can be found at [openai/consistency_models](https://github.com/openai/consistency_models).

## ConsistencyDecoderScheduler[[diffusers.schedulers.ConsistencyDecoderScheduler]]
#### diffusers.schedulers.ConsistencyDecoderScheduler[[diffusers.schedulers.ConsistencyDecoderScheduler]]

[Source](https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_consistency_decoder.py#L73)

scale_model_inputdiffusers.schedulers.ConsistencyDecoderScheduler.scale_model_inputhttps://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_consistency_decoder.py#L117[{"name": "sample", "val": ": Tensor"}, {"name": "timestep", "val": ": typing.Optional[int] = None"}]- **sample** (`torch.Tensor`) --
  The input sample.
- **timestep** (`int`, *optional*) --
  The current timestep in the diffusion chain.0`torch.Tensor`A scaled input sample.

Ensures interchangeability with schedulers that need to scale the denoising model input depending on the
current timestep.

**Parameters:**

sample (`torch.Tensor`) : The input sample.

timestep (`int`, *optional*) : The current timestep in the diffusion chain.

**Returns:**

``torch.Tensor``

A scaled input sample.
#### step[[diffusers.schedulers.ConsistencyDecoderScheduler.step]]

[Source](https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_consistency_decoder.py#L134)

Predict the sample from the previous timestep by reversing the SDE. This function propagates the diffusion
process from the learned model outputs (most often the predicted noise).

**Parameters:**

model_output (`torch.Tensor`) : The direct output from the learned diffusion model.

timestep (`float`) : The current timestep in the diffusion chain.

sample (`torch.Tensor`) : A current instance of a sample created by the diffusion process.

generator (`torch.Generator`, *optional*) : A random number generator.

return_dict (`bool`, *optional*, defaults to `True`) : Whether or not to return a `~schedulers.scheduling_consistency_models.ConsistencyDecoderSchedulerOutput` or `tuple`.

**Returns:**

``~schedulers.scheduling_consistency_models.ConsistencyDecoderSchedulerOutput` or `tuple``

If return_dict is `True`,
`~schedulers.scheduling_consistency_models.ConsistencyDecoderSchedulerOutput` is returned, otherwise
a tuple is returned where the first element is the sample tensor.

