import{s as ua,n as ba,o as Ia}from"../chunks/scheduler.53228c21.js";import{S as ga,i as fa,e as p,s as t,c as o,h as Ca,a as M,d as a,b as n,f as da,g as c,j as i,k as I,l as Ba,m as e,n as m,t as j,o as y,p as h}from"../chunks/index.100fac89.js";import{C as Za}from"../chunks/CopyLLMTxtMenu.20a72e0e.js";import{C as r}from"../chunks/CodeBlock.d30a6509.js";import{D as Aa}from"../chunks/DocNotebookDropdown.74a16910.js";import{H as Cs,E as Ga}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.4d82655d.js";function Xa(zl){let w,As,Bs,Gs,g,Xs,f,Ws,C,ks,B,$l='Unconditional image generation is a popular application of diffusion models that generates images that look like those in the dataset used for training. Typically, the best results are obtained from finetuning a pretrained model on a specific dataset. You can find many of these checkpoints on the <a href="https://huggingface.co/search/full-text?q=unconditional-image-generation&amp;type=model" rel="nofollow">Hub</a>, but if you can’t find one you like, you can always train your own!',_s,Z,Ql='This tutorial will teach you how to train a <a href="/docs/diffusers/main/en/api/models/unet2d#diffusers.UNet2DModel">UNet2DModel</a> from scratch on a subset of the <a href="https://huggingface.co/datasets/huggan/smithsonian_butterflies_subset" rel="nofollow">Smithsonian Butterflies</a> dataset to generate your own 🦋 butterflies 🦋.',vs,J,Fl='<p>💡 This training tutorial is based on the <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers/training_example.ipynb" rel="nofollow">Training with 🧨 Diffusers</a> notebook. For additional details and context about diffusion models like how they work, check out the notebook!</p>',Ns,A,Sl='Before you begin, make sure you have 🤗 Datasets installed to load and preprocess image datasets, and 🤗 Accelerate, to simplify training on any number of GPUs. The following command will also install <a href="https://www.tensorflow.org/tensorboard" rel="nofollow">TensorBoard</a> to visualize training metrics (you can also use <a href="https://docs.wandb.ai/" rel="nofollow">Weights &amp; Biases</a> to track your training).',Rs,G,Vs,X,Hl='We encourage you to share your model with the community, and in order to do that, you’ll need to login to your Hugging Face account (create one <a href="https://hf.co/join" rel="nofollow">here</a> if you don’t already have one!). You can login from a notebook and enter your token when prompted. Make sure your token has the write role.',Ys,W,zs,k,El="Or login in from the terminal:",$s,_,Qs,v,xl='Since the model checkpoints are quite large, install <a href="https://git-lfs.com/" rel="nofollow">Git-LFS</a> to version these large files:',Fs,N,Ss,R,Hs,V,Dl="For convenience, create a <code>TrainingConfig</code> class containing the training hyperparameters (feel free to adjust them):",Es,Y,xs,z,Ds,$,ql='You can easily load the <a href="https://huggingface.co/datasets/huggan/smithsonian_butterflies_subset" rel="nofollow">Smithsonian Butterflies</a> dataset with the 🤗 Datasets library:',qs,Q,Ls,T,Ll='<p>💡 You can find additional datasets from the <a href="https://huggingface.co/huggan" rel="nofollow">HugGan Community Event</a> or you can use your own dataset by creating a local <a href="https://huggingface.co/docs/datasets/image_dataset#imagefolder" rel="nofollow"><code>ImageFolder</code></a>. Set <code>config.dataset_name</code> to the repository id of the dataset if it is from the HugGan Community Event, or <code>imagefolder</code> if you’re using your own images.</p>',Ks,F,Kl='🤗 Datasets uses the <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Image" rel="nofollow">Image</a> feature to automatically decode the image data and load it as a <a href="https://pillow.readthedocs.io/en/stable/reference/Image.html" rel="nofollow"><code>PIL.Image</code></a> which we can visualize:',Ps,S,Os,U,Pl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/butterflies_ds.png"/>',sl,H,Ol="The images are all different sizes though, so you’ll need to preprocess them first:",ll,E,sa="<li><code>Resize</code> changes the image size to the one defined in <code>config.image_size</code>.</li> <li><code>RandomHorizontalFlip</code> augments the dataset by randomly mirroring the images.</li> <li><code>Normalize</code> is important to rescale the pixel values into a [-1, 1] range, which is what the model expects.</li>",al,x,el,D,la='Use 🤗 Datasets’ <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.set_transform" rel="nofollow">set_transform</a> method to apply the <code>preprocess</code> function on the fly during training:',tl,q,nl,L,aa='Feel free to visualize the images again to confirm that they’ve been resized. Now you’re ready to wrap the dataset in a <a href="https://pytorch.org/docs/stable/data#torch.utils.data.DataLoader" rel="nofollow">DataLoader</a> for training!',pl,K,Ml,P,il,O,ea='Pretrained models in 🧨 Diffusers are easily created from their model class with the parameters you want. For example, to create a <a href="/docs/diffusers/main/en/api/models/unet2d#diffusers.UNet2DModel">UNet2DModel</a>:',ol,ss,cl,ls,ta="It is often a good idea to quickly check the sample image shape matches the model output shape:",ml,as,jl,es,na="Great! Next, you’ll need a scheduler to add some noise to the image.",yl,ts,hl,ns,pa="The scheduler behaves differently depending on whether you’re using the model for training or inference. During inference, the scheduler generates image from the noise. During training, the scheduler takes a model output - or a sample - from a specific point in the diffusion process and applies noise to the image according to a <em>noise schedule</em> and an <em>update rule</em>.",rl,ps,Ma='Let’s take a look at the <a href="/docs/diffusers/main/en/api/schedulers/ddpm#diffusers.DDPMScheduler">DDPMScheduler</a> and use the <code>add_noise</code> method to add some random noise to the <code>sample_image</code> from before:',wl,Ms,Jl,d,ia='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/noisy_butterfly.png"/>',Tl,is,oa="The training objective of the model is to predict the noise added to the image. The loss at this step can be calculated by:",Ul,os,dl,cs,ul,ms,ca="By now, you have most of the pieces to start training the model and all that’s left is putting everything together.",bl,js,ma="First, you’ll need an optimizer and a learning rate scheduler:",Il,ys,gl,hs,ja='Then, you’ll need a way to evaluate the model. For evaluation, you can use the <a href="/docs/diffusers/main/en/api/pipelines/ddpm#diffusers.DDPMPipeline">DDPMPipeline</a> to generate a batch of sample images and save it as a grid:',fl,rs,Cl,ws,ya="Now you can wrap all these components together in a training loop with 🤗 Accelerate for easy TensorBoard logging, gradient accumulation, and mixed precision training. To upload the model to the Hub, write a function to get your repository name and information and then push it to the Hub.",Bl,u,ha="<p>💡 The training loop below may look intimidating and long, but it’ll be worth it later when you launch your training in just one line of code! If you can’t wait and want to start generating images, feel free to copy and run the code below. You can always come back and examine the training loop more closely later, like when you’re waiting for your model to finish training. 🤗</p>",Zl,Js,Al,Ts,ra='Phew, that was quite a bit of code! But you’re finally ready to launch the training with 🤗 Accelerate’s <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/launchers#accelerate.notebook_launcher" rel="nofollow">notebook_launcher</a> function. Pass the function the training loop, all the training arguments, and the number of processes (you can change this value to the number of GPUs available to you) to use for training:',Gl,Us,Xl,ds,wa="Once training is complete, take a look at the final 🦋 images 🦋 generated by your diffusion model!",Wl,us,kl,b,Ja='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/butterflies_final.png"/>',_l,bs,vl,Is,Ta='Unconditional image generation is one example of a task that can be trained. You can explore other tasks and training techniques by visiting the <a href="../training/overview">🧨 Diffusers Training Examples</a> page. Here are some examples of what you can learn:',Nl,gs,Ua='<li><a href="../training/text_inversion">Textual Inversion</a>, an algorithm that teaches a model a specific visual concept and integrates it into the generated image.</li> <li><a href="../training/dreambooth">DreamBooth</a>, a technique for generating personalized images of a subject given several input images of the subject.</li> <li><a href="../training/text2image">Guide</a> to finetuning a Stable Diffusion model on your own dataset.</li> <li><a href="../training/lora">Guide</a> to using LoRA, a memory-efficient technique for finetuning really large models faster.</li>',Rl,fs,Vl,Zs,Yl;return g=new Za({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),f=new Aa({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/basic_training.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/basic_training.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/basic_training.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/basic_training.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/basic_training.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/basic_training.ipynb"}]}}),C=new Cs({props:{title:"Train a diffusion model",local:"train-a-diffusion-model",headingTag:"h1"}}),G=new r({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwZGlmZnVzZXJzJTVCdHJhaW5pbmclNUQ=",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries in Colab</span>
<span class="hljs-comment">#!pip install diffusers[training]</span>`,wrap:!1}}),W=new r({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),_=new r({props:{code:"aGYlMjBhdXRoJTIwbG9naW4=",highlighted:"hf auth login",wrap:!1}}),N=new r({props:{code:"IXN1ZG8lMjBhcHQlMjAtcXElMjBpbnN0YWxsJTIwZ2l0LWxmcyUwQSFnaXQlMjBjb25maWclMjAtLWdsb2JhbCUyMGNyZWRlbnRpYWwuaGVscGVyJTIwc3RvcmU=",highlighted:`!sudo apt -qq install git-lfs
!git config --global credential.helper store`,wrap:!1}}),R=new Cs({props:{title:"Training configuration",local:"training-configuration",headingTag:"h2"}}),Y=new r({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwZGF0YWNsYXNzJTBBJTBBJTQwZGF0YWNsYXNzJTBBY2xhc3MlMjBUcmFpbmluZ0NvbmZpZyUzQSUwQSUyMCUyMCUyMCUyMGltYWdlX3NpemUlMjAlM0QlMjAxMjglMjAlMjAlMjMlMjB0aGUlMjBnZW5lcmF0ZWQlMjBpbWFnZSUyMHJlc29sdXRpb24lMEElMjAlMjAlMjAlMjB0cmFpbl9iYXRjaF9zaXplJTIwJTNEJTIwMTYlMEElMjAlMjAlMjAlMjBldmFsX2JhdGNoX3NpemUlMjAlM0QlMjAxNiUyMCUyMCUyMyUyMGhvdyUyMG1hbnklMjBpbWFnZXMlMjB0byUyMHNhbXBsZSUyMGR1cmluZyUyMGV2YWx1YXRpb24lMEElMjAlMjAlMjAlMjBudW1fZXBvY2hzJTIwJTNEJTIwNTAlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlMjAlM0QlMjAxJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUyMCUzRCUyMDFlLTQlMEElMjAlMjAlMjAlMjBscl93YXJtdXBfc3RlcHMlMjAlM0QlMjA1MDAlMEElMjAlMjAlMjAlMjBzYXZlX2ltYWdlX2Vwb2NocyUyMCUzRCUyMDEwJTBBJTIwJTIwJTIwJTIwc2F2ZV9tb2RlbF9lcG9jaHMlMjAlM0QlMjAzMCUwQSUyMCUyMCUyMCUyMG1peGVkX3ByZWNpc2lvbiUyMCUzRCUyMCUyMmZwMTYlMjIlMjAlMjAlMjMlMjAlNjBubyU2MCUyMGZvciUyMGZsb2F0MzIlMkMlMjAlNjBmcDE2JTYwJTIwZm9yJTIwYXV0b21hdGljJTIwbWl4ZWQlMjBwcmVjaXNpb24lMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTIwJTNEJTIwJTIyZGRwbS1idXR0ZXJmbGllcy0xMjglMjIlMjAlMjAlMjMlMjB0aGUlMjBtb2RlbCUyMG5hbWUlMjBsb2NhbGx5JTIwYW5kJTIwb24lMjB0aGUlMjBIRiUyMEh1YiUwQSUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTIwJTNEJTIwVHJ1ZSUyMCUyMCUyMyUyMHdoZXRoZXIlMjB0byUyMHVwbG9hZCUyMHRoZSUyMHNhdmVkJTIwbW9kZWwlMjB0byUyMHRoZSUyMEhGJTIwSHViJTBBJTIwJTIwJTIwJTIwaHViX21vZGVsX2lkJTIwJTNEJTIwJTIyJTNDeW91ci11c2VybmFtZSUzRSUyRiUzQ215LWF3ZXNvbWUtbW9kZWwlM0UlMjIlMjAlMjAlMjMlMjB0aGUlMjBuYW1lJTIwb2YlMjB0aGUlMjByZXBvc2l0b3J5JTIwdG8lMjBjcmVhdGUlMjBvbiUyMHRoZSUyMEhGJTIwSHViJTBBJTIwJTIwJTIwJTIwaHViX3ByaXZhdGVfcmVwbyUyMCUzRCUyME5vbmUlMEElMjAlMjAlMjAlMjBvdmVyd3JpdGVfb3V0cHV0X2RpciUyMCUzRCUyMFRydWUlMjAlMjAlMjMlMjBvdmVyd3JpdGUlMjB0aGUlMjBvbGQlMjBtb2RlbCUyMHdoZW4lMjByZS1ydW5uaW5nJTIwdGhlJTIwbm90ZWJvb2slMEElMjAlMjAlMjAlMjBzZWVkJTIwJTNEJTIwMCUwQSUwQSUwQWNvbmZpZyUyMCUzRCUyMFRyYWluaW5nQ29uZmlnKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass

<span class="hljs-meta">&gt;&gt;&gt; </span>@dataclass
<span class="hljs-meta">... </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">TrainingConfig</span>:
<span class="hljs-meta">... </span>    image_size = <span class="hljs-number">128</span>  <span class="hljs-comment"># the generated image resolution</span>
<span class="hljs-meta">... </span>    train_batch_size = <span class="hljs-number">16</span>
<span class="hljs-meta">... </span>    eval_batch_size = <span class="hljs-number">16</span>  <span class="hljs-comment"># how many images to sample during evaluation</span>
<span class="hljs-meta">... </span>    num_epochs = <span class="hljs-number">50</span>
<span class="hljs-meta">... </span>    gradient_accumulation_steps = <span class="hljs-number">1</span>
<span class="hljs-meta">... </span>    learning_rate = <span class="hljs-number">1e-4</span>
<span class="hljs-meta">... </span>    lr_warmup_steps = <span class="hljs-number">500</span>
<span class="hljs-meta">... </span>    save_image_epochs = <span class="hljs-number">10</span>
<span class="hljs-meta">... </span>    save_model_epochs = <span class="hljs-number">30</span>
<span class="hljs-meta">... </span>    mixed_precision = <span class="hljs-string">&quot;fp16&quot;</span>  <span class="hljs-comment"># \`no\` for float32, \`fp16\` for automatic mixed precision</span>
<span class="hljs-meta">... </span>    output_dir = <span class="hljs-string">&quot;ddpm-butterflies-128&quot;</span>  <span class="hljs-comment"># the model name locally and on the HF Hub</span>

<span class="hljs-meta">... </span>    push_to_hub = <span class="hljs-literal">True</span>  <span class="hljs-comment"># whether to upload the saved model to the HF Hub</span>
<span class="hljs-meta">... </span>    hub_model_id = <span class="hljs-string">&quot;&lt;your-username&gt;/&lt;my-awesome-model&gt;&quot;</span>  <span class="hljs-comment"># the name of the repository to create on the HF Hub</span>
<span class="hljs-meta">... </span>    hub_private_repo = <span class="hljs-literal">None</span>
<span class="hljs-meta">... </span>    overwrite_output_dir = <span class="hljs-literal">True</span>  <span class="hljs-comment"># overwrite the old model when re-running the notebook</span>
<span class="hljs-meta">... </span>    seed = <span class="hljs-number">0</span>


<span class="hljs-meta">&gt;&gt;&gt; </span>config = TrainingConfig()`,wrap:!1}}),z=new Cs({props:{title:"Load the dataset",local:"load-the-dataset",headingTag:"h2"}}),Q=new r({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBY29uZmlnLmRhdGFzZXRfbmFtZSUyMCUzRCUyMCUyMmh1Z2dhbiUyRnNtaXRoc29uaWFuX2J1dHRlcmZsaWVzX3N1YnNldCUyMiUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoY29uZmlnLmRhdGFzZXRfbmFtZSUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>config.dataset_name = <span class="hljs-string">&quot;huggan/smithsonian_butterflies_subset&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(config.dataset_name, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),S=new r({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQWZpZyUyQyUyMGF4cyUyMCUzRCUyMHBsdC5zdWJwbG90cygxJTJDJTIwNCUyQyUyMGZpZ3NpemUlM0QoMTYlMkMlMjA0KSklMEFmb3IlMjBpJTJDJTIwaW1hZ2UlMjBpbiUyMGVudW1lcmF0ZShkYXRhc2V0JTVCJTNBNCU1RCU1QiUyMmltYWdlJTIyJTVEKSUzQSUwQSUyMCUyMCUyMCUyMGF4cyU1QmklNUQuaW1zaG93KGltYWdlKSUwQSUyMCUyMCUyMCUyMGF4cyU1QmklNUQuc2V0X2F4aXNfb2ZmKCklMEFmaWcuc2hvdygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span>fig, axs = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, figsize=(<span class="hljs-number">16</span>, <span class="hljs-number">4</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, image <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(dataset[:<span class="hljs-number">4</span>][<span class="hljs-string">&quot;image&quot;</span>]):
<span class="hljs-meta">... </span>    axs[i].imshow(image)
<span class="hljs-meta">... </span>    axs[i].set_axis_off()
<span class="hljs-meta">&gt;&gt;&gt; </span>fig.show()`,wrap:!1}}),x=new r({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uJTIwaW1wb3J0JTIwdHJhbnNmb3JtcyUwQSUwQXByZXByb2Nlc3MlMjAlM0QlMjB0cmFuc2Zvcm1zLkNvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhbnNmb3Jtcy5SZXNpemUoKGNvbmZpZy5pbWFnZV9zaXplJTJDJTIwY29uZmlnLmltYWdlX3NpemUpKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuUmFuZG9tSG9yaXpvbnRhbEZsaXAoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuVG9UZW5zb3IoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuTm9ybWFsaXplKCU1QjAuNSU1RCUyQyUyMCU1QjAuNSU1RCklMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision <span class="hljs-keyword">import</span> transforms

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocess = transforms.Compose(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        transforms.Resize((config.image_size, config.image_size)),
<span class="hljs-meta">... </span>        transforms.RandomHorizontalFlip(),
<span class="hljs-meta">... </span>        transforms.ToTensor(),
<span class="hljs-meta">... </span>        transforms.Normalize([<span class="hljs-number">0.5</span>], [<span class="hljs-number">0.5</span>]),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)`,wrap:!1}}),q=new r({props:{code:"ZGVmJTIwdHJhbnNmb3JtKGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlcyUyMCUzRCUyMCU1QnByZXByb2Nlc3MoaW1hZ2UuY29udmVydCglMjJSR0IlMjIpKSUyMGZvciUyMGltYWdlJTIwaW4lMjBleGFtcGxlcyU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyaW1hZ2VzJTIyJTNBJTIwaW1hZ2VzJTdEJTBBJTBBJTBBZGF0YXNldC5zZXRfdHJhbnNmb3JtKHRyYW5zZm9ybSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">transform</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    images = [preprocess(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;images&quot;</span>: images}


<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.set_transform(transform)`,wrap:!1}}),K=new r({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF0cmFpbl9kYXRhbG9hZGVyJTIwJTNEJTIwdG9yY2gudXRpbHMuZGF0YS5EYXRhTG9hZGVyKGRhdGFzZXQlMkMlMjBiYXRjaF9zaXplJTNEY29uZmlnLnRyYWluX2JhdGNoX3NpemUlMkMlMjBzaHVmZmxlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader = torch.utils.data.DataLoader(dataset, batch_size=config.train_batch_size, shuffle=<span class="hljs-literal">True</span>)`,wrap:!1}}),P=new Cs({props:{title:"Create a UNet2DModel",local:"create-a-unet2dmodel",headingTag:"h2"}}),ss=new r({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = UNet2DModel(
<span class="hljs-meta">... </span>    sample_size=config.image_size,  <span class="hljs-comment"># the target image resolution</span>
<span class="hljs-meta">... </span>    in_channels=<span class="hljs-number">3</span>,  <span class="hljs-comment"># the number of input channels, 3 for RGB images</span>
<span class="hljs-meta">... </span>    out_channels=<span class="hljs-number">3</span>,  <span class="hljs-comment"># the number of output channels</span>
<span class="hljs-meta">... </span>    layers_per_block=<span class="hljs-number">2</span>,  <span class="hljs-comment"># how many ResNet layers to use per UNet block</span>
<span class="hljs-meta">... </span>    block_out_channels=(<span class="hljs-number">128</span>, <span class="hljs-number">128</span>, <span class="hljs-number">256</span>, <span class="hljs-number">256</span>, <span class="hljs-number">512</span>, <span class="hljs-number">512</span>),  <span class="hljs-comment"># the number of output channels for each UNet block</span>
<span class="hljs-meta">... </span>    down_block_types=(
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,  <span class="hljs-comment"># a regular ResNet downsampling block</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;AttnDownBlock2D&quot;</span>,  <span class="hljs-comment"># a ResNet downsampling block with spatial self-attention</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>    up_block_types=(
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,  <span class="hljs-comment"># a regular ResNet upsampling block</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;AttnUpBlock2D&quot;</span>,  <span class="hljs-comment"># a ResNet upsampling block with spatial self-attention</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>)`,wrap:!1}}),as=new r({props:{code:"c2FtcGxlX2ltYWdlJTIwJTNEJTIwZGF0YXNldCU1QjAlNUQlNUIlMjJpbWFnZXMlMjIlNUQudW5zcXVlZXplKDApJTBBcHJpbnQoJTIySW5wdXQlMjBzaGFwZSUzQSUyMiUyQyUyMHNhbXBsZV9pbWFnZS5zaGFwZSklMEElMEFwcmludCglMjJPdXRwdXQlMjBzaGFwZSUzQSUyMiUyQyUyMG1vZGVsKHNhbXBsZV9pbWFnZSUyQyUyMHRpbWVzdGVwJTNEMCkuc2FtcGxlLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>sample_image = dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;images&quot;</span>].unsqueeze(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Input shape:&quot;</span>, sample_image.shape)
Input shape: torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Output shape:&quot;</span>, model(sample_image, timestep=<span class="hljs-number">0</span>).sample.shape)
Output shape: torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>])`,wrap:!1}}),ts=new Cs({props:{title:"Create a scheduler",local:"create-a-scheduler",headingTag:"h2"}}),Ms=new r({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERQTVNjaGVkdWxlciUwQSUwQW5vaXNlX3NjaGVkdWxlciUyMCUzRCUyMEREUE1TY2hlZHVsZXIobnVtX3RyYWluX3RpbWVzdGVwcyUzRDEwMDApJTBBbm9pc2UlMjAlM0QlMjB0b3JjaC5yYW5kbihzYW1wbGVfaW1hZ2Uuc2hhcGUpJTBBdGltZXN0ZXBzJTIwJTNEJTIwdG9yY2guTG9uZ1RlbnNvciglNUI1MCU1RCklMEFub2lzeV9pbWFnZSUyMCUzRCUyMG5vaXNlX3NjaGVkdWxlci5hZGRfbm9pc2Uoc2FtcGxlX2ltYWdlJTJDJTIwbm9pc2UlMkMlMjB0aW1lc3RlcHMpJTBBJTBBSW1hZ2UuZnJvbWFycmF5KCgobm9pc3lfaW1hZ2UucGVybXV0ZSgwJTJDJTIwMiUyQyUyMDMlMkMlMjAxKSUyMCUyQiUyMDEuMCklMjAqJTIwMTI3LjUpLnR5cGUodG9yY2gudWludDgpLm51bXB5KCklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>noise_scheduler = DDPMScheduler(num_train_timesteps=<span class="hljs-number">1000</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>noise = torch.randn(sample_image.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span>timesteps = torch.LongTensor([<span class="hljs-number">50</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>noisy_image = noise_scheduler.add_noise(sample_image, noise, timesteps)

<span class="hljs-meta">&gt;&gt;&gt; </span>Image.fromarray(((noisy_image.permute(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>) + <span class="hljs-number">1.0</span>) * <span class="hljs-number">127.5</span>).<span class="hljs-built_in">type</span>(torch.uint8).numpy()[<span class="hljs-number">0</span>])`,wrap:!1}}),os=new r({props:{code:"aW1wb3J0JTIwdG9yY2gubm4uZnVuY3Rpb25hbCUyMGFzJTIwRiUwQSUwQW5vaXNlX3ByZWQlMjAlM0QlMjBtb2RlbChub2lzeV9pbWFnZSUyQyUyMHRpbWVzdGVwcykuc2FtcGxlJTBBbG9zcyUyMCUzRCUyMEYubXNlX2xvc3Mobm9pc2VfcHJlZCUyQyUyMG5vaXNlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F

<span class="hljs-meta">&gt;&gt;&gt; </span>noise_pred = model(noisy_image, timesteps).sample
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = F.mse_loss(noise_pred, noise)`,wrap:!1}}),cs=new Cs({props:{title:"Train the model",local:"train-the-model",headingTag:"h2"}}),ys=new r({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5vcHRpbWl6YXRpb24lMjBpbXBvcnQlMjBnZXRfY29zaW5lX3NjaGVkdWxlX3dpdGhfd2FybXVwJTBBJTBBb3B0aW1pemVyJTIwJTNEJTIwdG9yY2gub3B0aW0uQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0Rjb25maWcubGVhcm5pbmdfcmF0ZSklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfY29zaW5lX3NjaGVkdWxlX3dpdGhfd2FybXVwKCUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0Rjb25maWcubHJfd2FybXVwX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEKGxlbih0cmFpbl9kYXRhbG9hZGVyKSUyMColMjBjb25maWcubnVtX2Vwb2NocyklMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.optimization <span class="hljs-keyword">import</span> get_cosine_schedule_with_warmup

<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = torch.optim.AdamW(model.parameters(), lr=config.learning_rate)
<span class="hljs-meta">&gt;&gt;&gt; </span>lr_scheduler = get_cosine_schedule_with_warmup(
<span class="hljs-meta">... </span>    optimizer=optimizer,
<span class="hljs-meta">... </span>    num_warmup_steps=config.lr_warmup_steps,
<span class="hljs-meta">... </span>    num_training_steps=(<span class="hljs-built_in">len</span>(train_dataloader) * config.num_epochs),
<span class="hljs-meta">... </span>)`,wrap:!1}}),rs=new r({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1QaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBtYWtlX2ltYWdlX2dyaWQlMEFpbXBvcnQlMjBvcyUwQSUwQWRlZiUyMGV2YWx1YXRlKGNvbmZpZyUyQyUyMGVwb2NoJTJDJTIwcGlwZWxpbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwU2FtcGxlJTIwc29tZSUyMGltYWdlcyUyMGZyb20lMjByYW5kb20lMjBub2lzZSUyMCh0aGlzJTIwaXMlMjB0aGUlMjBiYWNrd2FyZCUyMGRpZmZ1c2lvbiUyMHByb2Nlc3MpLiUwQSUyMCUyMCUyMCUyMCUyMyUyMFRoZSUyMGRlZmF1bHQlMjBwaXBlbGluZSUyMG91dHB1dCUyMHR5cGUlMjBpcyUyMCU2MExpc3QlNUJQSUwuSW1hZ2UlNUQlNjAlMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEY29uZmlnLmV2YWxfYmF0Y2hfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QnY3B1JykubWFudWFsX3NlZWQoY29uZmlnLnNlZWQpJTJDJTIwJTIzJTIwVXNlJTIwYSUyMHNlcGFyYXRlJTIwdG9yY2glMjBnZW5lcmF0b3IlMjB0byUyMGF2b2lkJTIwcmV3aW5kaW5nJTIwdGhlJTIwcmFuZG9tJTIwc3RhdGUlMjBvZiUyMHRoZSUyMG1haW4lMjB0cmFpbmluZyUyMGxvb3AlMEElMjAlMjAlMjAlMjApLmltYWdlcyUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyME1ha2UlMjBhJTIwZ3JpZCUyMG91dCUyMG9mJTIwdGhlJTIwaW1hZ2VzJTBBJTIwJTIwJTIwJTIwaW1hZ2VfZ3JpZCUyMCUzRCUyMG1ha2VfaW1hZ2VfZ3JpZChpbWFnZXMlMkMlMjByb3dzJTNENCUyQyUyMGNvbHMlM0Q0KSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFNhdmUlMjB0aGUlMjBpbWFnZXMlMEElMjAlMjAlMjAlMjB0ZXN0X2RpciUyMCUzRCUyMG9zLnBhdGguam9pbihjb25maWcub3V0cHV0X2RpciUyQyUyMCUyMnNhbXBsZXMlMjIpJTBBJTIwJTIwJTIwJTIwb3MubWFrZWRpcnModGVzdF9kaXIlMkMlMjBleGlzdF9vayUzRFRydWUpJTBBJTIwJTIwJTIwJTIwaW1hZ2VfZ3JpZC5zYXZlKGYlMjIlN0J0ZXN0X2RpciU3RCUyRiU3QmVwb2NoJTNBMDRkJTdELnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">evaluate</span>(<span class="hljs-params">config, epoch, pipeline</span>):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Sample some images from random noise (this is the backward diffusion process).</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># The default pipeline output type is \`List[PIL.Image]\`</span>
<span class="hljs-meta">... </span>    images = pipeline(
<span class="hljs-meta">... </span>        batch_size=config.eval_batch_size,
<span class="hljs-meta">... </span>        generator=torch.Generator(device=<span class="hljs-string">&#x27;cpu&#x27;</span>).manual_seed(config.seed), <span class="hljs-comment"># Use a separate torch generator to avoid rewinding the random state of the main training loop</span>
<span class="hljs-meta">... </span>    ).images

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Make a grid out of the images</span>
<span class="hljs-meta">... </span>    image_grid = make_image_grid(images, rows=<span class="hljs-number">4</span>, cols=<span class="hljs-number">4</span>)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Save the images</span>
<span class="hljs-meta">... </span>    test_dir = os.path.join(config.output_dir, <span class="hljs-string">&quot;samples&quot;</span>)
<span class="hljs-meta">... </span>    os.makedirs(test_dir, exist_ok=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>    image_grid.save(<span class="hljs-string">f&quot;<span class="hljs-subst">{test_dir}</span>/<span class="hljs-subst">{epoch:04d}</span>.png&quot;</span>)`,wrap:!1}}),Js=new r({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_repo, upload_folder
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">train_loop</span>(<span class="hljs-params">config, model, noise_scheduler, optimizer, train_dataloader, lr_scheduler</span>):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Initialize accelerator and tensorboard logging</span>
<span class="hljs-meta">... </span>    accelerator = Accelerator(
<span class="hljs-meta">... </span>        mixed_precision=config.mixed_precision,
<span class="hljs-meta">... </span>        gradient_accumulation_steps=config.gradient_accumulation_steps,
<span class="hljs-meta">... </span>        log_with=<span class="hljs-string">&quot;tensorboard&quot;</span>,
<span class="hljs-meta">... </span>        project_dir=os.path.join(config.output_dir, <span class="hljs-string">&quot;logs&quot;</span>),
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> accelerator.is_main_process:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> config.output_dir <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
<span class="hljs-meta">... </span>            os.makedirs(config.output_dir, exist_ok=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> config.push_to_hub:
<span class="hljs-meta">... </span>            repo_id = create_repo(
<span class="hljs-meta">... </span>                repo_id=config.hub_model_id <span class="hljs-keyword">or</span> Path(config.output_dir).name, exist_ok=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>            ).repo_id
<span class="hljs-meta">... </span>        accelerator.init_trackers(<span class="hljs-string">&quot;train_example&quot;</span>)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Prepare everything</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># There is no specific order to remember, you just need to unpack the</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># objects in the same order you gave them to the prepare method.</span>
<span class="hljs-meta">... </span>    model, optimizer, train_dataloader, lr_scheduler = accelerator.prepare(
<span class="hljs-meta">... </span>        model, optimizer, train_dataloader, lr_scheduler
<span class="hljs-meta">... </span>    )

<span class="hljs-meta">... </span>    global_step = <span class="hljs-number">0</span>

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Now you train the model</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(config.num_epochs):
<span class="hljs-meta">... </span>        progress_bar = tqdm(total=<span class="hljs-built_in">len</span>(train_dataloader), disable=<span class="hljs-keyword">not</span> accelerator.is_local_main_process)
<span class="hljs-meta">... </span>        progress_bar.set_description(<span class="hljs-string">f&quot;Epoch <span class="hljs-subst">{epoch}</span>&quot;</span>)

<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(train_dataloader):
<span class="hljs-meta">... </span>            clean_images = batch[<span class="hljs-string">&quot;images&quot;</span>]
<span class="hljs-meta">... </span>            <span class="hljs-comment"># Sample noise to add to the images</span>
<span class="hljs-meta">... </span>            noise = torch.randn(clean_images.shape, device=clean_images.device)
<span class="hljs-meta">... </span>            bs = clean_images.shape[<span class="hljs-number">0</span>]

<span class="hljs-meta">... </span>            <span class="hljs-comment"># Sample a random timestep for each image</span>
<span class="hljs-meta">... </span>            timesteps = torch.randint(
<span class="hljs-meta">... </span>                <span class="hljs-number">0</span>, noise_scheduler.config.num_train_timesteps, (bs,), device=clean_images.device,
<span class="hljs-meta">... </span>                dtype=torch.int64
<span class="hljs-meta">... </span>            )

<span class="hljs-meta">... </span>            <span class="hljs-comment"># Add noise to the clean images according to the noise magnitude at each timestep</span>
<span class="hljs-meta">... </span>            <span class="hljs-comment"># (this is the forward diffusion process)</span>
<span class="hljs-meta">... </span>            noisy_images = noise_scheduler.add_noise(clean_images, noise, timesteps)

<span class="hljs-meta">... </span>            <span class="hljs-keyword">with</span> accelerator.accumulate(model):
<span class="hljs-meta">... </span>                <span class="hljs-comment"># Predict the noise residual</span>
<span class="hljs-meta">... </span>                noise_pred = model(noisy_images, timesteps, return_dict=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>                loss = F.mse_loss(noise_pred, noise)
<span class="hljs-meta">... </span>                accelerator.backward(loss)

<span class="hljs-meta">... </span>                <span class="hljs-keyword">if</span> accelerator.sync_gradients:
<span class="hljs-meta">... </span>                    accelerator.clip_grad_norm_(model.parameters(), <span class="hljs-number">1.0</span>)
<span class="hljs-meta">... </span>                optimizer.step()
<span class="hljs-meta">... </span>                lr_scheduler.step()
<span class="hljs-meta">... </span>                optimizer.zero_grad()

<span class="hljs-meta">... </span>            progress_bar.update(<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>            logs = {<span class="hljs-string">&quot;loss&quot;</span>: loss.detach().item(), <span class="hljs-string">&quot;lr&quot;</span>: lr_scheduler.get_last_lr()[<span class="hljs-number">0</span>], <span class="hljs-string">&quot;step&quot;</span>: global_step}
<span class="hljs-meta">... </span>            progress_bar.set_postfix(**logs)
<span class="hljs-meta">... </span>            accelerator.log(logs, step=global_step)
<span class="hljs-meta">... </span>            global_step += <span class="hljs-number">1</span>

<span class="hljs-meta">... </span>        <span class="hljs-comment"># After each epoch you optionally sample some demo images with evaluate() and save the model</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> accelerator.is_main_process:
<span class="hljs-meta">... </span>            pipeline = DDPMPipeline(unet=accelerator.unwrap_model(model), scheduler=noise_scheduler)

<span class="hljs-meta">... </span>            <span class="hljs-keyword">if</span> (epoch + <span class="hljs-number">1</span>) % config.save_image_epochs == <span class="hljs-number">0</span> <span class="hljs-keyword">or</span> epoch == config.num_epochs - <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>                evaluate(config, epoch, pipeline)

<span class="hljs-meta">... </span>            <span class="hljs-keyword">if</span> (epoch + <span class="hljs-number">1</span>) % config.save_model_epochs == <span class="hljs-number">0</span> <span class="hljs-keyword">or</span> epoch == config.num_epochs - <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>                <span class="hljs-keyword">if</span> config.push_to_hub:
<span class="hljs-meta">... </span>                    upload_folder(
<span class="hljs-meta">... </span>                        repo_id=repo_id,
<span class="hljs-meta">... </span>                        folder_path=config.output_dir,
<span class="hljs-meta">... </span>                        commit_message=<span class="hljs-string">f&quot;Epoch <span class="hljs-subst">{epoch}</span>&quot;</span>,
<span class="hljs-meta">... </span>                        ignore_patterns=[<span class="hljs-string">&quot;step_*&quot;</span>, <span class="hljs-string">&quot;epoch_*&quot;</span>],
<span class="hljs-meta">... </span>                    )
<span class="hljs-meta">... </span>                <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>                    pipeline.save_pretrained(config.output_dir)`,wrap:!1}}),Us=new r({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQWFyZ3MlMjAlM0QlMjAoY29uZmlnJTJDJTIwbW9kZWwlMkMlMjBub2lzZV9zY2hlZHVsZXIlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwbHJfc2NoZWR1bGVyKSUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluX2xvb3AlMkMlMjBhcmdzJTJDJTIwbnVtX3Byb2Nlc3NlcyUzRDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

<span class="hljs-meta">&gt;&gt;&gt; </span>args = (config, model, noise_scheduler, optimizer, train_dataloader, lr_scheduler)

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_launcher(train_loop, args, num_processes=<span class="hljs-number">1</span>)`,wrap:!1}}),us=new r({props:{code:"aW1wb3J0JTIwZ2xvYiUwQSUwQXNhbXBsZV9pbWFnZXMlMjAlM0QlMjBzb3J0ZWQoZ2xvYi5nbG9iKGYlMjIlN0Jjb25maWcub3V0cHV0X2RpciU3RCUyRnNhbXBsZXMlMkYqLnBuZyUyMikpJTBBSW1hZ2Uub3BlbihzYW1wbGVfaW1hZ2VzJTVCLTElNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> glob

<span class="hljs-meta">&gt;&gt;&gt; </span>sample_images = <span class="hljs-built_in">sorted</span>(glob.glob(<span class="hljs-string">f&quot;<span class="hljs-subst">{config.output_dir}</span>/samples/*.png&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>Image.<span class="hljs-built_in">open</span>(sample_images[-<span class="hljs-number">1</span>])`,wrap:!1}}),bs=new Cs({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),fs=new Ga({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/tutorials/basic_training.md"}}),{c(){w=p("meta"),As=t(),Bs=p("p"),Gs=t(),o(g.$$.fragment),Xs=t(),o(f.$$.fragment),Ws=t(),o(C.$$.fragment),ks=t(),B=p("p"),B.innerHTML=$l,_s=t(),Z=p("p"),Z.innerHTML=Ql,vs=t(),J=p("blockquote"),J.innerHTML=Fl,Ns=t(),A=p("p"),A.innerHTML=Sl,Rs=t(),o(G.$$.fragment),Vs=t(),X=p("p"),X.innerHTML=Hl,Ys=t(),o(W.$$.fragment),zs=t(),k=p("p"),k.textContent=El,$s=t(),o(_.$$.fragment),Qs=t(),v=p("p"),v.innerHTML=xl,Fs=t(),o(N.$$.fragment),Ss=t(),o(R.$$.fragment),Hs=t(),V=p("p"),V.innerHTML=Dl,Es=t(),o(Y.$$.fragment),xs=t(),o(z.$$.fragment),Ds=t(),$=p("p"),$.innerHTML=ql,qs=t(),o(Q.$$.fragment),Ls=t(),T=p("blockquote"),T.innerHTML=Ll,Ks=t(),F=p("p"),F.innerHTML=Kl,Ps=t(),o(S.$$.fragment),Os=t(),U=p("div"),U.innerHTML=Pl,sl=t(),H=p("p"),H.textContent=Ol,ll=t(),E=p("ul"),E.innerHTML=sa,al=t(),o(x.$$.fragment),el=t(),D=p("p"),D.innerHTML=la,tl=t(),o(q.$$.fragment),nl=t(),L=p("p"),L.innerHTML=aa,pl=t(),o(K.$$.fragment),Ml=t(),o(P.$$.fragment),il=t(),O=p("p"),O.innerHTML=ea,ol=t(),o(ss.$$.fragment),cl=t(),ls=p("p"),ls.textContent=ta,ml=t(),o(as.$$.fragment),jl=t(),es=p("p"),es.textContent=na,yl=t(),o(ts.$$.fragment),hl=t(),ns=p("p"),ns.innerHTML=pa,rl=t(),ps=p("p"),ps.innerHTML=Ma,wl=t(),o(Ms.$$.fragment),Jl=t(),d=p("div"),d.innerHTML=ia,Tl=t(),is=p("p"),is.textContent=oa,Ul=t(),o(os.$$.fragment),dl=t(),o(cs.$$.fragment),ul=t(),ms=p("p"),ms.textContent=ca,bl=t(),js=p("p"),js.textContent=ma,Il=t(),o(ys.$$.fragment),gl=t(),hs=p("p"),hs.innerHTML=ja,fl=t(),o(rs.$$.fragment),Cl=t(),ws=p("p"),ws.textContent=ya,Bl=t(),u=p("blockquote"),u.innerHTML=ha,Zl=t(),o(Js.$$.fragment),Al=t(),Ts=p("p"),Ts.innerHTML=ra,Gl=t(),o(Us.$$.fragment),Xl=t(),ds=p("p"),ds.textContent=wa,Wl=t(),o(us.$$.fragment),kl=t(),b=p("div"),b.innerHTML=Ja,_l=t(),o(bs.$$.fragment),vl=t(),Is=p("p"),Is.innerHTML=Ta,Nl=t(),gs=p("ul"),gs.innerHTML=Ua,Rl=t(),o(fs.$$.fragment),Vl=t(),Zs=p("p"),this.h()},l(s){const l=Ca("svelte-u9bgzb",document.head);w=M(l,"META",{name:!0,content:!0}),l.forEach(a),As=n(s),Bs=M(s,"P",{}),da(Bs).forEach(a),Gs=n(s),c(g.$$.fragment,s),Xs=n(s),c(f.$$.fragment,s),Ws=n(s),c(C.$$.fragment,s),ks=n(s),B=M(s,"P",{"data-svelte-h":!0}),i(B)!=="svelte-tdss46"&&(B.innerHTML=$l),_s=n(s),Z=M(s,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-ex8ldy"&&(Z.innerHTML=Ql),vs=n(s),J=M(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(J)!=="svelte-1w20s3"&&(J.innerHTML=Fl),Ns=n(s),A=M(s,"P",{"data-svelte-h":!0}),i(A)!=="svelte-x3q6hl"&&(A.innerHTML=Sl),Rs=n(s),c(G.$$.fragment,s),Vs=n(s),X=M(s,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1c8cv44"&&(X.innerHTML=Hl),Ys=n(s),c(W.$$.fragment,s),zs=n(s),k=M(s,"P",{"data-svelte-h":!0}),i(k)!=="svelte-17henro"&&(k.textContent=El),$s=n(s),c(_.$$.fragment,s),Qs=n(s),v=M(s,"P",{"data-svelte-h":!0}),i(v)!=="svelte-sz5qnh"&&(v.innerHTML=xl),Fs=n(s),c(N.$$.fragment,s),Ss=n(s),c(R.$$.fragment,s),Hs=n(s),V=M(s,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1otxl74"&&(V.innerHTML=Dl),Es=n(s),c(Y.$$.fragment,s),xs=n(s),c(z.$$.fragment,s),Ds=n(s),$=M(s,"P",{"data-svelte-h":!0}),i($)!=="svelte-1wj8hyv"&&($.innerHTML=ql),qs=n(s),c(Q.$$.fragment,s),Ls=n(s),T=M(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(T)!=="svelte-14m0c1d"&&(T.innerHTML=Ll),Ks=n(s),F=M(s,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1bh16eq"&&(F.innerHTML=Kl),Ps=n(s),c(S.$$.fragment,s),Os=n(s),U=M(s,"DIV",{class:!0,"data-svelte-h":!0}),i(U)!=="svelte-1wjbouq"&&(U.innerHTML=Pl),sl=n(s),H=M(s,"P",{"data-svelte-h":!0}),i(H)!=="svelte-19lli6v"&&(H.textContent=Ol),ll=n(s),E=M(s,"UL",{"data-svelte-h":!0}),i(E)!=="svelte-8oirkq"&&(E.innerHTML=sa),al=n(s),c(x.$$.fragment,s),el=n(s),D=M(s,"P",{"data-svelte-h":!0}),i(D)!=="svelte-a1cdro"&&(D.innerHTML=la),tl=n(s),c(q.$$.fragment,s),nl=n(s),L=M(s,"P",{"data-svelte-h":!0}),i(L)!=="svelte-1abv18u"&&(L.innerHTML=aa),pl=n(s),c(K.$$.fragment,s),Ml=n(s),c(P.$$.fragment,s),il=n(s),O=M(s,"P",{"data-svelte-h":!0}),i(O)!=="svelte-mlq3qn"&&(O.innerHTML=ea),ol=n(s),c(ss.$$.fragment,s),cl=n(s),ls=M(s,"P",{"data-svelte-h":!0}),i(ls)!=="svelte-ahjyed"&&(ls.textContent=ta),ml=n(s),c(as.$$.fragment,s),jl=n(s),es=M(s,"P",{"data-svelte-h":!0}),i(es)!=="svelte-1hkhok8"&&(es.textContent=na),yl=n(s),c(ts.$$.fragment,s),hl=n(s),ns=M(s,"P",{"data-svelte-h":!0}),i(ns)!=="svelte-31qoa1"&&(ns.innerHTML=pa),rl=n(s),ps=M(s,"P",{"data-svelte-h":!0}),i(ps)!=="svelte-1mnclmh"&&(ps.innerHTML=Ma),wl=n(s),c(Ms.$$.fragment,s),Jl=n(s),d=M(s,"DIV",{class:!0,"data-svelte-h":!0}),i(d)!=="svelte-qcxk5"&&(d.innerHTML=ia),Tl=n(s),is=M(s,"P",{"data-svelte-h":!0}),i(is)!=="svelte-1pekxga"&&(is.textContent=oa),Ul=n(s),c(os.$$.fragment,s),dl=n(s),c(cs.$$.fragment,s),ul=n(s),ms=M(s,"P",{"data-svelte-h":!0}),i(ms)!=="svelte-rpu9md"&&(ms.textContent=ca),bl=n(s),js=M(s,"P",{"data-svelte-h":!0}),i(js)!=="svelte-11y5cd5"&&(js.textContent=ma),Il=n(s),c(ys.$$.fragment,s),gl=n(s),hs=M(s,"P",{"data-svelte-h":!0}),i(hs)!=="svelte-1iidvjh"&&(hs.innerHTML=ja),fl=n(s),c(rs.$$.fragment,s),Cl=n(s),ws=M(s,"P",{"data-svelte-h":!0}),i(ws)!=="svelte-13pvon6"&&(ws.textContent=ya),Bl=n(s),u=M(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(u)!=="svelte-yn0cgh"&&(u.innerHTML=ha),Zl=n(s),c(Js.$$.fragment,s),Al=n(s),Ts=M(s,"P",{"data-svelte-h":!0}),i(Ts)!=="svelte-1f597mr"&&(Ts.innerHTML=ra),Gl=n(s),c(Us.$$.fragment,s),Xl=n(s),ds=M(s,"P",{"data-svelte-h":!0}),i(ds)!=="svelte-nz3dg5"&&(ds.textContent=wa),Wl=n(s),c(us.$$.fragment,s),kl=n(s),b=M(s,"DIV",{class:!0,"data-svelte-h":!0}),i(b)!=="svelte-tzqtub"&&(b.innerHTML=Ja),_l=n(s),c(bs.$$.fragment,s),vl=n(s),Is=M(s,"P",{"data-svelte-h":!0}),i(Is)!=="svelte-zg9981"&&(Is.innerHTML=Ta),Nl=n(s),gs=M(s,"UL",{"data-svelte-h":!0}),i(gs)!=="svelte-cndhdw"&&(gs.innerHTML=Ua),Rl=n(s),c(fs.$$.fragment,s),Vl=n(s),Zs=M(s,"P",{}),da(Zs).forEach(a),this.h()},h(){I(w,"name","hf:doc:metadata"),I(w,"content",Wa),I(J,"class","tip"),I(T,"class","tip"),I(U,"class","flex justify-center"),I(d,"class","flex justify-center"),I(u,"class","tip"),I(b,"class","flex justify-center")},m(s,l){Ba(document.head,w),e(s,As,l),e(s,Bs,l),e(s,Gs,l),m(g,s,l),e(s,Xs,l),m(f,s,l),e(s,Ws,l),m(C,s,l),e(s,ks,l),e(s,B,l),e(s,_s,l),e(s,Z,l),e(s,vs,l),e(s,J,l),e(s,Ns,l),e(s,A,l),e(s,Rs,l),m(G,s,l),e(s,Vs,l),e(s,X,l),e(s,Ys,l),m(W,s,l),e(s,zs,l),e(s,k,l),e(s,$s,l),m(_,s,l),e(s,Qs,l),e(s,v,l),e(s,Fs,l),m(N,s,l),e(s,Ss,l),m(R,s,l),e(s,Hs,l),e(s,V,l),e(s,Es,l),m(Y,s,l),e(s,xs,l),m(z,s,l),e(s,Ds,l),e(s,$,l),e(s,qs,l),m(Q,s,l),e(s,Ls,l),e(s,T,l),e(s,Ks,l),e(s,F,l),e(s,Ps,l),m(S,s,l),e(s,Os,l),e(s,U,l),e(s,sl,l),e(s,H,l),e(s,ll,l),e(s,E,l),e(s,al,l),m(x,s,l),e(s,el,l),e(s,D,l),e(s,tl,l),m(q,s,l),e(s,nl,l),e(s,L,l),e(s,pl,l),m(K,s,l),e(s,Ml,l),m(P,s,l),e(s,il,l),e(s,O,l),e(s,ol,l),m(ss,s,l),e(s,cl,l),e(s,ls,l),e(s,ml,l),m(as,s,l),e(s,jl,l),e(s,es,l),e(s,yl,l),m(ts,s,l),e(s,hl,l),e(s,ns,l),e(s,rl,l),e(s,ps,l),e(s,wl,l),m(Ms,s,l),e(s,Jl,l),e(s,d,l),e(s,Tl,l),e(s,is,l),e(s,Ul,l),m(os,s,l),e(s,dl,l),m(cs,s,l),e(s,ul,l),e(s,ms,l),e(s,bl,l),e(s,js,l),e(s,Il,l),m(ys,s,l),e(s,gl,l),e(s,hs,l),e(s,fl,l),m(rs,s,l),e(s,Cl,l),e(s,ws,l),e(s,Bl,l),e(s,u,l),e(s,Zl,l),m(Js,s,l),e(s,Al,l),e(s,Ts,l),e(s,Gl,l),m(Us,s,l),e(s,Xl,l),e(s,ds,l),e(s,Wl,l),m(us,s,l),e(s,kl,l),e(s,b,l),e(s,_l,l),m(bs,s,l),e(s,vl,l),e(s,Is,l),e(s,Nl,l),e(s,gs,l),e(s,Rl,l),m(fs,s,l),e(s,Vl,l),e(s,Zs,l),Yl=!0},p:ba,i(s){Yl||(j(g.$$.fragment,s),j(f.$$.fragment,s),j(C.$$.fragment,s),j(G.$$.fragment,s),j(W.$$.fragment,s),j(_.$$.fragment,s),j(N.$$.fragment,s),j(R.$$.fragment,s),j(Y.$$.fragment,s),j(z.$$.fragment,s),j(Q.$$.fragment,s),j(S.$$.fragment,s),j(x.$$.fragment,s),j(q.$$.fragment,s),j(K.$$.fragment,s),j(P.$$.fragment,s),j(ss.$$.fragment,s),j(as.$$.fragment,s),j(ts.$$.fragment,s),j(Ms.$$.fragment,s),j(os.$$.fragment,s),j(cs.$$.fragment,s),j(ys.$$.fragment,s),j(rs.$$.fragment,s),j(Js.$$.fragment,s),j(Us.$$.fragment,s),j(us.$$.fragment,s),j(bs.$$.fragment,s),j(fs.$$.fragment,s),Yl=!0)},o(s){y(g.$$.fragment,s),y(f.$$.fragment,s),y(C.$$.fragment,s),y(G.$$.fragment,s),y(W.$$.fragment,s),y(_.$$.fragment,s),y(N.$$.fragment,s),y(R.$$.fragment,s),y(Y.$$.fragment,s),y(z.$$.fragment,s),y(Q.$$.fragment,s),y(S.$$.fragment,s),y(x.$$.fragment,s),y(q.$$.fragment,s),y(K.$$.fragment,s),y(P.$$.fragment,s),y(ss.$$.fragment,s),y(as.$$.fragment,s),y(ts.$$.fragment,s),y(Ms.$$.fragment,s),y(os.$$.fragment,s),y(cs.$$.fragment,s),y(ys.$$.fragment,s),y(rs.$$.fragment,s),y(Js.$$.fragment,s),y(Us.$$.fragment,s),y(us.$$.fragment,s),y(bs.$$.fragment,s),y(fs.$$.fragment,s),Yl=!1},d(s){s&&(a(As),a(Bs),a(Gs),a(Xs),a(Ws),a(ks),a(B),a(_s),a(Z),a(vs),a(J),a(Ns),a(A),a(Rs),a(Vs),a(X),a(Ys),a(zs),a(k),a($s),a(Qs),a(v),a(Fs),a(Ss),a(Hs),a(V),a(Es),a(xs),a(Ds),a($),a(qs),a(Ls),a(T),a(Ks),a(F),a(Ps),a(Os),a(U),a(sl),a(H),a(ll),a(E),a(al),a(el),a(D),a(tl),a(nl),a(L),a(pl),a(Ml),a(il),a(O),a(ol),a(cl),a(ls),a(ml),a(jl),a(es),a(yl),a(hl),a(ns),a(rl),a(ps),a(wl),a(Jl),a(d),a(Tl),a(is),a(Ul),a(dl),a(ul),a(ms),a(bl),a(js),a(Il),a(gl),a(hs),a(fl),a(Cl),a(ws),a(Bl),a(u),a(Zl),a(Al),a(Ts),a(Gl),a(Xl),a(ds),a(Wl),a(kl),a(b),a(_l),a(vl),a(Is),a(Nl),a(gs),a(Rl),a(Vl),a(Zs)),a(w),h(g,s),h(f,s),h(C,s),h(G,s),h(W,s),h(_,s),h(N,s),h(R,s),h(Y,s),h(z,s),h(Q,s),h(S,s),h(x,s),h(q,s),h(K,s),h(P,s),h(ss,s),h(as,s),h(ts,s),h(Ms,s),h(os,s),h(cs,s),h(ys,s),h(rs,s),h(Js,s),h(Us,s),h(us,s),h(bs,s),h(fs,s)}}}const Wa='{"title":"Train a diffusion model","local":"train-a-diffusion-model","sections":[{"title":"Training configuration","local":"training-configuration","sections":[],"depth":2},{"title":"Load the dataset","local":"load-the-dataset","sections":[],"depth":2},{"title":"Create a UNet2DModel","local":"create-a-unet2dmodel","sections":[],"depth":2},{"title":"Create a scheduler","local":"create-a-scheduler","sections":[],"depth":2},{"title":"Train the model","local":"train-the-model","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function ka(zl){return Ia(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class za extends ga{constructor(w){super(),fa(this,w,ka,Xa,ua,{})}}export{za as component};
