import{s as It,n as Rt,o as Gt}from"../chunks/scheduler.53228c21.js";import{S as Bt,i as Ht,e as s,s as n,c as p,h as Vt,a as r,d as l,b as i,f as Xt,g as m,j as o,k as me,l as Et,m as a,n as c,t as u,o as f,p as d}from"../chunks/index.100fac89.js";import{C as Nt}from"../chunks/CopyLLMTxtMenu.20a72e0e.js";import{C as h}from"../chunks/CodeBlock.d30a6509.js";import{H as ce,E as Ft}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.4d82655d.js";function Qt(st){let M,ue,oe,fe,w,de,_,he,T,rt='The <a href="https://hf.co/papers/2306.00637" rel="nofollow">Wuerstchen</a> model drastically reduces computational costs by compressing the latent space by 42x, without compromising image quality and accelerating inference. During training, Wuerstchen uses two models (VQGAN + autoencoder) to compress the latents, and then a third model (text-conditioned latent diffusion model) is conditioned on this highly compressed space to generate an image.',Me,J,ot="To fit the prior model into GPU memory and to speedup training, try enabling <code>gradient_accumulation_steps</code>, <code>gradient_checkpointing</code>, and <code>mixed_precision</code> respectively.",ye,U,pt='This guide explores the <a href="https://github.com/huggingface/diffusers/blob/main/examples/wuerstchen/text_to_image/train_text_to_image_prior.py" rel="nofollow">train_text_to_image_prior.py</a> script to help you become more familiar with it, and how you can adapt it for your own use-case.',be,j,mt="Before running the script, make sure you install the library from source:",ge,x,we,$,ct="Then navigate to the example folder containing the training script and install the required dependencies for the script you’re using:",_e,Z,Te,y,ut='<p>🤗 Accelerate is a library for helping you train on multiple GPUs/TPUs or with mixed-precision. It’ll automatically configure your training setup based on your hardware and environment. Take a look at the 🤗 Accelerate <a href="https://huggingface.co/docs/accelerate/quicktour" rel="nofollow">Quick tour</a> to learn more.</p>',Je,W,ft="Initialize an 🤗 Accelerate environment:",Ue,C,je,v,dt="To setup a default 🤗 Accelerate environment without choosing any configurations:",xe,k,$e,X,ht="Or if your environment doesn’t support an interactive shell, like a notebook, you can use:",Ze,I,We,R,Mt='Lastly, if you want to train a model on your own dataset, take a look at the <a href="create_dataset">Create a dataset for training</a> guide to learn how to create a dataset that works with the training script.',Ce,b,yt='<p>The following sections highlight parts of the training scripts that are important for understanding how to modify it, but it doesn’t cover every aspect of the <a href="https://github.com/huggingface/diffusers/blob/main/examples/wuerstchen/text_to_image/train_text_to_image_prior.py" rel="nofollow">script</a> in detail. If you’re interested in learning more, feel free to read through the scripts and let us know if you have any questions or concerns.</p>',ve,G,ke,B,bt='The training scripts provides many parameters to help you customize your training run. All of the parameters and their descriptions are found in the <a href="https://github.com/huggingface/diffusers/blob/6e68c71503682c8693cb5b06a4da4911dfd655ee/examples/wuerstchen/text_to_image/train_text_to_image_prior.py#L192" rel="nofollow"><code>parse_args()</code></a> function. It provides default values for each parameter, such as the training batch size and learning rate, but you can also set your own values in the training command if you’d like.',Xe,H,gt="For example, to speedup training with mixed precision using the fp16 format, add the <code>--mixed_precision</code> parameter to the training command:",Ie,V,Re,E,wt='Most of the parameters are identical to the parameters in the <a href="text2image#script-parameters">Text-to-image</a> training guide, so let’s dive right into the Wuerstchen training script!',Ge,N,Be,F,_t='The training script is also similar to the <a href="text2image#training-script">Text-to-image</a> training guide, but it’s been modified to support Wuerstchen. This guide focuses on the code that is unique to the Wuerstchen training script.',He,Q,Tt='The <a href="https://github.com/huggingface/diffusers/blob/6e68c71503682c8693cb5b06a4da4911dfd655ee/examples/wuerstchen/text_to_image/train_text_to_image_prior.py#L441" rel="nofollow"><code>main()</code></a> function starts by initializing the image encoder - an <a href="https://github.com/huggingface/diffusers/blob/main/examples/wuerstchen/text_to_image/modeling_efficient_net_encoder.py" rel="nofollow">EfficientNet</a> - in addition to the usual scheduler and tokenizer.',Ve,Y,Ee,A,Jt="You’ll also load the <code>WuerstchenPrior</code> model for optimization.",Ne,L,Fe,S,Ut='Next, you’ll apply some <a href="https://github.com/huggingface/diffusers/blob/65ef7a0c5c594b4f84092e328fbdd73183613b30/examples/wuerstchen/text_to_image/train_text_to_image_prior.py#L656" rel="nofollow">transforms</a> to the images and <a href="https://github.com/huggingface/diffusers/blob/65ef7a0c5c594b4f84092e328fbdd73183613b30/examples/wuerstchen/text_to_image/train_text_to_image_prior.py#L637" rel="nofollow">tokenize</a> the captions:',Qe,z,Ye,q,jt='Finally, the <a href="https://github.com/huggingface/diffusers/blob/65ef7a0c5c594b4f84092e328fbdd73183613b30/examples/wuerstchen/text_to_image/train_text_to_image_prior.py#L656" rel="nofollow">training loop</a> handles compressing the images to latent space with the <code>EfficientNetEncoder</code>, adding noise to the latents, and predicting the noise residual with the <code>WuerstchenPrior</code> model.',Ae,P,Le,D,xt='If you want to learn more about how the training loop works, check out the <a href="../using-diffusers/write_own_pipeline">Understanding pipelines, models and schedulers</a> tutorial which breaks down the basic pattern of the denoising process.',Se,K,ze,O,$t="Once you’ve made all your changes or you’re okay with the default configuration, you’re ready to launch the training script! 🚀",qe,ee,Zt='Set the <code>DATASET_NAME</code> environment variable to the dataset name from the Hub. This guide uses the <a href="https://huggingface.co/datasets/lambdalabs/naruto-blip-captions" rel="nofollow">Naruto BLIP captions</a> dataset, but you can create and train on your own datasets as well (see the <a href="create_dataset">Create a dataset for training</a> guide).',Pe,g,Wt="<p>To monitor training progress with Weights &amp; Biases, add the <code>--report_to=wandb</code> parameter to the training command. You’ll also need to add the <code>--validation_prompt</code> to the training command to keep track of results. This can be really useful for debugging the model and viewing intermediate results.</p>",De,te,Ke,le,Ct="Once training is complete, you can use your newly trained model for inference!",Oe,ae,et,ne,tt,ie,vt="Congratulations on training a Wuerstchen model! To learn more about how to use your new model, the following may be helpful:",lt,se,kt='<li>Take a look at the <a href="../api/pipelines/wuerstchen#text-to-image-generation">Wuerstchen</a> API documentation to learn more about how to use the pipeline for text-to-image generation and its limitations.</li>',at,re,nt,pe,it;return w=new Nt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),_=new ce({props:{title:"Wuerstchen",local:"wuerstchen",headingTag:"h1"}}),x=new h({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUwQWNkJTIwZGlmZnVzZXJzJTBBcGlwJTIwaW5zdGFsbCUyMC4=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/huggingface/diffusers
<span class="hljs-built_in">cd</span> diffusers
pip install .`,wrap:!1}}),Z=new h({props:{code:"Y2QlMjBleGFtcGxlcyUyRnd1ZXJzdGNoZW4lMkZ0ZXh0X3RvX2ltYWdlJTBBcGlwJTIwaW5zdGFsbCUyMC1yJTIwcmVxdWlyZW1lbnRzLnR4dA==",highlighted:`<span class="hljs-built_in">cd</span> examples/wuerstchen/text_to_image
pip install -r requirements.txt`,wrap:!1}}),C=new h({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),k=new h({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMGRlZmF1bHQ=",highlighted:"accelerate config default",wrap:!1}}),I=new h({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjB3cml0ZV9iYXNpY19jb25maWclMEElMEF3cml0ZV9iYXNpY19jb25maWcoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> write_basic_config

write_basic_config()`,wrap:!1}}),G=new ce({props:{title:"Script parameters",local:"script-parameters",headingTag:"h2"}}),V=new h({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX3RleHRfdG9faW1hZ2VfcHJpb3IucHklMjAlNUMlMEElMjAlMjAtLW1peGVkX3ByZWNpc2lvbiUzRCUyMmZwMTYlMjI=",highlighted:`accelerate launch train_text_to_image_prior.py \\
  --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span>`,wrap:!1}}),N=new ce({props:{title:"Training script",local:"training-script",headingTag:"h2"}}),Y=new h({props:{code:"d2l0aCUyMENvbnRleHRNYW5hZ2VycyhkZWVwc3BlZWRfemVyb19pbml0X2Rpc2FibGVkX2NvbnRleHRfbWFuYWdlcigpKSUzQSUwQSUyMCUyMCUyMCUyMHByZXRyYWluZWRfY2hlY2twb2ludF9maWxlJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKCUyMmRvbWUyNzIlMkZ3dWVyc3RjaGVuJTIyJTJDJTIwZmlsZW5hbWUlM0QlMjJtb2RlbF92Ml9zdGFnZV9iLnB0JTIyKSUwQSUyMCUyMCUyMCUyMHN0YXRlX2RpY3QlMjAlM0QlMjB0b3JjaC5sb2FkKHByZXRyYWluZWRfY2hlY2twb2ludF9maWxlJTJDJTIwbWFwX2xvY2F0aW9uJTNEJTIyY3B1JTIyKSUwQSUyMCUyMCUyMCUyMGltYWdlX2VuY29kZXIlMjAlM0QlMjBFZmZpY2llbnROZXRFbmNvZGVyKCklMEElMjAlMjAlMjAlMjBpbWFnZV9lbmNvZGVyLmxvYWRfc3RhdGVfZGljdChzdGF0ZV9kaWN0JTVCJTIyZWZmbmV0X3N0YXRlX2RpY3QlMjIlNUQpJTBBJTIwJTIwJTIwJTIwaW1hZ2VfZW5jb2Rlci5ldmFsKCk=",highlighted:`<span class="hljs-keyword">with</span> ContextManagers(deepspeed_zero_init_disabled_context_manager()):
    pretrained_checkpoint_file = hf_hub_download(<span class="hljs-string">&quot;dome272/wuerstchen&quot;</span>, filename=<span class="hljs-string">&quot;model_v2_stage_b.pt&quot;</span>)
    state_dict = torch.load(pretrained_checkpoint_file, map_location=<span class="hljs-string">&quot;cpu&quot;</span>)
    image_encoder = EfficientNetEncoder()
    image_encoder.load_state_dict(state_dict[<span class="hljs-string">&quot;effnet_state_dict&quot;</span>])
    image_encoder.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),L=new h({props:{code:"cHJpb3IlMjAlM0QlMjBXdWVyc3RjaGVuUHJpb3IuZnJvbV9wcmV0cmFpbmVkKGFyZ3MucHJldHJhaW5lZF9wcmlvcl9tb2RlbF9uYW1lX29yX3BhdGglMkMlMjBzdWJmb2xkZXIlM0QlMjJwcmlvciUyMiklMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjBvcHRpbWl6ZXJfY2xzKCUwQSUyMCUyMCUyMCUyMHByaW9yLnBhcmFtZXRlcnMoKSUyQyUwQSUyMCUyMCUyMCUyMGxyJTNEYXJncy5sZWFybmluZ19yYXRlJTJDJTBBJTIwJTIwJTIwJTIwYmV0YXMlM0QoYXJncy5hZGFtX2JldGExJTJDJTIwYXJncy5hZGFtX2JldGEyKSUyQyUwQSUyMCUyMCUyMCUyMHdlaWdodF9kZWNheSUzRGFyZ3MuYWRhbV93ZWlnaHRfZGVjYXklMkMlMEElMjAlMjAlMjAlMjBlcHMlM0RhcmdzLmFkYW1fZXBzaWxvbiUyQyUwQSk=",highlighted:`prior = WuerstchenPrior.from_pretrained(args.pretrained_prior_model_name_or_path, subfolder=<span class="hljs-string">&quot;prior&quot;</span>)

optimizer = optimizer_cls(
    prior.parameters(),
    lr=args.learning_rate,
    betas=(args.adam_beta1, args.adam_beta2),
    weight_decay=args.adam_weight_decay,
    eps=args.adam_epsilon,
)`,wrap:!1}}),z=new h({props:{code:"ZGVmJTIwcHJlcHJvY2Vzc190cmFpbihleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjAlNUJpbWFnZS5jb252ZXJ0KCUyMlJHQiUyMiklMjBmb3IlMjBpbWFnZSUyMGluJTIwZXhhbXBsZXMlNUJpbWFnZV9jb2x1bW4lNUQlNUQlMEElMjAlMjAlMjAlMjBleGFtcGxlcyU1QiUyMmVmZm5ldF9waXhlbF92YWx1ZXMlMjIlNUQlMjAlM0QlMjAlNUJlZmZuZXRfdHJhbnNmb3JtcyhpbWFnZSklMjBmb3IlMjBpbWFnZSUyMGluJTIwaW1hZ2VzJTVEJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlNUIlMjJ0ZXh0X2lucHV0X2lkcyUyMiU1RCUyQyUyMGV4YW1wbGVzJTVCJTIydGV4dF9tYXNrJTIyJTVEJTIwJTNEJTIwdG9rZW5pemVfY2FwdGlvbnMoZXhhbXBsZXMpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_train</span>(<span class="hljs-params">examples</span>):
    images = [image.convert(<span class="hljs-string">&quot;RGB&quot;</span>) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> examples[image_column]]
    examples[<span class="hljs-string">&quot;effnet_pixel_values&quot;</span>] = [effnet_transforms(image) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> images]
    examples[<span class="hljs-string">&quot;text_input_ids&quot;</span>], examples[<span class="hljs-string">&quot;text_mask&quot;</span>] = tokenize_captions(examples)
    <span class="hljs-keyword">return</span> examples`,wrap:!1}}),P=new h({props:{code:"cHJlZF9ub2lzZSUyMCUzRCUyMHByaW9yKG5vaXN5X2xhdGVudHMlMkMlMjB0aW1lc3RlcHMlMkMlMjBwcm9tcHRfZW1iZWRzKQ==",highlighted:"pred_noise = prior(noisy_latents, timesteps, prompt_embeds)",wrap:!1}}),K=new ce({props:{title:"Launch the script",local:"launch-the-script",headingTag:"h2"}}),te=new h({props:{code:"ZXhwb3J0JTIwREFUQVNFVF9OQU1FJTNEJTIybGFtYmRhbGFicyUyRm5hcnV0by1ibGlwLWNhcHRpb25zJTIyJTBBJTBBYWNjZWxlcmF0ZSUyMGxhdW5jaCUyMCUyMHRyYWluX3RleHRfdG9faW1hZ2VfcHJpb3IucHklMjAlNUMlMEElMjAlMjAtLW1peGVkX3ByZWNpc2lvbiUzRCUyMmZwMTYlMjIlMjAlNUMlMEElMjAlMjAtLWRhdGFzZXRfbmFtZSUzRCUyNERBVEFTRVRfTkFNRSUyMCU1QyUwQSUyMCUyMC0tcmVzb2x1dGlvbiUzRDc2OCUyMCU1QyUwQSUyMCUyMC0tdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMjAlNUMlMEElMjAlMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDQlMjAlNUMlMEElMjAlMjAtLWdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjAlNUMlMEElMjAlMjAtLWRhdGFsb2FkZXJfbnVtX3dvcmtlcnMlM0Q0JTIwJTVDJTBBJTIwJTIwLS1tYXhfdHJhaW5fc3RlcHMlM0QxNTAwMCUyMCU1QyUwQSUyMCUyMC0tbGVhcm5pbmdfcmF0ZSUzRDFlLTA1JTIwJTVDJTBBJTIwJTIwLS1tYXhfZ3JhZF9ub3JtJTNEMSUyMCU1QyUwQSUyMCUyMC0tY2hlY2twb2ludHNfdG90YWxfbGltaXQlM0QzJTIwJTVDJTBBJTIwJTIwLS1scl9zY2hlZHVsZXIlM0QlMjJjb25zdGFudCUyMiUyMCU1QyUwQSUyMCUyMC0tbHJfd2FybXVwX3N0ZXBzJTNEMCUyMCU1QyUwQSUyMCUyMC0tdmFsaWRhdGlvbl9wcm9tcHRzJTNEJTIyQSUyMHJvYm90JTIwbmFydXRvJTJDJTIwNGslMjBwaG90byUyMiUyMCU1QyUwQSUyMCUyMC0tcmVwb3J0X3RvJTNEJTIyd2FuZGIlMjIlMjAlNUMlMEElMjAlMjAtLXB1c2hfdG9faHViJTIwJTVDJTBBJTIwJTIwLS1vdXRwdXRfZGlyJTNEJTIyd3VlcnN0Y2hlbi1wcmlvci1uYXJ1dG8tbW9kZWwlMjI=",highlighted:`<span class="hljs-built_in">export</span> DATASET_NAME=<span class="hljs-string">&quot;lambdalabs/naruto-blip-captions&quot;</span>

accelerate launch  train_text_to_image_prior.py \\
  --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span> \\
  --dataset_name=<span class="hljs-variable">$DATASET_NAME</span> \\
  --resolution=768 \\
  --train_batch_size=4 \\
  --gradient_accumulation_steps=4 \\
  --gradient_checkpointing \\
  --dataloader_num_workers=4 \\
  --max_train_steps=15000 \\
  --learning_rate=1e-05 \\
  --max_grad_norm=1 \\
  --checkpoints_total_limit=3 \\
  --lr_scheduler=<span class="hljs-string">&quot;constant&quot;</span> \\
  --lr_warmup_steps=0 \\
  --validation_prompts=<span class="hljs-string">&quot;A robot naruto, 4k photo&quot;</span> \\
  --report_to=<span class="hljs-string">&quot;wandb&quot;</span> \\
  --push_to_hub \\
  --output_dir=<span class="hljs-string">&quot;wuerstchen-prior-naruto-model&quot;</span>`,wrap:!1}}),ae=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUwQWZyb20lMjBkaWZmdXNlcnMucGlwZWxpbmVzLnd1ZXJzdGNoZW4lMjBpbXBvcnQlMjBERUZBVUxUX1NUQUdFX0NfVElNRVNURVBTJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMjJwYXRoJTJGdG8lMkZzYXZlZCUyRm1vZGVsJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KS50byglMjJjdWRhJTIyKSUwQSUwQWNhcHRpb24lMjAlM0QlMjAlMjJBJTIwY3V0ZSUyMGJpcmQlMjBuYXJ1dG8lMjBob2xkaW5nJTIwYSUyMHNoaWVsZCUyMiUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMGNhcHRpb24lMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0QxNTM2JTJDJTBBJTIwJTIwJTIwJTIwcHJpb3JfdGltZXN0ZXBzJTNEREVGQVVMVF9TVEFHRV9DX1RJTUVTVEVQUyUyQyUwQSUyMCUyMCUyMCUyMHByaW9yX2d1aWRhbmNlX3NjYWxlJTNENC4wJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2ltYWdlc19wZXJfcHJvbXB0JTNEMiUyQyUwQSkuaW1hZ2Vz",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">from</span> diffusers.pipelines.wuerstchen <span class="hljs-keyword">import</span> DEFAULT_STAGE_C_TIMESTEPS

pipeline = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;path/to/saved/model&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

caption = <span class="hljs-string">&quot;A cute bird naruto holding a shield&quot;</span>
images = pipeline(
    caption,
    width=<span class="hljs-number">1024</span>,
    height=<span class="hljs-number">1536</span>,
    prior_timesteps=DEFAULT_STAGE_C_TIMESTEPS,
    prior_guidance_scale=<span class="hljs-number">4.0</span>,
    num_images_per_prompt=<span class="hljs-number">2</span>,
).images`,wrap:!1}}),ne=new ce({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),re=new Ft({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/training/wuerstchen.md"}}),{c(){M=s("meta"),ue=n(),oe=s("p"),fe=n(),p(w.$$.fragment),de=n(),p(_.$$.fragment),he=n(),T=s("p"),T.innerHTML=rt,Me=n(),J=s("p"),J.innerHTML=ot,ye=n(),U=s("p"),U.innerHTML=pt,be=n(),j=s("p"),j.textContent=mt,ge=n(),p(x.$$.fragment),we=n(),$=s("p"),$.textContent=ct,_e=n(),p(Z.$$.fragment),Te=n(),y=s("blockquote"),y.innerHTML=ut,Je=n(),W=s("p"),W.textContent=ft,Ue=n(),p(C.$$.fragment),je=n(),v=s("p"),v.textContent=dt,xe=n(),p(k.$$.fragment),$e=n(),X=s("p"),X.textContent=ht,Ze=n(),p(I.$$.fragment),We=n(),R=s("p"),R.innerHTML=Mt,Ce=n(),b=s("blockquote"),b.innerHTML=yt,ve=n(),p(G.$$.fragment),ke=n(),B=s("p"),B.innerHTML=bt,Xe=n(),H=s("p"),H.innerHTML=gt,Ie=n(),p(V.$$.fragment),Re=n(),E=s("p"),E.innerHTML=wt,Ge=n(),p(N.$$.fragment),Be=n(),F=s("p"),F.innerHTML=_t,He=n(),Q=s("p"),Q.innerHTML=Tt,Ve=n(),p(Y.$$.fragment),Ee=n(),A=s("p"),A.innerHTML=Jt,Ne=n(),p(L.$$.fragment),Fe=n(),S=s("p"),S.innerHTML=Ut,Qe=n(),p(z.$$.fragment),Ye=n(),q=s("p"),q.innerHTML=jt,Ae=n(),p(P.$$.fragment),Le=n(),D=s("p"),D.innerHTML=xt,Se=n(),p(K.$$.fragment),ze=n(),O=s("p"),O.textContent=$t,qe=n(),ee=s("p"),ee.innerHTML=Zt,Pe=n(),g=s("blockquote"),g.innerHTML=Wt,De=n(),p(te.$$.fragment),Ke=n(),le=s("p"),le.textContent=Ct,Oe=n(),p(ae.$$.fragment),et=n(),p(ne.$$.fragment),tt=n(),ie=s("p"),ie.textContent=vt,lt=n(),se=s("ul"),se.innerHTML=kt,at=n(),p(re.$$.fragment),nt=n(),pe=s("p"),this.h()},l(e){const t=Vt("svelte-u9bgzb",document.head);M=r(t,"META",{name:!0,content:!0}),t.forEach(l),ue=i(e),oe=r(e,"P",{}),Xt(oe).forEach(l),fe=i(e),m(w.$$.fragment,e),de=i(e),m(_.$$.fragment,e),he=i(e),T=r(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-i7ckto"&&(T.innerHTML=rt),Me=i(e),J=r(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1ogrf3c"&&(J.innerHTML=ot),ye=i(e),U=r(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-19e0b6t"&&(U.innerHTML=pt),be=i(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-l7dm2q"&&(j.textContent=mt),ge=i(e),m(x.$$.fragment,e),we=i(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-z4z0b9"&&($.textContent=ct),_e=i(e),m(Z.$$.fragment,e),Te=i(e),y=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(y)!=="svelte-1in84qc"&&(y.innerHTML=ut),Je=i(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-60q53m"&&(W.textContent=ft),Ue=i(e),m(C.$$.fragment,e),je=i(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-di6juu"&&(v.textContent=dt),xe=i(e),m(k.$$.fragment,e),$e=i(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-tsz4qp"&&(X.textContent=ht),Ze=i(e),m(I.$$.fragment,e),We=i(e),R=r(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1fkfdql"&&(R.innerHTML=Mt),Ce=i(e),b=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-1kgaigt"&&(b.innerHTML=yt),ve=i(e),m(G.$$.fragment,e),ke=i(e),B=r(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-5hssf5"&&(B.innerHTML=bt),Xe=i(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1r0bv1x"&&(H.innerHTML=gt),Ie=i(e),m(V.$$.fragment,e),Re=i(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-94nkgl"&&(E.innerHTML=wt),Ge=i(e),m(N.$$.fragment,e),Be=i(e),F=r(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1qezx8a"&&(F.innerHTML=_t),He=i(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1dwkzrk"&&(Q.innerHTML=Tt),Ve=i(e),m(Y.$$.fragment,e),Ee=i(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1q4frxg"&&(A.innerHTML=Jt),Ne=i(e),m(L.$$.fragment,e),Fe=i(e),S=r(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-hccx6h"&&(S.innerHTML=Ut),Qe=i(e),m(z.$$.fragment,e),Ye=i(e),q=r(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1mgnmwn"&&(q.innerHTML=jt),Ae=i(e),m(P.$$.fragment,e),Le=i(e),D=r(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-6gmbd2"&&(D.innerHTML=xt),Se=i(e),m(K.$$.fragment,e),ze=i(e),O=r(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-9dei1q"&&(O.textContent=$t),qe=i(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-csbhgn"&&(ee.innerHTML=Zt),Pe=i(e),g=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(g)!=="svelte-rxdmtb"&&(g.innerHTML=Wt),De=i(e),m(te.$$.fragment,e),Ke=i(e),le=r(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1x6in5t"&&(le.textContent=Ct),Oe=i(e),m(ae.$$.fragment,e),et=i(e),m(ne.$$.fragment,e),tt=i(e),ie=r(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-1o0am8e"&&(ie.textContent=vt),lt=i(e),se=r(e,"UL",{"data-svelte-h":!0}),o(se)!=="svelte-m7qkni"&&(se.innerHTML=kt),at=i(e),m(re.$$.fragment,e),nt=i(e),pe=r(e,"P",{}),Xt(pe).forEach(l),this.h()},h(){me(M,"name","hf:doc:metadata"),me(M,"content",Yt),me(y,"class","tip"),me(b,"class","tip"),me(g,"class","tip")},m(e,t){Et(document.head,M),a(e,ue,t),a(e,oe,t),a(e,fe,t),c(w,e,t),a(e,de,t),c(_,e,t),a(e,he,t),a(e,T,t),a(e,Me,t),a(e,J,t),a(e,ye,t),a(e,U,t),a(e,be,t),a(e,j,t),a(e,ge,t),c(x,e,t),a(e,we,t),a(e,$,t),a(e,_e,t),c(Z,e,t),a(e,Te,t),a(e,y,t),a(e,Je,t),a(e,W,t),a(e,Ue,t),c(C,e,t),a(e,je,t),a(e,v,t),a(e,xe,t),c(k,e,t),a(e,$e,t),a(e,X,t),a(e,Ze,t),c(I,e,t),a(e,We,t),a(e,R,t),a(e,Ce,t),a(e,b,t),a(e,ve,t),c(G,e,t),a(e,ke,t),a(e,B,t),a(e,Xe,t),a(e,H,t),a(e,Ie,t),c(V,e,t),a(e,Re,t),a(e,E,t),a(e,Ge,t),c(N,e,t),a(e,Be,t),a(e,F,t),a(e,He,t),a(e,Q,t),a(e,Ve,t),c(Y,e,t),a(e,Ee,t),a(e,A,t),a(e,Ne,t),c(L,e,t),a(e,Fe,t),a(e,S,t),a(e,Qe,t),c(z,e,t),a(e,Ye,t),a(e,q,t),a(e,Ae,t),c(P,e,t),a(e,Le,t),a(e,D,t),a(e,Se,t),c(K,e,t),a(e,ze,t),a(e,O,t),a(e,qe,t),a(e,ee,t),a(e,Pe,t),a(e,g,t),a(e,De,t),c(te,e,t),a(e,Ke,t),a(e,le,t),a(e,Oe,t),c(ae,e,t),a(e,et,t),c(ne,e,t),a(e,tt,t),a(e,ie,t),a(e,lt,t),a(e,se,t),a(e,at,t),c(re,e,t),a(e,nt,t),a(e,pe,t),it=!0},p:Rt,i(e){it||(u(w.$$.fragment,e),u(_.$$.fragment,e),u(x.$$.fragment,e),u(Z.$$.fragment,e),u(C.$$.fragment,e),u(k.$$.fragment,e),u(I.$$.fragment,e),u(G.$$.fragment,e),u(V.$$.fragment,e),u(N.$$.fragment,e),u(Y.$$.fragment,e),u(L.$$.fragment,e),u(z.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(ne.$$.fragment,e),u(re.$$.fragment,e),it=!0)},o(e){f(w.$$.fragment,e),f(_.$$.fragment,e),f(x.$$.fragment,e),f(Z.$$.fragment,e),f(C.$$.fragment,e),f(k.$$.fragment,e),f(I.$$.fragment,e),f(G.$$.fragment,e),f(V.$$.fragment,e),f(N.$$.fragment,e),f(Y.$$.fragment,e),f(L.$$.fragment,e),f(z.$$.fragment,e),f(P.$$.fragment,e),f(K.$$.fragment,e),f(te.$$.fragment,e),f(ae.$$.fragment,e),f(ne.$$.fragment,e),f(re.$$.fragment,e),it=!1},d(e){e&&(l(ue),l(oe),l(fe),l(de),l(he),l(T),l(Me),l(J),l(ye),l(U),l(be),l(j),l(ge),l(we),l($),l(_e),l(Te),l(y),l(Je),l(W),l(Ue),l(je),l(v),l(xe),l($e),l(X),l(Ze),l(We),l(R),l(Ce),l(b),l(ve),l(ke),l(B),l(Xe),l(H),l(Ie),l(Re),l(E),l(Ge),l(Be),l(F),l(He),l(Q),l(Ve),l(Ee),l(A),l(Ne),l(Fe),l(S),l(Qe),l(Ye),l(q),l(Ae),l(Le),l(D),l(Se),l(ze),l(O),l(qe),l(ee),l(Pe),l(g),l(De),l(Ke),l(le),l(Oe),l(et),l(tt),l(ie),l(lt),l(se),l(at),l(nt),l(pe)),l(M),d(w,e),d(_,e),d(x,e),d(Z,e),d(C,e),d(k,e),d(I,e),d(G,e),d(V,e),d(N,e),d(Y,e),d(L,e),d(z,e),d(P,e),d(K,e),d(te,e),d(ae,e),d(ne,e),d(re,e)}}}const Yt='{"title":"Wuerstchen","local":"wuerstchen","sections":[{"title":"Script parameters","local":"script-parameters","sections":[],"depth":2},{"title":"Training script","local":"training-script","sections":[],"depth":2},{"title":"Launch the script","local":"launch-the-script","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function At(st){return Gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Dt extends Bt{constructor(M){super(),Ht(this,M,At,Qt,It,{})}}export{Dt as component};
