import{s as ft,n as ht,o as Tt}from"../chunks/scheduler.53228c21.js";import{S as bt,i as jt,e as i,s as a,c as r,h as Ut,a as p,d as t,b as n,f as wt,g as c,j as o,k as El,l as Zt,m as s,n as M,t as m,o as d,p as y}from"../chunks/index.100fac89.js";import{C as gt}from"../chunks/CopyLLMTxtMenu.20a72e0e.js";import{C as J}from"../chunks/CodeBlock.d30a6509.js";import{H as h,E as It}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.4d82655d.js";function Ct($l){let u,Ie,Ze,Ce,T,Be,b,_e,j,Nl="Distributed inference splits the workload across multiple GPUs. It a useful technique for fitting larger models in memory and can process multiple prompts for higher throughput.",ve,U,Rl='This guide will show you how to use <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate</a> and <a href="https://pytorch.org/tutorials/beginner/dist_overview.html" rel="nofollow">PyTorch Distributed</a> for distributed inference.',ke,Z,Ge,g,Al="Accelerate is a library designed to simplify inference and training on multiple accelerators by handling the setup, allowing users to focus on their PyTorch code.",We,I,xl="Install Accelerate with the following command.",Xe,C,Ee,B,Ql='Initialize a <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/state#accelerate.PartialState" rel="nofollow">accelerate.PartialState</a> class in a Python file to create a distributed environment. The <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/state#accelerate.PartialState" rel="nofollow">accelerate.PartialState</a> class manages process management, device control and distribution, and process coordination.',$e,_,Hl='Move the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to <code>accelerate.PartialState.device</code> to assign a GPU to each process.',Ne,v,Re,k,Vl='Use the <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/state#accelerate.PartialState.split_between_processes" rel="nofollow">split_between_processes</a> utility as a context manager to automatically distribute the prompts between the number of processes.',Ae,G,xe,W,Yl="Call <code>accelerate launch</code> to run the script and use the <code>--num_processes</code> argument to set the number of GPUs to use.",Qe,X,He,w,Sl='<p>Refer to this minimal example <a href="https://gist.github.com/sayakpaul/cfaebd221820d7b43fae638b4dfa01ba" rel="nofollow">script</a> for running inference across multiple GPUs. To learn more, take a look at the <a href="https://huggingface.co/docs/accelerate/en/usage_guides/distributed_inference#distributed-inference-with-accelerate" rel="nofollow">Distributed Inference with 🤗 Accelerate</a> guide.</p>',Ve,E,Ye,$,zl='PyTorch <a href="https://pytorch.org/docs/stable/generated/torch.nn.parallel.DistributedDataParallel.html" rel="nofollow">DistributedDataParallel</a> enables <a href="https://huggingface.co/spaces/nanotron/ultrascale-playbook?section=data_parallelism" rel="nofollow">data parallelism</a>, which replicates the same model on each device, to process different batches of data in parallel.',Se,N,Fl="Import <code>torch.distributed</code> and <code>torch.multiprocessing</code> into a Python file to set up the distributed process group and to spawn the processes for inference on each GPU.",ze,R,Fe,A,Pl='Create a function for inference with <a href="https://pytorch.org/docs/stable/distributed.html?highlight=init_process_group#torch.distributed.init_process_group" rel="nofollow">init_process_group</a>. This method creates a distributed environment with the backend type, the <code>rank</code> of the current process, and the <code>world_size</code> or number of processes participating (for example, 2 GPUs would be <code>world_size=2</code>).',Pe,x,Ll="Move the pipeline to <code>rank</code> and use <code>get_rank</code> to assign a GPU to each process. Each process handles a different prompt.",Le,Q,qe,H,ql='Use <a href="https://pytorch.org/docs/stable/multiprocessing.html#torch.multiprocessing.spawn" rel="nofollow">mp.spawn</a> to create the number of processes defined in <code>world_size</code>.',De,V,Ke,Y,Dl="Call <code>torchrun</code> to run the inference script and use the <code>--nproc_per_node</code> argument to set the number of GPUs to use.",Oe,S,el,z,ll,F,Kl="The <code>device_map</code> argument enables distributed inference by automatically placing model components on separate GPUs. This is especially useful when a model doesn’t fit on a single GPU. You can use <code>device_map</code> to selectively load and unload the required model components at a given stage as shown in the example below (assumes two GPUs are available).",tl,P,Ol="Set <code>device_map=&quot;balanced&quot;</code> to evenly distributes the text encoders on all available GPUs. You can use the <code>max_memory</code> argument to allocate a maximum amount of memory for each text encoder. Don’t load any other pipeline components to avoid memory usage.",sl,L,al,q,et="After the text embeddings are computed, remove them from the GPU to make space for the diffusion transformer.",nl,D,il,K,lt="Set <code>device_map=&quot;auto&quot;</code> to automatically distribute the model on the two GPUs. This strategy places a model on the fastest device first before placing a model on a slower device like a CPU or hard drive if needed. The trade-off of storing model parameters on slower devices is slower inference latency.",pl,O,ol,f,tt="<p>Run <code>pipeline.hf_device_map</code> to see how the various models are distributed across devices. This is useful for tracking model device placement. You can also call <code>hf_device_map</code> on the transformer model to see how it is distributed.</p>",rl,ee,st="Add the transformer model to the pipeline and set the <code>output_type=&quot;latent&quot;</code> to generate the latents.",cl,le,Ml,te,at="Remove the pipeline and transformer from memory and load a VAE to decode the latents. The VAE is typically small enough to be loaded on a single device.",ml,se,dl,ae,nt="By selectively loading and unloading the models you need at a given stage and sharding the largest models across multiple GPUs, it is possible to run inference with large models on consumer GPUs.",yl,ne,Jl,ie,it='<a href="https://huggingface.co/spaces/nanotron/ultrascale-playbook?section=context_parallelism" rel="nofollow">Context parallelism</a> splits input sequences across multiple GPUs to reduce memory usage. Each GPU processes its own slice of the sequence.',ul,pe,pt='Use <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.set_attention_backend">set_attention_backend()</a> to switch to a more optimized attention backend. Refer to this <a href="../optimization/attention_backends#available-backends">table</a> for a complete list of available backends.',wl,oe,ot='Most attention backends are compatible with context parallelism. Open an <a href="https://github.com/huggingface/diffusers/issues/new" rel="nofollow">issue</a> if a backend is not compatible.',fl,re,hl,ce,rt='Key (K) and value (V) representations communicate between devices using <a href="https://huggingface.co/papers/2310.01889" rel="nofollow">Ring Attention</a>. This ensures each split sees every other token’s K/V. Each GPU computes attention for its local K/V and passes it to the next GPU in the ring. No single GPU holds the full sequence, which reduces communication latency.',Tl,Me,ct='Pass a <a href="/docs/diffusers/main/en/api/parallel#diffusers.ContextParallelConfig">ContextParallelConfig</a> to the <code>parallel_config</code> argument of the transformer model. The config supports the <code>ring_degree</code> argument that determines how many devices to use for Ring Attention.',bl,me,jl,de,Mt='The script above needs to be run with a distributed launcher, such as <a href="https://docs.pytorch.org/docs/stable/elastic/run.html" rel="nofollow">torchrun</a>, that is compatible with PyTorch. <code>--nproc-per-node</code> is set to the number of GPUs available.',Ul,ye,mt="/<code>shell `torchrun --nproc-per-node 2 above_script.py`.  /</code>",Zl,Je,gl,ue,dt='<a href="https://huggingface.co/papers/2309.14509" rel="nofollow">Ulysses Attention</a> splits a sequence across GPUs and performs an <em>all-to-all</em> communication (every device sends/receives data to every other device). Each GPU ends up with all tokens for only a subset of attention heads. Each GPU computes attention locally on all tokens for its head, then performs another all-to-all to regroup results by tokens for the next layer.',Il,we,yt='<a href="/docs/diffusers/main/en/api/parallel#diffusers.ContextParallelConfig">ContextParallelConfig</a> supports Ulysses Attention through the <code>ulysses_degree</code> argument. This determines how many devices to use for Ulysses Attention.',Cl,fe,Jt='Pass the <a href="/docs/diffusers/main/en/api/parallel#diffusers.ContextParallelConfig">ContextParallelConfig</a> to <code>enable_parallelism()</code>.',Bl,he,_l,Te,vl,be,ut="Pass <code>parallel_config</code> during model initialization to enable context parallelism.",kl,je,Gl,Ue,Wl,ge,Xl;return T=new gt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),b=new h({props:{title:"Distributed inference",local:"distributed-inference",headingTag:"h1"}}),Z=new h({props:{title:"Accelerate",local:"accelerate",headingTag:"h2"}}),C=new J({props:{code:"dXYlMjBwaXAlMjBpbnN0YWxsJTIwYWNjZWxlcmF0ZQ==",highlighted:"uv pip install accelerate",wrap:!1}}),v=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwYWNjZWxlcmF0ZSUyMGltcG9ydCUyMFBhcnRpYWxTdGF0ZSUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBEaWZmdXNpb25QaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMlF3ZW4lMkZRd2VuLUltYWdlJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQWRpc3RyaWJ1dGVkX3N0YXRlJTIwJTNEJTIwUGFydGlhbFN0YXRlKCklMEFwaXBlbGluZS50byhkaXN0cmlidXRlZF9zdGF0ZS5kZXZpY2Up",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> PartialState
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.float16
)
distributed_state = PartialState()
pipeline.to(distributed_state.device)`,wrap:!1}}),G=new J({props:{code:"d2l0aCUyMGRpc3RyaWJ1dGVkX3N0YXRlLnNwbGl0X2JldHdlZW5fcHJvY2Vzc2VzKCU1QiUyMmElMjBkb2clMjIlMkMlMjAlMjJhJTIwY2F0JTIyJTVEKSUyMGFzJTIwcHJvbXB0JTNBJTBBJTIwJTIwJTIwJTIwcmVzdWx0JTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwcmVzdWx0LnNhdmUoZiUyMnJlc3VsdF8lN0JkaXN0cmlidXRlZF9zdGF0ZS5wcm9jZXNzX2luZGV4JTdELnBuZyUyMik=",highlighted:`<span class="hljs-keyword">with</span> distributed_state.split_between_processes([<span class="hljs-string">&quot;a dog&quot;</span>, <span class="hljs-string">&quot;a cat&quot;</span>]) <span class="hljs-keyword">as</span> prompt:
    result = pipeline(prompt).images[<span class="hljs-number">0</span>]
    result.save(<span class="hljs-string">f&quot;result_<span class="hljs-subst">{distributed_state.process_index}</span>.png&quot;</span>)`,wrap:!1}}),X=new J({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHJ1bl9kaXN0cmlidXRlZC5weSUyMC0tbnVtX3Byb2Nlc3NlcyUzRDI=",highlighted:"accelerate launch run_distributed.py --num_processes=2",wrap:!1}}),E=new h({props:{title:"PyTorch Distributed",local:"pytorch-distributed",headingTag:"h2"}}),R=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5kaXN0cmlidXRlZCUyMGFzJTIwZGlzdCUwQWltcG9ydCUyMHRvcmNoLm11bHRpcHJvY2Vzc2luZyUyMGFzJTIwbXAlMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.distributed <span class="hljs-keyword">as</span> dist
<span class="hljs-keyword">import</span> torch.multiprocessing <span class="hljs-keyword">as</span> mp

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.float16,
)`,wrap:!1}}),Q=new J({props:{code:"ZGVmJTIwcnVuX2luZmVyZW5jZShyYW5rJTJDJTIwd29ybGRfc2l6ZSklM0ElMEElMjAlMjAlMjAlMjBkaXN0LmluaXRfcHJvY2Vzc19ncm91cCglMjJuY2NsJTIyJTJDJTIwcmFuayUzRHJhbmslMkMlMjB3b3JsZF9zaXplJTNEd29ybGRfc2l6ZSklMEElMEElMjAlMjAlMjAlMjBwaXBlbGluZS50byhyYW5rKSUwQSUwQSUyMCUyMCUyMCUyMGlmJTIwdG9yY2guZGlzdHJpYnV0ZWQuZ2V0X3JhbmsoKSUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9tcHQlMjAlM0QlMjAlMjJhJTIwZG9nJTIyJTBBJTIwJTIwJTIwJTIwZWxpZiUyMHRvcmNoLmRpc3RyaWJ1dGVkLmdldF9yYW5rKCklMjAlM0QlM0QlMjAxJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGNhdCUyMiUwQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwc2QocHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwaW1hZ2Uuc2F2ZShmJTIyLiUyRiU3QidfJy5qb2luKHByb21wdCklN0QucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_inference</span>(<span class="hljs-params">rank, world_size</span>):
    dist.init_process_group(<span class="hljs-string">&quot;nccl&quot;</span>, rank=rank, world_size=world_size)

    pipeline.to(rank)

    <span class="hljs-keyword">if</span> torch.distributed.get_rank() == <span class="hljs-number">0</span>:
        prompt = <span class="hljs-string">&quot;a dog&quot;</span>
    <span class="hljs-keyword">elif</span> torch.distributed.get_rank() == <span class="hljs-number">1</span>:
        prompt = <span class="hljs-string">&quot;a cat&quot;</span>

    image = sd(prompt).images[<span class="hljs-number">0</span>]
    image.save(<span class="hljs-string">f&quot;./<span class="hljs-subst">{<span class="hljs-string">&#x27;_&#x27;</span>.join(prompt)}</span>.png&quot;</span>)`,wrap:!1}}),V=new J({props:{code:"ZGVmJTIwbWFpbigpJTNBJTBBJTIwJTIwJTIwJTIwd29ybGRfc2l6ZSUyMCUzRCUyMDIlMEElMjAlMjAlMjAlMjBtcC5zcGF3bihydW5faW5mZXJlbmNlJTJDJTIwYXJncyUzRCh3b3JsZF9zaXplJTJDKSUyQyUyMG5wcm9jcyUzRHdvcmxkX3NpemUlMkMlMjBqb2luJTNEVHJ1ZSklMEElMEElMEFpZiUyMF9fbmFtZV9fJTIwJTNEJTNEJTIwJTIyX19tYWluX18lMjIlM0ElMEElMjAlMjAlMjAlMjBtYWluKCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    world_size = <span class="hljs-number">2</span>
    mp.spawn(run_inference, args=(world_size,), nprocs=world_size, join=<span class="hljs-literal">True</span>)


<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    main()`,wrap:!1}}),S=new J({props:{code:"dG9yY2hydW4lMjBydW5fZGlzdHJpYnV0ZWQucHklMjAtLW5wcm9jX3Blcl9ub2RlJTNEMg==",highlighted:"torchrun run_distributed.py --nproc_per_node=2",wrap:!1}}),z=new h({props:{title:"device_map",local:"devicemap",headingTag:"h2"}}),L=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyJTIyJTIyJTBBY2luZW1hdGljJTIwZmlsbSUyMHN0aWxsJTIwb2YlMjBhJTIwY2F0JTIwc2lwcGluZyUyMGElMjBtYXJnYXJpdGElMjBpbiUyMGElMjBwb29sJTIwaW4lMjBQYWxtJTIwU3ByaW5ncyUyQyUyMENhbGlmb3JuaWElMEFoaWdobHklMjBkZXRhaWxlZCUyQyUyMGhpZ2glMjBidWRnZXQlMjBob2xseXdvb2QlMjBtb3ZpZSUyQyUyMGNpbmVtYXNjb3BlJTJDJTIwbW9vZHklMkMlMjBlcGljJTJDJTIwZ29yZ2VvdXMlMkMlMjBmaWxtJTIwZ3JhaW4lMEElMjIlMjIlMjIlMEElMEFwaXBlbGluZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwdmFlJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJiYWxhbmNlZCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1heF9tZW1vcnklM0QlN0IwJTNBJTIwJTIyMTZHQiUyMiUyQyUyMDElM0ElMjAlMjIxNkdCJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUwQSklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyRW5jb2RpbmclMjBwcm9tcHRzLiUyMiklMEElMjAlMjAlMjAlMjBwcm9tcHRfZW1iZWRzJTJDJTIwcG9vbGVkX3Byb21wdF9lbWJlZHMlMkMlMjB0ZXh0X2lkcyUyMCUzRCUyMHBpcGVsaW5lLmVuY29kZV9wcm9tcHQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTIwcHJvbXB0XzIlM0ROb25lJTJDJTIwbWF4X3NlcXVlbmNlX2xlbmd0aCUzRDUxMiUwQSUyMCUyMCUyMCUyMCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline
<span class="hljs-keyword">import</span> torch

prompt = <span class="hljs-string">&quot;&quot;&quot;
cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California
highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain
&quot;&quot;&quot;</span>

pipeline = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    transformer=<span class="hljs-literal">None</span>,
    vae=<span class="hljs-literal">None</span>,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>,
    max_memory={<span class="hljs-number">0</span>: <span class="hljs-string">&quot;16GB&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;16GB&quot;</span>},
    torch_dtype=torch.bfloat16
)
<span class="hljs-keyword">with</span> torch.no_grad():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Encoding prompts.&quot;</span>)
    prompt_embeds, pooled_prompt_embeds, text_ids = pipeline.encode_prompt(
        prompt=prompt, prompt_2=<span class="hljs-literal">None</span>, max_sequence_length=<span class="hljs-number">512</span>
    )`,wrap:!1}}),D=new J({props:{code:"aW1wb3J0JTIwZ2MlMjAlMEElMEFkZWYlMjBmbHVzaCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2MuY29sbGVjdCgpJTBBJTIwJTIwJTIwJTIwdG9yY2guY3VkYS5lbXB0eV9jYWNoZSgpJTBBJTIwJTIwJTIwJTIwdG9yY2guY3VkYS5yZXNldF9tYXhfbWVtb3J5X2FsbG9jYXRlZCgpJTBBJTIwJTIwJTIwJTIwdG9yY2guY3VkYS5yZXNldF9wZWFrX21lbW9yeV9zdGF0cygpJTBBJTBBZGVsJTIwcGlwZWxpbmUudGV4dF9lbmNvZGVyJTBBZGVsJTIwcGlwZWxpbmUudGV4dF9lbmNvZGVyXzIlMEFkZWwlMjBwaXBlbGluZS50b2tlbml6ZXIlMEFkZWwlMjBwaXBlbGluZS50b2tlbml6ZXJfMiUwQWRlbCUyMHBpcGVsaW5lJTBBJTBBZmx1c2goKQ==",highlighted:`<span class="hljs-keyword">import</span> gc 

<span class="hljs-keyword">def</span> <span class="hljs-title function_">flush</span>():
    gc.collect()
    torch.cuda.empty_cache()
    torch.cuda.reset_max_memory_allocated()
    torch.cuda.reset_peak_memory_stats()

<span class="hljs-keyword">del</span> pipeline.text_encoder
<span class="hljs-keyword">del</span> pipeline.text_encoder_2
<span class="hljs-keyword">del</span> pipeline.tokenizer
<span class="hljs-keyword">del</span> pipeline.tokenizer_2
<span class="hljs-keyword">del</span> pipeline

flush()`,wrap:!1}}),O=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQWltcG9ydCUyMHRvcmNoJTIwJTBBJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-keyword">import</span> torch 

transformer = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>, 
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16
)`,wrap:!1}}),le=new J({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBGbHV4UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2RlciUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjB0ZXh0X2VuY29kZXJfMiUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyXzIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwdmFlJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybWVyJTNEdHJhbnNmb3JtZXIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQSUwQXByaW50KCUyMlJ1bm5pbmclMjBkZW5vaXNpbmcuJTIyKSUwQWhlaWdodCUyQyUyMHdpZHRoJTIwJTNEJTIwNzY4JTJDJTIwMTM2MCUwQWxhdGVudHMlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHRfZW1iZWRzJTNEcHJvbXB0X2VtYmVkcyUyQyUwQSUyMCUyMCUyMCUyMHBvb2xlZF9wcm9tcHRfZW1iZWRzJTNEcG9vbGVkX3Byb21wdF9lbWJlZHMlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDMuNSUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRGhlaWdodCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNEd2lkdGglMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRfdHlwZSUzRCUyMmxhdGVudCUyMiUyQyUwQSkuaW1hZ2Vz",highlighted:`pipeline = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    text_encoder=<span class="hljs-literal">None</span>,
    text_encoder_2=<span class="hljs-literal">None</span>,
    tokenizer=<span class="hljs-literal">None</span>,
    tokenizer_2=<span class="hljs-literal">None</span>,
    vae=<span class="hljs-literal">None</span>,
    transformer=transformer,
    torch_dtype=torch.bfloat16
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Running denoising.&quot;</span>)
height, width = <span class="hljs-number">768</span>, <span class="hljs-number">1360</span>
latents = pipeline(
    prompt_embeds=prompt_embeds,
    pooled_prompt_embeds=pooled_prompt_embeds,
    num_inference_steps=<span class="hljs-number">50</span>,
    guidance_scale=<span class="hljs-number">3.5</span>,
    height=height,
    width=width,
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).images`,wrap:!1}}),se=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b2VuY29kZXJLTCUwQWZyb20lMjBkaWZmdXNlcnMuaW1hZ2VfcHJvY2Vzc29yJTIwaW1wb3J0JTIwVmFlSW1hZ2VQcm9jZXNzb3IlMEElMEF2YWUlMjAlM0QlMjBBdXRvZW5jb2RlcktMLmZyb21fcHJldHJhaW5lZChja3B0X2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIydmFlJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEF2YWVfc2NhbGVfZmFjdG9yJTIwJTNEJTIwMiUyMCoqJTIwKGxlbih2YWUuY29uZmlnLmJsb2NrX291dF9jaGFubmVscyklMjAtJTIwMSklMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBWYWVJbWFnZVByb2Nlc3Nvcih2YWVfc2NhbGVfZmFjdG9yJTNEdmFlX3NjYWxlX2ZhY3RvciklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyUnVubmluZyUyMGRlY29kaW5nLiUyMiklMEElMjAlMjAlMjAlMjBsYXRlbnRzJTIwJTNEJTIwRmx1eFBpcGVsaW5lLl91bnBhY2tfbGF0ZW50cyhsYXRlbnRzJTJDJTIwaGVpZ2h0JTJDJTIwd2lkdGglMkMlMjB2YWVfc2NhbGVfZmFjdG9yKSUwQSUyMCUyMCUyMCUyMGxhdGVudHMlMjAlM0QlMjAobGF0ZW50cyUyMCUyRiUyMHZhZS5jb25maWcuc2NhbGluZ19mYWN0b3IpJTIwJTJCJTIwdmFlLmNvbmZpZy5zaGlmdF9mYWN0b3IlMEElMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHZhZS5kZWNvZGUobGF0ZW50cyUyQyUyMHJldHVybl9kaWN0JTNERmFsc2UpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yLnBvc3Rwcm9jZXNzKGltYWdlJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJwaWwlMjIpJTBBJTIwJTIwJTIwJTIwaW1hZ2UlNUIwJTVELnNhdmUoJTIyc3BsaXRfdHJhbnNmb3JtZXIucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKL
<span class="hljs-keyword">from</span> diffusers.image_processor <span class="hljs-keyword">import</span> VaeImageProcessor

vae = AutoencoderKL.from_pretrained(ckpt_id, subfolder=<span class="hljs-string">&quot;vae&quot;</span>, torch_dtype=torch.bfloat16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
vae_scale_factor = <span class="hljs-number">2</span> ** (<span class="hljs-built_in">len</span>(vae.config.block_out_channels) - <span class="hljs-number">1</span>)
image_processor = VaeImageProcessor(vae_scale_factor=vae_scale_factor)

<span class="hljs-keyword">with</span> torch.no_grad():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Running decoding.&quot;</span>)
    latents = FluxPipeline._unpack_latents(latents, height, width, vae_scale_factor)
    latents = (latents / vae.config.scaling_factor) + vae.config.shift_factor

    image = vae.decode(latents, return_dict=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
    image = image_processor.postprocess(image, output_type=<span class="hljs-string">&quot;pil&quot;</span>)
    image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;split_transformer.png&quot;</span>)`,wrap:!1}}),ne=new h({props:{title:"Context parallelism",local:"context-parallelism",headingTag:"h2"}}),re=new h({props:{title:"Ring Attention",local:"ring-attention",headingTag:"h3"}}),me=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> distributed <span class="hljs-keyword">as</span> dist
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, ContextParallelConfig

<span class="hljs-keyword">def</span> <span class="hljs-title function_">setup_distributed</span>():
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> dist.is_initialized():
        dist.init_process_group(backend=<span class="hljs-string">&quot;nccl&quot;</span>)
    rank = dist.get_rank()
    device = torch.device(<span class="hljs-string">f&quot;cuda:<span class="hljs-subst">{rank}</span>&quot;</span>)
    torch.cuda.set_device(device)
    <span class="hljs-keyword">return</span> device

<span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    device = setup_distributed()
    world_size = dist.get_world_size()

    pipeline = DiffusionPipeline.from_pretrained(
        <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>, torch_dtype=torch.bfloat16, device_map=device
    )
    pipeline.transformer.set_attention_backend(<span class="hljs-string">&quot;_native_cudnn&quot;</span>)

    cp_config = ContextParallelConfig(ring_degree=world_size)
    pipeline.transformer.enable_parallelism(config=cp_config)

    prompt = <span class="hljs-string">&quot;&quot;&quot;
    cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California
    highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain
    &quot;&quot;&quot;</span>

    <span class="hljs-comment"># Must specify generator so all ranks start with same latents (or pass your own)</span>
    generator = torch.Generator().manual_seed(<span class="hljs-number">42</span>)
    image = pipeline(
        prompt,
        guidance_scale=<span class="hljs-number">3.5</span>,
        num_inference_steps=<span class="hljs-number">50</span>,
        generator=generator,
    ).images[<span class="hljs-number">0</span>]

    <span class="hljs-keyword">if</span> dist.get_rank() == <span class="hljs-number">0</span>:
        image.save(<span class="hljs-string">f&quot;output.png&quot;</span>)

    <span class="hljs-keyword">if</span> dist.is_initialized():
        dist.destroy_process_group()


<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    main()`,wrap:!1}}),Je=new h({props:{title:"Ulysses Attention",local:"ulysses-attention",headingTag:"h3"}}),he=new J({props:{code:"JTIzJTIwRGVwZW5kaW5nJTIwb24lMjB0aGUlMjBudW1iZXIlMjBvZiUyMEdQVXMlMjBhdmFpbGFibGUuJTBBcGlwZWxpbmUudHJhbnNmb3JtZXIuZW5hYmxlX3BhcmFsbGVsaXNtKGNvbmZpZyUzRENvbnRleHRQYXJhbGxlbENvbmZpZyh1bHlzc2VzX2RlZ3JlZSUzRDIpKQ==",highlighted:`<span class="hljs-comment"># Depending on the number of GPUs available.</span>
pipeline.transformer.enable_parallelism(config=ContextParallelConfig(ulysses_degree=<span class="hljs-number">2</span>))`,wrap:!1}}),Te=new h({props:{title:"parallel_config",local:"parallelconfig",headingTag:"h3"}}),je=new J({props:{code:"Q0tQVF9JRCUyMCUzRCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUwQSUwQWNwX2NvbmZpZyUyMCUzRCUyMENvbnRleHRQYXJhbGxlbENvbmZpZyhyaW5nX2RlZ3JlZSUzRDIpJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMENLUFRfSUQlMkMlMjAlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjAlMEElMjAlMjAlMjAlMjBwYXJhbGxlbF9jb25maWclM0RjcF9jb25maWclMEEpJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwQ0tQVF9JRCUyQyUyMHRyYW5zZm9ybWVyJTNEdHJhbnNmb3JtZXIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBKS50byhkZXZpY2Up",highlighted:`CKPT_ID = <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>

cp_config = ContextParallelConfig(ring_degree=<span class="hljs-number">2</span>)
transformer = AutoModel.from_pretrained(
    CKPT_ID, 
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>, 
    torch_dtype=torch.bfloat16, 
    parallel_config=cp_config
)

pipeline = DiffusionPipeline.from_pretrained(
    CKPT_ID, transformer=transformer, torch_dtype=torch.bfloat16,
).to(device)`,wrap:!1}}),Ue=new It({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/training/distributed_inference.md"}}),{c(){u=i("meta"),Ie=a(),Ze=i("p"),Ce=a(),r(T.$$.fragment),Be=a(),r(b.$$.fragment),_e=a(),j=i("p"),j.textContent=Nl,ve=a(),U=i("p"),U.innerHTML=Rl,ke=a(),r(Z.$$.fragment),Ge=a(),g=i("p"),g.textContent=Al,We=a(),I=i("p"),I.textContent=xl,Xe=a(),r(C.$$.fragment),Ee=a(),B=i("p"),B.innerHTML=Ql,$e=a(),_=i("p"),_.innerHTML=Hl,Ne=a(),r(v.$$.fragment),Re=a(),k=i("p"),k.innerHTML=Vl,Ae=a(),r(G.$$.fragment),xe=a(),W=i("p"),W.innerHTML=Yl,Qe=a(),r(X.$$.fragment),He=a(),w=i("blockquote"),w.innerHTML=Sl,Ve=a(),r(E.$$.fragment),Ye=a(),$=i("p"),$.innerHTML=zl,Se=a(),N=i("p"),N.innerHTML=Fl,ze=a(),r(R.$$.fragment),Fe=a(),A=i("p"),A.innerHTML=Pl,Pe=a(),x=i("p"),x.innerHTML=Ll,Le=a(),r(Q.$$.fragment),qe=a(),H=i("p"),H.innerHTML=ql,De=a(),r(V.$$.fragment),Ke=a(),Y=i("p"),Y.innerHTML=Dl,Oe=a(),r(S.$$.fragment),el=a(),r(z.$$.fragment),ll=a(),F=i("p"),F.innerHTML=Kl,tl=a(),P=i("p"),P.innerHTML=Ol,sl=a(),r(L.$$.fragment),al=a(),q=i("p"),q.textContent=et,nl=a(),r(D.$$.fragment),il=a(),K=i("p"),K.innerHTML=lt,pl=a(),r(O.$$.fragment),ol=a(),f=i("blockquote"),f.innerHTML=tt,rl=a(),ee=i("p"),ee.innerHTML=st,cl=a(),r(le.$$.fragment),Ml=a(),te=i("p"),te.textContent=at,ml=a(),r(se.$$.fragment),dl=a(),ae=i("p"),ae.textContent=nt,yl=a(),r(ne.$$.fragment),Jl=a(),ie=i("p"),ie.innerHTML=it,ul=a(),pe=i("p"),pe.innerHTML=pt,wl=a(),oe=i("p"),oe.innerHTML=ot,fl=a(),r(re.$$.fragment),hl=a(),ce=i("p"),ce.innerHTML=rt,Tl=a(),Me=i("p"),Me.innerHTML=ct,bl=a(),r(me.$$.fragment),jl=a(),de=i("p"),de.innerHTML=Mt,Ul=a(),ye=i("p"),ye.innerHTML=mt,Zl=a(),r(Je.$$.fragment),gl=a(),ue=i("p"),ue.innerHTML=dt,Il=a(),we=i("p"),we.innerHTML=yt,Cl=a(),fe=i("p"),fe.innerHTML=Jt,Bl=a(),r(he.$$.fragment),_l=a(),r(Te.$$.fragment),vl=a(),be=i("p"),be.innerHTML=ut,kl=a(),r(je.$$.fragment),Gl=a(),r(Ue.$$.fragment),Wl=a(),ge=i("p"),this.h()},l(e){const l=Ut("svelte-u9bgzb",document.head);u=p(l,"META",{name:!0,content:!0}),l.forEach(t),Ie=n(e),Ze=p(e,"P",{}),wt(Ze).forEach(t),Ce=n(e),c(T.$$.fragment,e),Be=n(e),c(b.$$.fragment,e),_e=n(e),j=p(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-eljq9f"&&(j.textContent=Nl),ve=n(e),U=p(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-og4l62"&&(U.innerHTML=Rl),ke=n(e),c(Z.$$.fragment,e),Ge=n(e),g=p(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-nz1tds"&&(g.textContent=Al),We=n(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1st21a7"&&(I.textContent=xl),Xe=n(e),c(C.$$.fragment,e),Ee=n(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-s7f0yp"&&(B.innerHTML=Ql),$e=n(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1ibki3b"&&(_.innerHTML=Hl),Ne=n(e),c(v.$$.fragment,e),Re=n(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-dxnfoj"&&(k.innerHTML=Vl),Ae=n(e),c(G.$$.fragment,e),xe=n(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-xu0wll"&&(W.innerHTML=Yl),Qe=n(e),c(X.$$.fragment,e),He=n(e),w=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-djm11n"&&(w.innerHTML=Sl),Ve=n(e),c(E.$$.fragment,e),Ye=n(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-nym58p"&&($.innerHTML=zl),Se=n(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1q3d069"&&(N.innerHTML=Fl),ze=n(e),c(R.$$.fragment,e),Fe=n(e),A=p(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1vva4uo"&&(A.innerHTML=Pl),Pe=n(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1329uwh"&&(x.innerHTML=Ll),Le=n(e),c(Q.$$.fragment,e),qe=n(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-84sp40"&&(H.innerHTML=ql),De=n(e),c(V.$$.fragment,e),Ke=n(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-17g6264"&&(Y.innerHTML=Dl),Oe=n(e),c(S.$$.fragment,e),el=n(e),c(z.$$.fragment,e),ll=n(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-19ricyq"&&(F.innerHTML=Kl),tl=n(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-uepizv"&&(P.innerHTML=Ol),sl=n(e),c(L.$$.fragment,e),al=n(e),q=p(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-m088j3"&&(q.textContent=et),nl=n(e),c(D.$$.fragment,e),il=n(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-18jqegg"&&(K.innerHTML=lt),pl=n(e),c(O.$$.fragment,e),ol=n(e),f=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(f)!=="svelte-eiyj9h"&&(f.innerHTML=tt),rl=n(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-128ts8i"&&(ee.innerHTML=st),cl=n(e),c(le.$$.fragment,e),Ml=n(e),te=p(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-jp9jpz"&&(te.textContent=at),ml=n(e),c(se.$$.fragment,e),dl=n(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-3tqui3"&&(ae.textContent=nt),yl=n(e),c(ne.$$.fragment,e),Jl=n(e),ie=p(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-1bsyx0k"&&(ie.innerHTML=it),ul=n(e),pe=p(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-rgekxt"&&(pe.innerHTML=pt),wl=n(e),oe=p(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-1ppoxcn"&&(oe.innerHTML=ot),fl=n(e),c(re.$$.fragment,e),hl=n(e),ce=p(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-wnvqc8"&&(ce.innerHTML=rt),Tl=n(e),Me=p(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-1kqjh5x"&&(Me.innerHTML=ct),bl=n(e),c(me.$$.fragment,e),jl=n(e),de=p(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-6zwmyc"&&(de.innerHTML=Mt),Ul=n(e),ye=p(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-k3vwet"&&(ye.innerHTML=mt),Zl=n(e),c(Je.$$.fragment,e),gl=n(e),ue=p(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-1b28cdv"&&(ue.innerHTML=dt),Il=n(e),we=p(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-1i9x1om"&&(we.innerHTML=yt),Cl=n(e),fe=p(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-9gv0zf"&&(fe.innerHTML=Jt),Bl=n(e),c(he.$$.fragment,e),_l=n(e),c(Te.$$.fragment,e),vl=n(e),be=p(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-1abk5kt"&&(be.innerHTML=ut),kl=n(e),c(je.$$.fragment,e),Gl=n(e),c(Ue.$$.fragment,e),Wl=n(e),ge=p(e,"P",{}),wt(ge).forEach(t),this.h()},h(){El(u,"name","hf:doc:metadata"),El(u,"content",Bt),El(w,"class","tip"),El(f,"class","tip")},m(e,l){Zt(document.head,u),s(e,Ie,l),s(e,Ze,l),s(e,Ce,l),M(T,e,l),s(e,Be,l),M(b,e,l),s(e,_e,l),s(e,j,l),s(e,ve,l),s(e,U,l),s(e,ke,l),M(Z,e,l),s(e,Ge,l),s(e,g,l),s(e,We,l),s(e,I,l),s(e,Xe,l),M(C,e,l),s(e,Ee,l),s(e,B,l),s(e,$e,l),s(e,_,l),s(e,Ne,l),M(v,e,l),s(e,Re,l),s(e,k,l),s(e,Ae,l),M(G,e,l),s(e,xe,l),s(e,W,l),s(e,Qe,l),M(X,e,l),s(e,He,l),s(e,w,l),s(e,Ve,l),M(E,e,l),s(e,Ye,l),s(e,$,l),s(e,Se,l),s(e,N,l),s(e,ze,l),M(R,e,l),s(e,Fe,l),s(e,A,l),s(e,Pe,l),s(e,x,l),s(e,Le,l),M(Q,e,l),s(e,qe,l),s(e,H,l),s(e,De,l),M(V,e,l),s(e,Ke,l),s(e,Y,l),s(e,Oe,l),M(S,e,l),s(e,el,l),M(z,e,l),s(e,ll,l),s(e,F,l),s(e,tl,l),s(e,P,l),s(e,sl,l),M(L,e,l),s(e,al,l),s(e,q,l),s(e,nl,l),M(D,e,l),s(e,il,l),s(e,K,l),s(e,pl,l),M(O,e,l),s(e,ol,l),s(e,f,l),s(e,rl,l),s(e,ee,l),s(e,cl,l),M(le,e,l),s(e,Ml,l),s(e,te,l),s(e,ml,l),M(se,e,l),s(e,dl,l),s(e,ae,l),s(e,yl,l),M(ne,e,l),s(e,Jl,l),s(e,ie,l),s(e,ul,l),s(e,pe,l),s(e,wl,l),s(e,oe,l),s(e,fl,l),M(re,e,l),s(e,hl,l),s(e,ce,l),s(e,Tl,l),s(e,Me,l),s(e,bl,l),M(me,e,l),s(e,jl,l),s(e,de,l),s(e,Ul,l),s(e,ye,l),s(e,Zl,l),M(Je,e,l),s(e,gl,l),s(e,ue,l),s(e,Il,l),s(e,we,l),s(e,Cl,l),s(e,fe,l),s(e,Bl,l),M(he,e,l),s(e,_l,l),M(Te,e,l),s(e,vl,l),s(e,be,l),s(e,kl,l),M(je,e,l),s(e,Gl,l),M(Ue,e,l),s(e,Wl,l),s(e,ge,l),Xl=!0},p:ht,i(e){Xl||(m(T.$$.fragment,e),m(b.$$.fragment,e),m(Z.$$.fragment,e),m(C.$$.fragment,e),m(v.$$.fragment,e),m(G.$$.fragment,e),m(X.$$.fragment,e),m(E.$$.fragment,e),m(R.$$.fragment,e),m(Q.$$.fragment,e),m(V.$$.fragment,e),m(S.$$.fragment,e),m(z.$$.fragment,e),m(L.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(le.$$.fragment,e),m(se.$$.fragment,e),m(ne.$$.fragment,e),m(re.$$.fragment,e),m(me.$$.fragment,e),m(Je.$$.fragment,e),m(he.$$.fragment,e),m(Te.$$.fragment,e),m(je.$$.fragment,e),m(Ue.$$.fragment,e),Xl=!0)},o(e){d(T.$$.fragment,e),d(b.$$.fragment,e),d(Z.$$.fragment,e),d(C.$$.fragment,e),d(v.$$.fragment,e),d(G.$$.fragment,e),d(X.$$.fragment,e),d(E.$$.fragment,e),d(R.$$.fragment,e),d(Q.$$.fragment,e),d(V.$$.fragment,e),d(S.$$.fragment,e),d(z.$$.fragment,e),d(L.$$.fragment,e),d(D.$$.fragment,e),d(O.$$.fragment,e),d(le.$$.fragment,e),d(se.$$.fragment,e),d(ne.$$.fragment,e),d(re.$$.fragment,e),d(me.$$.fragment,e),d(Je.$$.fragment,e),d(he.$$.fragment,e),d(Te.$$.fragment,e),d(je.$$.fragment,e),d(Ue.$$.fragment,e),Xl=!1},d(e){e&&(t(Ie),t(Ze),t(Ce),t(Be),t(_e),t(j),t(ve),t(U),t(ke),t(Ge),t(g),t(We),t(I),t(Xe),t(Ee),t(B),t($e),t(_),t(Ne),t(Re),t(k),t(Ae),t(xe),t(W),t(Qe),t(He),t(w),t(Ve),t(Ye),t($),t(Se),t(N),t(ze),t(Fe),t(A),t(Pe),t(x),t(Le),t(qe),t(H),t(De),t(Ke),t(Y),t(Oe),t(el),t(ll),t(F),t(tl),t(P),t(sl),t(al),t(q),t(nl),t(il),t(K),t(pl),t(ol),t(f),t(rl),t(ee),t(cl),t(Ml),t(te),t(ml),t(dl),t(ae),t(yl),t(Jl),t(ie),t(ul),t(pe),t(wl),t(oe),t(fl),t(hl),t(ce),t(Tl),t(Me),t(bl),t(jl),t(de),t(Ul),t(ye),t(Zl),t(gl),t(ue),t(Il),t(we),t(Cl),t(fe),t(Bl),t(_l),t(vl),t(be),t(kl),t(Gl),t(Wl),t(ge)),t(u),y(T,e),y(b,e),y(Z,e),y(C,e),y(v,e),y(G,e),y(X,e),y(E,e),y(R,e),y(Q,e),y(V,e),y(S,e),y(z,e),y(L,e),y(D,e),y(O,e),y(le,e),y(se,e),y(ne,e),y(re,e),y(me,e),y(Je,e),y(he,e),y(Te,e),y(je,e),y(Ue,e)}}}const Bt='{"title":"Distributed inference","local":"distributed-inference","sections":[{"title":"Accelerate","local":"accelerate","sections":[],"depth":2},{"title":"PyTorch Distributed","local":"pytorch-distributed","sections":[],"depth":2},{"title":"device_map","local":"devicemap","sections":[],"depth":2},{"title":"Context parallelism","local":"context-parallelism","sections":[{"title":"Ring Attention","local":"ring-attention","sections":[],"depth":3},{"title":"Ulysses Attention","local":"ulysses-attention","sections":[],"depth":3},{"title":"parallel_config","local":"parallelconfig","sections":[],"depth":3}],"depth":2}],"depth":1}';function _t($l){return Tt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Et extends bt{constructor(u){super(),jt(this,u,_t,Ct,ft,{})}}export{Et as component};
