import{s as Mt,o as _t,n as wt}from"../chunks/scheduler.53228c21.js";import{S as bt,i as yt,e as i,s as a,c as d,h as jt,a as r,d as n,b as o,f as v,g as c,j as w,k as I,l as s,m as l,n as m,t as f,o as g,p as u}from"../chunks/index.100fac89.js";import{D as ae}from"../chunks/Docstring.49101787.js";import{C as Ve}from"../chunks/CodeBlock.d30a6509.js";import{E as Tt}from"../chunks/ExampleCodeBlock.4a9effb9.js";import{H as oe,E as Jt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.4d82655d.js";function xt(ue){let _,X="Examples:",T,b,y;return b=new Ve({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUFJYUGlwZWxpbmUlMEElMEElMjMlMjBMb2FkJTIwcGlwZWxpbmUlMjB3aXRoJTIwZnJvbV9wcmV0cmFpbmVkJTBBcGlwZSUyMCUzRCUyMFBSWFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJQaG90b3Jvb20lMkZwcngtNTEyLXQyaS1zZnQlMjIpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBkaWdpdGFsJTIwcGFpbnRpbmclMjBvZiUyMGElMjBydXN0eSUyQyUyMHZpbnRhZ2UlMjB0cmFtJTIwb24lMjBhJTIwc2FuZHklMjBiZWFjaCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjglMkMlMjBndWlkYW5jZV9zY2FsZSUzRDUuMCkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIycHJ4X291dHB1dC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> PRXPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load pipeline with from_pretrained</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = PRXPipeline.from_pretrained(<span class="hljs-string">&quot;Photoroom/prx-512-t2i-sft&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A digital painting of a rusty, vintage tram on a sandy beach&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt, num_inference_steps=<span class="hljs-number">28</span>, guidance_scale=<span class="hljs-number">5.0</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;prx_output.png&quot;</span>)`,wrap:!1}}),{c(){_=i("p"),_.textContent=X,T=a(),d(b.$$.fragment)},l(h){_=r(h,"P",{"data-svelte-h":!0}),w(_)!=="svelte-kvfsh7"&&(_.textContent=X),T=o(h),c(b.$$.fragment,h)},m(h,j){l(h,_,j),l(h,T,j),m(b,h,j),y=!0},p:wt,i(h){y||(f(b.$$.fragment,h),y=!0)},o(h){g(b.$$.fragment,h),y=!1},d(h){h&&(n(_),n(T)),u(b,h)}}}function vt(ue){let _,X,T,b,y,h,j,nt="PRX generates high-quality images from text using a simplified MMDIT architecture where text tokens don’t update through transformer blocks. It employs flow matching with discrete scheduling for efficient sampling and uses Google’s T5Gemma-2B-2B-UL2 model for multi-language text encoding. The ~1.3B parameter transformer delivers fast inference without sacrificing quality. You can choose between Flux VAE (8x compression, 16 latent channels) for balanced quality and speed or DC-AE (32x compression, 32 latent channels) for latent compression and faster processing.",he,$,Me,R,at='PRX offers multiple variants with different VAE configurations, each optimized for specific resolutions. Base models excel with detailed prompts, capturing complex compositions and subtle details. Fine-tuned models trained on the <a href="https://huggingface.co/datasets/yandex/alchemist" rel="nofollow">Alchemist dataset</a> improve aesthetic quality, especially with simpler prompts.',_e,B,ot='<thead><tr><th align="center">Model</th> <th align="center">Resolution</th> <th align="center">Fine-tuned</th> <th align="center">Distilled</th> <th align="center">Description</th> <th align="center">Suggested prompts</th> <th align="center">Suggested parameters</th> <th align="center">Recommended dtype</th></tr></thead> <tbody><tr><td align="center"><a href="https://huggingface.co/Photoroom/prx-256-t2i" rel="nofollow"><code>Photoroom/prx-256-t2i</code></a></td> <td align="center">256</td> <td align="center">No</td> <td align="center">No</td> <td align="center">Base model pre-trained at 256 with Flux VAE</td> <td align="center">Works best with detailed prompts in natural language</td> <td align="center">28 steps, cfg=5.0</td> <td align="center"><code>torch.bfloat16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Photoroom/prx-256-t2i-sft" rel="nofollow"><code>Photoroom/prx-256-t2i-sft</code></a></td> <td align="center">512</td> <td align="center">Yes</td> <td align="center">No</td> <td align="center">Fine-tuned on the <a href="https://huggingface.co/datasets/yandex/alchemist" rel="nofollow">Alchemist dataset</a> dataset with Flux VAE</td> <td align="center">Can handle less detailed prompts</td> <td align="center">28 steps, cfg=5.0</td> <td align="center"><code>torch.bfloat16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Photoroom/prx-512-t2i" rel="nofollow"><code>Photoroom/prx-512-t2i</code></a></td> <td align="center">512</td> <td align="center">No</td> <td align="center">No</td> <td align="center">Base model pre-trained at 512 with Flux VAE</td> <td align="center">Works best with detailed prompts in natural language</td> <td align="center">28 steps, cfg=5.0</td> <td align="center"><code>torch.bfloat16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Photoroom/prx-512-t2i-sft" rel="nofollow"><code>Photoroom/prx-512-t2i-sft</code></a></td> <td align="center">512</td> <td align="center">Yes</td> <td align="center">No</td> <td align="center">Fine-tuned on the <a href="https://huggingface.co/datasets/yandex/alchemist" rel="nofollow">Alchemist dataset</a> dataset with Flux VAE</td> <td align="center">Can handle less detailed prompts in natural language</td> <td align="center">28 steps, cfg=5.0</td> <td align="center"><code>torch.bfloat16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Photoroom/prx-512-t2i-sft-distilled" rel="nofollow"><code>Photoroom/prx-512-t2i-sft-distilled</code></a></td> <td align="center">512</td> <td align="center">Yes</td> <td align="center">Yes</td> <td align="center">8-step distilled model from <a href="https://huggingface.co/Photoroom/prx-512-t2i-sft" rel="nofollow"><code>Photoroom/prx-512-t2i-sft</code></a></td> <td align="center">Can handle less detailed prompts in natural language</td> <td align="center">8 steps, cfg=1.0</td> <td align="center"><code>torch.bfloat16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Photoroom/prx-512-t2i-dc-ae" rel="nofollow"><code>Photoroom/prx-512-t2i-dc-ae</code></a></td> <td align="center">512</td> <td align="center">No</td> <td align="center">No</td> <td align="center">Base model pre-trained at 512 with <a href="https://hanlab.mit.edu/projects/dc-ae" rel="nofollow">Deep Compression Autoencoder (DC-AE)</a></td> <td align="center">Works best with detailed prompts in natural language</td> <td align="center">28 steps, cfg=5.0</td> <td align="center"><code>torch.bfloat16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Photoroom/prx-512-t2i-dc-ae-sft" rel="nofollow"><code>Photoroom/prx-512-t2i-dc-ae-sft</code></a></td> <td align="center">512</td> <td align="center">Yes</td> <td align="center">No</td> <td align="center">Fine-tuned on the <a href="https://huggingface.co/datasets/yandex/alchemist" rel="nofollow">Alchemist dataset</a> dataset with <a href="https://hanlab.mit.edu/projects/dc-ae" rel="nofollow">Deep Compression Autoencoder (DC-AE)</a></td> <td align="center">Can handle less detailed prompts in natural language</td> <td align="center">28 steps, cfg=5.0</td> <td align="center"><code>torch.bfloat16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Photoroom/prx-512-t2i-dc-ae-sft-distilled" rel="nofollow"><code>Photoroom/prx-512-t2i-dc-ae-sft-distilled</code></a></td> <td align="center">512</td> <td align="center">Yes</td> <td align="center">Yes</td> <td align="center">8-step distilled model from <a href="https://huggingface.co/Photoroom/prx-512-t2i-dc-ae-sft-distilled" rel="nofollow"><code>Photoroom/prx-512-t2i-dc-ae-sft-distilled</code></a></td> <td align="center">Can handle less detailed prompts in natural language</td> <td align="center">8 steps, cfg=1.0</td> <td align="center"><code>torch.bfloat16</code></td></tr></tbody>',we,C,lt='Refer to <a href="https://huggingface.co/collections/Photoroom/prx-models-68e66254c202ebfab99ad38e" rel="nofollow">this</a> collection for more information.',be,E,ye,W,st='Load the pipeline with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a>.',je,F,Te,V,Je,G,it="Load components individually to customize the pipeline for instance to use quantized models.",xe,N,ve,Q,Ie,z,rt="For memory-constrained environments:",Pe,Y,Ze,L,Ae,p,H,Ge,le,pt="Pipeline for text-to-image generation using PRX Transformer.",Ne,se,dt=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Qe,J,S,ze,ie,ct="Function invoked when calling the pipeline for generation.",Ye,P,Le,Z,q,He,re,mt="Check that all inputs are in correct format.",Se,A,D,qe,pe,ft="Encode text prompt using standard text encoder and tokenizer, or use precomputed embeddings.",De,k,O,Oe,de,gt="Determine the default resolution based on the loaded VAE and config.",Ke,U,K,et,ce,ut="Prepare initial latents for the diffusion process.",ke,ee,Ue,x,te,tt,me,ht="Output class for PRX pipelines.",Xe,ne,$e,ge,Re;return y=new oe({props:{title:"PRX",local:"prx",headingTag:"h1"}}),$=new oe({props:{title:"Available models",local:"available-models",headingTag:"h2"}}),E=new oe({props:{title:"Loading the pipeline",local:"loading-the-pipeline",headingTag:"h2"}}),F=new Ve({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5waXBlbGluZXMucHJ4JTIwaW1wb3J0JTIwUFJYUGlwZWxpbmUlMEElMEElMjMlMjBMb2FkJTIwcGlwZWxpbmUlMjAtJTIwVkFFJTIwYW5kJTIwdGV4dCUyMGVuY29kZXIlMjB3aWxsJTIwYmUlMjBsb2FkZWQlMjBmcm9tJTIwSHVnZ2luZ0ZhY2UlMEFwaXBlJTIwJTNEJTIwUFJYUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMlBob3Rvcm9vbSUyRnByeC01MTItdDJpLXNmdCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBmcm9udC1mYWNpbmclMjBwb3J0cmFpdCUyMG9mJTIwYSUyMGxpb24lMjB0aGUlMjBnb2xkZW4lMjBzYXZhbm5hJTIwYXQlMjBzdW5zZXQuJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyOCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNENS4wKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJwcnhfb3V0cHV0LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers.pipelines.prx <span class="hljs-keyword">import</span> PRXPipeline

<span class="hljs-comment"># Load pipeline - VAE and text encoder will be loaded from HuggingFace</span>
pipe = PRXPipeline.from_pretrained(<span class="hljs-string">&quot;Photoroom/prx-512-t2i-sft&quot;</span>, torch_dtype=torch.bfloat16)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A front-facing portrait of a lion the golden savanna at sunset.&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">28</span>, guidance_scale=<span class="hljs-number">5.0</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;prx_output.png&quot;</span>)`,wrap:!1}}),V=new oe({props:{title:"Manual Component Loading",local:"manual-component-loading",headingTag:"h3"}}),N=new Ve({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.pipelines.prx <span class="hljs-keyword">import</span> PRXPipeline
<span class="hljs-keyword">from</span> diffusers.models <span class="hljs-keyword">import</span> AutoencoderKL, AutoencoderDC
<span class="hljs-keyword">from</span> diffusers.models.transformers.transformer_prx <span class="hljs-keyword">import</span> PRXTransformer2DModel
<span class="hljs-keyword">from</span> diffusers.schedulers <span class="hljs-keyword">import</span> FlowMatchEulerDiscreteScheduler
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5GemmaModel, GemmaTokenizerFast
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> BitsAndBytesConfig

quant_config = DiffusersBitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
<span class="hljs-comment"># Load transformer</span>
transformer = PRXTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;checkpoints/prx-512-t2i-sft&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.bfloat16,
)

<span class="hljs-comment"># Load scheduler</span>
scheduler = FlowMatchEulerDiscreteScheduler.from_pretrained(
    <span class="hljs-string">&quot;checkpoints/prx-512-t2i-sft&quot;</span>, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>
)

<span class="hljs-comment"># Load T5Gemma text encoder</span>
t5gemma_model = T5GemmaModel.from_pretrained(<span class="hljs-string">&quot;google/t5gemma-2b-2b-ul2&quot;</span>,
                                            quantization_config=quant_config,
                                            torch_dtype=torch.bfloat16)
text_encoder = t5gemma_model.encoder.to(dtype=torch.bfloat16)
tokenizer = GemmaTokenizerFast.from_pretrained(<span class="hljs-string">&quot;google/t5gemma-2b-2b-ul2&quot;</span>)
tokenizer.model_max_length = <span class="hljs-number">256</span>

<span class="hljs-comment"># Load VAE - choose either Flux VAE or DC-AE</span>
<span class="hljs-comment"># Flux VAE</span>
vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
                                    subfolder=<span class="hljs-string">&quot;vae&quot;</span>,
                                    quantization_config=quant_config,
                                    torch_dtype=torch.bfloat16)

pipe = PRXPipeline(
    transformer=transformer,
    scheduler=scheduler,
    text_encoder=text_encoder,
    tokenizer=tokenizer,
    vae=vae
)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),Q=new oe({props:{title:"Memory Optimization",local:"memory-optimization",headingTag:"h2"}}),Y=new Ve({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLnBpcGVsaW5lcy5wcnglMjBpbXBvcnQlMjBQUlhQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBQUlhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyUGhvdG9yb29tJTJGcHJ4LTUxMi10Mmktc2Z0JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTIwJTIwJTIzJTIwT2ZmbG9hZCUyMGNvbXBvbmVudHMlMjB0byUyMENQVSUyMHdoZW4lMjBub3QlMjBpbiUyMHVzZSUwQSUwQSUyMyUyME9yJTIwdXNlJTIwc2VxdWVudGlhbCUyMENQVSUyMG9mZmxvYWQlMjBmb3IlMjBldmVuJTIwbG93ZXIlMjBtZW1vcnklMEFwaXBlLmVuYWJsZV9zZXF1ZW50aWFsX2NwdV9vZmZsb2FkKCk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.pipelines.prx <span class="hljs-keyword">import</span> PRXPipeline

pipe = PRXPipeline.from_pretrained(<span class="hljs-string">&quot;Photoroom/prx-512-t2i-sft&quot;</span>, torch_dtype=torch.bfloat16)
pipe.enable_model_cpu_offload()  <span class="hljs-comment"># Offload components to CPU when not in use</span>

<span class="hljs-comment"># Or use sequential CPU offload for even lower memory</span>
pipe.enable_sequential_cpu_offload()`,wrap:!1}}),L=new oe({props:{title:"PRXPipeline",local:"diffusers.PRXPipeline",headingTag:"h2"}}),H=new ae({props:{name:"class diffusers.PRXPipeline",anchor:"diffusers.PRXPipeline",parameters:[{name:"transformer",val:": PRXTransformer2DModel"},{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"text_encoder",val:": T5GemmaEncoder"},{name:"tokenizer",val:": typing.Union[transformers.models.t5.tokenization_t5_fast.T5TokenizerFast, transformers.models.gemma.tokenization_gemma_fast.GemmaTokenizerFast, transformers.models.auto.tokenization_auto.AutoTokenizer]"},{name:"vae",val:": typing.Union[diffusers.models.autoencoders.autoencoder_kl.AutoencoderKL, diffusers.models.autoencoders.autoencoder_dc.AutoencoderDC, NoneType] = None"},{name:"default_sample_size",val:": typing.Optional[int] = 512"}],parametersDescription:[{anchor:"diffusers.PRXPipeline.transformer",description:`<strong>transformer</strong> (<code>PRXTransformer2DModel</code>) &#x2014;
The PRX transformer model to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.PRXPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.PRXPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5GemmaEncoder</code>) &#x2014;
Text encoder model for encoding prompts.`,name:"text_encoder"},{anchor:"diffusers.PRXPipeline.tokenizer",description:`<strong>tokenizer</strong> ([<code>T5TokenizerFast</code> or <code>GemmaTokenizerFast</code>]) &#x2014;
Tokenizer for the text encoder.`,name:"tokenizer"},{anchor:"diffusers.PRXPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a> or <a href="/docs/diffusers/main/en/api/models/autoencoder_dc#diffusers.AutoencoderDC">AutoencoderDC</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.
Supports both AutoencoderKL (8x compression) and AutoencoderDC (32x compression).`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/prx/pipeline_prx.py#L252"}}),S=new ae({props:{name:"__call__",anchor:"diffusers.PRXPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": str = ''"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 28"},{name:"timesteps",val:": typing.List[int] = None"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"use_resolution_binning",val:": bool = True"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"}],parametersDescription:[{anchor:"diffusers.PRXPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>
instead.`,name:"prompt"},{anchor:"diffusers.PRXPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.PRXPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.PRXPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.PRXPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 28) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.PRXPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.PRXPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.PRXPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.PRXPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.PRXPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.PRXPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.PRXPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided and <code>guidance_scale &gt; 1</code>, negative embeddings will be generated from an
empty string.`,name:"negative_prompt_embeds"},{anchor:"diffusers.PRXPipeline.__call__.prompt_attention_mask",description:`<strong>prompt_attention_mask</strong> (<code>torch.BoolTensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for <code>prompt_embeds</code>. If not provided, attention mask will be generated
from <code>prompt</code> input argument.`,name:"prompt_attention_mask"},{anchor:"diffusers.PRXPipeline.__call__.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.BoolTensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for <code>negative_prompt_embeds</code>. If not provided and <code>guidance_scale &gt; 1</code>,
attention mask will be generated from an empty string.`,name:"negative_prompt_attention_mask"},{anchor:"diffusers.PRXPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.PRXPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/prx#diffusers.pipelines.prx.PRXPipelineOutput">PRXPipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.PRXPipeline.__call__.use_resolution_binning",description:`<strong>use_resolution_binning</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If set to <code>True</code>, the requested height and width are first mapped to the closest resolutions using
predefined aspect ratio bins. After the produced latents are decoded into images, they are resized back
to the requested resolution. Useful for generating non-square images at optimal resolutions.`,name:"use_resolution_binning"},{anchor:"diffusers.PRXPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self, step, timestep, callback_kwargs)</code>.
<code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.PRXPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include tensors that are listed
in the <code>._callback_tensor_inputs</code> attribute.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/prx/pipeline_prx.py#L526",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/prx#diffusers.pipelines.prx.PRXPipelineOutput"
>PRXPipelineOutput</a> if <code>return_dict</code> is
True, otherwise a \`tuple. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/prx#diffusers.pipelines.prx.PRXPipelineOutput"
>PRXPipelineOutput</a> or <code>tuple</code></p>
`}}),P=new Tt({props:{anchor:"diffusers.PRXPipeline.__call__.example",$$slots:{default:[xt]},$$scope:{ctx:ue}}}),q=new ae({props:{name:"check_inputs",anchor:"diffusers.PRXPipeline.check_inputs",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"height",val:": int"},{name:"width",val:": int"},{name:"guidance_scale",val:": float"},{name:"callback_on_step_end_tensor_inputs",val:": typing.Optional[typing.List[str]] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/prx/pipeline_prx.py#L474"}}),D=new ae({props:{name:"encode_prompt",anchor:"diffusers.PRXPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": str = ''"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/prx/pipeline_prx.py#L371"}}),O=new ae({props:{name:"get_default_resolution",anchor:"diffusers.PRXPipeline.get_default_resolution",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/prx/pipeline_prx.py#L335",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The default sample size (height/width) to use for generation.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>int</p>
`}}),K=new ae({props:{name:"prepare_latents",anchor:"diffusers.PRXPipeline.prepare_latents",parameters:[{name:"batch_size",val:": int"},{name:"num_channels_latents",val:": int"},{name:"height",val:": int"},{name:"width",val:": int"},{name:"dtype",val:": dtype"},{name:"device",val:": device"},{name:"generator",val:": typing.Optional[torch._C.Generator] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/prx/pipeline_prx.py#L347"}}),ee=new oe({props:{title:"PRXPipelineOutput",local:"diffusers.pipelines.prx.PRXPipelineOutput",headingTag:"h2"}}),te=new ae({props:{name:"class diffusers.pipelines.prx.PRXPipelineOutput",anchor:"diffusers.pipelines.prx.PRXPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"}],parametersDescription:[{anchor:"diffusers.pipelines.prx.PRXPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or numpy array of shape <code>(batch_size, height, width, num_channels)</code>. PIL images or numpy array present the denoised images of the diffusion pipeline.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/prx/pipeline_output.py#L25"}}),ne=new Jt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/prx.md"}}),{c(){_=i("meta"),X=a(),T=i("p"),b=a(),d(y.$$.fragment),h=a(),j=i("p"),j.textContent=nt,he=a(),d($.$$.fragment),Me=a(),R=i("p"),R.innerHTML=at,_e=a(),B=i("table"),B.innerHTML=ot,we=a(),C=i("p"),C.innerHTML=lt,be=a(),d(E.$$.fragment),ye=a(),W=i("p"),W.innerHTML=st,je=a(),d(F.$$.fragment),Te=a(),d(V.$$.fragment),Je=a(),G=i("p"),G.textContent=it,xe=a(),d(N.$$.fragment),ve=a(),d(Q.$$.fragment),Ie=a(),z=i("p"),z.textContent=rt,Pe=a(),d(Y.$$.fragment),Ze=a(),d(L.$$.fragment),Ae=a(),p=i("div"),d(H.$$.fragment),Ge=a(),le=i("p"),le.textContent=pt,Ne=a(),se=i("p"),se.innerHTML=dt,Qe=a(),J=i("div"),d(S.$$.fragment),ze=a(),ie=i("p"),ie.textContent=ct,Ye=a(),d(P.$$.fragment),Le=a(),Z=i("div"),d(q.$$.fragment),He=a(),re=i("p"),re.textContent=mt,Se=a(),A=i("div"),d(D.$$.fragment),qe=a(),pe=i("p"),pe.textContent=ft,De=a(),k=i("div"),d(O.$$.fragment),Oe=a(),de=i("p"),de.textContent=gt,Ke=a(),U=i("div"),d(K.$$.fragment),et=a(),ce=i("p"),ce.textContent=ut,ke=a(),d(ee.$$.fragment),Ue=a(),x=i("div"),d(te.$$.fragment),tt=a(),me=i("p"),me.textContent=ht,Xe=a(),d(ne.$$.fragment),$e=a(),ge=i("p"),this.h()},l(e){const t=jt("svelte-u9bgzb",document.head);_=r(t,"META",{name:!0,content:!0}),t.forEach(n),X=o(e),T=r(e,"P",{}),v(T).forEach(n),b=o(e),c(y.$$.fragment,e),h=o(e),j=r(e,"P",{"data-svelte-h":!0}),w(j)!=="svelte-m5sak4"&&(j.textContent=nt),he=o(e),c($.$$.fragment,e),Me=o(e),R=r(e,"P",{"data-svelte-h":!0}),w(R)!=="svelte-1h5j4x4"&&(R.innerHTML=at),_e=o(e),B=r(e,"TABLE",{"data-svelte-h":!0}),w(B)!=="svelte-19j5tak"&&(B.innerHTML=ot),we=o(e),C=r(e,"P",{"data-svelte-h":!0}),w(C)!=="svelte-1enwsbq"&&(C.innerHTML=lt),be=o(e),c(E.$$.fragment,e),ye=o(e),W=r(e,"P",{"data-svelte-h":!0}),w(W)!=="svelte-vpte0l"&&(W.innerHTML=st),je=o(e),c(F.$$.fragment,e),Te=o(e),c(V.$$.fragment,e),Je=o(e),G=r(e,"P",{"data-svelte-h":!0}),w(G)!=="svelte-xfqnac"&&(G.textContent=it),xe=o(e),c(N.$$.fragment,e),ve=o(e),c(Q.$$.fragment,e),Ie=o(e),z=r(e,"P",{"data-svelte-h":!0}),w(z)!=="svelte-8u7gup"&&(z.textContent=rt),Pe=o(e),c(Y.$$.fragment,e),Ze=o(e),c(L.$$.fragment,e),Ae=o(e),p=r(e,"DIV",{class:!0});var M=v(p);c(H.$$.fragment,M),Ge=o(M),le=r(M,"P",{"data-svelte-h":!0}),w(le)!=="svelte-jlclpv"&&(le.textContent=pt),Ne=o(M),se=r(M,"P",{"data-svelte-h":!0}),w(se)!=="svelte-wu1jmh"&&(se.innerHTML=dt),Qe=o(M),J=r(M,"DIV",{class:!0});var fe=v(J);c(S.$$.fragment,fe),ze=o(fe),ie=r(fe,"P",{"data-svelte-h":!0}),w(ie)!=="svelte-v78lg8"&&(ie.textContent=ct),Ye=o(fe),c(P.$$.fragment,fe),fe.forEach(n),Le=o(M),Z=r(M,"DIV",{class:!0});var Be=v(Z);c(q.$$.fragment,Be),He=o(Be),re=r(Be,"P",{"data-svelte-h":!0}),w(re)!=="svelte-x9auef"&&(re.textContent=mt),Be.forEach(n),Se=o(M),A=r(M,"DIV",{class:!0});var Ce=v(A);c(D.$$.fragment,Ce),qe=o(Ce),pe=r(Ce,"P",{"data-svelte-h":!0}),w(pe)!=="svelte-1o7rddz"&&(pe.textContent=ft),Ce.forEach(n),De=o(M),k=r(M,"DIV",{class:!0});var Ee=v(k);c(O.$$.fragment,Ee),Oe=o(Ee),de=r(Ee,"P",{"data-svelte-h":!0}),w(de)!=="svelte-1pf05cy"&&(de.textContent=gt),Ee.forEach(n),Ke=o(M),U=r(M,"DIV",{class:!0});var We=v(U);c(K.$$.fragment,We),et=o(We),ce=r(We,"P",{"data-svelte-h":!0}),w(ce)!=="svelte-vy3whk"&&(ce.textContent=ut),We.forEach(n),M.forEach(n),ke=o(e),c(ee.$$.fragment,e),Ue=o(e),x=r(e,"DIV",{class:!0});var Fe=v(x);c(te.$$.fragment,Fe),tt=o(Fe),me=r(Fe,"P",{"data-svelte-h":!0}),w(me)!=="svelte-1l7a397"&&(me.textContent=ht),Fe.forEach(n),Xe=o(e),c(ne.$$.fragment,e),$e=o(e),ge=r(e,"P",{}),v(ge).forEach(n),this.h()},h(){I(_,"name","hf:doc:metadata"),I(_,"content",It),I(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){s(document.head,_),l(e,X,t),l(e,T,t),l(e,b,t),m(y,e,t),l(e,h,t),l(e,j,t),l(e,he,t),m($,e,t),l(e,Me,t),l(e,R,t),l(e,_e,t),l(e,B,t),l(e,we,t),l(e,C,t),l(e,be,t),m(E,e,t),l(e,ye,t),l(e,W,t),l(e,je,t),m(F,e,t),l(e,Te,t),m(V,e,t),l(e,Je,t),l(e,G,t),l(e,xe,t),m(N,e,t),l(e,ve,t),m(Q,e,t),l(e,Ie,t),l(e,z,t),l(e,Pe,t),m(Y,e,t),l(e,Ze,t),m(L,e,t),l(e,Ae,t),l(e,p,t),m(H,p,null),s(p,Ge),s(p,le),s(p,Ne),s(p,se),s(p,Qe),s(p,J),m(S,J,null),s(J,ze),s(J,ie),s(J,Ye),m(P,J,null),s(p,Le),s(p,Z),m(q,Z,null),s(Z,He),s(Z,re),s(p,Se),s(p,A),m(D,A,null),s(A,qe),s(A,pe),s(p,De),s(p,k),m(O,k,null),s(k,Oe),s(k,de),s(p,Ke),s(p,U),m(K,U,null),s(U,et),s(U,ce),l(e,ke,t),m(ee,e,t),l(e,Ue,t),l(e,x,t),m(te,x,null),s(x,tt),s(x,me),l(e,Xe,t),m(ne,e,t),l(e,$e,t),l(e,ge,t),Re=!0},p(e,[t]){const M={};t&2&&(M.$$scope={dirty:t,ctx:e}),P.$set(M)},i(e){Re||(f(y.$$.fragment,e),f($.$$.fragment,e),f(E.$$.fragment,e),f(F.$$.fragment,e),f(V.$$.fragment,e),f(N.$$.fragment,e),f(Q.$$.fragment,e),f(Y.$$.fragment,e),f(L.$$.fragment,e),f(H.$$.fragment,e),f(S.$$.fragment,e),f(P.$$.fragment,e),f(q.$$.fragment,e),f(D.$$.fragment,e),f(O.$$.fragment,e),f(K.$$.fragment,e),f(ee.$$.fragment,e),f(te.$$.fragment,e),f(ne.$$.fragment,e),Re=!0)},o(e){g(y.$$.fragment,e),g($.$$.fragment,e),g(E.$$.fragment,e),g(F.$$.fragment,e),g(V.$$.fragment,e),g(N.$$.fragment,e),g(Q.$$.fragment,e),g(Y.$$.fragment,e),g(L.$$.fragment,e),g(H.$$.fragment,e),g(S.$$.fragment,e),g(P.$$.fragment,e),g(q.$$.fragment,e),g(D.$$.fragment,e),g(O.$$.fragment,e),g(K.$$.fragment,e),g(ee.$$.fragment,e),g(te.$$.fragment,e),g(ne.$$.fragment,e),Re=!1},d(e){e&&(n(X),n(T),n(b),n(h),n(j),n(he),n(Me),n(R),n(_e),n(B),n(we),n(C),n(be),n(ye),n(W),n(je),n(Te),n(Je),n(G),n(xe),n(ve),n(Ie),n(z),n(Pe),n(Ze),n(Ae),n(p),n(ke),n(Ue),n(x),n(Xe),n($e),n(ge)),n(_),u(y,e),u($,e),u(E,e),u(F,e),u(V,e),u(N,e),u(Q,e),u(Y,e),u(L,e),u(H),u(S),u(P),u(q),u(D),u(O),u(K),u(ee,e),u(te),u(ne,e)}}}const It='{"title":"PRX","local":"prx","sections":[{"title":"Available models","local":"available-models","sections":[],"depth":2},{"title":"Loading the pipeline","local":"loading-the-pipeline","sections":[{"title":"Manual Component Loading","local":"manual-component-loading","sections":[],"depth":3}],"depth":2},{"title":"Memory Optimization","local":"memory-optimization","sections":[],"depth":2},{"title":"PRXPipeline","local":"diffusers.PRXPipeline","sections":[],"depth":2},{"title":"PRXPipelineOutput","local":"diffusers.pipelines.prx.PRXPipelineOutput","sections":[],"depth":2}],"depth":1}';function Pt(ue){return _t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rt extends bt{constructor(_){super(),yt(this,_,Pt,vt,Mt,{})}}export{Rt as component};
