import{s as us,o as fs,n as Ms}from"../chunks/scheduler.182ea377.js";import{S as ds,i as hs,g as i,s as n,r,A as ys,h as p,f as l,c as a,j as cs,u as c,x as o,k as $,y as bs,a as s,v as m,d as M,t as u,w as f}from"../chunks/index.abf12888.js";import{T as ms}from"../chunks/Tip.230e2334.js";import{C as y}from"../chunks/CodeBlock.57fe6e13.js";import{H as b}from"../chunks/Heading.16916d63.js";function js(Ne){let d,j='Support for <code>fuse_qkv_projections()</code> is limited and experimental. As such, it’s not available for many non-SD pipelines such as <a href="../using-diffusers/kandinsky.md">Kandinsky</a>. You can refer to <a href="https://github.com/huggingface/diffusers/pull/6179" rel="nofollow">this PR</a> to get an idea about how to support this kind of computation.';return{c(){d=i("p"),d.innerHTML=j},l(h){d=p(h,"P",{"data-svelte-h":!0}),o(d)!=="svelte-izvj6c"&&(d.innerHTML=j)},m(h,w){s(h,d,w)},p:Ms,d(h){h&&l(d)}}}function ws(Ne){let d,j='Through experimentation, we found that certain linear layers in the UNet and the VAE don’t benefit from dynamic int8 quantization. You can check out the full code for filtering those layers <a href="https://github.com/huggingface/diffusion-fast/blob/0f169640b1db106fe6a479f78c1ed3bfaeba3386/utils/pipeline_utils.py#L16" rel="nofollow">here</a> (referred to as <code>dynamic_quant_filter_fn</code> below).';return{c(){d=i("p"),d.innerHTML=j},l(h){d=p(h,"P",{"data-svelte-h":!0}),o(d)!=="svelte-1xe2fym"&&(d.innerHTML=j)},m(h,w){s(h,d,w)},p:Ms,d(h){h&&l(d)}}}function Js(Ne){let d,j,h,w,I,Ee,G,dl="Diffusion models are known to be slower than their counter parts, GANs, because of the iterative and sequential reverse diffusion process. Recent works try to address limitation with:",Ye,B,hl='<li>progressive timestep distillation (such as <a href="../using-diffusers/inference_with_lcm_lora.md">LCM LoRA</a>)</li> <li>model compression (such as <a href="https://huggingface.co/segmind/SSD-1B" rel="nofollow">SSD-1B</a>)</li> <li>reusing adjacent features of the denoiser (such as <a href="https://github.com/horseee/DeepCache" rel="nofollow">DeepCache</a>)</li>',ze,k,yl='In this tutorial, we focus on leveraging the power of PyTorch 2 to accelerate the inference latency of text-to-image diffusion pipeline, instead. We will use <a href="../using-diffusers/sdxl.md">Stable Diffusion XL (SDXL)</a> as a case study, but the techniques we will discuss should extend to other text-to-image diffusion pipelines.',De,x,qe,A,bl="Make sure you’re on the latest version of <code>diffusers</code>:",Pe,W,Ke,X,jl="Then upgrade the other required libraries too:",Oe,S,et,V,wl='To benefit from the fastest kernels, use PyTorch nightly. You can find the installation instructions <a href="https://pytorch.org/" rel="nofollow">here</a>.',tt,R,Jl="To report the numbers shown below, we used an 80GB 400W A100 with its clock rate set to the maximum.",lt,H,Tl='<em>This tutorial doesn’t present the benchmarking code and focuses on how to perform the optimizations, instead. For the full benchmarking code, refer to: <a href="https://github.com/huggingface/diffusion-fast" rel="nofollow">https://github.com/huggingface/diffusion-fast</a>.</em>',st,F,nt,Q,Ul='Let’s start with a baseline. Disable the use of a reduced precision and <a href="../optimization/torch2.0.md"><code>scaled_dot_product_attention</code></a>:',at,N,it,L,Cl="This takes 7.36 seconds:",pt,J,gl='<img src="https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/progressive-acceleration-sdxl/SDXL%2C_Batch_Size%3A_1%2C_Steps%3A_30_0.png" width="500"/>',ot,E,rt,Y,vl="Enable the first optimization: use a reduced precision to run the inference.",ct,z,mt,D,_l="bfloat16 reduces the latency from 7.36 seconds to 4.63 seconds:",Mt,T,Zl='<img src="https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/progressive-acceleration-sdxl/SDXL%2C_Batch_Size%3A_1%2C_Steps%3A_30_1.png" width="500"/>',ut,q,$l="<em>(We later ran the experiments in float16 and found out that the recent versions of torchao do not incur numerical problems from float16.)</em>",ft,P,Il="<strong>Why bfloat16?</strong>",dt,K,Gl="<li>Using a reduced numerical precision (such as float16, bfloat16) to run inference doesn’t affect the generation quality but significantly improves latency.</li> <li>The benefits of using the bfloat16 numerical precision as compared to float16 are hardware-dependent. Modern generations of GPUs tend to favor bfloat16.</li> <li>Furthermore, in our experiments, we bfloat16 to be much more resilient when used with quantization in comparison to float16.</li>",ht,O,Bl='We have a <a href="../optimization/fp16.md">dedicated guide</a> for running inference in a reduced precision.',yt,ee,bt,te,kl='Attention blocks are intensive to run. But with PyTorch’s <a href="../optimization/torch2.0.md"><code>scaled_dot_product_attention</code></a>, we can run them efficiently.',jt,le,wt,se,xl="<code>scaled_dot_product_attention</code> improves the latency from 4.63 seconds to 3.31 seconds.",Jt,U,Al='<img src="https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/progressive-acceleration-sdxl/SDXL%2C_Batch_Size%3A_1%2C_Steps%3A_30_2.png" width="500"/>',Tt,ne,Ut,ae,Wl="Compile the UNet and the VAE to benefit from the faster kernels. First, configure a few compiler flags:",Ct,ie,gt,pe,Xl='For the full list of compiler flags, refer to <a href="https://github.com/pytorch/pytorch/blob/main/torch/_inductor/config.py" rel="nofollow">this file</a>.',vt,oe,Sl="It is also important to change the memory layout of the UNet and the VAE to “channels_last” when compiling them. This ensures maximum speed:",_t,re,Zt,ce,Vl="Then, compile and perform inference:",$t,me,It,Me,Rl="<code>torch.compile</code> offers different backends and modes. As we’re aiming for maximum inference speed, we opt for the inductor backend using the “max-autotune”. “max-autotune” uses CUDA graphs and optimizes the compilation graph specifically for latency. Using CUDA graphs greatly reduces the overhead of launching GPU operations. It saves time by using a mechanism to launch multiple GPU operations through a single CPU operation.",Gt,ue,Hl="Specifying fullgraph to be True ensures that there are no graph breaks in the underlying model, ensuring the fullest potential of <code>torch.compile</code>.",Bt,fe,Fl="Using SDPA attention and compiling both the UNet and VAE reduces the latency from 3.31 seconds to 2.54 seconds.",kt,C,Ql='<img src="https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/progressive-acceleration-sdxl/SDXL%2C_Batch_Size%3A_1%2C_Steps%3A_30_3.png" width="500"/>',xt,de,At,he,Nl="Both the UNet and the VAE used in SDXL make use of Transformer-like blocks. A Transformer block consists of attention blocks and feed-forward blocks.",Wt,ye,Ll="In an attention block, the input is projected into three sub-spaces using three different projection matrices – Q, K, and V. In the naive implementation, these projections are performed separately on the input. But we can horizontally combine the projection matrices into a single matrix and perform the projection in one shot. This increases the size of the matmuls of the input projections and improves the impact of quantization (to be discussed next).",Xt,be,El="Enabling this kind of computation in Diffusers just takes a single line of code:",St,je,Vt,we,Yl="It provides a minor boost from 2.54 seconds to 2.52 seconds.",Rt,g,zl='<img src="https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/progressive-acceleration-sdxl/SDXL%2C_Batch_Size%3A_1%2C_Steps%3A_30_4.png" width="500"/>',Ht,v,Ft,Je,Qt,Te,Dl='Aapply <a href="https://pytorch.org/tutorials/recipes/recipes/dynamic_quantization.html" rel="nofollow">dynamic int8 quantization</a> to both the UNet and the VAE. This is because quantization adds additional conversion overhead to the model that is hopefully made up for by faster matmuls (dynamic quantization). If the matmuls are too small, these techniques may degrade performance.',Nt,_,Lt,Ue,ql='You will leverage the ultra-lightweight pure PyTorch library <a href="https://github.com/pytorch-labs/ao" rel="nofollow">torchao</a> (commit SHA: 54bcd5a10d0abbe7b0c045052029257099f83fd9) to use its user-friendly APIs for quantization.',Et,Ce,Pl="First, configure all the compiler tags:",Yt,ge,zt,ve,Kl="Define the filtering functions:",Dt,_e,qt,Ze,Ol="Then apply all the optimizations discussed so far:",Pt,$e,Kt,Ie,es="Since this quantization support is limited to linear layers only, we also turn suitable pointwise convolution layers into linear layers to maximize the benefit.",Ot,Ge,el,Be,ts="Apply dynamic quantization:",tl,ke,ll,xe,ls="Finally, compile and perform inference:",sl,Ae,nl,We,ss="Applying dynamic quantization improves the latency from 2.52 seconds to 2.43 seconds.",al,Z,ns='<img src="https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/progressive-acceleration-sdxl/SDXL%2C_Batch_Size%3A_1%2C_Steps%3A_30_5.png" width="500"/>',il,Xe,pl,Se,ol,Ve,as="Ensuring that the underlying model/method can be fully compiled is crucial for performance (torch.compile with fullgraph=True). This means having no graph breaks. We did this for the UNet and VAE by changing how we access the returning variables. Consider the following example:",rl,Re,cl,He,ml,Fe,is='During the iterative reverse diffusion process, we <a href="https://github.com/huggingface/diffusers/blob/1d686bac8146037e97f3fd8c56e4063230f71751/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl.py#L1228" rel="nofollow">call</a> <code>step()</code> on the scheduler each time after the denoiser predicts the less noisy latent embeddings. Inside <code>step()</code>, the <code>sigmas</code> variable is <a href="https://github.com/huggingface/diffusers/blob/1d686bac8146037e97f3fd8c56e4063230f71751/src/diffusers/schedulers/scheduling_euler_discrete.py#L476" rel="nofollow">indexed</a>. If the <code>sigmas</code> array is placed on the GPU, indexing causes a communication sync between the CPU and GPU. This causes a latency, and it becomes more evident when the denoiser has already been compiled.',Ml,Qe,ps='But if the <code>sigmas</code> array always stays on the CPU (refer to <a href="https://github.com/huggingface/diffusers/blob/35a969d297cba69110d175ee79c59312b9f49e1e/src/diffusers/schedulers/scheduling_euler_discrete.py#L240" rel="nofollow">this line</a>), this sync doesn’t take place, hence improved latency. In general, any CPU &lt;-&gt; GPU communication sync should be none or be kept to a bare minimum as it can impact inference latency.',ul,Le,fl;return I=new b({props:{title:"Accelerate inference of text-to-image diffusion models",local:"accelerate-inference-of-text-to-image-diffusion-models",headingTag:"h1"}}),x=new b({props:{title:"Setup",local:"setup",headingTag:"h2"}}),W=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZGlmZnVzZXJz",highlighted:"pip install -U diffusers",wrap:!1}}),S=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZSUyMHBlZnQ=",highlighted:"pip install -U transformers accelerate peft",wrap:!1}}),F=new b({props:{title:"Baseline",local:"baseline",headingTag:"h2"}}),N=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwcGlwZWxpbmUlMjBpbiUyMGZ1bGwtcHJlY2lzaW9uJTIwYW5kJTIwcGxhY2UlMjBpdHMlMjBtb2RlbCUyMGNvbXBvbmVudHMlMjBvbiUyMENVREEuJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUwQSkudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBSdW4lMjB0aGUlMjBhdHRlbnRpb24lMjBvcHMlMjB3aXRob3V0JTIwZWZmaWNpZW5jeS4lMEFwaXBlLnVuZXQuc2V0X2RlZmF1bHRfYXR0bl9wcm9jZXNzb3IoKSUwQXBpcGUudmFlLnNldF9kZWZhdWx0X2F0dG5fcHJvY2Vzc29yKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBjb2xkJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwbXV0ZWQlMjBjb2xvcnMlMkMlMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QzMCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

<span class="hljs-comment"># Load the pipeline in full-precision and place its model components on CUDA.</span>
pipe = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Run the attention ops without efficiency.</span>
pipe.unet.set_default_attn_processor()
pipe.vae.set_default_attn_processor()

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),E=new b({props:{title:"Running inference in bfloat16",local:"running-inference-in-bfloat16",headingTag:"h2"}}),z=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMDklMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMFJ1biUyMHRoZSUyMGF0dGVudGlvbiUyMG9wcyUyMHdpdGhvdXQlMjBlZmZpY2llbmN5LiUwQXBpcGUudW5ldC5zZXRfZGVmYXVsdF9hdHRuX3Byb2Nlc3NvcigpJTBBcGlwZS52YWUuc2V0X2RlZmF1bHRfYXR0bl9wcm9jZXNzb3IoKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDMwKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline
<span class="hljs-keyword">import</span> torch

pipe = StableDiffusionXLPipeline.from_pretrained(
	<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.bfloat16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Run the attention ops without efficiency.</span>
pipe.unet.set_default_attn_processor()
pipe.vae.set_default_attn_processor()

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ee=new b({props:{title:"Running attention efficiently",local:"running-attention-efficiently",headingTag:"h2"}}),le=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMDklMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDMwKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline
<span class="hljs-keyword">import</span> torch

pipe = StableDiffusionXLPipeline.from_pretrained(
	<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.bfloat16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ne=new b({props:{title:"Use faster kernels with torch.compile",local:"use-faster-kernels-with-torchcompile",headingTag:"h2"}}),ie=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuY29udl8xeDFfYXNfbW0lMjAlM0QlMjBUcnVlJTBBdG9yY2guX2luZHVjdG9yLmNvbmZpZy5jb29yZGluYXRlX2Rlc2NlbnRfdHVuaW5nJTIwJTNEJTIwVHJ1ZSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuZXBpbG9ndWVfZnVzaW9uJTIwJTNEJTIwRmFsc2UlMEF0b3JjaC5faW5kdWN0b3IuY29uZmlnLmNvb3JkaW5hdGVfZGVzY2VudF9jaGVja19hbGxfZGlyZWN0aW9ucyUyMCUzRCUyMFRydWU=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline
<span class="hljs-keyword">import</span> torch

torch._inductor.config.conv_1x1_as_mm = <span class="hljs-literal">True</span>
torch._inductor.config.coordinate_descent_tuning = <span class="hljs-literal">True</span>
torch._inductor.config.epilogue_fusion = <span class="hljs-literal">False</span>
torch._inductor.config.coordinate_descent_check_all_directions = <span class="hljs-literal">True</span>`,wrap:!1}}),re=new y({props:{code:"cGlwZS51bmV0LnRvKG1lbW9yeV9mb3JtYXQlM0R0b3JjaC5jaGFubmVsc19sYXN0KSUwQXBpcGUudmFlLnRvKG1lbW9yeV9mb3JtYXQlM0R0b3JjaC5jaGFubmVsc19sYXN0KQ==",highlighted:`pipe.unet.to(memory_format=torch.channels_last)
pipe.vae.to(memory_format=torch.channels_last)`,wrap:!1}}),me=new y({props:{code:"JTIzJTIwQ29tcGlsZSUyMHRoZSUyMFVOZXQlMjBhbmQlMjBWQUUuJTBBcGlwZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnVuZXQlMkMlMjBtb2RlJTNEJTIybWF4LWF1dG90dW5lJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEFwaXBlLnZhZS5kZWNvZGUlMjAlM0QlMjB0b3JjaC5jb21waWxlKHBpcGUudmFlLmRlY29kZSUyQyUyMG1vZGUlM0QlMjJtYXgtYXV0b3R1bmUlMjIlMkMlMjBmdWxsZ3JhcGglM0RUcnVlKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEElMEElMjMlMjBGaXJzdCUyMGNhbGwlMjB0byUyMCU2MHBpcGUlNjAlMjB3aWxsJTIwYmUlMjBzbG93JTJDJTIwc3Vic2VxdWVudCUyMG9uZXMlMjB3aWxsJTIwYmUlMjBmYXN0ZXIuJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QzMCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-comment"># Compile the UNet and VAE.</span>
pipe.unet = torch.<span class="hljs-built_in">compile</span>(pipe.unet, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
pipe.vae.decode = torch.<span class="hljs-built_in">compile</span>(pipe.vae.decode, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># First call to \`pipe\` will be slow, subsequent ones will be faster.</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),de=new b({props:{title:"Combine the projection matrices of attention",local:"combine-the-projection-matrices-of-attention",headingTag:"h2"}}),je=new y({props:{code:"cGlwZS5mdXNlX3Frdl9wcm9qZWN0aW9ucygp",highlighted:"pipe.fuse_qkv_projections()",wrap:!1}}),v=new ms({props:{warning:!0,$$slots:{default:[js]},$$scope:{ctx:Ne}}}),Je=new b({props:{title:"Dynamic quantization",local:"dynamic-quantization",headingTag:"h2"}}),_=new ms({props:{$$slots:{default:[ws]},$$scope:{ctx:Ne}}}),ge=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUyMCUwQSUwQSUyMyUyME5vdGljZSUyMHRoZSUyMHR3byUyMG5ldyUyMGZsYWdzJTIwYXQlMjB0aGUlMjBlbmQuJTBBdG9yY2guX2luZHVjdG9yLmNvbmZpZy5jb252XzF4MV9hc19tbSUyMCUzRCUyMFRydWUlMEF0b3JjaC5faW5kdWN0b3IuY29uZmlnLmNvb3JkaW5hdGVfZGVzY2VudF90dW5pbmclMjAlM0QlMjBUcnVlJTBBdG9yY2guX2luZHVjdG9yLmNvbmZpZy5lcGlsb2d1ZV9mdXNpb24lMjAlM0QlMjBGYWxzZSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuY29vcmRpbmF0ZV9kZXNjZW50X2NoZWNrX2FsbF9kaXJlY3Rpb25zJTIwJTNEJTIwVHJ1ZSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuZm9yY2VfZnVzZV9pbnRfbW1fd2l0aF9tdWwlMjAlM0QlMjBUcnVlJTBBdG9yY2guX2luZHVjdG9yLmNvbmZpZy51c2VfbWl4ZWRfbW0lMjAlM0QlMjBUcnVl",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline
<span class="hljs-keyword">import</span> torch 

<span class="hljs-comment"># Notice the two new flags at the end.</span>
torch._inductor.config.conv_1x1_as_mm = <span class="hljs-literal">True</span>
torch._inductor.config.coordinate_descent_tuning = <span class="hljs-literal">True</span>
torch._inductor.config.epilogue_fusion = <span class="hljs-literal">False</span>
torch._inductor.config.coordinate_descent_check_all_directions = <span class="hljs-literal">True</span>
torch._inductor.config.force_fuse_int_mm_with_mul = <span class="hljs-literal">True</span>
torch._inductor.config.use_mixed_mm = <span class="hljs-literal">True</span>`,wrap:!1}}),_e=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">dynamic_quant_filter_fn</span>(<span class="hljs-params">mod, *args</span>):
    <span class="hljs-keyword">return</span> (
        <span class="hljs-built_in">isinstance</span>(mod, torch.nn.Linear)
        <span class="hljs-keyword">and</span> mod.in_features &gt; <span class="hljs-number">16</span>
        <span class="hljs-keyword">and</span> (mod.in_features, mod.out_features)
        <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [
            (<span class="hljs-number">1280</span>, <span class="hljs-number">640</span>),
            (<span class="hljs-number">1920</span>, <span class="hljs-number">1280</span>),
            (<span class="hljs-number">1920</span>, <span class="hljs-number">640</span>),
            (<span class="hljs-number">2048</span>, <span class="hljs-number">1280</span>),
            (<span class="hljs-number">2048</span>, <span class="hljs-number">2560</span>),
            (<span class="hljs-number">2560</span>, <span class="hljs-number">1280</span>),
            (<span class="hljs-number">256</span>, <span class="hljs-number">128</span>),
            (<span class="hljs-number">2816</span>, <span class="hljs-number">1280</span>),
            (<span class="hljs-number">320</span>, <span class="hljs-number">640</span>),
            (<span class="hljs-number">512</span>, <span class="hljs-number">1536</span>),
            (<span class="hljs-number">512</span>, <span class="hljs-number">256</span>),
            (<span class="hljs-number">512</span>, <span class="hljs-number">512</span>),
            (<span class="hljs-number">640</span>, <span class="hljs-number">1280</span>),
            (<span class="hljs-number">640</span>, <span class="hljs-number">1920</span>),
            (<span class="hljs-number">640</span>, <span class="hljs-number">320</span>),
            (<span class="hljs-number">640</span>, <span class="hljs-number">5120</span>),
            (<span class="hljs-number">640</span>, <span class="hljs-number">640</span>),
            (<span class="hljs-number">960</span>, <span class="hljs-number">320</span>),
            (<span class="hljs-number">960</span>, <span class="hljs-number">640</span>),
        ]
    )


<span class="hljs-keyword">def</span> <span class="hljs-title function_">conv_filter_fn</span>(<span class="hljs-params">mod, *args</span>):
    <span class="hljs-keyword">return</span> (
        <span class="hljs-built_in">isinstance</span>(mod, torch.nn.Conv2d) <span class="hljs-keyword">and</span> mod.kernel_size == (<span class="hljs-number">1</span>, <span class="hljs-number">1</span>) <span class="hljs-keyword">and</span> <span class="hljs-number">128</span> <span class="hljs-keyword">in</span> [mod.in_channels, mod.out_channels]
    )`,wrap:!1}}),$e=new y({props:{code:"JTIzJTIwU0RQQSUyMCUyQiUyMGJmbG9hdDE2LiUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMDklMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMENvbWJpbmUlMjBhdHRlbnRpb24lMjBwcm9qZWN0aW9uJTIwbWF0cmljZXMuJTBBcGlwZS5mdXNlX3Frdl9wcm9qZWN0aW9ucygpJTBBJTBBJTIzJTIwQ2hhbmdlJTIwdGhlJTIwbWVtb3J5JTIwbGF5b3V0LiUwQXBpcGUudW5ldC50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCklMEFwaXBlLnZhZS50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCk=",highlighted:`<span class="hljs-comment"># SDPA + bfloat16.</span>
pipe = StableDiffusionXLPipeline.from_pretrained(
	<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.bfloat16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Combine attention projection matrices.</span>
pipe.fuse_qkv_projections()

<span class="hljs-comment"># Change the memory layout.</span>
pipe.unet.to(memory_format=torch.channels_last)
pipe.vae.to(memory_format=torch.channels_last)`,wrap:!1}}),Ge=new y({props:{code:"ZnJvbSUyMHRvcmNoYW8lMjBpbXBvcnQlMjBzd2FwX2NvbnYyZF8xeDFfdG9fbGluZWFyJTBBJTBBc3dhcF9jb252MmRfMXgxX3RvX2xpbmVhcihwaXBlLnVuZXQlMkMlMjBjb252X2ZpbHRlcl9mbiklMEFzd2FwX2NvbnYyZF8xeDFfdG9fbGluZWFyKHBpcGUudmFlJTJDJTIwY29udl9maWx0ZXJfZm4p",highlighted:`<span class="hljs-keyword">from</span> torchao <span class="hljs-keyword">import</span> swap_conv2d_1x1_to_linear

swap_conv2d_1x1_to_linear(pipe.unet, conv_filter_fn)
swap_conv2d_1x1_to_linear(pipe.vae, conv_filter_fn)`,wrap:!1}}),ke=new y({props:{code:"ZnJvbSUyMHRvcmNoYW8lMjBpbXBvcnQlMjBhcHBseV9keW5hbWljX3F1YW50JTBBJTBBYXBwbHlfZHluYW1pY19xdWFudChwaXBlLnVuZXQlMkMlMjBkeW5hbWljX3F1YW50X2ZpbHRlcl9mbiklMEFhcHBseV9keW5hbWljX3F1YW50KHBpcGUudmFlJTJDJTIwZHluYW1pY19xdWFudF9maWx0ZXJfZm4p",highlighted:`<span class="hljs-keyword">from</span> torchao <span class="hljs-keyword">import</span> apply_dynamic_quant

apply_dynamic_quant(pipe.unet, dynamic_quant_filter_fn)
apply_dynamic_quant(pipe.vae, dynamic_quant_filter_fn)`,wrap:!1}}),Ae=new y({props:{code:"cGlwZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnVuZXQlMkMlMjBtb2RlJTNEJTIybWF4LWF1dG90dW5lJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEFwaXBlLnZhZS5kZWNvZGUlMjAlM0QlMjB0b3JjaC5jb21waWxlKHBpcGUudmFlLmRlY29kZSUyQyUyMG1vZGUlM0QlMjJtYXgtYXV0b3R1bmUlMjIlMkMlMjBmdWxsZ3JhcGglM0RUcnVlKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDMwKS5pbWFnZXMlNUIwJTVE",highlighted:`pipe.unet = torch.<span class="hljs-built_in">compile</span>(pipe.unet, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
pipe.vae.decode = torch.<span class="hljs-built_in">compile</span>(pipe.vae.decode, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Xe=new b({props:{title:"Misc",local:"misc",headingTag:"h2"}}),Se=new b({props:{title:"No graph breaks during torch.compile",local:"no-graph-breaks-during-torchcompile",headingTag:"h3"}}),Re=new y({props:{code:"LSUyMGxhdGVudHMlMjAlM0QlMjB1bmV0KCUwQS0lMDlsYXRlbnRzJTJDJTIwdGltZXN0ZXAlM0R0aW1lc3RlcCUyQyUyMGVuY29kZXJfaGlkZGVuX3N0YXRlcyUzRHByb21wdF9lbWJlZHMlMEEtKS5zYW1wbGUlMEElMEElMkIlMjBsYXRlbnRzJTIwJTNEJTIwdW5ldCglMEElMkIlMDlsYXRlbnRzJTJDJTIwdGltZXN0ZXAlM0R0aW1lc3RlcCUyQyUyMGVuY29kZXJfaGlkZGVuX3N0YXRlcyUzRHByb21wdF9lbWJlZHMlMkMlMjByZXR1cm5fZGljdCUzREZhbHNlJTBBJTJCKSU1QjAlNUQ=",highlighted:`<span class="hljs-deletion">- latents = unet(</span>
<span class="hljs-deletion">-	latents, timestep=timestep, encoder_hidden_states=prompt_embeds</span>
<span class="hljs-deletion">-).sample</span>

<span class="hljs-addition">+ latents = unet(</span>
<span class="hljs-addition">+	latents, timestep=timestep, encoder_hidden_states=prompt_embeds, return_dict=False</span>
<span class="hljs-addition">+)[0]</span>`,wrap:!1}}),He=new b({props:{title:"Getting rid of GPU syncs after compilation",local:"getting-rid-of-gpu-syncs-after-compilation",headingTag:"h3"}}),{c(){d=i("meta"),j=n(),h=i("p"),w=n(),r(I.$$.fragment),Ee=n(),G=i("p"),G.textContent=dl,Ye=n(),B=i("ul"),B.innerHTML=hl,ze=n(),k=i("p"),k.innerHTML=yl,De=n(),r(x.$$.fragment),qe=n(),A=i("p"),A.innerHTML=bl,Pe=n(),r(W.$$.fragment),Ke=n(),X=i("p"),X.textContent=jl,Oe=n(),r(S.$$.fragment),et=n(),V=i("p"),V.innerHTML=wl,tt=n(),R=i("p"),R.textContent=Jl,lt=n(),H=i("p"),H.innerHTML=Tl,st=n(),r(F.$$.fragment),nt=n(),Q=i("p"),Q.innerHTML=Ul,at=n(),r(N.$$.fragment),it=n(),L=i("p"),L.textContent=Cl,pt=n(),J=i("div"),J.innerHTML=gl,ot=n(),r(E.$$.fragment),rt=n(),Y=i("p"),Y.textContent=vl,ct=n(),r(z.$$.fragment),mt=n(),D=i("p"),D.textContent=_l,Mt=n(),T=i("div"),T.innerHTML=Zl,ut=n(),q=i("p"),q.innerHTML=$l,ft=n(),P=i("p"),P.innerHTML=Il,dt=n(),K=i("ul"),K.innerHTML=Gl,ht=n(),O=i("p"),O.innerHTML=Bl,yt=n(),r(ee.$$.fragment),bt=n(),te=i("p"),te.innerHTML=kl,jt=n(),r(le.$$.fragment),wt=n(),se=i("p"),se.innerHTML=xl,Jt=n(),U=i("div"),U.innerHTML=Al,Tt=n(),r(ne.$$.fragment),Ut=n(),ae=i("p"),ae.textContent=Wl,Ct=n(),r(ie.$$.fragment),gt=n(),pe=i("p"),pe.innerHTML=Xl,vt=n(),oe=i("p"),oe.textContent=Sl,_t=n(),r(re.$$.fragment),Zt=n(),ce=i("p"),ce.textContent=Vl,$t=n(),r(me.$$.fragment),It=n(),Me=i("p"),Me.innerHTML=Rl,Gt=n(),ue=i("p"),ue.innerHTML=Hl,Bt=n(),fe=i("p"),fe.textContent=Fl,kt=n(),C=i("div"),C.innerHTML=Ql,xt=n(),r(de.$$.fragment),At=n(),he=i("p"),he.textContent=Nl,Wt=n(),ye=i("p"),ye.textContent=Ll,Xt=n(),be=i("p"),be.textContent=El,St=n(),r(je.$$.fragment),Vt=n(),we=i("p"),we.textContent=Yl,Rt=n(),g=i("div"),g.innerHTML=zl,Ht=n(),r(v.$$.fragment),Ft=n(),r(Je.$$.fragment),Qt=n(),Te=i("p"),Te.innerHTML=Dl,Nt=n(),r(_.$$.fragment),Lt=n(),Ue=i("p"),Ue.innerHTML=ql,Et=n(),Ce=i("p"),Ce.textContent=Pl,Yt=n(),r(ge.$$.fragment),zt=n(),ve=i("p"),ve.textContent=Kl,Dt=n(),r(_e.$$.fragment),qt=n(),Ze=i("p"),Ze.textContent=Ol,Pt=n(),r($e.$$.fragment),Kt=n(),Ie=i("p"),Ie.textContent=es,Ot=n(),r(Ge.$$.fragment),el=n(),Be=i("p"),Be.textContent=ts,tl=n(),r(ke.$$.fragment),ll=n(),xe=i("p"),xe.textContent=ls,sl=n(),r(Ae.$$.fragment),nl=n(),We=i("p"),We.textContent=ss,al=n(),Z=i("div"),Z.innerHTML=ns,il=n(),r(Xe.$$.fragment),pl=n(),r(Se.$$.fragment),ol=n(),Ve=i("p"),Ve.textContent=as,rl=n(),r(Re.$$.fragment),cl=n(),r(He.$$.fragment),ml=n(),Fe=i("p"),Fe.innerHTML=is,Ml=n(),Qe=i("p"),Qe.innerHTML=ps,ul=n(),Le=i("p"),this.h()},l(e){const t=ys("svelte-u9bgzb",document.head);d=p(t,"META",{name:!0,content:!0}),t.forEach(l),j=a(e),h=p(e,"P",{}),cs(h).forEach(l),w=a(e),c(I.$$.fragment,e),Ee=a(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-pkpiyo"&&(G.textContent=dl),Ye=a(e),B=p(e,"UL",{"data-svelte-h":!0}),o(B)!=="svelte-1n3ja6f"&&(B.innerHTML=hl),ze=a(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1ahq65p"&&(k.innerHTML=yl),De=a(e),c(x.$$.fragment,e),qe=a(e),A=p(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-609t4e"&&(A.innerHTML=bl),Pe=a(e),c(W.$$.fragment,e),Ke=a(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1s5viqc"&&(X.textContent=jl),Oe=a(e),c(S.$$.fragment,e),et=a(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-2y23yy"&&(V.innerHTML=wl),tt=a(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-zfizj4"&&(R.textContent=Jl),lt=a(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-teht3n"&&(H.innerHTML=Tl),st=a(e),c(F.$$.fragment,e),nt=a(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-zqipth"&&(Q.innerHTML=Ul),at=a(e),c(N.$$.fragment,e),it=a(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1x1lehr"&&(L.textContent=Cl),pt=a(e),J=p(e,"DIV",{align:!0,"data-svelte-h":!0}),o(J)!=="svelte-1do855s"&&(J.innerHTML=gl),ot=a(e),c(E.$$.fragment,e),rt=a(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-59kzwp"&&(Y.textContent=vl),ct=a(e),c(z.$$.fragment,e),mt=a(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1kdjw5n"&&(D.textContent=_l),Mt=a(e),T=p(e,"DIV",{align:!0,"data-svelte-h":!0}),o(T)!=="svelte-lxnqqr"&&(T.innerHTML=Zl),ut=a(e),q=p(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1wnf046"&&(q.innerHTML=$l),ft=a(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-17gxfqr"&&(P.innerHTML=Il),dt=a(e),K=p(e,"UL",{"data-svelte-h":!0}),o(K)!=="svelte-eu6tje"&&(K.innerHTML=Gl),ht=a(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-ezaz6j"&&(O.innerHTML=Bl),yt=a(e),c(ee.$$.fragment,e),bt=a(e),te=p(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-i6cij5"&&(te.innerHTML=kl),jt=a(e),c(le.$$.fragment,e),wt=a(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1ya4pwz"&&(se.innerHTML=xl),Jt=a(e),U=p(e,"DIV",{align:!0,"data-svelte-h":!0}),o(U)!=="svelte-1vt8crq"&&(U.innerHTML=Al),Tt=a(e),c(ne.$$.fragment,e),Ut=a(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-125vukj"&&(ae.textContent=Wl),Ct=a(e),c(ie.$$.fragment,e),gt=a(e),pe=p(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-wn8tu2"&&(pe.innerHTML=Xl),vt=a(e),oe=p(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-1xhp6zo"&&(oe.textContent=Sl),_t=a(e),c(re.$$.fragment,e),Zt=a(e),ce=p(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-1huthp1"&&(ce.textContent=Vl),$t=a(e),c(me.$$.fragment,e),It=a(e),Me=p(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-19rkk08"&&(Me.innerHTML=Rl),Gt=a(e),ue=p(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-z2z0tn"&&(ue.innerHTML=Hl),Bt=a(e),fe=p(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-ax8e93"&&(fe.textContent=Fl),kt=a(e),C=p(e,"DIV",{align:!0,"data-svelte-h":!0}),o(C)!=="svelte-h7n375"&&(C.innerHTML=Ql),xt=a(e),c(de.$$.fragment,e),At=a(e),he=p(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-1ok923t"&&(he.textContent=Nl),Wt=a(e),ye=p(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-1vgoh8g"&&(ye.textContent=Ll),Xt=a(e),be=p(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-1g4675p"&&(be.textContent=El),St=a(e),c(je.$$.fragment,e),Vt=a(e),we=p(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-1ip60rj"&&(we.textContent=Yl),Rt=a(e),g=p(e,"DIV",{align:!0,"data-svelte-h":!0}),o(g)!=="svelte-bdlltg"&&(g.innerHTML=zl),Ht=a(e),c(v.$$.fragment,e),Ft=a(e),c(Je.$$.fragment,e),Qt=a(e),Te=p(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-k2whf5"&&(Te.innerHTML=Dl),Nt=a(e),c(_.$$.fragment,e),Lt=a(e),Ue=p(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-1egpvb2"&&(Ue.innerHTML=ql),Et=a(e),Ce=p(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-gvi9jq"&&(Ce.textContent=Pl),Yt=a(e),c(ge.$$.fragment,e),zt=a(e),ve=p(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-tgt4ub"&&(ve.textContent=Kl),Dt=a(e),c(_e.$$.fragment,e),qt=a(e),Ze=p(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-1848xq7"&&(Ze.textContent=Ol),Pt=a(e),c($e.$$.fragment,e),Kt=a(e),Ie=p(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-1nbn6cl"&&(Ie.textContent=es),Ot=a(e),c(Ge.$$.fragment,e),el=a(e),Be=p(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-13vdbpw"&&(Be.textContent=ts),tl=a(e),c(ke.$$.fragment,e),ll=a(e),xe=p(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-145l8jb"&&(xe.textContent=ls),sl=a(e),c(Ae.$$.fragment,e),nl=a(e),We=p(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-od9x3v"&&(We.textContent=ss),al=a(e),Z=p(e,"DIV",{align:!0,"data-svelte-h":!0}),o(Z)!=="svelte-j96t4n"&&(Z.innerHTML=ns),il=a(e),c(Xe.$$.fragment,e),pl=a(e),c(Se.$$.fragment,e),ol=a(e),Ve=p(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-16a5dxq"&&(Ve.textContent=as),rl=a(e),c(Re.$$.fragment,e),cl=a(e),c(He.$$.fragment,e),ml=a(e),Fe=p(e,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-1kwsxwb"&&(Fe.innerHTML=is),Ml=a(e),Qe=p(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-1jhxh9n"&&(Qe.innerHTML=ps),ul=a(e),Le=p(e,"P",{}),cs(Le).forEach(l),this.h()},h(){$(d,"name","hf:doc:metadata"),$(d,"content",Ts),$(J,"align","center"),$(T,"align","center"),$(U,"align","center"),$(C,"align","center"),$(g,"align","center"),$(Z,"align","center")},m(e,t){bs(document.head,d),s(e,j,t),s(e,h,t),s(e,w,t),m(I,e,t),s(e,Ee,t),s(e,G,t),s(e,Ye,t),s(e,B,t),s(e,ze,t),s(e,k,t),s(e,De,t),m(x,e,t),s(e,qe,t),s(e,A,t),s(e,Pe,t),m(W,e,t),s(e,Ke,t),s(e,X,t),s(e,Oe,t),m(S,e,t),s(e,et,t),s(e,V,t),s(e,tt,t),s(e,R,t),s(e,lt,t),s(e,H,t),s(e,st,t),m(F,e,t),s(e,nt,t),s(e,Q,t),s(e,at,t),m(N,e,t),s(e,it,t),s(e,L,t),s(e,pt,t),s(e,J,t),s(e,ot,t),m(E,e,t),s(e,rt,t),s(e,Y,t),s(e,ct,t),m(z,e,t),s(e,mt,t),s(e,D,t),s(e,Mt,t),s(e,T,t),s(e,ut,t),s(e,q,t),s(e,ft,t),s(e,P,t),s(e,dt,t),s(e,K,t),s(e,ht,t),s(e,O,t),s(e,yt,t),m(ee,e,t),s(e,bt,t),s(e,te,t),s(e,jt,t),m(le,e,t),s(e,wt,t),s(e,se,t),s(e,Jt,t),s(e,U,t),s(e,Tt,t),m(ne,e,t),s(e,Ut,t),s(e,ae,t),s(e,Ct,t),m(ie,e,t),s(e,gt,t),s(e,pe,t),s(e,vt,t),s(e,oe,t),s(e,_t,t),m(re,e,t),s(e,Zt,t),s(e,ce,t),s(e,$t,t),m(me,e,t),s(e,It,t),s(e,Me,t),s(e,Gt,t),s(e,ue,t),s(e,Bt,t),s(e,fe,t),s(e,kt,t),s(e,C,t),s(e,xt,t),m(de,e,t),s(e,At,t),s(e,he,t),s(e,Wt,t),s(e,ye,t),s(e,Xt,t),s(e,be,t),s(e,St,t),m(je,e,t),s(e,Vt,t),s(e,we,t),s(e,Rt,t),s(e,g,t),s(e,Ht,t),m(v,e,t),s(e,Ft,t),m(Je,e,t),s(e,Qt,t),s(e,Te,t),s(e,Nt,t),m(_,e,t),s(e,Lt,t),s(e,Ue,t),s(e,Et,t),s(e,Ce,t),s(e,Yt,t),m(ge,e,t),s(e,zt,t),s(e,ve,t),s(e,Dt,t),m(_e,e,t),s(e,qt,t),s(e,Ze,t),s(e,Pt,t),m($e,e,t),s(e,Kt,t),s(e,Ie,t),s(e,Ot,t),m(Ge,e,t),s(e,el,t),s(e,Be,t),s(e,tl,t),m(ke,e,t),s(e,ll,t),s(e,xe,t),s(e,sl,t),m(Ae,e,t),s(e,nl,t),s(e,We,t),s(e,al,t),s(e,Z,t),s(e,il,t),m(Xe,e,t),s(e,pl,t),m(Se,e,t),s(e,ol,t),s(e,Ve,t),s(e,rl,t),m(Re,e,t),s(e,cl,t),m(He,e,t),s(e,ml,t),s(e,Fe,t),s(e,Ml,t),s(e,Qe,t),s(e,ul,t),s(e,Le,t),fl=!0},p(e,[t]){const os={};t&2&&(os.$$scope={dirty:t,ctx:e}),v.$set(os);const rs={};t&2&&(rs.$$scope={dirty:t,ctx:e}),_.$set(rs)},i(e){fl||(M(I.$$.fragment,e),M(x.$$.fragment,e),M(W.$$.fragment,e),M(S.$$.fragment,e),M(F.$$.fragment,e),M(N.$$.fragment,e),M(E.$$.fragment,e),M(z.$$.fragment,e),M(ee.$$.fragment,e),M(le.$$.fragment,e),M(ne.$$.fragment,e),M(ie.$$.fragment,e),M(re.$$.fragment,e),M(me.$$.fragment,e),M(de.$$.fragment,e),M(je.$$.fragment,e),M(v.$$.fragment,e),M(Je.$$.fragment,e),M(_.$$.fragment,e),M(ge.$$.fragment,e),M(_e.$$.fragment,e),M($e.$$.fragment,e),M(Ge.$$.fragment,e),M(ke.$$.fragment,e),M(Ae.$$.fragment,e),M(Xe.$$.fragment,e),M(Se.$$.fragment,e),M(Re.$$.fragment,e),M(He.$$.fragment,e),fl=!0)},o(e){u(I.$$.fragment,e),u(x.$$.fragment,e),u(W.$$.fragment,e),u(S.$$.fragment,e),u(F.$$.fragment,e),u(N.$$.fragment,e),u(E.$$.fragment,e),u(z.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(ne.$$.fragment,e),u(ie.$$.fragment,e),u(re.$$.fragment,e),u(me.$$.fragment,e),u(de.$$.fragment,e),u(je.$$.fragment,e),u(v.$$.fragment,e),u(Je.$$.fragment,e),u(_.$$.fragment,e),u(ge.$$.fragment,e),u(_e.$$.fragment,e),u($e.$$.fragment,e),u(Ge.$$.fragment,e),u(ke.$$.fragment,e),u(Ae.$$.fragment,e),u(Xe.$$.fragment,e),u(Se.$$.fragment,e),u(Re.$$.fragment,e),u(He.$$.fragment,e),fl=!1},d(e){e&&(l(j),l(h),l(w),l(Ee),l(G),l(Ye),l(B),l(ze),l(k),l(De),l(qe),l(A),l(Pe),l(Ke),l(X),l(Oe),l(et),l(V),l(tt),l(R),l(lt),l(H),l(st),l(nt),l(Q),l(at),l(it),l(L),l(pt),l(J),l(ot),l(rt),l(Y),l(ct),l(mt),l(D),l(Mt),l(T),l(ut),l(q),l(ft),l(P),l(dt),l(K),l(ht),l(O),l(yt),l(bt),l(te),l(jt),l(wt),l(se),l(Jt),l(U),l(Tt),l(Ut),l(ae),l(Ct),l(gt),l(pe),l(vt),l(oe),l(_t),l(Zt),l(ce),l($t),l(It),l(Me),l(Gt),l(ue),l(Bt),l(fe),l(kt),l(C),l(xt),l(At),l(he),l(Wt),l(ye),l(Xt),l(be),l(St),l(Vt),l(we),l(Rt),l(g),l(Ht),l(Ft),l(Qt),l(Te),l(Nt),l(Lt),l(Ue),l(Et),l(Ce),l(Yt),l(zt),l(ve),l(Dt),l(qt),l(Ze),l(Pt),l(Kt),l(Ie),l(Ot),l(el),l(Be),l(tl),l(ll),l(xe),l(sl),l(nl),l(We),l(al),l(Z),l(il),l(pl),l(ol),l(Ve),l(rl),l(cl),l(ml),l(Fe),l(Ml),l(Qe),l(ul),l(Le)),l(d),f(I,e),f(x,e),f(W,e),f(S,e),f(F,e),f(N,e),f(E,e),f(z,e),f(ee,e),f(le,e),f(ne,e),f(ie,e),f(re,e),f(me,e),f(de,e),f(je,e),f(v,e),f(Je,e),f(_,e),f(ge,e),f(_e,e),f($e,e),f(Ge,e),f(ke,e),f(Ae,e),f(Xe,e),f(Se,e),f(Re,e),f(He,e)}}}const Ts='{"title":"Accelerate inference of text-to-image diffusion models","local":"accelerate-inference-of-text-to-image-diffusion-models","sections":[{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"Baseline","local":"baseline","sections":[],"depth":2},{"title":"Running inference in bfloat16","local":"running-inference-in-bfloat16","sections":[],"depth":2},{"title":"Running attention efficiently","local":"running-attention-efficiently","sections":[],"depth":2},{"title":"Use faster kernels with torch.compile","local":"use-faster-kernels-with-torchcompile","sections":[],"depth":2},{"title":"Combine the projection matrices of attention","local":"combine-the-projection-matrices-of-attention","sections":[],"depth":2},{"title":"Dynamic quantization","local":"dynamic-quantization","sections":[],"depth":2},{"title":"Misc","local":"misc","sections":[{"title":"No graph breaks during torch.compile","local":"no-graph-breaks-during-torchcompile","sections":[],"depth":3},{"title":"Getting rid of GPU syncs after compilation","local":"getting-rid-of-gpu-syncs-after-compilation","sections":[],"depth":3}],"depth":2}],"depth":1}';function Us(Ne){return fs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $s extends ds{constructor(d){super(),hs(this,d,Us,Js,us,{})}}export{$s as component};
