import{s as es,o as ts,n as ns}from"../chunks/scheduler.182ea377.js";import{S as ss,i as os,g as a,s as o,r as d,A as ls,h as i,f as t,c as l,j as g,u as c,x as p,k as V,y as r,a as s,v as m,d as h,t as u,w as f}from"../chunks/index.abf12888.js";import{T as as}from"../chunks/Tip.230e2334.js";import{D as Oe}from"../chunks/Docstring.93f6f462.js";import{C as M}from"../chunks/CodeBlock.57fe6e13.js";import{H as j}from"../chunks/Heading.16916d63.js";function is(et){let y,W='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){y=a("p"),y.innerHTML=W},l(T){y=i(T,"P",{"data-svelte-h":!0}),p(y)!=="svelte-1wmc0l4"&&(y.innerHTML=W)},m(T,Ie){s(T,y,Ie)},p:ns,d(T){T&&t(y)}}}function rs(et){let y,W,T,Ie,G,tt,B,Mn='<a href="https://huggingface.co/papers/2303.13439" rel="nofollow">Text2Video-Zero: Text-to-Image Diffusion Models are Zero-Shot Video Generators</a> is by Levon Khachatryan, Andranik Movsisyan, Vahram Tadevosyan, Roberto Henschel, <a href="https://www.ece.utexas.edu/people/faculty/atlas-wang" rel="nofollow">Zhangyang Wang</a>, Shant Navasardyan, <a href="https://www.humphreyshi.com" rel="nofollow">Humphrey Shi</a>.',nt,$,wn="Text2Video-Zero enables zero-shot video generation using either:",st,R,vn="<li>A textual prompt</li> <li>A prompt combined with guidance from poses or edges</li> <li>Video Instruct-Pix2Pix (instruction-guided video editing)</li>",ot,X,Jn="Results are temporally consistent and closely follow the guidance and textual prompts.",lt,N,xn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/t2v_zero_teaser.png" alt="teaser-img"/>',at,z,Zn="The abstract from the paper is:",it,Q,jn=`<em>Recent text-to-video generation approaches rely on computationally heavy training and require large-scale video datasets. In this paper, we introduce a new task of zero-shot text-to-video generation and propose a low-cost approach (without any training or optimization) by leveraging the power of existing text-to-image synthesis methods (e.g., Stable Diffusion), making them suitable for the video domain.
Our key modifications include (i) enriching the latent codes of the generated frames with motion dynamics to keep the global scene and the background time consistent; and (ii) reprogramming frame-level self-attention using a new cross-frame attention of each frame on the first frame, to preserve the context, appearance, and identity of the foreground object.
Experiments show that this leads to low overhead, yet high-quality and remarkably consistent video generation. Moreover, our approach is not limited to text-to-video synthesis but is also applicable to other tasks such as conditional and content-specialized video generation, and Video Instruct-Pix2Pix, i.e., instruction-guided video editing.
As experiments show, our method performs comparably or sometimes better than recent approaches, despite not being trained on additional video data.</em>`,rt,P,Un='You can find additional information about Text2Video-Zero on the <a href="https://text2video-zero.github.io/" rel="nofollow">project page</a>, <a href="https://arxiv.org/abs/2303.13439" rel="nofollow">paper</a>, and <a href="https://github.com/Picsart-AI-Research/Text2Video-Zero" rel="nofollow">original codebase</a>.',pt,E,dt,Y,ct,S,Cn="To generate a video from prompt, run the following Python code:",mt,F,ht,H,In="You can change these parameters in the pipeline call:",ut,L,kn='<li>Motion field strength (see the <a href="https://arxiv.org/abs/2303.13439" rel="nofollow">paper</a>, Sect. 3.3.1):<ul><li><code>motion_field_strength_x</code> and <code>motion_field_strength_y</code>. Default: <code>motion_field_strength_x=12</code>, <code>motion_field_strength_y=12</code></li></ul></li> <li><code>T</code> and <code>T&#39;</code> (see the <a href="https://arxiv.org/abs/2303.13439" rel="nofollow">paper</a>, Sect. 3.3.1)<ul><li><code>t0</code> and <code>t1</code> in the range <code>{0, ..., num_inference_steps}</code>. Default: <code>t0=45</code>, <code>t1=48</code></li></ul></li> <li>Video length:<ul><li><code>video_length</code>, the number of frames video_length to be generated. Default: <code>video_length=8</code></li></ul></li>',ft,D,Vn="We can also generate longer videos by doing the processing in a chunk-by-chunk manner:",gt,q,yt,A,_t,K,Wn="To generate a video from prompt with additional pose control",bt,ke,O,Ve,Gn="Download a demo video",qt,ee,Tt,J,x,We,Bn="Read video containing extracted pose images",At,te,Kt,Ge,$n='To extract pose from actual video, read <a href="controlnet">ControlNet documentation</a>.',Ot,ne,Be,Rn="Run <code>StableDiffusionControlNetPipeline</code> with our custom attention processor",en,se,Mt,oe,wt,le,Xn='To generate a video from prompt with additional Canny edge control, follow the same steps described above for pose-guided generation using <a href="https://huggingface.co/lllyasviel/sd-controlnet-canny" rel="nofollow">Canny edge ControlNet model</a>.',vt,ae,Jt,ie,Nn='To perform text-guided video editing (with <a href="pix2pix">InstructPix2Pix</a>):',xt,w,re,$e,zn="Download a demo video",tn,pe,nn,de,Re,Qn="Read video from path",sn,ce,on,me,Xe,Pn="Run <code>StableDiffusionInstructPix2PixPipeline</code> with our custom attention processor",ln,he,Zt,ue,jt,fe,En=`Methods <strong>Text-To-Video</strong>, <strong>Text-To-Video with Pose Control</strong> and <strong>Text-To-Video with Edge Control</strong>
can run with custom <a href="../../training/dreambooth">DreamBooth</a> models, as shown below for
<a href="https://huggingface.co/lllyasviel/sd-controlnet-canny" rel="nofollow">Canny edge ControlNet model</a> and
<a href="https://huggingface.co/PAIR/text2video-zero-controlnet-canny-avatar" rel="nofollow">Avatar style DreamBooth</a> model:`,Ut,v,ge,Ne,Yn="Download a demo video",an,ye,rn,_e,ze,Sn="Read video from path",pn,be,dn,Te,Qe,Fn="Run <code>StableDiffusionControlNetPipeline</code> with custom trained DreamBooth model",cn,Me,Ct,we,Hn='You can filter out some available DreamBooth-trained models with <a href="https://huggingface.co/models?search=dreambooth" rel="nofollow">this link</a>.',It,U,kt,ve,Vt,_,Je,mn,Pe,Ln="Pipeline for zero-shot text-to-video generation using Stable Diffusion.",hn,Ee,Dn=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,un,C,xe,fn,Ye,qn="The call function to the pipeline for generation.",gn,I,Ze,yn,Se,An="Perform backward process given list of time steps.",_n,k,je,bn,Fe,Kn="Perform DDPM forward process from time t0 to t1. This is the same as adding noise with corresponding variance.",Wt,Ue,Gt,Z,Ce,Tn,He,On="Output class for zero-shot text-to-video pipeline.",Bt,Ae,$t;return G=new j({props:{title:"Text2Video-Zero",local:"text2video-zero",headingTag:"h1"}}),E=new j({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),Y=new j({props:{title:"Text-To-Video",local:"text-to-video",headingTag:"h3"}}),F=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVGV4dFRvVmlkZW9aZXJvUGlwZWxpbmUlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFRleHRUb1ZpZGVvWmVyb1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwcGFuZGElMjBpcyUyMHBsYXlpbmclMjBndWl0YXIlMjBvbiUyMHRpbWVzJTIwc3F1YXJlJTIyJTBBcmVzdWx0JTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQpLmltYWdlcyUwQXJlc3VsdCUyMCUzRCUyMCU1QihyJTIwKiUyMDI1NSkuYXN0eXBlKCUyMnVpbnQ4JTIyKSUyMGZvciUyMHIlMjBpbiUyMHJlc3VsdCU1RCUwQWltYWdlaW8ubWltc2F2ZSglMjJ2aWRlby5tcDQlMjIlMkMlMjByZXN1bHQlMkMlMjBmcHMlM0Q0KQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> TextToVideoZeroPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = TextToVideoZeroPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A panda is playing guitar on times square&quot;</span>
result = pipe(prompt=prompt).images
result = [(r * <span class="hljs-number">255</span>).astype(<span class="hljs-string">&quot;uint8&quot;</span>) <span class="hljs-keyword">for</span> r <span class="hljs-keyword">in</span> result]
imageio.mimsave(<span class="hljs-string">&quot;video.mp4&quot;</span>, result, fps=<span class="hljs-number">4</span>)`,wrap:!1}}),q=new M({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> TextToVideoZeroPipeline
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = TextToVideoZeroPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
seed = <span class="hljs-number">0</span>
video_length = <span class="hljs-number">24</span>  <span class="hljs-comment">#24 ÷ 4fps = 6 seconds</span>
chunk_size = <span class="hljs-number">8</span>
prompt = <span class="hljs-string">&quot;A panda is playing guitar on times square&quot;</span>

<span class="hljs-comment"># Generate the video chunk-by-chunk</span>
result = []
chunk_ids = np.arange(<span class="hljs-number">0</span>, video_length, chunk_size - <span class="hljs-number">1</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(chunk_ids)):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Processing chunk <span class="hljs-subst">{i + <span class="hljs-number">1</span>}</span> / <span class="hljs-subst">{<span class="hljs-built_in">len</span>(chunk_ids)}</span>&quot;</span>)
    ch_start = chunk_ids[i]
    ch_end = video_length <span class="hljs-keyword">if</span> i == <span class="hljs-built_in">len</span>(chunk_ids) - <span class="hljs-number">1</span> <span class="hljs-keyword">else</span> chunk_ids[i + <span class="hljs-number">1</span>]
    <span class="hljs-comment"># Attach the first frame for Cross Frame Attention</span>
    frame_ids = [<span class="hljs-number">0</span>] + <span class="hljs-built_in">list</span>(<span class="hljs-built_in">range</span>(ch_start, ch_end))
    <span class="hljs-comment"># Fix the seed for the temporal consistency</span>
    generator.manual_seed(seed)
    output = pipe(prompt=prompt, video_length=<span class="hljs-built_in">len</span>(frame_ids), generator=generator, frame_ids=frame_ids)
    result.append(output.images[<span class="hljs-number">1</span>:])

<span class="hljs-comment"># Concatenate chunks and save</span>
result = np.concatenate(result)
result = [(r * <span class="hljs-number">255</span>).astype(<span class="hljs-string">&quot;uint8&quot;</span>) <span class="hljs-keyword">for</span> r <span class="hljs-keyword">in</span> result]
imageio.mimsave(<span class="hljs-string">&quot;video.mp4&quot;</span>, result, fps=<span class="hljs-number">4</span>)`,wrap:!1}}),A=new j({props:{title:"Text-To-Video with Pose Control",local:"text-to-video-with-pose-control",headingTag:"h3"}}),ee=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQSUwQWZpbGVuYW1lJTIwJTNEJTIwJTIyX19hc3NldHNfXyUyRnBvc2VzX3NrZWxldG9uX2dpZnMlMkZkYW5jZTFfY29yci5tcDQlMjIlMEFyZXBvX2lkJTIwJTNEJTIwJTIyUEFJUiUyRlRleHQyVmlkZW8tWmVybyUyMiUwQXZpZGVvX3BhdGglMjAlM0QlMjBoZl9odWJfZG93bmxvYWQocmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMjByZXBvX2lkJTNEcmVwb19pZCUyQyUyMGZpbGVuYW1lJTNEZmlsZW5hbWUp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

filename = <span class="hljs-string">&quot;__assets__/poses_skeleton_gifs/dance1_corr.mp4&quot;</span>
repo_id = <span class="hljs-string">&quot;PAIR/Text2Video-Zero&quot;</span>
video_path = hf_hub_download(repo_type=<span class="hljs-string">&quot;space&quot;</span>, repo_id=repo_id, filename=filename)`,wrap:!1}}),te=new M({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwaW1hZ2VpbyUwQSUwQXJlYWRlciUyMCUzRCUyMGltYWdlaW8uZ2V0X3JlYWRlcih2aWRlb19wYXRoJTJDJTIwJTIyZmZtcGVnJTIyKSUwQWZyYW1lX2NvdW50JTIwJTNEJTIwOCUwQXBvc2VfaW1hZ2VzJTIwJTNEJTIwJTVCSW1hZ2UuZnJvbWFycmF5KHJlYWRlci5nZXRfZGF0YShpKSklMjBmb3IlMjBpJTIwaW4lMjByYW5nZShmcmFtZV9jb3VudCklNUQ=",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> imageio

reader = imageio.get_reader(video_path, <span class="hljs-string">&quot;ffmpeg&quot;</span>)
frame_count = <span class="hljs-number">8</span>
pose_images = [Image.fromarray(reader.get_data(i)) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(frame_count)]`,wrap:!1}}),se=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldFBpcGVsaW5lJTJDJTIwQ29udHJvbE5ldE1vZGVsJTBBZnJvbSUyMGRpZmZ1c2Vycy5waXBlbGluZXMudGV4dF90b192aWRlb19zeW50aGVzaXMucGlwZWxpbmVfdGV4dF90b192aWRlb196ZXJvJTIwaW1wb3J0JTIwQ3Jvc3NGcmFtZUF0dG5Qcm9jZXNzb3IlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBY29udHJvbG5ldCUyMCUzRCUyMENvbnRyb2xOZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIybGxseWFzdmllbCUyRnNkLWNvbnRyb2xuZXQtb3BlbnBvc2UlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSkudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBTZXQlMjB0aGUlMjBhdHRlbnRpb24lMjBwcm9jZXNzb3IlMEFwaXBlLnVuZXQuc2V0X2F0dG5fcHJvY2Vzc29yKENyb3NzRnJhbWVBdHRuUHJvY2Vzc29yKGJhdGNoX3NpemUlM0QyKSklMEFwaXBlLmNvbnRyb2xuZXQuc2V0X2F0dG5fcHJvY2Vzc29yKENyb3NzRnJhbWVBdHRuUHJvY2Vzc29yKGJhdGNoX3NpemUlM0QyKSklMEElMEElMjMlMjBmaXglMjBsYXRlbnRzJTIwZm9yJTIwYWxsJTIwZnJhbWVzJTBBbGF0ZW50cyUyMCUzRCUyMHRvcmNoLnJhbmRuKCgxJTJDJTIwNCUyQyUyMDY0JTJDJTIwNjQpJTJDJTIwZGV2aWNlJTNEJTIyY3VkYSUyMiUyQyUyMGR0eXBlJTNEdG9yY2guZmxvYXQxNikucmVwZWF0KGxlbihwb3NlX2ltYWdlcyklMkMlMjAxJTJDJTIwMSUyQyUyMDEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyRGFydGglMjBWYWRlciUyMGRhbmNpbmclMjBpbiUyMGElMjBkZXNlcnQlMjIlMEFyZXN1bHQlMjAlM0QlMjBwaXBlKHByb21wdCUzRCU1QnByb21wdCU1RCUyMColMjBsZW4ocG9zZV9pbWFnZXMpJTJDJTIwaW1hZ2UlM0Rwb3NlX2ltYWdlcyUyQyUyMGxhdGVudHMlM0RsYXRlbnRzKS5pbWFnZXMlMEFpbWFnZWlvLm1pbXNhdmUoJTIydmlkZW8ubXA0JTIyJTJDJTIwcmVzdWx0JTJDJTIwZnBzJTNENCk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel
<span class="hljs-keyword">from</span> diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero <span class="hljs-keyword">import</span> CrossFrameAttnProcessor

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-openpose&quot;</span>, torch_dtype=torch.float16)
pipe = StableDiffusionControlNetPipeline.from_pretrained(
    model_id, controlnet=controlnet, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Set the attention processor</span>
pipe.unet.set_attn_processor(CrossFrameAttnProcessor(batch_size=<span class="hljs-number">2</span>))
pipe.controlnet.set_attn_processor(CrossFrameAttnProcessor(batch_size=<span class="hljs-number">2</span>))

<span class="hljs-comment"># fix latents for all frames</span>
latents = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16).repeat(<span class="hljs-built_in">len</span>(pose_images), <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>)

prompt = <span class="hljs-string">&quot;Darth Vader dancing in a desert&quot;</span>
result = pipe(prompt=[prompt] * <span class="hljs-built_in">len</span>(pose_images), image=pose_images, latents=latents).images
imageio.mimsave(<span class="hljs-string">&quot;video.mp4&quot;</span>, result, fps=<span class="hljs-number">4</span>)`,wrap:!1}}),oe=new j({props:{title:"Text-To-Video with Edge Control",local:"text-to-video-with-edge-control",headingTag:"h3"}}),ae=new j({props:{title:"Video Instruct-Pix2Pix",local:"video-instruct-pix2pix",headingTag:"h3"}}),pe=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQSUwQWZpbGVuYW1lJTIwJTNEJTIwJTIyX19hc3NldHNfXyUyRnBpeDJwaXglMjB2aWRlbyUyRmNhbWVsLm1wNCUyMiUwQXJlcG9faWQlMjAlM0QlMjAlMjJQQUlSJTJGVGV4dDJWaWRlby1aZXJvJTIyJTBBdmlkZW9fcGF0aCUyMCUzRCUyMGhmX2h1Yl9kb3dubG9hZChyZXBvX3R5cGUlM0QlMjJzcGFjZSUyMiUyQyUyMHJlcG9faWQlM0RyZXBvX2lkJTJDJTIwZmlsZW5hbWUlM0RmaWxlbmFtZSk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

filename = <span class="hljs-string">&quot;__assets__/pix2pix video/camel.mp4&quot;</span>
repo_id = <span class="hljs-string">&quot;PAIR/Text2Video-Zero&quot;</span>
video_path = hf_hub_download(repo_type=<span class="hljs-string">&quot;space&quot;</span>, repo_id=repo_id, filename=filename)`,wrap:!1}}),ce=new M({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwaW1hZ2VpbyUwQSUwQXJlYWRlciUyMCUzRCUyMGltYWdlaW8uZ2V0X3JlYWRlcih2aWRlb19wYXRoJTJDJTIwJTIyZmZtcGVnJTIyKSUwQWZyYW1lX2NvdW50JTIwJTNEJTIwOCUwQXZpZGVvJTIwJTNEJTIwJTVCSW1hZ2UuZnJvbWFycmF5KHJlYWRlci5nZXRfZGF0YShpKSklMjBmb3IlMjBpJTIwaW4lMjByYW5nZShmcmFtZV9jb3VudCklNUQ=",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> imageio

reader = imageio.get_reader(video_path, <span class="hljs-string">&quot;ffmpeg&quot;</span>)
frame_count = <span class="hljs-number">8</span>
video = [Image.fromarray(reader.get_data(i)) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(frame_count)]`,wrap:!1}}),he=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uSW5zdHJ1Y3RQaXgyUGl4UGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnBpcGVsaW5lcy50ZXh0X3RvX3ZpZGVvX3N5bnRoZXNpcy5waXBlbGluZV90ZXh0X3RvX3ZpZGVvX3plcm8lMjBpbXBvcnQlMjBDcm9zc0ZyYW1lQXR0blByb2Nlc3NvciUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIydGltYnJvb2tzJTJGaW5zdHJ1Y3QtcGl4MnBpeCUyMiUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbnN0cnVjdFBpeDJQaXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZS51bmV0LnNldF9hdHRuX3Byb2Nlc3NvcihDcm9zc0ZyYW1lQXR0blByb2Nlc3NvcihiYXRjaF9zaXplJTNEMykpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIybWFrZSUyMGl0JTIwVmFuJTIwR29naCUyMFN0YXJyeSUyME5pZ2h0JTIwc3R5bGUlMjIlMEFyZXN1bHQlMjAlM0QlMjBwaXBlKHByb21wdCUzRCU1QnByb21wdCU1RCUyMColMjBsZW4odmlkZW8pJTJDJTIwaW1hZ2UlM0R2aWRlbykuaW1hZ2VzJTBBaW1hZ2Vpby5taW1zYXZlKCUyMmVkaXRlZF92aWRlby5tcDQlMjIlMkMlMjByZXN1bHQlMkMlMjBmcHMlM0Q0KQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionInstructPix2PixPipeline
<span class="hljs-keyword">from</span> diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero <span class="hljs-keyword">import</span> CrossFrameAttnProcessor

model_id = <span class="hljs-string">&quot;timbrooks/instruct-pix2pix&quot;</span>
pipe = StableDiffusionInstructPix2PixPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.unet.set_attn_processor(CrossFrameAttnProcessor(batch_size=<span class="hljs-number">3</span>))

prompt = <span class="hljs-string">&quot;make it Van Gogh Starry Night style&quot;</span>
result = pipe(prompt=[prompt] * <span class="hljs-built_in">len</span>(video), image=video).images
imageio.mimsave(<span class="hljs-string">&quot;edited_video.mp4&quot;</span>, result, fps=<span class="hljs-number">4</span>)`,wrap:!1}}),ue=new j({props:{title:"DreamBooth specialization",local:"dreambooth-specialization",headingTag:"h3"}}),ye=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQSUwQWZpbGVuYW1lJTIwJTNEJTIwJTIyX19hc3NldHNfXyUyRmNhbm55X3ZpZGVvc19tcDQlMkZnaXJsX3R1cm5pbmcubXA0JTIyJTBBcmVwb19pZCUyMCUzRCUyMCUyMlBBSVIlMkZUZXh0MlZpZGVvLVplcm8lMjIlMEF2aWRlb19wYXRoJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKHJlcG9fdHlwZSUzRCUyMnNwYWNlJTIyJTJDJTIwcmVwb19pZCUzRHJlcG9faWQlMkMlMjBmaWxlbmFtZSUzRGZpbGVuYW1lKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

filename = <span class="hljs-string">&quot;__assets__/canny_videos_mp4/girl_turning.mp4&quot;</span>
repo_id = <span class="hljs-string">&quot;PAIR/Text2Video-Zero&quot;</span>
video_path = hf_hub_download(repo_type=<span class="hljs-string">&quot;space&quot;</span>, repo_id=repo_id, filename=filename)`,wrap:!1}}),be=new M({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwaW1hZ2VpbyUwQSUwQXJlYWRlciUyMCUzRCUyMGltYWdlaW8uZ2V0X3JlYWRlcih2aWRlb19wYXRoJTJDJTIwJTIyZmZtcGVnJTIyKSUwQWZyYW1lX2NvdW50JTIwJTNEJTIwOCUwQWNhbm55X2VkZ2VzJTIwJTNEJTIwJTVCSW1hZ2UuZnJvbWFycmF5KHJlYWRlci5nZXRfZGF0YShpKSklMjBmb3IlMjBpJTIwaW4lMjByYW5nZShmcmFtZV9jb3VudCklNUQ=",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> imageio

reader = imageio.get_reader(video_path, <span class="hljs-string">&quot;ffmpeg&quot;</span>)
frame_count = <span class="hljs-number">8</span>
canny_edges = [Image.fromarray(reader.get_data(i)) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(frame_count)]`,wrap:!1}}),Me=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldFBpcGVsaW5lJTJDJTIwQ29udHJvbE5ldE1vZGVsJTBBZnJvbSUyMGRpZmZ1c2Vycy5waXBlbGluZXMudGV4dF90b192aWRlb19zeW50aGVzaXMucGlwZWxpbmVfdGV4dF90b192aWRlb196ZXJvJTIwaW1wb3J0JTIwQ3Jvc3NGcmFtZUF0dG5Qcm9jZXNzb3IlMEElMEElMjMlMjBzZXQlMjBtb2RlbCUyMGlkJTIwdG8lMjBjdXN0b20lMjBtb2RlbCUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyUEFJUiUyRnRleHQydmlkZW8temVyby1jb250cm9sbmV0LWNhbm55LWF2YXRhciUyMiUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmxsbHlhc3ZpZWwlMkZzZC1jb250cm9sbmV0LWNhbm55JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25Db250cm9sTmV0UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTIwY29udHJvbG5ldCUzRGNvbnRyb2xuZXQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTIzJTIwU2V0JTIwdGhlJTIwYXR0ZW50aW9uJTIwcHJvY2Vzc29yJTBBcGlwZS51bmV0LnNldF9hdHRuX3Byb2Nlc3NvcihDcm9zc0ZyYW1lQXR0blByb2Nlc3NvcihiYXRjaF9zaXplJTNEMikpJTBBcGlwZS5jb250cm9sbmV0LnNldF9hdHRuX3Byb2Nlc3NvcihDcm9zc0ZyYW1lQXR0blByb2Nlc3NvcihiYXRjaF9zaXplJTNEMikpJTBBJTBBJTIzJTIwZml4JTIwbGF0ZW50cyUyMGZvciUyMGFsbCUyMGZyYW1lcyUwQWxhdGVudHMlMjAlM0QlMjB0b3JjaC5yYW5kbigoMSUyQyUyMDQlMkMlMjA2NCUyQyUyMDY0KSUyQyUyMGRldmljZSUzRCUyMmN1ZGElMjIlMkMlMjBkdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnJlcGVhdChsZW4oY2FubnlfZWRnZXMpJTJDJTIwMSUyQyUyMDElMkMlMjAxKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMm9pbCUyMHBhaW50aW5nJTIwb2YlMjBhJTIwYmVhdXRpZnVsJTIwZ2lybCUyMGF2YXRhciUyMHN0eWxlJTIyJTBBcmVzdWx0JTIwJTNEJTIwcGlwZShwcm9tcHQlM0QlNUJwcm9tcHQlNUQlMjAqJTIwbGVuKGNhbm55X2VkZ2VzKSUyQyUyMGltYWdlJTNEY2FubnlfZWRnZXMlMkMlMjBsYXRlbnRzJTNEbGF0ZW50cykuaW1hZ2VzJTBBaW1hZ2Vpby5taW1zYXZlKCUyMnZpZGVvLm1wNCUyMiUyQyUyMHJlc3VsdCUyQyUyMGZwcyUzRDQp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel
<span class="hljs-keyword">from</span> diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero <span class="hljs-keyword">import</span> CrossFrameAttnProcessor

<span class="hljs-comment"># set model id to custom model</span>
model_id = <span class="hljs-string">&quot;PAIR/text2video-zero-controlnet-canny-avatar&quot;</span>
controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>, torch_dtype=torch.float16)
pipe = StableDiffusionControlNetPipeline.from_pretrained(
    model_id, controlnet=controlnet, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Set the attention processor</span>
pipe.unet.set_attn_processor(CrossFrameAttnProcessor(batch_size=<span class="hljs-number">2</span>))
pipe.controlnet.set_attn_processor(CrossFrameAttnProcessor(batch_size=<span class="hljs-number">2</span>))

<span class="hljs-comment"># fix latents for all frames</span>
latents = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16).repeat(<span class="hljs-built_in">len</span>(canny_edges), <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>)

prompt = <span class="hljs-string">&quot;oil painting of a beautiful girl avatar style&quot;</span>
result = pipe(prompt=[prompt] * <span class="hljs-built_in">len</span>(canny_edges), image=canny_edges, latents=latents).images
imageio.mimsave(<span class="hljs-string">&quot;video.mp4&quot;</span>, result, fps=<span class="hljs-number">4</span>)`,wrap:!1}}),U=new as({props:{$$slots:{default:[is]},$$scope:{ctx:et}}}),ve=new j({props:{title:"TextToVideoZeroPipeline",local:"diffusers.TextToVideoZeroPipeline",headingTag:"h2"}}),Je=new Oe({props:{name:"class diffusers.TextToVideoZeroPipeline",anchor:"diffusers.TextToVideoZeroPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.TextToVideoZeroPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.TextToVideoZeroPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.TextToVideoZeroPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.TextToVideoZeroPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a> to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.TextToVideoZeroPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.TextToVideoZeroPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.TextToVideoZeroPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero.py#L274"}}),xe=new Oe({props:{name:"__call__",anchor:"diffusers.TextToVideoZeroPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"video_length",val:": typing.Optional[int] = 8"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"motion_field_strength_x",val:": float = 12"},{name:"motion_field_strength_y",val:": float = 12"},{name:"output_type",val:": typing.Optional[str] = 'tensor'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": typing.Optional[int] = 1"},{name:"t0",val:": int = 44"},{name:"t1",val:": int = 47"},{name:"frame_ids",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"diffusers.TextToVideoZeroPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.video_length",description:`<strong>video_length</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
The number of generated video frames.`,name:"video_length"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in video generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;numpy&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>&quot;latent&quot;</code> and <code>&quot;numpy&quot;</code>.`,name:"output_type"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a
<a href="/docs/diffusers/main/en/api/pipelines/text_to_video_zero#diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput">TextToVideoPipelineOutput</a> instead of
a plain tuple.`,name:"return_dict"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.motion_field_strength_x",description:`<strong>motion_field_strength_x</strong> (<code>float</code>, <em>optional</em>, defaults to 12) &#x2014;
Strength of motion in generated video along x-axis. See the <a href="https://arxiv.org/abs/2303.13439" rel="nofollow">paper</a>,
Sect. 3.3.1.`,name:"motion_field_strength_x"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.motion_field_strength_y",description:`<strong>motion_field_strength_y</strong> (<code>float</code>, <em>optional</em>, defaults to 12) &#x2014;
Strength of motion in generated video along y-axis. See the <a href="https://arxiv.org/abs/2303.13439" rel="nofollow">paper</a>,
Sect. 3.3.1.`,name:"motion_field_strength_y"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.t0",description:`<strong>t0</strong> (<code>int</code>, <em>optional</em>, defaults to 44) &#x2014;
Timestep t0. Should be in the range [0, num_inference_steps - 1]. See the
<a href="https://arxiv.org/abs/2303.13439" rel="nofollow">paper</a>, Sect. 3.3.1.`,name:"t0"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.t1",description:`<strong>t1</strong> (<code>int</code>, <em>optional</em>, defaults to 47) &#x2014;
Timestep t0. Should be in the range [t0 + 1, num_inference_steps - 1]. See the
<a href="https://arxiv.org/abs/2303.13439" rel="nofollow">paper</a>, Sect. 3.3.1.`,name:"t1"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.frame_ids",description:`<strong>frame_ids</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Indexes of the frames that are being generated. This is used when generating longer videos
chunk-by-chunk.`,name:"frame_ids"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero.py#L421",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The output contains a <code>ndarray</code> of the generated video, when <code>output_type</code> != <code>"latent"</code>, otherwise a
latent code of generated videos and a list of <code>bool</code>s indicating whether the corresponding generated
video contains “not-safe-for-work” (nsfw) content..</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/text_to_video_zero#diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput"
>TextToVideoPipelineOutput</a></p>
`}}),Ze=new Oe({props:{name:"backward_loop",anchor:"diffusers.TextToVideoZeroPipeline.backward_loop",parameters:[{name:"latents",val:""},{name:"timesteps",val:""},{name:"prompt_embeds",val:""},{name:"guidance_scale",val:""},{name:"callback",val:""},{name:"callback_steps",val:""},{name:"num_warmup_steps",val:""},{name:"extra_step_kwargs",val:""},{name:"cross_attention_kwargs",val:" = None"}],parametersDescription:[{anchor:"diffusers.TextToVideoZeroPipeline.backward_loop.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.TextToVideoZeroPipeline.backward_loop.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.
extra_step_kwargs &#x2014;
Extra_step_kwargs.
cross_attention_kwargs &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.
num_warmup_steps &#x2014;
number of warmup steps.`,name:"callback_steps"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero.py#L346",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Latents of backward process output at time timesteps[-1].</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>latents</p>
`}}),je=new Oe({props:{name:"forward_loop",anchor:"diffusers.TextToVideoZeroPipeline.forward_loop",parameters:[{name:"x_t0",val:""},{name:"t0",val:""},{name:"t1",val:""},{name:"generator",val:""}],parametersDescription:[{anchor:"diffusers.TextToVideoZeroPipeline.forward_loop.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero.py#L322",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Forward process applied to x_t0 from time t0 to t1.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>x_t1</p>
`}}),Ue=new j({props:{title:"TextToVideoPipelineOutput",local:"diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput",headingTag:"h2"}}),Ce=new Oe({props:{name:"class diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput",anchor:"diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"},{name:"nsfw_content_detected",val:": typing.Optional[typing.List[bool]]"}],parametersDescription:[{anchor:"diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput.images",description:`<strong>images</strong> (<code>[List[PIL.Image.Image]</code>, <code>np.ndarray</code>]) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>[List[bool]]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero.py#L174"}}),{c(){y=a("meta"),W=o(),T=a("p"),Ie=o(),d(G.$$.fragment),tt=o(),B=a("p"),B.innerHTML=Mn,nt=o(),$=a("p"),$.textContent=wn,st=o(),R=a("ol"),R.innerHTML=vn,ot=o(),X=a("p"),X.textContent=Jn,lt=o(),N=a("p"),N.innerHTML=xn,at=o(),z=a("p"),z.textContent=Zn,it=o(),Q=a("p"),Q.innerHTML=jn,rt=o(),P=a("p"),P.innerHTML=Un,pt=o(),d(E.$$.fragment),dt=o(),d(Y.$$.fragment),ct=o(),S=a("p"),S.textContent=Cn,mt=o(),d(F.$$.fragment),ht=o(),H=a("p"),H.textContent=In,ut=o(),L=a("ul"),L.innerHTML=kn,ft=o(),D=a("p"),D.textContent=Vn,gt=o(),d(q.$$.fragment),yt=o(),d(A.$$.fragment),_t=o(),K=a("p"),K.textContent=Wn,bt=o(),ke=a("ol"),O=a("li"),Ve=a("p"),Ve.textContent=Gn,qt=o(),d(ee.$$.fragment),Tt=o(),J=a("ol"),x=a("li"),We=a("p"),We.textContent=Bn,At=o(),d(te.$$.fragment),Kt=o(),Ge=a("p"),Ge.innerHTML=$n,Ot=o(),ne=a("li"),Be=a("p"),Be.innerHTML=Rn,en=o(),d(se.$$.fragment),Mt=o(),d(oe.$$.fragment),wt=o(),le=a("p"),le.innerHTML=Xn,vt=o(),d(ae.$$.fragment),Jt=o(),ie=a("p"),ie.innerHTML=Nn,xt=o(),w=a("ol"),re=a("li"),$e=a("p"),$e.textContent=zn,tn=o(),d(pe.$$.fragment),nn=o(),de=a("li"),Re=a("p"),Re.textContent=Qn,sn=o(),d(ce.$$.fragment),on=o(),me=a("li"),Xe=a("p"),Xe.innerHTML=Pn,ln=o(),d(he.$$.fragment),Zt=o(),d(ue.$$.fragment),jt=o(),fe=a("p"),fe.innerHTML=En,Ut=o(),v=a("ol"),ge=a("li"),Ne=a("p"),Ne.textContent=Yn,an=o(),d(ye.$$.fragment),rn=o(),_e=a("li"),ze=a("p"),ze.textContent=Sn,pn=o(),d(be.$$.fragment),dn=o(),Te=a("li"),Qe=a("p"),Qe.innerHTML=Fn,cn=o(),d(Me.$$.fragment),Ct=o(),we=a("p"),we.innerHTML=Hn,It=o(),d(U.$$.fragment),kt=o(),d(ve.$$.fragment),Vt=o(),_=a("div"),d(Je.$$.fragment),mn=o(),Pe=a("p"),Pe.textContent=Ln,hn=o(),Ee=a("p"),Ee.innerHTML=Dn,un=o(),C=a("div"),d(xe.$$.fragment),fn=o(),Ye=a("p"),Ye.textContent=qn,gn=o(),I=a("div"),d(Ze.$$.fragment),yn=o(),Se=a("p"),Se.textContent=An,_n=o(),k=a("div"),d(je.$$.fragment),bn=o(),Fe=a("p"),Fe.textContent=Kn,Wt=o(),d(Ue.$$.fragment),Gt=o(),Z=a("div"),d(Ce.$$.fragment),Tn=o(),He=a("p"),He.textContent=On,Bt=o(),Ae=a("p"),this.h()},l(e){const n=ls("svelte-u9bgzb",document.head);y=i(n,"META",{name:!0,content:!0}),n.forEach(t),W=l(e),T=i(e,"P",{}),g(T).forEach(t),Ie=l(e),c(G.$$.fragment,e),tt=l(e),B=i(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-16xpzkf"&&(B.innerHTML=Mn),nt=l(e),$=i(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1jaz0ks"&&($.textContent=wn),st=l(e),R=i(e,"OL",{"data-svelte-h":!0}),p(R)!=="svelte-19ca1wn"&&(R.innerHTML=vn),ot=l(e),X=i(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-yhxhyq"&&(X.textContent=Jn),lt=l(e),N=i(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-uupw0l"&&(N.innerHTML=xn),at=l(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1cwsb16"&&(z.textContent=Zn),it=l(e),Q=i(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1rtg145"&&(Q.innerHTML=jn),rt=l(e),P=i(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-u78olw"&&(P.innerHTML=Un),pt=l(e),c(E.$$.fragment,e),dt=l(e),c(Y.$$.fragment,e),ct=l(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1dpixty"&&(S.textContent=Cn),mt=l(e),c(F.$$.fragment,e),ht=l(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-rs2kss"&&(H.textContent=In),ut=l(e),L=i(e,"UL",{"data-svelte-h":!0}),p(L)!=="svelte-1na1mhs"&&(L.innerHTML=kn),ft=l(e),D=i(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1xdujjh"&&(D.textContent=Vn),gt=l(e),c(q.$$.fragment,e),yt=l(e),c(A.$$.fragment,e),_t=l(e),K=i(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-13nlg5v"&&(K.textContent=Wn),bt=l(e),ke=i(e,"OL",{});var Ke=g(ke);O=i(Ke,"LI",{});var Rt=g(O);Ve=i(Rt,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-1xo2nq1"&&(Ve.textContent=Gn),qt=l(Rt),c(ee.$$.fragment,Rt),Rt.forEach(t),Ke.forEach(t),Tt=l(e),J=i(e,"OL",{start:!0});var Xt=g(J);x=i(Xt,"LI",{});var Le=g(x);We=i(Le,"P",{"data-svelte-h":!0}),p(We)!=="svelte-7pm43o"&&(We.textContent=Bn),At=l(Le),c(te.$$.fragment,Le),Kt=l(Le),Ge=i(Le,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-mij11h"&&(Ge.innerHTML=$n),Le.forEach(t),Ot=l(Xt),ne=i(Xt,"LI",{});var Nt=g(ne);Be=i(Nt,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-1wsv5bt"&&(Be.innerHTML=Rn),en=l(Nt),c(se.$$.fragment,Nt),Nt.forEach(t),Xt.forEach(t),Mt=l(e),c(oe.$$.fragment,e),wt=l(e),le=i(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1fgx3w6"&&(le.innerHTML=Xn),vt=l(e),c(ae.$$.fragment,e),Jt=l(e),ie=i(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-o0vmiz"&&(ie.innerHTML=Nn),xt=l(e),w=i(e,"OL",{});var De=g(w);re=i(De,"LI",{});var zt=g(re);$e=i(zt,"P",{"data-svelte-h":!0}),p($e)!=="svelte-1xo2nq1"&&($e.textContent=zn),tn=l(zt),c(pe.$$.fragment,zt),zt.forEach(t),nn=l(De),de=i(De,"LI",{});var Qt=g(de);Re=i(Qt,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-1wln6n0"&&(Re.textContent=Qn),sn=l(Qt),c(ce.$$.fragment,Qt),Qt.forEach(t),on=l(De),me=i(De,"LI",{});var Pt=g(me);Xe=i(Pt,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-14jy04z"&&(Xe.innerHTML=Pn),ln=l(Pt),c(he.$$.fragment,Pt),Pt.forEach(t),De.forEach(t),Zt=l(e),c(ue.$$.fragment,e),jt=l(e),fe=i(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-x1pkth"&&(fe.innerHTML=En),Ut=l(e),v=i(e,"OL",{});var qe=g(v);ge=i(qe,"LI",{});var Et=g(ge);Ne=i(Et,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-1xo2nq1"&&(Ne.textContent=Yn),an=l(Et),c(ye.$$.fragment,Et),Et.forEach(t),rn=l(qe),_e=i(qe,"LI",{});var Yt=g(_e);ze=i(Yt,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-1wln6n0"&&(ze.textContent=Sn),pn=l(Yt),c(be.$$.fragment,Yt),Yt.forEach(t),dn=l(qe),Te=i(qe,"LI",{});var St=g(Te);Qe=i(St,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-okpmrc"&&(Qe.innerHTML=Fn),cn=l(St),c(Me.$$.fragment,St),St.forEach(t),qe.forEach(t),Ct=l(e),we=i(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-18tnclt"&&(we.innerHTML=Hn),It=l(e),c(U.$$.fragment,e),kt=l(e),c(ve.$$.fragment,e),Vt=l(e),_=i(e,"DIV",{class:!0});var b=g(_);c(Je.$$.fragment,b),mn=l(b),Pe=i(b,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-1q57293"&&(Pe.textContent=Ln),hn=l(b),Ee=i(b,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-496sm0"&&(Ee.innerHTML=Dn),un=l(b),C=i(b,"DIV",{class:!0});var Ft=g(C);c(xe.$$.fragment,Ft),fn=l(Ft),Ye=i(Ft,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-50j04k"&&(Ye.textContent=qn),Ft.forEach(t),gn=l(b),I=i(b,"DIV",{class:!0});var Ht=g(I);c(Ze.$$.fragment,Ht),yn=l(Ht),Se=i(Ht,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-1cxzr1t"&&(Se.textContent=An),Ht.forEach(t),_n=l(b),k=i(b,"DIV",{class:!0});var Lt=g(k);c(je.$$.fragment,Lt),bn=l(Lt),Fe=i(Lt,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-1d8vbe1"&&(Fe.textContent=Kn),Lt.forEach(t),b.forEach(t),Wt=l(e),c(Ue.$$.fragment,e),Gt=l(e),Z=i(e,"DIV",{class:!0});var Dt=g(Z);c(Ce.$$.fragment,Dt),Tn=l(Dt),He=i(Dt,"P",{"data-svelte-h":!0}),p(He)!=="svelte-1dgz4ei"&&(He.textContent=On),Dt.forEach(t),Bt=l(e),Ae=i(e,"P",{}),g(Ae).forEach(t),this.h()},h(){V(y,"name","hf:doc:metadata"),V(y,"content",ps),V(J,"start","2"),V(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){r(document.head,y),s(e,W,n),s(e,T,n),s(e,Ie,n),m(G,e,n),s(e,tt,n),s(e,B,n),s(e,nt,n),s(e,$,n),s(e,st,n),s(e,R,n),s(e,ot,n),s(e,X,n),s(e,lt,n),s(e,N,n),s(e,at,n),s(e,z,n),s(e,it,n),s(e,Q,n),s(e,rt,n),s(e,P,n),s(e,pt,n),m(E,e,n),s(e,dt,n),m(Y,e,n),s(e,ct,n),s(e,S,n),s(e,mt,n),m(F,e,n),s(e,ht,n),s(e,H,n),s(e,ut,n),s(e,L,n),s(e,ft,n),s(e,D,n),s(e,gt,n),m(q,e,n),s(e,yt,n),m(A,e,n),s(e,_t,n),s(e,K,n),s(e,bt,n),s(e,ke,n),r(ke,O),r(O,Ve),r(O,qt),m(ee,O,null),s(e,Tt,n),s(e,J,n),r(J,x),r(x,We),r(x,At),m(te,x,null),r(x,Kt),r(x,Ge),r(J,Ot),r(J,ne),r(ne,Be),r(ne,en),m(se,ne,null),s(e,Mt,n),m(oe,e,n),s(e,wt,n),s(e,le,n),s(e,vt,n),m(ae,e,n),s(e,Jt,n),s(e,ie,n),s(e,xt,n),s(e,w,n),r(w,re),r(re,$e),r(re,tn),m(pe,re,null),r(w,nn),r(w,de),r(de,Re),r(de,sn),m(ce,de,null),r(w,on),r(w,me),r(me,Xe),r(me,ln),m(he,me,null),s(e,Zt,n),m(ue,e,n),s(e,jt,n),s(e,fe,n),s(e,Ut,n),s(e,v,n),r(v,ge),r(ge,Ne),r(ge,an),m(ye,ge,null),r(v,rn),r(v,_e),r(_e,ze),r(_e,pn),m(be,_e,null),r(v,dn),r(v,Te),r(Te,Qe),r(Te,cn),m(Me,Te,null),s(e,Ct,n),s(e,we,n),s(e,It,n),m(U,e,n),s(e,kt,n),m(ve,e,n),s(e,Vt,n),s(e,_,n),m(Je,_,null),r(_,mn),r(_,Pe),r(_,hn),r(_,Ee),r(_,un),r(_,C),m(xe,C,null),r(C,fn),r(C,Ye),r(_,gn),r(_,I),m(Ze,I,null),r(I,yn),r(I,Se),r(_,_n),r(_,k),m(je,k,null),r(k,bn),r(k,Fe),s(e,Wt,n),m(Ue,e,n),s(e,Gt,n),s(e,Z,n),m(Ce,Z,null),r(Z,Tn),r(Z,He),s(e,Bt,n),s(e,Ae,n),$t=!0},p(e,[n]){const Ke={};n&2&&(Ke.$$scope={dirty:n,ctx:e}),U.$set(Ke)},i(e){$t||(h(G.$$.fragment,e),h(E.$$.fragment,e),h(Y.$$.fragment,e),h(F.$$.fragment,e),h(q.$$.fragment,e),h(A.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(se.$$.fragment,e),h(oe.$$.fragment,e),h(ae.$$.fragment,e),h(pe.$$.fragment,e),h(ce.$$.fragment,e),h(he.$$.fragment,e),h(ue.$$.fragment,e),h(ye.$$.fragment,e),h(be.$$.fragment,e),h(Me.$$.fragment,e),h(U.$$.fragment,e),h(ve.$$.fragment,e),h(Je.$$.fragment,e),h(xe.$$.fragment,e),h(Ze.$$.fragment,e),h(je.$$.fragment,e),h(Ue.$$.fragment,e),h(Ce.$$.fragment,e),$t=!0)},o(e){u(G.$$.fragment,e),u(E.$$.fragment,e),u(Y.$$.fragment,e),u(F.$$.fragment,e),u(q.$$.fragment,e),u(A.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(se.$$.fragment,e),u(oe.$$.fragment,e),u(ae.$$.fragment,e),u(pe.$$.fragment,e),u(ce.$$.fragment,e),u(he.$$.fragment,e),u(ue.$$.fragment,e),u(ye.$$.fragment,e),u(be.$$.fragment,e),u(Me.$$.fragment,e),u(U.$$.fragment,e),u(ve.$$.fragment,e),u(Je.$$.fragment,e),u(xe.$$.fragment,e),u(Ze.$$.fragment,e),u(je.$$.fragment,e),u(Ue.$$.fragment,e),u(Ce.$$.fragment,e),$t=!1},d(e){e&&(t(W),t(T),t(Ie),t(tt),t(B),t(nt),t($),t(st),t(R),t(ot),t(X),t(lt),t(N),t(at),t(z),t(it),t(Q),t(rt),t(P),t(pt),t(dt),t(ct),t(S),t(mt),t(ht),t(H),t(ut),t(L),t(ft),t(D),t(gt),t(yt),t(_t),t(K),t(bt),t(ke),t(Tt),t(J),t(Mt),t(wt),t(le),t(vt),t(Jt),t(ie),t(xt),t(w),t(Zt),t(jt),t(fe),t(Ut),t(v),t(Ct),t(we),t(It),t(kt),t(Vt),t(_),t(Wt),t(Gt),t(Z),t(Bt),t(Ae)),t(y),f(G,e),f(E,e),f(Y,e),f(F,e),f(q,e),f(A,e),f(ee),f(te),f(se),f(oe,e),f(ae,e),f(pe),f(ce),f(he),f(ue,e),f(ye),f(be),f(Me),f(U,e),f(ve,e),f(Je),f(xe),f(Ze),f(je),f(Ue,e),f(Ce)}}}const ps='{"title":"Text2Video-Zero","local":"text2video-zero","sections":[{"title":"Usage example","local":"usage-example","sections":[{"title":"Text-To-Video","local":"text-to-video","sections":[],"depth":3},{"title":"Text-To-Video with Pose Control","local":"text-to-video-with-pose-control","sections":[],"depth":3},{"title":"Text-To-Video with Edge Control","local":"text-to-video-with-edge-control","sections":[],"depth":3},{"title":"Video Instruct-Pix2Pix","local":"video-instruct-pix2pix","sections":[],"depth":3},{"title":"DreamBooth specialization","local":"dreambooth-specialization","sections":[],"depth":3}],"depth":2},{"title":"TextToVideoZeroPipeline","local":"diffusers.TextToVideoZeroPipeline","sections":[],"depth":2},{"title":"TextToVideoPipelineOutput","local":"diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput","sections":[],"depth":2}],"depth":1}';function ds(et){return ts(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ys extends ss{constructor(y){super(),os(this,y,ds,rs,es,{})}}export{ys as component};
