import{s as aa,o as sa,n as P}from"../chunks/scheduler.182ea377.js";import{S as ia,i as da,g as s,s as r,r as m,A as la,h as i,f as d,c as a,j as M,u as p,x,k as L,y as o,a as b,v as u,d as h,t as g,w as _}from"../chunks/index.abf12888.js";import{T as vt}from"../chunks/Tip.230e2334.js";import{D as C}from"../chunks/Docstring.93f6f462.js";import{C as wo}from"../chunks/CodeBlock.57fe6e13.js";import{E as yo}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as Te}from"../chunks/Heading.16916d63.js";function ca(k){let n,y='🧪 The <code>LoaderMixin</code>s are highly experimental and prone to future changes. To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated</a> models, log-in with <code>huggingface-cli login</code>.';return{c(){n=s("p"),n.innerHTML=y},l(c){n=i(c,"P",{"data-svelte-h":!0}),x(n)!=="svelte-fpi8zo"&&(n.innerHTML=y)},m(c,l){b(c,n,l)},p:P,d(c){c&&d(n)}}}function fa(k){let n,y="To load a textual inversion embedding vector in 🤗 Diffusers format:",c,l,v;return l=new wo({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMCUzQ2NhdC10b3klM0UlMjBiYWNrcGFjayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC1iYWNrcGFjay5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`,wrap:!1}}),{c(){n=s("p"),n.textContent=y,c=r(),m(l.$$.fragment)},l(t){n=i(t,"P",{"data-svelte-h":!0}),x(n)!=="svelte-1y13ww6"&&(n.textContent=y),c=a(t),p(l.$$.fragment,t)},m(t,w){b(t,n,w),b(t,c,w),u(l,t,w),v=!0},p:P,i(t){v||(h(l.$$.fragment,t),v=!0)},o(t){g(l.$$.fragment,t),v=!1},d(t){t&&(d(n),d(c)),_(l,t)}}}function ma(k){let n,y="locally:",c,l,v;return l=new wo({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyLiUyRmNoYXJ0dXJuZXJ2Mi5wdCUyMiUyQyUyMHRva2VuJTNEJTIyY2hhcnR1cm5lcnYyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMG9mJTIwYSUyMHdvbWFuJTIwd2VhcmluZyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMHJlZCUyMHNoaXJ0JTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxzLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoYXJhY3Rlci5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, token=<span class="hljs-string">&quot;charturnerv2&quot;</span>)

prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a woman wearing a black jacket and red shirt, best quality, intricate details.&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;character.png&quot;</span>)`,wrap:!1}}),{c(){n=s("p"),n.textContent=y,c=r(),m(l.$$.fragment)},l(t){n=i(t,"P",{"data-svelte-h":!0}),x(n)!=="svelte-4c75kq"&&(n.textContent=y),c=a(t),p(l.$$.fragment,t)},m(t,w){b(t,n,w),b(t,c,w),u(l,t,w),v=!0},p:P,i(t){v||(h(l.$$.fragment,t),v=!0)},o(t){g(l.$$.fragment,t),v=!1},d(t){t&&(d(n),d(c)),_(l,t)}}}function pa(k){let n,y="This is an experimental API.";return{c(){n=s("p"),n.textContent=y},l(c){n=i(c,"P",{"data-svelte-h":!0}),x(n)!=="svelte-8w79b9"&&(n.textContent=y)},m(c,l){b(c,n,l)},p:P,d(c){c&&d(n)}}}function ua(k){let n,y="Example:",c,l,v;return l=new wo({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmxvYWRfbG9yYV93ZWlnaHRzKCUyMkNpcm9OMjAyMiUyRnRveS1mYWNlJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJ0b3lfZmFjZV9zZHhsLnNhZmV0ZW5zb3JzJTIyJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIydG95JTIyKSUwQXBpcGVsaW5lLmdldF9hY3RpdmVfYWRhcHRlcnMoKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_lora_weights(<span class="hljs-string">&quot;CiroN2022/toy-face&quot;</span>, weight_name=<span class="hljs-string">&quot;toy_face_sdxl.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;toy&quot;</span>)
pipeline.get_active_adapters()`,wrap:!1}}),{c(){n=s("p"),n.textContent=y,c=r(),m(l.$$.fragment)},l(t){n=i(t,"P",{"data-svelte-h":!0}),x(n)!=="svelte-11lpom8"&&(n.textContent=y),c=a(t),p(l.$$.fragment,t)},m(t,w){b(t,n,w),b(t,c,w),u(l,t,w),v=!0},p:P,i(t){v||(h(l.$$.fragment,t),v=!0)},o(t){g(l.$$.fragment,t),v=!1},d(t){t&&(d(n),d(c)),_(l,t)}}}function ha(k){let n,y="We support loading A1111 formatted LoRA checkpoints in a limited capacity.",c,l,v="This function is experimental and might change in the future.";return{c(){n=s("p"),n.textContent=y,c=r(),l=s("p"),l.textContent=v},l(t){n=i(t,"P",{"data-svelte-h":!0}),x(n)!=="svelte-15l1sdn"&&(n.textContent=y),c=a(t),l=i(t,"P",{"data-svelte-h":!0}),x(l)!=="svelte-3fufvn"&&(l.textContent=v)},m(t,w){b(t,n,w),b(t,c,w),b(t,l,w)},p:P,d(t){t&&(d(n),d(c),d(l))}}}function ga(k){let n,y="This is an experimental API.";return{c(){n=s("p"),n.textContent=y},l(c){n=i(c,"P",{"data-svelte-h":!0}),x(n)!=="svelte-8w79b9"&&(n.textContent=y)},m(c,l){b(c,n,l)},p:P,d(c){c&&d(n)}}}function _a(k){let n,y="Examples:",c,l,v;return l=new wo({props:{code:"JTIzJTIwQXNzdW1pbmclMjAlNjBwaXBlbGluZSU2MCUyMGlzJTIwYWxyZWFkeSUyMGxvYWRlZCUyMHdpdGglMjB0aGUlMjBMb1JBJTIwcGFyYW1ldGVycy4lMEFwaXBlbGluZS51bmxvYWRfbG9yYV93ZWlnaHRzKCklMEEuLi4=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Assuming `pipeline` is already loaded with the LoRA parameters.</span>\n<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.unload_lora_weights()\n<span class="hljs-meta">&gt;&gt;&gt; </span>...',wrap:!1}}),{c(){n=s("p"),n.textContent=y,c=r(),m(l.$$.fragment)},l(t){n=i(t,"P",{"data-svelte-h":!0}),x(n)!=="svelte-kvfsh7"&&(n.textContent=y),c=a(t),p(l.$$.fragment,t)},m(t,w){b(t,n,w),b(t,c,w),u(l,t,w),v=!0},p:P,i(t){v||(h(l.$$.fragment,t),v=!0)},o(t){g(l.$$.fragment,t),v=!1},d(t){t&&(d(n),d(c)),_(l,t)}}}function xa(k){let n,y="Examples:",c,l,v;return l=new wo({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGV2Fycmlvck1hbWE3NzclMkZPcmFuZ2VNaXhzJTJGYmxvYiUyRm1haW4lMkZNb2RlbHMlMkZBYnlzc09yYW5nZU1peCUyRkFieXNzT3JhbmdlTWl4LnNhZmV0ZW5zb3JzJTIyJTBBKSUwQSUwQSUyMyUyMERvd25sb2FkJTIwcGlwZWxpbmUlMjBmcm9tJTIwbG9jYWwlMjBmaWxlJTBBJTIzJTIwZmlsZSUyMGlzJTIwZG93bmxvYWRlZCUyMHVuZGVyJTIwLiUyRnYxLTUtcHJ1bmVkLWVtYW9ubHkuY2twdCUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMjIuJTJGdjEtNS1wcnVuZWQtZW1hb25seSUyMiklMEElMEElMjMlMjBFbmFibGUlMjBmbG9hdDE2JTIwYW5kJTIwbW92ZSUyMHRvJTIwR1BVJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRmJsb2IlMkZtYWluJTJGdjEtNS1wcnVuZWQtZW1hb25seS5ja3B0JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQXBpcGVsaW5lLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/WarriorMama777/OrangeMixs/blob/main/Models/AbyssOrangeMix/AbyssOrangeMix.safetensors&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from local file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># file is downloaded under ./v1-5-pruned-emaonly.ckpt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(<span class="hljs-string">&quot;./v1-5-pruned-emaonly&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Enable float16 and move to GPU</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/v1-5-pruned-emaonly.ckpt&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),{c(){n=s("p"),n.textContent=y,c=r(),m(l.$$.fragment)},l(t){n=i(t,"P",{"data-svelte-h":!0}),x(n)!=="svelte-kvfsh7"&&(n.textContent=y),c=a(t),p(l.$$.fragment,t)},m(t,w){b(t,n,w),b(t,c,w),u(l,t,w),v=!0},p:P,i(t){v||(h(l.$$.fragment,t),v=!0)},o(t){g(l.$$.fragment,t),v=!1},d(t){t&&(d(n),d(c)),_(l,t)}}}function ba(k){let n,y="Examples:",c,l,v;return l=new wo({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZSUyQyUyMENvbnRyb2xOZXRNb2RlbCUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZsbGx5YXN2aWVsJTJGQ29udHJvbE5ldC12MS0xJTJGYmxvYiUyRm1haW4lMkZjb250cm9sX3YxMXBfc2QxNV9jYW5ueS5wdGglMjIlMjAlMjAlMjMlMjBjYW4lMjBhbHNvJTIwYmUlMjBhJTIwbG9jYWwlMjBwYXRoJTBBbW9kZWwlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9zaW5nbGVfZmlsZSh1cmwpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGYmxvYiUyRm1haW4lMkZ2MS01LXBydW5lZC5zYWZldGVuc29ycyUyMiUyMCUyMCUyMyUyMGNhbiUyMGFsc28lMjBiZSUyMGElMjBsb2NhbCUyMHBhdGglMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldFBpcGVsaW5lLmZyb21fc2luZ2xlX2ZpbGUodXJsJTJDJTIwY29udHJvbG5ldCUzRGNvbnRyb2xuZXQp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel

url = <span class="hljs-string">&quot;https://huggingface.co/lllyasviel/ControlNet-v1-1/blob/main/control_v11p_sd15_canny.pth&quot;</span>  <span class="hljs-comment"># can also be a local path</span>
model = ControlNetModel.from_single_file(url)

url = <span class="hljs-string">&quot;https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/v1-5-pruned.safetensors&quot;</span>  <span class="hljs-comment"># can also be a local path</span>
pipe = StableDiffusionControlNetPipeline.from_single_file(url, controlnet=controlnet)`,wrap:!1}}),{c(){n=s("p"),n.textContent=y,c=r(),m(l.$$.fragment)},l(t){n=i(t,"P",{"data-svelte-h":!0}),x(n)!=="svelte-kvfsh7"&&(n.textContent=y),c=a(t),p(l.$$.fragment,t)},m(t,w){b(t,n,w),b(t,c,w),u(l,t,w),v=!0},p:P,i(t){v||(h(l.$$.fragment,t),v=!0)},o(t){g(l.$$.fragment,t),v=!1},d(t){t&&(d(n),d(c)),_(l,t)}}}function va(k){let n,y=`Make sure to pass both <code>image_size</code> and <code>scaling_factor</code> to <code>from_single_file()</code> if you want to load
a VAE that does accompany a stable diffusion model of v2 or higher or SDXL.`;return{c(){n=s("p"),n.innerHTML=y},l(c){n=i(c,"P",{"data-svelte-h":!0}),x(n)!=="svelte-1u4e4ei"&&(n.innerHTML=y)},m(c,l){b(c,n,l)},p:P,d(c){c&&d(n)}}}function ya(k){let n,y="Examples:",c,l,v;return l=new wo({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9lbmNvZGVyS0wlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3RhYmlsaXR5YWklMkZzZC12YWUtZnQtbXNlLW9yaWdpbmFsJTJGYmxvYiUyRm1haW4lMkZ2YWUtZnQtbXNlLTg0MDAwMC1lbWEtcHJ1bmVkLnNhZmV0ZW5zb3JzJTIyJTIwJTIwJTIzJTIwY2FuJTIwYWxzbyUyMGJlJTIwbG9jYWwlMjBmaWxlJTBBbW9kZWwlMjAlM0QlMjBBdXRvZW5jb2RlcktMLmZyb21fc2luZ2xlX2ZpbGUodXJsKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKL

url = <span class="hljs-string">&quot;https://huggingface.co/stabilityai/sd-vae-ft-mse-original/blob/main/vae-ft-mse-840000-ema-pruned.safetensors&quot;</span>  <span class="hljs-comment"># can also be local file</span>
model = AutoencoderKL.from_single_file(url)`,wrap:!1}}),{c(){n=s("p"),n.textContent=y,c=r(),m(l.$$.fragment)},l(t){n=i(t,"P",{"data-svelte-h":!0}),x(n)!=="svelte-kvfsh7"&&(n.textContent=y),c=a(t),p(l.$$.fragment,t)},m(t,w){b(t,n,w),b(t,c,w),u(l,t,w),v=!0},p:P,i(t){v||(h(l.$$.fragment,t),v=!0)},o(t){g(l.$$.fragment,t),v=!1},d(t){t&&(d(n),d(c)),_(l,t)}}}function wa(k){let n,y,c,l,v,t,w,xr="Adapters (textual inversion, LoRA, hypernetworks) allow you to modify a diffusion model to generate images in a specific style without training or finetuning the entire model. The adapter weights are very portable because they’re typically only a tiny fraction of the pretrained model weights. 🤗 Diffusers provides an easy-to-use <code>LoaderMixin</code> API to load adapter weights.",yt,K,wt,Ce,$t,U,ke,Bt,$o,Ue,Yt,ee,Ie,Xt,Mo,br="Disables the active LoRA layers for the unet.",Ot,oe,Je,Qt,Lo,vr="Enables the active LoRA layers for the unet.",Kt,te,Fe,en,To,yr=`Load pretrained attention processor layers into <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>. Attention processor layers have to be
defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>attention_processor.py</code></a>
and be a <code>torch.nn.Module</code> class.`,on,ne,De,tn,Co,wr=`Save an attention processor to a directory so that it can be reloaded using the
<a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs">load_attn_procs()</a> method.`,nn,re,Ne,rn,ko,$r="Sets the adapter layers for the unet.",Mt,Ze,Lt,W,We,an,Uo,Mr="Load textual inversion tokens and embeddings to the tokenizer and text encoder.",sn,J,Se,dn,Io,Lr=`Load textual inversion embeddings into the text encoder of <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> (both 🤗 Diffusers and
Automatic1111 formats are supported).`,ln,Jo,Tr="Example:",cn,ae,fn,Fo,Cr=`To load a textual inversion embedding vector in Automatic1111 format, make sure to download the vector first
(for example from <a href="https://civitai.com/models/3036?modelVersionId=9857" rel="nofollow">civitAI</a>) and then load the vector`,mn,se,pn,ie,je,un,Do,kr=`Processes prompts that include a special token corresponding to a multi-vector textual inversion embedding to
be replaced with multiple special tokens each corresponding to one of the vectors. If the prompt has no textual
inversion token or if the textual inversion token is a single vector, the input prompt is returned.`,Tt,Pe,Ct,R,Re,hn,No,Ur="This class overrides <code>LoraLoaderMixin</code> with LoRA loading/saving code that’s specific to SDXL",gn,F,Ee,_n,Zo,Ir=`Load LoRA weights specified in <code>pretrained_model_name_or_path_or_dict</code> into <code>self.unet</code> and
<code>self.text_encoder</code>.`,xn,Wo,Jr="All kwargs are forwarded to <code>self.lora_state_dict</code>.",bn,So,Fr='See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a> for more details on how the state dict is loaded.',vn,jo,Dr=`See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.load_lora_into_unet">load_lora_into_unet()</a> for more details on how the state dict is loaded into
<code>self.unet</code>.`,yn,Po,Nr=`See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder">load_lora_into_text_encoder()</a> for more details on how the state dict is loaded
into <code>self.text_encoder</code>.`,kt,Ge,Ut,$,Ae,wn,Ro,Zr=`Load LoRA layers into <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> and
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow"><code>CLIPTextModel</code></a>.`,$n,Eo,Ve,Mn,de,He,Ln,Go,Wr="Disables the LoRA layers for the text encoder.",Tn,le,ze,Cn,Ao,Sr="Enables the LoRA layers for the text encoder.",kn,A,qe,Un,Vo,jr="Fuses the LoRA parameters into the original parameters of the corresponding blocks.",In,ce,Jn,V,Be,Fn,Ho,Pr="Gets the list of the current active adapters.",Dn,fe,Nn,me,Ye,Zn,zo,Rr="Gets the current list of all available adapters in the pipeline.",Wn,pe,Xe,Sn,qo,Er="This will load the LoRA layers specified in <code>state_dict</code> into <code>text_encoder</code>",jn,ue,Oe,Pn,Bo,Gr="This will load the LoRA layers specified in <code>state_dict</code> into <code>unet</code>.",Rn,D,Qe,En,Yo,Ar=`Load LoRA weights specified in <code>pretrained_model_name_or_path_or_dict</code> into <code>self.unet</code> and
<code>self.text_encoder</code>.`,Gn,Xo,Vr="All kwargs are forwarded to <code>self.lora_state_dict</code>.",An,Oo,Hr='See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a> for more details on how the state dict is loaded.',Vn,Qo,zr=`See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.load_lora_into_unet">load_lora_into_unet()</a> for more details on how the state dict is loaded into
<code>self.unet</code>.`,Hn,Ko,qr=`See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder">load_lora_into_text_encoder()</a> for more details on how the state dict is loaded
into <code>self.text_encoder</code>.`,zn,H,Ke,qn,et,Br="Return state dict for lora weights and the network alphas.",Bn,he,Yn,ge,eo,Xn,ot,Yr="Save the LoRA parameters corresponding to the UNet and text encoder.",On,_e,oo,Qn,tt,Xr="Sets the adapter layers for the text encoder.",Kn,xe,to,er,nt,Or=`Moves the LoRAs listed in <code>adapter_names</code> to a target device. Useful for offloading the LoRA to the CPU in case
you want to load multiple adapters and free some GPU memory.`,or,z,no,tr,rt,Qr=`Reverses the effect of
<a href="https://huggingface.co/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.fuse_lora" rel="nofollow"><code>pipe.fuse_lora()</code></a>.`,nr,be,rr,q,ro,ar,at,Kr="Unloads the LoRA parameters.",sr,ve,It,ao,Jt,E,so,ir,st,ea='Load model weights saved in the <code>.ckpt</code> format into a <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>.',dr,B,io,lr,it,oa=`Instantiate a <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> from pretrained pipeline weights saved in the <code>.ckpt</code> or <code>.safetensors</code>
format. The pipeline is set in evaluation mode (<code>model.eval()</code>) by default.`,cr,ye,Ft,lo,Dt,X,co,fr,Y,fo,mr,dt,ta=`Instantiate a <a href="/docs/diffusers/main/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> from pretrained controlnet weights saved in the original <code>.ckpt</code> or
<code>.safetensors</code> format. The pipeline is set in evaluation mode (<code>model.eval()</code>) by default.`,pr,we,Nt,mo,Zt,O,po,ur,S,uo,hr,lt,na=`Instantiate a <a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a> from pretrained controlnet weights saved in the original <code>.ckpt</code> or
<code>.safetensors</code> format. The pipeline is format. The pipeline is set in evaluation mode (<code>model.eval()</code>) by
default.`,gr,$e,_r,Me,Wt,xt,St;return v=new Te({props:{title:"Loaders",local:"loaders",headingTag:"h1"}}),K=new vt({props:{warning:!0,$$slots:{default:[ca]},$$scope:{ctx:k}}}),Ce=new Te({props:{title:"UNet2DConditionLoadersMixin",local:"diffusers.loaders.UNet2DConditionLoadersMixin",headingTag:"h2"}}),ke=new C({props:{name:"class diffusers.loaders.UNet2DConditionLoadersMixin",anchor:"diffusers.loaders.UNet2DConditionLoadersMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/unet.py#L55"}}),Ue=new C({props:{name:"delete_adapters",anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.delete_adapters",parameters:[{name:"adapter_names",val:": typing.Union[typing.List[str], str]"}],parametersDescription:[{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.delete_adapters.Deletes",description:`<strong>Deletes</strong> the LoRA layers of <code>adapter_name</code> for the unet. &#x2014;
adapter_names (<code>Union[List[str], str]</code>):
The names of the adapter to delete. Can be a single string or a list of strings`,name:"Deletes"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/unet.py#L552"}}),Ie=new C({props:{name:"disable_lora",anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.disable_lora",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/unet.py#L536"}}),Je=new C({props:{name:"enable_lora",anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.enable_lora",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/unet.py#L544"}}),Fe=new C({props:{name:"load_attn_procs",anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": typing.Union[str, typing.Dict[str, torch.Tensor]]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the model id (for example <code>google/ddpm-celebahq-256</code>) of a pretrained model hosted on
the Hub.</li>
<li>A path to a directory (for example <code>./my_model_directory</code>) containing the model weights saved
with <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.save_pretrained">ModelMixin.save_pretrained()</a>.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code> if torch version &gt;= 1.9.0 else <code>False</code>) &#x2014;
Speed up model loading only loading the pretrained weights and not initializing the weights. This also
tries to not use more than 1x model size in CPU memory (including peak memory) while loading the model.
Only supported for PyTorch &gt;= 1.9.0. If you are using an older version of PyTorch, setting this
argument to <code>True</code> will raise an error.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.load_attn_procs.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/unet.py#L59"}}),De=new C({props:{name:"save_attn_procs",anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.save_attn_procs",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"is_main_process",val:": bool = True"},{name:"weight_name",val:": str = None"},{name:"save_function",val:": typing.Callable = None"},{name:"safe_serialization",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.save_attn_procs.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save an attention processor to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.save_attn_procs.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.save_attn_procs.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dictionary. Useful during distributed training when you need to
replace <code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.save_attn_procs.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/unet.py#L386"}}),Ne=new C({props:{name:"set_adapters",anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.set_adapters",parameters:[{name:"adapter_names",val:": typing.Union[typing.List[str], str]"},{name:"weights",val:": typing.Union[typing.List[float], float, NoneType] = None"}],parametersDescription:[{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.set_adapters.adapter_names",description:`<strong>adapter_names</strong> (<code>List[str]</code> or <code>str</code>) &#x2014;
The names of the adapters to use.`,name:"adapter_names"},{anchor:"diffusers.loaders.UNet2DConditionLoadersMixin.set_adapters.weights",description:`<strong>weights</strong> (<code>Union[List[float], float]</code>, <em>optional</em>) &#x2014;
The adapter(s) weights to use with the UNet. If <code>None</code>, the weights are set to <code>1.0</code> for all the
adapters.`,name:"weights"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/unet.py#L504"}}),Ze=new Te({props:{title:"TextualInversionLoaderMixin",local:"diffusers.loaders.TextualInversionLoaderMixin",headingTag:"h2"}}),We=new C({props:{name:"class diffusers.loaders.TextualInversionLoaderMixin",anchor:"diffusers.loaders.TextualInversionLoaderMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/textual_inversion.py#L117"}}),Se=new C({props:{name:"load_textual_inversion",anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, typing.List[str], typing.Dict[str, torch.Tensor], typing.List[typing.Dict[str, torch.Tensor]]]"},{name:"token",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[ForwardRef('PreTrainedTokenizer')] = None"},{name:"text_encoder",val:": typing.Optional[ForwardRef('PreTrainedModel')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code> or <code>List[str or os.PathLike]</code> or <code>Dict</code> or <code>List[Dict]</code>) &#x2014;
Can be either one of the following or a list of them:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>sd-concepts-library/low-poly-hd-logos-icons</code>) of a
pretrained model hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_text_inversion_directory/</code>) containing the textual
inversion weights.</li>
<li>A path to a <em>file</em> (for example <code>./my_text_inversions.pt</code>) containing textual inversion weights.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Override the token to use for the textual inversion weights. If <code>pretrained_model_name_or_path</code> is a
list, then <code>token</code> must also be a list of equal length.`,name:"token"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
If not specified, function will take self.tokenizer.`,name:"text_encoder"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text. If not specified, function will take self.tokenizer.`,name:"tokenizer"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of a custom weight file. This should be used when:</p>
<ul>
<li>The saved textual inversion file is in &#x1F917; Diffusers format, but was saved under a specific weight
name such as <code>text_inv.bin</code>.</li>
<li>The saved textual inversion file is in the Automatic1111 format.</li>
</ul>`,name:"weight_name"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/textual_inversion.py#L270"}}),ae=new yo({props:{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.example",$$slots:{default:[fa]},$$scope:{ctx:k}}}),se=new yo({props:{anchor:"diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion.example-2",$$slots:{default:[ma]},$$scope:{ctx:k}}}),je=new C({props:{name:"maybe_convert_prompt",anchor:"diffusers.loaders.TextualInversionLoaderMixin.maybe_convert_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"tokenizer",val:": PreTrainedTokenizer"}],parametersDescription:[{anchor:"diffusers.loaders.TextualInversionLoaderMixin.maybe_convert_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or list of <code>str</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.loaders.TextualInversionLoaderMixin.maybe_convert_prompt.tokenizer",description:`<strong>tokenizer</strong> (<code>PreTrainedTokenizer</code>) &#x2014;
The tokenizer responsible for encoding the prompt into input tokens.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/textual_inversion.py#L122",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The converted prompt</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code> or list of <code>str</code></p>
`}}),Pe=new Te({props:{title:"StableDiffusionXLLoraLoaderMixin",local:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin",headingTag:"h2"}}),Re=new C({props:{name:"class diffusers.loaders.StableDiffusionXLLoraLoaderMixin",anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L1532"}}),Ee=new C({props:{name:"load_lora_weights",anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": typing.Union[str, typing.Dict[str, torch.Tensor]]"},{name:"adapter_name",val:": typing.Optional[str] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"},{anchor:"diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L1536"}}),Ge=new Te({props:{title:"LoraLoaderMixin",local:"diffusers.loaders.LoraLoaderMixin",headingTag:"h2"}}),Ae=new C({props:{name:"class diffusers.loaders.LoraLoaderMixin",anchor:"diffusers.loaders.LoraLoaderMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L69"}}),Ve=new C({props:{name:"delete_adapters",anchor:"diffusers.loaders.LoraLoaderMixin.delete_adapters",parameters:[{name:"adapter_names",val:": typing.Union[typing.List[str], str]"}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.delete_adapters.Deletes",description:`<strong>Deletes</strong> the LoRA layers of <code>adapter_name</code> for the unet and text-encoder(s). &#x2014;
adapter_names (<code>Union[List[str], str]</code>):
The names of the adapter to delete. Can be a single string or a list of strings`,name:"Deletes"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L1415"}}),He=new C({props:{name:"disable_lora_for_text_encoder",anchor:"diffusers.loaders.LoraLoaderMixin.disable_lora_for_text_encoder",parameters:[{name:"text_encoder",val:": typing.Optional[ForwardRef('PreTrainedModel')] = None"}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.disable_lora_for_text_encoder.text_encoder",description:`<strong>text_encoder</strong> (<code>torch.nn.Module</code>, <em>optional</em>) &#x2014;
The text encoder module to disable the LoRA layers for. If <code>None</code>, it will try to get the
<code>text_encoder</code> attribute.`,name:"text_encoder"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L1342"}}),ze=new C({props:{name:"enable_lora_for_text_encoder",anchor:"diffusers.loaders.LoraLoaderMixin.enable_lora_for_text_encoder",parameters:[{name:"text_encoder",val:": typing.Optional[ForwardRef('PreTrainedModel')] = None"}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.enable_lora_for_text_encoder.text_encoder",description:`<strong>text_encoder</strong> (<code>torch.nn.Module</code>, <em>optional</em>) &#x2014;
The text encoder module to enable the LoRA layers for. If <code>None</code>, it will try to get the <code>text_encoder</code>
attribute.`,name:"text_encoder"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L1359"}}),qe=new C({props:{name:"fuse_lora",anchor:"diffusers.loaders.LoraLoaderMixin.fuse_lora",parameters:[{name:"fuse_unet",val:": bool = True"},{name:"fuse_text_encoder",val:": bool = True"},{name:"lora_scale",val:": float = 1.0"},{name:"safe_fusing",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.fuse_lora.fuse_unet",description:"<strong>fuse_unet</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014; Whether to fuse the UNet LoRA parameters.",name:"fuse_unet"},{anchor:"diffusers.loaders.LoraLoaderMixin.fuse_lora.fuse_text_encoder",description:`<strong>fuse_text_encoder</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to fuse the text encoder LoRA parameters. If the text encoder wasn&#x2019;t monkey-patched with the
LoRA parameters then it won&#x2019;t have any effect.`,name:"fuse_text_encoder"},{anchor:"diffusers.loaders.LoraLoaderMixin.fuse_lora.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, defaults to 1.0) &#x2014;
Controls how much to influence the outputs with the LoRA parameters.`,name:"lora_scale"},{anchor:"diffusers.loaders.LoraLoaderMixin.fuse_lora.safe_fusing",description:`<strong>safe_fusing</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to check fused weights for NaN values before fusing and if values are NaN not fusing them.`,name:"safe_fusing"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L1169"}}),ce=new vt({props:{warning:!0,$$slots:{default:[pa]},$$scope:{ctx:k}}}),Be=new C({props:{name:"get_active_adapters",anchor:"diffusers.loaders.LoraLoaderMixin.get_active_adapters",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L1438"}}),fe=new yo({props:{anchor:"diffusers.loaders.LoraLoaderMixin.get_active_adapters.example",$$slots:{default:[ua]},$$scope:{ctx:k}}}),Ye=new C({props:{name:"get_list_adapters",anchor:"diffusers.loaders.LoraLoaderMixin.get_list_adapters",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L1470"}}),Xe=new C({props:{name:"load_lora_into_text_encoder",anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder",parameters:[{name:"state_dict",val:""},{name:"network_alphas",val:""},{name:"text_encoder",val:""},{name:"prefix",val:" = None"},{name:"lora_scale",val:" = 1.0"},{name:"low_cpu_mem_usage",val:" = None"},{name:"adapter_name",val:" = None"},{name:"_pipeline",val:" = None"}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder.state_dict",description:`<strong>state_dict</strong> (<code>dict</code>) &#x2014;
A standard state dict containing the lora layer parameters. The key should be prefixed with an
additional <code>text_encoder</code> to distinguish between unet lora layers.`,name:"state_dict"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder.network_alphas",description:`<strong>network_alphas</strong> (<code>Dict[str, float]</code>) &#x2014;
See <code>LoRALinearLayer</code> for more details.`,name:"network_alphas"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
The text encoder model to load the LoRA layers into.`,name:"text_encoder"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder.prefix",description:`<strong>prefix</strong> (<code>str</code>) &#x2014;
Expected prefix of the <code>text_encoder</code> in the <code>state_dict</code>.`,name:"prefix"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>) &#x2014;
How much to scale the output of the lora linear layer before it is added with the output of the regular
lora layer.`,name:"lora_scale"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code> if torch version &gt;= 1.9.0 else <code>False</code>) &#x2014;
Speed up model loading only loading the pretrained weights and not initializing the weights. This also
tries to not use more than 1x model size in CPU memory (including peak memory) while loading the model.
Only supported for PyTorch &gt;= 1.9.0. If you are using an older version of PyTorch, setting this
argument to <code>True</code> will raise an error.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L569"}}),Oe=new C({props:{name:"load_lora_into_unet",anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_unet",parameters:[{name:"state_dict",val:""},{name:"network_alphas",val:""},{name:"unet",val:""},{name:"low_cpu_mem_usage",val:" = None"},{name:"adapter_name",val:" = None"},{name:"_pipeline",val:" = None"}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_unet.state_dict",description:`<strong>state_dict</strong> (<code>dict</code>) &#x2014;
A standard state dict containing the lora layer parameters. The keys can either be indexed directly
into the unet or prefixed with an additional <code>unet</code> which can be used to distinguish between text
encoder lora layers.`,name:"state_dict"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_unet.network_alphas",description:`<strong>network_alphas</strong> (<code>Dict[str, float]</code>) &#x2014;
See <code>LoRALinearLayer</code> for more details.`,name:"network_alphas"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_unet.unet",description:`<strong>unet</strong> (<code>UNet2DConditionModel</code>) &#x2014;
The UNet model to load the LoRA layers into.`,name:"unet"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_unet.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code> if torch version &gt;= 1.9.0 else <code>False</code>) &#x2014;
Speed up model loading only loading the pretrained weights and not initializing the weights. This also
tries to not use more than 1x model size in CPU memory (including peak memory) while loading the model.
Only supported for PyTorch &gt;= 1.9.0. If you are using an older version of PyTorch, setting this
argument to <code>True</code> will raise an error.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_into_unet.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L465"}}),Qe=new C({props:{name:"load_lora_weights",anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_weights",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": typing.Union[str, typing.Dict[str, torch.Tensor]]"},{name:"adapter_name",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_weights.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_weights.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"kwargs"},{anchor:"diffusers.loaders.LoraLoaderMixin.load_lora_weights.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L78"}}),Ke=new C({props:{name:"lora_state_dict",anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": typing.Union[str, typing.Dict[str, torch.Tensor]]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>google/ddpm-celebahq-256</code>) of a pretrained model hosted on
the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_model_directory</code>) containing the model weights saved
with <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.save_pretrained">ModelMixin.save_pretrained()</a>.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code> if torch version &gt;= 1.9.0 else <code>False</code>) &#x2014;
Speed up model loading only loading the pretrained weights and not initializing the weights. This also
tries to not use more than 1x model size in CPU memory (including peak memory) while loading the model.
Only supported for PyTorch &gt;= 1.9.0. If you are using an older version of PyTorch, setting this
argument to <code>True</code> will raise an error.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.loaders.LoraLoaderMixin.lora_state_dict.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L133"}}),he=new vt({props:{warning:!0,$$slots:{default:[ha]},$$scope:{ctx:k}}}),eo=new C({props:{name:"save_lora_weights",anchor:"diffusers.loaders.LoraLoaderMixin.save_lora_weights",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"unet_lora_layers",val:": typing.Dict[str, typing.Union[torch.nn.modules.module.Module, torch.Tensor]] = None"},{name:"text_encoder_lora_layers",val:": typing.Dict[str, torch.nn.modules.module.Module] = None"},{name:"is_main_process",val:": bool = True"},{name:"weight_name",val:": str = None"},{name:"save_function",val:": typing.Callable = None"},{name:"safe_serialization",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.save_lora_weights.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save LoRA parameters to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.loaders.LoraLoaderMixin.save_lora_weights.unet_lora_layers",description:`<strong>unet_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>unet</code>.`,name:"unet_lora_layers"},{anchor:"diffusers.loaders.LoraLoaderMixin.save_lora_weights.text_encoder_lora_layers",description:`<strong>text_encoder_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>text_encoder</code>. Must explicitly pass the text
encoder LoRA state dict because it comes from &#x1F917; Transformers.`,name:"text_encoder_lora_layers"},{anchor:"diffusers.loaders.LoraLoaderMixin.save_lora_weights.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.loaders.LoraLoaderMixin.save_lora_weights.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dictionary. Useful during distributed training when you need to
replace <code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.loaders.LoraLoaderMixin.save_lora_weights.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L874"}}),oo=new C({props:{name:"set_adapters_for_text_encoder",anchor:"diffusers.loaders.LoraLoaderMixin.set_adapters_for_text_encoder",parameters:[{name:"adapter_names",val:": typing.Union[typing.List[str], str]"},{name:"text_encoder",val:": typing.Optional[ForwardRef('PreTrainedModel')] = None"},{name:"text_encoder_weights",val:": typing.List[float] = None"}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.set_adapters_for_text_encoder.adapter_names",description:`<strong>adapter_names</strong> (<code>List[str]</code> or <code>str</code>) &#x2014;
The names of the adapters to use.`,name:"adapter_names"},{anchor:"diffusers.loaders.LoraLoaderMixin.set_adapters_for_text_encoder.text_encoder",description:`<strong>text_encoder</strong> (<code>torch.nn.Module</code>, <em>optional</em>) &#x2014;
The text encoder module to set the adapter layers for. If <code>None</code>, it will try to get the <code>text_encoder</code>
attribute.`,name:"text_encoder"},{anchor:"diffusers.loaders.LoraLoaderMixin.set_adapters_for_text_encoder.text_encoder_weights",description:`<strong>text_encoder_weights</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
The weights to use for the text encoder. If <code>None</code>, the weights are set to <code>1.0</code> for all the adapters.`,name:"text_encoder_weights"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L1300"}}),to=new C({props:{name:"set_lora_device",anchor:"diffusers.loaders.LoraLoaderMixin.set_lora_device",parameters:[{name:"adapter_names",val:": typing.List[str]"},{name:"device",val:": typing.Union[torch.device, str, int]"}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.set_lora_device.adapter_names",description:`<strong>adapter_names</strong> (<code>List[str]</code>) &#x2014;
List of adapters to send device to.`,name:"adapter_names"},{anchor:"diffusers.loaders.LoraLoaderMixin.set_lora_device.device",description:`<strong>device</strong> (<code>Union[torch.device, str, int]</code>) &#x2014;
Device to send the adapters to. Can be either a torch device, a str or an integer.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L1492"}}),no=new C({props:{name:"unfuse_lora",anchor:"diffusers.loaders.LoraLoaderMixin.unfuse_lora",parameters:[{name:"unfuse_unet",val:": bool = True"},{name:"unfuse_text_encoder",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.loaders.LoraLoaderMixin.unfuse_lora.unfuse_unet",description:"<strong>unfuse_unet</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014; Whether to unfuse the UNet LoRA parameters.",name:"unfuse_unet"},{anchor:"diffusers.loaders.LoraLoaderMixin.unfuse_lora.unfuse_text_encoder",description:`<strong>unfuse_text_encoder</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to unfuse the text encoder LoRA parameters. If the text encoder wasn&#x2019;t monkey-patched with the
LoRA parameters then it won&#x2019;t have any effect.`,name:"unfuse_text_encoder"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L1240"}}),be=new vt({props:{warning:!0,$$slots:{default:[ga]},$$scope:{ctx:k}}}),ro=new C({props:{name:"unload_lora_weights",anchor:"diffusers.loaders.LoraLoaderMixin.unload_lora_weights",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L1139"}}),ve=new yo({props:{anchor:"diffusers.loaders.LoraLoaderMixin.unload_lora_weights.example",$$slots:{default:[_a]},$$scope:{ctx:k}}}),ao=new Te({props:{title:"FromSingleFileMixin",local:"diffusers.loaders.FromSingleFileMixin",headingTag:"h2"}}),so=new C({props:{name:"class diffusers.loaders.FromSingleFileMixin",anchor:"diffusers.loaders.FromSingleFileMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/single_file.py#L43"}}),io=new C({props:{name:"from_single_file",anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file",parameters:[{name:"pretrained_model_link_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.pretrained_model_link_or_path",description:`<strong>pretrained_model_link_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:<ul>
<li>A link to the <code>.ckpt</code> file (for example
<code>&quot;https://huggingface.co/&lt;repo_id&gt;/blob/main/&lt;path_to_file&gt;.ckpt&quot;</code>) on the Hub.</li>
<li>A path to a <em>file</em> containing all pipeline weights.</li>
</ul>`,name:"pretrained_model_link_or_path"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. If <code>&quot;auto&quot;</code> is passed, the
dtype is automatically derived from the model&#x2019;s weights.`,name:"torch_dtype"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.extract_ema",description:`<strong>extract_ema</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to extract the EMA weights or not. Pass <code>True</code> to extract the EMA weights which usually yield
higher quality images for inference. Non-EMA weights are usually better for continuing finetuning.`,name:"extract_ema"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.upcast_attention",description:`<strong>upcast_attention</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether the attention computation should always be upcasted.`,name:"upcast_attention"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The image size the model was trained on. Use 512 for all Stable Diffusion v1 models and the Stable
Diffusion v2 base model. Use 768 for Stable Diffusion v2.`,name:"image_size"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.prediction_type",description:`<strong>prediction_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The prediction type the model was trained on. Use <code>&apos;epsilon&apos;</code> for all Stable Diffusion v1 models and
the Stable Diffusion v2 base model. Use <code>&apos;v_prediction&apos;</code> for Stable Diffusion v2.`,name:"prediction_type"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.num_in_channels",description:`<strong>num_in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The number of input channels. If <code>None</code>, it is automatically inferred.`,name:"num_in_channels"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.scheduler_type",description:`<strong>scheduler_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pndm&quot;</code>) &#x2014;
Type of scheduler to use. Should be one of <code>[&quot;pndm&quot;, &quot;lms&quot;, &quot;heun&quot;, &quot;euler&quot;, &quot;euler-ancestral&quot;, &quot;dpm&quot;, &quot;ddim&quot;]</code>.`,name:"scheduler_type"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.load_safety_checker",description:`<strong>load_safety_checker</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to load the safety checker or not.`,name:"load_safety_checker"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
An instance of <code>CLIPTextModel</code> to use, specifically the
<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant. If this
parameter is <code>None</code>, the function loads a new instance of <code>CLIPTextModel</code> by itself if needed.`,name:"text_encoder"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.vae",description:`<strong>vae</strong> (<code>AutoencoderKL</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations. If
this parameter is <code>None</code>, the function will load a new instance of [CLIP] by itself, if needed.`,name:"vae"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
An instance of <code>CLIPTokenizer</code> to use. If this parameter is <code>None</code>, the function loads a new instance
of <code>CLIPTokenizer</code> by itself if needed.`,name:"tokenizer"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.original_config_file",description:`<strong>original_config_file</strong> (<code>str</code>) &#x2014;
Path to <code>.yaml</code> config file corresponding to the original architecture. If <code>None</code>, will be
automatically inferred by looking for a key that only exists in SD2.0 models.`,name:"original_config_file"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (for example the pipeline components of the
specific pipeline class). The overwritten components are directly passed to the pipelines <code>__init__</code>
method. See example below for more information.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/single_file.py#L54"}}),ye=new yo({props:{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.example",$$slots:{default:[xa]},$$scope:{ctx:k}}}),lo=new Te({props:{title:"FromOriginalControlnetMixin",local:"diffusers.loaders.FromOriginalControlnetMixin",headingTag:"h2"}}),co=new C({props:{name:"class diffusers.loaders.FromOriginalControlnetMixin",anchor:"diffusers.loaders.FromOriginalControlnetMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/single_file.py#L484"}}),fo=new C({props:{name:"from_single_file",anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file",parameters:[{name:"pretrained_model_link_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.pretrained_model_link_or_path",description:`<strong>pretrained_model_link_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:<ul>
<li>A link to the <code>.ckpt</code> file (for example
<code>&quot;https://huggingface.co/&lt;repo_id&gt;/blob/main/&lt;path_to_file&gt;.ckpt&quot;</code>) on the Hub.</li>
<li>A path to a <em>file</em> containing all pipeline weights.</li>
</ul>`,name:"pretrained_model_link_or_path"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. If <code>&quot;auto&quot;</code> is passed, the
dtype is automatically derived from the model&#x2019;s weights.`,name:"torch_dtype"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to True, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The image size the model was trained on. Use 512 for all Stable Diffusion v1 models and the Stable
Diffusion v2 base model. Use 768 for Stable Diffusion v2.`,name:"image_size"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.upcast_attention",description:`<strong>upcast_attention</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether the attention computation should always be upcasted.`,name:"upcast_attention"},{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (for example the pipeline components of the
specific pipeline class). The overwritten components are directly passed to the pipelines <code>__init__</code>
method. See example below for more information.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/single_file.py#L485"}}),we=new yo({props:{anchor:"diffusers.loaders.FromOriginalControlnetMixin.from_single_file.example",$$slots:{default:[ba]},$$scope:{ctx:k}}}),mo=new Te({props:{title:"FromOriginalVAEMixin",local:"diffusers.loaders.FromOriginalVAEMixin",headingTag:"h2"}}),po=new C({props:{name:"class diffusers.loaders.FromOriginalVAEMixin",anchor:"diffusers.loaders.FromOriginalVAEMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/single_file.py#L290"}}),uo=new C({props:{name:"from_single_file",anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file",parameters:[{name:"pretrained_model_link_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.pretrained_model_link_or_path",description:`<strong>pretrained_model_link_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:<ul>
<li>A link to the <code>.ckpt</code> file (for example
<code>&quot;https://huggingface.co/&lt;repo_id&gt;/blob/main/&lt;path_to_file&gt;.ckpt&quot;</code>) on the Hub.</li>
<li>A path to a <em>file</em> containing all pipeline weights.</li>
</ul>`,name:"pretrained_model_link_or_path"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. If <code>&quot;auto&quot;</code> is passed, the
dtype is automatically derived from the model&#x2019;s weights.`,name:"torch_dtype"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to True, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The image size the model was trained on. Use 512 for all Stable Diffusion v1 models and the Stable
Diffusion v2 base model. Use 768 for Stable Diffusion v2.`,name:"image_size"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.upcast_attention",description:`<strong>upcast_attention</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether the attention computation should always be upcasted.`,name:"upcast_attention"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.scaling_factor",description:`<strong>scaling_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.18215) &#x2014;
The component-wise standard deviation of the trained latent space computed using the first batch of the
training set. This is used to scale the latent space to have unit variance when training the diffusion
model. The latents are scaled with the formula <code>z = z * scaling_factor</code> before being passed to the
diffusion model. When decoding, the latents are scaled back to the original scale with the formula: <code>z = 1 / scaling_factor * z</code>. For more details, refer to sections 4.3.2 and D.1 of the <a href="https://arxiv.org/abs/2112.10752" rel="nofollow">High-Resolution
Image Synthesis with Latent Diffusion Models</a> paper.`,name:"scaling_factor"},{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (for example the pipeline components of the
specific pipeline class). The overwritten components are directly passed to the pipelines <code>__init__</code>
method. See example below for more information.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/single_file.py#L291"}}),$e=new vt({props:{warning:!0,$$slots:{default:[va]},$$scope:{ctx:k}}}),Me=new yo({props:{anchor:"diffusers.loaders.FromOriginalVAEMixin.from_single_file.example",$$slots:{default:[ya]},$$scope:{ctx:k}}}),{c(){n=s("meta"),y=r(),c=s("p"),l=r(),m(v.$$.fragment),t=r(),w=s("p"),w.innerHTML=xr,yt=r(),m(K.$$.fragment),wt=r(),m(Ce.$$.fragment),$t=r(),U=s("div"),m(ke.$$.fragment),Bt=r(),$o=s("div"),m(Ue.$$.fragment),Yt=r(),ee=s("div"),m(Ie.$$.fragment),Xt=r(),Mo=s("p"),Mo.textContent=br,Ot=r(),oe=s("div"),m(Je.$$.fragment),Qt=r(),Lo=s("p"),Lo.textContent=vr,Kt=r(),te=s("div"),m(Fe.$$.fragment),en=r(),To=s("p"),To.innerHTML=yr,on=r(),ne=s("div"),m(De.$$.fragment),tn=r(),Co=s("p"),Co.innerHTML=wr,nn=r(),re=s("div"),m(Ne.$$.fragment),rn=r(),ko=s("p"),ko.textContent=$r,Mt=r(),m(Ze.$$.fragment),Lt=r(),W=s("div"),m(We.$$.fragment),an=r(),Uo=s("p"),Uo.textContent=Mr,sn=r(),J=s("div"),m(Se.$$.fragment),dn=r(),Io=s("p"),Io.innerHTML=Lr,ln=r(),Jo=s("p"),Jo.textContent=Tr,cn=r(),m(ae.$$.fragment),fn=r(),Fo=s("p"),Fo.innerHTML=Cr,mn=r(),m(se.$$.fragment),pn=r(),ie=s("div"),m(je.$$.fragment),un=r(),Do=s("p"),Do.textContent=kr,Tt=r(),m(Pe.$$.fragment),Ct=r(),R=s("div"),m(Re.$$.fragment),hn=r(),No=s("p"),No.innerHTML=Ur,gn=r(),F=s("div"),m(Ee.$$.fragment),_n=r(),Zo=s("p"),Zo.innerHTML=Ir,xn=r(),Wo=s("p"),Wo.innerHTML=Jr,bn=r(),So=s("p"),So.innerHTML=Fr,vn=r(),jo=s("p"),jo.innerHTML=Dr,yn=r(),Po=s("p"),Po.innerHTML=Nr,kt=r(),m(Ge.$$.fragment),Ut=r(),$=s("div"),m(Ae.$$.fragment),wn=r(),Ro=s("p"),Ro.innerHTML=Zr,$n=r(),Eo=s("div"),m(Ve.$$.fragment),Mn=r(),de=s("div"),m(He.$$.fragment),Ln=r(),Go=s("p"),Go.textContent=Wr,Tn=r(),le=s("div"),m(ze.$$.fragment),Cn=r(),Ao=s("p"),Ao.textContent=Sr,kn=r(),A=s("div"),m(qe.$$.fragment),Un=r(),Vo=s("p"),Vo.textContent=jr,In=r(),m(ce.$$.fragment),Jn=r(),V=s("div"),m(Be.$$.fragment),Fn=r(),Ho=s("p"),Ho.textContent=Pr,Dn=r(),m(fe.$$.fragment),Nn=r(),me=s("div"),m(Ye.$$.fragment),Zn=r(),zo=s("p"),zo.textContent=Rr,Wn=r(),pe=s("div"),m(Xe.$$.fragment),Sn=r(),qo=s("p"),qo.innerHTML=Er,jn=r(),ue=s("div"),m(Oe.$$.fragment),Pn=r(),Bo=s("p"),Bo.innerHTML=Gr,Rn=r(),D=s("div"),m(Qe.$$.fragment),En=r(),Yo=s("p"),Yo.innerHTML=Ar,Gn=r(),Xo=s("p"),Xo.innerHTML=Vr,An=r(),Oo=s("p"),Oo.innerHTML=Hr,Vn=r(),Qo=s("p"),Qo.innerHTML=zr,Hn=r(),Ko=s("p"),Ko.innerHTML=qr,zn=r(),H=s("div"),m(Ke.$$.fragment),qn=r(),et=s("p"),et.textContent=Br,Bn=r(),m(he.$$.fragment),Yn=r(),ge=s("div"),m(eo.$$.fragment),Xn=r(),ot=s("p"),ot.textContent=Yr,On=r(),_e=s("div"),m(oo.$$.fragment),Qn=r(),tt=s("p"),tt.textContent=Xr,Kn=r(),xe=s("div"),m(to.$$.fragment),er=r(),nt=s("p"),nt.innerHTML=Or,or=r(),z=s("div"),m(no.$$.fragment),tr=r(),rt=s("p"),rt.innerHTML=Qr,nr=r(),m(be.$$.fragment),rr=r(),q=s("div"),m(ro.$$.fragment),ar=r(),at=s("p"),at.textContent=Kr,sr=r(),m(ve.$$.fragment),It=r(),m(ao.$$.fragment),Jt=r(),E=s("div"),m(so.$$.fragment),ir=r(),st=s("p"),st.innerHTML=ea,dr=r(),B=s("div"),m(io.$$.fragment),lr=r(),it=s("p"),it.innerHTML=oa,cr=r(),m(ye.$$.fragment),Ft=r(),m(lo.$$.fragment),Dt=r(),X=s("div"),m(co.$$.fragment),fr=r(),Y=s("div"),m(fo.$$.fragment),mr=r(),dt=s("p"),dt.innerHTML=ta,pr=r(),m(we.$$.fragment),Nt=r(),m(mo.$$.fragment),Zt=r(),O=s("div"),m(po.$$.fragment),ur=r(),S=s("div"),m(uo.$$.fragment),hr=r(),lt=s("p"),lt.innerHTML=na,gr=r(),m($e.$$.fragment),_r=r(),m(Me.$$.fragment),Wt=r(),xt=s("p"),this.h()},l(e){const f=la("svelte-u9bgzb",document.head);n=i(f,"META",{name:!0,content:!0}),f.forEach(d),y=a(e),c=i(e,"P",{}),M(c).forEach(d),l=a(e),p(v.$$.fragment,e),t=a(e),w=i(e,"P",{"data-svelte-h":!0}),x(w)!=="svelte-zcft6j"&&(w.innerHTML=xr),yt=a(e),p(K.$$.fragment,e),wt=a(e),p(Ce.$$.fragment,e),$t=a(e),U=i(e,"DIV",{class:!0});var I=M(U);p(ke.$$.fragment,I),Bt=a(I),$o=i(I,"DIV",{class:!0});var bt=M($o);p(Ue.$$.fragment,bt),bt.forEach(d),Yt=a(I),ee=i(I,"DIV",{class:!0});var ho=M(ee);p(Ie.$$.fragment,ho),Xt=a(ho),Mo=i(ho,"P",{"data-svelte-h":!0}),x(Mo)!=="svelte-6zpqka"&&(Mo.textContent=br),ho.forEach(d),Ot=a(I),oe=i(I,"DIV",{class:!0});var go=M(oe);p(Je.$$.fragment,go),Qt=a(go),Lo=i(go,"P",{"data-svelte-h":!0}),x(Lo)!=="svelte-1wwvhh7"&&(Lo.textContent=vr),go.forEach(d),Kt=a(I),te=i(I,"DIV",{class:!0});var _o=M(te);p(Fe.$$.fragment,_o),en=a(_o),To=i(_o,"P",{"data-svelte-h":!0}),x(To)!=="svelte-u9tliy"&&(To.innerHTML=yr),_o.forEach(d),on=a(I),ne=i(I,"DIV",{class:!0});var xo=M(ne);p(De.$$.fragment,xo),tn=a(xo),Co=i(xo,"P",{"data-svelte-h":!0}),x(Co)!=="svelte-1j7rcpo"&&(Co.innerHTML=wr),xo.forEach(d),nn=a(I),re=i(I,"DIV",{class:!0});var bo=M(re);p(Ne.$$.fragment,bo),rn=a(bo),ko=i(bo,"P",{"data-svelte-h":!0}),x(ko)!=="svelte-1mxhf81"&&(ko.textContent=$r),bo.forEach(d),I.forEach(d),Mt=a(e),p(Ze.$$.fragment,e),Lt=a(e),W=i(e,"DIV",{class:!0});var G=M(W);p(We.$$.fragment,G),an=a(G),Uo=i(G,"P",{"data-svelte-h":!0}),x(Uo)!=="svelte-100hk3u"&&(Uo.textContent=Mr),sn=a(G),J=i(G,"DIV",{class:!0});var N=M(J);p(Se.$$.fragment,N),dn=a(N),Io=i(N,"P",{"data-svelte-h":!0}),x(Io)!=="svelte-617c7s"&&(Io.innerHTML=Lr),ln=a(N),Jo=i(N,"P",{"data-svelte-h":!0}),x(Jo)!=="svelte-11lpom8"&&(Jo.textContent=Tr),cn=a(N),p(ae.$$.fragment,N),fn=a(N),Fo=i(N,"P",{"data-svelte-h":!0}),x(Fo)!=="svelte-2gddoh"&&(Fo.innerHTML=Cr),mn=a(N),p(se.$$.fragment,N),N.forEach(d),pn=a(G),ie=i(G,"DIV",{class:!0});var vo=M(ie);p(je.$$.fragment,vo),un=a(vo),Do=i(vo,"P",{"data-svelte-h":!0}),x(Do)!=="svelte-gjjmbb"&&(Do.textContent=kr),vo.forEach(d),G.forEach(d),Tt=a(e),p(Pe.$$.fragment,e),Ct=a(e),R=i(e,"DIV",{class:!0});var Q=M(R);p(Re.$$.fragment,Q),hn=a(Q),No=i(Q,"P",{"data-svelte-h":!0}),x(No)!=="svelte-1powver"&&(No.innerHTML=Ur),gn=a(Q),F=i(Q,"DIV",{class:!0});var Z=M(F);p(Ee.$$.fragment,Z),_n=a(Z),Zo=i(Z,"P",{"data-svelte-h":!0}),x(Zo)!=="svelte-vs7s0z"&&(Zo.innerHTML=Ir),xn=a(Z),Wo=i(Z,"P",{"data-svelte-h":!0}),x(Wo)!=="svelte-15b960v"&&(Wo.innerHTML=Jr),bn=a(Z),So=i(Z,"P",{"data-svelte-h":!0}),x(So)!=="svelte-qj05o3"&&(So.innerHTML=Fr),vn=a(Z),jo=i(Z,"P",{"data-svelte-h":!0}),x(jo)!=="svelte-ot29jq"&&(jo.innerHTML=Dr),yn=a(Z),Po=i(Z,"P",{"data-svelte-h":!0}),x(Po)!=="svelte-1ah097o"&&(Po.innerHTML=Nr),Z.forEach(d),Q.forEach(d),kt=a(e),p(Ge.$$.fragment,e),Ut=a(e),$=i(e,"DIV",{class:!0});var T=M($);p(Ae.$$.fragment,T),wn=a(T),Ro=i(T,"P",{"data-svelte-h":!0}),x(Ro)!=="svelte-1pb3n03"&&(Ro.innerHTML=Zr),$n=a(T),Eo=i(T,"DIV",{class:!0});var ra=M(Eo);p(Ve.$$.fragment,ra),ra.forEach(d),Mn=a(T),de=i(T,"DIV",{class:!0});var jt=M(de);p(He.$$.fragment,jt),Ln=a(jt),Go=i(jt,"P",{"data-svelte-h":!0}),x(Go)!=="svelte-tbr0r9"&&(Go.textContent=Wr),jt.forEach(d),Tn=a(T),le=i(T,"DIV",{class:!0});var Pt=M(le);p(ze.$$.fragment,Pt),Cn=a(Pt),Ao=i(Pt,"P",{"data-svelte-h":!0}),x(Ao)!=="svelte-ujvdgi"&&(Ao.textContent=Sr),Pt.forEach(d),kn=a(T),A=i(T,"DIV",{class:!0});var ct=M(A);p(qe.$$.fragment,ct),Un=a(ct),Vo=i(ct,"P",{"data-svelte-h":!0}),x(Vo)!=="svelte-1nr2dy0"&&(Vo.textContent=jr),In=a(ct),p(ce.$$.fragment,ct),ct.forEach(d),Jn=a(T),V=i(T,"DIV",{class:!0});var ft=M(V);p(Be.$$.fragment,ft),Fn=a(ft),Ho=i(ft,"P",{"data-svelte-h":!0}),x(Ho)!=="svelte-h0os0v"&&(Ho.textContent=Pr),Dn=a(ft),p(fe.$$.fragment,ft),ft.forEach(d),Nn=a(T),me=i(T,"DIV",{class:!0});var Rt=M(me);p(Ye.$$.fragment,Rt),Zn=a(Rt),zo=i(Rt,"P",{"data-svelte-h":!0}),x(zo)!=="svelte-1825k9e"&&(zo.textContent=Rr),Rt.forEach(d),Wn=a(T),pe=i(T,"DIV",{class:!0});var Et=M(pe);p(Xe.$$.fragment,Et),Sn=a(Et),qo=i(Et,"P",{"data-svelte-h":!0}),x(qo)!=="svelte-1062ci4"&&(qo.innerHTML=Er),Et.forEach(d),jn=a(T),ue=i(T,"DIV",{class:!0});var Gt=M(ue);p(Oe.$$.fragment,Gt),Pn=a(Gt),Bo=i(Gt,"P",{"data-svelte-h":!0}),x(Bo)!=="svelte-u3q4so"&&(Bo.innerHTML=Gr),Gt.forEach(d),Rn=a(T),D=i(T,"DIV",{class:!0});var j=M(D);p(Qe.$$.fragment,j),En=a(j),Yo=i(j,"P",{"data-svelte-h":!0}),x(Yo)!=="svelte-vs7s0z"&&(Yo.innerHTML=Ar),Gn=a(j),Xo=i(j,"P",{"data-svelte-h":!0}),x(Xo)!=="svelte-15b960v"&&(Xo.innerHTML=Vr),An=a(j),Oo=i(j,"P",{"data-svelte-h":!0}),x(Oo)!=="svelte-qj05o3"&&(Oo.innerHTML=Hr),Vn=a(j),Qo=i(j,"P",{"data-svelte-h":!0}),x(Qo)!=="svelte-ot29jq"&&(Qo.innerHTML=zr),Hn=a(j),Ko=i(j,"P",{"data-svelte-h":!0}),x(Ko)!=="svelte-1ah097o"&&(Ko.innerHTML=qr),j.forEach(d),zn=a(T),H=i(T,"DIV",{class:!0});var mt=M(H);p(Ke.$$.fragment,mt),qn=a(mt),et=i(mt,"P",{"data-svelte-h":!0}),x(et)!=="svelte-flusvq"&&(et.textContent=Br),Bn=a(mt),p(he.$$.fragment,mt),mt.forEach(d),Yn=a(T),ge=i(T,"DIV",{class:!0});var At=M(ge);p(eo.$$.fragment,At),Xn=a(At),ot=i(At,"P",{"data-svelte-h":!0}),x(ot)!=="svelte-1ufq5ot"&&(ot.textContent=Yr),At.forEach(d),On=a(T),_e=i(T,"DIV",{class:!0});var Vt=M(_e);p(oo.$$.fragment,Vt),Qn=a(Vt),tt=i(Vt,"P",{"data-svelte-h":!0}),x(tt)!=="svelte-kmejci"&&(tt.textContent=Xr),Vt.forEach(d),Kn=a(T),xe=i(T,"DIV",{class:!0});var Ht=M(xe);p(to.$$.fragment,Ht),er=a(Ht),nt=i(Ht,"P",{"data-svelte-h":!0}),x(nt)!=="svelte-rvubqa"&&(nt.innerHTML=Or),Ht.forEach(d),or=a(T),z=i(T,"DIV",{class:!0});var pt=M(z);p(no.$$.fragment,pt),tr=a(pt),rt=i(pt,"P",{"data-svelte-h":!0}),x(rt)!=="svelte-56a0bo"&&(rt.innerHTML=Qr),nr=a(pt),p(be.$$.fragment,pt),pt.forEach(d),rr=a(T),q=i(T,"DIV",{class:!0});var ut=M(q);p(ro.$$.fragment,ut),ar=a(ut),at=i(ut,"P",{"data-svelte-h":!0}),x(at)!=="svelte-119cgd9"&&(at.textContent=Kr),sr=a(ut),p(ve.$$.fragment,ut),ut.forEach(d),T.forEach(d),It=a(e),p(ao.$$.fragment,e),Jt=a(e),E=i(e,"DIV",{class:!0});var ht=M(E);p(so.$$.fragment,ht),ir=a(ht),st=i(ht,"P",{"data-svelte-h":!0}),x(st)!=="svelte-11v9qjy"&&(st.innerHTML=ea),dr=a(ht),B=i(ht,"DIV",{class:!0});var gt=M(B);p(io.$$.fragment,gt),lr=a(gt),it=i(gt,"P",{"data-svelte-h":!0}),x(it)!=="svelte-pmqrln"&&(it.innerHTML=oa),cr=a(gt),p(ye.$$.fragment,gt),gt.forEach(d),ht.forEach(d),Ft=a(e),p(lo.$$.fragment,e),Dt=a(e),X=i(e,"DIV",{class:!0});var zt=M(X);p(co.$$.fragment,zt),fr=a(zt),Y=i(zt,"DIV",{class:!0});var _t=M(Y);p(fo.$$.fragment,_t),mr=a(_t),dt=i(_t,"P",{"data-svelte-h":!0}),x(dt)!=="svelte-1keh2nw"&&(dt.innerHTML=ta),pr=a(_t),p(we.$$.fragment,_t),_t.forEach(d),zt.forEach(d),Nt=a(e),p(mo.$$.fragment,e),Zt=a(e),O=i(e,"DIV",{class:!0});var qt=M(O);p(po.$$.fragment,qt),ur=a(qt),S=i(qt,"DIV",{class:!0});var Le=M(S);p(uo.$$.fragment,Le),hr=a(Le),lt=i(Le,"P",{"data-svelte-h":!0}),x(lt)!=="svelte-12bf65c"&&(lt.innerHTML=na),gr=a(Le),p($e.$$.fragment,Le),_r=a(Le),p(Me.$$.fragment,Le),Le.forEach(d),qt.forEach(d),Wt=a(e),xt=i(e,"P",{}),M(xt).forEach(d),this.h()},h(){L(n,"name","hf:doc:metadata"),L(n,"content",$a),L($o,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(Eo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),L(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,f){o(document.head,n),b(e,y,f),b(e,c,f),b(e,l,f),u(v,e,f),b(e,t,f),b(e,w,f),b(e,yt,f),u(K,e,f),b(e,wt,f),u(Ce,e,f),b(e,$t,f),b(e,U,f),u(ke,U,null),o(U,Bt),o(U,$o),u(Ue,$o,null),o(U,Yt),o(U,ee),u(Ie,ee,null),o(ee,Xt),o(ee,Mo),o(U,Ot),o(U,oe),u(Je,oe,null),o(oe,Qt),o(oe,Lo),o(U,Kt),o(U,te),u(Fe,te,null),o(te,en),o(te,To),o(U,on),o(U,ne),u(De,ne,null),o(ne,tn),o(ne,Co),o(U,nn),o(U,re),u(Ne,re,null),o(re,rn),o(re,ko),b(e,Mt,f),u(Ze,e,f),b(e,Lt,f),b(e,W,f),u(We,W,null),o(W,an),o(W,Uo),o(W,sn),o(W,J),u(Se,J,null),o(J,dn),o(J,Io),o(J,ln),o(J,Jo),o(J,cn),u(ae,J,null),o(J,fn),o(J,Fo),o(J,mn),u(se,J,null),o(W,pn),o(W,ie),u(je,ie,null),o(ie,un),o(ie,Do),b(e,Tt,f),u(Pe,e,f),b(e,Ct,f),b(e,R,f),u(Re,R,null),o(R,hn),o(R,No),o(R,gn),o(R,F),u(Ee,F,null),o(F,_n),o(F,Zo),o(F,xn),o(F,Wo),o(F,bn),o(F,So),o(F,vn),o(F,jo),o(F,yn),o(F,Po),b(e,kt,f),u(Ge,e,f),b(e,Ut,f),b(e,$,f),u(Ae,$,null),o($,wn),o($,Ro),o($,$n),o($,Eo),u(Ve,Eo,null),o($,Mn),o($,de),u(He,de,null),o(de,Ln),o(de,Go),o($,Tn),o($,le),u(ze,le,null),o(le,Cn),o(le,Ao),o($,kn),o($,A),u(qe,A,null),o(A,Un),o(A,Vo),o(A,In),u(ce,A,null),o($,Jn),o($,V),u(Be,V,null),o(V,Fn),o(V,Ho),o(V,Dn),u(fe,V,null),o($,Nn),o($,me),u(Ye,me,null),o(me,Zn),o(me,zo),o($,Wn),o($,pe),u(Xe,pe,null),o(pe,Sn),o(pe,qo),o($,jn),o($,ue),u(Oe,ue,null),o(ue,Pn),o(ue,Bo),o($,Rn),o($,D),u(Qe,D,null),o(D,En),o(D,Yo),o(D,Gn),o(D,Xo),o(D,An),o(D,Oo),o(D,Vn),o(D,Qo),o(D,Hn),o(D,Ko),o($,zn),o($,H),u(Ke,H,null),o(H,qn),o(H,et),o(H,Bn),u(he,H,null),o($,Yn),o($,ge),u(eo,ge,null),o(ge,Xn),o(ge,ot),o($,On),o($,_e),u(oo,_e,null),o(_e,Qn),o(_e,tt),o($,Kn),o($,xe),u(to,xe,null),o(xe,er),o(xe,nt),o($,or),o($,z),u(no,z,null),o(z,tr),o(z,rt),o(z,nr),u(be,z,null),o($,rr),o($,q),u(ro,q,null),o(q,ar),o(q,at),o(q,sr),u(ve,q,null),b(e,It,f),u(ao,e,f),b(e,Jt,f),b(e,E,f),u(so,E,null),o(E,ir),o(E,st),o(E,dr),o(E,B),u(io,B,null),o(B,lr),o(B,it),o(B,cr),u(ye,B,null),b(e,Ft,f),u(lo,e,f),b(e,Dt,f),b(e,X,f),u(co,X,null),o(X,fr),o(X,Y),u(fo,Y,null),o(Y,mr),o(Y,dt),o(Y,pr),u(we,Y,null),b(e,Nt,f),u(mo,e,f),b(e,Zt,f),b(e,O,f),u(po,O,null),o(O,ur),o(O,S),u(uo,S,null),o(S,hr),o(S,lt),o(S,gr),u($e,S,null),o(S,_r),u(Me,S,null),b(e,Wt,f),b(e,xt,f),St=!0},p(e,[f]){const I={};f&2&&(I.$$scope={dirty:f,ctx:e}),K.$set(I);const bt={};f&2&&(bt.$$scope={dirty:f,ctx:e}),ae.$set(bt);const ho={};f&2&&(ho.$$scope={dirty:f,ctx:e}),se.$set(ho);const go={};f&2&&(go.$$scope={dirty:f,ctx:e}),ce.$set(go);const _o={};f&2&&(_o.$$scope={dirty:f,ctx:e}),fe.$set(_o);const xo={};f&2&&(xo.$$scope={dirty:f,ctx:e}),he.$set(xo);const bo={};f&2&&(bo.$$scope={dirty:f,ctx:e}),be.$set(bo);const G={};f&2&&(G.$$scope={dirty:f,ctx:e}),ve.$set(G);const N={};f&2&&(N.$$scope={dirty:f,ctx:e}),ye.$set(N);const vo={};f&2&&(vo.$$scope={dirty:f,ctx:e}),we.$set(vo);const Q={};f&2&&(Q.$$scope={dirty:f,ctx:e}),$e.$set(Q);const Z={};f&2&&(Z.$$scope={dirty:f,ctx:e}),Me.$set(Z)},i(e){St||(h(v.$$.fragment,e),h(K.$$.fragment,e),h(Ce.$$.fragment,e),h(ke.$$.fragment,e),h(Ue.$$.fragment,e),h(Ie.$$.fragment,e),h(Je.$$.fragment,e),h(Fe.$$.fragment,e),h(De.$$.fragment,e),h(Ne.$$.fragment,e),h(Ze.$$.fragment,e),h(We.$$.fragment,e),h(Se.$$.fragment,e),h(ae.$$.fragment,e),h(se.$$.fragment,e),h(je.$$.fragment,e),h(Pe.$$.fragment,e),h(Re.$$.fragment,e),h(Ee.$$.fragment,e),h(Ge.$$.fragment,e),h(Ae.$$.fragment,e),h(Ve.$$.fragment,e),h(He.$$.fragment,e),h(ze.$$.fragment,e),h(qe.$$.fragment,e),h(ce.$$.fragment,e),h(Be.$$.fragment,e),h(fe.$$.fragment,e),h(Ye.$$.fragment,e),h(Xe.$$.fragment,e),h(Oe.$$.fragment,e),h(Qe.$$.fragment,e),h(Ke.$$.fragment,e),h(he.$$.fragment,e),h(eo.$$.fragment,e),h(oo.$$.fragment,e),h(to.$$.fragment,e),h(no.$$.fragment,e),h(be.$$.fragment,e),h(ro.$$.fragment,e),h(ve.$$.fragment,e),h(ao.$$.fragment,e),h(so.$$.fragment,e),h(io.$$.fragment,e),h(ye.$$.fragment,e),h(lo.$$.fragment,e),h(co.$$.fragment,e),h(fo.$$.fragment,e),h(we.$$.fragment,e),h(mo.$$.fragment,e),h(po.$$.fragment,e),h(uo.$$.fragment,e),h($e.$$.fragment,e),h(Me.$$.fragment,e),St=!0)},o(e){g(v.$$.fragment,e),g(K.$$.fragment,e),g(Ce.$$.fragment,e),g(ke.$$.fragment,e),g(Ue.$$.fragment,e),g(Ie.$$.fragment,e),g(Je.$$.fragment,e),g(Fe.$$.fragment,e),g(De.$$.fragment,e),g(Ne.$$.fragment,e),g(Ze.$$.fragment,e),g(We.$$.fragment,e),g(Se.$$.fragment,e),g(ae.$$.fragment,e),g(se.$$.fragment,e),g(je.$$.fragment,e),g(Pe.$$.fragment,e),g(Re.$$.fragment,e),g(Ee.$$.fragment,e),g(Ge.$$.fragment,e),g(Ae.$$.fragment,e),g(Ve.$$.fragment,e),g(He.$$.fragment,e),g(ze.$$.fragment,e),g(qe.$$.fragment,e),g(ce.$$.fragment,e),g(Be.$$.fragment,e),g(fe.$$.fragment,e),g(Ye.$$.fragment,e),g(Xe.$$.fragment,e),g(Oe.$$.fragment,e),g(Qe.$$.fragment,e),g(Ke.$$.fragment,e),g(he.$$.fragment,e),g(eo.$$.fragment,e),g(oo.$$.fragment,e),g(to.$$.fragment,e),g(no.$$.fragment,e),g(be.$$.fragment,e),g(ro.$$.fragment,e),g(ve.$$.fragment,e),g(ao.$$.fragment,e),g(so.$$.fragment,e),g(io.$$.fragment,e),g(ye.$$.fragment,e),g(lo.$$.fragment,e),g(co.$$.fragment,e),g(fo.$$.fragment,e),g(we.$$.fragment,e),g(mo.$$.fragment,e),g(po.$$.fragment,e),g(uo.$$.fragment,e),g($e.$$.fragment,e),g(Me.$$.fragment,e),St=!1},d(e){e&&(d(y),d(c),d(l),d(t),d(w),d(yt),d(wt),d($t),d(U),d(Mt),d(Lt),d(W),d(Tt),d(Ct),d(R),d(kt),d(Ut),d($),d(It),d(Jt),d(E),d(Ft),d(Dt),d(X),d(Nt),d(Zt),d(O),d(Wt),d(xt)),d(n),_(v,e),_(K,e),_(Ce,e),_(ke),_(Ue),_(Ie),_(Je),_(Fe),_(De),_(Ne),_(Ze,e),_(We),_(Se),_(ae),_(se),_(je),_(Pe,e),_(Re),_(Ee),_(Ge,e),_(Ae),_(Ve),_(He),_(ze),_(qe),_(ce),_(Be),_(fe),_(Ye),_(Xe),_(Oe),_(Qe),_(Ke),_(he),_(eo),_(oo),_(to),_(no),_(be),_(ro),_(ve),_(ao,e),_(so),_(io),_(ye),_(lo,e),_(co),_(fo),_(we),_(mo,e),_(po),_(uo),_($e),_(Me)}}}const $a='{"title":"Loaders","local":"loaders","sections":[{"title":"UNet2DConditionLoadersMixin","local":"diffusers.loaders.UNet2DConditionLoadersMixin","sections":[],"depth":2},{"title":"TextualInversionLoaderMixin","local":"diffusers.loaders.TextualInversionLoaderMixin","sections":[],"depth":2},{"title":"StableDiffusionXLLoraLoaderMixin","local":"diffusers.loaders.StableDiffusionXLLoraLoaderMixin","sections":[],"depth":2},{"title":"LoraLoaderMixin","local":"diffusers.loaders.LoraLoaderMixin","sections":[],"depth":2},{"title":"FromSingleFileMixin","local":"diffusers.loaders.FromSingleFileMixin","sections":[],"depth":2},{"title":"FromOriginalControlnetMixin","local":"diffusers.loaders.FromOriginalControlnetMixin","sections":[],"depth":2},{"title":"FromOriginalVAEMixin","local":"diffusers.loaders.FromOriginalVAEMixin","sections":[],"depth":2}],"depth":1}';function Ma(k){return sa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fa extends ia{constructor(n){super(),da(this,n,Ma,wa,aa,{})}}export{Fa as component};
