import{s as bl,o as yl,n as Be}from"../chunks/scheduler.182ea377.js";import{S as Ml,i as _l,g as u,s as n,r,A as wl,h as g,f as l,c as o,j as Ye,u as f,x as y,k as Ne,y as T,a as t,v as d,d as p,t as c,w as m}from"../chunks/index.abf12888.js";import{T as Ni}from"../chunks/Tip.230e2334.js";import{D as Bi}from"../chunks/Docstring.81ce6c10.js";import{C as U}from"../chunks/CodeBlock.57fe6e13.js";import{E as hl}from"../chunks/ExampleCodeBlock.6db7157e.js";import{H as _,E as Jl}from"../chunks/EditOnGithub.9b8e78e4.js";function Tl($){let s,M="Most of the time you do not need to explicitly set a <code>config</code> argument. <code>from_single_file</code> will automatically map the checkpoint to the appropriate model repository. However, this option can be useful in cases where model components in the checkpoint might have been changed from what was originally distributed, or in cases where a checkpoint file might not have the necessary metadata to correctly determine the configuration to use for the pipeline.";return{c(){s=u("p"),s.innerHTML=M},l(a){s=g(a,"P",{"data-svelte-h":!0}),y(s)!=="svelte-1ocl3mu"&&(s.innerHTML=M)},m(a,b){t(a,s,b)},p:Be,d(a){a&&l(s)}}}function $l($){let s,M='To learn more about how to load single file weights, see the <a href="../../using-diffusers/other-formats">Load different Stable Diffusion formats</a> loading guide.';return{c(){s=u("p"),s.innerHTML=M},l(a){s=g(a,"P",{"data-svelte-h":!0}),y(s)!=="svelte-1d80t6b"&&(s.innerHTML=M)},m(a,b){t(a,s,b)},p:Be,d(a){a&&l(s)}}}function Ul($){let s,M="As of <code>huggingface_hub&gt;=0.23.0</code> the <code>local_dir_use_symlinks</code> argument isn’t necessary for the <code>hf_hub_download</code> and <code>snapshot_download</code> functions.";return{c(){s=u("p"),s.innerHTML=M},l(a){s=g(a,"P",{"data-svelte-h":!0}),y(s)!=="svelte-1wapj81"&&(s.innerHTML=M)},m(a,b){t(a,s,b)},p:Be,d(a){a&&l(s)}}}function Zl($){let s,M="When using <code>original_config</code> with <code>local_files_only=True</code>, Diffusers will attempt to infer the components of the pipeline based on the type signatures of pipeline class, rather than attempting to fetch the configuration files from a model repository on the Hugging Face Hub. This is to prevent backward breaking changes in existing code that might not be able to connect to the internet to fetch the necessary configuration files.",a,b,w="This is not as reliable as providing a path to a local model repository using the <code>config</code> argument and might lead to errors when configuring the pipeline. To avoid this, please run the pipeline with <code>local_files_only=False</code> once to download the appropriate pipeline configuration files to the local cache.";return{c(){s=u("p"),s.innerHTML=M,a=n(),b=u("p"),b.innerHTML=w},l(h){s=g(h,"P",{"data-svelte-h":!0}),y(s)!=="svelte-18lsa05"&&(s.innerHTML=M),a=o(h),b=g(h,"P",{"data-svelte-h":!0}),y(b)!=="svelte-jc8gvd"&&(b.innerHTML=w)},m(h,J){t(h,s,J),t(h,a,J),t(h,b,J)},p:Be,d(h){h&&(l(s),l(a),l(b))}}}function xl($){let s,M="Examples:",a,b,w;return b=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGV2Fycmlvck1hbWE3NzclMkZPcmFuZ2VNaXhzJTJGYmxvYiUyRm1haW4lMkZNb2RlbHMlMkZBYnlzc09yYW5nZU1peCUyRkFieXNzT3JhbmdlTWl4LnNhZmV0ZW5zb3JzJTIyJTBBKSUwQSUwQSUyMyUyMERvd25sb2FkJTIwcGlwZWxpbmUlMjBmcm9tJTIwbG9jYWwlMjBmaWxlJTBBJTIzJTIwZmlsZSUyMGlzJTIwZG93bmxvYWRlZCUyMHVuZGVyJTIwLiUyRnYxLTUtcHJ1bmVkLWVtYW9ubHkuY2twdCUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMjIuJTJGdjEtNS1wcnVuZWQtZW1hb25seS5ja3B0JTIyKSUwQSUwQSUyMyUyMEVuYWJsZSUyMGZsb2F0MTYlMjBhbmQlMjBtb3ZlJTIwdG8lMjBHUFUlMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fc2luZ2xlX2ZpbGUoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGYmxvYiUyRm1haW4lMkZ2MS01LXBydW5lZC1lbWFvbmx5LmNrcHQlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBcGlwZWxpbmUudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/WarriorMama777/OrangeMixs/blob/main/Models/AbyssOrangeMix/AbyssOrangeMix.safetensors&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from local file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># file is downloaded under ./v1-5-pruned-emaonly.ckpt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(<span class="hljs-string">&quot;./v1-5-pruned-emaonly.ckpt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Enable float16 and move to GPU</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/v1-5-pruned-emaonly.ckpt&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),{c(){s=u("p"),s.textContent=M,a=n(),r(b.$$.fragment)},l(h){s=g(h,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=M),a=o(h),f(b.$$.fragment,h)},m(h,J){t(h,s,J),t(h,a,J),d(b,h,J),w=!0},p:Be,i(h){w||(p(b.$$.fragment,h),w=!0)},o(h){c(b.$$.fragment,h),w=!1},d(h){h&&(l(s),l(a)),m(b,h)}}}function jl($){let s,M;return s=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZUNhc2NhZGVVTmV0JTBBJTBBY2twdF9wYXRoJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnN0YWJpbGl0eWFpJTJGc3RhYmxlLWNhc2NhZGUlMkZibG9iJTJGbWFpbiUyRnN0YWdlX2JfbGl0ZS5zYWZldGVuc29ycyUyMiUwQW1vZGVsJTIwJTNEJTIwU3RhYmxlQ2FzY2FkZVVOZXQuZnJvbV9zaW5nbGVfZmlsZShja3B0X3BhdGgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableCascadeUNet

<span class="hljs-meta">&gt;&gt;&gt; </span>ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-cascade/blob/main/stage_b_lite.safetensors&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = StableCascadeUNet.from_single_file(ckpt_path)`,wrap:!1}}),{c(){r(s.$$.fragment)},l(a){f(s.$$.fragment,a)},m(a,b){d(s,a,b),M=!0},p:Be,i(a){M||(p(s.$$.fragment,a),M=!0)},o(a){c(s.$$.fragment,a),M=!1},d(a){m(s,a)}}}function kl($){let s,M,a,b,w,h,J,qi="The <code>from_single_file</code> method allows you to load supported pipelines using a single checkpoint file as opposed to Diffusers’ multiple folders format. This is useful if you are working with Stable Diffusion Web UI’s (such as A1111) that rely on a single file format to distribute all the components of a model.",Xe,C,Qi="The <code>from_single_file</code> method also supports loading models in their originally distributed format. This means that supported models that have been finetuned with other services can be loaded directly into Diffusers model objects and pipelines.",Le,X,He,L,zi='<li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline">StableDiffusionImg2ImgPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline">StableDiffusionInpaintPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetImg2ImgPipeline">StableDiffusionControlNetImg2ImgPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetInpaintPipeline">StableDiffusionControlNetInpaintPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/upscale#diffusers.StableDiffusionUpscalePipeline">StableDiffusionUpscalePipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLImg2ImgPipeline">StableDiffusionXLImg2ImgPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLInpaintPipeline">StableDiffusionXLInpaintPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/pix2pix#diffusers.StableDiffusionXLInstructPix2PixPipeline">StableDiffusionXLInstructPix2PixPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/controlnet_sdxl#diffusers.StableDiffusionXLControlNetPipeline">StableDiffusionXLControlNetPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/k_diffusion#diffusers.StableDiffusionXLKDiffusionPipeline">StableDiffusionXLKDiffusionPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/latent_consistency_models#diffusers.LatentConsistencyModelPipeline">LatentConsistencyModelPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/latent_consistency_models#diffusers.LatentConsistencyModelImg2ImgPipeline">LatentConsistencyModelImg2ImgPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/controlnetxs#diffusers.StableDiffusionControlNetXSPipeline">StableDiffusionControlNetXSPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/controlnetxs_sdxl#diffusers.StableDiffusionXLControlNetXSPipeline">StableDiffusionXLControlNetXSPipeline</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/ledits_pp#diffusers.LEditsPPPipelineStableDiffusion">LEditsPPPipelineStableDiffusion</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/ledits_pp#diffusers.LEditsPPPipelineStableDiffusionXL">LEditsPPPipelineStableDiffusionXL</a></li> <li><a href="/docs/diffusers/main/en/api/pipelines/pia#diffusers.PIAPipeline">PIAPipeline</a></li>',Ve,H,Ee,V,Ai='<li><a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a></li> <li><code>StableCascadeUNet</code></li> <li><a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a></li> <li><a href="/docs/diffusers/main/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a></li>',Pe,E,De,P,qe,D,Qe,q,ze,Q,Oi="Set components of a pipeline by passing them directly to the <code>from_single_file</code> method. For example, here we are swapping out the pipeline’s default scheduler with the <code>DDIMScheduler</code>.",Ae,z,Oe,A,Ki="Here we are passing in a ControlNet model to the <code>StableDiffusionControlNetPipeline</code>.",Ke,O,ei,K,ii,ee,li,ie,ti,le,el="Under the hood, <code>from_single_file</code> will try to automatically determine a model repository to use to configure the components of a pipeline. You can also explicitly set the model repository to configure the pipeline with the <code>config</code> argument.",ni,te,oi,ne,il='In the example above, since we explicitly passed <code>repo_id=&quot;segmind/SSD-1B&quot;</code> to the <code>config</code> argument, it will use this <a href="https://huggingface.co/segmind/SSD-1B/blob/main/unet/config.json" rel="nofollow">configuration file</a> from the <code>unet</code> subfolder in <code>&quot;segmind/SSD-1B&quot;</code> to configure the <code>unet</code> component of the pipeline; Similarly, it will use the <code>config.json</code> file from <code>vae</code> subfolder to configure the <code>vae</code> model, <code>config.json</code> file from <code>text_encoder</code> folder to configure <code>text_encoder</code> and so on.',si,F,ai,oe,ri,se,ll="Override the default model or pipeline configuration options by providing the relevant arguments directly to the <code>from_single_file</code> method. Any argument supported by the model or pipeline class can be configured in this way:",fi,ae,di,re,pi,fe,ci,de,mi,I,ui,pe,gi,ce,tl="As of <code>diffusers&gt;=0.28.0</code> the <code>from_single_file</code> method will attempt to configure a pipeline or model by first inferring the model type from the keys in the checkpoint file. This inferred model type is then used to determine the appropriate model repository on the Hugging Face Hub to configure the model or pipeline.",hi,me,nl='For example, any single file checkpoint based on the Stable Diffusion XL base model will use the <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow"><code>stabilityai/stable-diffusion-xl-base-1.0</code></a> model repository to configure the pipeline.',bi,ue,ol="If you are working in an environment with restricted internet access, it is recommended that you download the config files and checkpoints for the model to your preferred directory and pass the local paths to the <code>pretrained_model_link_or_path</code> and <code>config</code> arguments of the <code>from_single_file</code> method.",yi,ge,Mi,he,sl='By default this will download the checkpoints and config files to the <a href="https://huggingface.co/docs/huggingface_hub/en/guides/manage-cache" rel="nofollow">Hugging Face Hub cache directory</a>. You can also specify a local directory to download the files to by passing the <code>local_dir</code> argument to the <code>hf_hub_download</code> and <code>snapshot_download</code> functions.',_i,be,wi,ye,Ji,Me,al="By default the <code>from_single_file</code> method relies on the <code>huggingface_hub</code> caching mechanism to fetch and store checkpoints and config files for models and pipelines. If you are working with a file system that does not support symlinking, it is recommended that you first download the checkpoint file to a local directory and disable symlinking by passing the <code>local_dir_use_symlink=False</code> argument to the <code>hf_hub_download</code> and <code>snapshot_download</code> functions.",Ti,_e,$i,we,rl="Then pass the local paths to the <code>pretrained_model_link_or_path</code> and <code>config</code> arguments of the <code>from_single_file</code> method.",Ui,Je,Zi,R,xi,Te,ji,$e,fl="If you would like to configure the model components in a pipeline using the orignal YAML configuration file, you can pass a local path or url to the original configuration file via the <code>original_config</code> argument.",ki,Ue,Gi,Y,vi,Ze,Wi,Z,xe,Ci,Se,dl='Load model weights saved in the <code>.ckpt</code> format into a <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>.',Xi,j,je,Li,Fe,pl=`Instantiate a <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> from pretrained pipeline weights saved in the <code>.ckpt</code> or <code>.safetensors</code>
format. The pipeline is set in evaluation mode (<code>model.eval()</code>) by default.`,Hi,N,Si,ke,Fi,x,Ge,Vi,Ie,cl="Load pretrained weights saved in the <code>.ckpt</code> or <code>.safetensors</code> format into a model.",Ei,k,ve,Pi,Re,ml=`Instantiate a model from pretrained weights saved in the original <code>.ckpt</code> or <code>.safetensors</code> format. The model
is set in evaluation mode (<code>model.eval()</code>) by default.`,Di,B,Ii,We,Ri,Ce,Yi;return w=new _({props:{title:"Loading Pipelines and Models via from_single_file",local:"loading-pipelines-and-models-via-fromsinglefile",headingTag:"h1"}}),X=new _({props:{title:"Pipelines that currently support from_single_file loading",local:"pipelines-that-currently-support-fromsinglefile-loading",headingTag:"h2"}}),H=new _({props:{title:"Models that currently support from_single_file loading",local:"models-that-currently-support-fromsinglefile-loading",headingTag:"h2"}}),E=new _({props:{title:"Usage Examples",local:"usage-examples",headingTag:"h2"}}),P=new _({props:{title:"Loading a Pipeline using from_single_file",local:"loading-a-pipeline-using-fromsinglefile",headingTag:"h2"}}),D=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEElMEFja3B0X3BhdGglMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTJGYmxvYiUyRm1haW4lMkZzZF94bF9iYXNlXzEuMF8wLjl2YWUuc2FmZXRlbnNvcnMlMjIlMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKGNrcHRfcGF0aCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0/blob/main/sd_xl_base_1.0_0.9vae.safetensors&quot;</span>
pipe = StableDiffusionXLPipeline.from_single_file(ckpt_path)`,wrap:!1}}),q=new _({props:{title:"Setting components in a Pipeline using from_single_file",local:"setting-components-in-a-pipeline-using-fromsinglefile",headingTag:"h2"}}),z=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMkMlMjBERElNU2NoZWR1bGVyJTBBJTBBY2twdF9wYXRoJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyRmJsb2IlMkZtYWluJTJGc2RfeGxfYmFzZV8xLjBfMC45dmFlLnNhZmV0ZW5zb3JzJTIyJTBBJTBBc2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlcigpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZShja3B0X3BhdGglMkMlMjBzY2hlZHVsZXIlM0RzY2hlZHVsZXIpJTBB",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline, DDIMScheduler

ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0/blob/main/sd_xl_base_1.0_0.9vae.safetensors&quot;</span>

scheduler = DDIMScheduler()
pipe = StableDiffusionXLPipeline.from_single_file(ckpt_path, scheduler=scheduler)
`,wrap:!1}}),O=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZSUyQyUyMENvbnRyb2xOZXRNb2RlbCUwQSUwQWNrcHRfcGF0aCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRmJsb2IlMkZtYWluJTJGdjEtNS1wcnVuZWQtZW1hb25seS5zYWZldGVuc29ycyUyMiUwQSUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmxsbHlhc3ZpZWwlMkZjb250cm9sX3YxMXBfc2QxNV9jYW5ueSUyMiklMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldFBpcGVsaW5lLmZyb21fc2luZ2xlX2ZpbGUoY2twdF9wYXRoJTJDJTIwY29udHJvbG5ldCUzRGNvbnRyb2xuZXQpJTBB",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel

ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/v1-5-pruned-emaonly.safetensors&quot;</span>

controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/control_v11p_sd15_canny&quot;</span>)
pipe = StableDiffusionControlNetPipeline.from_single_file(ckpt_path, controlnet=controlnet)
`,wrap:!1}}),K=new _({props:{title:"Loading a Model using from_single_file",local:"loading-a-model-using-fromsinglefile",headingTag:"h2"}}),ee=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZUNhc2NhZGVVTmV0JTBBJTBBY2twdF9wYXRoJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnN0YWJpbGl0eWFpJTJGc3RhYmxlLWNhc2NhZGUlMkZibG9iJTJGbWFpbiUyRnN0YWdlX2JfbGl0ZS5zYWZldGVuc29ycyUyMiUwQW1vZGVsJTIwJTNEJTIwU3RhYmxlQ2FzY2FkZVVOZXQuZnJvbV9zaW5nbGVfZmlsZShja3B0X3BhdGgpJTBB",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableCascadeUNet

ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-cascade/blob/main/stage_b_lite.safetensors&quot;</span>
model = StableCascadeUNet.from_single_file(ckpt_path)
`,wrap:!1}}),ie=new _({props:{title:"Using a Diffusers model repository to configure single file loading",local:"using-a-diffusers-model-repository-to-configure-single-file-loading",headingTag:"h2"}}),te=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEElMEFja3B0X3BhdGglMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc2VnbWluZCUyRlNTRC0xQiUyRmJsb2IlMkZtYWluJTJGU1NELTFCLnNhZmV0ZW5zb3JzJTIyJTBBcmVwb19pZCUyMCUzRCUyMCUyMnNlZ21pbmQlMkZTU0QtMUIlMjIlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKGNrcHRfcGF0aCUyQyUyMGNvbmZpZyUzRHJlcG9faWQpJTBB",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/segmind/SSD-1B/blob/main/SSD-1B.safetensors&quot;</span>
repo_id = <span class="hljs-string">&quot;segmind/SSD-1B&quot;</span>

pipe = StableDiffusionXLPipeline.from_single_file(ckpt_path, config=repo_id)
`,wrap:!1}}),F=new Ni({props:{$$slots:{default:[Tl]},$$scope:{ctx:$}}}),oe=new _({props:{title:"Override configuration options when using single file loading",local:"override-configuration-options-when-using-single-file-loading",headingTag:"h2"}}),ae=new _({props:{title:"Setting a pipeline configuration option",local:"setting-a-pipeline-configuration-option",headingTag:"h3"}}),re=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMSW5zdHJ1Y3RQaXgyUGl4UGlwZWxpbmUlMEElMEFja3B0X3BhdGglMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3RhYmlsaXR5YWklMkZjb3N4bCUyRmJsb2IlMkZtYWluJTJGY29zeGxfZWRpdC5zYWZldGVuc29ycyUyMiUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTEluc3RydWN0UGl4MlBpeFBpcGVsaW5lLmZyb21fc2luZ2xlX2ZpbGUoY2twdF9wYXRoJTJDJTIwY29uZmlnJTNEJTIyZGlmZnVzZXJzJTJGc2R4bC1pbnN0cnVjdHBpeDJwaXgtNzY4JTIyJTJDJTIwaXNfY29zeGxfZWRpdCUzRFRydWUpJTBB",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLInstructPix2PixPipeline

ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/stabilityai/cosxl/blob/main/cosxl_edit.safetensors&quot;</span>
pipe = StableDiffusionXLInstructPix2PixPipeline.from_single_file(ckpt_path, config=<span class="hljs-string">&quot;diffusers/sdxl-instructpix2pix-768&quot;</span>, is_cosxl_edit=<span class="hljs-literal">True</span>)
`,wrap:!1}}),fe=new _({props:{title:"Setting a model configuration option",local:"setting-a-model-configuration-option",headingTag:"h3"}}),de=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBY2twdF9wYXRoJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyRmJsb2IlMkZtYWluJTJGc2RfeGxfYmFzZV8xLjBfMC45dmFlLnNhZmV0ZW5zb3JzJTIyJTBBbW9kZWwlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3NpbmdsZV9maWxlKGNrcHRfcGF0aCUyQyUyMHVwY2FzdF9hdHRlbnRpb24lM0RUcnVlKSUwQQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0/blob/main/sd_xl_base_1.0_0.9vae.safetensors&quot;</span>
model = UNet2DConditionModel.from_single_file(ckpt_path, upcast_attention=<span class="hljs-literal">True</span>)
`,wrap:!1}}),I=new Ni({props:{$$slots:{default:[$l]},$$scope:{ctx:$}}}),pe=new _({props:{title:"Working with local files",local:"working-with-local-files",headingTag:"h2"}}),ge=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUyQyUyMHNuYXBzaG90X2Rvd25sb2FkJTBBJTBBbXlfbG9jYWxfY2hlY2twb2ludF9wYXRoJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJzZWdtaW5kJTJGU1NELTFCJTIyJTJDJTBBJTIwJTIwJTIwJTIwZmlsZW5hbWUlM0QlMjJTU0QtMUIuc2FmZXRlbnNvcnMlMjIlMEEpJTBBJTBBbXlfbG9jYWxfY29uZmlnX3BhdGglMjAlM0QlMjBzbmFwc2hvdF9kb3dubG9hZCglMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIyc2VnbWluZCUyRlNTRC0xQiUyMiUyQyUwQSUyMCUyMCUyMCUyMGFsbG93ZWRfcGF0dGVybnMlM0QlNUIlMjIqLmpzb24lMjIlMkMlMjAlMjIqKiUyRiouanNvbiUyMiUyQyUyMCUyMioudHh0JTIyJTJDJTIwJTIyKiolMkYqLnR4dCUyMiU1RCUwQSklMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKG15X2xvY2FsX2NoZWNrcG9pbnRfcGF0aCUyQyUyMGNvbmZpZyUzRG15X2xvY2FsX2NvbmZpZ19wYXRoJTJDJTIwbG9jYWxfZmlsZXNfb25seSUzRFRydWUpJTBB",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download, snapshot_download

my_local_checkpoint_path = hf_hub_download(
    repo_id=<span class="hljs-string">&quot;segmind/SSD-1B&quot;</span>,
    filename=<span class="hljs-string">&quot;SSD-1B.safetensors&quot;</span>
)

my_local_config_path = snapshot_download(
    repo_id=<span class="hljs-string">&quot;segmind/SSD-1B&quot;</span>,
    allowed_patterns=[<span class="hljs-string">&quot;*.json&quot;</span>, <span class="hljs-string">&quot;**/*.json&quot;</span>, <span class="hljs-string">&quot;*.txt&quot;</span>, <span class="hljs-string">&quot;**/*.txt&quot;</span>]
)

pipe = StableDiffusionXLPipeline.from_single_file(my_local_checkpoint_path, config=my_local_config_path, local_files_only=<span class="hljs-literal">True</span>)
`,wrap:!1}}),be=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUyQyUyMHNuYXBzaG90X2Rvd25sb2FkJTBBJTBBbXlfbG9jYWxfY2hlY2twb2ludF9wYXRoJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJzZWdtaW5kJTJGU1NELTFCJTIyJTJDJTBBJTIwJTIwJTIwJTIwZmlsZW5hbWUlM0QlMjJTU0QtMUIuc2FmZXRlbnNvcnMlMjIlMEElMjAlMjAlMjAlMjBsb2NhbF9kaXIlM0QlMjJteV9sb2NhbF9jaGVja3BvaW50cyUyMiUwQSklMEElMEFteV9sb2NhbF9jb25maWdfcGF0aCUyMCUzRCUyMHNuYXBzaG90X2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJzZWdtaW5kJTJGU1NELTFCJTIyJTJDJTBBJTIwJTIwJTIwJTIwYWxsb3dlZF9wYXR0ZXJucyUzRCU1QiUyMiouanNvbiUyMiUyQyUyMCUyMioqJTJGKi5qc29uJTIyJTJDJTIwJTIyKi50eHQlMjIlMkMlMjAlMjIqKiUyRioudHh0JTIyJTVEJTBBJTIwJTIwJTIwJTIwbG9jYWxfZGlyJTNEJTIybXlfbG9jYWxfY29uZmlnJTIyJTBBKSUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fc2luZ2xlX2ZpbGUobXlfbG9jYWxfY2hlY2twb2ludF9wYXRoJTJDJTIwY29uZmlnJTNEbXlfbG9jYWxfY29uZmlnX3BhdGglMkMlMjBsb2NhbF9maWxlc19vbmx5JTNEVHJ1ZSklMEE=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download, snapshot_download

my_local_checkpoint_path = hf_hub_download(
    repo_id=<span class="hljs-string">&quot;segmind/SSD-1B&quot;</span>,
    filename=<span class="hljs-string">&quot;SSD-1B.safetensors&quot;</span>
    local_dir=<span class="hljs-string">&quot;my_local_checkpoints&quot;</span>
)

my_local_config_path = snapshot_download(
    repo_id=<span class="hljs-string">&quot;segmind/SSD-1B&quot;</span>,
    allowed_patterns=[<span class="hljs-string">&quot;*.json&quot;</span>, <span class="hljs-string">&quot;**/*.json&quot;</span>, <span class="hljs-string">&quot;*.txt&quot;</span>, <span class="hljs-string">&quot;**/*.txt&quot;</span>]
    local_dir=<span class="hljs-string">&quot;my_local_config&quot;</span>
)

pipe = StableDiffusionXLPipeline.from_single_file(my_local_checkpoint_path, config=my_local_config_path, local_files_only=<span class="hljs-literal">True</span>)
`,wrap:!1}}),ye=new _({props:{title:"Working with local files on file systems that do not support symlinking",local:"working-with-local-files-on-file-systems-that-do-not-support-symlinking",headingTag:"h2"}}),_e=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUyQyUyMHNuYXBzaG90X2Rvd25sb2FkJTBBJTBBbXlfbG9jYWxfY2hlY2twb2ludF9wYXRoJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJzZWdtaW5kJTJGU1NELTFCJTIyJTJDJTBBJTIwJTIwJTIwJTIwZmlsZW5hbWUlM0QlMjJTU0QtMUIuc2FmZXRlbnNvcnMlMjIlMEElMjAlMjAlMjAlMjBsb2NhbF9kaXIlM0QlMjJteV9sb2NhbF9jaGVja3BvaW50cyUyMiUyQyUwQSUyMCUyMCUyMCUyMGxvY2FsX2Rpcl91c2Vfc3ltbGlua3MlM0RGYWxzZSUwQSklMEFwcmludCglMjJNeSUyMGxvY2FsJTIwY2hlY2twb2ludCUzQSUyMCUyMiUyQyUyMG15X2xvY2FsX2NoZWNrcG9pbnRfcGF0aCklMEElMEFteV9sb2NhbF9jb25maWdfcGF0aCUyMCUzRCUyMHNuYXBzaG90X2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJzZWdtaW5kJTJGU1NELTFCJTIyJTJDJTBBJTIwJTIwJTIwJTIwYWxsb3dlZF9wYXR0ZXJucyUzRCU1QiUyMiouanNvbiUyMiUyQyUyMCUyMioqJTJGKi5qc29uJTIyJTJDJTIwJTIyKi50eHQlMjIlMkMlMjAlMjIqKiUyRioudHh0JTIyJTVEJTBBJTIwJTIwJTIwJTIwbG9jYWxfZGlyX3VzZV9zeW1saW5rcyUzREZhbHNlJTJDJTBBKSUwQXByaW50KCUyMk15JTIwbG9jYWwlMjBjb25maWclM0ElMjAlMjIlMkMlMjBteV9sb2NhbF9jb25maWdfcGF0aCklMEE=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download, snapshot_download

my_local_checkpoint_path = hf_hub_download(
    repo_id=<span class="hljs-string">&quot;segmind/SSD-1B&quot;</span>,
    filename=<span class="hljs-string">&quot;SSD-1B.safetensors&quot;</span>
    local_dir=<span class="hljs-string">&quot;my_local_checkpoints&quot;</span>,
    local_dir_use_symlinks=<span class="hljs-literal">False</span>
)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;My local checkpoint: &quot;</span>, my_local_checkpoint_path)

my_local_config_path = snapshot_download(
    repo_id=<span class="hljs-string">&quot;segmind/SSD-1B&quot;</span>,
    allowed_patterns=[<span class="hljs-string">&quot;*.json&quot;</span>, <span class="hljs-string">&quot;**/*.json&quot;</span>, <span class="hljs-string">&quot;*.txt&quot;</span>, <span class="hljs-string">&quot;**/*.txt&quot;</span>]
    local_dir_use_symlinks=<span class="hljs-literal">False</span>,
)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;My local config: &quot;</span>, my_local_config_path)
`,wrap:!1}}),Je=new U({props:{code:"cGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZShteV9sb2NhbF9jaGVja3BvaW50X3BhdGglMkMlMjBjb25maWclM0RteV9sb2NhbF9jb25maWdfcGF0aCUyQyUyMGxvY2FsX2ZpbGVzX29ubHklM0RUcnVlKSUwQQ==",highlighted:`pipe = StableDiffusionXLPipeline.from_single_file(my_local_checkpoint_path, config=my_local_config_path, local_files_only=<span class="hljs-literal">True</span>)
`,wrap:!1}}),R=new Ni({props:{$$slots:{default:[Ul]},$$scope:{ctx:$}}}),Te=new _({props:{title:"Using the original configuration file of a model",local:"using-the-original-configuration-file-of-a-model",headingTag:"h2"}}),Ue=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEElMEFja3B0X3BhdGglMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTJGYmxvYiUyRm1haW4lMkZzZF94bF9iYXNlXzEuMF8wLjl2YWUuc2FmZXRlbnNvcnMlMjIlMEFyZXBvX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTBBb3JpZ2luYWxfY29uZmlnJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGU3RhYmlsaXR5LUFJJTJGZ2VuZXJhdGl2ZS1tb2RlbHMlMkZtYWluJTJGY29uZmlncyUyRmluZmVyZW5jZSUyRnNkX3hsX2Jhc2UueWFtbCUyMiUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fc2luZ2xlX2ZpbGUoY2twdF9wYXRoJTJDJTIwb3JpZ2luYWxfY29uZmlnJTNEb3JpZ2luYWxfY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0/blob/main/sd_xl_base_1.0_0.9vae.safetensors&quot;</span>
repo_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
original_config = <span class="hljs-string">&quot;https://raw.githubusercontent.com/Stability-AI/generative-models/main/configs/inference/sd_xl_base.yaml&quot;</span>

pipe = StableDiffusionXLPipeline.from_single_file(ckpt_path, original_config=original_config)`,wrap:!1}}),Y=new Ni({props:{$$slots:{default:[Zl]},$$scope:{ctx:$}}}),Ze=new _({props:{title:"FromSingleFileMixin",local:"diffusers.loaders.FromSingleFileMixin",headingTag:"h2"}}),xe=new Bi({props:{name:"class diffusers.loaders.FromSingleFileMixin",anchor:"diffusers.loaders.FromSingleFileMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/single_file.py#L253"}}),je=new Bi({props:{name:"from_single_file",anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file",parameters:[{name:"pretrained_model_link_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.pretrained_model_link_or_path",description:`<strong>pretrained_model_link_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:<ul>
<li>A link to the <code>.ckpt</code> file (for example
<code>&quot;https://huggingface.co/&lt;repo_id&gt;/blob/main/&lt;path_to_file&gt;.ckpt&quot;</code>) on the Hub.</li>
<li>A path to a <em>file</em> containing all pipeline weights.</li>
</ul>`,name:"pretrained_model_link_or_path"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype.`,name:"torch_dtype"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.
resume_download &#x2014;
Deprecated and ignored. All downloads are now resumed by default when possible. Will be removed in v1
of Diffusers.`,name:"cache_dir"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.original_config_file",description:`<strong>original_config_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The path to the original config file that was used to train the model. If not provided, the config file
will be inferred from the checkpoint file.`,name:"original_config_file"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.config",description:`<strong>config</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Can be either:<ul>
<li>A string, the <em>repo id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained pipeline
hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_pipeline_directory/</code>) containing the pipeline
component configs in Diffusers format.</li>
</ul>`,name:"config"},{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (the pipeline components of the specific pipeline
class). The overwritten components are passed directly to the pipelines <code>__init__</code> method. See example
below for more information.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/single_file.py#L258"}}),N=new hl({props:{anchor:"diffusers.loaders.FromSingleFileMixin.from_single_file.example",$$slots:{default:[xl]},$$scope:{ctx:$}}}),ke=new _({props:{title:"FromOriginalModelMixin",local:"diffusers.loaders.FromOriginalModelMixin",headingTag:"h2"}}),Ge=new Bi({props:{name:"class diffusers.loaders.FromOriginalModelMixin",anchor:"diffusers.loaders.FromOriginalModelMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/single_file_model.py#L81"}}),ve=new Bi({props:{name:"from_single_file",anchor:"diffusers.loaders.FromOriginalModelMixin.from_single_file",parameters:[{name:"pretrained_model_link_or_path_or_dict",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.loaders.FromOriginalModelMixin.from_single_file.pretrained_model_link_or_path_or_dict",description:`<strong>pretrained_model_link_or_path_or_dict</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Can be either:<ul>
<li>A link to the <code>.safetensors</code> or <code>.ckpt</code> file (for example
<code>&quot;https://huggingface.co/&lt;repo_id&gt;/blob/main/&lt;path_to_file&gt;.safetensors&quot;</code>) on the Hub.</li>
<li>A path to a local <em>file</em> containing the weights of the component model.</li>
<li>A state dict containing the component model weights.</li>
</ul>`,name:"pretrained_model_link_or_path_or_dict"},{anchor:"diffusers.loaders.FromOriginalModelMixin.from_single_file.config",description:`<strong>config</strong> (<code>str</code>, <em>optional</em>) &#x2014;<ul>
<li>A string, the <em>repo id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained pipeline hosted
on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_pipeline_directory/</code>) containing the pipeline component
configs in Diffusers format.</li>
</ul>`,name:"config"},{anchor:"diffusers.loaders.FromOriginalModelMixin.from_single_file.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.loaders.FromOriginalModelMixin.from_single_file.original_config",description:`<strong>original_config</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Dict or path to a yaml file containing the configuration for the model in its original format.
If a dict is provided, it will be used to initialize the model configuration.`,name:"original_config"},{anchor:"diffusers.loaders.FromOriginalModelMixin.from_single_file.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. If <code>&quot;auto&quot;</code> is passed, the
dtype is automatically derived from the model&#x2019;s weights.`,name:"torch_dtype"},{anchor:"diffusers.loaders.FromOriginalModelMixin.from_single_file.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.loaders.FromOriginalModelMixin.from_single_file.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.loaders.FromOriginalModelMixin.from_single_file.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.loaders.FromOriginalModelMixin.from_single_file.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.loaders.FromOriginalModelMixin.from_single_file.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to True, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.loaders.FromOriginalModelMixin.from_single_file.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.loaders.FromOriginalModelMixin.from_single_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.loaders.FromOriginalModelMixin.from_single_file.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (for example the pipeline components of the
specific pipeline class). The overwritten components are directly passed to the pipelines <code>__init__</code>
method. See example below for more information.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/single_file_model.py#L86"}}),B=new hl({props:{anchor:"diffusers.loaders.FromOriginalModelMixin.from_single_file.example",$$slots:{default:[jl]},$$scope:{ctx:$}}}),We=new Jl({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/loaders/single_file.md"}}),{c(){s=u("meta"),M=n(),a=u("p"),b=n(),r(w.$$.fragment),h=n(),J=u("p"),J.innerHTML=qi,Xe=n(),C=u("p"),C.innerHTML=Qi,Le=n(),r(X.$$.fragment),He=n(),L=u("ul"),L.innerHTML=zi,Ve=n(),r(H.$$.fragment),Ee=n(),V=u("ul"),V.innerHTML=Ai,Pe=n(),r(E.$$.fragment),De=n(),r(P.$$.fragment),qe=n(),r(D.$$.fragment),Qe=n(),r(q.$$.fragment),ze=n(),Q=u("p"),Q.innerHTML=Oi,Ae=n(),r(z.$$.fragment),Oe=n(),A=u("p"),A.innerHTML=Ki,Ke=n(),r(O.$$.fragment),ei=n(),r(K.$$.fragment),ii=n(),r(ee.$$.fragment),li=n(),r(ie.$$.fragment),ti=n(),le=u("p"),le.innerHTML=el,ni=n(),r(te.$$.fragment),oi=n(),ne=u("p"),ne.innerHTML=il,si=n(),r(F.$$.fragment),ai=n(),r(oe.$$.fragment),ri=n(),se=u("p"),se.innerHTML=ll,fi=n(),r(ae.$$.fragment),di=n(),r(re.$$.fragment),pi=n(),r(fe.$$.fragment),ci=n(),r(de.$$.fragment),mi=n(),r(I.$$.fragment),ui=n(),r(pe.$$.fragment),gi=n(),ce=u("p"),ce.innerHTML=tl,hi=n(),me=u("p"),me.innerHTML=nl,bi=n(),ue=u("p"),ue.innerHTML=ol,yi=n(),r(ge.$$.fragment),Mi=n(),he=u("p"),he.innerHTML=sl,_i=n(),r(be.$$.fragment),wi=n(),r(ye.$$.fragment),Ji=n(),Me=u("p"),Me.innerHTML=al,Ti=n(),r(_e.$$.fragment),$i=n(),we=u("p"),we.innerHTML=rl,Ui=n(),r(Je.$$.fragment),Zi=n(),r(R.$$.fragment),xi=n(),r(Te.$$.fragment),ji=n(),$e=u("p"),$e.innerHTML=fl,ki=n(),r(Ue.$$.fragment),Gi=n(),r(Y.$$.fragment),vi=n(),r(Ze.$$.fragment),Wi=n(),Z=u("div"),r(xe.$$.fragment),Ci=n(),Se=u("p"),Se.innerHTML=dl,Xi=n(),j=u("div"),r(je.$$.fragment),Li=n(),Fe=u("p"),Fe.innerHTML=pl,Hi=n(),r(N.$$.fragment),Si=n(),r(ke.$$.fragment),Fi=n(),x=u("div"),r(Ge.$$.fragment),Vi=n(),Ie=u("p"),Ie.innerHTML=cl,Ei=n(),k=u("div"),r(ve.$$.fragment),Pi=n(),Re=u("p"),Re.innerHTML=ml,Di=n(),r(B.$$.fragment),Ii=n(),r(We.$$.fragment),Ri=n(),Ce=u("p"),this.h()},l(e){const i=wl("svelte-u9bgzb",document.head);s=g(i,"META",{name:!0,content:!0}),i.forEach(l),M=o(e),a=g(e,"P",{}),Ye(a).forEach(l),b=o(e),f(w.$$.fragment,e),h=o(e),J=g(e,"P",{"data-svelte-h":!0}),y(J)!=="svelte-1j698ul"&&(J.innerHTML=qi),Xe=o(e),C=g(e,"P",{"data-svelte-h":!0}),y(C)!=="svelte-1ukmajh"&&(C.innerHTML=Qi),Le=o(e),f(X.$$.fragment,e),He=o(e),L=g(e,"UL",{"data-svelte-h":!0}),y(L)!=="svelte-1wsech9"&&(L.innerHTML=zi),Ve=o(e),f(H.$$.fragment,e),Ee=o(e),V=g(e,"UL",{"data-svelte-h":!0}),y(V)!=="svelte-1sr1e43"&&(V.innerHTML=Ai),Pe=o(e),f(E.$$.fragment,e),De=o(e),f(P.$$.fragment,e),qe=o(e),f(D.$$.fragment,e),Qe=o(e),f(q.$$.fragment,e),ze=o(e),Q=g(e,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-1di86uw"&&(Q.innerHTML=Oi),Ae=o(e),f(z.$$.fragment,e),Oe=o(e),A=g(e,"P",{"data-svelte-h":!0}),y(A)!=="svelte-lirgmp"&&(A.innerHTML=Ki),Ke=o(e),f(O.$$.fragment,e),ei=o(e),f(K.$$.fragment,e),ii=o(e),f(ee.$$.fragment,e),li=o(e),f(ie.$$.fragment,e),ti=o(e),le=g(e,"P",{"data-svelte-h":!0}),y(le)!=="svelte-8zwqii"&&(le.innerHTML=el),ni=o(e),f(te.$$.fragment,e),oi=o(e),ne=g(e,"P",{"data-svelte-h":!0}),y(ne)!=="svelte-1xr1std"&&(ne.innerHTML=il),si=o(e),f(F.$$.fragment,e),ai=o(e),f(oe.$$.fragment,e),ri=o(e),se=g(e,"P",{"data-svelte-h":!0}),y(se)!=="svelte-t4x39f"&&(se.innerHTML=ll),fi=o(e),f(ae.$$.fragment,e),di=o(e),f(re.$$.fragment,e),pi=o(e),f(fe.$$.fragment,e),ci=o(e),f(de.$$.fragment,e),mi=o(e),f(I.$$.fragment,e),ui=o(e),f(pe.$$.fragment,e),gi=o(e),ce=g(e,"P",{"data-svelte-h":!0}),y(ce)!=="svelte-1kkis7a"&&(ce.innerHTML=tl),hi=o(e),me=g(e,"P",{"data-svelte-h":!0}),y(me)!=="svelte-1w7qzn"&&(me.innerHTML=nl),bi=o(e),ue=g(e,"P",{"data-svelte-h":!0}),y(ue)!=="svelte-t49x7j"&&(ue.innerHTML=ol),yi=o(e),f(ge.$$.fragment,e),Mi=o(e),he=g(e,"P",{"data-svelte-h":!0}),y(he)!=="svelte-delnnw"&&(he.innerHTML=sl),_i=o(e),f(be.$$.fragment,e),wi=o(e),f(ye.$$.fragment,e),Ji=o(e),Me=g(e,"P",{"data-svelte-h":!0}),y(Me)!=="svelte-1nvseog"&&(Me.innerHTML=al),Ti=o(e),f(_e.$$.fragment,e),$i=o(e),we=g(e,"P",{"data-svelte-h":!0}),y(we)!=="svelte-1wi9kuq"&&(we.innerHTML=rl),Ui=o(e),f(Je.$$.fragment,e),Zi=o(e),f(R.$$.fragment,e),xi=o(e),f(Te.$$.fragment,e),ji=o(e),$e=g(e,"P",{"data-svelte-h":!0}),y($e)!=="svelte-ld5js"&&($e.innerHTML=fl),ki=o(e),f(Ue.$$.fragment,e),Gi=o(e),f(Y.$$.fragment,e),vi=o(e),f(Ze.$$.fragment,e),Wi=o(e),Z=g(e,"DIV",{class:!0});var G=Ye(Z);f(xe.$$.fragment,G),Ci=o(G),Se=g(G,"P",{"data-svelte-h":!0}),y(Se)!=="svelte-11v9qjy"&&(Se.innerHTML=dl),Xi=o(G),j=g(G,"DIV",{class:!0});var v=Ye(j);f(je.$$.fragment,v),Li=o(v),Fe=g(v,"P",{"data-svelte-h":!0}),y(Fe)!=="svelte-pmqrln"&&(Fe.innerHTML=pl),Hi=o(v),f(N.$$.fragment,v),v.forEach(l),G.forEach(l),Si=o(e),f(ke.$$.fragment,e),Fi=o(e),x=g(e,"DIV",{class:!0});var W=Ye(x);f(Ge.$$.fragment,W),Vi=o(W),Ie=g(W,"P",{"data-svelte-h":!0}),y(Ie)!=="svelte-1angwv3"&&(Ie.innerHTML=cl),Ei=o(W),k=g(W,"DIV",{class:!0});var S=Ye(k);f(ve.$$.fragment,S),Pi=o(S),Re=g(S,"P",{"data-svelte-h":!0}),y(Re)!=="svelte-vw4n4o"&&(Re.innerHTML=ml),Di=o(S),f(B.$$.fragment,S),S.forEach(l),W.forEach(l),Ii=o(e),f(We.$$.fragment,e),Ri=o(e),Ce=g(e,"P",{}),Ye(Ce).forEach(l),this.h()},h(){Ne(s,"name","hf:doc:metadata"),Ne(s,"content",Gl),Ne(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Ne(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Ne(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Ne(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){T(document.head,s),t(e,M,i),t(e,a,i),t(e,b,i),d(w,e,i),t(e,h,i),t(e,J,i),t(e,Xe,i),t(e,C,i),t(e,Le,i),d(X,e,i),t(e,He,i),t(e,L,i),t(e,Ve,i),d(H,e,i),t(e,Ee,i),t(e,V,i),t(e,Pe,i),d(E,e,i),t(e,De,i),d(P,e,i),t(e,qe,i),d(D,e,i),t(e,Qe,i),d(q,e,i),t(e,ze,i),t(e,Q,i),t(e,Ae,i),d(z,e,i),t(e,Oe,i),t(e,A,i),t(e,Ke,i),d(O,e,i),t(e,ei,i),d(K,e,i),t(e,ii,i),d(ee,e,i),t(e,li,i),d(ie,e,i),t(e,ti,i),t(e,le,i),t(e,ni,i),d(te,e,i),t(e,oi,i),t(e,ne,i),t(e,si,i),d(F,e,i),t(e,ai,i),d(oe,e,i),t(e,ri,i),t(e,se,i),t(e,fi,i),d(ae,e,i),t(e,di,i),d(re,e,i),t(e,pi,i),d(fe,e,i),t(e,ci,i),d(de,e,i),t(e,mi,i),d(I,e,i),t(e,ui,i),d(pe,e,i),t(e,gi,i),t(e,ce,i),t(e,hi,i),t(e,me,i),t(e,bi,i),t(e,ue,i),t(e,yi,i),d(ge,e,i),t(e,Mi,i),t(e,he,i),t(e,_i,i),d(be,e,i),t(e,wi,i),d(ye,e,i),t(e,Ji,i),t(e,Me,i),t(e,Ti,i),d(_e,e,i),t(e,$i,i),t(e,we,i),t(e,Ui,i),d(Je,e,i),t(e,Zi,i),d(R,e,i),t(e,xi,i),d(Te,e,i),t(e,ji,i),t(e,$e,i),t(e,ki,i),d(Ue,e,i),t(e,Gi,i),d(Y,e,i),t(e,vi,i),d(Ze,e,i),t(e,Wi,i),t(e,Z,i),d(xe,Z,null),T(Z,Ci),T(Z,Se),T(Z,Xi),T(Z,j),d(je,j,null),T(j,Li),T(j,Fe),T(j,Hi),d(N,j,null),t(e,Si,i),d(ke,e,i),t(e,Fi,i),t(e,x,i),d(Ge,x,null),T(x,Vi),T(x,Ie),T(x,Ei),T(x,k),d(ve,k,null),T(k,Pi),T(k,Re),T(k,Di),d(B,k,null),t(e,Ii,i),d(We,e,i),t(e,Ri,i),t(e,Ce,i),Yi=!0},p(e,[i]){const G={};i&2&&(G.$$scope={dirty:i,ctx:e}),F.$set(G);const v={};i&2&&(v.$$scope={dirty:i,ctx:e}),I.$set(v);const W={};i&2&&(W.$$scope={dirty:i,ctx:e}),R.$set(W);const S={};i&2&&(S.$$scope={dirty:i,ctx:e}),Y.$set(S);const ul={};i&2&&(ul.$$scope={dirty:i,ctx:e}),N.$set(ul);const gl={};i&2&&(gl.$$scope={dirty:i,ctx:e}),B.$set(gl)},i(e){Yi||(p(w.$$.fragment,e),p(X.$$.fragment,e),p(H.$$.fragment,e),p(E.$$.fragment,e),p(P.$$.fragment,e),p(D.$$.fragment,e),p(q.$$.fragment,e),p(z.$$.fragment,e),p(O.$$.fragment,e),p(K.$$.fragment,e),p(ee.$$.fragment,e),p(ie.$$.fragment,e),p(te.$$.fragment,e),p(F.$$.fragment,e),p(oe.$$.fragment,e),p(ae.$$.fragment,e),p(re.$$.fragment,e),p(fe.$$.fragment,e),p(de.$$.fragment,e),p(I.$$.fragment,e),p(pe.$$.fragment,e),p(ge.$$.fragment,e),p(be.$$.fragment,e),p(ye.$$.fragment,e),p(_e.$$.fragment,e),p(Je.$$.fragment,e),p(R.$$.fragment,e),p(Te.$$.fragment,e),p(Ue.$$.fragment,e),p(Y.$$.fragment,e),p(Ze.$$.fragment,e),p(xe.$$.fragment,e),p(je.$$.fragment,e),p(N.$$.fragment,e),p(ke.$$.fragment,e),p(Ge.$$.fragment,e),p(ve.$$.fragment,e),p(B.$$.fragment,e),p(We.$$.fragment,e),Yi=!0)},o(e){c(w.$$.fragment,e),c(X.$$.fragment,e),c(H.$$.fragment,e),c(E.$$.fragment,e),c(P.$$.fragment,e),c(D.$$.fragment,e),c(q.$$.fragment,e),c(z.$$.fragment,e),c(O.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(ie.$$.fragment,e),c(te.$$.fragment,e),c(F.$$.fragment,e),c(oe.$$.fragment,e),c(ae.$$.fragment,e),c(re.$$.fragment,e),c(fe.$$.fragment,e),c(de.$$.fragment,e),c(I.$$.fragment,e),c(pe.$$.fragment,e),c(ge.$$.fragment,e),c(be.$$.fragment,e),c(ye.$$.fragment,e),c(_e.$$.fragment,e),c(Je.$$.fragment,e),c(R.$$.fragment,e),c(Te.$$.fragment,e),c(Ue.$$.fragment,e),c(Y.$$.fragment,e),c(Ze.$$.fragment,e),c(xe.$$.fragment,e),c(je.$$.fragment,e),c(N.$$.fragment,e),c(ke.$$.fragment,e),c(Ge.$$.fragment,e),c(ve.$$.fragment,e),c(B.$$.fragment,e),c(We.$$.fragment,e),Yi=!1},d(e){e&&(l(M),l(a),l(b),l(h),l(J),l(Xe),l(C),l(Le),l(He),l(L),l(Ve),l(Ee),l(V),l(Pe),l(De),l(qe),l(Qe),l(ze),l(Q),l(Ae),l(Oe),l(A),l(Ke),l(ei),l(ii),l(li),l(ti),l(le),l(ni),l(oi),l(ne),l(si),l(ai),l(ri),l(se),l(fi),l(di),l(pi),l(ci),l(mi),l(ui),l(gi),l(ce),l(hi),l(me),l(bi),l(ue),l(yi),l(Mi),l(he),l(_i),l(wi),l(Ji),l(Me),l(Ti),l($i),l(we),l(Ui),l(Zi),l(xi),l(ji),l($e),l(ki),l(Gi),l(vi),l(Wi),l(Z),l(Si),l(Fi),l(x),l(Ii),l(Ri),l(Ce)),l(s),m(w,e),m(X,e),m(H,e),m(E,e),m(P,e),m(D,e),m(q,e),m(z,e),m(O,e),m(K,e),m(ee,e),m(ie,e),m(te,e),m(F,e),m(oe,e),m(ae,e),m(re,e),m(fe,e),m(de,e),m(I,e),m(pe,e),m(ge,e),m(be,e),m(ye,e),m(_e,e),m(Je,e),m(R,e),m(Te,e),m(Ue,e),m(Y,e),m(Ze,e),m(xe),m(je),m(N),m(ke,e),m(Ge),m(ve),m(B),m(We,e)}}}const Gl='{"title":"Loading Pipelines and Models via from_single_file","local":"loading-pipelines-and-models-via-fromsinglefile","sections":[{"title":"Pipelines that currently support from_single_file loading","local":"pipelines-that-currently-support-fromsinglefile-loading","sections":[],"depth":2},{"title":"Models that currently support from_single_file loading","local":"models-that-currently-support-fromsinglefile-loading","sections":[],"depth":2},{"title":"Usage Examples","local":"usage-examples","sections":[],"depth":2},{"title":"Loading a Pipeline using from_single_file","local":"loading-a-pipeline-using-fromsinglefile","sections":[],"depth":2},{"title":"Setting components in a Pipeline using from_single_file","local":"setting-components-in-a-pipeline-using-fromsinglefile","sections":[],"depth":2},{"title":"Loading a Model using from_single_file","local":"loading-a-model-using-fromsinglefile","sections":[],"depth":2},{"title":"Using a Diffusers model repository to configure single file loading","local":"using-a-diffusers-model-repository-to-configure-single-file-loading","sections":[],"depth":2},{"title":"Override configuration options when using single file loading","local":"override-configuration-options-when-using-single-file-loading","sections":[{"title":"Setting a pipeline configuration option","local":"setting-a-pipeline-configuration-option","sections":[],"depth":3},{"title":"Setting a model configuration option","local":"setting-a-model-configuration-option","sections":[],"depth":3}],"depth":2},{"title":"Working with local files","local":"working-with-local-files","sections":[],"depth":2},{"title":"Working with local files on file systems that do not support symlinking","local":"working-with-local-files-on-file-systems-that-do-not-support-symlinking","sections":[],"depth":2},{"title":"Using the original configuration file of a model","local":"using-the-original-configuration-file-of-a-model","sections":[],"depth":2},{"title":"FromSingleFileMixin","local":"diffusers.loaders.FromSingleFileMixin","sections":[],"depth":2},{"title":"FromOriginalModelMixin","local":"diffusers.loaders.FromOriginalModelMixin","sections":[],"depth":2}],"depth":1}';function vl($){return yl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Bl extends Ml{constructor(s){super(),_l(this,s,vl,kl,bl,{})}}export{Bl as component};
