import{s as Ke,o as Qe,n as Xe}from"../chunks/scheduler.182ea377.js";import{S as et,i as tt,g as a,s as i,r as M,A as nt,h as r,f as n,c as s,j as W,u as b,x as u,k as Y,y as d,a as o,v,d as y,t as w,w as x}from"../chunks/index.abf12888.js";import{T as ot}from"../chunks/Tip.230e2334.js";import{D as ie}from"../chunks/Docstring.93f6f462.js";import{C as it}from"../chunks/CodeBlock.57fe6e13.js";import{E as st}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as He}from"../chunks/Heading.16916d63.js";function at(O){let l,T='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){l=a("p"),l.innerHTML=T},l(f){l=r(f,"P",{"data-svelte-h":!0}),u(l)!=="svelte-1wmc0l4"&&(l.innerHTML=T)},m(f,h){o(f,l,h)},p:Xe,d(f){f&&n(l)}}}function rt(O){let l,T="Examples:",f,h,g;return h=new it({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyME11c2ljTERNUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQWltcG9ydCUyMHNjaXB5JTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMmN2c3NwJTJGYXVkaW9sZG0tcy1mdWxsLXYyJTIyJTBBcGlwZSUyMCUzRCUyME11c2ljTERNUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJUZWNobm8lMjBtdXNpYyUyMHdpdGglMjBhJTIwc3Ryb25nJTJDJTIwdXBiZWF0JTIwdGVtcG8lMjBhbmQlMjBoaWdoJTIwbWVsb2RpYyUyMHJpZmZzJTIyJTBBYXVkaW8lMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QxMCUyQyUyMGF1ZGlvX2xlbmd0aF9pbl9zJTNENS4wKS5hdWRpb3MlNUIwJTVEJTBBJTBBJTIzJTIwc2F2ZSUyMHRoZSUyMGF1ZGlvJTIwc2FtcGxlJTIwYXMlMjBhJTIwLndhdiUyMGZpbGUlMEFzY2lweS5pby53YXZmaWxlLndyaXRlKCUyMnRlY2huby53YXYlMjIlMkMlMjByYXRlJTNEMTYwMDAlMkMlMjBkYXRhJTNEYXVkaW8p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MusicLDMPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> scipy

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;cvssp/audioldm-s-full-v2&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = MusicLDMPipeline.from_pretrained(repo_id, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Techno music with a strong, upbeat tempo and high melodic riffs&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = pipe(prompt, num_inference_steps=<span class="hljs-number">10</span>, audio_length_in_s=<span class="hljs-number">5.0</span>).audios[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># save the audio sample as a .wav file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>scipy.io.wavfile.write(<span class="hljs-string">&quot;techno.wav&quot;</span>, rate=<span class="hljs-number">16000</span>, data=audio)`,wrap:!1}}),{c(){l=a("p"),l.textContent=T,f=i(),M(h.$$.fragment)},l(c){l=r(c,"P",{"data-svelte-h":!0}),u(l)!=="svelte-kvfsh7"&&(l.textContent=T),f=s(c),b(h.$$.fragment,c)},m(c,_){o(c,l,_),o(c,f,_),v(h,c,_),g=!0},p:Xe,i(c){g||(y(h.$$.fragment,c),g=!0)},o(c){w(h.$$.fragment,c),g=!1},d(c){c&&(n(l),n(f)),x(h,c)}}}function lt(O){let l,T,f,h,g,c,_,Se=`MusicLDM was proposed in <a href="https://huggingface.co/papers/2308.01546" rel="nofollow">MusicLDM: Enhancing Novelty in Text-to-Music Generation Using Beat-Synchronous Mixup Strategies</a> by Ke Chen, Yusong Wu, Haohe Liu, Marianna Nezhurina, Taylor Berg-Kirkpatrick, Shlomo Dubnov.
MusicLDM takes a text prompt as input and predicts the corresponding music sample.`,se,j,Ie=`Inspired by <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/overview" rel="nofollow">Stable Diffusion</a> and <a href="https://huggingface.co/docs/diffusers/api/pipelines/audioldm" rel="nofollow">AudioLDM</a>,
MusicLDM is a text-to-music <em>latent diffusion model (LDM)</em> that learns continuous audio representations from <a href="https://huggingface.co/docs/transformers/main/model_doc/clap" rel="nofollow">CLAP</a>
latents.`,ae,G,Ne="MusicLDM is trained on a corpus of 466 hours of music data. Beat-synchronous data augmentation strategies are applied to the music samples, both in the time domain and in the latent space. Using beat-synchronous data augmentation strategies encourages the model to interpolate between the training samples, but stay within the domain of the training data. The result is generated music that is more diverse while staying faithful to the corresponding style.",re,H,Ae="The abstract of the paper is the following:",le,S,Be="<em>Diffusion models have shown promising results in cross-modal generation tasks, including text-to-image and text-to-audio generation. However, generating music, as a special type of audio, presents unique challenges due to limited availability of music data and sensitive issues related to copyright and plagiarism. In this paper, to tackle these challenges, we first construct a state-of-the-art text-to-music model, MusicLDM, that adapts Stable Diffusion and AudioLDM architectures to the music domain. We achieve this by retraining the contrastive language-audio pretraining model (CLAP) and the Hifi-GAN vocoder, as components of MusicLDM, on a collection of music data samples. Then, to address the limitations of training data and to avoid plagiarism, we leverage a beat tracking model and propose two different mixup strategies for data augmentation: beat-synchronous audio mixup and beat-synchronous latent mixup, which recombine training audio directly or via a latent embeddings space, respectively. Such mixup strategies encourage the model to interpolate between musical training samples and generate new music within the convex hull of the training data, making the generated music more diverse while still staying faithful to the corresponding style. In addition to popular evaluation metrics, we design several new evaluation metrics based on CLAP score to demonstrate that our proposed MusicLDM and beat-synchronous mixup strategies improve both the quality and novelty of generated music, as well as the correspondence between input text and generated music.</em>",de,I,Ee='This pipeline was contributed by <a href="https://huggingface.co/sanchit-gandhi" rel="nofollow">sanchit-gandhi</a>.',ce,N,pe,A,Je="When constructing a prompt, keep in mind:",ue,B,qe="<li>Descriptive prompt inputs work best; use adjectives to describe the sound (for example, “high quality” or “clear”) and make the prompt context specific where possible (e.g. “melodic techno with a fast beat and synths” works better than “techno”).</li> <li>Using a <em>negative prompt</em> can significantly improve the quality of the generated audio. Try using a negative prompt of “low quality, average quality”.</li>",me,E,ze="During inference:",fe,J,Fe="<li>The <em>quality</em> of the generated audio sample can be controlled by the <code>num_inference_steps</code> argument; higher steps give higher quality audio at the expense of slower inference.</li> <li>Multiple waveforms can be generated in one go: set <code>num_waveforms_per_prompt</code> to a value greater than 1 to enable. Automatic scoring will be performed between the generated waveforms and prompt text, and the audios ranked from best to worst accordingly.</li> <li>The <em>length</em> of the generated audio sample can be controlled by varying the <code>audio_length_in_s</code> argument.</li>",he,D,ge,q,_e,p,z,xe,X,Ve="Pipeline for text-to-audio generation using MusicLDM.",Te,K,Ze=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,$e,$,F,Le,Q,Re="The call function to the pipeline for generation.",De,C,Ce,P,V,Pe,ee,We=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,ke,k,Z,Ue,te,Ye=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the GPU when its <code>forward</code>
method is called, and the model remains in GPU until the next model runs. Memory savings are lower than with
<code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution of the <code>unet</code>.`,je,U,R,Ge,ne,Oe=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Me,oe,be;return g=new He({props:{title:"MusicLDM",local:"musicldm",headingTag:"h1"}}),N=new He({props:{title:"Tips",local:"tips",headingTag:"h2"}}),D=new ot({props:{$$slots:{default:[at]},$$scope:{ctx:O}}}),q=new He({props:{title:"MusicLDMPipeline",local:"diffusers.MusicLDMPipeline",headingTag:"h2"}}),z=new ie({props:{name:"class diffusers.MusicLDMPipeline",anchor:"diffusers.MusicLDMPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": typing.Union[transformers.models.clap.modeling_clap.ClapTextModelWithProjection, transformers.models.clap.modeling_clap.ClapModel]"},{name:"tokenizer",val:": typing.Union[transformers.models.roberta.tokenization_roberta.RobertaTokenizer, transformers.models.roberta.tokenization_roberta_fast.RobertaTokenizerFast]"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clap.feature_extraction_clap.ClapFeatureExtractor]"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"vocoder",val:": SpeechT5HifiGan"}],parametersDescription:[{anchor:"diffusers.MusicLDMPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.MusicLDMPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clap#transformers.ClapModel" rel="nofollow">ClapModel</a>) &#x2014;
Frozen text-audio embedding model (<code>ClapTextModel</code>), specifically the
<a href="https://huggingface.co/laion/clap-htsat-unfused" rel="nofollow">laion/clap-htsat-unfused</a> variant.`,name:"text_encoder"},{anchor:"diffusers.MusicLDMPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>PreTrainedTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/roberta#transformers.RobertaTokenizer" rel="nofollow">RobertaTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.MusicLDMPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clap#transformers.ClapFeatureExtractor" rel="nofollow">ClapFeatureExtractor</a>) &#x2014;
Feature extractor to compute mel-spectrograms from audio waveforms.`,name:"feature_extractor"},{anchor:"diffusers.MusicLDMPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded audio latents.`,name:"unet"},{anchor:"diffusers.MusicLDMPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded audio latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.MusicLDMPipeline.vocoder",description:`<strong>vocoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/speecht5#transformers.SpeechT5HifiGan" rel="nofollow">SpeechT5HifiGan</a>) &#x2014;
Vocoder of class <code>SpeechT5HifiGan</code>.`,name:"vocoder"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/musicldm/pipeline_musicldm.py#L67"}}),F=new ie({props:{name:"__call__",anchor:"diffusers.MusicLDMPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"audio_length_in_s",val:": typing.Optional[float] = None"},{name:"num_inference_steps",val:": int = 200"},{name:"guidance_scale",val:": float = 2.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_waveforms_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": typing.Optional[int] = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"output_type",val:": typing.Optional[str] = 'np'"}],parametersDescription:[{anchor:"diffusers.MusicLDMPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide audio generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.MusicLDMPipeline.__call__.audio_length_in_s",description:`<strong>audio_length_in_s</strong> (<code>int</code>, <em>optional</em>, defaults to 10.24) &#x2014;
The length of the generated audio sample in seconds.`,name:"audio_length_in_s"},{anchor:"diffusers.MusicLDMPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 200) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality audio at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.MusicLDMPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 2.0) &#x2014;
A higher guidance scale value encourages the model to generate audio that is closely linked to the text
<code>prompt</code> at the expense of lower sound quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.MusicLDMPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in audio generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.MusicLDMPipeline.__call__.num_waveforms_per_prompt",description:`<strong>num_waveforms_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of waveforms to generate per prompt. If <code>num_waveforms_per_prompt &gt; 1</code>, the text encoding
model is a joint text-audio model (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clap#transformers.ClapModel" rel="nofollow">ClapModel</a>), and the tokenizer is a
<code>[~transformers.ClapProcessor]</code>, then automatic scoring will be performed between the generated outputs
and the input text. This scoring ranks the generated waveforms based on their cosine similarity to text
input in the joint text-audio embedding space.`,name:"num_waveforms_per_prompt"},{anchor:"diffusers.MusicLDMPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.MusicLDMPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.MusicLDMPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.MusicLDMPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.MusicLDMPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.MusicLDMPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/dance_diffusion#diffusers.AudioPipelineOutput">AudioPipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.MusicLDMPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.MusicLDMPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.MusicLDMPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.MusicLDMPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated audio. Choose between <code>&quot;np&quot;</code> to return a NumPy <code>np.ndarray</code> or
<code>&quot;pt&quot;</code> to return a PyTorch <code>torch.Tensor</code> object. Set to <code>&quot;latent&quot;</code> to return the latent diffusion
model (LDM) output.`,name:"output_type"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/musicldm/pipeline_musicldm.py#L434",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/dance_diffusion#diffusers.AudioPipelineOutput"
>AudioPipelineOutput</a> is returned, otherwise a <code>tuple</code> is
returned where the first element is a list with the generated audio.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/dance_diffusion#diffusers.AudioPipelineOutput"
>AudioPipelineOutput</a> or <code>tuple</code></p>
`}}),C=new st({props:{anchor:"diffusers.MusicLDMPipeline.__call__.example",$$slots:{default:[rt]},$$scope:{ctx:O}}}),V=new ie({props:{name:"disable_vae_slicing",anchor:"diffusers.MusicLDMPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/musicldm/pipeline_musicldm.py#L125"}}),Z=new ie({props:{name:"enable_model_cpu_offload",anchor:"diffusers.MusicLDMPipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/musicldm/pipeline_musicldm.py#L400"}}),R=new ie({props:{name:"enable_vae_slicing",anchor:"diffusers.MusicLDMPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/musicldm/pipeline_musicldm.py#L117"}}),{c(){l=a("meta"),T=i(),f=a("p"),h=i(),M(g.$$.fragment),c=i(),_=a("p"),_.innerHTML=Se,se=i(),j=a("p"),j.innerHTML=Ie,ae=i(),G=a("p"),G.textContent=Ne,re=i(),H=a("p"),H.textContent=Ae,le=i(),S=a("p"),S.innerHTML=Be,de=i(),I=a("p"),I.innerHTML=Ee,ce=i(),M(N.$$.fragment),pe=i(),A=a("p"),A.textContent=Je,ue=i(),B=a("ul"),B.innerHTML=qe,me=i(),E=a("p"),E.textContent=ze,fe=i(),J=a("ul"),J.innerHTML=Fe,he=i(),M(D.$$.fragment),ge=i(),M(q.$$.fragment),_e=i(),p=a("div"),M(z.$$.fragment),xe=i(),X=a("p"),X.textContent=Ve,Te=i(),K=a("p"),K.innerHTML=Ze,$e=i(),$=a("div"),M(F.$$.fragment),Le=i(),Q=a("p"),Q.textContent=Re,De=i(),M(C.$$.fragment),Ce=i(),P=a("div"),M(V.$$.fragment),Pe=i(),ee=a("p"),ee.innerHTML=We,ke=i(),k=a("div"),M(Z.$$.fragment),Ue=i(),te=a("p"),te.innerHTML=Ye,je=i(),U=a("div"),M(R.$$.fragment),Ge=i(),ne=a("p"),ne.textContent=Oe,Me=i(),oe=a("p"),this.h()},l(e){const t=nt("svelte-u9bgzb",document.head);l=r(t,"META",{name:!0,content:!0}),t.forEach(n),T=s(e),f=r(e,"P",{}),W(f).forEach(n),h=s(e),b(g.$$.fragment,e),c=s(e),_=r(e,"P",{"data-svelte-h":!0}),u(_)!=="svelte-dgtsvr"&&(_.innerHTML=Se),se=s(e),j=r(e,"P",{"data-svelte-h":!0}),u(j)!=="svelte-xz1yc5"&&(j.innerHTML=Ie),ae=s(e),G=r(e,"P",{"data-svelte-h":!0}),u(G)!=="svelte-59771y"&&(G.textContent=Ne),re=s(e),H=r(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-wu27l3"&&(H.textContent=Ae),le=s(e),S=r(e,"P",{"data-svelte-h":!0}),u(S)!=="svelte-qsxrno"&&(S.innerHTML=Be),de=s(e),I=r(e,"P",{"data-svelte-h":!0}),u(I)!=="svelte-ig43pw"&&(I.innerHTML=Ee),ce=s(e),b(N.$$.fragment,e),pe=s(e),A=r(e,"P",{"data-svelte-h":!0}),u(A)!=="svelte-1dvtu0c"&&(A.textContent=Je),ue=s(e),B=r(e,"UL",{"data-svelte-h":!0}),u(B)!=="svelte-1gnv7ni"&&(B.innerHTML=qe),me=s(e),E=r(e,"P",{"data-svelte-h":!0}),u(E)!=="svelte-1g0t9wk"&&(E.textContent=ze),fe=s(e),J=r(e,"UL",{"data-svelte-h":!0}),u(J)!=="svelte-1ynscju"&&(J.innerHTML=Fe),he=s(e),b(D.$$.fragment,e),ge=s(e),b(q.$$.fragment,e),_e=s(e),p=r(e,"DIV",{class:!0});var m=W(p);b(z.$$.fragment,m),xe=s(m),X=r(m,"P",{"data-svelte-h":!0}),u(X)!=="svelte-1abu1jx"&&(X.textContent=Ve),Te=s(m),K=r(m,"P",{"data-svelte-h":!0}),u(K)!=="svelte-496sm0"&&(K.innerHTML=Ze),$e=s(m),$=r(m,"DIV",{class:!0});var L=W($);b(F.$$.fragment,L),Le=s(L),Q=r(L,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-50j04k"&&(Q.textContent=Re),De=s(L),b(C.$$.fragment,L),L.forEach(n),Ce=s(m),P=r(m,"DIV",{class:!0});var ve=W(P);b(V.$$.fragment,ve),Pe=s(ve),ee=r(ve,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-1s3c06i"&&(ee.innerHTML=We),ve.forEach(n),ke=s(m),k=r(m,"DIV",{class:!0});var ye=W(k);b(Z.$$.fragment,ye),Ue=s(ye),te=r(ye,"P",{"data-svelte-h":!0}),u(te)!=="svelte-d7vywi"&&(te.innerHTML=Ye),ye.forEach(n),je=s(m),U=r(m,"DIV",{class:!0});var we=W(U);b(R.$$.fragment,we),Ge=s(we),ne=r(we,"P",{"data-svelte-h":!0}),u(ne)!=="svelte-14bnrb6"&&(ne.textContent=Oe),we.forEach(n),m.forEach(n),Me=s(e),oe=r(e,"P",{}),W(oe).forEach(n),this.h()},h(){Y(l,"name","hf:doc:metadata"),Y(l,"content",dt),Y($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Y(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Y(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Y(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Y(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){d(document.head,l),o(e,T,t),o(e,f,t),o(e,h,t),v(g,e,t),o(e,c,t),o(e,_,t),o(e,se,t),o(e,j,t),o(e,ae,t),o(e,G,t),o(e,re,t),o(e,H,t),o(e,le,t),o(e,S,t),o(e,de,t),o(e,I,t),o(e,ce,t),v(N,e,t),o(e,pe,t),o(e,A,t),o(e,ue,t),o(e,B,t),o(e,me,t),o(e,E,t),o(e,fe,t),o(e,J,t),o(e,he,t),v(D,e,t),o(e,ge,t),v(q,e,t),o(e,_e,t),o(e,p,t),v(z,p,null),d(p,xe),d(p,X),d(p,Te),d(p,K),d(p,$e),d(p,$),v(F,$,null),d($,Le),d($,Q),d($,De),v(C,$,null),d(p,Ce),d(p,P),v(V,P,null),d(P,Pe),d(P,ee),d(p,ke),d(p,k),v(Z,k,null),d(k,Ue),d(k,te),d(p,je),d(p,U),v(R,U,null),d(U,Ge),d(U,ne),o(e,Me,t),o(e,oe,t),be=!0},p(e,[t]){const m={};t&2&&(m.$$scope={dirty:t,ctx:e}),D.$set(m);const L={};t&2&&(L.$$scope={dirty:t,ctx:e}),C.$set(L)},i(e){be||(y(g.$$.fragment,e),y(N.$$.fragment,e),y(D.$$.fragment,e),y(q.$$.fragment,e),y(z.$$.fragment,e),y(F.$$.fragment,e),y(C.$$.fragment,e),y(V.$$.fragment,e),y(Z.$$.fragment,e),y(R.$$.fragment,e),be=!0)},o(e){w(g.$$.fragment,e),w(N.$$.fragment,e),w(D.$$.fragment,e),w(q.$$.fragment,e),w(z.$$.fragment,e),w(F.$$.fragment,e),w(C.$$.fragment,e),w(V.$$.fragment,e),w(Z.$$.fragment,e),w(R.$$.fragment,e),be=!1},d(e){e&&(n(T),n(f),n(h),n(c),n(_),n(se),n(j),n(ae),n(G),n(re),n(H),n(le),n(S),n(de),n(I),n(ce),n(pe),n(A),n(ue),n(B),n(me),n(E),n(fe),n(J),n(he),n(ge),n(_e),n(p),n(Me),n(oe)),n(l),x(g,e),x(N,e),x(D,e),x(q,e),x(z),x(F),x(C),x(V),x(Z),x(R)}}}const dt='{"title":"MusicLDM","local":"musicldm","sections":[{"title":"Tips","local":"tips","sections":[],"depth":2},{"title":"MusicLDMPipeline","local":"diffusers.MusicLDMPipeline","sections":[],"depth":2}],"depth":1}';function ct(O){return Qe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Mt extends et{constructor(l){super(),tt(this,l,ct,lt,Ke,{})}}export{Mt as component};
