import{s as Ua,o as da,n as Nl}from"../chunks/scheduler.182ea377.js";import{S as ua,i as Ia,g as p,s as t,r as c,A as ba,h as M,f as a,c as n,j as Ta,u as m,x as o,k as As,y as ga,a as e,v as j,d as y,t as r,w as h}from"../chunks/index.abf12888.js";import{T as Rl}from"../chunks/Tip.230e2334.js";import{C as J}from"../chunks/CodeBlock.57fe6e13.js";import{D as fa}from"../chunks/DocNotebookDropdown.d9060979.js";import{H as Bs}from"../chunks/Heading.16916d63.js";function Ca(d){let i,T='💡 This training tutorial is based on the <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers/training_example.ipynb" rel="nofollow">Training with 🧨 Diffusers</a> notebook. For additional details and context about diffusion models like how they work, check out the notebook!';return{c(){i=p("p"),i.innerHTML=T},l(w){i=M(w,"P",{"data-svelte-h":!0}),o(i)!=="svelte-mrih6e"&&(i.innerHTML=T)},m(w,U){e(w,i,U)},p:Nl,d(w){w&&a(i)}}}function Ba(d){let i,T='💡 You can find additional datasets from the <a href="https://huggingface.co/huggan" rel="nofollow">HugGan Community Event</a> or you can use your own dataset by creating a local <a href="https://huggingface.co/docs/datasets/image_dataset#imagefolder" rel="nofollow"><code>ImageFolder</code></a>. Set <code>config.dataset_name</code> to the repository id of the dataset if it is from the HugGan Community Event, or <code>imagefolder</code> if you’re using your own images.';return{c(){i=p("p"),i.innerHTML=T},l(w){i=M(w,"P",{"data-svelte-h":!0}),o(i)!=="svelte-1617s30"&&(i.innerHTML=T)},m(w,U){e(w,i,U)},p:Nl,d(w){w&&a(i)}}}function Za(d){let i,T="💡 The training loop below may look intimidating and long, but it’ll be worth it later when you launch your training in just one line of code! If you can’t wait and want to start generating images, feel free to copy and run the code below. You can always come back and examine the training loop more closely later, like when you’re waiting for your model to finish training. 🤗";return{c(){i=p("p"),i.textContent=T},l(w){i=M(w,"P",{"data-svelte-h":!0}),o(i)!=="svelte-dstut0"&&(i.textContent=T)},m(w,U){e(w,i,U)},p:Nl,d(w){w&&a(i)}}}function Aa(d){let i,T,w,U,B,Gs,Z,Ws,A,$l='Unconditional image generation is a popular application of diffusion models that generates images that look like those in the dataset used for training. Typically, the best results are obtained from finetuning a pretrained model on a specific dataset. You can find many of these checkpoints on the <a href="https://huggingface.co/search/full-text?q=unconditional-image-generation&amp;type=model" rel="nofollow">Hub</a>, but if you can’t find one you like, you can always train your own!',Xs,G,zl='This tutorial will teach you how to train a <a href="/docs/diffusers/main/en/api/models/unet2d#diffusers.UNet2DModel">UNet2DModel</a> from scratch on a subset of the <a href="https://huggingface.co/datasets/huggan/smithsonian_butterflies_subset" rel="nofollow">Smithsonian Butterflies</a> dataset to generate your own 🦋 butterflies 🦋.',ks,u,_s,W,Yl='Before you begin, make sure you have 🤗 Datasets installed to load and preprocess image datasets, and 🤗 Accelerate, to simplify training on any number of GPUs. The following command will also install <a href="https://www.tensorflow.org/tensorboard" rel="nofollow">TensorBoard</a> to visualize training metrics (you can also use <a href="https://docs.wandb.ai/" rel="nofollow">Weights &amp; Biases</a> to track your training).',vs,X,Vs,k,Ql='We encourage you to share your model with the community, and in order to do that, you’ll need to login to your Hugging Face account (create one <a href="https://hf.co/join" rel="nofollow">here</a> if you don’t already have one!). You can login from a notebook and enter your token when prompted. Make sure your token has the write role.',Rs,_,Ns,v,Fl="Or login in from the terminal:",$s,V,zs,R,Sl='Since the model checkpoints are quite large, install <a href="https://git-lfs.com/" rel="nofollow">Git-LFS</a> to version these large files:',Ys,N,Qs,$,Fs,z,Hl="For convenience, create a <code>TrainingConfig</code> class containing the training hyperparameters (feel free to adjust them):",Ss,Y,Hs,Q,Es,F,El='You can easily load the <a href="https://huggingface.co/datasets/huggan/smithsonian_butterflies_subset" rel="nofollow">Smithsonian Butterflies</a> dataset with the 🤗 Datasets library:',xs,S,Ds,I,qs,H,xl='🤗 Datasets uses the <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Image" rel="nofollow">Image</a> feature to automatically decode the image data and load it as a <a href="https://pillow.readthedocs.io/en/stable/reference/Image.html" rel="nofollow"><code>PIL.Image</code></a> which we can visualize:',Ls,E,Ks,b,Dl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/butterflies_ds.png"/>',Ps,x,ql="The images are all different sizes though, so you’ll need to preprocess them first:",Os,D,Ll="<li><code>Resize</code> changes the image size to the one defined in <code>config.image_size</code>.</li> <li><code>RandomHorizontalFlip</code> augments the dataset by randomly mirroring the images.</li> <li><code>Normalize</code> is important to rescale the pixel values into a [-1, 1] range, which is what the model expects.</li>",sl,q,ll,L,Kl='Use 🤗 Datasets’ <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.set_transform" rel="nofollow">set_transform</a> method to apply the <code>preprocess</code> function on the fly during training:',al,K,el,P,Pl='Feel free to visualize the images again to confirm that they’ve been resized. Now you’re ready to wrap the dataset in a <a href="https://pytorch.org/docs/stable/data#torch.utils.data.DataLoader" rel="nofollow">DataLoader</a> for training!',tl,O,nl,ss,pl,ls,Ol='Pretrained models in 🧨 Diffusers are easily created from their model class with the parameters you want. For example, to create a <a href="/docs/diffusers/main/en/api/models/unet2d#diffusers.UNet2DModel">UNet2DModel</a>:',Ml,as,il,es,sa="It is often a good idea to quickly check the sample image shape matches the model output shape:",ol,ts,cl,ns,la="Great! Next, you’ll need a scheduler to add some noise to the image.",ml,ps,jl,Ms,aa="The scheduler behaves differently depending on whether you’re using the model for training or inference. During inference, the scheduler generates image from the noise. During training, the scheduler takes a model output - or a sample - from a specific point in the diffusion process and applies noise to the image according to a <em>noise schedule</em> and an <em>update rule</em>.",yl,is,ea='Let’s take a look at the <a href="/docs/diffusers/main/en/api/schedulers/ddpm#diffusers.DDPMScheduler">DDPMScheduler</a> and use the <code>add_noise</code> method to add some random noise to the <code>sample_image</code> from before:',rl,os,hl,g,ta='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/noisy_butterfly.png"/>',wl,cs,na="The training objective of the model is to predict the noise added to the image. The loss at this step can be calculated by:",Jl,ms,Tl,js,Ul,ys,pa="By now, you have most of the pieces to start training the model and all that’s left is putting everything together.",dl,rs,Ma="First, you’ll need an optimizer and a learning rate scheduler:",ul,hs,Il,ws,ia='Then, you’ll need a way to evaluate the model. For evaluation, you can use the <a href="/docs/diffusers/main/en/api/pipelines/ddpm#diffusers.DDPMPipeline">DDPMPipeline</a> to generate a batch of sample images and save it as a grid:',bl,Js,gl,Ts,oa="Now you can wrap all these components together in a training loop with 🤗 Accelerate for easy TensorBoard logging, gradient accumulation, and mixed precision training. To upload the model to the Hub, write a function to get your repository name and information and then push it to the Hub.",fl,f,Cl,Us,Bl,ds,ca='Phew, that was quite a bit of code! But you’re finally ready to launch the training with 🤗 Accelerate’s <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/launchers#accelerate.notebook_launcher" rel="nofollow">notebook_launcher</a> function. Pass the function the training loop, all the training arguments, and the number of processes (you can change this value to the number of GPUs available to you) to use for training:',Zl,us,Al,Is,ma="Once training is complete, take a look at the final 🦋 images 🦋 generated by your diffusion model!",Gl,bs,Wl,C,ja='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/butterflies_final.png"/>',Xl,gs,kl,fs,ya='Unconditional image generation is one example of a task that can be trained. You can explore other tasks and training techniques by visiting the <a href="../training/overview">🧨 Diffusers Training Examples</a> page. Here are some examples of what you can learn:',_l,Cs,ra='<li><a href="../training/text_inversion">Textual Inversion</a>, an algorithm that teaches a model a specific visual concept and integrates it into the generated image.</li> <li><a href="../training/dreambooth">DreamBooth</a>, a technique for generating personalized images of a subject given several input images of the subject.</li> <li><a href="../training/text2image">Guide</a> to finetuning a Stable Diffusion model on your own dataset.</li> <li><a href="../training/lora">Guide</a> to using LoRA, a memory-efficient technique for finetuning really large models faster.</li>',vl,Zs,Vl;return B=new fa({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/basic_training.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/basic_training.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/basic_training.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/basic_training.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/basic_training.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/basic_training.ipynb"}]}}),Z=new Bs({props:{title:"Train a diffusion model",local:"train-a-diffusion-model",headingTag:"h1"}}),u=new Rl({props:{$$slots:{default:[Ca]},$$scope:{ctx:d}}}),X=new J({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwZGlmZnVzZXJzJTVCdHJhaW5pbmclNUQ=",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries in Colab</span>
<span class="hljs-comment">#!pip install diffusers[training]</span>`,wrap:!1}}),_=new J({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),V=new J({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),N=new J({props:{code:"IXN1ZG8lMjBhcHQlMjAtcXElMjBpbnN0YWxsJTIwZ2l0LWxmcyUwQSFnaXQlMjBjb25maWclMjAtLWdsb2JhbCUyMGNyZWRlbnRpYWwuaGVscGVyJTIwc3RvcmU=",highlighted:`!sudo apt -qq install git-lfs
!git config --global credential.helper store`,wrap:!1}}),$=new Bs({props:{title:"Training configuration",local:"training-configuration",headingTag:"h2"}}),Y=new J({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwZGF0YWNsYXNzJTBBJTBBJTQwZGF0YWNsYXNzJTBBY2xhc3MlMjBUcmFpbmluZ0NvbmZpZyUzQSUwQSUyMCUyMCUyMCUyMGltYWdlX3NpemUlMjAlM0QlMjAxMjglMjAlMjAlMjMlMjB0aGUlMjBnZW5lcmF0ZWQlMjBpbWFnZSUyMHJlc29sdXRpb24lMEElMjAlMjAlMjAlMjB0cmFpbl9iYXRjaF9zaXplJTIwJTNEJTIwMTYlMEElMjAlMjAlMjAlMjBldmFsX2JhdGNoX3NpemUlMjAlM0QlMjAxNiUyMCUyMCUyMyUyMGhvdyUyMG1hbnklMjBpbWFnZXMlMjB0byUyMHNhbXBsZSUyMGR1cmluZyUyMGV2YWx1YXRpb24lMEElMjAlMjAlMjAlMjBudW1fZXBvY2hzJTIwJTNEJTIwNTAlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlMjAlM0QlMjAxJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUyMCUzRCUyMDFlLTQlMEElMjAlMjAlMjAlMjBscl93YXJtdXBfc3RlcHMlMjAlM0QlMjA1MDAlMEElMjAlMjAlMjAlMjBzYXZlX2ltYWdlX2Vwb2NocyUyMCUzRCUyMDEwJTBBJTIwJTIwJTIwJTIwc2F2ZV9tb2RlbF9lcG9jaHMlMjAlM0QlMjAzMCUwQSUyMCUyMCUyMCUyMG1peGVkX3ByZWNpc2lvbiUyMCUzRCUyMCUyMmZwMTYlMjIlMjAlMjAlMjMlMjAlNjBubyU2MCUyMGZvciUyMGZsb2F0MzIlMkMlMjAlNjBmcDE2JTYwJTIwZm9yJTIwYXV0b21hdGljJTIwbWl4ZWQlMjBwcmVjaXNpb24lMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTIwJTNEJTIwJTIyZGRwbS1idXR0ZXJmbGllcy0xMjglMjIlMjAlMjAlMjMlMjB0aGUlMjBtb2RlbCUyMG5hbWUlMjBsb2NhbGx5JTIwYW5kJTIwb24lMjB0aGUlMjBIRiUyMEh1YiUwQSUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTIwJTNEJTIwVHJ1ZSUyMCUyMCUyMyUyMHdoZXRoZXIlMjB0byUyMHVwbG9hZCUyMHRoZSUyMHNhdmVkJTIwbW9kZWwlMjB0byUyMHRoZSUyMEhGJTIwSHViJTBBJTIwJTIwJTIwJTIwaHViX21vZGVsX2lkJTIwJTNEJTIwJTIyJTNDeW91ci11c2VybmFtZSUzRSUyRiUzQ215LWF3ZXNvbWUtbW9kZWwlM0UlMjIlMjAlMjAlMjMlMjB0aGUlMjBuYW1lJTIwb2YlMjB0aGUlMjByZXBvc2l0b3J5JTIwdG8lMjBjcmVhdGUlMjBvbiUyMHRoZSUyMEhGJTIwSHViJTBBJTIwJTIwJTIwJTIwaHViX3ByaXZhdGVfcmVwbyUyMCUzRCUyMEZhbHNlJTBBJTIwJTIwJTIwJTIwb3ZlcndyaXRlX291dHB1dF9kaXIlMjAlM0QlMjBUcnVlJTIwJTIwJTIzJTIwb3ZlcndyaXRlJTIwdGhlJTIwb2xkJTIwbW9kZWwlMjB3aGVuJTIwcmUtcnVubmluZyUyMHRoZSUyMG5vdGVib29rJTBBJTIwJTIwJTIwJTIwc2VlZCUyMCUzRCUyMDAlMEElMEElMEFjb25maWclMjAlM0QlMjBUcmFpbmluZ0NvbmZpZygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass

<span class="hljs-meta">&gt;&gt;&gt; </span>@dataclass
<span class="hljs-meta">... </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">TrainingConfig</span>:
<span class="hljs-meta">... </span>    image_size = <span class="hljs-number">128</span>  <span class="hljs-comment"># the generated image resolution</span>
<span class="hljs-meta">... </span>    train_batch_size = <span class="hljs-number">16</span>
<span class="hljs-meta">... </span>    eval_batch_size = <span class="hljs-number">16</span>  <span class="hljs-comment"># how many images to sample during evaluation</span>
<span class="hljs-meta">... </span>    num_epochs = <span class="hljs-number">50</span>
<span class="hljs-meta">... </span>    gradient_accumulation_steps = <span class="hljs-number">1</span>
<span class="hljs-meta">... </span>    learning_rate = <span class="hljs-number">1e-4</span>
<span class="hljs-meta">... </span>    lr_warmup_steps = <span class="hljs-number">500</span>
<span class="hljs-meta">... </span>    save_image_epochs = <span class="hljs-number">10</span>
<span class="hljs-meta">... </span>    save_model_epochs = <span class="hljs-number">30</span>
<span class="hljs-meta">... </span>    mixed_precision = <span class="hljs-string">&quot;fp16&quot;</span>  <span class="hljs-comment"># \`no\` for float32, \`fp16\` for automatic mixed precision</span>
<span class="hljs-meta">... </span>    output_dir = <span class="hljs-string">&quot;ddpm-butterflies-128&quot;</span>  <span class="hljs-comment"># the model name locally and on the HF Hub</span>

<span class="hljs-meta">... </span>    push_to_hub = <span class="hljs-literal">True</span>  <span class="hljs-comment"># whether to upload the saved model to the HF Hub</span>
<span class="hljs-meta">... </span>    hub_model_id = <span class="hljs-string">&quot;&lt;your-username&gt;/&lt;my-awesome-model&gt;&quot;</span>  <span class="hljs-comment"># the name of the repository to create on the HF Hub</span>
<span class="hljs-meta">... </span>    hub_private_repo = <span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>    overwrite_output_dir = <span class="hljs-literal">True</span>  <span class="hljs-comment"># overwrite the old model when re-running the notebook</span>
<span class="hljs-meta">... </span>    seed = <span class="hljs-number">0</span>


<span class="hljs-meta">&gt;&gt;&gt; </span>config = TrainingConfig()`,wrap:!1}}),Q=new Bs({props:{title:"Load the dataset",local:"load-the-dataset",headingTag:"h2"}}),S=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBY29uZmlnLmRhdGFzZXRfbmFtZSUyMCUzRCUyMCUyMmh1Z2dhbiUyRnNtaXRoc29uaWFuX2J1dHRlcmZsaWVzX3N1YnNldCUyMiUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoY29uZmlnLmRhdGFzZXRfbmFtZSUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>config.dataset_name = <span class="hljs-string">&quot;huggan/smithsonian_butterflies_subset&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(config.dataset_name, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),I=new Rl({props:{$$slots:{default:[Ba]},$$scope:{ctx:d}}}),E=new J({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQWZpZyUyQyUyMGF4cyUyMCUzRCUyMHBsdC5zdWJwbG90cygxJTJDJTIwNCUyQyUyMGZpZ3NpemUlM0QoMTYlMkMlMjA0KSklMEFmb3IlMjBpJTJDJTIwaW1hZ2UlMjBpbiUyMGVudW1lcmF0ZShkYXRhc2V0JTVCJTNBNCU1RCU1QiUyMmltYWdlJTIyJTVEKSUzQSUwQSUyMCUyMCUyMCUyMGF4cyU1QmklNUQuaW1zaG93KGltYWdlKSUwQSUyMCUyMCUyMCUyMGF4cyU1QmklNUQuc2V0X2F4aXNfb2ZmKCklMEFmaWcuc2hvdygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span>fig, axs = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, figsize=(<span class="hljs-number">16</span>, <span class="hljs-number">4</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, image <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(dataset[:<span class="hljs-number">4</span>][<span class="hljs-string">&quot;image&quot;</span>]):
<span class="hljs-meta">... </span>    axs[i].imshow(image)
<span class="hljs-meta">... </span>    axs[i].set_axis_off()
<span class="hljs-meta">&gt;&gt;&gt; </span>fig.show()`,wrap:!1}}),q=new J({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uJTIwaW1wb3J0JTIwdHJhbnNmb3JtcyUwQSUwQXByZXByb2Nlc3MlMjAlM0QlMjB0cmFuc2Zvcm1zLkNvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhbnNmb3Jtcy5SZXNpemUoKGNvbmZpZy5pbWFnZV9zaXplJTJDJTIwY29uZmlnLmltYWdlX3NpemUpKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuUmFuZG9tSG9yaXpvbnRhbEZsaXAoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuVG9UZW5zb3IoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuTm9ybWFsaXplKCU1QjAuNSU1RCUyQyUyMCU1QjAuNSU1RCklMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision <span class="hljs-keyword">import</span> transforms

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocess = transforms.Compose(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        transforms.Resize((config.image_size, config.image_size)),
<span class="hljs-meta">... </span>        transforms.RandomHorizontalFlip(),
<span class="hljs-meta">... </span>        transforms.ToTensor(),
<span class="hljs-meta">... </span>        transforms.Normalize([<span class="hljs-number">0.5</span>], [<span class="hljs-number">0.5</span>]),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)`,wrap:!1}}),K=new J({props:{code:"ZGVmJTIwdHJhbnNmb3JtKGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlcyUyMCUzRCUyMCU1QnByZXByb2Nlc3MoaW1hZ2UuY29udmVydCglMjJSR0IlMjIpKSUyMGZvciUyMGltYWdlJTIwaW4lMjBleGFtcGxlcyU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyaW1hZ2VzJTIyJTNBJTIwaW1hZ2VzJTdEJTBBJTBBJTBBZGF0YXNldC5zZXRfdHJhbnNmb3JtKHRyYW5zZm9ybSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">transform</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    images = [preprocess(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;images&quot;</span>: images}


<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.set_transform(transform)`,wrap:!1}}),O=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF0cmFpbl9kYXRhbG9hZGVyJTIwJTNEJTIwdG9yY2gudXRpbHMuZGF0YS5EYXRhTG9hZGVyKGRhdGFzZXQlMkMlMjBiYXRjaF9zaXplJTNEY29uZmlnLnRyYWluX2JhdGNoX3NpemUlMkMlMjBzaHVmZmxlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader = torch.utils.data.DataLoader(dataset, batch_size=config.train_batch_size, shuffle=<span class="hljs-literal">True</span>)`,wrap:!1}}),ss=new Bs({props:{title:"Create a UNet2DModel",local:"create-a-unet2dmodel",headingTag:"h2"}}),as=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = UNet2DModel(
<span class="hljs-meta">... </span>    sample_size=config.image_size,  <span class="hljs-comment"># the target image resolution</span>
<span class="hljs-meta">... </span>    in_channels=<span class="hljs-number">3</span>,  <span class="hljs-comment"># the number of input channels, 3 for RGB images</span>
<span class="hljs-meta">... </span>    out_channels=<span class="hljs-number">3</span>,  <span class="hljs-comment"># the number of output channels</span>
<span class="hljs-meta">... </span>    layers_per_block=<span class="hljs-number">2</span>,  <span class="hljs-comment"># how many ResNet layers to use per UNet block</span>
<span class="hljs-meta">... </span>    block_out_channels=(<span class="hljs-number">128</span>, <span class="hljs-number">128</span>, <span class="hljs-number">256</span>, <span class="hljs-number">256</span>, <span class="hljs-number">512</span>, <span class="hljs-number">512</span>),  <span class="hljs-comment"># the number of output channels for each UNet block</span>
<span class="hljs-meta">... </span>    down_block_types=(
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,  <span class="hljs-comment"># a regular ResNet downsampling block</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;AttnDownBlock2D&quot;</span>,  <span class="hljs-comment"># a ResNet downsampling block with spatial self-attention</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>    up_block_types=(
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,  <span class="hljs-comment"># a regular ResNet upsampling block</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;AttnUpBlock2D&quot;</span>,  <span class="hljs-comment"># a ResNet upsampling block with spatial self-attention</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>)`,wrap:!1}}),ts=new J({props:{code:"c2FtcGxlX2ltYWdlJTIwJTNEJTIwZGF0YXNldCU1QjAlNUQlNUIlMjJpbWFnZXMlMjIlNUQudW5zcXVlZXplKDApJTBBcHJpbnQoJTIySW5wdXQlMjBzaGFwZSUzQSUyMiUyQyUyMHNhbXBsZV9pbWFnZS5zaGFwZSklMEElMEFwcmludCglMjJPdXRwdXQlMjBzaGFwZSUzQSUyMiUyQyUyMG1vZGVsKHNhbXBsZV9pbWFnZSUyQyUyMHRpbWVzdGVwJTNEMCkuc2FtcGxlLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>sample_image = dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;images&quot;</span>].unsqueeze(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Input shape:&quot;</span>, sample_image.shape)
Input shape: torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Output shape:&quot;</span>, model(sample_image, timestep=<span class="hljs-number">0</span>).sample.shape)
Output shape: torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>])`,wrap:!1}}),ps=new Bs({props:{title:"Create a scheduler",local:"create-a-scheduler",headingTag:"h2"}}),os=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERQTVNjaGVkdWxlciUwQSUwQW5vaXNlX3NjaGVkdWxlciUyMCUzRCUyMEREUE1TY2hlZHVsZXIobnVtX3RyYWluX3RpbWVzdGVwcyUzRDEwMDApJTBBbm9pc2UlMjAlM0QlMjB0b3JjaC5yYW5kbihzYW1wbGVfaW1hZ2Uuc2hhcGUpJTBBdGltZXN0ZXBzJTIwJTNEJTIwdG9yY2guTG9uZ1RlbnNvciglNUI1MCU1RCklMEFub2lzeV9pbWFnZSUyMCUzRCUyMG5vaXNlX3NjaGVkdWxlci5hZGRfbm9pc2Uoc2FtcGxlX2ltYWdlJTJDJTIwbm9pc2UlMkMlMjB0aW1lc3RlcHMpJTBBJTBBSW1hZ2UuZnJvbWFycmF5KCgobm9pc3lfaW1hZ2UucGVybXV0ZSgwJTJDJTIwMiUyQyUyMDMlMkMlMjAxKSUyMCUyQiUyMDEuMCklMjAqJTIwMTI3LjUpLnR5cGUodG9yY2gudWludDgpLm51bXB5KCklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>noise_scheduler = DDPMScheduler(num_train_timesteps=<span class="hljs-number">1000</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>noise = torch.randn(sample_image.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span>timesteps = torch.LongTensor([<span class="hljs-number">50</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>noisy_image = noise_scheduler.add_noise(sample_image, noise, timesteps)

<span class="hljs-meta">&gt;&gt;&gt; </span>Image.fromarray(((noisy_image.permute(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>) + <span class="hljs-number">1.0</span>) * <span class="hljs-number">127.5</span>).<span class="hljs-built_in">type</span>(torch.uint8).numpy()[<span class="hljs-number">0</span>])`,wrap:!1}}),ms=new J({props:{code:"aW1wb3J0JTIwdG9yY2gubm4uZnVuY3Rpb25hbCUyMGFzJTIwRiUwQSUwQW5vaXNlX3ByZWQlMjAlM0QlMjBtb2RlbChub2lzeV9pbWFnZSUyQyUyMHRpbWVzdGVwcykuc2FtcGxlJTBBbG9zcyUyMCUzRCUyMEYubXNlX2xvc3Mobm9pc2VfcHJlZCUyQyUyMG5vaXNlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F

<span class="hljs-meta">&gt;&gt;&gt; </span>noise_pred = model(noisy_image, timesteps).sample
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = F.mse_loss(noise_pred, noise)`,wrap:!1}}),js=new Bs({props:{title:"Train the model",local:"train-the-model",headingTag:"h2"}}),hs=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5vcHRpbWl6YXRpb24lMjBpbXBvcnQlMjBnZXRfY29zaW5lX3NjaGVkdWxlX3dpdGhfd2FybXVwJTBBJTBBb3B0aW1pemVyJTIwJTNEJTIwdG9yY2gub3B0aW0uQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0Rjb25maWcubGVhcm5pbmdfcmF0ZSklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfY29zaW5lX3NjaGVkdWxlX3dpdGhfd2FybXVwKCUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0Rjb25maWcubHJfd2FybXVwX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEKGxlbih0cmFpbl9kYXRhbG9hZGVyKSUyMColMjBjb25maWcubnVtX2Vwb2NocyklMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.optimization <span class="hljs-keyword">import</span> get_cosine_schedule_with_warmup

<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = torch.optim.AdamW(model.parameters(), lr=config.learning_rate)
<span class="hljs-meta">&gt;&gt;&gt; </span>lr_scheduler = get_cosine_schedule_with_warmup(
<span class="hljs-meta">... </span>    optimizer=optimizer,
<span class="hljs-meta">... </span>    num_warmup_steps=config.lr_warmup_steps,
<span class="hljs-meta">... </span>    num_training_steps=(<span class="hljs-built_in">len</span>(train_dataloader) * config.num_epochs),
<span class="hljs-meta">... </span>)`,wrap:!1}}),Js=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1QaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBtYWtlX2ltYWdlX2dyaWQlMEFpbXBvcnQlMjBvcyUwQSUwQWRlZiUyMGV2YWx1YXRlKGNvbmZpZyUyQyUyMGVwb2NoJTJDJTIwcGlwZWxpbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwU2FtcGxlJTIwc29tZSUyMGltYWdlcyUyMGZyb20lMjByYW5kb20lMjBub2lzZSUyMCh0aGlzJTIwaXMlMjB0aGUlMjBiYWNrd2FyZCUyMGRpZmZ1c2lvbiUyMHByb2Nlc3MpLiUwQSUyMCUyMCUyMCUyMCUyMyUyMFRoZSUyMGRlZmF1bHQlMjBwaXBlbGluZSUyMG91dHB1dCUyMHR5cGUlMjBpcyUyMCU2MExpc3QlNUJQSUwuSW1hZ2UlNUQlNjAlMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEY29uZmlnLmV2YWxfYmF0Y2hfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRHRvcmNoLm1hbnVhbF9zZWVkKGNvbmZpZy5zZWVkKSUyQyUwQSUyMCUyMCUyMCUyMCkuaW1hZ2VzJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwTWFrZSUyMGElMjBncmlkJTIwb3V0JTIwb2YlMjB0aGUlMjBpbWFnZXMlMEElMjAlMjAlMjAlMjBpbWFnZV9ncmlkJTIwJTNEJTIwbWFrZV9pbWFnZV9ncmlkKGltYWdlcyUyQyUyMHJvd3MlM0Q0JTJDJTIwY29scyUzRDQpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwU2F2ZSUyMHRoZSUyMGltYWdlcyUwQSUyMCUyMCUyMCUyMHRlc3RfZGlyJTIwJTNEJTIwb3MucGF0aC5qb2luKGNvbmZpZy5vdXRwdXRfZGlyJTJDJTIwJTIyc2FtcGxlcyUyMiklMEElMjAlMjAlMjAlMjBvcy5tYWtlZGlycyh0ZXN0X2RpciUyQyUyMGV4aXN0X29rJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBpbWFnZV9ncmlkLnNhdmUoZiUyMiU3QnRlc3RfZGlyJTdEJTJGJTdCZXBvY2glM0EwNGQlN0QucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">evaluate</span>(<span class="hljs-params">config, epoch, pipeline</span>):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Sample some images from random noise (this is the backward diffusion process).</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># The default pipeline output type is \`List[PIL.Image]\`</span>
<span class="hljs-meta">... </span>    images = pipeline(
<span class="hljs-meta">... </span>        batch_size=config.eval_batch_size,
<span class="hljs-meta">... </span>        generator=torch.manual_seed(config.seed),
<span class="hljs-meta">... </span>    ).images

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Make a grid out of the images</span>
<span class="hljs-meta">... </span>    image_grid = make_image_grid(images, rows=<span class="hljs-number">4</span>, cols=<span class="hljs-number">4</span>)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Save the images</span>
<span class="hljs-meta">... </span>    test_dir = os.path.join(config.output_dir, <span class="hljs-string">&quot;samples&quot;</span>)
<span class="hljs-meta">... </span>    os.makedirs(test_dir, exist_ok=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>    image_grid.save(<span class="hljs-string">f&quot;<span class="hljs-subst">{test_dir}</span>/<span class="hljs-subst">{epoch:04d}</span>.png&quot;</span>)`,wrap:!1}}),f=new Rl({props:{$$slots:{default:[Za]},$$scope:{ctx:d}}}),Us=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_repo, upload_folder
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">train_loop</span>(<span class="hljs-params">config, model, noise_scheduler, optimizer, train_dataloader, lr_scheduler</span>):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Initialize accelerator and tensorboard logging</span>
<span class="hljs-meta">... </span>    accelerator = Accelerator(
<span class="hljs-meta">... </span>        mixed_precision=config.mixed_precision,
<span class="hljs-meta">... </span>        gradient_accumulation_steps=config.gradient_accumulation_steps,
<span class="hljs-meta">... </span>        log_with=<span class="hljs-string">&quot;tensorboard&quot;</span>,
<span class="hljs-meta">... </span>        project_dir=os.path.join(config.output_dir, <span class="hljs-string">&quot;logs&quot;</span>),
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> accelerator.is_main_process:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> config.output_dir <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
<span class="hljs-meta">... </span>            os.makedirs(config.output_dir, exist_ok=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> config.push_to_hub:
<span class="hljs-meta">... </span>            repo_id = create_repo(
<span class="hljs-meta">... </span>                repo_id=config.hub_model_id <span class="hljs-keyword">or</span> Path(config.output_dir).name, exist_ok=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>            ).repo_id
<span class="hljs-meta">... </span>        accelerator.init_trackers(<span class="hljs-string">&quot;train_example&quot;</span>)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Prepare everything</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># There is no specific order to remember, you just need to unpack the</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># objects in the same order you gave them to the prepare method.</span>
<span class="hljs-meta">... </span>    model, optimizer, train_dataloader, lr_scheduler = accelerator.prepare(
<span class="hljs-meta">... </span>        model, optimizer, train_dataloader, lr_scheduler
<span class="hljs-meta">... </span>    )

<span class="hljs-meta">... </span>    global_step = <span class="hljs-number">0</span>

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Now you train the model</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(config.num_epochs):
<span class="hljs-meta">... </span>        progress_bar = tqdm(total=<span class="hljs-built_in">len</span>(train_dataloader), disable=<span class="hljs-keyword">not</span> accelerator.is_local_main_process)
<span class="hljs-meta">... </span>        progress_bar.set_description(<span class="hljs-string">f&quot;Epoch <span class="hljs-subst">{epoch}</span>&quot;</span>)

<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(train_dataloader):
<span class="hljs-meta">... </span>            clean_images = batch[<span class="hljs-string">&quot;images&quot;</span>]
<span class="hljs-meta">... </span>            <span class="hljs-comment"># Sample noise to add to the images</span>
<span class="hljs-meta">... </span>            noise = torch.randn(clean_images.shape, device=clean_images.device)
<span class="hljs-meta">... </span>            bs = clean_images.shape[<span class="hljs-number">0</span>]

<span class="hljs-meta">... </span>            <span class="hljs-comment"># Sample a random timestep for each image</span>
<span class="hljs-meta">... </span>            timesteps = torch.randint(
<span class="hljs-meta">... </span>                <span class="hljs-number">0</span>, noise_scheduler.config.num_train_timesteps, (bs,), device=clean_images.device
<span class="hljs-meta">... </span>            )

<span class="hljs-meta">... </span>            <span class="hljs-comment"># Add noise to the clean images according to the noise magnitude at each timestep</span>
<span class="hljs-meta">... </span>            <span class="hljs-comment"># (this is the forward diffusion process)</span>
<span class="hljs-meta">... </span>            noisy_images = noise_scheduler.add_noise(clean_images, noise, timesteps)

<span class="hljs-meta">... </span>            <span class="hljs-keyword">with</span> accelerator.accumulate(model):
<span class="hljs-meta">... </span>                <span class="hljs-comment"># Predict the noise residual</span>
<span class="hljs-meta">... </span>                noise_pred = model(noisy_images, timesteps, return_dict=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>                loss = F.mse_loss(noise_pred, noise)
<span class="hljs-meta">... </span>                accelerator.backward(loss)

<span class="hljs-meta">... </span>                accelerator.clip_grad_norm_(model.parameters(), <span class="hljs-number">1.0</span>)
<span class="hljs-meta">... </span>                optimizer.step()
<span class="hljs-meta">... </span>                lr_scheduler.step()
<span class="hljs-meta">... </span>                optimizer.zero_grad()

<span class="hljs-meta">... </span>            progress_bar.update(<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>            logs = {<span class="hljs-string">&quot;loss&quot;</span>: loss.detach().item(), <span class="hljs-string">&quot;lr&quot;</span>: lr_scheduler.get_last_lr()[<span class="hljs-number">0</span>], <span class="hljs-string">&quot;step&quot;</span>: global_step}
<span class="hljs-meta">... </span>            progress_bar.set_postfix(**logs)
<span class="hljs-meta">... </span>            accelerator.log(logs, step=global_step)
<span class="hljs-meta">... </span>            global_step += <span class="hljs-number">1</span>

<span class="hljs-meta">... </span>        <span class="hljs-comment"># After each epoch you optionally sample some demo images with evaluate() and save the model</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> accelerator.is_main_process:
<span class="hljs-meta">... </span>            pipeline = DDPMPipeline(unet=accelerator.unwrap_model(model), scheduler=noise_scheduler)

<span class="hljs-meta">... </span>            <span class="hljs-keyword">if</span> (epoch + <span class="hljs-number">1</span>) % config.save_image_epochs == <span class="hljs-number">0</span> <span class="hljs-keyword">or</span> epoch == config.num_epochs - <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>                evaluate(config, epoch, pipeline)

<span class="hljs-meta">... </span>            <span class="hljs-keyword">if</span> (epoch + <span class="hljs-number">1</span>) % config.save_model_epochs == <span class="hljs-number">0</span> <span class="hljs-keyword">or</span> epoch == config.num_epochs - <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>                <span class="hljs-keyword">if</span> config.push_to_hub:
<span class="hljs-meta">... </span>                    upload_folder(
<span class="hljs-meta">... </span>                        repo_id=repo_id,
<span class="hljs-meta">... </span>                        folder_path=config.output_dir,
<span class="hljs-meta">... </span>                        commit_message=<span class="hljs-string">f&quot;Epoch <span class="hljs-subst">{epoch}</span>&quot;</span>,
<span class="hljs-meta">... </span>                        ignore_patterns=[<span class="hljs-string">&quot;step_*&quot;</span>, <span class="hljs-string">&quot;epoch_*&quot;</span>],
<span class="hljs-meta">... </span>                    )
<span class="hljs-meta">... </span>                <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>                    pipeline.save_pretrained(config.output_dir)`,wrap:!1}}),us=new J({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQWFyZ3MlMjAlM0QlMjAoY29uZmlnJTJDJTIwbW9kZWwlMkMlMjBub2lzZV9zY2hlZHVsZXIlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwbHJfc2NoZWR1bGVyKSUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluX2xvb3AlMkMlMjBhcmdzJTJDJTIwbnVtX3Byb2Nlc3NlcyUzRDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

<span class="hljs-meta">&gt;&gt;&gt; </span>args = (config, model, noise_scheduler, optimizer, train_dataloader, lr_scheduler)

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_launcher(train_loop, args, num_processes=<span class="hljs-number">1</span>)`,wrap:!1}}),bs=new J({props:{code:"aW1wb3J0JTIwZ2xvYiUwQSUwQXNhbXBsZV9pbWFnZXMlMjAlM0QlMjBzb3J0ZWQoZ2xvYi5nbG9iKGYlMjIlN0Jjb25maWcub3V0cHV0X2RpciU3RCUyRnNhbXBsZXMlMkYqLnBuZyUyMikpJTBBSW1hZ2Uub3BlbihzYW1wbGVfaW1hZ2VzJTVCLTElNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> glob

<span class="hljs-meta">&gt;&gt;&gt; </span>sample_images = <span class="hljs-built_in">sorted</span>(glob.glob(<span class="hljs-string">f&quot;<span class="hljs-subst">{config.output_dir}</span>/samples/*.png&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>Image.<span class="hljs-built_in">open</span>(sample_images[-<span class="hljs-number">1</span>])`,wrap:!1}}),gs=new Bs({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),{c(){i=p("meta"),T=t(),w=p("p"),U=t(),c(B.$$.fragment),Gs=t(),c(Z.$$.fragment),Ws=t(),A=p("p"),A.innerHTML=$l,Xs=t(),G=p("p"),G.innerHTML=zl,ks=t(),c(u.$$.fragment),_s=t(),W=p("p"),W.innerHTML=Yl,vs=t(),c(X.$$.fragment),Vs=t(),k=p("p"),k.innerHTML=Ql,Rs=t(),c(_.$$.fragment),Ns=t(),v=p("p"),v.textContent=Fl,$s=t(),c(V.$$.fragment),zs=t(),R=p("p"),R.innerHTML=Sl,Ys=t(),c(N.$$.fragment),Qs=t(),c($.$$.fragment),Fs=t(),z=p("p"),z.innerHTML=Hl,Ss=t(),c(Y.$$.fragment),Hs=t(),c(Q.$$.fragment),Es=t(),F=p("p"),F.innerHTML=El,xs=t(),c(S.$$.fragment),Ds=t(),c(I.$$.fragment),qs=t(),H=p("p"),H.innerHTML=xl,Ls=t(),c(E.$$.fragment),Ks=t(),b=p("div"),b.innerHTML=Dl,Ps=t(),x=p("p"),x.textContent=ql,Os=t(),D=p("ul"),D.innerHTML=Ll,sl=t(),c(q.$$.fragment),ll=t(),L=p("p"),L.innerHTML=Kl,al=t(),c(K.$$.fragment),el=t(),P=p("p"),P.innerHTML=Pl,tl=t(),c(O.$$.fragment),nl=t(),c(ss.$$.fragment),pl=t(),ls=p("p"),ls.innerHTML=Ol,Ml=t(),c(as.$$.fragment),il=t(),es=p("p"),es.textContent=sa,ol=t(),c(ts.$$.fragment),cl=t(),ns=p("p"),ns.textContent=la,ml=t(),c(ps.$$.fragment),jl=t(),Ms=p("p"),Ms.innerHTML=aa,yl=t(),is=p("p"),is.innerHTML=ea,rl=t(),c(os.$$.fragment),hl=t(),g=p("div"),g.innerHTML=ta,wl=t(),cs=p("p"),cs.textContent=na,Jl=t(),c(ms.$$.fragment),Tl=t(),c(js.$$.fragment),Ul=t(),ys=p("p"),ys.textContent=pa,dl=t(),rs=p("p"),rs.textContent=Ma,ul=t(),c(hs.$$.fragment),Il=t(),ws=p("p"),ws.innerHTML=ia,bl=t(),c(Js.$$.fragment),gl=t(),Ts=p("p"),Ts.textContent=oa,fl=t(),c(f.$$.fragment),Cl=t(),c(Us.$$.fragment),Bl=t(),ds=p("p"),ds.innerHTML=ca,Zl=t(),c(us.$$.fragment),Al=t(),Is=p("p"),Is.textContent=ma,Gl=t(),c(bs.$$.fragment),Wl=t(),C=p("div"),C.innerHTML=ja,Xl=t(),c(gs.$$.fragment),kl=t(),fs=p("p"),fs.innerHTML=ya,_l=t(),Cs=p("ul"),Cs.innerHTML=ra,vl=t(),Zs=p("p"),this.h()},l(s){const l=ba("svelte-u9bgzb",document.head);i=M(l,"META",{name:!0,content:!0}),l.forEach(a),T=n(s),w=M(s,"P",{}),Ta(w).forEach(a),U=n(s),m(B.$$.fragment,s),Gs=n(s),m(Z.$$.fragment,s),Ws=n(s),A=M(s,"P",{"data-svelte-h":!0}),o(A)!=="svelte-tdss46"&&(A.innerHTML=$l),Xs=n(s),G=M(s,"P",{"data-svelte-h":!0}),o(G)!=="svelte-ex8ldy"&&(G.innerHTML=zl),ks=n(s),m(u.$$.fragment,s),_s=n(s),W=M(s,"P",{"data-svelte-h":!0}),o(W)!=="svelte-x3q6hl"&&(W.innerHTML=Yl),vs=n(s),m(X.$$.fragment,s),Vs=n(s),k=M(s,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1c8cv44"&&(k.innerHTML=Ql),Rs=n(s),m(_.$$.fragment,s),Ns=n(s),v=M(s,"P",{"data-svelte-h":!0}),o(v)!=="svelte-17henro"&&(v.textContent=Fl),$s=n(s),m(V.$$.fragment,s),zs=n(s),R=M(s,"P",{"data-svelte-h":!0}),o(R)!=="svelte-sz5qnh"&&(R.innerHTML=Sl),Ys=n(s),m(N.$$.fragment,s),Qs=n(s),m($.$$.fragment,s),Fs=n(s),z=M(s,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1otxl74"&&(z.innerHTML=Hl),Ss=n(s),m(Y.$$.fragment,s),Hs=n(s),m(Q.$$.fragment,s),Es=n(s),F=M(s,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1wj8hyv"&&(F.innerHTML=El),xs=n(s),m(S.$$.fragment,s),Ds=n(s),m(I.$$.fragment,s),qs=n(s),H=M(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1bh16eq"&&(H.innerHTML=xl),Ls=n(s),m(E.$$.fragment,s),Ks=n(s),b=M(s,"DIV",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-1wjbouq"&&(b.innerHTML=Dl),Ps=n(s),x=M(s,"P",{"data-svelte-h":!0}),o(x)!=="svelte-19lli6v"&&(x.textContent=ql),Os=n(s),D=M(s,"UL",{"data-svelte-h":!0}),o(D)!=="svelte-8oirkq"&&(D.innerHTML=Ll),sl=n(s),m(q.$$.fragment,s),ll=n(s),L=M(s,"P",{"data-svelte-h":!0}),o(L)!=="svelte-a1cdro"&&(L.innerHTML=Kl),al=n(s),m(K.$$.fragment,s),el=n(s),P=M(s,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1abv18u"&&(P.innerHTML=Pl),tl=n(s),m(O.$$.fragment,s),nl=n(s),m(ss.$$.fragment,s),pl=n(s),ls=M(s,"P",{"data-svelte-h":!0}),o(ls)!=="svelte-mlq3qn"&&(ls.innerHTML=Ol),Ml=n(s),m(as.$$.fragment,s),il=n(s),es=M(s,"P",{"data-svelte-h":!0}),o(es)!=="svelte-ahjyed"&&(es.textContent=sa),ol=n(s),m(ts.$$.fragment,s),cl=n(s),ns=M(s,"P",{"data-svelte-h":!0}),o(ns)!=="svelte-1hkhok8"&&(ns.textContent=la),ml=n(s),m(ps.$$.fragment,s),jl=n(s),Ms=M(s,"P",{"data-svelte-h":!0}),o(Ms)!=="svelte-31qoa1"&&(Ms.innerHTML=aa),yl=n(s),is=M(s,"P",{"data-svelte-h":!0}),o(is)!=="svelte-1mnclmh"&&(is.innerHTML=ea),rl=n(s),m(os.$$.fragment,s),hl=n(s),g=M(s,"DIV",{class:!0,"data-svelte-h":!0}),o(g)!=="svelte-qcxk5"&&(g.innerHTML=ta),wl=n(s),cs=M(s,"P",{"data-svelte-h":!0}),o(cs)!=="svelte-1pekxga"&&(cs.textContent=na),Jl=n(s),m(ms.$$.fragment,s),Tl=n(s),m(js.$$.fragment,s),Ul=n(s),ys=M(s,"P",{"data-svelte-h":!0}),o(ys)!=="svelte-rpu9md"&&(ys.textContent=pa),dl=n(s),rs=M(s,"P",{"data-svelte-h":!0}),o(rs)!=="svelte-11y5cd5"&&(rs.textContent=Ma),ul=n(s),m(hs.$$.fragment,s),Il=n(s),ws=M(s,"P",{"data-svelte-h":!0}),o(ws)!=="svelte-1iidvjh"&&(ws.innerHTML=ia),bl=n(s),m(Js.$$.fragment,s),gl=n(s),Ts=M(s,"P",{"data-svelte-h":!0}),o(Ts)!=="svelte-13pvon6"&&(Ts.textContent=oa),fl=n(s),m(f.$$.fragment,s),Cl=n(s),m(Us.$$.fragment,s),Bl=n(s),ds=M(s,"P",{"data-svelte-h":!0}),o(ds)!=="svelte-1f597mr"&&(ds.innerHTML=ca),Zl=n(s),m(us.$$.fragment,s),Al=n(s),Is=M(s,"P",{"data-svelte-h":!0}),o(Is)!=="svelte-nz3dg5"&&(Is.textContent=ma),Gl=n(s),m(bs.$$.fragment,s),Wl=n(s),C=M(s,"DIV",{class:!0,"data-svelte-h":!0}),o(C)!=="svelte-tzqtub"&&(C.innerHTML=ja),Xl=n(s),m(gs.$$.fragment,s),kl=n(s),fs=M(s,"P",{"data-svelte-h":!0}),o(fs)!=="svelte-zg9981"&&(fs.innerHTML=ya),_l=n(s),Cs=M(s,"UL",{"data-svelte-h":!0}),o(Cs)!=="svelte-cndhdw"&&(Cs.innerHTML=ra),vl=n(s),Zs=M(s,"P",{}),Ta(Zs).forEach(a),this.h()},h(){As(i,"name","hf:doc:metadata"),As(i,"content",Ga),As(b,"class","flex justify-center"),As(g,"class","flex justify-center"),As(C,"class","flex justify-center")},m(s,l){ga(document.head,i),e(s,T,l),e(s,w,l),e(s,U,l),j(B,s,l),e(s,Gs,l),j(Z,s,l),e(s,Ws,l),e(s,A,l),e(s,Xs,l),e(s,G,l),e(s,ks,l),j(u,s,l),e(s,_s,l),e(s,W,l),e(s,vs,l),j(X,s,l),e(s,Vs,l),e(s,k,l),e(s,Rs,l),j(_,s,l),e(s,Ns,l),e(s,v,l),e(s,$s,l),j(V,s,l),e(s,zs,l),e(s,R,l),e(s,Ys,l),j(N,s,l),e(s,Qs,l),j($,s,l),e(s,Fs,l),e(s,z,l),e(s,Ss,l),j(Y,s,l),e(s,Hs,l),j(Q,s,l),e(s,Es,l),e(s,F,l),e(s,xs,l),j(S,s,l),e(s,Ds,l),j(I,s,l),e(s,qs,l),e(s,H,l),e(s,Ls,l),j(E,s,l),e(s,Ks,l),e(s,b,l),e(s,Ps,l),e(s,x,l),e(s,Os,l),e(s,D,l),e(s,sl,l),j(q,s,l),e(s,ll,l),e(s,L,l),e(s,al,l),j(K,s,l),e(s,el,l),e(s,P,l),e(s,tl,l),j(O,s,l),e(s,nl,l),j(ss,s,l),e(s,pl,l),e(s,ls,l),e(s,Ml,l),j(as,s,l),e(s,il,l),e(s,es,l),e(s,ol,l),j(ts,s,l),e(s,cl,l),e(s,ns,l),e(s,ml,l),j(ps,s,l),e(s,jl,l),e(s,Ms,l),e(s,yl,l),e(s,is,l),e(s,rl,l),j(os,s,l),e(s,hl,l),e(s,g,l),e(s,wl,l),e(s,cs,l),e(s,Jl,l),j(ms,s,l),e(s,Tl,l),j(js,s,l),e(s,Ul,l),e(s,ys,l),e(s,dl,l),e(s,rs,l),e(s,ul,l),j(hs,s,l),e(s,Il,l),e(s,ws,l),e(s,bl,l),j(Js,s,l),e(s,gl,l),e(s,Ts,l),e(s,fl,l),j(f,s,l),e(s,Cl,l),j(Us,s,l),e(s,Bl,l),e(s,ds,l),e(s,Zl,l),j(us,s,l),e(s,Al,l),e(s,Is,l),e(s,Gl,l),j(bs,s,l),e(s,Wl,l),e(s,C,l),e(s,Xl,l),j(gs,s,l),e(s,kl,l),e(s,fs,l),e(s,_l,l),e(s,Cs,l),e(s,vl,l),e(s,Zs,l),Vl=!0},p(s,[l]){const ha={};l&2&&(ha.$$scope={dirty:l,ctx:s}),u.$set(ha);const wa={};l&2&&(wa.$$scope={dirty:l,ctx:s}),I.$set(wa);const Ja={};l&2&&(Ja.$$scope={dirty:l,ctx:s}),f.$set(Ja)},i(s){Vl||(y(B.$$.fragment,s),y(Z.$$.fragment,s),y(u.$$.fragment,s),y(X.$$.fragment,s),y(_.$$.fragment,s),y(V.$$.fragment,s),y(N.$$.fragment,s),y($.$$.fragment,s),y(Y.$$.fragment,s),y(Q.$$.fragment,s),y(S.$$.fragment,s),y(I.$$.fragment,s),y(E.$$.fragment,s),y(q.$$.fragment,s),y(K.$$.fragment,s),y(O.$$.fragment,s),y(ss.$$.fragment,s),y(as.$$.fragment,s),y(ts.$$.fragment,s),y(ps.$$.fragment,s),y(os.$$.fragment,s),y(ms.$$.fragment,s),y(js.$$.fragment,s),y(hs.$$.fragment,s),y(Js.$$.fragment,s),y(f.$$.fragment,s),y(Us.$$.fragment,s),y(us.$$.fragment,s),y(bs.$$.fragment,s),y(gs.$$.fragment,s),Vl=!0)},o(s){r(B.$$.fragment,s),r(Z.$$.fragment,s),r(u.$$.fragment,s),r(X.$$.fragment,s),r(_.$$.fragment,s),r(V.$$.fragment,s),r(N.$$.fragment,s),r($.$$.fragment,s),r(Y.$$.fragment,s),r(Q.$$.fragment,s),r(S.$$.fragment,s),r(I.$$.fragment,s),r(E.$$.fragment,s),r(q.$$.fragment,s),r(K.$$.fragment,s),r(O.$$.fragment,s),r(ss.$$.fragment,s),r(as.$$.fragment,s),r(ts.$$.fragment,s),r(ps.$$.fragment,s),r(os.$$.fragment,s),r(ms.$$.fragment,s),r(js.$$.fragment,s),r(hs.$$.fragment,s),r(Js.$$.fragment,s),r(f.$$.fragment,s),r(Us.$$.fragment,s),r(us.$$.fragment,s),r(bs.$$.fragment,s),r(gs.$$.fragment,s),Vl=!1},d(s){s&&(a(T),a(w),a(U),a(Gs),a(Ws),a(A),a(Xs),a(G),a(ks),a(_s),a(W),a(vs),a(Vs),a(k),a(Rs),a(Ns),a(v),a($s),a(zs),a(R),a(Ys),a(Qs),a(Fs),a(z),a(Ss),a(Hs),a(Es),a(F),a(xs),a(Ds),a(qs),a(H),a(Ls),a(Ks),a(b),a(Ps),a(x),a(Os),a(D),a(sl),a(ll),a(L),a(al),a(el),a(P),a(tl),a(nl),a(pl),a(ls),a(Ml),a(il),a(es),a(ol),a(cl),a(ns),a(ml),a(jl),a(Ms),a(yl),a(is),a(rl),a(hl),a(g),a(wl),a(cs),a(Jl),a(Tl),a(Ul),a(ys),a(dl),a(rs),a(ul),a(Il),a(ws),a(bl),a(gl),a(Ts),a(fl),a(Cl),a(Bl),a(ds),a(Zl),a(Al),a(Is),a(Gl),a(Wl),a(C),a(Xl),a(kl),a(fs),a(_l),a(Cs),a(vl),a(Zs)),a(i),h(B,s),h(Z,s),h(u,s),h(X,s),h(_,s),h(V,s),h(N,s),h($,s),h(Y,s),h(Q,s),h(S,s),h(I,s),h(E,s),h(q,s),h(K,s),h(O,s),h(ss,s),h(as,s),h(ts,s),h(ps,s),h(os,s),h(ms,s),h(js,s),h(hs,s),h(Js,s),h(f,s),h(Us,s),h(us,s),h(bs,s),h(gs,s)}}}const Ga='{"title":"Train a diffusion model","local":"train-a-diffusion-model","sections":[{"title":"Training configuration","local":"training-configuration","sections":[],"depth":2},{"title":"Load the dataset","local":"load-the-dataset","sections":[],"depth":2},{"title":"Create a UNet2DModel","local":"create-a-unet2dmodel","sections":[],"depth":2},{"title":"Create a scheduler","local":"create-a-scheduler","sections":[],"depth":2},{"title":"Train the model","local":"train-the-model","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Wa(d){return da(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Na extends ua{constructor(i){super(),Ia(this,i,Wa,Aa,Ua,{})}}export{Na as component};
