import{s as Ka,o as es,n as X}from"../chunks/scheduler.182ea377.js";import{S as ts,i as ns,g as l,s,r as g,A as as,h as r,f as i,c as o,j as x,u as f,x as y,k as C,y as t,a as c,v as u,d as h,t as _,w as b}from"../chunks/index.abf12888.js";import{T as Gt}from"../chunks/Tip.230e2334.js";import{D as J}from"../chunks/Docstring.93f6f462.js";import{C as Y}from"../chunks/CodeBlock.57fe6e13.js";import{E as St}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as nt}from"../chunks/Heading.16916d63.js";function ss(P){let n,I='For text-to-image we use <code>stabilityai/stable-diffusion-2-1-unclip-small</code> as it was trained on CLIP ViT-L/14 embedding, the same as the Karlo model prior. <a href="https://hf.co/stabilityai/stable-diffusion-2-1-unclip" rel="nofollow">stabilityai/stable-diffusion-2-1-unclip</a> was trained on OpenCLIP ViT-H, so we don’t recommend its use.';return{c(){n=l("p"),n.innerHTML=I},l(d){n=r(d,"P",{"data-svelte-h":!0}),y(n)!=="svelte-1eqlm9k"&&(n.innerHTML=I)},m(d,m){c(d,n,m)},p:X,d(d){d&&i(n)}}}function os(P){let n,I="Examples:",d,m,v;return m=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlVW5DTElQUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlVW5DTElQUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmZ1c2luZyUyRnN0YWJsZS11bmNsaXAtMi0xLWwlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTIwJTIwJTIzJTIwVE9ETyUyMHVwZGF0ZSUyMG1vZGVsJTIwcGF0aCUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQWltYWdlcyUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlMEFpbWFnZXMlNUIwJTVELnNhdmUoJTIyYXN0cm9uYXV0X2hvcnNlLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableUnCLIPPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableUnCLIPPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;fusing/stable-unclip-2-1-l&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)  <span class="hljs-comment"># TODO update model path</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(prompt).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;astronaut_horse.png&quot;</span>)`,wrap:!1}}),{c(){n=l("p"),n.textContent=I,d=s(),g(m.$$.fragment)},l(a){n=r(a,"P",{"data-svelte-h":!0}),y(n)!=="svelte-kvfsh7"&&(n.textContent=I),d=o(a),f(m.$$.fragment,a)},m(a,w){c(a,n,w),c(a,d,w),u(m,a,w),v=!0},p:X,i(a){v||(h(m.$$.fragment,a),v=!0)},o(a){_(m.$$.fragment,a),v=!1},d(a){a&&(i(n),i(d)),b(m,a)}}}function is(P){let n,I=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){n=l("p"),n.innerHTML=I},l(d){n=r(d,"P",{"data-svelte-h":!0}),y(n)!=="svelte-ackzsn"&&(n.innerHTML=I)},m(d,m){c(d,n,m)},p:X,d(d){d&&i(n)}}}function ls(P){let n,I="Examples:",d,m,v;return m=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=l("p"),n.textContent=I,d=s(),g(m.$$.fragment)},l(a){n=r(a,"P",{"data-svelte-h":!0}),y(n)!=="svelte-kvfsh7"&&(n.textContent=I),d=o(a),f(m.$$.fragment,a)},m(a,w){c(a,n,w),c(a,d,w),u(m,a,w),v=!0},p:X,i(a){v||(h(m.$$.fragment,a),v=!0)},o(a){_(m.$$.fragment,a),v=!1},d(a){a&&(i(n),i(d)),b(m,a)}}}function rs(P){let n,I=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){n=l("p"),n.textContent=I},l(d){n=r(d,"P",{"data-svelte-h":!0}),y(n)!=="svelte-17p1lpg"&&(n.textContent=I)},m(d,m){c(d,n,m)},p:X,d(d){d&&i(n)}}}function ps(P){let n,I="Examples:",d,m,v;return m=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){n=l("p"),n.textContent=I,d=s(),g(m.$$.fragment)},l(a){n=r(a,"P",{"data-svelte-h":!0}),y(n)!=="svelte-kvfsh7"&&(n.textContent=I),d=o(a),f(m.$$.fragment,a)},m(a,w){c(a,n,w),c(a,d,w),u(m,a,w),v=!0},p:X,i(a){v||(h(m.$$.fragment,a),v=!0)},o(a){_(m.$$.fragment,a),v=!1},d(a){a&&(i(n),i(d)),b(m,a)}}}function ds(P){let n,I="Examples:",d,m,v;return m=new Y({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlVW5DTElQSW1nMkltZ1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZVVuQ0xJUEltZzJJbWdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZnVzaW5nJTJGc3RhYmxlLXVuY2xpcC0yLTEtbC1pbWcyaW1nJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUyMCUyMCUyMyUyMFRPRE8lMjB1cGRhdGUlMjBtb2RlbCUyMHBhdGglMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uJTJGbWFpbiUyRmFzc2V0cyUyRnN0YWJsZS1zYW1wbGVzJTJGaW1nMmltZyUyRnNrZXRjaC1tb3VudGFpbnMtaW5wdXQuanBnJTIyJTBBJTBBcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBpbml0X2ltYWdlLnJlc2l6ZSgoNzY4JTJDJTIwNTEyKSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwZmFudGFzeSUyMGxhbmRzY2FwZSUyQyUyMHRyZW5kaW5nJTIwb24lMjBhcnRzdGF0aW9uJTIyJTBBJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBpbml0X2ltYWdlKS5pbWFnZXMlMEFpbWFnZXMlNUIwJTVELnNhdmUoJTIyZmFudGFzeV9sYW5kc2NhcGUucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableUnCLIPImg2ImgPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableUnCLIPImg2ImgPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;fusing/stable-unclip-2-1-l-img2img&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)  <span class="hljs-comment"># TODO update model path</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>response = requests.get(url)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = init_image.resize((<span class="hljs-number">768</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A fantasy landscape, trending on artstation&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(prompt, init_image).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;fantasy_landscape.png&quot;</span>)`,wrap:!1}}),{c(){n=l("p"),n.textContent=I,d=s(),g(m.$$.fragment)},l(a){n=r(a,"P",{"data-svelte-h":!0}),y(n)!=="svelte-kvfsh7"&&(n.textContent=I),d=o(a),f(m.$$.fragment,a)},m(a,w){c(a,n,w),c(a,d,w),u(m,a,w),v=!0},p:X,i(a){v||(h(m.$$.fragment,a),v=!0)},o(a){_(m.$$.fragment,a),v=!1},d(a){a&&(i(n),i(d)),b(m,a)}}}function ms(P){let n,I=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){n=l("p"),n.innerHTML=I},l(d){n=r(d,"P",{"data-svelte-h":!0}),y(n)!=="svelte-ackzsn"&&(n.innerHTML=I)},m(d,m){c(d,n,m)},p:X,d(d){d&&i(n)}}}function cs(P){let n,I="Examples:",d,m,v;return m=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=l("p"),n.textContent=I,d=s(),g(m.$$.fragment)},l(a){n=r(a,"P",{"data-svelte-h":!0}),y(n)!=="svelte-kvfsh7"&&(n.textContent=I),d=o(a),f(m.$$.fragment,a)},m(a,w){c(a,n,w),c(a,d,w),u(m,a,w),v=!0},p:X,i(a){v||(h(m.$$.fragment,a),v=!0)},o(a){_(m.$$.fragment,a),v=!1},d(a){a&&(i(n),i(d)),b(m,a)}}}function gs(P){let n,I=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){n=l("p"),n.textContent=I},l(d){n=r(d,"P",{"data-svelte-h":!0}),y(n)!=="svelte-17p1lpg"&&(n.textContent=I)},m(d,m){c(d,n,m)},p:X,d(d){d&&i(n)}}}function fs(P){let n,I="Examples:",d,m,v;return m=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){n=l("p"),n.textContent=I,d=s(),g(m.$$.fragment)},l(a){n=r(a,"P",{"data-svelte-h":!0}),y(n)!=="svelte-kvfsh7"&&(n.textContent=I),d=o(a),f(m.$$.fragment,a)},m(a,w){c(a,n,w),c(a,d,w),u(m,a,w),v=!0},p:X,i(a){v||(h(m.$$.fragment,a),v=!0)},o(a){_(m.$$.fragment,a),v=!1},d(a){a&&(i(n),i(d)),b(m,a)}}}function us(P){let n,I,d,m,v,a,w,ha=`Stable unCLIP checkpoints are finetuned from <a href="./stable_diffusion/stable_diffusion_2">Stable Diffusion 2.1</a> checkpoints to condition on CLIP image embeddings.
Stable unCLIP still conditions on text embeddings. Given the two separate conditionings, stable unCLIP can be used
for text guided image variation. When combined with an unCLIP prior, it can also be used for full text to image generation.`,Bt,he,_a="The abstract from the paper is:",Vt,_e,ba="<em>Contrastive models like CLIP have been shown to learn robust representations of images that capture both semantics and style. To leverage these representations for image generation, we propose a two-stage model: a prior that generates a CLIP image embedding given a text caption, and a decoder that generates an image conditioned on the image embedding. We show that explicitly generating image representations improves image diversity with minimal loss in photorealism and caption similarity. Our decoders conditioned on image representations can also produce variations of an image that preserve both its semantics and style, while varying the non-essential details absent from the image representation. Moreover, the joint embedding space of CLIP enables language-guided image manipulations in a zero-shot fashion. We use diffusion models for the decoder and experiment with both autoregressive and diffusion models for the prior, finding that the latter are computationally more efficient and produce higher-quality samples.</em>",Nt,be,Xt,ye,ya=`Stable unCLIP takes  <code>noise_level</code> as input during inference which determines how much noise is added
to the image embeddings. A higher <code>noise_level</code> increases variation in the final un-noised images. By default,
we do not add any additional noise to the image embeddings (<code>noise_level = 0</code>).`,Ft,Ie,Et,ve,Ia='Stable unCLIP can be leveraged for text-to-image generation by pipelining it with the prior model of KakaoBrain’s open source DALL-E 2 replication <a href="https://huggingface.co/kakaobrain/karlo-v1-alpha" rel="nofollow">Karlo</a>',zt,we,Rt,H,Yt,Te,Ht,$e,Qt,Me,va="Optionally, you can also pass a prompt to <code>pipe</code> such as:",Dt,Ue,At,Pe,qt,T,xe,mn,at,wa="Pipeline for text-to-image generation using stable unCLIP.",cn,st,Ta=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,gn,F,Ce,fn,ot,$a="The call function to the pipeline for generation.",un,Q,hn,W,Je,_n,it,Ma=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,bn,D,yn,A,In,q,Le,vn,lt,Ua=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,wn,O,je,Tn,rt,Pa=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,$n,K,Ze,Mn,pt,xa=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Un,S,We,Pn,dt,Ca=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,xn,ee,Cn,te,Jn,ne,Se,Ln,mt,Ja='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',jn,ae,ke,Zn,ct,La="Encodes the prompt into text encoder hidden states.",Wn,L,Ge,Sn,gt,ja=`Add noise to the image embeddings. The amount of noise is controlled by a <code>noise_level</code> input. A higher
<code>noise_level</code> increases the variance in the final un-noised images.`,kn,ft,Za="The noise is applied in two ways:",Gn,ut,Wa="<li>A noise schedule is applied directly to the embeddings.</li> <li>A vector of sinusoidal time embeddings are appended to the output.</li>",Bn,ht,Sa="In both cases, the amount of noise is controlled by the same <code>noise_level</code>.",Vn,_t,ka="The embeddings are normalized before the noise is applied and un-normalized after the noise is applied.",Ot,Be,Kt,$,Ve,Nn,bt,Ga="Pipeline for text-guided image-to-image generation using stable unCLIP.",Xn,yt,Ba=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Fn,E,Ne,En,It,Va="The call function to the pipeline for generation.",zn,se,Rn,k,Xe,Yn,vt,Na=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,Hn,oe,Qn,ie,Dn,le,Fe,An,wt,Xa=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,qn,re,Ee,On,Tt,Fa=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Kn,pe,ze,ea,$t,Ea=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,ta,G,Re,na,Mt,za=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,aa,de,sa,me,oa,ce,Ye,ia,Ut,Ra='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',la,ge,He,ra,Pt,Ya="Encodes the prompt into text encoder hidden states.",pa,j,Qe,da,xt,Ha=`Add noise to the image embeddings. The amount of noise is controlled by a <code>noise_level</code> input. A higher
<code>noise_level</code> increases the variance in the final un-noised images.`,ma,Ct,Qa="The noise is applied in two ways:",ca,Jt,Da="<li>A noise schedule is applied directly to the embeddings.</li> <li>A vector of sinusoidal time embeddings are appended to the output.</li>",ga,Lt,Aa="In both cases, the amount of noise is controlled by the same <code>noise_level</code>.",fa,jt,qa="The embeddings are normalized before the noise is applied and un-normalized after the noise is applied.",en,De,tn,z,Ae,ua,Zt,Oa="Output class for image pipelines.",nn,kt,an;return v=new nt({props:{title:"Stable unCLIP",local:"stable-unclip",headingTag:"h1"}}),be=new nt({props:{title:"Tips",local:"tips",headingTag:"h2"}}),Ie=new nt({props:{title:"Text-to-Image Generation",local:"text-to-image-generation",headingTag:"h3"}}),we=new Y({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UnCLIPScheduler, DDPMScheduler, StableUnCLIPPipeline
<span class="hljs-keyword">from</span> diffusers.models <span class="hljs-keyword">import</span> PriorTransformer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPTokenizer, CLIPTextModelWithProjection

prior_model_id = <span class="hljs-string">&quot;kakaobrain/karlo-v1-alpha&quot;</span>
data_type = torch.float16
prior = PriorTransformer.from_pretrained(prior_model_id, subfolder=<span class="hljs-string">&quot;prior&quot;</span>, torch_dtype=data_type)

prior_text_model_id = <span class="hljs-string">&quot;openai/clip-vit-large-patch14&quot;</span>
prior_tokenizer = CLIPTokenizer.from_pretrained(prior_text_model_id)
prior_text_model = CLIPTextModelWithProjection.from_pretrained(prior_text_model_id, torch_dtype=data_type)
prior_scheduler = UnCLIPScheduler.from_pretrained(prior_model_id, subfolder=<span class="hljs-string">&quot;prior_scheduler&quot;</span>)
prior_scheduler = DDPMScheduler.from_config(prior_scheduler.config)

stable_unclip_model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1-unclip-small&quot;</span>

pipe = StableUnCLIPPipeline.from_pretrained(
    stable_unclip_model_id,
    torch_dtype=data_type,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
    prior_tokenizer=prior_tokenizer,
    prior_text_encoder=prior_text_model,
    prior=prior,
    prior_scheduler=prior_scheduler,
)

pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
wave_prompt = <span class="hljs-string">&quot;dramatic wave, the Oceans roar, Strong wave spiral across the oceans as the waves unfurl into roaring crests; perfect wave form; perfect wave shape; dramatic wave shape; wave shape unbelievable; wave; wave shape spectacular&quot;</span>

images = pipe(prompt=wave_prompt).images
images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;waves.png&quot;</span>)`,wrap:!1}}),H=new Gt({props:{warning:!0,$$slots:{default:[ss]},$$scope:{ctx:P}}}),Te=new nt({props:{title:"Text guided Image-to-Image Variation",local:"text-guided-image-to-image-variation",headingTag:"h3"}}),$e=new Y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZVVuQ0xJUEltZzJJbWdQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlVW5DTElQSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi0xLXVuY2xpcCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhdGlvbiUzRCUyMmZwMTYlMjIlMEEpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGc3RhYmxlX3VuY2xpcCUyRnRhcnNpbGFfZG9fYW1hcmFsLnBuZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCklMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKGluaXRfaW1hZ2UpLmltYWdlcyUwQWltYWdlcyU1QjAlNUQuc2F2ZSglMjJ2YXJpYXRpb25faW1hZ2UucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableUnCLIPImg2ImgPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipe = StableUnCLIPImg2ImgPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1-unclip&quot;</span>, torch_dtype=torch.float16, variation=<span class="hljs-string">&quot;fp16&quot;</span>
)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/stable_unclip/tarsila_do_amaral.png&quot;</span>
init_image = load_image(url)

images = pipe(init_image).images
images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;variation_image.png&quot;</span>)`,wrap:!1}}),Ue=new Y({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyQSUyMGZhbnRhc3klMjBsYW5kc2NhcGUlMkMlMjB0cmVuZGluZyUyMG9uJTIwYXJ0c3RhdGlvbiUyMiUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGUoaW5pdF9pbWFnZSUyQyUyMHByb21wdCUzRHByb21wdCkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RC5zYXZlKCUyMnZhcmlhdGlvbl9pbWFnZV90d28ucG5nJTIyKQ==",highlighted:`prompt = <span class="hljs-string">&quot;A fantasy landscape, trending on artstation&quot;</span>

images = pipe(init_image, prompt=prompt).images
images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;variation_image_two.png&quot;</span>)`,wrap:!1}}),Pe=new nt({props:{title:"StableUnCLIPPipeline",local:"diffusers.StableUnCLIPPipeline",headingTag:"h2"}}),xe=new J({props:{name:"class diffusers.StableUnCLIPPipeline",anchor:"diffusers.StableUnCLIPPipeline",parameters:[{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior",val:": PriorTransformer"},{name:"prior_scheduler",val:": KarrasDiffusionSchedulers"},{name:"image_normalizer",val:": StableUnCLIPImageNormalizer"},{name:"image_noising_scheduler",val:": KarrasDiffusionSchedulers"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder",val:": CLIPTextModelWithProjection"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"vae",val:": AutoencoderKL"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <code>CLIPTokenizer</code>.`,name:"prior_tokenizer"},{anchor:"diffusers.StableUnCLIPPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen <code>CLIPTextModelWithProjection</code> text-encoder.`,name:"prior_text_encoder"},{anchor:"diffusers.StableUnCLIPPipeline.prior",description:`<strong>prior</strong> (<a href="/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonincal unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior"},{anchor:"diffusers.StableUnCLIPPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>KarrasDiffusionSchedulers</code>) &#x2014;
Scheduler used in the prior denoising process.`,name:"prior_scheduler"},{anchor:"diffusers.StableUnCLIPPipeline.image_normalizer",description:`<strong>image_normalizer</strong> (<code>StableUnCLIPImageNormalizer</code>) &#x2014;
Used to normalize the predicted image embeddings before the noise is applied and un-normalize the image
embeddings after the noise has been applied.`,name:"image_normalizer"},{anchor:"diffusers.StableUnCLIPPipeline.image_noising_scheduler",description:`<strong>image_noising_scheduler</strong> (<code>KarrasDiffusionSchedulers</code>) &#x2014;
Noise schedule for adding noise to the predicted image embeddings. The amount of noise to add is determined
by the <code>noise_level</code>.`,name:"image_noising_scheduler"},{anchor:"diffusers.StableUnCLIPPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <code>CLIPTokenizer</code>.`,name:"tokenizer"},{anchor:"diffusers.StableUnCLIPPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen <code>CLIPTextModel</code> text-encoder.`,name:"text_encoder"},{anchor:"diffusers.StableUnCLIPPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableUnCLIPPipeline.scheduler",description:`<strong>scheduler</strong> (<code>KarrasDiffusionSchedulers</code>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.StableUnCLIPPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip.py#L61"}}),Ce=new J({props:{name:"__call__",anchor:"diffusers.StableUnCLIPPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 20"},{name:"guidance_scale",val:": float = 10.0"},{name:"negative_prompt",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Optional[torch._C.Generator] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"noise_level",val:": int = 0"},{name:"prior_num_inference_steps",val:": int = 25"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"prior_latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 10.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/ddim#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.noise_level",description:`<strong>noise_level</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
The amount of noise to add to the image embeddings. A higher <code>noise_level</code> increases the variance in
the final un-noised images. See <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.StableUnCLIPPipeline.noise_image_embeddings">StableUnCLIPPipeline.noise_image_embeddings()</a> for more details.`,name:"noise_level"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 25) &#x2014;
The number of denoising steps in the prior denoising process. More denoising steps usually lead to a
higher quality image at the expense of slower inference.`,name:"prior_num_inference_steps"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"prior_guidance_scale"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.prior_latents",description:`<strong>prior_latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
embedding generation in the prior denoising process. Can be used to tweak the same generation with
different prompts. If not provided, a latents tensor is generated by sampling using the supplied random
<code>generator</code>.`,name:"prior_latents"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip.py#L644",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~ pipeline_utils.ImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When returning
a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/ddim#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),Q=new St({props:{anchor:"diffusers.StableUnCLIPPipeline.__call__.example",$$slots:{default:[os]},$$scope:{ctx:P}}}),Je=new J({props:{name:"enable_attention_slicing",anchor:"diffusers.StableUnCLIPPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": typing.Union[str, int, NoneType] = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2038"}}),D=new Gt({props:{warning:!0,$$slots:{default:[is]},$$scope:{ctx:P}}}),A=new St({props:{anchor:"diffusers.StableUnCLIPPipeline.enable_attention_slicing.example",$$slots:{default:[ls]},$$scope:{ctx:P}}}),Le=new J({props:{name:"disable_attention_slicing",anchor:"diffusers.StableUnCLIPPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2078"}}),je=new J({props:{name:"enable_vae_slicing",anchor:"diffusers.StableUnCLIPPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip.py#L154"}}),Ze=new J({props:{name:"disable_vae_slicing",anchor:"diffusers.StableUnCLIPPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip.py#L162"}}),We=new J({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableUnCLIPPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1977"}}),ee=new Gt({props:{warning:!0,$$slots:{default:[rs]},$$scope:{ctx:P}}}),te=new St({props:{anchor:"diffusers.StableUnCLIPPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[ps]},$$scope:{ctx:P}}}),Se=new J({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableUnCLIPPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2012"}}),ke=new J({props:{name:"encode_prompt",anchor:"diffusers.StableUnCLIPPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip.py#L297"}}),Ge=new J({props:{name:"noise_image_embeddings",anchor:"diffusers.StableUnCLIPPipeline.noise_image_embeddings",parameters:[{name:"image_embeds",val:": Tensor"},{name:"noise_level",val:": int"},{name:"noise",val:": typing.Optional[torch.FloatTensor] = None"},{name:"generator",val:": typing.Optional[torch._C.Generator] = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip.py#L598"}}),Be=new nt({props:{title:"StableUnCLIPImg2ImgPipeline",local:"diffusers.StableUnCLIPImg2ImgPipeline",headingTag:"h2"}}),Ve=new J({props:{name:"class diffusers.StableUnCLIPImg2ImgPipeline",anchor:"diffusers.StableUnCLIPImg2ImgPipeline",parameters:[{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"image_normalizer",val:": StableUnCLIPImageNormalizer"},{name:"image_noising_scheduler",val:": KarrasDiffusionSchedulers"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder",val:": CLIPTextModel"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"vae",val:": AutoencoderKL"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
Feature extractor for image pre-processing before being encoded.`,name:"feature_extractor"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
CLIP vision model for encoding images.`,name:"image_encoder"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.image_normalizer",description:`<strong>image_normalizer</strong> (<code>StableUnCLIPImageNormalizer</code>) &#x2014;
Used to normalize the predicted image embeddings before the noise is applied and un-normalize the image
embeddings after the noise has been applied.`,name:"image_normalizer"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.image_noising_scheduler",description:`<strong>image_noising_scheduler</strong> (<code>KarrasDiffusionSchedulers</code>) &#x2014;
Noise schedule for adding noise to the predicted image embeddings. The amount of noise to add is determined
by the <code>noise_level</code>.`,name:"image_noising_scheduler"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>~transformers.CLIPTokenizer</code>) &#x2014;
A [<code>~transformers.CLIPTokenizer</code>)].`,name:"tokenizer"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a> text-encoder.`,name:"text_encoder"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<code>KarrasDiffusionSchedulers</code>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip_img2img.py#L72"}}),Ne=new J({props:{name:"__call__",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__",parameters:[{name:"image",val:": typing.Union[torch.FloatTensor, PIL.Image.Image] = None"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 20"},{name:"guidance_scale",val:": float = 10"},{name:"negative_prompt",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Optional[torch._C.Generator] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"noise_level",val:": int = 0"},{name:"image_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, either <code>prompt_embeds</code> will be
used or prompt is initialized to <code>&quot;&quot;</code>.`,name:"prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code> or <code>PIL.Image.Image</code>) &#x2014;
<code>Image</code> or tensor representing an image batch. The image is encoded to its CLIP embedding which the
<code>unet</code> is conditioned on. The image is <em>not</em> encoded by the <code>vae</code> and then used as the latents in the
denoising process like it is in the standard Stable Diffusion text-guided image variation process.`,name:"image"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 10.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/ddim#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.noise_level",description:`<strong>noise_level</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
The amount of noise to add to the image embeddings. A higher <code>noise_level</code> increases the variance in
the final un-noised images. See <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.StableUnCLIPPipeline.noise_image_embeddings">StableUnCLIPPipeline.noise_image_embeddings()</a> for more details.`,name:"noise_level"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated CLIP embeddings to condition the <code>unet</code> on. These latents are not used in the denoising
process. If you want to provide pre-generated latents, pass them to <code>__call__</code> as <code>latents</code>.`,name:"image_embeds"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip_img2img.py#L618",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~ pipeline_utils.ImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When returning
a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/ddim#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),se=new St({props:{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.example",$$slots:{default:[ds]},$$scope:{ctx:P}}}),Xe=new J({props:{name:"enable_attention_slicing",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": typing.Union[str, int, NoneType] = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2038"}}),oe=new Gt({props:{warning:!0,$$slots:{default:[ms]},$$scope:{ctx:P}}}),ie=new St({props:{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_attention_slicing.example",$$slots:{default:[cs]},$$scope:{ctx:P}}}),Fe=new J({props:{name:"disable_attention_slicing",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2078"}}),Ee=new J({props:{name:"enable_vae_slicing",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip_img2img.py#L155"}}),ze=new J({props:{name:"disable_vae_slicing",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip_img2img.py#L163"}}),Re=new J({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1977"}}),de=new Gt({props:{warning:!0,$$slots:{default:[gs]},$$scope:{ctx:P}}}),me=new St({props:{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[fs]},$$scope:{ctx:P}}}),Ye=new J({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2012"}}),He=new J({props:{name:"encode_prompt",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip_img2img.py#L259"}}),Qe=new J({props:{name:"noise_image_embeddings",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.noise_image_embeddings",parameters:[{name:"image_embeds",val:": Tensor"},{name:"noise_level",val:": int"},{name:"noise",val:": typing.Optional[torch.FloatTensor] = None"},{name:"generator",val:": typing.Optional[torch._C.Generator] = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip_img2img.py#L572"}}),De=new nt({props:{title:"ImagePipelineOutput",local:"diffusers.ImagePipelineOutput",headingTag:"h2"}}),Ae=new J({props:{name:"class diffusers.ImagePipelineOutput",anchor:"diffusers.ImagePipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"}],parametersDescription:[{anchor:"diffusers.ImagePipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L111"}}),{c(){n=l("meta"),I=s(),d=l("p"),m=s(),g(v.$$.fragment),a=s(),w=l("p"),w.innerHTML=ha,Bt=s(),he=l("p"),he.textContent=_a,Vt=s(),_e=l("p"),_e.innerHTML=ba,Nt=s(),g(be.$$.fragment),Xt=s(),ye=l("p"),ye.innerHTML=ya,Ft=s(),g(Ie.$$.fragment),Et=s(),ve=l("p"),ve.innerHTML=Ia,zt=s(),g(we.$$.fragment),Rt=s(),g(H.$$.fragment),Yt=s(),g(Te.$$.fragment),Ht=s(),g($e.$$.fragment),Qt=s(),Me=l("p"),Me.innerHTML=va,Dt=s(),g(Ue.$$.fragment),At=s(),g(Pe.$$.fragment),qt=s(),T=l("div"),g(xe.$$.fragment),mn=s(),at=l("p"),at.textContent=wa,cn=s(),st=l("p"),st.innerHTML=Ta,gn=s(),F=l("div"),g(Ce.$$.fragment),fn=s(),ot=l("p"),ot.textContent=$a,un=s(),g(Q.$$.fragment),hn=s(),W=l("div"),g(Je.$$.fragment),_n=s(),it=l("p"),it.textContent=Ma,bn=s(),g(D.$$.fragment),yn=s(),g(A.$$.fragment),In=s(),q=l("div"),g(Le.$$.fragment),vn=s(),lt=l("p"),lt.innerHTML=Ua,wn=s(),O=l("div"),g(je.$$.fragment),Tn=s(),rt=l("p"),rt.textContent=Pa,$n=s(),K=l("div"),g(Ze.$$.fragment),Mn=s(),pt=l("p"),pt.innerHTML=xa,Un=s(),S=l("div"),g(We.$$.fragment),Pn=s(),dt=l("p"),dt.innerHTML=Ca,xn=s(),g(ee.$$.fragment),Cn=s(),g(te.$$.fragment),Jn=s(),ne=l("div"),g(Se.$$.fragment),Ln=s(),mt=l("p"),mt.innerHTML=Ja,jn=s(),ae=l("div"),g(ke.$$.fragment),Zn=s(),ct=l("p"),ct.textContent=La,Wn=s(),L=l("div"),g(Ge.$$.fragment),Sn=s(),gt=l("p"),gt.innerHTML=ja,kn=s(),ft=l("p"),ft.textContent=Za,Gn=s(),ut=l("ol"),ut.innerHTML=Wa,Bn=s(),ht=l("p"),ht.innerHTML=Sa,Vn=s(),_t=l("p"),_t.textContent=ka,Ot=s(),g(Be.$$.fragment),Kt=s(),$=l("div"),g(Ve.$$.fragment),Nn=s(),bt=l("p"),bt.textContent=Ga,Xn=s(),yt=l("p"),yt.innerHTML=Ba,Fn=s(),E=l("div"),g(Ne.$$.fragment),En=s(),It=l("p"),It.textContent=Va,zn=s(),g(se.$$.fragment),Rn=s(),k=l("div"),g(Xe.$$.fragment),Yn=s(),vt=l("p"),vt.textContent=Na,Hn=s(),g(oe.$$.fragment),Qn=s(),g(ie.$$.fragment),Dn=s(),le=l("div"),g(Fe.$$.fragment),An=s(),wt=l("p"),wt.innerHTML=Xa,qn=s(),re=l("div"),g(Ee.$$.fragment),On=s(),Tt=l("p"),Tt.textContent=Fa,Kn=s(),pe=l("div"),g(ze.$$.fragment),ea=s(),$t=l("p"),$t.innerHTML=Ea,ta=s(),G=l("div"),g(Re.$$.fragment),na=s(),Mt=l("p"),Mt.innerHTML=za,aa=s(),g(de.$$.fragment),sa=s(),g(me.$$.fragment),oa=s(),ce=l("div"),g(Ye.$$.fragment),ia=s(),Ut=l("p"),Ut.innerHTML=Ra,la=s(),ge=l("div"),g(He.$$.fragment),ra=s(),Pt=l("p"),Pt.textContent=Ya,pa=s(),j=l("div"),g(Qe.$$.fragment),da=s(),xt=l("p"),xt.innerHTML=Ha,ma=s(),Ct=l("p"),Ct.textContent=Qa,ca=s(),Jt=l("ol"),Jt.innerHTML=Da,ga=s(),Lt=l("p"),Lt.innerHTML=Aa,fa=s(),jt=l("p"),jt.textContent=qa,en=s(),g(De.$$.fragment),tn=s(),z=l("div"),g(Ae.$$.fragment),ua=s(),Zt=l("p"),Zt.textContent=Oa,nn=s(),kt=l("p"),this.h()},l(e){const p=as("svelte-u9bgzb",document.head);n=r(p,"META",{name:!0,content:!0}),p.forEach(i),I=o(e),d=r(e,"P",{}),x(d).forEach(i),m=o(e),f(v.$$.fragment,e),a=o(e),w=r(e,"P",{"data-svelte-h":!0}),y(w)!=="svelte-bd6hsa"&&(w.innerHTML=ha),Bt=o(e),he=r(e,"P",{"data-svelte-h":!0}),y(he)!=="svelte-1cwsb16"&&(he.textContent=_a),Vt=o(e),_e=r(e,"P",{"data-svelte-h":!0}),y(_e)!=="svelte-ha34c8"&&(_e.innerHTML=ba),Nt=o(e),f(be.$$.fragment,e),Xt=o(e),ye=r(e,"P",{"data-svelte-h":!0}),y(ye)!=="svelte-30kfzk"&&(ye.innerHTML=ya),Ft=o(e),f(Ie.$$.fragment,e),Et=o(e),ve=r(e,"P",{"data-svelte-h":!0}),y(ve)!=="svelte-1i5fgej"&&(ve.innerHTML=Ia),zt=o(e),f(we.$$.fragment,e),Rt=o(e),f(H.$$.fragment,e),Yt=o(e),f(Te.$$.fragment,e),Ht=o(e),f($e.$$.fragment,e),Qt=o(e),Me=r(e,"P",{"data-svelte-h":!0}),y(Me)!=="svelte-1mvqeru"&&(Me.innerHTML=va),Dt=o(e),f(Ue.$$.fragment,e),At=o(e),f(Pe.$$.fragment,e),qt=o(e),T=r(e,"DIV",{class:!0});var M=x(T);f(xe.$$.fragment,M),mn=o(M),at=r(M,"P",{"data-svelte-h":!0}),y(at)!=="svelte-2c89j6"&&(at.textContent=wa),cn=o(M),st=r(M,"P",{"data-svelte-h":!0}),y(st)!=="svelte-496sm0"&&(st.innerHTML=Ta),gn=o(M),F=r(M,"DIV",{class:!0});var R=x(F);f(Ce.$$.fragment,R),fn=o(R),ot=r(R,"P",{"data-svelte-h":!0}),y(ot)!=="svelte-50j04k"&&(ot.textContent=$a),un=o(R),f(Q.$$.fragment,R),R.forEach(i),hn=o(M),W=r(M,"DIV",{class:!0});var V=x(W);f(Je.$$.fragment,V),_n=o(V),it=r(V,"P",{"data-svelte-h":!0}),y(it)!=="svelte-10jaql7"&&(it.textContent=Ma),bn=o(V),f(D.$$.fragment,V),yn=o(V),f(A.$$.fragment,V),V.forEach(i),In=o(M),q=r(M,"DIV",{class:!0});var qe=x(q);f(Le.$$.fragment,qe),vn=o(qe),lt=r(qe,"P",{"data-svelte-h":!0}),y(lt)!=="svelte-1lh0nh5"&&(lt.innerHTML=Ua),qe.forEach(i),wn=o(M),O=r(M,"DIV",{class:!0});var Oe=x(O);f(je.$$.fragment,Oe),Tn=o(Oe),rt=r(Oe,"P",{"data-svelte-h":!0}),y(rt)!=="svelte-14bnrb6"&&(rt.textContent=Pa),Oe.forEach(i),$n=o(M),K=r(M,"DIV",{class:!0});var Ke=x(K);f(Ze.$$.fragment,Ke),Mn=o(Ke),pt=r(Ke,"P",{"data-svelte-h":!0}),y(pt)!=="svelte-1s3c06i"&&(pt.innerHTML=xa),Ke.forEach(i),Un=o(M),S=r(M,"DIV",{class:!0});var N=x(S);f(We.$$.fragment,N),Pn=o(N),dt=r(N,"P",{"data-svelte-h":!0}),y(dt)!=="svelte-e03q3e"&&(dt.innerHTML=Ca),xn=o(N),f(ee.$$.fragment,N),Cn=o(N),f(te.$$.fragment,N),N.forEach(i),Jn=o(M),ne=r(M,"DIV",{class:!0});var et=x(ne);f(Se.$$.fragment,et),Ln=o(et),mt=r(et,"P",{"data-svelte-h":!0}),y(mt)!=="svelte-1vfte1e"&&(mt.innerHTML=Ja),et.forEach(i),jn=o(M),ae=r(M,"DIV",{class:!0});var tt=x(ae);f(ke.$$.fragment,tt),Zn=o(tt),ct=r(tt,"P",{"data-svelte-h":!0}),y(ct)!=="svelte-16q0ax1"&&(ct.textContent=La),tt.forEach(i),Wn=o(M),L=r(M,"DIV",{class:!0});var Z=x(L);f(Ge.$$.fragment,Z),Sn=o(Z),gt=r(Z,"P",{"data-svelte-h":!0}),y(gt)!=="svelte-1e71opl"&&(gt.innerHTML=ja),kn=o(Z),ft=r(Z,"P",{"data-svelte-h":!0}),y(ft)!=="svelte-acyrt"&&(ft.textContent=Za),Gn=o(Z),ut=r(Z,"OL",{"data-svelte-h":!0}),y(ut)!=="svelte-114uhci"&&(ut.innerHTML=Wa),Bn=o(Z),ht=r(Z,"P",{"data-svelte-h":!0}),y(ht)!=="svelte-46dthp"&&(ht.innerHTML=Sa),Vn=o(Z),_t=r(Z,"P",{"data-svelte-h":!0}),y(_t)!=="svelte-4ngutd"&&(_t.textContent=ka),Z.forEach(i),M.forEach(i),Ot=o(e),f(Be.$$.fragment,e),Kt=o(e),$=r(e,"DIV",{class:!0});var U=x($);f(Ve.$$.fragment,U),Nn=o(U),bt=r(U,"P",{"data-svelte-h":!0}),y(bt)!=="svelte-y15i80"&&(bt.textContent=Ga),Xn=o(U),yt=r(U,"P",{"data-svelte-h":!0}),y(yt)!=="svelte-496sm0"&&(yt.innerHTML=Ba),Fn=o(U),E=r(U,"DIV",{class:!0});var Wt=x(E);f(Ne.$$.fragment,Wt),En=o(Wt),It=r(Wt,"P",{"data-svelte-h":!0}),y(It)!=="svelte-50j04k"&&(It.textContent=Va),zn=o(Wt),f(se.$$.fragment,Wt),Wt.forEach(i),Rn=o(U),k=r(U,"DIV",{class:!0});var fe=x(k);f(Xe.$$.fragment,fe),Yn=o(fe),vt=r(fe,"P",{"data-svelte-h":!0}),y(vt)!=="svelte-10jaql7"&&(vt.textContent=Na),Hn=o(fe),f(oe.$$.fragment,fe),Qn=o(fe),f(ie.$$.fragment,fe),fe.forEach(i),Dn=o(U),le=r(U,"DIV",{class:!0});var sn=x(le);f(Fe.$$.fragment,sn),An=o(sn),wt=r(sn,"P",{"data-svelte-h":!0}),y(wt)!=="svelte-1lh0nh5"&&(wt.innerHTML=Xa),sn.forEach(i),qn=o(U),re=r(U,"DIV",{class:!0});var on=x(re);f(Ee.$$.fragment,on),On=o(on),Tt=r(on,"P",{"data-svelte-h":!0}),y(Tt)!=="svelte-14bnrb6"&&(Tt.textContent=Fa),on.forEach(i),Kn=o(U),pe=r(U,"DIV",{class:!0});var ln=x(pe);f(ze.$$.fragment,ln),ea=o(ln),$t=r(ln,"P",{"data-svelte-h":!0}),y($t)!=="svelte-1s3c06i"&&($t.innerHTML=Ea),ln.forEach(i),ta=o(U),G=r(U,"DIV",{class:!0});var ue=x(G);f(Re.$$.fragment,ue),na=o(ue),Mt=r(ue,"P",{"data-svelte-h":!0}),y(Mt)!=="svelte-e03q3e"&&(Mt.innerHTML=za),aa=o(ue),f(de.$$.fragment,ue),sa=o(ue),f(me.$$.fragment,ue),ue.forEach(i),oa=o(U),ce=r(U,"DIV",{class:!0});var rn=x(ce);f(Ye.$$.fragment,rn),ia=o(rn),Ut=r(rn,"P",{"data-svelte-h":!0}),y(Ut)!=="svelte-1vfte1e"&&(Ut.innerHTML=Ra),rn.forEach(i),la=o(U),ge=r(U,"DIV",{class:!0});var pn=x(ge);f(He.$$.fragment,pn),ra=o(pn),Pt=r(pn,"P",{"data-svelte-h":!0}),y(Pt)!=="svelte-16q0ax1"&&(Pt.textContent=Ya),pn.forEach(i),pa=o(U),j=r(U,"DIV",{class:!0});var B=x(j);f(Qe.$$.fragment,B),da=o(B),xt=r(B,"P",{"data-svelte-h":!0}),y(xt)!=="svelte-1e71opl"&&(xt.innerHTML=Ha),ma=o(B),Ct=r(B,"P",{"data-svelte-h":!0}),y(Ct)!=="svelte-acyrt"&&(Ct.textContent=Qa),ca=o(B),Jt=r(B,"OL",{"data-svelte-h":!0}),y(Jt)!=="svelte-114uhci"&&(Jt.innerHTML=Da),ga=o(B),Lt=r(B,"P",{"data-svelte-h":!0}),y(Lt)!=="svelte-46dthp"&&(Lt.innerHTML=Aa),fa=o(B),jt=r(B,"P",{"data-svelte-h":!0}),y(jt)!=="svelte-4ngutd"&&(jt.textContent=qa),B.forEach(i),U.forEach(i),en=o(e),f(De.$$.fragment,e),tn=o(e),z=r(e,"DIV",{class:!0});var dn=x(z);f(Ae.$$.fragment,dn),ua=o(dn),Zt=r(dn,"P",{"data-svelte-h":!0}),y(Zt)!=="svelte-19wetgi"&&(Zt.textContent=Oa),dn.forEach(i),nn=o(e),kt=r(e,"P",{}),x(kt).forEach(i),this.h()},h(){C(n,"name","hf:doc:metadata"),C(n,"content",hs),C(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){t(document.head,n),c(e,I,p),c(e,d,p),c(e,m,p),u(v,e,p),c(e,a,p),c(e,w,p),c(e,Bt,p),c(e,he,p),c(e,Vt,p),c(e,_e,p),c(e,Nt,p),u(be,e,p),c(e,Xt,p),c(e,ye,p),c(e,Ft,p),u(Ie,e,p),c(e,Et,p),c(e,ve,p),c(e,zt,p),u(we,e,p),c(e,Rt,p),u(H,e,p),c(e,Yt,p),u(Te,e,p),c(e,Ht,p),u($e,e,p),c(e,Qt,p),c(e,Me,p),c(e,Dt,p),u(Ue,e,p),c(e,At,p),u(Pe,e,p),c(e,qt,p),c(e,T,p),u(xe,T,null),t(T,mn),t(T,at),t(T,cn),t(T,st),t(T,gn),t(T,F),u(Ce,F,null),t(F,fn),t(F,ot),t(F,un),u(Q,F,null),t(T,hn),t(T,W),u(Je,W,null),t(W,_n),t(W,it),t(W,bn),u(D,W,null),t(W,yn),u(A,W,null),t(T,In),t(T,q),u(Le,q,null),t(q,vn),t(q,lt),t(T,wn),t(T,O),u(je,O,null),t(O,Tn),t(O,rt),t(T,$n),t(T,K),u(Ze,K,null),t(K,Mn),t(K,pt),t(T,Un),t(T,S),u(We,S,null),t(S,Pn),t(S,dt),t(S,xn),u(ee,S,null),t(S,Cn),u(te,S,null),t(T,Jn),t(T,ne),u(Se,ne,null),t(ne,Ln),t(ne,mt),t(T,jn),t(T,ae),u(ke,ae,null),t(ae,Zn),t(ae,ct),t(T,Wn),t(T,L),u(Ge,L,null),t(L,Sn),t(L,gt),t(L,kn),t(L,ft),t(L,Gn),t(L,ut),t(L,Bn),t(L,ht),t(L,Vn),t(L,_t),c(e,Ot,p),u(Be,e,p),c(e,Kt,p),c(e,$,p),u(Ve,$,null),t($,Nn),t($,bt),t($,Xn),t($,yt),t($,Fn),t($,E),u(Ne,E,null),t(E,En),t(E,It),t(E,zn),u(se,E,null),t($,Rn),t($,k),u(Xe,k,null),t(k,Yn),t(k,vt),t(k,Hn),u(oe,k,null),t(k,Qn),u(ie,k,null),t($,Dn),t($,le),u(Fe,le,null),t(le,An),t(le,wt),t($,qn),t($,re),u(Ee,re,null),t(re,On),t(re,Tt),t($,Kn),t($,pe),u(ze,pe,null),t(pe,ea),t(pe,$t),t($,ta),t($,G),u(Re,G,null),t(G,na),t(G,Mt),t(G,aa),u(de,G,null),t(G,sa),u(me,G,null),t($,oa),t($,ce),u(Ye,ce,null),t(ce,ia),t(ce,Ut),t($,la),t($,ge),u(He,ge,null),t(ge,ra),t(ge,Pt),t($,pa),t($,j),u(Qe,j,null),t(j,da),t(j,xt),t(j,ma),t(j,Ct),t(j,ca),t(j,Jt),t(j,ga),t(j,Lt),t(j,fa),t(j,jt),c(e,en,p),u(De,e,p),c(e,tn,p),c(e,z,p),u(Ae,z,null),t(z,ua),t(z,Zt),c(e,nn,p),c(e,kt,p),an=!0},p(e,[p]){const M={};p&2&&(M.$$scope={dirty:p,ctx:e}),H.$set(M);const R={};p&2&&(R.$$scope={dirty:p,ctx:e}),Q.$set(R);const V={};p&2&&(V.$$scope={dirty:p,ctx:e}),D.$set(V);const qe={};p&2&&(qe.$$scope={dirty:p,ctx:e}),A.$set(qe);const Oe={};p&2&&(Oe.$$scope={dirty:p,ctx:e}),ee.$set(Oe);const Ke={};p&2&&(Ke.$$scope={dirty:p,ctx:e}),te.$set(Ke);const N={};p&2&&(N.$$scope={dirty:p,ctx:e}),se.$set(N);const et={};p&2&&(et.$$scope={dirty:p,ctx:e}),oe.$set(et);const tt={};p&2&&(tt.$$scope={dirty:p,ctx:e}),ie.$set(tt);const Z={};p&2&&(Z.$$scope={dirty:p,ctx:e}),de.$set(Z);const U={};p&2&&(U.$$scope={dirty:p,ctx:e}),me.$set(U)},i(e){an||(h(v.$$.fragment,e),h(be.$$.fragment,e),h(Ie.$$.fragment,e),h(we.$$.fragment,e),h(H.$$.fragment,e),h(Te.$$.fragment,e),h($e.$$.fragment,e),h(Ue.$$.fragment,e),h(Pe.$$.fragment,e),h(xe.$$.fragment,e),h(Ce.$$.fragment,e),h(Q.$$.fragment,e),h(Je.$$.fragment,e),h(D.$$.fragment,e),h(A.$$.fragment,e),h(Le.$$.fragment,e),h(je.$$.fragment,e),h(Ze.$$.fragment,e),h(We.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(Se.$$.fragment,e),h(ke.$$.fragment,e),h(Ge.$$.fragment,e),h(Be.$$.fragment,e),h(Ve.$$.fragment,e),h(Ne.$$.fragment,e),h(se.$$.fragment,e),h(Xe.$$.fragment,e),h(oe.$$.fragment,e),h(ie.$$.fragment,e),h(Fe.$$.fragment,e),h(Ee.$$.fragment,e),h(ze.$$.fragment,e),h(Re.$$.fragment,e),h(de.$$.fragment,e),h(me.$$.fragment,e),h(Ye.$$.fragment,e),h(He.$$.fragment,e),h(Qe.$$.fragment,e),h(De.$$.fragment,e),h(Ae.$$.fragment,e),an=!0)},o(e){_(v.$$.fragment,e),_(be.$$.fragment,e),_(Ie.$$.fragment,e),_(we.$$.fragment,e),_(H.$$.fragment,e),_(Te.$$.fragment,e),_($e.$$.fragment,e),_(Ue.$$.fragment,e),_(Pe.$$.fragment,e),_(xe.$$.fragment,e),_(Ce.$$.fragment,e),_(Q.$$.fragment,e),_(Je.$$.fragment,e),_(D.$$.fragment,e),_(A.$$.fragment,e),_(Le.$$.fragment,e),_(je.$$.fragment,e),_(Ze.$$.fragment,e),_(We.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(Se.$$.fragment,e),_(ke.$$.fragment,e),_(Ge.$$.fragment,e),_(Be.$$.fragment,e),_(Ve.$$.fragment,e),_(Ne.$$.fragment,e),_(se.$$.fragment,e),_(Xe.$$.fragment,e),_(oe.$$.fragment,e),_(ie.$$.fragment,e),_(Fe.$$.fragment,e),_(Ee.$$.fragment,e),_(ze.$$.fragment,e),_(Re.$$.fragment,e),_(de.$$.fragment,e),_(me.$$.fragment,e),_(Ye.$$.fragment,e),_(He.$$.fragment,e),_(Qe.$$.fragment,e),_(De.$$.fragment,e),_(Ae.$$.fragment,e),an=!1},d(e){e&&(i(I),i(d),i(m),i(a),i(w),i(Bt),i(he),i(Vt),i(_e),i(Nt),i(Xt),i(ye),i(Ft),i(Et),i(ve),i(zt),i(Rt),i(Yt),i(Ht),i(Qt),i(Me),i(Dt),i(At),i(qt),i(T),i(Ot),i(Kt),i($),i(en),i(tn),i(z),i(nn),i(kt)),i(n),b(v,e),b(be,e),b(Ie,e),b(we,e),b(H,e),b(Te,e),b($e,e),b(Ue,e),b(Pe,e),b(xe),b(Ce),b(Q),b(Je),b(D),b(A),b(Le),b(je),b(Ze),b(We),b(ee),b(te),b(Se),b(ke),b(Ge),b(Be,e),b(Ve),b(Ne),b(se),b(Xe),b(oe),b(ie),b(Fe),b(Ee),b(ze),b(Re),b(de),b(me),b(Ye),b(He),b(Qe),b(De,e),b(Ae)}}}const hs='{"title":"Stable unCLIP","local":"stable-unclip","sections":[{"title":"Tips","local":"tips","sections":[{"title":"Text-to-Image Generation","local":"text-to-image-generation","sections":[],"depth":3},{"title":"Text guided Image-to-Image Variation","local":"text-guided-image-to-image-variation","sections":[],"depth":3}],"depth":2},{"title":"StableUnCLIPPipeline","local":"diffusers.StableUnCLIPPipeline","sections":[],"depth":2},{"title":"StableUnCLIPImg2ImgPipeline","local":"diffusers.StableUnCLIPImg2ImgPipeline","sections":[],"depth":2},{"title":"ImagePipelineOutput","local":"diffusers.ImagePipelineOutput","sections":[],"depth":2}],"depth":1}';function _s(P){return es(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ms extends ts{constructor(n){super(),ns(this,n,_s,us,Ka,{})}}export{Ms as component};
