import{s as nl,o as pl,n as sl}from"../chunks/scheduler.182ea377.js";import{S as al,i as ol,g as a,s,r as d,A as rl,h as o,f as t,c as n,j as ll,u as m,x as r,k as tl,y as cl,a as i,v as u,d as f,t as M,w}from"../chunks/index.1ea56653.js";import{H as le,g as dl}from"../chunks/Heading.71ac6e9f.js";import{T as il}from"../chunks/Tip.67abc998.js";import{C as T}from"../chunks/CodeBlock.82c2494b.js";function ml(O){let p,y='💡 Take a look at GitHub Issue <a href="https://github.com/huggingface/diffusers/issues/841" rel="nofollow">#841</a> for more context about why we’re adding community pipelines to help everyone easily share their work without being slowed down.';return{c(){p=a("p"),p.innerHTML=y},l(c){p=o(c,"P",{"data-svelte-h":!0}),r(p)!=="svelte-19wo1pm"&&(p.innerHTML=y)},m(c,J){i(c,p,J)},p:sl,d(c){c&&t(p)}}}function ul(O){let p,y="💡 You can use whatever package you want in your community pipeline file - as long as the user has it installed, everything will work fine. Make sure you have one and only one pipeline class that inherits from <code>DiffusionPipeline</code> because this is automatically detected.";return{c(){p=a("p"),p.innerHTML=y},l(c){p=o(c,"P",{"data-svelte-h":!0}),r(p)!=="svelte-143wzg5"&&(p.innerHTML=y)},m(c,J){i(c,p,J)},p:sl,d(c){c&&t(p)}}}function fl(O){let p,y,c,J,Z,te,h,ie,U,ke='Community pipelines allow you to add any additional features you’d like on top of the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. The main benefit of building on top of the <code>DiffusionPipeline</code> is anyone can load and use your pipeline by only adding one more argument, making it super easy for the community to access.',se,I,He="This guide will show you how to create a community pipeline and explain how they work. To keep things simple, you’ll create a “one-step” pipeline where the <code>UNet</code> does a single forward pass and calls the scheduler once.",ne,j,pe,_,We='You should start by creating a <code>one_step_unet.py</code> file for your community pipeline. In this file, create a pipeline class that inherits from the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to be able to load model weights and the scheduler configuration from the Hub. The one-step pipeline needs a <code>UNet</code> and a scheduler, so you’ll need to add these as arguments to the <code>__init__</code> function:',ae,B,oe,G,Ee='To ensure your pipeline and its components (<code>unet</code> and <code>scheduler</code>) can be saved with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">save_pretrained()</a>, add them to the <code>register_modules</code> function:',re,V,ce,$,Ne="Cool, the <code>__init__</code> step is done and you can move to the forward pass now! 🔥",de,g,me,C,xe="In the forward pass, which we recommend defining as <code>__call__</code>, you have complete creative freedom to add whatever feature you’d like. For our amazing one-step pipeline, create a random image and only call the <code>unet</code> and <code>scheduler</code> once by setting <code>timestep=1</code>:",ue,v,fe,X,Ae="That’s it! 🚀 You can now run this pipeline by passing a <code>unet</code> and <code>scheduler</code> to it:",Me,R,we,k,Se='But what’s even better is you can load pre-existing weights into the pipeline if the pipeline structure is identical. For example, you can load the <a href="https://huggingface.co/google/ddpm-cifar10-32" rel="nofollow"><code>google/ddpm-cifar10-32</code></a> weights into the one-step pipeline:',ye,H,Te,W,Je,E,ze='Open a Pull Request on the 🧨 Diffusers <a href="https://github.com/huggingface/diffusers" rel="nofollow">repository</a> to add your awesome pipeline in <code>one_step_unet.py</code> to the <a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">examples/community</a> subfolder.',he,N,Qe="Once it is merged, anyone with <code>diffusers &gt;= 0.4.0</code> installed can use this pipeline magically 🪄 by specifying it in the <code>custom_pipeline</code> argument:",be,x,Ze,A,Pe='Another way to share your community pipeline is to upload the <code>one_step_unet.py</code> file directly to your preferred <a href="https://huggingface.co/docs/hub/models-uploading" rel="nofollow">model repository</a> on the Hub. Instead of specifying the <code>one_step_unet.py</code> file, pass the model repository id to the <code>custom_pipeline</code> argument:',Ue,S,Ie,z,Fe="Take a look at the following table to compare the two sharing workflows to help you decide the best option for you:",je,Q,Le="<thead><tr><th></th> <th>GitHub community pipeline</th> <th>HF Hub community pipeline</th></tr></thead> <tbody><tr><td>usage</td> <td>same</td> <td>same</td></tr> <tr><td>review process</td> <td>open a Pull Request on GitHub and undergo a review process from the Diffusers team before merging; may be slower</td> <td>upload directly to a Hub repository without any review; this is the fastest workflow</td></tr> <tr><td>visibility</td> <td>included in the official Diffusers repository and documentation</td> <td>included on your HF Hub profile and relies on your own usage/promotion to gain visibility</td></tr></tbody>",_e,b,Be,P,Ge,F,Ye='A community pipeline is a class that inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> which means:',Ve,L,De="<li>It can be loaded with the <code>custom_pipeline</code> argument.</li> <li>The model weights and scheduler configuration are loaded from <code>pretrained_model_name_or_path</code>.</li> <li>The code that implements a feature in the community pipeline is defined in a <code>pipeline.py</code> file.</li>",$e,Y,qe="Sometimes you can’t load all the pipeline components weights from an official repository. In this case, the other components should be passed directly to the pipeline:",ge,D,Ce,q,Ke="The magic behind community pipelines is contained in the following code. It allows the community pipeline to be loaded from GitHub or the Hub, and it’ll be available to all 🧨 Diffusers packages.",ve,K,Xe,ee,Re;return Z=new le({props:{title:"Contribute a community pipeline",local:"contribute-a-community-pipeline",headingTag:"h1"}}),h=new il({props:{$$slots:{default:[ml]},$$scope:{ctx:O}}}),j=new le({props:{title:"Initialize the pipeline",local:"initialize-the-pipeline",headingTag:"h2"}}),B=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEElMEFjbGFzcyUyMFVuZXRTY2hlZHVsZXJPbmVGb3J3YXJkUGlwZWxpbmUoRGlmZnVzaW9uUGlwZWxpbmUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMHVuZXQlMkMlMjBzY2hlZHVsZXIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">class</span> <span class="hljs-title class_">UnetSchedulerOneForwardPipeline</span>(<span class="hljs-title class_ inherited__">DiffusionPipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, unet, scheduler</span>):
        <span class="hljs-built_in">super</span>().__init__()`,wrap:!1}}),V=new T({props:{code:"JTIwJTIwZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTIwJTIwaW1wb3J0JTIwdG9yY2glMEElMEElMjAlMjBjbGFzcyUyMFVuZXRTY2hlZHVsZXJPbmVGb3J3YXJkUGlwZWxpbmUoRGlmZnVzaW9uUGlwZWxpbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMHVuZXQlMkMlMjBzY2hlZHVsZXIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTBBJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5yZWdpc3Rlcl9tb2R1bGVzKHVuZXQlM0R1bmV0JTJDJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyKQ==",highlighted:`  from diffusers import DiffusionPipeline
  import torch

  class UnetSchedulerOneForwardPipeline(DiffusionPipeline):
      def __init__(self, unet, scheduler):
          super().__init__()

<span class="hljs-addition">+         self.register_modules(unet=unet, scheduler=scheduler)</span>`,wrap:!1}}),g=new le({props:{title:"Define the forward pass",local:"define-the-forward-pass",headingTag:"h2"}}),v=new T({props:{code:"JTIwJTIwZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTIwJTIwaW1wb3J0JTIwdG9yY2glMEElMEElMEElMjAlMjBjbGFzcyUyMFVuZXRTY2hlZHVsZXJPbmVGb3J3YXJkUGlwZWxpbmUoRGlmZnVzaW9uUGlwZWxpbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMHVuZXQlMkMlMjBzY2hlZHVsZXIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5yZWdpc3Rlcl9tb2R1bGVzKHVuZXQlM0R1bmV0JTJDJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyKSUwQSUwQSUyQiUyMCUyMCUyMCUyMCUyMGRlZiUyMF9fY2FsbF9fKHNlbGYpJTNBJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjB0b3JjaC5yYW5kbiglMEElMkIlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoMSUyQyUyMHNlbGYudW5ldC5jb25maWcuaW5fY2hhbm5lbHMlMkMlMjBzZWxmLnVuZXQuY29uZmlnLnNhbXBsZV9zaXplJTJDJTIwc2VsZi51bmV0LmNvbmZpZy5zYW1wbGVfc2l6ZSklMkMlMEElMkIlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGltZXN0ZXAlMjAlM0QlMjAxJTBBJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfb3V0cHV0JTIwJTNEJTIwc2VsZi51bmV0KGltYWdlJTJDJTIwdGltZXN0ZXApLnNhbXBsZSUwQSUyQiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNjaGVkdWxlcl9vdXRwdXQlMjAlM0QlMjBzZWxmLnNjaGVkdWxlci5zdGVwKG1vZGVsX291dHB1dCUyQyUyMHRpbWVzdGVwJTJDJTIwaW1hZ2UpLnByZXZfc2FtcGxlJTBBJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2NoZWR1bGVyX291dHB1dA==",highlighted:`  from diffusers import DiffusionPipeline
  import torch


  class UnetSchedulerOneForwardPipeline(DiffusionPipeline):
      def __init__(self, unet, scheduler):
          super().__init__()

          self.register_modules(unet=unet, scheduler=scheduler)

<span class="hljs-addition">+     def __call__(self):</span>
<span class="hljs-addition">+         image = torch.randn(</span>
<span class="hljs-addition">+             (1, self.unet.config.in_channels, self.unet.config.sample_size, self.unet.config.sample_size),</span>
<span class="hljs-addition">+         )</span>
<span class="hljs-addition">+         timestep = 1</span>

<span class="hljs-addition">+         model_output = self.unet(image, timestep).sample</span>
<span class="hljs-addition">+         scheduler_output = self.scheduler.step(model_output, timestep, image).prev_sample</span>

<span class="hljs-addition">+         return scheduler_output</span>`,wrap:!1}}),R=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1TY2hlZHVsZXIlMkMlMjBVTmV0MkRNb2RlbCUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMEREUE1TY2hlZHVsZXIoKSUwQXVuZXQlMjAlM0QlMjBVTmV0MkRNb2RlbCgpJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBVbmV0U2NoZWR1bGVyT25lRm9yd2FyZFBpcGVsaW5lKHVuZXQlM0R1bmV0JTJDJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyKSUwQSUwQW91dHB1dCUyMCUzRCUyMHBpcGVsaW5lKCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMScheduler, UNet2DModel

scheduler = DDPMScheduler()
unet = UNet2DModel()

pipeline = UnetSchedulerOneForwardPipeline(unet=unet, scheduler=scheduler)

output = pipeline()`,wrap:!1}}),H=new T({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBVbmV0U2NoZWR1bGVyT25lRm9yd2FyZFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZkZHBtLWNpZmFyMTAtMzIlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQSUwQW91dHB1dCUyMCUzRCUyMHBpcGVsaW5lKCk=",highlighted:`pipeline = UnetSchedulerOneForwardPipeline.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)

output = pipeline()`,wrap:!1}}),W=new le({props:{title:"Share your pipeline",local:"share-your-pipeline",headingTag:"h2"}}),x=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJnb29nbGUlMkZkZHBtLWNpZmFyMTAtMzIlMjIlMkMlMjBjdXN0b21fcGlwZWxpbmUlM0QlMjJvbmVfc3RlcF91bmV0JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlKCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, custom_pipeline=<span class="hljs-string">&quot;one_step_unet&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipe()`,wrap:!1}}),S=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZ29vZ2xlJTJGZGRwbS1jaWZhcjEwLTMyJTIyJTJDJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyc3RldmhsaXUlMkZvbmVfc3RlcF91bmV0JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, custom_pipeline=<span class="hljs-string">&quot;stevhliu/one_step_unet&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),b=new il({props:{$$slots:{default:[ul]},$$scope:{ctx:O}}}),P=new le({props:{title:"How do community pipelines work?",local:"how-do-community-pipelines-work",headingTag:"h2"}}),D=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBGZWF0dXJlRXh0cmFjdG9yJTJDJTIwQ0xJUE1vZGVsJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS00JTIyJTBBY2xpcF9tb2RlbF9pZCUyMCUzRCUyMCUyMmxhaW9uJTJGQ0xJUC1WaVQtQi0zMi1sYWlvbjJCLXMzNEItYjc5SyUyMiUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQ0xJUEZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKGNsaXBfbW9kZWxfaWQpJTBBY2xpcF9tb2RlbCUyMCUzRCUyMENMSVBNb2RlbC5mcm9tX3ByZXRyYWluZWQoY2xpcF9tb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMGN1c3RvbV9waXBlbGluZSUzRCUyMmNsaXBfZ3VpZGVkX3N0YWJsZV9kaWZmdXNpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBjbGlwX21vZGVsJTNEY2xpcF9tb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEZmVhdHVyZV9leHRyYWN0b3IlMkMlMEElMjAlMjAlMjAlMjBzY2hlZHVsZXIlM0RzY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPFeatureExtractor, CLIPModel

model_id = <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>
clip_model_id = <span class="hljs-string">&quot;laion/CLIP-ViT-B-32-laion2B-s34B-b79K&quot;</span>

feature_extractor = CLIPFeatureExtractor.from_pretrained(clip_model_id)
clip_model = CLIPModel.from_pretrained(clip_model_id, torch_dtype=torch.float16)

pipeline = DiffusionPipeline.from_pretrained(
    model_id,
    custom_pipeline=<span class="hljs-string">&quot;clip_guided_stable_diffusion&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    scheduler=scheduler,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),K=new T({props:{code:"JTIzJTIwMi4lMjBMb2FkJTIwdGhlJTIwcGlwZWxpbmUlMjBjbGFzcyUyQyUyMGlmJTIwdXNpbmclMjBjdXN0b20lMjBtb2R1bGUlMjB0aGVuJTIwbG9hZCUyMGl0JTIwZnJvbSUyMHRoZSUyMGh1YiUwQSUyMyUyMGlmJTIwd2UlMjBsb2FkJTIwZnJvbSUyMGV4cGxpY2l0JTIwY2xhc3MlMkMlMjBsZXQncyUyMHVzZSUyMGl0JTBBaWYlMjBjdXN0b21fcGlwZWxpbmUlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUyMCUzRCUyMGdldF9jbGFzc19mcm9tX2R5bmFtaWNfbW9kdWxlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGN1c3RvbV9waXBlbGluZSUyQyUyMG1vZHVsZV9maWxlJTNEQ1VTVE9NX1BJUEVMSU5FX0ZJTEVfTkFNRSUyQyUyMGNhY2hlX2RpciUzRGN1c3RvbV9waXBlbGluZSUwQSUyMCUyMCUyMCUyMCklMEFlbGlmJTIwY2xzJTIwISUzRCUyMERpZmZ1c2lvblBpcGVsaW5lJTNBJTBBJTIwJTIwJTIwJTIwcGlwZWxpbmVfY2xhc3MlMjAlM0QlMjBjbHMlMEFlbHNlJTNBJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzX21vZHVsZSUyMCUzRCUyMGltcG9ydGxpYi5pbXBvcnRfbW9kdWxlKGNscy5fX21vZHVsZV9fLnNwbGl0KCUyMi4lMjIpJTVCMCU1RCklMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUyMCUzRCUyMGdldGF0dHIoZGlmZnVzZXJzX21vZHVsZSUyQyUyMGNvbmZpZ19kaWN0JTVCJTIyX2NsYXNzX25hbWUlMjIlNUQp",highlighted:`<span class="hljs-comment"># 2. Load the pipeline class, if using custom module then load it from the hub</span>
<span class="hljs-comment"># if we load from explicit class, let&#x27;s use it</span>
<span class="hljs-keyword">if</span> custom_pipeline <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    pipeline_class = get_class_from_dynamic_module(
        custom_pipeline, module_file=CUSTOM_PIPELINE_FILE_NAME, cache_dir=custom_pipeline
    )
<span class="hljs-keyword">elif</span> cls != DiffusionPipeline:
    pipeline_class = cls
<span class="hljs-keyword">else</span>:
    diffusers_module = importlib.import_module(cls.__module__.split(<span class="hljs-string">&quot;.&quot;</span>)[<span class="hljs-number">0</span>])
    pipeline_class = <span class="hljs-built_in">getattr</span>(diffusers_module, config_dict[<span class="hljs-string">&quot;_class_name&quot;</span>])`,wrap:!1}}),{c(){p=a("meta"),y=s(),c=a("p"),J=s(),d(Z.$$.fragment),te=s(),d(h.$$.fragment),ie=s(),U=a("p"),U.innerHTML=ke,se=s(),I=a("p"),I.innerHTML=He,ne=s(),d(j.$$.fragment),pe=s(),_=a("p"),_.innerHTML=We,ae=s(),d(B.$$.fragment),oe=s(),G=a("p"),G.innerHTML=Ee,re=s(),d(V.$$.fragment),ce=s(),$=a("p"),$.innerHTML=Ne,de=s(),d(g.$$.fragment),me=s(),C=a("p"),C.innerHTML=xe,ue=s(),d(v.$$.fragment),fe=s(),X=a("p"),X.innerHTML=Ae,Me=s(),d(R.$$.fragment),we=s(),k=a("p"),k.innerHTML=Se,ye=s(),d(H.$$.fragment),Te=s(),d(W.$$.fragment),Je=s(),E=a("p"),E.innerHTML=ze,he=s(),N=a("p"),N.innerHTML=Qe,be=s(),d(x.$$.fragment),Ze=s(),A=a("p"),A.innerHTML=Pe,Ue=s(),d(S.$$.fragment),Ie=s(),z=a("p"),z.textContent=Fe,je=s(),Q=a("table"),Q.innerHTML=Le,_e=s(),d(b.$$.fragment),Be=s(),d(P.$$.fragment),Ge=s(),F=a("p"),F.innerHTML=Ye,Ve=s(),L=a("ul"),L.innerHTML=De,$e=s(),Y=a("p"),Y.textContent=qe,ge=s(),d(D.$$.fragment),Ce=s(),q=a("p"),q.textContent=Ke,ve=s(),d(K.$$.fragment),Xe=s(),ee=a("p"),this.h()},l(e){const l=rl("svelte-u9bgzb",document.head);p=o(l,"META",{name:!0,content:!0}),l.forEach(t),y=n(e),c=o(e,"P",{}),ll(c).forEach(t),J=n(e),m(Z.$$.fragment,e),te=n(e),m(h.$$.fragment,e),ie=n(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-18q8p0l"&&(U.innerHTML=ke),se=n(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-uyw7g0"&&(I.innerHTML=He),ne=n(e),m(j.$$.fragment,e),pe=n(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1ofdu1u"&&(_.innerHTML=We),ae=n(e),m(B.$$.fragment,e),oe=n(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1efu2er"&&(G.innerHTML=Ee),re=n(e),m(V.$$.fragment,e),ce=n(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-jmgs1z"&&($.innerHTML=Ne),de=n(e),m(g.$$.fragment,e),me=n(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1l1aime"&&(C.innerHTML=xe),ue=n(e),m(v.$$.fragment,e),fe=n(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1wqngql"&&(X.innerHTML=Ae),Me=n(e),m(R.$$.fragment,e),we=n(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-13itfz9"&&(k.innerHTML=Se),ye=n(e),m(H.$$.fragment,e),Te=n(e),m(W.$$.fragment,e),Je=n(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1okqb75"&&(E.innerHTML=ze),he=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-mmjniw"&&(N.innerHTML=Qe),be=n(e),m(x.$$.fragment,e),Ze=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-hpyorm"&&(A.innerHTML=Pe),Ue=n(e),m(S.$$.fragment,e),Ie=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1wdgje4"&&(z.textContent=Fe),je=n(e),Q=o(e,"TABLE",{"data-svelte-h":!0}),r(Q)!=="svelte-1tu2a4k"&&(Q.innerHTML=Le),_e=n(e),m(b.$$.fragment,e),Be=n(e),m(P.$$.fragment,e),Ge=n(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1jkfcz7"&&(F.innerHTML=Ye),Ve=n(e),L=o(e,"UL",{"data-svelte-h":!0}),r(L)!=="svelte-185ii9u"&&(L.innerHTML=De),$e=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-84chr9"&&(Y.textContent=qe),ge=n(e),m(D.$$.fragment,e),Ce=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-pfjr1e"&&(q.textContent=Ke),ve=n(e),m(K.$$.fragment,e),Xe=n(e),ee=o(e,"P",{}),ll(ee).forEach(t),this.h()},h(){tl(p,"name","hf:doc:metadata"),tl(p,"content",Ml)},m(e,l){cl(document.head,p),i(e,y,l),i(e,c,l),i(e,J,l),u(Z,e,l),i(e,te,l),u(h,e,l),i(e,ie,l),i(e,U,l),i(e,se,l),i(e,I,l),i(e,ne,l),u(j,e,l),i(e,pe,l),i(e,_,l),i(e,ae,l),u(B,e,l),i(e,oe,l),i(e,G,l),i(e,re,l),u(V,e,l),i(e,ce,l),i(e,$,l),i(e,de,l),u(g,e,l),i(e,me,l),i(e,C,l),i(e,ue,l),u(v,e,l),i(e,fe,l),i(e,X,l),i(e,Me,l),u(R,e,l),i(e,we,l),i(e,k,l),i(e,ye,l),u(H,e,l),i(e,Te,l),u(W,e,l),i(e,Je,l),i(e,E,l),i(e,he,l),i(e,N,l),i(e,be,l),u(x,e,l),i(e,Ze,l),i(e,A,l),i(e,Ue,l),u(S,e,l),i(e,Ie,l),i(e,z,l),i(e,je,l),i(e,Q,l),i(e,_e,l),u(b,e,l),i(e,Be,l),u(P,e,l),i(e,Ge,l),i(e,F,l),i(e,Ve,l),i(e,L,l),i(e,$e,l),i(e,Y,l),i(e,ge,l),u(D,e,l),i(e,Ce,l),i(e,q,l),i(e,ve,l),u(K,e,l),i(e,Xe,l),i(e,ee,l),Re=!0},p(e,[l]){const Oe={};l&2&&(Oe.$$scope={dirty:l,ctx:e}),h.$set(Oe);const el={};l&2&&(el.$$scope={dirty:l,ctx:e}),b.$set(el)},i(e){Re||(f(Z.$$.fragment,e),f(h.$$.fragment,e),f(j.$$.fragment,e),f(B.$$.fragment,e),f(V.$$.fragment,e),f(g.$$.fragment,e),f(v.$$.fragment,e),f(R.$$.fragment,e),f(H.$$.fragment,e),f(W.$$.fragment,e),f(x.$$.fragment,e),f(S.$$.fragment,e),f(b.$$.fragment,e),f(P.$$.fragment,e),f(D.$$.fragment,e),f(K.$$.fragment,e),Re=!0)},o(e){M(Z.$$.fragment,e),M(h.$$.fragment,e),M(j.$$.fragment,e),M(B.$$.fragment,e),M(V.$$.fragment,e),M(g.$$.fragment,e),M(v.$$.fragment,e),M(R.$$.fragment,e),M(H.$$.fragment,e),M(W.$$.fragment,e),M(x.$$.fragment,e),M(S.$$.fragment,e),M(b.$$.fragment,e),M(P.$$.fragment,e),M(D.$$.fragment,e),M(K.$$.fragment,e),Re=!1},d(e){e&&(t(y),t(c),t(J),t(te),t(ie),t(U),t(se),t(I),t(ne),t(pe),t(_),t(ae),t(oe),t(G),t(re),t(ce),t($),t(de),t(me),t(C),t(ue),t(fe),t(X),t(Me),t(we),t(k),t(ye),t(Te),t(Je),t(E),t(he),t(N),t(be),t(Ze),t(A),t(Ue),t(Ie),t(z),t(je),t(Q),t(_e),t(Be),t(Ge),t(F),t(Ve),t(L),t($e),t(Y),t(ge),t(Ce),t(q),t(ve),t(Xe),t(ee)),t(p),w(Z,e),w(h,e),w(j,e),w(B,e),w(V,e),w(g,e),w(v,e),w(R,e),w(H,e),w(W,e),w(x,e),w(S,e),w(b,e),w(P,e),w(D,e),w(K,e)}}}const Ml='{"title":"Contribute a community pipeline","local":"contribute-a-community-pipeline","sections":[{"title":"Initialize the pipeline","local":"initialize-the-pipeline","sections":[],"depth":2},{"title":"Define the forward pass","local":"define-the-forward-pass","sections":[],"depth":2},{"title":"Share your pipeline","local":"share-your-pipeline","sections":[],"depth":2},{"title":"How do community pipelines work?","local":"how-do-community-pipelines-work","sections":[],"depth":2}],"depth":1}';function wl(O){return pl(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=dl}),[]}class Zl extends al{constructor(p){super(),ol(this,p,wl,fl,nl,{})}}export{Zl as component};
