import{s as Lt,o as Pt,n as we}from"../chunks/scheduler.182ea377.js";import{S as qt,i as Dt,g as o,s as a,r as d,A as Kt,h as m,f as l,c as i,j as At,u as M,x as r,k as Ft,y as Ot,a as s,v as y,d as h,t as w,w as J}from"../chunks/index.1ea56653.js";import{H as B,g as el}from"../chunks/Heading.71ac6e9f.js";import{T as he}from"../chunks/Tip.67abc998.js";import{C as W}from"../chunks/CodeBlock.82c2494b.js";function tl(U){let n,f='In many cases, optimizing for memory or speed leads to improved performance in the other, so you should try to optimize for both whenever you can. This guide focuses on minimizing memory usage, but you can also learn more about how to <a href="fp16">Speed up inference</a>.';return{c(){n=o("p"),n.innerHTML=f},l(p){n=m(p,"P",{"data-svelte-h":!0}),r(n)!=="svelte-15lbm2y"&&(n.innerHTML=f)},m(p,c){s(p,n,c)},p:we,d(p){p&&l(n)}}}function ll(U){let n,f='Consider using <a href="#model-offloading">model offloading</a> if you want to optimize for speed because it is much faster. The tradeoff is your memory savings won’t be as large.';return{c(){n=o("p"),n.innerHTML=f},l(p){n=m(p,"P",{"data-svelte-h":!0}),r(n)!=="svelte-1yyrc0t"&&(n.innerHTML=f)},m(p,c){s(p,n,c)},p:we,d(p){p&&l(n)}}}function sl(U){let n,f='When using <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/latent_upscale#diffusers.StableDiffusionLatentUpscalePipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a>, don’t move the pipeline to CUDA beforehand or else the gain in memory consumption will only be minimal (see this <a href="https://github.com/huggingface/diffusers/issues/1934" rel="nofollow">issue</a> for more information).',p,c,b='<a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/latent_upscale#diffusers.StableDiffusionLatentUpscalePipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a> is a stateful operation that installs hooks on the models.';return{c(){n=o("p"),n.innerHTML=f,p=a(),c=o("p"),c.innerHTML=b},l(u){n=m(u,"P",{"data-svelte-h":!0}),r(n)!=="svelte-1u6stjz"&&(n.innerHTML=f),p=i(u),c=m(u,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1j7vi8o"&&(c.innerHTML=b)},m(u,T){s(u,n,T),s(u,p,T),s(u,c,T)},p:we,d(u){u&&(l(n),l(p),l(c))}}}function nl(U){let n,f="Model offloading requires 🤗 Accelerate version 0.17.0 or higher.";return{c(){n=o("p"),n.textContent=f},l(p){n=m(p,"P",{"data-svelte-h":!0}),r(n)!=="svelte-1guxtqy"&&(n.textContent=f)},m(p,c){s(p,n,c)},p:we,d(p){p&&l(n)}}}function al(U){let n,f='In order to properly offload models after they’re called, it is required to run the entire pipeline and models are called in the pipeline’s expected order. Exercise caution if models are reused outside the context of the pipeline after hooks have been installed. See <a href="https://huggingface.co/docs/accelerate/en/package_reference/big_modeling#accelerate.hooks.remove_hook_from_module" rel="nofollow">Removing Hooks</a> for more information.',p,c,b='<a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENTextImagePipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> is a stateful operation that installs hooks on the models and state on the pipeline.';return{c(){n=o("p"),n.innerHTML=f,p=a(),c=o("p"),c.innerHTML=b},l(u){n=m(u,"P",{"data-svelte-h":!0}),r(n)!=="svelte-bljvwk"&&(n.innerHTML=f),p=i(u),c=m(u,"P",{"data-svelte-h":!0}),r(c)!=="svelte-17elxqz"&&(c.innerHTML=b)},m(u,T){s(u,n,T),s(u,p,T),s(u,c,T)},p:we,d(u){u&&(l(n),l(p),l(c))}}}function il(U){let n,f="If you have PyTorch &gt;= 2.0 installed, you should not expect a speed-up for inference when enabling <code>xformers</code>.";return{c(){n=o("p"),n.innerHTML=f},l(p){n=m(p,"P",{"data-svelte-h":!0}),r(n)!=="svelte-17vr965"&&(n.innerHTML=f)},m(p,c){s(p,n,c)},p:we,d(p){p&&l(n)}}}function pl(U){let n,f,p,c,b,u,T,dt="A barrier to using diffusion models is the large amount of memory required. To overcome this challenge, there are several memory-reducing techniques you can use to run even some of the largest models on free-tier or consumer GPUs. Some of these techniques can even be combined to further reduce memory usage.",Te,j,Ue,G,Mt="The results below are obtained from generating a single 512x512 image from the prompt a photo of an astronaut riding a horse on mars with 50 DDIM steps on a Nvidia Titan RTX, demonstrating the speed-up you can expect as a result of reduced memory consumption.",be,v,yt="<thead><tr><th></th> <th>latency</th> <th>speed-up</th></tr></thead> <tbody><tr><td>original</td> <td>9.50s</td> <td>x1</td></tr> <tr><td>fp16</td> <td>3.61s</td> <td>x2.63</td></tr> <tr><td>channels last</td> <td>3.30s</td> <td>x2.88</td></tr> <tr><td>traced UNet</td> <td>3.21s</td> <td>x2.96</td></tr> <tr><td>memory-efficient attention</td> <td>2.63s</td> <td>x3.61</td></tr></tbody>",je,$,Ce,V,ht='Sliced VAE enables decoding large batches of images with limited VRAM or batches with 32 images or more by decoding the batches of latents one image at a time. You’ll likely want to couple this with <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> to reduce memory use further if you have xFormers installed.',Ze,X,wt='To use sliced VAE, call <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline.enable_vae_slicing">enable_vae_slicing()</a> on your pipeline before inference:',_e,R,ge,k,Jt="You may see a small performance boost in VAE decoding on multi-image batches, and there should be no performance impact on single-image batches.",Ie,S,Be,x,Tt='Tiled VAE processing also enables working with large images on limited VRAM (for example, generating 4k images on 8GB of VRAM) by splitting the image into overlapping tiles, decoding the tiles, and then blending the outputs together to compose the final image. You should also used tiled VAE with <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> to reduce memory use further if you have xFormers installed.',We,E,Ut='To use tiled VAE processing, call <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline.enable_vae_tiling">enable_vae_tiling()</a> on your pipeline before inference:',Ge,N,ve,Y,bt="The output image has some tile-to-tile tone variation because the tiles are decoded separately, but you shouldn’t see any sharp and obvious seams between the tiles. Tiling is turned off for images that are 512x512 or smaller.",$e,Q,Ve,H,jt="Offloading the weights to the CPU and only loading them on the GPU when performing the forward pass can also save memory. Often, this technique can reduce memory consumption to less than 3GB.",Xe,z,Ct='To perform CPU offloading, call <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/latent_upscale#diffusers.StableDiffusionLatentUpscalePipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a>:',Re,A,ke,F,Zt="CPU offloading works on submodules rather than whole models. This is the best way to minimize memory consumption, but inference is much slower due to the iterative nature of the diffusion process. The UNet component of the pipeline runs several times (as many as <code>num_inference_steps</code>); each time, the different UNet submodules are sequentially onloaded and offloaded as needed, resulting in a large number of memory transfers.",Se,C,xe,Z,Ee,L,Ne,_,Ye,P,_t='<a href="#cpu-offloading">Sequential CPU offloading</a> preserves a lot of memory but it makes inference slower because submodules are moved to GPU as needed, and they’re immediately returned to the CPU when a new module runs.',Qe,q,gt="Full-model offloading is an alternative that moves whole models to the GPU, instead of handling each model’s constituent <em>submodules</em>. There is a negligible impact on inference time (compared with moving the pipeline to <code>cuda</code>), and it still provides some memory savings.",He,D,It=`During model offloading, only one of the main components of the pipeline (typically the text encoder, UNet and VAE)
is placed on the GPU while the others wait on the CPU. Components like the UNet that run for multiple iterations stay on the GPU until they’re no longer needed.`,ze,K,Bt='Enable model offloading by calling <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENTextImagePipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> on the pipeline:',Ae,O,Fe,g,Le,ee,Pe,te,Wt="The channels-last memory format is an alternative way of ordering NCHW tensors in memory to preserve dimension ordering. Channels-last tensors are ordered in such a way that the channels become the densest dimension (storing images pixel-per-pixel). Since not all operators currently support the channels-last format, it may result in worst performance but you should still try and see if it works for your model.",qe,le,Gt="For example, to set the pipeline’s UNet to use the channels-last format:",De,se,Ke,ne,Oe,ae,vt="Tracing runs an example input tensor through the model and captures the operations that are performed on it as that input makes its way through the model’s layers. The executable or <code>ScriptFunction</code> that is returned is optimized with just-in-time compilation.",et,ie,$t="To trace a UNet:",tt,pe,lt,oe,Vt="Replace the <code>unet</code> attribute of the pipeline with the traced model:",st,me,nt,re,at,ce,Xt='Recent work on optimizing bandwidth in the attention block has generated huge speed-ups and reductions in GPU memory usage. The most recent type of memory-efficient attention is <a href="https://arxiv.org/abs/2205.14135" rel="nofollow">Flash Attention</a> (you can check out the original code at <a href="https://github.com/HazyResearch/flash-attention" rel="nofollow">HazyResearch/flash-attention</a>).',it,I,pt,ue,Rt="To use Flash Attention, install the following:",ot,fe,kt='<li>PyTorch &gt; 1.12</li> <li>CUDA available</li> <li><a href="xformers">xFormers</a></li>',mt,de,St='Then call <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> on the pipeline:',rt,Me,ct,ye,xt='The iteration speed when using <code>xformers</code> should match the iteration speed of PyTorch 2.0 as described <a href="torch2.0">here</a>.',ut,Je,ft;return b=new B({props:{title:"Reduce memory usage",local:"reduce-memory-usage",headingTag:"h1"}}),j=new he({props:{$$slots:{default:[tl]},$$scope:{ctx:U}}}),$=new B({props:{title:"Sliced VAE",local:"sliced-vae",headingTag:"h2"}}),R=new W({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMEFwaXBlLmVuYWJsZV92YWVfc2xpY2luZygpJTBBJTIzcGlwZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQWltYWdlcyUyMCUzRCUyMHBpcGUoJTVCcHJvbXB0JTVEJTIwKiUyMDMyKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_vae_slicing()
<span class="hljs-comment">#pipe.enable_xformers_memory_efficient_attention()</span>
images = pipe([prompt] * <span class="hljs-number">32</span>).images`,wrap:!1}}),S=new B({props:{title:"Tiled VAE",local:"tiled-vae",headingTag:"h2"}}),N=new W({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlciUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTJDJTBBKSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwVW5pUENNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGJlYXV0aWZ1bCUyMGxhbmRzY2FwZSUyMHBob3RvZ3JhcGglMjIlMEFwaXBlLmVuYWJsZV92YWVfdGlsaW5nKCklMEElMjNwaXBlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCU1QnByb21wdCU1RCUyQyUyMHdpZHRoJTNEMzg0MCUyQyUyMGhlaWdodCUzRDIyMjQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjApLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, UniPCMultistepScheduler

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt = <span class="hljs-string">&quot;a beautiful landscape photograph&quot;</span>
pipe.enable_vae_tiling()
<span class="hljs-comment">#pipe.enable_xformers_memory_efficient_attention()</span>

image = pipe([prompt], width=<span class="hljs-number">3840</span>, height=<span class="hljs-number">2224</span>, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Q=new B({props:{title:"CPU offloading",local:"cpu-offloading",headingTag:"h2"}}),A=new W({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfc2VxdWVudGlhbF9jcHVfb2ZmbG9hZCgpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_sequential_cpu_offload()
image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),C=new he({props:{$$slots:{default:[ll]},$$scope:{ctx:U}}}),Z=new he({props:{warning:!0,$$slots:{default:[sl]},$$scope:{ctx:U}}}),L=new B({props:{title:"Model offloading",local:"model-offloading",headingTag:"h2"}}),_=new he({props:{$$slots:{default:[nl]},$$scope:{ctx:U}}}),O=new W({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_model_cpu_offload()
image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),g=new he({props:{warning:!0,$$slots:{default:[al]},$$scope:{ctx:U}}}),ee=new B({props:{title:"Channels-last memory format",local:"channels-last-memory-format",headingTag:"h2"}}),se=new W({props:{code:"cHJpbnQocGlwZS51bmV0LmNvbnZfb3V0LnN0YXRlX2RpY3QoKSU1QiUyMndlaWdodCUyMiU1RC5zdHJpZGUoKSklMjAlMjAlMjMlMjAoMjg4MCUyQyUyMDklMkMlMjAzJTJDJTIwMSklMEFwaXBlLnVuZXQudG8obWVtb3J5X2Zvcm1hdCUzRHRvcmNoLmNoYW5uZWxzX2xhc3QpJTIwJTIwJTIzJTIwaW4tcGxhY2UlMjBvcGVyYXRpb24lMEFwcmludCglMEElMjAlMjAlMjAlMjBwaXBlLnVuZXQuY29udl9vdXQuc3RhdGVfZGljdCgpJTVCJTIyd2VpZ2h0JTIyJTVELnN0cmlkZSgpJTBBKSUyMCUyMCUyMyUyMCgyODgwJTJDJTIwMSUyQyUyMDk2MCUyQyUyMDMyMCklMjBoYXZpbmclMjBhJTIwc3RyaWRlJTIwb2YlMjAxJTIwZm9yJTIwdGhlJTIwMm5kJTIwZGltZW5zaW9uJTIwcHJvdmVzJTIwdGhhdCUyMGl0JTIwd29ya3M=",highlighted:`<span class="hljs-built_in">print</span>(pipe.unet.conv_out.state_dict()[<span class="hljs-string">&quot;weight&quot;</span>].stride())  <span class="hljs-comment"># (2880, 9, 3, 1)</span>
pipe.unet.to(memory_format=torch.channels_last)  <span class="hljs-comment"># in-place operation</span>
<span class="hljs-built_in">print</span>(
    pipe.unet.conv_out.state_dict()[<span class="hljs-string">&quot;weight&quot;</span>].stride()
)  <span class="hljs-comment"># (2880, 1, 960, 320) having a stride of 1 for the 2nd dimension proves that it works</span>`,wrap:!1}}),ne=new B({props:{title:"Tracing",local:"tracing",headingTag:"h2"}}),pe=new W({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> functools

<span class="hljs-comment"># torch disable grad</span>
torch.set_grad_enabled(<span class="hljs-literal">False</span>)

<span class="hljs-comment"># set variables</span>
n_experiments = <span class="hljs-number">2</span>
unet_runs_per_experiment = <span class="hljs-number">50</span>


<span class="hljs-comment"># load inputs</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_inputs</span>():
    sample = torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>).half().cuda()
    timestep = torch.rand(<span class="hljs-number">1</span>).half().cuda() * <span class="hljs-number">999</span>
    encoder_hidden_states = torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">77</span>, <span class="hljs-number">768</span>).half().cuda()
    <span class="hljs-keyword">return</span> sample, timestep, encoder_hidden_states


pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
unet = pipe.unet
unet.<span class="hljs-built_in">eval</span>()
unet.to(memory_format=torch.channels_last)  <span class="hljs-comment"># use channels_last memory format</span>
unet.forward = functools.partial(unet.forward, return_dict=<span class="hljs-literal">False</span>)  <span class="hljs-comment"># set return_dict=False as default</span>

<span class="hljs-comment"># warmup</span>
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    <span class="hljs-keyword">with</span> torch.inference_mode():
        inputs = generate_inputs()
        orig_output = unet(*inputs)

<span class="hljs-comment"># trace</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;tracing..&quot;</span>)
unet_traced = torch.jit.trace(unet, inputs)
unet_traced.<span class="hljs-built_in">eval</span>()
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;done tracing&quot;</span>)


<span class="hljs-comment"># warmup and optimize graph</span>
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
    <span class="hljs-keyword">with</span> torch.inference_mode():
        inputs = generate_inputs()
        orig_output = unet_traced(*inputs)


<span class="hljs-comment"># benchmarking</span>
<span class="hljs-keyword">with</span> torch.inference_mode():
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_experiments):
        torch.cuda.synchronize()
        start_time = time.time()
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(unet_runs_per_experiment):
            orig_output = unet_traced(*inputs)
        torch.cuda.synchronize()
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;unet traced inference took <span class="hljs-subst">{time.time() - start_time:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_experiments):
        torch.cuda.synchronize()
        start_time = time.time()
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(unet_runs_per_experiment):
            orig_output = unet(*inputs)
        torch.cuda.synchronize()
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;unet inference took <span class="hljs-subst">{time.time() - start_time:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)

<span class="hljs-comment"># save the model</span>
unet_traced.save(<span class="hljs-string">&quot;unet_traced.pt&quot;</span>)`,wrap:!1}}),me=new W({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YWNsYXNzZXMlMjBpbXBvcnQlMjBkYXRhY2xhc3MlMEElMEElMEElNDBkYXRhY2xhc3MlMEFjbGFzcyUyMFVOZXQyRENvbmRpdGlvbk91dHB1dCUzQSUwQSUyMCUyMCUyMCUyMHNhbXBsZSUzQSUyMHRvcmNoLkZsb2F0VGVuc29yJTBBJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTIzJTIwdXNlJTIwaml0dGVkJTIwdW5ldCUwQXVuZXRfdHJhY2VkJTIwJTNEJTIwdG9yY2guaml0LmxvYWQoJTIydW5ldF90cmFjZWQucHQlMjIpJTBBJTBBJTBBJTIzJTIwZGVsJTIwcGlwZS51bmV0JTBBY2xhc3MlMjBUcmFjZWRVTmV0KHRvcmNoLm5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuaW5fY2hhbm5lbHMlMjAlM0QlMjBwaXBlLnVuZXQuY29uZmlnLmluX2NoYW5uZWxzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5kZXZpY2UlMjAlM0QlMjBwaXBlLnVuZXQuZGV2aWNlJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwbGF0ZW50X21vZGVsX2lucHV0JTJDJTIwdCUyQyUyMGVuY29kZXJfaGlkZGVuX3N0YXRlcyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzYW1wbGUlMjAlM0QlMjB1bmV0X3RyYWNlZChsYXRlbnRfbW9kZWxfaW5wdXQlMkMlMjB0JTJDJTIwZW5jb2Rlcl9oaWRkZW5fc3RhdGVzKSU1QjAlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBVTmV0MkRDb25kaXRpb25PdXRwdXQoc2FtcGxlJTNEc2FtcGxlKSUwQSUwQSUwQXBpcGUudW5ldCUyMCUzRCUyMFRyYWNlZFVOZXQoKSUwQSUwQXdpdGglMjB0b3JjaC5pbmZlcmVuY2VfbW9kZSgpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBwaXBlKCU1QnByb21wdCU1RCUyMColMjAxJTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">UNet2DConditionOutput</span>:
    sample: torch.FloatTensor


pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># use jitted unet</span>
unet_traced = torch.jit.load(<span class="hljs-string">&quot;unet_traced.pt&quot;</span>)


<span class="hljs-comment"># del pipe.unet</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TracedUNet</span>(torch.nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.in_channels = pipe.unet.config.in_channels
        self.device = pipe.unet.device

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, latent_model_input, t, encoder_hidden_states</span>):
        sample = unet_traced(latent_model_input, t, encoder_hidden_states)[<span class="hljs-number">0</span>]
        <span class="hljs-keyword">return</span> UNet2DConditionOutput(sample=sample)


pipe.unet = TracedUNet()

<span class="hljs-keyword">with</span> torch.inference_mode():
    image = pipe([prompt] * <span class="hljs-number">1</span>, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),re=new B({props:{title:"Memory-efficient attention",local:"memory-efficient-attention",headingTag:"h2"}}),I=new he({props:{$$slots:{default:[il]},$$scope:{ctx:U}}}),Me=new W({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBd2l0aCUyMHRvcmNoLmluZmVyZW5jZV9tb2RlKCklM0ElMEElMjAlMjAlMjAlMjBzYW1wbGUlMjAlM0QlMjBwaXBlKCUyMmElMjBzbWFsbCUyMGNhdCUyMiklMEElMEElMjMlMjBvcHRpb25hbCUzQSUyMFlvdSUyMGNhbiUyMGRpc2FibGUlMjBpdCUyMHZpYSUwQSUyMyUyMHBpcGUuZGlzYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.enable_xformers_memory_efficient_attention()

<span class="hljs-keyword">with</span> torch.inference_mode():
    sample = pipe(<span class="hljs-string">&quot;a small cat&quot;</span>)

<span class="hljs-comment"># optional: You can disable it via</span>
<span class="hljs-comment"># pipe.disable_xformers_memory_efficient_attention()</span>`,wrap:!1}}),{c(){n=o("meta"),f=a(),p=o("p"),c=a(),d(b.$$.fragment),u=a(),T=o("p"),T.textContent=dt,Te=a(),d(j.$$.fragment),Ue=a(),G=o("p"),G.textContent=Mt,be=a(),v=o("table"),v.innerHTML=yt,je=a(),d($.$$.fragment),Ce=a(),V=o("p"),V.innerHTML=ht,Ze=a(),X=o("p"),X.innerHTML=wt,_e=a(),d(R.$$.fragment),ge=a(),k=o("p"),k.textContent=Jt,Ie=a(),d(S.$$.fragment),Be=a(),x=o("p"),x.innerHTML=Tt,We=a(),E=o("p"),E.innerHTML=Ut,Ge=a(),d(N.$$.fragment),ve=a(),Y=o("p"),Y.textContent=bt,$e=a(),d(Q.$$.fragment),Ve=a(),H=o("p"),H.textContent=jt,Xe=a(),z=o("p"),z.innerHTML=Ct,Re=a(),d(A.$$.fragment),ke=a(),F=o("p"),F.innerHTML=Zt,Se=a(),d(C.$$.fragment),xe=a(),d(Z.$$.fragment),Ee=a(),d(L.$$.fragment),Ne=a(),d(_.$$.fragment),Ye=a(),P=o("p"),P.innerHTML=_t,Qe=a(),q=o("p"),q.innerHTML=gt,He=a(),D=o("p"),D.textContent=It,ze=a(),K=o("p"),K.innerHTML=Bt,Ae=a(),d(O.$$.fragment),Fe=a(),d(g.$$.fragment),Le=a(),d(ee.$$.fragment),Pe=a(),te=o("p"),te.textContent=Wt,qe=a(),le=o("p"),le.textContent=Gt,De=a(),d(se.$$.fragment),Ke=a(),d(ne.$$.fragment),Oe=a(),ae=o("p"),ae.innerHTML=vt,et=a(),ie=o("p"),ie.textContent=$t,tt=a(),d(pe.$$.fragment),lt=a(),oe=o("p"),oe.innerHTML=Vt,st=a(),d(me.$$.fragment),nt=a(),d(re.$$.fragment),at=a(),ce=o("p"),ce.innerHTML=Xt,it=a(),d(I.$$.fragment),pt=a(),ue=o("p"),ue.textContent=Rt,ot=a(),fe=o("ul"),fe.innerHTML=kt,mt=a(),de=o("p"),de.innerHTML=St,rt=a(),d(Me.$$.fragment),ct=a(),ye=o("p"),ye.innerHTML=xt,ut=a(),Je=o("p"),this.h()},l(e){const t=Kt("svelte-u9bgzb",document.head);n=m(t,"META",{name:!0,content:!0}),t.forEach(l),f=i(e),p=m(e,"P",{}),At(p).forEach(l),c=i(e),M(b.$$.fragment,e),u=i(e),T=m(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-18ag1qn"&&(T.textContent=dt),Te=i(e),M(j.$$.fragment,e),Ue=i(e),G=m(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1nfsyhf"&&(G.textContent=Mt),be=i(e),v=m(e,"TABLE",{"data-svelte-h":!0}),r(v)!=="svelte-qiiy0g"&&(v.innerHTML=yt),je=i(e),M($.$$.fragment,e),Ce=i(e),V=m(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-g37v30"&&(V.innerHTML=ht),Ze=i(e),X=m(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1ux1t0a"&&(X.innerHTML=wt),_e=i(e),M(R.$$.fragment,e),ge=i(e),k=m(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-fte8mn"&&(k.textContent=Jt),Ie=i(e),M(S.$$.fragment,e),Be=i(e),x=m(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1g0rx31"&&(x.innerHTML=Tt),We=i(e),E=m(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-wr7ue3"&&(E.innerHTML=Ut),Ge=i(e),M(N.$$.fragment,e),ve=i(e),Y=m(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-nyzaca"&&(Y.textContent=bt),$e=i(e),M(Q.$$.fragment,e),Ve=i(e),H=m(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-435lli"&&(H.textContent=jt),Xe=i(e),z=m(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-l77fg6"&&(z.innerHTML=Ct),Re=i(e),M(A.$$.fragment,e),ke=i(e),F=m(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-153k8wf"&&(F.innerHTML=Zt),Se=i(e),M(C.$$.fragment,e),xe=i(e),M(Z.$$.fragment,e),Ee=i(e),M(L.$$.fragment,e),Ne=i(e),M(_.$$.fragment,e),Ye=i(e),P=m(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1w0xgx8"&&(P.innerHTML=_t),Qe=i(e),q=m(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-nislc4"&&(q.innerHTML=gt),He=i(e),D=m(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-11gjm3"&&(D.textContent=It),ze=i(e),K=m(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1x60rf2"&&(K.innerHTML=Bt),Ae=i(e),M(O.$$.fragment,e),Fe=i(e),M(g.$$.fragment,e),Le=i(e),M(ee.$$.fragment,e),Pe=i(e),te=m(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-sky5la"&&(te.textContent=Wt),qe=i(e),le=m(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-mhdc10"&&(le.textContent=Gt),De=i(e),M(se.$$.fragment,e),Ke=i(e),M(ne.$$.fragment,e),Oe=i(e),ae=m(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1hj6sqj"&&(ae.innerHTML=vt),et=i(e),ie=m(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1ca1ko1"&&(ie.textContent=$t),tt=i(e),M(pe.$$.fragment,e),lt=i(e),oe=m(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-mpebhd"&&(oe.innerHTML=Vt),st=i(e),M(me.$$.fragment,e),nt=i(e),M(re.$$.fragment,e),at=i(e),ce=m(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1tu2ji2"&&(ce.innerHTML=Xt),it=i(e),M(I.$$.fragment,e),pt=i(e),ue=m(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-rpfoyf"&&(ue.textContent=Rt),ot=i(e),fe=m(e,"UL",{"data-svelte-h":!0}),r(fe)!=="svelte-1q6gndt"&&(fe.innerHTML=kt),mt=i(e),de=m(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-141yc6t"&&(de.innerHTML=St),rt=i(e),M(Me.$$.fragment,e),ct=i(e),ye=m(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1nf2kxh"&&(ye.innerHTML=xt),ut=i(e),Je=m(e,"P",{}),At(Je).forEach(l),this.h()},h(){Ft(n,"name","hf:doc:metadata"),Ft(n,"content",ol)},m(e,t){Ot(document.head,n),s(e,f,t),s(e,p,t),s(e,c,t),y(b,e,t),s(e,u,t),s(e,T,t),s(e,Te,t),y(j,e,t),s(e,Ue,t),s(e,G,t),s(e,be,t),s(e,v,t),s(e,je,t),y($,e,t),s(e,Ce,t),s(e,V,t),s(e,Ze,t),s(e,X,t),s(e,_e,t),y(R,e,t),s(e,ge,t),s(e,k,t),s(e,Ie,t),y(S,e,t),s(e,Be,t),s(e,x,t),s(e,We,t),s(e,E,t),s(e,Ge,t),y(N,e,t),s(e,ve,t),s(e,Y,t),s(e,$e,t),y(Q,e,t),s(e,Ve,t),s(e,H,t),s(e,Xe,t),s(e,z,t),s(e,Re,t),y(A,e,t),s(e,ke,t),s(e,F,t),s(e,Se,t),y(C,e,t),s(e,xe,t),y(Z,e,t),s(e,Ee,t),y(L,e,t),s(e,Ne,t),y(_,e,t),s(e,Ye,t),s(e,P,t),s(e,Qe,t),s(e,q,t),s(e,He,t),s(e,D,t),s(e,ze,t),s(e,K,t),s(e,Ae,t),y(O,e,t),s(e,Fe,t),y(g,e,t),s(e,Le,t),y(ee,e,t),s(e,Pe,t),s(e,te,t),s(e,qe,t),s(e,le,t),s(e,De,t),y(se,e,t),s(e,Ke,t),y(ne,e,t),s(e,Oe,t),s(e,ae,t),s(e,et,t),s(e,ie,t),s(e,tt,t),y(pe,e,t),s(e,lt,t),s(e,oe,t),s(e,st,t),y(me,e,t),s(e,nt,t),y(re,e,t),s(e,at,t),s(e,ce,t),s(e,it,t),y(I,e,t),s(e,pt,t),s(e,ue,t),s(e,ot,t),s(e,fe,t),s(e,mt,t),s(e,de,t),s(e,rt,t),y(Me,e,t),s(e,ct,t),s(e,ye,t),s(e,ut,t),s(e,Je,t),ft=!0},p(e,[t]){const Et={};t&2&&(Et.$$scope={dirty:t,ctx:e}),j.$set(Et);const Nt={};t&2&&(Nt.$$scope={dirty:t,ctx:e}),C.$set(Nt);const Yt={};t&2&&(Yt.$$scope={dirty:t,ctx:e}),Z.$set(Yt);const Qt={};t&2&&(Qt.$$scope={dirty:t,ctx:e}),_.$set(Qt);const Ht={};t&2&&(Ht.$$scope={dirty:t,ctx:e}),g.$set(Ht);const zt={};t&2&&(zt.$$scope={dirty:t,ctx:e}),I.$set(zt)},i(e){ft||(h(b.$$.fragment,e),h(j.$$.fragment,e),h($.$$.fragment,e),h(R.$$.fragment,e),h(S.$$.fragment,e),h(N.$$.fragment,e),h(Q.$$.fragment,e),h(A.$$.fragment,e),h(C.$$.fragment,e),h(Z.$$.fragment,e),h(L.$$.fragment,e),h(_.$$.fragment,e),h(O.$$.fragment,e),h(g.$$.fragment,e),h(ee.$$.fragment,e),h(se.$$.fragment,e),h(ne.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),h(re.$$.fragment,e),h(I.$$.fragment,e),h(Me.$$.fragment,e),ft=!0)},o(e){w(b.$$.fragment,e),w(j.$$.fragment,e),w($.$$.fragment,e),w(R.$$.fragment,e),w(S.$$.fragment,e),w(N.$$.fragment,e),w(Q.$$.fragment,e),w(A.$$.fragment,e),w(C.$$.fragment,e),w(Z.$$.fragment,e),w(L.$$.fragment,e),w(_.$$.fragment,e),w(O.$$.fragment,e),w(g.$$.fragment,e),w(ee.$$.fragment,e),w(se.$$.fragment,e),w(ne.$$.fragment,e),w(pe.$$.fragment,e),w(me.$$.fragment,e),w(re.$$.fragment,e),w(I.$$.fragment,e),w(Me.$$.fragment,e),ft=!1},d(e){e&&(l(f),l(p),l(c),l(u),l(T),l(Te),l(Ue),l(G),l(be),l(v),l(je),l(Ce),l(V),l(Ze),l(X),l(_e),l(ge),l(k),l(Ie),l(Be),l(x),l(We),l(E),l(Ge),l(ve),l(Y),l($e),l(Ve),l(H),l(Xe),l(z),l(Re),l(ke),l(F),l(Se),l(xe),l(Ee),l(Ne),l(Ye),l(P),l(Qe),l(q),l(He),l(D),l(ze),l(K),l(Ae),l(Fe),l(Le),l(Pe),l(te),l(qe),l(le),l(De),l(Ke),l(Oe),l(ae),l(et),l(ie),l(tt),l(lt),l(oe),l(st),l(nt),l(at),l(ce),l(it),l(pt),l(ue),l(ot),l(fe),l(mt),l(de),l(rt),l(ct),l(ye),l(ut),l(Je)),l(n),J(b,e),J(j,e),J($,e),J(R,e),J(S,e),J(N,e),J(Q,e),J(A,e),J(C,e),J(Z,e),J(L,e),J(_,e),J(O,e),J(g,e),J(ee,e),J(se,e),J(ne,e),J(pe,e),J(me,e),J(re,e),J(I,e),J(Me,e)}}}const ol='{"title":"Reduce memory usage","local":"reduce-memory-usage","sections":[{"title":"Sliced VAE","local":"sliced-vae","sections":[],"depth":2},{"title":"Tiled VAE","local":"tiled-vae","sections":[],"depth":2},{"title":"CPU offloading","local":"cpu-offloading","sections":[],"depth":2},{"title":"Model offloading","local":"model-offloading","sections":[],"depth":2},{"title":"Channels-last memory format","local":"channels-last-memory-format","sections":[],"depth":2},{"title":"Tracing","local":"tracing","sections":[],"depth":2},{"title":"Memory-efficient attention","local":"memory-efficient-attention","sections":[],"depth":2}],"depth":1}';function ml(U){return Pt(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=el}),[]}class Ml extends qt{constructor(n){super(),Dt(this,n,ml,pl,Lt,{})}}export{Ml as component};
