import{s as wa,n as ba,o as va}from"../chunks/scheduler.182ea377.js";import{S as xa,i as $a,g as l,s as o,r as u,A as Ta,h as a,f as i,c as n,j as ri,u as f,x as r,k as ui,y,a as s,v as h,d as p,t as d,w as m}from"../chunks/index.1ea56653.js";import{H as c,g as ka}from"../chunks/Heading.71ac6e9f.js";import{C as g}from"../chunks/CodeBlock.82c2494b.js";function Ma(dn){let b,yi,ci,wi,k,bi,M,mn="We ❤️ contributions from the open-source community! Everyone is welcome, and all types of participation –not just code– are valued and appreciated. Answering questions, helping others, reaching out, and improving the documentation are all immensely valuable to the community, so don’t be afraid and get involved if you’re up for it!",vi,C,cn='Everyone is encouraged to start by saying 👋 in our public Discord channel. We discuss the latest trends in diffusion models, ask questions, show off personal projects, help each other with contributions, or just hang out ☕. <a href="https://Discord.gg/G7tWnz98XR"><img alt="Join us on Discord" src="https://img.shields.io/discord/823813159592001537?color=5865F2&amp;logo=discord&amp;logoColor=white"/></a>',xi,H,gn='Whichever way you choose to contribute, we strive to be part of an open, welcoming, and kind community. Please, read our <a href="https://github.com/huggingface/diffusers/blob/main/CODE_OF_CONDUCT.md" rel="nofollow">code of conduct</a> and be mindful to respect it during your interactions. We also recommend you become familiar with the <a href="https://huggingface.co/docs/diffusers/conceptual/ethical_guidelines" rel="nofollow">ethical guidelines</a> that guide our project and ask you to adhere to the same principles of transparency and responsibility.',$i,L,yn="We enormously value feedback from the community, so please do not be afraid to speak up if you believe you have valuable feedback that can help improve the library - every message, comment, issue, and pull request (PR) is read and considered.",Ti,P,ki,I,wn=`You can contribute in many ways ranging from answering questions on issues to adding new diffusion models to
the core library.`,Mi,_,bn="In the following, we give an overview of different ways to contribute, ranked by difficulty in ascending order. All of them are valuable to the community.",Ci,q,vn='<li><ol><li>Asking and answering questions on <a href="https://discuss.huggingface.co/c/discussion-related-to-httpsgithubcomhuggingfacediffusers" rel="nofollow">the Diffusers discussion forum</a> or on <a href="https://discord.gg/G7tWnz98XR" rel="nofollow">Discord</a>.</li></ol></li> <li><ol start="2"><li>Opening new issues on <a href="https://github.com/huggingface/diffusers/issues/new/choose" rel="nofollow">the GitHub Issues tab</a>.</li></ol></li> <li><ol start="3"><li>Answering issues on <a href="https://github.com/huggingface/diffusers/issues" rel="nofollow">the GitHub Issues tab</a>.</li></ol></li> <li><ol start="4"><li>Fix a simple issue, marked by the “Good first issue” label, see <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22good+first+issue%22" rel="nofollow">here</a>.</li></ol></li> <li><ol start="5"><li>Contribute to the <a href="https://github.com/huggingface/diffusers/tree/main/docs/source" rel="nofollow">documentation</a>.</li></ol></li> <li><ol start="6"><li>Contribute a <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3Acommunity-examples" rel="nofollow">Community Pipeline</a>.</li></ol></li> <li><ol start="7"><li>Contribute to the <a href="https://github.com/huggingface/diffusers/tree/main/examples" rel="nofollow">examples</a>.</li></ol></li> <li><ol start="8"><li>Fix a more difficult issue, marked by the “Good second issue” label, see <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22Good+second+issue%22" rel="nofollow">here</a>.</li></ol></li> <li><ol start="9"><li>Add a new pipeline, model, or scheduler, see <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22New+pipeline%2Fmodel%22" rel="nofollow">“New Pipeline/Model”</a> and <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22New+scheduler%22" rel="nofollow">“New scheduler”</a> issues. For this contribution, please have a look at <a href="https://github.com/huggingface/diffusers/blob/main/PHILOSOPHY.md" rel="nofollow">Design Philosophy</a>.</li></ol></li>',Hi,R,xn=`As said before, <strong>all contributions are valuable to the community</strong>.
In the following, we will explain each contribution a bit more in detail.`,Li,A,$n='For all contributions 4 - 9, you will need to open a PR. It is explained in detail how to do so in <a href="#how-to-open-a-pr">Opening a pull request</a>.',Pi,J,Ii,U,Tn='Any question or comment related to the Diffusers library can be asked on the <a href="https://discuss.huggingface.co/c/discussion-related-to-httpsgithubcomhuggingfacediffusers/" rel="nofollow">discussion forum</a> or on <a href="https://discord.gg/G7tWnz98XR" rel="nofollow">Discord</a>. Such questions and comments include (but are not limited to):',_i,G,kn="<li>Reports of training or inference experiments in an attempt to share knowledge</li> <li>Presentation of personal projects</li> <li>Questions to non-official training examples</li> <li>Project proposals</li> <li>General feedback</li> <li>Paper summaries</li> <li>Asking for help on personal projects that build on top of the Diffusers library</li> <li>General questions</li> <li>Ethical questions regarding diffusion models</li> <li>…</li>",qi,j,Mn=`Every question that is asked on the forum or on Discord actively encourages the community to publicly
share knowledge and might very well help a beginner in the future who has the same question you’re
having. Please do pose any questions you might have.
In the same spirit, you are of immense help to the community by answering such questions because this way you are publicly documenting knowledge for everybody to learn from.`,Ri,D,Cn=`<strong>Please</strong> keep in mind that the more effort you put into asking or answering a question, the higher
the quality of the publicly documented knowledge. In the same way, well-posed and well-answered questions create a high-quality knowledge database accessible to everybody, while badly posed questions or answers reduce the overall quality of the public knowledge database.
In short, a high quality question or answer is <em>precise</em>, <em>concise</em>, <em>relevant</em>, <em>easy-to-understand</em>, <em>accessible</em>, and <em>well-formated/well-posed</em>. For more information, please have a look through the <a href="#how-to-write-a-good-issue">How to write a good issue</a> section.`,Ai,W,Hn=`<strong>NOTE about channels</strong>:
<a href="https://discuss.huggingface.co/c/discussion-related-to-httpsgithubcomhuggingfacediffusers/63" rel="nofollow"><em>The forum</em></a> is much better indexed by search engines, such as Google. Posts are ranked by popularity rather than chronologically. Hence, it’s easier to look up questions and answers that we posted some time ago.
In addition, questions and answers posted in the forum can easily be linked to.
In contrast, <em>Discord</em> has a chat-like format that invites fast back-and-forth communication.
While it will most likely take less time for you to get an answer to your question on Discord, your
question won’t be visible anymore over time. Also, it’s much harder to find information that was posted a while back on Discord. We therefore strongly recommend using the forum for high-quality questions and answers in an attempt to create long-lasting knowledge for the community. If discussions on Discord lead to very interesting answers and conclusions, we recommend posting the results on the forum to make the information more available for future readers.`,Ji,Z,Ui,F,Ln=`The 🧨 Diffusers library is robust and reliable thanks to the users who notify us of
the problems they encounter. So thank you for reporting an issue.`,Gi,S,Pn="Remember, GitHub issues are reserved for technical questions directly related to the Diffusers library, bug reports, feature requests, or feedback on the library design.",ji,N,In='In a nutshell, this means that everything that is <strong>not</strong> related to the <strong>code of the Diffusers library</strong> (including the documentation) should <strong>not</strong> be asked on GitHub, but rather on either the <a href="https://discuss.huggingface.co/c/discussion-related-to-httpsgithubcomhuggingfacediffusers/63" rel="nofollow">forum</a> or <a href="https://discord.gg/G7tWnz98XR" rel="nofollow">Discord</a>.',Di,z,_n="<strong>Please consider the following guidelines when opening a new issue</strong>:",Wi,Y,qn=`<li>Make sure you have searched whether your issue has already been asked before (use the search bar on GitHub under Issues).</li> <li>Please never report a new issue on another (related) issue. If another issue is highly related, please
open a new issue nevertheless and link to the related issue.</li> <li>Make sure your issue is written in English. Please use one of the great, free online translation services, such as <a href="https://www.deepl.com/translator" rel="nofollow">DeepL</a> to translate from your native language to English if you are not comfortable in English.</li> <li>Check whether your issue might be solved by updating to the newest Diffusers version. Before posting your issue, please make sure that <code>python -c &quot;import diffusers; print(diffusers.__version__)&quot;</code> is higher or matches the latest Diffusers version.</li> <li>Remember that the more effort you put into opening a new issue, the higher the quality of your answer will be and the better the overall quality of the Diffusers issues.</li>`,Zi,X,Rn="New issues usually include the following.",Fi,E,Si,B,An=`A bug report should always have a reproducible code snippet and be as minimal and concise as possible.
This means in more detail:`,Ni,O,Jn='<li>Narrow the bug down as much as you can, <strong>do not just dump your whole code file</strong>.</li> <li>Format your code.</li> <li>Do not include any external libraries except for Diffusers depending on them.</li> <li><strong>Always</strong> provide all necessary information about your environment; for this, you can run: <code>diffusers-cli env</code> in your shell and copy-paste the displayed information to the issue.</li> <li>Explain the issue. If the reader doesn’t know what the issue is and why it is an issue, she cannot solve it.</li> <li><strong>Always</strong> make sure the reader can reproduce your issue with as little effort as possible. If your code snippet cannot be run because of missing libraries or undefined variables, the reader cannot help you. Make sure your reproducible code snippet is as minimal as possible and can be copy-pasted into a simple Python shell.</li> <li>If in order to reproduce your issue a model and/or dataset is required, make sure the reader has access to that model or dataset. You can always upload your model or dataset to the <a href="https://huggingface.co" rel="nofollow">Hub</a> to make it easily downloadable. Try to keep your model and dataset as small as possible, to make the reproduction of your issue as effortless as possible.</li>',zi,V,Un='For more information, please have a look through the <a href="#how-to-write-a-good-issue">How to write a good issue</a> section.',Yi,Q,Gn='You can open a bug report <a href="https://github.com/huggingface/diffusers/issues/new?assignees=&amp;labels=bug&amp;projects=&amp;template=bug-report.yml" rel="nofollow">here</a>.',Xi,K,Ei,ee,jn="A world-class feature request addresses the following points:",Bi,te,Dn="<li>Motivation first:</li>",Oi,ie,Wn=`<li>Is it related to a problem/frustration with the library? If so, please explain
why. Providing a code snippet that demonstrates the problem is best.</li> <li>Is it related to something you would need for a project? We’d love to hear
about it!</li> <li>Is it something you worked on and think could benefit the community?
Awesome! Tell us what problem it solved for you.</li>`,Vi,v,Zn="<li>Write a <em>full paragraph</em> describing the feature;</li> <li>Provide a <strong>code snippet</strong> that demonstrates its future use;</li> <li>In case this is related to a paper, please attach a link;</li> <li>Attach any additional information (drawings, screenshots, etc.) you think may help.</li>",Qi,se,Fn='You can open a feature request <a href="https://github.com/huggingface/diffusers/issues/new?assignees=&amp;labels=&amp;template=feature_request.md&amp;title=" rel="nofollow">here</a>.',Ki,oe,es,ne,Sn=`Feedback about the library design and why it is good or not good helps the core maintainers immensely to build a user-friendly library. To understand the philosophy behind the current design philosophy, please have a look <a href="https://huggingface.co/docs/diffusers/conceptual/philosophy" rel="nofollow">here</a>. If you feel like a certain design choice does not fit with the current design philosophy, please explain why and how it should be changed. If a certain design choice follows the design philosophy too much, hence restricting use cases, explain why and how it should be changed.
If a certain design choice is very useful for you, please also leave a note as this is great feedback for future design decisions.`,ts,le,Nn='You can open an issue about feedback <a href="https://github.com/huggingface/diffusers/issues/new?assignees=&amp;labels=&amp;template=feedback.md&amp;title=" rel="nofollow">here</a>.',is,ae,ss,re,zn=`Technical questions are mainly about why certain code of the library was written in a certain way, or what a certain part of the code does. Please make sure to link to the code in question and please provide details on
why this part of the code is difficult to understand.`,os,ue,Yn='You can open an issue about a technical question <a href="https://github.com/huggingface/diffusers/issues/new?assignees=&amp;labels=bug&amp;template=bug-report.yml" rel="nofollow">here</a>.',ns,fe,ls,he,Xn="If the diffusion model community released a new model, pipeline, or scheduler that you would like to see in the Diffusers library, please provide the following information:",as,pe,En="<li>Short description of the diffusion pipeline, model, or scheduler and link to the paper or public release.</li> <li>Link to any of its open-source implementation(s).</li> <li>Link to the model weights if they are available.</li>",rs,de,Bn=`If you are willing to contribute to the model yourself, let us know so we can best guide you. Also, don’t forget
to tag the original author of the component (model, scheduler, pipeline, etc.) by GitHub handle if you can find it.`,us,me,On='You can open a request for a model/pipeline/scheduler <a href="https://github.com/huggingface/diffusers/issues/new?assignees=&amp;labels=New+model%2Fpipeline%2Fscheduler&amp;template=new-model-addition.yml" rel="nofollow">here</a>.',fs,ce,hs,ge,Vn=`Answering issues on GitHub might require some technical knowledge of Diffusers, but we encourage everybody to give it a try even if you are not 100% certain that your answer is correct.
Some tips to give a high-quality answer to an issue:`,ps,ye,Qn="<li>Be as concise and minimal as possible.</li> <li>Stay on topic. An answer to the issue should concern the issue and only the issue.</li> <li>Provide links to code, papers, or other sources that prove or encourage your point.</li> <li>Answer in code. If a simple code snippet is the answer to the issue or shows how the issue can be solved, please provide a fully reproducible code snippet.</li>",ds,we,Kn=`Also, many issues tend to be simply off-topic, duplicates of other issues, or irrelevant. It is of great
help to the maintainers if you can answer such issues, encouraging the author of the issue to be
more precise, provide the link to a duplicated issue or redirect them to <a href="https://discuss.huggingface.co/c/discussion-related-to-httpsgithubcomhuggingfacediffusers/63" rel="nofollow">the forum</a> or <a href="https://discord.gg/G7tWnz98XR" rel="nofollow">Discord</a>.`,ms,be,el=`If you have verified that the issued bug report is correct and requires a correction in the source code,
please have a look at the next sections.`,cs,ve,tl='For all of the following contributions, you will need to open a PR. It is explained in detail how to do so in the <a href="#how-to-open-a-pr">Opening a pull request</a> section.',gs,xe,ys,$e,il=`<em>Good first issues</em> are marked by the <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22good+first+issue%22" rel="nofollow">Good first issue</a> label. Usually, the issue already
explains how a potential solution should look so that it is easier to fix.
If the issue hasn’t been closed and you would like to try to fix this issue, you can just leave a message “I would like to try this issue.”. There are usually three scenarios:`,ws,Te,sl="<li>a.) The issue description already proposes a fix. In this case and if the solution makes sense to you, you can open a PR or draft PR to fix it.</li> <li>b.) The issue description does not propose a fix. In this case, you can ask what a proposed fix could look like and someone from the Diffusers team should answer shortly. If you have a good idea of how to fix it, feel free to directly open a PR.</li> <li>c.) There is already an open PR to fix the issue, but the issue hasn’t been closed yet. If the PR has gone stale, you can simply open a new PR and link to the stale PR. PRs often go stale if the original contributor who wanted to fix the issue suddenly cannot find the time anymore to proceed. This often happens in open-source and is very normal. In this case, the community will be very happy if you give it a new try and leverage the knowledge of the existing PR. If there is already a PR and it is active, you can help the author by giving suggestions, reviewing the PR or even asking whether you can contribute to the PR.</li>",bs,ke,vs,Me,ol=`A good library <strong>always</strong> has good documentation! The official documentation is often one of the first points of contact for new users of the library, and therefore contributing to the documentation is a <strong>highly
valuable contribution</strong>.`,xs,Ce,nl="Contributing to the library can have many forms:",$s,He,ll="<li>Correcting spelling or grammatical errors.</li> <li>Correct incorrect formatting of the docstring. If you see that the official documentation is weirdly displayed or a link is broken, we would be very happy if you take some time to correct it.</li> <li>Correct the shape or dimensions of a docstring input or output tensor.</li> <li>Clarify documentation that is hard to understand or incorrect.</li> <li>Update outdated code examples.</li> <li>Translating the documentation to another language.</li>",Ts,Le,al='Anything displayed on <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">the official Diffusers doc page</a> is part of the official documentation and can be corrected, adjusted in the respective <a href="https://github.com/huggingface/diffusers/tree/main/docs/source" rel="nofollow">documentation source</a>.',ks,Pe,rl='Please have a look at <a href="https://github.com/huggingface/diffusers/tree/main/docs" rel="nofollow">this page</a> on how to verify changes made to the documentation locally.',Ms,Ie,Cs,_e,ul=`<a href="https://huggingface.co/docs/diffusers/api/pipelines/overview" rel="nofollow">Pipelines</a> are usually the first point of contact between the Diffusers library and the user.
Pipelines are examples of how to use Diffusers <a href="https://huggingface.co/docs/diffusers/api/models/overview" rel="nofollow">models</a> and <a href="https://huggingface.co/docs/diffusers/api/schedulers/overview" rel="nofollow">schedulers</a>.
We support two types of pipelines:`,Hs,qe,fl="<li>Official Pipelines</li> <li>Community Pipelines</li>",Ls,Re,hl="Both official and community pipelines follow the same design and consist of the same type of components.",Ps,Ae,pl=`Official pipelines are tested and maintained by the core maintainers of Diffusers. Their code
resides in <a href="https://github.com/huggingface/diffusers/tree/main/src/diffusers/pipelines" rel="nofollow">src/diffusers/pipelines</a>.
In contrast, community pipelines are contributed and maintained purely by the <strong>community</strong> and are <strong>not</strong> tested.
They reside in <a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">examples/community</a> and while they can be accessed via the <a href="https://pypi.org/project/diffusers/" rel="nofollow">PyPI diffusers package</a>, their code is not part of the PyPI distribution.`,Is,Je,dl=`The reason for the distinction is that the core maintainers of the Diffusers library cannot maintain and test all
possible ways diffusion models can be used for inference, but some of them may be of interest to the community.
Officially released diffusion pipelines,
such as Stable Diffusion are added to the core src/diffusers/pipelines package which ensures
high quality of maintenance, no backward-breaking code changes, and testing.
More bleeding edge pipelines should be added as community pipelines. If usage for a community pipeline is high, the pipeline can be moved to the official pipelines upon request from the community. This is one of the ways we strive to be a community-driven library.`,_s,Ue,ml='To add a community pipeline, one should add a &lt;name-of-the-community&gt;.py file to <a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">examples/community</a> and adapt the <a href="https://github.com/huggingface/diffusers/tree/main/examples/community/README.md" rel="nofollow">examples/community/README.md</a> to include an example of the new pipeline.',qs,Ge,cl='An example can be seen <a href="https://github.com/huggingface/diffusers/pull/2400" rel="nofollow">here</a>.',Rs,je,gl="Community pipeline PRs are only checked at a superficial level and ideally they should be maintained by their original authors.",As,De,yl=`Contributing a community pipeline is a great way to understand how Diffusers models and schedulers work. Having contributed a community pipeline is usually the first stepping stone to contributing an official pipeline to the
core package.`,Js,We,Us,Ze,wl='Diffusers examples are a collection of training scripts that reside in <a href="https://github.com/huggingface/diffusers/tree/main/examples" rel="nofollow">examples</a>.',Gs,Fe,bl="We support two types of training examples:",js,Se,vl="<li>Official training examples</li> <li>Research training examples</li>",Ds,Ne,xl=`Research training examples are located in <a href="https://github.com/huggingface/diffusers/tree/main/examples/research_projects" rel="nofollow">examples/research_projects</a> whereas official training examples include all folders under <a href="https://github.com/huggingface/diffusers/tree/main/examples" rel="nofollow">examples</a> except the <code>research_projects</code> and <code>community</code> folders.
The official training examples are maintained by the Diffusers’ core maintainers whereas the research training examples are maintained by the community.
This is because of the same reasons put forward in <a href="#6-contribute-a-community-pipeline">6. Contribute a community pipeline</a> for official pipelines vs. community pipelines: It is not feasible for the core maintainers to maintain all possible training methods for diffusion models.
If the Diffusers core maintainers and the community consider a certain training paradigm to be too experimental or not popular enough, the corresponding training code should be put in the <code>research_projects</code> folder and maintained by the author.`,Ws,ze,$l=`Both official training and research examples consist of a directory that contains one or more training scripts, a requirements.txt file, and a README.md file. In order for the user to make use of the
training examples, it is required to clone the repository:`,Zs,Ye,Fs,Xe,Tl="as well as to install all additional dependencies required for training:",Ss,Ee,Ns,Be,kl='Therefore when adding an example, the <code>requirements.txt</code> file shall define all pip dependencies required for your training example so that once all those are installed, the user can run the example’s training script. See, for example, the <a href="https://github.com/huggingface/diffusers/blob/main/examples/dreambooth/requirements.txt" rel="nofollow">DreamBooth <code>requirements.txt</code> file</a>.',zs,Oe,Ml="Training examples of the Diffusers library should adhere to the following philosophy:",Ys,Ve,Cl="<li>All the code necessary to run the examples should be found in a single Python file.</li> <li>One should be able to run the example from the command line with <code>python &lt;your-example&gt;.py --args</code>.</li> <li>Examples should be kept simple and serve as <strong>an example</strong> on how to use Diffusers for training. The purpose of example scripts is <strong>not</strong> to create state-of-the-art diffusion models, but rather to reproduce known training schemes without adding too much custom logic. As a byproduct of this point, our examples also strive to serve as good educational materials.</li>",Xs,Qe,Hl=`To contribute an example, it is highly recommended to look at already existing examples such as <a href="https://github.com/huggingface/diffusers/blob/main/examples/dreambooth/train_dreambooth.py" rel="nofollow">dreambooth</a> to get an idea of how they should look like.
We strongly advise contributors to make use of the <a href="https://github.com/huggingface/accelerate" rel="nofollow">Accelerate library</a> as it’s tightly integrated
with Diffusers.
Once an example script works, please make sure to add a comprehensive <code>README.md</code> that states how to use the example exactly. This README should include:`,Es,Ke,Ll='<li>An example command on how to run the example script as shown <a href="https://github.com/huggingface/diffusers/tree/main/examples/dreambooth#running-locally-with-pytorch" rel="nofollow">here</a>.</li> <li>A link to some training results (logs, models, etc.) that show what the user can expect as shown <a href="https://api.wandb.ai/report/patrickvonplaten/xm6cd5q5" rel="nofollow">here</a>.</li> <li>If you are adding a non-official/research training example, <strong>please don’t forget</strong> to add a sentence that you are maintaining this training example which includes your git handle as shown <a href="https://github.com/huggingface/diffusers/tree/main/examples/research_projects/intel_opts#diffusers-examples-with-intel-optimizations" rel="nofollow">here</a>.</li>',Bs,et,Pl='If you are contributing to the official training examples, please also make sure to add a test to <a href="https://github.com/huggingface/diffusers/blob/main/examples/test_examples.py" rel="nofollow">examples/test_examples.py</a>. This is not necessary for non-official training examples.',Os,tt,Vs,it,Il=`<em>Good second issues</em> are marked by the <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22Good+second+issue%22" rel="nofollow">Good second issue</a> label. Good second issues are
usually more complicated to solve than <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22good+first+issue%22" rel="nofollow">Good first issues</a>.
The issue description usually gives less guidance on how to fix the issue and requires
a decent understanding of the library by the interested contributor.
If you are interested in tackling a good second issue, feel free to open a PR to fix it and link the PR to the issue. If you see that a PR has already been opened for this issue but did not get merged, have a look to understand why it wasn’t merged and try to open an improved PR.
Good second issues are usually more difficult to get merged compared to good first issues, so don’t hesitate to ask for help from the core maintainers. If your PR is almost finished the core maintainers can also jump into your PR and commit to it in order to get it merged.`,Qs,st,Ks,ot,_l=`Pipelines, models, and schedulers are the most important pieces of the Diffusers library.
They provide easy access to state-of-the-art diffusion technologies and thus allow the community to
build powerful generative AI applications.`,eo,nt,ql="By adding a new model, pipeline, or scheduler you might enable a new powerful use case for any of the user interfaces relying on Diffusers which can be of immense value for the whole generative AI ecosystem.",to,lt,Rl=`Diffusers has a couple of open feature requests for all three components - feel free to gloss over them
if you don’t know yet what specific component you would like to add:`,io,at,Al='<li><a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22New+pipeline%2Fmodel%22" rel="nofollow">Model or pipeline</a></li> <li><a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22New+scheduler%22" rel="nofollow">Scheduler</a></li>',so,rt,Jl=`Before adding any of the three components, it is strongly recommended that you give the <a href="philosophy">Philosophy guide</a> a read to better understand the design of any of the three components. Please be aware that
we cannot merge model, scheduler, or pipeline additions that strongly diverge from our design philosophy
as it will lead to API inconsistencies. If you fundamentally disagree with a design choice, please
open a <a href="https://github.com/huggingface/diffusers/issues/new?assignees=&amp;labels=&amp;template=feedback.md&amp;title=" rel="nofollow">Feedback issue</a> instead so that it can be discussed whether a certain design
pattern/design choice shall be changed everywhere in the library and whether we shall update our design philosophy. Consistency across the library is very important for us.`,oo,ut,Ul=`Please make sure to add links to the original codebase/paper to the PR and ideally also ping the
original author directly on the PR so that they can follow the progress and potentially help with questions.`,no,ft,Gl="If you are unsure or stuck in the PR, don’t hesitate to leave a message to ask for a first review or help.",lo,ht,ao,pt,jl="<strong>The better your issue is written, the higher the chances that it will be quickly resolved.</strong>",ro,dt,Dl='<li>Make sure that you’ve used the correct template for your issue. You can pick between <em>Bug Report</em>, <em>Feature Request</em>, <em>Feedback about API Design</em>, <em>New model/pipeline/scheduler addition</em>, <em>Forum</em>, or a blank issue. Make sure to pick the correct one when opening <a href="https://github.com/huggingface/diffusers/issues/new/choose" rel="nofollow">a new issue</a>.</li> <li><strong>Be precise</strong>: Give your issue a fitting title. Try to formulate your issue description as simple as possible. The more precise you are when submitting an issue, the less time it takes to understand the issue and potentially solve it. Make sure to open an issue for one issue only and not for multiple issues. If you found multiple issues, simply open multiple issues. If your issue is a bug, try to be as precise as possible about what bug it is - you should not just write “Error in diffusers”.</li> <li><strong>Reproducibility</strong>: No reproducible code snippet == no solution. If you encounter a bug, maintainers <strong>have to be able to reproduce</strong> it. Make sure that you include a code snippet that can be copy-pasted into a Python interpreter to reproduce the issue. Make sure that your code snippet works, <em>i.e.</em> that there are no missing imports or missing links to images, … Your issue should contain an error message <strong>and</strong> a code snippet that can be copy-pasted without any changes to reproduce the exact same error message. If your issue is using local model weights or local data that cannot be accessed by the reader, the issue cannot be solved. If you cannot share your data or model, try to make a dummy model or dummy data.</li> <li><strong>Minimalistic</strong>: Try to help the reader as much as you can to understand the issue as quickly as possible by staying as concise as possible. Remove all code / all information that is irrelevant to the issue. If you have found a bug, try to create the easiest code example you can to demonstrate your issue, do not just dump your whole workflow into the issue as soon as you have found a bug. E.g., if you train a model and get an error at some point during the training, you should first try to understand what part of the training code is responsible for the error and try to reproduce it with a couple of lines. Try to use dummy data instead of full datasets.</li> <li>Add links. If you are referring to a certain naming, method, or model make sure to provide a link so that the reader can better understand what you mean. If you are referring to a specific PR or issue, make sure to link it to your issue. Do not assume that the reader knows what you are talking about. The more links you add to your issue the better.</li> <li>Formatting. Make sure to nicely format your issue by formatting code into Python code syntax, and error messages into normal code syntax. See the <a href="https://docs.github.com/en/get-started/writing-on-github/getting-started-with-writing-and-formatting-on-github/basic-writing-and-formatting-syntax" rel="nofollow">official GitHub formatting docs</a> for more information.</li> <li>Think of your issue not as a ticket to be solved, but rather as a beautiful entry to a well-written encyclopedia. Every added issue is a contribution to publicly available knowledge. By adding a nicely written issue you not only make it easier for maintainers to solve your issue, but you are helping the whole community to better understand a certain aspect of the library.</li>',uo,mt,fo,ct,Wl=`<li>Be a chameleon. Understand existing design patterns and syntax and make sure your code additions flow seamlessly into the existing code base. Pull requests that significantly diverge from existing design patterns or user interfaces will not be merged.</li> <li>Be laser focused. A pull request should solve one problem and one problem only. Make sure to not fall into the trap of “also fixing another problem while we’re adding it”. It is much more difficult to review pull requests that solve multiple, unrelated problems at once.</li> <li>If helpful, try to add a code snippet that displays an example of how your addition can be used.</li> <li>The title of your pull request should be a summary of its contribution.</li> <li>If your pull request addresses an issue, please mention the issue number in
the pull request description to make sure they are linked (and people
consulting the issue know you are working on it);</li> <li>To indicate a work in progress please prefix the title with <code>[WIP]</code>. These
are useful to avoid duplicated work, and to differentiate it from PRs ready
to be merged;</li> <li>Try to formulate and format your text as explained in <a href="#how-to-write-a-good-issue">How to write a good issue</a>.</li> <li>Make sure existing tests pass;</li> <li>Add high-coverage tests. No quality testing = no merge.</li>`,ho,gt,Zl=`<li>If you are adding new <code>@slow</code> tests, make sure they pass using
<code>RUN_SLOW=1 python -m pytest tests/test_my_new_model.py</code>.
CircleCI does not run the slow tests, but GitHub Actions does every night!</li>`,po,x,Fl=`<li>All public methods must have informative docstrings that work nicely with markdown. See <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/latent_diffusion/pipeline_latent_diffusion.py" rel="nofollow"><code>pipeline_latent_diffusion.py</code></a> for an example.</li> <li>Due to the rapidly growing repository, it is important to make sure that no files that would significantly weigh down the repository are added. This includes images, videos, and other non-text files. We prefer to leverage a hf.co hosted <code>dataset</code> like
<a href="https://huggingface.co/hf-internal-testing" rel="nofollow"><code>hf-internal-testing</code></a> or <a href="https://huggingface.co/datasets/huggingface/documentation-images" rel="nofollow">huggingface/documentation-images</a> to place these files.
If an external contribution, feel free to add the images to your PR and ask a Hugging Face member to migrate your images
to this dataset.</li>`,mo,yt,co,wt,Sl=`Before writing code, we strongly advise you to search through the existing PRs or
issues to make sure that nobody is already working on the same thing. If you are
unsure, it is always a good idea to open an issue to get some feedback.`,go,bt,Nl=`You will need basic <code>git</code> proficiency to be able to contribute to
🧨 Diffusers. <code>git</code> is not the easiest tool to use but it has the greatest
manual. Type <code>git --help</code> in a shell and enjoy. If you prefer books, <a href="https://git-scm.com/book/en/v2" rel="nofollow">Pro
Git</a> is a very good reference.`,yo,vt,zl='Follow these steps to start contributing (<a href="https://github.com/huggingface/diffusers/blob/main/setup.py#L244" rel="nofollow">supported Python versions</a>):',wo,w,fi,Yl=`<p>Fork the <a href="https://github.com/huggingface/diffusers" rel="nofollow">repository</a> by
clicking on the ‘Fork’ button on the repository’s page. This creates a copy of the code
under your GitHub user account.</p>`,rn,xt,hi,Xl="Clone your fork to your local disk, and add the base repository as a remote:",un,$t,fn,Tt,pi,El="Create a new branch to hold your development changes:",hn,kt,bo,Mt,Bl="<strong>Do not</strong> work on the <code>main</code> branch.",vo,Ct,Ht,di,Ol="Set up a development environment by running the following command in a virtual environment:",pn,Lt,xo,Pt,Vl=`If you have already cloned the repo, you might need to <code>git pull</code> to get the most recent changes in the
library.`,$o,$,Ql="<li>Develop the features on your branch.</li>",To,It,Kl=`As you work on the features, you should make sure that the test suite
passes. You should run the tests impacted by your changes like this:`,ko,_t,Mo,qt,ea=`Before you run the tests, please make sure you install the dependencies required for testing. You can do so
with this command:`,Co,Rt,Ho,At,ta=`You can also run the full test suite with the following command, but it takes
a beefy machine to produce a result in a decent amount of time now that
Diffusers has grown a lot. Here is the command for it:`,Lo,Jt,Po,Ut,ia=`🧨 Diffusers relies on <code>black</code> and <code>isort</code> to format its source code
consistently. After you make changes, apply automatic style corrections and code verifications
that can’t be automated in one go with:`,Io,Gt,_o,jt,sa=`🧨 Diffusers also uses <code>ruff</code> and a few custom scripts to check for coding mistakes. Quality
control runs in CI, however, you can also run the same checks with:`,qo,Dt,Ro,Wt,oa=`Once you’re happy with your changes, add changed files using <code>git add</code> and
make a commit with <code>git commit</code> to record your changes locally:`,Ao,Zt,Jo,Ft,na=`It is a good idea to sync your copy of the code with the original
repository regularly. This way you can quickly account for changes:`,Uo,St,Go,Nt,la="Push the changes to your account using:",jo,zt,Do,T,aa=`<li><p>Once you are satisfied, go to the
webpage of your fork on GitHub. Click on ‘Pull request’ to send your changes
to the project maintainers for review.</p></li> <li><p>It’s OK if maintainers ask you for changes. It happens to core contributors
too! So everyone can see the changes in the Pull request, work in your local
branch and push the changes to your fork. They will automatically appear in
the pull request.</p></li>`,Wo,Yt,Zo,Xt,ra=`An extensive test suite is included to test the library behavior and several examples. Library tests can be found in
the <a href="https://github.com/huggingface/diffusers/tree/main/tests" rel="nofollow">tests folder</a>.`,Fo,Et,ua=`We like <code>pytest</code> and <code>pytest-xdist</code> because it’s faster. From the root of the
repository, here’s how to run tests with <code>pytest</code> for the library:`,So,Bt,No,Ot,fa="In fact, that’s how <code>make test</code> is implemented!",zo,Vt,ha=`You can specify a smaller set of tests in order to test only the feature
you’re working on.`,Yo,Qt,pa=`By default, slow tests are skipped. Set the <code>RUN_SLOW</code> environment variable to
<code>yes</code> to run them. This will download many gigabytes of models — make sure you
have enough disk space and a good Internet connection, or a lot of patience!`,Xo,Kt,Eo,ei,da="<code>unittest</code> is fully supported, here’s how to run tests with it:",Bo,ti,Oo,ii,Vo,si,ma=`To avoid pinging the upstream repository which adds reference notes to each upstream PR and sends unnecessary notifications to the developers involved in these PRs,
when syncing the main branch of a forked repository, please, follow these steps:`,Qo,oi,ca="<li>When possible, avoid syncing with the upstream using a branch and PR on the forked repository. Instead, merge directly into the forked main.</li> <li>If a PR is absolutely necessary, use the following steps after checking out your branch:</li>",Ko,ni,en,li,tn,ai,ga='For documentation strings, 🧨 Diffusers follows the <a href="https://google.github.io/styleguide/pyguide.html" rel="nofollow">Google style</a>.',sn,gi,on;return k=new c({props:{title:"How to contribute to Diffusers 🧨",local:"how-to-contribute-to-diffusers-",headingTag:"h1"}}),P=new c({props:{title:"Overview",local:"overview",headingTag:"h2"}}),J=new c({props:{title:"1. Asking and answering questions on the Diffusers discussion forum or on the Diffusers Discord",local:"1-asking-and-answering-questions-on-the-diffusers-discussion-forum-or-on-the-diffusers-discord",headingTag:"h3"}}),Z=new c({props:{title:"2. Opening new issues on the GitHub issues tab",local:"2-opening-new-issues-on-the-github-issues-tab",headingTag:"h3"}}),E=new c({props:{title:"2.1. Reproducible, minimal bug reports",local:"21-reproducible-minimal-bug-reports",headingTag:"h4"}}),K=new c({props:{title:"2.2. Feature requests",local:"22-feature-requests",headingTag:"h4"}}),oe=new c({props:{title:"2.3 Feedback",local:"23-feedback",headingTag:"h4"}}),ae=new c({props:{title:"2.4 Technical questions",local:"24-technical-questions",headingTag:"h4"}}),fe=new c({props:{title:"2.5 Proposal to add a new model, scheduler, or pipeline",local:"25-proposal-to-add-a-new-model-scheduler-or-pipeline",headingTag:"h4"}}),ce=new c({props:{title:"3. Answering issues on the GitHub issues tab",local:"3-answering-issues-on-the-github-issues-tab",headingTag:"h3"}}),xe=new c({props:{title:"4. Fixing a “Good first issue”",local:"4-fixing-a-good-first-issue",headingTag:"h3"}}),ke=new c({props:{title:"5. Contribute to the documentation",local:"5-contribute-to-the-documentation",headingTag:"h3"}}),Ie=new c({props:{title:"6. Contribute a community pipeline",local:"6-contribute-a-community-pipeline",headingTag:"h3"}}),We=new c({props:{title:"7. Contribute to training examples",local:"7-contribute-to-training-examples",headingTag:"h3"}}),Ye=new g({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2Vycw==",highlighted:'git <span class="hljs-built_in">clone</span> https://github.com/huggingface/diffusers',wrap:!1}}),Ee=new g({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1yJTIwJTJGZXhhbXBsZXMlMkYlM0N5b3VyLWV4YW1wbGUtZm9sZGVyJTNFJTJGcmVxdWlyZW1lbnRzLnR4dA==",highlighted:"pip install -r /examples/&lt;your-example-folder&gt;/requirements.txt",wrap:!1}}),tt=new c({props:{title:"8. Fixing a “Good second issue”",local:"8-fixing-a-good-second-issue",headingTag:"h3"}}),st=new c({props:{title:"9. Adding pipelines, models, schedulers",local:"9-adding-pipelines-models-schedulers",headingTag:"h3"}}),ht=new c({props:{title:"How to write a good issue",local:"how-to-write-a-good-issue",headingTag:"h2"}}),mt=new c({props:{title:"How to write a good PR",local:"how-to-write-a-good-pr",headingTag:"h2"}}),yt=new c({props:{title:"How to open a PR",local:"how-to-open-a-pr",headingTag:"h2"}}),$t=new g({props:{code:"JTI0JTIwZ2l0JTIwY2xvbmUlMjBnaXQlNDBnaXRodWIuY29tJTNBJTNDeW91ciUyMEdpdEh1YiUyMGhhbmRsZSUzRSUyRmRpZmZ1c2Vycy5naXQlMEElMjQlMjBjZCUyMGRpZmZ1c2VycyUwQSUyNCUyMGdpdCUyMHJlbW90ZSUyMGFkZCUyMHVwc3RyZWFtJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZkaWZmdXNlcnMuZ2l0",highlighted:`$ git <span class="hljs-built_in">clone</span> git@github.com:&lt;your GitHub handle&gt;/diffusers.git
$ <span class="hljs-built_in">cd</span> diffusers
$ git remote add upstream https://github.com/huggingface/diffusers.git`,wrap:!1}}),kt=new g({props:{code:"JTI0JTIwZ2l0JTIwY2hlY2tvdXQlMjAtYiUyMGEtZGVzY3JpcHRpdmUtbmFtZS1mb3ItbXktY2hhbmdlcw==",highlighted:"$ git checkout -b a-descriptive-name-for-my-changes",wrap:!1}}),Lt=new g({props:{code:"JTI0JTIwcGlwJTIwaW5zdGFsbCUyMC1lJTIwJTIyLiU1QmRldiU1RCUyMg==",highlighted:'$ pip install -e <span class="hljs-string">&quot;.[dev]&quot;</span>',wrap:!1}}),_t=new g({props:{code:"JTI0JTIwcHl0ZXN0JTIwdGVzdHMlMkYlM0NURVNUX1RPX1JVTiUzRS5weQ==",highlighted:"$ pytest tests/&lt;TEST_TO_RUN&gt;.py",wrap:!1}}),Rt=new g({props:{code:"JTI0JTIwcGlwJTIwaW5zdGFsbCUyMC1lJTIwJTIyLiU1QnRlc3QlNUQlMjI=",highlighted:'$ pip install -e <span class="hljs-string">&quot;.[test]&quot;</span>',wrap:!1}}),Jt=new g({props:{code:"JTI0JTIwbWFrZSUyMHRlc3Q=",highlighted:'$ make <span class="hljs-built_in">test</span>',wrap:!1}}),Gt=new g({props:{code:"JTI0JTIwbWFrZSUyMHN0eWxl",highlighted:"$ make style",wrap:!1}}),Dt=new g({props:{code:"JTI0JTIwbWFrZSUyMHF1YWxpdHk=",highlighted:"$ make quality",wrap:!1}}),Zt=new g({props:{code:"JTI0JTIwZ2l0JTIwYWRkJTIwbW9kaWZpZWRfZmlsZS5weSUwQSUyNCUyMGdpdCUyMGNvbW1pdCUyMC1tJTIwJTIyQSUyMGRlc2NyaXB0aXZlJTIwbWVzc2FnZSUyMGFib3V0JTIweW91ciUyMGNoYW5nZXMuJTIy",highlighted:`$ git add modified_file.py
$ git commit -m <span class="hljs-string">&quot;A descriptive message about your changes.&quot;</span>`,wrap:!1}}),St=new g({props:{code:"JTI0JTIwZ2l0JTIwcHVsbCUyMHVwc3RyZWFtJTIwbWFpbg==",highlighted:"$ git pull upstream main",wrap:!1}}),zt=new g({props:{code:"JTI0JTIwZ2l0JTIwcHVzaCUyMC11JTIwb3JpZ2luJTIwYS1kZXNjcmlwdGl2ZS1uYW1lLWZvci1teS1jaGFuZ2Vz",highlighted:"$ git push -u origin a-descriptive-name-for-my-changes",wrap:!1}}),Yt=new c({props:{title:"Tests",local:"tests",headingTag:"h3"}}),Bt=new g({props:{code:"JTI0JTIwcHl0aG9uJTIwLW0lMjBweXRlc3QlMjAtbiUyMGF1dG8lMjAtLWRpc3QlM0Rsb2FkZmlsZSUyMC1zJTIwLXYlMjAuJTJGdGVzdHMlMkY=",highlighted:"$ python -m pytest -n auto --dist=loadfile -s -v ./tests/",wrap:!1}}),Kt=new g({props:{code:"JTI0JTIwUlVOX1NMT1clM0R5ZXMlMjBweXRob24lMjAtbSUyMHB5dGVzdCUyMC1uJTIwYXV0byUyMC0tZGlzdCUzRGxvYWRmaWxlJTIwLXMlMjAtdiUyMC4lMkZ0ZXN0cyUyRg==",highlighted:'$ RUN_SLOW=<span class="hljs-built_in">yes</span> python -m pytest -n auto --dist=loadfile -s -v ./tests/',wrap:!1}}),ti=new g({props:{code:"JTI0JTIwcHl0aG9uJTIwLW0lMjB1bml0dGVzdCUyMGRpc2NvdmVyJTIwLXMlMjB0ZXN0cyUyMC10JTIwLiUyMC12JTBBJTI0JTIwcHl0aG9uJTIwLW0lMjB1bml0dGVzdCUyMGRpc2NvdmVyJTIwLXMlMjBleGFtcGxlcyUyMC10JTIwZXhhbXBsZXMlMjAtdg==",highlighted:`$ python -m unittest discover -s tests -t . -v
$ python -m unittest discover -s examples -t examples -v`,wrap:!1}}),ii=new c({props:{title:"Syncing forked main with upstream (HuggingFace) main",local:"syncing-forked-main-with-upstream-huggingface-main",headingTag:"h3"}}),ni=new g({props:{code:"JTI0JTIwZ2l0JTIwY2hlY2tvdXQlMjAtYiUyMHlvdXItYnJhbmNoLWZvci1zeW5jaW5nJTBBJTI0JTIwZ2l0JTIwcHVsbCUyMC0tc3F1YXNoJTIwLS1uby1jb21taXQlMjB1cHN0cmVhbSUyMG1haW4lMEElMjQlMjBnaXQlMjBjb21taXQlMjAtbSUyMCclM0N5b3VyJTIwbWVzc2FnZSUyMHdpdGhvdXQlMjBHaXRIdWIlMjByZWZlcmVuY2VzJTNFJyUwQSUyNCUyMGdpdCUyMHB1c2glMjAtLXNldC11cHN0cmVhbSUyMG9yaWdpbiUyMHlvdXItYnJhbmNoLWZvci1zeW5jaW5n",highlighted:`$ git checkout -b your-branch-for-syncing
$ git pull --squash --no-commit upstream main
$ git commit -m <span class="hljs-string">&#x27;&lt;your message without GitHub references&gt;&#x27;</span>
$ git push --set-upstream origin your-branch-for-syncing`,wrap:!1}}),li=new c({props:{title:"Style guide",local:"style-guide",headingTag:"h3"}}),{c(){b=l("meta"),yi=o(),ci=l("p"),wi=o(),u(k.$$.fragment),bi=o(),M=l("p"),M.textContent=mn,vi=o(),C=l("p"),C.innerHTML=cn,xi=o(),H=l("p"),H.innerHTML=gn,$i=o(),L=l("p"),L.textContent=yn,Ti=o(),u(P.$$.fragment),ki=o(),I=l("p"),I.textContent=wn,Mi=o(),_=l("p"),_.textContent=bn,Ci=o(),q=l("ul"),q.innerHTML=vn,Hi=o(),R=l("p"),R.innerHTML=xn,Li=o(),A=l("p"),A.innerHTML=$n,Pi=o(),u(J.$$.fragment),Ii=o(),U=l("p"),U.innerHTML=Tn,_i=o(),G=l("ul"),G.innerHTML=kn,qi=o(),j=l("p"),j.textContent=Mn,Ri=o(),D=l("p"),D.innerHTML=Cn,Ai=o(),W=l("p"),W.innerHTML=Hn,Ji=o(),u(Z.$$.fragment),Ui=o(),F=l("p"),F.textContent=Ln,Gi=o(),S=l("p"),S.textContent=Pn,ji=o(),N=l("p"),N.innerHTML=In,Di=o(),z=l("p"),z.innerHTML=_n,Wi=o(),Y=l("ul"),Y.innerHTML=qn,Zi=o(),X=l("p"),X.textContent=Rn,Fi=o(),u(E.$$.fragment),Si=o(),B=l("p"),B.textContent=An,Ni=o(),O=l("ul"),O.innerHTML=Jn,zi=o(),V=l("p"),V.innerHTML=Un,Yi=o(),Q=l("p"),Q.innerHTML=Gn,Xi=o(),u(K.$$.fragment),Ei=o(),ee=l("p"),ee.textContent=jn,Bi=o(),te=l("ol"),te.innerHTML=Dn,Oi=o(),ie=l("ul"),ie.innerHTML=Wn,Vi=o(),v=l("ol"),v.innerHTML=Zn,Qi=o(),se=l("p"),se.innerHTML=Fn,Ki=o(),u(oe.$$.fragment),es=o(),ne=l("p"),ne.innerHTML=Sn,ts=o(),le=l("p"),le.innerHTML=Nn,is=o(),u(ae.$$.fragment),ss=o(),re=l("p"),re.textContent=zn,os=o(),ue=l("p"),ue.innerHTML=Yn,ns=o(),u(fe.$$.fragment),ls=o(),he=l("p"),he.textContent=Xn,as=o(),pe=l("ul"),pe.innerHTML=En,rs=o(),de=l("p"),de.textContent=Bn,us=o(),me=l("p"),me.innerHTML=On,fs=o(),u(ce.$$.fragment),hs=o(),ge=l("p"),ge.textContent=Vn,ps=o(),ye=l("ul"),ye.innerHTML=Qn,ds=o(),we=l("p"),we.innerHTML=Kn,ms=o(),be=l("p"),be.textContent=el,cs=o(),ve=l("p"),ve.innerHTML=tl,gs=o(),u(xe.$$.fragment),ys=o(),$e=l("p"),$e.innerHTML=il,ws=o(),Te=l("ul"),Te.innerHTML=sl,bs=o(),u(ke.$$.fragment),vs=o(),Me=l("p"),Me.innerHTML=ol,xs=o(),Ce=l("p"),Ce.textContent=nl,$s=o(),He=l("ul"),He.innerHTML=ll,Ts=o(),Le=l("p"),Le.innerHTML=al,ks=o(),Pe=l("p"),Pe.innerHTML=rl,Ms=o(),u(Ie.$$.fragment),Cs=o(),_e=l("p"),_e.innerHTML=ul,Hs=o(),qe=l("ul"),qe.innerHTML=fl,Ls=o(),Re=l("p"),Re.textContent=hl,Ps=o(),Ae=l("p"),Ae.innerHTML=pl,Is=o(),Je=l("p"),Je.textContent=dl,_s=o(),Ue=l("p"),Ue.innerHTML=ml,qs=o(),Ge=l("p"),Ge.innerHTML=cl,Rs=o(),je=l("p"),je.textContent=gl,As=o(),De=l("p"),De.textContent=yl,Js=o(),u(We.$$.fragment),Us=o(),Ze=l("p"),Ze.innerHTML=wl,Gs=o(),Fe=l("p"),Fe.textContent=bl,js=o(),Se=l("ul"),Se.innerHTML=vl,Ds=o(),Ne=l("p"),Ne.innerHTML=xl,Ws=o(),ze=l("p"),ze.textContent=$l,Zs=o(),u(Ye.$$.fragment),Fs=o(),Xe=l("p"),Xe.textContent=Tl,Ss=o(),u(Ee.$$.fragment),Ns=o(),Be=l("p"),Be.innerHTML=kl,zs=o(),Oe=l("p"),Oe.textContent=Ml,Ys=o(),Ve=l("ul"),Ve.innerHTML=Cl,Xs=o(),Qe=l("p"),Qe.innerHTML=Hl,Es=o(),Ke=l("ul"),Ke.innerHTML=Ll,Bs=o(),et=l("p"),et.innerHTML=Pl,Os=o(),u(tt.$$.fragment),Vs=o(),it=l("p"),it.innerHTML=Il,Qs=o(),u(st.$$.fragment),Ks=o(),ot=l("p"),ot.textContent=_l,eo=o(),nt=l("p"),nt.textContent=ql,to=o(),lt=l("p"),lt.textContent=Rl,io=o(),at=l("ul"),at.innerHTML=Al,so=o(),rt=l("p"),rt.innerHTML=Jl,oo=o(),ut=l("p"),ut.textContent=Ul,no=o(),ft=l("p"),ft.textContent=Gl,lo=o(),u(ht.$$.fragment),ao=o(),pt=l("p"),pt.innerHTML=jl,ro=o(),dt=l("ol"),dt.innerHTML=Dl,uo=o(),u(mt.$$.fragment),fo=o(),ct=l("ol"),ct.innerHTML=Wl,ho=o(),gt=l("ul"),gt.innerHTML=Zl,po=o(),x=l("ol"),x.innerHTML=Fl,mo=o(),u(yt.$$.fragment),co=o(),wt=l("p"),wt.textContent=Sl,go=o(),bt=l("p"),bt.innerHTML=Nl,yo=o(),vt=l("p"),vt.innerHTML=zl,wo=o(),w=l("ol"),fi=l("li"),fi.innerHTML=Yl,rn=o(),xt=l("li"),hi=l("p"),hi.textContent=Xl,un=o(),u($t.$$.fragment),fn=o(),Tt=l("li"),pi=l("p"),pi.textContent=El,hn=o(),u(kt.$$.fragment),bo=o(),Mt=l("p"),Mt.innerHTML=Bl,vo=o(),Ct=l("ol"),Ht=l("li"),di=l("p"),di.textContent=Ol,pn=o(),u(Lt.$$.fragment),xo=o(),Pt=l("p"),Pt.innerHTML=Vl,$o=o(),$=l("ol"),$.innerHTML=Ql,To=o(),It=l("p"),It.textContent=Kl,ko=o(),u(_t.$$.fragment),Mo=o(),qt=l("p"),qt.textContent=ea,Co=o(),u(Rt.$$.fragment),Ho=o(),At=l("p"),At.textContent=ta,Lo=o(),u(Jt.$$.fragment),Po=o(),Ut=l("p"),Ut.innerHTML=ia,Io=o(),u(Gt.$$.fragment),_o=o(),jt=l("p"),jt.innerHTML=sa,qo=o(),u(Dt.$$.fragment),Ro=o(),Wt=l("p"),Wt.innerHTML=oa,Ao=o(),u(Zt.$$.fragment),Jo=o(),Ft=l("p"),Ft.textContent=na,Uo=o(),u(St.$$.fragment),Go=o(),Nt=l("p"),Nt.textContent=la,jo=o(),u(zt.$$.fragment),Do=o(),T=l("ol"),T.innerHTML=aa,Wo=o(),u(Yt.$$.fragment),Zo=o(),Xt=l("p"),Xt.innerHTML=ra,Fo=o(),Et=l("p"),Et.innerHTML=ua,So=o(),u(Bt.$$.fragment),No=o(),Ot=l("p"),Ot.innerHTML=fa,zo=o(),Vt=l("p"),Vt.textContent=ha,Yo=o(),Qt=l("p"),Qt.innerHTML=pa,Xo=o(),u(Kt.$$.fragment),Eo=o(),ei=l("p"),ei.innerHTML=da,Bo=o(),u(ti.$$.fragment),Oo=o(),u(ii.$$.fragment),Vo=o(),si=l("p"),si.textContent=ma,Qo=o(),oi=l("ol"),oi.innerHTML=ca,Ko=o(),u(ni.$$.fragment),en=o(),u(li.$$.fragment),tn=o(),ai=l("p"),ai.innerHTML=ga,sn=o(),gi=l("p"),this.h()},l(e){const t=Ta("svelte-u9bgzb",document.head);b=a(t,"META",{name:!0,content:!0}),t.forEach(i),yi=n(e),ci=a(e,"P",{}),ri(ci).forEach(i),wi=n(e),f(k.$$.fragment,e),bi=n(e),M=a(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-5law2j"&&(M.textContent=mn),vi=n(e),C=a(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-rf5fv0"&&(C.innerHTML=cn),xi=n(e),H=a(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-7yk1qu"&&(H.innerHTML=gn),$i=n(e),L=a(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-19e4jq9"&&(L.textContent=yn),Ti=n(e),f(P.$$.fragment,e),ki=n(e),I=a(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-qchdhx"&&(I.textContent=wn),Mi=n(e),_=a(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-vste1h"&&(_.textContent=bn),Ci=n(e),q=a(e,"UL",{"data-svelte-h":!0}),r(q)!=="svelte-1kftoyd"&&(q.innerHTML=vn),Hi=n(e),R=a(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1a17ouk"&&(R.innerHTML=xn),Li=n(e),A=a(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1carl1x"&&(A.innerHTML=$n),Pi=n(e),f(J.$$.fragment,e),Ii=n(e),U=a(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-eooydc"&&(U.innerHTML=Tn),_i=n(e),G=a(e,"UL",{"data-svelte-h":!0}),r(G)!=="svelte-1pzwmv0"&&(G.innerHTML=kn),qi=n(e),j=a(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1gi90ut"&&(j.textContent=Mn),Ri=n(e),D=a(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1wkkt7q"&&(D.innerHTML=Cn),Ai=n(e),W=a(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-14aelba"&&(W.innerHTML=Hn),Ji=n(e),f(Z.$$.fragment,e),Ui=n(e),F=a(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1xkk71m"&&(F.textContent=Ln),Gi=n(e),S=a(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1kqqlyc"&&(S.textContent=Pn),ji=n(e),N=a(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-180qij7"&&(N.innerHTML=In),Di=n(e),z=a(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1fjofc5"&&(z.innerHTML=_n),Wi=n(e),Y=a(e,"UL",{"data-svelte-h":!0}),r(Y)!=="svelte-pzymlv"&&(Y.innerHTML=qn),Zi=n(e),X=a(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1gfbuxb"&&(X.textContent=Rn),Fi=n(e),f(E.$$.fragment,e),Si=n(e),B=a(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1ipsy1e"&&(B.textContent=An),Ni=n(e),O=a(e,"UL",{"data-svelte-h":!0}),r(O)!=="svelte-1mrun3g"&&(O.innerHTML=Jn),zi=n(e),V=a(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-b221ai"&&(V.innerHTML=Un),Yi=n(e),Q=a(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1vpz9iu"&&(Q.innerHTML=Gn),Xi=n(e),f(K.$$.fragment,e),Ei=n(e),ee=a(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1s92zhu"&&(ee.textContent=jn),Bi=n(e),te=a(e,"OL",{"data-svelte-h":!0}),r(te)!=="svelte-1meaa0h"&&(te.innerHTML=Dn),Oi=n(e),ie=a(e,"UL",{"data-svelte-h":!0}),r(ie)!=="svelte-1m6et35"&&(ie.innerHTML=Wn),Vi=n(e),v=a(e,"OL",{start:!0,"data-svelte-h":!0}),r(v)!=="svelte-1353nnk"&&(v.innerHTML=Zn),Qi=n(e),se=a(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1fbsnox"&&(se.innerHTML=Fn),Ki=n(e),f(oe.$$.fragment,e),es=n(e),ne=a(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-14r8j00"&&(ne.innerHTML=Sn),ts=n(e),le=a(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-19nmi90"&&(le.innerHTML=Nn),is=n(e),f(ae.$$.fragment,e),ss=n(e),re=a(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-w10b99"&&(re.textContent=zn),os=n(e),ue=a(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-117d5cx"&&(ue.innerHTML=Yn),ns=n(e),f(fe.$$.fragment,e),ls=n(e),he=a(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-10axoet"&&(he.textContent=Xn),as=n(e),pe=a(e,"UL",{"data-svelte-h":!0}),r(pe)!=="svelte-djw2fh"&&(pe.innerHTML=En),rs=n(e),de=a(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1g4ps0b"&&(de.textContent=Bn),us=n(e),me=a(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-sc0vav"&&(me.innerHTML=On),fs=n(e),f(ce.$$.fragment,e),hs=n(e),ge=a(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-15u5nyq"&&(ge.textContent=Vn),ps=n(e),ye=a(e,"UL",{"data-svelte-h":!0}),r(ye)!=="svelte-1utx7xe"&&(ye.innerHTML=Qn),ds=n(e),we=a(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1h98g7p"&&(we.innerHTML=Kn),ms=n(e),be=a(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1n38hfq"&&(be.textContent=el),cs=n(e),ve=a(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1aq6j4g"&&(ve.innerHTML=tl),gs=n(e),f(xe.$$.fragment,e),ys=n(e),$e=a(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-17d5j91"&&($e.innerHTML=il),ws=n(e),Te=a(e,"UL",{"data-svelte-h":!0}),r(Te)!=="svelte-csw3jn"&&(Te.innerHTML=sl),bs=n(e),f(ke.$$.fragment,e),vs=n(e),Me=a(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-p135hl"&&(Me.innerHTML=ol),xs=n(e),Ce=a(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-dmhl9b"&&(Ce.textContent=nl),$s=n(e),He=a(e,"UL",{"data-svelte-h":!0}),r(He)!=="svelte-1vfa69p"&&(He.innerHTML=ll),Ts=n(e),Le=a(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1fszx"&&(Le.innerHTML=al),ks=n(e),Pe=a(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-6of141"&&(Pe.innerHTML=rl),Ms=n(e),f(Ie.$$.fragment,e),Cs=n(e),_e=a(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1fdnj10"&&(_e.innerHTML=ul),Hs=n(e),qe=a(e,"UL",{"data-svelte-h":!0}),r(qe)!=="svelte-1huzw6a"&&(qe.innerHTML=fl),Ls=n(e),Re=a(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-bi46pe"&&(Re.textContent=hl),Ps=n(e),Ae=a(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1m88k68"&&(Ae.innerHTML=pl),Is=n(e),Je=a(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1oqcq1v"&&(Je.textContent=dl),_s=n(e),Ue=a(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1yh6g4i"&&(Ue.innerHTML=ml),qs=n(e),Ge=a(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-nd3yab"&&(Ge.innerHTML=cl),Rs=n(e),je=a(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-oxm1xv"&&(je.textContent=gl),As=n(e),De=a(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-19m8l5c"&&(De.textContent=yl),Js=n(e),f(We.$$.fragment,e),Us=n(e),Ze=a(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1695xih"&&(Ze.innerHTML=wl),Gs=n(e),Fe=a(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-dlx7ai"&&(Fe.textContent=bl),js=n(e),Se=a(e,"UL",{"data-svelte-h":!0}),r(Se)!=="svelte-15twepo"&&(Se.innerHTML=vl),Ds=n(e),Ne=a(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-1ao1iff"&&(Ne.innerHTML=xl),Ws=n(e),ze=a(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-vgkeor"&&(ze.textContent=$l),Zs=n(e),f(Ye.$$.fragment,e),Fs=n(e),Xe=a(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-idor3x"&&(Xe.textContent=Tl),Ss=n(e),f(Ee.$$.fragment,e),Ns=n(e),Be=a(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1951zcj"&&(Be.innerHTML=kl),zs=n(e),Oe=a(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-1m6im41"&&(Oe.textContent=Ml),Ys=n(e),Ve=a(e,"UL",{"data-svelte-h":!0}),r(Ve)!=="svelte-1xy9lh5"&&(Ve.innerHTML=Cl),Xs=n(e),Qe=a(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-68kw4k"&&(Qe.innerHTML=Hl),Es=n(e),Ke=a(e,"UL",{"data-svelte-h":!0}),r(Ke)!=="svelte-df85hq"&&(Ke.innerHTML=Ll),Bs=n(e),et=a(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-paax9d"&&(et.innerHTML=Pl),Os=n(e),f(tt.$$.fragment,e),Vs=n(e),it=a(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-hbgtxz"&&(it.innerHTML=Il),Qs=n(e),f(st.$$.fragment,e),Ks=n(e),ot=a(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-if0791"&&(ot.textContent=_l),eo=n(e),nt=a(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-9zs46y"&&(nt.textContent=ql),to=n(e),lt=a(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-ktahrm"&&(lt.textContent=Rl),io=n(e),at=a(e,"UL",{"data-svelte-h":!0}),r(at)!=="svelte-1frr5y8"&&(at.innerHTML=Al),so=n(e),rt=a(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-125l0kx"&&(rt.innerHTML=Jl),oo=n(e),ut=a(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-2xpxr5"&&(ut.textContent=Ul),no=n(e),ft=a(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-15y7ezq"&&(ft.textContent=Gl),lo=n(e),f(ht.$$.fragment,e),ao=n(e),pt=a(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-160saia"&&(pt.innerHTML=jl),ro=n(e),dt=a(e,"OL",{"data-svelte-h":!0}),r(dt)!=="svelte-147evhz"&&(dt.innerHTML=Dl),uo=n(e),f(mt.$$.fragment,e),fo=n(e),ct=a(e,"OL",{"data-svelte-h":!0}),r(ct)!=="svelte-1dyfapb"&&(ct.innerHTML=Wl),ho=n(e),gt=a(e,"UL",{"data-svelte-h":!0}),r(gt)!=="svelte-bfdf0l"&&(gt.innerHTML=Zl),po=n(e),x=a(e,"OL",{start:!0,"data-svelte-h":!0}),r(x)!=="svelte-9teity"&&(x.innerHTML=Fl),mo=n(e),f(yt.$$.fragment,e),co=n(e),wt=a(e,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-18wldn4"&&(wt.textContent=Sl),go=n(e),bt=a(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-ha1e2a"&&(bt.innerHTML=Nl),yo=n(e),vt=a(e,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-hj53bb"&&(vt.innerHTML=zl),wo=n(e),w=a(e,"OL",{});var mi=ri(w);fi=a(mi,"LI",{"data-svelte-h":!0}),r(fi)!=="svelte-1051ijo"&&(fi.innerHTML=Yl),rn=n(mi),xt=a(mi,"LI",{});var nn=ri(xt);hi=a(nn,"P",{"data-svelte-h":!0}),r(hi)!=="svelte-clge5v"&&(hi.textContent=Xl),un=n(nn),f($t.$$.fragment,nn),nn.forEach(i),fn=n(mi),Tt=a(mi,"LI",{});var ln=ri(Tt);pi=a(ln,"P",{"data-svelte-h":!0}),r(pi)!=="svelte-imt6wq"&&(pi.textContent=El),hn=n(ln),f(kt.$$.fragment,ln),ln.forEach(i),mi.forEach(i),bo=n(e),Mt=a(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-12bf6z0"&&(Mt.innerHTML=Bl),vo=n(e),Ct=a(e,"OL",{start:!0});var ya=ri(Ct);Ht=a(ya,"LI",{});var an=ri(Ht);di=a(an,"P",{"data-svelte-h":!0}),r(di)!=="svelte-1sxg1ux"&&(di.textContent=Ol),pn=n(an),f(Lt.$$.fragment,an),an.forEach(i),ya.forEach(i),xo=n(e),Pt=a(e,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-baqsq9"&&(Pt.innerHTML=Vl),$o=n(e),$=a(e,"OL",{start:!0,"data-svelte-h":!0}),r($)!=="svelte-1ug4u82"&&($.innerHTML=Ql),To=n(e),It=a(e,"P",{"data-svelte-h":!0}),r(It)!=="svelte-6e1eyz"&&(It.textContent=Kl),ko=n(e),f(_t.$$.fragment,e),Mo=n(e),qt=a(e,"P",{"data-svelte-h":!0}),r(qt)!=="svelte-zb2pxr"&&(qt.textContent=ea),Co=n(e),f(Rt.$$.fragment,e),Ho=n(e),At=a(e,"P",{"data-svelte-h":!0}),r(At)!=="svelte-1xnez06"&&(At.textContent=ta),Lo=n(e),f(Jt.$$.fragment,e),Po=n(e),Ut=a(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-1ee1sp3"&&(Ut.innerHTML=ia),Io=n(e),f(Gt.$$.fragment,e),_o=n(e),jt=a(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-1fsb6ew"&&(jt.innerHTML=sa),qo=n(e),f(Dt.$$.fragment,e),Ro=n(e),Wt=a(e,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-1h0d1ob"&&(Wt.innerHTML=oa),Ao=n(e),f(Zt.$$.fragment,e),Jo=n(e),Ft=a(e,"P",{"data-svelte-h":!0}),r(Ft)!=="svelte-b5s72j"&&(Ft.textContent=na),Uo=n(e),f(St.$$.fragment,e),Go=n(e),Nt=a(e,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-1adm7yl"&&(Nt.textContent=la),jo=n(e),f(zt.$$.fragment,e),Do=n(e),T=a(e,"OL",{start:!0,"data-svelte-h":!0}),r(T)!=="svelte-vcjscl"&&(T.innerHTML=aa),Wo=n(e),f(Yt.$$.fragment,e),Zo=n(e),Xt=a(e,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-109saxj"&&(Xt.innerHTML=ra),Fo=n(e),Et=a(e,"P",{"data-svelte-h":!0}),r(Et)!=="svelte-1w3mw7o"&&(Et.innerHTML=ua),So=n(e),f(Bt.$$.fragment,e),No=n(e),Ot=a(e,"P",{"data-svelte-h":!0}),r(Ot)!=="svelte-1df4miy"&&(Ot.innerHTML=fa),zo=n(e),Vt=a(e,"P",{"data-svelte-h":!0}),r(Vt)!=="svelte-12n8jzj"&&(Vt.textContent=ha),Yo=n(e),Qt=a(e,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-kna9l3"&&(Qt.innerHTML=pa),Xo=n(e),f(Kt.$$.fragment,e),Eo=n(e),ei=a(e,"P",{"data-svelte-h":!0}),r(ei)!=="svelte-6tihfz"&&(ei.innerHTML=da),Bo=n(e),f(ti.$$.fragment,e),Oo=n(e),f(ii.$$.fragment,e),Vo=n(e),si=a(e,"P",{"data-svelte-h":!0}),r(si)!=="svelte-ciarbw"&&(si.textContent=ma),Qo=n(e),oi=a(e,"OL",{"data-svelte-h":!0}),r(oi)!=="svelte-ff502d"&&(oi.innerHTML=ca),Ko=n(e),f(ni.$$.fragment,e),en=n(e),f(li.$$.fragment,e),tn=n(e),ai=a(e,"P",{"data-svelte-h":!0}),r(ai)!=="svelte-1w7izlk"&&(ai.innerHTML=ga),sn=n(e),gi=a(e,"P",{}),ri(gi).forEach(i),this.h()},h(){ui(b,"name","hf:doc:metadata"),ui(b,"content",Ca),ui(v,"start","2"),ui(x,"start","10"),ui(Ct,"start","4"),ui($,"start","5"),ui(T,"start","6")},m(e,t){y(document.head,b),s(e,yi,t),s(e,ci,t),s(e,wi,t),h(k,e,t),s(e,bi,t),s(e,M,t),s(e,vi,t),s(e,C,t),s(e,xi,t),s(e,H,t),s(e,$i,t),s(e,L,t),s(e,Ti,t),h(P,e,t),s(e,ki,t),s(e,I,t),s(e,Mi,t),s(e,_,t),s(e,Ci,t),s(e,q,t),s(e,Hi,t),s(e,R,t),s(e,Li,t),s(e,A,t),s(e,Pi,t),h(J,e,t),s(e,Ii,t),s(e,U,t),s(e,_i,t),s(e,G,t),s(e,qi,t),s(e,j,t),s(e,Ri,t),s(e,D,t),s(e,Ai,t),s(e,W,t),s(e,Ji,t),h(Z,e,t),s(e,Ui,t),s(e,F,t),s(e,Gi,t),s(e,S,t),s(e,ji,t),s(e,N,t),s(e,Di,t),s(e,z,t),s(e,Wi,t),s(e,Y,t),s(e,Zi,t),s(e,X,t),s(e,Fi,t),h(E,e,t),s(e,Si,t),s(e,B,t),s(e,Ni,t),s(e,O,t),s(e,zi,t),s(e,V,t),s(e,Yi,t),s(e,Q,t),s(e,Xi,t),h(K,e,t),s(e,Ei,t),s(e,ee,t),s(e,Bi,t),s(e,te,t),s(e,Oi,t),s(e,ie,t),s(e,Vi,t),s(e,v,t),s(e,Qi,t),s(e,se,t),s(e,Ki,t),h(oe,e,t),s(e,es,t),s(e,ne,t),s(e,ts,t),s(e,le,t),s(e,is,t),h(ae,e,t),s(e,ss,t),s(e,re,t),s(e,os,t),s(e,ue,t),s(e,ns,t),h(fe,e,t),s(e,ls,t),s(e,he,t),s(e,as,t),s(e,pe,t),s(e,rs,t),s(e,de,t),s(e,us,t),s(e,me,t),s(e,fs,t),h(ce,e,t),s(e,hs,t),s(e,ge,t),s(e,ps,t),s(e,ye,t),s(e,ds,t),s(e,we,t),s(e,ms,t),s(e,be,t),s(e,cs,t),s(e,ve,t),s(e,gs,t),h(xe,e,t),s(e,ys,t),s(e,$e,t),s(e,ws,t),s(e,Te,t),s(e,bs,t),h(ke,e,t),s(e,vs,t),s(e,Me,t),s(e,xs,t),s(e,Ce,t),s(e,$s,t),s(e,He,t),s(e,Ts,t),s(e,Le,t),s(e,ks,t),s(e,Pe,t),s(e,Ms,t),h(Ie,e,t),s(e,Cs,t),s(e,_e,t),s(e,Hs,t),s(e,qe,t),s(e,Ls,t),s(e,Re,t),s(e,Ps,t),s(e,Ae,t),s(e,Is,t),s(e,Je,t),s(e,_s,t),s(e,Ue,t),s(e,qs,t),s(e,Ge,t),s(e,Rs,t),s(e,je,t),s(e,As,t),s(e,De,t),s(e,Js,t),h(We,e,t),s(e,Us,t),s(e,Ze,t),s(e,Gs,t),s(e,Fe,t),s(e,js,t),s(e,Se,t),s(e,Ds,t),s(e,Ne,t),s(e,Ws,t),s(e,ze,t),s(e,Zs,t),h(Ye,e,t),s(e,Fs,t),s(e,Xe,t),s(e,Ss,t),h(Ee,e,t),s(e,Ns,t),s(e,Be,t),s(e,zs,t),s(e,Oe,t),s(e,Ys,t),s(e,Ve,t),s(e,Xs,t),s(e,Qe,t),s(e,Es,t),s(e,Ke,t),s(e,Bs,t),s(e,et,t),s(e,Os,t),h(tt,e,t),s(e,Vs,t),s(e,it,t),s(e,Qs,t),h(st,e,t),s(e,Ks,t),s(e,ot,t),s(e,eo,t),s(e,nt,t),s(e,to,t),s(e,lt,t),s(e,io,t),s(e,at,t),s(e,so,t),s(e,rt,t),s(e,oo,t),s(e,ut,t),s(e,no,t),s(e,ft,t),s(e,lo,t),h(ht,e,t),s(e,ao,t),s(e,pt,t),s(e,ro,t),s(e,dt,t),s(e,uo,t),h(mt,e,t),s(e,fo,t),s(e,ct,t),s(e,ho,t),s(e,gt,t),s(e,po,t),s(e,x,t),s(e,mo,t),h(yt,e,t),s(e,co,t),s(e,wt,t),s(e,go,t),s(e,bt,t),s(e,yo,t),s(e,vt,t),s(e,wo,t),s(e,w,t),y(w,fi),y(w,rn),y(w,xt),y(xt,hi),y(xt,un),h($t,xt,null),y(w,fn),y(w,Tt),y(Tt,pi),y(Tt,hn),h(kt,Tt,null),s(e,bo,t),s(e,Mt,t),s(e,vo,t),s(e,Ct,t),y(Ct,Ht),y(Ht,di),y(Ht,pn),h(Lt,Ht,null),s(e,xo,t),s(e,Pt,t),s(e,$o,t),s(e,$,t),s(e,To,t),s(e,It,t),s(e,ko,t),h(_t,e,t),s(e,Mo,t),s(e,qt,t),s(e,Co,t),h(Rt,e,t),s(e,Ho,t),s(e,At,t),s(e,Lo,t),h(Jt,e,t),s(e,Po,t),s(e,Ut,t),s(e,Io,t),h(Gt,e,t),s(e,_o,t),s(e,jt,t),s(e,qo,t),h(Dt,e,t),s(e,Ro,t),s(e,Wt,t),s(e,Ao,t),h(Zt,e,t),s(e,Jo,t),s(e,Ft,t),s(e,Uo,t),h(St,e,t),s(e,Go,t),s(e,Nt,t),s(e,jo,t),h(zt,e,t),s(e,Do,t),s(e,T,t),s(e,Wo,t),h(Yt,e,t),s(e,Zo,t),s(e,Xt,t),s(e,Fo,t),s(e,Et,t),s(e,So,t),h(Bt,e,t),s(e,No,t),s(e,Ot,t),s(e,zo,t),s(e,Vt,t),s(e,Yo,t),s(e,Qt,t),s(e,Xo,t),h(Kt,e,t),s(e,Eo,t),s(e,ei,t),s(e,Bo,t),h(ti,e,t),s(e,Oo,t),h(ii,e,t),s(e,Vo,t),s(e,si,t),s(e,Qo,t),s(e,oi,t),s(e,Ko,t),h(ni,e,t),s(e,en,t),h(li,e,t),s(e,tn,t),s(e,ai,t),s(e,sn,t),s(e,gi,t),on=!0},p:ba,i(e){on||(p(k.$$.fragment,e),p(P.$$.fragment,e),p(J.$$.fragment,e),p(Z.$$.fragment,e),p(E.$$.fragment,e),p(K.$$.fragment,e),p(oe.$$.fragment,e),p(ae.$$.fragment,e),p(fe.$$.fragment,e),p(ce.$$.fragment,e),p(xe.$$.fragment,e),p(ke.$$.fragment,e),p(Ie.$$.fragment,e),p(We.$$.fragment,e),p(Ye.$$.fragment,e),p(Ee.$$.fragment,e),p(tt.$$.fragment,e),p(st.$$.fragment,e),p(ht.$$.fragment,e),p(mt.$$.fragment,e),p(yt.$$.fragment,e),p($t.$$.fragment,e),p(kt.$$.fragment,e),p(Lt.$$.fragment,e),p(_t.$$.fragment,e),p(Rt.$$.fragment,e),p(Jt.$$.fragment,e),p(Gt.$$.fragment,e),p(Dt.$$.fragment,e),p(Zt.$$.fragment,e),p(St.$$.fragment,e),p(zt.$$.fragment,e),p(Yt.$$.fragment,e),p(Bt.$$.fragment,e),p(Kt.$$.fragment,e),p(ti.$$.fragment,e),p(ii.$$.fragment,e),p(ni.$$.fragment,e),p(li.$$.fragment,e),on=!0)},o(e){d(k.$$.fragment,e),d(P.$$.fragment,e),d(J.$$.fragment,e),d(Z.$$.fragment,e),d(E.$$.fragment,e),d(K.$$.fragment,e),d(oe.$$.fragment,e),d(ae.$$.fragment,e),d(fe.$$.fragment,e),d(ce.$$.fragment,e),d(xe.$$.fragment,e),d(ke.$$.fragment,e),d(Ie.$$.fragment,e),d(We.$$.fragment,e),d(Ye.$$.fragment,e),d(Ee.$$.fragment,e),d(tt.$$.fragment,e),d(st.$$.fragment,e),d(ht.$$.fragment,e),d(mt.$$.fragment,e),d(yt.$$.fragment,e),d($t.$$.fragment,e),d(kt.$$.fragment,e),d(Lt.$$.fragment,e),d(_t.$$.fragment,e),d(Rt.$$.fragment,e),d(Jt.$$.fragment,e),d(Gt.$$.fragment,e),d(Dt.$$.fragment,e),d(Zt.$$.fragment,e),d(St.$$.fragment,e),d(zt.$$.fragment,e),d(Yt.$$.fragment,e),d(Bt.$$.fragment,e),d(Kt.$$.fragment,e),d(ti.$$.fragment,e),d(ii.$$.fragment,e),d(ni.$$.fragment,e),d(li.$$.fragment,e),on=!1},d(e){e&&(i(yi),i(ci),i(wi),i(bi),i(M),i(vi),i(C),i(xi),i(H),i($i),i(L),i(Ti),i(ki),i(I),i(Mi),i(_),i(Ci),i(q),i(Hi),i(R),i(Li),i(A),i(Pi),i(Ii),i(U),i(_i),i(G),i(qi),i(j),i(Ri),i(D),i(Ai),i(W),i(Ji),i(Ui),i(F),i(Gi),i(S),i(ji),i(N),i(Di),i(z),i(Wi),i(Y),i(Zi),i(X),i(Fi),i(Si),i(B),i(Ni),i(O),i(zi),i(V),i(Yi),i(Q),i(Xi),i(Ei),i(ee),i(Bi),i(te),i(Oi),i(ie),i(Vi),i(v),i(Qi),i(se),i(Ki),i(es),i(ne),i(ts),i(le),i(is),i(ss),i(re),i(os),i(ue),i(ns),i(ls),i(he),i(as),i(pe),i(rs),i(de),i(us),i(me),i(fs),i(hs),i(ge),i(ps),i(ye),i(ds),i(we),i(ms),i(be),i(cs),i(ve),i(gs),i(ys),i($e),i(ws),i(Te),i(bs),i(vs),i(Me),i(xs),i(Ce),i($s),i(He),i(Ts),i(Le),i(ks),i(Pe),i(Ms),i(Cs),i(_e),i(Hs),i(qe),i(Ls),i(Re),i(Ps),i(Ae),i(Is),i(Je),i(_s),i(Ue),i(qs),i(Ge),i(Rs),i(je),i(As),i(De),i(Js),i(Us),i(Ze),i(Gs),i(Fe),i(js),i(Se),i(Ds),i(Ne),i(Ws),i(ze),i(Zs),i(Fs),i(Xe),i(Ss),i(Ns),i(Be),i(zs),i(Oe),i(Ys),i(Ve),i(Xs),i(Qe),i(Es),i(Ke),i(Bs),i(et),i(Os),i(Vs),i(it),i(Qs),i(Ks),i(ot),i(eo),i(nt),i(to),i(lt),i(io),i(at),i(so),i(rt),i(oo),i(ut),i(no),i(ft),i(lo),i(ao),i(pt),i(ro),i(dt),i(uo),i(fo),i(ct),i(ho),i(gt),i(po),i(x),i(mo),i(co),i(wt),i(go),i(bt),i(yo),i(vt),i(wo),i(w),i(bo),i(Mt),i(vo),i(Ct),i(xo),i(Pt),i($o),i($),i(To),i(It),i(ko),i(Mo),i(qt),i(Co),i(Ho),i(At),i(Lo),i(Po),i(Ut),i(Io),i(_o),i(jt),i(qo),i(Ro),i(Wt),i(Ao),i(Jo),i(Ft),i(Uo),i(Go),i(Nt),i(jo),i(Do),i(T),i(Wo),i(Zo),i(Xt),i(Fo),i(Et),i(So),i(No),i(Ot),i(zo),i(Vt),i(Yo),i(Qt),i(Xo),i(Eo),i(ei),i(Bo),i(Oo),i(Vo),i(si),i(Qo),i(oi),i(Ko),i(en),i(tn),i(ai),i(sn),i(gi)),i(b),m(k,e),m(P,e),m(J,e),m(Z,e),m(E,e),m(K,e),m(oe,e),m(ae,e),m(fe,e),m(ce,e),m(xe,e),m(ke,e),m(Ie,e),m(We,e),m(Ye,e),m(Ee,e),m(tt,e),m(st,e),m(ht,e),m(mt,e),m(yt,e),m($t),m(kt),m(Lt),m(_t,e),m(Rt,e),m(Jt,e),m(Gt,e),m(Dt,e),m(Zt,e),m(St,e),m(zt,e),m(Yt,e),m(Bt,e),m(Kt,e),m(ti,e),m(ii,e),m(ni,e),m(li,e)}}}const Ca='{"title":"How to contribute to Diffusers 🧨","local":"how-to-contribute-to-diffusers-","sections":[{"title":"Overview","local":"overview","sections":[{"title":"1. Asking and answering questions on the Diffusers discussion forum or on the Diffusers Discord","local":"1-asking-and-answering-questions-on-the-diffusers-discussion-forum-or-on-the-diffusers-discord","sections":[],"depth":3},{"title":"2. Opening new issues on the GitHub issues tab","local":"2-opening-new-issues-on-the-github-issues-tab","sections":[{"title":"2.1. Reproducible, minimal bug reports","local":"21-reproducible-minimal-bug-reports","sections":[],"depth":4},{"title":"2.2. Feature requests","local":"22-feature-requests","sections":[],"depth":4},{"title":"2.3 Feedback","local":"23-feedback","sections":[],"depth":4},{"title":"2.4 Technical questions","local":"24-technical-questions","sections":[],"depth":4},{"title":"2.5 Proposal to add a new model, scheduler, or pipeline","local":"25-proposal-to-add-a-new-model-scheduler-or-pipeline","sections":[],"depth":4}],"depth":3},{"title":"3. Answering issues on the GitHub issues tab","local":"3-answering-issues-on-the-github-issues-tab","sections":[],"depth":3},{"title":"4. Fixing a “Good first issue”","local":"4-fixing-a-good-first-issue","sections":[],"depth":3},{"title":"5. Contribute to the documentation","local":"5-contribute-to-the-documentation","sections":[],"depth":3},{"title":"6. Contribute a community pipeline","local":"6-contribute-a-community-pipeline","sections":[],"depth":3},{"title":"7. Contribute to training examples","local":"7-contribute-to-training-examples","sections":[],"depth":3},{"title":"8. Fixing a “Good second issue”","local":"8-fixing-a-good-second-issue","sections":[],"depth":3},{"title":"9. Adding pipelines, models, schedulers","local":"9-adding-pipelines-models-schedulers","sections":[],"depth":3}],"depth":2},{"title":"How to write a good issue","local":"how-to-write-a-good-issue","sections":[],"depth":2},{"title":"How to write a good PR","local":"how-to-write-a-good-pr","sections":[],"depth":2},{"title":"How to open a PR","local":"how-to-open-a-pr","sections":[{"title":"Tests","local":"tests","sections":[],"depth":3},{"title":"Syncing forked main with upstream (HuggingFace) main","local":"syncing-forked-main-with-upstream-huggingface-main","sections":[],"depth":3},{"title":"Style guide","local":"style-guide","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ha(dn){return va(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=ka}),[]}class qa extends xa{constructor(b){super(),$a(this,b,Ha,Ma,wa,{})}}export{qa as component};
