import{s as ca,o as ma,n as S}from"../chunks/scheduler.182ea377.js";import{S as ga,i as ua,g as d,s as o,r as u,A as fa,h as p,f as s,c as i,j as T,u as f,x as w,k as I,y as a,a as m,v as h,d as _,t as y,w as b}from"../chunks/index.abf12888.js";import{T as pa}from"../chunks/Tip.230e2334.js";import{D as J}from"../chunks/Docstring.93f6f462.js";import{C as he}from"../chunks/CodeBlock.57fe6e13.js";import{E as ue}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as fe}from"../chunks/Heading.16916d63.js";function ha(v){let t,M='Check out the <a href="https://huggingface.co/kandinsky-community" rel="nofollow">Kandinsky Community</a> organization on the Hub for the official model checkpoints for tasks like text-to-image, image-to-image, and inpainting.';return{c(){t=d("p"),t.innerHTML=M},l(c){t=p(c,"P",{"data-svelte-h":!0}),w(t)!=="svelte-1nfky5i"&&(t.innerHTML=M)},m(c,r){m(c,t,r)},p:S,d(c){c&&s(t)}}}function _a(v){let t,M='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){t=d("p"),t.innerHTML=M},l(c){t=p(c,"P",{"data-svelte-h":!0}),w(t)!=="svelte-1wmc0l4"&&(t.innerHTML=M)},m(c,r){m(c,t,r)},p:S,d(c){c&&s(t)}}}function ya(v){let t,M="Examples:",c,r,g;return r=new he({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVBpcGVsaW5lJTJDJTIwS2FuZGluc2t5UHJpb3JQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZV9wcmlvciUyMCUzRCUyMEthbmRpbnNreVByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0xLXByaW9yJTIyKSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJyZWQlMjBjYXQlMkMlMjA0ayUyMHBob3RvJTIyJTBBb3V0JTIwJTNEJTIwcGlwZV9wcmlvcihwcm9tcHQpJTBBaW1hZ2VfZW1iJTIwJTNEJTIwb3V0LmltYWdlX2VtYmVkcyUwQW5lZ2F0aXZlX2ltYWdlX2VtYiUyMCUzRCUyMG91dC5uZWdhdGl2ZV9pbWFnZV9lbWJlZHMlMEElMEFwaXBlJTIwJTNEJTIwS2FuZGluc2t5UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0xJTIyKSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2VfZW1iZWRzJTNEaW1hZ2VfZW1iJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfaW1hZ2VfZW1iZWRzJTNEbmVnYXRpdmVfaW1hZ2VfZW1iJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0Q3NjglMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMTAwJTJDJTBBKS5pbWFnZXMlMEElMEFpbWFnZSU1QjAlNUQuc2F2ZSglMjJjYXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyPipeline, KandinskyPriorPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyPriorPipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1-prior&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;red cat, 4k photo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>out = pipe_prior(prompt)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb = out.image_embeds
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_image_emb = out.negative_image_embeds

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyPipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=negative_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;cat.png&quot;</span>)`,wrap:!1}}),{c(){t=d("p"),t.textContent=M,c=o(),u(r.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-kvfsh7"&&(t.textContent=M),c=i(n),f(r.$$.fragment,n)},m(n,k){m(n,t,k),m(n,c,k),h(r,n,k),g=!0},p:S,i(n){g||(_(r.$$.fragment,n),g=!0)},o(n){y(r.$$.fragment,n),g=!1},d(n){n&&(s(t),s(c)),b(r,n)}}}function ba(v){let t,M="Examples:",c,r,g;return r=new he({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVByaW9yUGlwZWxpbmUlMkMlMjBLYW5kaW5za3lQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBaW1wb3J0JTIwUElMJTBBJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdG9yY2h2aXNpb24lMjBpbXBvcnQlMjB0cmFuc2Zvcm1zJTBBJTBBcGlwZV9wcmlvciUyMCUzRCUyMEthbmRpbnNreVByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0xLXByaW9yJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEElMEFpbWcxJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTIyJTBBJTIwJTIwJTIwJTIwJTIyJTJGa2FuZGluc2t5JTJGY2F0LnBuZyUyMiUwQSklMEElMEFpbWcyJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTIyJTBBJTIwJTIwJTIwJTIwJTIyJTJGa2FuZGluc2t5JTJGc3RhcnJ5X25pZ2h0LmpwZWclMjIlMEEpJTBBJTBBaW1hZ2VzX3RleHRzJTIwJTNEJTIwJTVCJTIyYSUyMGNhdCUyMiUyQyUyMGltZzElMkMlMjBpbWcyJTVEJTBBd2VpZ2h0cyUyMCUzRCUyMCU1QjAuMyUyQyUyMDAuMyUyQyUyMDAuNCU1RCUwQWltYWdlX2VtYiUyQyUyMHplcm9faW1hZ2VfZW1iJTIwJTNEJTIwcGlwZV9wcmlvci5pbnRlcnBvbGF0ZShpbWFnZXNfdGV4dHMlMkMlMjB3ZWlnaHRzKSUwQSUwQXBpcGUlMjAlM0QlMjBLYW5kaW5za3lQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIya2FuZGluc2t5LWNvbW11bml0eSUyRmthbmRpbnNreS0yLTElMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjAlMjIlMjIlMkMlMEElMjAlMjAlMjAlMjBpbWFnZV9lbWJlZHMlM0RpbWFnZV9lbWIlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9pbWFnZV9lbWJlZHMlM0R6ZXJvX2ltYWdlX2VtYiUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDc2OCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDE1MCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUwQWltYWdlLnNhdmUoJTIyc3RhcnJ5X2NhdC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyPriorPipeline, KandinskyPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision <span class="hljs-keyword">import</span> transforms

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyPriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1-prior&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>img1 = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>img2 = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/starry_night.jpeg&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>images_texts = [<span class="hljs-string">&quot;a cat&quot;</span>, img1, img2]
<span class="hljs-meta">&gt;&gt;&gt; </span>weights = [<span class="hljs-number">0.3</span>, <span class="hljs-number">0.3</span>, <span class="hljs-number">0.4</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb, zero_image_emb = pipe_prior.interpolate(images_texts, weights)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyPipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;</span>,
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=zero_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">150</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;starry_cat.png&quot;</span>)`,wrap:!1}}),{c(){t=d("p"),t.textContent=M,c=o(),u(r.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-kvfsh7"&&(t.textContent=M),c=i(n),f(r.$$.fragment,n)},m(n,k){m(n,t,k),m(n,c,k),h(r,n,k),g=!0},p:S,i(n){g||(_(r.$$.fragment,n),g=!0)},o(n){y(r.$$.fragment,n),g=!1},d(n){n&&(s(t),s(c)),b(r,n)}}}function ka(v){let t,M="Examples:",c,r,g;return r=new he({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVBpcGVsaW5lJTJDJTIwS2FuZGluc2t5UHJpb3JQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZV9wcmlvciUyMCUzRCUyMEthbmRpbnNreVByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZLYW5kaW5za3ktMi0xLXByaW9yJTIyKSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJyZWQlMjBjYXQlMkMlMjA0ayUyMHBob3RvJTIyJTBBb3V0JTIwJTNEJTIwcGlwZV9wcmlvcihwcm9tcHQpJTBBaW1hZ2VfZW1iJTIwJTNEJTIwb3V0LmltYWdlX2VtYmVkcyUwQW5lZ2F0aXZlX2ltYWdlX2VtYiUyMCUzRCUyMG91dC5uZWdhdGl2ZV9pbWFnZV9lbWJlZHMlMEElMEFwaXBlJTIwJTNEJTIwS2FuZGluc2t5UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0xJTIyKSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2VfZW1iZWRzJTNEaW1hZ2VfZW1iJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfaW1hZ2VfZW1iZWRzJTNEbmVnYXRpdmVfaW1hZ2VfZW1iJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0Q3NjglMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMTAwJTJDJTBBKS5pbWFnZXMlMEElMEFpbWFnZSU1QjAlNUQuc2F2ZSglMjJjYXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyPipeline, KandinskyPriorPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyPriorPipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/Kandinsky-2-1-prior&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;red cat, 4k photo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>out = pipe_prior(prompt)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb = out.image_embeds
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_image_emb = out.negative_image_embeds

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyPipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=negative_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;cat.png&quot;</span>)`,wrap:!1}}),{c(){t=d("p"),t.textContent=M,c=o(),u(r.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-kvfsh7"&&(t.textContent=M),c=i(n),f(r.$$.fragment,n)},m(n,k){m(n,t,k),m(n,c,k),h(r,n,k),g=!0},p:S,i(n){g||(_(r.$$.fragment,n),g=!0)},o(n){y(r.$$.fragment,n),g=!1},d(n){n&&(s(t),s(c)),b(r,n)}}}function wa(v){let t,M="Examples:",c,r,g;return r=new he({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGxpb24lMjBpbiUyMGdhbGF4aWVzJTJDJTIwc3BpcmFscyUyQyUyMG5lYnVsYWUlMkMlMjBzdGFycyUyQyUyMHNtb2tlJTJDJTIwaXJpZGVzY2VudCUyQyUyMGludHJpY2F0ZSUyMGRldGFpbCUyQyUyMG9jdGFuZSUyMHJlbmRlciUyQyUyMDhrJTIyJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipe = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1&quot;</span>, torch_dtype=torch.float16
)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A lion in galaxies, spirals, nebulae, stars, smoke, iridescent, intricate detail, octane render, 8k&quot;</span>

image = pipe(prompt=prompt, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){t=d("p"),t.textContent=M,c=o(),u(r.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-kvfsh7"&&(t.textContent=M),c=i(n),f(r.$$.fragment,n)},m(n,k){m(n,t,k),m(n,c,k),h(r,n,k),g=!0},p:S,i(n){g||(_(r.$$.fragment,n),g=!0)},o(n){y(r.$$.fragment,n),g=!1},d(n){n&&(s(t),s(c)),b(r,n)}}}function Ma(v){let t,M="Examples:",c,r,g;return r=new he({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreUltZzJJbWdQaXBlbGluZSUyQyUyMEthbmRpbnNreVByaW9yUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZV9wcmlvciUyMCUzRCUyMEthbmRpbnNreVByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0xLXByaW9yJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwcmVkJTIwY2FydG9vbiUyMGZyb2clMkMlMjA0ayUyMiUwQWltYWdlX2VtYiUyQyUyMHplcm9faW1hZ2VfZW1iJTIwJTNEJTIwcGlwZV9wcmlvcihwcm9tcHQlMkMlMjByZXR1cm5fZGljdCUzREZhbHNlKSUwQSUwQXBpcGUlMjAlM0QlMjBLYW5kaW5za3lJbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTIyJTBBJTIwJTIwJTIwJTIwJTIyJTJGa2FuZGluc2t5JTJGZnJvZy5wbmclMjIlMEEpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGltYWdlX2VtYmVkcyUzRGltYWdlX2VtYiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX2ltYWdlX2VtYmVkcyUzRHplcm9faW1hZ2VfZW1iJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0Q3NjglMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMTAwJTJDJTBBJTIwJTIwJTIwJTIwc3RyZW5ndGglM0QwLjIlMkMlMEEpLmltYWdlcyUwQSUwQWltYWdlJTVCMCU1RC5zYXZlKCUyMnJlZF9mcm9nLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyImg2ImgPipeline, KandinskyPriorPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyPriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1-prior&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A red cartoon frog, 4k&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb, zero_image_emb = pipe_prior(prompt, return_dict=<span class="hljs-literal">False</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyImg2ImgPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/frog.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    image=init_image,
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=zero_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    strength=<span class="hljs-number">0.2</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;red_frog.png&quot;</span>)`,wrap:!1}}),{c(){t=d("p"),t.textContent=M,c=o(),u(r.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-kvfsh7"&&(t.textContent=M),c=i(n),f(r.$$.fragment,n)},m(n,k){m(n,t,k),m(n,c,k),h(r,n,k),g=!0},p:S,i(n){g||(_(r.$$.fragment,n),g=!0)},o(n){y(r.$$.fragment,n),g=!1},d(n){n&&(s(t),s(c)),b(r,n)}}}function va(v){let t,M="Examples:",c,r,g;return r=new he({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjBvcyUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIya2FuZGluc2t5LWNvbW11bml0eSUyRmthbmRpbnNreS0yLTElMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBmYW50YXN5JTIwbGFuZHNjYXBlJTJDJTIwQ2luZW1hdGljJTIwbGlnaHRpbmclMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJsb3clMjBxdWFsaXR5JTJDJTIwYmFkJTIwcXVhbGl0eSUyMiUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uJTJGbWFpbiUyRmFzc2V0cyUyRnN0YWJsZS1zYW1wbGVzJTJGaW1nMmltZyUyRnNrZXRjaC1tb3VudGFpbnMtaW5wdXQuanBnJTIyJTBBJTBBcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFpbWFnZS50aHVtYm5haWwoKDc2OCUyQyUyMDc2OCkpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEb3JpZ2luYWxfaW1hZ2UlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjUpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> os

pipe = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1&quot;</span>, torch_dtype=torch.float16
)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A fantasy landscape, Cinematic lighting&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, bad quality&quot;</span>

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

response = requests.get(url)
image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
image.thumbnail((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))

image = pipe(prompt=prompt, image=original_image, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){t=d("p"),t.textContent=M,c=o(),u(r.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-kvfsh7"&&(t.textContent=M),c=i(n),f(r.$$.fragment,n)},m(n,k){m(n,t,k),m(n,c,k),h(r,n,k),g=!0},p:S,i(n){g||(_(r.$$.fragment,n),g=!0)},o(n){y(r.$$.fragment,n),g=!1},d(n){n&&(s(t),s(c)),b(r,n)}}}function Ta(v){let t,M="Examples:",c,r,g;return r=new he({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreUlucGFpbnRQaXBlbGluZSUyQyUyMEthbmRpbnNreVByaW9yUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBcGlwZV9wcmlvciUyMCUzRCUyMEthbmRpbnNreVByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0xLXByaW9yJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwaGF0JTIyJTBBaW1hZ2VfZW1iJTJDJTIwemVyb19pbWFnZV9lbWIlMjAlM0QlMjBwaXBlX3ByaW9yKHByb21wdCUyQyUyMHJldHVybl9kaWN0JTNERmFsc2UpJTBBJTBBcGlwZSUyMCUzRCUyMEthbmRpbnNreUlucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIya2FuZGluc2t5LWNvbW11bml0eSUyRmthbmRpbnNreS0yLTEtaW5wYWludCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyMiUwQSUyMCUyMCUyMCUyMCUyMiUyRmthbmRpbnNreSUyRmNhdC5wbmclMjIlMEEpJTBBJTBBbWFzayUyMCUzRCUyMG5wLnplcm9zKCg3NjglMkMlMjA3NjgpJTJDJTIwZHR5cGUlM0RucC5mbG9hdDMyKSUwQW1hc2slNUIlM0EyNTAlMkMlMjAyNTAlM0EtMjUwJTVEJTIwJTNEJTIwMSUwQSUwQW91dCUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwbWFza19pbWFnZSUzRG1hc2slMkMlMEElMjAlMjAlMjAlMjBpbWFnZV9lbWJlZHMlM0RpbWFnZV9lbWIlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9pbWFnZV9lbWJlZHMlM0R6ZXJvX2ltYWdlX2VtYiUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDc2OCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBKSUwQSUwQWltYWdlJTIwJTNEJTIwb3V0LmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdF93aXRoX2hhdC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyInpaintPipeline, KandinskyPriorPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyPriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1-prior&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a hat&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb, zero_image_emb = pipe_prior(prompt, return_dict=<span class="hljs-literal">False</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyInpaintPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1-inpaint&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>mask = np.zeros((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>), dtype=np.float32)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask[:<span class="hljs-number">250</span>, <span class="hljs-number">250</span>:-<span class="hljs-number">250</span>] = <span class="hljs-number">1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>out = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    image=init_image,
<span class="hljs-meta">... </span>    mask_image=mask,
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=zero_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = out.images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;cat_with_hat.png&quot;</span>)`,wrap:!1}}),{c(){t=d("p"),t.textContent=M,c=o(),u(r.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-kvfsh7"&&(t.textContent=M),c=i(n),f(r.$$.fragment,n)},m(n,k){m(n,t,k),m(n,c,k),h(r,n,k),g=!0},p:S,i(n){g||(_(r.$$.fragment,n),g=!0)},o(n){y(r.$$.fragment,n),g=!1},d(n){n&&(s(t),s(c)),b(r,n)}}}function Ia(v){let t,M="Examples:",c,r,g;return r=new he({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmclMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBcGlwZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0xLWlucGFpbnQlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBmYW50YXN5JTIwbGFuZHNjYXBlJTJDJTIwQ2luZW1hdGljJTIwbGlnaHRpbmclMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJsb3clMjBxdWFsaXR5JTJDJTIwYmFkJTIwcXVhbGl0eSUyMiUwQSUwQW9yaWdpbmFsX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTIyJTIwJTIyJTJGa2FuZGluc2t5JTJGY2F0LnBuZyUyMiUwQSklMEElMEFtYXNrJTIwJTNEJTIwbnAuemVyb3MoKDc2OCUyQyUyMDc2OCklMkMlMjBkdHlwZSUzRG5wLmZsb2F0MzIpJTBBJTIzJTIwTGV0J3MlMjBtYXNrJTIwb3V0JTIwYW4lMjBhcmVhJTIwYWJvdmUlMjB0aGUlMjBjYXQncyUyMGhlYWQlMEFtYXNrJTVCJTNBMjUwJTJDJTIwMjUwJTNBLTI1MCU1RCUyMCUzRCUyMDElMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0RvcmlnaW5hbF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlM0RtYXNrJTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI1KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

pipe = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-1-inpaint&quot;</span>, torch_dtype=torch.float16
)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A fantasy landscape, Cinematic lighting&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, bad quality&quot;</span>

original_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span> <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
)

mask = np.zeros((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>), dtype=np.float32)
<span class="hljs-comment"># Let&#x27;s mask out an area above the cat&#x27;s head</span>
mask[:<span class="hljs-number">250</span>, <span class="hljs-number">250</span>:-<span class="hljs-number">250</span>] = <span class="hljs-number">1</span>

image = pipe(prompt=prompt, image=original_image, mask_image=mask, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){t=d("p"),t.textContent=M,c=o(),u(r.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-kvfsh7"&&(t.textContent=M),c=i(n),f(r.$$.fragment,n)},m(n,k){m(n,t,k),m(n,c,k),h(r,n,k),g=!0},p:S,i(n){g||(_(r.$$.fragment,n),g=!0)},o(n){y(r.$$.fragment,n),g=!1},d(n){n&&(s(t),s(c)),b(r,n)}}}function Ja(v){let t,M,c,r,g,n,k,Gt='Kandinsky 2.1 is created by <a href="https://github.com/cene555" rel="nofollow">Arseniy Shakhmatov</a>, <a href="https://github.com/razzant" rel="nofollow">Anton Razzhigaev</a>, <a href="https://github.com/AlexWortega" rel="nofollow">Aleksandr Nikolich</a>, <a href="https://github.com/oriBetelgeuse" rel="nofollow">Vladimir Arkhipkin</a>, <a href="https://github.com/boomb0om" rel="nofollow">Igor Pavlov</a>, <a href="https://github.com/kuznetsoffandrey" rel="nofollow">Andrey Kuznetsov</a>, and <a href="https://github.com/denndimitrov" rel="nofollow">Denis Dimitrov</a>.',Mn,_e,Bt="The description from it’s GitHub page is:",vn,ye,Kt="<em>Kandinsky 2.1 inherits best practicies from Dall-E 2 and Latent diffusion, while introducing some new ideas. As text and image encoder it uses CLIP model and diffusion image prior (mapping) between latent spaces of CLIP modalities. This approach increases the visual performance of the model and unveils new horizons in blending images and text-guided image manipulation.</em>",Tn,be,Vt='The original codebase can be found at <a href="https://github.com/ai-forever/Kandinsky-2" rel="nofollow">ai-forever/Kandinsky-2</a>.',In,ee,Jn,ne,Pn,ke,xn,P,we,Qn,Re,qt="Pipeline for generating image prior for Kandinsky",Rn,Xe,Lt=`This model inherits from <a href="/docs/diffusers/v0.27.2/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Xn,V,Me,Sn,Se,Ft="Function invoked when calling the pipeline for generation.",Dn,te,Hn,q,ve,Yn,De,zt="Function invoked when using the prior pipeline for interpolation.",An,ae,Un,Te,Cn,j,Ie,On,He,Nt="Pipeline for text-to-image generation using Kandinsky",et,Ye,Et=`This model inherits from <a href="/docs/diffusers/v0.27.2/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,nt,L,Je,tt,Ae,Qt="Function invoked when calling the pipeline for generation.",at,se,jn,Pe,$n,x,xe,st,Oe,Rt="Combined Pipeline for text-to-image generation using Kandinsky",ot,en,Xt=`This model inherits from <a href="/docs/diffusers/v0.27.2/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,it,F,Ue,rt,nn,St="Function invoked when calling the pipeline for generation.",lt,oe,dt,ie,Ce,pt,tn,Dt=`Offloads all models (<code>unet</code>, <code>text_encoder</code>, <code>vae</code>, and <code>safety checker</code> state dicts) to CPU using 🤗
Accelerate, significantly reducing memory usage. Models are moved to a <code>torch.device(&#39;meta&#39;)</code> and loaded on a
GPU only when their specific submodule’s <code>forward</code> method is called. Offloading happens on a submodule basis.
Memory savings are higher than using <code>enable_model_cpu_offload</code>, but performance is lower.`,Zn,je,Wn,$,$e,ct,an,Ht="Pipeline for image-to-image generation using Kandinsky",mt,sn,Yt=`This model inherits from <a href="/docs/diffusers/v0.27.2/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,gt,z,Ze,ut,on,At="Function invoked when calling the pipeline for generation.",ft,re,Gn,We,Bn,U,Ge,ht,rn,Ot="Combined Pipeline for image-to-image generation using Kandinsky",_t,ln,ea=`This model inherits from <a href="/docs/diffusers/v0.27.2/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,yt,N,Be,bt,dn,na="Function invoked when calling the pipeline for generation.",kt,le,wt,de,Ke,Mt,pn,ta=`Offloads all models to CPU using accelerate, significantly reducing memory usage. When called, unet,
text_encoder, vae and safety checker have their state dicts saved to CPU and then are moved to a
<code>torch.device(&#39;meta&#39;) and loaded to GPU only when their specific submodule has its </code>forward<code>method called. Note that offloading happens on a submodule basis. Memory savings are higher than with</code>enable_model_cpu_offload\`, but performance is lower.`,Kn,Ve,Vn,Z,qe,vt,cn,aa="Pipeline for text-guided image inpainting using Kandinsky2.1",Tt,mn,sa=`This model inherits from <a href="/docs/diffusers/v0.27.2/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,It,E,Le,Jt,gn,oa="Function invoked when calling the pipeline for generation.",Pt,pe,qn,Fe,Ln,C,ze,xt,un,ia="Combined Pipeline for generation using Kandinsky",Ut,fn,ra=`This model inherits from <a href="/docs/diffusers/v0.27.2/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Ct,Q,Ne,jt,hn,la="Function invoked when calling the pipeline for generation.",$t,ce,Zt,me,Ee,Wt,_n,da=`Offloads all models to CPU using accelerate, significantly reducing memory usage. When called, unet,
text_encoder, vae and safety checker have their state dicts saved to CPU and then are moved to a
<code>torch.device(&#39;meta&#39;) and loaded to GPU only when their specific submodule has its </code>forward<code>method called. Note that offloading happens on a submodule basis. Memory savings are higher than with</code>enable_model_cpu_offload\`, but performance is lower.`,Fn,wn,zn;return g=new fe({props:{title:"Kandinsky 2.1",local:"kandinsky-21",headingTag:"h1"}}),ee=new pa({props:{$$slots:{default:[ha]},$$scope:{ctx:v}}}),ne=new pa({props:{$$slots:{default:[_a]},$$scope:{ctx:v}}}),ke=new fe({props:{title:"KandinskyPriorPipeline",local:"diffusers.KandinskyPriorPipeline",headingTag:"h2"}}),we=new J({props:{name:"class diffusers.KandinskyPriorPipeline",anchor:"diffusers.KandinskyPriorPipeline",parameters:[{name:"prior",val:": PriorTransformer"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"text_encoder",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": UnCLIPScheduler"},{name:"image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyPriorPipeline.prior",description:`<strong>prior</strong> (<a href="/docs/diffusers/v0.27.2/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonincal unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior"},{anchor:"diffusers.KandinskyPriorPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"image_encoder"},{anchor:"diffusers.KandinskyPriorPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyPriorPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.KandinskyPriorPipeline.scheduler",description:`<strong>scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_prior.py#L128"}}),Me=new J({props:{name:"__call__",anchor:"diffusers.KandinskyPriorPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"guidance_scale",val:": float = 4.0"},{name:"output_type",val:": Optional = 'pt'"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyPriorPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyPriorPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyPriorPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyPriorPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 25) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyPriorPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyPriorPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyPriorPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyPriorPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pt&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;np&quot;</code> (<code>np.array</code>) or <code>&quot;pt&quot;</code>
(<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyPriorPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.27.2/en/api/pipelines/unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_prior.py#L397",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>KandinskyPriorPipelineOutput</code> or <code>tuple</code></p>
`}}),te=new ue({props:{anchor:"diffusers.KandinskyPriorPipeline.__call__.example",$$slots:{default:[ya]},$$scope:{ctx:v}}}),ve=new J({props:{name:"interpolate",anchor:"diffusers.KandinskyPriorPipeline.interpolate",parameters:[{name:"images_and_prompts",val:": List"},{name:"weights",val:": List"},{name:"num_images_per_prompt",val:": int = 1"},{name:"num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"negative_prior_prompt",val:": Optional = None"},{name:"negative_prompt",val:": str = ''"},{name:"guidance_scale",val:": float = 4.0"},{name:"device",val:" = None"}],parametersDescription:[{anchor:"diffusers.KandinskyPriorPipeline.interpolate.images_and_prompts",description:`<strong>images_and_prompts</strong> (<code>List[Union[str, PIL.Image.Image, torch.FloatTensor]]</code>) &#x2014;
list of prompts and images to guide the image generation.
weights &#x2014; (<code>List[float]</code>):
list of weights for each condition in <code>images_and_prompts</code>`,name:"images_and_prompts"},{anchor:"diffusers.KandinskyPriorPipeline.interpolate.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyPriorPipeline.interpolate.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 25) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyPriorPipeline.interpolate.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyPriorPipeline.interpolate.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyPriorPipeline.interpolate.negative_prior_prompt",description:`<strong>negative_prior_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The prompt not to guide the prior diffusion process. Ignored when not using guidance (i.e., ignored if
<code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prior_prompt"},{anchor:"diffusers.KandinskyPriorPipeline.interpolate.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt not to guide the image generation. Ignored when not using guidance (i.e., ignored if
<code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyPriorPipeline.interpolate.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_prior.py#L172",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>KandinskyPriorPipelineOutput</code> or <code>tuple</code></p>
`}}),ae=new ue({props:{anchor:"diffusers.KandinskyPriorPipeline.interpolate.example",$$slots:{default:[ba]},$$scope:{ctx:v}}}),Te=new fe({props:{title:"KandinskyPipeline",local:"diffusers.KandinskyPipeline",headingTag:"h2"}}),Ie=new J({props:{name:"class diffusers.KandinskyPipeline",anchor:"diffusers.KandinskyPipeline",parameters:[{name:"text_encoder",val:": MultilingualCLIP"},{name:"tokenizer",val:": XLMRobertaTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": Union"},{name:"movq",val:": VQModel"}],parametersDescription:[{anchor:"diffusers.KandinskyPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>MultilingualCLIP</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>XLMRobertaTokenizer</code>) &#x2014;
Tokenizer of class`,name:"tokenizer"},{anchor:"diffusers.KandinskyPipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.27.2/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/v0.27.2/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/kandinsky/pipeline_kandinsky.py#L76"}}),Je=new J({props:{name:"__call__",anchor:"diffusers.KandinskyPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"image_embeds",val:": Union"},{name:"negative_image_embeds",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyPipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.27.2/en/api/pipelines/unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/kandinsky/pipeline_kandinsky.py#L231",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.27.2/en/api/pipelines/unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),se=new ue({props:{anchor:"diffusers.KandinskyPipeline.__call__.example",$$slots:{default:[ka]},$$scope:{ctx:v}}}),Pe=new fe({props:{title:"KandinskyCombinedPipeline",local:"diffusers.KandinskyCombinedPipeline",headingTag:"h2"}}),xe=new J({props:{name:"class diffusers.KandinskyCombinedPipeline",anchor:"diffusers.KandinskyCombinedPipeline",parameters:[{name:"text_encoder",val:": MultilingualCLIP"},{name:"tokenizer",val:": XLMRobertaTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": Union"},{name:"movq",val:": VQModel"},{name:"prior_prior",val:": PriorTransformer"},{name:"prior_image_encoder",val:": CLIPVisionModelWithProjection"},{name:"prior_text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_scheduler",val:": UnCLIPScheduler"},{name:"prior_image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyCombinedPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>MultilingualCLIP</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyCombinedPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>XLMRobertaTokenizer</code>) &#x2014;
Tokenizer of class`,name:"tokenizer"},{anchor:"diffusers.KandinskyCombinedPipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyCombinedPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.27.2/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyCombinedPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/v0.27.2/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"},{anchor:"diffusers.KandinskyCombinedPipeline.prior_prior",description:`<strong>prior_prior</strong> (<a href="/docs/diffusers/v0.27.2/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonincal unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior_prior"},{anchor:"diffusers.KandinskyCombinedPipeline.prior_image_encoder",description:`<strong>prior_image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"prior_image_encoder"},{anchor:"diffusers.KandinskyCombinedPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"prior_text_encoder"},{anchor:"diffusers.KandinskyCombinedPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"prior_tokenizer"},{anchor:"diffusers.KandinskyCombinedPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"prior_scheduler"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_combined.py#L113"}}),Ue=new J({props:{name:"__call__",anchor:"diffusers.KandinskyCombinedPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"prior_num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyCombinedPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"prior_guidance_scale"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"prior_num_inference_steps"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyCombinedPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.27.2/en/api/pipelines/unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_combined.py#L214",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.27.2/en/api/pipelines/unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),oe=new ue({props:{anchor:"diffusers.KandinskyCombinedPipeline.__call__.example",$$slots:{default:[wa]},$$scope:{ctx:v}}}),Ce=new J({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.KandinskyCombinedPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_combined.py#L195"}}),je=new fe({props:{title:"KandinskyImg2ImgPipeline",local:"diffusers.KandinskyImg2ImgPipeline",headingTag:"h2"}}),$e=new J({props:{name:"class diffusers.KandinskyImg2ImgPipeline",anchor:"diffusers.KandinskyImg2ImgPipeline",parameters:[{name:"text_encoder",val:": MultilingualCLIP"},{name:"movq",val:": VQModel"},{name:"tokenizer",val:": XLMRobertaTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDIMScheduler"}],parametersDescription:[{anchor:"diffusers.KandinskyImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>MultilingualCLIP</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>XLMRobertaTokenizer</code>) &#x2014;
Tokenizer of class`,name:"tokenizer"},{anchor:"diffusers.KandinskyImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.27.2/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyImg2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.27.2/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyImg2ImgPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/v0.27.2/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ image encoder and decoder`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_img2img.py#L98"}}),Ze=new J({props:{name:"__call__",anchor:"diffusers.KandinskyImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"image",val:": Union"},{name:"image_embeds",val:": FloatTensor"},{name:"negative_image_embeds",val:": FloatTensor"},{name:"negative_prompt",val:": Union = None"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"strength",val:": float = 0.3"},{name:"guidance_scale",val:": float = 7.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process.`,name:"image"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.3) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.27.2/en/api/pipelines/unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_img2img.py#L293",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.27.2/en/api/pipelines/unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),re=new ue({props:{anchor:"diffusers.KandinskyImg2ImgPipeline.__call__.example",$$slots:{default:[Ma]},$$scope:{ctx:v}}}),We=new fe({props:{title:"KandinskyImg2ImgCombinedPipeline",local:"diffusers.KandinskyImg2ImgCombinedPipeline",headingTag:"h2"}}),Ge=new J({props:{name:"class diffusers.KandinskyImg2ImgCombinedPipeline",anchor:"diffusers.KandinskyImg2ImgCombinedPipeline",parameters:[{name:"text_encoder",val:": MultilingualCLIP"},{name:"tokenizer",val:": XLMRobertaTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": Union"},{name:"movq",val:": VQModel"},{name:"prior_prior",val:": PriorTransformer"},{name:"prior_image_encoder",val:": CLIPVisionModelWithProjection"},{name:"prior_text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_scheduler",val:": UnCLIPScheduler"},{name:"prior_image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>MultilingualCLIP</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>XLMRobertaTokenizer</code>) &#x2014;
Tokenizer of class`,name:"tokenizer"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.27.2/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/v0.27.2/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.prior_prior",description:`<strong>prior_prior</strong> (<a href="/docs/diffusers/v0.27.2/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonincal unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior_prior"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.prior_image_encoder",description:`<strong>prior_image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"prior_image_encoder"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"prior_text_encoder"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"prior_tokenizer"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"prior_scheduler"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_combined.py#L330"}}),Be=new J({props:{name:"__call__",anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"image",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"strength",val:": float = 0.3"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"prior_num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process. Can also accept image latents as <code>image</code>, if passing latents directly, it will not be encoded
again.`,name:"image"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.3) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"prior_guidance_scale"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"prior_num_inference_steps"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.27.2/en/api/pipelines/unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_combined.py#L432",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.27.2/en/api/pipelines/unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),le=new ue({props:{anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.__call__.example",$$slots:{default:[va]},$$scope:{ctx:v}}}),Ke=new J({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.KandinskyImg2ImgCombinedPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_combined.py#L412"}}),Ve=new fe({props:{title:"KandinskyInpaintPipeline",local:"diffusers.KandinskyInpaintPipeline",headingTag:"h2"}}),qe=new J({props:{name:"class diffusers.KandinskyInpaintPipeline",anchor:"diffusers.KandinskyInpaintPipeline",parameters:[{name:"text_encoder",val:": MultilingualCLIP"},{name:"movq",val:": VQModel"},{name:"tokenizer",val:": XLMRobertaTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDIMScheduler"}],parametersDescription:[{anchor:"diffusers.KandinskyInpaintPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>MultilingualCLIP</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyInpaintPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>XLMRobertaTokenizer</code>) &#x2014;
Tokenizer of class`,name:"tokenizer"},{anchor:"diffusers.KandinskyInpaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.27.2/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyInpaintPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.27.2/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyInpaintPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/v0.27.2/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ image encoder and decoder`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_inpaint.py#L240"}}),Le=new J({props:{name:"__call__",anchor:"diffusers.KandinskyInpaintPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"image",val:": Union"},{name:"mask_image",val:": Union"},{name:"image_embeds",val:": FloatTensor"},{name:"negative_image_embeds",val:": FloatTensor"},{name:"negative_prompt",val:": Union = None"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code> or <code>np.ndarray</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process.`,name:"image"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>PIL.Image.Image</code>,<code>torch.FloatTensor</code> or <code>np.ndarray</code>) &#x2014;
<code>Image</code>, or a tensor representing an image batch, to mask <code>image</code>. White pixels in the mask will be
repainted, while black pixels will be preserved. You can pass a pytorch tensor as mask only if the
image you passed is a pytorch tensor, and it should contain one color channel (L) instead of 3, so the
expected shape would be either <code>(B, 1, H, W,)</code>, <code>(B, H, W)</code>, <code>(1, H, W)</code> or <code>(H, W)</code> If image is an PIL
image or numpy array, mask should also be a either PIL image or numpy array. If it is a PIL image, it
will be converted to a single channel (luminance) before use. If it is a nummpy array, the expected
shape is <code>(H, W)</code>.`,name:"mask_image"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.27.2/en/api/pipelines/unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_inpaint.py#L396",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.27.2/en/api/pipelines/unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),pe=new ue({props:{anchor:"diffusers.KandinskyInpaintPipeline.__call__.example",$$slots:{default:[Ta]},$$scope:{ctx:v}}}),Fe=new fe({props:{title:"KandinskyInpaintCombinedPipeline",local:"diffusers.KandinskyInpaintCombinedPipeline",headingTag:"h2"}}),ze=new J({props:{name:"class diffusers.KandinskyInpaintCombinedPipeline",anchor:"diffusers.KandinskyInpaintCombinedPipeline",parameters:[{name:"text_encoder",val:": MultilingualCLIP"},{name:"tokenizer",val:": XLMRobertaTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": Union"},{name:"movq",val:": VQModel"},{name:"prior_prior",val:": PriorTransformer"},{name:"prior_image_encoder",val:": CLIPVisionModelWithProjection"},{name:"prior_text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_scheduler",val:": UnCLIPScheduler"},{name:"prior_image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyInpaintCombinedPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>MultilingualCLIP</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>XLMRobertaTokenizer</code>) &#x2014;
Tokenizer of class`,name:"tokenizer"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.27.2/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/v0.27.2/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.prior_prior",description:`<strong>prior_prior</strong> (<a href="/docs/diffusers/v0.27.2/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonincal unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior_prior"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.prior_image_encoder",description:`<strong>prior_image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"prior_image_encoder"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"prior_text_encoder"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"prior_tokenizer"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"prior_scheduler"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_combined.py#L570"}}),Ne=new J({props:{name:"__call__",anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"image",val:": Union"},{name:"mask_image",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"prior_num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process. Can also accept image latents as <code>image</code>, if passing latents directly, it will not be encoded
again.`,name:"image"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>np.array</code>) &#x2014;
Tensor representing an image batch, to mask <code>image</code>. White pixels in the mask will be repainted, while
black pixels will be preserved. If <code>mask_image</code> is a PIL image, it will be converted to a single
channel (luminance) before use. If it&#x2019;s a tensor, it should contain one color channel (L) instead of 3,
so the expected shape would be <code>(B, H, W, 1)</code>.`,name:"mask_image"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"prior_guidance_scale"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"prior_num_inference_steps"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.27.2/en/api/pipelines/unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_combined.py#L672",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.27.2/en/api/pipelines/unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),ce=new ue({props:{anchor:"diffusers.KandinskyInpaintCombinedPipeline.__call__.example",$$slots:{default:[Ia]},$$scope:{ctx:v}}}),Ee=new J({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.KandinskyInpaintCombinedPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/kandinsky/pipeline_kandinsky_combined.py#L652"}}),{c(){t=d("meta"),M=o(),c=d("p"),r=o(),u(g.$$.fragment),n=o(),k=d("p"),k.innerHTML=Gt,Mn=o(),_e=d("p"),_e.textContent=Bt,vn=o(),ye=d("p"),ye.innerHTML=Kt,Tn=o(),be=d("p"),be.innerHTML=Vt,In=o(),u(ee.$$.fragment),Jn=o(),u(ne.$$.fragment),Pn=o(),u(ke.$$.fragment),xn=o(),P=d("div"),u(we.$$.fragment),Qn=o(),Re=d("p"),Re.textContent=qt,Rn=o(),Xe=d("p"),Xe.innerHTML=Lt,Xn=o(),V=d("div"),u(Me.$$.fragment),Sn=o(),Se=d("p"),Se.textContent=Ft,Dn=o(),u(te.$$.fragment),Hn=o(),q=d("div"),u(ve.$$.fragment),Yn=o(),De=d("p"),De.textContent=zt,An=o(),u(ae.$$.fragment),Un=o(),u(Te.$$.fragment),Cn=o(),j=d("div"),u(Ie.$$.fragment),On=o(),He=d("p"),He.textContent=Nt,et=o(),Ye=d("p"),Ye.innerHTML=Et,nt=o(),L=d("div"),u(Je.$$.fragment),tt=o(),Ae=d("p"),Ae.textContent=Qt,at=o(),u(se.$$.fragment),jn=o(),u(Pe.$$.fragment),$n=o(),x=d("div"),u(xe.$$.fragment),st=o(),Oe=d("p"),Oe.textContent=Rt,ot=o(),en=d("p"),en.innerHTML=Xt,it=o(),F=d("div"),u(Ue.$$.fragment),rt=o(),nn=d("p"),nn.textContent=St,lt=o(),u(oe.$$.fragment),dt=o(),ie=d("div"),u(Ce.$$.fragment),pt=o(),tn=d("p"),tn.innerHTML=Dt,Zn=o(),u(je.$$.fragment),Wn=o(),$=d("div"),u($e.$$.fragment),ct=o(),an=d("p"),an.textContent=Ht,mt=o(),sn=d("p"),sn.innerHTML=Yt,gt=o(),z=d("div"),u(Ze.$$.fragment),ut=o(),on=d("p"),on.textContent=At,ft=o(),u(re.$$.fragment),Gn=o(),u(We.$$.fragment),Bn=o(),U=d("div"),u(Ge.$$.fragment),ht=o(),rn=d("p"),rn.textContent=Ot,_t=o(),ln=d("p"),ln.innerHTML=ea,yt=o(),N=d("div"),u(Be.$$.fragment),bt=o(),dn=d("p"),dn.textContent=na,kt=o(),u(le.$$.fragment),wt=o(),de=d("div"),u(Ke.$$.fragment),Mt=o(),pn=d("p"),pn.innerHTML=ta,Kn=o(),u(Ve.$$.fragment),Vn=o(),Z=d("div"),u(qe.$$.fragment),vt=o(),cn=d("p"),cn.textContent=aa,Tt=o(),mn=d("p"),mn.innerHTML=sa,It=o(),E=d("div"),u(Le.$$.fragment),Jt=o(),gn=d("p"),gn.textContent=oa,Pt=o(),u(pe.$$.fragment),qn=o(),u(Fe.$$.fragment),Ln=o(),C=d("div"),u(ze.$$.fragment),xt=o(),un=d("p"),un.textContent=ia,Ut=o(),fn=d("p"),fn.innerHTML=ra,Ct=o(),Q=d("div"),u(Ne.$$.fragment),jt=o(),hn=d("p"),hn.textContent=la,$t=o(),u(ce.$$.fragment),Zt=o(),me=d("div"),u(Ee.$$.fragment),Wt=o(),_n=d("p"),_n.innerHTML=da,Fn=o(),wn=d("p"),this.h()},l(e){const l=fa("svelte-u9bgzb",document.head);t=p(l,"META",{name:!0,content:!0}),l.forEach(s),M=i(e),c=p(e,"P",{}),T(c).forEach(s),r=i(e),f(g.$$.fragment,e),n=i(e),k=p(e,"P",{"data-svelte-h":!0}),w(k)!=="svelte-z239mp"&&(k.innerHTML=Gt),Mn=i(e),_e=p(e,"P",{"data-svelte-h":!0}),w(_e)!=="svelte-1og8lwg"&&(_e.textContent=Bt),vn=i(e),ye=p(e,"P",{"data-svelte-h":!0}),w(ye)!=="svelte-1ax7cek"&&(ye.innerHTML=Kt),Tn=i(e),be=p(e,"P",{"data-svelte-h":!0}),w(be)!=="svelte-14rg3yz"&&(be.innerHTML=Vt),In=i(e),f(ee.$$.fragment,e),Jn=i(e),f(ne.$$.fragment,e),Pn=i(e),f(ke.$$.fragment,e),xn=i(e),P=p(e,"DIV",{class:!0});var W=T(P);f(we.$$.fragment,W),Qn=i(W),Re=p(W,"P",{"data-svelte-h":!0}),w(Re)!=="svelte-gfz7tn"&&(Re.textContent=qt),Rn=i(W),Xe=p(W,"P",{"data-svelte-h":!0}),w(Xe)!=="svelte-134paxr"&&(Xe.innerHTML=Lt),Xn=i(W),V=p(W,"DIV",{class:!0});var D=T(V);f(Me.$$.fragment,D),Sn=i(D),Se=p(D,"P",{"data-svelte-h":!0}),w(Se)!=="svelte-v78lg8"&&(Se.textContent=Ft),Dn=i(D),f(te.$$.fragment,D),D.forEach(s),Hn=i(W),q=p(W,"DIV",{class:!0});var H=T(q);f(ve.$$.fragment,H),Yn=i(H),De=p(H,"P",{"data-svelte-h":!0}),w(De)!=="svelte-1k7d7q8"&&(De.textContent=zt),An=i(H),f(ae.$$.fragment,H),H.forEach(s),W.forEach(s),Un=i(e),f(Te.$$.fragment,e),Cn=i(e),j=p(e,"DIV",{class:!0});var B=T(j);f(Ie.$$.fragment,B),On=i(B),He=p(B,"P",{"data-svelte-h":!0}),w(He)!=="svelte-jhhofy"&&(He.textContent=Nt),et=i(B),Ye=p(B,"P",{"data-svelte-h":!0}),w(Ye)!=="svelte-134paxr"&&(Ye.innerHTML=Et),nt=i(B),L=p(B,"DIV",{class:!0});var Y=T(L);f(Je.$$.fragment,Y),tt=i(Y),Ae=p(Y,"P",{"data-svelte-h":!0}),w(Ae)!=="svelte-v78lg8"&&(Ae.textContent=Qt),at=i(Y),f(se.$$.fragment,Y),Y.forEach(s),B.forEach(s),jn=i(e),f(Pe.$$.fragment,e),$n=i(e),x=p(e,"DIV",{class:!0});var G=T(x);f(xe.$$.fragment,G),st=i(G),Oe=p(G,"P",{"data-svelte-h":!0}),w(Oe)!=="svelte-1spbql3"&&(Oe.textContent=Rt),ot=i(G),en=p(G,"P",{"data-svelte-h":!0}),w(en)!=="svelte-134paxr"&&(en.innerHTML=Xt),it=i(G),F=p(G,"DIV",{class:!0});var A=T(F);f(Ue.$$.fragment,A),rt=i(A),nn=p(A,"P",{"data-svelte-h":!0}),w(nn)!=="svelte-v78lg8"&&(nn.textContent=St),lt=i(A),f(oe.$$.fragment,A),A.forEach(s),dt=i(G),ie=p(G,"DIV",{class:!0});var Qe=T(ie);f(Ce.$$.fragment,Qe),pt=i(Qe),tn=p(Qe,"P",{"data-svelte-h":!0}),w(tn)!=="svelte-a2a0wt"&&(tn.innerHTML=Dt),Qe.forEach(s),G.forEach(s),Zn=i(e),f(je.$$.fragment,e),Wn=i(e),$=p(e,"DIV",{class:!0});var K=T($);f($e.$$.fragment,K),ct=i(K),an=p(K,"P",{"data-svelte-h":!0}),w(an)!=="svelte-1nm2rj2"&&(an.textContent=Ht),mt=i(K),sn=p(K,"P",{"data-svelte-h":!0}),w(sn)!=="svelte-134paxr"&&(sn.innerHTML=Yt),gt=i(K),z=p(K,"DIV",{class:!0});var O=T(z);f(Ze.$$.fragment,O),ut=i(O),on=p(O,"P",{"data-svelte-h":!0}),w(on)!=="svelte-v78lg8"&&(on.textContent=At),ft=i(O),f(re.$$.fragment,O),O.forEach(s),K.forEach(s),Gn=i(e),f(We.$$.fragment,e),Bn=i(e),U=p(e,"DIV",{class:!0});var R=T(U);f(Ge.$$.fragment,R),ht=i(R),rn=p(R,"P",{"data-svelte-h":!0}),w(rn)!=="svelte-1ql3mrb"&&(rn.textContent=Ot),_t=i(R),ln=p(R,"P",{"data-svelte-h":!0}),w(ln)!=="svelte-134paxr"&&(ln.innerHTML=ea),yt=i(R),N=p(R,"DIV",{class:!0});var yn=T(N);f(Be.$$.fragment,yn),bt=i(yn),dn=p(yn,"P",{"data-svelte-h":!0}),w(dn)!=="svelte-v78lg8"&&(dn.textContent=na),kt=i(yn),f(le.$$.fragment,yn),yn.forEach(s),wt=i(R),de=p(R,"DIV",{class:!0});var Nn=T(de);f(Ke.$$.fragment,Nn),Mt=i(Nn),pn=p(Nn,"P",{"data-svelte-h":!0}),w(pn)!=="svelte-1ff7ilh"&&(pn.innerHTML=ta),Nn.forEach(s),R.forEach(s),Kn=i(e),f(Ve.$$.fragment,e),Vn=i(e),Z=p(e,"DIV",{class:!0});var ge=T(Z);f(qe.$$.fragment,ge),vt=i(ge),cn=p(ge,"P",{"data-svelte-h":!0}),w(cn)!=="svelte-2p9m8a"&&(cn.textContent=aa),Tt=i(ge),mn=p(ge,"P",{"data-svelte-h":!0}),w(mn)!=="svelte-134paxr"&&(mn.innerHTML=sa),It=i(ge),E=p(ge,"DIV",{class:!0});var bn=T(E);f(Le.$$.fragment,bn),Jt=i(bn),gn=p(bn,"P",{"data-svelte-h":!0}),w(gn)!=="svelte-v78lg8"&&(gn.textContent=oa),Pt=i(bn),f(pe.$$.fragment,bn),bn.forEach(s),ge.forEach(s),qn=i(e),f(Fe.$$.fragment,e),Ln=i(e),C=p(e,"DIV",{class:!0});var X=T(C);f(ze.$$.fragment,X),xt=i(X),un=p(X,"P",{"data-svelte-h":!0}),w(un)!=="svelte-18rw6ko"&&(un.textContent=ia),Ut=i(X),fn=p(X,"P",{"data-svelte-h":!0}),w(fn)!=="svelte-134paxr"&&(fn.innerHTML=ra),Ct=i(X),Q=p(X,"DIV",{class:!0});var kn=T(Q);f(Ne.$$.fragment,kn),jt=i(kn),hn=p(kn,"P",{"data-svelte-h":!0}),w(hn)!=="svelte-v78lg8"&&(hn.textContent=la),$t=i(kn),f(ce.$$.fragment,kn),kn.forEach(s),Zt=i(X),me=p(X,"DIV",{class:!0});var En=T(me);f(Ee.$$.fragment,En),Wt=i(En),_n=p(En,"P",{"data-svelte-h":!0}),w(_n)!=="svelte-1ff7ilh"&&(_n.innerHTML=da),En.forEach(s),X.forEach(s),Fn=i(e),wn=p(e,"P",{}),T(wn).forEach(s),this.h()},h(){I(t,"name","hf:doc:metadata"),I(t,"content",Pa),I(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,l){a(document.head,t),m(e,M,l),m(e,c,l),m(e,r,l),h(g,e,l),m(e,n,l),m(e,k,l),m(e,Mn,l),m(e,_e,l),m(e,vn,l),m(e,ye,l),m(e,Tn,l),m(e,be,l),m(e,In,l),h(ee,e,l),m(e,Jn,l),h(ne,e,l),m(e,Pn,l),h(ke,e,l),m(e,xn,l),m(e,P,l),h(we,P,null),a(P,Qn),a(P,Re),a(P,Rn),a(P,Xe),a(P,Xn),a(P,V),h(Me,V,null),a(V,Sn),a(V,Se),a(V,Dn),h(te,V,null),a(P,Hn),a(P,q),h(ve,q,null),a(q,Yn),a(q,De),a(q,An),h(ae,q,null),m(e,Un,l),h(Te,e,l),m(e,Cn,l),m(e,j,l),h(Ie,j,null),a(j,On),a(j,He),a(j,et),a(j,Ye),a(j,nt),a(j,L),h(Je,L,null),a(L,tt),a(L,Ae),a(L,at),h(se,L,null),m(e,jn,l),h(Pe,e,l),m(e,$n,l),m(e,x,l),h(xe,x,null),a(x,st),a(x,Oe),a(x,ot),a(x,en),a(x,it),a(x,F),h(Ue,F,null),a(F,rt),a(F,nn),a(F,lt),h(oe,F,null),a(x,dt),a(x,ie),h(Ce,ie,null),a(ie,pt),a(ie,tn),m(e,Zn,l),h(je,e,l),m(e,Wn,l),m(e,$,l),h($e,$,null),a($,ct),a($,an),a($,mt),a($,sn),a($,gt),a($,z),h(Ze,z,null),a(z,ut),a(z,on),a(z,ft),h(re,z,null),m(e,Gn,l),h(We,e,l),m(e,Bn,l),m(e,U,l),h(Ge,U,null),a(U,ht),a(U,rn),a(U,_t),a(U,ln),a(U,yt),a(U,N),h(Be,N,null),a(N,bt),a(N,dn),a(N,kt),h(le,N,null),a(U,wt),a(U,de),h(Ke,de,null),a(de,Mt),a(de,pn),m(e,Kn,l),h(Ve,e,l),m(e,Vn,l),m(e,Z,l),h(qe,Z,null),a(Z,vt),a(Z,cn),a(Z,Tt),a(Z,mn),a(Z,It),a(Z,E),h(Le,E,null),a(E,Jt),a(E,gn),a(E,Pt),h(pe,E,null),m(e,qn,l),h(Fe,e,l),m(e,Ln,l),m(e,C,l),h(ze,C,null),a(C,xt),a(C,un),a(C,Ut),a(C,fn),a(C,Ct),a(C,Q),h(Ne,Q,null),a(Q,jt),a(Q,hn),a(Q,$t),h(ce,Q,null),a(C,Zt),a(C,me),h(Ee,me,null),a(me,Wt),a(me,_n),m(e,Fn,l),m(e,wn,l),zn=!0},p(e,[l]){const W={};l&2&&(W.$$scope={dirty:l,ctx:e}),ee.$set(W);const D={};l&2&&(D.$$scope={dirty:l,ctx:e}),ne.$set(D);const H={};l&2&&(H.$$scope={dirty:l,ctx:e}),te.$set(H);const B={};l&2&&(B.$$scope={dirty:l,ctx:e}),ae.$set(B);const Y={};l&2&&(Y.$$scope={dirty:l,ctx:e}),se.$set(Y);const G={};l&2&&(G.$$scope={dirty:l,ctx:e}),oe.$set(G);const A={};l&2&&(A.$$scope={dirty:l,ctx:e}),re.$set(A);const Qe={};l&2&&(Qe.$$scope={dirty:l,ctx:e}),le.$set(Qe);const K={};l&2&&(K.$$scope={dirty:l,ctx:e}),pe.$set(K);const O={};l&2&&(O.$$scope={dirty:l,ctx:e}),ce.$set(O)},i(e){zn||(_(g.$$.fragment,e),_(ee.$$.fragment,e),_(ne.$$.fragment,e),_(ke.$$.fragment,e),_(we.$$.fragment,e),_(Me.$$.fragment,e),_(te.$$.fragment,e),_(ve.$$.fragment,e),_(ae.$$.fragment,e),_(Te.$$.fragment,e),_(Ie.$$.fragment,e),_(Je.$$.fragment,e),_(se.$$.fragment,e),_(Pe.$$.fragment,e),_(xe.$$.fragment,e),_(Ue.$$.fragment,e),_(oe.$$.fragment,e),_(Ce.$$.fragment,e),_(je.$$.fragment,e),_($e.$$.fragment,e),_(Ze.$$.fragment,e),_(re.$$.fragment,e),_(We.$$.fragment,e),_(Ge.$$.fragment,e),_(Be.$$.fragment,e),_(le.$$.fragment,e),_(Ke.$$.fragment,e),_(Ve.$$.fragment,e),_(qe.$$.fragment,e),_(Le.$$.fragment,e),_(pe.$$.fragment,e),_(Fe.$$.fragment,e),_(ze.$$.fragment,e),_(Ne.$$.fragment,e),_(ce.$$.fragment,e),_(Ee.$$.fragment,e),zn=!0)},o(e){y(g.$$.fragment,e),y(ee.$$.fragment,e),y(ne.$$.fragment,e),y(ke.$$.fragment,e),y(we.$$.fragment,e),y(Me.$$.fragment,e),y(te.$$.fragment,e),y(ve.$$.fragment,e),y(ae.$$.fragment,e),y(Te.$$.fragment,e),y(Ie.$$.fragment,e),y(Je.$$.fragment,e),y(se.$$.fragment,e),y(Pe.$$.fragment,e),y(xe.$$.fragment,e),y(Ue.$$.fragment,e),y(oe.$$.fragment,e),y(Ce.$$.fragment,e),y(je.$$.fragment,e),y($e.$$.fragment,e),y(Ze.$$.fragment,e),y(re.$$.fragment,e),y(We.$$.fragment,e),y(Ge.$$.fragment,e),y(Be.$$.fragment,e),y(le.$$.fragment,e),y(Ke.$$.fragment,e),y(Ve.$$.fragment,e),y(qe.$$.fragment,e),y(Le.$$.fragment,e),y(pe.$$.fragment,e),y(Fe.$$.fragment,e),y(ze.$$.fragment,e),y(Ne.$$.fragment,e),y(ce.$$.fragment,e),y(Ee.$$.fragment,e),zn=!1},d(e){e&&(s(M),s(c),s(r),s(n),s(k),s(Mn),s(_e),s(vn),s(ye),s(Tn),s(be),s(In),s(Jn),s(Pn),s(xn),s(P),s(Un),s(Cn),s(j),s(jn),s($n),s(x),s(Zn),s(Wn),s($),s(Gn),s(Bn),s(U),s(Kn),s(Vn),s(Z),s(qn),s(Ln),s(C),s(Fn),s(wn)),s(t),b(g,e),b(ee,e),b(ne,e),b(ke,e),b(we),b(Me),b(te),b(ve),b(ae),b(Te,e),b(Ie),b(Je),b(se),b(Pe,e),b(xe),b(Ue),b(oe),b(Ce),b(je,e),b($e),b(Ze),b(re),b(We,e),b(Ge),b(Be),b(le),b(Ke),b(Ve,e),b(qe),b(Le),b(pe),b(Fe,e),b(ze),b(Ne),b(ce),b(Ee)}}}const Pa='{"title":"Kandinsky 2.1","local":"kandinsky-21","sections":[{"title":"KandinskyPriorPipeline","local":"diffusers.KandinskyPriorPipeline","sections":[],"depth":2},{"title":"KandinskyPipeline","local":"diffusers.KandinskyPipeline","sections":[],"depth":2},{"title":"KandinskyCombinedPipeline","local":"diffusers.KandinskyCombinedPipeline","sections":[],"depth":2},{"title":"KandinskyImg2ImgPipeline","local":"diffusers.KandinskyImg2ImgPipeline","sections":[],"depth":2},{"title":"KandinskyImg2ImgCombinedPipeline","local":"diffusers.KandinskyImg2ImgCombinedPipeline","sections":[],"depth":2},{"title":"KandinskyInpaintPipeline","local":"diffusers.KandinskyInpaintPipeline","sections":[],"depth":2},{"title":"KandinskyInpaintCombinedPipeline","local":"diffusers.KandinskyInpaintCombinedPipeline","sections":[],"depth":2}],"depth":1}';function xa(v){return ma(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ba extends ga{constructor(t){super(),ua(this,t,xa,Ja,ca,{})}}export{Ba as component};
