import{s as Le,n as Ue,o as Ge}from"../chunks/scheduler.182ea377.js";import{S as Je,i as De,g as i,s as a,r as c,A as je,h as r,f as n,c as s,j as X,u as d,x as b,k as z,y as m,a as o,v as u,d as p,t as f,w as g}from"../chunks/index.1ea56653.js";import{H as N,g as Ke}from"../chunks/Heading.71ac6e9f.js";import{D as pe}from"../chunks/Docstring.59aaf0cd.js";import{C as Ce}from"../chunks/CodeBlock.82c2494b.js";function Fe(be){let h,Q,V,S,w,I,k,ve='Improved larger variational autoencoder (VAE) model with KL loss for inpainting task: <a href="https://arxiv.org/abs/2306.04632" rel="nofollow">Designing a Better Asymmetric VQGAN for StableDiffusion</a> by Zixin Zhu, Xuelu Feng, Dongdong Chen, Jianmin Bao, Le Wang, Yinpeng Chen, Lu Yuan, Gang Hua.',H,M,we="The abstract from the paper is:",q,A,ke='<em>StableDiffusion is a revolutionary text-to-image generator that is causing a stir in the world of image generation and editing. Unlike traditional methods that learn a diffusion model in pixel space, StableDiffusion learns a diffusion model in the latent space via a VQGAN, ensuring both efficiency and quality. It not only supports image generation tasks, but also enables image editing for real images, such as image inpainting and local editing. However, we have observed that the vanilla VQGAN used in StableDiffusion leads to significant information loss, causing distortion artifacts even in non-edited image regions. To this end, we propose a new asymmetric VQGAN with two simple designs. Firstly, in addition to the input from the encoder, the decoder contains a conditional branch that incorporates information from task-specific priors, such as the unmasked image region in inpainting. Secondly, the decoder is much heavier than the encoder, allowing for more detailed recovery while only slightly increasing the total inference cost. The training cost of our asymmetric VQGAN is cheap, and we only need to retrain a new asymmetric decoder while keeping the vanilla VQGAN encoder and StableDiffusion unchanged. Our asymmetric VQGAN can be widely used in StableDiffusion-based inpainting and local editing methods. Extensive experiments demonstrate that it can significantly improve the inpainting and editing performance, while maintaining the original text-to-image capability. The code is available at <a href="https://github.com/buxiangzhiren/Asymmetric_VQGAN" rel="nofollow">https://github.com/buxiangzhiren/Asymmetric_VQGAN</a></em>',O,$,Me="Evaluation results can be found in section 4.1 of the original paper.",P,T,ee,x,Ae='<li><a href="https://huggingface.co/cross-attention/asymmetric-autoencoder-kl-x-1-5" rel="nofollow">https://huggingface.co/cross-attention/asymmetric-autoencoder-kl-x-1-5</a></li> <li><a href="https://huggingface.co/cross-attention/asymmetric-autoencoder-kl-x-2" rel="nofollow">https://huggingface.co/cross-attention/asymmetric-autoencoder-kl-x-2</a></li>',te,Z,ne,W,oe,L,ae,l,U,fe,C,$e=`Designing a Better Asymmetric VQGAN for StableDiffusion <a href="https://arxiv.org/abs/2306.04632" rel="nofollow">https://arxiv.org/abs/2306.04632</a> . A VAE model with KL loss
for encoding images into latents and decoding latent representations into images.`,ge,F,Te=`This model inherits from <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin">ModelMixin</a>. Check the superclass documentation for it’s generic methods implemented
for all models (such as downloading or saving).`,he,R,G,se,J,ie,_,D,_e,B,xe="Output of AutoencoderKL encoding method.",re,j,le,y,K,ye,E,Ze="Output of decoding method.",ce,Y,de;return w=new N({props:{title:"AsymmetricAutoencoderKL",local:"asymmetricautoencoderkl",headingTag:"h1"}}),T=new N({props:{title:"Available checkpoints",local:"available-checkpoints",headingTag:"h2"}}),Z=new N({props:{title:"Example Usage",local:"example-usage",headingTag:"h2"}}),W=new Ce({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEFzeW1tZXRyaWNBdXRvZW5jb2RlcktMJTJDJTIwU3RhYmxlRGlmZnVzaW9uSW5wYWludFBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEElMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBwZXJzb24lMjB3aXRoJTIwYmVhcmQlMjIlMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnJlcGFpbnQlMkZjZWxlYmFfaHFfMjU2LnBuZyUyMiUwQW1hc2tfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnJlcGFpbnQlMkZtYXNrXzI1Ni5wbmclMjIlMEElMEFvcmlnaW5hbF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoaW1nX3VybCkucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQW1hc2tfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKG1hc2tfdXJsKS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLWlucGFpbnRpbmclMjIpJTBBcGlwZS52YWUlMjAlM0QlMjBBc3ltbWV0cmljQXV0b2VuY29kZXJLTC5mcm9tX3ByZXRyYWluZWQoJTIyY3Jvc3MtYXR0ZW50aW9uJTJGYXN5bW1ldHJpYy1hdXRvZW5jb2Rlci1rbC14LTEtNSUyMiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEb3JpZ2luYWxfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJvcmlnaW5hbF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDMp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AsymmetricAutoencoderKL, StableDiffusionInpaintPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid


prompt = <span class="hljs-string">&quot;a photo of a person with beard&quot;</span>
img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/repaint/celeba_hq_256.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/repaint/mask_256.png&quot;</span>

original_image = load_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
mask_image = load_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

pipe = StableDiffusionInpaintPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>)
pipe.vae = AsymmetricAutoencoderKL.from_pretrained(<span class="hljs-string">&quot;cross-attention/asymmetric-autoencoder-kl-x-1-5&quot;</span>)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipe(prompt=prompt, image=original_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]
make_image_grid([original_image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),L=new N({props:{title:"AsymmetricAutoencoderKL",local:"diffusers.AsymmetricAutoencoderKL",headingTag:"h2"}}),U=new pe({props:{name:"class diffusers.AsymmetricAutoencoderKL",anchor:"diffusers.AsymmetricAutoencoderKL",parameters:[{name:"in_channels",val:": int = 3"},{name:"out_channels",val:": int = 3"},{name:"down_block_types",val:": typing.Tuple[str] = ('DownEncoderBlock2D',)"},{name:"down_block_out_channels",val:": typing.Tuple[int] = (64,)"},{name:"layers_per_down_block",val:": int = 1"},{name:"up_block_types",val:": typing.Tuple[str] = ('UpDecoderBlock2D',)"},{name:"up_block_out_channels",val:": typing.Tuple[int] = (64,)"},{name:"layers_per_up_block",val:": int = 1"},{name:"act_fn",val:": str = 'silu'"},{name:"latent_channels",val:": int = 4"},{name:"norm_num_groups",val:": int = 32"},{name:"sample_size",val:": int = 32"},{name:"scaling_factor",val:": float = 0.18215"}],parametersDescription:[{anchor:"diffusers.AsymmetricAutoencoderKL.in_channels",description:"<strong>in_channels</strong> (int, <em>optional</em>, defaults to 3) &#x2014; Number of channels in the input image.",name:"in_channels"},{anchor:"diffusers.AsymmetricAutoencoderKL.out_channels",description:"<strong>out_channels</strong> (int,  <em>optional</em>, defaults to 3) &#x2014; Number of channels in the output.",name:"out_channels"},{anchor:"diffusers.AsymmetricAutoencoderKL.down_block_types",description:`<strong>down_block_types</strong> (<code>Tuple[str]</code>, <em>optional</em>, defaults to <code>(&quot;DownEncoderBlock2D&quot;,)</code>) &#x2014;
Tuple of downsample block types.`,name:"down_block_types"},{anchor:"diffusers.AsymmetricAutoencoderKL.down_block_out_channels",description:`<strong>down_block_out_channels</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>(64,)</code>) &#x2014;
Tuple of down block output channels.`,name:"down_block_out_channels"},{anchor:"diffusers.AsymmetricAutoencoderKL.layers_per_down_block",description:`<strong>layers_per_down_block</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
Number layers for down block.`,name:"layers_per_down_block"},{anchor:"diffusers.AsymmetricAutoencoderKL.up_block_types",description:`<strong>up_block_types</strong> (<code>Tuple[str]</code>, <em>optional</em>, defaults to <code>(&quot;UpDecoderBlock2D&quot;,)</code>) &#x2014;
Tuple of upsample block types.`,name:"up_block_types"},{anchor:"diffusers.AsymmetricAutoencoderKL.up_block_out_channels",description:`<strong>up_block_out_channels</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>(64,)</code>) &#x2014;
Tuple of up block output channels.`,name:"up_block_out_channels"},{anchor:"diffusers.AsymmetricAutoencoderKL.layers_per_up_block",description:`<strong>layers_per_up_block</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
Number layers for up block.`,name:"layers_per_up_block"},{anchor:"diffusers.AsymmetricAutoencoderKL.act_fn",description:"<strong>act_fn</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014; The activation function to use.",name:"act_fn"},{anchor:"diffusers.AsymmetricAutoencoderKL.latent_channels",description:"<strong>latent_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014; Number of channels in the latent space.",name:"latent_channels"},{anchor:"diffusers.AsymmetricAutoencoderKL.sample_size",description:"<strong>sample_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>32</code>) &#x2014; Sample input size.",name:"sample_size"},{anchor:"diffusers.AsymmetricAutoencoderKL.norm_num_groups",description:`<strong>norm_num_groups</strong> (<code>int</code>, <em>optional</em>, defaults to <code>32</code>) &#x2014;
Number of groups to use for the first normalization layer in ResNet blocks.`,name:"norm_num_groups"},{anchor:"diffusers.AsymmetricAutoencoderKL.scaling_factor",description:`<strong>scaling_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.18215) &#x2014;
The component-wise standard deviation of the trained latent space computed using the first batch of the
training set. This is used to scale the latent space to have unit variance when training the diffusion
model. The latents are scaled with the formula <code>z = z * scaling_factor</code> before being passed to the
diffusion model. When decoding, the latents are scaled back to the original scale with the formula: <code>z = 1 / scaling_factor * z</code>. For more details, refer to sections 4.3.2 and D.1 of the <a href="https://arxiv.org/abs/2112.10752" rel="nofollow">High-Resolution Image
Synthesis with Latent Diffusion Models</a> paper.`,name:"scaling_factor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoder_asym_kl.py#L26"}}),G=new pe({props:{name:"forward",anchor:"diffusers.AsymmetricAutoencoderKL.forward",parameters:[{name:"sample",val:": FloatTensor"},{name:"mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"sample_posterior",val:": bool = False"},{name:"return_dict",val:": bool = True"},{name:"generator",val:": typing.Optional[torch._C.Generator] = None"}],parametersDescription:[{anchor:"diffusers.AsymmetricAutoencoderKL.forward.sample",description:"<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014; Input sample.",name:"sample"},{anchor:"diffusers.AsymmetricAutoencoderKL.forward.mask",description:"<strong>mask</strong> (<code>torch.FloatTensor</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014; Optional inpainting mask.",name:"mask"},{anchor:"diffusers.AsymmetricAutoencoderKL.forward.sample_posterior",description:`<strong>sample_posterior</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to sample from the posterior.`,name:"sample_posterior"},{anchor:"diffusers.AsymmetricAutoencoderKL.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>DecoderOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoder_asym_kl.py#L153"}}),J=new N({props:{title:"AutoencoderKLOutput",local:"diffusers.models.autoencoder_kl.AutoencoderKLOutput",headingTag:"h2"}}),D=new pe({props:{name:"class diffusers.models.autoencoder_kl.AutoencoderKLOutput",anchor:"diffusers.models.autoencoder_kl.AutoencoderKLOutput",parameters:[{name:"latent_dist",val:": DiagonalGaussianDistribution"}],parametersDescription:[{anchor:"diffusers.models.autoencoder_kl.AutoencoderKLOutput.latent_dist",description:`<strong>latent_dist</strong> (<code>DiagonalGaussianDistribution</code>) &#x2014;
Encoded outputs of <code>Encoder</code> represented as the mean and logvar of <code>DiagonalGaussianDistribution</code>.
<code>DiagonalGaussianDistribution</code> allows for sampling latents from the distribution.`,name:"latent_dist"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoder_kl.py#L36"}}),j=new N({props:{title:"DecoderOutput",local:"diffusers.models.vae.DecoderOutput",headingTag:"h2"}}),K=new pe({props:{name:"class diffusers.models.vae.DecoderOutput",anchor:"diffusers.models.vae.DecoderOutput",parameters:[{name:"sample",val:": FloatTensor"}],parametersDescription:[{anchor:"diffusers.models.vae.DecoderOutput.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
The decoded output sample from the last layer of the model.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/vae.py#L29"}}),{c(){h=i("meta"),Q=a(),V=i("p"),S=a(),c(w.$$.fragment),I=a(),k=i("p"),k.innerHTML=ve,H=a(),M=i("p"),M.textContent=we,q=a(),A=i("p"),A.innerHTML=ke,O=a(),$=i("p"),$.textContent=Me,P=a(),c(T.$$.fragment),ee=a(),x=i("ul"),x.innerHTML=Ae,te=a(),c(Z.$$.fragment),ne=a(),c(W.$$.fragment),oe=a(),c(L.$$.fragment),ae=a(),l=i("div"),c(U.$$.fragment),fe=a(),C=i("p"),C.innerHTML=$e,ge=a(),F=i("p"),F.innerHTML=Te,he=a(),R=i("div"),c(G.$$.fragment),se=a(),c(J.$$.fragment),ie=a(),_=i("div"),c(D.$$.fragment),_e=a(),B=i("p"),B.textContent=xe,re=a(),c(j.$$.fragment),le=a(),y=i("div"),c(K.$$.fragment),ye=a(),E=i("p"),E.textContent=Ze,ce=a(),Y=i("p"),this.h()},l(e){const t=je("svelte-u9bgzb",document.head);h=r(t,"META",{name:!0,content:!0}),t.forEach(n),Q=s(e),V=r(e,"P",{}),X(V).forEach(n),S=s(e),d(w.$$.fragment,e),I=s(e),k=r(e,"P",{"data-svelte-h":!0}),b(k)!=="svelte-8mpj0"&&(k.innerHTML=ve),H=s(e),M=r(e,"P",{"data-svelte-h":!0}),b(M)!=="svelte-1cwsb16"&&(M.textContent=we),q=s(e),A=r(e,"P",{"data-svelte-h":!0}),b(A)!=="svelte-ggnlwl"&&(A.innerHTML=ke),O=s(e),$=r(e,"P",{"data-svelte-h":!0}),b($)!=="svelte-1dzj46z"&&($.textContent=Me),P=s(e),d(T.$$.fragment,e),ee=s(e),x=r(e,"UL",{"data-svelte-h":!0}),b(x)!=="svelte-1m6ravg"&&(x.innerHTML=Ae),te=s(e),d(Z.$$.fragment,e),ne=s(e),d(W.$$.fragment,e),oe=s(e),d(L.$$.fragment,e),ae=s(e),l=r(e,"DIV",{class:!0});var v=X(l);d(U.$$.fragment,v),fe=s(v),C=r(v,"P",{"data-svelte-h":!0}),b(C)!=="svelte-4v08r1"&&(C.innerHTML=$e),ge=s(v),F=r(v,"P",{"data-svelte-h":!0}),b(F)!=="svelte-1hyu2ru"&&(F.innerHTML=Te),he=s(v),R=r(v,"DIV",{class:!0});var We=X(R);d(G.$$.fragment,We),We.forEach(n),v.forEach(n),se=s(e),d(J.$$.fragment,e),ie=s(e),_=r(e,"DIV",{class:!0});var me=X(_);d(D.$$.fragment,me),_e=s(me),B=r(me,"P",{"data-svelte-h":!0}),b(B)!=="svelte-1vsc7ag"&&(B.textContent=xe),me.forEach(n),re=s(e),d(j.$$.fragment,e),le=s(e),y=r(e,"DIV",{class:!0});var ue=X(y);d(K.$$.fragment,ue),ye=s(ue),E=r(ue,"P",{"data-svelte-h":!0}),b(E)!=="svelte-18u8upa"&&(E.textContent=Ze),ue.forEach(n),ce=s(e),Y=r(e,"P",{}),X(Y).forEach(n),this.h()},h(){z(h,"name","hf:doc:metadata"),z(h,"content",Re),z(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(l,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){m(document.head,h),o(e,Q,t),o(e,V,t),o(e,S,t),u(w,e,t),o(e,I,t),o(e,k,t),o(e,H,t),o(e,M,t),o(e,q,t),o(e,A,t),o(e,O,t),o(e,$,t),o(e,P,t),u(T,e,t),o(e,ee,t),o(e,x,t),o(e,te,t),u(Z,e,t),o(e,ne,t),u(W,e,t),o(e,oe,t),u(L,e,t),o(e,ae,t),o(e,l,t),u(U,l,null),m(l,fe),m(l,C),m(l,ge),m(l,F),m(l,he),m(l,R),u(G,R,null),o(e,se,t),u(J,e,t),o(e,ie,t),o(e,_,t),u(D,_,null),m(_,_e),m(_,B),o(e,re,t),u(j,e,t),o(e,le,t),o(e,y,t),u(K,y,null),m(y,ye),m(y,E),o(e,ce,t),o(e,Y,t),de=!0},p:Ue,i(e){de||(p(w.$$.fragment,e),p(T.$$.fragment,e),p(Z.$$.fragment,e),p(W.$$.fragment,e),p(L.$$.fragment,e),p(U.$$.fragment,e),p(G.$$.fragment,e),p(J.$$.fragment,e),p(D.$$.fragment,e),p(j.$$.fragment,e),p(K.$$.fragment,e),de=!0)},o(e){f(w.$$.fragment,e),f(T.$$.fragment,e),f(Z.$$.fragment,e),f(W.$$.fragment,e),f(L.$$.fragment,e),f(U.$$.fragment,e),f(G.$$.fragment,e),f(J.$$.fragment,e),f(D.$$.fragment,e),f(j.$$.fragment,e),f(K.$$.fragment,e),de=!1},d(e){e&&(n(Q),n(V),n(S),n(I),n(k),n(H),n(M),n(q),n(A),n(O),n($),n(P),n(ee),n(x),n(te),n(ne),n(oe),n(ae),n(l),n(se),n(ie),n(_),n(re),n(le),n(y),n(ce),n(Y)),n(h),g(w,e),g(T,e),g(Z,e),g(W,e),g(L,e),g(U),g(G),g(J,e),g(D),g(j,e),g(K)}}}const Re='{"title":"AsymmetricAutoencoderKL","local":"asymmetricautoencoderkl","sections":[{"title":"Available checkpoints","local":"available-checkpoints","sections":[],"depth":2},{"title":"Example Usage","local":"example-usage","sections":[],"depth":2},{"title":"AsymmetricAutoencoderKL","local":"diffusers.AsymmetricAutoencoderKL","sections":[],"depth":2},{"title":"AutoencoderKLOutput","local":"diffusers.models.autoencoder_kl.AutoencoderKLOutput","sections":[],"depth":2},{"title":"DecoderOutput","local":"diffusers.models.vae.DecoderOutput","sections":[],"depth":2}],"depth":1}';function Be(be){return Ge(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=Ke}),[]}class Ye extends Je{constructor(h){super(),De(this,h,Be,Fe,Le,{})}}export{Ye as component};
