import{s as Kn,o as ei,n as ti}from"../chunks/scheduler.182ea377.js";import{S as ni,i as ii,g as r,s as i,r as c,A as si,h as l,f as n,c as s,j as w,u as f,x as m,k as y,y as o,a,v as u,d as g,t as h,w as _}from"../chunks/index.1ea56653.js";import{H as M,g as ai}from"../chunks/Heading.71ac6e9f.js";import{T as oi}from"../chunks/Tip.67abc998.js";import{D as x}from"../chunks/Docstring.59aaf0cd.js";import{C as We}from"../chunks/CodeBlock.82c2494b.js";function ri(Ae){let b,k="There is currently an issue on PyTorch 1.X where the output images are all black or the pixel values become <code>NaNs</code>. This issue can be mitigated by switching to PyTorch 2.X.";return{c(){b=r("p"),b.innerHTML=k},l(v){b=l(v,"P",{"data-svelte-h":!0}),m(b)!=="svelte-1uoi7bt"&&(b.innerHTML=k)},m(v,Xe){a(v,b,Xe)},p:ti,d(v){v&&n(b)}}}function li(Ae){let b,k,v,Xe,E,qe,B,xn='The UniDiffuser model was proposed in <a href="https://huggingface.co/papers/2303.06555" rel="nofollow">One Transformer Fits All Distributions in Multi-Modal Diffusion at Scale</a> by Fan Bao, Shen Nie, Kaiwen Xue, Chongxuan Li, Shi Pu, Yaole Wang, Gang Yue, Yue Cao, Hang Su, Jun Zhu.',Oe,R,vn='The abstract from the <a href="https://arxiv.org/abs/2303.06555" rel="nofollow">paper</a> is:',Ke,F,Tn="<em>This paper proposes a unified diffusion framework (dubbed UniDiffuser) to fit all distributions relevant to a set of multi-modal data in one model. Our key insight is — learning diffusion models for marginal, conditional, and joint distributions can be unified as predicting the noise in the perturbed data, where the perturbation levels (i.e. timesteps) can be different for different modalities. Inspired by the unified view, UniDiffuser learns all distributions simultaneously with a minimal modification to the original diffusion model — perturbs data in all modalities instead of a single modality, inputs individual timesteps in different modalities, and predicts the noise of all modalities instead of a single modality. UniDiffuser is parameterized by a transformer for diffusion models to handle input types of different modalities. Implemented on large-scale paired image-text data, UniDiffuser is able to perform image, text, text-to-image, image-to-text, and image-text pair generation by setting proper timesteps without additional overhead. In particular, UniDiffuser is able to produce perceptually realistic samples in all tasks and its quantitative results (e.g., the FID and CLIP score) are not only superior to existing general-purpose models but also comparable to the bespoken models (e.g., Stable Diffusion and DALL-E 2) in representative tasks (e.g., text-to-image generation).</em>",et,L,Mn='You can find the original codebase at <a href="https://github.com/thu-ml/unidiffuser" rel="nofollow">thu-ml/unidiffuser</a> and additional checkpoints at <a href="https://huggingface.co/thu-ml" rel="nofollow">thu-ml</a>.',tt,U,nt,N,Un='This pipeline was contributed by <a href="https://github.com/dg845" rel="nofollow">dg845</a>. ❤️',it,Q,st,z,Zn="Because the UniDiffuser model is trained to model the joint distribution of (image, text) pairs, it is capable of performing a diverse range of generation tasks:",at,Y,ot,S,Jn='Unconditional generation (where we start from only latents sampled from a standard Gaussian prior) from a <a href="/docs/diffusers/main/en/api/pipelines/unidiffuser#diffusers.UniDiffuserPipeline">UniDiffuserPipeline</a> will produce a (image, text) pair:',rt,H,lt,A,$n="This is also called “joint” generation in the UniDiffusers paper, since we are sampling from the joint image-text distribution.",pt,q,In=`Note that the generation task is inferred from the inputs used when calling the pipeline.
It is also possible to manually specify the unconditional generation task (“mode”) manually with <a href="/docs/diffusers/main/en/api/pipelines/unidiffuser#diffusers.UniDiffuserPipeline.set_joint_mode">UniDiffuserPipeline.set_joint_mode()</a>:`,dt,O,mt,K,jn=`When the mode is set manually, subsequent calls to the pipeline will use the set mode without attempting the infer the mode.
You can reset the mode with <a href="/docs/diffusers/main/en/api/pipelines/unidiffuser#diffusers.UniDiffuserPipeline.reset_mode">UniDiffuserPipeline.reset_mode()</a>, after which the pipeline will once again infer the mode.`,ct,ee,Gn="You can also generate only an image or only text (which the UniDiffuser paper calls “marginal” generation since we sample from the marginal distribution of images and text, respectively):",ft,te,ut,ne,gt,ie,Wn=`UniDiffuser is also capable of sampling from conditional distributions; that is, the distribution of images conditioned on a text prompt or the distribution of texts conditioned on an image.
Here is an example of sampling from the conditional image distribution (text-to-image generation or text-conditioned image generation):`,ht,se,_t,ae,Xn='The <code>text2img</code> mode requires that either an input <code>prompt</code> or <code>prompt_embeds</code> be supplied. You can set the <code>text2img</code> mode manually with <a href="/docs/diffusers/main/en/api/pipelines/unidiffuser#diffusers.UniDiffuserPipeline.set_text_to_image_mode">UniDiffuserPipeline.set_text_to_image_mode()</a>.',bt,oe,wt,re,Pn="Similarly, UniDiffuser can also produce text samples given an image (image-to-text or image-conditioned text generation):",yt,le,xt,pe,Cn='The <code>img2text</code> mode requires that an input <code>image</code> be supplied. You can set the <code>img2text</code> mode manually with <a href="/docs/diffusers/main/en/api/pipelines/unidiffuser#diffusers.UniDiffuserPipeline.set_image_to_text_mode">UniDiffuserPipeline.set_image_to_text_mode()</a>.',vt,de,Tt,me,Vn=`The UniDiffuser authors suggest performing image variation through a “round-trip” generation method, where given an input image, we first perform an image-to-text generation, and the perform a text-to-image generation on the outputs of the first generation.
This produces a new image which is semantically similar to the input image:`,Mt,ce,Ut,fe,Zt,ue,Dn="Similarly, text variation can be performed on an input prompt with a text-to-image generation followed by a image-to-text generation:",Jt,ge,$t,he,It,p,_e,Yt,Pe,kn=`Pipeline for a bimodal image-text model which supports unconditional text and image generation, text-conditioned
image generation, image-conditioned text generation, and joint image-text generation.`,St,Ce,En=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Ht,Z,be,At,Ve,Bn="The call function to the pipeline for generation.",qt,J,we,Ot,De,Rn=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Kt,$,ye,en,ke,Fn=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,tn,I,xe,nn,Ee,Ln=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,sn,j,ve,an,Be,Nn=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,on,G,Te,rn,Re,Qn="Encodes the prompt into text encoder hidden states.",ln,W,Me,pn,Fe,zn="Removes a manually set mode; after calling this, the pipeline will infer the mode from inputs.",dn,X,Ue,mn,Le,Yn="Manually set the generation mode to unconditional (“marginal”) image generation.",cn,P,Ze,fn,Ne,Sn="Manually set the generation mode to image-conditioned text generation.",un,C,Je,gn,Qe,Hn="Manually set the generation mode to unconditional joint image-text generation.",hn,V,$e,_n,ze,An="Manually set the generation mode to unconditional (“marginal”) text generation.",bn,D,Ie,wn,Ye,qn="Manually set the generation mode to text-conditioned image generation.",jt,je,Gt,T,Ge,yn,Se,On="Output class for joint image-text pipelines.",Wt,He,Xt;return E=new M({props:{title:"UniDiffuser",local:"unidiffuser",headingTag:"h1"}}),U=new oi({props:{warning:!0,$$slots:{default:[ri]},$$scope:{ctx:Ae}}}),Q=new M({props:{title:"Usage Examples",local:"usage-examples",headingTag:"h2"}}),Y=new M({props:{title:"Unconditional Image and Text Generation",local:"unconditional-image-and-text-generation",headingTag:"h3"}}),H=new We({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVW5pRGlmZnVzZXJQaXBlbGluZSUwQSUwQWRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMEFtb2RlbF9pZF9vcl9wYXRoJTIwJTNEJTIwJTIydGh1LW1sJTJGdW5pZGlmZnVzZXItdjElMjIlMEFwaXBlJTIwJTNEJTIwVW5pRGlmZnVzZXJQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWRfb3JfcGF0aCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlLnRvKGRldmljZSklMEElMEElMjMlMjBVbmNvbmRpdGlvbmFsJTIwaW1hZ2UlMjBhbmQlMjB0ZXh0JTIwZ2VuZXJhdGlvbi4lMjBUaGUlMjBnZW5lcmF0aW9uJTIwdGFzayUyMGlzJTIwYXV0b21hdGljYWxseSUyMGluZmVycmVkLiUwQXNhbXBsZSUyMCUzRCUyMHBpcGUobnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q4LjApJTBBaW1hZ2UlMjAlM0QlMjBzYW1wbGUuaW1hZ2VzJTVCMCU1RCUwQXRleHQlMjAlM0QlMjBzYW1wbGUudGV4dCU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMnVuaWRpZmZ1c2VyX2pvaW50X3NhbXBsZV9pbWFnZS5wbmclMjIpJTBBcHJpbnQodGV4dCk=",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniDiffuserPipeline

device = <span class="hljs-string">&quot;cuda&quot;</span>
model_id_or_path = <span class="hljs-string">&quot;thu-ml/unidiffuser-v1&quot;</span>
pipe = UniDiffuserPipeline.from_pretrained(model_id_or_path, torch_dtype=torch.float16)
pipe.to(device)

<span class="hljs-comment"># Unconditional image and text generation. The generation task is automatically inferred.</span>
sample = pipe(num_inference_steps=<span class="hljs-number">20</span>, guidance_scale=<span class="hljs-number">8.0</span>)
image = sample.images[<span class="hljs-number">0</span>]
text = sample.text[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;unidiffuser_joint_sample_image.png&quot;</span>)
<span class="hljs-built_in">print</span>(text)`,wrap:!1}}),O=new We({props:{code:"JTIzJTIwRXF1aXZhbGVudCUyMHRvJTIwdGhlJTIwYWJvdmUuJTBBcGlwZS5zZXRfam9pbnRfbW9kZSgpJTBBc2FtcGxlJTIwJTNEJTIwcGlwZShudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjAlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDguMCk=",highlighted:`<span class="hljs-comment"># Equivalent to the above.</span>
pipe.set_joint_mode()
sample = pipe(num_inference_steps=<span class="hljs-number">20</span>, guidance_scale=<span class="hljs-number">8.0</span>)`,wrap:!1}}),te=new We({props:{code:"JTIzJTIwVW5saWtlJTIwb3RoZXIlMjBnZW5lcmF0aW9uJTIwdGFza3MlMkMlMjBpbWFnZS1vbmx5JTIwYW5kJTIwdGV4dC1vbmx5JTIwZ2VuZXJhdGlvbiUyMGRvbid0JTIwdXNlJTIwY2xhc3NpZmllci1mcmVlJTIwZ3VpZGFuY2UlMEElMjMlMjBJbWFnZS1vbmx5JTIwZ2VuZXJhdGlvbiUwQXBpcGUuc2V0X2ltYWdlX21vZGUoKSUwQXNhbXBsZV9pbWFnZSUyMCUzRCUyMHBpcGUobnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwKS5pbWFnZXMlNUIwJTVEJTBBJTIzJTIwVGV4dC1vbmx5JTIwZ2VuZXJhdGlvbiUwQXBpcGUuc2V0X3RleHRfbW9kZSgpJTBBc2FtcGxlX3RleHQlMjAlM0QlMjBwaXBlKG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyMCkudGV4dCU1QjAlNUQ=",highlighted:`<span class="hljs-comment"># Unlike other generation tasks, image-only and text-only generation don&#x27;t use classifier-free guidance</span>
<span class="hljs-comment"># Image-only generation</span>
pipe.set_image_mode()
sample_image = pipe(num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-comment"># Text-only generation</span>
pipe.set_text_mode()
sample_text = pipe(num_inference_steps=<span class="hljs-number">20</span>).text[<span class="hljs-number">0</span>]`,wrap:!1}}),ne=new M({props:{title:"Text-to-Image Generation",local:"text-to-image-generation",headingTag:"h3"}}),se=new We({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVW5pRGlmZnVzZXJQaXBlbGluZSUwQSUwQWRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMEFtb2RlbF9pZF9vcl9wYXRoJTIwJTNEJTIwJTIydGh1LW1sJTJGdW5pZGlmZnVzZXItdjElMjIlMEFwaXBlJTIwJTNEJTIwVW5pRGlmZnVzZXJQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWRfb3JfcGF0aCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlLnRvKGRldmljZSklMEElMEElMjMlMjBUZXh0LXRvLWltYWdlJTIwZ2VuZXJhdGlvbiUwQXByb21wdCUyMCUzRCUyMCUyMmFuJTIwZWxlcGhhbnQlMjB1bmRlciUyMHRoZSUyMHNlYSUyMiUwQSUwQXNhbXBsZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q4LjApJTBBdDJpX2ltYWdlJTIwJTNEJTIwc2FtcGxlLmltYWdlcyU1QjAlNUQlMEF0MmlfaW1hZ2Uuc2F2ZSglMjJ1bmlkaWZmdXNlcl90ZXh0MmltZ19zYW1wbGVfaW1hZ2UucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniDiffuserPipeline

device = <span class="hljs-string">&quot;cuda&quot;</span>
model_id_or_path = <span class="hljs-string">&quot;thu-ml/unidiffuser-v1&quot;</span>
pipe = UniDiffuserPipeline.from_pretrained(model_id_or_path, torch_dtype=torch.float16)
pipe.to(device)

<span class="hljs-comment"># Text-to-image generation</span>
prompt = <span class="hljs-string">&quot;an elephant under the sea&quot;</span>

sample = pipe(prompt=prompt, num_inference_steps=<span class="hljs-number">20</span>, guidance_scale=<span class="hljs-number">8.0</span>)
t2i_image = sample.images[<span class="hljs-number">0</span>]
t2i_image.save(<span class="hljs-string">&quot;unidiffuser_text2img_sample_image.png&quot;</span>)`,wrap:!1}}),oe=new M({props:{title:"Image-to-Text Generation",local:"image-to-text-generation",headingTag:"h3"}}),le=new We({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVW5pRGlmZnVzZXJQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsX2lkX29yX3BhdGglMjAlM0QlMjAlMjJ0aHUtbWwlMkZ1bmlkaWZmdXNlci12MSUyMiUwQXBpcGUlMjAlM0QlMjBVbmlEaWZmdXNlclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZF9vcl9wYXRoJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGUudG8oZGV2aWNlKSUwQSUwQSUyMyUyMEltYWdlLXRvLXRleHQlMjBnZW5lcmF0aW9uJTBBaW1hZ2VfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnVuaWRpZmZ1c2VyJTJGdW5pZGlmZnVzZXJfZXhhbXBsZV9pbWFnZS5qcGclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShpbWFnZV91cmwpLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEElMEFzYW1wbGUlMjAlM0QlMjBwaXBlKGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyMCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKSUwQWkydF90ZXh0JTIwJTNEJTIwc2FtcGxlLnRleHQlNUIwJTVEJTBBcHJpbnQoaTJ0X3RleHQp",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniDiffuserPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

device = <span class="hljs-string">&quot;cuda&quot;</span>
model_id_or_path = <span class="hljs-string">&quot;thu-ml/unidiffuser-v1&quot;</span>
pipe = UniDiffuserPipeline.from_pretrained(model_id_or_path, torch_dtype=torch.float16)
pipe.to(device)

<span class="hljs-comment"># Image-to-text generation</span>
image_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/unidiffuser/unidiffuser_example_image.jpg&quot;</span>
init_image = load_image(image_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

sample = pipe(image=init_image, num_inference_steps=<span class="hljs-number">20</span>, guidance_scale=<span class="hljs-number">8.0</span>)
i2t_text = sample.text[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(i2t_text)`,wrap:!1}}),de=new M({props:{title:"Image Variation",local:"image-variation",headingTag:"h3"}}),ce=new We({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVW5pRGlmZnVzZXJQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsX2lkX29yX3BhdGglMjAlM0QlMjAlMjJ0aHUtbWwlMkZ1bmlkaWZmdXNlci12MSUyMiUwQXBpcGUlMjAlM0QlMjBVbmlEaWZmdXNlclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZF9vcl9wYXRoJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGUudG8oZGV2aWNlKSUwQSUwQSUyMyUyMEltYWdlJTIwdmFyaWF0aW9uJTIwY2FuJTIwYmUlMjBwZXJmb3JtZWQlMjB3aXRoJTIwYSUyMGltYWdlLXRvLXRleHQlMjBnZW5lcmF0aW9uJTIwZm9sbG93ZWQlMjBieSUyMGElMjB0ZXh0LXRvLWltYWdlJTIwZ2VuZXJhdGlvbiUzQSUwQSUyMyUyMDEuJTIwSW1hZ2UtdG8tdGV4dCUyMGdlbmVyYXRpb24lMEFpbWFnZV91cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGdW5pZGlmZnVzZXIlMkZ1bmlkaWZmdXNlcl9leGFtcGxlX2ltYWdlLmpwZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKGltYWdlX3VybCkucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQSUwQXNhbXBsZSUyMCUzRCUyMHBpcGUoaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q4LjApJTBBaTJ0X3RleHQlMjAlM0QlMjBzYW1wbGUudGV4dCU1QjAlNUQlMEFwcmludChpMnRfdGV4dCklMEElMEElMjMlMjAyLiUyMFRleHQtdG8taW1hZ2UlMjBnZW5lcmF0aW9uJTBBc2FtcGxlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0RpMnRfdGV4dCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyMCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKSUwQWZpbmFsX2ltYWdlJTIwJTNEJTIwc2FtcGxlLmltYWdlcyU1QjAlNUQlMEFmaW5hbF9pbWFnZS5zYXZlKCUyMnVuaWRpZmZ1c2VyX2ltYWdlX3ZhcmlhdGlvbl9zYW1wbGUucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniDiffuserPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

device = <span class="hljs-string">&quot;cuda&quot;</span>
model_id_or_path = <span class="hljs-string">&quot;thu-ml/unidiffuser-v1&quot;</span>
pipe = UniDiffuserPipeline.from_pretrained(model_id_or_path, torch_dtype=torch.float16)
pipe.to(device)

<span class="hljs-comment"># Image variation can be performed with a image-to-text generation followed by a text-to-image generation:</span>
<span class="hljs-comment"># 1. Image-to-text generation</span>
image_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/unidiffuser/unidiffuser_example_image.jpg&quot;</span>
init_image = load_image(image_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

sample = pipe(image=init_image, num_inference_steps=<span class="hljs-number">20</span>, guidance_scale=<span class="hljs-number">8.0</span>)
i2t_text = sample.text[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(i2t_text)

<span class="hljs-comment"># 2. Text-to-image generation</span>
sample = pipe(prompt=i2t_text, num_inference_steps=<span class="hljs-number">20</span>, guidance_scale=<span class="hljs-number">8.0</span>)
final_image = sample.images[<span class="hljs-number">0</span>]
final_image.save(<span class="hljs-string">&quot;unidiffuser_image_variation_sample.png&quot;</span>)`,wrap:!1}}),fe=new M({props:{title:"Text Variation",local:"text-variation",headingTag:"h3"}}),ge=new We({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVW5pRGlmZnVzZXJQaXBlbGluZSUwQSUwQWRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMEFtb2RlbF9pZF9vcl9wYXRoJTIwJTNEJTIwJTIydGh1LW1sJTJGdW5pZGlmZnVzZXItdjElMjIlMEFwaXBlJTIwJTNEJTIwVW5pRGlmZnVzZXJQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWRfb3JfcGF0aCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlLnRvKGRldmljZSklMEElMEElMjMlMjBUZXh0JTIwdmFyaWF0aW9uJTIwY2FuJTIwYmUlMjBwZXJmb3JtZWQlMjB3aXRoJTIwYSUyMHRleHQtdG8taW1hZ2UlMjBnZW5lcmF0aW9uJTIwZm9sbG93ZWQlMjBieSUyMGElMjBpbWFnZS10by10ZXh0JTIwZ2VuZXJhdGlvbiUzQSUwQSUyMyUyMDEuJTIwVGV4dC10by1pbWFnZSUyMGdlbmVyYXRpb24lMEFwcm9tcHQlMjAlM0QlMjAlMjJhbiUyMGVsZXBoYW50JTIwdW5kZXIlMjB0aGUlMjBzZWElMjIlMEElMEFzYW1wbGUlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyMCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKSUwQXQyaV9pbWFnZSUyMCUzRCUyMHNhbXBsZS5pbWFnZXMlNUIwJTVEJTBBdDJpX2ltYWdlLnNhdmUoJTIydW5pZGlmZnVzZXJfdGV4dDJpbWdfc2FtcGxlX2ltYWdlLnBuZyUyMiklMEElMEElMjMlMjAyLiUyMEltYWdlLXRvLXRleHQlMjBnZW5lcmF0aW9uJTBBc2FtcGxlJTIwJTNEJTIwcGlwZShpbWFnZSUzRHQyaV9pbWFnZSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyMCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKSUwQWZpbmFsX3Byb21wdCUyMCUzRCUyMHNhbXBsZS50ZXh0JTVCMCU1RCUwQXByaW50KGZpbmFsX3Byb21wdCk=",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniDiffuserPipeline

device = <span class="hljs-string">&quot;cuda&quot;</span>
model_id_or_path = <span class="hljs-string">&quot;thu-ml/unidiffuser-v1&quot;</span>
pipe = UniDiffuserPipeline.from_pretrained(model_id_or_path, torch_dtype=torch.float16)
pipe.to(device)

<span class="hljs-comment"># Text variation can be performed with a text-to-image generation followed by a image-to-text generation:</span>
<span class="hljs-comment"># 1. Text-to-image generation</span>
prompt = <span class="hljs-string">&quot;an elephant under the sea&quot;</span>

sample = pipe(prompt=prompt, num_inference_steps=<span class="hljs-number">20</span>, guidance_scale=<span class="hljs-number">8.0</span>)
t2i_image = sample.images[<span class="hljs-number">0</span>]
t2i_image.save(<span class="hljs-string">&quot;unidiffuser_text2img_sample_image.png&quot;</span>)

<span class="hljs-comment"># 2. Image-to-text generation</span>
sample = pipe(image=t2i_image, num_inference_steps=<span class="hljs-number">20</span>, guidance_scale=<span class="hljs-number">8.0</span>)
final_prompt = sample.text[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(final_prompt)`,wrap:!1}}),he=new M({props:{title:"UniDiffuserPipeline",local:"diffusers.UniDiffuserPipeline",headingTag:"h2"}}),_e=new x({props:{name:"class diffusers.UniDiffuserPipeline",anchor:"diffusers.UniDiffuserPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"clip_image_processor",val:": CLIPImageProcessor"},{name:"clip_tokenizer",val:": CLIPTokenizer"},{name:"text_decoder",val:": UniDiffuserTextDecoder"},{name:"text_tokenizer",val:": GPT2Tokenizer"},{name:"unet",val:": UniDiffuserModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"}],parametersDescription:[{anchor:"diffusers.UniDiffuserPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations. This
is part of the UniDiffuser image representation along with the CLIP vision encoding.`,name:"vae"},{anchor:"diffusers.UniDiffuserPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.UniDiffuserPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>CLIPVisionModel</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPVisionModel" rel="nofollow">CLIPVisionModel</a> to encode images as part of its image representation along with the VAE
latent representation.`,name:"image_encoder"},{anchor:"diffusers.UniDiffuserPipeline.image_processor",description:`<strong>image_processor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a> to preprocess an image before CLIP encoding it with <code>image_encoder</code>.`,name:"image_processor"},{anchor:"diffusers.UniDiffuserPipeline.clip_tokenizer",description:`<strong>clip_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize the prompt before encoding it with <code>text_encoder</code>.`,name:"clip_tokenizer"},{anchor:"diffusers.UniDiffuserPipeline.text_decoder",description:`<strong>text_decoder</strong> (<code>UniDiffuserTextDecoder</code>) &#x2014;
Frozen text decoder. This is a GPT-style model which is used to generate text from the UniDiffuser
embedding.`,name:"text_decoder"},{anchor:"diffusers.UniDiffuserPipeline.text_tokenizer",description:`<strong>text_tokenizer</strong> (<code>GPT2Tokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2Tokenizer" rel="nofollow">GPT2Tokenizer</a> to decode text for text generation; used along with the <code>text_decoder</code>.`,name:"text_tokenizer"},{anchor:"diffusers.UniDiffuserPipeline.unet",description:`<strong>unet</strong> (<code>UniDiffuserModel</code>) &#x2014;
A <a href="https://github.com/baofff/U-ViT" rel="nofollow">U-ViT</a> model with UNNet-style skip connections between transformer
layers to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.UniDiffuserPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image and/or text latents. The
original UniDiffuser paper uses the <a href="/docs/diffusers/main/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a> scheduler.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L51"}}),be=new x({props:{name:"__call__",anchor:"diffusers.UniDiffuserPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[torch.FloatTensor, PIL.Image.Image, NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"data_type",val:": typing.Optional[int] = 1"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 8.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"num_prompts_per_image",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"vae_latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"clip_latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"}],parametersDescription:[{anchor:"diffusers.UniDiffuserPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.
Required for text-conditioned image generation (<code>text2img</code>) mode.`,name:"prompt"},{anchor:"diffusers.UniDiffuserPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code> or <code>PIL.Image.Image</code>, <em>optional</em>) &#x2014;
<code>Image</code> or tensor representing an image batch. Required for image-conditioned text generation
(<code>img2text</code>) mode.`,name:"image"},{anchor:"diffusers.UniDiffuserPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.UniDiffuserPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.UniDiffuserPipeline.__call__.data_type",description:`<strong>data_type</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The data type (either 0 or 1). Only used if you are loading a checkpoint which supports a data type
embedding; this is added for compatibility with the
<a href="https://huggingface.co/thu-ml/unidiffuser-v1" rel="nofollow">UniDiffuser-v1</a> checkpoint.`,name:"data_type"},{anchor:"diffusers.UniDiffuserPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.UniDiffuserPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 8.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.UniDiffuserPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>). Used in
text-conditioned image generation (<code>text2img</code>) mode.`,name:"negative_prompt"},{anchor:"diffusers.UniDiffuserPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt. Used in <code>text2img</code> (text-conditioned image generation) and
<code>img</code> mode. If the mode is joint and both <code>num_images_per_prompt</code> and <code>num_prompts_per_image</code> are
supplied, <code>min(num_images_per_prompt, num_prompts_per_image)</code> samples are generated.`,name:"num_images_per_prompt"},{anchor:"diffusers.UniDiffuserPipeline.__call__.num_prompts_per_image",description:`<strong>num_prompts_per_image</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of prompts to generate per image. Used in <code>img2text</code> (image-conditioned text generation) and
<code>text</code> mode. If the mode is joint and both <code>num_images_per_prompt</code> and <code>num_prompts_per_image</code> are
supplied, <code>min(num_images_per_prompt, num_prompts_per_image)</code> samples are generated.`,name:"num_prompts_per_image"},{anchor:"diffusers.UniDiffuserPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.UniDiffuserPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.UniDiffuserPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for joint
image-text generation. Can be used to tweak the same generation with different prompts. If not
provided, a latents tensor is generated by sampling using the supplied random <code>generator</code>. This assumes
a full set of VAE, CLIP, and text latents, if supplied, overrides the value of <code>prompt_latents</code>,
<code>vae_latents</code>, and <code>clip_latents</code>.`,name:"latents"},{anchor:"diffusers.UniDiffuserPipeline.__call__.prompt_latents",description:`<strong>prompt_latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for text
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"prompt_latents"},{anchor:"diffusers.UniDiffuserPipeline.__call__.vae_latents",description:`<strong>vae_latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"vae_latents"},{anchor:"diffusers.UniDiffuserPipeline.__call__.clip_latents",description:`<strong>clip_latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"clip_latents"},{anchor:"diffusers.UniDiffuserPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument. Used in text-conditioned
image generation (<code>text2img</code>) mode.`,name:"prompt_embeds"},{anchor:"diffusers.UniDiffuserPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are be generated from the <code>negative_prompt</code> input argument. Used
in text-conditioned image generation (<code>text2img</code>) mode.`,name:"negative_prompt_embeds"},{anchor:"diffusers.UniDiffuserPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.UniDiffuserPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/unidiffuser#diffusers.ImageTextPipelineOutput">ImageTextPipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.UniDiffuserPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.UniDiffuserPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L1079",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/unidiffuser#diffusers.ImageTextPipelineOutput"
>ImageTextPipelineOutput</a> is returned, otherwise a
<code>tuple</code> is returned where the first element is a list with the generated images and the second element
is a list of generated texts.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/unidiffuser#diffusers.ImageTextPipelineOutput"
>ImageTextPipelineOutput</a> or <code>tuple</code></p>
`}}),we=new x({props:{name:"disable_vae_slicing",anchor:"diffusers.UniDiffuserPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L147"}}),ye=new x({props:{name:"disable_vae_tiling",anchor:"diffusers.UniDiffuserPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L164"}}),xe=new x({props:{name:"enable_vae_slicing",anchor:"diffusers.UniDiffuserPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L139"}}),ve=new x({props:{name:"enable_vae_tiling",anchor:"diffusers.UniDiffuserPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L155"}}),Te=new x({props:{name:"encode_prompt",anchor:"diffusers.UniDiffuserPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.UniDiffuserPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.UniDiffuserPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.UniDiffuserPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.UniDiffuserPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.UniDiffuserPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.UniDiffuserPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.UniDiffuserPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.UniDiffuserPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L382"}}),Me=new x({props:{name:"reset_mode",anchor:"diffusers.UniDiffuserPipeline.reset_mode",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L268"}}),Ue=new x({props:{name:"set_image_mode",anchor:"diffusers.UniDiffuserPipeline.set_image_mode",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L252"}}),Ze=new x({props:{name:"set_image_to_text_mode",anchor:"diffusers.UniDiffuserPipeline.set_image_to_text_mode",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L260"}}),Je=new x({props:{name:"set_joint_mode",anchor:"diffusers.UniDiffuserPipeline.set_joint_mode",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L264"}}),$e=new x({props:{name:"set_text_mode",anchor:"diffusers.UniDiffuserPipeline.set_text_mode",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L248"}}),Ie=new x({props:{name:"set_text_to_image_mode",anchor:"diffusers.UniDiffuserPipeline.set_text_to_image_mode",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L256"}}),je=new M({props:{title:"ImageTextPipelineOutput",local:"diffusers.ImageTextPipelineOutput",headingTag:"h2"}}),Ge=new x({props:{name:"class diffusers.ImageTextPipelineOutput",anchor:"diffusers.ImageTextPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray, NoneType]"},{name:"text",val:": typing.Union[typing.List[str], typing.List[typing.List[str]], NoneType]"}],parametersDescription:[{anchor:"diffusers.ImageTextPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.ImageTextPipelineOutput.text",description:`<strong>text</strong> (<code>List[str]</code> or <code>List[List[str]]</code>) &#x2014;
List of generated text strings of length <code>batch_size</code> or a list of list of strings whose outer list has
length <code>batch_size</code>.`,name:"text"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L34"}}),{c(){b=r("meta"),k=i(),v=r("p"),Xe=i(),c(E.$$.fragment),qe=i(),B=r("p"),B.innerHTML=xn,Oe=i(),R=r("p"),R.innerHTML=vn,Ke=i(),F=r("p"),F.innerHTML=Tn,et=i(),L=r("p"),L.innerHTML=Mn,tt=i(),c(U.$$.fragment),nt=i(),N=r("p"),N.innerHTML=Un,it=i(),c(Q.$$.fragment),st=i(),z=r("p"),z.textContent=Zn,at=i(),c(Y.$$.fragment),ot=i(),S=r("p"),S.innerHTML=Jn,rt=i(),c(H.$$.fragment),lt=i(),A=r("p"),A.textContent=$n,pt=i(),q=r("p"),q.innerHTML=In,dt=i(),c(O.$$.fragment),mt=i(),K=r("p"),K.innerHTML=jn,ct=i(),ee=r("p"),ee.textContent=Gn,ft=i(),c(te.$$.fragment),ut=i(),c(ne.$$.fragment),gt=i(),ie=r("p"),ie.textContent=Wn,ht=i(),c(se.$$.fragment),_t=i(),ae=r("p"),ae.innerHTML=Xn,bt=i(),c(oe.$$.fragment),wt=i(),re=r("p"),re.textContent=Pn,yt=i(),c(le.$$.fragment),xt=i(),pe=r("p"),pe.innerHTML=Cn,vt=i(),c(de.$$.fragment),Tt=i(),me=r("p"),me.textContent=Vn,Mt=i(),c(ce.$$.fragment),Ut=i(),c(fe.$$.fragment),Zt=i(),ue=r("p"),ue.textContent=Dn,Jt=i(),c(ge.$$.fragment),$t=i(),c(he.$$.fragment),It=i(),p=r("div"),c(_e.$$.fragment),Yt=i(),Pe=r("p"),Pe.textContent=kn,St=i(),Ce=r("p"),Ce.innerHTML=En,Ht=i(),Z=r("div"),c(be.$$.fragment),At=i(),Ve=r("p"),Ve.textContent=Bn,qt=i(),J=r("div"),c(we.$$.fragment),Ot=i(),De=r("p"),De.innerHTML=Rn,Kt=i(),$=r("div"),c(ye.$$.fragment),en=i(),ke=r("p"),ke.innerHTML=Fn,tn=i(),I=r("div"),c(xe.$$.fragment),nn=i(),Ee=r("p"),Ee.textContent=Ln,sn=i(),j=r("div"),c(ve.$$.fragment),an=i(),Be=r("p"),Be.textContent=Nn,on=i(),G=r("div"),c(Te.$$.fragment),rn=i(),Re=r("p"),Re.textContent=Qn,ln=i(),W=r("div"),c(Me.$$.fragment),pn=i(),Fe=r("p"),Fe.textContent=zn,dn=i(),X=r("div"),c(Ue.$$.fragment),mn=i(),Le=r("p"),Le.textContent=Yn,cn=i(),P=r("div"),c(Ze.$$.fragment),fn=i(),Ne=r("p"),Ne.textContent=Sn,un=i(),C=r("div"),c(Je.$$.fragment),gn=i(),Qe=r("p"),Qe.textContent=Hn,hn=i(),V=r("div"),c($e.$$.fragment),_n=i(),ze=r("p"),ze.textContent=An,bn=i(),D=r("div"),c(Ie.$$.fragment),wn=i(),Ye=r("p"),Ye.textContent=qn,jt=i(),c(je.$$.fragment),Gt=i(),T=r("div"),c(Ge.$$.fragment),yn=i(),Se=r("p"),Se.textContent=On,Wt=i(),He=r("p"),this.h()},l(e){const t=si("svelte-u9bgzb",document.head);b=l(t,"META",{name:!0,content:!0}),t.forEach(n),k=s(e),v=l(e,"P",{}),w(v).forEach(n),Xe=s(e),f(E.$$.fragment,e),qe=s(e),B=l(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-x4qgym"&&(B.innerHTML=xn),Oe=s(e),R=l(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-194mq73"&&(R.innerHTML=vn),Ke=s(e),F=l(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1rrofj2"&&(F.innerHTML=Tn),et=s(e),L=l(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-1mkhqav"&&(L.innerHTML=Mn),tt=s(e),f(U.$$.fragment,e),nt=s(e),N=l(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1eykv1b"&&(N.innerHTML=Un),it=s(e),f(Q.$$.fragment,e),st=s(e),z=l(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-cbm0c5"&&(z.textContent=Zn),at=s(e),f(Y.$$.fragment,e),ot=s(e),S=l(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-c6xivp"&&(S.innerHTML=Jn),rt=s(e),f(H.$$.fragment,e),lt=s(e),A=l(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1psmhxx"&&(A.textContent=$n),pt=s(e),q=l(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-uomou7"&&(q.innerHTML=In),dt=s(e),f(O.$$.fragment,e),mt=s(e),K=l(e,"P",{"data-svelte-h":!0}),m(K)!=="svelte-1ui0ron"&&(K.innerHTML=jn),ct=s(e),ee=l(e,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-1y647uj"&&(ee.textContent=Gn),ft=s(e),f(te.$$.fragment,e),ut=s(e),f(ne.$$.fragment,e),gt=s(e),ie=l(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-euu6tg"&&(ie.textContent=Wn),ht=s(e),f(se.$$.fragment,e),_t=s(e),ae=l(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-19zjjlo"&&(ae.innerHTML=Xn),bt=s(e),f(oe.$$.fragment,e),wt=s(e),re=l(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-tubb14"&&(re.textContent=Pn),yt=s(e),f(le.$$.fragment,e),xt=s(e),pe=l(e,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-1sf5a0r"&&(pe.innerHTML=Cn),vt=s(e),f(de.$$.fragment,e),Tt=s(e),me=l(e,"P",{"data-svelte-h":!0}),m(me)!=="svelte-13n7p28"&&(me.textContent=Vn),Mt=s(e),f(ce.$$.fragment,e),Ut=s(e),f(fe.$$.fragment,e),Zt=s(e),ue=l(e,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-1t6lzo0"&&(ue.textContent=Dn),Jt=s(e),f(ge.$$.fragment,e),$t=s(e),f(he.$$.fragment,e),It=s(e),p=l(e,"DIV",{class:!0});var d=w(p);f(_e.$$.fragment,d),Yt=s(d),Pe=l(d,"P",{"data-svelte-h":!0}),m(Pe)!=="svelte-qg5tdp"&&(Pe.textContent=kn),St=s(d),Ce=l(d,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-496sm0"&&(Ce.innerHTML=En),Ht=s(d),Z=l(d,"DIV",{class:!0});var Pt=w(Z);f(be.$$.fragment,Pt),At=s(Pt),Ve=l(Pt,"P",{"data-svelte-h":!0}),m(Ve)!=="svelte-50j04k"&&(Ve.textContent=Bn),Pt.forEach(n),qt=s(d),J=l(d,"DIV",{class:!0});var Ct=w(J);f(we.$$.fragment,Ct),Ot=s(Ct),De=l(Ct,"P",{"data-svelte-h":!0}),m(De)!=="svelte-1s3c06i"&&(De.innerHTML=Rn),Ct.forEach(n),Kt=s(d),$=l(d,"DIV",{class:!0});var Vt=w($);f(ye.$$.fragment,Vt),en=s(Vt),ke=l(Vt,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-pkn4ui"&&(ke.innerHTML=Fn),Vt.forEach(n),tn=s(d),I=l(d,"DIV",{class:!0});var Dt=w(I);f(xe.$$.fragment,Dt),nn=s(Dt),Ee=l(Dt,"P",{"data-svelte-h":!0}),m(Ee)!=="svelte-14bnrb6"&&(Ee.textContent=Ln),Dt.forEach(n),sn=s(d),j=l(d,"DIV",{class:!0});var kt=w(j);f(ve.$$.fragment,kt),an=s(kt),Be=l(kt,"P",{"data-svelte-h":!0}),m(Be)!=="svelte-1xwrf7t"&&(Be.textContent=Nn),kt.forEach(n),on=s(d),G=l(d,"DIV",{class:!0});var Et=w(G);f(Te.$$.fragment,Et),rn=s(Et),Re=l(Et,"P",{"data-svelte-h":!0}),m(Re)!=="svelte-16q0ax1"&&(Re.textContent=Qn),Et.forEach(n),ln=s(d),W=l(d,"DIV",{class:!0});var Bt=w(W);f(Me.$$.fragment,Bt),pn=s(Bt),Fe=l(Bt,"P",{"data-svelte-h":!0}),m(Fe)!=="svelte-ycux85"&&(Fe.textContent=zn),Bt.forEach(n),dn=s(d),X=l(d,"DIV",{class:!0});var Rt=w(X);f(Ue.$$.fragment,Rt),mn=s(Rt),Le=l(Rt,"P",{"data-svelte-h":!0}),m(Le)!=="svelte-f12s4l"&&(Le.textContent=Yn),Rt.forEach(n),cn=s(d),P=l(d,"DIV",{class:!0});var Ft=w(P);f(Ze.$$.fragment,Ft),fn=s(Ft),Ne=l(Ft,"P",{"data-svelte-h":!0}),m(Ne)!=="svelte-1b9y8l5"&&(Ne.textContent=Sn),Ft.forEach(n),un=s(d),C=l(d,"DIV",{class:!0});var Lt=w(C);f(Je.$$.fragment,Lt),gn=s(Lt),Qe=l(Lt,"P",{"data-svelte-h":!0}),m(Qe)!=="svelte-u7njpc"&&(Qe.textContent=Hn),Lt.forEach(n),hn=s(d),V=l(d,"DIV",{class:!0});var Nt=w(V);f($e.$$.fragment,Nt),_n=s(Nt),ze=l(Nt,"P",{"data-svelte-h":!0}),m(ze)!=="svelte-p08nnp"&&(ze.textContent=An),Nt.forEach(n),bn=s(d),D=l(d,"DIV",{class:!0});var Qt=w(D);f(Ie.$$.fragment,Qt),wn=s(Qt),Ye=l(Qt,"P",{"data-svelte-h":!0}),m(Ye)!=="svelte-rah46x"&&(Ye.textContent=qn),Qt.forEach(n),d.forEach(n),jt=s(e),f(je.$$.fragment,e),Gt=s(e),T=l(e,"DIV",{class:!0});var zt=w(T);f(Ge.$$.fragment,zt),yn=s(zt),Se=l(zt,"P",{"data-svelte-h":!0}),m(Se)!=="svelte-1i2ycus"&&(Se.textContent=On),zt.forEach(n),Wt=s(e),He=l(e,"P",{}),w(He).forEach(n),this.h()},h(){y(b,"name","hf:doc:metadata"),y(b,"content",pi),y(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){o(document.head,b),a(e,k,t),a(e,v,t),a(e,Xe,t),u(E,e,t),a(e,qe,t),a(e,B,t),a(e,Oe,t),a(e,R,t),a(e,Ke,t),a(e,F,t),a(e,et,t),a(e,L,t),a(e,tt,t),u(U,e,t),a(e,nt,t),a(e,N,t),a(e,it,t),u(Q,e,t),a(e,st,t),a(e,z,t),a(e,at,t),u(Y,e,t),a(e,ot,t),a(e,S,t),a(e,rt,t),u(H,e,t),a(e,lt,t),a(e,A,t),a(e,pt,t),a(e,q,t),a(e,dt,t),u(O,e,t),a(e,mt,t),a(e,K,t),a(e,ct,t),a(e,ee,t),a(e,ft,t),u(te,e,t),a(e,ut,t),u(ne,e,t),a(e,gt,t),a(e,ie,t),a(e,ht,t),u(se,e,t),a(e,_t,t),a(e,ae,t),a(e,bt,t),u(oe,e,t),a(e,wt,t),a(e,re,t),a(e,yt,t),u(le,e,t),a(e,xt,t),a(e,pe,t),a(e,vt,t),u(de,e,t),a(e,Tt,t),a(e,me,t),a(e,Mt,t),u(ce,e,t),a(e,Ut,t),u(fe,e,t),a(e,Zt,t),a(e,ue,t),a(e,Jt,t),u(ge,e,t),a(e,$t,t),u(he,e,t),a(e,It,t),a(e,p,t),u(_e,p,null),o(p,Yt),o(p,Pe),o(p,St),o(p,Ce),o(p,Ht),o(p,Z),u(be,Z,null),o(Z,At),o(Z,Ve),o(p,qt),o(p,J),u(we,J,null),o(J,Ot),o(J,De),o(p,Kt),o(p,$),u(ye,$,null),o($,en),o($,ke),o(p,tn),o(p,I),u(xe,I,null),o(I,nn),o(I,Ee),o(p,sn),o(p,j),u(ve,j,null),o(j,an),o(j,Be),o(p,on),o(p,G),u(Te,G,null),o(G,rn),o(G,Re),o(p,ln),o(p,W),u(Me,W,null),o(W,pn),o(W,Fe),o(p,dn),o(p,X),u(Ue,X,null),o(X,mn),o(X,Le),o(p,cn),o(p,P),u(Ze,P,null),o(P,fn),o(P,Ne),o(p,un),o(p,C),u(Je,C,null),o(C,gn),o(C,Qe),o(p,hn),o(p,V),u($e,V,null),o(V,_n),o(V,ze),o(p,bn),o(p,D),u(Ie,D,null),o(D,wn),o(D,Ye),a(e,jt,t),u(je,e,t),a(e,Gt,t),a(e,T,t),u(Ge,T,null),o(T,yn),o(T,Se),a(e,Wt,t),a(e,He,t),Xt=!0},p(e,[t]){const d={};t&2&&(d.$$scope={dirty:t,ctx:e}),U.$set(d)},i(e){Xt||(g(E.$$.fragment,e),g(U.$$.fragment,e),g(Q.$$.fragment,e),g(Y.$$.fragment,e),g(H.$$.fragment,e),g(O.$$.fragment,e),g(te.$$.fragment,e),g(ne.$$.fragment,e),g(se.$$.fragment,e),g(oe.$$.fragment,e),g(le.$$.fragment,e),g(de.$$.fragment,e),g(ce.$$.fragment,e),g(fe.$$.fragment,e),g(ge.$$.fragment,e),g(he.$$.fragment,e),g(_e.$$.fragment,e),g(be.$$.fragment,e),g(we.$$.fragment,e),g(ye.$$.fragment,e),g(xe.$$.fragment,e),g(ve.$$.fragment,e),g(Te.$$.fragment,e),g(Me.$$.fragment,e),g(Ue.$$.fragment,e),g(Ze.$$.fragment,e),g(Je.$$.fragment,e),g($e.$$.fragment,e),g(Ie.$$.fragment,e),g(je.$$.fragment,e),g(Ge.$$.fragment,e),Xt=!0)},o(e){h(E.$$.fragment,e),h(U.$$.fragment,e),h(Q.$$.fragment,e),h(Y.$$.fragment,e),h(H.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),h(se.$$.fragment,e),h(oe.$$.fragment,e),h(le.$$.fragment,e),h(de.$$.fragment,e),h(ce.$$.fragment,e),h(fe.$$.fragment,e),h(ge.$$.fragment,e),h(he.$$.fragment,e),h(_e.$$.fragment,e),h(be.$$.fragment,e),h(we.$$.fragment,e),h(ye.$$.fragment,e),h(xe.$$.fragment,e),h(ve.$$.fragment,e),h(Te.$$.fragment,e),h(Me.$$.fragment,e),h(Ue.$$.fragment,e),h(Ze.$$.fragment,e),h(Je.$$.fragment,e),h($e.$$.fragment,e),h(Ie.$$.fragment,e),h(je.$$.fragment,e),h(Ge.$$.fragment,e),Xt=!1},d(e){e&&(n(k),n(v),n(Xe),n(qe),n(B),n(Oe),n(R),n(Ke),n(F),n(et),n(L),n(tt),n(nt),n(N),n(it),n(st),n(z),n(at),n(ot),n(S),n(rt),n(lt),n(A),n(pt),n(q),n(dt),n(mt),n(K),n(ct),n(ee),n(ft),n(ut),n(gt),n(ie),n(ht),n(_t),n(ae),n(bt),n(wt),n(re),n(yt),n(xt),n(pe),n(vt),n(Tt),n(me),n(Mt),n(Ut),n(Zt),n(ue),n(Jt),n($t),n(It),n(p),n(jt),n(Gt),n(T),n(Wt),n(He)),n(b),_(E,e),_(U,e),_(Q,e),_(Y,e),_(H,e),_(O,e),_(te,e),_(ne,e),_(se,e),_(oe,e),_(le,e),_(de,e),_(ce,e),_(fe,e),_(ge,e),_(he,e),_(_e),_(be),_(we),_(ye),_(xe),_(ve),_(Te),_(Me),_(Ue),_(Ze),_(Je),_($e),_(Ie),_(je,e),_(Ge)}}}const pi='{"title":"UniDiffuser","local":"unidiffuser","sections":[{"title":"Usage Examples","local":"usage-examples","sections":[{"title":"Unconditional Image and Text Generation","local":"unconditional-image-and-text-generation","sections":[],"depth":3},{"title":"Text-to-Image Generation","local":"text-to-image-generation","sections":[],"depth":3},{"title":"Image-to-Text Generation","local":"image-to-text-generation","sections":[],"depth":3},{"title":"Image Variation","local":"image-variation","sections":[],"depth":3},{"title":"Text Variation","local":"text-variation","sections":[],"depth":3}],"depth":2},{"title":"UniDiffuserPipeline","local":"diffusers.UniDiffuserPipeline","sections":[],"depth":2},{"title":"ImageTextPipelineOutput","local":"diffusers.ImageTextPipelineOutput","sections":[],"depth":2}],"depth":1}';function di(Ae){return ei(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=ai}),[]}class _i extends ni{constructor(b){super(),ii(this,b,di,li,Kn,{})}}export{_i as component};
