import{s as xe,n as Ee,o as $e}from"../chunks/scheduler.182ea377.js";import{S as Fe,i as ze,g as i,s as a,r as m,A as Ae,h as o,f as l,c as n,j as Se,u as c,x as p,k as He,y as qe,a as s,v as M,d as r,t as u,w as d}from"../chunks/index.1ea56653.js";import{H as x,g as De}from"../chunks/Heading.71ac6e9f.js";import{C as we}from"../chunks/CodeBlock.82c2494b.js";function Pe(Te){let h,F,E,z,y,A,f,Ze="Latent Consistency Models (LCM) enable quality image generation in typically 2-4 steps making it possible to use diffusion models in almost real-time settings.",q,J,je='From the <a href="https://latent-consistency-models.github.io/" rel="nofollow">official website</a>:',D,g,Ce="<p>LCMs can be distilled from any pre-trained Stable Diffusion (SD) in only 4,000 training steps (~32 A100 GPU Hours) for generating high quality 768 x 768 resolution images in 2~4 steps or even one step, significantly accelerating text-to-image generation. We employ LCM to distill the Dreamshaper-V7 version of SD in just 4,000 training iterations.</p>",P,b,Ge='For a more technical overview of LCMs, refer to <a href="https://huggingface.co/papers/2310.04378" rel="nofollow">the paper</a>.',K,U,We="This guide shows how to perform inference with LCMs for text-to-image and image-to-image generation tasks. It will also cover performing inference with LoRA checkpoints.",O,w,ee,T,Be='You’ll use the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a> here changing the <code>unet</code>. The UNet was distilled from the SDXL UNet using the framework introduced in LCM. Another important component is the scheduler: <a href="/docs/diffusers/main/en/api/schedulers/lcm#diffusers.LCMScheduler">LCMScheduler</a>. Together with the distilled UNet and the scheduler, LCM enables a fast inference workflow overcoming the slow iterative nature of diffusion models.',te,Z,le,j,ve='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm/lcm_intro.png"/>',se,C,Ie="Notice that we use only 4 steps for generation which is way less than what’s typically used for standard SDXL.",ae,G,Re="Some details to keep in mind:",ne,W,Qe="<li>To perform classifier-free guidance, batch size is usually doubled inside the pipeline. LCM, however, applies guidance using guidance embeddings, so the batch size does not have to be doubled in this case. This leads to a faster inference time, with the drawback that negative prompts don’t have any effect on the denoising process.</li> <li>The UNet was trained using the [3., 13.] guidance scale range. So, that is the ideal range for <code>guidance_scale</code>. However, disabling <code>guidance_scale</code> using a value of 1.0 is also effective in most cases.</li>",ie,B,oe,v,Ne="The findings above apply to image-to-image tasks too. Let’s look at how we can perform image-to-image generation with LCMs:",pe,I,me,R,ke='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm/lcm_i2i.png"/>',ce,Q,Me,N,Xe='It is possible to generalize the LCM framework to use with <a href="../training/lora.md">LoRA</a>. It effectively eliminates the need to conduct expensive fine-tuning runs as LoRA training concerns just a few number of parameters compared to full fine-tuning. During inference, the <a href="/docs/diffusers/main/en/api/schedulers/lcm#diffusers.LCMScheduler">LCMScheduler</a> comes to the advantage as it enables very few-steps inference without compromising the quality.',re,k,Le=`We recommend to disable <code>guidance_scale</code> by setting it 0. The model is trained to follow prompts accurately
even without using guidance scale. You can however, still use guidance scale in which case we recommend
using values between 1.0 and 2.0.`,ue,X,de,L,he,Y,Ye='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm/lora_lcm.png"/>',ye,_,fe,V,_e="Extending LCM LoRA to image-to-image is possible:",Je,S,ge,H,Ve='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm/lcm_lora_i2i.png"/>',be,$,Ue;return y=new x({props:{title:"Performing inference with LCM",local:"performing-inference-with-lcm",headingTag:"h1"}}),w=new x({props:{title:"Text-to-image",local:"text-to-image",headingTag:"h2"}}),Z=new we({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTJDJTIwVU5ldDJEQ29uZGl0aW9uTW9kZWwlMkMlMjBMQ01TY2hlZHVsZXIlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXVuZXQlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybGF0ZW50LWNvbnNpc3RlbmN5JTJGbGNtLXNkeGwlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUwQSklMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHVuZXQlM0R1bmV0JTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwTENNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJTZWxmLXBvcnRyYWl0JTIwb2lsJTIwcGFpbnRpbmclMkMlMjBhJTIwYmVhdXRpZnVsJTIwY3lib3JnJTIwd2l0aCUyMGdvbGRlbiUyMGhhaXIlMkMlMjA4ayUyMiUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLm1hbnVhbF9zZWVkKDApJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q0JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q4LjAlMEEpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, UNet2DConditionModel, LCMScheduler
<span class="hljs-keyword">import</span> torch

unet = UNet2DConditionModel.from_pretrained(
    <span class="hljs-string">&quot;latent-consistency/lcm-sdxl&quot;</span>,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
)
pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, unet=unet, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

prompt = <span class="hljs-string">&quot;Self-portrait oil painting, a beautiful cyborg with golden hair, 8k&quot;</span>

generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(
    prompt=prompt, num_inference_steps=<span class="hljs-number">4</span>, generator=generator, guidance_scale=<span class="hljs-number">8.0</span>
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),B=new x({props:{title:"Image-to-image",local:"image-to-image",headingTag:"h2"}}),I=new we({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTJDJTIwVU5ldDJEQ29uZGl0aW9uTW9kZWwlMkMlMjBMQ01TY2hlZHVsZXIlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJsYXRlbnQtY29uc2lzdGVuY3klMkZsY20tc2R4bCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTBBKSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwdW5ldCUzRHVuZXQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBMQ01TY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkhpZ2glMjBhbHRpdHVkZSUyMHNub3d5JTIwbW91bnRhaW5zJTIyJTBBaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRnNheWFrcGF1bCUyRnNhbXBsZS1kYXRhc2V0cyUyRnJlc29sdmUlMkZtYWluJTJGc25vd3lfbW91bnRhaW5zLmpwZWclMjIlMEEpJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2gubWFudWFsX3NlZWQoMCklMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q4LjAlMkMlMEEpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image, UNet2DConditionModel, LCMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

unet = UNet2DConditionModel.from_pretrained(
    <span class="hljs-string">&quot;latent-consistency/lcm-sdxl&quot;</span>,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
)
pipe = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, unet=unet, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

prompt = <span class="hljs-string">&quot;High altitude snowy mountains&quot;</span>
image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/snowy_mountains.jpeg&quot;</span>
)

generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(
    prompt=prompt,
    image=image,
    num_inference_steps=<span class="hljs-number">4</span>,
    generator=generator,
    guidance_scale=<span class="hljs-number">8.0</span>,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Q=new x({props:{title:"LoRA",local:"lora",headingTag:"h2"}}),X=new x({props:{title:"Text-to-image",local:"text-to-image",headingTag:"h3"}}),L=new we({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTJDJTIwTENNU2NoZWR1bGVyJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUwQWxjbV9sb3JhX2lkJTIwJTNEJTIwJTIybGF0ZW50LWNvbnNpc3RlbmN5JTJGbGNtLWxvcmEtc2R4bCUyMiUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfbG9yYV93ZWlnaHRzKGxjbV9sb3JhX2lkKSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwTENNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJjbG9zZS11cCUyMHBob3RvZ3JhcGh5JTIwb2YlMjBvbGQlMjBtYW4lMjBzdGFuZGluZyUyMGluJTIwdGhlJTIwcmFpbiUyMGF0JTIwbmlnaHQlMkMlMjBpbiUyMGElMjBzdHJlZXQlMjBsaXQlMjBieSUyMGxhbXBzJTJDJTIwbGVpY2ElMjAzNW1tJTIwc3VtbWlsdXglMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDAlMkMlMjAlMjAlMjMlMjBzZXQlMjBndWlkYW5jZSUyMHNjYWxlJTIwdG8lMjAwJTIwdG8lMjBkaXNhYmxlJTIwaXQlMEEpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, LCMScheduler
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
lcm_lora_id = <span class="hljs-string">&quot;latent-consistency/lcm-lora-sdxl&quot;</span>

pipe = DiffusionPipeline.from_pretrained(model_id, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_lora_weights(lcm_lora_id)
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

prompt = <span class="hljs-string">&quot;close-up photography of old man standing in the rain at night, in a street lit by lamps, leica 35mm summilux&quot;</span>
image = pipe(
    prompt=prompt,
    num_inference_steps=<span class="hljs-number">4</span>,
    guidance_scale=<span class="hljs-number">0</span>,  <span class="hljs-comment"># set guidance scale to 0 to disable it</span>
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),_=new x({props:{title:"Image-to-image",local:"image-to-image",headingTag:"h3"}}),S=new we({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTJDJTIwTENNU2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTBBbGNtX2xvcmFfaWQlMjAlM0QlMjAlMjJsYXRlbnQtY29uc2lzdGVuY3klMkZsY20tbG9yYS1zZHhsJTIyJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KS50byglMjJjdWRhJTIyKSUwQSUwQXBpcGUubG9hZF9sb3JhX3dlaWdodHMobGNtX2xvcmFfaWQpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBMQ01TY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNsb3NlLXVwJTIwcGhvdG9ncmFwaHklMjBvZiUyMG9sZCUyMG1hbiUyMHN0YW5kaW5nJTIwaW4lMjB0aGUlMjByYWluJTIwYXQlMjBuaWdodCUyQyUyMGluJTIwYSUyMHN0cmVldCUyMGxpdCUyMGJ5JTIwbGFtcHMlMkMlMjBsZWljYSUyMDM1bW0lMjBzdW1taWx1eCUyMiUwQSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZsY20lMkZsb3JhX2xjbS5wbmclMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMCUyQyUyMCUyMCUyMyUyMHNldCUyMGd1aWRhbmNlJTIwc2NhbGUlMjB0byUyMDAlMjB0byUyMGRpc2FibGUlMjBpdCUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLImg2ImgPipeline, LCMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
lcm_lora_id = <span class="hljs-string">&quot;latent-consistency/lcm-lora-sdxl&quot;</span>

pipe = StableDiffusionXLImg2ImgPipeline.from_pretrained(model_id, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_lora_weights(lcm_lora_id)
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

prompt = <span class="hljs-string">&quot;close-up photography of old man standing in the rain at night, in a street lit by lamps, leica 35mm summilux&quot;</span>

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm/lora_lcm.png&quot;</span>)

image = pipe(
    prompt=prompt,
    image=image,
    num_inference_steps=<span class="hljs-number">4</span>,
    guidance_scale=<span class="hljs-number">0</span>,  <span class="hljs-comment"># set guidance scale to 0 to disable it</span>
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){h=i("meta"),F=a(),E=i("p"),z=a(),m(y.$$.fragment),A=a(),f=i("p"),f.textContent=Ze,q=a(),J=i("p"),J.innerHTML=je,D=a(),g=i("blockquote"),g.innerHTML=Ce,P=a(),b=i("p"),b.innerHTML=Ge,K=a(),U=i("p"),U.textContent=We,O=a(),m(w.$$.fragment),ee=a(),T=i("p"),T.innerHTML=Be,te=a(),m(Z.$$.fragment),le=a(),j=i("p"),j.innerHTML=ve,se=a(),C=i("p"),C.textContent=Ie,ae=a(),G=i("p"),G.textContent=Re,ne=a(),W=i("ul"),W.innerHTML=Qe,ie=a(),m(B.$$.fragment),oe=a(),v=i("p"),v.textContent=Ne,pe=a(),m(I.$$.fragment),me=a(),R=i("p"),R.innerHTML=ke,ce=a(),m(Q.$$.fragment),Me=a(),N=i("p"),N.innerHTML=Xe,re=a(),k=i("p"),k.innerHTML=Le,ue=a(),m(X.$$.fragment),de=a(),m(L.$$.fragment),he=a(),Y=i("p"),Y.innerHTML=Ye,ye=a(),m(_.$$.fragment),fe=a(),V=i("p"),V.textContent=_e,Je=a(),m(S.$$.fragment),ge=a(),H=i("p"),H.innerHTML=Ve,be=a(),$=i("p"),this.h()},l(e){const t=Ae("svelte-u9bgzb",document.head);h=o(t,"META",{name:!0,content:!0}),t.forEach(l),F=n(e),E=o(e,"P",{}),Se(E).forEach(l),z=n(e),c(y.$$.fragment,e),A=n(e),f=o(e,"P",{"data-svelte-h":!0}),p(f)!=="svelte-z8g6w0"&&(f.textContent=Ze),q=n(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-d9zkw1"&&(J.innerHTML=je),D=n(e),g=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),p(g)!=="svelte-9ngsrn"&&(g.innerHTML=Ce),P=n(e),b=o(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-yzou0e"&&(b.innerHTML=Ge),K=n(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-f8mmps"&&(U.textContent=We),O=n(e),c(w.$$.fragment,e),ee=n(e),T=o(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1hzha47"&&(T.innerHTML=Be),te=n(e),c(Z.$$.fragment,e),le=n(e),j=o(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-1xlop1"&&(j.innerHTML=ve),se=n(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-n61tgz"&&(C.textContent=Ie),ae=n(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-k48bzl"&&(G.textContent=Re),ne=n(e),W=o(e,"UL",{"data-svelte-h":!0}),p(W)!=="svelte-j6mcv0"&&(W.innerHTML=Qe),ie=n(e),c(B.$$.fragment,e),oe=n(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-faqh5e"&&(v.textContent=Ne),pe=n(e),c(I.$$.fragment,e),me=n(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1ip1f65"&&(R.innerHTML=ke),ce=n(e),c(Q.$$.fragment,e),Me=n(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-17hfqpq"&&(N.innerHTML=Xe),re=n(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-762c0q"&&(k.innerHTML=Le),ue=n(e),c(X.$$.fragment,e),de=n(e),c(L.$$.fragment,e),he=n(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1bt9nqr"&&(Y.innerHTML=Ye),ye=n(e),c(_.$$.fragment,e),fe=n(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1babs9h"&&(V.textContent=_e),Je=n(e),c(S.$$.fragment,e),ge=n(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1ddcini"&&(H.innerHTML=Ve),be=n(e),$=o(e,"P",{}),Se($).forEach(l),this.h()},h(){He(h,"name","hf:doc:metadata"),He(h,"content",Ke)},m(e,t){qe(document.head,h),s(e,F,t),s(e,E,t),s(e,z,t),M(y,e,t),s(e,A,t),s(e,f,t),s(e,q,t),s(e,J,t),s(e,D,t),s(e,g,t),s(e,P,t),s(e,b,t),s(e,K,t),s(e,U,t),s(e,O,t),M(w,e,t),s(e,ee,t),s(e,T,t),s(e,te,t),M(Z,e,t),s(e,le,t),s(e,j,t),s(e,se,t),s(e,C,t),s(e,ae,t),s(e,G,t),s(e,ne,t),s(e,W,t),s(e,ie,t),M(B,e,t),s(e,oe,t),s(e,v,t),s(e,pe,t),M(I,e,t),s(e,me,t),s(e,R,t),s(e,ce,t),M(Q,e,t),s(e,Me,t),s(e,N,t),s(e,re,t),s(e,k,t),s(e,ue,t),M(X,e,t),s(e,de,t),M(L,e,t),s(e,he,t),s(e,Y,t),s(e,ye,t),M(_,e,t),s(e,fe,t),s(e,V,t),s(e,Je,t),M(S,e,t),s(e,ge,t),s(e,H,t),s(e,be,t),s(e,$,t),Ue=!0},p:Ee,i(e){Ue||(r(y.$$.fragment,e),r(w.$$.fragment,e),r(Z.$$.fragment,e),r(B.$$.fragment,e),r(I.$$.fragment,e),r(Q.$$.fragment,e),r(X.$$.fragment,e),r(L.$$.fragment,e),r(_.$$.fragment,e),r(S.$$.fragment,e),Ue=!0)},o(e){u(y.$$.fragment,e),u(w.$$.fragment,e),u(Z.$$.fragment,e),u(B.$$.fragment,e),u(I.$$.fragment,e),u(Q.$$.fragment,e),u(X.$$.fragment,e),u(L.$$.fragment,e),u(_.$$.fragment,e),u(S.$$.fragment,e),Ue=!1},d(e){e&&(l(F),l(E),l(z),l(A),l(f),l(q),l(J),l(D),l(g),l(P),l(b),l(K),l(U),l(O),l(ee),l(T),l(te),l(le),l(j),l(se),l(C),l(ae),l(G),l(ne),l(W),l(ie),l(oe),l(v),l(pe),l(me),l(R),l(ce),l(Me),l(N),l(re),l(k),l(ue),l(de),l(he),l(Y),l(ye),l(fe),l(V),l(Je),l(ge),l(H),l(be),l($)),l(h),d(y,e),d(w,e),d(Z,e),d(B,e),d(I,e),d(Q,e),d(X,e),d(L,e),d(_,e),d(S,e)}}}const Ke='{"title":"Performing inference with LCM","local":"performing-inference-with-lcm","sections":[{"title":"Text-to-image","local":"text-to-image","sections":[],"depth":2},{"title":"Image-to-image","local":"image-to-image","sections":[],"depth":2},{"title":"LoRA","local":"lora","sections":[{"title":"Text-to-image","local":"text-to-image","sections":[],"depth":3},{"title":"Image-to-image","local":"image-to-image","sections":[],"depth":3}],"depth":2}],"depth":1}';function Oe(Te){return $e(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=De}),[]}class at extends Fe{constructor(h){super(),ze(this,h,Oe,Pe,xe,{})}}export{at as component};
