import{s as Xt,o as Bt,n as Vt}from"../chunks/scheduler.182ea377.js";import{S as Ct,i as vt,g as i,s as a,r as m,A as kt,h as p,f as l,c as n,j as Rt,u as r,x as o,k as st,y as Ht,a as s,v as c,d,t as f,w as u}from"../chunks/index.1ea56653.js";import{H as at,g as $t}from"../chunks/Heading.71ac6e9f.js";import{T as Et}from"../chunks/Tip.67abc998.js";import{C as J}from"../chunks/CodeBlock.82c2494b.js";import{D as xt}from"../chunks/DocNotebookDropdown.b1496a40.js";function Yt(ce){let M,h='Check out the <a href="https://huggingface.co/docs/transformers/main/en/generation_strategies" rel="nofollow">generation strategy</a> guide if you’re interested in learning more about strategies for generating different quality text.';return{c(){M=i("p"),M.innerHTML=h},l(w){M=p(w,"P",{"data-svelte-h":!0}),o(M)!=="svelte-vxki65"&&(M.innerHTML=h)},m(w,me){s(w,M,me)},p:Vt,d(w){w&&l(M)}}}function zt(ce){let M,h,w,me,g,de,U,fe,j,nt="Image editing typically requires providing a mask of the area to be edited. DiffEdit automatically generates the mask for you based on a text query, making it easier overall to create a mask without image editing software. The DiffEdit algorithm works in three steps:",ue,Z,it="<li>the diffusion model denoises an image conditioned on some query text and reference text which produces different noise estimates for different areas of the image; the difference is used to infer a mask to identify which area of the image needs to be changed to match the query text</li> <li>the input image is encoded into latent space with DDIM</li> <li>the latents are decoded with the diffusion model conditioned on the text query, using the mask as a guide such that pixels outside the mask remain the same as in the input image</li>",Me,I,pt="This guide will show you how to use DiffEdit to edit images without manually creating a mask.",Je,G,ot="Before you begin, make sure you have the following libraries installed:",we,W,ye,_,mt='The <a href="/docs/diffusers/main/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline">StableDiffusionDiffEditPipeline</a> requires an image mask and a set of partially inverted latents. The image mask is generated from the <a href="/docs/diffusers/main/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline.generate_mask">generate_mask()</a> function, and includes two parameters, <code>source_prompt</code> and <code>target_prompt</code>. These parameters determine what to edit in the image. For example, if you want to change a bowl of <em>fruits</em> to a bowl of <em>pears</em>, then:',Te,R,be,X,rt='The partially inverted latents are generated from the <a href="/docs/diffusers/main/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline.invert">invert()</a> function, and it is generally a good idea to include a <code>prompt</code> or <em>caption</em> describing the image to help guide the inverse latent sampling process. The caption can often be your <code>source_prompt</code>, but feel free to experiment with other text descriptions!',he,B,ct="Let’s load the pipeline, scheduler, inverse scheduler, and enable some optimizations to reduce memory usage:",ge,V,Ue,C,dt="Load the image to edit:",je,v,Ze,k,ft='Use the <a href="/docs/diffusers/main/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline.generate_mask">generate_mask()</a> function to generate the image mask. You’ll need to pass it the <code>source_prompt</code> and <code>target_prompt</code> to specify what to edit in the image:',Ie,H,Ge,$,ut="Next, create the inverted latents and pass it a caption describing the image:",We,E,_e,x,Mt="Finally, pass the image mask and inverted latents to the pipeline. The <code>target_prompt</code> becomes the <code>prompt</code> now, and the <code>source_prompt</code> is used as the <code>negative_prompt</code>:",Re,Y,Xe,y,Jt='<div><img class="rounded-xl" src="https://github.com/Xiang-cd/DiffEdit-stable-diffusion/raw/main/assets/origin.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://github.com/Xiang-cd/DiffEdit-stable-diffusion/blob/main/assets/target.png?raw=true"/> <figcaption class="mt-2 text-center text-sm text-gray-500">edited image</figcaption></div>',Be,z,Ve,N,wt='The source and target embeddings can be automatically generated with the <a href="https://huggingface.co/docs/transformers/model_doc/flan-t5" rel="nofollow">Flan-T5</a> model instead of creating them manually.',Ce,F,yt="Load the Flan-T5 model and tokenizer from the 🤗 Transformers library:",ve,Q,ke,S,Tt="Provide some initial text to prompt the model to generate the source and target prompts.",He,D,$e,A,bt="Next, create a utility function to generate the prompts:",Ee,q,xe,T,Ye,L,ht='Load the text encoder model used by the <a href="/docs/diffusers/main/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline">StableDiffusionDiffEditPipeline</a> to encode the text. You’ll use the text encoder to compute the text embeddings:',ze,P,Ne,K,gt='Finally, pass the embeddings to the <a href="/docs/diffusers/main/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline.generate_mask">generate_mask()</a> and <a href="/docs/diffusers/main/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline.invert">invert()</a> functions, and pipeline to generate the image:',Fe,O,Qe,ee,Se,te,Ut='While you can use the <code>source_prompt</code> as a caption to help generate the partially inverted latents, you can also use the <a href="https://huggingface.co/docs/transformers/model_doc/blip" rel="nofollow">BLIP</a> model to automatically generate a caption.',De,le,jt="Load the BLIP model and processor from the 🤗 Transformers library:",Ae,se,qe,ae,Zt="Create a utility function to generate a caption from the input image:",Le,ne,Pe,ie,It="Load an input image and generate a caption for it using the <code>generate_caption</code> function:",Ke,pe,Oe,b,Gt='<figure><img class="rounded-xl" src="https://github.com/Xiang-cd/DiffEdit-stable-diffusion/raw/main/assets/origin.png"/> <figcaption class="text-center">generated caption: &quot;a photograph of a bowl of fruit on a table&quot;</figcaption></figure>',et,oe,Wt='Now you can drop the caption into the <a href="/docs/diffusers/main/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline.invert">invert()</a> function to generate the partially inverted latents!',tt,re,lt;return g=new at({props:{title:"DiffEdit",local:"diffedit",headingTag:"h1"}}),U=new xt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/diffedit.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/diffedit.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/diffedit.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/diffedit.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/diffedit.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/diffedit.ipynb"}]}}),W=new J({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwZGlmZnVzZXJzJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZSUyMHNhZmV0ZW5zb3Jz",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries in Colab</span>
<span class="hljs-comment">#!pip install diffusers transformers accelerate safetensors</span>`,wrap:!1}}),R=new J({props:{code:"c291cmNlX3Byb21wdCUyMCUzRCUyMCUyMmElMjBib3dsJTIwb2YlMjBmcnVpdHMlMjIlMEF0YXJnZXRfcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGJvd2wlMjBvZiUyMHBlYXJzJTIy",highlighted:`source_prompt = <span class="hljs-string">&quot;a bowl of fruits&quot;</span>
target_prompt = <span class="hljs-string">&quot;a bowl of pears&quot;</span>`,wrap:!1}}),V=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERJTVNjaGVkdWxlciUyQyUyMERESU1JbnZlcnNlU2NoZWR1bGVyJTJDJTIwU3RhYmxlRGlmZnVzaW9uRGlmZkVkaXRQaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uRGlmZkVkaXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHNhZmV0eV9jaGVja2VyJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGVsaW5lLmludmVyc2Vfc2NoZWR1bGVyJTIwJTNEJTIwRERJTUludmVyc2VTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZWxpbmUuc2NoZWR1bGVyLmNvbmZpZyklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQXBpcGVsaW5lLmVuYWJsZV92YWVfc2xpY2luZygp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMScheduler, DDIMInverseScheduler, StableDiffusionDiffEditPipeline

pipeline = StableDiffusionDiffEditPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>,
    torch_dtype=torch.float16,
    safety_checker=<span class="hljs-literal">None</span>,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
pipeline.inverse_scheduler = DDIMInverseScheduler.from_config(pipeline.scheduler.config)
pipeline.enable_model_cpu_offload()
pipeline.enable_vae_slicing()`,wrap:!1}}),v=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGWGlhbmctY2QlMkZEaWZmRWRpdC1zdGFibGUtZGlmZnVzaW9uJTJGcmF3JTJGbWFpbiUyRmFzc2V0cyUyRm9yaWdpbi5wbmclMjIlMEFyYXdfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKGltZ191cmwpLmNvbnZlcnQoJTIyUkdCJTIyKS5yZXNpemUoKDc2OCUyQyUyMDc2OCkp",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

img_url = <span class="hljs-string">&quot;https://github.com/Xiang-cd/DiffEdit-stable-diffusion/raw/main/assets/origin.png&quot;</span>
raw_image = load_image(img_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>).resize((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))`,wrap:!1}}),H=new J({props:{code:"c291cmNlX3Byb21wdCUyMCUzRCUyMCUyMmElMjBib3dsJTIwb2YlMjBmcnVpdHMlMjIlMEF0YXJnZXRfcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGJhc2tldCUyMG9mJTIwcGVhcnMlMjIlMEFtYXNrX2ltYWdlJTIwJTNEJTIwcGlwZWxpbmUuZ2VuZXJhdGVfbWFzayglMEElMjAlMjAlMjAlMjBpbWFnZSUzRHJhd19pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMHNvdXJjZV9wcm9tcHQlM0Rzb3VyY2VfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X3Byb21wdCUzRHRhcmdldF9wcm9tcHQlMkMlMEEp",highlighted:`source_prompt = <span class="hljs-string">&quot;a bowl of fruits&quot;</span>
target_prompt = <span class="hljs-string">&quot;a basket of pears&quot;</span>
mask_image = pipeline.generate_mask(
    image=raw_image,
    source_prompt=source_prompt,
    target_prompt=target_prompt,
)`,wrap:!1}}),E=new J({props:{code:"aW52X2xhdGVudHMlMjAlM0QlMjBwaXBlbGluZS5pbnZlcnQocHJvbXB0JTNEc291cmNlX3Byb21wdCUyQyUyMGltYWdlJTNEcmF3X2ltYWdlKS5sYXRlbnRz",highlighted:"inv_latents = pipeline.invert(prompt=source_prompt, image=raw_image).latents",wrap:!1}}),Y=new J({props:{code:"aW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0R0YXJnZXRfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBpbWFnZV9sYXRlbnRzJTNEaW52X2xhdGVudHMlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0Rzb3VyY2VfcHJvbXB0JTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJlZGl0ZWRfaW1hZ2UucG5nJTIyKQ==",highlighted:`image = pipeline(
    prompt=target_prompt,
    mask_image=mask_image,
    image_latents=inv_latents,
    negative_prompt=source_prompt,
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;edited_image.png&quot;</span>)`,wrap:!1}}),z=new at({props:{title:"Generate source and target embeddings",local:"generate-source-and-target-embeddings",headingTag:"h2"}}),Q=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFQ1Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZmxhbi10NS14bCUyMiklMEFtb2RlbCUyMCUzRCUyMFQ1Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZmbGFuLXQ1LXhsJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, T5ForConditionalGeneration

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-xl&quot;</span>)
model = T5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-xl&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, torch_dtype=torch.float16)`,wrap:!1}}),D=new J({props:{code:"c291cmNlX2NvbmNlcHQlMjAlM0QlMjAlMjJib3dsJTIyJTBBdGFyZ2V0X2NvbmNlcHQlMjAlM0QlMjAlMjJiYXNrZXQlMjIlMEElMEFzb3VyY2VfdGV4dCUyMCUzRCUyMGYlMjJQcm92aWRlJTIwYSUyMGNhcHRpb24lMjBmb3IlMjBpbWFnZXMlMjBjb250YWluaW5nJTIwYSUyMCU3QnNvdXJjZV9jb25jZXB0JTdELiUyMCUyMiUwQSUyMlRoZSUyMGNhcHRpb25zJTIwc2hvdWxkJTIwYmUlMjBpbiUyMEVuZ2xpc2glMjBhbmQlMjBzaG91bGQlMjBiZSUyMG5vJTIwbG9uZ2VyJTIwdGhhbiUyMDE1MCUyMGNoYXJhY3RlcnMuJTIyJTBBJTBBdGFyZ2V0X3RleHQlMjAlM0QlMjBmJTIyUHJvdmlkZSUyMGElMjBjYXB0aW9uJTIwZm9yJTIwaW1hZ2VzJTIwY29udGFpbmluZyUyMGElMjAlN0J0YXJnZXRfY29uY2VwdCU3RC4lMjAlMjIlMEElMjJUaGUlMjBjYXB0aW9ucyUyMHNob3VsZCUyMGJlJTIwaW4lMjBFbmdsaXNoJTIwYW5kJTIwc2hvdWxkJTIwYmUlMjBubyUyMGxvbmdlciUyMHRoYW4lMjAxNTAlMjBjaGFyYWN0ZXJzLiUyMg==",highlighted:`source_concept = <span class="hljs-string">&quot;bowl&quot;</span>
target_concept = <span class="hljs-string">&quot;basket&quot;</span>

source_text = <span class="hljs-string">f&quot;Provide a caption for images containing a <span class="hljs-subst">{source_concept}</span>. &quot;</span>
<span class="hljs-string">&quot;The captions should be in English and should be no longer than 150 characters.&quot;</span>

target_text = <span class="hljs-string">f&quot;Provide a caption for images containing a <span class="hljs-subst">{target_concept}</span>. &quot;</span>
<span class="hljs-string">&quot;The captions should be in English and should be no longer than 150 characters.&quot;</span>`,wrap:!1}}),q=new J({props:{code:"JTQwdG9yY2gubm9fZ3JhZCUwQWRlZiUyMGdlbmVyYXRlX3Byb21wdHMoaW5wdXRfcHJvbXB0KSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplcihpbnB1dF9wcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5pbnB1dF9pZHMudG8oJTIyY3VkYSUyMiklMEElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRfaWRzJTJDJTIwdGVtcGVyYXR1cmUlM0QwLjglMkMlMjBudW1fcmV0dXJuX3NlcXVlbmNlcyUzRDE2JTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTI4JTJDJTIwdG9wX2slM0QxMCUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjB0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEElMEFzb3VyY2VfcHJvbXB0cyUyMCUzRCUyMGdlbmVyYXRlX3Byb21wdHMoc291cmNlX3RleHQpJTBBdGFyZ2V0X3Byb21wdHMlMjAlM0QlMjBnZW5lcmF0ZV9wcm9tcHRzKHRhcmdldF90ZXh0KSUwQXByaW50KHNvdXJjZV9wcm9tcHRzKSUwQXByaW50KHRhcmdldF9wcm9tcHRzKQ==",highlighted:`<span class="hljs-meta">@torch.no_grad</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_prompts</span>(<span class="hljs-params">input_prompt</span>):
    input_ids = tokenizer(input_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids.to(<span class="hljs-string">&quot;cuda&quot;</span>)

    outputs = model.generate(
        input_ids, temperature=<span class="hljs-number">0.8</span>, num_return_sequences=<span class="hljs-number">16</span>, do_sample=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">128</span>, top_k=<span class="hljs-number">10</span>
    )
    <span class="hljs-keyword">return</span> tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)

source_prompts = generate_prompts(source_text)
target_prompts = generate_prompts(target_text)
<span class="hljs-built_in">print</span>(source_prompts)
<span class="hljs-built_in">print</span>(target_prompts)`,wrap:!1}}),T=new Et({props:{$$slots:{default:[Yt]},$$scope:{ctx:ce}}}),P=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionDiffEditPipeline

pipeline = StableDiffusionDiffEditPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
pipeline.enable_vae_slicing()

<span class="hljs-meta">@torch.no_grad()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">embed_prompts</span>(<span class="hljs-params">sentences, tokenizer, text_encoder, device=<span class="hljs-string">&quot;cuda&quot;</span></span>):
    embeddings = []
    <span class="hljs-keyword">for</span> sent <span class="hljs-keyword">in</span> sentences:
        text_inputs = tokenizer(
            sent,
            padding=<span class="hljs-string">&quot;max_length&quot;</span>,
            max_length=tokenizer.model_max_length,
            truncation=<span class="hljs-literal">True</span>,
            return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
        )
        text_input_ids = text_inputs.input_ids
        prompt_embeds = text_encoder(text_input_ids.to(device), attention_mask=<span class="hljs-literal">None</span>)[<span class="hljs-number">0</span>]
        embeddings.append(prompt_embeds)
    <span class="hljs-keyword">return</span> torch.concatenate(embeddings, dim=<span class="hljs-number">0</span>).mean(dim=<span class="hljs-number">0</span>).unsqueeze(<span class="hljs-number">0</span>)

source_embeds = embed_prompts(source_prompts, pipeline.tokenizer, pipeline.text_encoder)
target_embeds = embed_prompts(target_prompts, pipeline.tokenizer, pipeline.text_encoder)`,wrap:!1}}),O=new J({props:{code:"JTIwJTIwZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERESU1JbnZlcnNlU2NoZWR1bGVyJTJDJTIwRERJTVNjaGVkdWxlciUwQSUyMCUyMGZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBJTIwJTIwcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKSUwQSUyMCUyMHBpcGVsaW5lLmludmVyc2Vfc2NoZWR1bGVyJTIwJTNEJTIwRERJTUludmVyc2VTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZWxpbmUuc2NoZWR1bGVyLmNvbmZpZyklMEElMEElMjAlMjBpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGWGlhbmctY2QlMkZEaWZmRWRpdC1zdGFibGUtZGlmZnVzaW9uJTJGcmF3JTJGbWFpbiUyRmFzc2V0cyUyRm9yaWdpbi5wbmclMjIlMEElMjAlMjByYXdfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKGltZ191cmwpLmNvbnZlcnQoJTIyUkdCJTIyKS5yZXNpemUoKDc2OCUyQyUyMDc2OCkpJTBBJTBBJTBBJTIwJTIwbWFza19pbWFnZSUyMCUzRCUyMHBpcGVsaW5lLmdlbmVyYXRlX21hc2soJTBBJTIwJTIwJTIwJTIwJTIwJTIwaW1hZ2UlM0RyYXdfaW1hZ2UlMkMlMEElMkIlMjAlMjAlMjAlMjAlMjBzb3VyY2VfcHJvbXB0X2VtYmVkcyUzRHNvdXJjZV9lbWJlZHMlMkMlMEElMkIlMjAlMjAlMjAlMjAlMjB0YXJnZXRfcHJvbXB0X2VtYmVkcyUzRHRhcmdldF9lbWJlZHMlMkMlMEElMjAlMjApJTBBJTBBJTIwJTIwaW52X2xhdGVudHMlMjAlM0QlMjBwaXBlbGluZS5pbnZlcnQoJTBBJTJCJTIwJTIwJTIwJTIwJTIwcHJvbXB0X2VtYmVkcyUzRHNvdXJjZV9lbWJlZHMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBpbWFnZSUzRHJhd19pbWFnZSUyQyUwQSUyMCUyMCkubGF0ZW50cyUwQSUwQSUyMCUyMGltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMCUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwaW1hZ2VfbGF0ZW50cyUzRGludl9sYXRlbnRzJTJDJTBBJTJCJTIwJTIwJTIwJTIwJTIwcHJvbXB0X2VtYmVkcyUzRHRhcmdldF9lbWJlZHMlMkMlMEElMkIlMjAlMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHRfZW1iZWRzJTNEc291cmNlX2VtYmVkcyUyQyUwQSUyMCUyMCkuaW1hZ2VzJTBBJTIwJTIwaW1hZ2VzJTVCMCU1RC5zYXZlKCUyMmVkaXRlZF9pbWFnZS5wbmclMjIp",highlighted:`  from diffusers import DDIMInverseScheduler, DDIMScheduler
  from diffusers.utils import load_image

  pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
  pipeline.inverse_scheduler = DDIMInverseScheduler.from_config(pipeline.scheduler.config)

  img_url = &quot;https://github.com/Xiang-cd/DiffEdit-stable-diffusion/raw/main/assets/origin.png&quot;
  raw_image = load_image(img_url).convert(&quot;RGB&quot;).resize((768, 768))


  mask_image = pipeline.generate_mask(
      image=raw_image,
<span class="hljs-addition">+     source_prompt_embeds=source_embeds,</span>
<span class="hljs-addition">+     target_prompt_embeds=target_embeds,</span>
  )

  inv_latents = pipeline.invert(
<span class="hljs-addition">+     prompt_embeds=source_embeds,</span>
      image=raw_image,
  ).latents

  images = pipeline(
      mask_image=mask_image,
      image_latents=inv_latents,
<span class="hljs-addition">+     prompt_embeds=target_embeds,</span>
<span class="hljs-addition">+     negative_prompt_embeds=source_embeds,</span>
  ).images
  images[0].save(&quot;edited_image.png&quot;)`,wrap:!1}}),ee=new at({props:{title:"Generate a caption for inversion",local:"generate-a-caption-for-inversion",headingTag:"h2"}}),se=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQmxpcEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyMEJsaXBQcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBCbGlwUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJTYWxlc2ZvcmNlJTJGYmxpcC1pbWFnZS1jYXB0aW9uaW5nLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBCbGlwRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJTYWxlc2ZvcmNlJTJGYmxpcC1pbWFnZS1jYXB0aW9uaW5nLWJhc2UlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BlipForConditionalGeneration, BlipProcessor

processor = BlipProcessor.from_pretrained(<span class="hljs-string">&quot;Salesforce/blip-image-captioning-base&quot;</span>)
model = BlipForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;Salesforce/blip-image-captioning-base&quot;</span>, torch_dtype=torch.float16, low_cpu_mem_usage=<span class="hljs-literal">True</span>)`,wrap:!1}}),ne=new J({props:{code:"JTQwdG9yY2gubm9fZ3JhZCgpJTBBZGVmJTIwZ2VuZXJhdGVfY2FwdGlvbihpbWFnZXMlMkMlMjBjYXB0aW9uX2dlbmVyYXRvciUyQyUyMGNhcHRpb25fcHJvY2Vzc29yKSUzQSUwQSUyMCUyMCUyMCUyMHRleHQlMjAlM0QlMjAlMjJhJTIwcGhvdG9ncmFwaCUyMG9mJTIyJTBBJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwY2FwdGlvbl9wcm9jZXNzb3IoaW1hZ2VzJTJDJTIwdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKGRldmljZSUzRCUyMmN1ZGElMjIlMkMlMjBkdHlwZSUzRGNhcHRpb25fZ2VuZXJhdG9yLmR0eXBlKSUwQSUyMCUyMCUyMCUyMGNhcHRpb25fZ2VuZXJhdG9yLnRvKCUyMmN1ZGElMjIpJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMGNhcHRpb25fZ2VuZXJhdG9yLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwb2ZmbG9hZCUyMGNhcHRpb24lMjBnZW5lcmF0b3IlMEElMjAlMjAlMjAlMjBjYXB0aW9uX2dlbmVyYXRvci50byglMjJjcHUlMjIpJTBBJTBBJTIwJTIwJTIwJTIwY2FwdGlvbiUyMCUzRCUyMGNhcHRpb25fcHJvY2Vzc29yLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGNhcHRpb24=",highlighted:`<span class="hljs-meta">@torch.no_grad()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_caption</span>(<span class="hljs-params">images, caption_generator, caption_processor</span>):
    text = <span class="hljs-string">&quot;a photograph of&quot;</span>

    inputs = caption_processor(images, text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=caption_generator.dtype)
    caption_generator.to(<span class="hljs-string">&quot;cuda&quot;</span>)
    outputs = caption_generator.generate(**inputs, max_new_tokens=<span class="hljs-number">128</span>)

    <span class="hljs-comment"># offload caption generator</span>
    caption_generator.to(<span class="hljs-string">&quot;cpu&quot;</span>)

    caption = caption_processor.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
    <span class="hljs-keyword">return</span> caption`,wrap:!1}}),pe=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGWGlhbmctY2QlMkZEaWZmRWRpdC1zdGFibGUtZGlmZnVzaW9uJTJGcmF3JTJGbWFpbiUyRmFzc2V0cyUyRm9yaWdpbi5wbmclMjIlMEFyYXdfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKGltZ191cmwpLmNvbnZlcnQoJTIyUkdCJTIyKS5yZXNpemUoKDc2OCUyQyUyMDc2OCkpJTBBY2FwdGlvbiUyMCUzRCUyMGdlbmVyYXRlX2NhcHRpb24ocmF3X2ltYWdlJTJDJTIwbW9kZWwlMkMlMjBwcm9jZXNzb3Ip",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

img_url = <span class="hljs-string">&quot;https://github.com/Xiang-cd/DiffEdit-stable-diffusion/raw/main/assets/origin.png&quot;</span>
raw_image = load_image(img_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>).resize((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))
caption = generate_caption(raw_image, model, processor)`,wrap:!1}}),{c(){M=i("meta"),h=a(),w=i("p"),me=a(),m(g.$$.fragment),de=a(),m(U.$$.fragment),fe=a(),j=i("p"),j.textContent=nt,ue=a(),Z=i("ol"),Z.innerHTML=it,Me=a(),I=i("p"),I.textContent=pt,Je=a(),G=i("p"),G.textContent=ot,we=a(),m(W.$$.fragment),ye=a(),_=i("p"),_.innerHTML=mt,Te=a(),m(R.$$.fragment),be=a(),X=i("p"),X.innerHTML=rt,he=a(),B=i("p"),B.textContent=ct,ge=a(),m(V.$$.fragment),Ue=a(),C=i("p"),C.textContent=dt,je=a(),m(v.$$.fragment),Ze=a(),k=i("p"),k.innerHTML=ft,Ie=a(),m(H.$$.fragment),Ge=a(),$=i("p"),$.textContent=ut,We=a(),m(E.$$.fragment),_e=a(),x=i("p"),x.innerHTML=Mt,Re=a(),m(Y.$$.fragment),Xe=a(),y=i("div"),y.innerHTML=Jt,Be=a(),m(z.$$.fragment),Ve=a(),N=i("p"),N.innerHTML=wt,Ce=a(),F=i("p"),F.textContent=yt,ve=a(),m(Q.$$.fragment),ke=a(),S=i("p"),S.textContent=Tt,He=a(),m(D.$$.fragment),$e=a(),A=i("p"),A.textContent=bt,Ee=a(),m(q.$$.fragment),xe=a(),m(T.$$.fragment),Ye=a(),L=i("p"),L.innerHTML=ht,ze=a(),m(P.$$.fragment),Ne=a(),K=i("p"),K.innerHTML=gt,Fe=a(),m(O.$$.fragment),Qe=a(),m(ee.$$.fragment),Se=a(),te=i("p"),te.innerHTML=Ut,De=a(),le=i("p"),le.textContent=jt,Ae=a(),m(se.$$.fragment),qe=a(),ae=i("p"),ae.textContent=Zt,Le=a(),m(ne.$$.fragment),Pe=a(),ie=i("p"),ie.innerHTML=It,Ke=a(),m(pe.$$.fragment),Oe=a(),b=i("div"),b.innerHTML=Gt,et=a(),oe=i("p"),oe.innerHTML=Wt,tt=a(),re=i("p"),this.h()},l(e){const t=kt("svelte-u9bgzb",document.head);M=p(t,"META",{name:!0,content:!0}),t.forEach(l),h=n(e),w=p(e,"P",{}),Rt(w).forEach(l),me=n(e),r(g.$$.fragment,e),de=n(e),r(U.$$.fragment,e),fe=n(e),j=p(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-9fgb3t"&&(j.textContent=nt),ue=n(e),Z=p(e,"OL",{"data-svelte-h":!0}),o(Z)!=="svelte-13ofpju"&&(Z.innerHTML=it),Me=n(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-9vh5wh"&&(I.textContent=pt),Je=n(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-cwruts"&&(G.textContent=ot),we=n(e),r(W.$$.fragment,e),ye=n(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1rtgewh"&&(_.innerHTML=mt),Te=n(e),r(R.$$.fragment,e),be=n(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-q1naxr"&&(X.innerHTML=rt),he=n(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-19i848b"&&(B.textContent=ct),ge=n(e),r(V.$$.fragment,e),Ue=n(e),C=p(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1umymvd"&&(C.textContent=dt),je=n(e),r(v.$$.fragment,e),Ze=n(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-p1ppsn"&&(k.innerHTML=ft),Ie=n(e),r(H.$$.fragment,e),Ge=n(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-58wksg"&&($.textContent=ut),We=n(e),r(E.$$.fragment,e),_e=n(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-949sql"&&(x.innerHTML=Mt),Re=n(e),r(Y.$$.fragment,e),Xe=n(e),y=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(y)!=="svelte-6s9t77"&&(y.innerHTML=Jt),Be=n(e),r(z.$$.fragment,e),Ve=n(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-whlnrh"&&(N.innerHTML=wt),Ce=n(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1lu7pxc"&&(F.textContent=yt),ve=n(e),r(Q.$$.fragment,e),ke=n(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1t1js6"&&(S.textContent=Tt),He=n(e),r(D.$$.fragment,e),$e=n(e),A=p(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1p4c9jk"&&(A.textContent=bt),Ee=n(e),r(q.$$.fragment,e),xe=n(e),r(T.$$.fragment,e),Ye=n(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-wrl4ww"&&(L.innerHTML=ht),ze=n(e),r(P.$$.fragment,e),Ne=n(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-dltym8"&&(K.innerHTML=gt),Fe=n(e),r(O.$$.fragment,e),Qe=n(e),r(ee.$$.fragment,e),Se=n(e),te=p(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-1y9t3by"&&(te.innerHTML=Ut),De=n(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-13qc2l3"&&(le.textContent=jt),Ae=n(e),r(se.$$.fragment,e),qe=n(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-16pyjsw"&&(ae.textContent=Zt),Le=n(e),r(ne.$$.fragment,e),Pe=n(e),ie=p(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-3lbf1j"&&(ie.innerHTML=It),Ke=n(e),r(pe.$$.fragment,e),Oe=n(e),b=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-1jq3ee2"&&(b.innerHTML=Gt),et=n(e),oe=p(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-14bczqy"&&(oe.innerHTML=Wt),tt=n(e),re=p(e,"P",{}),Rt(re).forEach(l),this.h()},h(){st(M,"name","hf:doc:metadata"),st(M,"content",Nt),st(y,"class","flex gap-4"),st(b,"class","flex justify-center")},m(e,t){Ht(document.head,M),s(e,h,t),s(e,w,t),s(e,me,t),c(g,e,t),s(e,de,t),c(U,e,t),s(e,fe,t),s(e,j,t),s(e,ue,t),s(e,Z,t),s(e,Me,t),s(e,I,t),s(e,Je,t),s(e,G,t),s(e,we,t),c(W,e,t),s(e,ye,t),s(e,_,t),s(e,Te,t),c(R,e,t),s(e,be,t),s(e,X,t),s(e,he,t),s(e,B,t),s(e,ge,t),c(V,e,t),s(e,Ue,t),s(e,C,t),s(e,je,t),c(v,e,t),s(e,Ze,t),s(e,k,t),s(e,Ie,t),c(H,e,t),s(e,Ge,t),s(e,$,t),s(e,We,t),c(E,e,t),s(e,_e,t),s(e,x,t),s(e,Re,t),c(Y,e,t),s(e,Xe,t),s(e,y,t),s(e,Be,t),c(z,e,t),s(e,Ve,t),s(e,N,t),s(e,Ce,t),s(e,F,t),s(e,ve,t),c(Q,e,t),s(e,ke,t),s(e,S,t),s(e,He,t),c(D,e,t),s(e,$e,t),s(e,A,t),s(e,Ee,t),c(q,e,t),s(e,xe,t),c(T,e,t),s(e,Ye,t),s(e,L,t),s(e,ze,t),c(P,e,t),s(e,Ne,t),s(e,K,t),s(e,Fe,t),c(O,e,t),s(e,Qe,t),c(ee,e,t),s(e,Se,t),s(e,te,t),s(e,De,t),s(e,le,t),s(e,Ae,t),c(se,e,t),s(e,qe,t),s(e,ae,t),s(e,Le,t),c(ne,e,t),s(e,Pe,t),s(e,ie,t),s(e,Ke,t),c(pe,e,t),s(e,Oe,t),s(e,b,t),s(e,et,t),s(e,oe,t),s(e,tt,t),s(e,re,t),lt=!0},p(e,[t]){const _t={};t&2&&(_t.$$scope={dirty:t,ctx:e}),T.$set(_t)},i(e){lt||(d(g.$$.fragment,e),d(U.$$.fragment,e),d(W.$$.fragment,e),d(R.$$.fragment,e),d(V.$$.fragment,e),d(v.$$.fragment,e),d(H.$$.fragment,e),d(E.$$.fragment,e),d(Y.$$.fragment,e),d(z.$$.fragment,e),d(Q.$$.fragment,e),d(D.$$.fragment,e),d(q.$$.fragment,e),d(T.$$.fragment,e),d(P.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(se.$$.fragment,e),d(ne.$$.fragment,e),d(pe.$$.fragment,e),lt=!0)},o(e){f(g.$$.fragment,e),f(U.$$.fragment,e),f(W.$$.fragment,e),f(R.$$.fragment,e),f(V.$$.fragment,e),f(v.$$.fragment,e),f(H.$$.fragment,e),f(E.$$.fragment,e),f(Y.$$.fragment,e),f(z.$$.fragment,e),f(Q.$$.fragment,e),f(D.$$.fragment,e),f(q.$$.fragment,e),f(T.$$.fragment,e),f(P.$$.fragment,e),f(O.$$.fragment,e),f(ee.$$.fragment,e),f(se.$$.fragment,e),f(ne.$$.fragment,e),f(pe.$$.fragment,e),lt=!1},d(e){e&&(l(h),l(w),l(me),l(de),l(fe),l(j),l(ue),l(Z),l(Me),l(I),l(Je),l(G),l(we),l(ye),l(_),l(Te),l(be),l(X),l(he),l(B),l(ge),l(Ue),l(C),l(je),l(Ze),l(k),l(Ie),l(Ge),l($),l(We),l(_e),l(x),l(Re),l(Xe),l(y),l(Be),l(Ve),l(N),l(Ce),l(F),l(ve),l(ke),l(S),l(He),l($e),l(A),l(Ee),l(xe),l(Ye),l(L),l(ze),l(Ne),l(K),l(Fe),l(Qe),l(Se),l(te),l(De),l(le),l(Ae),l(qe),l(ae),l(Le),l(Pe),l(ie),l(Ke),l(Oe),l(b),l(et),l(oe),l(tt),l(re)),l(M),u(g,e),u(U,e),u(W,e),u(R,e),u(V,e),u(v,e),u(H,e),u(E,e),u(Y,e),u(z,e),u(Q,e),u(D,e),u(q,e),u(T,e),u(P,e),u(O,e),u(ee,e),u(se,e),u(ne,e),u(pe,e)}}}const Nt='{"title":"DiffEdit","local":"diffedit","sections":[{"title":"Generate source and target embeddings","local":"generate-source-and-target-embeddings","sections":[],"depth":2},{"title":"Generate a caption for inversion","local":"generate-a-caption-for-inversion","sections":[],"depth":2}],"depth":1}';function Ft(ce){return Bt(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=$t}),[]}class Pt extends Ct{constructor(M){super(),vt(this,M,Ft,zt,Xt,{})}}export{Pt as component};
