import{s as Kn,n as On,o as es}from"../chunks/scheduler.182ea377.js";import{S as ts,i as ns,g as a,s as o,r as d,A as ss,h as i,f as t,c as l,j as y,u as c,x as p,k as W,y as r,a as s,v as m,d as h,t as u,w as f}from"../chunks/index.abf12888.js";import{D as De}from"../chunks/Docstring.93f6f462.js";import{C as T}from"../chunks/CodeBlock.57fe6e13.js";import{H as Z}from"../chunks/Heading.16916d63.js";function os(gn){let M,qe,He,Ae,C,Ke,k,_n=`<a href="https://huggingface.co/papers/2303.13439" rel="nofollow">Text2Video-Zero: Text-to-Image Diffusion Models are Zero-Shot Video Generators</a> is by
Levon Khachatryan,
Andranik Movsisyan,
Vahram Tadevosyan,
Roberto Henschel,
<a href="https://www.ece.utexas.edu/people/faculty/atlas-wang" rel="nofollow">Zhangyang Wang</a>, Shant Navasardyan, <a href="https://www.humphreyshi.com" rel="nofollow">Humphrey Shi</a>.`,Oe,B,Tn="Text2Video-Zero enables zero-shot video generation using either:",et,V,bn="<li>A textual prompt</li> <li>A prompt combined with guidance from poses or edges</li> <li>Video Instruct-Pix2Pix (instruction-guided video editing)</li>",tt,G,wn="Results are temporally consistent and closely follow the guidance and textual prompts.",nt,N,Mn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/t2v_zero_teaser.png" alt="teaser-img"/>',st,R,Jn="The abstract from the paper is:",ot,X,vn=`<em>Recent text-to-video generation approaches rely on computationally heavy training and require large-scale video datasets. In this paper, we introduce a new task of zero-shot text-to-video generation and propose a low-cost approach (without any training or optimization) by leveraging the power of existing text-to-image synthesis methods (e.g., Stable Diffusion), making them suitable for the video domain.
Our key modifications include (i) enriching the latent codes of the generated frames with motion dynamics to keep the global scene and the background time consistent; and (ii) reprogramming frame-level self-attention using a new cross-frame attention of each frame on the first frame, to preserve the context, appearance, and identity of the foreground object.
Experiments show that this leads to low overhead, yet high-quality and remarkably consistent video generation. Moreover, our approach is not limited to text-to-video synthesis but is also applicable to other tasks such as conditional and content-specialized video generation, and Video Instruct-Pix2Pix, i.e., instruction-guided video editing.
As experiments show, our method performs comparably or sometimes better than recent approaches, despite not being trained on additional video data.</em>`,lt,$,xn='You can find additional information about Text-to-Video Zero on the <a href="https://text2video-zero.github.io/" rel="nofollow">project page</a>, <a href="https://arxiv.org/abs/2303.13439" rel="nofollow">paper</a>, and <a href="https://github.com/Picsart-AI-Research/Text2Video-Zero" rel="nofollow">original codebase</a>.',at,Q,it,z,rt,P,Zn="To generate a video from prompt, run the following python command",pt,S,dt,E,jn="You can change these parameters in the pipeline call:",ct,Y,Un='<li>Motion field strength (see the <a href="https://arxiv.org/abs/2303.13439" rel="nofollow">paper</a>, Sect. 3.3.1):<ul><li><code>motion_field_strength_x</code> and <code>motion_field_strength_y</code>. Default: <code>motion_field_strength_x=12</code>, <code>motion_field_strength_y=12</code></li></ul></li> <li><code>T</code> and <code>T&#39;</code> (see the <a href="https://arxiv.org/abs/2303.13439" rel="nofollow">paper</a>, Sect. 3.3.1)<ul><li><code>t0</code> and <code>t1</code> in the range <code>{0, ..., num_inference_steps}</code>. Default: <code>t0=45</code>, <code>t1=48</code></li></ul></li> <li>Video length:<ul><li><code>video_length</code>, the number of frames video_length to be generated. Default: <code>video_length=8</code></li></ul></li>',mt,F,In="We an also generate longer videos by doing the processing in a chunk-by-chunk manner:",ht,H,ut,L,ft,D,Wn="To generate a video from prompt with additional pose control",yt,je,q,Ue,Cn="Download a demo video",Ft,A,gt,J,v,Ie,kn="Read video containing extracted pose images",Ht,K,Lt,We,Bn='To extract pose from actual video, read <a href="./stable_diffusion/controlnet">ControlNet documentation</a>.',Dt,O,Ce,Vn="Run <code>StableDiffusionControlNetPipeline</code> with our custom attention processor",qt,ee,_t,te,Tt,ne,Gn=`To generate a video from prompt with additional pose control,
follow the steps described above for pose-guided generation using <a href="https://huggingface.co/lllyasviel/sd-controlnet-canny" rel="nofollow">Canny edge ControlNet model</a>.`,bt,se,wt,oe,Nn='To perform text-guided video editing (with <a href="./stable_diffusion/pix2pix">InstructPix2Pix</a>):',Mt,b,le,ke,Rn="Download a demo video",At,ae,Kt,ie,Be,Xn="Read video from path",Ot,re,en,pe,Ve,$n="Run <code>StableDiffusionInstructPix2PixPipeline</code> with our custom attention processor",tn,de,Jt,ce,vt,me,Qn=`Methods <strong>Text-To-Video</strong>, <strong>Text-To-Video with Pose Control</strong> and <strong>Text-To-Video with Edge Control</strong>
can run with custom <a href="../training/dreambooth">DreamBooth</a> models, as shown below for
<a href="https://huggingface.co/lllyasviel/sd-controlnet-canny" rel="nofollow">Canny edge ControlNet model</a> and
<a href="https://huggingface.co/PAIR/text2video-zero-controlnet-canny-avatar" rel="nofollow">Avatar style DreamBooth</a> model`,xt,w,he,Ge,zn="Download a demo video",nn,ue,sn,fe,Ne,Pn="Read video from path",on,ye,ln,ge,Re,Sn="Run <code>StableDiffusionControlNetPipeline</code> with custom trained DreamBooth model",an,_e,Zt,Te,En='You can filter out some available DreamBooth-trained models with <a href="https://huggingface.co/models?search=dreambooth" rel="nofollow">this link</a>.',jt,be,Ut,g,we,rn,Xe,Yn="Pipeline for zero-shot text-to-video generation using Stable Diffusion.",pn,$e,Fn=`This model inherits from <a href="/docs/diffusers/v0.22.3/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,dn,j,Me,cn,Qe,Hn="The call function to the pipeline for generation.",mn,U,Je,hn,ze,Ln="Perform backward process given list of time steps.",un,I,ve,fn,Pe,Dn="Perform DDPM forward process from time t0 to t1. This is the same as adding noise with corresponding variance.",It,xe,Wt,x,Ze,yn,Se,qn="Output class for zero-shot text-to-video pipeline.",Ct,Le,kt;return C=new Z({props:{title:"Text2Video-Zero",local:"text2video-zero",headingTag:"h1"}}),Q=new Z({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),z=new Z({props:{title:"Text-To-Video",local:"text-to-video",headingTag:"h3"}}),S=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBpbWFnZWlvJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFRleHRUb1ZpZGVvWmVyb1BpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGUlMjAlM0QlMjBUZXh0VG9WaWRlb1plcm9QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMHBhbmRhJTIwaXMlMjBwbGF5aW5nJTIwZ3VpdGFyJTIwb24lMjB0aW1lcyUyMHNxdWFyZSUyMiUwQXJlc3VsdCUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0KS5pbWFnZXMlMEFyZXN1bHQlMjAlM0QlMjAlNUIociUyMColMjAyNTUpLmFzdHlwZSglMjJ1aW50OCUyMiklMjBmb3IlMjByJTIwaW4lMjByZXN1bHQlNUQlMEFpbWFnZWlvLm1pbXNhdmUoJTIydmlkZW8ubXA0JTIyJTJDJTIwcmVzdWx0JTJDJTIwZnBzJTNENCk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> imageio
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> TextToVideoZeroPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = TextToVideoZeroPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A panda is playing guitar on times square&quot;</span>
result = pipe(prompt=prompt).images
result = [(r * <span class="hljs-number">255</span>).astype(<span class="hljs-string">&quot;uint8&quot;</span>) <span class="hljs-keyword">for</span> r <span class="hljs-keyword">in</span> result]
imageio.mimsave(<span class="hljs-string">&quot;video.mp4&quot;</span>, result, fps=<span class="hljs-number">4</span>)`,wrap:!1}}),H=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBpbWFnZWlvJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFRleHRUb1ZpZGVvWmVyb1BpcGVsaW5lJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGUlMjAlM0QlMjBUZXh0VG9WaWRlb1plcm9QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBc2VlZCUyMCUzRCUyMDAlMEF2aWRlb19sZW5ndGglMjAlM0QlMjA4JTBBY2h1bmtfc2l6ZSUyMCUzRCUyMDQlMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwcGFuZGElMjBpcyUyMHBsYXlpbmclMjBndWl0YXIlMjBvbiUyMHRpbWVzJTIwc3F1YXJlJTIyJTBBJTBBJTIzJTIwR2VuZXJhdGUlMjB0aGUlMjB2aWRlbyUyMGNodW5rLWJ5LWNodW5rJTBBcmVzdWx0JTIwJTNEJTIwJTVCJTVEJTBBY2h1bmtfaWRzJTIwJTNEJTIwbnAuYXJhbmdlKDAlMkMlMjB2aWRlb19sZW5ndGglMkMlMjBjaHVua19zaXplJTIwLSUyMDEpJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmN1ZGElMjIpJTBBZm9yJTIwaSUyMGluJTIwcmFuZ2UobGVuKGNodW5rX2lkcykpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMlByb2Nlc3NpbmclMjBjaHVuayUyMCU3QmklMjAlMkIlMjAxJTdEJTIwJTJGJTIwJTdCbGVuKGNodW5rX2lkcyklN0QlMjIpJTBBJTIwJTIwJTIwJTIwY2hfc3RhcnQlMjAlM0QlMjBjaHVua19pZHMlNUJpJTVEJTBBJTIwJTIwJTIwJTIwY2hfZW5kJTIwJTNEJTIwdmlkZW9fbGVuZ3RoJTIwaWYlMjBpJTIwJTNEJTNEJTIwbGVuKGNodW5rX2lkcyklMjAtJTIwMSUyMGVsc2UlMjBjaHVua19pZHMlNUJpJTIwJTJCJTIwMSU1RCUwQSUyMCUyMCUyMCUyMCUyMyUyMEF0dGFjaCUyMHRoZSUyMGZpcnN0JTIwZnJhbWUlMjBmb3IlMjBDcm9zcyUyMEZyYW1lJTIwQXR0ZW50aW9uJTBBJTIwJTIwJTIwJTIwZnJhbWVfaWRzJTIwJTNEJTIwJTVCMCU1RCUyMCUyQiUyMGxpc3QocmFuZ2UoY2hfc3RhcnQlMkMlMjBjaF9lbmQpKSUwQSUyMCUyMCUyMCUyMCUyMyUyMEZpeCUyMHRoZSUyMHNlZWQlMjBmb3IlMjB0aGUlMjB0ZW1wb3JhbCUyMGNvbnNpc3RlbmN5JTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yLm1hbnVhbF9zZWVkKHNlZWQpJTBBJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjB2aWRlb19sZW5ndGglM0RsZW4oZnJhbWVfaWRzKSUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUyMGZyYW1lX2lkcyUzRGZyYW1lX2lkcyklMEElMjAlMjAlMjAlMjByZXN1bHQuYXBwZW5kKG91dHB1dC5pbWFnZXMlNUIxJTNBJTVEKSUwQSUwQSUyMyUyMENvbmNhdGVuYXRlJTIwY2h1bmtzJTIwYW5kJTIwc2F2ZSUwQXJlc3VsdCUyMCUzRCUyMG5wLmNvbmNhdGVuYXRlKHJlc3VsdCklMEFyZXN1bHQlMjAlM0QlMjAlNUIociUyMColMjAyNTUpLmFzdHlwZSglMjJ1aW50OCUyMiklMjBmb3IlMjByJTIwaW4lMjByZXN1bHQlNUQlMEFpbWFnZWlvLm1pbXNhdmUoJTIydmlkZW8ubXA0JTIyJTJDJTIwcmVzdWx0JTJDJTIwZnBzJTNENCk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> imageio
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> TextToVideoZeroPipeline
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = TextToVideoZeroPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
seed = <span class="hljs-number">0</span>
video_length = <span class="hljs-number">8</span>
chunk_size = <span class="hljs-number">4</span>
prompt = <span class="hljs-string">&quot;A panda is playing guitar on times square&quot;</span>

<span class="hljs-comment"># Generate the video chunk-by-chunk</span>
result = []
chunk_ids = np.arange(<span class="hljs-number">0</span>, video_length, chunk_size - <span class="hljs-number">1</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(chunk_ids)):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Processing chunk <span class="hljs-subst">{i + <span class="hljs-number">1</span>}</span> / <span class="hljs-subst">{<span class="hljs-built_in">len</span>(chunk_ids)}</span>&quot;</span>)
    ch_start = chunk_ids[i]
    ch_end = video_length <span class="hljs-keyword">if</span> i == <span class="hljs-built_in">len</span>(chunk_ids) - <span class="hljs-number">1</span> <span class="hljs-keyword">else</span> chunk_ids[i + <span class="hljs-number">1</span>]
    <span class="hljs-comment"># Attach the first frame for Cross Frame Attention</span>
    frame_ids = [<span class="hljs-number">0</span>] + <span class="hljs-built_in">list</span>(<span class="hljs-built_in">range</span>(ch_start, ch_end))
    <span class="hljs-comment"># Fix the seed for the temporal consistency</span>
    generator.manual_seed(seed)
    output = pipe(prompt=prompt, video_length=<span class="hljs-built_in">len</span>(frame_ids), generator=generator, frame_ids=frame_ids)
    result.append(output.images[<span class="hljs-number">1</span>:])

<span class="hljs-comment"># Concatenate chunks and save</span>
result = np.concatenate(result)
result = [(r * <span class="hljs-number">255</span>).astype(<span class="hljs-string">&quot;uint8&quot;</span>) <span class="hljs-keyword">for</span> r <span class="hljs-keyword">in</span> result]
imageio.mimsave(<span class="hljs-string">&quot;video.mp4&quot;</span>, result, fps=<span class="hljs-number">4</span>)`,wrap:!1}}),L=new Z({props:{title:"Text-To-Video with Pose Control",local:"text-to-video-with-pose-control",headingTag:"h3"}}),A=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQSUwQWZpbGVuYW1lJTIwJTNEJTIwJTIyX19hc3NldHNfXyUyRnBvc2VzX3NrZWxldG9uX2dpZnMlMkZkYW5jZTFfY29yci5tcDQlMjIlMEFyZXBvX2lkJTIwJTNEJTIwJTIyUEFJUiUyRlRleHQyVmlkZW8tWmVybyUyMiUwQXZpZGVvX3BhdGglMjAlM0QlMjBoZl9odWJfZG93bmxvYWQocmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMjByZXBvX2lkJTNEcmVwb19pZCUyQyUyMGZpbGVuYW1lJTNEZmlsZW5hbWUp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

filename = <span class="hljs-string">&quot;__assets__/poses_skeleton_gifs/dance1_corr.mp4&quot;</span>
repo_id = <span class="hljs-string">&quot;PAIR/Text2Video-Zero&quot;</span>
video_path = hf_hub_download(repo_type=<span class="hljs-string">&quot;space&quot;</span>, repo_id=repo_id, filename=filename)`,wrap:!1}}),K=new T({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwaW1hZ2VpbyUwQSUwQXJlYWRlciUyMCUzRCUyMGltYWdlaW8uZ2V0X3JlYWRlcih2aWRlb19wYXRoJTJDJTIwJTIyZmZtcGVnJTIyKSUwQWZyYW1lX2NvdW50JTIwJTNEJTIwOCUwQXBvc2VfaW1hZ2VzJTIwJTNEJTIwJTVCSW1hZ2UuZnJvbWFycmF5KHJlYWRlci5nZXRfZGF0YShpKSklMjBmb3IlMjBpJTIwaW4lMjByYW5nZShmcmFtZV9jb3VudCklNUQ=",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> imageio

reader = imageio.get_reader(video_path, <span class="hljs-string">&quot;ffmpeg&quot;</span>)
frame_count = <span class="hljs-number">8</span>
pose_images = [Image.fromarray(reader.get_data(i)) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(frame_count)]`,wrap:!1}}),ee=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldFBpcGVsaW5lJTJDJTIwQ29udHJvbE5ldE1vZGVsJTBBZnJvbSUyMGRpZmZ1c2Vycy5waXBlbGluZXMudGV4dF90b192aWRlb19zeW50aGVzaXMucGlwZWxpbmVfdGV4dF90b192aWRlb196ZXJvJTIwaW1wb3J0JTIwQ3Jvc3NGcmFtZUF0dG5Qcm9jZXNzb3IlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBY29udHJvbG5ldCUyMCUzRCUyMENvbnRyb2xOZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIybGxseWFzdmllbCUyRnNkLWNvbnRyb2xuZXQtb3BlbnBvc2UlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSkudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBTZXQlMjB0aGUlMjBhdHRlbnRpb24lMjBwcm9jZXNzb3IlMEFwaXBlLnVuZXQuc2V0X2F0dG5fcHJvY2Vzc29yKENyb3NzRnJhbWVBdHRuUHJvY2Vzc29yKGJhdGNoX3NpemUlM0QyKSklMEFwaXBlLmNvbnRyb2xuZXQuc2V0X2F0dG5fcHJvY2Vzc29yKENyb3NzRnJhbWVBdHRuUHJvY2Vzc29yKGJhdGNoX3NpemUlM0QyKSklMEElMEElMjMlMjBmaXglMjBsYXRlbnRzJTIwZm9yJTIwYWxsJTIwZnJhbWVzJTBBbGF0ZW50cyUyMCUzRCUyMHRvcmNoLnJhbmRuKCgxJTJDJTIwNCUyQyUyMDY0JTJDJTIwNjQpJTJDJTIwZGV2aWNlJTNEJTIyY3VkYSUyMiUyQyUyMGR0eXBlJTNEdG9yY2guZmxvYXQxNikucmVwZWF0KGxlbihwb3NlX2ltYWdlcyklMkMlMjAxJTJDJTIwMSUyQyUyMDEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyRGFydGglMjBWYWRlciUyMGRhbmNpbmclMjBpbiUyMGElMjBkZXNlcnQlMjIlMEFyZXN1bHQlMjAlM0QlMjBwaXBlKHByb21wdCUzRCU1QnByb21wdCU1RCUyMColMjBsZW4ocG9zZV9pbWFnZXMpJTJDJTIwaW1hZ2UlM0Rwb3NlX2ltYWdlcyUyQyUyMGxhdGVudHMlM0RsYXRlbnRzKS5pbWFnZXMlMEFpbWFnZWlvLm1pbXNhdmUoJTIydmlkZW8ubXA0JTIyJTJDJTIwcmVzdWx0JTJDJTIwZnBzJTNENCk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel
<span class="hljs-keyword">from</span> diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero <span class="hljs-keyword">import</span> CrossFrameAttnProcessor

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-openpose&quot;</span>, torch_dtype=torch.float16)
pipe = StableDiffusionControlNetPipeline.from_pretrained(
    model_id, controlnet=controlnet, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Set the attention processor</span>
pipe.unet.set_attn_processor(CrossFrameAttnProcessor(batch_size=<span class="hljs-number">2</span>))
pipe.controlnet.set_attn_processor(CrossFrameAttnProcessor(batch_size=<span class="hljs-number">2</span>))

<span class="hljs-comment"># fix latents for all frames</span>
latents = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16).repeat(<span class="hljs-built_in">len</span>(pose_images), <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>)

prompt = <span class="hljs-string">&quot;Darth Vader dancing in a desert&quot;</span>
result = pipe(prompt=[prompt] * <span class="hljs-built_in">len</span>(pose_images), image=pose_images, latents=latents).images
imageio.mimsave(<span class="hljs-string">&quot;video.mp4&quot;</span>, result, fps=<span class="hljs-number">4</span>)`,wrap:!1}}),te=new Z({props:{title:"Text-To-Video with Edge Control",local:"text-to-video-with-edge-control",headingTag:"h3"}}),se=new Z({props:{title:"Video Instruct-Pix2Pix",local:"video-instruct-pix2pix",headingTag:"h3"}}),ae=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQSUwQWZpbGVuYW1lJTIwJTNEJTIwJTIyX19hc3NldHNfXyUyRnBpeDJwaXglMjB2aWRlbyUyRmNhbWVsLm1wNCUyMiUwQXJlcG9faWQlMjAlM0QlMjAlMjJQQUlSJTJGVGV4dDJWaWRlby1aZXJvJTIyJTBBdmlkZW9fcGF0aCUyMCUzRCUyMGhmX2h1Yl9kb3dubG9hZChyZXBvX3R5cGUlM0QlMjJzcGFjZSUyMiUyQyUyMHJlcG9faWQlM0RyZXBvX2lkJTJDJTIwZmlsZW5hbWUlM0RmaWxlbmFtZSk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

filename = <span class="hljs-string">&quot;__assets__/pix2pix video/camel.mp4&quot;</span>
repo_id = <span class="hljs-string">&quot;PAIR/Text2Video-Zero&quot;</span>
video_path = hf_hub_download(repo_type=<span class="hljs-string">&quot;space&quot;</span>, repo_id=repo_id, filename=filename)`,wrap:!1}}),re=new T({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwaW1hZ2VpbyUwQSUwQXJlYWRlciUyMCUzRCUyMGltYWdlaW8uZ2V0X3JlYWRlcih2aWRlb19wYXRoJTJDJTIwJTIyZmZtcGVnJTIyKSUwQWZyYW1lX2NvdW50JTIwJTNEJTIwOCUwQXZpZGVvJTIwJTNEJTIwJTVCSW1hZ2UuZnJvbWFycmF5KHJlYWRlci5nZXRfZGF0YShpKSklMjBmb3IlMjBpJTIwaW4lMjByYW5nZShmcmFtZV9jb3VudCklNUQ=",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> imageio

reader = imageio.get_reader(video_path, <span class="hljs-string">&quot;ffmpeg&quot;</span>)
frame_count = <span class="hljs-number">8</span>
video = [Image.fromarray(reader.get_data(i)) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(frame_count)]`,wrap:!1}}),de=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uSW5zdHJ1Y3RQaXgyUGl4UGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnBpcGVsaW5lcy50ZXh0X3RvX3ZpZGVvX3N5bnRoZXNpcy5waXBlbGluZV90ZXh0X3RvX3ZpZGVvX3plcm8lMjBpbXBvcnQlMjBDcm9zc0ZyYW1lQXR0blByb2Nlc3NvciUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIydGltYnJvb2tzJTJGaW5zdHJ1Y3QtcGl4MnBpeCUyMiUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbnN0cnVjdFBpeDJQaXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZS51bmV0LnNldF9hdHRuX3Byb2Nlc3NvcihDcm9zc0ZyYW1lQXR0blByb2Nlc3NvcihiYXRjaF9zaXplJTNEMykpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIybWFrZSUyMGl0JTIwVmFuJTIwR29naCUyMFN0YXJyeSUyME5pZ2h0JTIwc3R5bGUlMjIlMEFyZXN1bHQlMjAlM0QlMjBwaXBlKHByb21wdCUzRCU1QnByb21wdCU1RCUyMColMjBsZW4odmlkZW8pJTJDJTIwaW1hZ2UlM0R2aWRlbykuaW1hZ2VzJTBBaW1hZ2Vpby5taW1zYXZlKCUyMmVkaXRlZF92aWRlby5tcDQlMjIlMkMlMjByZXN1bHQlMkMlMjBmcHMlM0Q0KQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionInstructPix2PixPipeline
<span class="hljs-keyword">from</span> diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero <span class="hljs-keyword">import</span> CrossFrameAttnProcessor

model_id = <span class="hljs-string">&quot;timbrooks/instruct-pix2pix&quot;</span>
pipe = StableDiffusionInstructPix2PixPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.unet.set_attn_processor(CrossFrameAttnProcessor(batch_size=<span class="hljs-number">3</span>))

prompt = <span class="hljs-string">&quot;make it Van Gogh Starry Night style&quot;</span>
result = pipe(prompt=[prompt] * <span class="hljs-built_in">len</span>(video), image=video).images
imageio.mimsave(<span class="hljs-string">&quot;edited_video.mp4&quot;</span>, result, fps=<span class="hljs-number">4</span>)`,wrap:!1}}),ce=new Z({props:{title:"DreamBooth specialization",local:"dreambooth-specialization",headingTag:"h3"}}),ue=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQSUwQWZpbGVuYW1lJTIwJTNEJTIwJTIyX19hc3NldHNfXyUyRmNhbm55X3ZpZGVvc19tcDQlMkZnaXJsX3R1cm5pbmcubXA0JTIyJTBBcmVwb19pZCUyMCUzRCUyMCUyMlBBSVIlMkZUZXh0MlZpZGVvLVplcm8lMjIlMEF2aWRlb19wYXRoJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKHJlcG9fdHlwZSUzRCUyMnNwYWNlJTIyJTJDJTIwcmVwb19pZCUzRHJlcG9faWQlMkMlMjBmaWxlbmFtZSUzRGZpbGVuYW1lKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

filename = <span class="hljs-string">&quot;__assets__/canny_videos_mp4/girl_turning.mp4&quot;</span>
repo_id = <span class="hljs-string">&quot;PAIR/Text2Video-Zero&quot;</span>
video_path = hf_hub_download(repo_type=<span class="hljs-string">&quot;space&quot;</span>, repo_id=repo_id, filename=filename)`,wrap:!1}}),ye=new T({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwaW1hZ2VpbyUwQSUwQXJlYWRlciUyMCUzRCUyMGltYWdlaW8uZ2V0X3JlYWRlcih2aWRlb19wYXRoJTJDJTIwJTIyZmZtcGVnJTIyKSUwQWZyYW1lX2NvdW50JTIwJTNEJTIwOCUwQWNhbm55X2VkZ2VzJTIwJTNEJTIwJTVCSW1hZ2UuZnJvbWFycmF5KHJlYWRlci5nZXRfZGF0YShpKSklMjBmb3IlMjBpJTIwaW4lMjByYW5nZShmcmFtZV9jb3VudCklNUQ=",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> imageio

reader = imageio.get_reader(video_path, <span class="hljs-string">&quot;ffmpeg&quot;</span>)
frame_count = <span class="hljs-number">8</span>
canny_edges = [Image.fromarray(reader.get_data(i)) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(frame_count)]`,wrap:!1}}),_e=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldFBpcGVsaW5lJTJDJTIwQ29udHJvbE5ldE1vZGVsJTBBZnJvbSUyMGRpZmZ1c2Vycy5waXBlbGluZXMudGV4dF90b192aWRlb19zeW50aGVzaXMucGlwZWxpbmVfdGV4dF90b192aWRlb196ZXJvJTIwaW1wb3J0JTIwQ3Jvc3NGcmFtZUF0dG5Qcm9jZXNzb3IlMEElMEElMjMlMjBzZXQlMjBtb2RlbCUyMGlkJTIwdG8lMjBjdXN0b20lMjBtb2RlbCUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyUEFJUiUyRnRleHQydmlkZW8temVyby1jb250cm9sbmV0LWNhbm55LWF2YXRhciUyMiUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmxsbHlhc3ZpZWwlMkZzZC1jb250cm9sbmV0LWNhbm55JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25Db250cm9sTmV0UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTIwY29udHJvbG5ldCUzRGNvbnRyb2xuZXQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTIzJTIwU2V0JTIwdGhlJTIwYXR0ZW50aW9uJTIwcHJvY2Vzc29yJTBBcGlwZS51bmV0LnNldF9hdHRuX3Byb2Nlc3NvcihDcm9zc0ZyYW1lQXR0blByb2Nlc3NvcihiYXRjaF9zaXplJTNEMikpJTBBcGlwZS5jb250cm9sbmV0LnNldF9hdHRuX3Byb2Nlc3NvcihDcm9zc0ZyYW1lQXR0blByb2Nlc3NvcihiYXRjaF9zaXplJTNEMikpJTBBJTBBJTIzJTIwZml4JTIwbGF0ZW50cyUyMGZvciUyMGFsbCUyMGZyYW1lcyUwQWxhdGVudHMlMjAlM0QlMjB0b3JjaC5yYW5kbigoMSUyQyUyMDQlMkMlMjA2NCUyQyUyMDY0KSUyQyUyMGRldmljZSUzRCUyMmN1ZGElMjIlMkMlMjBkdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnJlcGVhdChsZW4oY2FubnlfZWRnZXMpJTJDJTIwMSUyQyUyMDElMkMlMjAxKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMm9pbCUyMHBhaW50aW5nJTIwb2YlMjBhJTIwYmVhdXRpZnVsJTIwZ2lybCUyMGF2YXRhciUyMHN0eWxlJTIyJTBBcmVzdWx0JTIwJTNEJTIwcGlwZShwcm9tcHQlM0QlNUJwcm9tcHQlNUQlMjAqJTIwbGVuKGNhbm55X2VkZ2VzKSUyQyUyMGltYWdlJTNEY2FubnlfZWRnZXMlMkMlMjBsYXRlbnRzJTNEbGF0ZW50cykuaW1hZ2VzJTBBaW1hZ2Vpby5taW1zYXZlKCUyMnZpZGVvLm1wNCUyMiUyQyUyMHJlc3VsdCUyQyUyMGZwcyUzRDQp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel
<span class="hljs-keyword">from</span> diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero <span class="hljs-keyword">import</span> CrossFrameAttnProcessor

<span class="hljs-comment"># set model id to custom model</span>
model_id = <span class="hljs-string">&quot;PAIR/text2video-zero-controlnet-canny-avatar&quot;</span>
controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>, torch_dtype=torch.float16)
pipe = StableDiffusionControlNetPipeline.from_pretrained(
    model_id, controlnet=controlnet, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Set the attention processor</span>
pipe.unet.set_attn_processor(CrossFrameAttnProcessor(batch_size=<span class="hljs-number">2</span>))
pipe.controlnet.set_attn_processor(CrossFrameAttnProcessor(batch_size=<span class="hljs-number">2</span>))

<span class="hljs-comment"># fix latents for all frames</span>
latents = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16).repeat(<span class="hljs-built_in">len</span>(canny_edges), <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>)

prompt = <span class="hljs-string">&quot;oil painting of a beautiful girl avatar style&quot;</span>
result = pipe(prompt=[prompt] * <span class="hljs-built_in">len</span>(canny_edges), image=canny_edges, latents=latents).images
imageio.mimsave(<span class="hljs-string">&quot;video.mp4&quot;</span>, result, fps=<span class="hljs-number">4</span>)`,wrap:!1}}),be=new Z({props:{title:"TextToVideoZeroPipeline",local:"diffusers.TextToVideoZeroPipeline",headingTag:"h2"}}),we=new De({props:{name:"class diffusers.TextToVideoZeroPipeline",anchor:"diffusers.TextToVideoZeroPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.TextToVideoZeroPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.22.3/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.TextToVideoZeroPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.TextToVideoZeroPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.TextToVideoZeroPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.22.3/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/v0.22.3/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a> to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.TextToVideoZeroPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.22.3/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.22.3/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.22.3/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.22.3/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.TextToVideoZeroPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.TextToVideoZeroPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.3/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero.py#L274"}}),Me=new De({props:{name:"__call__",anchor:"diffusers.TextToVideoZeroPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"video_length",val:": typing.Optional[int] = 8"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"motion_field_strength_x",val:": float = 12"},{name:"motion_field_strength_y",val:": float = 12"},{name:"output_type",val:": typing.Optional[str] = 'tensor'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": typing.Optional[int] = 1"},{name:"t0",val:": int = 44"},{name:"t1",val:": int = 47"},{name:"frame_ids",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"diffusers.TextToVideoZeroPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.video_length",description:`<strong>video_length</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
The number of generated video frames.`,name:"video_length"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in video generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.22.3/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;numpy&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>&quot;latent&quot;</code> and <code>&quot;numpy&quot;</code>.`,name:"output_type"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a
<a href="/docs/diffusers/v0.22.3/en/api/pipelines/text_to_video_zero#diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput">TextToVideoPipelineOutput</a> instead of
a plain tuple.`,name:"return_dict"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.motion_field_strength_x",description:`<strong>motion_field_strength_x</strong> (<code>float</code>, <em>optional</em>, defaults to 12) &#x2014;
Strength of motion in generated video along x-axis. See the <a href="https://arxiv.org/abs/2303.13439" rel="nofollow">paper</a>,
Sect. 3.3.1.`,name:"motion_field_strength_x"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.motion_field_strength_y",description:`<strong>motion_field_strength_y</strong> (<code>float</code>, <em>optional</em>, defaults to 12) &#x2014;
Strength of motion in generated video along y-axis. See the <a href="https://arxiv.org/abs/2303.13439" rel="nofollow">paper</a>,
Sect. 3.3.1.`,name:"motion_field_strength_y"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.t0",description:`<strong>t0</strong> (<code>int</code>, <em>optional</em>, defaults to 44) &#x2014;
Timestep t0. Should be in the range [0, num_inference_steps - 1]. See the
<a href="https://arxiv.org/abs/2303.13439" rel="nofollow">paper</a>, Sect. 3.3.1.`,name:"t0"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.t1",description:`<strong>t1</strong> (<code>int</code>, <em>optional</em>, defaults to 47) &#x2014;
Timestep t0. Should be in the range [t0 + 1, num_inference_steps - 1]. See the
<a href="https://arxiv.org/abs/2303.13439" rel="nofollow">paper</a>, Sect. 3.3.1.`,name:"t1"},{anchor:"diffusers.TextToVideoZeroPipeline.__call__.frame_ids",description:`<strong>frame_ids</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Indexes of the frames that are being generated. This is used when generating longer videos
chunk-by-chunk.`,name:"frame_ids"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.3/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero.py#L421",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The output contains a <code>ndarray</code> of the generated video, when <code>output_type</code> != <code>"latent"</code>, otherwise a
latent code of generated videos and a list of <code>bool</code>s indicating whether the corresponding generated
video contains “not-safe-for-work” (nsfw) content..</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.22.3/en/api/pipelines/text_to_video_zero#diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput"
>TextToVideoPipelineOutput</a></p>
`}}),Je=new De({props:{name:"backward_loop",anchor:"diffusers.TextToVideoZeroPipeline.backward_loop",parameters:[{name:"latents",val:""},{name:"timesteps",val:""},{name:"prompt_embeds",val:""},{name:"guidance_scale",val:""},{name:"callback",val:""},{name:"callback_steps",val:""},{name:"num_warmup_steps",val:""},{name:"extra_step_kwargs",val:""},{name:"cross_attention_kwargs",val:" = None"}],parametersDescription:[{anchor:"diffusers.TextToVideoZeroPipeline.backward_loop.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.TextToVideoZeroPipeline.backward_loop.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.
extra_step_kwargs &#x2014;
Extra_step_kwargs.
cross_attention_kwargs &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.
num_warmup_steps &#x2014;
number of warmup steps.`,name:"callback_steps"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.3/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero.py#L346",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Latents of backward process output at time timesteps[-1].</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>latents</p>
`}}),ve=new De({props:{name:"forward_loop",anchor:"diffusers.TextToVideoZeroPipeline.forward_loop",parameters:[{name:"x_t0",val:""},{name:"t0",val:""},{name:"t1",val:""},{name:"generator",val:""}],parametersDescription:[{anchor:"diffusers.TextToVideoZeroPipeline.forward_loop.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.3/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero.py#L322",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Forward process applied to x_t0 from time t0 to t1.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>x_t1</p>
`}}),xe=new Z({props:{title:"TextToVideoPipelineOutput",local:"diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput",headingTag:"h2"}}),Ze=new De({props:{name:"class diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput",anchor:"diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"},{name:"nsfw_content_detected",val:": typing.Optional[typing.List[bool]]"}],parametersDescription:[{anchor:"diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput.images",description:`<strong>images</strong> (<code>[List[PIL.Image.Image]</code>, <code>np.ndarray</code>]) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>[List[bool]]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.3/src/diffusers/pipelines/text_to_video_synthesis/pipeline_text_to_video_zero.py#L174"}}),{c(){M=a("meta"),qe=o(),He=a("p"),Ae=o(),d(C.$$.fragment),Ke=o(),k=a("p"),k.innerHTML=_n,Oe=o(),B=a("p"),B.textContent=Tn,et=o(),V=a("ol"),V.innerHTML=bn,tt=o(),G=a("p"),G.textContent=wn,nt=o(),N=a("p"),N.innerHTML=Mn,st=o(),R=a("p"),R.textContent=Jn,ot=o(),X=a("p"),X.innerHTML=vn,lt=o(),$=a("p"),$.innerHTML=xn,at=o(),d(Q.$$.fragment),it=o(),d(z.$$.fragment),rt=o(),P=a("p"),P.textContent=Zn,pt=o(),d(S.$$.fragment),dt=o(),E=a("p"),E.textContent=jn,ct=o(),Y=a("ul"),Y.innerHTML=Un,mt=o(),F=a("p"),F.textContent=In,ht=o(),d(H.$$.fragment),ut=o(),d(L.$$.fragment),ft=o(),D=a("p"),D.textContent=Wn,yt=o(),je=a("ol"),q=a("li"),Ue=a("p"),Ue.textContent=Cn,Ft=o(),d(A.$$.fragment),gt=o(),J=a("ol"),v=a("li"),Ie=a("p"),Ie.textContent=kn,Ht=o(),d(K.$$.fragment),Lt=o(),We=a("p"),We.innerHTML=Bn,Dt=o(),O=a("li"),Ce=a("p"),Ce.innerHTML=Vn,qt=o(),d(ee.$$.fragment),_t=o(),d(te.$$.fragment),Tt=o(),ne=a("p"),ne.innerHTML=Gn,bt=o(),d(se.$$.fragment),wt=o(),oe=a("p"),oe.innerHTML=Nn,Mt=o(),b=a("ol"),le=a("li"),ke=a("p"),ke.textContent=Rn,At=o(),d(ae.$$.fragment),Kt=o(),ie=a("li"),Be=a("p"),Be.textContent=Xn,Ot=o(),d(re.$$.fragment),en=o(),pe=a("li"),Ve=a("p"),Ve.innerHTML=$n,tn=o(),d(de.$$.fragment),Jt=o(),d(ce.$$.fragment),vt=o(),me=a("p"),me.innerHTML=Qn,xt=o(),w=a("ol"),he=a("li"),Ge=a("p"),Ge.textContent=zn,nn=o(),d(ue.$$.fragment),sn=o(),fe=a("li"),Ne=a("p"),Ne.textContent=Pn,on=o(),d(ye.$$.fragment),ln=o(),ge=a("li"),Re=a("p"),Re.innerHTML=Sn,an=o(),d(_e.$$.fragment),Zt=o(),Te=a("p"),Te.innerHTML=En,jt=o(),d(be.$$.fragment),Ut=o(),g=a("div"),d(we.$$.fragment),rn=o(),Xe=a("p"),Xe.textContent=Yn,pn=o(),$e=a("p"),$e.innerHTML=Fn,dn=o(),j=a("div"),d(Me.$$.fragment),cn=o(),Qe=a("p"),Qe.textContent=Hn,mn=o(),U=a("div"),d(Je.$$.fragment),hn=o(),ze=a("p"),ze.textContent=Ln,un=o(),I=a("div"),d(ve.$$.fragment),fn=o(),Pe=a("p"),Pe.textContent=Dn,It=o(),d(xe.$$.fragment),Wt=o(),x=a("div"),d(Ze.$$.fragment),yn=o(),Se=a("p"),Se.textContent=qn,Ct=o(),Le=a("p"),this.h()},l(e){const n=ss("svelte-u9bgzb",document.head);M=i(n,"META",{name:!0,content:!0}),n.forEach(t),qe=l(e),He=i(e,"P",{}),y(He).forEach(t),Ae=l(e),c(C.$$.fragment,e),Ke=l(e),k=i(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1i4o66x"&&(k.innerHTML=_n),Oe=l(e),B=i(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1jaz0ks"&&(B.textContent=Tn),et=l(e),V=i(e,"OL",{"data-svelte-h":!0}),p(V)!=="svelte-19ca1wn"&&(V.innerHTML=bn),tt=l(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-yhxhyq"&&(G.textContent=wn),nt=l(e),N=i(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-uupw0l"&&(N.innerHTML=Mn),st=l(e),R=i(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1cwsb16"&&(R.textContent=Jn),ot=l(e),X=i(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1rtg145"&&(X.innerHTML=vn),lt=l(e),$=i(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1srzz2a"&&($.innerHTML=xn),at=l(e),c(Q.$$.fragment,e),it=l(e),c(z.$$.fragment,e),rt=l(e),P=i(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-wgi2jy"&&(P.textContent=Zn),pt=l(e),c(S.$$.fragment,e),dt=l(e),E=i(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-rs2kss"&&(E.textContent=jn),ct=l(e),Y=i(e,"UL",{"data-svelte-h":!0}),p(Y)!=="svelte-1na1mhs"&&(Y.innerHTML=Un),mt=l(e),F=i(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-11lsc56"&&(F.textContent=In),ht=l(e),c(H.$$.fragment,e),ut=l(e),c(L.$$.fragment,e),ft=l(e),D=i(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-13nlg5v"&&(D.textContent=Wn),yt=l(e),je=i(e,"OL",{});var An=y(je);q=i(An,"LI",{});var Bt=y(q);Ue=i(Bt,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1xo2nq1"&&(Ue.textContent=Cn),Ft=l(Bt),c(A.$$.fragment,Bt),Bt.forEach(t),An.forEach(t),gt=l(e),J=i(e,"OL",{start:!0});var Vt=y(J);v=i(Vt,"LI",{});var Ee=y(v);Ie=i(Ee,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-7pm43o"&&(Ie.textContent=kn),Ht=l(Ee),c(K.$$.fragment,Ee),Lt=l(Ee),We=i(Ee,"P",{"data-svelte-h":!0}),p(We)!=="svelte-12c412i"&&(We.innerHTML=Bn),Ee.forEach(t),Dt=l(Vt),O=i(Vt,"LI",{});var Gt=y(O);Ce=i(Gt,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-1wsv5bt"&&(Ce.innerHTML=Vn),qt=l(Gt),c(ee.$$.fragment,Gt),Gt.forEach(t),Vt.forEach(t),_t=l(e),c(te.$$.fragment,e),Tt=l(e),ne=i(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-5jt7ll"&&(ne.innerHTML=Gn),bt=l(e),c(se.$$.fragment,e),wt=l(e),oe=i(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1hftviu"&&(oe.innerHTML=Nn),Mt=l(e),b=i(e,"OL",{});var Ye=y(b);le=i(Ye,"LI",{});var Nt=y(le);ke=i(Nt,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-1xo2nq1"&&(ke.textContent=Rn),At=l(Nt),c(ae.$$.fragment,Nt),Nt.forEach(t),Kt=l(Ye),ie=i(Ye,"LI",{});var Rt=y(ie);Be=i(Rt,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-1wln6n0"&&(Be.textContent=Xn),Ot=l(Rt),c(re.$$.fragment,Rt),Rt.forEach(t),en=l(Ye),pe=i(Ye,"LI",{});var Xt=y(pe);Ve=i(Xt,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-14jy04z"&&(Ve.innerHTML=$n),tn=l(Xt),c(de.$$.fragment,Xt),Xt.forEach(t),Ye.forEach(t),Jt=l(e),c(ce.$$.fragment,e),vt=l(e),me=i(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-qyrti8"&&(me.innerHTML=Qn),xt=l(e),w=i(e,"OL",{});var Fe=y(w);he=i(Fe,"LI",{});var $t=y(he);Ge=i($t,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-1xo2nq1"&&(Ge.textContent=zn),nn=l($t),c(ue.$$.fragment,$t),$t.forEach(t),sn=l(Fe),fe=i(Fe,"LI",{});var Qt=y(fe);Ne=i(Qt,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-1wln6n0"&&(Ne.textContent=Pn),on=l(Qt),c(ye.$$.fragment,Qt),Qt.forEach(t),ln=l(Fe),ge=i(Fe,"LI",{});var zt=y(ge);Re=i(zt,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-okpmrc"&&(Re.innerHTML=Sn),an=l(zt),c(_e.$$.fragment,zt),zt.forEach(t),Fe.forEach(t),Zt=l(e),Te=i(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-18tnclt"&&(Te.innerHTML=En),jt=l(e),c(be.$$.fragment,e),Ut=l(e),g=i(e,"DIV",{class:!0});var _=y(g);c(we.$$.fragment,_),rn=l(_),Xe=i(_,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-1q57293"&&(Xe.textContent=Yn),pn=l(_),$e=i(_,"P",{"data-svelte-h":!0}),p($e)!=="svelte-1loa8p0"&&($e.innerHTML=Fn),dn=l(_),j=i(_,"DIV",{class:!0});var Pt=y(j);c(Me.$$.fragment,Pt),cn=l(Pt),Qe=i(Pt,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-50j04k"&&(Qe.textContent=Hn),Pt.forEach(t),mn=l(_),U=i(_,"DIV",{class:!0});var St=y(U);c(Je.$$.fragment,St),hn=l(St),ze=i(St,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-1cxzr1t"&&(ze.textContent=Ln),St.forEach(t),un=l(_),I=i(_,"DIV",{class:!0});var Et=y(I);c(ve.$$.fragment,Et),fn=l(Et),Pe=i(Et,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-1d8vbe1"&&(Pe.textContent=Dn),Et.forEach(t),_.forEach(t),It=l(e),c(xe.$$.fragment,e),Wt=l(e),x=i(e,"DIV",{class:!0});var Yt=y(x);c(Ze.$$.fragment,Yt),yn=l(Yt),Se=i(Yt,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-1dgz4ei"&&(Se.textContent=qn),Yt.forEach(t),Ct=l(e),Le=i(e,"P",{}),y(Le).forEach(t),this.h()},h(){W(M,"name","hf:doc:metadata"),W(M,"content",ls),W(J,"start","2"),W(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){r(document.head,M),s(e,qe,n),s(e,He,n),s(e,Ae,n),m(C,e,n),s(e,Ke,n),s(e,k,n),s(e,Oe,n),s(e,B,n),s(e,et,n),s(e,V,n),s(e,tt,n),s(e,G,n),s(e,nt,n),s(e,N,n),s(e,st,n),s(e,R,n),s(e,ot,n),s(e,X,n),s(e,lt,n),s(e,$,n),s(e,at,n),m(Q,e,n),s(e,it,n),m(z,e,n),s(e,rt,n),s(e,P,n),s(e,pt,n),m(S,e,n),s(e,dt,n),s(e,E,n),s(e,ct,n),s(e,Y,n),s(e,mt,n),s(e,F,n),s(e,ht,n),m(H,e,n),s(e,ut,n),m(L,e,n),s(e,ft,n),s(e,D,n),s(e,yt,n),s(e,je,n),r(je,q),r(q,Ue),r(q,Ft),m(A,q,null),s(e,gt,n),s(e,J,n),r(J,v),r(v,Ie),r(v,Ht),m(K,v,null),r(v,Lt),r(v,We),r(J,Dt),r(J,O),r(O,Ce),r(O,qt),m(ee,O,null),s(e,_t,n),m(te,e,n),s(e,Tt,n),s(e,ne,n),s(e,bt,n),m(se,e,n),s(e,wt,n),s(e,oe,n),s(e,Mt,n),s(e,b,n),r(b,le),r(le,ke),r(le,At),m(ae,le,null),r(b,Kt),r(b,ie),r(ie,Be),r(ie,Ot),m(re,ie,null),r(b,en),r(b,pe),r(pe,Ve),r(pe,tn),m(de,pe,null),s(e,Jt,n),m(ce,e,n),s(e,vt,n),s(e,me,n),s(e,xt,n),s(e,w,n),r(w,he),r(he,Ge),r(he,nn),m(ue,he,null),r(w,sn),r(w,fe),r(fe,Ne),r(fe,on),m(ye,fe,null),r(w,ln),r(w,ge),r(ge,Re),r(ge,an),m(_e,ge,null),s(e,Zt,n),s(e,Te,n),s(e,jt,n),m(be,e,n),s(e,Ut,n),s(e,g,n),m(we,g,null),r(g,rn),r(g,Xe),r(g,pn),r(g,$e),r(g,dn),r(g,j),m(Me,j,null),r(j,cn),r(j,Qe),r(g,mn),r(g,U),m(Je,U,null),r(U,hn),r(U,ze),r(g,un),r(g,I),m(ve,I,null),r(I,fn),r(I,Pe),s(e,It,n),m(xe,e,n),s(e,Wt,n),s(e,x,n),m(Ze,x,null),r(x,yn),r(x,Se),s(e,Ct,n),s(e,Le,n),kt=!0},p:On,i(e){kt||(h(C.$$.fragment,e),h(Q.$$.fragment,e),h(z.$$.fragment,e),h(S.$$.fragment,e),h(H.$$.fragment,e),h(L.$$.fragment,e),h(A.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(se.$$.fragment,e),h(ae.$$.fragment,e),h(re.$$.fragment,e),h(de.$$.fragment,e),h(ce.$$.fragment,e),h(ue.$$.fragment,e),h(ye.$$.fragment,e),h(_e.$$.fragment,e),h(be.$$.fragment,e),h(we.$$.fragment,e),h(Me.$$.fragment,e),h(Je.$$.fragment,e),h(ve.$$.fragment,e),h(xe.$$.fragment,e),h(Ze.$$.fragment,e),kt=!0)},o(e){u(C.$$.fragment,e),u(Q.$$.fragment,e),u(z.$$.fragment,e),u(S.$$.fragment,e),u(H.$$.fragment,e),u(L.$$.fragment,e),u(A.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(se.$$.fragment,e),u(ae.$$.fragment,e),u(re.$$.fragment,e),u(de.$$.fragment,e),u(ce.$$.fragment,e),u(ue.$$.fragment,e),u(ye.$$.fragment,e),u(_e.$$.fragment,e),u(be.$$.fragment,e),u(we.$$.fragment,e),u(Me.$$.fragment,e),u(Je.$$.fragment,e),u(ve.$$.fragment,e),u(xe.$$.fragment,e),u(Ze.$$.fragment,e),kt=!1},d(e){e&&(t(qe),t(He),t(Ae),t(Ke),t(k),t(Oe),t(B),t(et),t(V),t(tt),t(G),t(nt),t(N),t(st),t(R),t(ot),t(X),t(lt),t($),t(at),t(it),t(rt),t(P),t(pt),t(dt),t(E),t(ct),t(Y),t(mt),t(F),t(ht),t(ut),t(ft),t(D),t(yt),t(je),t(gt),t(J),t(_t),t(Tt),t(ne),t(bt),t(wt),t(oe),t(Mt),t(b),t(Jt),t(vt),t(me),t(xt),t(w),t(Zt),t(Te),t(jt),t(Ut),t(g),t(It),t(Wt),t(x),t(Ct),t(Le)),t(M),f(C,e),f(Q,e),f(z,e),f(S,e),f(H,e),f(L,e),f(A),f(K),f(ee),f(te,e),f(se,e),f(ae),f(re),f(de),f(ce,e),f(ue),f(ye),f(_e),f(be,e),f(we),f(Me),f(Je),f(ve),f(xe,e),f(Ze)}}}const ls='{"title":"Text2Video-Zero","local":"text2video-zero","sections":[{"title":"Usage example","local":"usage-example","sections":[{"title":"Text-To-Video","local":"text-to-video","sections":[],"depth":3},{"title":"Text-To-Video with Pose Control","local":"text-to-video-with-pose-control","sections":[],"depth":3},{"title":"Text-To-Video with Edge Control","local":"text-to-video-with-edge-control","sections":[],"depth":3},{"title":"Video Instruct-Pix2Pix","local":"video-instruct-pix2pix","sections":[],"depth":3},{"title":"DreamBooth specialization","local":"dreambooth-specialization","sections":[],"depth":3}],"depth":2},{"title":"TextToVideoZeroPipeline","local":"diffusers.TextToVideoZeroPipeline","sections":[],"depth":2},{"title":"TextToVideoPipelineOutput","local":"diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.TextToVideoPipelineOutput","sections":[],"depth":2}],"depth":1}';function as(gn){return es(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ms extends ts{constructor(M){super(),ns(this,M,as,os,Kn,{})}}export{ms as component};
