import{s as Zi,o as ki,n as Ft}from"../chunks/scheduler.8c3d61f6.js";import{S as $i,i as Wi,g as r,s as n,r as m,A as Gi,h as l,f as t,c as i,j as M,u as g,x as p,k as w,y as s,a,v as u,d as f,t as h,w as _}from"../chunks/index.da70eac4.js";import{T as Pi}from"../chunks/Tip.1d9b8c37.js";import{D as V}from"../chunks/Docstring.fa488882.js";import{C as N}from"../chunks/CodeBlock.a9c4becf.js";import{E as Lo}from"../chunks/ExampleCodeBlock.ec9feb8f.js";import{H as F,E as Bi}from"../chunks/index.dfbaf638.js";function Ni($){let c,C='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){c=r("p"),c.innerHTML=C},l(y){c=l(y,"P",{"data-svelte-h":!0}),p(c)!=="svelte-1qn15hi"&&(c.innerHTML=C)},m(y,b){a(y,c,b)},p:Ft,d(y){y&&t(c)}}}function Ri($){let c,C="Examples:",y,b,v;return b=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29nVmlkZW9YUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBJTIzJTIwTW9kZWxzJTNBJTIwJTIyVEhVRE0lMkZDb2dWaWRlb1gtMmIlMjIlMjBvciUyMCUyMlRIVURNJTJGQ29nVmlkZW9YLTViJTIyJTBBcGlwZSUyMCUzRCUyMENvZ1ZpZGVvWFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJUSFVETSUyRkNvZ1ZpZGVvWC0yYiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEFwcm9tcHQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIyQSUyMHBhbmRhJTJDJTIwZHJlc3NlZCUyMGluJTIwYSUyMHNtYWxsJTJDJTIwcmVkJTIwamFja2V0JTIwYW5kJTIwYSUyMHRpbnklMjBoYXQlMkMlMjBzaXRzJTIwb24lMjBhJTIwd29vZGVuJTIwc3Rvb2wlMjBpbiUyMGElMjBzZXJlbmUlMjBiYW1ib28lMjBmb3Jlc3QuJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIyVGhlJTIwcGFuZGEncyUyMGZsdWZmeSUyMHBhd3MlMjBzdHJ1bSUyMGElMjBtaW5pYXR1cmUlMjBhY291c3RpYyUyMGd1aXRhciUyQyUyMHByb2R1Y2luZyUyMHNvZnQlMkMlMjBtZWxvZGljJTIwdHVuZXMuJTIwTmVhcmJ5JTJDJTIwYSUyMGZldyUyMG90aGVyJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIycGFuZGFzJTIwZ2F0aGVyJTJDJTIwd2F0Y2hpbmclMjBjdXJpb3VzbHklMjBhbmQlMjBzb21lJTIwY2xhcHBpbmclMjBpbiUyMHJoeXRobS4lMjBTdW5saWdodCUyMGZpbHRlcnMlMjB0aHJvdWdoJTIwdGhlJTIwdGFsbCUyMGJhbWJvbyUyQyUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMmNhc3RpbmclMjBhJTIwZ2VudGxlJTIwZ2xvdyUyMG9uJTIwdGhlJTIwc2NlbmUuJTIwVGhlJTIwcGFuZGEncyUyMGZhY2UlMjBpcyUyMGV4cHJlc3NpdmUlMkMlMjBzaG93aW5nJTIwY29uY2VudHJhdGlvbiUyMGFuZCUyMGpveSUyMGFzJTIwaXQlMjBwbGF5cy4lMjAlMjIlMEElMjAlMjAlMjAlMjAlMjJUaGUlMjBiYWNrZ3JvdW5kJTIwaW5jbHVkZXMlMjBhJTIwc21hbGwlMkMlMjBmbG93aW5nJTIwc3RyZWFtJTIwYW5kJTIwdmlicmFudCUyMGdyZWVuJTIwZm9saWFnZSUyQyUyMGVuaGFuY2luZyUyMHRoZSUyMHBlYWNlZnVsJTIwYW5kJTIwbWFnaWNhbCUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMmF0bW9zcGhlcmUlMjBvZiUyMHRoaXMlMjB1bmlxdWUlMjBtdXNpY2FsJTIwcGVyZm9ybWFuY2UuJTIyJTBBKSUwQXZpZGVvJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDYlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fdmlkZW8odmlkZW8lMkMlMjAlMjJvdXRwdXQubXA0JTIyJTJDJTIwZnBzJTNEOCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Models: &quot;THUDM/CogVideoX-2b&quot; or &quot;THUDM/CogVideoX-5b&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = CogVideoXPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-2b&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A panda, dressed in a small, red jacket and a tiny hat, sits on a wooden stool in a serene bamboo forest. &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The panda&#x27;s fluffy paws strum a miniature acoustic guitar, producing soft, melodic tunes. Nearby, a few other &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;pandas gather, watching curiously and some clapping in rhythm. Sunlight filters through the tall bamboo, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;casting a gentle glow on the scene. The panda&#x27;s face is expressive, showing concentration and joy as it plays. &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The background includes a small, flowing stream and vibrant green foliage, enhancing the peaceful and magical &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;atmosphere of this unique musical performance.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(prompt=prompt, guidance_scale=<span class="hljs-number">6</span>, num_inference_steps=<span class="hljs-number">50</span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){c=r("p"),c.textContent=C,y=n(),m(b.$$.fragment)},l(d){c=l(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=C),y=i(d),g(b.$$.fragment,d)},m(d,T){a(d,c,T),a(d,y,T),u(b,d,T),v=!0},p:Ft,i(d){v||(f(b.$$.fragment,d),v=!0)},o(d){h(b.$$.fragment,d),v=!1},d(d){d&&(t(c),t(y)),_(b,d)}}}function Hi($){let c,C="Examples:",y,b,v;return b=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29nVmlkZW9YSW1hZ2VUb1ZpZGVvUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGUlMjAlM0QlMjBDb2dWaWRlb1hJbWFnZVRvVmlkZW9QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyVEhVRE0lMkZDb2dWaWRlb1gtNWItSTJWJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQW4lMjBhc3Ryb25hdXQlMjBoYXRjaGluZyUyMGZyb20lMjBhbiUyMGVnZyUyQyUyMG9uJTIwdGhlJTIwc3VyZmFjZSUyMG9mJTIwdGhlJTIwbW9vbiUyQyUyMHRoZSUyMGRhcmtuZXNzJTIwYW5kJTIwZGVwdGglMjBvZiUyMHNwYWNlJTIwcmVhbGlzZWQlMjBpbiUyMHRoZSUyMGJhY2tncm91bmQuJTIwSGlnaCUyMHF1YWxpdHklMkMlMjB1bHRyYXJlYWxpc3RpYyUyMGRldGFpbCUyMGFuZCUyMGJyZWF0aC10YWtpbmclMjBtb3ZpZS1saWtlJTIwY2FtZXJhJTIwc2hvdC4lMjIlMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGYXN0cm9uYXV0LmpwZyUyMiUwQSklMEF2aWRlbyUyMCUzRCUyMHBpcGUoaW1hZ2UlMkMlMjBwcm9tcHQlMkMlMjB1c2VfZHluYW1pY19jZmclM0RUcnVlKSUwQWV4cG9ydF90b192aWRlbyh2aWRlby5mcmFtZXMlNUIwJTVEJTJDJTIwJTIyb3V0cHV0Lm1wNCUyMiUyQyUyMGZwcyUzRDgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXImageToVideoPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = CogVideoXImageToVideoPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-5b-I2V&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;An astronaut hatching from an egg, on the surface of the moon, the darkness and depth of space realised in the background. High quality, ultrarealistic detail and breath-taking movie-like camera shot.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/astronaut.jpg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(image, prompt, use_dynamic_cfg=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video.frames[<span class="hljs-number">0</span>], <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){c=r("p"),c.textContent=C,y=n(),m(b.$$.fragment)},l(d){c=l(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=C),y=i(d),g(b.$$.fragment,d)},m(d,T){a(d,c,T),a(d,y,T),u(b,d,T),v=!0},p:Ft,i(d){v||(f(b.$$.fragment,d),v=!0)},o(d){h(b.$$.fragment,d),v=!1},d(d){d&&(t(c),t(y)),_(b,d)}}}function Fi($){let c,C="Examples:",y,b,v;return b=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29nVmlkZW9YRFBNU2NoZWR1bGVyJTJDJTIwQ29nVmlkZW9YVmlkZW9Ub1ZpZGVvUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTJDJTIwbG9hZF92aWRlbyUwQSUwQSUyMyUyME1vZGVscyUzQSUyMCUyMlRIVURNJTJGQ29nVmlkZW9YLTJiJTIyJTIwb3IlMjAlMjJUSFVETSUyRkNvZ1ZpZGVvWC01YiUyMiUwQXBpcGUlMjAlM0QlMjBDb2dWaWRlb1hWaWRlb1RvVmlkZW9QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyVEhVRE0lMkZDb2dWaWRlb1gtNWIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMENvZ1ZpZGVvWERQTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBJTBBaW5wdXRfdmlkZW8lMjAlM0QlMjBsb2FkX3ZpZGVvKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmhpa2VyLm1wNCUyMiUwQSklMEFwcm9tcHQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIyQW4lMjBhc3Ryb25hdXQlMjBzdGFuZHMlMjB0cml1bXBoYW50bHklMjBhdCUyMHRoZSUyMHBlYWslMjBvZiUyMGElMjB0b3dlcmluZyUyMG1vdW50YWluLiUyMFBhbm9yYW1hJTIwb2YlMjBydWdnZWQlMjBwZWFrcyUyMGFuZCUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMnZhbGxleXMuJTIwVmVyeSUyMGZ1dHVyaXN0aWMlMjB2aWJlJTIwYW5kJTIwYW5pbWF0ZWQlMjBhZXN0aGV0aWMuJTIwSGlnaGxpZ2h0cyUyMG9mJTIwcHVycGxlJTIwYW5kJTIwZ29sZGVuJTIwY29sb3JzJTIwaW4lMjAlMjIlMEElMjAlMjAlMjAlMjAlMjJ0aGUlMjBzY2VuZS4lMjBUaGUlMjBza3klMjBpcyUyMGxvb2tzJTIwbGlrZSUyMGFuJTIwYW5pbWF0ZWQlMkZjYXJ0b29uaXNoJTIwZHJlYW0lMjBvZiUyMGdhbGF4aWVzJTJDJTIwbmVidWxhZSUyQyUyMHN0YXJzJTJDJTIwcGxhbmV0cyUyQyUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMm1vb25zJTJDJTIwYnV0JTIwdGhlJTIwcmVtYWluZGVyJTIwb2YlMjB0aGUlMjBzY2VuZSUyMGlzJTIwbW9zdGx5JTIwcmVhbGlzdGljLiUyMiUwQSklMEElMEF2aWRlbyUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwdmlkZW8lM0RpbnB1dF92aWRlbyUyQyUyMHByb21wdCUzRHByb21wdCUyQyUyMHN0cmVuZ3RoJTNEMC44JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q2JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTBBKS5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX3ZpZGVvKHZpZGVvJTJDJTIwJTIyb3V0cHV0Lm1wNCUyMiUyQyUyMGZwcyUzRDgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXDPMScheduler, CogVideoXVideoToVideoPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_video

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Models: &quot;THUDM/CogVideoX-2b&quot; or &quot;THUDM/CogVideoX-5b&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = CogVideoXVideoToVideoPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-5b&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = CogVideoXDPMScheduler.from_config(pipe.scheduler.config)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_video = load_video(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/hiker.mp4&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut stands triumphantly at the peak of a towering mountain. Panorama of rugged peaks and &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;valleys. Very futuristic vibe and animated aesthetic. Highlights of purple and golden colors in &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;the scene. The sky is looks like an animated/cartoonish dream of galaxies, nebulae, stars, planets, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;moons, but the remainder of the scene is mostly realistic.&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(
<span class="hljs-meta">... </span>    video=input_video, prompt=prompt, strength=<span class="hljs-number">0.8</span>, guidance_scale=<span class="hljs-number">6</span>, num_inference_steps=<span class="hljs-number">50</span>
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){c=r("p"),c.textContent=C,y=n(),m(b.$$.fragment)},l(d){c=l(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=C),y=i(d),g(b.$$.fragment,d)},m(d,T){a(d,c,T),a(d,y,T),u(b,d,T),v=!0},p:Ft,i(d){v||(f(b.$$.fragment,d),v=!0)},o(d){h(b.$$.fragment,d),v=!1},d(d){d&&(t(c),t(y)),_(b,d)}}}function Yi($){let c,C="Examples:",y,b,v;return b=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29nVmlkZW9YRnVuQ29udHJvbFBpcGVsaW5lJTJDJTIwRERJTVNjaGVkdWxlciUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fdmlkZW8lMkMlMjBsb2FkX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMENvZ1ZpZGVvWEZ1bkNvbnRyb2xQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYWxpYmFiYS1wYWklMkZDb2dWaWRlb1gtRnVuLVYxLjEtNWItUG9zZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBY29udHJvbF92aWRlbyUyMCUzRCUyMGxvYWRfdmlkZW8oJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaGlrZXIubXA0JTIyJTBBKSUwQXByb21wdCUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjJBbiUyMGFzdHJvbmF1dCUyMHN0YW5kcyUyMHRyaXVtcGhhbnRseSUyMGF0JTIwdGhlJTIwcGVhayUyMG9mJTIwYSUyMHRvd2VyaW5nJTIwbW91bnRhaW4uJTIwUGFub3JhbWElMjBvZiUyMHJ1Z2dlZCUyMHBlYWtzJTIwYW5kJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIydmFsbGV5cy4lMjBWZXJ5JTIwZnV0dXJpc3RpYyUyMHZpYmUlMjBhbmQlMjBhbmltYXRlZCUyMGFlc3RoZXRpYy4lMjBIaWdobGlnaHRzJTIwb2YlMjBwdXJwbGUlMjBhbmQlMjBnb2xkZW4lMjBjb2xvcnMlMjBpbiUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMnRoZSUyMHNjZW5lLiUyMFRoZSUyMHNreSUyMGlzJTIwbG9va3MlMjBsaWtlJTIwYW4lMjBhbmltYXRlZCUyRmNhcnRvb25pc2glMjBkcmVhbSUyMG9mJTIwZ2FsYXhpZXMlMkMlMjBuZWJ1bGFlJTJDJTIwc3RhcnMlMkMlMjBwbGFuZXRzJTJDJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIybW9vbnMlMkMlMjBidXQlMjB0aGUlMjByZW1haW5kZXIlMjBvZiUyMHRoZSUyMHNjZW5lJTIwaXMlMjBtb3N0bHklMjByZWFsaXN0aWMuJTIyJTBBKSUwQSUwQXZpZGVvJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBjb250cm9sX3ZpZGVvJTNEY29udHJvbF92aWRlbykuZnJhbWVzJTVCMCU1RCUwQWV4cG9ydF90b192aWRlbyh2aWRlbyUyQyUyMCUyMm91dHB1dC5tcDQlMjIlMkMlMjBmcHMlM0Q4KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXFunControlPipeline, DDIMScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_video

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = CogVideoXFunControlPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;alibaba-pai/CogVideoX-Fun-V1.1-5b-Pose&quot;</span>, torch_dtype=torch.bfloat16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = DDIMScheduler.from_config(pipe.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>control_video = load_video(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/hiker.mp4&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut stands triumphantly at the peak of a towering mountain. Panorama of rugged peaks and &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;valleys. Very futuristic vibe and animated aesthetic. Highlights of purple and golden colors in &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;the scene. The sky is looks like an animated/cartoonish dream of galaxies, nebulae, stars, planets, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;moons, but the remainder of the scene is mostly realistic.&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(prompt=prompt, control_video=control_video).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){c=r("p"),c.textContent=C,y=n(),m(b.$$.fragment)},l(d){c=l(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=C),y=i(d),g(b.$$.fragment,d)},m(d,T){a(d,c,T),a(d,y,T),u(b,d,T),v=!0},p:Ft,i(d){v||(f(b.$$.fragment,d),v=!0)},o(d){h(b.$$.fragment,d),v=!1},d(d){d&&(t(c),t(y)),_(b,d)}}}function zi($){let c,C,y,b,v,d,T,Bn='<img alt="LoRA" src="https://img.shields.io/badge/LoRA-d8b4fe?style=flat"/>',Yt,ae,Nn='<a href="https://arxiv.org/abs/2408.06072" rel="nofollow">CogVideoX: Text-to-Video Diffusion Models with An Expert Transformer</a> from Tsinghua University &amp; ZhipuAI, by Zhuoyi Yang, Jiayan Teng, Wendi Zheng, Ming Ding, Shiyu Huang, Jiazheng Xu, Yuanming Yang, Wenyi Hong, Xiaohan Zhang, Guanyu Feng, Da Yin, Xiaotao Gu, Yuxuan Zhang, Weihan Wang, Yean Cheng, Ting Liu, Bin Xu, Yuxiao Dong, Jie Tang.',zt,re,Rn="The abstract from the paper is:",Lt,le,Hn='<em>We introduce CogVideoX, a large-scale diffusion transformer model designed for generating videos based on text prompts. To efficently model video data, we propose to levearge a 3D Variational Autoencoder (VAE) to compresses videos along both spatial and temporal dimensions. To improve the text-video alignment, we propose an expert transformer with the expert adaptive LayerNorm to facilitate the deep fusion between the two modalities. By employing a progressive training technique, CogVideoX is adept at producing coherent, long-duration videos characterized by significant motion. In addition, we develop an effectively text-video data processing pipeline that includes various data preprocessing strategies and a video captioning method. It significantly helps enhance the performance of CogVideoX, improving both generation quality and semantic alignment. Results show that CogVideoX demonstrates state-of-the-art performance across both multiple machine metrics and human evaluations. The model weight of CogVideoX-2B is publicly available at <a href="https://github.com/THUDM/CogVideo" rel="nofollow">https://github.com/THUDM/CogVideo</a>.</em>',Dt,Y,qt,de,Fn='This pipeline was contributed by <a href="https://github.com/zRzRzRzRzRzRzR" rel="nofollow">zRzRzRzRzRzRzR</a>. The original codebase can be found <a href="https://huggingface.co/THUDM" rel="nofollow">here</a>. The original weights can be found under <a href="https://huggingface.co/THUDM" rel="nofollow">hf.co/THUDM</a>.',Et,pe,Yn="There are three official CogVideoX checkpoints for text-to-video and video-to-video.",Qt,ce,zn='<thead><tr><th align="center">checkpoints</th> <th align="center">recommended inference dtype</th></tr></thead> <tbody><tr><td align="center"><a href="https://huggingface.co/THUDM/CogVideoX-2b" rel="nofollow"><code>THUDM/CogVideoX-2b</code></a></td> <td align="center">torch.float16</td></tr> <tr><td align="center"><a href="https://huggingface.co/THUDM/CogVideoX-5b" rel="nofollow"><code>THUDM/CogVideoX-5b</code></a></td> <td align="center">torch.bfloat16</td></tr> <tr><td align="center"><a href="https://huggingface.co/THUDM/CogVideoX1.5-5b" rel="nofollow"><code>THUDM/CogVideoX1.5-5b</code></a></td> <td align="center">torch.bfloat16</td></tr></tbody>',St,me,Ln="There are two official CogVideoX checkpoints available for image-to-video.",At,ge,Dn='<thead><tr><th align="center">checkpoints</th> <th align="center">recommended inference dtype</th></tr></thead> <tbody><tr><td align="center"><a href="https://huggingface.co/THUDM/CogVideoX-5b-I2V" rel="nofollow"><code>THUDM/CogVideoX-5b-I2V</code></a></td> <td align="center">torch.bfloat16</td></tr> <tr><td align="center"><a href="https://huggingface.co/THUDM/CogVideoX-1.5-5b-I2V" rel="nofollow"><code>THUDM/CogVideoX-1.5-5b-I2V</code></a></td> <td align="center">torch.bfloat16</td></tr></tbody>',Ot,ue,qn="For the CogVideoX 1.5 series:",Kt,fe,En="<li>Text-to-video (T2V) works best at a resolution of 1360x768 because it was trained with that specific resolution.</li> <li>Image-to-video (I2V) works for multiple resolutions. The width can vary from 768 to 1360, but the height must be 768. The height/width must be divisible by 16.</li> <li>Both T2V and I2V models support generation with 81 and 161 frames and work best at this value. Exporting videos at 16 FPS is recommended.</li>",eo,he,Qn='There are two official CogVideoX checkpoints that support pose controllable generation (by the <a href="https://huggingface.co/alibaba-pai" rel="nofollow">Alibaba-PAI</a> team).',to,_e,Sn='<thead><tr><th align="center">checkpoints</th> <th align="center">recommended inference dtype</th></tr></thead> <tbody><tr><td align="center"><a href="https://huggingface.co/alibaba-pai/CogVideoX-Fun-V1.1-2b-Pose" rel="nofollow"><code>alibaba-pai/CogVideoX-Fun-V1.1-2b-Pose</code></a></td> <td align="center">torch.bfloat16</td></tr> <tr><td align="center"><a href="https://huggingface.co/alibaba-pai/CogVideoX-Fun-V1.1-5b-Pose" rel="nofollow"><code>alibaba-pai/CogVideoX-Fun-V1.1-5b-Pose</code></a></td> <td align="center">torch.bfloat16</td></tr></tbody>',oo,be,no,ye,An='Use <a href="https://huggingface.co/docs/diffusers/main/en/tutorials/fast_diffusion#torchcompile" rel="nofollow"><code>torch.compile</code></a> to reduce the inference latency.',io,ve,On="First, load the pipeline:",so,Te,ao,we,Kn="If you are using the image-to-video pipeline, load it as follows:",ro,Me,lo,Ve,ei="Then change the memory layout of the pipelines <code>transformer</code> component to <code>torch.channels_last</code>:",po,Ce,co,xe,ti="Compile the components and run inference:",mo,Je,go,Ue,oi='The <a href="https://gist.github.com/a-r-r-o-w/5183d75e452a368fd17448fcc810bd3f" rel="nofollow">T2V benchmark</a> results on an 80GB A100 machine are:',uo,Ie,fo,Xe,ho,je,ni='CogVideoX-2b requires about 19 GB of GPU memory to decode 49 frames (6 seconds of video at 8 FPS) with output resolution 720x480 (W x H), which makes it not possible to run on consumer GPUs or free-tier T4 Colab. The following memory optimizations could be used to reduce the memory footprint. For replication, you can refer to <a href="https://gist.github.com/a-r-r-o-w/3959a03f15be5c9bd1fe545b09dfcc93" rel="nofollow">this</a> script.',_o,Ze,ii="<li><code>pipe.enable_model_cpu_offload()</code>:<ul><li>Without enabling cpu offloading, memory usage is <code>33 GB</code></li> <li>With enabling cpu offloading, memory usage is <code>19 GB</code></li></ul></li> <li><code>pipe.enable_sequential_cpu_offload()</code>:<ul><li>Similar to <code>enable_model_cpu_offload</code> but can significantly reduce memory usage at the cost of slow inference</li> <li>When enabled, memory usage is under <code>4 GB</code></li></ul></li> <li><code>pipe.vae.enable_tiling()</code>:<ul><li>With enabling cpu offloading and tiling, memory usage is <code>11 GB</code></li></ul></li> <li><code>pipe.vae.enable_slicing()</code></li>",bo,ke,yo,$e,si="Quantization helps reduce the memory requirements of very large models by storing model weights in a lower precision data type. However, quantization may have varying impact on video quality depending on the video model.",vo,We,ai='Refer to the <a href="../../quantization/overview">Quantization</a> overview to learn more about supported quantization backends and selecting a quantization backend that supports your use case. The example below demonstrates how to load a quantized <a href="/docs/diffusers/main/en/api/pipelines/cogvideox#diffusers.CogVideoXPipeline">CogVideoXPipeline</a> for inference with bitsandbytes.',To,Ge,wo,Pe,Mo,x,Be,Do,gt,ri="Pipeline for text-to-video generation using CogVideoX.",qo,ut,li=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Eo,W,Ne,Qo,ft,di="Function invoked when calling the pipeline for generation.",So,z,Ao,L,Re,Oo,ht,pi="Encodes the prompt into text encoder hidden states.",Ko,D,He,en,_t,ci="Enables fused QKV projections.",tn,q,Fe,on,bt,mi="Disable QKV projection fusion if enabled.",Vo,Ye,Co,J,ze,nn,yt,gi="Pipeline for image-to-video generation using CogVideoX.",sn,vt,ui=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,an,G,Le,rn,Tt,fi="Function invoked when calling the pipeline for generation.",ln,E,dn,Q,De,pn,wt,hi="Encodes the prompt into text encoder hidden states.",cn,S,qe,mn,Mt,_i="Enables fused QKV projections.",gn,A,Ee,un,Vt,bi="Disable QKV projection fusion if enabled.",xo,Qe,Jo,U,Se,fn,Ct,yi="Pipeline for video-to-video generation using CogVideoX.",hn,xt,vi=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,_n,P,Ae,bn,Jt,Ti="Function invoked when calling the pipeline for generation.",yn,O,vn,K,Oe,Tn,Ut,wi="Encodes the prompt into text encoder hidden states.",wn,ee,Ke,Mn,It,Mi="Enables fused QKV projections.",Vn,te,et,Cn,Xt,Vi="Disable QKV projection fusion if enabled.",Uo,tt,Io,I,ot,xn,jt,Ci="Pipeline for controlled text-to-video generation using CogVideoX Fun.",Jn,Zt,xi=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Un,B,nt,In,kt,Ji="Function invoked when calling the pipeline for generation.",Xn,oe,jn,ne,it,Zn,$t,Ui="Encodes the prompt into text encoder hidden states.",kn,ie,st,$n,Wt,Ii="Enables fused QKV projections.",Wn,se,at,Gn,Gt,Xi="Disable QKV projection fusion if enabled.",Xo,rt,jo,R,lt,Pn,Pt,ji="Output class for CogVideo pipelines.",Zo,dt,ko,Ht,$o;return v=new F({props:{title:"CogVideoX",local:"cogvideox",headingTag:"h1"}}),Y=new Pi({props:{$$slots:{default:[Ni]},$$scope:{ctx:$}}}),be=new F({props:{title:"Inference",local:"inference",headingTag:"h2"}}),Te=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29nVmlkZW9YUGlwZWxpbmUlMkMlMjBDb2dWaWRlb1hJbWFnZVRvVmlkZW9QaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fdmlkZW8lMkNsb2FkX2ltYWdlJTBBcGlwZSUyMCUzRCUyMENvZ1ZpZGVvWFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJUSFVETSUyRkNvZ1ZpZGVvWC01YiUyMikudG8oJTIyY3VkYSUyMiklMjAlMjMlMjBvciUyMCUyMlRIVURNJTJGQ29nVmlkZW9YLTJiJTIyJTIw",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXPipeline, CogVideoXImageToVideoPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video,load_image
pipe = CogVideoXPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-5b&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-comment"># or &quot;THUDM/CogVideoX-2b&quot; </span>`,wrap:!1}}),Me=new N({props:{code:"cGlwZSUyMCUzRCUyMENvZ1ZpZGVvWEltYWdlVG9WaWRlb1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJUSFVETSUyRkNvZ1ZpZGVvWC01Yi1JMlYlMjIpLnRvKCUyMmN1ZGElMjIp",highlighted:'pipe = CogVideoXImageToVideoPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-5b-I2V&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)',wrap:!1}}),Ce=new N({props:{code:"cGlwZS50cmFuc2Zvcm1lci50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCk=",highlighted:"pipe.transformer.to(memory_format=torch.channels_last)",wrap:!1}}),Je=new N({props:{code:"cGlwZS50cmFuc2Zvcm1lciUyMCUzRCUyMHRvcmNoLmNvbXBpbGUocGlwZWxpbmUudHJhbnNmb3JtZXIlMkMlMjBtb2RlJTNEJTIybWF4LWF1dG90dW5lJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEElMEElMjMlMjBDb2dWaWRlb1glMjB3b3JrcyUyMHdlbGwlMjB3aXRoJTIwbG9uZyUyMGFuZCUyMHdlbGwtZGVzY3JpYmVkJTIwcHJvbXB0cyUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBwYW5kYSUyQyUyMGRyZXNzZWQlMjBpbiUyMGElMjBzbWFsbCUyQyUyMHJlZCUyMGphY2tldCUyMGFuZCUyMGElMjB0aW55JTIwaGF0JTJDJTIwc2l0cyUyMG9uJTIwYSUyMHdvb2RlbiUyMHN0b29sJTIwaW4lMjBhJTIwc2VyZW5lJTIwYmFtYm9vJTIwZm9yZXN0LiUyMFRoZSUyMHBhbmRhJ3MlMjBmbHVmZnklMjBwYXdzJTIwc3RydW0lMjBhJTIwbWluaWF0dXJlJTIwYWNvdXN0aWMlMjBndWl0YXIlMkMlMjBwcm9kdWNpbmclMjBzb2Z0JTJDJTIwbWVsb2RpYyUyMHR1bmVzLiUyME5lYXJieSUyQyUyMGElMjBmZXclMjBvdGhlciUyMHBhbmRhcyUyMGdhdGhlciUyQyUyMHdhdGNoaW5nJTIwY3VyaW91c2x5JTIwYW5kJTIwc29tZSUyMGNsYXBwaW5nJTIwaW4lMjByaHl0aG0uJTIwU3VubGlnaHQlMjBmaWx0ZXJzJTIwdGhyb3VnaCUyMHRoZSUyMHRhbGwlMjBiYW1ib28lMkMlMjBjYXN0aW5nJTIwYSUyMGdlbnRsZSUyMGdsb3clMjBvbiUyMHRoZSUyMHNjZW5lLiUyMFRoZSUyMHBhbmRhJ3MlMjBmYWNlJTIwaXMlMjBleHByZXNzaXZlJTJDJTIwc2hvd2luZyUyMGNvbmNlbnRyYXRpb24lMjBhbmQlMjBqb3klMjBhcyUyMGl0JTIwcGxheXMuJTIwVGhlJTIwYmFja2dyb3VuZCUyMGluY2x1ZGVzJTIwYSUyMHNtYWxsJTJDJTIwZmxvd2luZyUyMHN0cmVhbSUyMGFuZCUyMHZpYnJhbnQlMjBncmVlbiUyMGZvbGlhZ2UlMkMlMjBlbmhhbmNpbmclMjB0aGUlMjBwZWFjZWZ1bCUyMGFuZCUyMG1hZ2ljYWwlMjBhdG1vc3BoZXJlJTIwb2YlMjB0aGlzJTIwdW5pcXVlJTIwbXVzaWNhbCUyMHBlcmZvcm1hbmNlLiUyMiUwQXZpZGVvJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDYlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmZyYW1lcyU1QjAlNUQ=",highlighted:`pipe.transformer = torch.<span class="hljs-built_in">compile</span>(pipeline.transformer, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># CogVideoX works well with long and well-described prompts</span>
prompt = <span class="hljs-string">&quot;A panda, dressed in a small, red jacket and a tiny hat, sits on a wooden stool in a serene bamboo forest. The panda&#x27;s fluffy paws strum a miniature acoustic guitar, producing soft, melodic tunes. Nearby, a few other pandas gather, watching curiously and some clapping in rhythm. Sunlight filters through the tall bamboo, casting a gentle glow on the scene. The panda&#x27;s face is expressive, showing concentration and joy as it plays. The background includes a small, flowing stream and vibrant green foliage, enhancing the peaceful and magical atmosphere of this unique musical performance.&quot;</span>
video = pipe(prompt=prompt, guidance_scale=<span class="hljs-number">6</span>, num_inference_steps=<span class="hljs-number">50</span>).frames[<span class="hljs-number">0</span>]`,wrap:!1}}),Ie=new N({props:{code:"V2l0aG91dCUyMHRvcmNoLmNvbXBpbGUoKSUzQSUyMEF2ZXJhZ2UlMjBpbmZlcmVuY2UlMjB0aW1lJTNBJTIwOTYuODklMjBzZWNvbmRzLiUwQVdpdGglMjB0b3JjaC5jb21waWxlKCklM0ElMjBBdmVyYWdlJTIwaW5mZXJlbmNlJTIwdGltZSUzQSUyMDc2LjI3JTIwc2Vjb25kcy4=",highlighted:`<span class="hljs-attribute">Without</span> torch.compile(): Average inference time: <span class="hljs-number">96</span>.<span class="hljs-number">89</span> seconds.
<span class="hljs-attribute">With</span> torch.compile(): Average inference time: <span class="hljs-number">76</span>.<span class="hljs-number">27</span> seconds.`,wrap:!1}}),Xe=new F({props:{title:"Memory optimization",local:"memory-optimization",headingTag:"h3"}}),ke=new F({props:{title:"Quantization",local:"quantization",headingTag:"h2"}}),Ge=new N({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig, CogVideoXTransformer3DModel, CogVideoXPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> BitsAndBytesConfig, T5EncoderModel

quant_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
text_encoder_8bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;THUDM/CogVideoX-2b&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
transformer_8bit = CogVideoXTransformer3DModel.from_pretrained(
    <span class="hljs-string">&quot;THUDM/CogVideoX-2b&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

pipeline = CogVideoXPipeline.from_pretrained(
    <span class="hljs-string">&quot;THUDM/CogVideoX-2b&quot;</span>,
    text_encoder=text_encoder_8bit,
    transformer=transformer_8bit,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>,
)

prompt = <span class="hljs-string">&quot;A detailed wooden toy ship with intricately carved masts and sails is seen gliding smoothly over a plush, blue carpet that mimics the waves of the sea. The ship&#x27;s hull is painted a rich brown, with tiny windows. The carpet, soft and textured, provides a perfect backdrop, resembling an oceanic expanse. Surrounding the ship are various other toys and children&#x27;s items, hinting at a playful environment. The scene captures the innocence and imagination of childhood, with the toy ship&#x27;s journey symbolizing endless adventures in a whimsical, indoor setting.&quot;</span>
video = pipeline(prompt=prompt, guidance_scale=<span class="hljs-number">6</span>, num_inference_steps=<span class="hljs-number">50</span>).frames[<span class="hljs-number">0</span>]
export_to_video(video, <span class="hljs-string">&quot;ship.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),Pe=new F({props:{title:"CogVideoXPipeline",local:"diffusers.CogVideoXPipeline",headingTag:"h2"}}),Be=new V({props:{name:"class diffusers.CogVideoXPipeline",anchor:"diffusers.CogVideoXPipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKLCogVideoX"},{name:"transformer",val:": CogVideoXTransformer3DModel"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim_cogvideox.CogVideoXDDIMScheduler, diffusers.schedulers.scheduling_dpm_cogvideox.CogVideoXDPMScheduler]"}],parametersDescription:[{anchor:"diffusers.CogVideoXPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.CogVideoXPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. CogVideoX uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/PixArt-alpha/PixArt-alpha/tree/main/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.CogVideoXPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.CogVideoXPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/cogvideox_transformer3d#diffusers.CogVideoXTransformer3DModel">CogVideoXTransformer3DModel</a>) &#x2014;
A text conditioned <code>CogVideoXTransformer3DModel</code> to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.CogVideoXPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded video latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L147"}}),Ne=new V({props:{name:"__call__",anchor:"diffusers.CogVideoXPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_frames",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.Optional[typing.List[int]] = None"},{name:"guidance_scale",val:": float = 6"},{name:"use_dynamic_cfg",val:": bool = False"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 226"}],parametersDescription:[{anchor:"diffusers.CogVideoXPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.CogVideoXPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The height in pixels of the generated image. This is set to 480 by default for the best results.`,name:"height"},{anchor:"diffusers.CogVideoXPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The width in pixels of the generated image. This is set to 720 by default for the best results.`,name:"width"},{anchor:"diffusers.CogVideoXPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>48</code>) &#x2014;
Number of frames to generate. Must be divisible by self.vae_scale_factor_temporal. Generated video will
contain 1 extra frame because CogVideoX is conditioned with (num_seconds * fps + 1) frames where
num_seconds is 6 and fps is 8. However, since videos can be saved at any fps, the only condition that
needs to be satisfied is that of divisibility mentioned above.`,name:"num_frames"},{anchor:"diffusers.CogVideoXPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.CogVideoXPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.CogVideoXPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.CogVideoXPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.CogVideoXPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.CogVideoXPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.CogVideoXPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.CogVideoXPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.CogVideoXPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.CogVideoXPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.CogVideoXPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, defaults to <code>226</code>) &#x2014;
Maximum sequence length in encoded prompt. Must be consistent with
<code>self.transformer.config.max_text_seq_length</code> otherwise may lead to poor results.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L505",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> or <code>tuple</code></p>
`}}),z=new Lo({props:{anchor:"diffusers.CogVideoXPipeline.__call__.example",$$slots:{default:[Ri]},$$scope:{ctx:$}}}),Re=new V({props:{name:"encode_prompt",anchor:"diffusers.CogVideoXPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.CogVideoXPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L244"}}),He=new V({props:{name:"fuse_qkv_projections",anchor:"diffusers.CogVideoXPipeline.fuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L428"}}),Fe=new V({props:{name:"unfuse_qkv_projections",anchor:"diffusers.CogVideoXPipeline.unfuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L433"}}),Ye=new F({props:{title:"CogVideoXImageToVideoPipeline",local:"diffusers.CogVideoXImageToVideoPipeline",headingTag:"h2"}}),ze=new V({props:{name:"class diffusers.CogVideoXImageToVideoPipeline",anchor:"diffusers.CogVideoXImageToVideoPipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKLCogVideoX"},{name:"transformer",val:": CogVideoXTransformer3DModel"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim_cogvideox.CogVideoXDDIMScheduler, diffusers.schedulers.scheduling_dpm_cogvideox.CogVideoXDPMScheduler]"}],parametersDescription:[{anchor:"diffusers.CogVideoXImageToVideoPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. CogVideoX uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/PixArt-alpha/PixArt-alpha/tree/main/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/cogvideox_transformer3d#diffusers.CogVideoXTransformer3DModel">CogVideoXTransformer3DModel</a>) &#x2014;
A text conditioned <code>CogVideoXTransformer3DModel</code> to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded video latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_image2video.py#L164"}}),Le=new V({props:{name:"__call__",anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_frames",val:": int = 49"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.Optional[typing.List[int]] = None"},{name:"guidance_scale",val:": float = 6"},{name:"use_dynamic_cfg",val:": bool = False"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 226"}],parametersDescription:[{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
The input image to condition the generation on. Must be an image, a list of images or a <code>torch.Tensor</code>.`,name:"image"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The height in pixels of the generated image. This is set to 480 by default for the best results.`,name:"height"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The width in pixels of the generated image. This is set to 720 by default for the best results.`,name:"width"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>48</code>) &#x2014;
Number of frames to generate. Must be divisible by self.vae_scale_factor_temporal. Generated video will
contain 1 extra frame because CogVideoX is conditioned with (num_seconds * fps + 1) frames where
num_seconds is 6 and fps is 8. However, since videos can be saved at any fps, the only condition that
needs to be satisfied is that of divisibility mentioned above.`,name:"num_frames"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, defaults to <code>226</code>) &#x2014;
Maximum sequence length in encoded prompt. Must be consistent with
<code>self.transformer.config.max_text_seq_length</code> otherwise may lead to poor results.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_image2video.py#L602",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> or <code>tuple</code></p>
`}}),E=new Lo({props:{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.example",$$slots:{default:[Hi]},$$scope:{ctx:$}}}),De=new V({props:{name:"encode_prompt",anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_image2video.py#L267"}}),qe=new V({props:{name:"fuse_qkv_projections",anchor:"diffusers.CogVideoXImageToVideoPipeline.fuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_image2video.py#L523"}}),Ee=new V({props:{name:"unfuse_qkv_projections",anchor:"diffusers.CogVideoXImageToVideoPipeline.unfuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_image2video.py#L529"}}),Qe=new F({props:{title:"CogVideoXVideoToVideoPipeline",local:"diffusers.CogVideoXVideoToVideoPipeline",headingTag:"h2"}}),Se=new V({props:{name:"class diffusers.CogVideoXVideoToVideoPipeline",anchor:"diffusers.CogVideoXVideoToVideoPipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKLCogVideoX"},{name:"transformer",val:": CogVideoXTransformer3DModel"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim_cogvideox.CogVideoXDDIMScheduler, diffusers.schedulers.scheduling_dpm_cogvideox.CogVideoXDPMScheduler]"}],parametersDescription:[{anchor:"diffusers.CogVideoXVideoToVideoPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. CogVideoX uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/PixArt-alpha/PixArt-alpha/tree/main/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/cogvideox_transformer3d#diffusers.CogVideoXTransformer3DModel">CogVideoXTransformer3DModel</a>) &#x2014;
A text conditioned <code>CogVideoXTransformer3DModel</code> to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded video latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_video2video.py#L169"}}),Ae=new V({props:{name:"__call__",anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__",parameters:[{name:"video",val:": typing.List[PIL.Image.Image] = None"},{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.Optional[typing.List[int]] = None"},{name:"strength",val:": float = 0.8"},{name:"guidance_scale",val:": float = 6"},{name:"use_dynamic_cfg",val:": bool = False"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 226"}],parametersDescription:[{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.video",description:`<strong>video</strong> (<code>List[PIL.Image.Image]</code>) &#x2014;
The input video to condition the generation on. Must be a list of images/frames of the video.`,name:"video"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The height in pixels of the generated image. This is set to 480 by default for the best results.`,name:"height"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The width in pixels of the generated image. This is set to 720 by default for the best results.`,name:"width"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Higher strength leads to more differences between original video and generated video.`,name:"strength"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, defaults to <code>226</code>) &#x2014;
Maximum sequence length in encoded prompt. Must be consistent with
<code>self.transformer.config.max_text_seq_length</code> otherwise may lead to poor results.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_video2video.py#L575",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> or <code>tuple</code></p>
`}}),O=new Lo({props:{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.example",$$slots:{default:[Fi]},$$scope:{ctx:$}}}),Oe=new V({props:{name:"encode_prompt",anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_video2video.py#L269"}}),Ke=new V({props:{name:"fuse_qkv_projections",anchor:"diffusers.CogVideoXVideoToVideoPipeline.fuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_video2video.py#L496"}}),et=new V({props:{name:"unfuse_qkv_projections",anchor:"diffusers.CogVideoXVideoToVideoPipeline.unfuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_video2video.py#L502"}}),tt=new F({props:{title:"CogVideoXFunControlPipeline",local:"diffusers.CogVideoXFunControlPipeline",headingTag:"h2"}}),ot=new V({props:{name:"class diffusers.CogVideoXFunControlPipeline",anchor:"diffusers.CogVideoXFunControlPipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKLCogVideoX"},{name:"transformer",val:": CogVideoXTransformer3DModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"}],parametersDescription:[{anchor:"diffusers.CogVideoXFunControlPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.CogVideoXFunControlPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. CogVideoX uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/PixArt-alpha/PixArt-alpha/tree/main/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.CogVideoXFunControlPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.CogVideoXFunControlPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/cogvideox_transformer3d#diffusers.CogVideoXTransformer3DModel">CogVideoXTransformer3DModel</a>) &#x2014;
A text conditioned <code>CogVideoXTransformer3DModel</code> to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.CogVideoXFunControlPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded video latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_fun_control.py#L154"}}),nt=new V({props:{name:"__call__",anchor:"diffusers.CogVideoXFunControlPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"control_video",val:": typing.Optional[typing.List[PIL.Image.Image]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.Optional[typing.List[int]] = None"},{name:"guidance_scale",val:": float = 6"},{name:"use_dynamic_cfg",val:": bool = False"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"control_video_latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 226"}],parametersDescription:[{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.control_video",description:`<strong>control_video</strong> (<code>List[PIL.Image.Image]</code>) &#x2014;
The control video to condition the generation on. Must be a list of images/frames of the video. If not
provided, <code>control_video_latents</code> must be provided.`,name:"control_video"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The height in pixels of the generated image. This is set to 480 by default for the best results.`,name:"height"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The width in pixels of the generated image. This is set to 720 by default for the best results.`,name:"width"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 6.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.control_video_latents",description:`<strong>control_video_latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated control latents, sampled from a Gaussian distribution, to be used as inputs for
controlled video generation. If not provided, <code>control_video</code> must be provided.`,name:"control_video_latents"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, defaults to <code>226</code>) &#x2014;
Maximum sequence length in encoded prompt. Must be consistent with
<code>self.transformer.config.max_text_seq_length</code> otherwise may lead to poor results.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_fun_control.py#L551",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> or <code>tuple</code></p>
`}}),oe=new Lo({props:{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.example",$$slots:{default:[Yi]},$$scope:{ctx:$}}}),it=new V({props:{name:"encode_prompt",anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_fun_control.py#L253"}}),st=new V({props:{name:"fuse_qkv_projections",anchor:"diffusers.CogVideoXFunControlPipeline.fuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_fun_control.py#L473"}}),at=new V({props:{name:"unfuse_qkv_projections",anchor:"diffusers.CogVideoXFunControlPipeline.unfuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_fun_control.py#L478"}}),rt=new F({props:{title:"CogVideoXPipelineOutput",local:"diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput",headingTag:"h2"}}),lt=new V({props:{name:"class diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput",anchor:"diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput",parameters:[{name:"frames",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing
denoised PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>.`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_output.py#L8"}}),dt=new Bi({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/cogvideox.md"}}),{c(){c=r("meta"),C=n(),y=r("p"),b=n(),m(v.$$.fragment),d=n(),T=r("div"),T.innerHTML=Bn,Yt=n(),ae=r("p"),ae.innerHTML=Nn,zt=n(),re=r("p"),re.textContent=Rn,Lt=n(),le=r("p"),le.innerHTML=Hn,Dt=n(),m(Y.$$.fragment),qt=n(),de=r("p"),de.innerHTML=Fn,Et=n(),pe=r("p"),pe.textContent=Yn,Qt=n(),ce=r("table"),ce.innerHTML=zn,St=n(),me=r("p"),me.textContent=Ln,At=n(),ge=r("table"),ge.innerHTML=Dn,Ot=n(),ue=r("p"),ue.textContent=qn,Kt=n(),fe=r("ul"),fe.innerHTML=En,eo=n(),he=r("p"),he.innerHTML=Qn,to=n(),_e=r("table"),_e.innerHTML=Sn,oo=n(),m(be.$$.fragment),no=n(),ye=r("p"),ye.innerHTML=An,io=n(),ve=r("p"),ve.textContent=On,so=n(),m(Te.$$.fragment),ao=n(),we=r("p"),we.textContent=Kn,ro=n(),m(Me.$$.fragment),lo=n(),Ve=r("p"),Ve.innerHTML=ei,po=n(),m(Ce.$$.fragment),co=n(),xe=r("p"),xe.textContent=ti,mo=n(),m(Je.$$.fragment),go=n(),Ue=r("p"),Ue.innerHTML=oi,uo=n(),m(Ie.$$.fragment),fo=n(),m(Xe.$$.fragment),ho=n(),je=r("p"),je.innerHTML=ni,_o=n(),Ze=r("ul"),Ze.innerHTML=ii,bo=n(),m(ke.$$.fragment),yo=n(),$e=r("p"),$e.textContent=si,vo=n(),We=r("p"),We.innerHTML=ai,To=n(),m(Ge.$$.fragment),wo=n(),m(Pe.$$.fragment),Mo=n(),x=r("div"),m(Be.$$.fragment),Do=n(),gt=r("p"),gt.textContent=ri,qo=n(),ut=r("p"),ut.innerHTML=li,Eo=n(),W=r("div"),m(Ne.$$.fragment),Qo=n(),ft=r("p"),ft.textContent=di,So=n(),m(z.$$.fragment),Ao=n(),L=r("div"),m(Re.$$.fragment),Oo=n(),ht=r("p"),ht.textContent=pi,Ko=n(),D=r("div"),m(He.$$.fragment),en=n(),_t=r("p"),_t.textContent=ci,tn=n(),q=r("div"),m(Fe.$$.fragment),on=n(),bt=r("p"),bt.textContent=mi,Vo=n(),m(Ye.$$.fragment),Co=n(),J=r("div"),m(ze.$$.fragment),nn=n(),yt=r("p"),yt.textContent=gi,sn=n(),vt=r("p"),vt.innerHTML=ui,an=n(),G=r("div"),m(Le.$$.fragment),rn=n(),Tt=r("p"),Tt.textContent=fi,ln=n(),m(E.$$.fragment),dn=n(),Q=r("div"),m(De.$$.fragment),pn=n(),wt=r("p"),wt.textContent=hi,cn=n(),S=r("div"),m(qe.$$.fragment),mn=n(),Mt=r("p"),Mt.textContent=_i,gn=n(),A=r("div"),m(Ee.$$.fragment),un=n(),Vt=r("p"),Vt.textContent=bi,xo=n(),m(Qe.$$.fragment),Jo=n(),U=r("div"),m(Se.$$.fragment),fn=n(),Ct=r("p"),Ct.textContent=yi,hn=n(),xt=r("p"),xt.innerHTML=vi,_n=n(),P=r("div"),m(Ae.$$.fragment),bn=n(),Jt=r("p"),Jt.textContent=Ti,yn=n(),m(O.$$.fragment),vn=n(),K=r("div"),m(Oe.$$.fragment),Tn=n(),Ut=r("p"),Ut.textContent=wi,wn=n(),ee=r("div"),m(Ke.$$.fragment),Mn=n(),It=r("p"),It.textContent=Mi,Vn=n(),te=r("div"),m(et.$$.fragment),Cn=n(),Xt=r("p"),Xt.textContent=Vi,Uo=n(),m(tt.$$.fragment),Io=n(),I=r("div"),m(ot.$$.fragment),xn=n(),jt=r("p"),jt.textContent=Ci,Jn=n(),Zt=r("p"),Zt.innerHTML=xi,Un=n(),B=r("div"),m(nt.$$.fragment),In=n(),kt=r("p"),kt.textContent=Ji,Xn=n(),m(oe.$$.fragment),jn=n(),ne=r("div"),m(it.$$.fragment),Zn=n(),$t=r("p"),$t.textContent=Ui,kn=n(),ie=r("div"),m(st.$$.fragment),$n=n(),Wt=r("p"),Wt.textContent=Ii,Wn=n(),se=r("div"),m(at.$$.fragment),Gn=n(),Gt=r("p"),Gt.textContent=Xi,Xo=n(),m(rt.$$.fragment),jo=n(),R=r("div"),m(lt.$$.fragment),Pn=n(),Pt=r("p"),Pt.textContent=ji,Zo=n(),m(dt.$$.fragment),ko=n(),Ht=r("p"),this.h()},l(e){const o=Gi("svelte-u9bgzb",document.head);c=l(o,"META",{name:!0,content:!0}),o.forEach(t),C=i(e),y=l(e,"P",{}),M(y).forEach(t),b=i(e),g(v.$$.fragment,e),d=i(e),T=l(e,"DIV",{class:!0,"data-svelte-h":!0}),p(T)!=="svelte-si9ct8"&&(T.innerHTML=Bn),Yt=i(e),ae=l(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1jx3rme"&&(ae.innerHTML=Nn),zt=i(e),re=l(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1cwsb16"&&(re.textContent=Rn),Lt=i(e),le=l(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-19oae4l"&&(le.innerHTML=Hn),Dt=i(e),g(Y.$$.fragment,e),qt=i(e),de=l(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-14a2tju"&&(de.innerHTML=Fn),Et=i(e),pe=l(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1kazin2"&&(pe.textContent=Yn),Qt=i(e),ce=l(e,"TABLE",{"data-svelte-h":!0}),p(ce)!=="svelte-1rj5ajk"&&(ce.innerHTML=zn),St=i(e),me=l(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-zszkur"&&(me.textContent=Ln),At=i(e),ge=l(e,"TABLE",{"data-svelte-h":!0}),p(ge)!=="svelte-skqsf0"&&(ge.innerHTML=Dn),Ot=i(e),ue=l(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1dritjd"&&(ue.textContent=qn),Kt=i(e),fe=l(e,"UL",{"data-svelte-h":!0}),p(fe)!=="svelte-2qusrd"&&(fe.innerHTML=En),eo=i(e),he=l(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-kp1pcj"&&(he.innerHTML=Qn),to=i(e),_e=l(e,"TABLE",{"data-svelte-h":!0}),p(_e)!=="svelte-1ujlzlu"&&(_e.innerHTML=Sn),oo=i(e),g(be.$$.fragment,e),no=i(e),ye=l(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-iekg51"&&(ye.innerHTML=An),io=i(e),ve=l(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-jub7f1"&&(ve.textContent=On),so=i(e),g(Te.$$.fragment,e),ao=i(e),we=l(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-a3ahk3"&&(we.textContent=Kn),ro=i(e),g(Me.$$.fragment,e),lo=i(e),Ve=l(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-1p91erm"&&(Ve.innerHTML=ei),po=i(e),g(Ce.$$.fragment,e),co=i(e),xe=l(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-oyjtrh"&&(xe.textContent=ti),mo=i(e),g(Je.$$.fragment,e),go=i(e),Ue=l(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1ri8bb"&&(Ue.innerHTML=oi),uo=i(e),g(Ie.$$.fragment,e),fo=i(e),g(Xe.$$.fragment,e),ho=i(e),je=l(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-1wycjro"&&(je.innerHTML=ni),_o=i(e),Ze=l(e,"UL",{"data-svelte-h":!0}),p(Ze)!=="svelte-195dfo2"&&(Ze.innerHTML=ii),bo=i(e),g(ke.$$.fragment,e),yo=i(e),$e=l(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-1ou2pxc"&&($e.textContent=si),vo=i(e),We=l(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-ugud9u"&&(We.innerHTML=ai),To=i(e),g(Ge.$$.fragment,e),wo=i(e),g(Pe.$$.fragment,e),Mo=i(e),x=l(e,"DIV",{class:!0});var X=M(x);g(Be.$$.fragment,X),Do=i(X),gt=l(X,"P",{"data-svelte-h":!0}),p(gt)!=="svelte-gmblkq"&&(gt.textContent=ri),qo=i(X),ut=l(X,"P",{"data-svelte-h":!0}),p(ut)!=="svelte-wu1jmh"&&(ut.innerHTML=li),Eo=i(X),W=l(X,"DIV",{class:!0});var H=M(W);g(Ne.$$.fragment,H),Qo=i(H),ft=l(H,"P",{"data-svelte-h":!0}),p(ft)!=="svelte-v78lg8"&&(ft.textContent=di),So=i(H),g(z.$$.fragment,H),H.forEach(t),Ao=i(X),L=l(X,"DIV",{class:!0});var pt=M(L);g(Re.$$.fragment,pt),Oo=i(pt),ht=l(pt,"P",{"data-svelte-h":!0}),p(ht)!=="svelte-16q0ax1"&&(ht.textContent=pi),pt.forEach(t),Ko=i(X),D=l(X,"DIV",{class:!0});var ct=M(D);g(He.$$.fragment,ct),en=i(ct),_t=l(ct,"P",{"data-svelte-h":!0}),p(_t)!=="svelte-1vadzv1"&&(_t.textContent=ci),ct.forEach(t),tn=i(X),q=l(X,"DIV",{class:!0});var mt=M(q);g(Fe.$$.fragment,mt),on=i(mt),bt=l(mt,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-fohozp"&&(bt.textContent=mi),mt.forEach(t),X.forEach(t),Vo=i(e),g(Ye.$$.fragment,e),Co=i(e),J=l(e,"DIV",{class:!0});var j=M(J);g(ze.$$.fragment,j),nn=i(j),yt=l(j,"P",{"data-svelte-h":!0}),p(yt)!=="svelte-cngl0i"&&(yt.textContent=gi),sn=i(j),vt=l(j,"P",{"data-svelte-h":!0}),p(vt)!=="svelte-wu1jmh"&&(vt.innerHTML=ui),an=i(j),G=l(j,"DIV",{class:!0});var Bt=M(G);g(Le.$$.fragment,Bt),rn=i(Bt),Tt=l(Bt,"P",{"data-svelte-h":!0}),p(Tt)!=="svelte-v78lg8"&&(Tt.textContent=fi),ln=i(Bt),g(E.$$.fragment,Bt),Bt.forEach(t),dn=i(j),Q=l(j,"DIV",{class:!0});var Wo=M(Q);g(De.$$.fragment,Wo),pn=i(Wo),wt=l(Wo,"P",{"data-svelte-h":!0}),p(wt)!=="svelte-16q0ax1"&&(wt.textContent=hi),Wo.forEach(t),cn=i(j),S=l(j,"DIV",{class:!0});var Go=M(S);g(qe.$$.fragment,Go),mn=i(Go),Mt=l(Go,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-1vadzv1"&&(Mt.textContent=_i),Go.forEach(t),gn=i(j),A=l(j,"DIV",{class:!0});var Po=M(A);g(Ee.$$.fragment,Po),un=i(Po),Vt=l(Po,"P",{"data-svelte-h":!0}),p(Vt)!=="svelte-fohozp"&&(Vt.textContent=bi),Po.forEach(t),j.forEach(t),xo=i(e),g(Qe.$$.fragment,e),Jo=i(e),U=l(e,"DIV",{class:!0});var Z=M(U);g(Se.$$.fragment,Z),fn=i(Z),Ct=l(Z,"P",{"data-svelte-h":!0}),p(Ct)!=="svelte-4lf8uk"&&(Ct.textContent=yi),hn=i(Z),xt=l(Z,"P",{"data-svelte-h":!0}),p(xt)!=="svelte-wu1jmh"&&(xt.innerHTML=vi),_n=i(Z),P=l(Z,"DIV",{class:!0});var Nt=M(P);g(Ae.$$.fragment,Nt),bn=i(Nt),Jt=l(Nt,"P",{"data-svelte-h":!0}),p(Jt)!=="svelte-v78lg8"&&(Jt.textContent=Ti),yn=i(Nt),g(O.$$.fragment,Nt),Nt.forEach(t),vn=i(Z),K=l(Z,"DIV",{class:!0});var Bo=M(K);g(Oe.$$.fragment,Bo),Tn=i(Bo),Ut=l(Bo,"P",{"data-svelte-h":!0}),p(Ut)!=="svelte-16q0ax1"&&(Ut.textContent=wi),Bo.forEach(t),wn=i(Z),ee=l(Z,"DIV",{class:!0});var No=M(ee);g(Ke.$$.fragment,No),Mn=i(No),It=l(No,"P",{"data-svelte-h":!0}),p(It)!=="svelte-1vadzv1"&&(It.textContent=Mi),No.forEach(t),Vn=i(Z),te=l(Z,"DIV",{class:!0});var Ro=M(te);g(et.$$.fragment,Ro),Cn=i(Ro),Xt=l(Ro,"P",{"data-svelte-h":!0}),p(Xt)!=="svelte-fohozp"&&(Xt.textContent=Vi),Ro.forEach(t),Z.forEach(t),Uo=i(e),g(tt.$$.fragment,e),Io=i(e),I=l(e,"DIV",{class:!0});var k=M(I);g(ot.$$.fragment,k),xn=i(k),jt=l(k,"P",{"data-svelte-h":!0}),p(jt)!=="svelte-8tkh5d"&&(jt.textContent=Ci),Jn=i(k),Zt=l(k,"P",{"data-svelte-h":!0}),p(Zt)!=="svelte-wu1jmh"&&(Zt.innerHTML=xi),Un=i(k),B=l(k,"DIV",{class:!0});var Rt=M(B);g(nt.$$.fragment,Rt),In=i(Rt),kt=l(Rt,"P",{"data-svelte-h":!0}),p(kt)!=="svelte-v78lg8"&&(kt.textContent=Ji),Xn=i(Rt),g(oe.$$.fragment,Rt),Rt.forEach(t),jn=i(k),ne=l(k,"DIV",{class:!0});var Ho=M(ne);g(it.$$.fragment,Ho),Zn=i(Ho),$t=l(Ho,"P",{"data-svelte-h":!0}),p($t)!=="svelte-16q0ax1"&&($t.textContent=Ui),Ho.forEach(t),kn=i(k),ie=l(k,"DIV",{class:!0});var Fo=M(ie);g(st.$$.fragment,Fo),$n=i(Fo),Wt=l(Fo,"P",{"data-svelte-h":!0}),p(Wt)!=="svelte-1vadzv1"&&(Wt.textContent=Ii),Fo.forEach(t),Wn=i(k),se=l(k,"DIV",{class:!0});var Yo=M(se);g(at.$$.fragment,Yo),Gn=i(Yo),Gt=l(Yo,"P",{"data-svelte-h":!0}),p(Gt)!=="svelte-fohozp"&&(Gt.textContent=Xi),Yo.forEach(t),k.forEach(t),Xo=i(e),g(rt.$$.fragment,e),jo=i(e),R=l(e,"DIV",{class:!0});var zo=M(R);g(lt.$$.fragment,zo),Pn=i(zo),Pt=l(zo,"P",{"data-svelte-h":!0}),p(Pt)!=="svelte-1qnvsrt"&&(Pt.textContent=ji),zo.forEach(t),Zo=i(e),g(dt.$$.fragment,e),ko=i(e),Ht=l(e,"P",{}),M(Ht).forEach(t),this.h()},h(){w(c,"name","hf:doc:metadata"),w(c,"content",Li),w(T,"class","flex flex-wrap space-x-1"),w(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){s(document.head,c),a(e,C,o),a(e,y,o),a(e,b,o),u(v,e,o),a(e,d,o),a(e,T,o),a(e,Yt,o),a(e,ae,o),a(e,zt,o),a(e,re,o),a(e,Lt,o),a(e,le,o),a(e,Dt,o),u(Y,e,o),a(e,qt,o),a(e,de,o),a(e,Et,o),a(e,pe,o),a(e,Qt,o),a(e,ce,o),a(e,St,o),a(e,me,o),a(e,At,o),a(e,ge,o),a(e,Ot,o),a(e,ue,o),a(e,Kt,o),a(e,fe,o),a(e,eo,o),a(e,he,o),a(e,to,o),a(e,_e,o),a(e,oo,o),u(be,e,o),a(e,no,o),a(e,ye,o),a(e,io,o),a(e,ve,o),a(e,so,o),u(Te,e,o),a(e,ao,o),a(e,we,o),a(e,ro,o),u(Me,e,o),a(e,lo,o),a(e,Ve,o),a(e,po,o),u(Ce,e,o),a(e,co,o),a(e,xe,o),a(e,mo,o),u(Je,e,o),a(e,go,o),a(e,Ue,o),a(e,uo,o),u(Ie,e,o),a(e,fo,o),u(Xe,e,o),a(e,ho,o),a(e,je,o),a(e,_o,o),a(e,Ze,o),a(e,bo,o),u(ke,e,o),a(e,yo,o),a(e,$e,o),a(e,vo,o),a(e,We,o),a(e,To,o),u(Ge,e,o),a(e,wo,o),u(Pe,e,o),a(e,Mo,o),a(e,x,o),u(Be,x,null),s(x,Do),s(x,gt),s(x,qo),s(x,ut),s(x,Eo),s(x,W),u(Ne,W,null),s(W,Qo),s(W,ft),s(W,So),u(z,W,null),s(x,Ao),s(x,L),u(Re,L,null),s(L,Oo),s(L,ht),s(x,Ko),s(x,D),u(He,D,null),s(D,en),s(D,_t),s(x,tn),s(x,q),u(Fe,q,null),s(q,on),s(q,bt),a(e,Vo,o),u(Ye,e,o),a(e,Co,o),a(e,J,o),u(ze,J,null),s(J,nn),s(J,yt),s(J,sn),s(J,vt),s(J,an),s(J,G),u(Le,G,null),s(G,rn),s(G,Tt),s(G,ln),u(E,G,null),s(J,dn),s(J,Q),u(De,Q,null),s(Q,pn),s(Q,wt),s(J,cn),s(J,S),u(qe,S,null),s(S,mn),s(S,Mt),s(J,gn),s(J,A),u(Ee,A,null),s(A,un),s(A,Vt),a(e,xo,o),u(Qe,e,o),a(e,Jo,o),a(e,U,o),u(Se,U,null),s(U,fn),s(U,Ct),s(U,hn),s(U,xt),s(U,_n),s(U,P),u(Ae,P,null),s(P,bn),s(P,Jt),s(P,yn),u(O,P,null),s(U,vn),s(U,K),u(Oe,K,null),s(K,Tn),s(K,Ut),s(U,wn),s(U,ee),u(Ke,ee,null),s(ee,Mn),s(ee,It),s(U,Vn),s(U,te),u(et,te,null),s(te,Cn),s(te,Xt),a(e,Uo,o),u(tt,e,o),a(e,Io,o),a(e,I,o),u(ot,I,null),s(I,xn),s(I,jt),s(I,Jn),s(I,Zt),s(I,Un),s(I,B),u(nt,B,null),s(B,In),s(B,kt),s(B,Xn),u(oe,B,null),s(I,jn),s(I,ne),u(it,ne,null),s(ne,Zn),s(ne,$t),s(I,kn),s(I,ie),u(st,ie,null),s(ie,$n),s(ie,Wt),s(I,Wn),s(I,se),u(at,se,null),s(se,Gn),s(se,Gt),a(e,Xo,o),u(rt,e,o),a(e,jo,o),a(e,R,o),u(lt,R,null),s(R,Pn),s(R,Pt),a(e,Zo,o),u(dt,e,o),a(e,ko,o),a(e,Ht,o),$o=!0},p(e,[o]){const X={};o&2&&(X.$$scope={dirty:o,ctx:e}),Y.$set(X);const H={};o&2&&(H.$$scope={dirty:o,ctx:e}),z.$set(H);const pt={};o&2&&(pt.$$scope={dirty:o,ctx:e}),E.$set(pt);const ct={};o&2&&(ct.$$scope={dirty:o,ctx:e}),O.$set(ct);const mt={};o&2&&(mt.$$scope={dirty:o,ctx:e}),oe.$set(mt)},i(e){$o||(f(v.$$.fragment,e),f(Y.$$.fragment,e),f(be.$$.fragment,e),f(Te.$$.fragment,e),f(Me.$$.fragment,e),f(Ce.$$.fragment,e),f(Je.$$.fragment,e),f(Ie.$$.fragment,e),f(Xe.$$.fragment,e),f(ke.$$.fragment,e),f(Ge.$$.fragment,e),f(Pe.$$.fragment,e),f(Be.$$.fragment,e),f(Ne.$$.fragment,e),f(z.$$.fragment,e),f(Re.$$.fragment,e),f(He.$$.fragment,e),f(Fe.$$.fragment,e),f(Ye.$$.fragment,e),f(ze.$$.fragment,e),f(Le.$$.fragment,e),f(E.$$.fragment,e),f(De.$$.fragment,e),f(qe.$$.fragment,e),f(Ee.$$.fragment,e),f(Qe.$$.fragment,e),f(Se.$$.fragment,e),f(Ae.$$.fragment,e),f(O.$$.fragment,e),f(Oe.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(ot.$$.fragment,e),f(nt.$$.fragment,e),f(oe.$$.fragment,e),f(it.$$.fragment,e),f(st.$$.fragment,e),f(at.$$.fragment,e),f(rt.$$.fragment,e),f(lt.$$.fragment,e),f(dt.$$.fragment,e),$o=!0)},o(e){h(v.$$.fragment,e),h(Y.$$.fragment,e),h(be.$$.fragment,e),h(Te.$$.fragment,e),h(Me.$$.fragment,e),h(Ce.$$.fragment,e),h(Je.$$.fragment,e),h(Ie.$$.fragment,e),h(Xe.$$.fragment,e),h(ke.$$.fragment,e),h(Ge.$$.fragment,e),h(Pe.$$.fragment,e),h(Be.$$.fragment,e),h(Ne.$$.fragment,e),h(z.$$.fragment,e),h(Re.$$.fragment,e),h(He.$$.fragment,e),h(Fe.$$.fragment,e),h(Ye.$$.fragment,e),h(ze.$$.fragment,e),h(Le.$$.fragment,e),h(E.$$.fragment,e),h(De.$$.fragment,e),h(qe.$$.fragment,e),h(Ee.$$.fragment,e),h(Qe.$$.fragment,e),h(Se.$$.fragment,e),h(Ae.$$.fragment,e),h(O.$$.fragment,e),h(Oe.$$.fragment,e),h(Ke.$$.fragment,e),h(et.$$.fragment,e),h(tt.$$.fragment,e),h(ot.$$.fragment,e),h(nt.$$.fragment,e),h(oe.$$.fragment,e),h(it.$$.fragment,e),h(st.$$.fragment,e),h(at.$$.fragment,e),h(rt.$$.fragment,e),h(lt.$$.fragment,e),h(dt.$$.fragment,e),$o=!1},d(e){e&&(t(C),t(y),t(b),t(d),t(T),t(Yt),t(ae),t(zt),t(re),t(Lt),t(le),t(Dt),t(qt),t(de),t(Et),t(pe),t(Qt),t(ce),t(St),t(me),t(At),t(ge),t(Ot),t(ue),t(Kt),t(fe),t(eo),t(he),t(to),t(_e),t(oo),t(no),t(ye),t(io),t(ve),t(so),t(ao),t(we),t(ro),t(lo),t(Ve),t(po),t(co),t(xe),t(mo),t(go),t(Ue),t(uo),t(fo),t(ho),t(je),t(_o),t(Ze),t(bo),t(yo),t($e),t(vo),t(We),t(To),t(wo),t(Mo),t(x),t(Vo),t(Co),t(J),t(xo),t(Jo),t(U),t(Uo),t(Io),t(I),t(Xo),t(jo),t(R),t(Zo),t(ko),t(Ht)),t(c),_(v,e),_(Y,e),_(be,e),_(Te,e),_(Me,e),_(Ce,e),_(Je,e),_(Ie,e),_(Xe,e),_(ke,e),_(Ge,e),_(Pe,e),_(Be),_(Ne),_(z),_(Re),_(He),_(Fe),_(Ye,e),_(ze),_(Le),_(E),_(De),_(qe),_(Ee),_(Qe,e),_(Se),_(Ae),_(O),_(Oe),_(Ke),_(et),_(tt,e),_(ot),_(nt),_(oe),_(it),_(st),_(at),_(rt,e),_(lt),_(dt,e)}}}const Li='{"title":"CogVideoX","local":"cogvideox","sections":[{"title":"Inference","local":"inference","sections":[{"title":"Memory optimization","local":"memory-optimization","sections":[],"depth":3}],"depth":2},{"title":"Quantization","local":"quantization","sections":[],"depth":2},{"title":"CogVideoXPipeline","local":"diffusers.CogVideoXPipeline","sections":[],"depth":2},{"title":"CogVideoXImageToVideoPipeline","local":"diffusers.CogVideoXImageToVideoPipeline","sections":[],"depth":2},{"title":"CogVideoXVideoToVideoPipeline","local":"diffusers.CogVideoXVideoToVideoPipeline","sections":[],"depth":2},{"title":"CogVideoXFunControlPipeline","local":"diffusers.CogVideoXFunControlPipeline","sections":[],"depth":2},{"title":"CogVideoXPipelineOutput","local":"diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput","sections":[],"depth":2}],"depth":1}';function Di($){return ki(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class es extends $i{constructor(c){super(),Wi(this,c,Di,zi,Zi,{})}}export{es as component};
