import{s as Do,n as Vo,o as Co}from"../chunks/scheduler.8c3d61f6.js";import{S as Ao,i as ko,g as s,s as r,r as d,A as Mo,h as a,f as n,c as o,j as _,u as m,x as u,k as v,y as t,a as I,v as p,d as g,t as l,w as f}from"../chunks/index.da70eac4.js";import{D as b}from"../chunks/Docstring.fa488882.js";import{H as pt,E as No}from"../chunks/index.dfbaf638.js";function Eo(Kr){let w,gt,dt,lt,Q,ft,X,Qr='The <code>VaeImageProcessor</code> provides a unified API for <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>s to prepare image inputs for VAE encoding and post-processing outputs once they’re decoded. This includes transformations such as resizing, normalization, and conversion between PIL Image, PyTorch, and NumPy arrays.',ht,Z,Xr="All pipelines with <code>VaeImageProcessor</code> accept PIL Image, PyTorch tensor, or NumPy arrays as image inputs and return outputs based on the <code>output_type</code> argument by the user. You can pass encoded image latents directly to the pipeline and return latents from the pipeline as a specific output with the <code>output_type</code> argument (for example <code>output_type=&quot;latent&quot;</code>). This allows you to take the generated latents from one pipeline and pass it to another pipeline as input without leaving the latent space. It also makes it much easier to use multiple pipelines together by passing PyTorch tensors directly between different pipelines.",ut,ee,_t,i,te,Xt,Me,Zr="Image processor for VAE.",Zt,T,re,er,Ne,eo="Applies an overlay of the mask and the inpainted image on the original image.",tr,z,oe,rr,Ee,to="Create a mask.",or,L,se,sr,We,ro="Applies Gaussian blur to an image.",ar,D,ae,nr,Re,oo="Converts a given PIL image to grayscale.",ir,V,ne,cr,Ue,so="Converts a PIL image to RGB format.",dr,C,ie,mr,He,ao="Denormalize an image array to [0,1].",pr,A,ce,gr,Oe,no=`Finds a rectangular region that contains all masked ares in an image, and expands region to match the aspect
ratio of the original image; for example, if user drew mask in a 128x32 region, and the dimensions for
processing are 512x512, the region will be expanded to 128x128.`,lr,k,de,fr,Fe,io="Returns the height and width of the image, downscaled to the next integer multiple of <code>vae_scale_factor</code>.",hr,M,me,ur,qe,co="Normalize an image array to [-1,1].",_r,N,pe,vr,Ge,mo="Convert a numpy image or a batch of images to a PIL image.",br,E,ge,Ir,Be,po="Convert a NumPy image to a PyTorch tensor.",xr,W,le,Pr,je,go="Convert a PIL image or a list of PIL images to NumPy arrays.",yr,R,fe,$r,Se,lo="Postprocess the image output from tensor to <code>output_type</code>.",wr,U,he,Tr,Ye,fo="Preprocess the image input.",zr,H,ue,Lr,Je,ho="Convert a PyTorch tensor to a NumPy image.",Dr,O,_e,Vr,Ke,uo="Resize image.",vt,ve,bt,be,_o="The <code>VaeImageProcessorLDM3D</code> accepts RGB and depth inputs and returns RGB and depth outputs.",It,x,Ie,Cr,Qe,vo="Image processor for VAE LDM3D.",Ar,F,xe,kr,Xe,bo="Convert a PIL image or a list of PIL images to NumPy arrays.",Mr,q,Pe,Nr,Ze,Io="Convert a NumPy depth image or a batch of images to a list of PIL images.",Er,G,ye,Wr,et,xo="Convert a NumPy image or a batch of images to a list of PIL images.",Rr,B,$e,Ur,tt,Po="Preprocess the image input. Accepted formats are PIL images, NumPy arrays, or PyTorch tensors.",Hr,j,we,Or,rt,yo="Convert an RGB-like depth image to a depth map.",xt,Te,Pt,y,ze,Fr,ot,$o="Image processor for PixArt image resize and crop.",qr,S,Le,Gr,st,wo="Returns the binned height and width based on the aspect ratio.",Br,Y,De,jr,at,To="Resizes and crops a tensor of images to the specified dimensions.",yt,Ve,$t,$,Ce,Sr,nt,zo="Image processor for IP Adapter image masks.",Yr,J,Ae,Jr,it,Lo=`Downsamples the provided mask tensor to match the expected dimensions for scaled dot-product attention. If the
aspect ratio of the mask does not match the aspect ratio of the output image, a warning is issued.`,wt,ke,Tt,mt,zt;return Q=new pt({props:{title:"VAE Image Processor",local:"vae-image-processor",headingTag:"h1"}}),ee=new pt({props:{title:"VaeImageProcessor",local:"diffusers.image_processor.VaeImageProcessor",headingTag:"h2"}}),te=new b({props:{name:"class diffusers.image_processor.VaeImageProcessor",anchor:"diffusers.image_processor.VaeImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"vae_scale_factor",val:": int = 8"},{name:"vae_latent_channels",val:": int = 4"},{name:"resample",val:": str = 'lanczos'"},{name:"do_normalize",val:": bool = True"},{name:"do_binarize",val:": bool = False"},{name:"do_convert_rgb",val:": bool = False"},{name:"do_convert_grayscale",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to downscale the image&#x2019;s (height, width) dimensions to multiples of <code>vae_scale_factor</code>. Can accept
<code>height</code> and <code>width</code> arguments from <a href="/docs/diffusers/main/en/api/image_processor#diffusers.image_processor.VaeImageProcessor.preprocess">image_processor.VaeImageProcessor.preprocess()</a> method.`,name:"do_resize"},{anchor:"diffusers.image_processor.VaeImageProcessor.vae_scale_factor",description:`<strong>vae_scale_factor</strong> (<code>int</code>, <em>optional</em>, defaults to <code>8</code>) &#x2014;
VAE scale factor. If <code>do_resize</code> is <code>True</code>, the image is automatically resized to multiples of this factor.`,name:"vae_scale_factor"},{anchor:"diffusers.image_processor.VaeImageProcessor.resample",description:`<strong>resample</strong> (<code>str</code>, <em>optional</em>, defaults to <code>lanczos</code>) &#x2014;
Resampling filter to use when resizing the image.`,name:"resample"},{anchor:"diffusers.image_processor.VaeImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image to [-1,1].`,name:"do_normalize"},{anchor:"diffusers.image_processor.VaeImageProcessor.do_binarize",description:`<strong>do_binarize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to binarize the image to 0/1.`,name:"do_binarize"},{anchor:"diffusers.image_processor.VaeImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to be <code>False</code>) &#x2014;
Whether to convert the images to RGB format.`,name:"do_convert_rgb"},{anchor:"diffusers.image_processor.VaeImageProcessor.do_convert_grayscale",description:`<strong>do_convert_grayscale</strong> (<code>bool</code>, <em>optional</em>, defaults to be <code>False</code>) &#x2014;
Whether to convert the images to grayscale format.`,name:"do_convert_grayscale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L88"}}),re=new b({props:{name:"apply_overlay",anchor:"diffusers.image_processor.VaeImageProcessor.apply_overlay",parameters:[{name:"mask",val:": Image"},{name:"init_image",val:": Image"},{name:"image",val:": Image"},{name:"crop_coords",val:": typing.Optional[typing.Tuple[int, int, int, int]] = None"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.apply_overlay.mask",description:`<strong>mask</strong> (<code>PIL.Image.Image</code>) &#x2014;
The mask image that highlights regions to overlay.`,name:"mask"},{anchor:"diffusers.image_processor.VaeImageProcessor.apply_overlay.init_image",description:`<strong>init_image</strong> (<code>PIL.Image.Image</code>) &#x2014;
The original image to which the overlay is applied.`,name:"init_image"},{anchor:"diffusers.image_processor.VaeImageProcessor.apply_overlay.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>) &#x2014;
The image to overlay onto the original.`,name:"image"},{anchor:"diffusers.image_processor.VaeImageProcessor.apply_overlay.crop_coords",description:`<strong>crop_coords</strong> (<code>Tuple[int, int, int, int]</code>, <em>optional</em>) &#x2014;
Coordinates to crop the image. If provided, the image will be cropped accordingly.`,name:"crop_coords"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L788",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The final image with the overlay applied.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PIL.Image.Image</code></p>
`}}),oe=new b({props:{name:"binarize",anchor:"diffusers.image_processor.VaeImageProcessor.binarize",parameters:[{name:"image",val:": Image"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.binarize.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>) &#x2014;
The image input, should be a PIL image.`,name:"image"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L523",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The binarized image. Values less than 0.5 are set to 0, values greater than 0.5 are set to 1.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PIL.Image.Image</code></p>
`}}),se=new b({props:{name:"blur",anchor:"diffusers.image_processor.VaeImageProcessor.blur",parameters:[{name:"image",val:": Image"},{name:"blur_factor",val:": int = 4"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.blur.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>) &#x2014;
The PIL image to convert to grayscale.`,name:"image"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L275",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The grayscale-converted PIL image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PIL.Image.Image</code></p>
`}}),ae=new b({props:{name:"convert_to_grayscale",anchor:"diffusers.image_processor.VaeImageProcessor.convert_to_grayscale",parameters:[{name:"image",val:": Image"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.convert_to_grayscale.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>) &#x2014;
The input image to convert.`,name:"image"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L258",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The image converted to grayscale.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PIL.Image.Image</code></p>
`}}),ne=new b({props:{name:"convert_to_rgb",anchor:"diffusers.image_processor.VaeImageProcessor.convert_to_rgb",parameters:[{name:"image",val:": Image"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.convert_to_rgb.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>) &#x2014;
The PIL image to convert to RGB.`,name:"image"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L241",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The RGB-converted PIL image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PIL.Image.Image</code></p>
`}}),ie=new b({props:{name:"denormalize",anchor:"diffusers.image_processor.VaeImageProcessor.denormalize",parameters:[{name:"images",val:": typing.Union[numpy.ndarray, torch.Tensor]"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.denormalize.images",description:`<strong>images</strong> (<code>np.ndarray</code> or <code>torch.Tensor</code>) &#x2014;
The image array to denormalize.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L226",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The denormalized image array.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>np.ndarray</code> or <code>torch.Tensor</code></p>
`}}),ce=new b({props:{name:"get_crop_region",anchor:"diffusers.image_processor.VaeImageProcessor.get_crop_region",parameters:[{name:"mask_image",val:": Image"},{name:"width",val:": int"},{name:"height",val:": int"},{name:"pad",val:" = 0"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.get_crop_region.mask_image",description:"<strong>mask_image</strong> (PIL.Image.Image) &#x2014; Mask image.",name:"mask_image"},{anchor:"diffusers.image_processor.VaeImageProcessor.get_crop_region.width",description:"<strong>width</strong> (int) &#x2014; Width of the image to be processed.",name:"width"},{anchor:"diffusers.image_processor.VaeImageProcessor.get_crop_region.height",description:"<strong>height</strong> (int) &#x2014; Height of the image to be processed.",name:"height"},{anchor:"diffusers.image_processor.VaeImageProcessor.get_crop_region.pad",description:"<strong>pad</strong> (int, optional) &#x2014; Padding to be added to the crop region. Defaults to 0.",name:"pad"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L292",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(x1, y1, x2, y2) represent a rectangular region that contains all masked ares in an image and
matches the original aspect ratio.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>tuple</p>
`}}),de=new b({props:{name:"get_default_height_width",anchor:"diffusers.image_processor.VaeImageProcessor.get_default_height_width",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor]"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.get_default_height_width.image",description:`<strong>image</strong> (<code>Union[PIL.Image.Image, np.ndarray, torch.Tensor]</code>) &#x2014;
The image input, which can be a PIL image, NumPy array, or PyTorch tensor. If it is a NumPy array, it
should have shape <code>[batch, height, width]</code> or <code>[batch, height, width, channels]</code>. If it is a PyTorch
tensor, it should have shape <code>[batch, channels, height, width]</code>.`,name:"image"},{anchor:"diffusers.image_processor.VaeImageProcessor.get_default_height_width.height",description:`<strong>height</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The height of the preprocessed image. If <code>None</code>, the height of the <code>image</code> input will be used.`,name:"height"},{anchor:"diffusers.image_processor.VaeImageProcessor.get_default_height_width.width",description:`<strong>width</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The width of the preprocessed image. If <code>None</code>, the width of the <code>image</code> input will be used.`,name:"width"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L560",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the height and width, both resized to the nearest integer multiple of
<code>vae_scale_factor</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple[int, int]</code></p>
`}}),me=new b({props:{name:"normalize",anchor:"diffusers.image_processor.VaeImageProcessor.normalize",parameters:[{name:"images",val:": typing.Union[numpy.ndarray, torch.Tensor]"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.normalize.images",description:`<strong>images</strong> (<code>np.ndarray</code> or <code>torch.Tensor</code>) &#x2014;
The image array to normalize.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L211",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The normalized image array.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>np.ndarray</code> or <code>torch.Tensor</code></p>
`}}),pe=new b({props:{name:"numpy_to_pil",anchor:"diffusers.image_processor.VaeImageProcessor.numpy_to_pil",parameters:[{name:"images",val:": ndarray"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.numpy_to_pil.images",description:`<strong>images</strong> (<code>np.ndarray</code>) &#x2014;
The image array to convert to PIL format.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L132",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of PIL images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[PIL.Image.Image]</code></p>
`}}),ge=new b({props:{name:"numpy_to_pt",anchor:"diffusers.image_processor.VaeImageProcessor.numpy_to_pt",parameters:[{name:"images",val:": ndarray"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.numpy_to_pt.images",description:`<strong>images</strong> (<code>np.ndarray</code>) &#x2014;
The NumPy image array to convert to PyTorch format.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L176",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A PyTorch tensor representation of the images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),le=new b({props:{name:"pil_to_numpy",anchor:"diffusers.image_processor.VaeImageProcessor.pil_to_numpy",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], PIL.Image.Image]"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.pil_to_numpy.images",description:`<strong>images</strong> (<code>PIL.Image.Image</code> or <code>List[PIL.Image.Image]</code>) &#x2014;
The PIL image or list of images to convert to NumPy format.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L156",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A NumPy array representation of the images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>np.ndarray</code></p>
`}}),fe=new b({props:{name:"postprocess",anchor:"diffusers.image_processor.VaeImageProcessor.postprocess",parameters:[{name:"image",val:": Tensor"},{name:"output_type",val:": str = 'pil'"},{name:"do_denormalize",val:": typing.Optional[typing.List[bool]] = None"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.postprocess.image",description:`<strong>image</strong> (<code>torch.Tensor</code>) &#x2014;
The image input, should be a pytorch tensor with shape <code>B x C x H x W</code>.`,name:"image"},{anchor:"diffusers.image_processor.VaeImageProcessor.postprocess.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>pil</code>) &#x2014;
The output type of the image, can be one of <code>pil</code>, <code>np</code>, <code>pt</code>, <code>latent</code>.`,name:"output_type"},{anchor:"diffusers.image_processor.VaeImageProcessor.postprocess.do_denormalize",description:`<strong>do_denormalize</strong> (<code>List[bool]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether to denormalize the image to [0,1]. If <code>None</code>, will use the value of <code>do_normalize</code> in the
<code>VaeImageProcessor</code> config.`,name:"do_denormalize"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L738",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The postprocessed image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PIL.Image.Image</code>, <code>np.ndarray</code> or <code>torch.Tensor</code></p>
`}}),he=new b({props:{name:"preprocess",anchor:"diffusers.image_processor.VaeImageProcessor.preprocess",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"resize_mode",val:": str = 'default'"},{name:"crops_coords",val:": typing.Optional[typing.Tuple[int, int, int, int]] = None"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.preprocess.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
The image input, accepted formats are PIL images, NumPy arrays, PyTorch tensors; Also accept list of
supported formats.`,name:"image"},{anchor:"diffusers.image_processor.VaeImageProcessor.preprocess.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The height in preprocessed image. If <code>None</code>, will use the <code>get_default_height_width()</code> to get default
height.`,name:"height"},{anchor:"diffusers.image_processor.VaeImageProcessor.preprocess.width",description:"<strong>width</strong> (<code>int</code>, <em>optional</em>) &#x2014;\nThe width in preprocessed. If <code>None</code>, will use get_default_height_width()` to get the default width.",name:"width"},{anchor:"diffusers.image_processor.VaeImageProcessor.preprocess.resize_mode",description:`<strong>resize_mode</strong> (<code>str</code>, <em>optional</em>, defaults to <code>default</code>) &#x2014;
The resize mode, can be one of <code>default</code> or <code>fill</code>. If <code>default</code>, will resize the image to fit within
the specified width and height, and it may not maintaining the original aspect ratio. If <code>fill</code>, will
resize the image to fit within the specified width and height, maintaining the aspect ratio, and then
center the image within the dimensions, filling empty with data from image. If <code>crop</code>, will resize the
image to fit within the specified width and height, maintaining the aspect ratio, and then center the
image within the dimensions, cropping the excess. Note that resize_mode <code>fill</code> and <code>crop</code> are only
supported for PIL image input.`,name:"resize_mode"},{anchor:"diffusers.image_processor.VaeImageProcessor.preprocess.crops_coords",description:`<strong>crops_coords</strong> (<code>List[Tuple[int, int, int, int]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The crop coordinates for each image in the batch. If <code>None</code>, will not crop the image.`,name:"crops_coords"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L607",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The preprocessed image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),ue=new b({props:{name:"pt_to_numpy",anchor:"diffusers.image_processor.VaeImageProcessor.pt_to_numpy",parameters:[{name:"images",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.pt_to_numpy.images",description:`<strong>images</strong> (<code>torch.Tensor</code>) &#x2014;
The PyTorch tensor to convert to NumPy format.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L195",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A NumPy array representation of the images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>np.ndarray</code></p>
`}}),_e=new b({props:{name:"resize",anchor:"diffusers.image_processor.VaeImageProcessor.resize",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor]"},{name:"height",val:": int"},{name:"width",val:": int"},{name:"resize_mode",val:": str = 'default'"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.resize.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>, <code>np.ndarray</code> or <code>torch.Tensor</code>) &#x2014;
The image input, can be a PIL image, numpy array or pytorch tensor.`,name:"image"},{anchor:"diffusers.image_processor.VaeImageProcessor.resize.height",description:`<strong>height</strong> (<code>int</code>) &#x2014;
The height to resize to.`,name:"height"},{anchor:"diffusers.image_processor.VaeImageProcessor.resize.width",description:`<strong>width</strong> (<code>int</code>) &#x2014;
The width to resize to.`,name:"width"},{anchor:"diffusers.image_processor.VaeImageProcessor.resize.resize_mode",description:`<strong>resize_mode</strong> (<code>str</code>, <em>optional</em>, defaults to <code>default</code>) &#x2014;
The resize mode to use, can be one of <code>default</code> or <code>fill</code>. If <code>default</code>, will resize the image to fit
within the specified width and height, and it may not maintaining the original aspect ratio. If <code>fill</code>,
will resize the image to fit within the specified width and height, maintaining the aspect ratio, and
then center the image within the dimensions, filling empty with data from image. If <code>crop</code>, will resize
the image to fit within the specified width and height, maintaining the aspect ratio, and then center
the image within the dimensions, cropping the excess. Note that resize_mode <code>fill</code> and <code>crop</code> are only
supported for PIL image input.`,name:"resize_mode"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L467",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The resized image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PIL.Image.Image</code>, <code>np.ndarray</code> or <code>torch.Tensor</code></p>
`}}),ve=new pt({props:{title:"VaeImageProcessorLDM3D",local:"diffusers.image_processor.VaeImageProcessorLDM3D",headingTag:"h2"}}),Ie=new b({props:{name:"class diffusers.image_processor.VaeImageProcessorLDM3D",anchor:"diffusers.image_processor.VaeImageProcessorLDM3D",parameters:[{name:"do_resize",val:": bool = True"},{name:"vae_scale_factor",val:": int = 8"},{name:"resample",val:": str = 'lanczos'"},{name:"do_normalize",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to downscale the image&#x2019;s (height, width) dimensions to multiples of <code>vae_scale_factor</code>.`,name:"do_resize"},{anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.vae_scale_factor",description:`<strong>vae_scale_factor</strong> (<code>int</code>, <em>optional</em>, defaults to <code>8</code>) &#x2014;
VAE scale factor. If <code>do_resize</code> is <code>True</code>, the image is automatically resized to multiples of this factor.`,name:"vae_scale_factor"},{anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.resample",description:`<strong>resample</strong> (<code>str</code>, <em>optional</em>, defaults to <code>lanczos</code>) &#x2014;
Resampling filter to use when resizing the image.`,name:"resample"},{anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image to [-1,1].`,name:"do_normalize"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L836"}}),xe=new b({props:{name:"depth_pil_to_numpy",anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.depth_pil_to_numpy",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], PIL.Image.Image]"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.depth_pil_to_numpy.images",description:`<strong>images</strong> (<code>Union[List[PIL.Image.Image], PIL.Image.Image]</code>) &#x2014;
The input image or list of images to be converted.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L887",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A NumPy array of the converted images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>np.ndarray</code></p>
`}}),Pe=new b({props:{name:"numpy_to_depth",anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.numpy_to_depth",parameters:[{name:"images",val:": ndarray"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.numpy_to_depth.images",description:`<strong>images</strong> (<code>np.ndarray</code>) &#x2014;
The input NumPy array of depth images, which can be a single image or a batch.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L922",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of PIL images converted from the input NumPy depth images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[PIL.Image.Image]</code></p>
`}}),ye=new b({props:{name:"numpy_to_pil",anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.numpy_to_pil",parameters:[{name:"images",val:": ndarray"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.numpy_to_pil.images",description:`<strong>images</strong> (<code>np.ndarray</code>) &#x2014;
The input NumPy array of images, which can be a single image or a batch.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L863",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of PIL images converted from the input NumPy array.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[PIL.Image.Image]</code></p>
`}}),$e=new b({props:{name:"preprocess",anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.preprocess",parameters:[{name:"rgb",val:": typing.Union[torch.Tensor, PIL.Image.Image, numpy.ndarray]"},{name:"depth",val:": typing.Union[torch.Tensor, PIL.Image.Image, numpy.ndarray]"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"target_res",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.preprocess.rgb",description:`<strong>rgb</strong> (<code>Union[torch.Tensor, PIL.Image.Image, np.ndarray]</code>) &#x2014;
The RGB input image, which can be a single image or a batch.`,name:"rgb"},{anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.preprocess.depth",description:`<strong>depth</strong> (<code>Union[torch.Tensor, PIL.Image.Image, np.ndarray]</code>) &#x2014;
The depth input image, which can be a single image or a batch.`,name:"depth"},{anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.preprocess.height",description:`<strong>height</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The desired height of the processed image. If <code>None</code>, defaults to the height of the input image.`,name:"height"},{anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.preprocess.width",description:`<strong>width</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The desired width of the processed image. If <code>None</code>, defaults to the width of the input image.`,name:"width"},{anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.preprocess.target_res",description:`<strong>target_res</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Target resolution for resizing the images. If specified, overrides height and width.`,name:"target_res"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L1000",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the processed RGB and depth images as PyTorch tensors.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple[torch.Tensor, torch.Tensor]</code></p>
`}}),we=new b({props:{name:"rgblike_to_depthmap",anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.rgblike_to_depthmap",parameters:[{name:"image",val:": typing.Union[numpy.ndarray, torch.Tensor]"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.rgblike_to_depthmap.image",description:`<strong>image</strong> (<code>Union[np.ndarray, torch.Tensor]</code>) &#x2014;
The RGB-like depth image to convert.`,name:"image"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L907",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The corresponding depth map.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[np.ndarray, torch.Tensor]</code></p>
`}}),Te=new pt({props:{title:"PixArtImageProcessor",local:"diffusers.image_processor.PixArtImageProcessor",headingTag:"h2"}}),ze=new b({props:{name:"class diffusers.image_processor.PixArtImageProcessor",anchor:"diffusers.image_processor.PixArtImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"vae_scale_factor",val:": int = 8"},{name:"resample",val:": str = 'lanczos'"},{name:"do_normalize",val:": bool = True"},{name:"do_binarize",val:": bool = False"},{name:"do_convert_grayscale",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.image_processor.PixArtImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to downscale the image&#x2019;s (height, width) dimensions to multiples of <code>vae_scale_factor</code>. Can accept
<code>height</code> and <code>width</code> arguments from <a href="/docs/diffusers/main/en/api/image_processor#diffusers.image_processor.VaeImageProcessor.preprocess">image_processor.VaeImageProcessor.preprocess()</a> method.`,name:"do_resize"},{anchor:"diffusers.image_processor.PixArtImageProcessor.vae_scale_factor",description:`<strong>vae_scale_factor</strong> (<code>int</code>, <em>optional</em>, defaults to <code>8</code>) &#x2014;
VAE scale factor. If <code>do_resize</code> is <code>True</code>, the image is automatically resized to multiples of this factor.`,name:"vae_scale_factor"},{anchor:"diffusers.image_processor.PixArtImageProcessor.resample",description:`<strong>resample</strong> (<code>str</code>, <em>optional</em>, defaults to <code>lanczos</code>) &#x2014;
Resampling filter to use when resizing the image.`,name:"resample"},{anchor:"diffusers.image_processor.PixArtImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image to [-1,1].`,name:"do_normalize"},{anchor:"diffusers.image_processor.PixArtImageProcessor.do_binarize",description:`<strong>do_binarize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to binarize the image to 0/1.`,name:"do_binarize"},{anchor:"diffusers.image_processor.PixArtImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to be <code>False</code>) &#x2014;
Whether to convert the images to RGB format.`,name:"do_convert_rgb"},{anchor:"diffusers.image_processor.PixArtImageProcessor.do_convert_grayscale",description:`<strong>do_convert_grayscale</strong> (<code>bool</code>, <em>optional</em>, defaults to be <code>False</code>) &#x2014;
Whether to convert the images to grayscale format.`,name:"do_convert_grayscale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L1220"}}),Le=new b({props:{name:"classify_height_width_bin",anchor:"diffusers.image_processor.PixArtImageProcessor.classify_height_width_bin",parameters:[{name:"height",val:": int"},{name:"width",val:": int"},{name:"ratios",val:": dict"}],parametersDescription:[{anchor:"diffusers.image_processor.PixArtImageProcessor.classify_height_width_bin.height",description:"<strong>height</strong> (<code>int</code>) &#x2014; The height of the image.",name:"height"},{anchor:"diffusers.image_processor.PixArtImageProcessor.classify_height_width_bin.width",description:"<strong>width</strong> (<code>int</code>) &#x2014; The width of the image.",name:"width"},{anchor:"diffusers.image_processor.PixArtImageProcessor.classify_height_width_bin.ratios",description:"<strong>ratios</strong> (<code>dict</code>) &#x2014; A dictionary where keys are aspect ratios and values are tuples of (height, width).",name:"ratios"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L1261",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The closest binned height and width.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple[int, int]</code></p>
`}}),De=new b({props:{name:"resize_and_crop_tensor",anchor:"diffusers.image_processor.PixArtImageProcessor.resize_and_crop_tensor",parameters:[{name:"samples",val:": Tensor"},{name:"new_width",val:": int"},{name:"new_height",val:": int"}],parametersDescription:[{anchor:"diffusers.image_processor.PixArtImageProcessor.resize_and_crop_tensor.samples",description:`<strong>samples</strong> (<code>torch.Tensor</code>) &#x2014;
A tensor of shape (N, C, H, W) where N is the batch size, C is the number of channels, H is the height,
and W is the width.`,name:"samples"},{anchor:"diffusers.image_processor.PixArtImageProcessor.resize_and_crop_tensor.new_width",description:"<strong>new_width</strong> (<code>int</code>) &#x2014; The desired width of the output images.",name:"new_width"},{anchor:"diffusers.image_processor.PixArtImageProcessor.resize_and_crop_tensor.new_height",description:"<strong>new_height</strong> (<code>int</code>) &#x2014; The desired height of the output images.",name:"new_height"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L1279",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor containing the resized and cropped images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),Ve=new pt({props:{title:"IPAdapterMaskProcessor",local:"diffusers.image_processor.IPAdapterMaskProcessor",headingTag:"h2"}}),Ce=new b({props:{name:"class diffusers.image_processor.IPAdapterMaskProcessor",anchor:"diffusers.image_processor.IPAdapterMaskProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"vae_scale_factor",val:": int = 8"},{name:"resample",val:": str = 'lanczos'"},{name:"do_normalize",val:": bool = False"},{name:"do_binarize",val:": bool = True"},{name:"do_convert_grayscale",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.image_processor.IPAdapterMaskProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to downscale the image&#x2019;s (height, width) dimensions to multiples of <code>vae_scale_factor</code>.`,name:"do_resize"},{anchor:"diffusers.image_processor.IPAdapterMaskProcessor.vae_scale_factor",description:`<strong>vae_scale_factor</strong> (<code>int</code>, <em>optional</em>, defaults to <code>8</code>) &#x2014;
VAE scale factor. If <code>do_resize</code> is <code>True</code>, the image is automatically resized to multiples of this factor.`,name:"vae_scale_factor"},{anchor:"diffusers.image_processor.IPAdapterMaskProcessor.resample",description:`<strong>resample</strong> (<code>str</code>, <em>optional</em>, defaults to <code>lanczos</code>) &#x2014;
Resampling filter to use when resizing the image.`,name:"resample"},{anchor:"diffusers.image_processor.IPAdapterMaskProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize the image to [-1,1].`,name:"do_normalize"},{anchor:"diffusers.image_processor.IPAdapterMaskProcessor.do_binarize",description:`<strong>do_binarize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to binarize the image to 0/1.`,name:"do_binarize"},{anchor:"diffusers.image_processor.IPAdapterMaskProcessor.do_convert_grayscale",description:`<strong>do_convert_grayscale</strong> (<code>bool</code>, <em>optional</em>, defaults to be <code>True</code>) &#x2014;
Whether to convert the images to grayscale format.`,name:"do_convert_grayscale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L1116"}}),Ae=new b({props:{name:"downsample",anchor:"diffusers.image_processor.IPAdapterMaskProcessor.downsample",parameters:[{name:"mask",val:": Tensor"},{name:"batch_size",val:": int"},{name:"num_queries",val:": int"},{name:"value_embed_dim",val:": int"}],parametersDescription:[{anchor:"diffusers.image_processor.IPAdapterMaskProcessor.downsample.mask",description:`<strong>mask</strong> (<code>torch.Tensor</code>) &#x2014;
The input mask tensor generated with <code>IPAdapterMaskProcessor.preprocess()</code>.`,name:"mask"},{anchor:"diffusers.image_processor.IPAdapterMaskProcessor.downsample.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
The batch size.`,name:"batch_size"},{anchor:"diffusers.image_processor.IPAdapterMaskProcessor.downsample.num_queries",description:`<strong>num_queries</strong> (<code>int</code>) &#x2014;
The number of queries.`,name:"num_queries"},{anchor:"diffusers.image_processor.IPAdapterMaskProcessor.downsample.value_embed_dim",description:`<strong>value_embed_dim</strong> (<code>int</code>) &#x2014;
The dimensionality of the value embeddings.`,name:"value_embed_dim"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L1157",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The downsampled mask tensor.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),ke=new No({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/image_processor.md"}}),{c(){w=s("meta"),gt=r(),dt=s("p"),lt=r(),d(Q.$$.fragment),ft=r(),X=s("p"),X.innerHTML=Qr,ht=r(),Z=s("p"),Z.innerHTML=Xr,ut=r(),d(ee.$$.fragment),_t=r(),i=s("div"),d(te.$$.fragment),Xt=r(),Me=s("p"),Me.textContent=Zr,Zt=r(),T=s("div"),d(re.$$.fragment),er=r(),Ne=s("p"),Ne.textContent=eo,tr=r(),z=s("div"),d(oe.$$.fragment),rr=r(),Ee=s("p"),Ee.textContent=to,or=r(),L=s("div"),d(se.$$.fragment),sr=r(),We=s("p"),We.textContent=ro,ar=r(),D=s("div"),d(ae.$$.fragment),nr=r(),Re=s("p"),Re.textContent=oo,ir=r(),V=s("div"),d(ne.$$.fragment),cr=r(),Ue=s("p"),Ue.textContent=so,dr=r(),C=s("div"),d(ie.$$.fragment),mr=r(),He=s("p"),He.textContent=ao,pr=r(),A=s("div"),d(ce.$$.fragment),gr=r(),Oe=s("p"),Oe.textContent=no,lr=r(),k=s("div"),d(de.$$.fragment),fr=r(),Fe=s("p"),Fe.innerHTML=io,hr=r(),M=s("div"),d(me.$$.fragment),ur=r(),qe=s("p"),qe.textContent=co,_r=r(),N=s("div"),d(pe.$$.fragment),vr=r(),Ge=s("p"),Ge.textContent=mo,br=r(),E=s("div"),d(ge.$$.fragment),Ir=r(),Be=s("p"),Be.textContent=po,xr=r(),W=s("div"),d(le.$$.fragment),Pr=r(),je=s("p"),je.textContent=go,yr=r(),R=s("div"),d(fe.$$.fragment),$r=r(),Se=s("p"),Se.innerHTML=lo,wr=r(),U=s("div"),d(he.$$.fragment),Tr=r(),Ye=s("p"),Ye.textContent=fo,zr=r(),H=s("div"),d(ue.$$.fragment),Lr=r(),Je=s("p"),Je.textContent=ho,Dr=r(),O=s("div"),d(_e.$$.fragment),Vr=r(),Ke=s("p"),Ke.textContent=uo,vt=r(),d(ve.$$.fragment),bt=r(),be=s("p"),be.innerHTML=_o,It=r(),x=s("div"),d(Ie.$$.fragment),Cr=r(),Qe=s("p"),Qe.textContent=vo,Ar=r(),F=s("div"),d(xe.$$.fragment),kr=r(),Xe=s("p"),Xe.textContent=bo,Mr=r(),q=s("div"),d(Pe.$$.fragment),Nr=r(),Ze=s("p"),Ze.textContent=Io,Er=r(),G=s("div"),d(ye.$$.fragment),Wr=r(),et=s("p"),et.textContent=xo,Rr=r(),B=s("div"),d($e.$$.fragment),Ur=r(),tt=s("p"),tt.textContent=Po,Hr=r(),j=s("div"),d(we.$$.fragment),Or=r(),rt=s("p"),rt.textContent=yo,xt=r(),d(Te.$$.fragment),Pt=r(),y=s("div"),d(ze.$$.fragment),Fr=r(),ot=s("p"),ot.textContent=$o,qr=r(),S=s("div"),d(Le.$$.fragment),Gr=r(),st=s("p"),st.textContent=wo,Br=r(),Y=s("div"),d(De.$$.fragment),jr=r(),at=s("p"),at.textContent=To,yt=r(),d(Ve.$$.fragment),$t=r(),$=s("div"),d(Ce.$$.fragment),Sr=r(),nt=s("p"),nt.textContent=zo,Yr=r(),J=s("div"),d(Ae.$$.fragment),Jr=r(),it=s("p"),it.textContent=Lo,wt=r(),d(ke.$$.fragment),Tt=r(),mt=s("p"),this.h()},l(e){const h=Mo("svelte-u9bgzb",document.head);w=a(h,"META",{name:!0,content:!0}),h.forEach(n),gt=o(e),dt=a(e,"P",{}),_(dt).forEach(n),lt=o(e),m(Q.$$.fragment,e),ft=o(e),X=a(e,"P",{"data-svelte-h":!0}),u(X)!=="svelte-lut875"&&(X.innerHTML=Qr),ht=o(e),Z=a(e,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-15xkwv1"&&(Z.innerHTML=Xr),ut=o(e),m(ee.$$.fragment,e),_t=o(e),i=a(e,"DIV",{class:!0});var c=_(i);m(te.$$.fragment,c),Xt=o(c),Me=a(c,"P",{"data-svelte-h":!0}),u(Me)!=="svelte-20k7u4"&&(Me.textContent=Zr),Zt=o(c),T=a(c,"DIV",{class:!0});var Lt=_(T);m(re.$$.fragment,Lt),er=o(Lt),Ne=a(Lt,"P",{"data-svelte-h":!0}),u(Ne)!=="svelte-1rfnp0c"&&(Ne.textContent=eo),Lt.forEach(n),tr=o(c),z=a(c,"DIV",{class:!0});var Dt=_(z);m(oe.$$.fragment,Dt),rr=o(Dt),Ee=a(Dt,"P",{"data-svelte-h":!0}),u(Ee)!=="svelte-1jdqg5n"&&(Ee.textContent=to),Dt.forEach(n),or=o(c),L=a(c,"DIV",{class:!0});var Vt=_(L);m(se.$$.fragment,Vt),sr=o(Vt),We=a(Vt,"P",{"data-svelte-h":!0}),u(We)!=="svelte-1l3ylqr"&&(We.textContent=ro),Vt.forEach(n),ar=o(c),D=a(c,"DIV",{class:!0});var Ct=_(D);m(ae.$$.fragment,Ct),nr=o(Ct),Re=a(Ct,"P",{"data-svelte-h":!0}),u(Re)!=="svelte-1byxcdi"&&(Re.textContent=oo),Ct.forEach(n),ir=o(c),V=a(c,"DIV",{class:!0});var At=_(V);m(ne.$$.fragment,At),cr=o(At),Ue=a(At,"P",{"data-svelte-h":!0}),u(Ue)!=="svelte-ckvlrc"&&(Ue.textContent=so),At.forEach(n),dr=o(c),C=a(c,"DIV",{class:!0});var kt=_(C);m(ie.$$.fragment,kt),mr=o(kt),He=a(kt,"P",{"data-svelte-h":!0}),u(He)!=="svelte-ipi2rr"&&(He.textContent=ao),kt.forEach(n),pr=o(c),A=a(c,"DIV",{class:!0});var Mt=_(A);m(ce.$$.fragment,Mt),gr=o(Mt),Oe=a(Mt,"P",{"data-svelte-h":!0}),u(Oe)!=="svelte-1gkaazy"&&(Oe.textContent=no),Mt.forEach(n),lr=o(c),k=a(c,"DIV",{class:!0});var Nt=_(k);m(de.$$.fragment,Nt),fr=o(Nt),Fe=a(Nt,"P",{"data-svelte-h":!0}),u(Fe)!=="svelte-gf87un"&&(Fe.innerHTML=io),Nt.forEach(n),hr=o(c),M=a(c,"DIV",{class:!0});var Et=_(M);m(me.$$.fragment,Et),ur=o(Et),qe=a(Et,"P",{"data-svelte-h":!0}),u(qe)!=="svelte-1l17iqw"&&(qe.textContent=co),Et.forEach(n),_r=o(c),N=a(c,"DIV",{class:!0});var Wt=_(N);m(pe.$$.fragment,Wt),vr=o(Wt),Ge=a(Wt,"P",{"data-svelte-h":!0}),u(Ge)!=="svelte-49eriv"&&(Ge.textContent=mo),Wt.forEach(n),br=o(c),E=a(c,"DIV",{class:!0});var Rt=_(E);m(ge.$$.fragment,Rt),Ir=o(Rt),Be=a(Rt,"P",{"data-svelte-h":!0}),u(Be)!=="svelte-uauale"&&(Be.textContent=po),Rt.forEach(n),xr=o(c),W=a(c,"DIV",{class:!0});var Ut=_(W);m(le.$$.fragment,Ut),Pr=o(Ut),je=a(Ut,"P",{"data-svelte-h":!0}),u(je)!=="svelte-x3z8ka"&&(je.textContent=go),Ut.forEach(n),yr=o(c),R=a(c,"DIV",{class:!0});var Ht=_(R);m(fe.$$.fragment,Ht),$r=o(Ht),Se=a(Ht,"P",{"data-svelte-h":!0}),u(Se)!=="svelte-m705s9"&&(Se.innerHTML=lo),Ht.forEach(n),wr=o(c),U=a(c,"DIV",{class:!0});var Ot=_(U);m(he.$$.fragment,Ot),Tr=o(Ot),Ye=a(Ot,"P",{"data-svelte-h":!0}),u(Ye)!=="svelte-1p2bpse"&&(Ye.textContent=fo),Ot.forEach(n),zr=o(c),H=a(c,"DIV",{class:!0});var Ft=_(H);m(ue.$$.fragment,Ft),Lr=o(Ft),Je=a(Ft,"P",{"data-svelte-h":!0}),u(Je)!=="svelte-1acncdu"&&(Je.textContent=ho),Ft.forEach(n),Dr=o(c),O=a(c,"DIV",{class:!0});var qt=_(O);m(_e.$$.fragment,qt),Vr=o(qt),Ke=a(qt,"P",{"data-svelte-h":!0}),u(Ke)!=="svelte-si84j5"&&(Ke.textContent=uo),qt.forEach(n),c.forEach(n),vt=o(e),m(ve.$$.fragment,e),bt=o(e),be=a(e,"P",{"data-svelte-h":!0}),u(be)!=="svelte-12yfhhz"&&(be.innerHTML=_o),It=o(e),x=a(e,"DIV",{class:!0});var P=_(x);m(Ie.$$.fragment,P),Cr=o(P),Qe=a(P,"P",{"data-svelte-h":!0}),u(Qe)!=="svelte-bz065s"&&(Qe.textContent=vo),Ar=o(P),F=a(P,"DIV",{class:!0});var Gt=_(F);m(xe.$$.fragment,Gt),kr=o(Gt),Xe=a(Gt,"P",{"data-svelte-h":!0}),u(Xe)!=="svelte-x3z8ka"&&(Xe.textContent=bo),Gt.forEach(n),Mr=o(P),q=a(P,"DIV",{class:!0});var Bt=_(q);m(Pe.$$.fragment,Bt),Nr=o(Bt),Ze=a(Bt,"P",{"data-svelte-h":!0}),u(Ze)!=="svelte-taiq20"&&(Ze.textContent=Io),Bt.forEach(n),Er=o(P),G=a(P,"DIV",{class:!0});var jt=_(G);m(ye.$$.fragment,jt),Wr=o(jt),et=a(jt,"P",{"data-svelte-h":!0}),u(et)!=="svelte-6xu3xh"&&(et.textContent=xo),jt.forEach(n),Rr=o(P),B=a(P,"DIV",{class:!0});var St=_(B);m($e.$$.fragment,St),Ur=o(St),tt=a(St,"P",{"data-svelte-h":!0}),u(tt)!=="svelte-jw9t5f"&&(tt.textContent=Po),St.forEach(n),Hr=o(P),j=a(P,"DIV",{class:!0});var Yt=_(j);m(we.$$.fragment,Yt),Or=o(Yt),rt=a(Yt,"P",{"data-svelte-h":!0}),u(rt)!=="svelte-8ahhcq"&&(rt.textContent=yo),Yt.forEach(n),P.forEach(n),xt=o(e),m(Te.$$.fragment,e),Pt=o(e),y=a(e,"DIV",{class:!0});var K=_(y);m(ze.$$.fragment,K),Fr=o(K),ot=a(K,"P",{"data-svelte-h":!0}),u(ot)!=="svelte-saajey"&&(ot.textContent=$o),qr=o(K),S=a(K,"DIV",{class:!0});var Jt=_(S);m(Le.$$.fragment,Jt),Gr=o(Jt),st=a(Jt,"P",{"data-svelte-h":!0}),u(st)!=="svelte-1vfwv9u"&&(st.textContent=wo),Jt.forEach(n),Br=o(K),Y=a(K,"DIV",{class:!0});var Kt=_(Y);m(De.$$.fragment,Kt),jr=o(Kt),at=a(Kt,"P",{"data-svelte-h":!0}),u(at)!=="svelte-izj9xl"&&(at.textContent=To),Kt.forEach(n),K.forEach(n),yt=o(e),m(Ve.$$.fragment,e),$t=o(e),$=a(e,"DIV",{class:!0});var ct=_($);m(Ce.$$.fragment,ct),Sr=o(ct),nt=a(ct,"P",{"data-svelte-h":!0}),u(nt)!=="svelte-mxmwf6"&&(nt.textContent=zo),Yr=o(ct),J=a(ct,"DIV",{class:!0});var Qt=_(J);m(Ae.$$.fragment,Qt),Jr=o(Qt),it=a(Qt,"P",{"data-svelte-h":!0}),u(it)!=="svelte-1jm7ypm"&&(it.textContent=Lo),Qt.forEach(n),ct.forEach(n),wt=o(e),m(ke.$$.fragment,e),Tt=o(e),mt=a(e,"P",{}),_(mt).forEach(n),this.h()},h(){v(w,"name","hf:doc:metadata"),v(w,"content",Wo),v(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(i,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,h){t(document.head,w),I(e,gt,h),I(e,dt,h),I(e,lt,h),p(Q,e,h),I(e,ft,h),I(e,X,h),I(e,ht,h),I(e,Z,h),I(e,ut,h),p(ee,e,h),I(e,_t,h),I(e,i,h),p(te,i,null),t(i,Xt),t(i,Me),t(i,Zt),t(i,T),p(re,T,null),t(T,er),t(T,Ne),t(i,tr),t(i,z),p(oe,z,null),t(z,rr),t(z,Ee),t(i,or),t(i,L),p(se,L,null),t(L,sr),t(L,We),t(i,ar),t(i,D),p(ae,D,null),t(D,nr),t(D,Re),t(i,ir),t(i,V),p(ne,V,null),t(V,cr),t(V,Ue),t(i,dr),t(i,C),p(ie,C,null),t(C,mr),t(C,He),t(i,pr),t(i,A),p(ce,A,null),t(A,gr),t(A,Oe),t(i,lr),t(i,k),p(de,k,null),t(k,fr),t(k,Fe),t(i,hr),t(i,M),p(me,M,null),t(M,ur),t(M,qe),t(i,_r),t(i,N),p(pe,N,null),t(N,vr),t(N,Ge),t(i,br),t(i,E),p(ge,E,null),t(E,Ir),t(E,Be),t(i,xr),t(i,W),p(le,W,null),t(W,Pr),t(W,je),t(i,yr),t(i,R),p(fe,R,null),t(R,$r),t(R,Se),t(i,wr),t(i,U),p(he,U,null),t(U,Tr),t(U,Ye),t(i,zr),t(i,H),p(ue,H,null),t(H,Lr),t(H,Je),t(i,Dr),t(i,O),p(_e,O,null),t(O,Vr),t(O,Ke),I(e,vt,h),p(ve,e,h),I(e,bt,h),I(e,be,h),I(e,It,h),I(e,x,h),p(Ie,x,null),t(x,Cr),t(x,Qe),t(x,Ar),t(x,F),p(xe,F,null),t(F,kr),t(F,Xe),t(x,Mr),t(x,q),p(Pe,q,null),t(q,Nr),t(q,Ze),t(x,Er),t(x,G),p(ye,G,null),t(G,Wr),t(G,et),t(x,Rr),t(x,B),p($e,B,null),t(B,Ur),t(B,tt),t(x,Hr),t(x,j),p(we,j,null),t(j,Or),t(j,rt),I(e,xt,h),p(Te,e,h),I(e,Pt,h),I(e,y,h),p(ze,y,null),t(y,Fr),t(y,ot),t(y,qr),t(y,S),p(Le,S,null),t(S,Gr),t(S,st),t(y,Br),t(y,Y),p(De,Y,null),t(Y,jr),t(Y,at),I(e,yt,h),p(Ve,e,h),I(e,$t,h),I(e,$,h),p(Ce,$,null),t($,Sr),t($,nt),t($,Yr),t($,J),p(Ae,J,null),t(J,Jr),t(J,it),I(e,wt,h),p(ke,e,h),I(e,Tt,h),I(e,mt,h),zt=!0},p:Vo,i(e){zt||(g(Q.$$.fragment,e),g(ee.$$.fragment,e),g(te.$$.fragment,e),g(re.$$.fragment,e),g(oe.$$.fragment,e),g(se.$$.fragment,e),g(ae.$$.fragment,e),g(ne.$$.fragment,e),g(ie.$$.fragment,e),g(ce.$$.fragment,e),g(de.$$.fragment,e),g(me.$$.fragment,e),g(pe.$$.fragment,e),g(ge.$$.fragment,e),g(le.$$.fragment,e),g(fe.$$.fragment,e),g(he.$$.fragment,e),g(ue.$$.fragment,e),g(_e.$$.fragment,e),g(ve.$$.fragment,e),g(Ie.$$.fragment,e),g(xe.$$.fragment,e),g(Pe.$$.fragment,e),g(ye.$$.fragment,e),g($e.$$.fragment,e),g(we.$$.fragment,e),g(Te.$$.fragment,e),g(ze.$$.fragment,e),g(Le.$$.fragment,e),g(De.$$.fragment,e),g(Ve.$$.fragment,e),g(Ce.$$.fragment,e),g(Ae.$$.fragment,e),g(ke.$$.fragment,e),zt=!0)},o(e){l(Q.$$.fragment,e),l(ee.$$.fragment,e),l(te.$$.fragment,e),l(re.$$.fragment,e),l(oe.$$.fragment,e),l(se.$$.fragment,e),l(ae.$$.fragment,e),l(ne.$$.fragment,e),l(ie.$$.fragment,e),l(ce.$$.fragment,e),l(de.$$.fragment,e),l(me.$$.fragment,e),l(pe.$$.fragment,e),l(ge.$$.fragment,e),l(le.$$.fragment,e),l(fe.$$.fragment,e),l(he.$$.fragment,e),l(ue.$$.fragment,e),l(_e.$$.fragment,e),l(ve.$$.fragment,e),l(Ie.$$.fragment,e),l(xe.$$.fragment,e),l(Pe.$$.fragment,e),l(ye.$$.fragment,e),l($e.$$.fragment,e),l(we.$$.fragment,e),l(Te.$$.fragment,e),l(ze.$$.fragment,e),l(Le.$$.fragment,e),l(De.$$.fragment,e),l(Ve.$$.fragment,e),l(Ce.$$.fragment,e),l(Ae.$$.fragment,e),l(ke.$$.fragment,e),zt=!1},d(e){e&&(n(gt),n(dt),n(lt),n(ft),n(X),n(ht),n(Z),n(ut),n(_t),n(i),n(vt),n(bt),n(be),n(It),n(x),n(xt),n(Pt),n(y),n(yt),n($t),n($),n(wt),n(Tt),n(mt)),n(w),f(Q,e),f(ee,e),f(te),f(re),f(oe),f(se),f(ae),f(ne),f(ie),f(ce),f(de),f(me),f(pe),f(ge),f(le),f(fe),f(he),f(ue),f(_e),f(ve,e),f(Ie),f(xe),f(Pe),f(ye),f($e),f(we),f(Te,e),f(ze),f(Le),f(De),f(Ve,e),f(Ce),f(Ae),f(ke,e)}}}const Wo='{"title":"VAE Image Processor","local":"vae-image-processor","sections":[{"title":"VaeImageProcessor","local":"diffusers.image_processor.VaeImageProcessor","sections":[],"depth":2},{"title":"VaeImageProcessorLDM3D","local":"diffusers.image_processor.VaeImageProcessorLDM3D","sections":[],"depth":2},{"title":"PixArtImageProcessor","local":"diffusers.image_processor.PixArtImageProcessor","sections":[],"depth":2},{"title":"IPAdapterMaskProcessor","local":"diffusers.image_processor.IPAdapterMaskProcessor","sections":[],"depth":2}],"depth":1}';function Ro(Kr){return Co(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qo extends Ao{constructor(w){super(),ko(this,w,Ro,Eo,Do,{})}}export{qo as component};
