import{s as ct,o as ht,n as Ee}from"../chunks/scheduler.8c3d61f6.js";import{S as Mt,i as yt,g as o,s,r as u,A as bt,h as p,f as l,c as n,j as ut,u as r,x as f,k as rt,y as wt,a as i,v as d,d as c,t as h,w as M}from"../chunks/index.da70eac4.js";import{T as Xe}from"../chunks/Tip.1d9b8c37.js";import{C as $}from"../chunks/CodeBlock.a9c4becf.js";import{H as dt,E as _t}from"../chunks/index.dfbaf638.js";function vt(w){let a,y='Refer to the <a href="https://huggingface.co/docs/accelerate/main/en/concept_guides/big_model_inference" rel="nofollow">Handling big models for inference</a> guide for general guidance when working with big models that are hard to fit into memory.';return{c(){a=o("p"),a.innerHTML=y},l(m){a=p(m,"P",{"data-svelte-h":!0}),f(a)!=="svelte-6g79u0"&&(a.innerHTML=y)},m(m,b){i(m,a,b)},p:Ee,d(m){m&&l(a)}}}function Tt(w){let a,y="This feature is experimental and its APIs might change in the future.";return{c(){a=o("p"),a.textContent=y},l(m){a=p(m,"P",{"data-svelte-h":!0}),f(a)!=="svelte-jtjc2m"&&(a.textContent=y)},m(m,b){i(m,a,b)},p:Ee,d(m){m&&l(a)}}}function $t(w){let a,y="Only the “balanced” strategy is supported at the moment, and we plan to support additional mapping strategies in the future.";return{c(){a=o("p"),a.textContent=y},l(m){a=p(m,"P",{"data-svelte-h":!0}),f(a)!=="svelte-qgg1n4"&&(a.textContent=y)},m(m,b){i(m,a,b)},p:Ee,d(m){m&&l(a)}}}function Jt(w){let a,y,m,b,J,ie,U,He='A modern diffusion model, like <a href="../using-diffusers/sdxl">Stable Diffusion XL (SDXL)</a>, is not just a single model, but a collection of multiple models. SDXL has four different model-level components:',se,Z,Se="<li>A variational autoencoder (VAE)</li> <li>Two text encoders</li> <li>A UNet for denoising</li>",ne,g,Ve="Usually, the text encoders and the denoiser are much larger compared to the VAE.",ae,C,qe="As models get bigger and better, it’s possible your model is so big that even a single copy won’t fit in memory. But that doesn’t mean it can’t be loaded. If you have more than one GPU, there is more memory available to store your model. In this case, it’s better to split your model checkpoint into several smaller <em>checkpoint shards</em>.",oe,x,Ne='When a text encoder checkpoint has multiple shards, like <a href="https://huggingface.co/stabilityai/stable-diffusion-3-medium-diffusers/tree/main/text_encoder_3" rel="nofollow">T5-xxl for SD3</a>, it is automatically handled by the <a href="https://huggingface.co/docs/transformers/index" rel="nofollow">Transformers</a> library as it is a required dependency of Diffusers when using the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_3#diffusers.StableDiffusion3Pipeline">StableDiffusion3Pipeline</a>. More specifically, Transformers will automatically handle the loading of multiple shards within the requested model class and get it ready so that inference can be performed.',pe,G,Ye='The denoiser checkpoint can also have multiple shards and supports inference thanks to the <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate</a> library.',fe,_,me,j,De='For example, let’s save a sharded checkpoint for the <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0/tree/main/unet" rel="nofollow">SDXL UNet</a>:',ue,W,re,B,Qe='The size of the fp32 variant of the SDXL UNet checkpoint is ~10.4GB. Set the <code>max_shard_size</code> parameter to 5GB to create 3 shards. After saving, you can load them in <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a>:',de,k,ce,I,ze='If placing all the model-level components on the GPU at once is not feasible, use <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> to help you:',he,R,Me,L,Ae="In general, we recommend sharding when a checkpoint is more than 5GB (in fp32).",ye,P,be,X,Fe="On distributed setups, you can run inference across multiple GPUs with Accelerate.",we,v,_e,E,Ke="With Accelerate, you can use the <code>device_map</code> to determine how to distribute the models of a pipeline across multiple devices. This is useful in situations where you have more than one GPU.",ve,H,Oe='For example, if you have two 8GB GPUs, then using <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> may not work so well because:',Te,S,et='<li>it only works on a single GPU</li> <li>a single model might not fit on a single GPU (<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a> might work but it will be extremely slow and it is also limited to a single GPU)</li>',$e,V,tt="To make use of both GPUs, you can use the “balanced” device placement strategy which splits the models across all available GPUs.",Je,T,Ue,q,Ze,N,lt="You can also pass a dictionary to enforce the maximum GPU memory that can be used on each device:",ge,Y,Ce,D,it="If a device is not present in <code>max_memory</code>, then it will be completely ignored and will not participate in the device placement.",xe,Q,st='By default, Diffusers uses the maximum memory of all devices. If the models don’t fit on the GPUs, they are offloaded to the CPU. If the CPU doesn’t have enough memory, then you might see an error. In that case, you could defer to using <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a> and <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a>.',Ge,z,nt='Call <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.reset_device_map">reset_device_map()</a> to reset the <code>device_map</code> of a pipeline. This is also necessary if you want to use methods like <code>to()</code>, <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a>, and <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> on a pipeline that was device-mapped.',je,A,We,F,at="Once a pipeline has been device-mapped, you can also access its device map via <code>hf_device_map</code>:",Be,K,ke,O,ot="An example device map would look like so:",Ie,ee,Re,te,Le,le,Pe;return J=new dt({props:{title:"Working with big models",local:"working-with-big-models",headingTag:"h1"}}),_=new Xe({props:{warning:!1,$$slots:{default:[vt]},$$scope:{ctx:w}}}),W=new $({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQSUwQXVuZXQlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIlMEEpJTBBdW5ldC5zYXZlX3ByZXRyYWluZWQoJTIyc2R4bC11bmV0LXNoYXJkZWQlMjIlMkMlMjBtYXhfc2hhcmRfc2l6ZSUzRCUyMjVHQiUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel

unet = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>
)
unet.save_pretrained(<span class="hljs-string">&quot;sdxl-unet-sharded&quot;</span>, max_shard_size=<span class="hljs-string">&quot;5GB&quot;</span>)`,wrap:!1}}),k=new $({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUyQyUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXVuZXQlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnNheWFrcGF1bCUyRnNkeGwtdW5ldC1zaGFyZGVkJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwdW5ldCUzRHVuZXQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMjJhJTIwY3V0ZSUyMGRvZyUyMHJ1bm5pbmclMjBvbiUyMHRoZSUyMGdyYXNzJTIyJTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDMwKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJkb2cucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, StableDiffusionXLPipeline
<span class="hljs-keyword">import</span> torch

unet = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;sayakpaul/sdxl-unet-sharded&quot;</span>, torch_dtype=torch.float16
)
pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, unet=unet, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipeline(<span class="hljs-string">&quot;a cute dog running on the grass&quot;</span>, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;dog.png&quot;</span>)`,wrap:!1}}),R=new $({props:{code:"LSUyMHBpcGVsaW5lLnRvKCUyMmN1ZGElMjIpJTBBJTJCJTIwcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCk=",highlighted:`<span class="hljs-deletion">- pipeline.to(&quot;cuda&quot;)</span>
<span class="hljs-addition">+ pipeline.enable_model_cpu_offload()</span>`,wrap:!1}}),P=new dt({props:{title:"Device placement",local:"device-placement",headingTag:"h2"}}),v=new Xe({props:{warning:!0,$$slots:{default:[Tt]},$$scope:{ctx:w}}}),T=new Xe({props:{warning:!0,$$slots:{default:[$t]},$$scope:{ctx:w}}}),q=new $({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEEtJTIwJTIwJTIwJTIwJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSUyQiUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYmFsYW5jZWQlMjIlMEEpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMjJhJTIwZG9nJTIyKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`from diffusers import DiffusionPipeline
import torch

pipeline = DiffusionPipeline.from_pretrained(
<span class="hljs-deletion">-    &quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;, torch_dtype=torch.float16, use_safetensors=True,</span>
<span class="hljs-addition">+    &quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;, torch_dtype=torch.float16, use_safetensors=True, device_map=&quot;balanced&quot;</span>
)
image = pipeline(&quot;a dog&quot;).images[0]
image`,wrap:!1}}),Y=new $({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtYXhfbWVtb3J5JTIwJTNEJTIwJTdCMCUzQSUyMjFHQiUyMiUyQyUyMDElM0ElMjIxR0IlMjIlN0QlMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmJhbGFuY2VkJTIyJTJDJTBBJTJCJTIwJTIwJTIwbWF4X21lbW9yeSUzRG1heF9tZW1vcnklMEEpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMjJhJTIwZG9nJTIyKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`from diffusers import DiffusionPipeline
import torch

max_memory = {0:&quot;1GB&quot;, 1:&quot;1GB&quot;}
pipeline = DiffusionPipeline.from_pretrained(
    &quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;,
    torch_dtype=torch.float16,
    use_safetensors=True,
    device_map=&quot;balanced&quot;,
<span class="hljs-addition">+   max_memory=max_memory</span>
)
image = pipeline(&quot;a dog&quot;).images[0]
image`,wrap:!1}}),A=new $({props:{code:"cGlwZWxpbmUucmVzZXRfZGV2aWNlX21hcCgp",highlighted:"pipeline.reset_device_map()",wrap:!1}}),K=new $({props:{code:"cHJpbnQocGlwZWxpbmUuaGZfZGV2aWNlX21hcCk=",highlighted:'<span class="hljs-built_in">print</span>(pipeline.hf_device_map)',wrap:!1}}),ee=new $({props:{code:"JTdCJ3VuZXQnJTNBJTIwMSUyQyUyMCd2YWUnJTNBJTIwMSUyQyUyMCdzYWZldHlfY2hlY2tlciclM0ElMjAwJTJDJTIwJ3RleHRfZW5jb2RlciclM0ElMjAwJTdE",highlighted:'{<span class="hljs-string">&#x27;unet&#x27;</span>: 1, <span class="hljs-string">&#x27;vae&#x27;</span>: 1, <span class="hljs-string">&#x27;safety_checker&#x27;</span>: 0, <span class="hljs-string">&#x27;text_encoder&#x27;</span>: 0}',wrap:!1}}),te=new _t({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/tutorials/inference_with_big_models.md"}}),{c(){a=o("meta"),y=s(),m=o("p"),b=s(),u(J.$$.fragment),ie=s(),U=o("p"),U.innerHTML=He,se=s(),Z=o("ul"),Z.innerHTML=Se,ne=s(),g=o("p"),g.textContent=Ve,ae=s(),C=o("p"),C.innerHTML=qe,oe=s(),x=o("p"),x.innerHTML=Ne,pe=s(),G=o("p"),G.innerHTML=Ye,fe=s(),u(_.$$.fragment),me=s(),j=o("p"),j.innerHTML=De,ue=s(),u(W.$$.fragment),re=s(),B=o("p"),B.innerHTML=Qe,de=s(),u(k.$$.fragment),ce=s(),I=o("p"),I.innerHTML=ze,he=s(),u(R.$$.fragment),Me=s(),L=o("p"),L.textContent=Ae,ye=s(),u(P.$$.fragment),be=s(),X=o("p"),X.textContent=Fe,we=s(),u(v.$$.fragment),_e=s(),E=o("p"),E.innerHTML=Ke,ve=s(),H=o("p"),H.innerHTML=Oe,Te=s(),S=o("ul"),S.innerHTML=et,$e=s(),V=o("p"),V.textContent=tt,Je=s(),u(T.$$.fragment),Ue=s(),u(q.$$.fragment),Ze=s(),N=o("p"),N.textContent=lt,ge=s(),u(Y.$$.fragment),Ce=s(),D=o("p"),D.innerHTML=it,xe=s(),Q=o("p"),Q.innerHTML=st,Ge=s(),z=o("p"),z.innerHTML=nt,je=s(),u(A.$$.fragment),We=s(),F=o("p"),F.innerHTML=at,Be=s(),u(K.$$.fragment),ke=s(),O=o("p"),O.textContent=ot,Ie=s(),u(ee.$$.fragment),Re=s(),u(te.$$.fragment),Le=s(),le=o("p"),this.h()},l(e){const t=bt("svelte-u9bgzb",document.head);a=p(t,"META",{name:!0,content:!0}),t.forEach(l),y=n(e),m=p(e,"P",{}),ut(m).forEach(l),b=n(e),r(J.$$.fragment,e),ie=n(e),U=p(e,"P",{"data-svelte-h":!0}),f(U)!=="svelte-i5ki63"&&(U.innerHTML=He),se=n(e),Z=p(e,"UL",{"data-svelte-h":!0}),f(Z)!=="svelte-di8t2m"&&(Z.innerHTML=Se),ne=n(e),g=p(e,"P",{"data-svelte-h":!0}),f(g)!=="svelte-141shqw"&&(g.textContent=Ve),ae=n(e),C=p(e,"P",{"data-svelte-h":!0}),f(C)!=="svelte-n27w9x"&&(C.innerHTML=qe),oe=n(e),x=p(e,"P",{"data-svelte-h":!0}),f(x)!=="svelte-6f3u1x"&&(x.innerHTML=Ne),pe=n(e),G=p(e,"P",{"data-svelte-h":!0}),f(G)!=="svelte-igij6y"&&(G.innerHTML=Ye),fe=n(e),r(_.$$.fragment,e),me=n(e),j=p(e,"P",{"data-svelte-h":!0}),f(j)!=="svelte-bu4e6r"&&(j.innerHTML=De),ue=n(e),r(W.$$.fragment,e),re=n(e),B=p(e,"P",{"data-svelte-h":!0}),f(B)!=="svelte-1sph058"&&(B.innerHTML=Qe),de=n(e),r(k.$$.fragment,e),ce=n(e),I=p(e,"P",{"data-svelte-h":!0}),f(I)!=="svelte-rp98jd"&&(I.innerHTML=ze),he=n(e),r(R.$$.fragment,e),Me=n(e),L=p(e,"P",{"data-svelte-h":!0}),f(L)!=="svelte-110kwsj"&&(L.textContent=Ae),ye=n(e),r(P.$$.fragment,e),be=n(e),X=p(e,"P",{"data-svelte-h":!0}),f(X)!=="svelte-17ssrfq"&&(X.textContent=Fe),we=n(e),r(v.$$.fragment,e),_e=n(e),E=p(e,"P",{"data-svelte-h":!0}),f(E)!=="svelte-1y4i1fz"&&(E.innerHTML=Ke),ve=n(e),H=p(e,"P",{"data-svelte-h":!0}),f(H)!=="svelte-11sq7ul"&&(H.innerHTML=Oe),Te=n(e),S=p(e,"UL",{"data-svelte-h":!0}),f(S)!=="svelte-wjj3fr"&&(S.innerHTML=et),$e=n(e),V=p(e,"P",{"data-svelte-h":!0}),f(V)!=="svelte-awezto"&&(V.textContent=tt),Je=n(e),r(T.$$.fragment,e),Ue=n(e),r(q.$$.fragment,e),Ze=n(e),N=p(e,"P",{"data-svelte-h":!0}),f(N)!=="svelte-1y8b6l8"&&(N.textContent=lt),ge=n(e),r(Y.$$.fragment,e),Ce=n(e),D=p(e,"P",{"data-svelte-h":!0}),f(D)!=="svelte-fmsbbs"&&(D.innerHTML=it),xe=n(e),Q=p(e,"P",{"data-svelte-h":!0}),f(Q)!=="svelte-izwtcw"&&(Q.innerHTML=st),Ge=n(e),z=p(e,"P",{"data-svelte-h":!0}),f(z)!=="svelte-dkgqfm"&&(z.innerHTML=nt),je=n(e),r(A.$$.fragment,e),We=n(e),F=p(e,"P",{"data-svelte-h":!0}),f(F)!=="svelte-17pbny5"&&(F.innerHTML=at),Be=n(e),r(K.$$.fragment,e),ke=n(e),O=p(e,"P",{"data-svelte-h":!0}),f(O)!=="svelte-18o6tiw"&&(O.textContent=ot),Ie=n(e),r(ee.$$.fragment,e),Re=n(e),r(te.$$.fragment,e),Le=n(e),le=p(e,"P",{}),ut(le).forEach(l),this.h()},h(){rt(a,"name","hf:doc:metadata"),rt(a,"content",Ut)},m(e,t){wt(document.head,a),i(e,y,t),i(e,m,t),i(e,b,t),d(J,e,t),i(e,ie,t),i(e,U,t),i(e,se,t),i(e,Z,t),i(e,ne,t),i(e,g,t),i(e,ae,t),i(e,C,t),i(e,oe,t),i(e,x,t),i(e,pe,t),i(e,G,t),i(e,fe,t),d(_,e,t),i(e,me,t),i(e,j,t),i(e,ue,t),d(W,e,t),i(e,re,t),i(e,B,t),i(e,de,t),d(k,e,t),i(e,ce,t),i(e,I,t),i(e,he,t),d(R,e,t),i(e,Me,t),i(e,L,t),i(e,ye,t),d(P,e,t),i(e,be,t),i(e,X,t),i(e,we,t),d(v,e,t),i(e,_e,t),i(e,E,t),i(e,ve,t),i(e,H,t),i(e,Te,t),i(e,S,t),i(e,$e,t),i(e,V,t),i(e,Je,t),d(T,e,t),i(e,Ue,t),d(q,e,t),i(e,Ze,t),i(e,N,t),i(e,ge,t),d(Y,e,t),i(e,Ce,t),i(e,D,t),i(e,xe,t),i(e,Q,t),i(e,Ge,t),i(e,z,t),i(e,je,t),d(A,e,t),i(e,We,t),i(e,F,t),i(e,Be,t),d(K,e,t),i(e,ke,t),i(e,O,t),i(e,Ie,t),d(ee,e,t),i(e,Re,t),d(te,e,t),i(e,Le,t),i(e,le,t),Pe=!0},p(e,[t]){const pt={};t&2&&(pt.$$scope={dirty:t,ctx:e}),_.$set(pt);const ft={};t&2&&(ft.$$scope={dirty:t,ctx:e}),v.$set(ft);const mt={};t&2&&(mt.$$scope={dirty:t,ctx:e}),T.$set(mt)},i(e){Pe||(c(J.$$.fragment,e),c(_.$$.fragment,e),c(W.$$.fragment,e),c(k.$$.fragment,e),c(R.$$.fragment,e),c(P.$$.fragment,e),c(v.$$.fragment,e),c(T.$$.fragment,e),c(q.$$.fragment,e),c(Y.$$.fragment,e),c(A.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),Pe=!0)},o(e){h(J.$$.fragment,e),h(_.$$.fragment,e),h(W.$$.fragment,e),h(k.$$.fragment,e),h(R.$$.fragment,e),h(P.$$.fragment,e),h(v.$$.fragment,e),h(T.$$.fragment,e),h(q.$$.fragment,e),h(Y.$$.fragment,e),h(A.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),Pe=!1},d(e){e&&(l(y),l(m),l(b),l(ie),l(U),l(se),l(Z),l(ne),l(g),l(ae),l(C),l(oe),l(x),l(pe),l(G),l(fe),l(me),l(j),l(ue),l(re),l(B),l(de),l(ce),l(I),l(he),l(Me),l(L),l(ye),l(be),l(X),l(we),l(_e),l(E),l(ve),l(H),l(Te),l(S),l($e),l(V),l(Je),l(Ue),l(Ze),l(N),l(ge),l(Ce),l(D),l(xe),l(Q),l(Ge),l(z),l(je),l(We),l(F),l(Be),l(ke),l(O),l(Ie),l(Re),l(Le),l(le)),l(a),M(J,e),M(_,e),M(W,e),M(k,e),M(R,e),M(P,e),M(v,e),M(T,e),M(q,e),M(Y,e),M(A,e),M(K,e),M(ee,e),M(te,e)}}}const Ut='{"title":"Working with big models","local":"working-with-big-models","sections":[{"title":"Device placement","local":"device-placement","sections":[],"depth":2}],"depth":1}';function Zt(w){return ht(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wt extends Mt{constructor(a){super(),yt(this,a,Zt,Jt,ct,{})}}export{Wt as component};
