import{s as Xt,n as zt,o as kt}from"../chunks/scheduler.8c3d61f6.js";import{S as vt,i as qt,g as i,s,r as o,A as _t,h as m,f as l,c as a,j as Ft,u as p,x as c,k as $t,y as Yt,a as n,v as r,d as u,t as d,w as y}from"../chunks/index.da70eac4.js";import{C as G}from"../chunks/CodeBlock.a9c4becf.js";import{H as B,E as xt}from"../chunks/index.dfbaf638.js";function Bt(Jt){let M,E,N,H,f,L,w,Tt='<a href="https://github.com/huggingface/optimum-quanto" rel="nofollow">Quanto</a> is a PyTorch quantization backend for <a href="https://huggingface.co/docs/optimum/en/index" rel="nofollow">Optimum</a>. It has been designed with versatility and simplicity in mind:',S,h,bt="<li>All features are available in eager mode (works with non-traceable models)</li> <li>Supports quantization aware training</li> <li>Quantized models are compatible with <code>torch.compile</code></li> <li>Quantized models are Device agnostic (e.g CUDA,XPU,MPS,CPU)</li>",A,J,Ut="In order to use the Quanto backend, you will first need to install <code>optimum-quanto&gt;=0.2.6</code> and <code>accelerate</code>",D,T,P,b,Zt="Now you can quantize a model by passing the <code>QuantoConfig</code> object to the <code>from_pretrained()</code> method. Although the Quanto library does allow quantizing <code>nn.Conv2d</code> and <code>nn.LayerNorm</code> modules, currently, Diffusers only supports quantizing the weights in the <code>nn.Linear</code> layers of a model. The following snippet demonstrates how to apply <code>float8</code> quantization with Quanto.",K,U,O,Z,tt,g,gt="It is possible to skip applying quantization on certain modules using the <code>modules_to_not_convert</code> argument in the <code>QuantoConfig</code>. Please ensure that the modules passed in to this argument match the keys of the modules in the <code>state_dict</code>",et,W,lt,I,nt,j,Wt="<code>QuantoConfig</code> is compatible with <code>~FromOriginalModelMixin.from_single_file</code>.",st,C,at,R,it,Q,It="Diffusers supports serializing Quanto models using the <code>~ModelMixin.save_pretrained</code> method.",ot,F,jt=`The serialization and loading requirements are different for models quantized directly with the Quanto library and models quantized
with Diffusers using Quanto as the backend. It is currently not possible to load models quantized directly with Quanto into Diffusers using <code>~ModelMixin.from_pretrained</code>`,mt,$,pt,X,rt,z,Ct="Currently the Quanto backend supports <code>torch.compile</code> for the following quantization types:",ut,k,Rt="<li><code>int8</code> weights</li>",dt,v,yt,q,ct,_,Mt,Y,Qt="<li>float8</li> <li>int8</li> <li>int4</li> <li>int2</li>",ft,x,wt,V,ht;return f=new B({props:{title:"Quanto",local:"quanto",headingTag:"h1"}}),T=new G({props:{code:"cGlwJTIwaW5zdGFsbCUyMG9wdGltdW0tcXVhbnRvJTIwYWNjZWxlcmF0ZQ==",highlighted:"pip install optimum-quanto accelerate",wrap:!1}}),U=new G({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbCUyQyUyMFF1YW50b0NvbmZpZyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMFF1YW50b0NvbmZpZyh3ZWlnaHRzX2R0eXBlJTNEJTIyZmxvYXQ4JTIyKSUwQXRyYW5zZm9ybWVyJTIwJTNEJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSklMEElMEFwaXBlJTIwJTNEJTIwRmx1eFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRyYW5zZm9ybWVyJTNEdHJhbnNmb3JtZXIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoX2R0eXBlKSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNENC41JTJDJTIwbWF4X3NlcXVlbmNlX2xlbmd0aCUzRDUxMiUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyb3V0cHV0LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel, QuantoConfig

model_id = <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>
quantization_config = QuantoConfig(weights_dtype=<span class="hljs-string">&quot;float8&quot;</span>)
transformer = FluxTransformer2DModel.from_pretrained(
      model_id,
      subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
      quantization_config=quantization_config,
      torch_dtype=torch.bfloat16,
)

pipe = FluxPipeline.from_pretrained(model_id, transformer=transformer, torch_dtype=torch_dtype)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
image = pipe(
    prompt, num_inference_steps=<span class="hljs-number">50</span>, guidance_scale=<span class="hljs-number">4.5</span>, max_sequence_length=<span class="hljs-number">512</span>
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),Z=new B({props:{title:"Skipping Quantization on specific modules",local:"skipping-quantization-on-specific-modules",headingTag:"h2"}}),W=new G({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbCUyQyUyMFF1YW50b0NvbmZpZyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMFF1YW50b0NvbmZpZyh3ZWlnaHRzX2R0eXBlJTNEJTIyZmxvYXQ4JTIyJTJDJTIwbW9kdWxlc190b19ub3RfY29udmVydCUzRCU1QiUyMnByb2pfb3V0JTIyJTVEKSUwQXRyYW5zZm9ybWVyJTIwJTNEJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel, QuantoConfig

model_id = <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>
quantization_config = QuantoConfig(weights_dtype=<span class="hljs-string">&quot;float8&quot;</span>, modules_to_not_convert=[<span class="hljs-string">&quot;proj_out&quot;</span>])
transformer = FluxTransformer2DModel.from_pretrained(
      model_id,
      subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
      quantization_config=quantization_config,
      torch_dtype=torch.bfloat16,
)`,wrap:!1}}),I=new B({props:{title:"Using from_single_file with the Quanto Backend",local:"using-fromsinglefile-with-the-quanto-backend",headingTag:"h2"}}),C=new G({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbCUyQyUyMFF1YW50b0NvbmZpZyUwQSUwQWNrcHRfcGF0aCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMkZibG9iJTJGbWFpbiUyRmZsdXgxLWRldi5zYWZldGVuc29ycyUyMiUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBRdWFudG9Db25maWcod2VpZ2h0c19kdHlwZSUzRCUyMmZsb2F0OCUyMiklMEF0cmFuc2Zvcm1lciUyMCUzRCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9zaW5nbGVfZmlsZShja3B0X3BhdGglMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel, QuantoConfig

ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/black-forest-labs/FLUX.1-dev/blob/main/flux1-dev.safetensors&quot;</span>
quantization_config = QuantoConfig(weights_dtype=<span class="hljs-string">&quot;float8&quot;</span>)
transformer = FluxTransformer2DModel.from_single_file(ckpt_path, quantization_config=quantization_config, torch_dtype=torch.bfloat16)`,wrap:!1}}),R=new B({props:{title:"Saving Quantized models",local:"saving-quantized-models",headingTag:"h2"}}),$=new G({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbCUyQyUyMFF1YW50b0NvbmZpZyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMFF1YW50b0NvbmZpZyh3ZWlnaHRzX2R0eXBlJTNEJTIyZmxvYXQ4JTIyKSUwQXRyYW5zZm9ybWVyJTIwJTNEJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSklMEElMjMlMjBzYXZlJTIwcXVhbnRpemVkJTIwbW9kZWwlMjB0byUyMHJldXNlJTBBdHJhbnNmb3JtZXIuc2F2ZV9wcmV0cmFpbmVkKCUyMiUzQ3lvdXIlMjBxdWFudGl6ZWQlMjBtb2RlbCUyMHNhdmUlMjBwYXRoJTNFJTIyKSUwQSUwQSUyMyUyMHlvdSUyMGNhbiUyMHJlbG9hZCUyMHlvdXIlMjBxdWFudGl6ZWQlMjBtb2RlbCUyMHdpdGglMEFtb2RlbCUyMCUzRCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMiUzQ3lvdXIlMjBxdWFudGl6ZWQlMjBtb2RlbCUyMHNhdmUlMjBwYXRoJTNFJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel, QuantoConfig

model_id = <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>
quantization_config = QuantoConfig(weights_dtype=<span class="hljs-string">&quot;float8&quot;</span>)
transformer = FluxTransformer2DModel.from_pretrained(
      model_id,
      subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
      quantization_config=quantization_config,
      torch_dtype=torch.bfloat16,
)
<span class="hljs-comment"># save quantized model to reuse</span>
transformer.save_pretrained(<span class="hljs-string">&quot;&lt;your quantized model save path&gt;&quot;</span>)

<span class="hljs-comment"># you can reload your quantized model with</span>
model = FluxTransformer2DModel.from_pretrained(<span class="hljs-string">&quot;&lt;your quantized model save path&gt;&quot;</span>)`,wrap:!1}}),X=new B({props:{title:"Using torch.compile with Quanto",local:"using-torchcompile-with-quanto",headingTag:"h2"}}),v=new G({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFBpcGVsaW5lJTJDJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbCUyQyUyMFF1YW50b0NvbmZpZyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMFF1YW50b0NvbmZpZyh3ZWlnaHRzX2R0eXBlJTNEJTIyaW50OCUyMiklMEF0cmFuc2Zvcm1lciUyMCUzRCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEpJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjB0b3JjaC5jb21waWxlKHRyYW5zZm9ybWVyJTJDJTIwbW9kZSUzRCUyMm1heC1hdXRvdHVuZSUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBJTBBcGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjB0cmFuc2Zvcm1lciUzRHRyYW5zZm9ybWVyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaF9kdHlwZSUwQSklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZSglMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMikuaW1hZ2VzJTVCMCU1RCUwQWltYWdlcy5zYXZlKCUyMmZsdXgtcXVhbnRvLWNvbXBpbGUucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline, FluxTransformer2DModel, QuantoConfig

model_id = <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>
quantization_config = QuantoConfig(weights_dtype=<span class="hljs-string">&quot;int8&quot;</span>)
transformer = FluxTransformer2DModel.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quantization_config,
    torch_dtype=torch.bfloat16,
)
transformer = torch.<span class="hljs-built_in">compile</span>(transformer, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

pipe = FluxPipeline.from_pretrained(
    model_id, transformer=transformer, torch_dtype=torch_dtype
)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
images = pipe(<span class="hljs-string">&quot;A cat holding a sign that says hello&quot;</span>).images[<span class="hljs-number">0</span>]
images.save(<span class="hljs-string">&quot;flux-quanto-compile.png&quot;</span>)`,wrap:!1}}),q=new B({props:{title:"Supported Quantization Types",local:"supported-quantization-types",headingTag:"h2"}}),_=new B({props:{title:"Weights",local:"weights",headingTag:"h3"}}),x=new xt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/quantization/quanto.md"}}),{c(){M=i("meta"),E=s(),N=i("p"),H=s(),o(f.$$.fragment),L=s(),w=i("p"),w.innerHTML=Tt,S=s(),h=i("ul"),h.innerHTML=bt,A=s(),J=i("p"),J.innerHTML=Ut,D=s(),o(T.$$.fragment),P=s(),b=i("p"),b.innerHTML=Zt,K=s(),o(U.$$.fragment),O=s(),o(Z.$$.fragment),tt=s(),g=i("p"),g.innerHTML=gt,et=s(),o(W.$$.fragment),lt=s(),o(I.$$.fragment),nt=s(),j=i("p"),j.innerHTML=Wt,st=s(),o(C.$$.fragment),at=s(),o(R.$$.fragment),it=s(),Q=i("p"),Q.innerHTML=It,ot=s(),F=i("p"),F.innerHTML=jt,mt=s(),o($.$$.fragment),pt=s(),o(X.$$.fragment),rt=s(),z=i("p"),z.innerHTML=Ct,ut=s(),k=i("ul"),k.innerHTML=Rt,dt=s(),o(v.$$.fragment),yt=s(),o(q.$$.fragment),ct=s(),o(_.$$.fragment),Mt=s(),Y=i("ul"),Y.innerHTML=Qt,ft=s(),o(x.$$.fragment),wt=s(),V=i("p"),this.h()},l(t){const e=_t("svelte-u9bgzb",document.head);M=m(e,"META",{name:!0,content:!0}),e.forEach(l),E=a(t),N=m(t,"P",{}),Ft(N).forEach(l),H=a(t),p(f.$$.fragment,t),L=a(t),w=m(t,"P",{"data-svelte-h":!0}),c(w)!=="svelte-wedqkd"&&(w.innerHTML=Tt),S=a(t),h=m(t,"UL",{"data-svelte-h":!0}),c(h)!=="svelte-yhikdz"&&(h.innerHTML=bt),A=a(t),J=m(t,"P",{"data-svelte-h":!0}),c(J)!=="svelte-18uawxu"&&(J.innerHTML=Ut),D=a(t),p(T.$$.fragment,t),P=a(t),b=m(t,"P",{"data-svelte-h":!0}),c(b)!=="svelte-il6k3t"&&(b.innerHTML=Zt),K=a(t),p(U.$$.fragment,t),O=a(t),p(Z.$$.fragment,t),tt=a(t),g=m(t,"P",{"data-svelte-h":!0}),c(g)!=="svelte-4moh48"&&(g.innerHTML=gt),et=a(t),p(W.$$.fragment,t),lt=a(t),p(I.$$.fragment,t),nt=a(t),j=m(t,"P",{"data-svelte-h":!0}),c(j)!=="svelte-80xlz7"&&(j.innerHTML=Wt),st=a(t),p(C.$$.fragment,t),at=a(t),p(R.$$.fragment,t),it=a(t),Q=m(t,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-1bdnm93"&&(Q.innerHTML=It),ot=a(t),F=m(t,"P",{"data-svelte-h":!0}),c(F)!=="svelte-18ura5r"&&(F.innerHTML=jt),mt=a(t),p($.$$.fragment,t),pt=a(t),p(X.$$.fragment,t),rt=a(t),z=m(t,"P",{"data-svelte-h":!0}),c(z)!=="svelte-1sftzs6"&&(z.innerHTML=Ct),ut=a(t),k=m(t,"UL",{"data-svelte-h":!0}),c(k)!=="svelte-4fwo66"&&(k.innerHTML=Rt),dt=a(t),p(v.$$.fragment,t),yt=a(t),p(q.$$.fragment,t),ct=a(t),p(_.$$.fragment,t),Mt=a(t),Y=m(t,"UL",{"data-svelte-h":!0}),c(Y)!=="svelte-gqdhfh"&&(Y.innerHTML=Qt),ft=a(t),p(x.$$.fragment,t),wt=a(t),V=m(t,"P",{}),Ft(V).forEach(l),this.h()},h(){$t(M,"name","hf:doc:metadata"),$t(M,"content",Gt)},m(t,e){Yt(document.head,M),n(t,E,e),n(t,N,e),n(t,H,e),r(f,t,e),n(t,L,e),n(t,w,e),n(t,S,e),n(t,h,e),n(t,A,e),n(t,J,e),n(t,D,e),r(T,t,e),n(t,P,e),n(t,b,e),n(t,K,e),r(U,t,e),n(t,O,e),r(Z,t,e),n(t,tt,e),n(t,g,e),n(t,et,e),r(W,t,e),n(t,lt,e),r(I,t,e),n(t,nt,e),n(t,j,e),n(t,st,e),r(C,t,e),n(t,at,e),r(R,t,e),n(t,it,e),n(t,Q,e),n(t,ot,e),n(t,F,e),n(t,mt,e),r($,t,e),n(t,pt,e),r(X,t,e),n(t,rt,e),n(t,z,e),n(t,ut,e),n(t,k,e),n(t,dt,e),r(v,t,e),n(t,yt,e),r(q,t,e),n(t,ct,e),r(_,t,e),n(t,Mt,e),n(t,Y,e),n(t,ft,e),r(x,t,e),n(t,wt,e),n(t,V,e),ht=!0},p:zt,i(t){ht||(u(f.$$.fragment,t),u(T.$$.fragment,t),u(U.$$.fragment,t),u(Z.$$.fragment,t),u(W.$$.fragment,t),u(I.$$.fragment,t),u(C.$$.fragment,t),u(R.$$.fragment,t),u($.$$.fragment,t),u(X.$$.fragment,t),u(v.$$.fragment,t),u(q.$$.fragment,t),u(_.$$.fragment,t),u(x.$$.fragment,t),ht=!0)},o(t){d(f.$$.fragment,t),d(T.$$.fragment,t),d(U.$$.fragment,t),d(Z.$$.fragment,t),d(W.$$.fragment,t),d(I.$$.fragment,t),d(C.$$.fragment,t),d(R.$$.fragment,t),d($.$$.fragment,t),d(X.$$.fragment,t),d(v.$$.fragment,t),d(q.$$.fragment,t),d(_.$$.fragment,t),d(x.$$.fragment,t),ht=!1},d(t){t&&(l(E),l(N),l(H),l(L),l(w),l(S),l(h),l(A),l(J),l(D),l(P),l(b),l(K),l(O),l(tt),l(g),l(et),l(lt),l(nt),l(j),l(st),l(at),l(it),l(Q),l(ot),l(F),l(mt),l(pt),l(rt),l(z),l(ut),l(k),l(dt),l(yt),l(ct),l(Mt),l(Y),l(ft),l(wt),l(V)),l(M),y(f,t),y(T,t),y(U,t),y(Z,t),y(W,t),y(I,t),y(C,t),y(R,t),y($,t),y(X,t),y(v,t),y(q,t),y(_,t),y(x,t)}}}const Gt='{"title":"Quanto","local":"quanto","sections":[{"title":"Skipping Quantization on specific modules","local":"skipping-quantization-on-specific-modules","sections":[],"depth":2},{"title":"Using from_single_file with the Quanto Backend","local":"using-fromsinglefile-with-the-quanto-backend","sections":[],"depth":2},{"title":"Saving Quantized models","local":"saving-quantized-models","sections":[],"depth":2},{"title":"Using torch.compile with Quanto","local":"using-torchcompile-with-quanto","sections":[],"depth":2},{"title":"Supported Quantization Types","local":"supported-quantization-types","sections":[{"title":"Weights","local":"weights","sections":[],"depth":3}],"depth":2}],"depth":1}';function Nt(Jt){return kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class St extends vt{constructor(M){super(),qt(this,M,Nt,Bt,Xt,{})}}export{St as component};
