import{s as ft,o as yt,n as ht}from"../chunks/scheduler.182ea377.js";import{S as Mt,i as bt,g as r,s as a,r as f,A as wt,h as m,f as l,c as n,j as ut,u as y,x as J,k as dt,y as Jt,a as s,v as h,d as M,t as b,w}from"../chunks/index.abf12888.js";import{T as gt}from"../chunks/Tip.230e2334.js";import{C as st}from"../chunks/CodeBlock.57fe6e13.js";import{H as E}from"../chunks/Heading.16916d63.js";function Zt(_){let i,Z='Make sure to check out the Stable Diffusion <a href="overview#tips">Tips</a> section to learn how to explore the tradeoff between scheduler speed and quality, and how to reuse pipeline components efficiently!',u,o,d='If you’re interested in using one of the official checkpoints for a task, explore the <a href="https://huggingface.co/CompVis" rel="nofollow">CompVis</a>, <a href="https://huggingface.co/runwayml" rel="nofollow">Runway</a>, and <a href="https://huggingface.co/stabilityai" rel="nofollow">Stability AI</a> Hub organizations!';return{c(){i=r("p"),i.innerHTML=Z,u=a(),o=r("p"),o.innerHTML=d},l(p){i=m(p,"P",{"data-svelte-h":!0}),J(i)!=="svelte-1ue9xpl"&&(i.innerHTML=Z),u=n(p),o=m(p,"P",{"data-svelte-h":!0}),J(o)!=="svelte-z4pn9c"&&(o.innerHTML=d)},m(p,c){s(p,i,c),s(p,u,c),s(p,o,c)},p:ht,d(p){p&&(l(i),l(u),l(o))}}}function Tt(_){let i,Z,u,o,d,p,c,at='Stable Diffusion 2 is a text-to-image <em>latent diffusion</em> model built upon the work of the original <a href="https://stability.ai/blog/stable-diffusion-public-release" rel="nofollow">Stable Diffusion</a>, and it was led by Robin Rombach and Katherine Crowson from <a href="https://stability.ai/" rel="nofollow">Stability AI</a> and <a href="https://laion.ai/" rel="nofollow">LAION</a>.',F,T,nt=`<em>The Stable Diffusion 2.0 release includes robust text-to-image models trained using a brand new text encoder (OpenCLIP), developed by LAION with support from Stability AI, which greatly improves the quality of the generated images compared to earlier V1 releases. The text-to-image models in this release can generate images with default resolutions of both 512x512 pixels and 768x768 pixels.
These models are trained on an aesthetic subset of the <a href="https://laion.ai/blog/laion-5b/" rel="nofollow">LAION-5B dataset</a> created by the DeepFloyd team at Stability AI, which is then further filtered to remove adult content using <a href="https://openreview.net/forum?id=M3Y74vmsMcY" rel="nofollow">LAION’s NSFW filter</a>.</em>`,V,U,it='For more details about how Stable Diffusion 2 works and how it differs from the original Stable Diffusion, please refer to the official <a href="https://stability.ai/blog/stable-diffusion-v2-release" rel="nofollow">announcement post</a>.',Y,j,pt='The architecture of Stable Diffusion 2 is more or less identical to the original <a href="./text2img">Stable Diffusion model</a> so check out it’s API documentation for how to use Stable Diffusion 2. We recommend using the <a href="/docs/diffusers/v0.22.0/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a> as it’s currently the fastest scheduler.',C,B,ot="Stable Diffusion 2 is available for tasks like text-to-image, inpainting, super-resolution, and depth-to-image:",x,W,rt='<thead><tr><th>Task</th> <th>Repository</th></tr></thead> <tbody><tr><td>text-to-image (512x512)</td> <td><a href="https://huggingface.co/stabilityai/stable-diffusion-2-base" rel="nofollow">stabilityai/stable-diffusion-2-base</a></td></tr> <tr><td>text-to-image (768x768)</td> <td><a href="https://huggingface.co/stabilityai/stable-diffusion-2" rel="nofollow">stabilityai/stable-diffusion-2</a></td></tr> <tr><td>inpainting</td> <td><a href="https://huggingface.co/stabilityai/stable-diffusion-2-inpainting" rel="nofollow">stabilityai/stable-diffusion-2-inpainting</a></td></tr> <tr><td>super-resolution</td> <td><a href="https://huggingface.co/stabilityai/stable-diffusion-x4-upscaler" rel="nofollow">stable-diffusion-x4-upscaler</a></td></tr> <tr><td>depth-to-image</td> <td><a href="https://huggingface.co/stabilityai/stable-diffusion-2-depth" rel="nofollow">stabilityai/stable-diffusion-2-depth</a></td></tr></tbody>',H,G,mt="Here are some examples for how to use Stable Diffusion 2 for each task:",z,g,q,I,L,X,D,k,A,v,P,S,K,R,O,Q,tt,N,et,$,lt;return d=new E({props:{title:"Stable Diffusion 2",local:"stable-diffusion-2",headingTag:"h1"}}),g=new gt({props:{$$slots:{default:[Zt]},$$scope:{ctx:_}}}),I=new E({props:{title:"Text-to-image",local:"text-to-image",headingTag:"h2"}}),X=new st({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTJDJTIwRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyJTBBaW1wb3J0JTIwdG9yY2glMEElMEFyZXBvX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItYmFzZSUyMiUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHJldmlzaW9uJTNEJTIyZnAxNiUyMiklMEElMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJIaWdoJTIwcXVhbGl0eSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMGluJTIwc3BhY2UlMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI1KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DPMSolverMultistepScheduler
<span class="hljs-keyword">import</span> torch

repo_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-base&quot;</span>
pipe = DiffusionPipeline.from_pretrained(repo_id, torch_dtype=torch.float16, revision=<span class="hljs-string">&quot;fp16&quot;</span>)

pipe.scheduler = DPMSolverMultistepScheduler.from_config(pipe.scheduler.config)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;High quality photo of an astronaut riding a horse in space&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)`,wrap:!1}}),k=new E({props:{title:"Inpainting",local:"inpainting",headingTag:"h2"}}),v=new st({props:{code:"aW1wb3J0JTIwUElMJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIlMEElMEElMEFkZWYlMjBkb3dubG9hZF9pbWFnZSh1cmwpJTNBJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMFBJTC5JbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1by5wbmclMjIlMEFtYXNrX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZsYXRlbnQtZGlmZnVzaW9uJTJGbWFpbiUyRmRhdGElMkZpbnBhaW50aW5nX2V4YW1wbGVzJTJGb3ZlcnR1cmUtY3JlYXRpb25zLTVzSTZmUWdZSXVvX21hc2sucG5nJTIyJTBBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGRvd25sb2FkX2ltYWdlKGltZ191cmwpLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEFtYXNrX2ltYWdlJTIwJTNEJTIwZG93bmxvYWRfaW1hZ2UobWFza191cmwpLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEElMEFyZXBvX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItaW5wYWludGluZyUyMiUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHJldmlzaW9uJTNEJTIyZnAxNiUyMiklMEElMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJGYWNlJTIwb2YlMjBhJTIweWVsbG93JTIwY2F0JTJDJTIwaGlnaCUyMHJlc29sdXRpb24lMkMlMjBzaXR0aW5nJTIwb24lMjBhJTIwcGFyayUyMGJlbmNoJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI1KS5pbWFnZXMlNUIwJTVEJTBBJTBBaW1hZ2Uuc2F2ZSglMjJ5ZWxsb3dfY2F0LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> PIL
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DPMSolverMultistepScheduler


<span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
    response = requests.get(url)
    <span class="hljs-keyword">return</span> PIL.Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)


img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
mask_image = download_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

repo_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-inpainting&quot;</span>
pipe = DiffusionPipeline.from_pretrained(repo_id, torch_dtype=torch.float16, revision=<span class="hljs-string">&quot;fp16&quot;</span>)

pipe.scheduler = DPMSolverMultistepScheduler.from_config(pipe.scheduler.config)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
image = pipe(prompt=prompt, image=init_image, mask_image=mask_image, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;yellow_cat.png&quot;</span>)`,wrap:!1}}),S=new E({props:{title:"Super-resolution",local:"super-resolution",headingTag:"h2"}}),R=new st({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblVwc2NhbGVQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBJTIzJTIwbG9hZCUyMG1vZGVsJTIwYW5kJTIwc2NoZWR1bGVyJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teDQtdXBzY2FsZXIlMjIlMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblVwc2NhbGVQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMGxldCdzJTIwZG93bmxvYWQlMjBhbiUyMCUyMGltYWdlJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnNkMi11cHNjYWxlJTJGbG93X3Jlc19jYXQucG5nJTIyJTBBcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQWxvd19yZXNfaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFsb3dfcmVzX2ltZyUyMCUzRCUyMGxvd19yZXNfaW1nLnJlc2l6ZSgoMTI4JTJDJTIwMTI4KSklMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwd2hpdGUlMjBjYXQlMjIlMEF1cHNjYWxlZF9pbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEbG93X3Jlc19pbWcpLmltYWdlcyU1QjAlNUQlMEF1cHNjYWxlZF9pbWFnZS5zYXZlKCUyMnVwc2FtcGxlZF9jYXQucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionUpscalePipeline
<span class="hljs-keyword">import</span> torch

<span class="hljs-comment"># load model and scheduler</span>
model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-x4-upscaler&quot;</span>
pipeline = StableDiffusionUpscalePipeline.from_pretrained(model_id, torch_dtype=torch.float16)
pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># let&#x27;s download an  image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd2-upscale/low_res_cat.png&quot;</span>
response = requests.get(url)
low_res_img = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
low_res_img = low_res_img.resize((<span class="hljs-number">128</span>, <span class="hljs-number">128</span>))
prompt = <span class="hljs-string">&quot;a white cat&quot;</span>
upscaled_image = pipeline(prompt=prompt, image=low_res_img).images[<span class="hljs-number">0</span>]
upscaled_image.save(<span class="hljs-string">&quot;upsampled_cat.png&quot;</span>)`,wrap:!1}}),Q=new E({props:{title:"Depth-to-image",local:"depth-to-image",headingTag:"h2"}}),N=new st({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQSUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBTdGFibGVEaWZmdXNpb25EZXB0aDJJbWdQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25EZXB0aDJJbWdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItZGVwdGglMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBcHJvbXB0JTIwJTNEJTIwJTIydHdvJTIwdGlnZXJzJTIyJTBBbl9wcm9wbXQlMjAlM0QlMjAlMjJiYWQlMkMlMjBkZWZvcm1lZCUyQyUyMHVnbHklMkMlMjBiYWQlMjBhbm90b215JTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG5lZ2F0aXZlX3Byb21wdCUzRG5fcHJvcG10JTJDJTIwc3RyZW5ndGglM0QwLjcpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionDepth2ImgPipeline

pipe = StableDiffusionDepth2ImgPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-depth&quot;</span>,
    torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)


url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
init_image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
prompt = <span class="hljs-string">&quot;two tigers&quot;</span>
n_propmt = <span class="hljs-string">&quot;bad, deformed, ugly, bad anotomy&quot;</span>
image = pipe(prompt=prompt, image=init_image, negative_prompt=n_propmt, strength=<span class="hljs-number">0.7</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){i=r("meta"),Z=a(),u=r("p"),o=a(),f(d.$$.fragment),p=a(),c=r("p"),c.innerHTML=at,F=a(),T=r("p"),T.innerHTML=nt,V=a(),U=r("p"),U.innerHTML=it,Y=a(),j=r("p"),j.innerHTML=pt,C=a(),B=r("p"),B.textContent=ot,x=a(),W=r("table"),W.innerHTML=rt,H=a(),G=r("p"),G.textContent=mt,z=a(),f(g.$$.fragment),q=a(),f(I.$$.fragment),L=a(),f(X.$$.fragment),D=a(),f(k.$$.fragment),A=a(),f(v.$$.fragment),P=a(),f(S.$$.fragment),K=a(),f(R.$$.fragment),O=a(),f(Q.$$.fragment),tt=a(),f(N.$$.fragment),et=a(),$=r("p"),this.h()},l(t){const e=wt("svelte-u9bgzb",document.head);i=m(e,"META",{name:!0,content:!0}),e.forEach(l),Z=n(t),u=m(t,"P",{}),ut(u).forEach(l),o=n(t),y(d.$$.fragment,t),p=n(t),c=m(t,"P",{"data-svelte-h":!0}),J(c)!=="svelte-b1fked"&&(c.innerHTML=at),F=n(t),T=m(t,"P",{"data-svelte-h":!0}),J(T)!=="svelte-14ofdwv"&&(T.innerHTML=nt),V=n(t),U=m(t,"P",{"data-svelte-h":!0}),J(U)!=="svelte-m1ataf"&&(U.innerHTML=it),Y=n(t),j=m(t,"P",{"data-svelte-h":!0}),J(j)!=="svelte-12mtw05"&&(j.innerHTML=pt),C=n(t),B=m(t,"P",{"data-svelte-h":!0}),J(B)!=="svelte-lmvyuh"&&(B.textContent=ot),x=n(t),W=m(t,"TABLE",{"data-svelte-h":!0}),J(W)!=="svelte-14nbvv4"&&(W.innerHTML=rt),H=n(t),G=m(t,"P",{"data-svelte-h":!0}),J(G)!=="svelte-1y4j0tz"&&(G.textContent=mt),z=n(t),y(g.$$.fragment,t),q=n(t),y(I.$$.fragment,t),L=n(t),y(X.$$.fragment,t),D=n(t),y(k.$$.fragment,t),A=n(t),y(v.$$.fragment,t),P=n(t),y(S.$$.fragment,t),K=n(t),y(R.$$.fragment,t),O=n(t),y(Q.$$.fragment,t),tt=n(t),y(N.$$.fragment,t),et=n(t),$=m(t,"P",{}),ut($).forEach(l),this.h()},h(){dt(i,"name","hf:doc:metadata"),dt(i,"content",Ut)},m(t,e){Jt(document.head,i),s(t,Z,e),s(t,u,e),s(t,o,e),h(d,t,e),s(t,p,e),s(t,c,e),s(t,F,e),s(t,T,e),s(t,V,e),s(t,U,e),s(t,Y,e),s(t,j,e),s(t,C,e),s(t,B,e),s(t,x,e),s(t,W,e),s(t,H,e),s(t,G,e),s(t,z,e),h(g,t,e),s(t,q,e),h(I,t,e),s(t,L,e),h(X,t,e),s(t,D,e),h(k,t,e),s(t,A,e),h(v,t,e),s(t,P,e),h(S,t,e),s(t,K,e),h(R,t,e),s(t,O,e),h(Q,t,e),s(t,tt,e),h(N,t,e),s(t,et,e),s(t,$,e),lt=!0},p(t,[e]){const ct={};e&2&&(ct.$$scope={dirty:e,ctx:t}),g.$set(ct)},i(t){lt||(M(d.$$.fragment,t),M(g.$$.fragment,t),M(I.$$.fragment,t),M(X.$$.fragment,t),M(k.$$.fragment,t),M(v.$$.fragment,t),M(S.$$.fragment,t),M(R.$$.fragment,t),M(Q.$$.fragment,t),M(N.$$.fragment,t),lt=!0)},o(t){b(d.$$.fragment,t),b(g.$$.fragment,t),b(I.$$.fragment,t),b(X.$$.fragment,t),b(k.$$.fragment,t),b(v.$$.fragment,t),b(S.$$.fragment,t),b(R.$$.fragment,t),b(Q.$$.fragment,t),b(N.$$.fragment,t),lt=!1},d(t){t&&(l(Z),l(u),l(o),l(p),l(c),l(F),l(T),l(V),l(U),l(Y),l(j),l(C),l(B),l(x),l(W),l(H),l(G),l(z),l(q),l(L),l(D),l(A),l(P),l(K),l(O),l(tt),l(et),l($)),l(i),w(d,t),w(g,t),w(I,t),w(X,t),w(k,t),w(v,t),w(S,t),w(R,t),w(Q,t),w(N,t)}}}const Ut='{"title":"Stable Diffusion 2","local":"stable-diffusion-2","sections":[{"title":"Text-to-image","local":"text-to-image","sections":[],"depth":2},{"title":"Inpainting","local":"inpainting","sections":[],"depth":2},{"title":"Super-resolution","local":"super-resolution","sections":[],"depth":2},{"title":"Depth-to-image","local":"depth-to-image","sections":[],"depth":2}],"depth":1}';function jt(_){return yt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class kt extends Mt{constructor(i){super(),bt(this,i,jt,Tt,ft,{})}}export{kt as component};
