import{s as Gt,o as Rt,n as Te}from"../chunks/scheduler.182ea377.js";import{S as Lt,i as Ht,g as d,s as o,r as $,A as Ft,h,f as n,c as r,j as Wt,u as w,x as g,k as It,y as Bt,a as s,v as M,d as b,t as _,w as v}from"../chunks/index.abf12888.js";import{T as rt}from"../chunks/Tip.230e2334.js";import{C as W}from"../chunks/CodeBlock.57fe6e13.js";import{F as Xt,M as pt}from"../chunks/Markdown.7a59e0fd.js";import{H as ve}from"../chunks/Heading.16916d63.js";function Nt(U){let t,m='There is a community-created collection of trained Textual Inversion models in the <a href="https://huggingface.co/sd-concepts-library" rel="nofollow">Stable Diffusion Textual Inversion Concepts Library</a> which are readily available for inference. Over time, this’ll hopefully grow into a useful resource as more concepts are added!';return{c(){t=d("p"),t.innerHTML=m},l(l){t=h(l,"P",{"data-svelte-h":!0}),g(t)!=="svelte-10iahyg"&&(t.innerHTML=m)},m(l,i){s(l,t,i)},p:Te,d(l){l&&n(t)}}}function Yt(U){let t,m='💡 A full training run takes ~1 hour on one V100 GPU. While you’re waiting for the training to complete, feel free to check out <a href="#how-it-works">how Textual Inversion works</a> in the section below if you’re curious!';return{c(){t=d("p"),t.innerHTML=m},l(l){t=h(l,"P",{"data-svelte-h":!0}),g(t)!=="svelte-1y2i2ao"&&(t.innerHTML=m)},m(l,i){s(l,t,i)},p:Te,d(l){l&&n(t)}}}function Vt(U){let t,m=`💡 If you want to increase the trainable capacity, you can associate your placeholder token, <em>e.g.</em> <code>&lt;cat-toy&gt;</code> to
multiple embedding vectors. This can help the model to better capture the style of more (complex) images.
To enable training multiple embedding vectors, simply pass:`,l,i,f;return i=new W({props:{code:"LS1udW1fdmVjdG9ycyUzRDU=",highlighted:"--num_vectors=5",wrap:!1}}),{c(){t=d("p"),t.innerHTML=m,l=o(),$(i.$$.fragment)},l(u){t=h(u,"P",{"data-svelte-h":!0}),g(t)!=="svelte-1ckgnyj"&&(t.innerHTML=m),l=r(u),w(i.$$.fragment,u)},m(u,y){s(u,t,y),s(u,l,y),M(i,u,y),f=!0},p:Te,i(u){f||(b(i.$$.fragment,u),f=!0)},o(u){_(i.$$.fragment,u),f=!1},d(u){u&&(n(t),n(l)),v(i,u)}}}function Et(U){let t,m,l,i;return t=new W({props:{code:"ZXhwb3J0JTIwTU9ERUxfTkFNRSUzRCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBZXhwb3J0JTIwREFUQV9ESVIlM0QlMjIuJTJGY2F0JTIyJTBBJTBBYWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRleHR1YWxfaW52ZXJzaW9uLnB5JTIwJTVDJTBBJTIwJTIwLS1wcmV0cmFpbmVkX21vZGVsX25hbWVfb3JfcGF0aCUzRCUyNE1PREVMX05BTUUlMjAlNUMlMEElMjAlMjAtLXRyYWluX2RhdGFfZGlyJTNEJTI0REFUQV9ESVIlMjAlNUMlMEElMjAlMjAtLWxlYXJuYWJsZV9wcm9wZXJ0eSUzRCUyMm9iamVjdCUyMiUyMCU1QyUwQSUyMCUyMC0tcGxhY2Vob2xkZXJfdG9rZW4lM0QlMjIlM0NjYXQtdG95JTNFJTIyJTIwLS1pbml0aWFsaXplcl90b2tlbiUzRCUyMnRveSUyMiUyMCU1QyUwQSUyMCUyMC0tcmVzb2x1dGlvbiUzRDUxMiUyMCU1QyUwQSUyMCUyMC0tdHJhaW5fYmF0Y2hfc2l6ZSUzRDElMjAlNUMlMEElMjAlMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDQlMjAlNUMlMEElMjAlMjAtLW1heF90cmFpbl9zdGVwcyUzRDMwMDAlMjAlNUMlMEElMjAlMjAtLWxlYXJuaW5nX3JhdGUlM0Q1LjBlLTA0JTIwLS1zY2FsZV9sciUyMCU1QyUwQSUyMCUyMC0tbHJfc2NoZWR1bGVyJTNEJTIyY29uc3RhbnQlMjIlMjAlNUMlMEElMjAlMjAtLWxyX3dhcm11cF9zdGVwcyUzRDAlMjAlNUMlMEElMjAlMjAtLW91dHB1dF9kaXIlM0QlMjJ0ZXh0dWFsX2ludmVyc2lvbl9jYXQlMjIlMjAlNUMlMEElMjAlMjAtLXB1c2hfdG9faHVi",highlighted:`<span class="hljs-built_in">export</span> MODEL_NAME=<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-built_in">export</span> DATA_DIR=<span class="hljs-string">&quot;./cat&quot;</span>

accelerate launch textual_inversion.py \\
  --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_NAME</span> \\
  --train_data_dir=<span class="hljs-variable">$DATA_DIR</span> \\
  --learnable_property=<span class="hljs-string">&quot;object&quot;</span> \\
  --placeholder_token=<span class="hljs-string">&quot;&lt;cat-toy&gt;&quot;</span> --initializer_token=<span class="hljs-string">&quot;toy&quot;</span> \\
  --resolution=512 \\
  --train_batch_size=1 \\
  --gradient_accumulation_steps=4 \\
  --max_train_steps=3000 \\
  --learning_rate=5.0e-04 --scale_lr \\
  --lr_scheduler=<span class="hljs-string">&quot;constant&quot;</span> \\
  --lr_warmup_steps=0 \\
  --output_dir=<span class="hljs-string">&quot;textual_inversion_cat&quot;</span> \\
  --push_to_hub`,wrap:!1}}),l=new rt({props:{$$slots:{default:[Vt]},$$scope:{ctx:U}}}),{c(){$(t.$$.fragment),m=o(),$(l.$$.fragment)},l(f){w(t.$$.fragment,f),m=r(f),w(l.$$.fragment,f)},m(f,u){M(t,f,u),s(f,m,u),M(l,f,u),i=!0},p(f,u){const y={};u&2&&(y.$$scope={dirty:u,ctx:f}),l.$set(y)},i(f){i||(b(t.$$.fragment,f),b(l.$$.fragment,f),i=!0)},o(f){_(t.$$.fragment,f),_(l.$$.fragment,f),i=!1},d(f){f&&n(m),v(t,f),v(l,f)}}}function St(U){let t,m;return t=new pt({props:{$$slots:{default:[Et]},$$scope:{ctx:U}}}),{c(){$(t.$$.fragment)},l(l){w(t.$$.fragment,l)},m(l,i){M(t,l,i),m=!0},p(l,i){const f={};i&2&&(f.$$scope={dirty:i,ctx:l}),t.$set(f)},i(l){m||(b(t.$$.fragment,l),m=!0)},o(l){_(t.$$.fragment,l),m=!1},d(l){v(t,l)}}}function Qt(U){let t,m='If you have access to TPUs, try out the <a href="https://github.com/huggingface/diffusers/blob/main/examples/textual_inversion/textual_inversion_flax.py" rel="nofollow">Flax training script</a> to train even faster (this’ll also work for GPUs). With the same configuration settings, the Flax training script should be at least 70% faster than the PyTorch training script! ⚡️',l,i,f="Before you begin, make sure you install the Flax specific dependencies:",u,y,k,T,j='Specify the <code>MODEL_NAME</code> environment variable (either a Hub model repository id or a path to the directory containing the model weights) and pass it to the <a href="https://huggingface.co/docs/diffusers/en/api/diffusion_pipeline#diffusers.DiffusionPipeline.from_pretrained.pretrained_model_name_or_path" rel="nofollow"><code>pretrained_model_name_or_path</code></a> argument.',G,I,Z='Then you can launch the <a href="https://github.com/huggingface/diffusers/blob/main/examples/textual_inversion/textual_inversion_flax.py" rel="nofollow">training script</a>:',H,X,C;return y=new W({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwLXIlMjByZXF1aXJlbWVudHNfZmxheC50eHQ=",highlighted:"pip install -U -r requirements_flax.txt",wrap:!1}}),X=new W({props:{code:"ZXhwb3J0JTIwTU9ERUxfTkFNRSUzRCUyMmR1b25nbmElMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQtZmxheCUyMiUwQWV4cG9ydCUyMERBVEFfRElSJTNEJTIyLiUyRmNhdCUyMiUwQSUwQXB5dGhvbiUyMHRleHR1YWxfaW52ZXJzaW9uX2ZsYXgucHklMjAlNUMlMEElMjAlMjAtLXByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTNEJTI0TU9ERUxfTkFNRSUyMCU1QyUwQSUyMCUyMC0tdHJhaW5fZGF0YV9kaXIlM0QlMjREQVRBX0RJUiUyMCU1QyUwQSUyMCUyMC0tbGVhcm5hYmxlX3Byb3BlcnR5JTNEJTIyb2JqZWN0JTIyJTIwJTVDJTBBJTIwJTIwLS1wbGFjZWhvbGRlcl90b2tlbiUzRCUyMiUzQ2NhdC10b3klM0UlMjIlMjAtLWluaXRpYWxpemVyX3Rva2VuJTNEJTIydG95JTIyJTIwJTVDJTBBJTIwJTIwLS1yZXNvbHV0aW9uJTNENTEyJTIwJTVDJTBBJTIwJTIwLS10cmFpbl9iYXRjaF9zaXplJTNEMSUyMCU1QyUwQSUyMCUyMC0tbWF4X3RyYWluX3N0ZXBzJTNEMzAwMCUyMCU1QyUwQSUyMCUyMC0tbGVhcm5pbmdfcmF0ZSUzRDUuMGUtMDQlMjAtLXNjYWxlX2xyJTIwJTVDJTBBJTIwJTIwLS1vdXRwdXRfZGlyJTNEJTIydGV4dHVhbF9pbnZlcnNpb25fY2F0JTIyJTIwJTVDJTBBJTIwJTIwLS1wdXNoX3RvX2h1Yg==",highlighted:`<span class="hljs-built_in">export</span> MODEL_NAME=<span class="hljs-string">&quot;duongna/stable-diffusion-v1-4-flax&quot;</span>
<span class="hljs-built_in">export</span> DATA_DIR=<span class="hljs-string">&quot;./cat&quot;</span>

python textual_inversion_flax.py \\
  --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_NAME</span> \\
  --train_data_dir=<span class="hljs-variable">$DATA_DIR</span> \\
  --learnable_property=<span class="hljs-string">&quot;object&quot;</span> \\
  --placeholder_token=<span class="hljs-string">&quot;&lt;cat-toy&gt;&quot;</span> --initializer_token=<span class="hljs-string">&quot;toy&quot;</span> \\
  --resolution=512 \\
  --train_batch_size=1 \\
  --max_train_steps=3000 \\
  --learning_rate=5.0e-04 --scale_lr \\
  --output_dir=<span class="hljs-string">&quot;textual_inversion_cat&quot;</span> \\
  --push_to_hub`,wrap:!1}}),{c(){t=d("p"),t.innerHTML=m,l=o(),i=d("p"),i.textContent=f,u=o(),$(y.$$.fragment),k=o(),T=d("p"),T.innerHTML=j,G=o(),I=d("p"),I.innerHTML=Z,H=o(),$(X.$$.fragment)},l(c){t=h(c,"P",{"data-svelte-h":!0}),g(t)!=="svelte-m4fpg4"&&(t.innerHTML=m),l=r(c),i=h(c,"P",{"data-svelte-h":!0}),g(i)!=="svelte-12tevzv"&&(i.textContent=f),u=r(c),w(y.$$.fragment,c),k=r(c),T=h(c,"P",{"data-svelte-h":!0}),g(T)!=="svelte-sj32mn"&&(T.innerHTML=j),G=r(c),I=h(c,"P",{"data-svelte-h":!0}),g(I)!=="svelte-1bknvx7"&&(I.innerHTML=Z),H=r(c),w(X.$$.fragment,c)},m(c,J){s(c,t,J),s(c,l,J),s(c,i,J),s(c,u,J),M(y,c,J),s(c,k,J),s(c,T,J),s(c,G,J),s(c,I,J),s(c,H,J),M(X,c,J),C=!0},p:Te,i(c){C||(b(y.$$.fragment,c),b(X.$$.fragment,c),C=!0)},o(c){_(y.$$.fragment,c),_(X.$$.fragment,c),C=!1},d(c){c&&(n(t),n(l),n(i),n(u),n(k),n(T),n(G),n(I),n(H)),v(y,c),v(X,c)}}}function zt(U){let t,m;return t=new pt({props:{$$slots:{default:[Qt]},$$scope:{ctx:U}}}),{c(){$(t.$$.fragment)},l(l){w(t.$$.fragment,l)},m(l,i){M(t,l,i),m=!0},p(l,i){const f={};i&2&&(f.$$scope={dirty:i,ctx:l}),t.$set(f)},i(l){m||(b(t.$$.fragment,l),m=!0)},o(l){_(t.$$.fragment,l),m=!1},d(l){v(t,l)}}}function At(U){let t,m=`💡 The community has created a large library of different textual inversion embedding vectors, called <a href="https://huggingface.co/sd-concepts-library" rel="nofollow">sd-concepts-library</a>.
Instead of training textual inversion embeddings from scratch you can also see whether a fitting textual inversion embedding has already been added to the library.`;return{c(){t=d("p"),t.innerHTML=m},l(l){t=h(l,"P",{"data-svelte-h":!0}),g(t)!=="svelte-dw95f3"&&(t.innerHTML=m)},m(l,i){s(l,t,i)},p:Te,d(l){l&&n(t)}}}function qt(U){let t,m,l,i=`To load the textual inversion embeddings you first need to load the base model that was used when training
your textual inversion embedding vectors. Here we assume that <a href="runwayml/stable-diffusion-v1-5"><code>runwayml/stable-diffusion-v1-5</code></a>
was used as a base model so we load it first:`,f,u,y,k,T=`Next, we need to load the textual inversion embedding vector which can be done via the <code>TextualInversionLoaderMixin.load_textual_inversion</code>
function. Here we’ll load the embeddings of the ”&lt;cat-toy&gt;” example from before.`,j,G,I,Z,H="Now we can run the pipeline making sure that the placeholder token <code>&lt;cat-toy&gt;</code> is used in our prompt.",X,C,c,J,L=`The function <code>TextualInversionLoaderMixin.load_textual_inversion</code> can not only
load textual embedding vectors saved in Diffusers’ format, but also embedding vectors
saved in <a href="https://github.com/AUTOMATIC1111/stable-diffusion-webui" rel="nofollow">Automatic1111</a> format.
To do so, you can first download an embedding vector from <a href="https://civitai.com/models/3036?modelVersionId=8387" rel="nofollow">civitAI</a>
and then load it locally:`,F,R,V;return t=new rt({props:{$$slots:{default:[At]},$$scope:{ctx:U}}}),u=new W({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),G=new W({props:{code:"cGlwZS5sb2FkX3RleHR1YWxfaW52ZXJzaW9uKCUyMnNkLWNvbmNlcHRzLWxpYnJhcnklMkZjYXQtdG95JTIyKQ==",highlighted:'pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)',wrap:!1}}),C=new W({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyQSUyMCUzQ2NhdC10b3klM0UlMjBiYWNrcGFjayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC1iYWNrcGFjay5wbmclMjIp",highlighted:`prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`,wrap:!1}}),R=new W({props:{code:"cGlwZS5sb2FkX3RleHR1YWxfaW52ZXJzaW9uKCUyMi4lMkZjaGFydHVybmVydjIucHQlMjIp",highlighted:'pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>)',wrap:!1}}),{c(){$(t.$$.fragment),m=o(),l=d("p"),l.innerHTML=i,f=o(),$(u.$$.fragment),y=o(),k=d("p"),k.innerHTML=T,j=o(),$(G.$$.fragment),I=o(),Z=d("p"),Z.innerHTML=H,X=o(),$(C.$$.fragment),c=o(),J=d("p"),J.innerHTML=L,F=o(),$(R.$$.fragment)},l(p){w(t.$$.fragment,p),m=r(p),l=h(p,"P",{"data-svelte-h":!0}),g(l)!=="svelte-hb8ui1"&&(l.innerHTML=i),f=r(p),w(u.$$.fragment,p),y=r(p),k=h(p,"P",{"data-svelte-h":!0}),g(k)!=="svelte-1hfw7uh"&&(k.innerHTML=T),j=r(p),w(G.$$.fragment,p),I=r(p),Z=h(p,"P",{"data-svelte-h":!0}),g(Z)!=="svelte-1g0wmmx"&&(Z.innerHTML=H),X=r(p),w(C.$$.fragment,p),c=r(p),J=h(p,"P",{"data-svelte-h":!0}),g(J)!=="svelte-1og1rwu"&&(J.innerHTML=L),F=r(p),w(R.$$.fragment,p)},m(p,x){M(t,p,x),s(p,m,x),s(p,l,x),s(p,f,x),M(u,p,x),s(p,y,x),s(p,k,x),s(p,j,x),M(G,p,x),s(p,I,x),s(p,Z,x),s(p,X,x),M(C,p,x),s(p,c,x),s(p,J,x),s(p,F,x),M(R,p,x),V=!0},p(p,x){const E={};x&2&&(E.$$scope={dirty:x,ctx:p}),t.$set(E)},i(p){V||(b(t.$$.fragment,p),b(u.$$.fragment,p),b(G.$$.fragment,p),b(C.$$.fragment,p),b(R.$$.fragment,p),V=!0)},o(p){_(t.$$.fragment,p),_(u.$$.fragment,p),_(G.$$.fragment,p),_(C.$$.fragment,p),_(R.$$.fragment,p),V=!1},d(p){p&&(n(m),n(l),n(f),n(y),n(k),n(j),n(I),n(Z),n(X),n(c),n(J),n(F)),v(t,p),v(u,p),v(G,p),v(C,p),v(R,p)}}}function Pt(U){let t,m;return t=new pt({props:{$$slots:{default:[qt]},$$scope:{ctx:U}}}),{c(){$(t.$$.fragment)},l(l){w(t.$$.fragment,l)},m(l,i){M(t,l,i),m=!0},p(l,i){const f={};i&2&&(f.$$scope={dirty:i,ctx:l}),t.$set(f)},i(l){m||(b(t.$$.fragment,l),m=!0)},o(l){_(t.$$.fragment,l),m=!1},d(l){v(t,l)}}}function Dt(U){let t,m=`Currently there is no <code>load_textual_inversion</code> function for Flax so one has to make sure the textual inversion
embedding vector is saved as part of the model after training.`,l,i,f="The model can then be run just like any other Flax model:",u,y,k;return y=new W({props:{code:"aW1wb3J0JTIwamF4JTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGZsYXguamF4X3V0aWxzJTIwaW1wb3J0JTIwcmVwbGljYXRlJTBBZnJvbSUyMGZsYXgudHJhaW5pbmcuY29tbW9uX3V0aWxzJTIwaW1wb3J0JTIwc2hhcmQlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmxheFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBbW9kZWxfcGF0aCUyMCUzRCUyMCUyMnBhdGgtdG8teW91ci10cmFpbmVkLW1vZGVsJTIyJTBBcGlwZWxpbmUlMkMlMjBwYXJhbXMlMjAlM0QlMjBGbGF4U3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX3BhdGglMkMlMjBkdHlwZSUzRGpheC5udW1weS5iZmxvYXQxNiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwJTNDY2F0LXRveSUzRSUyMGJhY2twYWNrJTIyJTBBcHJuZ19zZWVkJTIwJTNEJTIwamF4LnJhbmRvbS5QUk5HS2V5KDApJTBBbnVtX2luZmVyZW5jZV9zdGVwcyUyMCUzRCUyMDUwJTBBJTBBbnVtX3NhbXBsZXMlMjAlM0QlMjBqYXguZGV2aWNlX2NvdW50KCklMEFwcm9tcHQlMjAlM0QlMjBudW1fc2FtcGxlcyUyMColMjAlNUJwcm9tcHQlNUQlMEFwcm9tcHRfaWRzJTIwJTNEJTIwcGlwZWxpbmUucHJlcGFyZV9pbnB1dHMocHJvbXB0KSUwQSUwQSUyMyUyMHNoYXJkJTIwaW5wdXRzJTIwYW5kJTIwcm5nJTBBcGFyYW1zJTIwJTNEJTIwcmVwbGljYXRlKHBhcmFtcyklMEFwcm5nX3NlZWQlMjAlM0QlMjBqYXgucmFuZG9tLnNwbGl0KHBybmdfc2VlZCUyQyUyMGpheC5kZXZpY2VfY291bnQoKSklMEFwcm9tcHRfaWRzJTIwJTNEJTIwc2hhcmQocHJvbXB0X2lkcyklMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlbGluZShwcm9tcHRfaWRzJTJDJTIwcGFyYW1zJTJDJTIwcHJuZ19zZWVkJTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUyQyUyMGppdCUzRFRydWUpLmltYWdlcyUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lLm51bXB5X3RvX3BpbChucC5hc2FycmF5KGltYWdlcy5yZXNoYXBlKChudW1fc2FtcGxlcyUyQyklMjAlMkIlMjBpbWFnZXMuc2hhcGUlNUItMyUzQSU1RCkpKSUwQWltYWdlLnNhdmUoJTIyY2F0LWJhY2twYWNrLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> jax
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> flax.jax_utils <span class="hljs-keyword">import</span> replicate
<span class="hljs-keyword">from</span> flax.training.common_utils <span class="hljs-keyword">import</span> shard
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxStableDiffusionPipeline

model_path = <span class="hljs-string">&quot;path-to-your-trained-model&quot;</span>
pipeline, params = FlaxStableDiffusionPipeline.from_pretrained(model_path, dtype=jax.numpy.bfloat16)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>
prng_seed = jax.random.PRNGKey(<span class="hljs-number">0</span>)
num_inference_steps = <span class="hljs-number">50</span>

num_samples = jax.device_count()
prompt = num_samples * [prompt]
prompt_ids = pipeline.prepare_inputs(prompt)

<span class="hljs-comment"># shard inputs and rng</span>
params = replicate(params)
prng_seed = jax.random.split(prng_seed, jax.device_count())
prompt_ids = shard(prompt_ids)

images = pipeline(prompt_ids, params, prng_seed, num_inference_steps, jit=<span class="hljs-literal">True</span>).images
images = pipeline.numpy_to_pil(np.asarray(images.reshape((num_samples,) + images.shape[-<span class="hljs-number">3</span>:])))
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`,wrap:!1}}),{c(){t=d("p"),t.innerHTML=m,l=o(),i=d("p"),i.textContent=f,u=o(),$(y.$$.fragment)},l(T){t=h(T,"P",{"data-svelte-h":!0}),g(t)!=="svelte-1015828"&&(t.innerHTML=m),l=r(T),i=h(T,"P",{"data-svelte-h":!0}),g(i)!=="svelte-1igmh5k"&&(i.textContent=f),u=r(T),w(y.$$.fragment,T)},m(T,j){s(T,t,j),s(T,l,j),s(T,i,j),s(T,u,j),M(y,T,j),k=!0},p:Te,i(T){k||(b(y.$$.fragment,T),k=!0)},o(T){_(y.$$.fragment,T),k=!1},d(T){T&&(n(t),n(l),n(i),n(u)),v(y,T)}}}function Kt(U){let t,m;return t=new pt({props:{$$slots:{default:[Dt]},$$scope:{ctx:U}}}),{c(){$(t.$$.fragment)},l(l){w(t.$$.fragment,l)},m(l,i){M(t,l,i),m=!0},p(l,i){const f={};i&2&&(f.$$scope={dirty:i,ctx:l}),t.$set(f)},i(l){m||(b(t.$$.fragment,l),m=!0)},o(l){_(t.$$.fragment,l),m=!1},d(l){v(t,l)}}}function Ot(U){let t,m,l,i,f,u,y,k='<a href="https://arxiv.org/abs/2208.01618" rel="nofollow">Textual Inversion</a> is a technique for capturing novel concepts from a small number of example images. While the technique was originally demonstrated with a <a href="https://github.com/CompVis/latent-diffusion" rel="nofollow">latent diffusion model</a>, it has since been applied to other model variants like <a href="https://huggingface.co/docs/diffusers/main/en/conceptual/stable_diffusion" rel="nofollow">Stable Diffusion</a>. The learned concepts can be used to better control the images generated from text-to-image pipelines. It learns new “words” in the text encoder’s embedding space, which are used within text prompts for personalized image generation.',T,j,G='<img src="https://textual-inversion.github.io/static/images/editing/colorful_teapot.JPG" alt="Textual Inversion example"/>',I,Z,H='By using just 3-5 images you can teach new concepts to a model such as Stable Diffusion for personalized image generation <a href="https://github.com/rinongal/textual_inversion">(image source)</a>.',X,C,c='This guide will show you how to train a <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a> model with Textual Inversion. All the training scripts for Textual Inversion used in this guide can be found <a href="https://github.com/huggingface/diffusers/tree/main/examples/textual_inversion" rel="nofollow">here</a> if you’re interested in taking a closer look at how things work under the hood.',J,L,F,R,V="Before you begin, make sure you install the library’s training dependencies:",p,x,E,S,ft='After all the dependencies have been set up, initialize a <a href="https://github.com/huggingface/accelerate/" rel="nofollow">🤗Accelerate</a> environment with:',Ue,Q,Je,z,mt="To setup a default 🤗 Accelerate environment without choosing any configurations:",je,A,ke,q,ut="Or if your environment doesn’t support an interactive shell like a notebook, you can use:",Ce,P,Ze,D,ct='Finally, you try and <a href="https://huggingface.co/docs/diffusers/main/en/training/optimization/xformers" rel="nofollow">install xFormers</a> to reduce your memory footprint with xFormers memory-efficient attention. Once you have xFormers installed, add the <code>--enable_xformers_memory_efficient_attention</code> argument to the training script. xFormers is not supported for Flax.',We,K,Ie,O,dt="If you want to store your model on the Hub, add the following argument to the training script:",Xe,ee,Ge,te,Re,ne,ht="It is often a good idea to regularly save checkpoints of your model during training. This way, you can resume training from a saved checkpoint if your training is interrupted for any reason. To save a checkpoint, pass the following argument to the training script to save the full training state in a subfolder in <code>output_dir</code> every 500 steps:",Le,le,He,ae,gt="To resume training from a saved checkpoint, pass the following argument to the training script and the specific checkpoint you’d like to resume from:",Fe,se,Be,ie,Ne,oe,yt='For your training dataset, download these <a href="https://huggingface.co/datasets/diffusers/cat_toy_example" rel="nofollow">images of a cat toy</a> and store them in a directory. To use your own dataset, take a look at the <a href="create_dataset">Create a dataset for training</a> guide.',Ye,re,Ve,pe,$t='Specify the <code>MODEL_NAME</code> environment variable (either a Hub model repository id or a path to the directory containing the model weights) and pass it to the <a href="https://huggingface.co/docs/diffusers/en/api/diffusion_pipeline#diffusers.DiffusionPipeline.from_pretrained.pretrained_model_name_or_path" rel="nofollow"><code>pretrained_model_name_or_path</code></a> argument, and the <code>DATA_DIR</code> environment variable to the path of the directory containing the images.',Ee,fe,wt='Now you can launch the <a href="https://github.com/huggingface/diffusers/blob/main/examples/textual_inversion/textual_inversion.py" rel="nofollow">training script</a>. The script creates and saves the following files to your repository: <code>learned_embeds.bin</code>, <code>token_identifier.txt</code>, and <code>type_of_concept.txt</code>.',Se,B,Qe,N,ze,me,Ae,ue,Mt="If you’re interested in following along with your model training progress, you can save the generated images from the training process. Add the following arguments to the training script to enable intermediate logging:",qe,ce,bt="<li><code>validation_prompt</code>, the prompt used to generate samples (this is set to <code>None</code> by default and intermediate logging is disabled)</li> <li><code>num_validation_images</code>, the number of sample images to generate</li> <li><code>validation_steps</code>, the number of steps before generating <code>num_validation_images</code> from the <code>validation_prompt</code></li>",Pe,de,De,he,Ke,ge,_t='Once you have trained a model, you can use it for inference with the <a href="/docs/diffusers/v0.22.0/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>.',Oe,ye,vt=`The textual inversion script will by default only save the textual inversion embedding vector(s) that have
been added to the text encoder embedding matrix and consequently been trained.`,et,Y,tt,$e,nt,we,Tt='<img src="https://textual-inversion.github.io/static/images/training/training.JPG" alt="Diagram from the paper showing overview"/>',lt,Me,xt='Architecture overview from the Textual Inversion <a href="https://textual-inversion.github.io/">blog post.</a>',at,be,Ut="Usually, text prompts are tokenized into an embedding before being passed to a model, which is often a transformer. Textual Inversion does something similar, but it learns a new token embedding, <code>v*</code>, from a special token <code>S*</code> in the diagram above. The model output is used to condition the diffusion model, which helps the diffusion model understand the prompt and new concepts from just a few example images.",st,_e,Jt="To do this, Textual Inversion uses a generator model and noisy versions of the training images. The generator tries to predict less noisy versions of the images, and the token embedding <code>v*</code> is optimized based on how well the generator does. If the token embedding successfully captures the new concept, it gives more useful information to the diffusion model and helps create clearer images with less noise. This optimization process typically occurs after several thousand steps of exposure to a variety of prompt and image variants.",it,xe,ot;return f=new ve({props:{title:"Textual Inversion",local:"textual-inversion",headingTag:"h1"}}),L=new rt({props:{$$slots:{default:[Nt]},$$scope:{ctx:U}}}),x=new W({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRpZmZ1c2VycyUyMGFjY2VsZXJhdGUlMjB0cmFuc2Zvcm1lcnM=",highlighted:"pip install diffusers accelerate transformers",wrap:!1}}),Q=new W({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),A=new W({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMGRlZmF1bHQ=",highlighted:"accelerate config default",wrap:!1}}),P=new W({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjB3cml0ZV9iYXNpY19jb25maWclMEElMEF3cml0ZV9iYXNpY19jb25maWcoKQ==",highlighted:`from accelerate.utils import write_basic_config

write_basic_config()`,wrap:!1}}),K=new ve({props:{title:"Upload model to Hub",local:"upload-model-to-hub",headingTag:"h2"}}),ee=new W({props:{code:"LS1wdXNoX3RvX2h1Yg==",highlighted:"--push_to_hub",wrap:!1}}),te=new ve({props:{title:"Save and load checkpoints",local:"save-and-load-checkpoints",headingTag:"h2"}}),le=new W({props:{code:"LS1jaGVja3BvaW50aW5nX3N0ZXBzJTNENTAw",highlighted:"--checkpointing_steps=500",wrap:!1}}),se=new W({props:{code:"LS1yZXN1bWVfZnJvbV9jaGVja3BvaW50JTNEJTIyY2hlY2twb2ludC0xNTAwJTIy",highlighted:'--resume_from_checkpoint=<span class="hljs-string">&quot;checkpoint-1500&quot;</span>',wrap:!1}}),ie=new ve({props:{title:"Finetuning",local:"finetuning",headingTag:"h2"}}),re=new W({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBJTBBbG9jYWxfZGlyJTIwJTNEJTIwJTIyLiUyRmNhdCUyMiUwQXNuYXBzaG90X2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMCUyMmRpZmZ1c2VycyUyRmNhdF90b3lfZXhhbXBsZSUyMiUyQyUyMGxvY2FsX2RpciUzRGxvY2FsX2RpciUyQyUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMkMlMjBpZ25vcmVfcGF0dGVybnMlM0QlMjIuZ2l0YXR0cmlidXRlcyUyMiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download

local_dir = <span class="hljs-string">&quot;./cat&quot;</span>
snapshot_download(
    <span class="hljs-string">&quot;diffusers/cat_toy_example&quot;</span>, local_dir=local_dir, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, ignore_patterns=<span class="hljs-string">&quot;.gitattributes&quot;</span>
)`,wrap:!1}}),B=new rt({props:{$$slots:{default:[Yt]},$$scope:{ctx:U}}}),N=new Xt({props:{pytorch:!0,tensorflow:!1,jax:!0,$$slots:{jax:[zt],pytorch:[St]},$$scope:{ctx:U}}}),me=new ve({props:{title:"Intermediate logging",local:"intermediate-logging",headingTag:"h3"}}),de=new W({props:{code:"LS12YWxpZGF0aW9uX3Byb21wdCUzRCUyMkElMjAlM0NjYXQtdG95JTNFJTIwYmFja3BhY2slMjIlMEEtLW51bV92YWxpZGF0aW9uX2ltYWdlcyUzRDQlMEEtLXZhbGlkYXRpb25fc3RlcHMlM0QxMDA=",highlighted:`--validation_prompt=<span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>
--num_validation_images=4
--validation_steps=100`,wrap:!1}}),he=new ve({props:{title:"Inference",local:"inference",headingTag:"h2"}}),Y=new Xt({props:{pytorch:!0,tensorflow:!1,jax:!0,$$slots:{jax:[Kt],pytorch:[Pt]},$$scope:{ctx:U}}}),$e=new ve({props:{title:"How it works",local:"how-it-works",headingTag:"h2"}}),{c(){t=d("meta"),m=o(),l=d("p"),i=o(),$(f.$$.fragment),u=o(),y=d("p"),y.innerHTML=k,T=o(),j=d("p"),j.innerHTML=G,I=o(),Z=d("small"),Z.innerHTML=H,X=o(),C=d("p"),C.innerHTML=c,J=o(),$(L.$$.fragment),F=o(),R=d("p"),R.textContent=V,p=o(),$(x.$$.fragment),E=o(),S=d("p"),S.innerHTML=ft,Ue=o(),$(Q.$$.fragment),Je=o(),z=d("p"),z.textContent=mt,je=o(),$(A.$$.fragment),ke=o(),q=d("p"),q.textContent=ut,Ce=o(),$(P.$$.fragment),Ze=o(),D=d("p"),D.innerHTML=ct,We=o(),$(K.$$.fragment),Ie=o(),O=d("p"),O.textContent=dt,Xe=o(),$(ee.$$.fragment),Ge=o(),$(te.$$.fragment),Re=o(),ne=d("p"),ne.innerHTML=ht,Le=o(),$(le.$$.fragment),He=o(),ae=d("p"),ae.textContent=gt,Fe=o(),$(se.$$.fragment),Be=o(),$(ie.$$.fragment),Ne=o(),oe=d("p"),oe.innerHTML=yt,Ye=o(),$(re.$$.fragment),Ve=o(),pe=d("p"),pe.innerHTML=$t,Ee=o(),fe=d("p"),fe.innerHTML=wt,Se=o(),$(B.$$.fragment),Qe=o(),$(N.$$.fragment),ze=o(),$(me.$$.fragment),Ae=o(),ue=d("p"),ue.textContent=Mt,qe=o(),ce=d("ul"),ce.innerHTML=bt,Pe=o(),$(de.$$.fragment),De=o(),$(he.$$.fragment),Ke=o(),ge=d("p"),ge.innerHTML=_t,Oe=o(),ye=d("p"),ye.textContent=vt,et=o(),$(Y.$$.fragment),tt=o(),$($e.$$.fragment),nt=o(),we=d("p"),we.innerHTML=Tt,lt=o(),Me=d("small"),Me.innerHTML=xt,at=o(),be=d("p"),be.innerHTML=Ut,st=o(),_e=d("p"),_e.innerHTML=Jt,it=o(),xe=d("p"),this.h()},l(e){const a=Ft("svelte-u9bgzb",document.head);t=h(a,"META",{name:!0,content:!0}),a.forEach(n),m=r(e),l=h(e,"P",{}),Wt(l).forEach(n),i=r(e),w(f.$$.fragment,e),u=r(e),y=h(e,"P",{"data-svelte-h":!0}),g(y)!=="svelte-1ak1yzh"&&(y.innerHTML=k),T=r(e),j=h(e,"P",{"data-svelte-h":!0}),g(j)!=="svelte-1vgmpoc"&&(j.innerHTML=G),I=r(e),Z=h(e,"SMALL",{"data-svelte-h":!0}),g(Z)!=="svelte-20gkrh"&&(Z.innerHTML=H),X=r(e),C=h(e,"P",{"data-svelte-h":!0}),g(C)!=="svelte-15v4j5x"&&(C.innerHTML=c),J=r(e),w(L.$$.fragment,e),F=r(e),R=h(e,"P",{"data-svelte-h":!0}),g(R)!=="svelte-13t46bd"&&(R.textContent=V),p=r(e),w(x.$$.fragment,e),E=r(e),S=h(e,"P",{"data-svelte-h":!0}),g(S)!=="svelte-1aaeu4s"&&(S.innerHTML=ft),Ue=r(e),w(Q.$$.fragment,e),Je=r(e),z=h(e,"P",{"data-svelte-h":!0}),g(z)!=="svelte-di6juu"&&(z.textContent=mt),je=r(e),w(A.$$.fragment,e),ke=r(e),q=h(e,"P",{"data-svelte-h":!0}),g(q)!=="svelte-130n95n"&&(q.textContent=ut),Ce=r(e),w(P.$$.fragment,e),Ze=r(e),D=h(e,"P",{"data-svelte-h":!0}),g(D)!=="svelte-405a1t"&&(D.innerHTML=ct),We=r(e),w(K.$$.fragment,e),Ie=r(e),O=h(e,"P",{"data-svelte-h":!0}),g(O)!=="svelte-ngtwm4"&&(O.textContent=dt),Xe=r(e),w(ee.$$.fragment,e),Ge=r(e),w(te.$$.fragment,e),Re=r(e),ne=h(e,"P",{"data-svelte-h":!0}),g(ne)!=="svelte-1yij86f"&&(ne.innerHTML=ht),Le=r(e),w(le.$$.fragment,e),He=r(e),ae=h(e,"P",{"data-svelte-h":!0}),g(ae)!=="svelte-u8my22"&&(ae.textContent=gt),Fe=r(e),w(se.$$.fragment,e),Be=r(e),w(ie.$$.fragment,e),Ne=r(e),oe=h(e,"P",{"data-svelte-h":!0}),g(oe)!=="svelte-ntjrrr"&&(oe.innerHTML=yt),Ye=r(e),w(re.$$.fragment,e),Ve=r(e),pe=h(e,"P",{"data-svelte-h":!0}),g(pe)!=="svelte-15gfwl0"&&(pe.innerHTML=$t),Ee=r(e),fe=h(e,"P",{"data-svelte-h":!0}),g(fe)!=="svelte-13jni84"&&(fe.innerHTML=wt),Se=r(e),w(B.$$.fragment,e),Qe=r(e),w(N.$$.fragment,e),ze=r(e),w(me.$$.fragment,e),Ae=r(e),ue=h(e,"P",{"data-svelte-h":!0}),g(ue)!=="svelte-4lrmm3"&&(ue.textContent=Mt),qe=r(e),ce=h(e,"UL",{"data-svelte-h":!0}),g(ce)!=="svelte-1ibhi4r"&&(ce.innerHTML=bt),Pe=r(e),w(de.$$.fragment,e),De=r(e),w(he.$$.fragment,e),Ke=r(e),ge=h(e,"P",{"data-svelte-h":!0}),g(ge)!=="svelte-1643a1n"&&(ge.innerHTML=_t),Oe=r(e),ye=h(e,"P",{"data-svelte-h":!0}),g(ye)!=="svelte-1621yhm"&&(ye.textContent=vt),et=r(e),w(Y.$$.fragment,e),tt=r(e),w($e.$$.fragment,e),nt=r(e),we=h(e,"P",{"data-svelte-h":!0}),g(we)!=="svelte-4oyjpc"&&(we.innerHTML=Tt),lt=r(e),Me=h(e,"SMALL",{"data-svelte-h":!0}),g(Me)!=="svelte-1t7e7o6"&&(Me.innerHTML=xt),at=r(e),be=h(e,"P",{"data-svelte-h":!0}),g(be)!=="svelte-o0upqp"&&(be.innerHTML=Ut),st=r(e),_e=h(e,"P",{"data-svelte-h":!0}),g(_e)!=="svelte-v2wgvo"&&(_e.innerHTML=Jt),it=r(e),xe=h(e,"P",{}),Wt(xe).forEach(n),this.h()},h(){It(t,"name","hf:doc:metadata"),It(t,"content",en)},m(e,a){Bt(document.head,t),s(e,m,a),s(e,l,a),s(e,i,a),M(f,e,a),s(e,u,a),s(e,y,a),s(e,T,a),s(e,j,a),s(e,I,a),s(e,Z,a),s(e,X,a),s(e,C,a),s(e,J,a),M(L,e,a),s(e,F,a),s(e,R,a),s(e,p,a),M(x,e,a),s(e,E,a),s(e,S,a),s(e,Ue,a),M(Q,e,a),s(e,Je,a),s(e,z,a),s(e,je,a),M(A,e,a),s(e,ke,a),s(e,q,a),s(e,Ce,a),M(P,e,a),s(e,Ze,a),s(e,D,a),s(e,We,a),M(K,e,a),s(e,Ie,a),s(e,O,a),s(e,Xe,a),M(ee,e,a),s(e,Ge,a),M(te,e,a),s(e,Re,a),s(e,ne,a),s(e,Le,a),M(le,e,a),s(e,He,a),s(e,ae,a),s(e,Fe,a),M(se,e,a),s(e,Be,a),M(ie,e,a),s(e,Ne,a),s(e,oe,a),s(e,Ye,a),M(re,e,a),s(e,Ve,a),s(e,pe,a),s(e,Ee,a),s(e,fe,a),s(e,Se,a),M(B,e,a),s(e,Qe,a),M(N,e,a),s(e,ze,a),M(me,e,a),s(e,Ae,a),s(e,ue,a),s(e,qe,a),s(e,ce,a),s(e,Pe,a),M(de,e,a),s(e,De,a),M(he,e,a),s(e,Ke,a),s(e,ge,a),s(e,Oe,a),s(e,ye,a),s(e,et,a),M(Y,e,a),s(e,tt,a),M($e,e,a),s(e,nt,a),s(e,we,a),s(e,lt,a),s(e,Me,a),s(e,at,a),s(e,be,a),s(e,st,a),s(e,_e,a),s(e,it,a),s(e,xe,a),ot=!0},p(e,[a]){const jt={};a&2&&(jt.$$scope={dirty:a,ctx:e}),L.$set(jt);const kt={};a&2&&(kt.$$scope={dirty:a,ctx:e}),B.$set(kt);const Ct={};a&2&&(Ct.$$scope={dirty:a,ctx:e}),N.$set(Ct);const Zt={};a&2&&(Zt.$$scope={dirty:a,ctx:e}),Y.$set(Zt)},i(e){ot||(b(f.$$.fragment,e),b(L.$$.fragment,e),b(x.$$.fragment,e),b(Q.$$.fragment,e),b(A.$$.fragment,e),b(P.$$.fragment,e),b(K.$$.fragment,e),b(ee.$$.fragment,e),b(te.$$.fragment,e),b(le.$$.fragment,e),b(se.$$.fragment,e),b(ie.$$.fragment,e),b(re.$$.fragment,e),b(B.$$.fragment,e),b(N.$$.fragment,e),b(me.$$.fragment,e),b(de.$$.fragment,e),b(he.$$.fragment,e),b(Y.$$.fragment,e),b($e.$$.fragment,e),ot=!0)},o(e){_(f.$$.fragment,e),_(L.$$.fragment,e),_(x.$$.fragment,e),_(Q.$$.fragment,e),_(A.$$.fragment,e),_(P.$$.fragment,e),_(K.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(le.$$.fragment,e),_(se.$$.fragment,e),_(ie.$$.fragment,e),_(re.$$.fragment,e),_(B.$$.fragment,e),_(N.$$.fragment,e),_(me.$$.fragment,e),_(de.$$.fragment,e),_(he.$$.fragment,e),_(Y.$$.fragment,e),_($e.$$.fragment,e),ot=!1},d(e){e&&(n(m),n(l),n(i),n(u),n(y),n(T),n(j),n(I),n(Z),n(X),n(C),n(J),n(F),n(R),n(p),n(E),n(S),n(Ue),n(Je),n(z),n(je),n(ke),n(q),n(Ce),n(Ze),n(D),n(We),n(Ie),n(O),n(Xe),n(Ge),n(Re),n(ne),n(Le),n(He),n(ae),n(Fe),n(Be),n(Ne),n(oe),n(Ye),n(Ve),n(pe),n(Ee),n(fe),n(Se),n(Qe),n(ze),n(Ae),n(ue),n(qe),n(ce),n(Pe),n(De),n(Ke),n(ge),n(Oe),n(ye),n(et),n(tt),n(nt),n(we),n(lt),n(Me),n(at),n(be),n(st),n(_e),n(it),n(xe)),n(t),v(f,e),v(L,e),v(x,e),v(Q,e),v(A,e),v(P,e),v(K,e),v(ee,e),v(te,e),v(le,e),v(se,e),v(ie,e),v(re,e),v(B,e),v(N,e),v(me,e),v(de,e),v(he,e),v(Y,e),v($e,e)}}}const en='{"title":"Textual Inversion","local":"textual-inversion","sections":[{"title":"Upload model to Hub","local":"upload-model-to-hub","sections":[],"depth":2},{"title":"Save and load checkpoints","local":"save-and-load-checkpoints","sections":[],"depth":2},{"title":"Finetuning","local":"finetuning","sections":[{"title":"Intermediate logging","local":"intermediate-logging","sections":[],"depth":3}],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2},{"title":"How it works","local":"how-it-works","sections":[],"depth":2}],"depth":1}';function tn(U){return Rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pn extends Lt{constructor(t){super(),Ht(this,t,tn,Ot,Gt,{})}}export{pn as component};
