import{s as ue,o as ye,n as de}from"../chunks/scheduler.182ea377.js";import{S as fe,i as he,g as o,s as a,r as y,A as be,h as p,f as t,c as n,j as Me,u as d,x as r,k as ee,y as we,a as s,v as f,d as h,t as b,w}from"../chunks/index.abf12888.js";import{T as ge}from"../chunks/Tip.230e2334.js";import{C as le}from"../chunks/CodeBlock.57fe6e13.js";import{D as Ue}from"../chunks/DocNotebookDropdown.d9060979.js";import{H as te}from"../chunks/Heading.16916d63.js";function Je(R){let i,g='For more context about the design choices behind community pipelines, please have a look at <a href="https://github.com/huggingface/diffusers/issues/841" rel="nofollow">this issue</a>.';return{c(){i=o("p"),i.innerHTML=g},l(m){i=p(m,"P",{"data-svelte-h":!0}),r(i)!=="svelte-18wmiaf"&&(i.innerHTML=g)},m(m,v){s(m,i,v)},p:de,d(m){m&&t(i)}}}function Te(R){let i,g,m,v,U,X,J,$,c,E,T,se='Community pipelines allow you to get creative and build your own unique pipelines to share with the community. You can find all community pipelines in the <a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">diffusers/examples/community</a> folder along with inference and training examples for how to use them. This guide showcases some of the community pipelines and hopefully it’ll inspire you to create your own (feel free to open a PR with your own pipeline and we will merge it!).',Y,j,ae='To load a community pipeline, use the <code>custom_pipeline</code> argument in <a href="/docs/diffusers/v0.23.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to specify one of the files in <a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">diffusers/examples/community</a>:',N,Z,z,C,ne="If a community pipeline doesn’t work as expected, please open a GitHub issue and mention the author.",Q,I,ie='You can learn more about community pipelines in the how to <a href="custom_pipeline_overview">load community pipelines</a> and how to <a href="contribute_pipeline">contribute a community pipeline</a> guides.',S,W,A,G,oe='The multilingual Stable Diffusion pipeline uses a pretrained <a href="https://huggingface.co/papluca/xlm-roberta-base-language-detection" rel="nofollow">XLM-RoBERTa</a> to identify a language and the <a href="https://huggingface.co/facebook/mbart-large-50-many-to-one-mmt" rel="nofollow">mBART-large-50</a> model to handle the translation. This allows you to generate images from text in 20 languages.',q,_,F,M,pe='<img src="https://user-images.githubusercontent.com/4313860/198328706-295824a4-9856-4ce5-8e66-278ceb42fd29.png"/>',H,k,L,B,me='<a href="https://huggingface.co/papers/2210.16056" rel="nofollow">MagicMix</a> is a pipeline that can mix an image and text prompt to generate a new image that preserves the image structure. The <code>mix_factor</code> determines how much influence the prompt has on the layout generation, <code>kmin</code> controls the number of steps during the content generation process, and <code>kmax</code> determines how much information is kept in the layout of the original image.',D,x,P,u,re='<div><img class="rounded-xl" src="https://user-images.githubusercontent.com/59410571/209578593-141467c7-d831-4792-8b9a-b17dc5e47816.jpg"/> <figcaption class="mt-2 text-center text-sm text-gray-500">image prompt</figcaption></div> <div><img class="rounded-xl" src="https://user-images.githubusercontent.com/59410571/209578602-70f323fa-05b7-4dd6-b055-e40683e37914.jpg"/> <figcaption class="mt-2 text-center text-sm text-gray-500">image and text prompt mix</figcaption></div>',K,V,O;return U=new te({props:{title:"Community pipelines",local:"community-pipelines",headingTag:"h1"}}),J=new Ue({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/custom_pipeline_examples.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/custom_pipeline_examples.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/custom_pipeline_examples.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/custom_pipeline_examples.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/custom_pipeline_examples.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/custom_pipeline_examples.ipynb"}]}}),c=new ge({props:{$$slots:{default:[Je]},$$scope:{ctx:R}}}),Z=new le({props:{code:"cGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS00JTIyJTJDJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyZmlsZW5hbWVfaW5fdGhlX2NvbW11bml0eV9mb2xkZXIlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKQ==",highlighted:`pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, custom_pipeline=<span class="hljs-string">&quot;filename_in_the_community_folder&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),W=new te({props:{title:"Multilingual Stable Diffusion",local:"multilingual-stable-diffusion",headingTag:"h2"}}),_=new le({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    pipeline,
    MBart50TokenizerFast,
    MBartForConditionalGeneration,
)

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
device_dict = {<span class="hljs-string">&quot;cuda&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;cpu&quot;</span>: -<span class="hljs-number">1</span>}

<span class="hljs-comment"># add language detection pipeline</span>
language_detection_model_ckpt = <span class="hljs-string">&quot;papluca/xlm-roberta-base-language-detection&quot;</span>
language_detection_pipeline = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>,
                                       model=language_detection_model_ckpt,
                                       device=device_dict[device])

<span class="hljs-comment"># add model for language translation</span>
trans_tokenizer = MBart50TokenizerFast.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-one-mmt&quot;</span>)
trans_model = MBartForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-one-mmt&quot;</span>).to(device)

diffuser_pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;multilingual_stable_diffusion&quot;</span>,
    detection_pipeline=language_detection_pipeline,
    translation_model=trans_model,
    translation_tokenizer=trans_tokenizer,
    torch_dtype=torch.float16,
)

diffuser_pipeline.enable_attention_slicing()
diffuser_pipeline = diffuser_pipeline.to(device)

prompt = [<span class="hljs-string">&quot;a photograph of an astronaut riding a horse&quot;</span>, 
          <span class="hljs-string">&quot;Una casa en la playa&quot;</span>,
          <span class="hljs-string">&quot;Ein Hund, der Orange isst&quot;</span>,
          <span class="hljs-string">&quot;Un restaurant parisien&quot;</span>]

images = diffuser_pipeline(prompt).images
grid = make_image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">2</span>)
grid`,wrap:!1}}),k=new te({props:{title:"MagicMix",local:"magicmix",headingTag:"h2"}}),x=new le({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTJDJTIwRERJTVNjaGVkdWxlciUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUyQyUwQSUyMCUyMCUyMCUyMGN1c3RvbV9waXBlbGluZSUzRCUyMm1hZ2ljX21peCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlciUyMCUzRCUyMERESU1TY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJzY2hlZHVsZXIlMjIpJTJDJTBBKS50bygnY3VkYScpJTBBJTBBaW1nJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRnVzZXItaW1hZ2VzLmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRjU5NDEwNTcxJTJGMjA5NTc4NTkzLTE0MTQ2N2M3LWQ4MzEtNDc5Mi04YjlhLWIxN2RjNWU0NzgxNi5qcGclMjIpJTBBbWl4X2ltZyUyMCUzRCUyMHBpcGVsaW5lKGltZyUyQyUyMHByb21wdCUzRCUyMmJlZCUyMiUyQyUyMGttaW4lMjAlM0QlMjAwLjMlMkMlMjBrbWF4JTIwJTNEJTIwMC41JTJDJTIwbWl4X2ZhY3RvciUyMCUzRCUyMDAuNSklMEFtaXhfaW1n",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DDIMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;magic_mix&quot;</span>,
    scheduler = DDIMScheduler.from_pretrained(<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>),
).to(<span class="hljs-string">&#x27;cuda&#x27;</span>)

img = load_image(<span class="hljs-string">&quot;https://user-images.githubusercontent.com/59410571/209578593-141467c7-d831-4792-8b9a-b17dc5e47816.jpg&quot;</span>)
mix_img = pipeline(img, prompt=<span class="hljs-string">&quot;bed&quot;</span>, kmin = <span class="hljs-number">0.3</span>, kmax = <span class="hljs-number">0.5</span>, mix_factor = <span class="hljs-number">0.5</span>)
mix_img`,wrap:!1}}),{c(){i=o("meta"),g=a(),m=o("p"),v=a(),y(U.$$.fragment),X=a(),y(J.$$.fragment),$=a(),y(c.$$.fragment),E=a(),T=o("p"),T.innerHTML=se,Y=a(),j=o("p"),j.innerHTML=ae,N=a(),y(Z.$$.fragment),z=a(),C=o("p"),C.textContent=ne,Q=a(),I=o("p"),I.innerHTML=ie,S=a(),y(W.$$.fragment),A=a(),G=o("p"),G.innerHTML=oe,q=a(),y(_.$$.fragment),F=a(),M=o("div"),M.innerHTML=pe,H=a(),y(k.$$.fragment),L=a(),B=o("p"),B.innerHTML=me,D=a(),y(x.$$.fragment),P=a(),u=o("div"),u.innerHTML=re,K=a(),V=o("p"),this.h()},l(e){const l=be("svelte-u9bgzb",document.head);i=p(l,"META",{name:!0,content:!0}),l.forEach(t),g=n(e),m=p(e,"P",{}),Me(m).forEach(t),v=n(e),d(U.$$.fragment,e),X=n(e),d(J.$$.fragment,e),$=n(e),d(c.$$.fragment,e),E=n(e),T=p(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1baok02"&&(T.innerHTML=se),Y=n(e),j=p(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-ss1pwq"&&(j.innerHTML=ae),N=n(e),d(Z.$$.fragment,e),z=n(e),C=p(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-19dq7yu"&&(C.textContent=ne),Q=n(e),I=p(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-ghaeyc"&&(I.innerHTML=ie),S=n(e),d(W.$$.fragment,e),A=n(e),G=p(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1ee0giq"&&(G.innerHTML=oe),q=n(e),d(_.$$.fragment,e),F=n(e),M=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(M)!=="svelte-1v1rdhr"&&(M.innerHTML=pe),H=n(e),d(k.$$.fragment,e),L=n(e),B=p(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-tjmn7p"&&(B.innerHTML=me),D=n(e),d(x.$$.fragment,e),P=n(e),u=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(u)!=="svelte-14d0edh"&&(u.innerHTML=re),K=n(e),V=p(e,"P",{}),Me(V).forEach(t),this.h()},h(){ee(i,"name","hf:doc:metadata"),ee(i,"content",je),ee(M,"class","flex justify-center"),ee(u,"class","flex gap-4")},m(e,l){we(document.head,i),s(e,g,l),s(e,m,l),s(e,v,l),f(U,e,l),s(e,X,l),f(J,e,l),s(e,$,l),f(c,e,l),s(e,E,l),s(e,T,l),s(e,Y,l),s(e,j,l),s(e,N,l),f(Z,e,l),s(e,z,l),s(e,C,l),s(e,Q,l),s(e,I,l),s(e,S,l),f(W,e,l),s(e,A,l),s(e,G,l),s(e,q,l),f(_,e,l),s(e,F,l),s(e,M,l),s(e,H,l),f(k,e,l),s(e,L,l),s(e,B,l),s(e,D,l),f(x,e,l),s(e,P,l),s(e,u,l),s(e,K,l),s(e,V,l),O=!0},p(e,[l]){const ce={};l&2&&(ce.$$scope={dirty:l,ctx:e}),c.$set(ce)},i(e){O||(h(U.$$.fragment,e),h(J.$$.fragment,e),h(c.$$.fragment,e),h(Z.$$.fragment,e),h(W.$$.fragment,e),h(_.$$.fragment,e),h(k.$$.fragment,e),h(x.$$.fragment,e),O=!0)},o(e){b(U.$$.fragment,e),b(J.$$.fragment,e),b(c.$$.fragment,e),b(Z.$$.fragment,e),b(W.$$.fragment,e),b(_.$$.fragment,e),b(k.$$.fragment,e),b(x.$$.fragment,e),O=!1},d(e){e&&(t(g),t(m),t(v),t(X),t($),t(E),t(T),t(Y),t(j),t(N),t(z),t(C),t(Q),t(I),t(S),t(A),t(G),t(q),t(F),t(M),t(H),t(L),t(B),t(D),t(P),t(u),t(K),t(V)),t(i),w(U,e),w(J,e),w(c,e),w(Z,e),w(W,e),w(_,e),w(k,e),w(x,e)}}}const je='{"title":"Community pipelines","local":"community-pipelines","sections":[{"title":"Multilingual Stable Diffusion","local":"multilingual-stable-diffusion","sections":[],"depth":2},{"title":"MagicMix","local":"magicmix","sections":[],"depth":2}],"depth":1}';function Ze(R){return ye(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Be extends fe{constructor(i){super(),he(this,i,Ze,Te,ue,{})}}export{Be as component};
