import{s as Ke,n as Oe,o as et}from"../chunks/scheduler.eb0ed874.js";import{S as tt,i as st,g as i,s as l,r as p,A as nt,h as r,f as s,c as a,j as Fe,u as c,x as o,k as D,y as lt,a as n,v as h,d as y,t as M,w as m}from"../chunks/index.b954ae78.js";import{C as Be}from"../chunks/CodeBlock.2e864717.js";import{H as T,E as at}from"../chunks/EditOnGithub.6f0e1a75.js";function it(Ee){let u,F,X,K,J,O,g,ee,f,Qe="Token streaming is the mode in which the server returns the tokens one by one as the model generates them. This enables showing progressive generations to the user rather than waiting for the whole generation. Streaming is an essential aspect of the end-user experience as it reduces latency, one of the most critical aspects of a smooth experience.",te,w,qe='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/tgi/streaming-generation-visual_360.gif"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/tgi/streaming-generation-visual-dark_360.gif"/>',se,j,xe="With token streaming, the server can start returning the tokens one by one before having to generate the whole response. Users can have a sense of the generation’s quality before the end of the generation. This has different positive effects:",ne,C,Ze="<li>Users can get results orders of magnitude earlier for extremely long queries.</li> <li>Seeing something in progress allows users to stop the generation if it’s not going in the direction they expect.</li> <li>Perceived latency is lower when results are shown in the early stages.</li> <li>When used in conversational UIs, the experience feels more natural.</li>",le,I,We="For example, a system can generate 100 tokens per second. If the system generates 1000 tokens, with the non-streaming setup, users need to wait 10 seconds to get results. On the other hand, with the streaming setup, users get initial results immediately, and although end-to-end latency will be the same, they can see half of the generation after five seconds. Below you can see an interactive demo that shows non-streaming vs streaming side-by-side. Click <strong>generate</strong> below.",ae,d,Ge='<iframe src="https://osanseviero-streaming-vs-non-streaming.hf.space?__theme=light" width="850" height="350"></iframe>',ie,U,He='<iframe src="https://osanseviero-streaming-vs-non-streaming.hf.space?__theme=dark" width="850" height="350"></iframe>',re,b,oe,v,pe,$,Ne="To stream tokens with <code>InferenceClient</code>, simply pass <code>stream=True</code> and iterate over the response.",ce,S,he,k,_e="The <code>huggingface_hub</code> library also comes with an <code>AsyncInferenceClient</code> in case you need to handle the requests concurrently.",ye,B,Me,E,me,Q,Ve="To use the OpenAI Chat Completions compatible Messages API <code>v1/chat/completions</code> endpoint with curl, you can add the <code>-N</code> flag, which disables curl default buffering and shows data as it arrives from the server",ue,q,we,x,de,Z,Ye=`First, we need to install the <code>@huggingface/inference</code> library.
<code>npm install @huggingface/inference</code>`,Ue,W,Ae="If you’re using the free Inference API, you can use <code>HfInference</code>. If you’re using inference endpoints, you can use <code>HfInferenceEndpoint</code>.",Te,G,Re="We can create a <code>HfInferenceEndpoint</code> providing our endpoint URL and credential.",Je,H,ge,N,fe,_,Le="Under the hood, TGI uses Server-Sent Events (SSE). In an SSE Setup, a client sends a request with the data, opening an HTTP connection and subscribing to updates. Afterward, the server sends data to the client. There is no need for further requests; the server will keep sending the data. SSEs are unidirectional, meaning the client does not send other requests to the server. SSE sends data over HTTP, making it easy to use.",je,V,ze="SSEs are different than:",Ce,Y,Xe="<li>Polling: where the client keeps calling the server to get data. This means that the server might return empty responses and cause overhead.</li> <li>Webhooks: where there is a bi-directional connection. The server can send information to the client, but the client can also send data to the server after the first request. Webhooks are more complex to operate as they don’t only use HTTP.</li>",Ie,A,Pe="If there are too many requests at the same time, TGI returns an HTTP Error with an <code>overloaded</code> error type (<code>huggingface_hub</code> returns <code>OverloadedError</code>). This allows the client to manage the overloaded server (e.g., it could display a busy error to the user or retry with a new request). To configure the maximum number of concurrent requests, you can specify <code>--max_concurrent_requests</code>, allowing clients to handle backpressure.",be,R,ve,L,De='Adyen wrote a nice recap of how TGI streaming feature works. <a href="https://www.adyen.com/knowledge-hub/llm-inference-at-scale-with-tgi" rel="nofollow">LLM inference at scale with TGI</a>',$e,z,Se,P,ke;return J=new T({props:{title:"Streaming",local:"streaming",headingTag:"h1"}}),g=new T({props:{title:"What is Streaming?",local:"what-is-streaming",headingTag:"h2"}}),b=new T({props:{title:"How to use Streaming?",local:"how-to-use-streaming",headingTag:"h2"}}),v=new T({props:{title:"Streaming with Python",local:"streaming-with-python",headingTag:"h3"}}),S=new Be({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChiYXNlX3VybCUzRCUyMmh0dHAlM0ElMkYlMkYxMjcuMC4wLjElM0E4MDgwJTIyKSUwQW91dHB1dCUyMCUzRCUyMGNsaWVudC5jaGF0LmNvbXBsZXRpb25zLmNyZWF0ZSglMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQ291bnQlMjB0byUyMDEwJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwc3RyZWFtJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDI0JTJDJTBBKSUwQSUwQWZvciUyMGNodW5rJTIwaW4lMjBvdXRwdXQlM0ElMEElMjAlMjAlMjAlMjBwcmludChjaHVuay5jaG9pY2VzJTVCMCU1RC5kZWx0YS5jb250ZW50KSUwQSUwQSUyMyUyMDElMEElMjMlMjAyJTBBJTIzJTIwMyUwQSUyMyUyMDQlMEElMjMlMjA1JTBBJTIzJTIwNiUwQSUyMyUyMDclMEElMjMlMjA4JTBBJTIzJTIwOSUwQSUyMyUyMDEw",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(base_url=<span class="hljs-string">&quot;http://127.0.0.1:8080&quot;</span>)
output = client.chat.completions.create(
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Count to 10&quot;</span>},
    ],
    stream=<span class="hljs-literal">True</span>,
    max_tokens=<span class="hljs-number">1024</span>,
)

<span class="hljs-keyword">for</span> chunk <span class="hljs-keyword">in</span> output:
    <span class="hljs-built_in">print</span>(chunk.choices[<span class="hljs-number">0</span>].delta.content)

<span class="hljs-comment"># 1</span>
<span class="hljs-comment"># 2</span>
<span class="hljs-comment"># 3</span>
<span class="hljs-comment"># 4</span>
<span class="hljs-comment"># 5</span>
<span class="hljs-comment"># 6</span>
<span class="hljs-comment"># 7</span>
<span class="hljs-comment"># 8</span>
<span class="hljs-comment"># 9</span>
<span class="hljs-comment"># 10</span>`,wrap:!1}}),B=new Be({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBJTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoYmFzZV91cmwlM0QlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODA4MCUyMiklMEFhc3luYyUyMGRlZiUyMG1haW4oKSUzQSUwQSUyMCUyMCUyMCUyMHN0cmVhbSUyMCUzRCUyMGF3YWl0JTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyU2F5JTIwdGhpcyUyMGlzJTIwYSUyMHRlc3QlMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdHJlYW0lM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZm9yJTIwY2h1bmslMjBpbiUyMHN0cmVhbSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGNodW5rLmNob2ljZXMlNUIwJTVELmRlbHRhLmNvbnRlbnQlMjBvciUyMCUyMiUyMiUyQyUyMGVuZCUzRCUyMiUyMiklMEElMEFhc3luY2lvLnJ1bihtYWluKCkpJTBBJTBBJTIzJTIwVGhpcyUwQSUyMyUyMGlzJTBBJTIzJTIwYSUwQSUyMyUyMHRlc3QlMEElMjMu",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient

client = AsyncInferenceClient(base_url=<span class="hljs-string">&quot;http://127.0.0.1:8080&quot;</span>)
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    stream = <span class="hljs-keyword">await</span> client.chat.completions.create(
        messages=[{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Say this is a test&quot;</span>}],
        stream=<span class="hljs-literal">True</span>,
    )
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> chunk <span class="hljs-keyword">in</span> stream:
        <span class="hljs-built_in">print</span>(chunk.choices[<span class="hljs-number">0</span>].delta.content <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;&quot;</span>, end=<span class="hljs-string">&quot;&quot;</span>)

asyncio.run(main())

<span class="hljs-comment"># This</span>
<span class="hljs-comment"># is</span>
<span class="hljs-comment"># a</span>
<span class="hljs-comment"># test</span>
<span class="hljs-comment">#.</span>`,wrap:!1}}),E=new T({props:{title:"Streaming with cURL",local:"streaming-with-curl",headingTag:"h3"}}),q=new Be({props:{code:"Y3VybCUyMGxvY2FsaG9zdCUzQTgwODAlMkZ2MSUyRmNoYXQlMkZjb21wbGV0aW9ucyUyMCU1QyUwQSUyMCUyMCUyMCUyMC1YJTIwUE9TVCUyMCU1QyUwQSUyMCUyMCUyMCUyMC1kJTIwJyU3QiUwQSUyMCUyMCUyMm1vZGVsJTIyJTNBJTIwJTIydGdpJTIyJTJDJTBBJTIwJTIwJTIybWVzc2FnZXMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50LiUyMiUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnN0cmVhbSUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjJtYXhfdG9rZW5zJTIyJTNBJTIwMjAlMEElN0QnJTIwJTVDJTBBJTIwJTIwJTIwJTIwLUglMjAnQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJw==",highlighted:`curl localhost:<span class="hljs-number">8080</span>/v1/chat/completions \\
    -X POST \\
    -d &#x27;{
  <span class="hljs-string">&quot;model&quot;</span>: <span class="hljs-string">&quot;tgi&quot;</span>,
  <span class="hljs-string">&quot;messages&quot;</span>: [
    {
      <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
      <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>
    },
    {
      <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
      <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is deep learning?&quot;</span>
    }
  ],
  <span class="hljs-string">&quot;stream&quot;</span>: <span class="hljs-literal">true</span>,
  <span class="hljs-string">&quot;max_tokens&quot;</span>: <span class="hljs-number">20</span>
}&#x27; \\
    -H <span class="hljs-symbol">&#x27;Content</span>-<span class="hljs-keyword">Type</span>: application/json&#x27;`,wrap:!1}}),x=new T({props:{title:"Streaming with JavaScript",local:"streaming-with-javascript",headingTag:"h3"}}),H=new Be({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2VFbmRwb2ludCUyMCU3RCUyMGZyb20lMjAnJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UnJTBBJTBBY29uc3QlMjBoZiUyMCUzRCUyMG5ldyUyMEhmSW5mZXJlbmNlRW5kcG9pbnQoJ2h0dHBzJTNBJTJGJTJGWU9VUl9FTkRQT0lOVC5lbmRwb2ludHMuaHVnZ2luZ2ZhY2UuY2xvdWQnJTJDJTIwJ2hmX1lPVVJfVE9LRU4nKSUwQSUwQSUyRiUyRiUyMHByb21wdCUwQWNvbnN0JTIwcHJvbXB0JTIwJTNEJTIwJ1doYXQlMjBjYW4lMjB5b3UlMjBkbyUyMGluJTIwTnVyZW1iZXJnJTJDJTIwR2VybWFueSUzRiUyMEdpdmUlMjBtZSUyMDMlMjBUaXBzJyUwQSUwQWNvbnN0JTIwc3RyZWFtJTIwJTNEJTIwaGYudGV4dEdlbmVyYXRpb25TdHJlYW0oJTdCJTIwaW5wdXRzJTNBJTIwcHJvbXB0JTIwJTdEKSUwQWZvciUyMGF3YWl0JTIwKGNvbnN0JTIwciUyMG9mJTIwc3RyZWFtKSUyMCU3QiUwQSUyMCUyMCUyRiUyRiUyMHlpZWxkJTIwdGhlJTIwZ2VuZXJhdGVkJTIwdG9rZW4lMEElMjAlMjBwcm9jZXNzLnN0ZG91dC53cml0ZShyLnRva2VuLnRleHQpJTBBJTdE",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInferenceEndpoint</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/inference&#x27;</span>

<span class="hljs-keyword">const</span> hf = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfInferenceEndpoint</span>(<span class="hljs-string">&#x27;https://YOUR_ENDPOINT.endpoints.huggingface.cloud&#x27;</span>, <span class="hljs-string">&#x27;hf_YOUR_TOKEN&#x27;</span>)

<span class="hljs-comment">// prompt</span>
<span class="hljs-keyword">const</span> prompt = <span class="hljs-string">&#x27;What can you do in Nuremberg, Germany? Give me 3 Tips&#x27;</span>

<span class="hljs-keyword">const</span> stream = hf.<span class="hljs-title function_">textGenerationStream</span>({ <span class="hljs-attr">inputs</span>: prompt })
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> r <span class="hljs-keyword">of</span> stream) {
  <span class="hljs-comment">// yield the generated token</span>
  process.<span class="hljs-property">stdout</span>.<span class="hljs-title function_">write</span>(r.<span class="hljs-property">token</span>.<span class="hljs-property">text</span>)
}`,wrap:!1}}),N=new T({props:{title:"How does Streaming work under the hood?",local:"how-does-streaming-work-under-the-hood",headingTag:"h2"}}),R=new T({props:{title:"External sources",local:"external-sources",headingTag:"h2"}}),z=new at({props:{source:"https://github.com/huggingface/text-generation-inference/blob/main/docs/source/conceptual/streaming.md"}}),{c(){u=i("meta"),F=l(),X=i("p"),K=l(),p(J.$$.fragment),O=l(),p(g.$$.fragment),ee=l(),f=i("p"),f.textContent=Qe,te=l(),w=i("div"),w.innerHTML=qe,se=l(),j=i("p"),j.textContent=xe,ne=l(),C=i("ul"),C.innerHTML=Ze,le=l(),I=i("p"),I.innerHTML=We,ae=l(),d=i("div"),d.innerHTML=Ge,ie=l(),U=i("div"),U.innerHTML=He,re=l(),p(b.$$.fragment),oe=l(),p(v.$$.fragment),pe=l(),$=i("p"),$.innerHTML=Ne,ce=l(),p(S.$$.fragment),he=l(),k=i("p"),k.innerHTML=_e,ye=l(),p(B.$$.fragment),Me=l(),p(E.$$.fragment),me=l(),Q=i("p"),Q.innerHTML=Ve,ue=l(),p(q.$$.fragment),we=l(),p(x.$$.fragment),de=l(),Z=i("p"),Z.innerHTML=Ye,Ue=l(),W=i("p"),W.innerHTML=Ae,Te=l(),G=i("p"),G.innerHTML=Re,Je=l(),p(H.$$.fragment),ge=l(),p(N.$$.fragment),fe=l(),_=i("p"),_.textContent=Le,je=l(),V=i("p"),V.textContent=ze,Ce=l(),Y=i("ul"),Y.innerHTML=Xe,Ie=l(),A=i("p"),A.innerHTML=Pe,be=l(),p(R.$$.fragment),ve=l(),L=i("p"),L.innerHTML=De,$e=l(),p(z.$$.fragment),Se=l(),P=i("p"),this.h()},l(e){const t=nt("svelte-u9bgzb",document.head);u=r(t,"META",{name:!0,content:!0}),t.forEach(s),F=a(e),X=r(e,"P",{}),Fe(X).forEach(s),K=a(e),c(J.$$.fragment,e),O=a(e),c(g.$$.fragment,e),ee=a(e),f=r(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-18otp1w"&&(f.textContent=Qe),te=a(e),w=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-1mls61x"&&(w.innerHTML=qe),se=a(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1i4w8o9"&&(j.textContent=xe),ne=a(e),C=r(e,"UL",{"data-svelte-h":!0}),o(C)!=="svelte-1sljm14"&&(C.innerHTML=Ze),le=a(e),I=r(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-doyuuq"&&(I.innerHTML=We),ae=a(e),d=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(d)!=="svelte-7ia471"&&(d.innerHTML=Ge),ie=a(e),U=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(U)!=="svelte-1wj2bw6"&&(U.innerHTML=He),re=a(e),c(b.$$.fragment,e),oe=a(e),c(v.$$.fragment,e),pe=a(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-16qpzge"&&($.innerHTML=Ne),ce=a(e),c(S.$$.fragment,e),he=a(e),k=r(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1nblluv"&&(k.innerHTML=_e),ye=a(e),c(B.$$.fragment,e),Me=a(e),c(E.$$.fragment,e),me=a(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-foca00"&&(Q.innerHTML=Ve),ue=a(e),c(q.$$.fragment,e),we=a(e),c(x.$$.fragment,e),de=a(e),Z=r(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-16sqqc4"&&(Z.innerHTML=Ye),Ue=a(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1qwkxte"&&(W.innerHTML=Ae),Te=a(e),G=r(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-5nogh0"&&(G.innerHTML=Re),Je=a(e),c(H.$$.fragment,e),ge=a(e),c(N.$$.fragment,e),fe=a(e),_=r(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1wghvdx"&&(_.textContent=Le),je=a(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-m95rqi"&&(V.textContent=ze),Ce=a(e),Y=r(e,"UL",{"data-svelte-h":!0}),o(Y)!=="svelte-1vpfo5b"&&(Y.innerHTML=Xe),Ie=a(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-jbqwxg"&&(A.innerHTML=Pe),be=a(e),c(R.$$.fragment,e),ve=a(e),L=r(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-jyeer2"&&(L.innerHTML=De),$e=a(e),c(z.$$.fragment,e),Se=a(e),P=r(e,"P",{}),Fe(P).forEach(s),this.h()},h(){D(u,"name","hf:doc:metadata"),D(u,"content",rt),D(w,"class","flex justify-center"),D(d,"class","block dark:hidden"),D(U,"class","hidden dark:block")},m(e,t){lt(document.head,u),n(e,F,t),n(e,X,t),n(e,K,t),h(J,e,t),n(e,O,t),h(g,e,t),n(e,ee,t),n(e,f,t),n(e,te,t),n(e,w,t),n(e,se,t),n(e,j,t),n(e,ne,t),n(e,C,t),n(e,le,t),n(e,I,t),n(e,ae,t),n(e,d,t),n(e,ie,t),n(e,U,t),n(e,re,t),h(b,e,t),n(e,oe,t),h(v,e,t),n(e,pe,t),n(e,$,t),n(e,ce,t),h(S,e,t),n(e,he,t),n(e,k,t),n(e,ye,t),h(B,e,t),n(e,Me,t),h(E,e,t),n(e,me,t),n(e,Q,t),n(e,ue,t),h(q,e,t),n(e,we,t),h(x,e,t),n(e,de,t),n(e,Z,t),n(e,Ue,t),n(e,W,t),n(e,Te,t),n(e,G,t),n(e,Je,t),h(H,e,t),n(e,ge,t),h(N,e,t),n(e,fe,t),n(e,_,t),n(e,je,t),n(e,V,t),n(e,Ce,t),n(e,Y,t),n(e,Ie,t),n(e,A,t),n(e,be,t),h(R,e,t),n(e,ve,t),n(e,L,t),n(e,$e,t),h(z,e,t),n(e,Se,t),n(e,P,t),ke=!0},p:Oe,i(e){ke||(y(J.$$.fragment,e),y(g.$$.fragment,e),y(b.$$.fragment,e),y(v.$$.fragment,e),y(S.$$.fragment,e),y(B.$$.fragment,e),y(E.$$.fragment,e),y(q.$$.fragment,e),y(x.$$.fragment,e),y(H.$$.fragment,e),y(N.$$.fragment,e),y(R.$$.fragment,e),y(z.$$.fragment,e),ke=!0)},o(e){M(J.$$.fragment,e),M(g.$$.fragment,e),M(b.$$.fragment,e),M(v.$$.fragment,e),M(S.$$.fragment,e),M(B.$$.fragment,e),M(E.$$.fragment,e),M(q.$$.fragment,e),M(x.$$.fragment,e),M(H.$$.fragment,e),M(N.$$.fragment,e),M(R.$$.fragment,e),M(z.$$.fragment,e),ke=!1},d(e){e&&(s(F),s(X),s(K),s(O),s(ee),s(f),s(te),s(w),s(se),s(j),s(ne),s(C),s(le),s(I),s(ae),s(d),s(ie),s(U),s(re),s(oe),s(pe),s($),s(ce),s(he),s(k),s(ye),s(Me),s(me),s(Q),s(ue),s(we),s(de),s(Z),s(Ue),s(W),s(Te),s(G),s(Je),s(ge),s(fe),s(_),s(je),s(V),s(Ce),s(Y),s(Ie),s(A),s(be),s(ve),s(L),s($e),s(Se),s(P)),s(u),m(J,e),m(g,e),m(b,e),m(v,e),m(S,e),m(B,e),m(E,e),m(q,e),m(x,e),m(H,e),m(N,e),m(R,e),m(z,e)}}}const rt='{"title":"Streaming","local":"streaming","sections":[{"title":"What is Streaming?","local":"what-is-streaming","sections":[],"depth":2},{"title":"How to use Streaming?","local":"how-to-use-streaming","sections":[{"title":"Streaming with Python","local":"streaming-with-python","sections":[],"depth":3},{"title":"Streaming with cURL","local":"streaming-with-curl","sections":[],"depth":3},{"title":"Streaming with JavaScript","local":"streaming-with-javascript","sections":[],"depth":3}],"depth":2},{"title":"How does Streaming work under the hood?","local":"how-does-streaming-work-under-the-hood","sections":[],"depth":2},{"title":"External sources","local":"external-sources","sections":[],"depth":2}],"depth":1}';function ot(Ee){return et(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Mt extends tt{constructor(u){super(),st(this,u,ot,it,Ke,{})}}export{Mt as component};
