import{s as ep,n as np,o as pp}from"../chunks/scheduler.7bc62968.js";import{S as ip,i as op,g as h,s as e,r as p,A as Mp,h as j,f as l,c as n,j as lp,u as i,x as J,k as ap,y as rp,a,v as o,d as M,t as r,w as c}from"../chunks/index.66556066.js";import{C as y}from"../chunks/CodeBlock.a759539a.js";import{H as m,E as cp}from"../chunks/EditOnGithub.46ca76a5.js";function hp(Fe){let u,nl,al,pl,T,il,w,_e=`A Typescript powered wrapper for the HF Inference API (serverless), Inference Endpoints (dedicated), and third-party Inference Providers.
It works with <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API (serverless)</a> and <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints (dedicated)</a>, and even with supported third-party Inference Providers.`,ol,f,Le='You can also try out a live <a href="https://observablehq.com/@huggingface/hello-huggingface-js-inference" rel="nofollow">interactive notebook</a>, see some demos on <a href="https://huggingface.co/huggingfacejs" rel="nofollow">hf.co/huggingfacejs</a>, or watch a <a href="https://scrimba.com/scrim/cod8248f5adfd6e129582c523" rel="nofollow">Scrimba tutorial that explains how Inference Endpoints works</a>.',Ml,g,rl,d,cl,U,hl,I,jl,b,Jl,$,ml,C,yl,B,ul,x,De='❗<strong>Important note:</strong> Using an access token is optional to get started, however you will be rate limited eventually. Join <a href="https://huggingface.co/join" rel="nofollow">Hugging Face</a> and then visit <a href="https://huggingface.co/settings/tokens" rel="nofollow">access tokens</a> to generate your access token for <strong>free</strong>.',Tl,k,Pe="Your access token should be kept private. If you need to protect it in front-end applications, we suggest setting up a proxy server that stores the access token.",wl,Z,fl,Q,Ke="You can send inference requests to third-party providers with the inference client.",gl,G,Oe="Currently, we support the following providers:",dl,N,sn='<li><a href="https://fal.ai" rel="nofollow">Fal.ai</a></li> <li><a href="https://fireworks.ai" rel="nofollow">Fireworks AI</a></li> <li><a href="https://hyperbolic.xyz" rel="nofollow">Hyperbolic</a></li> <li><a href="https://studio.nebius.ai" rel="nofollow">Nebius</a></li> <li><a href="https://novita.ai/?utm_source=github_huggingface&amp;utm_medium=github_readme&amp;utm_campaign=link" rel="nofollow">Novita</a></li> <li><a href="https://replicate.com" rel="nofollow">Replicate</a></li> <li><a href="https://sambanova.ai" rel="nofollow">Sambanova</a></li> <li><a href="https://together.xyz" rel="nofollow">Together</a></li> <li><a href="https://blackforestlabs.ai" rel="nofollow">Blackforestlabs</a></li> <li><a href="https://cohere.com" rel="nofollow">Cohere</a></li> <li><a href="https://cerebras.ai/" rel="nofollow">Cerebras</a></li>',Ul,E,tn="To send requests to a third-party provider, you have to pass the <code>provider</code> parameter to the inference function. Make sure your request is authenticated with an access token.",Il,v,bl,W,ln=`When authenticated with a Hugging Face access token, the request is routed through <a href="https://huggingface.co." rel="nofollow">https://huggingface.co.</a>
When authenticated with a third-party provider key, the request is made directly against that provider’s inference API.`,$l,A,an="Only a subset of models are supported when requesting third-party providers. You can check the list of supported models per pipeline tasks here:",Cl,Y,en='<li><a href="https://huggingface.co/api/partners/fal-ai/models" rel="nofollow">Fal.ai supported models</a></li> <li><a href="https://huggingface.co/api/partners/fireworks-ai/models" rel="nofollow">Fireworks AI supported models</a></li> <li><a href="https://huggingface.co/api/partners/hyperbolic/models" rel="nofollow">Hyperbolic supported models</a></li> <li><a href="https://huggingface.co/api/partners/nebius/models" rel="nofollow">Nebius supported models</a></li> <li><a href="https://huggingface.co/api/partners/replicate/models" rel="nofollow">Replicate supported models</a></li> <li><a href="https://huggingface.co/api/partners/sambanova/models" rel="nofollow">Sambanova supported models</a></li> <li><a href="https://huggingface.co/api/partners/together/models" rel="nofollow">Together supported models</a></li> <li><a href="https://huggingface.co/api/partners/cohere/models" rel="nofollow">Cohere supported models</a></li> <li><a href="https://huggingface.co/api/partners/cerebras/models" rel="nofollow">Cerebras supported models</a></li> <li><a href="https://huggingface.co/models?inference=warm&amp;sort=trending" rel="nofollow">HF Inference API (serverless)</a></li>',Bl,X,nn=`❗<strong>Important note:</strong> To be compatible, the third-party API must adhere to the “standard” shape API we expect on HF model pages for each pipeline task type.
This is not an issue for LLMs as everyone converged on the OpenAI API anyways, but can be more tricky for other tasks like “text-to-image” or “automatic-speech-recognition” where there exists no standard API. Let us know if any help is needed or if we can make things easier for you!`,xl,S,pn='👋<strong>Want to add another provider?</strong> Get in touch if you’d like to add support for another Inference provider, and/or request it on <a href="https://huggingface.co/spaces/huggingface/HuggingDiscussions/discussions/49" rel="nofollow">https://huggingface.co/spaces/huggingface/HuggingDiscussions/discussions/49</a>',kl,V,Zl,R,on="You can import the functions you need directly from the module instead of using the <code>HfInference</code> class.",Ql,q,Gl,z,Mn="This will enable tree-shaking by your bundler.",Nl,H,El,F,vl,_,rn="Generates text from an input prompt.",Wl,L,cn='<a href="https://huggingface.co/spaces/huggingfacejs/streaming-text-generation" rel="nofollow">Demo</a>',Al,D,Yl,P,Xl,K,hn='Using the <code>chatCompletion</code> method, you can generate text with models compatible with the OpenAI Chat Completion API. All models served by <a href="https://huggingface.co/docs/text-generation-inference/" rel="nofollow">TGI</a> on Hugging Face support Messages API.',Sl,O,jn='<a href="https://huggingface.co/spaces/huggingfacejs/streaming-chat-completion" rel="nofollow">Demo</a>',Vl,ss,Rl,ts,Jn="It’s also possible to call Mistral or OpenAI endpoints directly:",ql,ls,zl,as,Hl,es,mn="Tries to fill in a hole with a missing word (token to be precise).",Fl,ns,_l,ps,Ll,is,yn="Summarizes longer text into shorter text. Be careful, some models have a maximum length of input.",Dl,os,Pl,Ms,Kl,rs,un="Answers questions based on the context you provide.",Ol,cs,sa,hs,ta,js,la,Js,aa,ms,Tn="Often used for sentiment analysis, this method will assign labels to the given text along with a probability score of that label.",ea,ys,na,us,pa,Ts,wn="Used for sentence parsing, either grammatical, or Named Entity Recognition (NER) to understand keywords contained within text.",ia,ws,oa,fs,Ma,gs,fn="Converts text from one language to another.",ra,ds,ca,Us,ha,Is,gn="Checks how well an input text fits into a set of labels you provide.",ja,bs,Ja,$s,ma,Cs,dn="This task corresponds to any chatbot-like structure. Models tend to have shorter max_length, so please check with caution when using a given model if you need long-range dependency or not.",ya,Bs,ua,xs,Ta,ks,Un="Calculate the semantic similarity between one text and a list of other sentences.",wa,Zs,fa,Qs,ga,Gs,da,Ns,In="Transcribes speech from an audio file.",Ua,Es,bn='<a href="https://huggingface.co/spaces/huggingfacejs/speech-recognition-vue" rel="nofollow">Demo</a>',Ia,vs,ba,Ws,$a,As,$n="Assigns labels to the given audio along with a probability score of that label.",Ca,Ys,Cn='<a href="https://huggingface.co/spaces/huggingfacejs/audio-classification-vue" rel="nofollow">Demo</a>',Ba,Xs,xa,Ss,ka,Vs,Bn="Generates natural-sounding speech from text input.",Za,Rs,xn='<a href="https://scrimba.com/scrim/co8da4d23b49b648f77f4848a?pl=pkVnrP7uP" rel="nofollow">Interactive tutorial</a>',Qa,qs,Ga,zs,Na,Hs,kn="Outputs one or multiple generated audios from an input audio, commonly used for speech enhancement and source separation.",Ea,Fs,va,_s,Wa,Ls,Aa,Ds,Zn="Assigns labels to a given image along with a probability score of that label.",Ya,Ps,Qn='<a href="https://huggingface.co/spaces/huggingfacejs/image-classification-vue" rel="nofollow">Demo</a>',Xa,Ks,Sa,Os,Va,st,Gn="Detects objects within an image and returns labels with corresponding bounding boxes and probability scores.",Ra,tt,Nn='<a href="https://huggingface.co/spaces/huggingfacejs/object-detection-vue" rel="nofollow">Demo</a>',qa,lt,za,at,Ha,et,En="Detects segments within an image and returns labels with corresponding bounding boxes and probability scores.",Fa,nt,_a,pt,La,it,vn="Outputs text from a given image, commonly used for captioning or optical character recognition.",Da,ot,Pa,Mt,Ka,rt,Wn="Creates an image from a text prompt.",Oa,ct,An='<a href="https://huggingface.co/spaces/huggingfacejs/image-to-text" rel="nofollow">Demo</a>',se,ht,te,jt,le,Jt,Yn="Image-to-image is the task of transforming a source image to match the characteristics of a target image or a target image domain.",ae,mt,Xn='<a href="https://scrimba.com/scrim/co4834bf9a91cc81cfab07969?pl=pkVnrP7uP" rel="nofollow">Interactive tutorial</a>',ee,yt,ne,ut,pe,Tt,Sn="Checks how well an input image fits into a set of labels you provide.",ie,wt,oe,ft,Me,gt,re,dt,Vn="This task reads some text and outputs raw float values, that are usually consumed as part of a semantic database/semantic search.",ce,Ut,he,It,je,bt,Rn="Visual Question Answering is the task of answering open-ended questions based on an image. They output natural language responses to natural language questions.",Je,$t,qn='<a href="https://huggingface.co/spaces/huggingfacejs/doc-vis-qa" rel="nofollow">Demo</a>',me,Ct,ye,Bt,ue,xt,zn="Document question answering models take a (document, question) pair as input and return an answer in natural language.",Te,kt,Hn='<a href="https://huggingface.co/spaces/huggingfacejs/doc-vis-qa" rel="nofollow">Demo</a>',we,Zt,fe,Qt,ge,Gt,de,Nt,Fn="Tabular regression is the task of predicting a numerical value given a set of attributes.",Ue,Et,Ie,vt,be,Wt,_n="Tabular classification is the task of classifying a target category (a group) based on set of attributes.",$e,At,Ce,Yt,Be,Xt,Ln="For models with custom parameters / outputs.",xe,St,ke,Vt,Dn="You can use any Chat Completion API-compatible provider with the <code>chatCompletion</code> method.",Ze,Rt,Qe,qt,Ge,zt,Pn='Learn more about using your own inference endpoints <a href="https://hf.co/docs/inference-endpoints/" rel="nofollow">here</a>',Ne,Ht,Ee,Ft,Kn=`By default, all calls to the inference endpoint will wait until the model is
loaded. When <a href="https://huggingface.co/docs/inference-endpoints/en/autoscaling#scaling-to-0" rel="nofollow">scaling to
0</a>
is enabled on the endpoint, this can result in non-trivial waiting time. If
you’d rather disable this behavior and handle the endpoint’s returned 500 HTTP
errors yourself, you can do so like so:`,ve,_t,We,Lt,Ae,Dt,Ye,Pt,Xe,Kt,On='We have an informative documentation project called <a href="https://huggingface.co/tasks" rel="nofollow">Tasks</a> to list available models for each task and explain how each task works in detail.',Se,Ot,sp="It also contains demos, example outputs, and other resources should you want to dig deeper into the ML side of things.",Ve,sl,Re,tl,tp="<li><code>@huggingface/tasks</code> : Typings only</li>",qe,ll,ze,el,He;return T=new m({props:{title:"🤗 Hugging Face Inference",local:"-hugging-face-inference",headingTag:"h1"}}),g=new m({props:{title:"Getting Started",local:"getting-started",headingTag:"h2"}}),d=new m({props:{title:"Install",local:"install",headingTag:"h3"}}),U=new m({props:{title:"Node",local:"node",headingTag:"h4"}}),I=new y({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTBBJTBBcG5wbSUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTBBJTBBeWFybiUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNl",highlighted:`npm install @huggingface/inference

pnpm add @huggingface/inference

yarn add @huggingface/inference`,wrap:!1}}),b=new m({props:{title:"Deno",local:"deno",headingTag:"h4"}}),$=new y({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIyaHR0cHMlM0ElMkYlMkZlc20uc2glMkYlNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSUyMiUwQSUyRiUyRiUyMG9yJTIwbnBtJTNBJTBBaW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIybnBtJTNBJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjI=",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/inference&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/inference&quot;</span>`,wrap:!1}}),C=new m({props:{title:"Initialize",local:"initialize",headingTag:"h3"}}),B=new y({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJyU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJyUwQSUwQWNvbnN0JTIwaGYlMjAlM0QlMjBuZXclMjBIZkluZmVyZW5jZSgneW91ciUyMGFjY2VzcyUyMHRva2VuJyk=",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/inference&#x27;</span>

<span class="hljs-keyword">const</span> hf = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfInference</span>(<span class="hljs-string">&#x27;your access token&#x27;</span>)`,wrap:!1}}),Z=new m({props:{title:"Third-party inference providers",local:"third-party-inference-providers",headingTag:"h3"}}),v=new y({props:{code:"Y29uc3QlMjBhY2Nlc3NUb2tlbiUyMCUzRCUyMCUyMmhmXy4uLiUyMiUzQiUyMCUyRiUyRiUyMEVpdGhlciUyMGElMjBIRiUyMGFjY2VzcyUyMHRva2VuJTJDJTIwb3IlMjBhbiUyMEFQSSUyMGtleSUyMGZyb20lMjB0aGUlMjB0aGlyZC1wYXJ0eSUyMHByb3ZpZGVyJTIwKFJlcGxpY2F0ZSUyMGluJTIwdGhpcyUyMGV4YW1wbGUpJTBBJTBBY29uc3QlMjBjbGllbnQlMjAlM0QlMjBuZXclMjBIZkluZmVyZW5jZShhY2Nlc3NUb2tlbiklM0IlMEFhd2FpdCUyMGNsaWVudC50ZXh0VG9JbWFnZSglN0IlMEElMjAlMjBwcm92aWRlciUzQSUyMCUyMnJlcGxpY2F0ZSUyMiUyQyUwQSUyMCUyMG1vZGVsJTNBJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGbHV4LjEtZGV2JTIyJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTIyQSUyMGJsYWNrJTIwZm9yZXN0JTIwY2FrZSUyMiUwQSU3RCk=",highlighted:`<span class="hljs-keyword">const</span> accessToken = <span class="hljs-string">&quot;hf_...&quot;</span>; <span class="hljs-comment">// Either a HF access token, or an API key from the third-party provider (Replicate in this example)</span>

<span class="hljs-keyword">const</span> client = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfInference</span>(accessToken);
<span class="hljs-keyword">await</span> client.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;replicate&quot;</span>,
  <span class="hljs-attr">model</span>:<span class="hljs-string">&quot;black-forest-labs/Flux.1-dev&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;A black forest cake&quot;</span>
})`,wrap:!1}}),V=new m({props:{title:"Tree-shaking",local:"tree-shaking",headingTag:"h3"}}),q=new y({props:{code:"aW1wb3J0JTIwJTdCJTIwdGV4dEdlbmVyYXRpb24lMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjIlM0IlMEElMEFhd2FpdCUyMHRleHRHZW5lcmF0aW9uKCU3QiUwQSUyMCUyMGFjY2Vzc1Rva2VuJTNBJTIwJTIyaGZfLi4uJTIyJTJDJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJtb2RlbF9vcl9lbmRwb2ludCUyMiUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMC4uLiUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAuLi4lMEElN0Qp",highlighted:`<span class="hljs-keyword">import</span> { textGeneration } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;

<span class="hljs-keyword">await</span> <span class="hljs-title function_">textGeneration</span>({
  <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;model_or_endpoint&quot;</span>,
  <span class="hljs-attr">inputs</span>: ...,
  <span class="hljs-attr">parameters</span>: ...
})`,wrap:!1}}),H=new m({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h2"}}),F=new m({props:{title:"Text Generation",local:"text-generation",headingTag:"h3"}}),D=new y({props:{code:"YXdhaXQlMjBoZi50ZXh0R2VuZXJhdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdncHQyJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCdUaGUlMjBhbnN3ZXIlMjB0byUyMHRoZSUyMHVuaXZlcnNlJTIwaXMnJTBBJTdEKSUwQSUwQWZvciUyMGF3YWl0JTIwKGNvbnN0JTIwb3V0cHV0JTIwb2YlMjBoZi50ZXh0R2VuZXJhdGlvblN0cmVhbSglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMmdvb2dsZSUyRmZsYW4tdDUteHhsJTIyJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJ3JlcGVhdCUyMCUyMm9uZSUyMHR3byUyMHRocmVlJTIwZm91ciUyMiclMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTIwbWF4X25ld190b2tlbnMlM0ElMjAyNTAlMjAlN0QlMEElN0QpKSUyMCU3QiUwQSUyMCUyMGNvbnNvbGUubG9nKG91dHB1dC50b2tlbi50ZXh0JTJDJTIwb3V0cHV0LmdlbmVyYXRlZF90ZXh0KSUzQiUwQSU3RA==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textGeneration</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;gpt2&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span>
})

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> output <span class="hljs-keyword">of</span> hf.<span class="hljs-title function_">textGenerationStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;google/flan-t5-xxl&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;repeat &quot;one two three four&quot;&#x27;</span>,
  <span class="hljs-attr">parameters</span>: { <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">250</span> }
})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(output.<span class="hljs-property">token</span>.<span class="hljs-property">text</span>, output.<span class="hljs-property">generated_text</span>);
}`,wrap:!1}}),P=new m({props:{title:"Text Generation (Chat Completion API Compatible)",local:"text-generation-chat-completion-api-compatible",headingTag:"h3"}}),ss=new y({props:{code:"JTJGJTJGJTIwTm9uLXN0cmVhbWluZyUyMEFQSSUwQWNvbnN0JTIwb3V0JTIwJTNEJTIwYXdhaXQlMjBoZi5jaGF0Q29tcGxldGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjEtOEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjBtZXNzYWdlcyUzQSUyMCU1QiU3QiUyMHJvbGUlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwY29udGVudCUzQSUyMCUyMkhlbGxvJTJDJTIwbmljZSUyMHRvJTIwbWVldCUyMHlvdSElMjIlMjAlN0QlNUQlMkMlMEElMjAlMjBtYXhfdG9rZW5zJTNBJTIwNTEyJTJDJTBBJTIwJTIwdGVtcGVyYXR1cmUlM0ElMjAwLjElMkMlMEElN0QpJTNCJTBBJTBBJTJGJTJGJTIwU3RyZWFtaW5nJTIwQVBJJTBBbGV0JTIwb3V0JTIwJTNEJTIwJTIyJTIyJTNCJTBBZm9yJTIwYXdhaXQlMjAoY29uc3QlMjBjaHVuayUyMG9mJTIwaGYuY2hhdENvbXBsZXRpb25TdHJlYW0oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4xLThCLUluc3RydWN0JTIyJTJDJTBBJTIwJTIwbWVzc2FnZXMlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjByb2xlJTNBJTIwJTIydXNlciUyMiUyQyUyMGNvbnRlbnQlM0ElMjAlMjJDYW4lMjB5b3UlMjBoZWxwJTIwbWUlMjBzb2x2ZSUyMGFuJTIwZXF1YXRpb24lM0YlMjIlMjAlN0QlMkMlMEElMjAlMjAlNUQlMkMlMEElMjAlMjBtYXhfdG9rZW5zJTNBJTIwNTEyJTJDJTBBJTIwJTIwdGVtcGVyYXR1cmUlM0ElMjAwLjElMkMlMEElN0QpKSUyMCU3QiUwQSUyMCUyMGlmJTIwKGNodW5rLmNob2ljZXMlMjAlMjYlMjYlMjBjaHVuay5jaG9pY2VzLmxlbmd0aCUyMCUzRSUyMDApJTIwJTdCJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTJCJTNEJTIwY2h1bmsuY2hvaWNlcyU1QjAlNUQuZGVsdGEuY29udGVudCUzQiUwQSUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-comment">// Non-streaming API</span>
<span class="hljs-keyword">const</span> out = <span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">chatCompletion</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Hello, nice to meet you!&quot;</span> }],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>,
  <span class="hljs-attr">temperature</span>: <span class="hljs-number">0.1</span>,
});

<span class="hljs-comment">// Streaming API</span>
<span class="hljs-keyword">let</span> out = <span class="hljs-string">&quot;&quot;</span>;
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> hf.<span class="hljs-title function_">chatCompletionStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">messages</span>: [
    { <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Can you help me solve an equation?&quot;</span> },
  ],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>,
  <span class="hljs-attr">temperature</span>: <span class="hljs-number">0.1</span>,
})) {
  <span class="hljs-keyword">if</span> (chunk.<span class="hljs-property">choices</span> &amp;&amp; chunk.<span class="hljs-property">choices</span>.<span class="hljs-property">length</span> &gt; <span class="hljs-number">0</span>) {
    out += chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">delta</span>.<span class="hljs-property">content</span>;
  }
}`,wrap:!1}}),ls=new y({props:{code:"Y29uc3QlMjBvcGVuYWklMjAlM0QlMjBuZXclMjBIZkluZmVyZW5jZShPUEVOQUlfVE9LRU4pLmVuZHBvaW50KCUyMmh0dHBzJTNBJTJGJTJGYXBpLm9wZW5haS5jb20lMjIpJTNCJTBBJTBBbGV0JTIwb3V0JTIwJTNEJTIwJTIyJTIyJTNCJTBBZm9yJTIwYXdhaXQlMjAoY29uc3QlMjBjaHVuayUyMG9mJTIwb3BlbmFpLmNoYXRDb21wbGV0aW9uU3RyZWFtKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJTIyZ3B0LTMuNS10dXJibyUyMiUyQyUwQSUyMCUyMG1lc3NhZ2VzJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIwcm9sZSUzQSUyMCUyMnVzZXIlMjIlMkMlMjBjb250ZW50JTNBJTIwJTIyQ29tcGxldGUlMjB0aGUlMjBlcXVhdGlvbiUyMDElMkIxJTNEJTIwJTJDanVzdCUyMHRoZSUyMGFuc3dlciUyMiUyMCU3RCUyQyUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMG1heF90b2tlbnMlM0ElMjA1MDAlMkMlMEElMjAlMjB0ZW1wZXJhdHVyZSUzQSUyMDAuMSUyQyUwQSUyMCUyMHNlZWQlM0ElMjAwJTJDJTBBJTdEKSklMjAlN0IlMEElMjAlMjBpZiUyMChjaHVuay5jaG9pY2VzJTIwJTI2JTI2JTIwY2h1bmsuY2hvaWNlcy5sZW5ndGglMjAlM0UlMjAwKSUyMCU3QiUwQSUyMCUyMCUyMCUyMG91dCUyMCUyQiUzRCUyMGNodW5rLmNob2ljZXMlNUIwJTVELmRlbHRhLmNvbnRlbnQlM0IlMEElMjAlMjAlN0QlMEElN0QlMEElMEElMkYlMkYlMjBGb3IlMjBtaXN0cmFsJTIwQUklM0ElMEElMkYlMkYlMjBlbmRwb2ludFVybCUzQSUyMCUyMmh0dHBzJTNBJTJGJTJGYXBpLm1pc3RyYWwuYWklMjIlMEElMkYlMkYlMjBtb2RlbCUzQSUyMCUyMm1pc3RyYWwtdGlueSUyMg==",highlighted:`<span class="hljs-keyword">const</span> openai = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfInference</span>(<span class="hljs-variable constant_">OPENAI_TOKEN</span>).<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&quot;https://api.openai.com&quot;</span>);

<span class="hljs-keyword">let</span> out = <span class="hljs-string">&quot;&quot;</span>;
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> openai.<span class="hljs-title function_">chatCompletionStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;gpt-3.5-turbo&quot;</span>,
  <span class="hljs-attr">messages</span>: [
    { <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Complete the equation 1+1= ,just the answer&quot;</span> },
  ],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">500</span>,
  <span class="hljs-attr">temperature</span>: <span class="hljs-number">0.1</span>,
  <span class="hljs-attr">seed</span>: <span class="hljs-number">0</span>,
})) {
  <span class="hljs-keyword">if</span> (chunk.<span class="hljs-property">choices</span> &amp;&amp; chunk.<span class="hljs-property">choices</span>.<span class="hljs-property">length</span> &gt; <span class="hljs-number">0</span>) {
    out += chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">delta</span>.<span class="hljs-property">content</span>;
  }
}

<span class="hljs-comment">// For mistral AI:</span>
<span class="hljs-comment">// endpointUrl: &quot;https://api.mistral.ai&quot;</span>
<span class="hljs-comment">// model: &quot;mistral-tiny&quot;</span>`,wrap:!1}}),as=new m({props:{title:"Fill Mask",local:"fill-mask",headingTag:"h3"}}),ns=new y({props:{code:"YXdhaXQlMjBoZi5maWxsTWFzayglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdiZXJ0LWJhc2UtdW5jYXNlZCclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnJTVCTUFTSyU1RCUyMHdvcmxkISclMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">fillMask</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;bert-base-uncased&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;[MASK] world!&#x27;</span>
})`,wrap:!1}}),ps=new m({props:{title:"Summarization",local:"summarization",headingTag:"h3"}}),os=new y({props:{code:"YXdhaXQlMjBoZi5zdW1tYXJpemF0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ZhY2Vib29rJTJGYmFydC1sYXJnZS1jbm4nJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTBBJTIwJTIwJTIwJTIwJ1RoZSUyMHRvd2VyJTIwaXMlMjAzMjQlMjBtZXRyZXMlMjAoMSUyQzA2MyUyMGZ0KSUyMHRhbGwlMkMlMjBhYm91dCUyMHRoZSUyMHNhbWUlMjBoZWlnaHQlMjBhcyUyMGFuJTIwODEtc3RvcmV5JTIwYnVpbGRpbmclMkMlMjBhbmQlMjB0aGUlMjB0YWxsZXN0JTIwc3RydWN0dXJlJTIwaW4lMjBQYXJpcy4lMjBJdHMlMjBiYXNlJTIwaXMlMjBzcXVhcmUlMkMlMjBtZWFzdXJpbmclMjAxMjUlMjBtZXRyZXMlMjAoNDEwJTIwZnQpJTIwb24lMjBlYWNoJTIwc2lkZS4lMjBEdXJpbmclMjBpdHMlMjBjb25zdHJ1Y3Rpb24lMkMlMjB0aGUlMjBFaWZmZWwlMjBUb3dlciUyMHN1cnBhc3NlZCUyMHRoZSUyMFdhc2hpbmd0b24lMjBNb251bWVudCUyMHRvJTIwYmVjb21lJTIwdGhlJTIwdGFsbGVzdCUyMG1hbi1tYWRlJTIwc3RydWN0dXJlJTIwaW4lMjB0aGUlMjB3b3JsZCUyQyUyMGElMjB0aXRsZSUyMGl0JTIwaGVsZCUyMGZvciUyMDQxJTIweWVhcnMlMjB1bnRpbCUyMHRoZSUyMENocnlzbGVyJTIwQnVpbGRpbmclMjBpbiUyME5ldyUyMFlvcmslMjBDaXR5JTIwd2FzJTIwZmluaXNoZWQlMjBpbiUyMDE5MzAuJyUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBtYXhfbGVuZ3RoJTNBJTIwMTAwJTBBJTIwJTIwJTdEJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">summarization</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/bart-large-cnn&#x27;</span>,
  <span class="hljs-attr">inputs</span>:
    <span class="hljs-string">&#x27;The tower is 324 metres (1,063 ft) tall, about the same height as an 81-storey building, and the tallest structure in Paris. Its base is square, measuring 125 metres (410 ft) on each side. During its construction, the Eiffel Tower surpassed the Washington Monument to become the tallest man-made structure in the world, a title it held for 41 years until the Chrysler Building in New York City was finished in 1930.&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">max_length</span>: <span class="hljs-number">100</span>
  }
})`,wrap:!1}}),Ms=new m({props:{title:"Question Answering",local:"question-answering",headingTag:"h3"}}),cs=new y({props:{code:"YXdhaXQlMjBoZi5xdWVzdGlvbkFuc3dlcmluZyglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdkZWVwc2V0JTJGcm9iZXJ0YS1iYXNlLXNxdWFkMiclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBxdWVzdGlvbiUzQSUyMCdXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YnJTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dCUzQSUyMCdUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiclMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">questionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;deepset/roberta-base-squad2&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">question</span>: <span class="hljs-string">&#x27;What is the capital of France?&#x27;</span>,
    <span class="hljs-attr">context</span>: <span class="hljs-string">&#x27;The capital of France is Paris.&#x27;</span>
  }
})`,wrap:!1}}),hs=new m({props:{title:"Table Question Answering",local:"table-question-answering",headingTag:"h3"}}),js=new y({props:{code:"YXdhaXQlMjBoZi50YWJsZVF1ZXN0aW9uQW5zd2VyaW5nKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2dvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBxdWVyeSUzQSUyMCdIb3clMjBtYW55JTIwc3RhcnMlMjBkb2VzJTIwdGhlJTIwdHJhbnNmb3JtZXJzJTIwcmVwb3NpdG9yeSUyMGhhdmUlM0YnJTJDJTBBJTIwJTIwJTIwJTIwdGFibGUlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjBSZXBvc2l0b3J5JTNBJTIwJTVCJ1RyYW5zZm9ybWVycyclMkMlMjAnRGF0YXNldHMnJTJDJTIwJ1Rva2VuaXplcnMnJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwU3RhcnMlM0ElMjAlNUInMzY1NDInJTJDJTIwJzQ1MTInJTJDJTIwJzM5MzQnJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwQ29udHJpYnV0b3JzJTNBJTIwJTVCJzY1MSclMkMlMjAnNzcnJTJDJTIwJzM0JyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCdQcm9ncmFtbWluZyUyMGxhbmd1YWdlJyUzQSUyMCU1QidQeXRob24nJTJDJTIwJ1B5dGhvbiclMkMlMjAnUnVzdCUyQyUyMFB5dGhvbiUyMGFuZCUyME5vZGVKUyclNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tableQuestionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;google/tapas-base-finetuned-wtq&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">query</span>: <span class="hljs-string">&#x27;How many stars does the transformers repository have?&#x27;</span>,
    <span class="hljs-attr">table</span>: {
      <span class="hljs-title class_">Repository</span>: [<span class="hljs-string">&#x27;Transformers&#x27;</span>, <span class="hljs-string">&#x27;Datasets&#x27;</span>, <span class="hljs-string">&#x27;Tokenizers&#x27;</span>],
      <span class="hljs-title class_">Stars</span>: [<span class="hljs-string">&#x27;36542&#x27;</span>, <span class="hljs-string">&#x27;4512&#x27;</span>, <span class="hljs-string">&#x27;3934&#x27;</span>],
      <span class="hljs-title class_">Contributors</span>: [<span class="hljs-string">&#x27;651&#x27;</span>, <span class="hljs-string">&#x27;77&#x27;</span>, <span class="hljs-string">&#x27;34&#x27;</span>],
      <span class="hljs-string">&#x27;Programming language&#x27;</span>: [<span class="hljs-string">&#x27;Python&#x27;</span>, <span class="hljs-string">&#x27;Python&#x27;</span>, <span class="hljs-string">&#x27;Rust, Python and NodeJS&#x27;</span>]
    }
  }
})`,wrap:!1}}),Js=new m({props:{title:"Text Classification",local:"text-classification",headingTag:"h3"}}),ys=new y({props:{code:"YXdhaXQlMjBoZi50ZXh0Q2xhc3NpZmljYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2gnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJ0klMjBsaWtlJTIweW91LiUyMEklMjBsb3ZlJTIweW91LiclMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;I like you. I love you.&#x27;</span>
})`,wrap:!1}}),us=new m({props:{title:"Token Classification",local:"token-classification",headingTag:"h3"}}),ws=new y({props:{code:"YXdhaXQlMjBoZi50b2tlbkNsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2RibWR6JTJGYmVydC1sYXJnZS1jYXNlZC1maW5ldHVuZWQtY29ubGwwMy1lbmdsaXNoJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCdNeSUyMG5hbWUlMjBpcyUyMFNhcmFoJTIwSmVzc2ljYSUyMFBhcmtlciUyMGJ1dCUyMHlvdSUyMGNhbiUyMGNhbGwlMjBtZSUyMEplc3NpY2EnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tokenClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;dbmdz/bert-large-cased-finetuned-conll03-english&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;My name is Sarah Jessica Parker but you can call me Jessica&#x27;</span>
})`,wrap:!1}}),fs=new m({props:{title:"Translation",local:"translation",headingTag:"h3"}}),ds=new y({props:{code:"YXdhaXQlMjBoZi50cmFuc2xhdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCd0NS1iYXNlJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCdNeSUyMG5hbWUlMjBpcyUyMFdvbGZnYW5nJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmxpbiclMEElN0QpJTBBJTBBYXdhaXQlMjBoZi50cmFuc2xhdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdmYWNlYm9vayUyRm1iYXJ0LWxhcmdlLTUwLW1hbnktdG8tbWFueS1tbXQnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwdGV4dFRvVHJhbnNsYXRlJTJDJTBBJTIwJTIwcGFyYW1ldGVycyUzQSUyMCU3QiUwQSUyMCUyMCUyMnNyY19sYW5nJTIyJTNBJTIwJTIyZW5fWFglMjIlMkMlMEElMjAlMjAlMjJ0Z3RfbGFuZyUyMiUzQSUyMCUyMmZyX1hYJTIyJTBBJTIwJTdEJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;t5-base&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;My name is Wolfgang and I live in Berlin&#x27;</span>
})

<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/mbart-large-50-many-to-many-mmt&#x27;</span>,
  <span class="hljs-attr">inputs</span>: textToTranslate,
  <span class="hljs-attr">parameters</span>: {
  <span class="hljs-string">&quot;src_lang&quot;</span>: <span class="hljs-string">&quot;en_XX&quot;</span>,
  <span class="hljs-string">&quot;tgt_lang&quot;</span>: <span class="hljs-string">&quot;fr_XX&quot;</span>
 }
})`,wrap:!1}}),Us=new m({props:{title:"Zero-Shot Classification",local:"zero-shot-classification",headingTag:"h3"}}),bs=new y({props:{code:"YXdhaXQlMjBoZi56ZXJvU2hvdENsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ZhY2Vib29rJTJGYmFydC1sYXJnZS1tbmxpJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCdIaSUyQyUyMEklMjByZWNlbnRseSUyMGJvdWdodCUyMGElMjBkZXZpY2UlMjBmcm9tJTIweW91ciUyMGNvbXBhbnklMjBidXQlMjBpdCUyMGlzJTIwbm90JTIwd29ya2luZyUyMGFzJTIwYWR2ZXJ0aXNlZCUyMGFuZCUyMEklMjB3b3VsZCUyMGxpa2UlMjB0byUyMGdldCUyMHJlaW1idXJzZWQhJyUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAlN0IlMjBjYW5kaWRhdGVfbGFiZWxzJTNBJTIwJTVCJ3JlZnVuZCclMkMlMjAnbGVnYWwnJTJDJTIwJ2ZhcSclNUQlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">zeroShotClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/bart-large-mnli&#x27;</span>,
  <span class="hljs-attr">inputs</span>: [
    <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>
  ],
  <span class="hljs-attr">parameters</span>: { <span class="hljs-attr">candidate_labels</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>] }
})`,wrap:!1}}),$s=new m({props:{title:"Conversational",local:"conversational",headingTag:"h3"}}),Bs=new y({props:{code:"YXdhaXQlMjBoZi5jb252ZXJzYXRpb25hbCglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdtaWNyb3NvZnQlMkZEaWFsb0dQVC1sYXJnZSclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBwYXN0X3VzZXJfaW5wdXRzJTNBJTIwJTVCJ1doaWNoJTIwbW92aWUlMjBpcyUyMHRoZSUyMGJlc3QlMjAlM0YnJTVEJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVkX3Jlc3BvbnNlcyUzQSUyMCU1QidJdCUyMGlzJTIwRGllJTIwSGFyZCUyMGZvciUyMHN1cmUuJyU1RCUyQyUwQSUyMCUyMCUyMCUyMHRleHQlM0ElMjAnQ2FuJTIweW91JTIwZXhwbGFpbiUyMHdoeSUyMCUzRiclMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">conversational</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;microsoft/DialoGPT-large&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">past_user_inputs</span>: [<span class="hljs-string">&#x27;Which movie is the best ?&#x27;</span>],
    <span class="hljs-attr">generated_responses</span>: [<span class="hljs-string">&#x27;It is Die Hard for sure.&#x27;</span>],
    <span class="hljs-attr">text</span>: <span class="hljs-string">&#x27;Can you explain why ?&#x27;</span>
  }
})`,wrap:!1}}),xs=new m({props:{title:"Sentence Similarity",local:"sentence-similarity",headingTag:"h3"}}),Zs=new y({props:{code:"YXdhaXQlMjBoZi5zZW50ZW5jZVNpbWlsYXJpdHkoJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnc2VudGVuY2UtdHJhbnNmb3JtZXJzJTJGcGFyYXBocmFzZS14bG0tci1tdWx0aWxpbmd1YWwtdjEnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwc291cmNlX3NlbnRlbmNlJTNBJTIwJ1RoYXQlMjBpcyUyMGElMjBoYXBweSUyMHBlcnNvbiclMkMlMEElMjAlMjAlMjAlMjBzZW50ZW5jZXMlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAnVGhhdCUyMGlzJTIwYSUyMGhhcHB5JTIwZG9nJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCdUaGF0JTIwaXMlMjBhJTIwdmVyeSUyMGhhcHB5JTIwcGVyc29uJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCdUb2RheSUyMGlzJTIwYSUyMHN1bm55JTIwZGF5JyUwQSUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCU3RCUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">sentenceSimilarity</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;sentence-transformers/paraphrase-xlm-r-multilingual-v1&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">source_sentence</span>: <span class="hljs-string">&#x27;That is a happy person&#x27;</span>,
    <span class="hljs-attr">sentences</span>: [
      <span class="hljs-string">&#x27;That is a happy dog&#x27;</span>,
      <span class="hljs-string">&#x27;That is a very happy person&#x27;</span>,
      <span class="hljs-string">&#x27;Today is a sunny day&#x27;</span>
    ]
  }
})`,wrap:!1}}),Qs=new m({props:{title:"Audio",local:"audio",headingTag:"h2"}}),Gs=new m({props:{title:"Automatic Speech Recognition",local:"automatic-speech-recognition",headingTag:"h3"}}),vs=new y({props:{code:"YXdhaXQlMjBoZi5hdXRvbWF0aWNTcGVlY2hSZWNvZ25pdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdmYWNlYm9vayUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MC1zZWxmJyUyQyUwQSUyMCUyMGRhdGElM0ElMjByZWFkRmlsZVN5bmMoJ3Rlc3QlMkZzYW1wbGUxLmZsYWMnKSUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">automaticSpeechRecognition</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/wav2vec2-large-960h-lv60-self&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/sample1.flac&#x27;</span>)
})`,wrap:!1}}),Ws=new m({props:{title:"Audio Classification",local:"audio-classification",headingTag:"h3"}}),Xs=new y({props:{code:"YXdhaXQlMjBoZi5hdWRpb0NsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ3N1cGVyYiUyRmh1YmVydC1sYXJnZS1zdXBlcmItZXInJTJDJTBBJTIwJTIwZGF0YSUzQSUyMHJlYWRGaWxlU3luYygndGVzdCUyRnNhbXBsZTEuZmxhYycpJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">audioClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;superb/hubert-large-superb-er&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/sample1.flac&#x27;</span>)
})`,wrap:!1}}),Ss=new m({props:{title:"Text To Speech",local:"text-to-speech",headingTag:"h3"}}),qs=new y({props:{code:"YXdhaXQlMjBoZi50ZXh0VG9TcGVlY2goJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnZXNwbmV0JTJGa2FuLWJheWFzaGlfbGpzcGVlY2hfdml0cyclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnSGVsbG8lMjB3b3JsZCEnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textToSpeech</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;espnet/kan-bayashi_ljspeech_vits&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;Hello world!&#x27;</span>
})`,wrap:!1}}),zs=new m({props:{title:"Audio To Audio",local:"audio-to-audio",headingTag:"h3"}}),Fs=new y({props:{code:"YXdhaXQlMjBoZi5hdWRpb1RvQXVkaW8oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnc3BlZWNoYnJhaW4lMkZzZXBmb3JtZXItd2hhbSclMkMlMEElMjAlMjBkYXRhJTNBJTIwcmVhZEZpbGVTeW5jKCd0ZXN0JTJGc2FtcGxlMS5mbGFjJyklMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">audioToAudio</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;speechbrain/sepformer-wham&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/sample1.flac&#x27;</span>)
})`,wrap:!1}}),_s=new m({props:{title:"Computer Vision",local:"computer-vision",headingTag:"h2"}}),Ls=new m({props:{title:"Image Classification",local:"image-classification",headingTag:"h3"}}),Ks=new y({props:{code:"YXdhaXQlMjBoZi5pbWFnZUNsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMGRhdGElM0ElMjByZWFkRmlsZVN5bmMoJ3Rlc3QlMkZjaGVldGFoLnBuZycpJTJDJTBBJTIwJTIwbW9kZWwlM0ElMjAnZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageClassification</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cheetah.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;google/vit-base-patch16-224&#x27;</span>
})`,wrap:!1}}),Os=new m({props:{title:"Object Detection",local:"object-detection",headingTag:"h3"}}),lt=new y({props:{code:"YXdhaXQlMjBoZi5vYmplY3REZXRlY3Rpb24oJTdCJTBBJTIwJTIwZGF0YSUzQSUyMHJlYWRGaWxlU3luYygndGVzdCUyRmNhdHMucG5nJyklMkMlMEElMjAlMjBtb2RlbCUzQSUyMCdmYWNlYm9vayUyRmRldHItcmVzbmV0LTUwJyUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">objectDetection</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cats.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/detr-resnet-50&#x27;</span>
})`,wrap:!1}}),at=new m({props:{title:"Image Segmentation",local:"image-segmentation",headingTag:"h3"}}),nt=new y({props:{code:"YXdhaXQlMjBoZi5pbWFnZVNlZ21lbnRhdGlvbiglN0IlMEElMjAlMjBkYXRhJTNBJTIwcmVhZEZpbGVTeW5jKCd0ZXN0JTJGY2F0cy5wbmcnKSUyQyUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ZhY2Vib29rJTJGZGV0ci1yZXNuZXQtNTAtcGFub3B0aWMnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageSegmentation</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cats.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/detr-resnet-50-panoptic&#x27;</span>
})`,wrap:!1}}),pt=new m({props:{title:"Image To Text",local:"image-to-text",headingTag:"h3"}}),ot=new y({props:{code:"YXdhaXQlMjBoZi5pbWFnZVRvVGV4dCglN0IlMEElMjAlMjBkYXRhJTNBJTIwcmVhZEZpbGVTeW5jKCd0ZXN0JTJGY2F0cy5wbmcnKSUyQyUwQSUyMCUyMG1vZGVsJTNBJTIwJ25scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJyUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageToText</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cats.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;nlpconnect/vit-gpt2-image-captioning&#x27;</span>
})`,wrap:!1}}),Mt=new m({props:{title:"Text To Image",local:"text-to-image",headingTag:"h3"}}),ht=new y({props:{code:"YXdhaXQlMjBoZi50ZXh0VG9JbWFnZSglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJ2ElMjBwaWN0dXJlJTIwb2YlMjBhJTIwZ3JlZW4lMjBiaXJkJyUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;black-forest-labs/FLUX.1-dev&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;a picture of a green bird&#x27;</span>
})`,wrap:!1}}),jt=new m({props:{title:"Image To Image",local:"image-to-image",headingTag:"h3"}}),yt=new y({props:{code:"YXdhaXQlMjBoZi5pbWFnZVRvSW1hZ2UoJTdCJTBBJTIwJTIwaW5wdXRzJTNBJTIwbmV3JTIwQmxvYiglNUJyZWFkRmlsZVN5bmMoJTIydGVzdCUyRnN0b3JtdHJvb3Blcl9kZXB0aC5wbmclMjIpJTVEKSUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBwcm9tcHQlM0ElMjAlMjJlbG1vJ3MlMjBsZWN0dXJlJTIyJTJDJTBBJTIwJTIwJTdEJTJDJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJsbGx5YXN2aWVsJTJGc2QtY29udHJvbG5ldC1kZXB0aCUyMiUyQyUwQSU3RCklM0I=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageToImage</span>({
  <span class="hljs-attr">inputs</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>([<span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&quot;test/stormtrooper_depth.png&quot;</span>)]),
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">prompt</span>: <span class="hljs-string">&quot;elmo&#x27;s lecture&quot;</span>,
  },
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;lllyasviel/sd-controlnet-depth&quot;</span>,
});`,wrap:!1}}),ut=new m({props:{title:"Zero Shot Image Classification",local:"zero-shot-image-classification",headingTag:"h3"}}),wt=new y({props:{code:"YXdhaXQlMjBoZi56ZXJvU2hvdEltYWdlQ2xhc3NpZmljYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnb3BlbmFpJTJGY2xpcC12aXQtbGFyZ2UtcGF0Y2gxNC0zMzYnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0ElMjBhd2FpdCUyMChhd2FpdCUyMGZldGNoKCdodHRwcyUzQSUyRiUyRnBsYWNla2l0dGVuLmNvbSUyRjMwMCUyRjMwMCcpKS5ibG9iKCklMEElMjAlMjAlN0QlMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwY2FuZGlkYXRlX2xhYmVscyUzQSUyMCU1QidjYXQnJTJDJTIwJ2RvZyclNUQlMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">zeroShotImageClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;openai/clip-vit-large-patch14-336&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">image</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://placekitten.com/300/300&#x27;</span>)).<span class="hljs-title function_">blob</span>()
  },
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">candidate_labels</span>: [<span class="hljs-string">&#x27;cat&#x27;</span>, <span class="hljs-string">&#x27;dog&#x27;</span>]
  }
})`,wrap:!1}}),ft=new m({props:{title:"Multimodal",local:"multimodal",headingTag:"h2"}}),gt=new m({props:{title:"Feature Extraction",local:"feature-extraction",headingTag:"h3"}}),Ut=new y({props:{code:"YXdhaXQlMjBoZi5mZWF0dXJlRXh0cmFjdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMnNlbnRlbmNlLXRyYW5zZm9ybWVycyUyRmRpc3RpbGJlcnQtYmFzZS1ubGktbWVhbi10b2tlbnMlMjIlMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlMjJUaGF0JTIwaXMlMjBhJTIwaGFwcHklMjBwZXJzb24lMjIlMkMlMEElN0QpJTNC",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">featureExtraction</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;sentence-transformers/distilbert-base-nli-mean-tokens&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;That is a happy person&quot;</span>,
});`,wrap:!1}}),It=new m({props:{title:"Visual Question Answering",local:"visual-question-answering",headingTag:"h3"}}),Ct=new y({props:{code:"YXdhaXQlMjBoZi52aXN1YWxRdWVzdGlvbkFuc3dlcmluZyglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdkYW5kZWxpbiUyRnZpbHQtYjMyLWZpbmV0dW5lZC12cWEnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lM0ElMjAnSG93JTIwbWFueSUyMGNhdHMlMjBhcmUlMjBseWluZyUyMGRvd24lM0YnJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0ElMjBhd2FpdCUyMChhd2FpdCUyMGZldGNoKCdodHRwcyUzQSUyRiUyRnBsYWNla2l0dGVuLmNvbSUyRjMwMCUyRjMwMCcpKS5ibG9iKCklMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">visualQuestionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;dandelin/vilt-b32-finetuned-vqa&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">question</span>: <span class="hljs-string">&#x27;How many cats are lying down?&#x27;</span>,
    <span class="hljs-attr">image</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://placekitten.com/300/300&#x27;</span>)).<span class="hljs-title function_">blob</span>()
  }
})`,wrap:!1}}),Bt=new m({props:{title:"Document Question Answering",local:"document-question-answering",headingTag:"h3"}}),Zt=new y({props:{code:"YXdhaXQlMjBoZi5kb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ltcGlyYSUyRmxheW91dGxtLWRvY3VtZW50LXFhJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMHF1ZXN0aW9uJTNBJTIwJ0ludm9pY2UlMjBudW1iZXIlM0YnJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0ElMjBhd2FpdCUyMChhd2FpdCUyMGZldGNoKCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3BhY2VzJTJGaW1waXJhJTJGZG9jcXVlcnklMkZyZXNvbHZlJTJGMjM1OTIyM2MxODM3YTc1ODc0MDJiZGEwZjI2NDMzODJhNmVlZmVhYiUyRmludm9pY2UucG5nJykpLmJsb2IoKSUyQyUwQSUyMCUyMCU3RCUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">documentQuestionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;impira/layoutlm-document-qa&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">question</span>: <span class="hljs-string">&#x27;Invoice number?&#x27;</span>,
    <span class="hljs-attr">image</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&#x27;</span>)).<span class="hljs-title function_">blob</span>(),
  }
})`,wrap:!1}}),Qt=new m({props:{title:"Tabular",local:"tabular",headingTag:"h2"}}),Gt=new m({props:{title:"Tabular Regression",local:"tabular-regression",headingTag:"h3"}}),Et=new y({props:{code:"YXdhaXQlMjBoZi50YWJ1bGFyUmVncmVzc2lvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMnNjaWtpdC1sZWFybiUyRkZpc2gtV2VpZ2h0JTIyJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwZGF0YSUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMkhlaWdodCUyMiUzQSUyMCU1QiUyMjExLjUyJTIyJTJDJTIwJTIyMTIuNDglMjIlMkMlMjAlMjIxMi4zNzc4JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyTGVuZ3RoMSUyMiUzQSUyMCU1QiUyMjIzLjIlMjIlMkMlMjAlMjIyNCUyMiUyQyUyMCUyMjIzLjklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJMZW5ndGgyJTIyJTNBJTIwJTVCJTIyMjUuNCUyMiUyQyUyMCUyMjI2LjMlMjIlMkMlMjAlMjIyNi41JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyTGVuZ3RoMyUyMiUzQSUyMCU1QiUyMjMwJTIyJTJDJTIwJTIyMzEuMiUyMiUyQyUyMCUyMjMxLjElMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJTcGVjaWVzJTIyJTNBJTIwJTVCJTIyQnJlYW0lMjIlMkMlMjAlMjJCcmVhbSUyMiUyQyUyMCUyMkJyZWFtJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2lkdGglMjIlM0ElMjAlNUIlMjI0LjAyJTIyJTJDJTIwJTIyNC4zMDU2JTIyJTJDJTIwJTIyNC42OTYxJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTdEJTJDJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tabularRegression</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;scikit-learn/Fish-Weight&quot;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">data</span>: {
      <span class="hljs-string">&quot;Height&quot;</span>: [<span class="hljs-string">&quot;11.52&quot;</span>, <span class="hljs-string">&quot;12.48&quot;</span>, <span class="hljs-string">&quot;12.3778&quot;</span>],
      <span class="hljs-string">&quot;Length1&quot;</span>: [<span class="hljs-string">&quot;23.2&quot;</span>, <span class="hljs-string">&quot;24&quot;</span>, <span class="hljs-string">&quot;23.9&quot;</span>],
      <span class="hljs-string">&quot;Length2&quot;</span>: [<span class="hljs-string">&quot;25.4&quot;</span>, <span class="hljs-string">&quot;26.3&quot;</span>, <span class="hljs-string">&quot;26.5&quot;</span>],
      <span class="hljs-string">&quot;Length3&quot;</span>: [<span class="hljs-string">&quot;30&quot;</span>, <span class="hljs-string">&quot;31.2&quot;</span>, <span class="hljs-string">&quot;31.1&quot;</span>],
      <span class="hljs-string">&quot;Species&quot;</span>: [<span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>],
      <span class="hljs-string">&quot;Width&quot;</span>: [<span class="hljs-string">&quot;4.02&quot;</span>, <span class="hljs-string">&quot;4.3056&quot;</span>, <span class="hljs-string">&quot;4.6961&quot;</span>]
    },
  },
})`,wrap:!1}}),vt=new m({props:{title:"Tabular Classification",local:"tabular-classification",headingTag:"h3"}}),At=new y({props:{code:"YXdhaXQlMjBoZi50YWJ1bGFyQ2xhc3NpZmljYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJ2dm1ubm5rdiUyRndpbmUtcXVhbGl0eSUyMiUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMGRhdGElM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJmaXhlZF9hY2lkaXR5JTIyJTNBJTIwJTVCJTIyNy40JTIyJTJDJTIwJTIyNy44JTIyJTJDJTIwJTIyMTAuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnZvbGF0aWxlX2FjaWRpdHklMjIlM0ElMjAlNUIlMjIwLjclMjIlMkMlMjAlMjIwLjg4JTIyJTJDJTIwJTIyMC4zMiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmNpdHJpY19hY2lkJTIyJTNBJTIwJTVCJTIyMCUyMiUyQyUyMCUyMjAlMjIlMkMlMjAlMjIwLjQ1JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycmVzaWR1YWxfc3VnYXIlMjIlM0ElMjAlNUIlMjIxLjklMjIlMkMlMjAlMjIyLjYlMjIlMkMlMjAlMjI2LjQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJjaGxvcmlkZXMlMjIlM0ElMjAlNUIlMjIwLjA3NiUyMiUyQyUyMCUyMjAuMDk4JTIyJTJDJTIwJTIyMC4wNzMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJmcmVlX3N1bGZ1cl9kaW94aWRlJTIyJTNBJTIwJTVCJTIyMTElMjIlMkMlMjAlMjIyNSUyMiUyQyUyMCUyMjUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0b3RhbF9zdWxmdXJfZGlveGlkZSUyMiUzQSUyMCU1QiUyMjM0JTIyJTJDJTIwJTIyNjclMjIlMkMlMjAlMjIxMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlbnNpdHklMjIlM0ElMjAlNUIlMjIwLjk5NzglMjIlMkMlMjAlMjIwLjk5NjglMjIlMkMlMjAlMjIwLjk5NzYlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJwSCUyMiUzQSUyMCU1QiUyMjMuNTElMjIlMkMlMjAlMjIzLjIlMjIlMkMlMjAlMjIzLjIzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3VscGhhdGVzJTIyJTNBJTIwJTVCJTIyMC41NiUyMiUyQyUyMCUyMjAuNjglMjIlMkMlMjAlMjIwLjgyJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWxjb2hvbCUyMiUzQSUyMCU1QiUyMjkuNCUyMiUyQyUyMCUyMjkuOCUyMiUyQyUyMCUyMjEyLjYlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlN0QlMkMlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tabularClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;vvmnnnkv/wine-quality&quot;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">data</span>: {
      <span class="hljs-string">&quot;fixed_acidity&quot;</span>: [<span class="hljs-string">&quot;7.4&quot;</span>, <span class="hljs-string">&quot;7.8&quot;</span>, <span class="hljs-string">&quot;10.3&quot;</span>],
      <span class="hljs-string">&quot;volatile_acidity&quot;</span>: [<span class="hljs-string">&quot;0.7&quot;</span>, <span class="hljs-string">&quot;0.88&quot;</span>, <span class="hljs-string">&quot;0.32&quot;</span>],
      <span class="hljs-string">&quot;citric_acid&quot;</span>: [<span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0.45&quot;</span>],
      <span class="hljs-string">&quot;residual_sugar&quot;</span>: [<span class="hljs-string">&quot;1.9&quot;</span>, <span class="hljs-string">&quot;2.6&quot;</span>, <span class="hljs-string">&quot;6.4&quot;</span>],
      <span class="hljs-string">&quot;chlorides&quot;</span>: [<span class="hljs-string">&quot;0.076&quot;</span>, <span class="hljs-string">&quot;0.098&quot;</span>, <span class="hljs-string">&quot;0.073&quot;</span>],
      <span class="hljs-string">&quot;free_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;11&quot;</span>, <span class="hljs-string">&quot;25&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>],
      <span class="hljs-string">&quot;total_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;34&quot;</span>, <span class="hljs-string">&quot;67&quot;</span>, <span class="hljs-string">&quot;13&quot;</span>],
      <span class="hljs-string">&quot;density&quot;</span>: [<span class="hljs-string">&quot;0.9978&quot;</span>, <span class="hljs-string">&quot;0.9968&quot;</span>, <span class="hljs-string">&quot;0.9976&quot;</span>],
      <span class="hljs-string">&quot;pH&quot;</span>: [<span class="hljs-string">&quot;3.51&quot;</span>, <span class="hljs-string">&quot;3.2&quot;</span>, <span class="hljs-string">&quot;3.23&quot;</span>],
      <span class="hljs-string">&quot;sulphates&quot;</span>: [<span class="hljs-string">&quot;0.56&quot;</span>, <span class="hljs-string">&quot;0.68&quot;</span>, <span class="hljs-string">&quot;0.82&quot;</span>],
      <span class="hljs-string">&quot;alcohol&quot;</span>: [<span class="hljs-string">&quot;9.4&quot;</span>, <span class="hljs-string">&quot;9.8&quot;</span>, <span class="hljs-string">&quot;12.6&quot;</span>]
    },
  },
})`,wrap:!1}}),Yt=new m({props:{title:"Custom Calls",local:"custom-calls",headingTag:"h2"}}),St=new y({props:{code:"YXdhaXQlMjBoZi5yZXF1ZXN0KCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ215LWN1c3RvbS1tb2RlbCclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnaGVsbG8lMjB3b3JsZCclMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3BhcmFtJTNBJTIwJ3NvbWUlMjBtYWdpYyclMkMlMEElMjAlMjAlN0QlMEElN0QpJTBBJTBBJTJGJTJGJTIwQ3VzdG9tJTIwc3RyZWFtaW5nJTIwY2FsbCUyQyUyMGZvciUyMG1vZGVscyUyMHdpdGglMjBjdXN0b20lMjBwYXJhbWV0ZXJzJTIwJTJGJTIwb3V0cHV0cyUwQWZvciUyMGF3YWl0JTIwKGNvbnN0JTIwb3V0cHV0JTIwb2YlMjBoZi5zdHJlYW1pbmdSZXF1ZXN0KCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ215LWN1c3RvbS1tb2RlbCclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnaGVsbG8lMjB3b3JsZCclMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3BhcmFtJTNBJTIwJ3NvbWUlMjBtYWdpYyclMkMlMEElMjAlMjAlN0QlMEElN0QpKSUyMCU3QiUwQSUyMCUyMC4uLiUwQSU3RA==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">request</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;my-custom-model&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;hello world&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">custom_param</span>: <span class="hljs-string">&#x27;some magic&#x27;</span>,
  }
})

<span class="hljs-comment">// Custom streaming call, for models with custom parameters / outputs</span>
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> output <span class="hljs-keyword">of</span> hf.<span class="hljs-title function_">streamingRequest</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;my-custom-model&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;hello world&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">custom_param</span>: <span class="hljs-string">&#x27;some magic&#x27;</span>,
  }
})) {
  ...
}`,wrap:!1}}),Rt=new y({props:{code:"JTJGJTJGJTIwQ2hhdCUyMENvbXBsZXRpb24lMjBFeGFtcGxlJTBBY29uc3QlMjBNSVNUUkFMX0tFWSUyMCUzRCUyMHByb2Nlc3MuZW52Lk1JU1RSQUxfS0VZJTNCJTBBY29uc3QlMjBoZiUyMCUzRCUyMG5ldyUyMEhmSW5mZXJlbmNlKE1JU1RSQUxfS0VZKSUzQiUwQWNvbnN0JTIwZXAlMjAlM0QlMjBoZi5lbmRwb2ludCglMjJodHRwcyUzQSUyRiUyRmFwaS5taXN0cmFsLmFpJTIyKSUzQiUwQWNvbnN0JTIwc3RyZWFtJTIwJTNEJTIwZXAuY2hhdENvbXBsZXRpb25TdHJlYW0oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJtaXN0cmFsLXRpbnklMjIlMkMlMEElMjAlMjBtZXNzYWdlcyUzQSUyMCU1QiU3QiUyMHJvbGUlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwY29udGVudCUzQSUyMCUyMkNvbXBsZXRlJTIwdGhlJTIwZXF1YXRpb24lMjBvbmUlMjAlMkIlMjBvbmUlMjAlM0QlMjAlMkMlMjBqdXN0JTIwdGhlJTIwYW5zd2VyJTIyJTIwJTdEJTVEJTJDJTBBJTdEKSUzQiUwQWxldCUyMG91dCUyMCUzRCUyMCUyMiUyMiUzQiUwQWZvciUyMGF3YWl0JTIwKGNvbnN0JTIwY2h1bmslMjBvZiUyMHN0cmVhbSklMjAlN0IlMEElMjAlMjBpZiUyMChjaHVuay5jaG9pY2VzJTIwJTI2JTI2JTIwY2h1bmsuY2hvaWNlcy5sZW5ndGglMjAlM0UlMjAwKSUyMCU3QiUwQSUyMCUyMCUyMCUyMG91dCUyMCUyQiUzRCUyMGNodW5rLmNob2ljZXMlNUIwJTVELmRlbHRhLmNvbnRlbnQlM0IlMEElMjAlMjAlMjAlMjBjb25zb2xlLmxvZyhvdXQpJTNCJTBBJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-comment">// Chat Completion Example</span>
<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">MISTRAL_KEY</span> = process.<span class="hljs-property">env</span>.<span class="hljs-property">MISTRAL_KEY</span>;
<span class="hljs-keyword">const</span> hf = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfInference</span>(<span class="hljs-variable constant_">MISTRAL_KEY</span>);
<span class="hljs-keyword">const</span> ep = hf.<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&quot;https://api.mistral.ai&quot;</span>);
<span class="hljs-keyword">const</span> stream = ep.<span class="hljs-title function_">chatCompletionStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;mistral-tiny&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Complete the equation one + one = , just the answer&quot;</span> }],
});
<span class="hljs-keyword">let</span> out = <span class="hljs-string">&quot;&quot;</span>;
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> stream) {
  <span class="hljs-keyword">if</span> (chunk.<span class="hljs-property">choices</span> &amp;&amp; chunk.<span class="hljs-property">choices</span>.<span class="hljs-property">length</span> &gt; <span class="hljs-number">0</span>) {
    out += chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">delta</span>.<span class="hljs-property">content</span>;
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(out);
  }
}`,wrap:!1}}),qt=new m({props:{title:"Custom Inference Endpoints",local:"custom-inference-endpoints",headingTag:"h2"}}),Ht=new y({props:{code:"Y29uc3QlMjBncHQyJTIwJTNEJTIwaGYuZW5kcG9pbnQoJ2h0dHBzJTNBJTJGJTJGeHl6LmV1LXdlc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGZ3B0MicpJTNCJTBBY29uc3QlMjAlN0IlMjBnZW5lcmF0ZWRfdGV4dCUyMCU3RCUyMCUzRCUyMGF3YWl0JTIwZ3B0Mi50ZXh0R2VuZXJhdGlvbiglN0JpbnB1dHMlM0ElMjAnVGhlJTIwYW5zd2VyJTIwdG8lMjB0aGUlMjB1bml2ZXJzZSUyMGlzJyU3RCklM0IlMEElMEElMkYlMkYlMjBDaGF0JTIwQ29tcGxldGlvbiUyMEV4YW1wbGUlMEFjb25zdCUyMGVwJTIwJTNEJTIwaGYuZW5kcG9pbnQoJTBBJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZyb3V0ZXIuaHVnZ2luZ2ZhY2UuY28lMkZoZi1pbmZlcmVuY2UlMkZtb2RlbHMlMkZtZXRhLWxsYW1hJTJGTGxhbWEtMy4xLThCLUluc3RydWN0JTIyJTBBKSUzQiUwQWNvbnN0JTIwc3RyZWFtJTIwJTNEJTIwZXAuY2hhdENvbXBsZXRpb25TdHJlYW0oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJ0Z2klMjIlMkMlMEElMjAlMjBtZXNzYWdlcyUzQSUyMCU1QiU3QiUyMHJvbGUlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwY29udGVudCUzQSUyMCUyMkNvbXBsZXRlJTIwdGhlJTIwZXF1YXRpb24lMjAxJTJCMSUzRCUyMCUyQ2p1c3QlMjB0aGUlMjBhbnN3ZXIlMjIlMjAlN0QlNUQlMkMlMEElMjAlMjBtYXhfdG9rZW5zJTNBJTIwNTAwJTJDJTBBJTIwJTIwdGVtcGVyYXR1cmUlM0ElMjAwLjElMkMlMEElMjAlMjBzZWVkJTNBJTIwMCUyQyUwQSU3RCklM0IlMEFsZXQlMjBvdXQlMjAlM0QlMjAlMjIlMjIlM0IlMEFmb3IlMjBhd2FpdCUyMChjb25zdCUyMGNodW5rJTIwb2YlMjBzdHJlYW0pJTIwJTdCJTBBJTIwJTIwaWYlMjAoY2h1bmsuY2hvaWNlcyUyMCUyNiUyNiUyMGNodW5rLmNob2ljZXMubGVuZ3RoJTIwJTNFJTIwMCklMjAlN0IlMEElMjAlMjAlMjAlMjBvdXQlMjAlMkIlM0QlMjBjaHVuay5jaG9pY2VzJTVCMCU1RC5kZWx0YS5jb250ZW50JTNCJTBBJTIwJTIwJTIwJTIwY29uc29sZS5sb2cob3V0KSUzQiUwQSUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-keyword">const</span> gpt2 = hf.<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&#x27;https://xyz.eu-west-1.aws.endpoints.huggingface.cloud/gpt2&#x27;</span>);
<span class="hljs-keyword">const</span> { generated_text } = <span class="hljs-keyword">await</span> gpt2.<span class="hljs-title function_">textGeneration</span>({<span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span>});

<span class="hljs-comment">// Chat Completion Example</span>
<span class="hljs-keyword">const</span> ep = hf.<span class="hljs-title function_">endpoint</span>(
  <span class="hljs-string">&quot;https://router.huggingface.co/hf-inference/models/meta-llama/Llama-3.1-8B-Instruct&quot;</span>
);
<span class="hljs-keyword">const</span> stream = ep.<span class="hljs-title function_">chatCompletionStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;tgi&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Complete the equation 1+1= ,just the answer&quot;</span> }],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">500</span>,
  <span class="hljs-attr">temperature</span>: <span class="hljs-number">0.1</span>,
  <span class="hljs-attr">seed</span>: <span class="hljs-number">0</span>,
});
<span class="hljs-keyword">let</span> out = <span class="hljs-string">&quot;&quot;</span>;
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> stream) {
  <span class="hljs-keyword">if</span> (chunk.<span class="hljs-property">choices</span> &amp;&amp; chunk.<span class="hljs-property">choices</span>.<span class="hljs-property">length</span> &gt; <span class="hljs-number">0</span>) {
    out += chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">delta</span>.<span class="hljs-property">content</span>;
    <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(out);
  }
}`,wrap:!1}}),_t=new y({props:{code:"Y29uc3QlMjBncHQyJTIwJTNEJTIwaGYuZW5kcG9pbnQoJ2h0dHBzJTNBJTJGJTJGeHl6LmV1LXdlc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGZ3B0MicpJTNCJTBBY29uc3QlMjAlN0IlMjBnZW5lcmF0ZWRfdGV4dCUyMCU3RCUyMCUzRCUyMGF3YWl0JTIwZ3B0Mi50ZXh0R2VuZXJhdGlvbiglMEElMjAlMjAlN0JpbnB1dHMlM0ElMjAnVGhlJTIwYW5zd2VyJTIwdG8lMjB0aGUlMjB1bml2ZXJzZSUyMGlzJyU3RCUyQyUwQSUyMCUyMCU3QnJldHJ5X29uX2Vycm9yJTNBJTIwZmFsc2UlN0QlMkMlMEEpJTNC",highlighted:`<span class="hljs-keyword">const</span> gpt2 = hf.<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&#x27;https://xyz.eu-west-1.aws.endpoints.huggingface.cloud/gpt2&#x27;</span>);
<span class="hljs-keyword">const</span> { generated_text } = <span class="hljs-keyword">await</span> gpt2.<span class="hljs-title function_">textGeneration</span>(
  {<span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span>},
  {<span class="hljs-attr">retry_on_error</span>: <span class="hljs-literal">false</span>},
);`,wrap:!1}}),Lt=new m({props:{title:"Running tests",local:"running-tests",headingTag:"h2"}}),Dt=new y({props:{code:"SEZfVE9LRU4lM0QlMjJ5b3VyJTIwYWNjZXNzJTIwdG9rZW4lMjIlMjBwbnBtJTIwcnVuJTIwdGVzdA==",highlighted:"HF_TOKEN=&quot;your access token&quot; pnpm run test",wrap:!1}}),Pt=new m({props:{title:"Finding appropriate models",local:"finding-appropriate-models",headingTag:"h2"}}),sl=new m({props:{title:"Dependencies",local:"dependencies",headingTag:"h2"}}),ll=new cp({props:{source:"https://github.com/huggingface/huggingface.js/blob/main/docs/inference/README.md"}}),{c(){u=h("meta"),nl=e(),al=h("p"),pl=e(),p(T.$$.fragment),il=e(),w=h("p"),w.innerHTML=_e,ol=e(),f=h("p"),f.innerHTML=Le,Ml=e(),p(g.$$.fragment),rl=e(),p(d.$$.fragment),cl=e(),p(U.$$.fragment),hl=e(),p(I.$$.fragment),jl=e(),p(b.$$.fragment),Jl=e(),p($.$$.fragment),ml=e(),p(C.$$.fragment),yl=e(),p(B.$$.fragment),ul=e(),x=h("p"),x.innerHTML=De,Tl=e(),k=h("p"),k.textContent=Pe,wl=e(),p(Z.$$.fragment),fl=e(),Q=h("p"),Q.textContent=Ke,gl=e(),G=h("p"),G.textContent=Oe,dl=e(),N=h("ul"),N.innerHTML=sn,Ul=e(),E=h("p"),E.innerHTML=tn,Il=e(),p(v.$$.fragment),bl=e(),W=h("p"),W.innerHTML=ln,$l=e(),A=h("p"),A.textContent=an,Cl=e(),Y=h("ul"),Y.innerHTML=en,Bl=e(),X=h("p"),X.innerHTML=nn,xl=e(),S=h("p"),S.innerHTML=pn,kl=e(),p(V.$$.fragment),Zl=e(),R=h("p"),R.innerHTML=on,Ql=e(),p(q.$$.fragment),Gl=e(),z=h("p"),z.textContent=Mn,Nl=e(),p(H.$$.fragment),El=e(),p(F.$$.fragment),vl=e(),_=h("p"),_.textContent=rn,Wl=e(),L=h("p"),L.innerHTML=cn,Al=e(),p(D.$$.fragment),Yl=e(),p(P.$$.fragment),Xl=e(),K=h("p"),K.innerHTML=hn,Sl=e(),O=h("p"),O.innerHTML=jn,Vl=e(),p(ss.$$.fragment),Rl=e(),ts=h("p"),ts.textContent=Jn,ql=e(),p(ls.$$.fragment),zl=e(),p(as.$$.fragment),Hl=e(),es=h("p"),es.textContent=mn,Fl=e(),p(ns.$$.fragment),_l=e(),p(ps.$$.fragment),Ll=e(),is=h("p"),is.textContent=yn,Dl=e(),p(os.$$.fragment),Pl=e(),p(Ms.$$.fragment),Kl=e(),rs=h("p"),rs.textContent=un,Ol=e(),p(cs.$$.fragment),sa=e(),p(hs.$$.fragment),ta=e(),p(js.$$.fragment),la=e(),p(Js.$$.fragment),aa=e(),ms=h("p"),ms.textContent=Tn,ea=e(),p(ys.$$.fragment),na=e(),p(us.$$.fragment),pa=e(),Ts=h("p"),Ts.textContent=wn,ia=e(),p(ws.$$.fragment),oa=e(),p(fs.$$.fragment),Ma=e(),gs=h("p"),gs.textContent=fn,ra=e(),p(ds.$$.fragment),ca=e(),p(Us.$$.fragment),ha=e(),Is=h("p"),Is.textContent=gn,ja=e(),p(bs.$$.fragment),Ja=e(),p($s.$$.fragment),ma=e(),Cs=h("p"),Cs.textContent=dn,ya=e(),p(Bs.$$.fragment),ua=e(),p(xs.$$.fragment),Ta=e(),ks=h("p"),ks.textContent=Un,wa=e(),p(Zs.$$.fragment),fa=e(),p(Qs.$$.fragment),ga=e(),p(Gs.$$.fragment),da=e(),Ns=h("p"),Ns.textContent=In,Ua=e(),Es=h("p"),Es.innerHTML=bn,Ia=e(),p(vs.$$.fragment),ba=e(),p(Ws.$$.fragment),$a=e(),As=h("p"),As.textContent=$n,Ca=e(),Ys=h("p"),Ys.innerHTML=Cn,Ba=e(),p(Xs.$$.fragment),xa=e(),p(Ss.$$.fragment),ka=e(),Vs=h("p"),Vs.textContent=Bn,Za=e(),Rs=h("p"),Rs.innerHTML=xn,Qa=e(),p(qs.$$.fragment),Ga=e(),p(zs.$$.fragment),Na=e(),Hs=h("p"),Hs.textContent=kn,Ea=e(),p(Fs.$$.fragment),va=e(),p(_s.$$.fragment),Wa=e(),p(Ls.$$.fragment),Aa=e(),Ds=h("p"),Ds.textContent=Zn,Ya=e(),Ps=h("p"),Ps.innerHTML=Qn,Xa=e(),p(Ks.$$.fragment),Sa=e(),p(Os.$$.fragment),Va=e(),st=h("p"),st.textContent=Gn,Ra=e(),tt=h("p"),tt.innerHTML=Nn,qa=e(),p(lt.$$.fragment),za=e(),p(at.$$.fragment),Ha=e(),et=h("p"),et.textContent=En,Fa=e(),p(nt.$$.fragment),_a=e(),p(pt.$$.fragment),La=e(),it=h("p"),it.textContent=vn,Da=e(),p(ot.$$.fragment),Pa=e(),p(Mt.$$.fragment),Ka=e(),rt=h("p"),rt.textContent=Wn,Oa=e(),ct=h("p"),ct.innerHTML=An,se=e(),p(ht.$$.fragment),te=e(),p(jt.$$.fragment),le=e(),Jt=h("p"),Jt.textContent=Yn,ae=e(),mt=h("p"),mt.innerHTML=Xn,ee=e(),p(yt.$$.fragment),ne=e(),p(ut.$$.fragment),pe=e(),Tt=h("p"),Tt.textContent=Sn,ie=e(),p(wt.$$.fragment),oe=e(),p(ft.$$.fragment),Me=e(),p(gt.$$.fragment),re=e(),dt=h("p"),dt.textContent=Vn,ce=e(),p(Ut.$$.fragment),he=e(),p(It.$$.fragment),je=e(),bt=h("p"),bt.textContent=Rn,Je=e(),$t=h("p"),$t.innerHTML=qn,me=e(),p(Ct.$$.fragment),ye=e(),p(Bt.$$.fragment),ue=e(),xt=h("p"),xt.textContent=zn,Te=e(),kt=h("p"),kt.innerHTML=Hn,we=e(),p(Zt.$$.fragment),fe=e(),p(Qt.$$.fragment),ge=e(),p(Gt.$$.fragment),de=e(),Nt=h("p"),Nt.textContent=Fn,Ue=e(),p(Et.$$.fragment),Ie=e(),p(vt.$$.fragment),be=e(),Wt=h("p"),Wt.textContent=_n,$e=e(),p(At.$$.fragment),Ce=e(),p(Yt.$$.fragment),Be=e(),Xt=h("p"),Xt.textContent=Ln,xe=e(),p(St.$$.fragment),ke=e(),Vt=h("p"),Vt.innerHTML=Dn,Ze=e(),p(Rt.$$.fragment),Qe=e(),p(qt.$$.fragment),Ge=e(),zt=h("p"),zt.innerHTML=Pn,Ne=e(),p(Ht.$$.fragment),Ee=e(),Ft=h("p"),Ft.innerHTML=Kn,ve=e(),p(_t.$$.fragment),We=e(),p(Lt.$$.fragment),Ae=e(),p(Dt.$$.fragment),Ye=e(),p(Pt.$$.fragment),Xe=e(),Kt=h("p"),Kt.innerHTML=On,Se=e(),Ot=h("p"),Ot.textContent=sp,Ve=e(),p(sl.$$.fragment),Re=e(),tl=h("ul"),tl.innerHTML=tp,qe=e(),p(ll.$$.fragment),ze=e(),el=h("p"),this.h()},l(s){const t=Mp("svelte-u9bgzb",document.head);u=j(t,"META",{name:!0,content:!0}),t.forEach(l),nl=n(s),al=j(s,"P",{}),lp(al).forEach(l),pl=n(s),i(T.$$.fragment,s),il=n(s),w=j(s,"P",{"data-svelte-h":!0}),J(w)!=="svelte-4r76fn"&&(w.innerHTML=_e),ol=n(s),f=j(s,"P",{"data-svelte-h":!0}),J(f)!=="svelte-15l1k62"&&(f.innerHTML=Le),Ml=n(s),i(g.$$.fragment,s),rl=n(s),i(d.$$.fragment,s),cl=n(s),i(U.$$.fragment,s),hl=n(s),i(I.$$.fragment,s),jl=n(s),i(b.$$.fragment,s),Jl=n(s),i($.$$.fragment,s),ml=n(s),i(C.$$.fragment,s),yl=n(s),i(B.$$.fragment,s),ul=n(s),x=j(s,"P",{"data-svelte-h":!0}),J(x)!=="svelte-ys53zo"&&(x.innerHTML=De),Tl=n(s),k=j(s,"P",{"data-svelte-h":!0}),J(k)!=="svelte-2l8ybr"&&(k.textContent=Pe),wl=n(s),i(Z.$$.fragment,s),fl=n(s),Q=j(s,"P",{"data-svelte-h":!0}),J(Q)!=="svelte-jymwke"&&(Q.textContent=Ke),gl=n(s),G=j(s,"P",{"data-svelte-h":!0}),J(G)!=="svelte-10x65ih"&&(G.textContent=Oe),dl=n(s),N=j(s,"UL",{"data-svelte-h":!0}),J(N)!=="svelte-th6b6q"&&(N.innerHTML=sn),Ul=n(s),E=j(s,"P",{"data-svelte-h":!0}),J(E)!=="svelte-10p6n92"&&(E.innerHTML=tn),Il=n(s),i(v.$$.fragment,s),bl=n(s),W=j(s,"P",{"data-svelte-h":!0}),J(W)!=="svelte-chybr3"&&(W.innerHTML=ln),$l=n(s),A=j(s,"P",{"data-svelte-h":!0}),J(A)!=="svelte-1q5o8lp"&&(A.textContent=an),Cl=n(s),Y=j(s,"UL",{"data-svelte-h":!0}),J(Y)!=="svelte-1n0tk8"&&(Y.innerHTML=en),Bl=n(s),X=j(s,"P",{"data-svelte-h":!0}),J(X)!=="svelte-w24fai"&&(X.innerHTML=nn),xl=n(s),S=j(s,"P",{"data-svelte-h":!0}),J(S)!=="svelte-anhj2e"&&(S.innerHTML=pn),kl=n(s),i(V.$$.fragment,s),Zl=n(s),R=j(s,"P",{"data-svelte-h":!0}),J(R)!=="svelte-62skcu"&&(R.innerHTML=on),Ql=n(s),i(q.$$.fragment,s),Gl=n(s),z=j(s,"P",{"data-svelte-h":!0}),J(z)!=="svelte-88xj6h"&&(z.textContent=Mn),Nl=n(s),i(H.$$.fragment,s),El=n(s),i(F.$$.fragment,s),vl=n(s),_=j(s,"P",{"data-svelte-h":!0}),J(_)!=="svelte-18cimv4"&&(_.textContent=rn),Wl=n(s),L=j(s,"P",{"data-svelte-h":!0}),J(L)!=="svelte-kjz90x"&&(L.innerHTML=cn),Al=n(s),i(D.$$.fragment,s),Yl=n(s),i(P.$$.fragment,s),Xl=n(s),K=j(s,"P",{"data-svelte-h":!0}),J(K)!=="svelte-1jovdfa"&&(K.innerHTML=hn),Sl=n(s),O=j(s,"P",{"data-svelte-h":!0}),J(O)!=="svelte-slg7wg"&&(O.innerHTML=jn),Vl=n(s),i(ss.$$.fragment,s),Rl=n(s),ts=j(s,"P",{"data-svelte-h":!0}),J(ts)!=="svelte-1daohkt"&&(ts.textContent=Jn),ql=n(s),i(ls.$$.fragment,s),zl=n(s),i(as.$$.fragment,s),Hl=n(s),es=j(s,"P",{"data-svelte-h":!0}),J(es)!=="svelte-1mnrr3b"&&(es.textContent=mn),Fl=n(s),i(ns.$$.fragment,s),_l=n(s),i(ps.$$.fragment,s),Ll=n(s),is=j(s,"P",{"data-svelte-h":!0}),J(is)!=="svelte-4s1xv3"&&(is.textContent=yn),Dl=n(s),i(os.$$.fragment,s),Pl=n(s),i(Ms.$$.fragment,s),Kl=n(s),rs=j(s,"P",{"data-svelte-h":!0}),J(rs)!=="svelte-vnhv92"&&(rs.textContent=un),Ol=n(s),i(cs.$$.fragment,s),sa=n(s),i(hs.$$.fragment,s),ta=n(s),i(js.$$.fragment,s),la=n(s),i(Js.$$.fragment,s),aa=n(s),ms=j(s,"P",{"data-svelte-h":!0}),J(ms)!=="svelte-vlz10z"&&(ms.textContent=Tn),ea=n(s),i(ys.$$.fragment,s),na=n(s),i(us.$$.fragment,s),pa=n(s),Ts=j(s,"P",{"data-svelte-h":!0}),J(Ts)!=="svelte-qln4hq"&&(Ts.textContent=wn),ia=n(s),i(ws.$$.fragment,s),oa=n(s),i(fs.$$.fragment,s),Ma=n(s),gs=j(s,"P",{"data-svelte-h":!0}),J(gs)!=="svelte-yinzpl"&&(gs.textContent=fn),ra=n(s),i(ds.$$.fragment,s),ca=n(s),i(Us.$$.fragment,s),ha=n(s),Is=j(s,"P",{"data-svelte-h":!0}),J(Is)!=="svelte-mqluby"&&(Is.textContent=gn),ja=n(s),i(bs.$$.fragment,s),Ja=n(s),i($s.$$.fragment,s),ma=n(s),Cs=j(s,"P",{"data-svelte-h":!0}),J(Cs)!=="svelte-1wq8md5"&&(Cs.textContent=dn),ya=n(s),i(Bs.$$.fragment,s),ua=n(s),i(xs.$$.fragment,s),Ta=n(s),ks=j(s,"P",{"data-svelte-h":!0}),J(ks)!=="svelte-tf7teq"&&(ks.textContent=Un),wa=n(s),i(Zs.$$.fragment,s),fa=n(s),i(Qs.$$.fragment,s),ga=n(s),i(Gs.$$.fragment,s),da=n(s),Ns=j(s,"P",{"data-svelte-h":!0}),J(Ns)!=="svelte-1in7idl"&&(Ns.textContent=In),Ua=n(s),Es=j(s,"P",{"data-svelte-h":!0}),J(Es)!=="svelte-18afluh"&&(Es.innerHTML=bn),Ia=n(s),i(vs.$$.fragment,s),ba=n(s),i(Ws.$$.fragment,s),$a=n(s),As=j(s,"P",{"data-svelte-h":!0}),J(As)!=="svelte-12s1din"&&(As.textContent=$n),Ca=n(s),Ys=j(s,"P",{"data-svelte-h":!0}),J(Ys)!=="svelte-1jpdfy8"&&(Ys.innerHTML=Cn),Ba=n(s),i(Xs.$$.fragment,s),xa=n(s),i(Ss.$$.fragment,s),ka=n(s),Vs=j(s,"P",{"data-svelte-h":!0}),J(Vs)!=="svelte-1h8ubig"&&(Vs.textContent=Bn),Za=n(s),Rs=j(s,"P",{"data-svelte-h":!0}),J(Rs)!=="svelte-1edrfzt"&&(Rs.innerHTML=xn),Qa=n(s),i(qs.$$.fragment,s),Ga=n(s),i(zs.$$.fragment,s),Na=n(s),Hs=j(s,"P",{"data-svelte-h":!0}),J(Hs)!=="svelte-zj5o06"&&(Hs.textContent=kn),Ea=n(s),i(Fs.$$.fragment,s),va=n(s),i(_s.$$.fragment,s),Wa=n(s),i(Ls.$$.fragment,s),Aa=n(s),Ds=j(s,"P",{"data-svelte-h":!0}),J(Ds)!=="svelte-1nlp89w"&&(Ds.textContent=Zn),Ya=n(s),Ps=j(s,"P",{"data-svelte-h":!0}),J(Ps)!=="svelte-10vvvxx"&&(Ps.innerHTML=Qn),Xa=n(s),i(Ks.$$.fragment,s),Sa=n(s),i(Os.$$.fragment,s),Va=n(s),st=j(s,"P",{"data-svelte-h":!0}),J(st)!=="svelte-d15mev"&&(st.textContent=Gn),Ra=n(s),tt=j(s,"P",{"data-svelte-h":!0}),J(tt)!=="svelte-pxrbuw"&&(tt.innerHTML=Nn),qa=n(s),i(lt.$$.fragment,s),za=n(s),i(at.$$.fragment,s),Ha=n(s),et=j(s,"P",{"data-svelte-h":!0}),J(et)!=="svelte-1oenl8f"&&(et.textContent=En),Fa=n(s),i(nt.$$.fragment,s),_a=n(s),i(pt.$$.fragment,s),La=n(s),it=j(s,"P",{"data-svelte-h":!0}),J(it)!=="svelte-66badz"&&(it.textContent=vn),Da=n(s),i(ot.$$.fragment,s),Pa=n(s),i(Mt.$$.fragment,s),Ka=n(s),rt=j(s,"P",{"data-svelte-h":!0}),J(rt)!=="svelte-13iv3hh"&&(rt.textContent=Wn),Oa=n(s),ct=j(s,"P",{"data-svelte-h":!0}),J(ct)!=="svelte-1mgyz4r"&&(ct.innerHTML=An),se=n(s),i(ht.$$.fragment,s),te=n(s),i(jt.$$.fragment,s),le=n(s),Jt=j(s,"P",{"data-svelte-h":!0}),J(Jt)!=="svelte-1y7kqaa"&&(Jt.textContent=Yn),ae=n(s),mt=j(s,"P",{"data-svelte-h":!0}),J(mt)!=="svelte-m8xmew"&&(mt.innerHTML=Xn),ee=n(s),i(yt.$$.fragment,s),ne=n(s),i(ut.$$.fragment,s),pe=n(s),Tt=j(s,"P",{"data-svelte-h":!0}),J(Tt)!=="svelte-m7q2yg"&&(Tt.textContent=Sn),ie=n(s),i(wt.$$.fragment,s),oe=n(s),i(ft.$$.fragment,s),Me=n(s),i(gt.$$.fragment,s),re=n(s),dt=j(s,"P",{"data-svelte-h":!0}),J(dt)!=="svelte-174b8m1"&&(dt.textContent=Vn),ce=n(s),i(Ut.$$.fragment,s),he=n(s),i(It.$$.fragment,s),je=n(s),bt=j(s,"P",{"data-svelte-h":!0}),J(bt)!=="svelte-cnruui"&&(bt.textContent=Rn),Je=n(s),$t=j(s,"P",{"data-svelte-h":!0}),J($t)!=="svelte-hwgezm"&&($t.innerHTML=qn),me=n(s),i(Ct.$$.fragment,s),ye=n(s),i(Bt.$$.fragment,s),ue=n(s),xt=j(s,"P",{"data-svelte-h":!0}),J(xt)!=="svelte-1tpexz3"&&(xt.textContent=zn),Te=n(s),kt=j(s,"P",{"data-svelte-h":!0}),J(kt)!=="svelte-hwgezm"&&(kt.innerHTML=Hn),we=n(s),i(Zt.$$.fragment,s),fe=n(s),i(Qt.$$.fragment,s),ge=n(s),i(Gt.$$.fragment,s),de=n(s),Nt=j(s,"P",{"data-svelte-h":!0}),J(Nt)!=="svelte-1js246c"&&(Nt.textContent=Fn),Ue=n(s),i(Et.$$.fragment,s),Ie=n(s),i(vt.$$.fragment,s),be=n(s),Wt=j(s,"P",{"data-svelte-h":!0}),J(Wt)!=="svelte-7l7zu1"&&(Wt.textContent=_n),$e=n(s),i(At.$$.fragment,s),Ce=n(s),i(Yt.$$.fragment,s),Be=n(s),Xt=j(s,"P",{"data-svelte-h":!0}),J(Xt)!=="svelte-1uv5lul"&&(Xt.textContent=Ln),xe=n(s),i(St.$$.fragment,s),ke=n(s),Vt=j(s,"P",{"data-svelte-h":!0}),J(Vt)!=="svelte-cw0lq3"&&(Vt.innerHTML=Dn),Ze=n(s),i(Rt.$$.fragment,s),Qe=n(s),i(qt.$$.fragment,s),Ge=n(s),zt=j(s,"P",{"data-svelte-h":!0}),J(zt)!=="svelte-14q869u"&&(zt.innerHTML=Pn),Ne=n(s),i(Ht.$$.fragment,s),Ee=n(s),Ft=j(s,"P",{"data-svelte-h":!0}),J(Ft)!=="svelte-16znzc1"&&(Ft.innerHTML=Kn),ve=n(s),i(_t.$$.fragment,s),We=n(s),i(Lt.$$.fragment,s),Ae=n(s),i(Dt.$$.fragment,s),Ye=n(s),i(Pt.$$.fragment,s),Xe=n(s),Kt=j(s,"P",{"data-svelte-h":!0}),J(Kt)!=="svelte-62a9et"&&(Kt.innerHTML=On),Se=n(s),Ot=j(s,"P",{"data-svelte-h":!0}),J(Ot)!=="svelte-1yyf4wc"&&(Ot.textContent=sp),Ve=n(s),i(sl.$$.fragment,s),Re=n(s),tl=j(s,"UL",{"data-svelte-h":!0}),J(tl)!=="svelte-mopwlb"&&(tl.innerHTML=tp),qe=n(s),i(ll.$$.fragment,s),ze=n(s),el=j(s,"P",{}),lp(el).forEach(l),this.h()},h(){ap(u,"name","hf:doc:metadata"),ap(u,"content",jp)},m(s,t){rp(document.head,u),a(s,nl,t),a(s,al,t),a(s,pl,t),o(T,s,t),a(s,il,t),a(s,w,t),a(s,ol,t),a(s,f,t),a(s,Ml,t),o(g,s,t),a(s,rl,t),o(d,s,t),a(s,cl,t),o(U,s,t),a(s,hl,t),o(I,s,t),a(s,jl,t),o(b,s,t),a(s,Jl,t),o($,s,t),a(s,ml,t),o(C,s,t),a(s,yl,t),o(B,s,t),a(s,ul,t),a(s,x,t),a(s,Tl,t),a(s,k,t),a(s,wl,t),o(Z,s,t),a(s,fl,t),a(s,Q,t),a(s,gl,t),a(s,G,t),a(s,dl,t),a(s,N,t),a(s,Ul,t),a(s,E,t),a(s,Il,t),o(v,s,t),a(s,bl,t),a(s,W,t),a(s,$l,t),a(s,A,t),a(s,Cl,t),a(s,Y,t),a(s,Bl,t),a(s,X,t),a(s,xl,t),a(s,S,t),a(s,kl,t),o(V,s,t),a(s,Zl,t),a(s,R,t),a(s,Ql,t),o(q,s,t),a(s,Gl,t),a(s,z,t),a(s,Nl,t),o(H,s,t),a(s,El,t),o(F,s,t),a(s,vl,t),a(s,_,t),a(s,Wl,t),a(s,L,t),a(s,Al,t),o(D,s,t),a(s,Yl,t),o(P,s,t),a(s,Xl,t),a(s,K,t),a(s,Sl,t),a(s,O,t),a(s,Vl,t),o(ss,s,t),a(s,Rl,t),a(s,ts,t),a(s,ql,t),o(ls,s,t),a(s,zl,t),o(as,s,t),a(s,Hl,t),a(s,es,t),a(s,Fl,t),o(ns,s,t),a(s,_l,t),o(ps,s,t),a(s,Ll,t),a(s,is,t),a(s,Dl,t),o(os,s,t),a(s,Pl,t),o(Ms,s,t),a(s,Kl,t),a(s,rs,t),a(s,Ol,t),o(cs,s,t),a(s,sa,t),o(hs,s,t),a(s,ta,t),o(js,s,t),a(s,la,t),o(Js,s,t),a(s,aa,t),a(s,ms,t),a(s,ea,t),o(ys,s,t),a(s,na,t),o(us,s,t),a(s,pa,t),a(s,Ts,t),a(s,ia,t),o(ws,s,t),a(s,oa,t),o(fs,s,t),a(s,Ma,t),a(s,gs,t),a(s,ra,t),o(ds,s,t),a(s,ca,t),o(Us,s,t),a(s,ha,t),a(s,Is,t),a(s,ja,t),o(bs,s,t),a(s,Ja,t),o($s,s,t),a(s,ma,t),a(s,Cs,t),a(s,ya,t),o(Bs,s,t),a(s,ua,t),o(xs,s,t),a(s,Ta,t),a(s,ks,t),a(s,wa,t),o(Zs,s,t),a(s,fa,t),o(Qs,s,t),a(s,ga,t),o(Gs,s,t),a(s,da,t),a(s,Ns,t),a(s,Ua,t),a(s,Es,t),a(s,Ia,t),o(vs,s,t),a(s,ba,t),o(Ws,s,t),a(s,$a,t),a(s,As,t),a(s,Ca,t),a(s,Ys,t),a(s,Ba,t),o(Xs,s,t),a(s,xa,t),o(Ss,s,t),a(s,ka,t),a(s,Vs,t),a(s,Za,t),a(s,Rs,t),a(s,Qa,t),o(qs,s,t),a(s,Ga,t),o(zs,s,t),a(s,Na,t),a(s,Hs,t),a(s,Ea,t),o(Fs,s,t),a(s,va,t),o(_s,s,t),a(s,Wa,t),o(Ls,s,t),a(s,Aa,t),a(s,Ds,t),a(s,Ya,t),a(s,Ps,t),a(s,Xa,t),o(Ks,s,t),a(s,Sa,t),o(Os,s,t),a(s,Va,t),a(s,st,t),a(s,Ra,t),a(s,tt,t),a(s,qa,t),o(lt,s,t),a(s,za,t),o(at,s,t),a(s,Ha,t),a(s,et,t),a(s,Fa,t),o(nt,s,t),a(s,_a,t),o(pt,s,t),a(s,La,t),a(s,it,t),a(s,Da,t),o(ot,s,t),a(s,Pa,t),o(Mt,s,t),a(s,Ka,t),a(s,rt,t),a(s,Oa,t),a(s,ct,t),a(s,se,t),o(ht,s,t),a(s,te,t),o(jt,s,t),a(s,le,t),a(s,Jt,t),a(s,ae,t),a(s,mt,t),a(s,ee,t),o(yt,s,t),a(s,ne,t),o(ut,s,t),a(s,pe,t),a(s,Tt,t),a(s,ie,t),o(wt,s,t),a(s,oe,t),o(ft,s,t),a(s,Me,t),o(gt,s,t),a(s,re,t),a(s,dt,t),a(s,ce,t),o(Ut,s,t),a(s,he,t),o(It,s,t),a(s,je,t),a(s,bt,t),a(s,Je,t),a(s,$t,t),a(s,me,t),o(Ct,s,t),a(s,ye,t),o(Bt,s,t),a(s,ue,t),a(s,xt,t),a(s,Te,t),a(s,kt,t),a(s,we,t),o(Zt,s,t),a(s,fe,t),o(Qt,s,t),a(s,ge,t),o(Gt,s,t),a(s,de,t),a(s,Nt,t),a(s,Ue,t),o(Et,s,t),a(s,Ie,t),o(vt,s,t),a(s,be,t),a(s,Wt,t),a(s,$e,t),o(At,s,t),a(s,Ce,t),o(Yt,s,t),a(s,Be,t),a(s,Xt,t),a(s,xe,t),o(St,s,t),a(s,ke,t),a(s,Vt,t),a(s,Ze,t),o(Rt,s,t),a(s,Qe,t),o(qt,s,t),a(s,Ge,t),a(s,zt,t),a(s,Ne,t),o(Ht,s,t),a(s,Ee,t),a(s,Ft,t),a(s,ve,t),o(_t,s,t),a(s,We,t),o(Lt,s,t),a(s,Ae,t),o(Dt,s,t),a(s,Ye,t),o(Pt,s,t),a(s,Xe,t),a(s,Kt,t),a(s,Se,t),a(s,Ot,t),a(s,Ve,t),o(sl,s,t),a(s,Re,t),a(s,tl,t),a(s,qe,t),o(ll,s,t),a(s,ze,t),a(s,el,t),He=!0},p:np,i(s){He||(M(T.$$.fragment,s),M(g.$$.fragment,s),M(d.$$.fragment,s),M(U.$$.fragment,s),M(I.$$.fragment,s),M(b.$$.fragment,s),M($.$$.fragment,s),M(C.$$.fragment,s),M(B.$$.fragment,s),M(Z.$$.fragment,s),M(v.$$.fragment,s),M(V.$$.fragment,s),M(q.$$.fragment,s),M(H.$$.fragment,s),M(F.$$.fragment,s),M(D.$$.fragment,s),M(P.$$.fragment,s),M(ss.$$.fragment,s),M(ls.$$.fragment,s),M(as.$$.fragment,s),M(ns.$$.fragment,s),M(ps.$$.fragment,s),M(os.$$.fragment,s),M(Ms.$$.fragment,s),M(cs.$$.fragment,s),M(hs.$$.fragment,s),M(js.$$.fragment,s),M(Js.$$.fragment,s),M(ys.$$.fragment,s),M(us.$$.fragment,s),M(ws.$$.fragment,s),M(fs.$$.fragment,s),M(ds.$$.fragment,s),M(Us.$$.fragment,s),M(bs.$$.fragment,s),M($s.$$.fragment,s),M(Bs.$$.fragment,s),M(xs.$$.fragment,s),M(Zs.$$.fragment,s),M(Qs.$$.fragment,s),M(Gs.$$.fragment,s),M(vs.$$.fragment,s),M(Ws.$$.fragment,s),M(Xs.$$.fragment,s),M(Ss.$$.fragment,s),M(qs.$$.fragment,s),M(zs.$$.fragment,s),M(Fs.$$.fragment,s),M(_s.$$.fragment,s),M(Ls.$$.fragment,s),M(Ks.$$.fragment,s),M(Os.$$.fragment,s),M(lt.$$.fragment,s),M(at.$$.fragment,s),M(nt.$$.fragment,s),M(pt.$$.fragment,s),M(ot.$$.fragment,s),M(Mt.$$.fragment,s),M(ht.$$.fragment,s),M(jt.$$.fragment,s),M(yt.$$.fragment,s),M(ut.$$.fragment,s),M(wt.$$.fragment,s),M(ft.$$.fragment,s),M(gt.$$.fragment,s),M(Ut.$$.fragment,s),M(It.$$.fragment,s),M(Ct.$$.fragment,s),M(Bt.$$.fragment,s),M(Zt.$$.fragment,s),M(Qt.$$.fragment,s),M(Gt.$$.fragment,s),M(Et.$$.fragment,s),M(vt.$$.fragment,s),M(At.$$.fragment,s),M(Yt.$$.fragment,s),M(St.$$.fragment,s),M(Rt.$$.fragment,s),M(qt.$$.fragment,s),M(Ht.$$.fragment,s),M(_t.$$.fragment,s),M(Lt.$$.fragment,s),M(Dt.$$.fragment,s),M(Pt.$$.fragment,s),M(sl.$$.fragment,s),M(ll.$$.fragment,s),He=!0)},o(s){r(T.$$.fragment,s),r(g.$$.fragment,s),r(d.$$.fragment,s),r(U.$$.fragment,s),r(I.$$.fragment,s),r(b.$$.fragment,s),r($.$$.fragment,s),r(C.$$.fragment,s),r(B.$$.fragment,s),r(Z.$$.fragment,s),r(v.$$.fragment,s),r(V.$$.fragment,s),r(q.$$.fragment,s),r(H.$$.fragment,s),r(F.$$.fragment,s),r(D.$$.fragment,s),r(P.$$.fragment,s),r(ss.$$.fragment,s),r(ls.$$.fragment,s),r(as.$$.fragment,s),r(ns.$$.fragment,s),r(ps.$$.fragment,s),r(os.$$.fragment,s),r(Ms.$$.fragment,s),r(cs.$$.fragment,s),r(hs.$$.fragment,s),r(js.$$.fragment,s),r(Js.$$.fragment,s),r(ys.$$.fragment,s),r(us.$$.fragment,s),r(ws.$$.fragment,s),r(fs.$$.fragment,s),r(ds.$$.fragment,s),r(Us.$$.fragment,s),r(bs.$$.fragment,s),r($s.$$.fragment,s),r(Bs.$$.fragment,s),r(xs.$$.fragment,s),r(Zs.$$.fragment,s),r(Qs.$$.fragment,s),r(Gs.$$.fragment,s),r(vs.$$.fragment,s),r(Ws.$$.fragment,s),r(Xs.$$.fragment,s),r(Ss.$$.fragment,s),r(qs.$$.fragment,s),r(zs.$$.fragment,s),r(Fs.$$.fragment,s),r(_s.$$.fragment,s),r(Ls.$$.fragment,s),r(Ks.$$.fragment,s),r(Os.$$.fragment,s),r(lt.$$.fragment,s),r(at.$$.fragment,s),r(nt.$$.fragment,s),r(pt.$$.fragment,s),r(ot.$$.fragment,s),r(Mt.$$.fragment,s),r(ht.$$.fragment,s),r(jt.$$.fragment,s),r(yt.$$.fragment,s),r(ut.$$.fragment,s),r(wt.$$.fragment,s),r(ft.$$.fragment,s),r(gt.$$.fragment,s),r(Ut.$$.fragment,s),r(It.$$.fragment,s),r(Ct.$$.fragment,s),r(Bt.$$.fragment,s),r(Zt.$$.fragment,s),r(Qt.$$.fragment,s),r(Gt.$$.fragment,s),r(Et.$$.fragment,s),r(vt.$$.fragment,s),r(At.$$.fragment,s),r(Yt.$$.fragment,s),r(St.$$.fragment,s),r(Rt.$$.fragment,s),r(qt.$$.fragment,s),r(Ht.$$.fragment,s),r(_t.$$.fragment,s),r(Lt.$$.fragment,s),r(Dt.$$.fragment,s),r(Pt.$$.fragment,s),r(sl.$$.fragment,s),r(ll.$$.fragment,s),He=!1},d(s){s&&(l(nl),l(al),l(pl),l(il),l(w),l(ol),l(f),l(Ml),l(rl),l(cl),l(hl),l(jl),l(Jl),l(ml),l(yl),l(ul),l(x),l(Tl),l(k),l(wl),l(fl),l(Q),l(gl),l(G),l(dl),l(N),l(Ul),l(E),l(Il),l(bl),l(W),l($l),l(A),l(Cl),l(Y),l(Bl),l(X),l(xl),l(S),l(kl),l(Zl),l(R),l(Ql),l(Gl),l(z),l(Nl),l(El),l(vl),l(_),l(Wl),l(L),l(Al),l(Yl),l(Xl),l(K),l(Sl),l(O),l(Vl),l(Rl),l(ts),l(ql),l(zl),l(Hl),l(es),l(Fl),l(_l),l(Ll),l(is),l(Dl),l(Pl),l(Kl),l(rs),l(Ol),l(sa),l(ta),l(la),l(aa),l(ms),l(ea),l(na),l(pa),l(Ts),l(ia),l(oa),l(Ma),l(gs),l(ra),l(ca),l(ha),l(Is),l(ja),l(Ja),l(ma),l(Cs),l(ya),l(ua),l(Ta),l(ks),l(wa),l(fa),l(ga),l(da),l(Ns),l(Ua),l(Es),l(Ia),l(ba),l($a),l(As),l(Ca),l(Ys),l(Ba),l(xa),l(ka),l(Vs),l(Za),l(Rs),l(Qa),l(Ga),l(Na),l(Hs),l(Ea),l(va),l(Wa),l(Aa),l(Ds),l(Ya),l(Ps),l(Xa),l(Sa),l(Va),l(st),l(Ra),l(tt),l(qa),l(za),l(Ha),l(et),l(Fa),l(_a),l(La),l(it),l(Da),l(Pa),l(Ka),l(rt),l(Oa),l(ct),l(se),l(te),l(le),l(Jt),l(ae),l(mt),l(ee),l(ne),l(pe),l(Tt),l(ie),l(oe),l(Me),l(re),l(dt),l(ce),l(he),l(je),l(bt),l(Je),l($t),l(me),l(ye),l(ue),l(xt),l(Te),l(kt),l(we),l(fe),l(ge),l(de),l(Nt),l(Ue),l(Ie),l(be),l(Wt),l($e),l(Ce),l(Be),l(Xt),l(xe),l(ke),l(Vt),l(Ze),l(Qe),l(Ge),l(zt),l(Ne),l(Ee),l(Ft),l(ve),l(We),l(Ae),l(Ye),l(Xe),l(Kt),l(Se),l(Ot),l(Ve),l(Re),l(tl),l(qe),l(ze),l(el)),l(u),c(T,s),c(g,s),c(d,s),c(U,s),c(I,s),c(b,s),c($,s),c(C,s),c(B,s),c(Z,s),c(v,s),c(V,s),c(q,s),c(H,s),c(F,s),c(D,s),c(P,s),c(ss,s),c(ls,s),c(as,s),c(ns,s),c(ps,s),c(os,s),c(Ms,s),c(cs,s),c(hs,s),c(js,s),c(Js,s),c(ys,s),c(us,s),c(ws,s),c(fs,s),c(ds,s),c(Us,s),c(bs,s),c($s,s),c(Bs,s),c(xs,s),c(Zs,s),c(Qs,s),c(Gs,s),c(vs,s),c(Ws,s),c(Xs,s),c(Ss,s),c(qs,s),c(zs,s),c(Fs,s),c(_s,s),c(Ls,s),c(Ks,s),c(Os,s),c(lt,s),c(at,s),c(nt,s),c(pt,s),c(ot,s),c(Mt,s),c(ht,s),c(jt,s),c(yt,s),c(ut,s),c(wt,s),c(ft,s),c(gt,s),c(Ut,s),c(It,s),c(Ct,s),c(Bt,s),c(Zt,s),c(Qt,s),c(Gt,s),c(Et,s),c(vt,s),c(At,s),c(Yt,s),c(St,s),c(Rt,s),c(qt,s),c(Ht,s),c(_t,s),c(Lt,s),c(Dt,s),c(Pt,s),c(sl,s),c(ll,s)}}}const jp='{"title":"🤗 Hugging Face Inference","local":"-hugging-face-inference","sections":[{"title":"Getting Started","local":"getting-started","sections":[{"title":"Install","local":"install","sections":[{"title":"Node","local":"node","sections":[],"depth":4},{"title":"Deno","local":"deno","sections":[],"depth":4}],"depth":3},{"title":"Initialize","local":"initialize","sections":[],"depth":3},{"title":"Third-party inference providers","local":"third-party-inference-providers","sections":[],"depth":3},{"title":"Tree-shaking","local":"tree-shaking","sections":[],"depth":3}],"depth":2},{"title":"Natural Language Processing","local":"natural-language-processing","sections":[{"title":"Text Generation","local":"text-generation","sections":[],"depth":3},{"title":"Text Generation (Chat Completion API Compatible)","local":"text-generation-chat-completion-api-compatible","sections":[],"depth":3},{"title":"Fill Mask","local":"fill-mask","sections":[],"depth":3},{"title":"Summarization","local":"summarization","sections":[],"depth":3},{"title":"Question Answering","local":"question-answering","sections":[],"depth":3},{"title":"Table Question Answering","local":"table-question-answering","sections":[],"depth":3},{"title":"Text Classification","local":"text-classification","sections":[],"depth":3},{"title":"Token Classification","local":"token-classification","sections":[],"depth":3},{"title":"Translation","local":"translation","sections":[],"depth":3},{"title":"Zero-Shot Classification","local":"zero-shot-classification","sections":[],"depth":3},{"title":"Conversational","local":"conversational","sections":[],"depth":3},{"title":"Sentence Similarity","local":"sentence-similarity","sections":[],"depth":3}],"depth":2},{"title":"Audio","local":"audio","sections":[{"title":"Automatic Speech Recognition","local":"automatic-speech-recognition","sections":[],"depth":3},{"title":"Audio Classification","local":"audio-classification","sections":[],"depth":3},{"title":"Text To Speech","local":"text-to-speech","sections":[],"depth":3},{"title":"Audio To Audio","local":"audio-to-audio","sections":[],"depth":3}],"depth":2},{"title":"Computer Vision","local":"computer-vision","sections":[{"title":"Image Classification","local":"image-classification","sections":[],"depth":3},{"title":"Object Detection","local":"object-detection","sections":[],"depth":3},{"title":"Image Segmentation","local":"image-segmentation","sections":[],"depth":3},{"title":"Image To Text","local":"image-to-text","sections":[],"depth":3},{"title":"Text To Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image To Image","local":"image-to-image","sections":[],"depth":3},{"title":"Zero Shot Image Classification","local":"zero-shot-image-classification","sections":[],"depth":3}],"depth":2},{"title":"Multimodal","local":"multimodal","sections":[{"title":"Feature Extraction","local":"feature-extraction","sections":[],"depth":3},{"title":"Visual Question Answering","local":"visual-question-answering","sections":[],"depth":3},{"title":"Document Question Answering","local":"document-question-answering","sections":[],"depth":3}],"depth":2},{"title":"Tabular","local":"tabular","sections":[{"title":"Tabular Regression","local":"tabular-regression","sections":[],"depth":3},{"title":"Tabular Classification","local":"tabular-classification","sections":[],"depth":3}],"depth":2},{"title":"Custom Calls","local":"custom-calls","sections":[],"depth":2},{"title":"Custom Inference Endpoints","local":"custom-inference-endpoints","sections":[],"depth":2},{"title":"Running tests","local":"running-tests","sections":[],"depth":2},{"title":"Finding appropriate models","local":"finding-appropriate-models","sections":[],"depth":2},{"title":"Dependencies","local":"dependencies","sections":[],"depth":2}],"depth":1}';function Jp(Fe){return pp(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wp extends ip{constructor(u){super(),op(this,u,Jp,hp,ep,{})}}export{wp as component};
