import{s as rt,o as ut,n as Ys}from"../chunks/scheduler.37c15a92.js";import{S as ot,i as Tt,g as U,s as a,r as M,A as ht,h as r,f as n,c as p,j as ct,u as y,x as o,k as Ut,y as wt,a as t,v as j,d as J,t as i,w as c}from"../chunks/index.2bf4358c.js";import{T as Rs}from"../chunks/Tip.363c041f.js";import{Y as xt}from"../chunks/Youtube.1e50a667.js";import{C as T}from"../chunks/CodeBlock.4e987730.js";import{C as Ct}from"../chunks/CourseFloatingBanner.9ff4c771.js";import{H as In,E as gt}from"../chunks/getInferenceSnippets.80a69898.js";function mt(x){let e,h="💡 本节深入介绍了 BPE，甚至展示了一个完整的实现。如果你只想大致了解 tokenization 算法，可以跳到最后。";return{c(){e=U("p"),e.textContent=h},l(u){e=r(u,"P",{"data-svelte-h":!0}),o(e)!=="svelte-1waktky"&&(e.textContent=h)},m(u,w){t(u,e,w)},p:Ys,d(u){u&&n(e)}}}function It(x){let e,h="GPT-2 和 RoBERTa （这两者非常相似）的 tokenizer 有一个巧妙的方法来处理这个问题：他们不把单词看成是用 Unicode 字符编写的，而是用字节编写的。这样，基本词汇表的大小很小（256），但是能包含几乎所有你能想象的字符，而不会最终转换为未知 tokens 这个技巧被称为 <code>字节级（byte-level） BPE</code> 。";return{c(){e=U("p"),e.innerHTML=h},l(u){e=r(u,"P",{"data-svelte-h":!0}),o(e)!=="svelte-ec0vh8"&&(e.innerHTML=h)},m(u,w){t(u,e,w)},p:Ys,d(u){u&&n(e)}}}function ft(x){let e,h="✏️ <strong>现在轮到你了！</strong> 你认为下一个合并规则是什么？";return{c(){e=U("p"),e.innerHTML=h},l(u){e=r(u,"P",{"data-svelte-h":!0}),o(e)!=="svelte-1abbvo6"&&(e.innerHTML=h)},m(u,w){t(u,e,w)},p:Ys,d(u){u&&n(e)}}}function $t(x){let e,h="✏️ <strong>现在轮到你了！</strong> 你认为这个词 <code>&quot;unhug&quot;</code> 将如何被 tokenization？";return{c(){e=U("p"),e.innerHTML=h},l(u){e=r(u,"P",{"data-svelte-h":!0}),o(e)!=="svelte-18fkeee"&&(e.innerHTML=h)},m(u,w){t(u,e,w)},p:Ys,d(u){u&&n(e)}}}function dt(x){let e,h="💡 在同一语料库上使用 <code>train_new_from_iterator()</code> 可能不会产生完全相同的词汇表。这是因为当有多个出现频率最高的对时，我们选择遇到的第一个，而 🤗 Tokenizers 库根据内部 ID 选择第一个。";return{c(){e=U("p"),e.innerHTML=h},l(u){e=r(u,"P",{"data-svelte-h":!0}),o(e)!=="svelte-x4k8ma"&&(e.innerHTML=h)},m(u,w){t(u,e,w)},p:Ys,d(u){u&&n(e)}}}function kt(x){let e,h="⚠️ 如果存在未知字符，我们的实现将抛出错误，因为我们没有做任何处理它们。GPT-2 实际上没有未知 tokens （使用字节级 BPE 时不可能得到未知字符），但这里的代码可能会出现这个错误，因为我们并未在初始词汇中包含所有可能的字节。BPE 的这一部分已超出了本节的范围，因此我们省略了一些细节。";return{c(){e=U("p"),e.textContent=h},l(u){e=r(u,"P",{"data-svelte-h":!0}),o(e)!=="svelte-ezw7bq"&&(e.textContent=h)},m(u,w){t(u,e,w)},p:Ys,d(u){u&&n(e)}}}function qt(x){let e,h,u,w,d,Ks,k,Fs,q,fn="字节对编码（BPE）最初被开发为一种压缩文本的算法，然后在预训练 GPT 模型时被 OpenAI 用于 tokenization。许多 Transformer 模型都使用它，包括 GPT、GPT-2、RoBERTa、BART 和 DeBERTa。",Ls,Q,Os,C,sl,b,ll,A,$n="BPE 训练首先计算语料库中使用的唯一单词集合（在完成标准化和预分词步骤之后），然后取出用来编写这些词的所有符号来构建词汇表。举一个非常简单的例子，假设我们的语料库使用了这五个词：",nl,B,tl,E,dn="基础单词集合将是 <code>[&quot;b&quot;, &quot;g&quot;, &quot;h&quot;, &quot;n&quot;, &quot;p&quot;, &quot;s&quot;, &quot;u&quot;]</code> 。在实际应用中，基本词汇表将至少包含所有 ASCII 字符，可能还包含一些 Unicode 字符。如果你正在 tokenization 不在训练语料库中的字符，则该字符将转换为未知 tokens，这就是为什么许多 NLP 模型在分析带有表情符号的内容的结果非常糟糕的原因之一。",al,g,pl,z,kn="获得这个基础单词集合后，我们通过学习 <code>合并（merges）</code> 来添加新的 tokens 直到达到期望的词汇表大小。合并是将现有词汇表中的两个元素合并为一个新元素的规则。所以，一开始会创建出含有两个字符的 tokens 然后，随着训练的进展，会产生更长的子词。",el,V,qn="在分词器训练期间的任何一步，BPE 算法都会搜索最常见的现有 tokens 对 （在这里，“对”是指一个词中的两个连续 tokens ）。最常见的这一对会被合并，然后我们重复这个过程。",Ml,Z,Qn="回到我们之前的例子，让我们假设单词具有以下频率：",yl,G,jl,S,bn="意思是 <code>&quot;hug&quot;</code> 在语料库中出现了 10 次， <code>&quot;pug&quot;</code> 出现了 5 次， <code>&quot;pun&quot;</code> 出现了 12 次， <code>&quot;bun&quot;</code> 出现了 4 次， <code>&quot;hugs&quot;</code> 出现了 5 次。我们通过将每个单词拆分为字符（形成我们初始词汇表的字符）来开始训练，这样我们就可以将每个单词视为一个 tokens 列表：",Jl,_,il,N,An="然后我们看看相邻的字符对。 <code>(&quot;h&quot;, &quot;u&quot;)</code> 在词 <code>&quot;hug&quot;</code> 和 <code>&quot;hugs&quot;</code> 中出现，所以在语料库中总共出现了 15 次。然而，最常见的对属于 <code>(&quot;u&quot;, &quot;g&quot;)</code> ，它在 <code>&quot;hug&quot;</code> 、 <code>&quot;pug&quot;</code> 和 <code>&quot;hugs&quot;</code> 中出现，总共在词汇表中出现了 20 次。",cl,v,Bn="因此，tokenizer 学习的第一个合并规则是 <code>(&quot;u&quot;, &quot;g&quot;) -&gt; &quot;ug&quot;</code> ，意思就是 <code>&quot;ug&quot;</code> 将被添加到词汇表中，且应在语料库的所有词中合并这一对。在这个阶段结束时，词汇表和语料库看起来像这样：",Ul,D,rl,H,En="现在我们有一些对，继续合并的话会产生一个比两个字符长的 tokens 例如 <code>(&quot;h&quot;, &quot;ug&quot;)</code> ，在语料库中出现 15 次。然而，这个阶段出现频率最高的对是 <code>(&quot;u&quot;, &quot;n&quot;)</code> ，在语料库中出现 16 次，所以学到的第二个合并规则是 <code>(&quot;u&quot;, &quot;n&quot;) -&gt; &quot;un&quot;</code> 。将其添加到词汇表并合并所有现有的这个对，将出现：",ul,X,ol,W,zn="现在最频繁的一对是 <code>(&quot;h&quot;, &quot;ug&quot;)</code> ，所以我们学习了合并规则 <code>(&quot;h&quot;, &quot;ug&quot;) -&gt; &quot;hug&quot;</code> ，这形成了我们第一个三个字母的 tokens 合并后，语料库如下所示：",Tl,R,hl,Y,Vn="我们继续这样合并，直到达到我们所需的词汇量。",wl,m,xl,P,Cl,K,Zn="完成训练之后就可以对新的输入 tokenization 了，从某种意义上说，新的输入会依照以下步骤对新输入进行 tokenization：",gl,F,Gn="<li>标准化</li> <li>预分词</li> <li>将单词拆分为单个字符</li> <li>根据学习的合并规则，按顺序合并拆分的字符</li>",ml,L,Sn="让我们以我们在训练期间使用的示例为例，Tokenizer 学习到了三个合并规则：",Il,O,fl,ss,_n="在这种情况下，单词 <code>&quot;bug&quot;</code> 将被转化为 <code>[&quot;b&quot;, &quot;ug&quot;]</code> 。然而 <code>&quot;mug&quot;</code> ，将被转换为 <code>[&quot;[UNK]&quot;, &quot;ug&quot;]</code> ，因为字母 <code>&quot;m&quot;</code> 不再基本词汇表中。同样，单词 <code>&quot;thug&quot;</code> 会被转换为 <code>[&quot;[UNK]&quot;, &quot;hug&quot;]</code> ：字母 <code>&quot;t&quot;</code> 不在基本词汇表中，使用合并规则首先会将 <code>&quot;u&quot;</code> 和 <code>&quot;g&quot;</code> 合并，然后将 <code>&quot;h&quot;</code> 和 <code>&quot;ug&quot;</code> 合并。",$l,I,dl,ls,kl,ns,Nn="现在，让我们看一下 BPE 算法的实现。这并不是在大型语料库上实际使用的经过优化的版本；我们只是想向你展示代码，以便你可以更好地理解算法",ql,ts,vn="首先，我们需要一个语料库，让我们创建一个含有几句话的简单语料库：",Ql,as,bl,ps,Dn="接下来，我们需要将该语料库预分词为单词。由于我们正在复现一个 BPE  tokenizer （例如 GPT-2），我们将使用 <code>gpt2</code> 分词器进行预分词：",Al,es,Bl,Ms,Hn="然后，我们在进行预分词的同时计算语料库中每个单词的频率：",El,ys,zl,js,Vl,Js,Xn="下一步是计算基础词汇表，这由语料库中使用的所有字符组成：",Zl,is,Gl,cs,Sl,Us,Wn="我们还在该词汇表的开头添加了模型使用的特殊 tokens 对于 GPT-2，唯一的特殊 tokens 是 <code>&quot;&lt;|endoftext|&gt;&quot;</code> ：",_l,rs,Nl,us,Rn="我们现在需要将每个单词拆分为单独的字符，以便能够开始训练：",vl,os,Dl,Ts,Yn="现在我们已准备好进行训练，让我们编写一个函数来计算每对字符的频率。我们需要在训练的每个步骤中使用它：",Hl,hs,Xl,ws,Pn="让我们来看看这个字典在初始合并后的一些结果：",Wl,xs,Rl,Cs,Yl,gs,Kn="现在，只需要一个简单的循环就可以找到出现频率最高的对：",Pl,ms,Kl,Is,Fl,fs,Fn="所以第一个要学习的合并规则是 <code>(&#39;Ġ&#39;, &#39;t&#39;) -&gt; &#39;Ġt&#39;</code> ，我们将 <code>&#39;Ġt&#39;</code> 添加到词汇表：",Ll,$s,Ol,ds,Ln="接下来，我们需要在我们的 <code>splits</code> 字典中进行这个合并。让我们为此编写另一个函数：",sn,ks,ln,qs,On="我们可以观察一下第一次合并的结果：",nn,Qs,tn,bs,an,As,st="现在我们有了我们需要的所有代码，可以循环直到我们学习到我们想要的所有合并。让我们把目标词汇表的大小设定为 50：",pn,Bs,en,Es,lt="最终，我们学习了 19 条合并规则（初始词汇量为 31 —— 字母表中的 30 个字符，加上特殊 token ）：",Mn,zs,yn,Vs,jn,Zs,nt="词汇表由特殊 token 初始字母和所有合并结果组成：",Jn,Gs,cn,Ss,Un,f,rn,_s,tt="为了对新文本进行分词，我们对其进行预分词、拆分，然后使用学到的所有合并规则：",un,Ns,on,vs,at="我们可以尝试在任何由字母表中的字符组成的文本上进行此操作：",Tn,Ds,hn,Hs,wn,$,xn,Xs,pt="至此，BPE 算法的介绍就到此结束！接下来，我们将研究 WordPiece 算法。",Cn,Ws,gn,Ps,mn;return d=new In({props:{title:"BPE tokenization 算法",local:"BPE tokenization算法",headingTag:"h1"}}),k=new Ct({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/zh-CN/chapter6/section5.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/zh-CN/chapter6/section5.ipynb"}]}}),Q=new xt({props:{id:"HEikzVL-lZU"}}),C=new Rs({props:{$$slots:{default:[mt]},$$scope:{ctx:x}}}),b=new In({props:{title:"BPE 训练",local:"BPE 训练",headingTag:"h2"}}),B=new T({props:{code:"JTIyaHVnJTIyJTJDJTIwJTIycHVnJTIyJTJDJTIwJTIycHVuJTIyJTJDJTIwJTIyYnVuJTIyJTJDJTIwJTIyaHVncyUyMg==",highlighted:'<span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-string">&quot;pug&quot;</span>, <span class="hljs-string">&quot;pun&quot;</span>, <span class="hljs-string">&quot;bun&quot;</span>, <span class="hljs-string">&quot;hugs&quot;</span>',wrap:!1}}),g=new Rs({props:{$$slots:{default:[It]},$$scope:{ctx:x}}}),G=new T({props:{code:"KCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwdWclMjIlMkMlMjA1KSUyQyUyMCglMjJwdW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVncyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;hug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;bun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;hugs&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),_=new T({props:{code:"KCUyMmglMjIlMjAlMjJ1JTIyJTIwJTIyZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMmclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMm4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnUlMjIlMjAlMjJuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMnUlMjIlMjAlMjJnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span> <span class="hljs-string">&quot;s&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),D=new T({props:{code:"JUU4JUFGJThEJUU2JUIxJTg3JUU4JUExJUE4JTNBJTIwJTVCJTIyYiUyMiUyQyUyMCUyMmclMjIlMkMlMjAlMjJoJTIyJTJDJTIwJTIybiUyMiUyQyUyMCUyMnAlMjIlMkMlMjAlMjJzJTIyJTJDJTIwJTIydSUyMiUyQyUyMCUyMnVnJTIyJTVEJTBBJUU4JUFGJUFEJUU2JTk2JTk5JUU1JUJBJTkzJTNBJTIwKCUyMmglMjIlMjAlMjJ1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydWclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMm4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnUlMjIlMjAlMjJuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMnVnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:`词汇表: <span class="hljs-selector-attr">[<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>]</span>
语料库: (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),X=new T({props:{code:"JUU4JUFGJThEJUU2JUIxJTg3JUU4JUExJUE4JTNBJTIwJTVCJTIyYiUyMiUyQyUyMCUyMmclMjIlMkMlMjAlMjJoJTIyJTJDJTIwJTIybiUyMiUyQyUyMCUyMnAlMjIlMkMlMjAlMjJzJTIyJTJDJTIwJTIydSUyMiUyQyUyMCUyMnVnJTIyJTJDJTIwJTIydW4lMjIlNUQlMEElRTglQUYlQUQlRTYlOTYlOTklRTUlQkElOTMlM0ElMjAoJTIyaCUyMiUyMCUyMnVnJTIyJTJDJTIwMTApJTJDJTIwKCUyMnAlMjIlMjAlMjJ1ZyUyMiUyQyUyMDUpJTJDJTIwKCUyMnAlMjIlMjAlMjJ1biUyMiUyQyUyMDEyKSUyQyUyMCglMjJiJTIyJTIwJTIydW4lMjIlMkMlMjA0KSUyQyUyMCglMjJoJTIyJTIwJTIydWclMjIlMjAlMjJzJTIyJTJDJTIwNSk=",highlighted:`词汇表: <span class="hljs-selector-attr">[<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-string">&quot;un&quot;</span>]</span>
语料库: (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),R=new T({props:{code:"JUU4JUFGJThEJUU2JUIxJTg3JUU4JUExJUE4JTNBJTIwJTVCJTIyYiUyMiUyQyUyMCUyMmclMjIlMkMlMjAlMjJoJTIyJTJDJTIwJTIybiUyMiUyQyUyMCUyMnAlMjIlMkMlMjAlMjJzJTIyJTJDJTIwJTIydSUyMiUyQyUyMCUyMnVnJTIyJTJDJTIwJTIydW4lMjIlMkMlMjAlMjJodWclMjIlNUQlMEElRTglQUYlQUQlRTYlOTYlOTklRTUlQkElOTMlM0ElMjAoJTIyaHVnJTIyJTJDJTIwMTApJTJDJTIwKCUyMnAlMjIlMjAlMjJ1ZyUyMiUyQyUyMDUpJTJDJTIwKCUyMnAlMjIlMjAlMjJ1biUyMiUyQyUyMDEyKSUyQyUyMCglMjJiJTIyJTIwJTIydW4lMjIlMkMlMjA0KSUyQyUyMCglMjJodWclMjIlMjAlMjJzJTIyJTJDJTIwNSk=",highlighted:`词汇表: <span class="hljs-selector-attr">[<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-string">&quot;hug&quot;</span>]</span>
语料库: (<span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;hug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),m=new Rs({props:{$$slots:{default:[ft]},$$scope:{ctx:x}}}),P=new In({props:{title:"tokenization",local:"tokenization",headingTag:"h2"}}),O=new T({props:{code:"KCUyMnUlMjIlMkMlMjAlMjJnJTIyKSUyMC0lM0UlMjAlMjJ1ZyUyMiUwQSglMjJ1JTIyJTJDJTIwJTIybiUyMiklMjAtJTNFJTIwJTIydW4lMjIlMEEoJTIyaCUyMiUyQyUyMCUyMnVnJTIyKSUyMC0lM0UlMjAlMjJodWclMjI=",highlighted:`<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;ug&quot;</span>
<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;un&quot;</span>
<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;hug&quot;</span>`,wrap:!1}}),I=new Rs({props:{$$slots:{default:[$t]},$$scope:{ctx:x}}}),ls=new In({props:{title:"实现 BPE 算法",local:"实现 BPE 算法",headingTag:"h2"}}),as=new T({props:{code:"Y29ycHVzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGlzJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBDb3Vyc2UuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGNoYXB0ZXIlMjBpcyUyMGFib3V0JTIwdG9rZW5pemF0aW9uLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlRoaXMlMjBzZWN0aW9uJTIwc2hvd3MlMjBzZXZlcmFsJTIwdG9rZW5pemVyJTIwYWxnb3JpdGhtcy4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJIb3BlZnVsbHklMkMlMjB5b3UlMjB3aWxsJTIwYmUlMjBhYmxlJTIwdG8lMjB1bmRlcnN0YW5kJTIwaG93JTIwdGhleSUyMGFyZSUyMHRyYWluZWQlMjBhbmQlMjBnZW5lcmF0ZSUyMHRva2Vucy4lMjIlMkMlMEElNUQ=",highlighted:`corpus = [
    <span class="hljs-string">&quot;This is the Hugging Face Course.&quot;</span>,
    <span class="hljs-string">&quot;This chapter is about tokenization.&quot;</span>,
    <span class="hljs-string">&quot;This section shows several tokenizer algorithms.&quot;</span>,
    <span class="hljs-string">&quot;Hopefully, you will be able to understand how they are trained and generate tokens.&quot;</span>,
]`,wrap:!1}}),es=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)`,wrap:!1}}),ys=new T({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEF3b3JkX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQSUwQWZvciUyMHRleHQlMjBpbiUyMGNvcnB1cyUzQSUwQSUyMCUyMCUyMCUyMHdvcmRzX3dpdGhfb2Zmc2V0cyUyMCUzRCUyMHRva2VuaXplci5iYWNrZW5kX3Rva2VuaXplci5wcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIodGV4dCklMEElMjAlMjAlMjAlMjBuZXdfd29yZHMlMjAlM0QlMjAlNUJ3b3JkJTIwZm9yJTIwd29yZCUyQyUyMG9mZnNldCUyMGluJTIwd29yZHNfd2l0aF9vZmZzZXRzJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwd29yZCUyMGluJTIwbmV3X3dvcmRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd29yZF9mcmVxcyU1QndvcmQlNUQlMjAlMkIlM0QlMjAxJTBBJTBBcHJpbnQod29yZF9mcmVxcyk=",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

word_freqs = defaultdict(<span class="hljs-built_in">int</span>)

<span class="hljs-keyword">for</span> text <span class="hljs-keyword">in</span> corpus:
    words_with_offsets = tokenizer.backend_tokenizer.pre_tokenizer.pre_tokenize_str(text)
    new_words = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> words_with_offsets]
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> new_words:
        word_freqs[word] += <span class="hljs-number">1</span>

<span class="hljs-built_in">print</span>(word_freqs)`,wrap:!1}}),js=new T({props:{code:"ZGVmYXVsdGRpY3QoaW50JTJDJTIwJTdCJ1RoaXMnJTNBJTIwMyUyQyUyMCclQzQlQTBpcyclM0ElMjAyJTJDJTIwJyVDNCVBMHRoZSclM0ElMjAxJTJDJTIwJyVDNCVBMEh1Z2dpbmcnJTNBJTIwMSUyQyUyMCclQzQlQTBGYWNlJyUzQSUyMDElMkMlMjAnJUM0JUEwQ291cnNlJyUzQSUyMDElMkMlMjAnLiclM0ElMjA0JTJDJTIwJyVDNCVBMGNoYXB0ZXInJTNBJTIwMSUyQyUwQSUyMCUyMCUyMCUyMCclQzQlQTBhYm91dCclM0ElMjAxJTJDJTIwJyVDNCVBMHRva2VuaXphdGlvbiclM0ElMjAxJTJDJTIwJyVDNCVBMHNlY3Rpb24nJTNBJTIwMSUyQyUyMCclQzQlQTBzaG93cyclM0ElMjAxJTJDJTIwJyVDNCVBMHNldmVyYWwnJTNBJTIwMSUyQyUyMCclQzQlQTB0b2tlbml6ZXInJTNBJTIwMSUyQyUyMCclQzQlQTBhbGdvcml0aG1zJyUzQSUyMDElMkMlMEElMjAlMjAlMjAlMjAnSG9wZWZ1bGx5JyUzQSUyMDElMkMlMjAnJTJDJyUzQSUyMDElMkMlMjAnJUM0JUEweW91JyUzQSUyMDElMkMlMjAnJUM0JUEwd2lsbCclM0ElMjAxJTJDJTIwJyVDNCVBMGJlJyUzQSUyMDElMkMlMjAnJUM0JUEwYWJsZSclM0ElMjAxJTJDJTIwJyVDNCVBMHRvJyUzQSUyMDElMkMlMjAnJUM0JUEwdW5kZXJzdGFuZCclM0ElMjAxJTJDJTIwJyVDNCVBMGhvdyclM0ElMjAxJTJDJTBBJTIwJTIwJTIwJTIwJyVDNCVBMHRoZXknJTNBJTIwMSUyQyUyMCclQzQlQTBhcmUnJTNBJTIwMSUyQyUyMCclQzQlQTB0cmFpbmVkJyUzQSUyMDElMkMlMjAnJUM0JUEwYW5kJyUzQSUyMDElMkMlMjAnJUM0JUEwZ2VuZXJhdGUnJTNBJTIwMSUyQyUyMCclQzQlQTB0b2tlbnMnJTNBJTIwMSU3RCk=",highlighted:`defaultdict(<span class="hljs-built_in">int</span>, {<span class="hljs-string">&#x27;This&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠHugging&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠFace&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠCourse&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;.&#x27;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&#x27;Ġchapter&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Ġabout&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokenization&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġsection&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġshows&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġseveral&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokenizer&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġalgorithms&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Hopefully&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;,&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġyou&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġwill&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġbe&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġable&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġunderstand&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġhow&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Ġthey&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġare&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtrained&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġand&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġgenerate&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokens&#x27;</span>: <span class="hljs-number">1</span>})`,wrap:!1}}),is=new T({props:{code:"YWxwaGFiZXQlMjAlM0QlMjAlNUIlNUQlMEElMEFmb3IlMjB3b3JkJTIwaW4lMjB3b3JkX2ZyZXFzLmtleXMoKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGxldHRlciUyMGluJTIwd29yZCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGV0dGVyJTIwbm90JTIwaW4lMjBhbHBoYWJldCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFscGhhYmV0LmFwcGVuZChsZXR0ZXIpJTBBYWxwaGFiZXQuc29ydCgpJTBBJTBBcHJpbnQoYWxwaGFiZXQp",highlighted:`alphabet = []

<span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs.keys():
    <span class="hljs-keyword">for</span> letter <span class="hljs-keyword">in</span> word:
        <span class="hljs-keyword">if</span> letter <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> alphabet:
            alphabet.append(letter)
alphabet.sort()

<span class="hljs-built_in">print</span>(alphabet)`,wrap:!1}}),cs=new T({props:{code:"JTVCJTIwJyUyQyclMkMlMjAnLiclMkMlMjAnQyclMkMlMjAnRiclMkMlMjAnSCclMkMlMjAnVCclMkMlMjAnYSclMkMlMjAnYiclMkMlMjAnYyclMkMlMjAnZCclMkMlMjAnZSclMkMlMjAnZiclMkMlMjAnZyclMkMlMjAnaCclMkMlMjAnaSclMkMlMjAnayclMkMlMjAnbCclMkMlMjAnbSclMkMlMjAnbiclMkMlMjAnbyclMkMlMjAncCclMkMlMjAnciclMkMlMjAncyclMkMlMEElMjAlMjAndCclMkMlMjAndSclMkMlMjAndiclMkMlMjAndyclMkMlMjAneSclMkMlMjAneiclMkMlMjAnJUM0JUEwJyU1RA==",highlighted:`[ <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;C&#x27;</span>, <span class="hljs-string">&#x27;F&#x27;</span>, <span class="hljs-string">&#x27;H&#x27;</span>, <span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;f&#x27;</span>, <span class="hljs-string">&#x27;g&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>, <span class="hljs-string">&#x27;l&#x27;</span>, <span class="hljs-string">&#x27;m&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;p&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>,
  <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>, <span class="hljs-string">&#x27;v&#x27;</span>, <span class="hljs-string">&#x27;w&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>, <span class="hljs-string">&#x27;z&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>]`,wrap:!1}}),rs=new T({props:{code:"dm9jYWIlMjAlM0QlMjAlNUIlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlNUQlMjAlMkIlMjBhbHBoYWJldC5jb3B5KCk=",highlighted:'vocab = [<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>] + alphabet.copy()',wrap:!1}}),os=new T({props:{code:"c3BsaXRzJTIwJTNEJTIwJTdCd29yZCUzQSUyMCU1QmMlMjBmb3IlMjBjJTIwaW4lMjB3b3JkJTVEJTIwZm9yJTIwd29yZCUyMGluJTIwd29yZF9mcmVxcy5rZXlzKCklN0Q=",highlighted:'splits = {word: [c <span class="hljs-keyword">for</span> c <span class="hljs-keyword">in</span> word] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs.keys()}',wrap:!1}}),hs=new T({props:{code:"ZGVmJTIwY29tcHV0ZV9wYWlyX2ZyZXFzKHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjBwYWlyX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQSUyMCUyMCUyMCUyMGZvciUyMHdvcmQlMkMlMjBmcmVxJTIwaW4lMjB3b3JkX2ZyZXFzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGxpdCUyMCUzRCUyMHNwbGl0cyU1QndvcmQlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGxlbihzcGxpdCklMjAlM0QlM0QlMjAxJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29udGludWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oc3BsaXQpJTIwLSUyMDEpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFpciUyMCUzRCUyMChzcGxpdCU1QmklNUQlMkMlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhaXJfZnJlcXMlNUJwYWlyJTVEJTIwJTJCJTNEJTIwZnJlcSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHBhaXJfZnJlcXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_pair_freqs</span>(<span class="hljs-params">splits</span>):
    pair_freqs = defaultdict(<span class="hljs-built_in">int</span>)
    <span class="hljs-keyword">for</span> word, freq <span class="hljs-keyword">in</span> word_freqs.items():
        split = splits[word]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(split) == <span class="hljs-number">1</span>:
            <span class="hljs-keyword">continue</span>
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>):
            pair = (split[i], split[i + <span class="hljs-number">1</span>])
            pair_freqs[pair] += freq
    <span class="hljs-keyword">return</span> pair_freqs`,wrap:!1}}),xs=new T({props:{code:"cGFpcl9mcmVxcyUyMCUzRCUyMGNvbXB1dGVfcGFpcl9mcmVxcyhzcGxpdHMpJTBBJTBBZm9yJTIwaSUyQyUyMGtleSUyMGluJTIwZW51bWVyYXRlKHBhaXJfZnJlcXMua2V5cygpKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlN0JrZXklN0QlM0ElMjAlN0JwYWlyX2ZyZXFzJTVCa2V5JTVEJTdEJTIyKSUwQSUyMCUyMCUyMCUyMGlmJTIwaSUyMCUzRSUzRCUyMDUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBicmVhaw==",highlighted:`pair_freqs = compute_pair_freqs(splits)

<span class="hljs-keyword">for</span> i, key <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(pair_freqs.keys()):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{key}</span>: <span class="hljs-subst">{pair_freqs[key]}</span>&quot;</span>)
    <span class="hljs-keyword">if</span> i &gt;= <span class="hljs-number">5</span>:
        <span class="hljs-keyword">break</span>`,wrap:!1}}),Cs=new T({props:{code:"KCdUJyUyQyUyMCdoJyklM0ElMjAzJTBBKCdoJyUyQyUyMCdpJyklM0ElMjAzJTBBKCdpJyUyQyUyMCdzJyklM0ElMjA1JTBBKCclQzQlQTAnJTJDJTIwJ2knKSUzQSUyMDIlMEEoJyVDNCVBMCclMkMlMjAndCcpJTNBJTIwNyUwQSgndCclMkMlMjAnaCcpJTNBJTIwMw==",highlighted:`(<span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-number">3</span>
(<span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-number">3</span>
(<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>): <span class="hljs-number">5</span>
(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-number">2</span>
(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>): <span class="hljs-number">7</span>
(<span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-number">3</span>`,wrap:!1}}),ms=new T({props:{code:"YmVzdF9wYWlyJTIwJTNEJTIwJTIyJTIyJTBBbWF4X2ZyZXElMjAlM0QlMjBOb25lJTBBJTBBZm9yJTIwcGFpciUyQyUyMGZyZXElMjBpbiUyMHBhaXJfZnJlcXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbWF4X2ZyZXElMjBpcyUyME5vbmUlMjBvciUyMG1heF9mcmVxJTIwJTNDJTIwZnJlcSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJlc3RfcGFpciUyMCUzRCUyMHBhaXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfZnJlcSUyMCUzRCUyMGZyZXElMEElMEFwcmludChiZXN0X3BhaXIlMkMlMjBtYXhfZnJlcSk=",highlighted:`best_pair = <span class="hljs-string">&quot;&quot;</span>
max_freq = <span class="hljs-literal">None</span>

<span class="hljs-keyword">for</span> pair, freq <span class="hljs-keyword">in</span> pair_freqs.items():
    <span class="hljs-keyword">if</span> max_freq <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> max_freq &lt; freq:
        best_pair = pair
        max_freq = freq

<span class="hljs-built_in">print</span>(best_pair, max_freq)`,wrap:!1}}),Is=new T({props:{code:"KCclQzQlQTAnJTJDJTIwJ3QnKSUyMDc=",highlighted:'(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>) <span class="hljs-number">7</span>',wrap:!1}}),$s=new T({props:{code:"bWVyZ2VzJTIwJTNEJTIwJTdCKCUyMiVDNCVBMCUyMiUyQyUyMCUyMnQlMjIpJTNBJTIwJTIyJUM0JUEwdCUyMiU3RCUwQXZvY2FiLmFwcGVuZCglMjIlQzQlQTB0JTIyKQ==",highlighted:`merges = {(<span class="hljs-string">&quot;Ġ&quot;</span>, <span class="hljs-string">&quot;t&quot;</span>): <span class="hljs-string">&quot;Ġt&quot;</span>}
vocab.append(<span class="hljs-string">&quot;Ġt&quot;</span>)`,wrap:!1}}),ks=new T({props:{code:"ZGVmJTIwbWVyZ2VfcGFpcihhJTJDJTIwYiUyQyUyMHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjB3b3JkJTIwaW4lMjB3b3JkX2ZyZXFzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BsaXQlMjAlM0QlMjBzcGxpdHMlNUJ3b3JkJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsZW4oc3BsaXQpJTIwJTNEJTNEJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbnRpbnVlJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaSUyMCUzRCUyMDAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aGlsZSUyMGklMjAlM0MlMjBsZW4oc3BsaXQpJTIwLSUyMDElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHNwbGl0JTVCaSU1RCUyMCUzRCUzRCUyMGElMjBhbmQlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEJTIwJTNEJTNEJTIwYiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwbGl0JTIwJTNEJTIwc3BsaXQlNUIlM0FpJTVEJTIwJTJCJTIwJTVCYSUyMCUyQiUyMGIlNUQlMjAlMkIlMjBzcGxpdCU1QmklMjAlMkIlMjAyJTIwJTNBJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGklMjAlMkIlM0QlMjAxJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BsaXRzJTVCd29yZCU1RCUyMCUzRCUyMHNwbGl0JTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3BsaXRz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">merge_pair</span>(<span class="hljs-params">a, b, splits</span>):
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs:
        split = splits[word]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(split) == <span class="hljs-number">1</span>:
            <span class="hljs-keyword">continue</span>

        i = <span class="hljs-number">0</span>
        <span class="hljs-keyword">while</span> i &lt; <span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>:
            <span class="hljs-keyword">if</span> split[i] == a <span class="hljs-keyword">and</span> split[i + <span class="hljs-number">1</span>] == b:
                split = split[:i] + [a + b] + split[i + <span class="hljs-number">2</span> :]
            <span class="hljs-keyword">else</span>:
                i += <span class="hljs-number">1</span>
        splits[word] = split
    <span class="hljs-keyword">return</span> splits`,wrap:!1}}),Qs=new T({props:{code:"c3BsaXRzJTIwJTNEJTIwbWVyZ2VfcGFpciglMjIlQzQlQTAlMjIlMkMlMjAlMjJ0JTIyJTJDJTIwc3BsaXRzKSUwQXByaW50KHNwbGl0cyU1QiUyMiVDNCVBMHRyYWluZWQlMjIlNUQp",highlighted:`splits = merge_pair(<span class="hljs-string">&quot;Ġ&quot;</span>, <span class="hljs-string">&quot;t&quot;</span>, splits)
<span class="hljs-built_in">print</span>(splits[<span class="hljs-string">&quot;Ġtrained&quot;</span>])`,wrap:!1}}),bs=new T({props:{code:"JTVCJyVDNCVBMHQnJTJDJTIwJ3InJTJDJTIwJ2EnJTJDJTIwJ2knJTJDJTIwJ24nJTJDJTIwJ2UnJTJDJTIwJ2QnJTVE",highlighted:'[<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>]',wrap:!1}}),Bs=new T({props:{code:"dm9jYWJfc2l6ZSUyMCUzRCUyMDUwJTBBJTBBd2hpbGUlMjBsZW4odm9jYWIpJTIwJTNDJTIwdm9jYWJfc2l6ZSUzQSUwQSUyMCUyMCUyMCUyMHBhaXJfZnJlcXMlMjAlM0QlMjBjb21wdXRlX3BhaXJfZnJlcXMoc3BsaXRzKSUwQSUyMCUyMCUyMCUyMGJlc3RfcGFpciUyMCUzRCUyMCUyMiUyMiUwQSUyMCUyMCUyMCUyMG1heF9mcmVxJTIwJTNEJTIwTm9uZSUwQSUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMkMlMjBmcmVxJTIwaW4lMjBwYWlyX2ZyZXFzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMG1heF9mcmVxJTIwaXMlMjBOb25lJTIwb3IlMjBtYXhfZnJlcSUyMCUzQyUyMGZyZXElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiZXN0X3BhaXIlMjAlM0QlMjBwYWlyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X2ZyZXElMjAlM0QlMjBmcmVxJTBBJTIwJTIwJTIwJTIwc3BsaXRzJTIwJTNEJTIwbWVyZ2VfcGFpcigqYmVzdF9wYWlyJTJDJTIwc3BsaXRzKSUwQSUyMCUyMCUyMCUyMG1lcmdlcyU1QmJlc3RfcGFpciU1RCUyMCUzRCUyMGJlc3RfcGFpciU1QjAlNUQlMjAlMkIlMjBiZXN0X3BhaXIlNUIxJTVEJTBBJTIwJTIwJTIwJTIwdm9jYWIuYXBwZW5kKGJlc3RfcGFpciU1QjAlNUQlMjAlMkIlMjBiZXN0X3BhaXIlNUIxJTVEKQ==",highlighted:`vocab_size = <span class="hljs-number">50</span>

<span class="hljs-keyword">while</span> <span class="hljs-built_in">len</span>(vocab) &lt; vocab_size:
    pair_freqs = compute_pair_freqs(splits)
    best_pair = <span class="hljs-string">&quot;&quot;</span>
    max_freq = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">for</span> pair, freq <span class="hljs-keyword">in</span> pair_freqs.items():
        <span class="hljs-keyword">if</span> max_freq <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> max_freq &lt; freq:
            best_pair = pair
            max_freq = freq
    splits = merge_pair(*best_pair, splits)
    merges[best_pair] = best_pair[<span class="hljs-number">0</span>] + best_pair[<span class="hljs-number">1</span>]
    vocab.append(best_pair[<span class="hljs-number">0</span>] + best_pair[<span class="hljs-number">1</span>])`,wrap:!1}}),zs=new T({props:{code:"cHJpbnQobWVyZ2VzKQ==",highlighted:'<span class="hljs-built_in">print</span>(merges)',wrap:!1}}),Vs=new T({props:{code:"JTdCKCclQzQlQTAnJTJDJTIwJ3QnKSUzQSUyMCclQzQlQTB0JyUyQyUyMCgnaSclMkMlMjAncycpJTNBJTIwJ2lzJyUyQyUyMCgnZSclMkMlMjAncicpJTNBJTIwJ2VyJyUyQyUyMCgnJUM0JUEwJyUyQyUyMCdhJyklM0ElMjAnJUM0JUEwYSclMkMlMjAoJyVDNCVBMHQnJTJDJTIwJ28nKSUzQSUyMCclQzQlQTB0byclMkMlMjAoJ2UnJTJDJTIwJ24nKSUzQSUyMCdlbiclMkMlMEElMjAoJ1QnJTJDJTIwJ2gnKSUzQSUyMCdUaCclMkMlMjAoJ1RoJyUyQyUyMCdpcycpJTNBJTIwJ1RoaXMnJTJDJTIwKCdvJyUyQyUyMCd1JyklM0ElMjAnb3UnJTJDJTIwKCdzJyUyQyUyMCdlJyklM0ElMjAnc2UnJTJDJTIwKCclQzQlQTB0byclMkMlMjAnaycpJTNBJTIwJyVDNCVBMHRvayclMkMlMEElMjAoJyVDNCVBMHRvayclMkMlMjAnZW4nKSUzQSUyMCclQzQlQTB0b2tlbiclMkMlMjAoJ24nJTJDJTIwJ2QnKSUzQSUyMCduZCclMkMlMjAoJyVDNCVBMCclMkMlMjAnaXMnKSUzQSUyMCclQzQlQTBpcyclMkMlMjAoJyVDNCVBMHQnJTJDJTIwJ2gnKSUzQSUyMCclQzQlQTB0aCclMkMlMjAoJyVDNCVBMHRoJyUyQyUyMCdlJyklM0ElMjAnJUM0JUEwdGhlJyUyQyUwQSUyMCgnaSclMkMlMjAnbicpJTNBJTIwJ2luJyUyQyUyMCgnJUM0JUEwYSclMkMlMjAnYicpJTNBJTIwJyVDNCVBMGFiJyUyQyUyMCgnJUM0JUEwdG9rZW4nJTJDJTIwJ2knKSUzQSUyMCclQzQlQTB0b2tlbmknJTdE",highlighted:`{(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>): <span class="hljs-string">&#x27;Ġt&#x27;</span>, (<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>): <span class="hljs-string">&#x27;is&#x27;</span>, (<span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>): <span class="hljs-string">&#x27;er&#x27;</span>, (<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>): <span class="hljs-string">&#x27;Ġa&#x27;</span>, (<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>): <span class="hljs-string">&#x27;Ġto&#x27;</span>, (<span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>): <span class="hljs-string">&#x27;en&#x27;</span>,
 (<span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-string">&#x27;Th&#x27;</span>, (<span class="hljs-string">&#x27;Th&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>): <span class="hljs-string">&#x27;This&#x27;</span>, (<span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>): <span class="hljs-string">&#x27;ou&#x27;</span>, (<span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>): <span class="hljs-string">&#x27;se&#x27;</span>, (<span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>): <span class="hljs-string">&#x27;Ġtok&#x27;</span>,
 (<span class="hljs-string">&#x27;Ġtok&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>): <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, (<span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>): <span class="hljs-string">&#x27;nd&#x27;</span>, (<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>): <span class="hljs-string">&#x27;Ġis&#x27;</span>, (<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-string">&#x27;Ġth&#x27;</span>, (<span class="hljs-string">&#x27;Ġth&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>): <span class="hljs-string">&#x27;Ġthe&#x27;</span>,
 (<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>): <span class="hljs-string">&#x27;in&#x27;</span>, (<span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>): <span class="hljs-string">&#x27;Ġab&#x27;</span>, (<span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-string">&#x27;Ġtokeni&#x27;</span>}`,wrap:!1}}),Gs=new T({props:{code:"cHJpbnQodm9jYWIp",highlighted:'<span class="hljs-built_in">print</span>(vocab)',wrap:!1}}),Ss=new T({props:{code:"JTVCJyUzQyU3Q2VuZG9mdGV4dCU3QyUzRSclMkMlMjAnJTJDJyUyQyUyMCcuJyUyQyUyMCdDJyUyQyUyMCdGJyUyQyUyMCdIJyUyQyUyMCdUJyUyQyUyMCdhJyUyQyUyMCdiJyUyQyUyMCdjJyUyQyUyMCdkJyUyQyUyMCdlJyUyQyUyMCdmJyUyQyUyMCdnJyUyQyUyMCdoJyUyQyUyMCdpJyUyQyUyMCdrJyUyQyUyMCdsJyUyQyUyMCdtJyUyQyUyMCduJyUyQyUyMCdvJyUyQyUwQSUyMCdwJyUyQyUyMCdyJyUyQyUyMCdzJyUyQyUyMCd0JyUyQyUyMCd1JyUyQyUyMCd2JyUyQyUyMCd3JyUyQyUyMCd5JyUyQyUyMCd6JyUyQyUyMCclQzQlQTAnJTJDJTIwJyVDNCVBMHQnJTJDJTIwJ2lzJyUyQyUyMCdlciclMkMlMjAnJUM0JUEwYSclMkMlMjAnJUM0JUEwdG8nJTJDJTIwJ2VuJyUyQyUyMCdUaCclMkMlMjAnVGhpcyclMkMlMjAnb3UnJTJDJTIwJ3NlJyUyQyUwQSUyMCclQzQlQTB0b2snJTJDJTIwJyVDNCVBMHRva2VuJyUyQyUyMCduZCclMkMlMjAnJUM0JUEwaXMnJTJDJTIwJyVDNCVBMHRoJyUyQyUyMCclQzQlQTB0aGUnJTJDJTIwJ2luJyUyQyUyMCclQzQlQTBhYiclMkMlMjAnJUM0JUEwdG9rZW5pJyU1RA==",highlighted:`[<span class="hljs-string">&#x27;&lt;|endoftext|&gt;&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;C&#x27;</span>, <span class="hljs-string">&#x27;F&#x27;</span>, <span class="hljs-string">&#x27;H&#x27;</span>, <span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;f&#x27;</span>, <span class="hljs-string">&#x27;g&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>, <span class="hljs-string">&#x27;l&#x27;</span>, <span class="hljs-string">&#x27;m&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>,
 <span class="hljs-string">&#x27;p&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>, <span class="hljs-string">&#x27;v&#x27;</span>, <span class="hljs-string">&#x27;w&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>, <span class="hljs-string">&#x27;z&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-string">&#x27;er&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-string">&#x27;Th&#x27;</span>, <span class="hljs-string">&#x27;This&#x27;</span>, <span class="hljs-string">&#x27;ou&#x27;</span>, <span class="hljs-string">&#x27;se&#x27;</span>,
 <span class="hljs-string">&#x27;Ġtok&#x27;</span>, <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;nd&#x27;</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>, <span class="hljs-string">&#x27;Ġth&#x27;</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>, <span class="hljs-string">&#x27;in&#x27;</span>, <span class="hljs-string">&#x27;Ġab&#x27;</span>, <span class="hljs-string">&#x27;Ġtokeni&#x27;</span>]`,wrap:!1}}),f=new Rs({props:{$$slots:{default:[dt]},$$scope:{ctx:x}}}),Ns=new T({props:{code:"ZGVmJTIwdG9rZW5pemUodGV4dCklM0ElMEElMjAlMjAlMjAlMjBwcmVfdG9rZW5pemVfcmVzdWx0JTIwJTNEJTIwdG9rZW5pemVyLl90b2tlbml6ZXIucHJlX3Rva2VuaXplci5wcmVfdG9rZW5pemVfc3RyKHRleHQpJTBBJTIwJTIwJTIwJTIwcHJlX3Rva2VuaXplZF90ZXh0JTIwJTNEJTIwJTVCd29yZCUyMGZvciUyMHdvcmQlMkMlMjBvZmZzZXQlMjBpbiUyMHByZV90b2tlbml6ZV9yZXN1bHQlNUQlMEElMjAlMjAlMjAlMjBzcGxpdHMlMjAlM0QlMjAlNUIlNUJsJTIwZm9yJTIwbCUyMGluJTIwd29yZCU1RCUyMGZvciUyMHdvcmQlMjBpbiUyMHByZV90b2tlbml6ZWRfdGV4dCU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMkMlMjBtZXJnZSUyMGluJTIwbWVyZ2VzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpZHglMkMlMjBzcGxpdCUyMGluJTIwZW51bWVyYXRlKHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpJTIwJTNEJTIwMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdoaWxlJTIwaSUyMCUzQyUyMGxlbihzcGxpdCklMjAtJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwc3BsaXQlNUJpJTVEJTIwJTNEJTNEJTIwcGFpciU1QjAlNUQlMjBhbmQlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEJTIwJTNEJTNEJTIwcGFpciU1QjElNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGxpdCUyMCUzRCUyMHNwbGl0JTVCJTNBaSU1RCUyMCUyQiUyMCU1Qm1lcmdlJTVEJTIwJTJCJTIwc3BsaXQlNUJpJTIwJTJCJTIwMiUyMCUzQSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpJTIwJTJCJTNEJTIwMSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwbGl0cyU1QmlkeCU1RCUyMCUzRCUyMHNwbGl0JTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3VtKHNwbGl0cyUyQyUyMCU1QiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">text</span>):
    pre_tokenize_result = tokenizer._tokenizer.pre_tokenizer.pre_tokenize_str(text)
    pre_tokenized_text = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> pre_tokenize_result]
    splits = [[l <span class="hljs-keyword">for</span> l <span class="hljs-keyword">in</span> word] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> pre_tokenized_text]
    <span class="hljs-keyword">for</span> pair, merge <span class="hljs-keyword">in</span> merges.items():
        <span class="hljs-keyword">for</span> idx, split <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(splits):
            i = <span class="hljs-number">0</span>
            <span class="hljs-keyword">while</span> i &lt; <span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>:
                <span class="hljs-keyword">if</span> split[i] == pair[<span class="hljs-number">0</span>] <span class="hljs-keyword">and</span> split[i + <span class="hljs-number">1</span>] == pair[<span class="hljs-number">1</span>]:
                    split = split[:i] + [merge] + split[i + <span class="hljs-number">2</span> :]
                <span class="hljs-keyword">else</span>:
                    i += <span class="hljs-number">1</span>
            splits[idx] = split

    <span class="hljs-keyword">return</span> <span class="hljs-built_in">sum</span>(splits, [])`,wrap:!1}}),Ds=new T({props:{code:"dG9rZW5pemUoJTIyVGhpcyUyMGlzJTIwbm90JTIwYSUyMHRva2VuLiUyMik=",highlighted:'tokenize(<span class="hljs-string">&quot;This is not a token.&quot;</span>)',wrap:!1}}),Hs=new T({props:{code:"JTVCJ1RoaXMnJTJDJTIwJyVDNCVBMGlzJyUyQyUyMCclQzQlQTAnJTJDJTIwJ24nJTJDJTIwJ28nJTJDJTIwJ3QnJTJDJTIwJyVDNCVBMGEnJTJDJTIwJyVDNCVBMHRva2VuJyUyQyUyMCcuJyU1RA==",highlighted:'[<span class="hljs-string">&#x27;This&#x27;</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),$=new Rs({props:{warning:!0,$$slots:{default:[kt]},$$scope:{ctx:x}}}),Ws=new gt({props:{source:"https://github.com/huggingface/course/blob/main/chapters/zh-CN/chapter6/5.mdx"}}),{c(){e=U("meta"),h=a(),u=U("p"),w=a(),M(d.$$.fragment),Ks=a(),M(k.$$.fragment),Fs=a(),q=U("p"),q.textContent=fn,Ls=a(),M(Q.$$.fragment),Os=a(),M(C.$$.fragment),sl=a(),M(b.$$.fragment),ll=a(),A=U("p"),A.textContent=$n,nl=a(),M(B.$$.fragment),tl=a(),E=U("p"),E.innerHTML=dn,al=a(),M(g.$$.fragment),pl=a(),z=U("p"),z.innerHTML=kn,el=a(),V=U("p"),V.textContent=qn,Ml=a(),Z=U("p"),Z.textContent=Qn,yl=a(),M(G.$$.fragment),jl=a(),S=U("p"),S.innerHTML=bn,Jl=a(),M(_.$$.fragment),il=a(),N=U("p"),N.innerHTML=An,cl=a(),v=U("p"),v.innerHTML=Bn,Ul=a(),M(D.$$.fragment),rl=a(),H=U("p"),H.innerHTML=En,ul=a(),M(X.$$.fragment),ol=a(),W=U("p"),W.innerHTML=zn,Tl=a(),M(R.$$.fragment),hl=a(),Y=U("p"),Y.textContent=Vn,wl=a(),M(m.$$.fragment),xl=a(),M(P.$$.fragment),Cl=a(),K=U("p"),K.textContent=Zn,gl=a(),F=U("ol"),F.innerHTML=Gn,ml=a(),L=U("p"),L.textContent=Sn,Il=a(),M(O.$$.fragment),fl=a(),ss=U("p"),ss.innerHTML=_n,$l=a(),M(I.$$.fragment),dl=a(),M(ls.$$.fragment),kl=a(),ns=U("p"),ns.textContent=Nn,ql=a(),ts=U("p"),ts.textContent=vn,Ql=a(),M(as.$$.fragment),bl=a(),ps=U("p"),ps.innerHTML=Dn,Al=a(),M(es.$$.fragment),Bl=a(),Ms=U("p"),Ms.textContent=Hn,El=a(),M(ys.$$.fragment),zl=a(),M(js.$$.fragment),Vl=a(),Js=U("p"),Js.textContent=Xn,Zl=a(),M(is.$$.fragment),Gl=a(),M(cs.$$.fragment),Sl=a(),Us=U("p"),Us.innerHTML=Wn,_l=a(),M(rs.$$.fragment),Nl=a(),us=U("p"),us.textContent=Rn,vl=a(),M(os.$$.fragment),Dl=a(),Ts=U("p"),Ts.textContent=Yn,Hl=a(),M(hs.$$.fragment),Xl=a(),ws=U("p"),ws.textContent=Pn,Wl=a(),M(xs.$$.fragment),Rl=a(),M(Cs.$$.fragment),Yl=a(),gs=U("p"),gs.textContent=Kn,Pl=a(),M(ms.$$.fragment),Kl=a(),M(Is.$$.fragment),Fl=a(),fs=U("p"),fs.innerHTML=Fn,Ll=a(),M($s.$$.fragment),Ol=a(),ds=U("p"),ds.innerHTML=Ln,sn=a(),M(ks.$$.fragment),ln=a(),qs=U("p"),qs.textContent=On,nn=a(),M(Qs.$$.fragment),tn=a(),M(bs.$$.fragment),an=a(),As=U("p"),As.textContent=st,pn=a(),M(Bs.$$.fragment),en=a(),Es=U("p"),Es.textContent=lt,Mn=a(),M(zs.$$.fragment),yn=a(),M(Vs.$$.fragment),jn=a(),Zs=U("p"),Zs.textContent=nt,Jn=a(),M(Gs.$$.fragment),cn=a(),M(Ss.$$.fragment),Un=a(),M(f.$$.fragment),rn=a(),_s=U("p"),_s.textContent=tt,un=a(),M(Ns.$$.fragment),on=a(),vs=U("p"),vs.textContent=at,Tn=a(),M(Ds.$$.fragment),hn=a(),M(Hs.$$.fragment),wn=a(),M($.$$.fragment),xn=a(),Xs=U("p"),Xs.textContent=pt,Cn=a(),M(Ws.$$.fragment),gn=a(),Ps=U("p"),this.h()},l(s){const l=ht("svelte-u9bgzb",document.head);e=r(l,"META",{name:!0,content:!0}),l.forEach(n),h=p(s),u=r(s,"P",{}),ct(u).forEach(n),w=p(s),y(d.$$.fragment,s),Ks=p(s),y(k.$$.fragment,s),Fs=p(s),q=r(s,"P",{"data-svelte-h":!0}),o(q)!=="svelte-cafj1v"&&(q.textContent=fn),Ls=p(s),y(Q.$$.fragment,s),Os=p(s),y(C.$$.fragment,s),sl=p(s),y(b.$$.fragment,s),ll=p(s),A=r(s,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1xtlx6q"&&(A.textContent=$n),nl=p(s),y(B.$$.fragment,s),tl=p(s),E=r(s,"P",{"data-svelte-h":!0}),o(E)!=="svelte-qrzm6i"&&(E.innerHTML=dn),al=p(s),y(g.$$.fragment,s),pl=p(s),z=r(s,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1pf74eh"&&(z.innerHTML=kn),el=p(s),V=r(s,"P",{"data-svelte-h":!0}),o(V)!=="svelte-fgjr6p"&&(V.textContent=qn),Ml=p(s),Z=r(s,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1kuwrk5"&&(Z.textContent=Qn),yl=p(s),y(G.$$.fragment,s),jl=p(s),S=r(s,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1jexcr3"&&(S.innerHTML=bn),Jl=p(s),y(_.$$.fragment,s),il=p(s),N=r(s,"P",{"data-svelte-h":!0}),o(N)!=="svelte-cu00o7"&&(N.innerHTML=An),cl=p(s),v=r(s,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1pkk3x3"&&(v.innerHTML=Bn),Ul=p(s),y(D.$$.fragment,s),rl=p(s),H=r(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-19iv4fv"&&(H.innerHTML=En),ul=p(s),y(X.$$.fragment,s),ol=p(s),W=r(s,"P",{"data-svelte-h":!0}),o(W)!=="svelte-scrtmz"&&(W.innerHTML=zn),Tl=p(s),y(R.$$.fragment,s),hl=p(s),Y=r(s,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-4ek1mp"&&(Y.textContent=Vn),wl=p(s),y(m.$$.fragment,s),xl=p(s),y(P.$$.fragment,s),Cl=p(s),K=r(s,"P",{"data-svelte-h":!0}),o(K)!=="svelte-vwd30d"&&(K.textContent=Zn),gl=p(s),F=r(s,"OL",{"data-svelte-h":!0}),o(F)!=="svelte-m3fmz7"&&(F.innerHTML=Gn),ml=p(s),L=r(s,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1gfifff"&&(L.textContent=Sn),Il=p(s),y(O.$$.fragment,s),fl=p(s),ss=r(s,"P",{"data-svelte-h":!0}),o(ss)!=="svelte-19k5wls"&&(ss.innerHTML=_n),$l=p(s),y(I.$$.fragment,s),dl=p(s),y(ls.$$.fragment,s),kl=p(s),ns=r(s,"P",{"data-svelte-h":!0}),o(ns)!=="svelte-92kbvp"&&(ns.textContent=Nn),ql=p(s),ts=r(s,"P",{"data-svelte-h":!0}),o(ts)!=="svelte-19oi16y"&&(ts.textContent=vn),Ql=p(s),y(as.$$.fragment,s),bl=p(s),ps=r(s,"P",{"data-svelte-h":!0}),o(ps)!=="svelte-193w4gh"&&(ps.innerHTML=Dn),Al=p(s),y(es.$$.fragment,s),Bl=p(s),Ms=r(s,"P",{"data-svelte-h":!0}),o(Ms)!=="svelte-vwpm4m"&&(Ms.textContent=Hn),El=p(s),y(ys.$$.fragment,s),zl=p(s),y(js.$$.fragment,s),Vl=p(s),Js=r(s,"P",{"data-svelte-h":!0}),o(Js)!=="svelte-1fa8ke2"&&(Js.textContent=Xn),Zl=p(s),y(is.$$.fragment,s),Gl=p(s),y(cs.$$.fragment,s),Sl=p(s),Us=r(s,"P",{"data-svelte-h":!0}),o(Us)!=="svelte-1tg2x2o"&&(Us.innerHTML=Wn),_l=p(s),y(rs.$$.fragment,s),Nl=p(s),us=r(s,"P",{"data-svelte-h":!0}),o(us)!=="svelte-1m50py"&&(us.textContent=Rn),vl=p(s),y(os.$$.fragment,s),Dl=p(s),Ts=r(s,"P",{"data-svelte-h":!0}),o(Ts)!=="svelte-1kbibkn"&&(Ts.textContent=Yn),Hl=p(s),y(hs.$$.fragment,s),Xl=p(s),ws=r(s,"P",{"data-svelte-h":!0}),o(ws)!=="svelte-1ec489l"&&(ws.textContent=Pn),Wl=p(s),y(xs.$$.fragment,s),Rl=p(s),y(Cs.$$.fragment,s),Yl=p(s),gs=r(s,"P",{"data-svelte-h":!0}),o(gs)!=="svelte-11ofgxl"&&(gs.textContent=Kn),Pl=p(s),y(ms.$$.fragment,s),Kl=p(s),y(Is.$$.fragment,s),Fl=p(s),fs=r(s,"P",{"data-svelte-h":!0}),o(fs)!=="svelte-2ohqia"&&(fs.innerHTML=Fn),Ll=p(s),y($s.$$.fragment,s),Ol=p(s),ds=r(s,"P",{"data-svelte-h":!0}),o(ds)!=="svelte-8v6wgo"&&(ds.innerHTML=Ln),sn=p(s),y(ks.$$.fragment,s),ln=p(s),qs=r(s,"P",{"data-svelte-h":!0}),o(qs)!=="svelte-1atajuj"&&(qs.textContent=On),nn=p(s),y(Qs.$$.fragment,s),tn=p(s),y(bs.$$.fragment,s),an=p(s),As=r(s,"P",{"data-svelte-h":!0}),o(As)!=="svelte-wrfq07"&&(As.textContent=st),pn=p(s),y(Bs.$$.fragment,s),en=p(s),Es=r(s,"P",{"data-svelte-h":!0}),o(Es)!=="svelte-12dmu1y"&&(Es.textContent=lt),Mn=p(s),y(zs.$$.fragment,s),yn=p(s),y(Vs.$$.fragment,s),jn=p(s),Zs=r(s,"P",{"data-svelte-h":!0}),o(Zs)!=="svelte-1spn0nn"&&(Zs.textContent=nt),Jn=p(s),y(Gs.$$.fragment,s),cn=p(s),y(Ss.$$.fragment,s),Un=p(s),y(f.$$.fragment,s),rn=p(s),_s=r(s,"P",{"data-svelte-h":!0}),o(_s)!=="svelte-1r7uxle"&&(_s.textContent=tt),un=p(s),y(Ns.$$.fragment,s),on=p(s),vs=r(s,"P",{"data-svelte-h":!0}),o(vs)!=="svelte-18srrkp"&&(vs.textContent=at),Tn=p(s),y(Ds.$$.fragment,s),hn=p(s),y(Hs.$$.fragment,s),wn=p(s),y($.$$.fragment,s),xn=p(s),Xs=r(s,"P",{"data-svelte-h":!0}),o(Xs)!=="svelte-1isqaa6"&&(Xs.textContent=pt),Cn=p(s),y(Ws.$$.fragment,s),gn=p(s),Ps=r(s,"P",{}),ct(Ps).forEach(n),this.h()},h(){Ut(e,"name","hf:doc:metadata"),Ut(e,"content",Qt)},m(s,l){wt(document.head,e),t(s,h,l),t(s,u,l),t(s,w,l),j(d,s,l),t(s,Ks,l),j(k,s,l),t(s,Fs,l),t(s,q,l),t(s,Ls,l),j(Q,s,l),t(s,Os,l),j(C,s,l),t(s,sl,l),j(b,s,l),t(s,ll,l),t(s,A,l),t(s,nl,l),j(B,s,l),t(s,tl,l),t(s,E,l),t(s,al,l),j(g,s,l),t(s,pl,l),t(s,z,l),t(s,el,l),t(s,V,l),t(s,Ml,l),t(s,Z,l),t(s,yl,l),j(G,s,l),t(s,jl,l),t(s,S,l),t(s,Jl,l),j(_,s,l),t(s,il,l),t(s,N,l),t(s,cl,l),t(s,v,l),t(s,Ul,l),j(D,s,l),t(s,rl,l),t(s,H,l),t(s,ul,l),j(X,s,l),t(s,ol,l),t(s,W,l),t(s,Tl,l),j(R,s,l),t(s,hl,l),t(s,Y,l),t(s,wl,l),j(m,s,l),t(s,xl,l),j(P,s,l),t(s,Cl,l),t(s,K,l),t(s,gl,l),t(s,F,l),t(s,ml,l),t(s,L,l),t(s,Il,l),j(O,s,l),t(s,fl,l),t(s,ss,l),t(s,$l,l),j(I,s,l),t(s,dl,l),j(ls,s,l),t(s,kl,l),t(s,ns,l),t(s,ql,l),t(s,ts,l),t(s,Ql,l),j(as,s,l),t(s,bl,l),t(s,ps,l),t(s,Al,l),j(es,s,l),t(s,Bl,l),t(s,Ms,l),t(s,El,l),j(ys,s,l),t(s,zl,l),j(js,s,l),t(s,Vl,l),t(s,Js,l),t(s,Zl,l),j(is,s,l),t(s,Gl,l),j(cs,s,l),t(s,Sl,l),t(s,Us,l),t(s,_l,l),j(rs,s,l),t(s,Nl,l),t(s,us,l),t(s,vl,l),j(os,s,l),t(s,Dl,l),t(s,Ts,l),t(s,Hl,l),j(hs,s,l),t(s,Xl,l),t(s,ws,l),t(s,Wl,l),j(xs,s,l),t(s,Rl,l),j(Cs,s,l),t(s,Yl,l),t(s,gs,l),t(s,Pl,l),j(ms,s,l),t(s,Kl,l),j(Is,s,l),t(s,Fl,l),t(s,fs,l),t(s,Ll,l),j($s,s,l),t(s,Ol,l),t(s,ds,l),t(s,sn,l),j(ks,s,l),t(s,ln,l),t(s,qs,l),t(s,nn,l),j(Qs,s,l),t(s,tn,l),j(bs,s,l),t(s,an,l),t(s,As,l),t(s,pn,l),j(Bs,s,l),t(s,en,l),t(s,Es,l),t(s,Mn,l),j(zs,s,l),t(s,yn,l),j(Vs,s,l),t(s,jn,l),t(s,Zs,l),t(s,Jn,l),j(Gs,s,l),t(s,cn,l),j(Ss,s,l),t(s,Un,l),j(f,s,l),t(s,rn,l),t(s,_s,l),t(s,un,l),j(Ns,s,l),t(s,on,l),t(s,vs,l),t(s,Tn,l),j(Ds,s,l),t(s,hn,l),j(Hs,s,l),t(s,wn,l),j($,s,l),t(s,xn,l),t(s,Xs,l),t(s,Cn,l),j(Ws,s,l),t(s,gn,l),t(s,Ps,l),mn=!0},p(s,[l]){const et={};l&2&&(et.$$scope={dirty:l,ctx:s}),C.$set(et);const Mt={};l&2&&(Mt.$$scope={dirty:l,ctx:s}),g.$set(Mt);const yt={};l&2&&(yt.$$scope={dirty:l,ctx:s}),m.$set(yt);const jt={};l&2&&(jt.$$scope={dirty:l,ctx:s}),I.$set(jt);const Jt={};l&2&&(Jt.$$scope={dirty:l,ctx:s}),f.$set(Jt);const it={};l&2&&(it.$$scope={dirty:l,ctx:s}),$.$set(it)},i(s){mn||(J(d.$$.fragment,s),J(k.$$.fragment,s),J(Q.$$.fragment,s),J(C.$$.fragment,s),J(b.$$.fragment,s),J(B.$$.fragment,s),J(g.$$.fragment,s),J(G.$$.fragment,s),J(_.$$.fragment,s),J(D.$$.fragment,s),J(X.$$.fragment,s),J(R.$$.fragment,s),J(m.$$.fragment,s),J(P.$$.fragment,s),J(O.$$.fragment,s),J(I.$$.fragment,s),J(ls.$$.fragment,s),J(as.$$.fragment,s),J(es.$$.fragment,s),J(ys.$$.fragment,s),J(js.$$.fragment,s),J(is.$$.fragment,s),J(cs.$$.fragment,s),J(rs.$$.fragment,s),J(os.$$.fragment,s),J(hs.$$.fragment,s),J(xs.$$.fragment,s),J(Cs.$$.fragment,s),J(ms.$$.fragment,s),J(Is.$$.fragment,s),J($s.$$.fragment,s),J(ks.$$.fragment,s),J(Qs.$$.fragment,s),J(bs.$$.fragment,s),J(Bs.$$.fragment,s),J(zs.$$.fragment,s),J(Vs.$$.fragment,s),J(Gs.$$.fragment,s),J(Ss.$$.fragment,s),J(f.$$.fragment,s),J(Ns.$$.fragment,s),J(Ds.$$.fragment,s),J(Hs.$$.fragment,s),J($.$$.fragment,s),J(Ws.$$.fragment,s),mn=!0)},o(s){i(d.$$.fragment,s),i(k.$$.fragment,s),i(Q.$$.fragment,s),i(C.$$.fragment,s),i(b.$$.fragment,s),i(B.$$.fragment,s),i(g.$$.fragment,s),i(G.$$.fragment,s),i(_.$$.fragment,s),i(D.$$.fragment,s),i(X.$$.fragment,s),i(R.$$.fragment,s),i(m.$$.fragment,s),i(P.$$.fragment,s),i(O.$$.fragment,s),i(I.$$.fragment,s),i(ls.$$.fragment,s),i(as.$$.fragment,s),i(es.$$.fragment,s),i(ys.$$.fragment,s),i(js.$$.fragment,s),i(is.$$.fragment,s),i(cs.$$.fragment,s),i(rs.$$.fragment,s),i(os.$$.fragment,s),i(hs.$$.fragment,s),i(xs.$$.fragment,s),i(Cs.$$.fragment,s),i(ms.$$.fragment,s),i(Is.$$.fragment,s),i($s.$$.fragment,s),i(ks.$$.fragment,s),i(Qs.$$.fragment,s),i(bs.$$.fragment,s),i(Bs.$$.fragment,s),i(zs.$$.fragment,s),i(Vs.$$.fragment,s),i(Gs.$$.fragment,s),i(Ss.$$.fragment,s),i(f.$$.fragment,s),i(Ns.$$.fragment,s),i(Ds.$$.fragment,s),i(Hs.$$.fragment,s),i($.$$.fragment,s),i(Ws.$$.fragment,s),mn=!1},d(s){s&&(n(h),n(u),n(w),n(Ks),n(Fs),n(q),n(Ls),n(Os),n(sl),n(ll),n(A),n(nl),n(tl),n(E),n(al),n(pl),n(z),n(el),n(V),n(Ml),n(Z),n(yl),n(jl),n(S),n(Jl),n(il),n(N),n(cl),n(v),n(Ul),n(rl),n(H),n(ul),n(ol),n(W),n(Tl),n(hl),n(Y),n(wl),n(xl),n(Cl),n(K),n(gl),n(F),n(ml),n(L),n(Il),n(fl),n(ss),n($l),n(dl),n(kl),n(ns),n(ql),n(ts),n(Ql),n(bl),n(ps),n(Al),n(Bl),n(Ms),n(El),n(zl),n(Vl),n(Js),n(Zl),n(Gl),n(Sl),n(Us),n(_l),n(Nl),n(us),n(vl),n(Dl),n(Ts),n(Hl),n(Xl),n(ws),n(Wl),n(Rl),n(Yl),n(gs),n(Pl),n(Kl),n(Fl),n(fs),n(Ll),n(Ol),n(ds),n(sn),n(ln),n(qs),n(nn),n(tn),n(an),n(As),n(pn),n(en),n(Es),n(Mn),n(yn),n(jn),n(Zs),n(Jn),n(cn),n(Un),n(rn),n(_s),n(un),n(on),n(vs),n(Tn),n(hn),n(wn),n(xn),n(Xs),n(Cn),n(gn),n(Ps)),n(e),c(d,s),c(k,s),c(Q,s),c(C,s),c(b,s),c(B,s),c(g,s),c(G,s),c(_,s),c(D,s),c(X,s),c(R,s),c(m,s),c(P,s),c(O,s),c(I,s),c(ls,s),c(as,s),c(es,s),c(ys,s),c(js,s),c(is,s),c(cs,s),c(rs,s),c(os,s),c(hs,s),c(xs,s),c(Cs,s),c(ms,s),c(Is,s),c($s,s),c(ks,s),c(Qs,s),c(bs,s),c(Bs,s),c(zs,s),c(Vs,s),c(Gs,s),c(Ss,s),c(f,s),c(Ns,s),c(Ds,s),c(Hs,s),c($,s),c(Ws,s)}}}const Qt='{"title":"BPE tokenization 算法","local":"BPE tokenization算法","sections":[{"title":"BPE 训练","local":"BPE 训练","sections":[],"depth":2},{"title":"tokenization","local":"tokenization","sections":[],"depth":2},{"title":"实现 BPE 算法","local":"实现 BPE 算法","sections":[],"depth":2}],"depth":1}';function bt(x){return ut(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class St extends ot{constructor(e){super(),Tt(this,e,bt,qt,rt,{})}}export{St as component};
