import{s as Yi,o as Ki,n as Pi}from"../chunks/scheduler.8c3d61f6.js";import{S as en,i as tn,g as s,s as i,r as m,A as nn,h as r,f as o,c as n,j as x,u,x as f,k as D,y as t,a as c,v as g,d as _,t as h,w as b,m as on,n as sn}from"../chunks/index.da70eac4.js";import{T as Ri}from"../chunks/Tip.1d9b8c37.js";import{D as T}from"../chunks/Docstring.6b390b9a.js";import{C as Qi}from"../chunks/CodeBlock.00a903b3.js";import{E as Hi}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as tt,E as rn}from"../chunks/EditOnGithub.1e64e623.js";function an($){let d,E='You can find additional information about LEDITS++ on the <a href="https://leditsplusplus-project.static.hf.space/index.html" rel="nofollow">project page</a> and try it out in a <a href="https://huggingface.co/spaces/editing-images/leditsplusplus" rel="nofollow">demo</a>.';return{c(){d=s("p"),d.innerHTML=E},l(L){d=r(L,"P",{"data-svelte-h":!0}),f(d)!=="svelte-rdvyhm"&&(d.innerHTML=E)},m(L,w){c(L,d,w)},p:Pi,d(L){L&&o(d)}}}function dn($){let d;return{c(){d=on(`Due to some backward compatability issues with the current diffusers implementation of [DPMSolverMultistepScheduler](/docs/diffusers/pr_10037/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler) this implementation of LEdits++ can no longer guarantee perfect inversion.
This issue is unlikely to have any noticeable effects on applied use-cases. However, we provide an alternative implementation that guarantees perfect inversion in a dedicated [GitHub repo](https://github.com/ml-research/ledits_pp).`)},l(E){d=sn(E,`Due to some backward compatability issues with the current diffusers implementation of [DPMSolverMultistepScheduler](/docs/diffusers/pr_10037/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler) this implementation of LEdits++ can no longer guarantee perfect inversion.
This issue is unlikely to have any noticeable effects on applied use-cases. However, we provide an alternative implementation that guarantees perfect inversion in a dedicated [GitHub repo](https://github.com/ml-research/ledits_pp).`)},m(E,L){c(E,d,L)},d(E){E&&o(d)}}}function ln($){let d,E="Examples:",L,w,S;return w=new Qi({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTEVkaXRzUFBQaXBlbGluZVN0YWJsZURpZmZ1c2lvbiUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcGlwZSUyMCUzRCUyMExFZGl0c1BQUGlwZWxpbmVTdGFibGVEaWZmdXNpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZS5lbmFibGVfdmFlX3RpbGluZygpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ3d3cuYWltbC5pbmZvcm1hdGlrLnR1LWRhcm1zdGFkdC5kZSUyRnBlb3BsZSUyRm1icmFjayUyRmNoZXJyeV9ibG9zc29tLnBuZyUyMiUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShpbWdfdXJsKS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBJTBBXyUyMCUzRCUyMHBpcGUuaW52ZXJ0KGltYWdlJTNEaW1hZ2UlMkMlMjBudW1faW52ZXJzaW9uX3N0ZXBzJTNENTAlMkMlMjBza2lwJTNEMC4xKSUwQSUwQWVkaXRlZF9pbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwZWRpdGluZ19wcm9tcHQlM0QlNUIlMjJjaGVycnklMjBibG9zc29tJTIyJTVEJTJDJTIwZWRpdF9ndWlkYW5jZV9zY2FsZSUzRDEwLjAlMkMlMjBlZGl0X3RocmVzaG9sZCUzRDAuNzUlMEEpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LEditsPPPipelineStableDiffusion
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = LEditsPPPipelineStableDiffusion.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_vae_tiling()
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://www.aiml.informatik.tu-darmstadt.de/people/mbrack/cherry_blossom.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>_ = pipe.invert(image=image, num_inversion_steps=<span class="hljs-number">50</span>, skip=<span class="hljs-number">0.1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>edited_image = pipe(
<span class="hljs-meta">... </span>    editing_prompt=[<span class="hljs-string">&quot;cherry blossom&quot;</span>], edit_guidance_scale=<span class="hljs-number">10.0</span>, edit_threshold=<span class="hljs-number">0.75</span>
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){d=s("p"),d.textContent=E,L=i(),m(w.$$.fragment)},l(p){d=r(p,"P",{"data-svelte-h":!0}),f(d)!=="svelte-kvfsh7"&&(d.textContent=E),L=n(p),u(w.$$.fragment,p)},m(p,k){c(p,d,k),c(p,L,k),g(w,p,k),S=!0},p:Pi,i(p){S||(_(w.$$.fragment,p),S=!0)},o(p){h(w.$$.fragment,p),S=!1},d(p){p&&(o(d),o(L)),b(w,p)}}}function pn($){let d,E="Examples:",L,w,S;return w=new Qi({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTEVkaXRzUFBQaXBlbGluZVN0YWJsZURpZmZ1c2lvblhMJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFwaXBlJTIwJTNEJTIwTEVkaXRzUFBQaXBlbGluZVN0YWJsZURpZmZ1c2lvblhMLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLmVuYWJsZV92YWVfdGlsaW5nKCklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnd3dy5haW1sLmluZm9ybWF0aWsudHUtZGFybXN0YWR0LmRlJTJGcGVvcGxlJTJGbWJyYWNrJTJGdGVubmlzLmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShpbWdfdXJsKS5yZXNpemUoKDEwMjQlMkMlMjAxMDI0KSklMEElMEFfJTIwJTNEJTIwcGlwZS5pbnZlcnQoaW1hZ2UlM0RpbWFnZSUyQyUyMG51bV9pbnZlcnNpb25fc3RlcHMlM0Q1MCUyQyUyMHNraXAlM0QwLjIpJTBBJTBBZWRpdGVkX2ltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBlZGl0aW5nX3Byb21wdCUzRCU1QiUyMnRlbm5pcyUyMGJhbGwlMjIlMkMlMjAlMjJ0b21hdG8lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjByZXZlcnNlX2VkaXRpbmdfZGlyZWN0aW9uJTNEJTVCVHJ1ZSUyQyUyMEZhbHNlJTVEJTJDJTBBJTIwJTIwJTIwJTIwZWRpdF9ndWlkYW5jZV9zY2FsZSUzRCU1QjUuMCUyQyUyMDEwLjAlNUQlMkMlMEElMjAlMjAlMjAlMjBlZGl0X3RocmVzaG9sZCUzRCU1QjAuOSUyQyUyMDAuODUlNUQlMkMlMEEpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LEditsPPPipelineStableDiffusionXL
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = LEditsPPPipelineStableDiffusionXL.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_vae_tiling()
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://www.aiml.informatik.tu-darmstadt.de/people/mbrack/tennis.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(img_url).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>_ = pipe.invert(image=image, num_inversion_steps=<span class="hljs-number">50</span>, skip=<span class="hljs-number">0.2</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>edited_image = pipe(
<span class="hljs-meta">... </span>    editing_prompt=[<span class="hljs-string">&quot;tennis ball&quot;</span>, <span class="hljs-string">&quot;tomato&quot;</span>],
<span class="hljs-meta">... </span>    reverse_editing_direction=[<span class="hljs-literal">True</span>, <span class="hljs-literal">False</span>],
<span class="hljs-meta">... </span>    edit_guidance_scale=[<span class="hljs-number">5.0</span>, <span class="hljs-number">10.0</span>],
<span class="hljs-meta">... </span>    edit_threshold=[<span class="hljs-number">0.9</span>, <span class="hljs-number">0.85</span>],
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){d=s("p"),d.textContent=E,L=i(),m(w.$$.fragment)},l(p){d=r(p,"P",{"data-svelte-h":!0}),f(d)!=="svelte-kvfsh7"&&(d.textContent=E),L=n(p),u(w.$$.fragment,p)},m(p,k){c(p,d,k),c(p,L,k),g(w,p,k),S=!0},p:Pi,i(p){S||(_(w.$$.fragment,p),S=!0)},o(p){h(w.$$.fragment,p),S=!1},d(p){p&&(o(d),o(L)),b(w,p)}}}function cn($){let d,E,L,w,S,p,k,vi='LEDITS++ was proposed in <a href="https://huggingface.co/papers/2311.16711" rel="nofollow">LEDITS++: Limitless Image Editing using Text-to-Image Models</a> by Manuel Brack, Felix Friedrich, Katharina Kornmeier, Linoy Tsaban, Patrick Schramowski, Kristian Kersting, Apolinário Passos.',it,K,Li="The abstract from the paper is:",nt,ee,yi='<em>Text-to-image diffusion models have recently received increasing interest for their astonishing ability to produce high-fidelity images from solely text inputs. Subsequent research efforts aim to exploit and apply their capabilities to real image editing. However, existing image-to-image methods are often inefficient, imprecise, and of limited versatility. They either require time-consuming fine-tuning, deviate unnecessarily strongly from the input image, and/or lack support for multiple, simultaneous edits. To address these issues, we introduce LEDITS++, an efficient yet versatile and precise textual image manipulation technique. LEDITS++‘s novel inversion approach requires no tuning nor optimization and produces high-fidelity results with a few diffusion steps. Second, our methodology supports multiple simultaneous edits and is architecture-agnostic. Third, we use a novel implicit masking technique that limits changes to relevant image regions. We propose the novel TEdBench++ benchmark as part of our exhaustive evaluation. Our results demonstrate the capabilities of LEDITS++ and its improvements over previous methods. The project page is available at <a href="https://leditsplusplus-project.static.hf.space" rel="nofollow">https://leditsplusplus-project.static.hf.space</a> .</em>',ot,j,st,U,rt,te,wi="We provide two distinct pipelines based on different pre-trained models.",at,ie,dt,v,ne,It,Se,xi="Pipeline for textual image editing using LEDits++ with Stable Diffusion.",Mt,ke,Di=`This model inherits from <a href="/docs/diffusers/pr_10037/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> and builds on the <a href="/docs/diffusers/pr_10037/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>. Check the superclass
documentation for the generic methods implemented for all pipelines (downloading, saving, running on a particular
device, etc.).`,Ct,I,oe,Nt,$e,Ei=`The call function to the pipeline for editing. The
<a href="/docs/diffusers/pr_10037/en/api/pipelines/ledits_pp#diffusers.LEditsPPPipelineStableDiffusion.invert">invert()</a> method has to be called beforehand. Edits will
always be performed for the last inverted image(s).`,Xt,z,jt,J,se,Ut,Ie,Ti=`The function to the pipeline for image inversion as described by the <a href="https://arxiv.org/abs/2301.12247" rel="nofollow">LEDITS++
Paper</a>. If the scheduler is set to <a href="/docs/diffusers/pr_10037/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a> the
inversion proposed by <a href="https://arxiv.org/abs/2304.06140" rel="nofollow">edit-friendly DPDM</a> will be performed instead.`,zt,W,re,Jt,Me,Si=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Wt,A,ae,At,Ce,ki=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Zt,Z,de,Ot,Ne,$i=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Gt,O,le,Vt,Xe,Ii=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Bt,G,pe,Ft,je,Mi="Encodes the prompt into text encoder hidden states.",lt,ce,pt,l,fe,qt,Ue,Ci="Pipeline for textual image editing using LEDits++ with Stable Diffusion XL.",Rt,ze,Ni=`This model inherits from <a href="/docs/diffusers/pr_10037/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> and builds on the <a href="/docs/diffusers/pr_10037/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a>. Check the
superclass documentation for the generic methods implemented for all pipelines (downloading, saving, running on a
particular device, etc.).`,Ht,Je,Xi="In addition the pipeline inherits the following loading methods:",Qt,We,ji='<li><em>LoRA</em>: <a href="/docs/diffusers/pr_10037/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights">LEditsPPPipelineStableDiffusionXL.load_lora_weights()</a></li> <li><em>Ckpt</em>: <a href="/docs/diffusers/pr_10037/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">loaders.FromSingleFileMixin.from_single_file()</a></li>',Yt,Ae,Ui="as well as the following saving methods:",Kt,Ze,zi="<li><em>LoRA</em>: <code>loaders.StableDiffusionXLPipeline.save_lora_weights</code></li>",ei,M,me,ti,Oe,Ji=`The call function to the pipeline for editing. The
<a href="/docs/diffusers/pr_10037/en/api/pipelines/ledits_pp#diffusers.LEditsPPPipelineStableDiffusionXL.invert">invert()</a> method has to be called beforehand. Edits
will always be performed for the last inverted image(s).`,ii,V,ni,B,ue,oi,Ge,Wi=`The function to the pipeline for image inversion as described by the <a href="https://arxiv.org/abs/2301.12247" rel="nofollow">LEDITS++
Paper</a>. If the scheduler is set to <a href="/docs/diffusers/pr_10037/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a> the
inversion proposed by <a href="https://arxiv.org/abs/2304.06140" rel="nofollow">edit-friendly DPDM</a> will be performed instead.`,si,F,ge,ri,Ve,Ai=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,ai,q,_e,di,Be,Zi=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,li,R,he,pi,Fe,Oi=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,ci,H,be,fi,qe,Gi=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,mi,Q,Pe,ui,Re,Vi="Encodes the prompt into text encoder hidden states.",gi,Y,ve,_i,He,Bi='See <a href="https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298" rel="nofollow">https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298</a>',ct,Le,ft,C,ye,hi,Qe,Fi="Output class for LEdits++ Diffusion pipelines.",mt,we,ut,N,xe,bi,Ye,qi="Output class for LEdits++ Diffusion pipelines.",gt,De,_t,et,ht;return S=new tt({props:{title:"LEDITS++",local:"ledits",headingTag:"h1"}}),j=new Ri({props:{$$slots:{default:[an]},$$scope:{ctx:$}}}),U=new Ri({props:{warning:!0,$$slots:{default:[dn]},$$scope:{ctx:$}}}),ie=new tt({props:{title:"LEditsPPPipelineStableDiffusion",local:"diffusers.LEditsPPPipelineStableDiffusion",headingTag:"h2"}}),ne=new T({props:{name:"class diffusers.LEditsPPPipelineStableDiffusion",anchor:"diffusers.LEditsPPPipelineStableDiffusion",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_dpmsolver_multistep.DPMSolverMultistepScheduler]"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.LEditsPPPipelineStableDiffusion.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_10037/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder. Stable Diffusion uses the text portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.unet",description:'<strong>unet</strong> (<a href="/docs/diffusers/pr_10037/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014; Conditional U-Net architecture to denoise the encoded image latents.',name:"unet"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_10037/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a> or <a href="/docs/diffusers/pr_10037/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latens. Can be one of
<a href="/docs/diffusers/pr_10037/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a> or <a href="/docs/diffusers/pr_10037/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>. If any other scheduler is passed it will
automatically be set to <a href="/docs/diffusers/pr_10037/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please, refer to the <a href="https://huggingface.co/CompVis/stable-diffusion-v1-4" rel="nofollow">model card</a> for details.`,name:"safety_checker"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
Model that extracts features from generated images to be used as inputs for the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion.py#L269"}}),oe=new T({props:{name:"__call__",anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__",parameters:[{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"editing_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"editing_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"reverse_editing_direction",val:": typing.Union[bool, typing.List[bool], NoneType] = False"},{name:"edit_guidance_scale",val:": typing.Union[float, typing.List[float], NoneType] = 5"},{name:"edit_warmup_steps",val:": typing.Union[int, typing.List[int], NoneType] = 0"},{name:"edit_cooldown_steps",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"edit_threshold",val:": typing.Union[float, typing.List[float], NoneType] = 0.9"},{name:"user_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"sem_guidance",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"use_cross_attn_mask",val:": bool = False"},{name:"use_intersect_mask",val:": bool = True"},{name:"attn_store_steps",val:": typing.Optional[typing.List[int]] = []"},{name:"store_averaged_over_steps",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/pr_10037/en/api/pipelines/ledits_pp#diffusers.pipelines.LEditsPPDiffusionPipelineOutput">LEditsPPDiffusionPipelineOutput</a> instead of a plain
tuple.`,name:"return_dict"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.editing_prompt",description:`<strong>editing_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. The image is reconstructed by setting
<code>editing_prompt = None</code>. Guidance direction of prompt should be specified via
<code>reverse_editing_direction</code>.`,name:"editing_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.editing_prompt_embeds",description:`<strong>editing_prompt_embeds</strong> (<code>torch.Tensor&gt;</code>, <em>optional</em>) &#x2014;
Pre-computed embeddings to use for guiding the image generation. Guidance direction of embedding should
be specified via <code>reverse_editing_direction</code>.`,name:"editing_prompt_embeds"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.reverse_editing_direction",description:`<strong>reverse_editing_direction</strong> (<code>bool</code> or <code>List[bool]</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the corresponding prompt in <code>editing_prompt</code> should be increased or decreased.`,name:"reverse_editing_direction"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.edit_guidance_scale",description:`<strong>edit_guidance_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 5) &#x2014;
Guidance scale for guiding the image generation. If provided as list values should correspond to
<code>editing_prompt</code>. <code>edit_guidance_scale</code> is defined as <code>s_e</code> of equation 12 of <a href="https://arxiv.org/abs/2301.12247" rel="nofollow">LEDITS++
Paper</a>.`,name:"edit_guidance_scale"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.edit_warmup_steps",description:`<strong>edit_warmup_steps</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 10) &#x2014;
Number of diffusion steps (for each prompt) for which guidance will not be applied.`,name:"edit_warmup_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.edit_cooldown_steps",description:`<strong>edit_cooldown_steps</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of diffusion steps (for each prompt) after which guidance will no longer be applied.`,name:"edit_cooldown_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.edit_threshold",description:`<strong>edit_threshold</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.9) &#x2014;
Masking threshold of guidance. Threshold should be proportional to the image region that is modified.
&#x2018;edit_threshold&#x2019; is defined as &#x2018;&#x3BB;&#x2019; of equation 12 of <a href="https://arxiv.org/abs/2301.12247" rel="nofollow">LEDITS++
Paper</a>.`,name:"edit_threshold"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.user_mask",description:`<strong>user_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
User-provided mask for even better control over the editing process. This is helpful when LEDITS++&#x2018;s
implicit masks do not meet user preferences.`,name:"user_mask"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.sem_guidance",description:`<strong>sem_guidance</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
List of pre-generated guidance vectors to be applied at generation. Length of the list has to
correspond to <code>num_inference_steps</code>.`,name:"sem_guidance"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.use_cross_attn_mask",description:`<strong>use_cross_attn_mask</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether cross-attention masks are used. Cross-attention masks are always used when use_intersect_mask
is set to true. Cross-attention masks are defined as &#x2018;M^1&#x2019; of equation 12 of <a href="https://arxiv.org/pdf/2311.16711.pdf" rel="nofollow">LEDITS++
paper</a>.`,name:"use_cross_attn_mask"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.use_intersect_mask",description:`<strong>use_intersect_mask</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether the masking term is calculated as intersection of cross-attention masks and masks derived from
the noise estimate. Cross-attention mask are defined as &#x2018;M^1&#x2019; and masks derived from the noise estimate
are defined as &#x2018;M^2&#x2019; of equation 12 of <a href="https://arxiv.org/pdf/2311.16711.pdf" rel="nofollow">LEDITS++ paper</a>.`,name:"use_intersect_mask"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.attn_store_steps",description:`<strong>attn_store_steps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Steps for which the attention maps are stored in the AttentionStore. Just for visualization purposes.`,name:"attn_store_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.store_averaged_over_steps",description:`<strong>store_averaged_over_steps</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether the attention maps for the &#x2018;attn_store_steps&#x2019; are stored averaged over the diffusion steps. If
False, attention maps for each step are stores separately. Just for visualization purposes.`,name:"store_averaged_over_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor from <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a>. Guidance rescale factor should fix overexposure when
using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion.py#L749",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10037/en/api/pipelines/ledits_pp#diffusers.pipelines.LEditsPPDiffusionPipelineOutput"
>LEditsPPDiffusionPipelineOutput</a> if <code>return_dict</code> is True, otherwise a <code>tuple. When returning a tuple, the first element is a list with the generated images, and the second element is a list of </code>bool<code>s denoting whether the corresponding generated image likely represents "not-safe-for-work" (nsfw) content, according to the </code>safety_checker\`.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10037/en/api/pipelines/ledits_pp#diffusers.pipelines.LEditsPPDiffusionPipelineOutput"
>LEditsPPDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),z=new Hi({props:{anchor:"diffusers.LEditsPPPipelineStableDiffusion.__call__.example",$$slots:{default:[ln]},$$scope:{ctx:$}}}),se=new T({props:{name:"invert",anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"source_prompt",val:": str = ''"},{name:"source_guidance_scale",val:": float = 3.5"},{name:"num_inversion_steps",val:": int = 30"},{name:"skip",val:": float = 0.15"},{name:"generator",val:": typing.Optional[torch._C.Generator] = None"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"resize_mode",val:": typing.Optional[str] = 'default'"},{name:"crops_coords",val:": typing.Optional[typing.Tuple[int, int, int, int]] = None"}],parametersDescription:[{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
Input for the image(s) that are to be edited. Multiple input images have to default to the same aspect
ratio.`,name:"image"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.source_prompt",description:`<strong>source_prompt</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
Prompt describing the input image that will be used for guidance during inversion. Guidance is disabled
if the <code>source_prompt</code> is <code>&quot;&quot;</code>.`,name:"source_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.source_guidance_scale",description:`<strong>source_guidance_scale</strong> (<code>float</code>, defaults to <code>3.5</code>) &#x2014;
Strength of guidance during inversion.`,name:"source_guidance_scale"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.num_inversion_steps",description:`<strong>num_inversion_steps</strong> (<code>int</code>, defaults to <code>30</code>) &#x2014;
Number of total performed inversion steps after discarding the initial <code>skip</code> steps.`,name:"num_inversion_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.skip",description:`<strong>skip</strong> (<code>float</code>, defaults to <code>0.15</code>) &#x2014;
Portion of initial steps that will be ignored for inversion and subsequent generation. Lower values
will lead to stronger changes to the input image. <code>skip</code> has to be between <code>0</code> and <code>1</code>.`,name:"skip"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make inversion
deterministic.`,name:"generator"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The height in preprocessed image. If <code>None</code>, will use the <code>get_default_height_width()</code> to get default
height.`,name:"height"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.width",description:"<strong>width</strong> (<code>int</code>, <em>optional</em><code>, defaults to </code>None<code>) -- The width in preprocessed. If </code>None<code>, will use get_default_height_width()</code> to get the default width.",name:"width"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.resize_mode",description:`<strong>resize_mode</strong> (<code>str</code>, <em>optional</em>, defaults to <code>default</code>) &#x2014;
The resize mode, can be one of <code>default</code> or <code>fill</code>. If <code>default</code>, will resize the image to fit within
the specified width and height, and it may not maintaining the original aspect ratio. If <code>fill</code>, will
resize the image to fit within the specified width and height, maintaining the aspect ratio, and then
center the image within the dimensions, filling empty with data from image. If <code>crop</code>, will resize the
image to fit within the specified width and height, maintaining the aspect ratio, and then center the
image within the dimensions, cropping the excess. Note that resize_mode <code>fill</code> and <code>crop</code> are only
supported for PIL image input.`,name:"resize_mode"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.invert.crops_coords",description:`<strong>crops_coords</strong> (<code>List[Tuple[int, int, int, int]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The crop coordinates for each image in the batch. If <code>None</code>, will not crop the image.`,name:"crops_coords"}],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion.py#L1253",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Output will contain the resized input image(s)
and respective VAE reconstruction(s).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10037/en/api/pipelines/ledits_pp#diffusers.pipelines.LEditsPPInversionPipelineOutput"
>LEditsPPInversionPipelineOutput</a></p>
`}}),re=new T({props:{name:"disable_vae_slicing",anchor:"diffusers.LEditsPPPipelineStableDiffusion.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion.py#L727"}}),ae=new T({props:{name:"disable_vae_tiling",anchor:"diffusers.LEditsPPPipelineStableDiffusion.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion.py#L742"}}),de=new T({props:{name:"enable_vae_slicing",anchor:"diffusers.LEditsPPPipelineStableDiffusion.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion.py#L720"}}),le=new T({props:{name:"enable_vae_tiling",anchor:"diffusers.LEditsPPPipelineStableDiffusion.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion.py#L734"}}),pe=new T({props:{name:"encode_prompt",anchor:"diffusers.LEditsPPPipelineStableDiffusion.encode_prompt",parameters:[{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"enable_edit_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"editing_prompt",val:" = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"editing_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.LEditsPPPipelineStableDiffusion.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.encode_prompt.enable_edit_guidance",description:`<strong>enable_edit_guidance</strong> (<code>bool</code>) &#x2014;
whether to perform any editing or reconstruct the input image instead`,name:"enable_edit_guidance"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.encode_prompt.editing_prompt",description:`<strong>editing_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Editing prompt(s) to be encoded. If not defined, one has to pass <code>editing_prompt_embeds</code> instead.`,name:"editing_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.encode_prompt.editing_prompt_embeds",description:`<strong>editing_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"editing_prompt_embeds"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.LEditsPPPipelineStableDiffusion.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion.py#L521"}}),ce=new tt({props:{title:"LEditsPPPipelineStableDiffusionXL",local:"diffusers.LEditsPPPipelineStableDiffusionXL",headingTag:"h2"}}),fe=new T({props:{name:"class diffusers.LEditsPPPipelineStableDiffusionXL",anchor:"diffusers.LEditsPPPipelineStableDiffusionXL",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_dpmsolver_multistep.DPMSolverMultistepScheduler, diffusers.schedulers.scheduling_ddim.DDIMScheduler]"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"feature_extractor",val:": CLIPImageProcessor = None"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_10037/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder. Stable Diffusion XL uses the text portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.text_encoder_2",description:`<strong>text_encoder_2</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIPTextModelWithProjection</a>) &#x2014;
Second frozen text-encoder. Stable Diffusion XL uses the text and pool portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the
<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>
variant.`,name:"text_encoder_2"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.tokenizer_2",description:`<strong>tokenizer_2</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer_2"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.unet",description:'<strong>unet</strong> (<a href="/docs/diffusers/pr_10037/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014; Conditional U-Net architecture to denoise the encoded image latents.',name:"unet"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_10037/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a> or <a href="/docs/diffusers/pr_10037/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latens. Can be one of
<a href="/docs/diffusers/pr_10037/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a> or <a href="/docs/diffusers/pr_10037/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>. If any other scheduler is passed it will
automatically be set to <a href="/docs/diffusers/pr_10037/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.force_zeros_for_empty_prompt",description:`<strong>force_zeros_for_empty_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;True&quot;</code>) &#x2014;
Whether the negative prompt embeddings shall be forced to always be set to 0. Also see the config of
<code>stabilityai/stable-diffusion-xl-base-1-0</code>.`,name:"force_zeros_for_empty_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.add_watermarker",description:`<strong>add_watermarker</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use the <a href="https://github.com/ShieldMnt/invisible-watermark/" rel="nofollow">invisible_watermark library</a> to
watermark output images. If not defined, it will default to True if the package is installed, otherwise no
watermarker will be used.`,name:"add_watermarker"}],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion_xl.py#L274"}}),me=new T({props:{name:"__call__",anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__",parameters:[{name:"denoising_end",val:": typing.Optional[float] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"target_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"editing_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"editing_prompt_embeddings",val:": typing.Optional[torch.Tensor] = None"},{name:"editing_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"reverse_editing_direction",val:": typing.Union[bool, typing.List[bool], NoneType] = False"},{name:"edit_guidance_scale",val:": typing.Union[float, typing.List[float], NoneType] = 5"},{name:"edit_warmup_steps",val:": typing.Union[int, typing.List[int], NoneType] = 0"},{name:"edit_cooldown_steps",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"edit_threshold",val:": typing.Union[float, typing.List[float], NoneType] = 0.9"},{name:"sem_guidance",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"use_cross_attn_mask",val:": bool = False"},{name:"use_intersect_mask",val:": bool = False"},{name:"user_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"attn_store_steps",val:": typing.Optional[typing.List[int]] = []"},{name:"store_averaged_over_steps",val:": bool = True"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise as determined by the discrete timesteps selected by the
scheduler. The denoising_end parameter should ideally be utilized when this pipeline forms a part of a
&#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in [**Refining the Image`,name:"denoising_end"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.ip_adapter_image",description:`<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>):
Optional image input to work with IP Adapters.`,name:"ip_adapter_image"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.7) &#x2014;
Guidance rescale factor proposed by <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a>.
Guidance rescale factor should fix overexposure when using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(width, height)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.editing_prompt",description:`<strong>editing_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. The image is reconstructed by setting
<code>editing_prompt = None</code>. Guidance direction of prompt should be specified via
<code>reverse_editing_direction</code>.`,name:"editing_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.editing_prompt_embeddings",description:`<strong>editing_prompt_embeddings</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated edit text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, editing_prompt_embeddings will be generated from <code>editing_prompt</code> input argument.`,name:"editing_prompt_embeddings"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.editing_pooled_prompt_embeddings",description:`<strong>editing_pooled_prompt_embeddings</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled edit text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, editing_prompt_embeddings will be generated from <code>editing_prompt</code> input
argument.`,name:"editing_pooled_prompt_embeddings"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.reverse_editing_direction",description:`<strong>reverse_editing_direction</strong> (<code>bool</code> or <code>List[bool]</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the corresponding prompt in <code>editing_prompt</code> should be increased or decreased.`,name:"reverse_editing_direction"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.edit_guidance_scale",description:`<strong>edit_guidance_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 5) &#x2014;
Guidance scale for guiding the image generation. If provided as list values should correspond to
<code>editing_prompt</code>. <code>edit_guidance_scale</code> is defined as <code>s_e</code> of equation 12 of <a href="https://arxiv.org/abs/2301.12247" rel="nofollow">LEDITS++
Paper</a>.`,name:"edit_guidance_scale"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.edit_warmup_steps",description:`<strong>edit_warmup_steps</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 10) &#x2014;
Number of diffusion steps (for each prompt) for which guidance is not applied.`,name:"edit_warmup_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.edit_cooldown_steps",description:`<strong>edit_cooldown_steps</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of diffusion steps (for each prompt) after which guidance is no longer applied.`,name:"edit_cooldown_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.edit_threshold",description:`<strong>edit_threshold</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.9) &#x2014;
Masking threshold of guidance. Threshold should be proportional to the image region that is modified.
&#x2018;edit_threshold&#x2019; is defined as &#x2018;&#x3BB;&#x2019; of equation 12 of <a href="https://arxiv.org/abs/2301.12247" rel="nofollow">LEDITS++
Paper</a>.`,name:"edit_threshold"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.sem_guidance",description:`<strong>sem_guidance</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
List of pre-generated guidance vectors to be applied at generation. Length of the list has to
correspond to <code>num_inference_steps</code>.`,name:"sem_guidance"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.use_cross_attn_mask",description:`<strong>use_cross_attn_mask</strong> &#x2014;
Whether cross-attention masks are used. Cross-attention masks are always used when use_intersect_mask
is set to true. Cross-attention masks are defined as &#x2018;M^1&#x2019; of equation 12 of <a href="https://arxiv.org/pdf/2311.16711.pdf" rel="nofollow">LEDITS++
paper</a>.`,name:"use_cross_attn_mask"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.use_intersect_mask",description:`<strong>use_intersect_mask</strong> &#x2014;
Whether the masking term is calculated as intersection of cross-attention masks and masks derived from
the noise estimate. Cross-attention mask are defined as &#x2018;M^1&#x2019; and masks derived from the noise estimate
are defined as &#x2018;M^2&#x2019; of equation 12 of <a href="https://arxiv.org/pdf/2311.16711.pdf" rel="nofollow">LEDITS++ paper</a>.`,name:"use_intersect_mask"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.user_mask",description:`<strong>user_mask</strong> &#x2014;
User-provided mask for even better control over the editing process. This is helpful when LEDITS++&#x2018;s
implicit masks do not meet user preferences.`,name:"user_mask"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.attn_store_steps",description:`<strong>attn_store_steps</strong> &#x2014;
Steps for which the attention maps are stored in the AttentionStore. Just for visualization purposes.`,name:"attn_store_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.store_averaged_over_steps",description:`<strong>store_averaged_over_steps</strong> &#x2014;
Whether the attention maps for the &#x2018;attn_store_steps&#x2019; are stored averaged over the diffusion steps. If
False, attention maps for each step are stores separately. Just for visualization purposes.`,name:"store_averaged_over_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion_xl.py#L822",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10037/en/api/pipelines/ledits_pp#diffusers.pipelines.LEditsPPDiffusionPipelineOutput"
>LEditsPPDiffusionPipelineOutput</a> if <code>return_dict</code> is True, otherwise a \`tuple. When
returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10037/en/api/pipelines/ledits_pp#diffusers.pipelines.LEditsPPDiffusionPipelineOutput"
>LEditsPPDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),V=new Hi({props:{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.__call__.example",$$slots:{default:[pn]},$$scope:{ctx:$}}}),ue=new T({props:{name:"invert",anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"source_prompt",val:": str = ''"},{name:"source_guidance_scale",val:" = 3.5"},{name:"negative_prompt",val:": str = None"},{name:"negative_prompt_2",val:": str = None"},{name:"num_inversion_steps",val:": int = 50"},{name:"skip",val:": float = 0.15"},{name:"generator",val:": typing.Optional[torch._C.Generator] = None"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"num_zero_noise_steps",val:": int = 3"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"resize_mode",val:": typing.Optional[str] = 'default'"},{name:"crops_coords",val:": typing.Optional[typing.Tuple[int, int, int, int]] = None"}],parametersDescription:[{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
Input for the image(s) that are to be edited. Multiple input images have to default to the same aspect
ratio.`,name:"image"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.source_prompt",description:`<strong>source_prompt</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
Prompt describing the input image that will be used for guidance during inversion. Guidance is disabled
if the <code>source_prompt</code> is <code>&quot;&quot;</code>.`,name:"source_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.source_guidance_scale",description:`<strong>source_guidance_scale</strong> (<code>float</code>, defaults to <code>3.5</code>) &#x2014;
Strength of guidance during inversion.`,name:"source_guidance_scale"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.num_inversion_steps",description:`<strong>num_inversion_steps</strong> (<code>int</code>, defaults to <code>50</code>) &#x2014;
Number of total performed inversion steps after discarding the initial <code>skip</code> steps.`,name:"num_inversion_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.skip",description:`<strong>skip</strong> (<code>float</code>, defaults to <code>0.15</code>) &#x2014;
Portion of initial steps that will be ignored for inversion and subsequent generation. Lower values
will lead to stronger changes to the input image. <code>skip</code> has to be between <code>0</code> and <code>1</code>.`,name:"skip"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make inversion
deterministic.`,name:"generator"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.num_zero_noise_steps",description:`<strong>num_zero_noise_steps</strong> (<code>int</code>, defaults to <code>3</code>) &#x2014;
Number of final diffusion steps that will not renoise the current image. If no steps are set to zero
SD-XL in combination with <a href="/docs/diffusers/pr_10037/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a> will produce noise artifacts.`,name:"num_zero_noise_steps"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.invert.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"cross_attention_kwargs"}],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion_xl.py#L1460",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Output will contain the resized input image(s)
and respective VAE reconstruction(s).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10037/en/api/pipelines/ledits_pp#diffusers.pipelines.LEditsPPInversionPipelineOutput"
>LEditsPPInversionPipelineOutput</a></p>
`}}),ge=new T({props:{name:"disable_vae_slicing",anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion_xl.py#L775"}}),_e=new T({props:{name:"disable_vae_tiling",anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion_xl.py#L790"}}),he=new T({props:{name:"enable_vae_slicing",anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion_xl.py#L768"}}),be=new T({props:{name:"enable_vae_tiling",anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion_xl.py#L782"}}),Pe=new T({props:{name:"encode_prompt",anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt",parameters:[{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"negative_prompt",val:": typing.Optional[str] = None"},{name:"negative_prompt_2",val:": typing.Optional[str] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"enable_edit_guidance",val:": bool = True"},{name:"editing_prompt",val:": typing.Optional[str] = None"},{name:"editing_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"editing_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead.`,name:"negative_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.enable_edit_guidance",description:`<strong>enable_edit_guidance</strong> (<code>bool</code>) &#x2014;
Whether to guide towards an editing prompt or not.`,name:"enable_edit_guidance"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.editing_prompt",description:`<strong>editing_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Editing prompt(s) to be encoded. If not defined and &#x2018;enable_edit_guidance&#x2019; is True, one has to pass
<code>editing_prompt_embeds</code> instead.`,name:"editing_prompt"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.editing_prompt_embeds",description:`<strong>editing_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated edit text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided and &#x2018;enable_edit_guidance&#x2019; is True, editing_prompt_embeds will be generated from
<code>editing_prompt</code> input argument.`,name:"editing_prompt_embeds"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.encode_prompt.editing_pooled_prompt_embeds",description:`<strong>editing_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated edit pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled editing_pooled_prompt_embeds will be generated from <code>editing_prompt</code>
input argument.`,name:"editing_pooled_prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion_xl.py#L401"}}),ve=new T({props:{name:"get_guidance_scale_embedding",anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.get_guidance_scale_embedding",parameters:[{name:"w",val:": Tensor"},{name:"embedding_dim",val:": int = 512"},{name:"dtype",val:": dtype = torch.float32"}],parametersDescription:[{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.get_guidance_scale_embedding.w",description:`<strong>w</strong> (<code>torch.Tensor</code>) &#x2014;
Generate embedding vectors with a specified guidance scale to subsequently enrich timestep embeddings.`,name:"w"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.get_guidance_scale_embedding.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimension of the embeddings to generate.`,name:"embedding_dim"},{anchor:"diffusers.LEditsPPPipelineStableDiffusionXL.get_guidance_scale_embedding.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
Data type of the generated embeddings.`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/ledits_pp/pipeline_leditspp_stable_diffusion_xl.py#L707",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Embedding vectors with shape <code>(len(w), embedding_dim)</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),Le=new tt({props:{title:"LEditsPPDiffusionPipelineOutput",local:"diffusers.pipelines.LEditsPPDiffusionPipelineOutput",headingTag:"h2"}}),ye=new T({props:{name:"class diffusers.pipelines.LEditsPPDiffusionPipelineOutput",anchor:"diffusers.pipelines.LEditsPPDiffusionPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"},{name:"nsfw_content_detected",val:": typing.Optional[typing.List[bool]]"}],parametersDescription:[{anchor:"diffusers.pipelines.LEditsPPDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.LEditsPPDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/ledits_pp/pipeline_output.py#L10"}}),we=new tt({props:{title:"LEditsPPInversionPipelineOutput",local:"diffusers.pipelines.LEditsPPInversionPipelineOutput",headingTag:"h2"}}),xe=new T({props:{name:"class diffusers.pipelines.LEditsPPInversionPipelineOutput",anchor:"diffusers.pipelines.LEditsPPInversionPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"},{name:"vae_reconstruction_images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"}],parametersDescription:[{anchor:"diffusers.pipelines.LEditsPPInversionPipelineOutput.input_images",description:`<strong>input_images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of the cropped and resized input images as PIL images of length <code>batch_size</code> or NumPy array of shape <code> (batch_size, height, width, num_channels)</code>.`,name:"input_images"},{anchor:"diffusers.pipelines.LEditsPPInversionPipelineOutput.vae_reconstruction_images",description:`<strong>vae_reconstruction_images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of VAE reconstruction of all input images as PIL images of length <code>batch_size</code> or NumPy array of shape
<code> (batch_size, height, width, num_channels)</code>.`,name:"vae_reconstruction_images"}],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/ledits_pp/pipeline_output.py#L28"}}),De=new rn({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/ledits_pp.md"}}),{c(){d=s("meta"),E=i(),L=s("p"),w=i(),m(S.$$.fragment),p=i(),k=s("p"),k.innerHTML=vi,it=i(),K=s("p"),K.textContent=Li,nt=i(),ee=s("p"),ee.innerHTML=yi,ot=i(),m(j.$$.fragment),st=i(),m(U.$$.fragment),rt=i(),te=s("p"),te.textContent=wi,at=i(),m(ie.$$.fragment),dt=i(),v=s("div"),m(ne.$$.fragment),It=i(),Se=s("p"),Se.textContent=xi,Mt=i(),ke=s("p"),ke.innerHTML=Di,Ct=i(),I=s("div"),m(oe.$$.fragment),Nt=i(),$e=s("p"),$e.innerHTML=Ei,Xt=i(),m(z.$$.fragment),jt=i(),J=s("div"),m(se.$$.fragment),Ut=i(),Ie=s("p"),Ie.innerHTML=Ti,zt=i(),W=s("div"),m(re.$$.fragment),Jt=i(),Me=s("p"),Me.innerHTML=Si,Wt=i(),A=s("div"),m(ae.$$.fragment),At=i(),Ce=s("p"),Ce.innerHTML=ki,Zt=i(),Z=s("div"),m(de.$$.fragment),Ot=i(),Ne=s("p"),Ne.textContent=$i,Gt=i(),O=s("div"),m(le.$$.fragment),Vt=i(),Xe=s("p"),Xe.textContent=Ii,Bt=i(),G=s("div"),m(pe.$$.fragment),Ft=i(),je=s("p"),je.textContent=Mi,lt=i(),m(ce.$$.fragment),pt=i(),l=s("div"),m(fe.$$.fragment),qt=i(),Ue=s("p"),Ue.textContent=Ci,Rt=i(),ze=s("p"),ze.innerHTML=Ni,Ht=i(),Je=s("p"),Je.textContent=Xi,Qt=i(),We=s("ul"),We.innerHTML=ji,Yt=i(),Ae=s("p"),Ae.textContent=Ui,Kt=i(),Ze=s("ul"),Ze.innerHTML=zi,ei=i(),M=s("div"),m(me.$$.fragment),ti=i(),Oe=s("p"),Oe.innerHTML=Ji,ii=i(),m(V.$$.fragment),ni=i(),B=s("div"),m(ue.$$.fragment),oi=i(),Ge=s("p"),Ge.innerHTML=Wi,si=i(),F=s("div"),m(ge.$$.fragment),ri=i(),Ve=s("p"),Ve.innerHTML=Ai,ai=i(),q=s("div"),m(_e.$$.fragment),di=i(),Be=s("p"),Be.innerHTML=Zi,li=i(),R=s("div"),m(he.$$.fragment),pi=i(),Fe=s("p"),Fe.textContent=Oi,ci=i(),H=s("div"),m(be.$$.fragment),fi=i(),qe=s("p"),qe.textContent=Gi,mi=i(),Q=s("div"),m(Pe.$$.fragment),ui=i(),Re=s("p"),Re.textContent=Vi,gi=i(),Y=s("div"),m(ve.$$.fragment),_i=i(),He=s("p"),He.innerHTML=Bi,ct=i(),m(Le.$$.fragment),ft=i(),C=s("div"),m(ye.$$.fragment),hi=i(),Qe=s("p"),Qe.textContent=Fi,mt=i(),m(we.$$.fragment),ut=i(),N=s("div"),m(xe.$$.fragment),bi=i(),Ye=s("p"),Ye.textContent=qi,gt=i(),m(De.$$.fragment),_t=i(),et=s("p"),this.h()},l(e){const a=nn("svelte-u9bgzb",document.head);d=r(a,"META",{name:!0,content:!0}),a.forEach(o),E=n(e),L=r(e,"P",{}),x(L).forEach(o),w=n(e),u(S.$$.fragment,e),p=n(e),k=r(e,"P",{"data-svelte-h":!0}),f(k)!=="svelte-ke65yv"&&(k.innerHTML=vi),it=n(e),K=r(e,"P",{"data-svelte-h":!0}),f(K)!=="svelte-1cwsb16"&&(K.textContent=Li),nt=n(e),ee=r(e,"P",{"data-svelte-h":!0}),f(ee)!=="svelte-1jncrmh"&&(ee.innerHTML=yi),ot=n(e),u(j.$$.fragment,e),st=n(e),u(U.$$.fragment,e),rt=n(e),te=r(e,"P",{"data-svelte-h":!0}),f(te)!=="svelte-1qwf4p0"&&(te.textContent=wi),at=n(e),u(ie.$$.fragment,e),dt=n(e),v=r(e,"DIV",{class:!0});var y=x(v);u(ne.$$.fragment,y),It=n(y),Se=r(y,"P",{"data-svelte-h":!0}),f(Se)!=="svelte-i87xsw"&&(Se.textContent=xi),Mt=n(y),ke=r(y,"P",{"data-svelte-h":!0}),f(ke)!=="svelte-1vr06b"&&(ke.innerHTML=Di),Ct=n(y),I=r(y,"DIV",{class:!0});var X=x(I);u(oe.$$.fragment,X),Nt=n(X),$e=r(X,"P",{"data-svelte-h":!0}),f($e)!=="svelte-1uevb9o"&&($e.innerHTML=Ei),Xt=n(X),u(z.$$.fragment,X),X.forEach(o),jt=n(y),J=r(y,"DIV",{class:!0});var Ee=x(J);u(se.$$.fragment,Ee),Ut=n(Ee),Ie=r(Ee,"P",{"data-svelte-h":!0}),f(Ie)!=="svelte-1nh72su"&&(Ie.innerHTML=Ti),Ee.forEach(o),zt=n(y),W=r(y,"DIV",{class:!0});var Te=x(W);u(re.$$.fragment,Te),Jt=n(Te),Me=r(Te,"P",{"data-svelte-h":!0}),f(Me)!=="svelte-1s3c06i"&&(Me.innerHTML=Si),Te.forEach(o),Wt=n(y),A=r(y,"DIV",{class:!0});var bt=x(A);u(ae.$$.fragment,bt),At=n(bt),Ce=r(bt,"P",{"data-svelte-h":!0}),f(Ce)!=="svelte-pkn4ui"&&(Ce.innerHTML=ki),bt.forEach(o),Zt=n(y),Z=r(y,"DIV",{class:!0});var Pt=x(Z);u(de.$$.fragment,Pt),Ot=n(Pt),Ne=r(Pt,"P",{"data-svelte-h":!0}),f(Ne)!=="svelte-14bnrb6"&&(Ne.textContent=$i),Pt.forEach(o),Gt=n(y),O=r(y,"DIV",{class:!0});var vt=x(O);u(le.$$.fragment,vt),Vt=n(vt),Xe=r(vt,"P",{"data-svelte-h":!0}),f(Xe)!=="svelte-1xwrf7t"&&(Xe.textContent=Ii),vt.forEach(o),Bt=n(y),G=r(y,"DIV",{class:!0});var Lt=x(G);u(pe.$$.fragment,Lt),Ft=n(Lt),je=r(Lt,"P",{"data-svelte-h":!0}),f(je)!=="svelte-16q0ax1"&&(je.textContent=Mi),Lt.forEach(o),y.forEach(o),lt=n(e),u(ce.$$.fragment,e),pt=n(e),l=r(e,"DIV",{class:!0});var P=x(l);u(fe.$$.fragment,P),qt=n(P),Ue=r(P,"P",{"data-svelte-h":!0}),f(Ue)!=="svelte-ojahy4"&&(Ue.textContent=Ci),Rt=n(P),ze=r(P,"P",{"data-svelte-h":!0}),f(ze)!=="svelte-6eztzn"&&(ze.innerHTML=Ni),Ht=n(P),Je=r(P,"P",{"data-svelte-h":!0}),f(Je)!=="svelte-984r3o"&&(Je.textContent=Xi),Qt=n(P),We=r(P,"UL",{"data-svelte-h":!0}),f(We)!=="svelte-1v8y0ra"&&(We.innerHTML=ji),Yt=n(P),Ae=r(P,"P",{"data-svelte-h":!0}),f(Ae)!=="svelte-19qtqre"&&(Ae.textContent=Ui),Kt=n(P),Ze=r(P,"UL",{"data-svelte-h":!0}),f(Ze)!=="svelte-1tez18v"&&(Ze.innerHTML=zi),ei=n(P),M=r(P,"DIV",{class:!0});var Ke=x(M);u(me.$$.fragment,Ke),ti=n(Ke),Oe=r(Ke,"P",{"data-svelte-h":!0}),f(Oe)!=="svelte-18c76fc"&&(Oe.innerHTML=Ji),ii=n(Ke),u(V.$$.fragment,Ke),Ke.forEach(o),ni=n(P),B=r(P,"DIV",{class:!0});var yt=x(B);u(ue.$$.fragment,yt),oi=n(yt),Ge=r(yt,"P",{"data-svelte-h":!0}),f(Ge)!=="svelte-1nh72su"&&(Ge.innerHTML=Wi),yt.forEach(o),si=n(P),F=r(P,"DIV",{class:!0});var wt=x(F);u(ge.$$.fragment,wt),ri=n(wt),Ve=r(wt,"P",{"data-svelte-h":!0}),f(Ve)!=="svelte-1s3c06i"&&(Ve.innerHTML=Ai),wt.forEach(o),ai=n(P),q=r(P,"DIV",{class:!0});var xt=x(q);u(_e.$$.fragment,xt),di=n(xt),Be=r(xt,"P",{"data-svelte-h":!0}),f(Be)!=="svelte-pkn4ui"&&(Be.innerHTML=Zi),xt.forEach(o),li=n(P),R=r(P,"DIV",{class:!0});var Dt=x(R);u(he.$$.fragment,Dt),pi=n(Dt),Fe=r(Dt,"P",{"data-svelte-h":!0}),f(Fe)!=="svelte-14bnrb6"&&(Fe.textContent=Oi),Dt.forEach(o),ci=n(P),H=r(P,"DIV",{class:!0});var Et=x(H);u(be.$$.fragment,Et),fi=n(Et),qe=r(Et,"P",{"data-svelte-h":!0}),f(qe)!=="svelte-1xwrf7t"&&(qe.textContent=Gi),Et.forEach(o),mi=n(P),Q=r(P,"DIV",{class:!0});var Tt=x(Q);u(Pe.$$.fragment,Tt),ui=n(Tt),Re=r(Tt,"P",{"data-svelte-h":!0}),f(Re)!=="svelte-16q0ax1"&&(Re.textContent=Vi),Tt.forEach(o),gi=n(P),Y=r(P,"DIV",{class:!0});var St=x(Y);u(ve.$$.fragment,St),_i=n(St),He=r(St,"P",{"data-svelte-h":!0}),f(He)!=="svelte-vo59ec"&&(He.innerHTML=Bi),St.forEach(o),P.forEach(o),ct=n(e),u(Le.$$.fragment,e),ft=n(e),C=r(e,"DIV",{class:!0});var kt=x(C);u(ye.$$.fragment,kt),hi=n(kt),Qe=r(kt,"P",{"data-svelte-h":!0}),f(Qe)!=="svelte-hu8uib"&&(Qe.textContent=Fi),kt.forEach(o),mt=n(e),u(we.$$.fragment,e),ut=n(e),N=r(e,"DIV",{class:!0});var $t=x(N);u(xe.$$.fragment,$t),bi=n($t),Ye=r($t,"P",{"data-svelte-h":!0}),f(Ye)!=="svelte-hu8uib"&&(Ye.textContent=qi),$t.forEach(o),gt=n(e),u(De.$$.fragment,e),_t=n(e),et=r(e,"P",{}),x(et).forEach(o),this.h()},h(){D(d,"name","hf:doc:metadata"),D(d,"content",fn),D(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(l,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){t(document.head,d),c(e,E,a),c(e,L,a),c(e,w,a),g(S,e,a),c(e,p,a),c(e,k,a),c(e,it,a),c(e,K,a),c(e,nt,a),c(e,ee,a),c(e,ot,a),g(j,e,a),c(e,st,a),g(U,e,a),c(e,rt,a),c(e,te,a),c(e,at,a),g(ie,e,a),c(e,dt,a),c(e,v,a),g(ne,v,null),t(v,It),t(v,Se),t(v,Mt),t(v,ke),t(v,Ct),t(v,I),g(oe,I,null),t(I,Nt),t(I,$e),t(I,Xt),g(z,I,null),t(v,jt),t(v,J),g(se,J,null),t(J,Ut),t(J,Ie),t(v,zt),t(v,W),g(re,W,null),t(W,Jt),t(W,Me),t(v,Wt),t(v,A),g(ae,A,null),t(A,At),t(A,Ce),t(v,Zt),t(v,Z),g(de,Z,null),t(Z,Ot),t(Z,Ne),t(v,Gt),t(v,O),g(le,O,null),t(O,Vt),t(O,Xe),t(v,Bt),t(v,G),g(pe,G,null),t(G,Ft),t(G,je),c(e,lt,a),g(ce,e,a),c(e,pt,a),c(e,l,a),g(fe,l,null),t(l,qt),t(l,Ue),t(l,Rt),t(l,ze),t(l,Ht),t(l,Je),t(l,Qt),t(l,We),t(l,Yt),t(l,Ae),t(l,Kt),t(l,Ze),t(l,ei),t(l,M),g(me,M,null),t(M,ti),t(M,Oe),t(M,ii),g(V,M,null),t(l,ni),t(l,B),g(ue,B,null),t(B,oi),t(B,Ge),t(l,si),t(l,F),g(ge,F,null),t(F,ri),t(F,Ve),t(l,ai),t(l,q),g(_e,q,null),t(q,di),t(q,Be),t(l,li),t(l,R),g(he,R,null),t(R,pi),t(R,Fe),t(l,ci),t(l,H),g(be,H,null),t(H,fi),t(H,qe),t(l,mi),t(l,Q),g(Pe,Q,null),t(Q,ui),t(Q,Re),t(l,gi),t(l,Y),g(ve,Y,null),t(Y,_i),t(Y,He),c(e,ct,a),g(Le,e,a),c(e,ft,a),c(e,C,a),g(ye,C,null),t(C,hi),t(C,Qe),c(e,mt,a),g(we,e,a),c(e,ut,a),c(e,N,a),g(xe,N,null),t(N,bi),t(N,Ye),c(e,gt,a),g(De,e,a),c(e,_t,a),c(e,et,a),ht=!0},p(e,[a]){const y={};a&2&&(y.$$scope={dirty:a,ctx:e}),j.$set(y);const X={};a&2&&(X.$$scope={dirty:a,ctx:e}),U.$set(X);const Ee={};a&2&&(Ee.$$scope={dirty:a,ctx:e}),z.$set(Ee);const Te={};a&2&&(Te.$$scope={dirty:a,ctx:e}),V.$set(Te)},i(e){ht||(_(S.$$.fragment,e),_(j.$$.fragment,e),_(U.$$.fragment,e),_(ie.$$.fragment,e),_(ne.$$.fragment,e),_(oe.$$.fragment,e),_(z.$$.fragment,e),_(se.$$.fragment,e),_(re.$$.fragment,e),_(ae.$$.fragment,e),_(de.$$.fragment,e),_(le.$$.fragment,e),_(pe.$$.fragment,e),_(ce.$$.fragment,e),_(fe.$$.fragment,e),_(me.$$.fragment,e),_(V.$$.fragment,e),_(ue.$$.fragment,e),_(ge.$$.fragment,e),_(_e.$$.fragment,e),_(he.$$.fragment,e),_(be.$$.fragment,e),_(Pe.$$.fragment,e),_(ve.$$.fragment,e),_(Le.$$.fragment,e),_(ye.$$.fragment,e),_(we.$$.fragment,e),_(xe.$$.fragment,e),_(De.$$.fragment,e),ht=!0)},o(e){h(S.$$.fragment,e),h(j.$$.fragment,e),h(U.$$.fragment,e),h(ie.$$.fragment,e),h(ne.$$.fragment,e),h(oe.$$.fragment,e),h(z.$$.fragment,e),h(se.$$.fragment,e),h(re.$$.fragment,e),h(ae.$$.fragment,e),h(de.$$.fragment,e),h(le.$$.fragment,e),h(pe.$$.fragment,e),h(ce.$$.fragment,e),h(fe.$$.fragment,e),h(me.$$.fragment,e),h(V.$$.fragment,e),h(ue.$$.fragment,e),h(ge.$$.fragment,e),h(_e.$$.fragment,e),h(he.$$.fragment,e),h(be.$$.fragment,e),h(Pe.$$.fragment,e),h(ve.$$.fragment,e),h(Le.$$.fragment,e),h(ye.$$.fragment,e),h(we.$$.fragment,e),h(xe.$$.fragment,e),h(De.$$.fragment,e),ht=!1},d(e){e&&(o(E),o(L),o(w),o(p),o(k),o(it),o(K),o(nt),o(ee),o(ot),o(st),o(rt),o(te),o(at),o(dt),o(v),o(lt),o(pt),o(l),o(ct),o(ft),o(C),o(mt),o(ut),o(N),o(gt),o(_t),o(et)),o(d),b(S,e),b(j,e),b(U,e),b(ie,e),b(ne),b(oe),b(z),b(se),b(re),b(ae),b(de),b(le),b(pe),b(ce,e),b(fe),b(me),b(V),b(ue),b(ge),b(_e),b(he),b(be),b(Pe),b(ve),b(Le,e),b(ye),b(we,e),b(xe),b(De,e)}}}const fn='{"title":"LEDITS++","local":"ledits","sections":[{"title":"LEditsPPPipelineStableDiffusion","local":"diffusers.LEditsPPPipelineStableDiffusion","sections":[],"depth":2},{"title":"LEditsPPPipelineStableDiffusionXL","local":"diffusers.LEditsPPPipelineStableDiffusionXL","sections":[],"depth":2},{"title":"LEditsPPDiffusionPipelineOutput","local":"diffusers.pipelines.LEditsPPDiffusionPipelineOutput","sections":[],"depth":2},{"title":"LEditsPPInversionPipelineOutput","local":"diffusers.pipelines.LEditsPPInversionPipelineOutput","sections":[],"depth":2}],"depth":1}';function mn($){return Ki(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ln extends en{constructor(d){super(),tn(this,d,mn,cn,Yi,{})}}export{Ln as component};
