import{s as Ke,n as Oe,o as tl}from"../chunks/scheduler.c57aa7ef.js";import{S as el,i as ll,g as o,s as a,r as p,A as nl,h as s,f as l,c as i,j as Se,u as m,x as r,k as De,y as al,a as n,v as f,d as u,t as d,w as h}from"../chunks/index.c50cb18e.js";import{C as M}from"../chunks/CodeBlock.34f0a53d.js";import{H as c,E as il}from"../chunks/EditOnGithub.958a8a49.js";function ol(Te){let b,wt,bt,gt,y,Tt,w,Je="Quantization represents data with fewer bits, making it a useful technique for reducing memory-usage and accelerating inference especially when it comes to large language models (LLMs). There are several ways to quantize a model including:",Jt,g,_e='<li>optimizing which model weights are quantized with the <a href="https://hf.co/papers/2306.00978" rel="nofollow">AWQ</a> algorithm</li> <li>independently quantizing each row of a weight matrix with the <a href="https://hf.co/papers/2210.17323" rel="nofollow">GPTQ</a> algorithm</li> <li>quantizing to 8-bit and 4-bit precision with the <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> library</li> <li>quantizing to as low as 2-bit precision with the <a href="https://arxiv.org/abs/2401.06118" rel="nofollow">AQLM</a> algorithm</li>',_t,T,$e='However, after a model is quantized it isn’t typically further trained for downstream tasks because training can be unstable due to the lower precision of the weights and activations. But since PEFT methods only add <em>extra</em> trainable parameters, this allows you to train a quantized model with a PEFT adapter on top! Combining quantization with PEFT can be a good strategy for training even the largest models on a single GPU. For example, <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> is a method that quantizes a model to 4-bits and then trains it with LoRA. This method allows you to finetune a 65B parameter model on a single 48GB GPU!',$t,J,qe="In this guide, you’ll see how to quantize a model to 4-bits and train it with LoRA.",qt,_,vt,$,ve='<a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> is a quantization library with a Transformers integration. With this integration, you can quantize a model to 8 or 4-bits and enable many other options by configuring the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">BitsAndBytesConfig</a> class. For example, you can:',jt,q,je="<li>set <code>load_in_4bit=True</code> to quantize the model to 4-bits when you load it</li> <li>set <code>bnb_4bit_quant_type=&quot;nf4&quot;</code> to use a special 4-bit data type for weights initialized from a normal distribution</li> <li>set <code>bnb_4bit_use_double_quant=True</code> to use a nested quantization scheme to quantize the already quantized weights</li> <li>set <code>bnb_4bit_compute_dtype=torch.bfloat16</code> to use bfloat16 for faster computation</li>",Zt,v,Ct,j,Ze='Pass the <code>config</code> to the <a href="https://huggingface.co/docs/transformers/main/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a> method.',Bt,Z,Lt,C,Ce='Next, you should call the <a href="/docs/peft/main/en/package_reference/peft_model#peft.prepare_model_for_kbit_training">prepare_model_for_kbit_training()</a> function to preprocess the quantized model for training.',kt,B,Qt,L,Be="Now that the quantized model is ready, let’s set up a configuration.",zt,k,Wt,Q,Le='Create a <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> with the following parameters (or choose your own):',Ut,z,Xt,W,ke='Then use the <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function to create a <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> from the quantized model and configuration.',Ft,U,xt,X,Qe="You’re all set for training with whichever training method you prefer!",Rt,F,Et,x,ze='<a href="https://hf.co/papers/2310.08659" rel="nofollow">LoftQ</a> initializes LoRA weights such that the quantization error is minimized, and it can improve performance when training quantized models. To get started, follow <a href="https://github.com/huggingface/peft/tree/main/examples/loftq_finetuning" rel="nofollow">these instructions</a>.',It,R,We="In general, for LoftQ to work best, it is recommended to target as many layers with LoRA as possible, since those not targeted cannot have LoftQ applied. This means that passing <code>LoraConfig(..., target_modules=&quot;all-linear&quot;)</code> will most likely give the best results. Also, you should use <code>nf4</code> as quant type in your quantization config when using 4bit quantization, i.e. <code>BitsAndBytesConfig(load_in_4bit=True, bnb_4bit_quant_type=&quot;nf4&quot;)</code>.",At,E,Gt,I,Ue="QLoRA adds trainable weights to all the linear layers in the transformer architecture. Since the attribute names for these linear layers can vary across architectures, set <code>target_modules</code> to <code>&quot;all-linear&quot;</code> to add LoRA to all the linear layers:",Ht,A,Nt,G,Vt,H,Xe='Additive Quantization of Language Models (<a href="https://arxiv.org/abs/2401.06118" rel="nofollow">AQLM</a>) is a Large Language Models compression method. It quantizes multiple weights together and takes advantage of interdependencies between them. AQLM represents groups of 8-16 weights as a sum of multiple vector codes. This allows it to compress models down to as low as 2-bit with considerably low accuracy losses.',Yt,N,Fe='Since the AQLM quantization process is computationally expensive, a use of prequantized models is recommended. A partial list of available models can be found in the official aqlm <a href="https://github.com/Vahe1994/AQLM" rel="nofollow">repository</a>.',Pt,V,xe="The models support LoRA adapter tuning. To tune the quantized model you’ll need to install the <code>aqlm</code> inference library: <code>pip install aqlm&gt;=1.0.2</code>. Finetuned LoRA adapters shall be saved separately, as merging them with AQLM quantized weights is not possible.",St,Y,Dt,P,Re='You can refer to the <a href="https://colab.research.google.com/drive/12GTp1FCj5_0SnnNQH18h_2XFh9vS_guX?usp=sharing" rel="nofollow">Google Colab</a> example for an overview of AQLM+LoRA finetuning.',Kt,S,Ot,D,Ee='You can also perform LoRA fine-tuning on EETQ quantized models. <a href="https://github.com/NetEase-FuXi/EETQ" rel="nofollow">EETQ</a> package offers simple and efficient way to perform 8-bit quantization, which is claimed to be faster than the <code>LLM.int8()</code> algorithm. First, make sure that you have a transformers version that is compatible with EETQ (e.g. by installing it from latest pypi or from source).',te,K,ee,O,Ie='Pass the <code>config</code> to the <a href="https://huggingface.co/docs/transformers/main/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a> method.',le,tt,ne,et,Ae="and create a <code>LoraConfig</code> and pass it to <code>get_peft_model</code>:",ae,lt,ie,nt,oe,at,Ge='The models that is quantized using Half-Quadratic Quantization of Large Machine Learning Models (<a href="https://mobiusml.github.io/hqq_blog/" rel="nofollow">HQQ</a>) support LoRA adapter tuning. To tune the quantized model, you’ll need to install the <code>hqq</code> library with: <code>pip install hqq</code>.',se,it,re,ot,He="Or using transformers version that is compatible with HQQ (e.g. by installing it from latest pypi or from source).",pe,st,me,rt,fe,pt,Ne='PEFT supports models quantized with <a href="https://github.com/pytorch/ao" rel="nofollow">torchao</a> (“ao”) for int8 quantization.',ue,mt,de,ft,he,ut,Ve="<li>Use the most recent versions of torchao and transformers for best results.</li> <li>Only linear layers are currently supported.</li> <li><code>quant_type = &quot;int4_weight_only&quot;</code> is currently not supported.</li> <li><code>NF4</code> is not implemented in transformers as of yet and is thus also not supported.</li> <li>DoRA only works with <code>quant_type = &quot;int8_weight_only&quot;</code> at the moment.</li> <li>There is explicit support for torchao when used with LoRA. However, when torchao quantizes a layer, its class does not change, only the type of the underlying tensor. For this reason, PEFT methods other than LoRA will generally also work with torchao, even if not explicitly supported. Be aware, however, that <strong>merging only works correctly with LoRA and with <code>quant_type = &quot;int8_weight_only&quot;</code></strong>. If you use a different PEFT method or dtype, merging will likely result in an error, and even it doesn’t, the results will still be incorrect.</li>",Me,dt,ce,ht,Ye="If you’re interested in learning more about quantization, the following may be helpful:",be,Mt,Pe='<li>Learn more about details about QLoRA and check out some benchmarks on its impact in the <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">Making LLMs even more accessible with bitsandbytes, 4-bit quantization and QLoRA</a> blog post.</li> <li>Read more about different quantization schemes in the Transformers <a href="https://hf.co/docs/transformers/main/quantization" rel="nofollow">Quantization</a> guide.</li>',ye,ct,we,yt,ge;return y=new c({props:{title:"Quantization",local:"quantization",headingTag:"h1"}}),_=new c({props:{title:"Quantize a model",local:"quantize-a-model",headingTag:"h2"}}),v=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
)`,wrap:!1}}),Z=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, quantization_config=config)`,wrap:!1}}),B=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nJTBBJTBBbW9kZWwlMjAlM0QlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nKG1vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> prepare_model_for_kbit_training

model = prepare_model_for_kbit_training(model)`,wrap:!1}}),k=new c({props:{title:"LoraConfig",local:"loraconfig",headingTag:"h2"}}),z=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTJDJTIwJTIydl9wcm9qJTIyJTJDJTIwJTIyb19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4wNSUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>],
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)`,wrap:!1}}),U=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBjb25maWcp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model

model = get_peft_model(model, config)`,wrap:!1}}),F=new c({props:{title:"LoftQ initialization",local:"loftq-initialization",headingTag:"h3"}}),E=new c({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),A=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4p",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...)',wrap:!1}}),G=new c({props:{title:"AQLM quantization",local:"aqlm-quantization",headingTag:"h2"}}),Y=new M({props:{code:"cXVhbnRpemVkX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkJsYWNrU2Ftb3JleiUyRk1peHRyYWwtOHg3Yi1BUUxNLTJCaXQtMXgxNi1oZi10ZXN0LWRpc3BhdGNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0QlMjJhdXRvJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUlMkMlMEEpJTBBJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiklMEElMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChxdWFudGl6ZWRfbW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyk=",highlighted:`quantized_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;BlackSamorez/Mixtral-8x7b-AQLM-2Bit-1x16-hf-test-dispatch&quot;</span>,
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, low_cpu_mem_usage=<span class="hljs-literal">True</span>,
)

peft_config = LoraConfig(...)

quantized_model = get_peft_model(quantized_model, peft_config)`,wrap:!1}}),S=new c({props:{title:"EETQ quantization",local:"eetq-quantization",headingTag:"h2"}}),K=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwRWV0cUNvbmZpZyUwQSUwQWNvbmZpZyUyMCUzRCUyMEVldHFDb25maWcoJTIyaW50OCUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> EetqConfig

config = EetqConfig(<span class="hljs-string">&quot;int8&quot;</span>)`,wrap:!1}}),tt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, quantization_config=config)`,wrap:!1}}),lt=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0Q4JTJDJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X21vZHVsZXMlM0QlNUIlMjJxX3Byb2olMjIlMkMlMjAlMjJrX3Byb2olMjIlMkMlMjAlMjJ2X3Byb2olMjIlMkMlMjAlMjJvX3Byb2olMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>],
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)

model = get_peft_model(model, config)`,wrap:!1}}),nt=new c({props:{title:"HQQ quantization",local:"hqq-quantization",headingTag:"h2"}}),it=new M({props:{code:"ZnJvbSUyMGhxcS5lbmdpbmUuaGYlMjBpbXBvcnQlMjBIUVFNb2RlbEZvckNhdXNhbExNJTBBJTBBcXVhbnRpemVkX21vZGVsJTIwJTNEJTIwSFFRTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3F1YW50aXplZChzYXZlX2Rpcl9vcl9oZmh1YiUyQyUyMGRldmljZSUzRCdjdWRhJyklMEFwZWZ0X2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcoLi4uKSUwQXF1YW50aXplZF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKHF1YW50aXplZF9tb2RlbCUyQyUyMHBlZnRfY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> hqq.engine.hf <span class="hljs-keyword">import</span> HQQModelForCausalLM

quantized_model = HQQModelForCausalLM.from_quantized(save_dir_or_hfhub, device=<span class="hljs-string">&#x27;cuda&#x27;</span>)
peft_config = LoraConfig(...)
quantized_model = get_peft_model(quantized_model, peft_config)`,wrap:!1}}),st=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEhxcUNvbmZpZyUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwSHFxQ29uZmlnKG5iaXRzJTNENCUyQyUyMGdyb3VwX3NpemUlM0Q2NCklMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoc2F2ZV9kaXJfb3JfaGZodWIlMkMlMjBkZXZpY2VfbWFwJTNEZGV2aWNlX21hcCUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWcpJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiklMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChxdWFudGl6ZWRfbW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HqqConfig, AutoModelForCausalLM

quant_config = HqqConfig(nbits=<span class="hljs-number">4</span>, group_size=<span class="hljs-number">64</span>)
quantized_model = AutoModelForCausalLM.from_pretrained(save_dir_or_hfhub, device_map=device_map, quantization_config=quant_config)
peft_config = LoraConfig(...)
quantized_model = get_peft_model(quantized_model, peft_config)`,wrap:!1}}),rt=new c({props:{title:"torchao (PyTorch Architecture Optimization)",local:"torchao-pytorch-architecture-optimization",headingTag:"h2"}}),mt=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBUb3JjaEFvQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAuLi4lMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwVG9yY2hBb0NvbmZpZyhxdWFudF90eXBlJTNEJTIyaW50OF93ZWlnaHRfb25seSUyMiklMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWcpJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiklMEFtb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, TorchAoConfig

model_id = ...
quantization_config = TorchAoConfig(quant_type=<span class="hljs-string">&quot;int8_weight_only&quot;</span>)
base_model = AutoModelForCausalLM.from_pretrained(model_id, quantization_config=quantization_config)
peft_config = LoraConfig(...)
model = get_peft_model(base_model, peft_config)`,wrap:!1}}),ft=new c({props:{title:"Caveats:",local:"caveats",headingTag:"h3"}}),dt=new c({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),ct=new il({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/quantization.md"}}),{c(){b=o("meta"),wt=a(),bt=o("p"),gt=a(),p(y.$$.fragment),Tt=a(),w=o("p"),w.textContent=Je,Jt=a(),g=o("ul"),g.innerHTML=_e,_t=a(),T=o("p"),T.innerHTML=$e,$t=a(),J=o("p"),J.textContent=qe,qt=a(),p(_.$$.fragment),vt=a(),$=o("p"),$.innerHTML=ve,jt=a(),q=o("ul"),q.innerHTML=je,Zt=a(),p(v.$$.fragment),Ct=a(),j=o("p"),j.innerHTML=Ze,Bt=a(),p(Z.$$.fragment),Lt=a(),C=o("p"),C.innerHTML=Ce,kt=a(),p(B.$$.fragment),Qt=a(),L=o("p"),L.textContent=Be,zt=a(),p(k.$$.fragment),Wt=a(),Q=o("p"),Q.innerHTML=Le,Ut=a(),p(z.$$.fragment),Xt=a(),W=o("p"),W.innerHTML=ke,Ft=a(),p(U.$$.fragment),xt=a(),X=o("p"),X.textContent=Qe,Rt=a(),p(F.$$.fragment),Et=a(),x=o("p"),x.innerHTML=ze,It=a(),R=o("p"),R.innerHTML=We,At=a(),p(E.$$.fragment),Gt=a(),I=o("p"),I.innerHTML=Ue,Ht=a(),p(A.$$.fragment),Nt=a(),p(G.$$.fragment),Vt=a(),H=o("p"),H.innerHTML=Xe,Yt=a(),N=o("p"),N.innerHTML=Fe,Pt=a(),V=o("p"),V.innerHTML=xe,St=a(),p(Y.$$.fragment),Dt=a(),P=o("p"),P.innerHTML=Re,Kt=a(),p(S.$$.fragment),Ot=a(),D=o("p"),D.innerHTML=Ee,te=a(),p(K.$$.fragment),ee=a(),O=o("p"),O.innerHTML=Ie,le=a(),p(tt.$$.fragment),ne=a(),et=o("p"),et.innerHTML=Ae,ae=a(),p(lt.$$.fragment),ie=a(),p(nt.$$.fragment),oe=a(),at=o("p"),at.innerHTML=Ge,se=a(),p(it.$$.fragment),re=a(),ot=o("p"),ot.textContent=He,pe=a(),p(st.$$.fragment),me=a(),p(rt.$$.fragment),fe=a(),pt=o("p"),pt.innerHTML=Ne,ue=a(),p(mt.$$.fragment),de=a(),p(ft.$$.fragment),he=a(),ut=o("ul"),ut.innerHTML=Ve,Me=a(),p(dt.$$.fragment),ce=a(),ht=o("p"),ht.textContent=Ye,be=a(),Mt=o("ul"),Mt.innerHTML=Pe,ye=a(),p(ct.$$.fragment),we=a(),yt=o("p"),this.h()},l(t){const e=nl("svelte-u9bgzb",document.head);b=s(e,"META",{name:!0,content:!0}),e.forEach(l),wt=i(t),bt=s(t,"P",{}),Se(bt).forEach(l),gt=i(t),m(y.$$.fragment,t),Tt=i(t),w=s(t,"P",{"data-svelte-h":!0}),r(w)!=="svelte-famg4s"&&(w.textContent=Je),Jt=i(t),g=s(t,"UL",{"data-svelte-h":!0}),r(g)!=="svelte-27c91"&&(g.innerHTML=_e),_t=i(t),T=s(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-142xot4"&&(T.innerHTML=$e),$t=i(t),J=s(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1demhiu"&&(J.textContent=qe),qt=i(t),m(_.$$.fragment,t),vt=i(t),$=s(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-p0gbf4"&&($.innerHTML=ve),jt=i(t),q=s(t,"UL",{"data-svelte-h":!0}),r(q)!=="svelte-hfynw8"&&(q.innerHTML=je),Zt=i(t),m(v.$$.fragment,t),Ct=i(t),j=s(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-pxonbi"&&(j.innerHTML=Ze),Bt=i(t),m(Z.$$.fragment,t),Lt=i(t),C=s(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1i20kxq"&&(C.innerHTML=Ce),kt=i(t),m(B.$$.fragment,t),Qt=i(t),L=s(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-11mx7fc"&&(L.textContent=Be),zt=i(t),m(k.$$.fragment,t),Wt=i(t),Q=s(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-16xpk8c"&&(Q.innerHTML=Le),Ut=i(t),m(z.$$.fragment,t),Xt=i(t),W=s(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-rnh6oi"&&(W.innerHTML=ke),Ft=i(t),m(U.$$.fragment,t),xt=i(t),X=s(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-xd402n"&&(X.textContent=Qe),Rt=i(t),m(F.$$.fragment,t),Et=i(t),x=s(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-f32n60"&&(x.innerHTML=ze),It=i(t),R=s(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-7f0aai"&&(R.innerHTML=We),At=i(t),m(E.$$.fragment,t),Gt=i(t),I=s(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1c7jiea"&&(I.innerHTML=Ue),Ht=i(t),m(A.$$.fragment,t),Nt=i(t),m(G.$$.fragment,t),Vt=i(t),H=s(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-h7ytse"&&(H.innerHTML=Xe),Yt=i(t),N=s(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-120mr43"&&(N.innerHTML=Fe),Pt=i(t),V=s(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-wlm3ol"&&(V.innerHTML=xe),St=i(t),m(Y.$$.fragment,t),Dt=i(t),P=s(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1f1bzer"&&(P.innerHTML=Re),Kt=i(t),m(S.$$.fragment,t),Ot=i(t),D=s(t,"P",{"data-svelte-h":!0}),r(D)!=="svelte-16tz5mo"&&(D.innerHTML=Ee),te=i(t),m(K.$$.fragment,t),ee=i(t),O=s(t,"P",{"data-svelte-h":!0}),r(O)!=="svelte-pxonbi"&&(O.innerHTML=Ie),le=i(t),m(tt.$$.fragment,t),ne=i(t),et=s(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1wgonl8"&&(et.innerHTML=Ae),ae=i(t),m(lt.$$.fragment,t),ie=i(t),m(nt.$$.fragment,t),oe=i(t),at=s(t,"P",{"data-svelte-h":!0}),r(at)!=="svelte-17kgu1v"&&(at.innerHTML=Ge),se=i(t),m(it.$$.fragment,t),re=i(t),ot=s(t,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-p9acs7"&&(ot.textContent=He),pe=i(t),m(st.$$.fragment,t),me=i(t),m(rt.$$.fragment,t),fe=i(t),pt=s(t,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-gynv46"&&(pt.innerHTML=Ne),ue=i(t),m(mt.$$.fragment,t),de=i(t),m(ft.$$.fragment,t),he=i(t),ut=s(t,"UL",{"data-svelte-h":!0}),r(ut)!=="svelte-8jswii"&&(ut.innerHTML=Ve),Me=i(t),m(dt.$$.fragment,t),ce=i(t),ht=s(t,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-agdyn7"&&(ht.textContent=Ye),be=i(t),Mt=s(t,"UL",{"data-svelte-h":!0}),r(Mt)!=="svelte-83nivc"&&(Mt.innerHTML=Pe),ye=i(t),m(ct.$$.fragment,t),we=i(t),yt=s(t,"P",{}),Se(yt).forEach(l),this.h()},h(){De(b,"name","hf:doc:metadata"),De(b,"content",sl)},m(t,e){al(document.head,b),n(t,wt,e),n(t,bt,e),n(t,gt,e),f(y,t,e),n(t,Tt,e),n(t,w,e),n(t,Jt,e),n(t,g,e),n(t,_t,e),n(t,T,e),n(t,$t,e),n(t,J,e),n(t,qt,e),f(_,t,e),n(t,vt,e),n(t,$,e),n(t,jt,e),n(t,q,e),n(t,Zt,e),f(v,t,e),n(t,Ct,e),n(t,j,e),n(t,Bt,e),f(Z,t,e),n(t,Lt,e),n(t,C,e),n(t,kt,e),f(B,t,e),n(t,Qt,e),n(t,L,e),n(t,zt,e),f(k,t,e),n(t,Wt,e),n(t,Q,e),n(t,Ut,e),f(z,t,e),n(t,Xt,e),n(t,W,e),n(t,Ft,e),f(U,t,e),n(t,xt,e),n(t,X,e),n(t,Rt,e),f(F,t,e),n(t,Et,e),n(t,x,e),n(t,It,e),n(t,R,e),n(t,At,e),f(E,t,e),n(t,Gt,e),n(t,I,e),n(t,Ht,e),f(A,t,e),n(t,Nt,e),f(G,t,e),n(t,Vt,e),n(t,H,e),n(t,Yt,e),n(t,N,e),n(t,Pt,e),n(t,V,e),n(t,St,e),f(Y,t,e),n(t,Dt,e),n(t,P,e),n(t,Kt,e),f(S,t,e),n(t,Ot,e),n(t,D,e),n(t,te,e),f(K,t,e),n(t,ee,e),n(t,O,e),n(t,le,e),f(tt,t,e),n(t,ne,e),n(t,et,e),n(t,ae,e),f(lt,t,e),n(t,ie,e),f(nt,t,e),n(t,oe,e),n(t,at,e),n(t,se,e),f(it,t,e),n(t,re,e),n(t,ot,e),n(t,pe,e),f(st,t,e),n(t,me,e),f(rt,t,e),n(t,fe,e),n(t,pt,e),n(t,ue,e),f(mt,t,e),n(t,de,e),f(ft,t,e),n(t,he,e),n(t,ut,e),n(t,Me,e),f(dt,t,e),n(t,ce,e),n(t,ht,e),n(t,be,e),n(t,Mt,e),n(t,ye,e),f(ct,t,e),n(t,we,e),n(t,yt,e),ge=!0},p:Oe,i(t){ge||(u(y.$$.fragment,t),u(_.$$.fragment,t),u(v.$$.fragment,t),u(Z.$$.fragment,t),u(B.$$.fragment,t),u(k.$$.fragment,t),u(z.$$.fragment,t),u(U.$$.fragment,t),u(F.$$.fragment,t),u(E.$$.fragment,t),u(A.$$.fragment,t),u(G.$$.fragment,t),u(Y.$$.fragment,t),u(S.$$.fragment,t),u(K.$$.fragment,t),u(tt.$$.fragment,t),u(lt.$$.fragment,t),u(nt.$$.fragment,t),u(it.$$.fragment,t),u(st.$$.fragment,t),u(rt.$$.fragment,t),u(mt.$$.fragment,t),u(ft.$$.fragment,t),u(dt.$$.fragment,t),u(ct.$$.fragment,t),ge=!0)},o(t){d(y.$$.fragment,t),d(_.$$.fragment,t),d(v.$$.fragment,t),d(Z.$$.fragment,t),d(B.$$.fragment,t),d(k.$$.fragment,t),d(z.$$.fragment,t),d(U.$$.fragment,t),d(F.$$.fragment,t),d(E.$$.fragment,t),d(A.$$.fragment,t),d(G.$$.fragment,t),d(Y.$$.fragment,t),d(S.$$.fragment,t),d(K.$$.fragment,t),d(tt.$$.fragment,t),d(lt.$$.fragment,t),d(nt.$$.fragment,t),d(it.$$.fragment,t),d(st.$$.fragment,t),d(rt.$$.fragment,t),d(mt.$$.fragment,t),d(ft.$$.fragment,t),d(dt.$$.fragment,t),d(ct.$$.fragment,t),ge=!1},d(t){t&&(l(wt),l(bt),l(gt),l(Tt),l(w),l(Jt),l(g),l(_t),l(T),l($t),l(J),l(qt),l(vt),l($),l(jt),l(q),l(Zt),l(Ct),l(j),l(Bt),l(Lt),l(C),l(kt),l(Qt),l(L),l(zt),l(Wt),l(Q),l(Ut),l(Xt),l(W),l(Ft),l(xt),l(X),l(Rt),l(Et),l(x),l(It),l(R),l(At),l(Gt),l(I),l(Ht),l(Nt),l(Vt),l(H),l(Yt),l(N),l(Pt),l(V),l(St),l(Dt),l(P),l(Kt),l(Ot),l(D),l(te),l(ee),l(O),l(le),l(ne),l(et),l(ae),l(ie),l(oe),l(at),l(se),l(re),l(ot),l(pe),l(me),l(fe),l(pt),l(ue),l(de),l(he),l(ut),l(Me),l(ce),l(ht),l(be),l(Mt),l(ye),l(we),l(yt)),l(b),h(y,t),h(_,t),h(v,t),h(Z,t),h(B,t),h(k,t),h(z,t),h(U,t),h(F,t),h(E,t),h(A,t),h(G,t),h(Y,t),h(S,t),h(K,t),h(tt,t),h(lt,t),h(nt,t),h(it,t),h(st,t),h(rt,t),h(mt,t),h(ft,t),h(dt,t),h(ct,t)}}}const sl='{"title":"Quantization","local":"quantization","sections":[{"title":"Quantize a model","local":"quantize-a-model","sections":[],"depth":2},{"title":"LoraConfig","local":"loraconfig","sections":[{"title":"LoftQ initialization","local":"loftq-initialization","sections":[],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3}],"depth":2},{"title":"AQLM quantization","local":"aqlm-quantization","sections":[],"depth":2},{"title":"EETQ quantization","local":"eetq-quantization","sections":[],"depth":2},{"title":"HQQ quantization","local":"hqq-quantization","sections":[],"depth":2},{"title":"torchao (PyTorch Architecture Optimization)","local":"torchao-pytorch-architecture-optimization","sections":[{"title":"Caveats:","local":"caveats","sections":[],"depth":3}],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function rl(Te){return tl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dl extends el{constructor(b){super(),ll(this,b,rl,ol,Ke,{})}}export{dl as component};
