import{s as Ke,o as Oe,n as je}from"../chunks/scheduler.f6b352c8.js";import{S as tl,i as sl,g as p,s as n,r as M,A as el,h as o,f as e,c as a,j as Ht,u as j,x as c,k as Le,y as $,a as l,v as y,d as J,t as h,w as T}from"../chunks/index.b90df637.js";import{T as ll}from"../chunks/Tip.366d2e6e.js";import{C as d}from"../chunks/CodeBlock.e5718f9d.js";import{H as f,E as nl}from"../chunks/index.b1d6a402.js";import{H as al,a as De}from"../chunks/HfOption.6047630d.js";function pl(I){let r,C="The MCP specification is still evolving, so the configuration methods are subject to evolution. We’ll focus on the current best practices for configuration.";return{c(){r=p("p"),r.textContent=C},l(m){r=o(m,"P",{"data-svelte-h":!0}),c(r)!=="svelte-n56el2"&&(r.textContent=C)},m(m,U){l(m,r,U)},p:je,d(m){m&&e(r)}}}function ol(I){let r,C="In Python, we use the <code>os</code> module to access environment variables:",m,U,u;return U=new d({props:{code:"aW1wb3J0JTIwb3MlMEElMEElMjMlMjBBY2Nlc3MlMjBlbnZpcm9ubWVudCUyMHZhcmlhYmxlcyUwQWdpdGh1Yl90b2tlbiUyMCUzRCUyMG9zLmVudmlyb24uZ2V0KCUyMkdJVEhVQl9UT0tFTiUyMiklMEFpZiUyMG5vdCUyMGdpdGh1Yl90b2tlbiUzQSUwQSUyMCUyMCUyMCUyMHJhaXNlJTIwVmFsdWVFcnJvciglMjJHSVRIVUJfVE9LRU4lMjBlbnZpcm9ubWVudCUyMHZhcmlhYmxlJTIwaXMlMjByZXF1aXJlZCUyMiklMEElMEElMjMlMjBVc2UlMjB0aGUlMjB0b2tlbiUyMGluJTIweW91ciUyMHNlcnZlciUyMGNvZGUlMEFkZWYlMjBtYWtlX2dpdGh1Yl9yZXF1ZXN0KCklM0ElMEElMjAlMjAlMjAlMjBoZWFkZXJzJTIwJTNEJTIwJTdCJTIyQXV0aG9yaXphdGlvbiUyMiUzQSUyMGYlMjJCZWFyZXIlMjAlN0JnaXRodWJfdG9rZW4lN0QlMjIlN0QlMEElMjAlMjAlMjAlMjAlMjMlMjAuLi4lMjByZXN0JTIwb2YlMjB5b3VyJTIwY29kZQ==",highlighted:`<span class="hljs-keyword">import</span> os

<span class="hljs-comment"># Access environment variables</span>
github_token = os.environ.get(<span class="hljs-string">&quot;GITHUB_TOKEN&quot;</span>)
<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> github_token:
    <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">&quot;GITHUB_TOKEN environment variable is required&quot;</span>)

<span class="hljs-comment"># Use the token in your server code</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">make_github_request</span>():
    headers = {<span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{github_token}</span>&quot;</span>}
    <span class="hljs-comment"># ... rest of your code</span>`,wrap:!1}}),{c(){r=p("p"),r.innerHTML=C,m=n(),M(U.$$.fragment)},l(i){r=o(i,"P",{"data-svelte-h":!0}),c(r)!=="svelte-8jwuh1"&&(r.innerHTML=C),m=a(i),j(U.$$.fragment,i)},m(i,w){l(i,r,w),l(i,m,w),y(U,i,w),u=!0},p:je,i(i){u||(J(U.$$.fragment,i),u=!0)},o(i){h(U.$$.fragment,i),u=!1},d(i){i&&(e(r),e(m)),T(U,i)}}}function il(I){let r,C="In JavaScript, we use the <code>process.env</code> object to access environment variables:",m,U,u;return U=new d({props:{code:"JTJGJTJGJTIwQWNjZXNzJTIwZW52aXJvbm1lbnQlMjB2YXJpYWJsZXMlMEFjb25zdCUyMGdpdGh1YlRva2VuJTIwJTNEJTIwcHJvY2Vzcy5lbnYuR0lUSFVCX1RPS0VOJTNCJTBBaWYlMjAoIWdpdGh1YlRva2VuKSUyMCU3QiUwQSUyMCUyMCUyMCUyMHRocm93JTIwbmV3JTIwRXJyb3IoJTIyR0lUSFVCX1RPS0VOJTIwZW52aXJvbm1lbnQlMjB2YXJpYWJsZSUyMGlzJTIwcmVxdWlyZWQlMjIpJTNCJTBBJTdEJTBBJTBBJTJGJTJGJTIwVXNlJTIwdGhlJTIwdG9rZW4lMjBpbiUyMHlvdXIlMjBzZXJ2ZXIlMjBjb2RlJTBBZnVuY3Rpb24lMjBtYWtlR2l0aHViUmVxdWVzdCgpJTIwJTdCJTBBJTIwJTIwJTIwJTIwY29uc3QlMjBoZWFkZXJzJTIwJTNEJTIwJTdCJTIwJTIyQXV0aG9yaXphdGlvbiUyMiUzQSUyMCU2MEJlYXJlciUyMCUyNCU3QmdpdGh1YlRva2VuJTdEJTYwJTIwJTdEJTNCJTBBJTIwJTIwJTIwJTIwJTJGJTJGJTIwLi4uJTIwcmVzdCUyMG9mJTIweW91ciUyMGNvZGUlMEElN0Q=",highlighted:`<span class="hljs-comment">// Access environment variables</span>
<span class="hljs-keyword">const</span> githubToken = process.<span class="hljs-property">env</span>.<span class="hljs-property">GITHUB_TOKEN</span>;
<span class="hljs-keyword">if</span> (!githubToken) {
    <span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;GITHUB_TOKEN environment variable is required&quot;</span>);
}

<span class="hljs-comment">// Use the token in your server code</span>
<span class="hljs-keyword">function</span> <span class="hljs-title function_">makeGithubRequest</span>(<span class="hljs-params"></span>) {
    <span class="hljs-keyword">const</span> headers = { <span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">\`Bearer <span class="hljs-subst">\${githubToken}</span>\`</span> };
    <span class="hljs-comment">// ... rest of your code</span>
}`,wrap:!1}}),{c(){r=p("p"),r.innerHTML=C,m=n(),M(U.$$.fragment)},l(i){r=o(i,"P",{"data-svelte-h":!0}),c(r)!=="svelte-1554qq7"&&(r.innerHTML=C),m=a(i),j(U.$$.fragment,i)},m(i,w){l(i,r,w),l(i,m,w),y(U,i,w),u=!0},p:je,i(i){u||(J(U.$$.fragment,i),u=!0)},o(i){h(U.$$.fragment,i),u=!1},d(i){i&&(e(r),e(m)),T(U,i)}}}function rl(I){let r,C,m,U;return r=new De({props:{id:"env-variables",option:"python",$$slots:{default:[ol]},$$scope:{ctx:I}}}),m=new De({props:{id:"env-variables",option:"javascript",$$slots:{default:[il]},$$scope:{ctx:I}}}),{c(){M(r.$$.fragment),C=n(),M(m.$$.fragment)},l(u){j(r.$$.fragment,u),C=a(u),j(m.$$.fragment,u)},m(u,i){y(r,u,i),l(u,C,i),y(m,u,i),U=!0},p(u,i){const w={};i&2&&(w.$$scope={dirty:i,ctx:u}),r.$set(w);const Yt={};i&2&&(Yt.$$scope={dirty:i,ctx:u}),m.$set(Yt)},i(u){U||(J(r.$$.fragment,u),J(m.$$.fragment,u),U=!0)},o(u){h(r.$$.fragment,u),h(m.$$.fragment,u),U=!1},d(u){u&&e(C),T(r,u),T(m,u)}}}function cl(I){let r,C,m,U,u,i,w,Yt="Now that we have a basic understanding of the Model Context Protocol, we can explore the essential role of MCP Clients in the Model Context Protocol ecosystem.",Ft,Z,ye="In this part of Unit 1, we’ll explore the essential role of MCP Clients in the Model Context Protocol ecosystem.",Lt,q,Je="In this section, you will:",Dt,G,he="<li>Understand what MCP Clients are and their role in the MCP architecture</li> <li>Learn about the key responsibilities of MCP Clients</li> <li>Explore the major MCP Client implementations</li> <li>Discover how to use Hugging Face’s MCP Client implementation</li> <li>See practical examples of MCP Client usage</li>",Kt,x,Ot,V,Te="MCP Clients are crucial components that act as the bridge between AI applications (Hosts) and external capabilities provided by MCP Servers. Think of the Host as your main application (like an AI assistant or IDE) and the Client as a specialized module within that Host responsible for handling MCP communications.",ts,S,ss,k,me="Let’s start by exploring the user interface clients that are available for the MCP.",es,Q,ls,_,Ue="Anthropic’s Claude Desktop stands as one of the most prominent MCP Clients, providing integration with various MCP Servers.",ns,X,as,R,Ce="Cursor’s MCP Client implementation enables AI-powered coding assistance through direct integration with code editing capabilities. It supports multiple MCP Server connections and provides real-time tool invocation during coding, making it a powerful tool for developers.",ps,N,we="Continue.dev is another example of an interactive development client that supports MCP and connects to an MCP server from VS Code.",os,W,is,P,fe="Now that we’ve covered the core of the MCP protocol, let’s look at how to configure your MCP servers and clients.",rs,H,de="Effective deployment of MCP servers and clients requires proper configuration.",cs,v,us,Y,Ms,z,Ie="MCP hosts use configuration files to manage server connections. These files define which servers are available and how to connect to them.",js,F,$e="Fortunately, the configuration files are very simple, easy to understand, and consistent across major MCP hosts.",ys,L,Js,D,ve="The standard configuration file for MCP is named <code>mcp.json</code>. Here’s the basic structure:",hs,K,Ts,O,be="In this example, we have a single server with a name and a transport type. The transport type is either <code>stdio</code> or <code>sse</code>.",ms,tt,Us,st,ge="For local servers using stdio transport, the configuration includes the command and arguments to launch the server process:",Cs,et,ws,lt,Be="Here, we have a server called “File Explorer” that is a local script.",fs,nt,ds,at,Ee="For remote servers using HTTP+SSE transport, the configuration includes the server URL:",Is,pt,$s,ot,vs,it,Ae="Environment variables can be passed to server processes using the <code>env</code> field. Here’s how to access them in your server code:",bs,b,gs,rt,Ze="The corresponding configuration in <code>mcp.json</code> would look like this:",Bs,ct,Es,ut,As,Mt,qe="Let’s look at some real-world configuration scenarios:",Zs,jt,qs,yt,Ge="In this scenario, we have a local server that is a Python script which could be a file explorer or a code editor.",Gs,Jt,xs,ht,Vs,Tt,xe="In this scenario, we have a remote server that is a weather API.",Ss,mt,ks,Ut,Ve="Proper configuration is essential for successfully deploying MCP integrations. By understanding these aspects, you can create robust and reliable connections between AI applications and external capabilities.",Qs,Ct,Se="In the next section, we’ll explore the ecosystem of MCP servers available on Hugging Face Hub and how to publish your own servers there.",_s,wt,Xs,ft,ke="You can also use the MCP Client in within code so that the tools are available to the LLM. Let’s explore some examples in <code>smolagents</code>.",Rs,dt,Qe="First, let’s explore our weather server from the previous page. In <code>smolagents</code>, we can use the <code>ToolCollection</code> class to automatically discover and register tools from an MCP server. This is done by passing the <code>StdioServerParameters</code> or <code>SSEServerParameters</code> to the <code>ToolCollection.from_mcp</code> method. We can then print the tools to the console.",Ns,It,Ws,g,Rt,_e="Output",re,$t,Ps,vt,Xe="We can also connect to an MCP server that is hosted on a remote machine. In this case, we need to pass the <code>SSEServerParameters</code> to the <code>MCPClient</code> class.",Hs,bt,Ys,B,Nt,Re="Output",ce,gt,zs,Bt,Ne="Now, let’s see how we can use the MCP Client in a code agent.",Fs,Et,Ls,E,Wt,We="Output",ue,At,Ds,Zt,Pe="We can also connect to an MCP package. Here’s an example of connecting to the <code>pubmedmcp</code> package.",Ks,qt,Os,A,Pt,He="Output",Me,Gt,te,xt,se,Vt,Ye="Now that you understand MCP Clients, you’re ready to:",ee,St,ze="<li>Explore specific MCP Server implementations</li> <li>Learn about creating custom MCP Clients</li> <li>Dive into advanced MCP integration patterns</li>",le,kt,Fe="Let’s continue our journey into the world of Model Context Protocol!",ne,Qt,ae,zt,pe;return u=new f({props:{title:"MCP Clients",local:"mcp-clients",headingTag:"h1"}}),x=new f({props:{title:"Understanding MCP Clients",local:"understanding-mcp-clients",headingTag:"h2"}}),S=new f({props:{title:"User Interface Client",local:"user-interface-client",headingTag:"h2"}}),Q=new f({props:{title:"Chat Interface Clients",local:"chat-interface-clients",headingTag:"h3"}}),X=new f({props:{title:"Interactive Development Clients",local:"interactive-development-clients",headingTag:"h3"}}),W=new f({props:{title:"Configuring MCP Clients",local:"configuring-mcp-clients",headingTag:"h2"}}),v=new ll({props:{$$slots:{default:[pl]},$$scope:{ctx:I}}}),Y=new f({props:{title:"MCP Configuration Files",local:"mcp-configuration-files",headingTag:"h3"}}),L=new f({props:{title:"mcp.json Structure",local:"mcpjson-structure",headingTag:"h4"}}),K=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyc2VydmVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJTZXJ2ZXIlMjBOYW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIydHJhbnNwb3J0JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnN0ZGlvJTdDc3NlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTJGJTJGJTIwVHJhbnNwb3J0LXNwZWNpZmljJTIwY29uZmlndXJhdGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;servers&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Server Name&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;transport&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;stdio|sse&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-comment">// Transport-specific configuration</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),tt=new f({props:{title:"Configuration for stdio Transport",local:"configuration-for-stdio-transport",headingTag:"h4"}}),et=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyc2VydmVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJGaWxlJTIwRXhwbG9yZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0cmFuc3BvcnQlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyc3RkaW8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb21tYW5kJTIyJTNBJTIwJTIycHl0aG9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJncyUyMiUzQSUyMCU1QiUyMiUyRnBhdGglMkZ0byUyRmZpbGVfZXhwbG9yZXJfc2VydmVyLnB5JTIyJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTVEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;servers&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;File Explorer&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;transport&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;stdio&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;command&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;python&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;args&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;/path/to/file_explorer_server.py&quot;</span><span class="hljs-punctuation">]</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),nt=new f({props:{title:"Configuration for HTTP+SSE Transport",local:"configuration-for-httpsse-transport",headingTag:"h4"}}),pt=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyc2VydmVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJSZW1vdGUlMjBBUEklMjBTZXJ2ZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0cmFuc3BvcnQlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyc3NlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydXJsJTIyJTNBJTIwJTIyaHR0cHMlM0ElMkYlMkZleGFtcGxlLmNvbSUyRm1jcC1zZXJ2ZXIlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlNUQlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;servers&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Remote API Server&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;transport&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;sse&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;url&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;https://example.com/mcp-server&quot;</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ot=new f({props:{title:"Environment Variables in Configuration",local:"environment-variables-in-configuration",headingTag:"h4"}}),b=new al({props:{id:"env-variables",options:["python","javascript"],$$slots:{default:[rl]},$$scope:{ctx:I}}}),ct=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyc2VydmVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJHaXRIdWIlMjBBUEklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0cmFuc3BvcnQlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyc3RkaW8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb21tYW5kJTIyJTNBJTIwJTIycHl0aG9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJncyUyMiUzQSUyMCU1QiUyMiUyRnBhdGglMkZ0byUyRmdpdGh1Yl9zZXJ2ZXIucHklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbnYlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJHSVRIVUJfVE9LRU4lMjIlM0ElMjAlMjJ5b3VyX2dpdGh1Yl90b2tlbiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;servers&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;GitHub API&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;transport&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;stdio&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;command&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;python&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;args&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;/path/to/github_server.py&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;GITHUB_TOKEN&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;your_github_token&quot;</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ut=new f({props:{title:"Configuration Examples",local:"configuration-examples",headingTag:"h3"}}),jt=new f({props:{title:"Scenario 1: Local Server Configuration",local:"scenario-1-local-server-configuration",headingTag:"h4"}}),Jt=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyc2VydmVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJGaWxlJTIwRXhwbG9yZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0cmFuc3BvcnQlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyc3RkaW8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb21tYW5kJTIyJTNBJTIwJTIycHl0aG9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJncyUyMiUzQSUyMCU1QiUyMiUyRnBhdGglMkZ0byUyRmZpbGVfZXhwbG9yZXJfc2VydmVyLnB5JTIyJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTVEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;servers&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;File Explorer&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;transport&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;stdio&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;command&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;python&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;args&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;/path/to/file_explorer_server.py&quot;</span><span class="hljs-punctuation">]</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ht=new f({props:{title:"Scenario 2: Remote Server Configuration",local:"scenario-2-remote-server-configuration",headingTag:"h4"}}),mt=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyc2VydmVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJXZWF0aGVyJTIwQVBJJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIydHJhbnNwb3J0JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnNzZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVybCUyMiUzQSUyMCUyMmh0dHBzJTNBJTJGJTJGZXhhbXBsZS5jb20lMkZtY3Atc2VydmVyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTVEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;servers&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Weather API&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;transport&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;sse&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;url&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;https://example.com/mcp-server&quot;</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),wt=new f({props:{title:"Code Clients",local:"code-clients",headingTag:"h2"}}),It=new d({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQWZyb20lMjBtY3AuY2xpZW50LnN0ZGlvJTIwaW1wb3J0JTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTBBJTBBc2VydmVyX3BhcmFtZXRlcnMlMjAlM0QlMjBTdGRpb1NlcnZlclBhcmFtZXRlcnMoY29tbWFuZCUzRCUyMnV2JTIyJTJDJTIwYXJncyUzRCU1QiUyMnJ1biUyMiUyQyUyMCUyMnNlcnZlci5weSUyMiU1RCklMEElMEF3aXRoJTIwVG9vbENvbGxlY3Rpb24uZnJvbV9tY3AoJTBBJTIwJTIwJTIwJTIwc2VydmVyX3BhcmFtZXRlcnMlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEpJTIwYXMlMjB0b29scyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMiU1Q24lMjIuam9pbihmJTIyJTdCdG9vbC5uYW1lJTdEJTNBJTIwJTdCdG9vbC5kZXNjcmlwdGlvbiU3RCUyMiUyMGZvciUyMHRvb2wlMjBpbiUyMHRvb2xzLnRvb2xzKSklMEE=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent
<span class="hljs-keyword">from</span> mcp.client.stdio <span class="hljs-keyword">import</span> StdioServerParameters

server_parameters = StdioServerParameters(command=<span class="hljs-string">&quot;uv&quot;</span>, args=[<span class="hljs-string">&quot;run&quot;</span>, <span class="hljs-string">&quot;server.py&quot;</span>])

<span class="hljs-keyword">with</span> ToolCollection.from_mcp(
    server_parameters, trust_remote_code=<span class="hljs-literal">True</span>
) <span class="hljs-keyword">as</span> tools:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n&quot;</span>.join(<span class="hljs-string">f&quot;<span class="hljs-subst">{tool.name}</span>: <span class="hljs-subst">{tool.description}</span>&quot;</span> <span class="hljs-keyword">for</span> tool <span class="hljs-keyword">in</span> tools.tools))
`,wrap:!1}}),$t=new d({props:{code:"V2VhdGhlciUyMEFQSSUzQSUyMEdldCUyMHRoZSUyMHdlYXRoZXIlMjBpbiUyMGElMjBzcGVjaWZpYyUyMGxvY2F0aW9uJTBB",highlighted:`Weather API: Get the weather <span class="hljs-keyword">in</span> a specific location
`,wrap:!1}}),bt=new d({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMubWNwX2NsaWVudCUyMGltcG9ydCUyME1DUENsaWVudCUwQSUwQXdpdGglMjBNQ1BDbGllbnQoJTBBJTIwJTIwJTIwJTIwJTdCJTIydXJsJTIyJTNBJTIwJTIyaHR0cHMlM0ElMkYlMkZhYmlkbGFicy1tY3AtdG9vbHMuaGYuc3BhY2UlMkZncmFkaW9fYXBpJTJGbWNwJTJGc3NlJTIyJTdEJTBBKSUyMGFzJTIwdG9vbHMlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBUb29scyUyMGZyb20lMjB0aGUlMjByZW1vdGUlMjBzZXJ2ZXIlMjBhcmUlMjBhdmFpbGFibGUlMEElMjAlMjAlMjAlMjBwcmludCglMjIlNUNuJTIyLmpvaW4oZiUyMiU3QnQubmFtZSU3RCUzQSUyMCU3QnQuZGVzY3JpcHRpb24lN0QlMjIlMjBmb3IlMjB0JTIwaW4lMjB0b29scykp",highlighted:`<span class="hljs-keyword">from</span> smolagents.mcp_client <span class="hljs-keyword">import</span> MCPClient

<span class="hljs-keyword">with</span> MCPClient(
    {<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://abidlabs-mcp-tools.hf.space/gradio_api/mcp/sse&quot;</span>}
) <span class="hljs-keyword">as</span> tools:
    <span class="hljs-comment"># Tools from the remote server are available</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n&quot;</span>.join(<span class="hljs-string">f&quot;<span class="hljs-subst">{t.name}</span>: <span class="hljs-subst">{t.description}</span>&quot;</span> <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> tools))`,wrap:!1}}),gt=new d({props:{code:"cHJpbWVfZmFjdG9ycyUzQSUyMENvbXB1dGUlMjB0aGUlMjBwcmltZSUyMGZhY3Rvcml6YXRpb24lMjBvZiUyMGElMjBwb3NpdGl2ZSUyMGludGVnZXIuJTBBZ2VuZXJhdGVfY2hlZXRhaF9pbWFnZSUzQSUyMEdlbmVyYXRlJTIwYSUyMGNoZWV0YWglMjBpbWFnZS4lMEFpbWFnZV9vcmllbnRhdGlvbiUzQSUyMFJldHVybnMlMjB3aGV0aGVyJTIwaW1hZ2UlMjBpcyUyMHBvcnRyYWl0JTIwb3IlMjBsYW5kc2NhcGUuJTBBc2VwaWElM0ElMjBBcHBseSUyMGElMjBzZXBpYSUyMGZpbHRlciUyMHRvJTIwdGhlJTIwaW5wdXQlMjBpbWFnZS4=",highlighted:`prime_factors: Compute the prime factorization of a positive <span class="hljs-built_in">integer</span>.
generate_cheetah_image: Generate a cheetah image.
image_orientation: Returns whether image is portrait or landscape.
sepia: Apply a sepia filter to the input image.`,wrap:!1}}),Et=new d({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUyQyUyMFRvb2xDb2xsZWN0aW9uJTBBZnJvbSUyMG1jcC5jbGllbnQuc3RkaW8lMjBpbXBvcnQlMjBTdGRpb1NlcnZlclBhcmFtZXRlcnMlMEElMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKCklMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyhjb21tYW5kJTNEJTIydXYlMjIlMkMlMjBhcmdzJTNEJTVCJTIycnVuJTIyJTJDJTIwJTIyc2VydmVyLnB5JTIyJTVEKSUwQSUwQXdpdGglMjBUb29sQ29sbGVjdGlvbi5mcm9tX21jcCglMEElMjAlMjAlMjAlMjBzZXJ2ZXJfcGFyYW1ldGVycyUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUwQSklMjBhcyUyMHRvb2xfY29sbGVjdGlvbiUzQSUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCKnRvb2xfY29sbGVjdGlvbi50b29scyU1RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBJTIwJTIwJTIwJTIwYWdlbnQucnVuKCUyMldoYXQncyUyMHRoZSUyMHdlYXRoZXIlMjBpbiUyMFRva3lvJTNGJTIyKSUwQQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent, ToolCollection
<span class="hljs-keyword">from</span> mcp.client.stdio <span class="hljs-keyword">import</span> StdioServerParameters

model = InferenceClientModel()

server_parameters = StdioServerParameters(command=<span class="hljs-string">&quot;uv&quot;</span>, args=[<span class="hljs-string">&quot;run&quot;</span>, <span class="hljs-string">&quot;server.py&quot;</span>])

<span class="hljs-keyword">with</span> ToolCollection.from_mcp(
    server_parameters, trust_remote_code=<span class="hljs-literal">True</span>
) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], model=model)
    agent.run(<span class="hljs-string">&quot;What&#x27;s the weather in Tokyo?&quot;</span>)
`,wrap:!1}}),At=new d({props:{code:"VGhlJTIwd2VhdGhlciUyMGluJTIwVG9reW8lMjBpcyUyMHN1bm55JTIwd2l0aCUyMGElMjB0ZW1wZXJhdHVyZSUyMG9mJTIwMjAlMjBkZWdyZWVzJTIwQ2Vsc2l1cy4=",highlighted:'The weather <span class="hljs-keyword">in</span> Tokyo is sunny with a temperature of 20 degrees Celsius.',wrap:!1}}),qt=new d({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQWZyb20lMjBtY3AlMjBpbXBvcnQlMjBTdGRpb1NlcnZlclBhcmFtZXRlcnMlMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXYlMjIlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEJTVCJTIyLS1xdWlldCUyMiUyQyUyMCUyMnB1Ym1lZG1jcCU0MDAuMS4zJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZW52JTNEJTdCJTIyVVZfUFlUSE9OJTIyJTNBJTIwJTIyMy4xMiUyMiUyQyUyMCoqb3MuZW52aXJvbiU3RCUyQyUwQSklMEElMEF3aXRoJTIwVG9vbENvbGxlY3Rpb24uZnJvbV9tY3Aoc2VydmVyX3BhcmFtZXRlcnMlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTIwYXMlMjB0b29sX2NvbGxlY3Rpb24lM0ElMEElMjAlMjAlMjAlMjBhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1Qip0b29sX2NvbGxlY3Rpb24udG9vbHMlNUQlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTIwJTIwJTIwJTIwYWdlbnQucnVuKCUyMlBsZWFzZSUyMGZpbmQlMjBhJTIwcmVtZWR5JTIwZm9yJTIwaGFuZ292ZXIuJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters

server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uv&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-keyword">with</span> ToolCollection.from_mcp(server_parameters, trust_remote_code=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),Gt=new d({props:{code:"VGhlJTIwcmVtZWR5JTIwZm9yJTIwaGFuZ292ZXIlMjBpcyUyMHRvJTIwZHJpbmslMjB3YXRlci4=",highlighted:'The remedy <span class="hljs-keyword">for</span> hangover is to drink water.',wrap:!1}}),xt=new f({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),Qt=new nl({props:{source:"https://github.com/huggingface/mcp-course/blob/main/units/en/unit1/mcp-clients.mdx"}}),{c(){r=p("meta"),C=n(),m=p("p"),U=n(),M(u.$$.fragment),i=n(),w=p("p"),w.textContent=Yt,Ft=n(),Z=p("p"),Z.textContent=ye,Lt=n(),q=p("p"),q.textContent=Je,Dt=n(),G=p("ul"),G.innerHTML=he,Kt=n(),M(x.$$.fragment),Ot=n(),V=p("p"),V.textContent=Te,ts=n(),M(S.$$.fragment),ss=n(),k=p("p"),k.textContent=me,es=n(),M(Q.$$.fragment),ls=n(),_=p("p"),_.textContent=Ue,ns=n(),M(X.$$.fragment),as=n(),R=p("p"),R.textContent=Ce,ps=n(),N=p("p"),N.textContent=we,os=n(),M(W.$$.fragment),is=n(),P=p("p"),P.textContent=fe,rs=n(),H=p("p"),H.textContent=de,cs=n(),M(v.$$.fragment),us=n(),M(Y.$$.fragment),Ms=n(),z=p("p"),z.textContent=Ie,js=n(),F=p("p"),F.textContent=$e,ys=n(),M(L.$$.fragment),Js=n(),D=p("p"),D.innerHTML=ve,hs=n(),M(K.$$.fragment),Ts=n(),O=p("p"),O.innerHTML=be,ms=n(),M(tt.$$.fragment),Us=n(),st=p("p"),st.textContent=ge,Cs=n(),M(et.$$.fragment),ws=n(),lt=p("p"),lt.textContent=Be,fs=n(),M(nt.$$.fragment),ds=n(),at=p("p"),at.textContent=Ee,Is=n(),M(pt.$$.fragment),$s=n(),M(ot.$$.fragment),vs=n(),it=p("p"),it.innerHTML=Ae,bs=n(),M(b.$$.fragment),gs=n(),rt=p("p"),rt.innerHTML=Ze,Bs=n(),M(ct.$$.fragment),Es=n(),M(ut.$$.fragment),As=n(),Mt=p("p"),Mt.textContent=qe,Zs=n(),M(jt.$$.fragment),qs=n(),yt=p("p"),yt.textContent=Ge,Gs=n(),M(Jt.$$.fragment),xs=n(),M(ht.$$.fragment),Vs=n(),Tt=p("p"),Tt.textContent=xe,Ss=n(),M(mt.$$.fragment),ks=n(),Ut=p("p"),Ut.textContent=Ve,Qs=n(),Ct=p("p"),Ct.textContent=Se,_s=n(),M(wt.$$.fragment),Xs=n(),ft=p("p"),ft.innerHTML=ke,Rs=n(),dt=p("p"),dt.innerHTML=Qe,Ns=n(),M(It.$$.fragment),Ws=n(),g=p("details"),Rt=p("summary"),Rt.textContent=_e,re=n(),M($t.$$.fragment),Ps=n(),vt=p("p"),vt.innerHTML=Xe,Hs=n(),M(bt.$$.fragment),Ys=n(),B=p("details"),Nt=p("summary"),Nt.textContent=Re,ce=n(),M(gt.$$.fragment),zs=n(),Bt=p("p"),Bt.textContent=Ne,Fs=n(),M(Et.$$.fragment),Ls=n(),E=p("details"),Wt=p("summary"),Wt.textContent=We,ue=n(),M(At.$$.fragment),Ds=n(),Zt=p("p"),Zt.innerHTML=Pe,Ks=n(),M(qt.$$.fragment),Os=n(),A=p("details"),Pt=p("summary"),Pt.textContent=He,Me=n(),M(Gt.$$.fragment),te=n(),M(xt.$$.fragment),se=n(),Vt=p("p"),Vt.textContent=Ye,ee=n(),St=p("ul"),St.innerHTML=ze,le=n(),kt=p("p"),kt.textContent=Fe,ne=n(),M(Qt.$$.fragment),ae=n(),zt=p("p"),this.h()},l(t){const s=el("svelte-u9bgzb",document.head);r=o(s,"META",{name:!0,content:!0}),s.forEach(e),C=a(t),m=o(t,"P",{}),Ht(m).forEach(e),U=a(t),j(u.$$.fragment,t),i=a(t),w=o(t,"P",{"data-svelte-h":!0}),c(w)!=="svelte-bq1glt"&&(w.textContent=Yt),Ft=a(t),Z=o(t,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-3v3t4i"&&(Z.textContent=ye),Lt=a(t),q=o(t,"P",{"data-svelte-h":!0}),c(q)!=="svelte-37whj1"&&(q.textContent=Je),Dt=a(t),G=o(t,"UL",{"data-svelte-h":!0}),c(G)!=="svelte-nlhyzy"&&(G.innerHTML=he),Kt=a(t),j(x.$$.fragment,t),Ot=a(t),V=o(t,"P",{"data-svelte-h":!0}),c(V)!=="svelte-s96fp3"&&(V.textContent=Te),ts=a(t),j(S.$$.fragment,t),ss=a(t),k=o(t,"P",{"data-svelte-h":!0}),c(k)!=="svelte-38oyrl"&&(k.textContent=me),es=a(t),j(Q.$$.fragment,t),ls=a(t),_=o(t,"P",{"data-svelte-h":!0}),c(_)!=="svelte-sh915n"&&(_.textContent=Ue),ns=a(t),j(X.$$.fragment,t),as=a(t),R=o(t,"P",{"data-svelte-h":!0}),c(R)!=="svelte-1b87lnp"&&(R.textContent=Ce),ps=a(t),N=o(t,"P",{"data-svelte-h":!0}),c(N)!=="svelte-qfmi3f"&&(N.textContent=we),os=a(t),j(W.$$.fragment,t),is=a(t),P=o(t,"P",{"data-svelte-h":!0}),c(P)!=="svelte-1t8u4wf"&&(P.textContent=fe),rs=a(t),H=o(t,"P",{"data-svelte-h":!0}),c(H)!=="svelte-1h6qe5q"&&(H.textContent=de),cs=a(t),j(v.$$.fragment,t),us=a(t),j(Y.$$.fragment,t),Ms=a(t),z=o(t,"P",{"data-svelte-h":!0}),c(z)!=="svelte-1ycrnux"&&(z.textContent=Ie),js=a(t),F=o(t,"P",{"data-svelte-h":!0}),c(F)!=="svelte-z7yl0u"&&(F.textContent=$e),ys=a(t),j(L.$$.fragment,t),Js=a(t),D=o(t,"P",{"data-svelte-h":!0}),c(D)!=="svelte-upbqy5"&&(D.innerHTML=ve),hs=a(t),j(K.$$.fragment,t),Ts=a(t),O=o(t,"P",{"data-svelte-h":!0}),c(O)!=="svelte-1xnp18o"&&(O.innerHTML=be),ms=a(t),j(tt.$$.fragment,t),Us=a(t),st=o(t,"P",{"data-svelte-h":!0}),c(st)!=="svelte-eoeyze"&&(st.textContent=ge),Cs=a(t),j(et.$$.fragment,t),ws=a(t),lt=o(t,"P",{"data-svelte-h":!0}),c(lt)!=="svelte-443kp7"&&(lt.textContent=Be),fs=a(t),j(nt.$$.fragment,t),ds=a(t),at=o(t,"P",{"data-svelte-h":!0}),c(at)!=="svelte-1jwz8f7"&&(at.textContent=Ee),Is=a(t),j(pt.$$.fragment,t),$s=a(t),j(ot.$$.fragment,t),vs=a(t),it=o(t,"P",{"data-svelte-h":!0}),c(it)!=="svelte-1c7z0qi"&&(it.innerHTML=Ae),bs=a(t),j(b.$$.fragment,t),gs=a(t),rt=o(t,"P",{"data-svelte-h":!0}),c(rt)!=="svelte-1oqx78f"&&(rt.innerHTML=Ze),Bs=a(t),j(ct.$$.fragment,t),Es=a(t),j(ut.$$.fragment,t),As=a(t),Mt=o(t,"P",{"data-svelte-h":!0}),c(Mt)!=="svelte-fnutrr"&&(Mt.textContent=qe),Zs=a(t),j(jt.$$.fragment,t),qs=a(t),yt=o(t,"P",{"data-svelte-h":!0}),c(yt)!=="svelte-i95sbi"&&(yt.textContent=Ge),Gs=a(t),j(Jt.$$.fragment,t),xs=a(t),j(ht.$$.fragment,t),Vs=a(t),Tt=o(t,"P",{"data-svelte-h":!0}),c(Tt)!=="svelte-1d51v8x"&&(Tt.textContent=xe),Ss=a(t),j(mt.$$.fragment,t),ks=a(t),Ut=o(t,"P",{"data-svelte-h":!0}),c(Ut)!=="svelte-146ggji"&&(Ut.textContent=Ve),Qs=a(t),Ct=o(t,"P",{"data-svelte-h":!0}),c(Ct)!=="svelte-k8z1tj"&&(Ct.textContent=Se),_s=a(t),j(wt.$$.fragment,t),Xs=a(t),ft=o(t,"P",{"data-svelte-h":!0}),c(ft)!=="svelte-aa5a0z"&&(ft.innerHTML=ke),Rs=a(t),dt=o(t,"P",{"data-svelte-h":!0}),c(dt)!=="svelte-a3lj6q"&&(dt.innerHTML=Qe),Ns=a(t),j(It.$$.fragment,t),Ws=a(t),g=o(t,"DETAILS",{});var _t=Ht(g);Rt=o(_t,"SUMMARY",{"data-svelte-h":!0}),c(Rt)!=="svelte-1dioj6p"&&(Rt.textContent=_e),re=a(_t),j($t.$$.fragment,_t),_t.forEach(e),Ps=a(t),vt=o(t,"P",{"data-svelte-h":!0}),c(vt)!=="svelte-1fgzyi4"&&(vt.innerHTML=Xe),Hs=a(t),j(bt.$$.fragment,t),Ys=a(t),B=o(t,"DETAILS",{});var Xt=Ht(B);Nt=o(Xt,"SUMMARY",{"data-svelte-h":!0}),c(Nt)!=="svelte-1dioj6p"&&(Nt.textContent=Re),ce=a(Xt),j(gt.$$.fragment,Xt),Xt.forEach(e),zs=a(t),Bt=o(t,"P",{"data-svelte-h":!0}),c(Bt)!=="svelte-soysth"&&(Bt.textContent=Ne),Fs=a(t),j(Et.$$.fragment,t),Ls=a(t),E=o(t,"DETAILS",{});var oe=Ht(E);Wt=o(oe,"SUMMARY",{"data-svelte-h":!0}),c(Wt)!=="svelte-1dioj6p"&&(Wt.textContent=We),ue=a(oe),j(At.$$.fragment,oe),oe.forEach(e),Ds=a(t),Zt=o(t,"P",{"data-svelte-h":!0}),c(Zt)!=="svelte-1lkvhf3"&&(Zt.innerHTML=Pe),Ks=a(t),j(qt.$$.fragment,t),Os=a(t),A=o(t,"DETAILS",{});var ie=Ht(A);Pt=o(ie,"SUMMARY",{"data-svelte-h":!0}),c(Pt)!=="svelte-1dioj6p"&&(Pt.textContent=He),Me=a(ie),j(Gt.$$.fragment,ie),ie.forEach(e),te=a(t),j(xt.$$.fragment,t),se=a(t),Vt=o(t,"P",{"data-svelte-h":!0}),c(Vt)!=="svelte-jrhgb1"&&(Vt.textContent=Ye),ee=a(t),St=o(t,"UL",{"data-svelte-h":!0}),c(St)!=="svelte-1ypqei0"&&(St.innerHTML=ze),le=a(t),kt=o(t,"P",{"data-svelte-h":!0}),c(kt)!=="svelte-crczat"&&(kt.textContent=Fe),ne=a(t),j(Qt.$$.fragment,t),ae=a(t),zt=o(t,"P",{}),Ht(zt).forEach(e),this.h()},h(){Le(r,"name","hf:doc:metadata"),Le(r,"content",ul)},m(t,s){$(document.head,r),l(t,C,s),l(t,m,s),l(t,U,s),y(u,t,s),l(t,i,s),l(t,w,s),l(t,Ft,s),l(t,Z,s),l(t,Lt,s),l(t,q,s),l(t,Dt,s),l(t,G,s),l(t,Kt,s),y(x,t,s),l(t,Ot,s),l(t,V,s),l(t,ts,s),y(S,t,s),l(t,ss,s),l(t,k,s),l(t,es,s),y(Q,t,s),l(t,ls,s),l(t,_,s),l(t,ns,s),y(X,t,s),l(t,as,s),l(t,R,s),l(t,ps,s),l(t,N,s),l(t,os,s),y(W,t,s),l(t,is,s),l(t,P,s),l(t,rs,s),l(t,H,s),l(t,cs,s),y(v,t,s),l(t,us,s),y(Y,t,s),l(t,Ms,s),l(t,z,s),l(t,js,s),l(t,F,s),l(t,ys,s),y(L,t,s),l(t,Js,s),l(t,D,s),l(t,hs,s),y(K,t,s),l(t,Ts,s),l(t,O,s),l(t,ms,s),y(tt,t,s),l(t,Us,s),l(t,st,s),l(t,Cs,s),y(et,t,s),l(t,ws,s),l(t,lt,s),l(t,fs,s),y(nt,t,s),l(t,ds,s),l(t,at,s),l(t,Is,s),y(pt,t,s),l(t,$s,s),y(ot,t,s),l(t,vs,s),l(t,it,s),l(t,bs,s),y(b,t,s),l(t,gs,s),l(t,rt,s),l(t,Bs,s),y(ct,t,s),l(t,Es,s),y(ut,t,s),l(t,As,s),l(t,Mt,s),l(t,Zs,s),y(jt,t,s),l(t,qs,s),l(t,yt,s),l(t,Gs,s),y(Jt,t,s),l(t,xs,s),y(ht,t,s),l(t,Vs,s),l(t,Tt,s),l(t,Ss,s),y(mt,t,s),l(t,ks,s),l(t,Ut,s),l(t,Qs,s),l(t,Ct,s),l(t,_s,s),y(wt,t,s),l(t,Xs,s),l(t,ft,s),l(t,Rs,s),l(t,dt,s),l(t,Ns,s),y(It,t,s),l(t,Ws,s),l(t,g,s),$(g,Rt),$(g,re),y($t,g,null),l(t,Ps,s),l(t,vt,s),l(t,Hs,s),y(bt,t,s),l(t,Ys,s),l(t,B,s),$(B,Nt),$(B,ce),y(gt,B,null),l(t,zs,s),l(t,Bt,s),l(t,Fs,s),y(Et,t,s),l(t,Ls,s),l(t,E,s),$(E,Wt),$(E,ue),y(At,E,null),l(t,Ds,s),l(t,Zt,s),l(t,Ks,s),y(qt,t,s),l(t,Os,s),l(t,A,s),$(A,Pt),$(A,Me),y(Gt,A,null),l(t,te,s),y(xt,t,s),l(t,se,s),l(t,Vt,s),l(t,ee,s),l(t,St,s),l(t,le,s),l(t,kt,s),l(t,ne,s),y(Qt,t,s),l(t,ae,s),l(t,zt,s),pe=!0},p(t,[s]){const _t={};s&2&&(_t.$$scope={dirty:s,ctx:t}),v.$set(_t);const Xt={};s&2&&(Xt.$$scope={dirty:s,ctx:t}),b.$set(Xt)},i(t){pe||(J(u.$$.fragment,t),J(x.$$.fragment,t),J(S.$$.fragment,t),J(Q.$$.fragment,t),J(X.$$.fragment,t),J(W.$$.fragment,t),J(v.$$.fragment,t),J(Y.$$.fragment,t),J(L.$$.fragment,t),J(K.$$.fragment,t),J(tt.$$.fragment,t),J(et.$$.fragment,t),J(nt.$$.fragment,t),J(pt.$$.fragment,t),J(ot.$$.fragment,t),J(b.$$.fragment,t),J(ct.$$.fragment,t),J(ut.$$.fragment,t),J(jt.$$.fragment,t),J(Jt.$$.fragment,t),J(ht.$$.fragment,t),J(mt.$$.fragment,t),J(wt.$$.fragment,t),J(It.$$.fragment,t),J($t.$$.fragment,t),J(bt.$$.fragment,t),J(gt.$$.fragment,t),J(Et.$$.fragment,t),J(At.$$.fragment,t),J(qt.$$.fragment,t),J(Gt.$$.fragment,t),J(xt.$$.fragment,t),J(Qt.$$.fragment,t),pe=!0)},o(t){h(u.$$.fragment,t),h(x.$$.fragment,t),h(S.$$.fragment,t),h(Q.$$.fragment,t),h(X.$$.fragment,t),h(W.$$.fragment,t),h(v.$$.fragment,t),h(Y.$$.fragment,t),h(L.$$.fragment,t),h(K.$$.fragment,t),h(tt.$$.fragment,t),h(et.$$.fragment,t),h(nt.$$.fragment,t),h(pt.$$.fragment,t),h(ot.$$.fragment,t),h(b.$$.fragment,t),h(ct.$$.fragment,t),h(ut.$$.fragment,t),h(jt.$$.fragment,t),h(Jt.$$.fragment,t),h(ht.$$.fragment,t),h(mt.$$.fragment,t),h(wt.$$.fragment,t),h(It.$$.fragment,t),h($t.$$.fragment,t),h(bt.$$.fragment,t),h(gt.$$.fragment,t),h(Et.$$.fragment,t),h(At.$$.fragment,t),h(qt.$$.fragment,t),h(Gt.$$.fragment,t),h(xt.$$.fragment,t),h(Qt.$$.fragment,t),pe=!1},d(t){t&&(e(C),e(m),e(U),e(i),e(w),e(Ft),e(Z),e(Lt),e(q),e(Dt),e(G),e(Kt),e(Ot),e(V),e(ts),e(ss),e(k),e(es),e(ls),e(_),e(ns),e(as),e(R),e(ps),e(N),e(os),e(is),e(P),e(rs),e(H),e(cs),e(us),e(Ms),e(z),e(js),e(F),e(ys),e(Js),e(D),e(hs),e(Ts),e(O),e(ms),e(Us),e(st),e(Cs),e(ws),e(lt),e(fs),e(ds),e(at),e(Is),e($s),e(vs),e(it),e(bs),e(gs),e(rt),e(Bs),e(Es),e(As),e(Mt),e(Zs),e(qs),e(yt),e(Gs),e(xs),e(Vs),e(Tt),e(Ss),e(ks),e(Ut),e(Qs),e(Ct),e(_s),e(Xs),e(ft),e(Rs),e(dt),e(Ns),e(Ws),e(g),e(Ps),e(vt),e(Hs),e(Ys),e(B),e(zs),e(Bt),e(Fs),e(Ls),e(E),e(Ds),e(Zt),e(Ks),e(Os),e(A),e(te),e(se),e(Vt),e(ee),e(St),e(le),e(kt),e(ne),e(ae),e(zt)),e(r),T(u,t),T(x,t),T(S,t),T(Q,t),T(X,t),T(W,t),T(v,t),T(Y,t),T(L,t),T(K,t),T(tt,t),T(et,t),T(nt,t),T(pt,t),T(ot,t),T(b,t),T(ct,t),T(ut,t),T(jt,t),T(Jt,t),T(ht,t),T(mt,t),T(wt,t),T(It,t),T($t),T(bt,t),T(gt),T(Et,t),T(At),T(qt,t),T(Gt),T(xt,t),T(Qt,t)}}}const ul='{"title":"MCP Clients","local":"mcp-clients","sections":[{"title":"Understanding MCP Clients","local":"understanding-mcp-clients","sections":[],"depth":2},{"title":"User Interface Client","local":"user-interface-client","sections":[{"title":"Chat Interface Clients","local":"chat-interface-clients","sections":[],"depth":3},{"title":"Interactive Development Clients","local":"interactive-development-clients","sections":[],"depth":3}],"depth":2},{"title":"Configuring MCP Clients","local":"configuring-mcp-clients","sections":[{"title":"MCP Configuration Files","local":"mcp-configuration-files","sections":[{"title":"mcp.json Structure","local":"mcpjson-structure","sections":[],"depth":4},{"title":"Configuration for stdio Transport","local":"configuration-for-stdio-transport","sections":[],"depth":4},{"title":"Configuration for HTTP+SSE Transport","local":"configuration-for-httpsse-transport","sections":[],"depth":4},{"title":"Environment Variables in Configuration","local":"environment-variables-in-configuration","sections":[],"depth":4}],"depth":3},{"title":"Configuration Examples","local":"configuration-examples","sections":[{"title":"Scenario 1: Local Server Configuration","local":"scenario-1-local-server-configuration","sections":[],"depth":4},{"title":"Scenario 2: Remote Server Configuration","local":"scenario-2-remote-server-configuration","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Code Clients","local":"code-clients","sections":[],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Ml(I){return Oe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ul extends tl{constructor(r){super(),sl(this,r,Ml,cl,Ke,{})}}export{Ul as component};
