import{s as Si,n as Ki,o as qi}from"../chunks/scheduler.0219f8bd.js";import{S as Oi,i as ec,g as l,s,r as p,A as tc,h as d,f as r,c as a,j as _,u as m,x as i,k as c,y as rc,a as o,v as n,d as u,t as h,w as f}from"../chunks/index.f61edf3b.js";import{C as ad}from"../chunks/CodeBlock.38e566ae.js";import{H as g,E as oc}from"../chunks/EditOnGithub.48fa589f.js";function sc(ld){let x,Jr,Pr,Ir,T,Fr,b,kr,y,dd="Processors are used to prepare non-textual inputs (e.g., image or audio) for a model.",Lr,v,id="<strong>Example:</strong> Using a <code>WhisperProcessor</code> to prepare an audio input for a model.",jr,$,zr,w,cd='<li><a href="#module_processors">processors</a><ul><li><em>static</em><ul><li><a href="#module_processors.FeatureExtractor">.FeatureExtractor</a> ⇐ <a href="#Callable"><code>Callable</code></a><ul><li><a href="#new_module_processors.FeatureExtractor_new"><code>new FeatureExtractor(config)</code></a></li> <li><a href="#Callable+_call"><code>._call(...args)</code></a></li></ul></li> <li><a href="#module_processors.ImageFeatureExtractor">.ImageFeatureExtractor</a> ⇐ <code>FeatureExtractor</code><ul><li><a href="#new_module_processors.ImageFeatureExtractor_new"><code>new ImageFeatureExtractor(config)</code></a></li> <li><a href="#module_processors.ImageFeatureExtractor+thumbnail"><code>.thumbnail(image, size, [resample])</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+crop_margin"><code>.crop_margin(image, gray_threshold)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+pad_image"><code>.pad_image(pixelData, imgDims, padSize, options)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+rescale"><code>.rescale(pixelData)</code></a> ⇒ <code>void</code></li> <li><a href="#module_processors.ImageFeatureExtractor+get_resize_output_image_size"><code>.get_resize_output_image_size(image, size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+resize"><code>.resize(image)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+preprocess"><code>.preprocess(image, overrides)</code></a> ⇒ <code>Promise.&lt;PreprocessedImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+_call"><code>._call(images, ...args)</code></a> ⇒ <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code></li></ul></li> <li><a href="#module_processors.DetrFeatureExtractor">.DetrFeatureExtractor</a> ⇐ <code>ImageFeatureExtractor</code><ul><li><a href="#module_processors.DetrFeatureExtractor+_call"><code>._call(images)</code></a> ⇒ <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_object_detection"><code>.post_process_object_detection()</code></a> : <code>post_process_object_detection</code></li> <li><a href="#module_processors.DetrFeatureExtractor+remove_low_and_no_objects"><code>.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+check_segment_validity"><code>.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+compute_segments"><code>.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"><code>.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes])</code></a> ⇒ <code>Array.&lt;{segmentation: Tensor, segments_info: Array&lt;{id: number, label_id: number, score: number}&gt;}&gt;</code></li></ul></li> <li><a href="#module_processors.Processor">.Processor</a> ⇐ <a href="#Callable"><code>Callable</code></a><ul><li><a href="#new_module_processors.Processor_new"><code>new Processor(feature_extractor)</code></a></li> <li><a href="#module_processors.Processor+_call"><code>._call(input, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_processors.WhisperProcessor">.WhisperProcessor</a> ⇐ <code>Processor</code><ul><li><a href="#module_processors.WhisperProcessor+_call"><code>._call(audio)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_processors.AutoProcessor">.AutoProcessor</a><ul><li><a href="#module_processors.AutoProcessor.from_pretrained"><code>.from_pretrained(pretrained_model_name_or_path, options)</code></a> ⇒ <code>Promise.&lt;Processor&gt;</code></li></ul></li></ul></li> <li><em>inner</em><ul><li><a href="#module_processors..center_to_corners_format"><code>~center_to_corners_format(arr)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_processors..enforce_size_divisibility"><code>~enforce_size_divisibility(size, divisor)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors..HeightWidth"><code>~HeightWidth</code></a> : <code>*</code></li> <li><a href="#module_processors..ImageFeatureExtractorResult"><code>~ImageFeatureExtractorResult</code></a> : <code>object</code></li> <li><a href="#module_processors..PreprocessedImage"><code>~PreprocessedImage</code></a> : <code>object</code></li> <li><a href="#module_processors..DetrFeatureExtractorResult"><code>~DetrFeatureExtractorResult</code></a> : <code>object</code></li> <li><a href="#module_processors..SamImageProcessorResult"><code>~SamImageProcessorResult</code></a> : <code>object</code></li></ul></li></ul></li>',Ar,Rr,Ur,M,Dr,E,Br,C,pd="Base class for feature extractors.",Wr,P,md='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <a href="#Callable"><code>Callable</code></a>',Gr,H,nd='<li><a href="#module_processors.FeatureExtractor">.FeatureExtractor</a> ⇐ <a href="#Callable"><code>Callable</code></a><ul><li><a href="#new_module_processors.FeatureExtractor_new"><code>new FeatureExtractor(config)</code></a></li> <li><a href="#Callable+_call"><code>._call(...args)</code></a></li></ul></li>',Nr,Zr,Qr,J,Xr,I,Vr,F,ud="Constructs a new FeatureExtractor instance.",Yr,k,hd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>config</td><td><code>Object</code></td><td><p>The configuration for the feature extractor.</p></td></tr></tbody>",Sr,Kr,qr,L,Or,j,eo,z,fd=`This method should be implemented in subclasses to provide the
functionality of the callable object.`,to,A,_d='<strong>Kind</strong>: instance method of <a href="#module_processors.FeatureExtractor"><code>FeatureExtractor</code></a><br/> <strong>Overrides</strong>: <a href="#Callable+_call"><code>_call</code></a><br/> <strong>Throws</strong>:',ro,R,gd="<li><code>Error</code> If the subclass does not implement the `_call` method.</li>",oo,U,xd="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>...args</td><td><code>Array.&lt;any&gt;</code></td></tr></tbody>",so,ao,lo,D,io,B,co,W,Td="Feature extractor for image models.",po,G,bd='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>FeatureExtractor</code>',mo,N,yd='<li><a href="#module_processors.ImageFeatureExtractor">.ImageFeatureExtractor</a> ⇐ <code>FeatureExtractor</code><ul><li><a href="#new_module_processors.ImageFeatureExtractor_new"><code>new ImageFeatureExtractor(config)</code></a></li> <li><a href="#module_processors.ImageFeatureExtractor+thumbnail"><code>.thumbnail(image, size, [resample])</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+crop_margin"><code>.crop_margin(image, gray_threshold)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+pad_image"><code>.pad_image(pixelData, imgDims, padSize, options)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+rescale"><code>.rescale(pixelData)</code></a> ⇒ <code>void</code></li> <li><a href="#module_processors.ImageFeatureExtractor+get_resize_output_image_size"><code>.get_resize_output_image_size(image, size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+resize"><code>.resize(image)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+preprocess"><code>.preprocess(image, overrides)</code></a> ⇒ <code>Promise.&lt;PreprocessedImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+_call"><code>._call(images, ...args)</code></a> ⇒ <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code></li></ul></li>',no,uo,ho,Z,fo,Q,_o,X,vd="Constructs a new ImageFeatureExtractor instance.",go,V,$d=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>config</td><td><code>Object</code></td><td></td><td><p>The configuration for the feature extractor.</p></td> </tr><tr><td>config.image_mean</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The mean values for image normalization.</p></td> </tr><tr><td>config.image_std</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The standard deviation values for image normalization.</p></td> </tr><tr><td>config.do_rescale</td><td><code>boolean</code></td><td></td><td><p>Whether to rescale the image pixel values to the [0,1] range.</p></td> </tr><tr><td>config.rescale_factor</td><td><code>number</code></td><td></td><td><p>The factor to use for rescaling the image pixel values.</p></td> </tr><tr><td>config.do_normalize</td><td><code>boolean</code></td><td></td><td><p>Whether to normalize the image pixel values.</p></td> </tr><tr><td>config.do_resize</td><td><code>boolean</code></td><td></td><td><p>Whether to resize the image.</p></td> </tr><tr><td>config.resample</td><td><code>number</code></td><td></td><td><p>What method to use for resampling.</p></td> </tr><tr><td>config.size</td><td><code>number</code> | <code>Object</code></td><td></td><td><p>The size to resize the image to.</p></td> </tr><tr><td>[config.do_flip_channel_order]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to flip the color channels from RGB to BGR.
Can be overridden by the <code>do_flip_channel_order</code> parameter in the <code>preprocess</code> method.</p></td></tr></tbody>`,xo,To,bo,Y,yo,S,vo,K,wd=`Resize the image to make a thumbnail. The image is resized so that no dimension is larger than any
corresponding dimension of the specified size.`,$o,q,Md='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The resized image.',wo,O,Ed="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td></td><td><p>The image to be resized.</p></td> </tr><tr><td>size</td><td><code>Object</code></td><td></td><td><p>The size <code>{&quot;height&quot;: h, &quot;width&quot;: w}</code> to resize the image to.</p></td> </tr><tr><td>[resample]</td><td><code>string</code> | <code>0</code> | <code>1</code> | <code>2</code> | <code>3</code> | <code>4</code> | <code>5</code></td><td><code>2</code></td><td><p>The resampling filter to use.</p></td></tr></tbody>",Mo,Eo,Co,ee,Po,te,Ho,re,Cd="Crops the margin of the image. Gray pixels are considered margin (i.e., pixels with a value below the threshold).",Jo,oe,Pd='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The cropped image.',Io,se,Hd="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td></td><td><p>The image to be cropped.</p></td> </tr><tr><td>gray_threshold</td><td><code>number</code></td><td><code>200</code></td><td><p>Value below which pixels are considered to be gray.</p></td></tr></tbody>",Fo,ko,Lo,ae,jo,le,zo,de,Jd="Pad the image by a certain amount.",Ao,ie,Id='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The padded pixel data and image dimensions.',Ro,ce,Fd="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>pixelData</td><td><code>Float32Array</code></td><td></td><td><p>The pixel data to pad.</p></td> </tr><tr><td>imgDims</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The dimensions of the image (height, width, channels).</p></td> </tr><tr><td>padSize</td><td><code>*</code></td><td></td><td><p>The dimensions of the padded image.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options for padding.</p></td> </tr><tr><td>[options.mode]</td><td><code>&#39;constant&#39;</code> | <code>&#39;symmetric&#39;</code></td><td><code>&#39;constant&#39;</code></td><td><p>The type of padding to add.</p></td> </tr><tr><td>[options.center]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to center the image.</p></td> </tr><tr><td>[options.constant_values]</td><td><code>number</code></td><td><code>0</code></td><td><p>The constant value to use for padding.</p></td></tr></tbody>",Uo,Do,Bo,pe,Wo,me,Go,ne,kd="Rescale the image’ pixel values by <code>this.rescale_factor</code>.",No,ue,Ld='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a>',Zo,he,jd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pixelData</td><td><code>Float32Array</code></td><td><p>The pixel data to rescale.</p></td></tr></tbody>",Qo,Xo,Vo,fe,Yo,_e,So,ge,zd=`Find the target (width, height) dimension of the output image after
resizing given the input image and the desired size.`,Ko,xe,Ad='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The target (width, height) dimension of the output image after resizing.',qo,Te,Rd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td><p>The image to resize.</p></td> </tr><tr><td>size</td><td><code>any</code></td><td><p>The size to use for resizing the image.</p></td></tr></tbody>",Oo,es,ts,be,rs,ye,os,ve,Ud="Resizes the image.",ss,$e,Dd='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The resized image.',as,we,Bd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td><p>The image to resize.</p></td></tr></tbody>",ls,ds,is,Me,cs,Ee,ps,Ce,Wd="Preprocesses the given image.",ms,Pe,Gd='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;PreprocessedImage&gt;</code> - The preprocessed image.',ns,He,Nd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td><p>The image to preprocess.</p></td> </tr><tr><td>overrides</td><td><code>Object</code></td><td><p>The overrides for the preprocessing options.</p></td></tr></tbody>",us,hs,fs,Je,_s,Ie,gs,Fe,Zd=`Calls the feature extraction process on an array of images,
preprocesses each image, and concatenates the resulting
features into a single Tensor.`,xs,ke,Qd='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code> - An object containing the concatenated pixel values (and other metadata) of the preprocessed images.',Ts,Le,Xd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;RawImage&gt;</code></td><td><p>The image(s) to extract features from.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",bs,ys,vs,je,$s,ze,ws,Ae,Vd="Detr Feature Extractor.",Ms,Re,Yd='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>ImageFeatureExtractor</code>',Es,Ue,Sd='<li><a href="#module_processors.DetrFeatureExtractor">.DetrFeatureExtractor</a> ⇐ <code>ImageFeatureExtractor</code><ul><li><a href="#module_processors.DetrFeatureExtractor+_call"><code>._call(images)</code></a> ⇒ <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_object_detection"><code>.post_process_object_detection()</code></a> : <code>post_process_object_detection</code></li> <li><a href="#module_processors.DetrFeatureExtractor+remove_low_and_no_objects"><code>.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+check_segment_validity"><code>.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+compute_segments"><code>.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"><code>.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes])</code></a> ⇒ <code>Array.&lt;{segmentation: Tensor, segments_info: Array&lt;{id: number, label_id: number, score: number}&gt;}&gt;</code></li></ul></li>',Cs,Ps,Hs,De,Js,Be,Is,We,Kd=`Calls the feature extraction process on an array of images, preprocesses
each image, and concatenates the resulting features into a single Tensor.`,Fs,Ge,qd='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code> - An object containing the concatenated pixel values of the preprocessed images.',ks,Ne,Od="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;RawImage&gt;</code></td><td><p>The image(s) to extract features from.</p></td></tr></tbody>",Ls,js,zs,Ze,As,Qe,Rs,Xe,ei='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a>',Us,Ds,Bs,Ve,Ws,Ye,Gs,Se,ti="Binarize the given masks using <code>object_mask_threshold</code>, it returns the associated values of <code>masks</code>, <code>scores</code> and <code>labels</code>.",Ns,Ke,ri='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The binarized masks, the scores, and the labels.',Zs,qe,oi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>class_logits</td><td><code>Tensor</code></td><td><p>The class logits.</p></td> </tr><tr><td>mask_logits</td><td><code>Tensor</code></td><td><p>The mask logits.</p></td> </tr><tr><td>object_mask_threshold</td><td><code>number</code></td><td><p>A number between 0 and 1 used to binarize the masks.</p></td> </tr><tr><td>num_labels</td><td><code>number</code></td><td><p>The number of labels.</p></td></tr></tbody>",Qs,Xs,Vs,Oe,Ys,et,Ss,tt,si="Checks whether the segment is valid or not.",Ks,rt,ai='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - Whether the segment is valid or not, and the indices of the valid labels.',qs,ot,li="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>mask_labels</td><td><code>Int32Array</code></td><td></td><td><p>Labels for each pixel in the mask.</p></td> </tr><tr><td>mask_probs</td><td><code>Array.&lt;Tensor&gt;</code></td><td></td><td><p>Probabilities for each pixel in the masks.</p></td> </tr><tr><td>k</td><td><code>number</code></td><td></td><td><p>The class id of the segment.</p></td> </tr><tr><td>mask_threshold</td><td><code>number</code></td><td><code>0.5</code></td><td><p>The mask threshold.</p></td> </tr><tr><td>overlap_mask_area_threshold</td><td><code>number</code></td><td><code>0.8</code></td><td><p>The overlap mask area threshold.</p></td></tr></tbody>",Os,ea,ta,st,ra,at,oa,lt,di="Computes the segments.",sa,dt,ii='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The computed segments.',aa,it,ci="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>mask_probs</td><td><code>Array.&lt;Tensor&gt;</code></td><td></td><td><p>The mask probabilities.</p></td> </tr><tr><td>pred_scores</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The predicted scores.</p></td> </tr><tr><td>pred_labels</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The predicted labels.</p></td> </tr><tr><td>mask_threshold</td><td><code>number</code></td><td></td><td><p>The mask threshold.</p></td> </tr><tr><td>overlap_mask_area_threshold</td><td><code>number</code></td><td></td><td><p>The overlap mask area threshold.</p></td> </tr><tr><td>label_ids_to_fuse</td><td><code>Set.&lt;number&gt;</code></td><td><code></code></td><td><p>The label ids to fuse.</p></td> </tr><tr><td>target_size</td><td><code>Array.&lt;number&gt;</code></td><td><code></code></td><td><p>The target size of the image.</p></td></tr></tbody>",la,da,ia,ct,ca,pt,pa,mt,pi="Post-process the model output to generate the final panoptic segmentation.",ma,nt,mi='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a>',na,ut,ni="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>outputs</td><td><code>*</code></td><td></td><td><p>The model output to post process</p></td> </tr><tr><td>[threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>The probability score threshold to keep predicted instance masks.</p></td> </tr><tr><td>[mask_threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>Threshold to use when turning the predicted masks into binary values.</p></td> </tr><tr><td>[overlap_mask_area_threshold]</td><td><code>number</code></td><td><code>0.8</code></td><td><p>The overlap mask area threshold to merge or discard small disconnected parts within each binary instance mask.</p></td> </tr><tr><td>[label_ids_to_fuse]</td><td><code>Set.&lt;number&gt;</code></td><td><code></code></td><td><p>The labels in this state will have all their instances be fused together.</p></td> </tr><tr><td>[target_sizes]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td><code></code></td><td><p>The target sizes to resize the masks to.</p></td></tr></tbody>",ua,ha,fa,ht,_a,ft,ga,_t,ui="Represents a Processor that extracts features from an input.",xa,gt,hi='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <a href="#Callable"><code>Callable</code></a>',Ta,xt,fi='<li><a href="#module_processors.Processor">.Processor</a> ⇐ <a href="#Callable"><code>Callable</code></a><ul><li><a href="#new_module_processors.Processor_new"><code>new Processor(feature_extractor)</code></a></li> <li><a href="#module_processors.Processor+_call"><code>._call(input, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',ba,ya,va,Tt,$a,bt,wa,yt,_i="Creates a new Processor with the given feature extractor.",Ma,vt,gi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>feature_extractor</td><td><code>FeatureExtractor</code></td><td><p>The function used to extract features from the input.</p></td></tr></tbody>",Ea,Ca,Pa,$t,Ha,wt,Ja,Mt,xi="Calls the feature_extractor function with the given input.",Ia,Et,Ti='<strong>Kind</strong>: instance method of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Overrides</strong>: <a href="#Callable+_call"><code>_call</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A Promise that resolves with the extracted features.',Fa,Ct,bi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>any</code></td><td><p>The input to extract features from.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",ka,La,ja,Pt,za,Ht,Aa,Jt,yi="Represents a WhisperProcessor that extracts features from an audio input.",Ra,It,vi='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>Processor</code>',Ua,Da,Ba,Ft,Wa,kt,Ga,Lt,$i="Calls the feature_extractor function with the given audio input.",Na,jt,wi='<strong>Kind</strong>: instance method of <a href="#module_processors.WhisperProcessor"><code>WhisperProcessor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A Promise that resolves with the extracted features.',Za,zt,Mi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>audio</td><td><code>any</code></td><td><p>The audio input to extract features from.</p></td></tr></tbody>",Qa,Xa,Va,At,Ya,Rt,Sa,Ut,Ei=`Helper class which is used to instantiate pretrained processors with the <code>from_pretrained</code> function.
The chosen processor class is determined by the type specified in the processor config.`,Ka,Dt,Ci="<strong>Example:</strong> Load a processor using <code>from_pretrained</code>.",qa,Bt,Oa,Wt,Pi="<strong>Example:</strong> Run an image through a processor.",el,Gt,tl,Nt,Hi='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a>',rl,ol,sl,Zt,al,Qt,ll,Xt,Ji="Instantiate one of the processor classes of the library from a pretrained model.",dl,Vt,Ii=`The processor class to instantiate is selected based on the <code>feature_extractor_type</code> property of the config object
(either passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible)`,il,Yt,Fi='<strong>Kind</strong>: static method of <a href="#module_processors.AutoProcessor"><code>AutoProcessor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Processor&gt;</code> - A new instance of the Processor class.',cl,St,ki=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pretrained_model_name_or_path</td><td><code>string</code></td><td><p>The name or path of the pretrained model. Can be either:</p> <ul><li>A string, the <em>model id</em> of a pretrained processor hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li> <li>A path to a <em>directory</em> containing processor files, e.g., <code>./my_model_directory/</code>.</li></ul></td> </tr><tr><td>options</td><td><code>*</code></td><td><p>Additional options for loading the processor.</p></td></tr></tbody>`,pl,ml,nl,Kt,ul,qt,hl,Ot,Li="Converts bounding boxes from center format to corners format.",fl,er,ji='<strong>Kind</strong>: inner method of <a href="#module_processors"><code>processors</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The coodinates for the top-left and bottom-right corners of the box (top_left_x, top_left_y, bottom_right_x, bottom_right_y)',_l,tr,zi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array.&lt;number&gt;</code></td><td><p>The coordinate for the center of the box and its width, height dimensions (center_x, center_y, width, height)</p></td></tr></tbody>",gl,xl,Tl,rr,bl,or,yl,sr,Ai="Rounds the height and width down to the closest multiple of size_divisibility",vl,ar,Ri='<strong>Kind</strong>: inner method of <a href="#module_processors"><code>processors</code></a><br/> <strong>Returns</strong>: <code>*</code> - The rounded size.',$l,lr,Ui="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>*</code></td><td><p>The size of the image</p></td> </tr><tr><td>divisor</td><td><code>number</code></td><td><p>The divisor to use.</p></td></tr></tbody>",wl,Ml,El,dr,Cl,ir,Pl,cr,Di=`Named tuple to indicate the order we are using is (height x width), even though
the Graphics’ industry standard is (width x height).`,Hl,pr,Bi='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a>',Jl,Il,Fl,mr,kl,nr,Ll,ur,Wi='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',jl,hr,Gi="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pixel_values</td><td><code>Tensor</code></td><td><p>The pixel values of the batched preprocessed images.</p></td> </tr><tr><td>original_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td><td><p>Array of two-dimensional tuples like [[480, 640]].</p></td> </tr><tr><td>reshaped_input_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td><td><p>Array of two-dimensional tuples like [[1000, 1330]].</p></td></tr></tbody>",zl,Al,Rl,fr,Ul,_r,Dl,gr,Ni='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',Bl,xr,Zi="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>original_size</td><td><code>HeightWidth</code></td><td><p>The original size of the image.</p></td> </tr><tr><td>reshaped_input_size</td><td><code>HeightWidth</code></td><td><p>The reshaped input size of the image.</p></td> </tr><tr><td>pixel_values</td><td><code>Tensor</code></td><td><p>The pixel values of the preprocessed image.</p></td></tr></tbody>",Wl,Gl,Nl,Tr,Zl,br,Ql,yr,Qi='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',Xl,vr,Xi="<thead><tr><th>Name</th><th>Type</th></tr></thead> <tbody><tr><td>pixel_mask</td><td><code>Tensor</code></td></tr></tbody>",Vl,Yl,Sl,$r,Kl,wr,ql,Mr,Vi='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',Ol,Er,Yi="<thead><tr><th>Name</th><th>Type</th></tr></thead> <tbody><tr><td>pixel_values</td><td><code>Tensor</code></td> </tr><tr><td>original_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td> </tr><tr><td>reshaped_input_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td> </tr><tr><td>[input_points]</td><td><code>Tensor</code></td> </tr><tr><td>[input_labels]</td><td><code>Tensor</code></td> </tr><tr><td>[input_boxes]</td><td><code>Tensor</code></td></tr></tbody>",ed,td,rd,Cr,od,Hr,sd;return b=new g({props:{title:"processors",local:"processors",headingTag:"h1"}}),$=new ad({props:{code:"aW1wb3J0JTIwJTdCJTIwQXV0b1Byb2Nlc3NvciUyQyUyMHJlYWRfYXVkaW8lMjAlN0QlMjBmcm9tJTIwJyU0MHhlbm92YSUyRnRyYW5zZm9ybWVycyclM0IlMEElMEFsZXQlMjBwcm9jZXNzb3IlMjAlM0QlMjBhd2FpdCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCdvcGVuYWklMkZ3aGlzcGVyLXRpbnkuZW4nKSUzQiUwQWxldCUyMGF1ZGlvJTIwJTNEJTIwYXdhaXQlMjByZWFkX2F1ZGlvKCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1say5mbGFjJyUyQyUyMDE2MDAwKSUzQiUwQWxldCUyMCU3QiUyMGlucHV0X2ZlYXR1cmVzJTIwJTdEJTIwJTNEJTIwYXdhaXQlMjBwcm9jZXNzb3IoYXVkaW8pJTNCJTBBJTJGJTJGJTIwVGVuc29yJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwZGF0YSUzQSUyMEZsb2F0MzJBcnJheSgyNDAwMDApJTIwJTVCMC40NzUyOTg0NjQyOTgyNDgzJTJDJTIwMC41NTk3MjU4ODA2MjI4NjM4JTJDJTIwMC41NjQzNDE2NjQzMTQyNyUyQyUyMC4uLiU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMGRpbXMlM0ElMjAlNUIxJTJDJTIwODAlMkMlMjAzMDAwJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwdHlwZSUzQSUyMCdmbG9hdDMyJyUyQyUwQSUyRiUyRiUyMCUyMCUyMHNpemUlM0ElMjAyNDAwMDAlMkMlMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">AutoProcessor</span>, read_audio } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@xenova/transformers&#x27;</span>;

<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;openai/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">let</span> audio = <span class="hljs-keyword">await</span> <span class="hljs-title function_">read_audio</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&#x27;</span>, <span class="hljs-number">16000</span>);
<span class="hljs-keyword">let</span> { input_features } = <span class="hljs-keyword">await</span> <span class="hljs-title function_">processor</span>(audio);
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   data: Float32Array(240000) [0.4752984642982483, 0.5597258806228638, 0.56434166431427, ...],</span>
<span class="hljs-comment">//   dims: [1, 80, 3000],</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   size: 240000,</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),E=new g({props:{title:"processors.FeatureExtractor ⇐ <code> Callable </code>",local:"processorsfeatureextractor--code-callable-code",headingTag:"h2"}}),I=new g({props:{title:"new FeatureExtractor(config)",local:"new-featureextractorconfig",headingTag:"h3"}}),j=new g({props:{title:"featureExtractor._call(...args)",local:"featureextractorcallargs",headingTag:"h3"}}),B=new g({props:{title:"processors.ImageFeatureExtractor ⇐ <code> FeatureExtractor </code>",local:"processorsimagefeatureextractor--code-featureextractor-code",headingTag:"h2"}}),Q=new g({props:{title:"new ImageFeatureExtractor(config)",local:"new-imagefeatureextractorconfig",headingTag:"h3"}}),S=new g({props:{title:"imageFeatureExtractor.thumbnail(image, size, [resample]) ⇒ <code> Promise. < RawImage > </code>",local:"imagefeatureextractorthumbnailimage-size-resample--code-promise--rawimage--code",headingTag:"h3"}}),te=new g({props:{title:"imageFeatureExtractor.crop_margin(image, gray_threshold) ⇒ <code> Promise. < RawImage > </code>",local:"imagefeatureextractorcropmarginimage-graythreshold--code-promise--rawimage--code",headingTag:"h3"}}),le=new g({props:{title:"imageFeatureExtractor.pad_image(pixelData, imgDims, padSize, options) ⇒ <code> * </code>",local:"imagefeatureextractorpadimagepixeldata-imgdims-padsize-options--code--code",headingTag:"h3"}}),me=new g({props:{title:"imageFeatureExtractor.rescale(pixelData) ⇒ <code> void </code>",local:"imagefeatureextractorrescalepixeldata--code-void-code",headingTag:"h3"}}),_e=new g({props:{title:"imageFeatureExtractor.get_resize_output_image_size(image, size) ⇒ <code> * </code>",local:"imagefeatureextractorgetresizeoutputimagesizeimage-size--code--code",headingTag:"h3"}}),ye=new g({props:{title:"imageFeatureExtractor.resize(image) ⇒ <code> Promise. < RawImage > </code>",local:"imagefeatureextractorresizeimage--code-promise--rawimage--code",headingTag:"h3"}}),Ee=new g({props:{title:"imageFeatureExtractor.preprocess(image, overrides) ⇒ <code> Promise. < PreprocessedImage > </code>",local:"imagefeatureextractorpreprocessimage-overrides--code-promise--preprocessedimage--code",headingTag:"h3"}}),Ie=new g({props:{title:"imageFeatureExtractor._call(images, ...args) ⇒ <code> Promise. < ImageFeatureExtractorResult > </code>",local:"imagefeatureextractorcallimages-args--code-promise--imagefeatureextractorresult--code",headingTag:"h3"}}),ze=new g({props:{title:"processors.DetrFeatureExtractor ⇐ <code> ImageFeatureExtractor </code>",local:"processorsdetrfeatureextractor--code-imagefeatureextractor-code",headingTag:"h2"}}),Be=new g({props:{title:"detrFeatureExtractor._call(images) ⇒ <code> Promise. < DetrFeatureExtractorResult > </code>",local:"detrfeatureextractorcallimages--code-promise--detrfeatureextractorresult--code",headingTag:"h3"}}),Qe=new g({props:{title:"detrFeatureExtractor.post_process_object_detection() : <code> post_process_object_detection </code>",local:"detrfeatureextractorpostprocessobjectdetection--code-postprocessobjectdetection-code",headingTag:"h3"}}),Ye=new g({props:{title:"detrFeatureExtractor.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels) ⇒ <code> * </code>",local:"detrfeatureextractorremovelowandnoobjectsclasslogits-masklogits-objectmaskthreshold-numlabels--code--code",headingTag:"h3"}}),et=new g({props:{title:"detrFeatureExtractor.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold) ⇒ <code> * </code>",local:"detrfeatureextractorchecksegmentvaliditymasklabels-maskprobs-k-maskthreshold-overlapmaskareathreshold--code--code",headingTag:"h3"}}),at=new g({props:{title:"detrFeatureExtractor.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size) ⇒ <code> * </code>",local:"detrfeatureextractorcomputesegmentsmaskprobs-predscores-predlabels-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsize--code--code",headingTag:"h3"}}),pt=new g({props:{title:"detrFeatureExtractor.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes]) ⇒ <code> Array. < {segmentation: Tensor, segments_info: Array < {id: number, label_id: number, score: number} > } > </code>",local:"detrfeatureextractorpostprocesspanopticsegmentationoutputs-threshold-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsizes--code-array--segmentation-tensor-segmentsinfo-array--id-number-labelid-number-score-number----code",headingTag:"h3"}}),ft=new g({props:{title:"processors.Processor ⇐ <code> Callable </code>",local:"processorsprocessor--code-callable-code",headingTag:"h2"}}),bt=new g({props:{title:"new Processor(feature_extractor)",local:"new-processorfeatureextractor",headingTag:"h3"}}),wt=new g({props:{title:"processor._call(input, ...args) ⇒ <code> Promise. < any > </code>",local:"processorcallinput-args--code-promise--any--code",headingTag:"h3"}}),Ht=new g({props:{title:"processors.WhisperProcessor ⇐ <code> Processor </code>",local:"processorswhisperprocessor--code-processor-code",headingTag:"h2"}}),kt=new g({props:{title:"whisperProcessor._call(audio) ⇒ <code> Promise. < any > </code>",local:"whisperprocessorcallaudio--code-promise--any--code",headingTag:"h3"}}),Rt=new g({props:{title:"processors.AutoProcessor",local:"processorsautoprocessor",headingTag:"h2"}}),Bt=new ad({props:{code:"bGV0JTIwcHJvY2Vzc29yJTIwJTNEJTIwYXdhaXQlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCgnb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJyklM0I=",highlighted:'<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;openai/whisper-tiny.en&#x27;</span>);',wrap:!1}}),Gt=new ad({props:{code:"bGV0JTIwcHJvY2Vzc29yJTIwJTNEJTIwYXdhaXQlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCgnWGVub3ZhJTJGY2xpcC12aXQtYmFzZS1wYXRjaDE2JyklM0IlMEFsZXQlMjBpbWFnZSUyMCUzRCUyMGF3YWl0JTIwUmF3SW1hZ2UucmVhZCgnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRmZvb3RiYWxsLW1hdGNoLmpwZycpJTNCJTBBbGV0JTIwaW1hZ2VfaW5wdXRzJTIwJTNEJTIwYXdhaXQlMjBwcm9jZXNzb3IoaW1hZ2UpJTNCJTBBJTJGJTJGJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIycGl4ZWxfdmFsdWVzJTIyJTNBJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIyZGltcyUyMiUzQSUyMCU1QiUyMDElMkMlMjAzJTJDJTIwMjI0JTJDJTIwMjI0JTIwJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmZsb2F0MzIlMjIlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlMjJkYXRhJTIyJTNBJTIwRmxvYXQzMkFycmF5JTIwJTVCJTIwLTEuNTU4Njg3Njg2OTIwMTY2JTJDJTIwLTEuNTU4Njg3Njg2OTIwMTY2JTJDJTIwLTEuNTQ0MDg5MzE3MzIxNzc3MyUyQyUyMC4uLiUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCUyMnNpemUlMjIlM0ElMjAxNTA1MjglMEElMkYlMkYlMjAlMjAlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjJvcmlnaW5hbF9zaXplcyUyMiUzQSUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCU1QiUyMDUzMyUyQyUyMDgwMCUyMCU1RCUwQSUyRiUyRiUyMCUyMCUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMnJlc2hhcGVkX2lucHV0X3NpemVzJTIyJTNBJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTVCJTIwMjI0JTJDJTIwMjI0JTIwJTVEJTBBJTJGJTJGJTIwJTIwJTIwJTVEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;Xenova/clip-vit-base-patch16&#x27;</span>);
<span class="hljs-keyword">let</span> image = <span class="hljs-keyword">await</span> <span class="hljs-title class_">RawImage</span>.<span class="hljs-title function_">read</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/football-match.jpg&#x27;</span>);
<span class="hljs-keyword">let</span> image_inputs = <span class="hljs-keyword">await</span> <span class="hljs-title function_">processor</span>(image);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   &quot;pixel_values&quot;: {</span>
<span class="hljs-comment">//     &quot;dims&quot;: [ 1, 3, 224, 224 ],</span>
<span class="hljs-comment">//     &quot;type&quot;: &quot;float32&quot;,</span>
<span class="hljs-comment">//     &quot;data&quot;: Float32Array [ -1.558687686920166, -1.558687686920166, -1.5440893173217773, ... ],</span>
<span class="hljs-comment">//     &quot;size&quot;: 150528</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   &quot;original_sizes&quot;: [</span>
<span class="hljs-comment">//     [ 533, 800 ]</span>
<span class="hljs-comment">//   ],</span>
<span class="hljs-comment">//   &quot;reshaped_input_sizes&quot;: [</span>
<span class="hljs-comment">//     [ 224, 224 ]</span>
<span class="hljs-comment">//   ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Qt=new g({props:{title:"AutoProcessor.from_pretrained(pretrained_model_name_or_path, options) ⇒ <code> Promise. < Processor > </code>",local:"autoprocessorfrompretrainedpretrainedmodelnameorpath-options--code-promise--processor--code",headingTag:"h3"}}),qt=new g({props:{title:"processors~center_to_corners_format(arr) ⇒ <code> Array. < number > </code>",local:"processorscentertocornersformatarr--code-array--number--code",headingTag:"h2"}}),or=new g({props:{title:"processors~enforce_size_divisibility(size, divisor) ⇒ <code> * </code>",local:"processorsenforcesizedivisibilitysize-divisor--code--code",headingTag:"h2"}}),ir=new g({props:{title:"processors~HeightWidth : <code> * </code>",local:"processorsheightwidth--code--code",headingTag:"h2"}}),nr=new g({props:{title:"processors~ImageFeatureExtractorResult : <code> object </code>",local:"processorsimagefeatureextractorresult--code-object-code",headingTag:"h2"}}),_r=new g({props:{title:"processors~PreprocessedImage : <code> object </code>",local:"processorspreprocessedimage--code-object-code",headingTag:"h2"}}),br=new g({props:{title:"processors~DetrFeatureExtractorResult : <code> object </code>",local:"processorsdetrfeatureextractorresult--code-object-code",headingTag:"h2"}}),wr=new g({props:{title:"processors~SamImageProcessorResult : <code> object </code>",local:"processorssamimageprocessorresult--code-object-code",headingTag:"h2"}}),Cr=new oc({props:{source:"https://github.com/xenova/transformers.js/blob/main/docs/source/api/processors.md"}}),{c(){x=l("meta"),Jr=s(),Pr=l("p"),Ir=s(),T=l("a"),Fr=s(),p(b.$$.fragment),kr=s(),y=l("p"),y.textContent=dd,Lr=s(),v=l("p"),v.innerHTML=id,jr=s(),p($.$$.fragment),zr=s(),w=l("ul"),w.innerHTML=cd,Ar=s(),Rr=l("hr"),Ur=s(),M=l("a"),Dr=s(),p(E.$$.fragment),Br=s(),C=l("p"),C.textContent=pd,Wr=s(),P=l("p"),P.innerHTML=md,Gr=s(),H=l("ul"),H.innerHTML=nd,Nr=s(),Zr=l("hr"),Qr=s(),J=l("a"),Xr=s(),p(I.$$.fragment),Vr=s(),F=l("p"),F.textContent=ud,Yr=s(),k=l("table"),k.innerHTML=hd,Sr=s(),Kr=l("hr"),qr=s(),L=l("a"),Or=s(),p(j.$$.fragment),eo=s(),z=l("p"),z.textContent=fd,to=s(),A=l("p"),A.innerHTML=_d,ro=s(),R=l("ul"),R.innerHTML=gd,oo=s(),U=l("table"),U.innerHTML=xd,so=s(),ao=l("hr"),lo=s(),D=l("a"),io=s(),p(B.$$.fragment),co=s(),W=l("p"),W.textContent=Td,po=s(),G=l("p"),G.innerHTML=bd,mo=s(),N=l("ul"),N.innerHTML=yd,no=s(),uo=l("hr"),ho=s(),Z=l("a"),fo=s(),p(Q.$$.fragment),_o=s(),X=l("p"),X.textContent=vd,go=s(),V=l("table"),V.innerHTML=$d,xo=s(),To=l("hr"),bo=s(),Y=l("a"),yo=s(),p(S.$$.fragment),vo=s(),K=l("p"),K.textContent=wd,$o=s(),q=l("p"),q.innerHTML=Md,wo=s(),O=l("table"),O.innerHTML=Ed,Mo=s(),Eo=l("hr"),Co=s(),ee=l("a"),Po=s(),p(te.$$.fragment),Ho=s(),re=l("p"),re.textContent=Cd,Jo=s(),oe=l("p"),oe.innerHTML=Pd,Io=s(),se=l("table"),se.innerHTML=Hd,Fo=s(),ko=l("hr"),Lo=s(),ae=l("a"),jo=s(),p(le.$$.fragment),zo=s(),de=l("p"),de.textContent=Jd,Ao=s(),ie=l("p"),ie.innerHTML=Id,Ro=s(),ce=l("table"),ce.innerHTML=Fd,Uo=s(),Do=l("hr"),Bo=s(),pe=l("a"),Wo=s(),p(me.$$.fragment),Go=s(),ne=l("p"),ne.innerHTML=kd,No=s(),ue=l("p"),ue.innerHTML=Ld,Zo=s(),he=l("table"),he.innerHTML=jd,Qo=s(),Xo=l("hr"),Vo=s(),fe=l("a"),Yo=s(),p(_e.$$.fragment),So=s(),ge=l("p"),ge.textContent=zd,Ko=s(),xe=l("p"),xe.innerHTML=Ad,qo=s(),Te=l("table"),Te.innerHTML=Rd,Oo=s(),es=l("hr"),ts=s(),be=l("a"),rs=s(),p(ye.$$.fragment),os=s(),ve=l("p"),ve.textContent=Ud,ss=s(),$e=l("p"),$e.innerHTML=Dd,as=s(),we=l("table"),we.innerHTML=Bd,ls=s(),ds=l("hr"),is=s(),Me=l("a"),cs=s(),p(Ee.$$.fragment),ps=s(),Ce=l("p"),Ce.textContent=Wd,ms=s(),Pe=l("p"),Pe.innerHTML=Gd,ns=s(),He=l("table"),He.innerHTML=Nd,us=s(),hs=l("hr"),fs=s(),Je=l("a"),_s=s(),p(Ie.$$.fragment),gs=s(),Fe=l("p"),Fe.textContent=Zd,xs=s(),ke=l("p"),ke.innerHTML=Qd,Ts=s(),Le=l("table"),Le.innerHTML=Xd,bs=s(),ys=l("hr"),vs=s(),je=l("a"),$s=s(),p(ze.$$.fragment),ws=s(),Ae=l("p"),Ae.textContent=Vd,Ms=s(),Re=l("p"),Re.innerHTML=Yd,Es=s(),Ue=l("ul"),Ue.innerHTML=Sd,Cs=s(),Ps=l("hr"),Hs=s(),De=l("a"),Js=s(),p(Be.$$.fragment),Is=s(),We=l("p"),We.textContent=Kd,Fs=s(),Ge=l("p"),Ge.innerHTML=qd,ks=s(),Ne=l("table"),Ne.innerHTML=Od,Ls=s(),js=l("hr"),zs=s(),Ze=l("a"),As=s(),p(Qe.$$.fragment),Rs=s(),Xe=l("p"),Xe.innerHTML=ei,Us=s(),Ds=l("hr"),Bs=s(),Ve=l("a"),Ws=s(),p(Ye.$$.fragment),Gs=s(),Se=l("p"),Se.innerHTML=ti,Ns=s(),Ke=l("p"),Ke.innerHTML=ri,Zs=s(),qe=l("table"),qe.innerHTML=oi,Qs=s(),Xs=l("hr"),Vs=s(),Oe=l("a"),Ys=s(),p(et.$$.fragment),Ss=s(),tt=l("p"),tt.textContent=si,Ks=s(),rt=l("p"),rt.innerHTML=ai,qs=s(),ot=l("table"),ot.innerHTML=li,Os=s(),ea=l("hr"),ta=s(),st=l("a"),ra=s(),p(at.$$.fragment),oa=s(),lt=l("p"),lt.textContent=di,sa=s(),dt=l("p"),dt.innerHTML=ii,aa=s(),it=l("table"),it.innerHTML=ci,la=s(),da=l("hr"),ia=s(),ct=l("a"),ca=s(),p(pt.$$.fragment),pa=s(),mt=l("p"),mt.textContent=pi,ma=s(),nt=l("p"),nt.innerHTML=mi,na=s(),ut=l("table"),ut.innerHTML=ni,ua=s(),ha=l("hr"),fa=s(),ht=l("a"),_a=s(),p(ft.$$.fragment),ga=s(),_t=l("p"),_t.textContent=ui,xa=s(),gt=l("p"),gt.innerHTML=hi,Ta=s(),xt=l("ul"),xt.innerHTML=fi,ba=s(),ya=l("hr"),va=s(),Tt=l("a"),$a=s(),p(bt.$$.fragment),wa=s(),yt=l("p"),yt.textContent=_i,Ma=s(),vt=l("table"),vt.innerHTML=gi,Ea=s(),Ca=l("hr"),Pa=s(),$t=l("a"),Ha=s(),p(wt.$$.fragment),Ja=s(),Mt=l("p"),Mt.textContent=xi,Ia=s(),Et=l("p"),Et.innerHTML=Ti,Fa=s(),Ct=l("table"),Ct.innerHTML=bi,ka=s(),La=l("hr"),ja=s(),Pt=l("a"),za=s(),p(Ht.$$.fragment),Aa=s(),Jt=l("p"),Jt.textContent=yi,Ra=s(),It=l("p"),It.innerHTML=vi,Ua=s(),Da=l("hr"),Ba=s(),Ft=l("a"),Wa=s(),p(kt.$$.fragment),Ga=s(),Lt=l("p"),Lt.textContent=$i,Na=s(),jt=l("p"),jt.innerHTML=wi,Za=s(),zt=l("table"),zt.innerHTML=Mi,Qa=s(),Xa=l("hr"),Va=s(),At=l("a"),Ya=s(),p(Rt.$$.fragment),Sa=s(),Ut=l("p"),Ut.innerHTML=Ei,Ka=s(),Dt=l("p"),Dt.innerHTML=Ci,qa=s(),p(Bt.$$.fragment),Oa=s(),Wt=l("p"),Wt.innerHTML=Pi,el=s(),p(Gt.$$.fragment),tl=s(),Nt=l("p"),Nt.innerHTML=Hi,rl=s(),ol=l("hr"),sl=s(),Zt=l("a"),al=s(),p(Qt.$$.fragment),ll=s(),Xt=l("p"),Xt.textContent=Ji,dl=s(),Vt=l("p"),Vt.innerHTML=Ii,il=s(),Yt=l("p"),Yt.innerHTML=Fi,cl=s(),St=l("table"),St.innerHTML=ki,pl=s(),ml=l("hr"),nl=s(),Kt=l("a"),ul=s(),p(qt.$$.fragment),hl=s(),Ot=l("p"),Ot.textContent=Li,fl=s(),er=l("p"),er.innerHTML=ji,_l=s(),tr=l("table"),tr.innerHTML=zi,gl=s(),xl=l("hr"),Tl=s(),rr=l("a"),bl=s(),p(or.$$.fragment),yl=s(),sr=l("p"),sr.textContent=Ai,vl=s(),ar=l("p"),ar.innerHTML=Ri,$l=s(),lr=l("table"),lr.innerHTML=Ui,wl=s(),Ml=l("hr"),El=s(),dr=l("a"),Cl=s(),p(ir.$$.fragment),Pl=s(),cr=l("p"),cr.textContent=Di,Hl=s(),pr=l("p"),pr.innerHTML=Bi,Jl=s(),Il=l("hr"),Fl=s(),mr=l("a"),kl=s(),p(nr.$$.fragment),Ll=s(),ur=l("p"),ur.innerHTML=Wi,jl=s(),hr=l("table"),hr.innerHTML=Gi,zl=s(),Al=l("hr"),Rl=s(),fr=l("a"),Ul=s(),p(_r.$$.fragment),Dl=s(),gr=l("p"),gr.innerHTML=Ni,Bl=s(),xr=l("table"),xr.innerHTML=Zi,Wl=s(),Gl=l("hr"),Nl=s(),Tr=l("a"),Zl=s(),p(br.$$.fragment),Ql=s(),yr=l("p"),yr.innerHTML=Qi,Xl=s(),vr=l("table"),vr.innerHTML=Xi,Vl=s(),Yl=l("hr"),Sl=s(),$r=l("a"),Kl=s(),p(wr.$$.fragment),ql=s(),Mr=l("p"),Mr.innerHTML=Vi,Ol=s(),Er=l("table"),Er.innerHTML=Yi,ed=s(),td=l("hr"),rd=s(),p(Cr.$$.fragment),od=s(),Hr=l("p"),this.h()},l(e){const t=tc("svelte-u9bgzb",document.head);x=d(t,"META",{name:!0,content:!0}),t.forEach(r),Jr=a(e),Pr=d(e,"P",{}),_(Pr).forEach(r),Ir=a(e),T=d(e,"A",{id:!0,class:!0}),_(T).forEach(r),Fr=a(e),m(b.$$.fragment,e),kr=a(e),y=d(e,"P",{"data-svelte-h":!0}),i(y)!=="svelte-w0rx8m"&&(y.textContent=dd),Lr=a(e),v=d(e,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1olsie5"&&(v.innerHTML=id),jr=a(e),m($.$$.fragment,e),zr=a(e),w=d(e,"UL",{"data-svelte-h":!0}),i(w)!=="svelte-wm6ck5"&&(w.innerHTML=cd),Ar=a(e),Rr=d(e,"HR",{}),Ur=a(e),M=d(e,"A",{id:!0,class:!0}),_(M).forEach(r),Dr=a(e),m(E.$$.fragment,e),Br=a(e),C=d(e,"P",{"data-svelte-h":!0}),i(C)!=="svelte-14r3pvv"&&(C.textContent=pd),Wr=a(e),P=d(e,"P",{"data-svelte-h":!0}),i(P)!=="svelte-13iv745"&&(P.innerHTML=md),Gr=a(e),H=d(e,"UL",{"data-svelte-h":!0}),i(H)!=="svelte-16exrlt"&&(H.innerHTML=nd),Nr=a(e),Zr=d(e,"HR",{}),Qr=a(e),J=d(e,"A",{id:!0,class:!0}),_(J).forEach(r),Xr=a(e),m(I.$$.fragment,e),Vr=a(e),F=d(e,"P",{"data-svelte-h":!0}),i(F)!=="svelte-k3m2wg"&&(F.textContent=ud),Yr=a(e),k=d(e,"TABLE",{"data-svelte-h":!0}),i(k)!=="svelte-rd7ds7"&&(k.innerHTML=hd),Sr=a(e),Kr=d(e,"HR",{}),qr=a(e),L=d(e,"A",{id:!0,class:!0}),_(L).forEach(r),Or=a(e),m(j.$$.fragment,e),eo=a(e),z=d(e,"P",{"data-svelte-h":!0}),i(z)!=="svelte-8c74gj"&&(z.textContent=fd),to=a(e),A=d(e,"P",{"data-svelte-h":!0}),i(A)!=="svelte-syym47"&&(A.innerHTML=_d),ro=a(e),R=d(e,"UL",{"data-svelte-h":!0}),i(R)!=="svelte-7c1v8c"&&(R.innerHTML=gd),oo=a(e),U=d(e,"TABLE",{"data-svelte-h":!0}),i(U)!=="svelte-1v34kj"&&(U.innerHTML=xd),so=a(e),ao=d(e,"HR",{}),lo=a(e),D=d(e,"A",{id:!0,class:!0}),_(D).forEach(r),io=a(e),m(B.$$.fragment,e),co=a(e),W=d(e,"P",{"data-svelte-h":!0}),i(W)!=="svelte-8k8cys"&&(W.textContent=Td),po=a(e),G=d(e,"P",{"data-svelte-h":!0}),i(G)!=="svelte-18p52n5"&&(G.innerHTML=bd),mo=a(e),N=d(e,"UL",{"data-svelte-h":!0}),i(N)!=="svelte-1ne2ywl"&&(N.innerHTML=yd),no=a(e),uo=d(e,"HR",{}),ho=a(e),Z=d(e,"A",{id:!0,class:!0}),_(Z).forEach(r),fo=a(e),m(Q.$$.fragment,e),_o=a(e),X=d(e,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1mp2vol"&&(X.textContent=vd),go=a(e),V=d(e,"TABLE",{"data-svelte-h":!0}),i(V)!=="svelte-1131cyk"&&(V.innerHTML=$d),xo=a(e),To=d(e,"HR",{}),bo=a(e),Y=d(e,"A",{id:!0,class:!0}),_(Y).forEach(r),yo=a(e),m(S.$$.fragment,e),vo=a(e),K=d(e,"P",{"data-svelte-h":!0}),i(K)!=="svelte-1q6eyx4"&&(K.textContent=wd),$o=a(e),q=d(e,"P",{"data-svelte-h":!0}),i(q)!=="svelte-ar7q77"&&(q.innerHTML=Md),wo=a(e),O=d(e,"TABLE",{"data-svelte-h":!0}),i(O)!=="svelte-klyf4z"&&(O.innerHTML=Ed),Mo=a(e),Eo=d(e,"HR",{}),Co=a(e),ee=d(e,"A",{id:!0,class:!0}),_(ee).forEach(r),Po=a(e),m(te.$$.fragment,e),Ho=a(e),re=d(e,"P",{"data-svelte-h":!0}),i(re)!=="svelte-7fx89a"&&(re.textContent=Cd),Jo=a(e),oe=d(e,"P",{"data-svelte-h":!0}),i(oe)!=="svelte-65os4c"&&(oe.innerHTML=Pd),Io=a(e),se=d(e,"TABLE",{"data-svelte-h":!0}),i(se)!=="svelte-1dnvwno"&&(se.innerHTML=Hd),Fo=a(e),ko=d(e,"HR",{}),Lo=a(e),ae=d(e,"A",{id:!0,class:!0}),_(ae).forEach(r),jo=a(e),m(le.$$.fragment,e),zo=a(e),de=d(e,"P",{"data-svelte-h":!0}),i(de)!=="svelte-1mmkb9p"&&(de.textContent=Jd),Ao=a(e),ie=d(e,"P",{"data-svelte-h":!0}),i(ie)!=="svelte-110o3sn"&&(ie.innerHTML=Id),Ro=a(e),ce=d(e,"TABLE",{"data-svelte-h":!0}),i(ce)!=="svelte-mhh1xm"&&(ce.innerHTML=Fd),Uo=a(e),Do=d(e,"HR",{}),Bo=a(e),pe=d(e,"A",{id:!0,class:!0}),_(pe).forEach(r),Wo=a(e),m(me.$$.fragment,e),Go=a(e),ne=d(e,"P",{"data-svelte-h":!0}),i(ne)!=="svelte-pyd72v"&&(ne.innerHTML=kd),No=a(e),ue=d(e,"P",{"data-svelte-h":!0}),i(ue)!=="svelte-1isxmg1"&&(ue.innerHTML=Ld),Zo=a(e),he=d(e,"TABLE",{"data-svelte-h":!0}),i(he)!=="svelte-1e1ka8e"&&(he.innerHTML=jd),Qo=a(e),Xo=d(e,"HR",{}),Vo=a(e),fe=d(e,"A",{id:!0,class:!0}),_(fe).forEach(r),Yo=a(e),m(_e.$$.fragment,e),So=a(e),ge=d(e,"P",{"data-svelte-h":!0}),i(ge)!=="svelte-8leww2"&&(ge.textContent=zd),Ko=a(e),xe=d(e,"P",{"data-svelte-h":!0}),i(xe)!=="svelte-eqxqo6"&&(xe.innerHTML=Ad),qo=a(e),Te=d(e,"TABLE",{"data-svelte-h":!0}),i(Te)!=="svelte-1n361ub"&&(Te.innerHTML=Rd),Oo=a(e),es=d(e,"HR",{}),ts=a(e),be=d(e,"A",{id:!0,class:!0}),_(be).forEach(r),rs=a(e),m(ye.$$.fragment,e),os=a(e),ve=d(e,"P",{"data-svelte-h":!0}),i(ve)!=="svelte-5iny39"&&(ve.textContent=Ud),ss=a(e),$e=d(e,"P",{"data-svelte-h":!0}),i($e)!=="svelte-ar7q77"&&($e.innerHTML=Dd),as=a(e),we=d(e,"TABLE",{"data-svelte-h":!0}),i(we)!=="svelte-d8vk38"&&(we.innerHTML=Bd),ls=a(e),ds=d(e,"HR",{}),is=a(e),Me=d(e,"A",{id:!0,class:!0}),_(Me).forEach(r),cs=a(e),m(Ee.$$.fragment,e),ps=a(e),Ce=d(e,"P",{"data-svelte-h":!0}),i(Ce)!=="svelte-10g8wi9"&&(Ce.textContent=Wd),ms=a(e),Pe=d(e,"P",{"data-svelte-h":!0}),i(Pe)!=="svelte-cd20o3"&&(Pe.innerHTML=Gd),ns=a(e),He=d(e,"TABLE",{"data-svelte-h":!0}),i(He)!=="svelte-1773mps"&&(He.innerHTML=Nd),us=a(e),hs=d(e,"HR",{}),fs=a(e),Je=d(e,"A",{id:!0,class:!0}),_(Je).forEach(r),_s=a(e),m(Ie.$$.fragment,e),gs=a(e),Fe=d(e,"P",{"data-svelte-h":!0}),i(Fe)!=="svelte-1uytqp8"&&(Fe.textContent=Zd),xs=a(e),ke=d(e,"P",{"data-svelte-h":!0}),i(ke)!=="svelte-1pa0uk8"&&(ke.innerHTML=Qd),Ts=a(e),Le=d(e,"TABLE",{"data-svelte-h":!0}),i(Le)!=="svelte-hch5rz"&&(Le.innerHTML=Xd),bs=a(e),ys=d(e,"HR",{}),vs=a(e),je=d(e,"A",{id:!0,class:!0}),_(je).forEach(r),$s=a(e),m(ze.$$.fragment,e),ws=a(e),Ae=d(e,"P",{"data-svelte-h":!0}),i(Ae)!=="svelte-y1gxwn"&&(Ae.textContent=Vd),Ms=a(e),Re=d(e,"P",{"data-svelte-h":!0}),i(Re)!=="svelte-1xz91ac"&&(Re.innerHTML=Yd),Es=a(e),Ue=d(e,"UL",{"data-svelte-h":!0}),i(Ue)!=="svelte-1obx36y"&&(Ue.innerHTML=Sd),Cs=a(e),Ps=d(e,"HR",{}),Hs=a(e),De=d(e,"A",{id:!0,class:!0}),_(De).forEach(r),Js=a(e),m(Be.$$.fragment,e),Is=a(e),We=d(e,"P",{"data-svelte-h":!0}),i(We)!=="svelte-1ec3vsm"&&(We.textContent=Kd),Fs=a(e),Ge=d(e,"P",{"data-svelte-h":!0}),i(Ge)!=="svelte-6tjpr7"&&(Ge.innerHTML=qd),ks=a(e),Ne=d(e,"TABLE",{"data-svelte-h":!0}),i(Ne)!=="svelte-1px7bnv"&&(Ne.innerHTML=Od),Ls=a(e),js=d(e,"HR",{}),zs=a(e),Ze=d(e,"A",{id:!0,class:!0}),_(Ze).forEach(r),As=a(e),m(Qe.$$.fragment,e),Rs=a(e),Xe=d(e,"P",{"data-svelte-h":!0}),i(Xe)!=="svelte-j2v54d"&&(Xe.innerHTML=ei),Us=a(e),Ds=d(e,"HR",{}),Bs=a(e),Ve=d(e,"A",{id:!0,class:!0}),_(Ve).forEach(r),Ws=a(e),m(Ye.$$.fragment,e),Gs=a(e),Se=d(e,"P",{"data-svelte-h":!0}),i(Se)!=="svelte-75c7d5"&&(Se.innerHTML=ti),Ns=a(e),Ke=d(e,"P",{"data-svelte-h":!0}),i(Ke)!=="svelte-o8p6wm"&&(Ke.innerHTML=ri),Zs=a(e),qe=d(e,"TABLE",{"data-svelte-h":!0}),i(qe)!=="svelte-yqya7v"&&(qe.innerHTML=oi),Qs=a(e),Xs=d(e,"HR",{}),Vs=a(e),Oe=d(e,"A",{id:!0,class:!0}),_(Oe).forEach(r),Ys=a(e),m(et.$$.fragment,e),Ss=a(e),tt=d(e,"P",{"data-svelte-h":!0}),i(tt)!=="svelte-gl8gb6"&&(tt.textContent=si),Ks=a(e),rt=d(e,"P",{"data-svelte-h":!0}),i(rt)!=="svelte-1qxvzd2"&&(rt.innerHTML=ai),qs=a(e),ot=d(e,"TABLE",{"data-svelte-h":!0}),i(ot)!=="svelte-1f7z42u"&&(ot.innerHTML=li),Os=a(e),ea=d(e,"HR",{}),ta=a(e),st=d(e,"A",{id:!0,class:!0}),_(st).forEach(r),ra=a(e),m(at.$$.fragment,e),oa=a(e),lt=d(e,"P",{"data-svelte-h":!0}),i(lt)!=="svelte-7vs1p7"&&(lt.textContent=di),sa=a(e),dt=d(e,"P",{"data-svelte-h":!0}),i(dt)!=="svelte-15rcpil"&&(dt.innerHTML=ii),aa=a(e),it=d(e,"TABLE",{"data-svelte-h":!0}),i(it)!=="svelte-3xdz32"&&(it.innerHTML=ci),la=a(e),da=d(e,"HR",{}),ia=a(e),ct=d(e,"A",{id:!0,class:!0}),_(ct).forEach(r),ca=a(e),m(pt.$$.fragment,e),pa=a(e),mt=d(e,"P",{"data-svelte-h":!0}),i(mt)!=="svelte-frdp8m"&&(mt.textContent=pi),ma=a(e),nt=d(e,"P",{"data-svelte-h":!0}),i(nt)!=="svelte-j2v54d"&&(nt.innerHTML=mi),na=a(e),ut=d(e,"TABLE",{"data-svelte-h":!0}),i(ut)!=="svelte-11rkhka"&&(ut.innerHTML=ni),ua=a(e),ha=d(e,"HR",{}),fa=a(e),ht=d(e,"A",{id:!0,class:!0}),_(ht).forEach(r),_a=a(e),m(ft.$$.fragment,e),ga=a(e),_t=d(e,"P",{"data-svelte-h":!0}),i(_t)!=="svelte-o9f953"&&(_t.textContent=ui),xa=a(e),gt=d(e,"P",{"data-svelte-h":!0}),i(gt)!=="svelte-13iv745"&&(gt.innerHTML=hi),Ta=a(e),xt=d(e,"UL",{"data-svelte-h":!0}),i(xt)!=="svelte-ceq7pc"&&(xt.innerHTML=fi),ba=a(e),ya=d(e,"HR",{}),va=a(e),Tt=d(e,"A",{id:!0,class:!0}),_(Tt).forEach(r),$a=a(e),m(bt.$$.fragment,e),wa=a(e),yt=d(e,"P",{"data-svelte-h":!0}),i(yt)!=="svelte-1naom0u"&&(yt.textContent=_i),Ma=a(e),vt=d(e,"TABLE",{"data-svelte-h":!0}),i(vt)!=="svelte-ilxs6c"&&(vt.innerHTML=gi),Ea=a(e),Ca=d(e,"HR",{}),Pa=a(e),$t=d(e,"A",{id:!0,class:!0}),_($t).forEach(r),Ha=a(e),m(wt.$$.fragment,e),Ja=a(e),Mt=d(e,"P",{"data-svelte-h":!0}),i(Mt)!=="svelte-zbbm3j"&&(Mt.textContent=xi),Ia=a(e),Et=d(e,"P",{"data-svelte-h":!0}),i(Et)!=="svelte-1hik6yq"&&(Et.innerHTML=Ti),Fa=a(e),Ct=d(e,"TABLE",{"data-svelte-h":!0}),i(Ct)!=="svelte-pm1u9z"&&(Ct.innerHTML=bi),ka=a(e),La=d(e,"HR",{}),ja=a(e),Pt=d(e,"A",{id:!0,class:!0}),_(Pt).forEach(r),za=a(e),m(Ht.$$.fragment,e),Aa=a(e),Jt=d(e,"P",{"data-svelte-h":!0}),i(Jt)!=="svelte-17pib55"&&(Jt.textContent=yi),Ra=a(e),It=d(e,"P",{"data-svelte-h":!0}),i(It)!=="svelte-1ljhyyr"&&(It.innerHTML=vi),Ua=a(e),Da=d(e,"HR",{}),Ba=a(e),Ft=d(e,"A",{id:!0,class:!0}),_(Ft).forEach(r),Wa=a(e),m(kt.$$.fragment,e),Ga=a(e),Lt=d(e,"P",{"data-svelte-h":!0}),i(Lt)!=="svelte-r5x3fh"&&(Lt.textContent=$i),Na=a(e),jt=d(e,"P",{"data-svelte-h":!0}),i(jt)!=="svelte-1vpvonk"&&(jt.innerHTML=wi),Za=a(e),zt=d(e,"TABLE",{"data-svelte-h":!0}),i(zt)!=="svelte-nv3lon"&&(zt.innerHTML=Mi),Qa=a(e),Xa=d(e,"HR",{}),Va=a(e),At=d(e,"A",{id:!0,class:!0}),_(At).forEach(r),Ya=a(e),m(Rt.$$.fragment,e),Sa=a(e),Ut=d(e,"P",{"data-svelte-h":!0}),i(Ut)!=="svelte-62dsf9"&&(Ut.innerHTML=Ei),Ka=a(e),Dt=d(e,"P",{"data-svelte-h":!0}),i(Dt)!=="svelte-11vd43e"&&(Dt.innerHTML=Ci),qa=a(e),m(Bt.$$.fragment,e),Oa=a(e),Wt=d(e,"P",{"data-svelte-h":!0}),i(Wt)!=="svelte-c0cgha"&&(Wt.innerHTML=Pi),el=a(e),m(Gt.$$.fragment,e),tl=a(e),Nt=d(e,"P",{"data-svelte-h":!0}),i(Nt)!=="svelte-wmyz1o"&&(Nt.innerHTML=Hi),rl=a(e),ol=d(e,"HR",{}),sl=a(e),Zt=d(e,"A",{id:!0,class:!0}),_(Zt).forEach(r),al=a(e),m(Qt.$$.fragment,e),ll=a(e),Xt=d(e,"P",{"data-svelte-h":!0}),i(Xt)!=="svelte-jwfdp9"&&(Xt.textContent=Ji),dl=a(e),Vt=d(e,"P",{"data-svelte-h":!0}),i(Vt)!=="svelte-t85gxq"&&(Vt.innerHTML=Ii),il=a(e),Yt=d(e,"P",{"data-svelte-h":!0}),i(Yt)!=="svelte-y7m8db"&&(Yt.innerHTML=Fi),cl=a(e),St=d(e,"TABLE",{"data-svelte-h":!0}),i(St)!=="svelte-1oj79mt"&&(St.innerHTML=ki),pl=a(e),ml=d(e,"HR",{}),nl=a(e),Kt=d(e,"A",{id:!0,class:!0}),_(Kt).forEach(r),ul=a(e),m(qt.$$.fragment,e),hl=a(e),Ot=d(e,"P",{"data-svelte-h":!0}),i(Ot)!=="svelte-kjzox5"&&(Ot.textContent=Li),fl=a(e),er=d(e,"P",{"data-svelte-h":!0}),i(er)!=="svelte-19qboln"&&(er.innerHTML=ji),_l=a(e),tr=d(e,"TABLE",{"data-svelte-h":!0}),i(tr)!=="svelte-1bv5sxq"&&(tr.innerHTML=zi),gl=a(e),xl=d(e,"HR",{}),Tl=a(e),rr=d(e,"A",{id:!0,class:!0}),_(rr).forEach(r),bl=a(e),m(or.$$.fragment,e),yl=a(e),sr=d(e,"P",{"data-svelte-h":!0}),i(sr)!=="svelte-vlkbp"&&(sr.textContent=Ai),vl=a(e),ar=d(e,"P",{"data-svelte-h":!0}),i(ar)!=="svelte-vmdbik"&&(ar.innerHTML=Ri),$l=a(e),lr=d(e,"TABLE",{"data-svelte-h":!0}),i(lr)!=="svelte-4ldb45"&&(lr.innerHTML=Ui),wl=a(e),Ml=d(e,"HR",{}),El=a(e),dr=d(e,"A",{id:!0,class:!0}),_(dr).forEach(r),Cl=a(e),m(ir.$$.fragment,e),Pl=a(e),cr=d(e,"P",{"data-svelte-h":!0}),i(cr)!=="svelte-2u8xbp"&&(cr.textContent=Di),Hl=a(e),pr=d(e,"P",{"data-svelte-h":!0}),i(pr)!=="svelte-3xndnt"&&(pr.innerHTML=Bi),Jl=a(e),Il=d(e,"HR",{}),Fl=a(e),mr=d(e,"A",{id:!0,class:!0}),_(mr).forEach(r),kl=a(e),m(nr.$$.fragment,e),Ll=a(e),ur=d(e,"P",{"data-svelte-h":!0}),i(ur)!=="svelte-cy5pwv"&&(ur.innerHTML=Wi),jl=a(e),hr=d(e,"TABLE",{"data-svelte-h":!0}),i(hr)!=="svelte-1dyar84"&&(hr.innerHTML=Gi),zl=a(e),Al=d(e,"HR",{}),Rl=a(e),fr=d(e,"A",{id:!0,class:!0}),_(fr).forEach(r),Ul=a(e),m(_r.$$.fragment,e),Dl=a(e),gr=d(e,"P",{"data-svelte-h":!0}),i(gr)!=="svelte-cy5pwv"&&(gr.innerHTML=Ni),Bl=a(e),xr=d(e,"TABLE",{"data-svelte-h":!0}),i(xr)!=="svelte-1cnys15"&&(xr.innerHTML=Zi),Wl=a(e),Gl=d(e,"HR",{}),Nl=a(e),Tr=d(e,"A",{id:!0,class:!0}),_(Tr).forEach(r),Zl=a(e),m(br.$$.fragment,e),Ql=a(e),yr=d(e,"P",{"data-svelte-h":!0}),i(yr)!=="svelte-cy5pwv"&&(yr.innerHTML=Qi),Xl=a(e),vr=d(e,"TABLE",{"data-svelte-h":!0}),i(vr)!=="svelte-179cln2"&&(vr.innerHTML=Xi),Vl=a(e),Yl=d(e,"HR",{}),Sl=a(e),$r=d(e,"A",{id:!0,class:!0}),_($r).forEach(r),Kl=a(e),m(wr.$$.fragment,e),ql=a(e),Mr=d(e,"P",{"data-svelte-h":!0}),i(Mr)!=="svelte-cy5pwv"&&(Mr.innerHTML=Vi),Ol=a(e),Er=d(e,"TABLE",{"data-svelte-h":!0}),i(Er)!=="svelte-1nrm9i3"&&(Er.innerHTML=Yi),ed=a(e),td=d(e,"HR",{}),rd=a(e),m(Cr.$$.fragment,e),od=a(e),Hr=d(e,"P",{}),_(Hr).forEach(r),this.h()},h(){c(x,"name","hf:doc:metadata"),c(x,"content",ac),c(T,"id","module_processors"),c(T,"class","group"),c(M,"id","module_processors.FeatureExtractor"),c(M,"class","group"),c(J,"id","new_module_processors.FeatureExtractor_new"),c(J,"class","group"),c(L,"id","Callable+_call"),c(L,"class","group"),c(D,"id","module_processors.ImageFeatureExtractor"),c(D,"class","group"),c(Z,"id","new_module_processors.ImageFeatureExtractor_new"),c(Z,"class","group"),c(Y,"id","module_processors.ImageFeatureExtractor+thumbnail"),c(Y,"class","group"),c(ee,"id","module_processors.ImageFeatureExtractor+crop_margin"),c(ee,"class","group"),c(ae,"id","module_processors.ImageFeatureExtractor+pad_image"),c(ae,"class","group"),c(pe,"id","module_processors.ImageFeatureExtractor+rescale"),c(pe,"class","group"),c(fe,"id","module_processors.ImageFeatureExtractor+get_resize_output_image_size"),c(fe,"class","group"),c(be,"id","module_processors.ImageFeatureExtractor+resize"),c(be,"class","group"),c(Me,"id","module_processors.ImageFeatureExtractor+preprocess"),c(Me,"class","group"),c(Je,"id","module_processors.ImageFeatureExtractor+_call"),c(Je,"class","group"),c(je,"id","module_processors.DetrFeatureExtractor"),c(je,"class","group"),c(De,"id","module_processors.DetrFeatureExtractor+_call"),c(De,"class","group"),c(Ze,"id","module_processors.DetrFeatureExtractor+post_process_object_detection"),c(Ze,"class","group"),c(Ve,"id","module_processors.DetrFeatureExtractor+remove_low_and_no_objects"),c(Ve,"class","group"),c(Oe,"id","module_processors.DetrFeatureExtractor+check_segment_validity"),c(Oe,"class","group"),c(st,"id","module_processors.DetrFeatureExtractor+compute_segments"),c(st,"class","group"),c(ct,"id","module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"),c(ct,"class","group"),c(ht,"id","module_processors.Processor"),c(ht,"class","group"),c(Tt,"id","new_module_processors.Processor_new"),c(Tt,"class","group"),c($t,"id","module_processors.Processor+_call"),c($t,"class","group"),c(Pt,"id","module_processors.WhisperProcessor"),c(Pt,"class","group"),c(Ft,"id","module_processors.WhisperProcessor+_call"),c(Ft,"class","group"),c(At,"id","module_processors.AutoProcessor"),c(At,"class","group"),c(Zt,"id","module_processors.AutoProcessor.from_pretrained"),c(Zt,"class","group"),c(Kt,"id","module_processors..center_to_corners_format"),c(Kt,"class","group"),c(rr,"id","module_processors..enforce_size_divisibility"),c(rr,"class","group"),c(dr,"id","module_processors..HeightWidth"),c(dr,"class","group"),c(mr,"id","module_processors..ImageFeatureExtractorResult"),c(mr,"class","group"),c(fr,"id","module_processors..PreprocessedImage"),c(fr,"class","group"),c(Tr,"id","module_processors..DetrFeatureExtractorResult"),c(Tr,"class","group"),c($r,"id","module_processors..SamImageProcessorResult"),c($r,"class","group")},m(e,t){rc(document.head,x),o(e,Jr,t),o(e,Pr,t),o(e,Ir,t),o(e,T,t),o(e,Fr,t),n(b,e,t),o(e,kr,t),o(e,y,t),o(e,Lr,t),o(e,v,t),o(e,jr,t),n($,e,t),o(e,zr,t),o(e,w,t),o(e,Ar,t),o(e,Rr,t),o(e,Ur,t),o(e,M,t),o(e,Dr,t),n(E,e,t),o(e,Br,t),o(e,C,t),o(e,Wr,t),o(e,P,t),o(e,Gr,t),o(e,H,t),o(e,Nr,t),o(e,Zr,t),o(e,Qr,t),o(e,J,t),o(e,Xr,t),n(I,e,t),o(e,Vr,t),o(e,F,t),o(e,Yr,t),o(e,k,t),o(e,Sr,t),o(e,Kr,t),o(e,qr,t),o(e,L,t),o(e,Or,t),n(j,e,t),o(e,eo,t),o(e,z,t),o(e,to,t),o(e,A,t),o(e,ro,t),o(e,R,t),o(e,oo,t),o(e,U,t),o(e,so,t),o(e,ao,t),o(e,lo,t),o(e,D,t),o(e,io,t),n(B,e,t),o(e,co,t),o(e,W,t),o(e,po,t),o(e,G,t),o(e,mo,t),o(e,N,t),o(e,no,t),o(e,uo,t),o(e,ho,t),o(e,Z,t),o(e,fo,t),n(Q,e,t),o(e,_o,t),o(e,X,t),o(e,go,t),o(e,V,t),o(e,xo,t),o(e,To,t),o(e,bo,t),o(e,Y,t),o(e,yo,t),n(S,e,t),o(e,vo,t),o(e,K,t),o(e,$o,t),o(e,q,t),o(e,wo,t),o(e,O,t),o(e,Mo,t),o(e,Eo,t),o(e,Co,t),o(e,ee,t),o(e,Po,t),n(te,e,t),o(e,Ho,t),o(e,re,t),o(e,Jo,t),o(e,oe,t),o(e,Io,t),o(e,se,t),o(e,Fo,t),o(e,ko,t),o(e,Lo,t),o(e,ae,t),o(e,jo,t),n(le,e,t),o(e,zo,t),o(e,de,t),o(e,Ao,t),o(e,ie,t),o(e,Ro,t),o(e,ce,t),o(e,Uo,t),o(e,Do,t),o(e,Bo,t),o(e,pe,t),o(e,Wo,t),n(me,e,t),o(e,Go,t),o(e,ne,t),o(e,No,t),o(e,ue,t),o(e,Zo,t),o(e,he,t),o(e,Qo,t),o(e,Xo,t),o(e,Vo,t),o(e,fe,t),o(e,Yo,t),n(_e,e,t),o(e,So,t),o(e,ge,t),o(e,Ko,t),o(e,xe,t),o(e,qo,t),o(e,Te,t),o(e,Oo,t),o(e,es,t),o(e,ts,t),o(e,be,t),o(e,rs,t),n(ye,e,t),o(e,os,t),o(e,ve,t),o(e,ss,t),o(e,$e,t),o(e,as,t),o(e,we,t),o(e,ls,t),o(e,ds,t),o(e,is,t),o(e,Me,t),o(e,cs,t),n(Ee,e,t),o(e,ps,t),o(e,Ce,t),o(e,ms,t),o(e,Pe,t),o(e,ns,t),o(e,He,t),o(e,us,t),o(e,hs,t),o(e,fs,t),o(e,Je,t),o(e,_s,t),n(Ie,e,t),o(e,gs,t),o(e,Fe,t),o(e,xs,t),o(e,ke,t),o(e,Ts,t),o(e,Le,t),o(e,bs,t),o(e,ys,t),o(e,vs,t),o(e,je,t),o(e,$s,t),n(ze,e,t),o(e,ws,t),o(e,Ae,t),o(e,Ms,t),o(e,Re,t),o(e,Es,t),o(e,Ue,t),o(e,Cs,t),o(e,Ps,t),o(e,Hs,t),o(e,De,t),o(e,Js,t),n(Be,e,t),o(e,Is,t),o(e,We,t),o(e,Fs,t),o(e,Ge,t),o(e,ks,t),o(e,Ne,t),o(e,Ls,t),o(e,js,t),o(e,zs,t),o(e,Ze,t),o(e,As,t),n(Qe,e,t),o(e,Rs,t),o(e,Xe,t),o(e,Us,t),o(e,Ds,t),o(e,Bs,t),o(e,Ve,t),o(e,Ws,t),n(Ye,e,t),o(e,Gs,t),o(e,Se,t),o(e,Ns,t),o(e,Ke,t),o(e,Zs,t),o(e,qe,t),o(e,Qs,t),o(e,Xs,t),o(e,Vs,t),o(e,Oe,t),o(e,Ys,t),n(et,e,t),o(e,Ss,t),o(e,tt,t),o(e,Ks,t),o(e,rt,t),o(e,qs,t),o(e,ot,t),o(e,Os,t),o(e,ea,t),o(e,ta,t),o(e,st,t),o(e,ra,t),n(at,e,t),o(e,oa,t),o(e,lt,t),o(e,sa,t),o(e,dt,t),o(e,aa,t),o(e,it,t),o(e,la,t),o(e,da,t),o(e,ia,t),o(e,ct,t),o(e,ca,t),n(pt,e,t),o(e,pa,t),o(e,mt,t),o(e,ma,t),o(e,nt,t),o(e,na,t),o(e,ut,t),o(e,ua,t),o(e,ha,t),o(e,fa,t),o(e,ht,t),o(e,_a,t),n(ft,e,t),o(e,ga,t),o(e,_t,t),o(e,xa,t),o(e,gt,t),o(e,Ta,t),o(e,xt,t),o(e,ba,t),o(e,ya,t),o(e,va,t),o(e,Tt,t),o(e,$a,t),n(bt,e,t),o(e,wa,t),o(e,yt,t),o(e,Ma,t),o(e,vt,t),o(e,Ea,t),o(e,Ca,t),o(e,Pa,t),o(e,$t,t),o(e,Ha,t),n(wt,e,t),o(e,Ja,t),o(e,Mt,t),o(e,Ia,t),o(e,Et,t),o(e,Fa,t),o(e,Ct,t),o(e,ka,t),o(e,La,t),o(e,ja,t),o(e,Pt,t),o(e,za,t),n(Ht,e,t),o(e,Aa,t),o(e,Jt,t),o(e,Ra,t),o(e,It,t),o(e,Ua,t),o(e,Da,t),o(e,Ba,t),o(e,Ft,t),o(e,Wa,t),n(kt,e,t),o(e,Ga,t),o(e,Lt,t),o(e,Na,t),o(e,jt,t),o(e,Za,t),o(e,zt,t),o(e,Qa,t),o(e,Xa,t),o(e,Va,t),o(e,At,t),o(e,Ya,t),n(Rt,e,t),o(e,Sa,t),o(e,Ut,t),o(e,Ka,t),o(e,Dt,t),o(e,qa,t),n(Bt,e,t),o(e,Oa,t),o(e,Wt,t),o(e,el,t),n(Gt,e,t),o(e,tl,t),o(e,Nt,t),o(e,rl,t),o(e,ol,t),o(e,sl,t),o(e,Zt,t),o(e,al,t),n(Qt,e,t),o(e,ll,t),o(e,Xt,t),o(e,dl,t),o(e,Vt,t),o(e,il,t),o(e,Yt,t),o(e,cl,t),o(e,St,t),o(e,pl,t),o(e,ml,t),o(e,nl,t),o(e,Kt,t),o(e,ul,t),n(qt,e,t),o(e,hl,t),o(e,Ot,t),o(e,fl,t),o(e,er,t),o(e,_l,t),o(e,tr,t),o(e,gl,t),o(e,xl,t),o(e,Tl,t),o(e,rr,t),o(e,bl,t),n(or,e,t),o(e,yl,t),o(e,sr,t),o(e,vl,t),o(e,ar,t),o(e,$l,t),o(e,lr,t),o(e,wl,t),o(e,Ml,t),o(e,El,t),o(e,dr,t),o(e,Cl,t),n(ir,e,t),o(e,Pl,t),o(e,cr,t),o(e,Hl,t),o(e,pr,t),o(e,Jl,t),o(e,Il,t),o(e,Fl,t),o(e,mr,t),o(e,kl,t),n(nr,e,t),o(e,Ll,t),o(e,ur,t),o(e,jl,t),o(e,hr,t),o(e,zl,t),o(e,Al,t),o(e,Rl,t),o(e,fr,t),o(e,Ul,t),n(_r,e,t),o(e,Dl,t),o(e,gr,t),o(e,Bl,t),o(e,xr,t),o(e,Wl,t),o(e,Gl,t),o(e,Nl,t),o(e,Tr,t),o(e,Zl,t),n(br,e,t),o(e,Ql,t),o(e,yr,t),o(e,Xl,t),o(e,vr,t),o(e,Vl,t),o(e,Yl,t),o(e,Sl,t),o(e,$r,t),o(e,Kl,t),n(wr,e,t),o(e,ql,t),o(e,Mr,t),o(e,Ol,t),o(e,Er,t),o(e,ed,t),o(e,td,t),o(e,rd,t),n(Cr,e,t),o(e,od,t),o(e,Hr,t),sd=!0},p:Ki,i(e){sd||(u(b.$$.fragment,e),u($.$$.fragment,e),u(E.$$.fragment,e),u(I.$$.fragment,e),u(j.$$.fragment,e),u(B.$$.fragment,e),u(Q.$$.fragment,e),u(S.$$.fragment,e),u(te.$$.fragment,e),u(le.$$.fragment,e),u(me.$$.fragment,e),u(_e.$$.fragment,e),u(ye.$$.fragment,e),u(Ee.$$.fragment,e),u(Ie.$$.fragment,e),u(ze.$$.fragment,e),u(Be.$$.fragment,e),u(Qe.$$.fragment,e),u(Ye.$$.fragment,e),u(et.$$.fragment,e),u(at.$$.fragment,e),u(pt.$$.fragment,e),u(ft.$$.fragment,e),u(bt.$$.fragment,e),u(wt.$$.fragment,e),u(Ht.$$.fragment,e),u(kt.$$.fragment,e),u(Rt.$$.fragment,e),u(Bt.$$.fragment,e),u(Gt.$$.fragment,e),u(Qt.$$.fragment,e),u(qt.$$.fragment,e),u(or.$$.fragment,e),u(ir.$$.fragment,e),u(nr.$$.fragment,e),u(_r.$$.fragment,e),u(br.$$.fragment,e),u(wr.$$.fragment,e),u(Cr.$$.fragment,e),sd=!0)},o(e){h(b.$$.fragment,e),h($.$$.fragment,e),h(E.$$.fragment,e),h(I.$$.fragment,e),h(j.$$.fragment,e),h(B.$$.fragment,e),h(Q.$$.fragment,e),h(S.$$.fragment,e),h(te.$$.fragment,e),h(le.$$.fragment,e),h(me.$$.fragment,e),h(_e.$$.fragment,e),h(ye.$$.fragment,e),h(Ee.$$.fragment,e),h(Ie.$$.fragment,e),h(ze.$$.fragment,e),h(Be.$$.fragment,e),h(Qe.$$.fragment,e),h(Ye.$$.fragment,e),h(et.$$.fragment,e),h(at.$$.fragment,e),h(pt.$$.fragment,e),h(ft.$$.fragment,e),h(bt.$$.fragment,e),h(wt.$$.fragment,e),h(Ht.$$.fragment,e),h(kt.$$.fragment,e),h(Rt.$$.fragment,e),h(Bt.$$.fragment,e),h(Gt.$$.fragment,e),h(Qt.$$.fragment,e),h(qt.$$.fragment,e),h(or.$$.fragment,e),h(ir.$$.fragment,e),h(nr.$$.fragment,e),h(_r.$$.fragment,e),h(br.$$.fragment,e),h(wr.$$.fragment,e),h(Cr.$$.fragment,e),sd=!1},d(e){e&&(r(Jr),r(Pr),r(Ir),r(T),r(Fr),r(kr),r(y),r(Lr),r(v),r(jr),r(zr),r(w),r(Ar),r(Rr),r(Ur),r(M),r(Dr),r(Br),r(C),r(Wr),r(P),r(Gr),r(H),r(Nr),r(Zr),r(Qr),r(J),r(Xr),r(Vr),r(F),r(Yr),r(k),r(Sr),r(Kr),r(qr),r(L),r(Or),r(eo),r(z),r(to),r(A),r(ro),r(R),r(oo),r(U),r(so),r(ao),r(lo),r(D),r(io),r(co),r(W),r(po),r(G),r(mo),r(N),r(no),r(uo),r(ho),r(Z),r(fo),r(_o),r(X),r(go),r(V),r(xo),r(To),r(bo),r(Y),r(yo),r(vo),r(K),r($o),r(q),r(wo),r(O),r(Mo),r(Eo),r(Co),r(ee),r(Po),r(Ho),r(re),r(Jo),r(oe),r(Io),r(se),r(Fo),r(ko),r(Lo),r(ae),r(jo),r(zo),r(de),r(Ao),r(ie),r(Ro),r(ce),r(Uo),r(Do),r(Bo),r(pe),r(Wo),r(Go),r(ne),r(No),r(ue),r(Zo),r(he),r(Qo),r(Xo),r(Vo),r(fe),r(Yo),r(So),r(ge),r(Ko),r(xe),r(qo),r(Te),r(Oo),r(es),r(ts),r(be),r(rs),r(os),r(ve),r(ss),r($e),r(as),r(we),r(ls),r(ds),r(is),r(Me),r(cs),r(ps),r(Ce),r(ms),r(Pe),r(ns),r(He),r(us),r(hs),r(fs),r(Je),r(_s),r(gs),r(Fe),r(xs),r(ke),r(Ts),r(Le),r(bs),r(ys),r(vs),r(je),r($s),r(ws),r(Ae),r(Ms),r(Re),r(Es),r(Ue),r(Cs),r(Ps),r(Hs),r(De),r(Js),r(Is),r(We),r(Fs),r(Ge),r(ks),r(Ne),r(Ls),r(js),r(zs),r(Ze),r(As),r(Rs),r(Xe),r(Us),r(Ds),r(Bs),r(Ve),r(Ws),r(Gs),r(Se),r(Ns),r(Ke),r(Zs),r(qe),r(Qs),r(Xs),r(Vs),r(Oe),r(Ys),r(Ss),r(tt),r(Ks),r(rt),r(qs),r(ot),r(Os),r(ea),r(ta),r(st),r(ra),r(oa),r(lt),r(sa),r(dt),r(aa),r(it),r(la),r(da),r(ia),r(ct),r(ca),r(pa),r(mt),r(ma),r(nt),r(na),r(ut),r(ua),r(ha),r(fa),r(ht),r(_a),r(ga),r(_t),r(xa),r(gt),r(Ta),r(xt),r(ba),r(ya),r(va),r(Tt),r($a),r(wa),r(yt),r(Ma),r(vt),r(Ea),r(Ca),r(Pa),r($t),r(Ha),r(Ja),r(Mt),r(Ia),r(Et),r(Fa),r(Ct),r(ka),r(La),r(ja),r(Pt),r(za),r(Aa),r(Jt),r(Ra),r(It),r(Ua),r(Da),r(Ba),r(Ft),r(Wa),r(Ga),r(Lt),r(Na),r(jt),r(Za),r(zt),r(Qa),r(Xa),r(Va),r(At),r(Ya),r(Sa),r(Ut),r(Ka),r(Dt),r(qa),r(Oa),r(Wt),r(el),r(tl),r(Nt),r(rl),r(ol),r(sl),r(Zt),r(al),r(ll),r(Xt),r(dl),r(Vt),r(il),r(Yt),r(cl),r(St),r(pl),r(ml),r(nl),r(Kt),r(ul),r(hl),r(Ot),r(fl),r(er),r(_l),r(tr),r(gl),r(xl),r(Tl),r(rr),r(bl),r(yl),r(sr),r(vl),r(ar),r($l),r(lr),r(wl),r(Ml),r(El),r(dr),r(Cl),r(Pl),r(cr),r(Hl),r(pr),r(Jl),r(Il),r(Fl),r(mr),r(kl),r(Ll),r(ur),r(jl),r(hr),r(zl),r(Al),r(Rl),r(fr),r(Ul),r(Dl),r(gr),r(Bl),r(xr),r(Wl),r(Gl),r(Nl),r(Tr),r(Zl),r(Ql),r(yr),r(Xl),r(vr),r(Vl),r(Yl),r(Sl),r($r),r(Kl),r(ql),r(Mr),r(Ol),r(Er),r(ed),r(td),r(rd),r(od),r(Hr)),r(x),f(b,e),f($,e),f(E,e),f(I,e),f(j,e),f(B,e),f(Q,e),f(S,e),f(te,e),f(le,e),f(me,e),f(_e,e),f(ye,e),f(Ee,e),f(Ie,e),f(ze,e),f(Be,e),f(Qe,e),f(Ye,e),f(et,e),f(at,e),f(pt,e),f(ft,e),f(bt,e),f(wt,e),f(Ht,e),f(kt,e),f(Rt,e),f(Bt,e),f(Gt,e),f(Qt,e),f(qt,e),f(or,e),f(ir,e),f(nr,e),f(_r,e),f(br,e),f(wr,e),f(Cr,e)}}}const ac='{"title":"processors","local":"processors","sections":[{"title":"processors.FeatureExtractor ⇐ <code> Callable </code>","local":"processorsfeatureextractor--code-callable-code","sections":[{"title":"new FeatureExtractor(config)","local":"new-featureextractorconfig","sections":[],"depth":3},{"title":"featureExtractor._call(...args)","local":"featureextractorcallargs","sections":[],"depth":3}],"depth":2},{"title":"processors.ImageFeatureExtractor ⇐ <code> FeatureExtractor </code>","local":"processorsimagefeatureextractor--code-featureextractor-code","sections":[{"title":"new ImageFeatureExtractor(config)","local":"new-imagefeatureextractorconfig","sections":[],"depth":3},{"title":"imageFeatureExtractor.thumbnail(image, size, [resample]) ⇒ <code> Promise. < RawImage > </code>","local":"imagefeatureextractorthumbnailimage-size-resample--code-promise--rawimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.crop_margin(image, gray_threshold) ⇒ <code> Promise. < RawImage > </code>","local":"imagefeatureextractorcropmarginimage-graythreshold--code-promise--rawimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.pad_image(pixelData, imgDims, padSize, options) ⇒ <code> * </code>","local":"imagefeatureextractorpadimagepixeldata-imgdims-padsize-options--code--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.rescale(pixelData) ⇒ <code> void </code>","local":"imagefeatureextractorrescalepixeldata--code-void-code","sections":[],"depth":3},{"title":"imageFeatureExtractor.get_resize_output_image_size(image, size) ⇒ <code> * </code>","local":"imagefeatureextractorgetresizeoutputimagesizeimage-size--code--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.resize(image) ⇒ <code> Promise. < RawImage > </code>","local":"imagefeatureextractorresizeimage--code-promise--rawimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.preprocess(image, overrides) ⇒ <code> Promise. < PreprocessedImage > </code>","local":"imagefeatureextractorpreprocessimage-overrides--code-promise--preprocessedimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor._call(images, ...args) ⇒ <code> Promise. < ImageFeatureExtractorResult > </code>","local":"imagefeatureextractorcallimages-args--code-promise--imagefeatureextractorresult--code","sections":[],"depth":3}],"depth":2},{"title":"processors.DetrFeatureExtractor ⇐ <code> ImageFeatureExtractor </code>","local":"processorsdetrfeatureextractor--code-imagefeatureextractor-code","sections":[{"title":"detrFeatureExtractor._call(images) ⇒ <code> Promise. < DetrFeatureExtractorResult > </code>","local":"detrfeatureextractorcallimages--code-promise--detrfeatureextractorresult--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.post_process_object_detection() : <code> post_process_object_detection </code>","local":"detrfeatureextractorpostprocessobjectdetection--code-postprocessobjectdetection-code","sections":[],"depth":3},{"title":"detrFeatureExtractor.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels) ⇒ <code> * </code>","local":"detrfeatureextractorremovelowandnoobjectsclasslogits-masklogits-objectmaskthreshold-numlabels--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold) ⇒ <code> * </code>","local":"detrfeatureextractorchecksegmentvaliditymasklabels-maskprobs-k-maskthreshold-overlapmaskareathreshold--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size) ⇒ <code> * </code>","local":"detrfeatureextractorcomputesegmentsmaskprobs-predscores-predlabels-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsize--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes]) ⇒ <code> Array. < {segmentation: Tensor, segments_info: Array < {id: number, label_id: number, score: number} > } > </code>","local":"detrfeatureextractorpostprocesspanopticsegmentationoutputs-threshold-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsizes--code-array--segmentation-tensor-segmentsinfo-array--id-number-labelid-number-score-number----code","sections":[],"depth":3}],"depth":2},{"title":"processors.Processor ⇐ <code> Callable </code>","local":"processorsprocessor--code-callable-code","sections":[{"title":"new Processor(feature_extractor)","local":"new-processorfeatureextractor","sections":[],"depth":3},{"title":"processor._call(input, ...args) ⇒ <code> Promise. < any > </code>","local":"processorcallinput-args--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"processors.WhisperProcessor ⇐ <code> Processor </code>","local":"processorswhisperprocessor--code-processor-code","sections":[{"title":"whisperProcessor._call(audio) ⇒ <code> Promise. < any > </code>","local":"whisperprocessorcallaudio--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"processors.AutoProcessor","local":"processorsautoprocessor","sections":[{"title":"AutoProcessor.from_pretrained(pretrained_model_name_or_path, options) ⇒ <code> Promise. < Processor > </code>","local":"autoprocessorfrompretrainedpretrainedmodelnameorpath-options--code-promise--processor--code","sections":[],"depth":3}],"depth":2},{"title":"processors~center_to_corners_format(arr) ⇒ <code> Array. < number > </code>","local":"processorscentertocornersformatarr--code-array--number--code","sections":[],"depth":2},{"title":"processors~enforce_size_divisibility(size, divisor) ⇒ <code> * </code>","local":"processorsenforcesizedivisibilitysize-divisor--code--code","sections":[],"depth":2},{"title":"processors~HeightWidth : <code> * </code>","local":"processorsheightwidth--code--code","sections":[],"depth":2},{"title":"processors~ImageFeatureExtractorResult : <code> object </code>","local":"processorsimagefeatureextractorresult--code-object-code","sections":[],"depth":2},{"title":"processors~PreprocessedImage : <code> object </code>","local":"processorspreprocessedimage--code-object-code","sections":[],"depth":2},{"title":"processors~DetrFeatureExtractorResult : <code> object </code>","local":"processorsdetrfeatureextractorresult--code-object-code","sections":[],"depth":2},{"title":"processors~SamImageProcessorResult : <code> object </code>","local":"processorssamimageprocessorresult--code-object-code","sections":[],"depth":2}],"depth":1}';function lc(ld){return qi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class mc extends Oi{constructor(x){super(),ec(this,x,lc,sc,Si,{})}}export{mc as component};
