import{s as ct,n as ft,o as ut}from"../chunks/scheduler.8c3d61f6.js";import{S as mt,i as pt,g as r,s as o,r as f,A as ht,h as l,f as t,c as s,j as b,u,x as _,k as v,y as i,a,v as m,d as p,t as h,w as g}from"../chunks/index.da70eac4.js";import{D as C}from"../chunks/Docstring.6b390b9a.js";import{C as Pe}from"../chunks/CodeBlock.00a903b3.js";import{H as Le,E as gt}from"../chunks/EditOnGithub.1e64e623.js";function _t(Be){let y,re,ae,le,M,de,D,Se='The 2D Autoencoder model used in <a href="https://huggingface.co/papers/2410.10629" rel="nofollow">SANA</a> and introduced in <a href="https://huggingface.co/papers/2410.10733" rel="nofollow">DCAE</a> by authors Junyu Chen*, Han Cai*, Junsong Chen, Enze Xie, Shang Yang, Haotian Tang, Muyang Li, Yao Lu, Song Han from MIT HAN Lab.',ce,A,Fe="The abstract from the paper is:",fe,E,Oe='<em>We present Deep Compression Autoencoder (DC-AE), a new family of autoencoder models for accelerating high-resolution diffusion models. Existing autoencoder models have demonstrated impressive results at a moderate spatial compression ratio (e.g., 8x), but fail to maintain satisfactory reconstruction accuracy for high spatial compression ratios (e.g., 64x). We address this challenge by introducing two key techniques: (1) Residual Autoencoding, where we design our models to learn residuals based on the space-to-channel transformed features to alleviate the optimization difficulty of high spatial-compression autoencoders; (2) Decoupled High-Resolution Adaptation, an efficient decoupled three-phases training strategy for mitigating the generalization penalty of high spatial-compression autoencoders. With these designs, we improve the autoencoder’s spatial compression ratio up to 128 while maintaining the reconstruction quality. Applying our DC-AE to latent diffusion models, we achieve significant speedup without accuracy drop. For example, on ImageNet 512x512, our DC-AE provides 19.1x inference speedup and 17.9x training speedup on H100 GPU for UViT-H while achieving a better FID, compared with the widely used SD-VAE-f8 autoencoder. Our code is available at <a href="https://github.com/mit-han-lab/efficientvit" rel="nofollow">this https URL</a>.</em>',ue,Z,Xe="The following DCAE models are released and supported in Diffusers.",me,L,Qe='<thead><tr><th align="center">Diffusers format</th> <th align="center">Original format</th></tr></thead> <tbody><tr><td align="center"><a href="https://huggingface.co/mit-han-lab/dc-ae-f32c32-sana-1.0-diffusers" rel="nofollow"><code>mit-han-lab/dc-ae-f32c32-sana-1.0-diffusers</code></a></td> <td align="center"><a href="https://huggingface.co/mit-han-lab/dc-ae-f32c32-sana-1.0" rel="nofollow"><code>mit-han-lab/dc-ae-f32c32-sana-1.0</code></a></td></tr> <tr><td align="center"><a href="https://huggingface.co/mit-han-lab/dc-ae-f32c32-in-1.0-diffusers" rel="nofollow"><code>mit-han-lab/dc-ae-f32c32-in-1.0-diffusers</code></a></td> <td align="center"><a href="https://huggingface.co/mit-han-lab/dc-ae-f32c32-in-1.0" rel="nofollow"><code>mit-han-lab/dc-ae-f32c32-in-1.0</code></a></td></tr> <tr><td align="center"><a href="https://huggingface.co/mit-han-lab/dc-ae-f32c32-mix-1.0-diffusers" rel="nofollow"><code>mit-han-lab/dc-ae-f32c32-mix-1.0-diffusers</code></a></td> <td align="center"><a href="https://huggingface.co/mit-han-lab/dc-ae-f32c32-mix-1.0" rel="nofollow"><code>mit-han-lab/dc-ae-f32c32-mix-1.0</code></a></td></tr> <tr><td align="center"><a href="https://huggingface.co/mit-han-lab/dc-ae-f64c128-in-1.0-diffusers" rel="nofollow"><code>mit-han-lab/dc-ae-f64c128-in-1.0-diffusers</code></a></td> <td align="center"><a href="https://huggingface.co/mit-han-lab/dc-ae-f64c128-in-1.0" rel="nofollow"><code>mit-han-lab/dc-ae-f64c128-in-1.0</code></a></td></tr> <tr><td align="center"><a href="https://huggingface.co/mit-han-lab/dc-ae-f64c128-mix-1.0-diffusers" rel="nofollow"><code>mit-han-lab/dc-ae-f64c128-mix-1.0-diffusers</code></a></td> <td align="center"><a href="https://huggingface.co/mit-han-lab/dc-ae-f64c128-mix-1.0" rel="nofollow"><code>mit-han-lab/dc-ae-f64c128-mix-1.0</code></a></td></tr> <tr><td align="center"><a href="https://huggingface.co/mit-han-lab/dc-ae-f128c512-in-1.0-diffusers" rel="nofollow"><code>mit-han-lab/dc-ae-f128c512-in-1.0-diffusers</code></a></td> <td align="center"><a href="https://huggingface.co/mit-han-lab/dc-ae-f128c512-in-1.0" rel="nofollow"><code>mit-han-lab/dc-ae-f128c512-in-1.0</code></a></td></tr> <tr><td align="center"><a href="https://huggingface.co/mit-han-lab/dc-ae-f128c512-mix-1.0-diffusers" rel="nofollow"><code>mit-han-lab/dc-ae-f128c512-mix-1.0-diffusers</code></a></td> <td align="center"><a href="https://huggingface.co/mit-han-lab/dc-ae-f128c512-mix-1.0" rel="nofollow"><code>mit-han-lab/dc-ae-f128c512-mix-1.0</code></a></td></tr></tbody>',pe,U,Ke='Load a model in Diffusers format with <a href="/docs/diffusers/pr_10136/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a>.',he,J,ge,q,_e,G,be,R,et="The <code>AutoencoderDC</code> model has <code>in</code> and <code>mix</code> single file checkpoint variants that have matching checkpoint keys, but use different scaling factors. It is not possible for Diffusers to automatically infer the correct config file to use with the model based on just the checkpoint and will default to configuring the model using the <code>mix</code> variant config file. To override the automatically determined config, please use the <code>config</code> argument when using single file loading with <code>in</code> variant checkpoints.",ve,z,ye,H,$e,d,V,Ue,O,tt=`An Autoencoder model introduced in <a href="https://arxiv.org/abs/2410.10733" rel="nofollow">DCAE</a> and used in
<a href="https://arxiv.org/abs/2410.10629" rel="nofollow">SANA</a>.`,Je,X,nt=`This model inherits from <a href="/docs/diffusers/pr_10136/en/api/models/overview#diffusers.ModelMixin">ModelMixin</a>. Check the superclass documentation for it’s generic methods implemented
for all models (such as downloading or saving).`,qe,Q,W,Ge,K,j,Re,w,I,ze,ee,ot=`Disable sliced AE decoding. If <code>enable_slicing</code> was previously enabled, this method will go back to computing
decoding in one step.`,He,T,Y,Ve,te,st=`Disable tiled AE decoding. If <code>enable_tiling</code> was previously enabled, this method will go back to computing
decoding in one step.`,We,k,N,je,ne,at=`Enable sliced AE decoding. When this option is enabled, the AE will split the input tensor in slices to compute
decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Ie,x,P,Ye,oe,it=`Enable tiled AE decoding. When this option is enabled, the AE will split the input tensor into tiles to compute
decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,we,B,Te,$,S,Ne,se,rt="Output of decoding method.",ke,F,xe,ie,Ce;return M=new Le({props:{title:"AutoencoderDC",local:"autoencoderdc",headingTag:"h1"}}),J=new Pe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9lbmNvZGVyREMlMEElMEFhZSUyMCUzRCUyMEF1dG9lbmNvZGVyREMuZnJvbV9wcmV0cmFpbmVkKCUyMm1pdC1oYW4tbGFiJTJGZGMtYWUtZjMyYzMyLXNhbmEtMS4wLWRpZmZ1c2VycyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQzMikudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderDC

ae = AutoencoderDC.from_pretrained(<span class="hljs-string">&quot;mit-han-lab/dc-ae-f32c32-sana-1.0-diffusers&quot;</span>, torch_dtype=torch.float32).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),q=new Le({props:{title:"Load a model in Diffusers via from_single_file",local:"load-a-model-in-diffusers-via-fromsinglefile",headingTag:"h2"}}),G=new Pe({props:{code:"ZnJvbSUyMGRpZnVzZXJzJTIwaW1wb3J0JTIwQXV0b2VuY29kZXJEQyUwQSUwQWNrcHRfcGF0aCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZtaXQtaGFuLWxhYiUyRmRjLWFlLWYzMmMzMi1zYW5hLTEuMCUyRmJsb2IlMkZtYWluJTJGbW9kZWwuc2FmZXRlbnNvcnMlMjIlMEFtb2RlbCUyMCUzRCUyMEF1dG9lbmNvZGVyREMuZnJvbV9zaW5nbGVfZmlsZShja3B0X3BhdGgpJTIwJTBB",highlighted:`<span class="hljs-keyword">from</span> difusers <span class="hljs-keyword">import</span> AutoencoderDC

ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/mit-han-lab/dc-ae-f32c32-sana-1.0/blob/main/model.safetensors&quot;</span>
model = AutoencoderDC.from_single_file(ckpt_path) 
`,wrap:!1}}),z=new Pe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9lbmNvZGVyREMlMEElMEFja3B0X3BhdGglMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGbWl0LWhhbi1sYWIlMkZkYy1hZS1mMTI4YzUxMi1pbi0xLjAlMkZibG9iJTJGbWFpbiUyRm1vZGVsLnNhZmV0ZW5zb3JzJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvZW5jb2RlckRDLmZyb21fc2luZ2xlX2ZpbGUoY2twdF9wYXRoJTJDJTIwY29uZmlnJTNEJTIybWl0LWhhbi1sYWIlMkZkYy1hZS1mMTI4YzUxMi1pbi0xLjAtZGlmZnVzZXJzJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderDC

ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/mit-han-lab/dc-ae-f128c512-in-1.0/blob/main/model.safetensors&quot;</span>
model = AutoencoderDC.from_single_file(ckpt_path, config=<span class="hljs-string">&quot;mit-han-lab/dc-ae-f128c512-in-1.0-diffusers&quot;</span>)`,wrap:!1}}),H=new Le({props:{title:"AutoencoderDC",local:"diffusers.AutoencoderDC",headingTag:"h2"}}),V=new C({props:{name:"class diffusers.AutoencoderDC",anchor:"diffusers.AutoencoderDC",parameters:[{name:"in_channels",val:": int = 3"},{name:"latent_channels",val:": int = 32"},{name:"attention_head_dim",val:": int = 32"},{name:"encoder_block_types",val:": typing.Union[str, typing.Tuple[str]] = 'ResBlock'"},{name:"decoder_block_types",val:": typing.Union[str, typing.Tuple[str]] = 'ResBlock'"},{name:"encoder_block_out_channels",val:": typing.Tuple[int, ...] = (128, 256, 512, 512, 1024, 1024)"},{name:"decoder_block_out_channels",val:": typing.Tuple[int, ...] = (128, 256, 512, 512, 1024, 1024)"},{name:"encoder_layers_per_block",val:": typing.Tuple[int] = (2, 2, 2, 3, 3, 3)"},{name:"decoder_layers_per_block",val:": typing.Tuple[int] = (3, 3, 3, 3, 3, 3)"},{name:"encoder_qkv_multiscales",val:": typing.Tuple[typing.Tuple[int, ...], ...] = ((), (), (), (5,), (5,), (5,))"},{name:"decoder_qkv_multiscales",val:": typing.Tuple[typing.Tuple[int, ...], ...] = ((), (), (), (5,), (5,), (5,))"},{name:"upsample_block_type",val:": str = 'pixel_shuffle'"},{name:"downsample_block_type",val:": str = 'pixel_unshuffle'"},{name:"decoder_norm_types",val:": typing.Union[str, typing.Tuple[str]] = 'rms_norm'"},{name:"decoder_act_fns",val:": typing.Union[str, typing.Tuple[str]] = 'silu'"},{name:"scaling_factor",val:": float = 1.0"}],parametersDescription:[{anchor:"diffusers.AutoencoderDC.in_channels",description:`<strong>in_channels</strong> (<code>int</code>, defaults to <code>3</code>) &#x2014;
The number of input channels in samples.`,name:"in_channels"},{anchor:"diffusers.AutoencoderDC.latent_channels",description:`<strong>latent_channels</strong> (<code>int</code>, defaults to <code>32</code>) &#x2014;
The number of channels in the latent space representation.`,name:"latent_channels"},{anchor:"diffusers.AutoencoderDC.encoder_block_types",description:`<strong>encoder_block_types</strong> (<code>Union[str, Tuple[str]]</code>, defaults to <code>&quot;ResBlock&quot;</code>) &#x2014;
The type(s) of block to use in the encoder.`,name:"encoder_block_types"},{anchor:"diffusers.AutoencoderDC.decoder_block_types",description:`<strong>decoder_block_types</strong> (<code>Union[str, Tuple[str]]</code>, defaults to <code>&quot;ResBlock&quot;</code>) &#x2014;
The type(s) of block to use in the decoder.`,name:"decoder_block_types"},{anchor:"diffusers.AutoencoderDC.encoder_block_out_channels",description:`<strong>encoder_block_out_channels</strong> (<code>Tuple[int, ...]</code>, defaults to <code>(128, 256, 512, 512, 1024, 1024)</code>) &#x2014;
The number of output channels for each block in the encoder.`,name:"encoder_block_out_channels"},{anchor:"diffusers.AutoencoderDC.decoder_block_out_channels",description:`<strong>decoder_block_out_channels</strong> (<code>Tuple[int, ...]</code>, defaults to <code>(128, 256, 512, 512, 1024, 1024)</code>) &#x2014;
The number of output channels for each block in the decoder.`,name:"decoder_block_out_channels"},{anchor:"diffusers.AutoencoderDC.encoder_layers_per_block",description:`<strong>encoder_layers_per_block</strong> (<code>Tuple[int]</code>, defaults to <code>(2, 2, 2, 3, 3, 3)</code>) &#x2014;
The number of layers per block in the encoder.`,name:"encoder_layers_per_block"},{anchor:"diffusers.AutoencoderDC.decoder_layers_per_block",description:`<strong>decoder_layers_per_block</strong> (<code>Tuple[int]</code>, defaults to <code>(3, 3, 3, 3, 3, 3)</code>) &#x2014;
The number of layers per block in the decoder.`,name:"decoder_layers_per_block"},{anchor:"diffusers.AutoencoderDC.encoder_qkv_multiscales",description:`<strong>encoder_qkv_multiscales</strong> (<code>Tuple[Tuple[int, ...], ...]</code>, defaults to <code>((), (), (), (5,), (5,), (5,))</code>) &#x2014;
Multi-scale configurations for the encoder&#x2019;s QKV (query-key-value) transformations.`,name:"encoder_qkv_multiscales"},{anchor:"diffusers.AutoencoderDC.decoder_qkv_multiscales",description:`<strong>decoder_qkv_multiscales</strong> (<code>Tuple[Tuple[int, ...], ...]</code>, defaults to <code>((), (), (), (5,), (5,), (5,))</code>) &#x2014;
Multi-scale configurations for the decoder&#x2019;s QKV (query-key-value) transformations.`,name:"decoder_qkv_multiscales"},{anchor:"diffusers.AutoencoderDC.upsample_block_type",description:`<strong>upsample_block_type</strong> (<code>str</code>, defaults to <code>&quot;pixel_shuffle&quot;</code>) &#x2014;
The type of block to use for upsampling in the decoder.`,name:"upsample_block_type"},{anchor:"diffusers.AutoencoderDC.downsample_block_type",description:`<strong>downsample_block_type</strong> (<code>str</code>, defaults to <code>&quot;pixel_unshuffle&quot;</code>) &#x2014;
The type of block to use for downsampling in the encoder.`,name:"downsample_block_type"},{anchor:"diffusers.AutoencoderDC.decoder_norm_types",description:`<strong>decoder_norm_types</strong> (<code>Union[str, Tuple[str]]</code>, defaults to <code>&quot;rms_norm&quot;</code>) &#x2014;
The normalization type(s) to use in the decoder.`,name:"decoder_norm_types"},{anchor:"diffusers.AutoencoderDC.decoder_act_fns",description:`<strong>decoder_act_fns</strong> (<code>Union[str, Tuple[str]]</code>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The activation function(s) to use in the decoder.`,name:"decoder_act_fns"},{anchor:"diffusers.AutoencoderDC.scaling_factor",description:`<strong>scaling_factor</strong> (<code>float</code>, defaults to <code>1.0</code>) &#x2014;
The multiplicative inverse of the root mean square of the latent features. This is used to scale the latent
space to have unit variance when training the diffusion model. The latents are scaled with the formula <code>z = z * scaling_factor</code> before being passed to the diffusion model. When decoding, the latents are scaled back
to the original scale with the formula: <code>z = 1 / scaling_factor * z</code>.`,name:"scaling_factor"}],source:"https://github.com/huggingface/diffusers/blob/vr_10136/src/diffusers/models/autoencoders/autoencoder_dc.py#L378"}}),W=new C({props:{name:"wrapper",anchor:"diffusers.AutoencoderDC.encode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/diffusers/blob/vr_10136/src/diffusers/utils/accelerate_utils.py#L43"}}),j=new C({props:{name:"wrapper",anchor:"diffusers.AutoencoderDC.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/diffusers/blob/vr_10136/src/diffusers/utils/accelerate_utils.py#L43"}}),I=new C({props:{name:"disable_slicing",anchor:"diffusers.AutoencoderDC.disable_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10136/src/diffusers/models/autoencoders/autoencoder_dc.py#L533"}}),Y=new C({props:{name:"disable_tiling",anchor:"diffusers.AutoencoderDC.disable_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10136/src/diffusers/models/autoencoders/autoencoder_dc.py#L519"}}),N=new C({props:{name:"enable_slicing",anchor:"diffusers.AutoencoderDC.enable_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10136/src/diffusers/models/autoencoders/autoencoder_dc.py#L526"}}),P=new C({props:{name:"enable_tiling",anchor:"diffusers.AutoencoderDC.enable_tiling",parameters:[{name:"tile_sample_min_height",val:": typing.Optional[int] = None"},{name:"tile_sample_min_width",val:": typing.Optional[int] = None"},{name:"tile_sample_stride_height",val:": typing.Optional[float] = None"},{name:"tile_sample_stride_width",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.AutoencoderDC.enable_tiling.tile_sample_min_height",description:`<strong>tile_sample_min_height</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum height required for a sample to be separated into tiles across the height dimension.`,name:"tile_sample_min_height"},{anchor:"diffusers.AutoencoderDC.enable_tiling.tile_sample_min_width",description:`<strong>tile_sample_min_width</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum width required for a sample to be separated into tiles across the width dimension.`,name:"tile_sample_min_width"},{anchor:"diffusers.AutoencoderDC.enable_tiling.tile_sample_stride_height",description:`<strong>tile_sample_stride_height</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum amount of overlap between two consecutive vertical tiles. This is to ensure that there are
no tiling artifacts produced across the height dimension.`,name:"tile_sample_stride_height"},{anchor:"diffusers.AutoencoderDC.enable_tiling.tile_sample_stride_width",description:`<strong>tile_sample_stride_width</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The stride between two consecutive horizontal tiles. This is to ensure that there are no tiling
artifacts produced across the width dimension.`,name:"tile_sample_stride_width"}],source:"https://github.com/huggingface/diffusers/blob/vr_10136/src/diffusers/models/autoencoders/autoencoder_dc.py#L489"}}),B=new Le({props:{title:"DecoderOutput",local:"diffusers.models.autoencoders.vae.DecoderOutput",headingTag:"h2"}}),S=new C({props:{name:"class diffusers.models.autoencoders.vae.DecoderOutput",anchor:"diffusers.models.autoencoders.vae.DecoderOutput",parameters:[{name:"sample",val:": Tensor"},{name:"commit_loss",val:": typing.Optional[torch.FloatTensor] = None"}],parametersDescription:[{anchor:"diffusers.models.autoencoders.vae.DecoderOutput.sample",description:`<strong>sample</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
The decoded output sample from the last layer of the model.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/vr_10136/src/diffusers/models/autoencoders/vae.py#L46"}}),F=new gt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/models/autoencoder_dc.md"}}),{c(){y=r("meta"),re=o(),ae=r("p"),le=o(),f(M.$$.fragment),de=o(),D=r("p"),D.innerHTML=Se,ce=o(),A=r("p"),A.textContent=Fe,fe=o(),E=r("p"),E.innerHTML=Oe,ue=o(),Z=r("p"),Z.textContent=Xe,me=o(),L=r("table"),L.innerHTML=Qe,pe=o(),U=r("p"),U.innerHTML=Ke,he=o(),f(J.$$.fragment),ge=o(),f(q.$$.fragment),_e=o(),f(G.$$.fragment),be=o(),R=r("p"),R.innerHTML=et,ve=o(),f(z.$$.fragment),ye=o(),f(H.$$.fragment),$e=o(),d=r("div"),f(V.$$.fragment),Ue=o(),O=r("p"),O.innerHTML=tt,Je=o(),X=r("p"),X.innerHTML=nt,qe=o(),Q=r("div"),f(W.$$.fragment),Ge=o(),K=r("div"),f(j.$$.fragment),Re=o(),w=r("div"),f(I.$$.fragment),ze=o(),ee=r("p"),ee.innerHTML=ot,He=o(),T=r("div"),f(Y.$$.fragment),Ve=o(),te=r("p"),te.innerHTML=st,We=o(),k=r("div"),f(N.$$.fragment),je=o(),ne=r("p"),ne.textContent=at,Ie=o(),x=r("div"),f(P.$$.fragment),Ye=o(),oe=r("p"),oe.textContent=it,we=o(),f(B.$$.fragment),Te=o(),$=r("div"),f(S.$$.fragment),Ne=o(),se=r("p"),se.textContent=rt,ke=o(),f(F.$$.fragment),xe=o(),ie=r("p"),this.h()},l(e){const n=ht("svelte-u9bgzb",document.head);y=l(n,"META",{name:!0,content:!0}),n.forEach(t),re=s(e),ae=l(e,"P",{}),b(ae).forEach(t),le=s(e),u(M.$$.fragment,e),de=s(e),D=l(e,"P",{"data-svelte-h":!0}),_(D)!=="svelte-8tp46g"&&(D.innerHTML=Se),ce=s(e),A=l(e,"P",{"data-svelte-h":!0}),_(A)!=="svelte-1cwsb16"&&(A.textContent=Fe),fe=s(e),E=l(e,"P",{"data-svelte-h":!0}),_(E)!=="svelte-1tcz16m"&&(E.innerHTML=Oe),ue=s(e),Z=l(e,"P",{"data-svelte-h":!0}),_(Z)!=="svelte-1o0h6o1"&&(Z.textContent=Xe),me=s(e),L=l(e,"TABLE",{"data-svelte-h":!0}),_(L)!=="svelte-189p9ea"&&(L.innerHTML=Qe),pe=s(e),U=l(e,"P",{"data-svelte-h":!0}),_(U)!=="svelte-ctahi"&&(U.innerHTML=Ke),he=s(e),u(J.$$.fragment,e),ge=s(e),u(q.$$.fragment,e),_e=s(e),u(G.$$.fragment,e),be=s(e),R=l(e,"P",{"data-svelte-h":!0}),_(R)!=="svelte-j2ip3j"&&(R.innerHTML=et),ve=s(e),u(z.$$.fragment,e),ye=s(e),u(H.$$.fragment,e),$e=s(e),d=l(e,"DIV",{class:!0});var c=b(d);u(V.$$.fragment,c),Ue=s(c),O=l(c,"P",{"data-svelte-h":!0}),_(O)!=="svelte-1o8176"&&(O.innerHTML=tt),Je=s(c),X=l(c,"P",{"data-svelte-h":!0}),_(X)!=="svelte-km5dp"&&(X.innerHTML=nt),qe=s(c),Q=l(c,"DIV",{class:!0});var lt=b(Q);u(W.$$.fragment,lt),lt.forEach(t),Ge=s(c),K=l(c,"DIV",{class:!0});var dt=b(K);u(j.$$.fragment,dt),dt.forEach(t),Re=s(c),w=l(c,"DIV",{class:!0});var Me=b(w);u(I.$$.fragment,Me),ze=s(Me),ee=l(Me,"P",{"data-svelte-h":!0}),_(ee)!=="svelte-3s97m7"&&(ee.innerHTML=ot),Me.forEach(t),He=s(c),T=l(c,"DIV",{class:!0});var De=b(T);u(Y.$$.fragment,De),Ve=s(De),te=l(De,"P",{"data-svelte-h":!0}),_(te)!=="svelte-1v893a9"&&(te.innerHTML=st),De.forEach(t),We=s(c),k=l(c,"DIV",{class:!0});var Ae=b(k);u(N.$$.fragment,Ae),je=s(Ae),ne=l(Ae,"P",{"data-svelte-h":!0}),_(ne)!=="svelte-1s1uocy"&&(ne.textContent=at),Ae.forEach(t),Ie=s(c),x=l(c,"DIV",{class:!0});var Ee=b(x);u(P.$$.fragment,Ee),Ye=s(Ee),oe=l(Ee,"P",{"data-svelte-h":!0}),_(oe)!=="svelte-130u29x"&&(oe.textContent=it),Ee.forEach(t),c.forEach(t),we=s(e),u(B.$$.fragment,e),Te=s(e),$=l(e,"DIV",{class:!0});var Ze=b($);u(S.$$.fragment,Ze),Ne=s(Ze),se=l(Ze,"P",{"data-svelte-h":!0}),_(se)!=="svelte-18u8upa"&&(se.textContent=rt),Ze.forEach(t),ke=s(e),u(F.$$.fragment,e),xe=s(e),ie=l(e,"P",{}),b(ie).forEach(t),this.h()},h(){v(y,"name","hf:doc:metadata"),v(y,"content",bt),v(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){i(document.head,y),a(e,re,n),a(e,ae,n),a(e,le,n),m(M,e,n),a(e,de,n),a(e,D,n),a(e,ce,n),a(e,A,n),a(e,fe,n),a(e,E,n),a(e,ue,n),a(e,Z,n),a(e,me,n),a(e,L,n),a(e,pe,n),a(e,U,n),a(e,he,n),m(J,e,n),a(e,ge,n),m(q,e,n),a(e,_e,n),m(G,e,n),a(e,be,n),a(e,R,n),a(e,ve,n),m(z,e,n),a(e,ye,n),m(H,e,n),a(e,$e,n),a(e,d,n),m(V,d,null),i(d,Ue),i(d,O),i(d,Je),i(d,X),i(d,qe),i(d,Q),m(W,Q,null),i(d,Ge),i(d,K),m(j,K,null),i(d,Re),i(d,w),m(I,w,null),i(w,ze),i(w,ee),i(d,He),i(d,T),m(Y,T,null),i(T,Ve),i(T,te),i(d,We),i(d,k),m(N,k,null),i(k,je),i(k,ne),i(d,Ie),i(d,x),m(P,x,null),i(x,Ye),i(x,oe),a(e,we,n),m(B,e,n),a(e,Te,n),a(e,$,n),m(S,$,null),i($,Ne),i($,se),a(e,ke,n),m(F,e,n),a(e,xe,n),a(e,ie,n),Ce=!0},p:ft,i(e){Ce||(p(M.$$.fragment,e),p(J.$$.fragment,e),p(q.$$.fragment,e),p(G.$$.fragment,e),p(z.$$.fragment,e),p(H.$$.fragment,e),p(V.$$.fragment,e),p(W.$$.fragment,e),p(j.$$.fragment,e),p(I.$$.fragment,e),p(Y.$$.fragment,e),p(N.$$.fragment,e),p(P.$$.fragment,e),p(B.$$.fragment,e),p(S.$$.fragment,e),p(F.$$.fragment,e),Ce=!0)},o(e){h(M.$$.fragment,e),h(J.$$.fragment,e),h(q.$$.fragment,e),h(G.$$.fragment,e),h(z.$$.fragment,e),h(H.$$.fragment,e),h(V.$$.fragment,e),h(W.$$.fragment,e),h(j.$$.fragment,e),h(I.$$.fragment,e),h(Y.$$.fragment,e),h(N.$$.fragment,e),h(P.$$.fragment,e),h(B.$$.fragment,e),h(S.$$.fragment,e),h(F.$$.fragment,e),Ce=!1},d(e){e&&(t(re),t(ae),t(le),t(de),t(D),t(ce),t(A),t(fe),t(E),t(ue),t(Z),t(me),t(L),t(pe),t(U),t(he),t(ge),t(_e),t(be),t(R),t(ve),t(ye),t($e),t(d),t(we),t(Te),t($),t(ke),t(xe),t(ie)),t(y),g(M,e),g(J,e),g(q,e),g(G,e),g(z,e),g(H,e),g(V),g(W),g(j),g(I),g(Y),g(N),g(P),g(B,e),g(S),g(F,e)}}}const bt='{"title":"AutoencoderDC","local":"autoencoderdc","sections":[{"title":"Load a model in Diffusers via from_single_file","local":"load-a-model-in-diffusers-via-fromsinglefile","sections":[],"depth":2},{"title":"AutoencoderDC","local":"diffusers.AutoencoderDC","sections":[],"depth":2},{"title":"DecoderOutput","local":"diffusers.models.autoencoders.vae.DecoderOutput","sections":[],"depth":2}],"depth":1}';function vt(Be){return ut(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xt extends mt{constructor(y){super(),pt(this,y,vt,_t,ct,{})}}export{xt as component};
