import{s as Ls,n as Ds,o as Ks}from"../chunks/scheduler.7bc62968.js";import{S as Ps,i as Os,g as h,s as t,r as p,A as sl,h as r,f as a,c as e,j as As,x as y,u as c,k as Ss,y as ll,a as n,v as i,d as M,t as o,w as J}from"../chunks/index.66556066.js";import{C as j}from"../chunks/CodeBlock.a759539a.js";import{H as m,E as al}from"../chunks/EditOnGithub.46ca76a5.js";function nl(Ys){let T,O,K,ss,U,Rs='<br/> <picture><source media="(prefers-color-scheme: dark)" srcset="https://huggingface.co/datasets/huggingface/documentation-images/raw/main/huggingfacejs-dark.svg"/> <source media="(prefers-color-scheme: light)" srcset="https://huggingface.co/datasets/huggingface/documentation-images/raw/main/huggingfacejs-light.svg"/> <img alt="huggingface javascript library logo" src="https://huggingface.co/datasets/huggingface/documentation-images/raw/main/huggingfacejs-light.svg" width="376" height="59" style="max-width: 100%;"/></picture> <br/> <br/>',ls,u,as,w,ns,d,vs="This is a collection of JS libraries to interact with the Hugging Face API, with TS types included.",ts,g,$s='<li><a href="inference/README">@huggingface/inference</a>: Use HF Inference API (serverless), Inference Endpoints (dedicated) and third-party Inference Providers to make calls to 100,000+ Machine Learning models</li> <li><a href="hub/README">@huggingface/hub</a>: Interact with huggingface.co to create or delete repos and commit / download files</li> <li><a href="agents/README">@huggingface/agents</a>: Interact with HF models through a natural language interface</li> <li><a href="gguf/README">@huggingface/gguf</a>: A GGUF parser that works on remotely hosted files.</li> <li><a href="dduf/README">@huggingface/dduf</a>: Similar package for DDUF (DDUF Diffusers Unified Format)</li> <li><a href="tasks/README">@huggingface/tasks</a>: The definition files and source-of-truth for the Hub’s main primitives like pipeline tasks, model libraries, etc.</li> <li><a href="jinja/README">@huggingface/jinja</a>: A minimalistic JS implementation of the Jinja templating engine, to be used for ML chat templates.</li> <li><a href="space-header/README">@huggingface/space-header</a>: Use the Space <code>mini_header</code> outside Hugging Face</li> <li><a href="ollama-utils/README">@huggingface/ollama-utils</a>: Various utilities for maintaining Ollama compatibility with models on the Hugging Face Hub.</li>',es,b,Vs="We use modern features to avoid polyfills and dependencies, so the libraries will only work on modern browsers / Node.js >= 18 / Bun / Deno.",ps,I,Fs="The libraries are still very young, please help us by opening issues!",cs,f,is,B,Ms,Z,Xs="To install via NPM, you can download the libraries as needed:",os,G,Js,C,Hs="Then import the libraries in your code:",hs,k,rs,E,ys,Q,xs='You can run our packages with vanilla JS, without any bundler, by using a CDN or static hosting. Using <a href="https://hacks.mozilla.org/2018/03/es-modules-a-cartoon-deep-dive/" rel="nofollow">ES modules</a>, i.e. <code>&lt;script type=&quot;module&quot;&gt;</code>, you can import the libraries in your code:',ms,W,js,N,Ts,S,Us,Y,us,R,qs='Get your HF access token in your <a href="https://huggingface.co/settings/tokens" rel="nofollow">account settings</a>.',ws,v,ds,$,gs,V,bs,F,Is,X,fs,H,Bs,x,zs="There are more features of course, check each library’s README!",Zs,q,Gs,z,Cs,_,ks,A,Es,L,_s="This will generate ESM and CJS javascript files in <code>packages/*/dist</code>, eg <code>packages/inference/dist/index.mjs</code>.",Qs,D,Ws,P,Ns;return u=new j({props:{code:"JTJGJTJGJTIwUHJvZ3JhbWF0aWNhbGx5JTIwaW50ZXJhY3QlMjB3aXRoJTIwdGhlJTIwSHViJTBBJTBBYXdhaXQlMjBjcmVhdGVSZXBvKCU3QiUwQSUyMCUyMHJlcG8lM0ElMjAlN0IlMjB0eXBlJTNBJTIwJTIybW9kZWwlMjIlMkMlMjBuYW1lJTNBJTIwJTIybXktdXNlciUyRm5scC1tb2RlbCUyMiUyMCU3RCUyQyUwQSUyMCUyMGFjY2Vzc1Rva2VuJTNBJTIwSEZfVE9LRU4lMEElN0QpJTNCJTBBJTBBYXdhaXQlMjB1cGxvYWRGaWxlKCU3QiUwQSUyMCUyMHJlcG8lM0ElMjAlMjJteS11c2VyJTJGbmxwLW1vZGVsJTIyJTJDJTBBJTIwJTIwYWNjZXNzVG9rZW4lM0ElMjBIRl9UT0tFTiUyQyUwQSUyMCUyMCUyRiUyRiUyMENhbiUyMHdvcmslMjB3aXRoJTIwbmF0aXZlJTIwRmlsZSUyMGluJTIwYnJvd3NlcnMlMEElMjAlMjBmaWxlJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwcGF0aCUzQSUyMCUyMnB5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTBBJTIwJTIwJTIwJTIwY29udGVudCUzQSUyMG5ldyUyMEJsb2IoLi4uKSUyMCUwQSUyMCUyMCU3RCUwQSU3RCklM0IlMEElMEElMkYlMkYlMjBVc2UlMjBIRiUyMEluZmVyZW5jZSUyMEFQSSUyQyUyMG9yJTIwZXh0ZXJuYWwlMjBJbmZlcmVuY2UlMjBQcm92aWRlcnMhJTBBJTBBYXdhaXQlMjBpbmZlcmVuY2UuY2hhdENvbXBsZXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4xLThCLUluc3RydWN0JTIyJTJDJTBBJTIwJTIwbWVzc2FnZXMlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjByb2xlJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGNvbnRlbnQlM0ElMjAlMjJIZWxsbyUyQyUyMG5pY2UlMjB0byUyMG1lZXQlMjB5b3UhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwbWF4X3Rva2VucyUzQSUyMDUxMiUyQyUwQSUyMCUyMHRlbXBlcmF0dXJlJTNBJTIwMC41JTJDJTBBJTIwJTIwcHJvdmlkZXIlM0ElMjAlMjJzYW1iYW5vdmElMjIlMkMlMjAlMkYlMkYlMjBvciUyMHRvZ2V0aGVyJTJDJTIwZmFsLWFpJTJDJTIwcmVwbGljYXRlJTJDJTIwJUUyJTgwJUE2JTBBJTdEKSUzQiUwQSUwQWF3YWl0JTIwaW5mZXJlbmNlLnRleHRUb0ltYWdlKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTIyYSUyMHBpY3R1cmUlMjBvZiUyMGElMjBncmVlbiUyMGJpcmQlMjIlMkMlMEElN0QpJTNCJTBBJTBBJTJGJTJGJTIwYW5kJTIwbXVjaCUyMG1vcmUlRTIlODAlQTY=",highlighted:`<span class="hljs-comment">// Programatically interact with the Hub</span>

<span class="hljs-keyword">await</span> <span class="hljs-title function_">createRepo</span>({
  <span class="hljs-attr">repo</span>: { <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;model&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span> },
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>
});

<span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFile</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span>,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>,
  <span class="hljs-comment">// Can work with native File in browsers</span>
  <span class="hljs-attr">file</span>: {
    <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>,
    <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>(...) 
  }
});

<span class="hljs-comment">// Use HF Inference API, or external Inference Providers!</span>

<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">chatCompletion</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">messages</span>: [
    {
      <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Hello, nice to meet you!&quot;</span>,
    },
  ],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>,
  <span class="hljs-attr">temperature</span>: <span class="hljs-number">0.5</span>,
  <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;sambanova&quot;</span>, <span class="hljs-comment">// or together, fal-ai, replicate, …</span>
});

<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;a picture of a green bird&quot;</span>,
});

<span class="hljs-comment">// and much more…</span>`,wrap:!1}}),w=new m({props:{title:"Hugging Face JS libraries",local:"hugging-face-js-libraries",headingTag:"h1"}}),f=new m({props:{title:"Installation",local:"installation",headingTag:"h2"}}),B=new m({props:{title:"From NPM",local:"from-npm",headingTag:"h3"}}),G=new j({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTBBbnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaHViJTBBbnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGYWdlbnRz",highlighted:`npm install @huggingface/inference
npm install @huggingface/hub
npm install @huggingface/agents`,wrap:!1}}),k=new j({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjIlM0IlMEFpbXBvcnQlMjAlN0IlMjBIZkFnZW50JTIwJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGYWdlbnRzJTIyJTNCJTBBaW1wb3J0JTIwJTdCJTIwY3JlYXRlUmVwbyUyQyUyMGNvbW1pdCUyQyUyMGRlbGV0ZVJlcG8lMkMlMjBsaXN0RmlsZXMlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlM0IlMEFpbXBvcnQlMjB0eXBlJTIwJTdCJTIwUmVwb0lkJTIwJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGaHViJTIyJTNC",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/agents&quot;</span>;
<span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;
<span class="hljs-keyword">import</span> <span class="hljs-keyword">type</span> { <span class="hljs-title class_">RepoId</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;`,wrap:!1}}),E=new m({props:{title:"From CDN or Static hosting",local:"from-cdn-or-static-hosting",headingTag:"h3"}}),W=new j({props:{code:"JTNDc2NyaXB0JTIwdHlwZSUzRCUyMm1vZHVsZSUyMiUzRSUwQSUyMCUyMCUyMCUyMGltcG9ydCUyMCU3QiUyMEhmSW5mZXJlbmNlJTIwJTdEJTIwZnJvbSUyMCdodHRwcyUzQSUyRiUyRmNkbi5qc2RlbGl2ci5uZXQlMkZucG0lMkYlNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSU0MDMuMy4yJTJGJTJCZXNtJyUzQiUwQSUyMCUyMCUyMCUyMGltcG9ydCUyMCU3QiUyMGNyZWF0ZVJlcG8lMkMlMjBjb21taXQlMkMlMjBkZWxldGVSZXBvJTJDJTIwbGlzdEZpbGVzJTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGY2RuLmpzZGVsaXZyLm5ldCUyRm5wbSUyRiU0MGh1Z2dpbmdmYWNlJTJGaHViJTQwMS4wLjElMkYlMkJlc20lMjIlM0IlMEElM0MlMkZzY3JpcHQlM0U=",highlighted:`<span class="hljs-tag">&lt;<span class="hljs-name">script</span> <span class="hljs-attr">type</span>=<span class="hljs-string">&quot;module&quot;</span>&gt;</span><span class="language-javascript">
    <span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;https://cdn.jsdelivr.net/npm/@huggingface/inference@3.3.2/+esm&#x27;</span>;
    <span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://cdn.jsdelivr.net/npm/@huggingface/hub@1.0.1/+esm&quot;</span>;
</span><span class="hljs-tag">&lt;/<span class="hljs-name">script</span>&gt;</span>`,wrap:!1}}),N=new m({props:{title:"Deno",local:"deno",headingTag:"h3"}}),S=new j({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIyaHR0cHMlM0ElMkYlMkZlc20uc2glMkYlNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSUyMiUwQWltcG9ydCUyMCU3QiUyMEhmQWdlbnQlMjAlN0QlMjBmcm9tJTIwJTIyaHR0cHMlM0ElMkYlMkZlc20uc2glMkYlNDBodWdnaW5nZmFjZSUyRmFnZW50cyUyMiUzQiUwQSUwQWltcG9ydCUyMCU3QiUyMGNyZWF0ZVJlcG8lMkMlMjBjb21taXQlMkMlMjBkZWxldGVSZXBvJTJDJTIwbGlzdEZpbGVzJTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGZXNtLnNoJTJGJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlMEElMkYlMkYlMjBvciUyMG5wbSUzQSUwQWltcG9ydCUyMCU3QiUyMEhmSW5mZXJlbmNlJTIwJTdEJTIwZnJvbSUyMCUyMm5wbSUzQSU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTIyJTBBaW1wb3J0JTIwJTdCJTIwSGZBZ2VudCUyMCU3RCUyMGZyb20lMjAlMjJucG0lM0ElNDBodWdnaW5nZmFjZSUyRmFnZW50cyUyMiUzQiUwQSUwQWltcG9ydCUyMCU3QiUyMGNyZWF0ZVJlcG8lMkMlMjBjb21taXQlMkMlMjBkZWxldGVSZXBvJTJDJTIwbGlzdEZpbGVzJTIwJTdEJTIwZnJvbSUyMCUyMm5wbSUzQSU0MGh1Z2dpbmdmYWNlJTJGaHViJTIy",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/inference&quot;</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/agents&quot;</span>;

<span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/hub&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/inference&quot;</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/agents&quot;</span>;

<span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/hub&quot;</span>`,wrap:!1}}),Y=new m({props:{title:"Usage examples",local:"usage-examples",headingTag:"h2"}}),v=new m({props:{title:"@huggingface/inference examples",local:"huggingfaceinference-examples",headingTag:"h3"}}),$=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = <span class="hljs-string">&quot;hf_...&quot;</span>;

<span class="hljs-keyword">const</span> inference = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfInference</span>(<span class="hljs-variable constant_">HF_TOKEN</span>);

<span class="hljs-comment">// Chat completion API</span>
<span class="hljs-keyword">const</span> out = <span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">chatCompletion</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Hello, nice to meet you!&quot;</span> }],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>
});
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(out.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">message</span>);

<span class="hljs-comment">// Streaming chat completion API</span>
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> inference.<span class="hljs-title function_">chatCompletionStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Hello, nice to meet you!&quot;</span> }],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>
})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">delta</span>.<span class="hljs-property">content</span>);
}

<span class="hljs-comment">/// Using a third-party provider: </span>
<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">chatCompletion</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Hello, nice to meet you!&quot;</span> }],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>,
  <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;sambanova&quot;</span>, <span class="hljs-comment">// or together, fal-ai, replicate, …</span>
})

<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;a picture of a green bird&quot;</span>,
  <span class="hljs-attr">provider</span>: <span class="hljs-string">&quot;fal-ai&quot;</span>,
})



<span class="hljs-comment">// You can also omit &quot;model&quot; to use the recommended model for the task</span>
<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;My name is Wolfgang and I live in Amsterdam&quot;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&quot;en&quot;</span>,
    <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&quot;fr&quot;</span>,
  },
});

<span class="hljs-comment">// pass multimodal files or URLs as inputs</span>
<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">imageToText</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;nlpconnect/vit-gpt2-image-captioning&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://picsum.photos/300/300&#x27;</span>)).<span class="hljs-title function_">blob</span>(),
})

<span class="hljs-comment">// Using your own dedicated inference endpoint: https://hf.co/docs/inference-endpoints/</span>
<span class="hljs-keyword">const</span> gpt2 = inference.<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&#x27;https://xyz.eu-west-1.aws.endpoints.huggingface.cloud/gpt2&#x27;</span>);
<span class="hljs-keyword">const</span> { generated_text } = <span class="hljs-keyword">await</span> gpt2.<span class="hljs-title function_">textGeneration</span>({<span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span>});

<span class="hljs-comment">// Chat Completion</span>
<span class="hljs-keyword">const</span> llamaEndpoint = inference.<span class="hljs-title function_">endpoint</span>(
  <span class="hljs-string">&quot;https://router.huggingface.co/hf-inference/models/meta-llama/Llama-3.1-8B-Instruct&quot;</span>
);
<span class="hljs-keyword">const</span> out = <span class="hljs-keyword">await</span> llamaEndpoint.<span class="hljs-title function_">chatCompletion</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
  <span class="hljs-attr">messages</span>: [{ <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Hello, nice to meet you!&quot;</span> }],
  <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">512</span>,
});
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(out.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">message</span>);`,wrap:!1}}),V=new m({props:{title:"@huggingface/hub examples",local:"huggingfacehub-examples",headingTag:"h3"}}),F=new j({props:{code:"aW1wb3J0JTIwJTdCJTIwY3JlYXRlUmVwbyUyQyUyMHVwbG9hZEZpbGUlMkMlMjBkZWxldGVGaWxlcyUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmh1YiUyMiUzQiUwQSUwQWNvbnN0JTIwSEZfVE9LRU4lMjAlM0QlMjAlMjJoZl8uLi4lMjIlM0IlMEElMEFhd2FpdCUyMGNyZWF0ZVJlcG8oJTdCJTBBJTIwJTIwcmVwbyUzQSUyMCUyMm15LXVzZXIlMkZubHAtbW9kZWwlMjIlMkMlMjAlMkYlMkYlMjBvciUyMCU3QiUyMHR5cGUlM0ElMjAlMjJtb2RlbCUyMiUyQyUyMG5hbWUlM0ElMjAlMjJteS11c2VyJTJGbmxwLXRlc3QlMjIlMjAlN0QlMkMlMEElMjAlMjBhY2Nlc3NUb2tlbiUzQSUyMEhGX1RPS0VOJTBBJTdEKSUzQiUwQSUwQWF3YWl0JTIwdXBsb2FkRmlsZSglN0IlMEElMjAlMjByZXBvJTNBJTIwJTIybXktdXNlciUyRm5scC1tb2RlbCUyMiUyQyUwQSUyMCUyMGFjY2Vzc1Rva2VuJTNBJTIwSEZfVE9LRU4lMkMlMEElMjAlMjAlMkYlMkYlMjBDYW4lMjB3b3JrJTIwd2l0aCUyMG5hdGl2ZSUyMEZpbGUlMjBpbiUyMGJyb3dzZXJzJTBBJTIwJTIwZmlsZSUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMHBhdGglM0ElMjAlMjJweXRvcmNoX21vZGVsLmJpbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNvbnRlbnQlM0ElMjBuZXclMjBCbG9iKC4uLiklMjAlMEElMjAlMjAlN0QlMEElN0QpJTNCJTBBJTBBYXdhaXQlMjBkZWxldGVGaWxlcyglN0IlMEElMjAlMjByZXBvJTNBJTIwJTdCJTIwdHlwZSUzQSUyMCUyMnNwYWNlJTIyJTJDJTIwbmFtZSUzQSUyMCUyMm15LXVzZXIlMkZteS1zcGFjZSUyMiUyMCU3RCUyQyUyMCUyRiUyRiUyMG9yJTIwJTIyc3BhY2VzJTJGbXktdXNlciUyRm15LXNwYWNlJTIyJTBBJTIwJTIwYWNjZXNzVG9rZW4lM0ElMjBIRl9UT0tFTiUyQyUwQSUyMCUyMHBhdGhzJTNBJTIwJTVCJTIyUkVBRE1FLm1kJTIyJTJDJTIwJTIyLmdpdGF0dHJpYnV0ZXMlMjIlNUQlMEElN0QpJTNC",highlighted:`<span class="hljs-keyword">import</span> { createRepo, uploadFile, deleteFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = <span class="hljs-string">&quot;hf_...&quot;</span>;

<span class="hljs-keyword">await</span> <span class="hljs-title function_">createRepo</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span>, <span class="hljs-comment">// or { type: &quot;model&quot;, name: &quot;my-user/nlp-test&quot; },</span>
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>
});

<span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFile</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span>,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>,
  <span class="hljs-comment">// Can work with native File in browsers</span>
  <span class="hljs-attr">file</span>: {
    <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>,
    <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>(...) 
  }
});

<span class="hljs-keyword">await</span> <span class="hljs-title function_">deleteFiles</span>({
  <span class="hljs-attr">repo</span>: { <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;space&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;my-user/my-space&quot;</span> }, <span class="hljs-comment">// or &quot;spaces/my-user/my-space&quot;</span>
  <span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>,
  <span class="hljs-attr">paths</span>: [<span class="hljs-string">&quot;README.md&quot;</span>, <span class="hljs-string">&quot;.gitattributes&quot;</span>]
});`,wrap:!1}}),X=new m({props:{title:"@huggingface/agents example",local:"huggingfaceagents-example",headingTag:"h3"}}),H=new j({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZBZ2VudCUyQyUyMExMTUZyb21IdWIlMkMlMjBkZWZhdWx0VG9vbHMlMjAlN0QlMjBmcm9tJTIwJyU0MGh1Z2dpbmdmYWNlJTJGYWdlbnRzJyUzQiUwQSUwQWNvbnN0JTIwSEZfVE9LRU4lMjAlM0QlMjAlMjJoZl8uLi4lMjIlM0IlMEElMEFjb25zdCUyMGFnZW50JTIwJTNEJTIwbmV3JTIwSGZBZ2VudCglMEElMjAlMjBIRl9UT0tFTiUyQyUwQSUyMCUyMExMTUZyb21IdWIoSEZfVE9LRU4pJTJDJTBBJTIwJTIwJTVCLi4uZGVmYXVsdFRvb2xzJTVEJTBBKSUzQiUwQSUwQSUwQSUyRiUyRiUyMHlvdSUyMGNhbiUyMGdlbmVyYXRlJTIwdGhlJTIwY29kZSUyQyUyMGluc3BlY3QlMjBpdCUyMGFuZCUyMHRoZW4lMjBydW4lMjBpdCUwQWNvbnN0JTIwY29kZSUyMCUzRCUyMGF3YWl0JTIwYWdlbnQuZ2VuZXJhdGVDb2RlKCUyMkRyYXclMjBhJTIwcGljdHVyZSUyMG9mJTIwYSUyMGNhdCUyMHdlYXJpbmclMjBhJTIwdG9wJTIwaGF0LiUyMFRoZW4lMjBjYXB0aW9uJTIwdGhlJTIwcGljdHVyZSUyMGFuZCUyMHJlYWQlMjBpdCUyMG91dCUyMGxvdWQuJTIyKSUzQiUwQWNvbnNvbGUubG9nKGNvZGUpJTNCJTBBY29uc3QlMjBtZXNzYWdlcyUyMCUzRCUyMGF3YWl0JTIwYWdlbnQuZXZhbHVhdGVDb2RlKGNvZGUpJTBBY29uc29sZS5sb2cobWVzc2FnZXMpJTNCJTIwJTJGJTJGJTIwY29udGFpbnMlMjB0aGUlMjBkYXRhJTBBJTBBJTJGJTJGJTIwb3IlMjB5b3UlMjBjYW4lMjBydW4lMjB0aGUlMjBjb2RlJTIwZGlyZWN0bHklMkMlMjBob3dldmVyJTIweW91JTIwY2FuJ3QlMjBjaGVjayUyMHRoYXQlMjB0aGUlMjBjb2RlJTIwaXMlMjBzYWZlJTIwdG8lMjBleGVjdXRlJTIwdGhpcyUyMHdheSUyQyUyMHVzZSUyMGF0JTIweW91ciUyMG93biUyMHJpc2suJTBBY29uc3QlMjBtZXNzYWdlcyUyMCUzRCUyMGF3YWl0JTIwYWdlbnQucnVuKCUyMkRyYXclMjBhJTIwcGljdHVyZSUyMG9mJTIwYSUyMGNhdCUyMHdlYXJpbmclMjBhJTIwdG9wJTIwaGF0LiUyMFRoZW4lMjBjYXB0aW9uJTIwdGhlJTIwcGljdHVyZSUyMGFuZCUyMHJlYWQlMjBpdCUyMG91dCUyMGxvdWQuJTIyKSUwQWNvbnNvbGUubG9nKG1lc3NhZ2VzKSUzQiUyMA==",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span>, <span class="hljs-title class_">LLMFromHub</span>, defaultTools } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/agents&#x27;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = <span class="hljs-string">&quot;hf_...&quot;</span>;

<span class="hljs-keyword">const</span> agent = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfAgent</span>(
  <span class="hljs-variable constant_">HF_TOKEN</span>,
  <span class="hljs-title class_">LLMFromHub</span>(<span class="hljs-variable constant_">HF_TOKEN</span>),
  [...defaultTools]
);


<span class="hljs-comment">// you can generate the code, inspect it and then run it</span>
<span class="hljs-keyword">const</span> code = <span class="hljs-keyword">await</span> agent.<span class="hljs-title function_">generateCode</span>(<span class="hljs-string">&quot;Draw a picture of a cat wearing a top hat. Then caption the picture and read it out loud.&quot;</span>);
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(code);
<span class="hljs-keyword">const</span> messages = <span class="hljs-keyword">await</span> agent.evaluateCode(code)
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(messages); <span class="hljs-comment">// contains the data</span>

<span class="hljs-comment">// or you can run the code directly, however you can&#x27;t check that the code is safe to execute this way, use at your own risk.</span>
<span class="hljs-keyword">const</span> messages = <span class="hljs-keyword">await</span> agent.<span class="hljs-title function_">run</span>(<span class="hljs-string">&quot;Draw a picture of a cat wearing a top hat. Then caption the picture and read it out loud.&quot;</span>)
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(messages); `,wrap:!1}}),q=new m({props:{title:"Formatting & testing",local:"formatting--testing",headingTag:"h2"}}),z=new j({props:{code:"c3VkbyUyMGNvcmVwYWNrJTIwZW5hYmxlJTBBcG5wbSUyMGluc3RhbGwlMEElMEFwbnBtJTIwLXIlMjBmb3JtYXQlM0FjaGVjayUwQXBucG0lMjAtciUyMGxpbnQlM0FjaGVjayUwQXBucG0lMjAtciUyMHRlc3Q=",highlighted:`sudo corepack enable
pnpm install

pnpm -r format:check
pnpm -r lint:check
pnpm -r test`,wrap:!1}}),_=new m({props:{title:"Building",local:"building",headingTag:"h2"}}),A=new j({props:{code:"cG5wbSUyMC1yJTIwYnVpbGQ=",highlighted:'<span class="hljs-attribute">pnpm -r build</span>',wrap:!1}}),D=new al({props:{source:"https://github.com/huggingface/huggingface.js/blob/main/docs/index.md"}}),{c(){T=h("meta"),O=t(),K=h("p"),ss=t(),U=h("p"),U.innerHTML=Rs,ls=t(),p(u.$$.fragment),as=t(),p(w.$$.fragment),ns=t(),d=h("p"),d.textContent=vs,ts=t(),g=h("ul"),g.innerHTML=$s,es=t(),b=h("p"),b.textContent=Vs,ps=t(),I=h("p"),I.textContent=Fs,cs=t(),p(f.$$.fragment),is=t(),p(B.$$.fragment),Ms=t(),Z=h("p"),Z.textContent=Xs,os=t(),p(G.$$.fragment),Js=t(),C=h("p"),C.textContent=Hs,hs=t(),p(k.$$.fragment),rs=t(),p(E.$$.fragment),ys=t(),Q=h("p"),Q.innerHTML=xs,ms=t(),p(W.$$.fragment),js=t(),p(N.$$.fragment),Ts=t(),p(S.$$.fragment),Us=t(),p(Y.$$.fragment),us=t(),R=h("p"),R.innerHTML=qs,ws=t(),p(v.$$.fragment),ds=t(),p($.$$.fragment),gs=t(),p(V.$$.fragment),bs=t(),p(F.$$.fragment),Is=t(),p(X.$$.fragment),fs=t(),p(H.$$.fragment),Bs=t(),x=h("p"),x.textContent=zs,Zs=t(),p(q.$$.fragment),Gs=t(),p(z.$$.fragment),Cs=t(),p(_.$$.fragment),ks=t(),p(A.$$.fragment),Es=t(),L=h("p"),L.innerHTML=_s,Qs=t(),p(D.$$.fragment),Ws=t(),P=h("p"),this.h()},l(s){const l=sl("svelte-u9bgzb",document.head);T=r(l,"META",{name:!0,content:!0}),l.forEach(a),O=e(s),K=r(s,"P",{}),As(K).forEach(a),ss=e(s),U=r(s,"P",{align:!0,"data-svelte-h":!0}),y(U)!=="svelte-9rngw"&&(U.innerHTML=Rs),ls=e(s),c(u.$$.fragment,s),as=e(s),c(w.$$.fragment,s),ns=e(s),d=r(s,"P",{"data-svelte-h":!0}),y(d)!=="svelte-1eufct4"&&(d.textContent=vs),ts=e(s),g=r(s,"UL",{"data-svelte-h":!0}),y(g)!=="svelte-5mbq7w"&&(g.innerHTML=$s),es=e(s),b=r(s,"P",{"data-svelte-h":!0}),y(b)!=="svelte-5pb56g"&&(b.textContent=Vs),ps=e(s),I=r(s,"P",{"data-svelte-h":!0}),y(I)!=="svelte-1vx14v7"&&(I.textContent=Fs),cs=e(s),c(f.$$.fragment,s),is=e(s),c(B.$$.fragment,s),Ms=e(s),Z=r(s,"P",{"data-svelte-h":!0}),y(Z)!=="svelte-18mxf19"&&(Z.textContent=Xs),os=e(s),c(G.$$.fragment,s),Js=e(s),C=r(s,"P",{"data-svelte-h":!0}),y(C)!=="svelte-1fdwpsr"&&(C.textContent=Hs),hs=e(s),c(k.$$.fragment,s),rs=e(s),c(E.$$.fragment,s),ys=e(s),Q=r(s,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-1td2f08"&&(Q.innerHTML=xs),ms=e(s),c(W.$$.fragment,s),js=e(s),c(N.$$.fragment,s),Ts=e(s),c(S.$$.fragment,s),Us=e(s),c(Y.$$.fragment,s),us=e(s),R=r(s,"P",{"data-svelte-h":!0}),y(R)!=="svelte-mx6w21"&&(R.innerHTML=qs),ws=e(s),c(v.$$.fragment,s),ds=e(s),c($.$$.fragment,s),gs=e(s),c(V.$$.fragment,s),bs=e(s),c(F.$$.fragment,s),Is=e(s),c(X.$$.fragment,s),fs=e(s),c(H.$$.fragment,s),Bs=e(s),x=r(s,"P",{"data-svelte-h":!0}),y(x)!=="svelte-16qnxzd"&&(x.textContent=zs),Zs=e(s),c(q.$$.fragment,s),Gs=e(s),c(z.$$.fragment,s),Cs=e(s),c(_.$$.fragment,s),ks=e(s),c(A.$$.fragment,s),Es=e(s),L=r(s,"P",{"data-svelte-h":!0}),y(L)!=="svelte-ymfi8c"&&(L.innerHTML=_s),Qs=e(s),c(D.$$.fragment,s),Ws=e(s),P=r(s,"P",{}),As(P).forEach(a),this.h()},h(){Ss(T,"name","hf:doc:metadata"),Ss(T,"content",tl),Ss(U,"align","center")},m(s,l){ll(document.head,T),n(s,O,l),n(s,K,l),n(s,ss,l),n(s,U,l),n(s,ls,l),i(u,s,l),n(s,as,l),i(w,s,l),n(s,ns,l),n(s,d,l),n(s,ts,l),n(s,g,l),n(s,es,l),n(s,b,l),n(s,ps,l),n(s,I,l),n(s,cs,l),i(f,s,l),n(s,is,l),i(B,s,l),n(s,Ms,l),n(s,Z,l),n(s,os,l),i(G,s,l),n(s,Js,l),n(s,C,l),n(s,hs,l),i(k,s,l),n(s,rs,l),i(E,s,l),n(s,ys,l),n(s,Q,l),n(s,ms,l),i(W,s,l),n(s,js,l),i(N,s,l),n(s,Ts,l),i(S,s,l),n(s,Us,l),i(Y,s,l),n(s,us,l),n(s,R,l),n(s,ws,l),i(v,s,l),n(s,ds,l),i($,s,l),n(s,gs,l),i(V,s,l),n(s,bs,l),i(F,s,l),n(s,Is,l),i(X,s,l),n(s,fs,l),i(H,s,l),n(s,Bs,l),n(s,x,l),n(s,Zs,l),i(q,s,l),n(s,Gs,l),i(z,s,l),n(s,Cs,l),i(_,s,l),n(s,ks,l),i(A,s,l),n(s,Es,l),n(s,L,l),n(s,Qs,l),i(D,s,l),n(s,Ws,l),n(s,P,l),Ns=!0},p:Ds,i(s){Ns||(M(u.$$.fragment,s),M(w.$$.fragment,s),M(f.$$.fragment,s),M(B.$$.fragment,s),M(G.$$.fragment,s),M(k.$$.fragment,s),M(E.$$.fragment,s),M(W.$$.fragment,s),M(N.$$.fragment,s),M(S.$$.fragment,s),M(Y.$$.fragment,s),M(v.$$.fragment,s),M($.$$.fragment,s),M(V.$$.fragment,s),M(F.$$.fragment,s),M(X.$$.fragment,s),M(H.$$.fragment,s),M(q.$$.fragment,s),M(z.$$.fragment,s),M(_.$$.fragment,s),M(A.$$.fragment,s),M(D.$$.fragment,s),Ns=!0)},o(s){o(u.$$.fragment,s),o(w.$$.fragment,s),o(f.$$.fragment,s),o(B.$$.fragment,s),o(G.$$.fragment,s),o(k.$$.fragment,s),o(E.$$.fragment,s),o(W.$$.fragment,s),o(N.$$.fragment,s),o(S.$$.fragment,s),o(Y.$$.fragment,s),o(v.$$.fragment,s),o($.$$.fragment,s),o(V.$$.fragment,s),o(F.$$.fragment,s),o(X.$$.fragment,s),o(H.$$.fragment,s),o(q.$$.fragment,s),o(z.$$.fragment,s),o(_.$$.fragment,s),o(A.$$.fragment,s),o(D.$$.fragment,s),Ns=!1},d(s){s&&(a(O),a(K),a(ss),a(U),a(ls),a(as),a(ns),a(d),a(ts),a(g),a(es),a(b),a(ps),a(I),a(cs),a(is),a(Ms),a(Z),a(os),a(Js),a(C),a(hs),a(rs),a(ys),a(Q),a(ms),a(js),a(Ts),a(Us),a(us),a(R),a(ws),a(ds),a(gs),a(bs),a(Is),a(fs),a(Bs),a(x),a(Zs),a(Gs),a(Cs),a(ks),a(Es),a(L),a(Qs),a(Ws),a(P)),a(T),J(u,s),J(w,s),J(f,s),J(B,s),J(G,s),J(k,s),J(E,s),J(W,s),J(N,s),J(S,s),J(Y,s),J(v,s),J($,s),J(V,s),J(F,s),J(X,s),J(H,s),J(q,s),J(z,s),J(_,s),J(A,s),J(D,s)}}}const tl='{"title":"Hugging Face JS libraries","local":"hugging-face-js-libraries","sections":[{"title":"Installation","local":"installation","sections":[{"title":"From NPM","local":"from-npm","sections":[],"depth":3},{"title":"From CDN or Static hosting","local":"from-cdn-or-static-hosting","sections":[],"depth":3},{"title":"Deno","local":"deno","sections":[],"depth":3}],"depth":2},{"title":"Usage examples","local":"usage-examples","sections":[{"title":"@huggingface/inference examples","local":"huggingfaceinference-examples","sections":[],"depth":3},{"title":"@huggingface/hub examples","local":"huggingfacehub-examples","sections":[],"depth":3},{"title":"@huggingface/agents example","local":"huggingfaceagents-example","sections":[],"depth":3}],"depth":2},{"title":"Formatting & testing","local":"formatting--testing","sections":[],"depth":2},{"title":"Building","local":"building","sections":[],"depth":2}],"depth":1}';function el(Ys){return Ks(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ol extends Ps{constructor(T){super(),Os(this,T,el,nl,Ls,{})}}export{ol as component};
