import{s as qe,f as Fe,o as Le,n as De}from"../chunks/scheduler.f6b352c8.js";import{S as Ke,i as Oe,g as i,s as n,r as M,A as et,h as o,f as l,c as a,j as Ge,u as c,x as d,k as F,y as tt,a as s,v as m,d as r,t as w,w as J}from"../chunks/index.b90df637.js";import{T as lt}from"../chunks/Tip.366d2e6e.js";import{C as f}from"../chunks/CodeBlock.e5718f9d.js";import{H as K,E as st}from"../chunks/index.46a12c71.js";function nt(O){let p,y="Gradio is best suited to the creation of UI clients and MCP servers, but it is also possible to use it as an MCP Client and expose that as a UI.";return{c(){p=i("p"),p.textContent=y},l(j){p=o(j,"P",{"data-svelte-h":!0}),d(p)!=="svelte-1ld6o09"&&(p.textContent=y)},m(j,L){s(j,p,L)},p:De,d(j){j&&l(p)}}}function at(O){let p,y,j,L,g,ee,C,Ae="In the previous section, we explored how to create an MCP Server using Gradio and connect to it using an MCP Client. In this section, we’re going to explore how to use Gradio as an MCP Client to connect to an MCP Server.",te,u,le,b,ve="We’ll connect to the MCP server we created in the previous section and use it to answer questions.",se,I,ne,U,Ne="First, we need to install the <code>smolagents</code>, gradio and mcp-client libraries, if we haven’t already:",ae,$,ie,B,ke="Now, we can import the necessary libraries and create a simple Gradio interface that uses the MCP Client to connect to the MCP Server.",oe,Z,pe,W,Qe="Next, we’ll connect to the MCP Server and get the tools that we can use to answer questions.",Me,G,ce,A,xe="Now that we have the tools, we can create a simple agent that uses them to answer questions. We’ll just use a simple <code>InferenceClientModel</code> and the default model from <code>smolagents</code> for now.",me,v,re,N,Ee="Now, we can create a simple Gradio interface that uses the agent to answer questions.",we,k,Je,Q,Ye="And that’s it! We’ve created a simple Gradio interface that uses the MCP Client to connect to the MCP Server and answer questions.",de,T,Re,je,x,Te,E,Se="Here’s the complete example of the MCP Client in Gradio:",ue,Y,he,R,_e="You’ll notice that we’re closing the MCP Client in the <code>finally</code> block. This is important because the MCP Client is a long-lived object that needs to be closed when the program exits.",fe,S,ye,_,Pe=`To make your server available to others, you can deploy it to Hugging Face Spaces, just like we did in the previous section.
To deploy your Gradio MCP client to Hugging Face Spaces:`,ge,P,ze="<li><p>Create a new Space on Hugging Face:</p> <ul><li>Go to huggingface.co/spaces</li> <li>Click “Create new Space”</li> <li>Choose “Gradio” as the SDK</li> <li>Name your space (e.g., “mcp-client”)</li></ul></li> <li><p>Create a <code>requirements.txt</code> file:</p></li>",Ce,z,be,h,Ve="<li>Push your code to the Space:</li>",Ie,V,Ue,H,$e,X,He="In this section, we’ve explored how to use Gradio as an MCP Client to connect to an MCP Server. We’ve also seen how to deploy the MCP Client in Hugging Face Spaces.",Be,q,Ze,D,We;return g=new K({props:{title:"Gradio as an MCP Client",local:"gradio-as-an-mcp-client",headingTag:"h1"}}),u=new lt({props:{$$slots:{default:[nt]},$$scope:{ctx:O}}}),I=new K({props:{title:"MCP Client in Gradio",local:"mcp-client-in-gradio",headingTag:"h2"}}),$=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNtb2xhZ2VudHMlNUJtY3AlNUQlMjBncmFkaW8lNUJtY3AlNUQlMjBtY3A=",highlighted:"pip install smolagents[mcp] gradio[mcp] mcp",wrap:!1}}),Z=new f({props:{code:"JTYwJTYwJTYwcHl0aG9uJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQWZyb20lMjBtY3AuY2xpZW50LnN0ZGlvJTIwaW1wb3J0JTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQWZyb20lMjBzbW9sYWdlbnRzJTIwaW1wb3J0JTIwQ29kZUFnZW50JTJDJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwlMEFmcm9tJTIwc21vbGFnZW50cy5tY3BfY2xpZW50JTIwaW1wb3J0JTIwTUNQQ2xpZW50",highlighted:`\`\`\`python
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

<span class="hljs-keyword">from</span> mcp.client.stdio <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel
<span class="hljs-keyword">from</span> smolagents.mcp_client <span class="hljs-keyword">import</span> MCPClient`,wrap:!1}}),G=new f({props:{code:"bWNwX2NsaWVudCUyMCUzRCUyME1DUENsaWVudCglMEElMjAlMjAlMjAlMjAlN0IlMjJ1cmwlMjIlM0ElMjAlMjJodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBNzg2MCUyRmdyYWRpb19hcGklMkZtY3AlMkZzc2UlMjIlN0QlMEEpJTBBdG9vbHMlMjAlM0QlMjBtY3BfY2xpZW50LmdldF90b29scygp",highlighted:`mcp_client = MCPClient(
    {<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://localhost:7860/gradio_api/mcp/sse&quot;</span>}
)
tools = mcp_client.get_tools()`,wrap:!1}}),v=new f({props:{code:"bW9kZWwlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqdG9vbHMlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKQ==",highlighted:`model = InferenceClientModel()
agent = CodeAgent(tools=[*tools], model=model)`,wrap:!1}}),k=new f({props:{code:"ZGVtbyUyMCUzRCUyMGdyLkNoYXRJbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwZm4lM0RsYW1iZGElMjBtZXNzYWdlJTJDJTIwaGlzdG9yeSUzQSUyMHN0cihhZ2VudC5ydW4obWVzc2FnZSkpJTJDJTBBJTIwJTIwJTIwJTIwdHlwZSUzRCUyMm1lc3NhZ2VzJTIyJTJDJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0QlNUIlMjJQcmltZSUyMGZhY3Rvcml6YXRpb24lMjBvZiUyMDY4JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdGl0bGUlM0QlMjJBZ2VudCUyMHdpdGglMjBNQ1AlMjBUb29scyUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIyVGhpcyUyMGlzJTIwYSUyMHNpbXBsZSUyMGFnZW50JTIwdGhhdCUyMHVzZXMlMjBNQ1AlMjB0b29scyUyMHRvJTIwYW5zd2VyJTIwcXVlc3Rpb25zLiUyMiUyQyUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTVEJTJDJTBBKSUwQSUwQWRlbW8ubGF1bmNoKCk=",highlighted:`demo = gr.ChatInterface(
    fn=<span class="hljs-keyword">lambda</span> message, history: <span class="hljs-built_in">str</span>(agent.run(message)),
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;messages&quot;</span>,
    examples=[<span class="hljs-string">&quot;Prime factorization of 68&quot;</span>],
    title=<span class="hljs-string">&quot;Agent with MCP Tools&quot;</span>,
    description=<span class="hljs-string">&quot;This is a simple agent that uses MCP tools to answer questions.&quot;</span>,
    messages=[],
)

demo.launch()`,wrap:!1}}),x=new K({props:{title:"Complete Example",local:"complete-example",headingTag:"h2"}}),Y=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

<span class="hljs-keyword">from</span> mcp.client.stdio <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel
<span class="hljs-keyword">from</span> smolagents.mcp_client <span class="hljs-keyword">import</span> MCPClient


<span class="hljs-keyword">try</span>:
    mcp_client = MCPClient(
        <span class="hljs-comment"># {&quot;url&quot;: &quot;https://abidlabs-mcp-tools.hf.space/gradio_api/mcp/sse&quot;}</span>
        {<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://localhost:7860/gradio_api/mcp/sse&quot;</span>}
    )
    tools = mcp_client.get_tools()

    model = InferenceClientModel()
    agent = CodeAgent(tools=[*tools], model=model)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">call_agent</span>(<span class="hljs-params">message, history</span>):
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">str</span>(agent.run(message))


    demo = gr.ChatInterface(
        fn=<span class="hljs-keyword">lambda</span> message, history: <span class="hljs-built_in">str</span>(agent.run(message)),
        <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;messages&quot;</span>,
        examples=[<span class="hljs-string">&quot;Prime factorization of 68&quot;</span>],
        title=<span class="hljs-string">&quot;Agent with MCP Tools&quot;</span>,
        description=<span class="hljs-string">&quot;This is a simple agent that uses MCP tools to answer questions.&quot;</span>,
        messages=[],
    )

    demo.launch()
<span class="hljs-keyword">finally</span>:
    mcp_client.close()`,wrap:!1}}),S=new K({props:{title:"Deploying to Hugging Face Spaces",local:"deploying-to-hugging-face-spaces",headingTag:"h2"}}),z=new f({props:{code:"Z3JhZGlvJTVCbWNwJTVEJTBBc21vbGFnZW50cyU1Qm1jcCU1RA==",highlighted:`gradio[mcp]
smolagents[mcp]`,wrap:!1}}),V=new f({props:{code:"Z2l0JTIwaW5pdCUwQWdpdCUyMGFkZCUyMHNlcnZlci5weSUyMHJlcXVpcmVtZW50cy50eHQlMEFnaXQlMjBjb21taXQlMjAtbSUyMCUyMkluaXRpYWwlMjBjb21taXQlMjIlMEFnaXQlMjByZW1vdGUlMjBhZGQlMjBvcmlnaW4lMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3BhY2VzJTJGWU9VUl9VU0VSTkFNRSUyRm1jcC1jbGllbnQlMEFnaXQlMjBwdXNoJTIwLXUlMjBvcmlnaW4lMjBtYWlu",highlighted:`git init
git add server.py requirements.txt
git commit -m <span class="hljs-string">&quot;Initial commit&quot;</span>
git remote add origin https://huggingface.co/spaces/YOUR_USERNAME/mcp-client
git push -u origin main`,wrap:!1}}),H=new K({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),q=new st({props:{source:"https://github.com/huggingface/mcp-course/blob/main/units/en/unit2/gradio-client.mdx"}}),{c(){p=i("meta"),y=n(),j=i("p"),L=n(),M(g.$$.fragment),ee=n(),C=i("p"),C.textContent=Ae,te=n(),M(u.$$.fragment),le=n(),b=i("p"),b.textContent=ve,se=n(),M(I.$$.fragment),ne=n(),U=i("p"),U.innerHTML=Ne,ae=n(),M($.$$.fragment),ie=n(),B=i("p"),B.textContent=ke,oe=n(),M(Z.$$.fragment),pe=n(),W=i("p"),W.textContent=Qe,Me=n(),M(G.$$.fragment),ce=n(),A=i("p"),A.innerHTML=xe,me=n(),M(v.$$.fragment),re=n(),N=i("p"),N.textContent=Ee,we=n(),M(k.$$.fragment),Je=n(),Q=i("p"),Q.textContent=Ye,de=n(),T=i("iframe"),je=n(),M(x.$$.fragment),Te=n(),E=i("p"),E.textContent=Se,ue=n(),M(Y.$$.fragment),he=n(),R=i("p"),R.innerHTML=_e,fe=n(),M(S.$$.fragment),ye=n(),_=i("p"),_.textContent=Pe,ge=n(),P=i("ol"),P.innerHTML=ze,Ce=n(),M(z.$$.fragment),be=n(),h=i("ol"),h.innerHTML=Ve,Ie=n(),M(V.$$.fragment),Ue=n(),M(H.$$.fragment),$e=n(),X=i("p"),X.textContent=He,Be=n(),M(q.$$.fragment),Ze=n(),D=i("p"),this.h()},l(e){const t=et("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(l),y=a(e),j=o(e,"P",{}),Ge(j).forEach(l),L=a(e),c(g.$$.fragment,e),ee=a(e),C=o(e,"P",{"data-svelte-h":!0}),d(C)!=="svelte-dztswv"&&(C.textContent=Ae),te=a(e),c(u.$$.fragment,e),le=a(e),b=o(e,"P",{"data-svelte-h":!0}),d(b)!=="svelte-682wjj"&&(b.textContent=ve),se=a(e),c(I.$$.fragment,e),ne=a(e),U=o(e,"P",{"data-svelte-h":!0}),d(U)!=="svelte-zsxhur"&&(U.innerHTML=Ne),ae=a(e),c($.$$.fragment,e),ie=a(e),B=o(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-2tsitc"&&(B.textContent=ke),oe=a(e),c(Z.$$.fragment,e),pe=a(e),W=o(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-d4u1me"&&(W.textContent=Qe),Me=a(e),c(G.$$.fragment,e),ce=a(e),A=o(e,"P",{"data-svelte-h":!0}),d(A)!=="svelte-jz01ce"&&(A.innerHTML=xe),me=a(e),c(v.$$.fragment,e),re=a(e),N=o(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-ysi4z1"&&(N.textContent=Ee),we=a(e),c(k.$$.fragment,e),Je=a(e),Q=o(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-1sa2kw9"&&(Q.textContent=Ye),de=a(e),T=o(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Ge(T).forEach(l),je=a(e),c(x.$$.fragment,e),Te=a(e),E=o(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-jkw6n8"&&(E.textContent=Se),ue=a(e),c(Y.$$.fragment,e),he=a(e),R=o(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-1y1vlqe"&&(R.innerHTML=_e),fe=a(e),c(S.$$.fragment,e),ye=a(e),_=o(e,"P",{"data-svelte-h":!0}),d(_)!=="svelte-1kft0up"&&(_.textContent=Pe),ge=a(e),P=o(e,"OL",{"data-svelte-h":!0}),d(P)!=="svelte-1d97e6g"&&(P.innerHTML=ze),Ce=a(e),c(z.$$.fragment,e),be=a(e),h=o(e,"OL",{start:!0,"data-svelte-h":!0}),d(h)!=="svelte-ok99j"&&(h.innerHTML=Ve),Ie=a(e),c(V.$$.fragment,e),Ue=a(e),c(H.$$.fragment,e),$e=a(e),X=o(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-b18oph"&&(X.textContent=He),Be=a(e),c(q.$$.fragment,e),Ze=a(e),D=o(e,"P",{}),Ge(D).forEach(l),this.h()},h(){F(p,"name","hf:doc:metadata"),F(p,"content",it),Fe(T.src,Re="https://mcp-course-unit2-gradio-client.hf.space")||F(T,"src",Re),F(T,"frameborder","0"),F(T,"width","850"),F(T,"height","450"),F(h,"start","3")},m(e,t){tt(document.head,p),s(e,y,t),s(e,j,t),s(e,L,t),m(g,e,t),s(e,ee,t),s(e,C,t),s(e,te,t),m(u,e,t),s(e,le,t),s(e,b,t),s(e,se,t),m(I,e,t),s(e,ne,t),s(e,U,t),s(e,ae,t),m($,e,t),s(e,ie,t),s(e,B,t),s(e,oe,t),m(Z,e,t),s(e,pe,t),s(e,W,t),s(e,Me,t),m(G,e,t),s(e,ce,t),s(e,A,t),s(e,me,t),m(v,e,t),s(e,re,t),s(e,N,t),s(e,we,t),m(k,e,t),s(e,Je,t),s(e,Q,t),s(e,de,t),s(e,T,t),s(e,je,t),m(x,e,t),s(e,Te,t),s(e,E,t),s(e,ue,t),m(Y,e,t),s(e,he,t),s(e,R,t),s(e,fe,t),m(S,e,t),s(e,ye,t),s(e,_,t),s(e,ge,t),s(e,P,t),s(e,Ce,t),m(z,e,t),s(e,be,t),s(e,h,t),s(e,Ie,t),m(V,e,t),s(e,Ue,t),m(H,e,t),s(e,$e,t),s(e,X,t),s(e,Be,t),m(q,e,t),s(e,Ze,t),s(e,D,t),We=!0},p(e,[t]){const Xe={};t&2&&(Xe.$$scope={dirty:t,ctx:e}),u.$set(Xe)},i(e){We||(r(g.$$.fragment,e),r(u.$$.fragment,e),r(I.$$.fragment,e),r($.$$.fragment,e),r(Z.$$.fragment,e),r(G.$$.fragment,e),r(v.$$.fragment,e),r(k.$$.fragment,e),r(x.$$.fragment,e),r(Y.$$.fragment,e),r(S.$$.fragment,e),r(z.$$.fragment,e),r(V.$$.fragment,e),r(H.$$.fragment,e),r(q.$$.fragment,e),We=!0)},o(e){w(g.$$.fragment,e),w(u.$$.fragment,e),w(I.$$.fragment,e),w($.$$.fragment,e),w(Z.$$.fragment,e),w(G.$$.fragment,e),w(v.$$.fragment,e),w(k.$$.fragment,e),w(x.$$.fragment,e),w(Y.$$.fragment,e),w(S.$$.fragment,e),w(z.$$.fragment,e),w(V.$$.fragment,e),w(H.$$.fragment,e),w(q.$$.fragment,e),We=!1},d(e){e&&(l(y),l(j),l(L),l(ee),l(C),l(te),l(le),l(b),l(se),l(ne),l(U),l(ae),l(ie),l(B),l(oe),l(pe),l(W),l(Me),l(ce),l(A),l(me),l(re),l(N),l(we),l(Je),l(Q),l(de),l(T),l(je),l(Te),l(E),l(ue),l(he),l(R),l(fe),l(ye),l(_),l(ge),l(P),l(Ce),l(be),l(h),l(Ie),l(Ue),l($e),l(X),l(Be),l(Ze),l(D)),l(p),J(g,e),J(u,e),J(I,e),J($,e),J(Z,e),J(G,e),J(v,e),J(k,e),J(x,e),J(Y,e),J(S,e),J(z,e),J(V,e),J(H,e),J(q,e)}}}const it='{"title":"Gradio as an MCP Client","local":"gradio-as-an-mcp-client","sections":[{"title":"MCP Client in Gradio","local":"mcp-client-in-gradio","sections":[],"depth":2},{"title":"Complete Example","local":"complete-example","sections":[],"depth":2},{"title":"Deploying to Hugging Face Spaces","local":"deploying-to-hugging-face-spaces","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function ot(O){return Le(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wt extends Ke{constructor(p){super(),Oe(this,p,ot,at,qe,{})}}export{wt as component};
