import{s as We,o as Re,n as He}from"../chunks/scheduler.8c3d61f6.js";import{S as Xe,i as ze,g as p,s as n,r as d,A as Be,h as o,f as s,c as i,j as Ee,u,x as c,k as Pe,y as Ne,a as l,v as f,d as m,t as h,w as M}from"../chunks/index.da70eac4.js";import{T as Ce}from"../chunks/Tip.1d9b8c37.js";import{C as Q}from"../chunks/CodeBlock.00a903b3.js";import{H as we,E as Ae}from"../chunks/EditOnGithub.1e64e623.js";function Le(L){let a,w='Refer to this minimal example <a href="https://gist.github.com/sayakpaul/cfaebd221820d7b43fae638b4dfa01ba" rel="nofollow">script</a> for running inference across multiple GPUs. To learn more, take a look at the <a href="https://huggingface.co/docs/accelerate/en/usage_guides/distributed_inference#distributed-inference-with-accelerate" rel="nofollow">Distributed Inference with 🤗 Accelerate</a> guide.';return{c(){a=p("p"),a.innerHTML=w},l(r){a=o(r,"P",{"data-svelte-h":!0}),c(a)!=="svelte-gctvmu"&&(a.innerHTML=w)},m(r,y){l(r,a,y)},p:He,d(r){r&&s(a)}}}function Qe(L){let a,w='You can use <code>device_map</code> within a <a href="/docs/diffusers/pr_7067/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to distribute its model-level components on multiple devices. Refer to the <a href="../tutorials/inference_with_big_models#device-placement">Device placement</a> guide to learn more.';return{c(){a=p("p"),a.innerHTML=w},l(r){a=o(r,"P",{"data-svelte-h":!0}),c(a)!=="svelte-c659im"&&(a.innerHTML=w)},m(r,y){l(r,a,y)},p:He,d(r){r&&s(a)}}}function xe(L){let a,w,r,y,j,Y,J,ye='On distributed setups, you can run inference across multiple GPUs with 🤗 <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate</a> or <a href="https://pytorch.org/tutorials/beginner/dist_overview.html" rel="nofollow">PyTorch Distributed</a>, which is useful for generating with multiple prompts in parallel.',S,g,be="This guide will show you how to use 🤗 Accelerate and PyTorch Distributed for distributed inference.",V,$,D,_,Te='🤗 <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate</a> is a library designed to make it easy to train or run inference across distributed setups. It simplifies the process of setting up the distributed environment, allowing you to focus on your PyTorch code.',F,U,je='To begin, create a Python file and initialize an <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/state#accelerate.PartialState" rel="nofollow">accelerate.PartialState</a> to create a distributed environment; your setup is automatically detected so you don’t need to explicitly define the <code>rank</code> or <code>world_size</code>. Move the <a href="/docs/diffusers/pr_7067/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to <code>distributed_state.device</code> to assign a GPU to each process.',q,v,Je='Now use the <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/state#accelerate.PartialState.split_between_processes" rel="nofollow">split_between_processes</a> utility as a context manager to automatically distribute the prompts between the number of processes.',K,Z,O,k,ge="Use the <code>--num_processes</code> argument to specify the number of GPUs to use, and call <code>accelerate launch</code> to run the script:",ee,G,te,b,se,I,le,E,$e='PyTorch supports <a href="https://pytorch.org/docs/stable/generated/torch.nn.parallel.DistributedDataParallel.html" rel="nofollow"><code>DistributedDataParallel</code></a> which enables data parallelism.',ne,P,_e='To start, create a Python file and import <code>torch.distributed</code> and <code>torch.multiprocessing</code> to set up the distributed process group and to spawn the processes for inference on each GPU. You should also initialize a <a href="/docs/diffusers/pr_7067/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>:',ie,C,ae,H,Ue='You’ll want to create a function to run inference; <a href="https://pytorch.org/docs/stable/distributed.html?highlight=init_process_group#torch.distributed.init_process_group" rel="nofollow"><code>init_process_group</code></a> handles creating a distributed environment with the type of backend to use, the <code>rank</code> of the current process, and the <code>world_size</code> or the number of processes participating. If you’re running inference in parallel over 2 GPUs, then the <code>world_size</code> is 2.',re,W,ve='Move the <a href="/docs/diffusers/pr_7067/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to <code>rank</code> and use <code>get_rank</code> to assign a GPU to each process, where each process handles a different prompt:',pe,R,oe,X,Ze='To run the distributed inference, call <a href="https://pytorch.org/docs/stable/multiprocessing.html#torch.multiprocessing.spawn" rel="nofollow"><code>mp.spawn</code></a> to run the <code>run_inference</code> function on the number of GPUs defined in <code>world_size</code>:',ce,z,de,B,ke="Once you’ve completed the inference script, use the <code>--nproc_per_node</code> argument to specify the number of GPUs to use and call <code>torchrun</code> to run the script:",ue,N,fe,T,me,A,he,x,Me;return j=new we({props:{title:"Distributed inference with multiple GPUs",local:"distributed-inference-with-multiple-gpus",headingTag:"h1"}}),$=new we({props:{title:"🤗 Accelerate",local:"-accelerate",headingTag:"h2"}}),Z=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwYWNjZWxlcmF0ZSUyMGltcG9ydCUyMFBhcnRpYWxTdGF0ZSUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBEaWZmdXNpb25QaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBZGlzdHJpYnV0ZWRfc3RhdGUlMjAlM0QlMjBQYXJ0aWFsU3RhdGUoKSUwQXBpcGVsaW5lLnRvKGRpc3RyaWJ1dGVkX3N0YXRlLmRldmljZSklMEElMEF3aXRoJTIwZGlzdHJpYnV0ZWRfc3RhdGUuc3BsaXRfYmV0d2Vlbl9wcm9jZXNzZXMoJTVCJTIyYSUyMGRvZyUyMiUyQyUyMCUyMmElMjBjYXQlMjIlNUQpJTIwYXMlMjBwcm9tcHQlM0ElMEElMjAlMjAlMjAlMjByZXN1bHQlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQpLmltYWdlcyU1QjAlNUQlMEElMjAlMjAlMjAlMjByZXN1bHQuc2F2ZShmJTIycmVzdWx0XyU3QmRpc3RyaWJ1dGVkX3N0YXRlLnByb2Nlc3NfaW5kZXglN0QucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> PartialState
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
distributed_state = PartialState()
pipeline.to(distributed_state.device)

<span class="hljs-keyword">with</span> distributed_state.split_between_processes([<span class="hljs-string">&quot;a dog&quot;</span>, <span class="hljs-string">&quot;a cat&quot;</span>]) <span class="hljs-keyword">as</span> prompt:
    result = pipeline(prompt).images[<span class="hljs-number">0</span>]
    result.save(<span class="hljs-string">f&quot;result_<span class="hljs-subst">{distributed_state.process_index}</span>.png&quot;</span>)`,wrap:!1}}),G=new Q({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHJ1bl9kaXN0cmlidXRlZC5weSUyMC0tbnVtX3Byb2Nlc3NlcyUzRDI=",highlighted:"accelerate launch run_distributed.py --num_processes=2",wrap:!1}}),b=new Ce({props:{$$slots:{default:[Le]},$$scope:{ctx:L}}}),I=new we({props:{title:"PyTorch Distributed",local:"pytorch-distributed",headingTag:"h2"}}),C=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5kaXN0cmlidXRlZCUyMGFzJTIwZGlzdCUwQWltcG9ydCUyMHRvcmNoLm11bHRpcHJvY2Vzc2luZyUyMGFzJTIwbXAlMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFzZCUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.distributed <span class="hljs-keyword">as</span> dist
<span class="hljs-keyword">import</span> torch.multiprocessing <span class="hljs-keyword">as</span> mp

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

sd = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),R=new Q({props:{code:"ZGVmJTIwcnVuX2luZmVyZW5jZShyYW5rJTJDJTIwd29ybGRfc2l6ZSklM0ElMEElMjAlMjAlMjAlMjBkaXN0LmluaXRfcHJvY2Vzc19ncm91cCglMjJuY2NsJTIyJTJDJTIwcmFuayUzRHJhbmslMkMlMjB3b3JsZF9zaXplJTNEd29ybGRfc2l6ZSklMEElMEElMjAlMjAlMjAlMjBzZC50byhyYW5rKSUwQSUwQSUyMCUyMCUyMCUyMGlmJTIwdG9yY2guZGlzdHJpYnV0ZWQuZ2V0X3JhbmsoKSUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9tcHQlMjAlM0QlMjAlMjJhJTIwZG9nJTIyJTBBJTIwJTIwJTIwJTIwZWxpZiUyMHRvcmNoLmRpc3RyaWJ1dGVkLmdldF9yYW5rKCklMjAlM0QlM0QlMjAxJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGNhdCUyMiUwQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwc2QocHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwaW1hZ2Uuc2F2ZShmJTIyLiUyRiU3QidfJy5qb2luKHByb21wdCklN0QucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_inference</span>(<span class="hljs-params">rank, world_size</span>):
    dist.init_process_group(<span class="hljs-string">&quot;nccl&quot;</span>, rank=rank, world_size=world_size)

    sd.to(rank)

    <span class="hljs-keyword">if</span> torch.distributed.get_rank() == <span class="hljs-number">0</span>:
        prompt = <span class="hljs-string">&quot;a dog&quot;</span>
    <span class="hljs-keyword">elif</span> torch.distributed.get_rank() == <span class="hljs-number">1</span>:
        prompt = <span class="hljs-string">&quot;a cat&quot;</span>

    image = sd(prompt).images[<span class="hljs-number">0</span>]
    image.save(<span class="hljs-string">f&quot;./<span class="hljs-subst">{<span class="hljs-string">&#x27;_&#x27;</span>.join(prompt)}</span>.png&quot;</span>)`,wrap:!1}}),z=new Q({props:{code:"ZGVmJTIwbWFpbigpJTNBJTBBJTIwJTIwJTIwJTIwd29ybGRfc2l6ZSUyMCUzRCUyMDIlMEElMjAlMjAlMjAlMjBtcC5zcGF3bihydW5faW5mZXJlbmNlJTJDJTIwYXJncyUzRCh3b3JsZF9zaXplJTJDKSUyQyUyMG5wcm9jcyUzRHdvcmxkX3NpemUlMkMlMjBqb2luJTNEVHJ1ZSklMEElMEElMEFpZiUyMF9fbmFtZV9fJTIwJTNEJTNEJTIwJTIyX19tYWluX18lMjIlM0ElMEElMjAlMjAlMjAlMjBtYWluKCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    world_size = <span class="hljs-number">2</span>
    mp.spawn(run_inference, args=(world_size,), nprocs=world_size, join=<span class="hljs-literal">True</span>)


<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    main()`,wrap:!1}}),N=new Q({props:{code:"dG9yY2hydW4lMjBydW5fZGlzdHJpYnV0ZWQucHklMjAtLW5wcm9jX3Blcl9ub2RlJTNEMg==",highlighted:"torchrun run_distributed.py --nproc_per_node=2",wrap:!1}}),T=new Ce({props:{warning:!1,$$slots:{default:[Qe]},$$scope:{ctx:L}}}),A=new Ae({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/training/distributed_inference.md"}}),{c(){a=p("meta"),w=n(),r=p("p"),y=n(),d(j.$$.fragment),Y=n(),J=p("p"),J.innerHTML=ye,S=n(),g=p("p"),g.textContent=be,V=n(),d($.$$.fragment),D=n(),_=p("p"),_.innerHTML=Te,F=n(),U=p("p"),U.innerHTML=je,q=n(),v=p("p"),v.innerHTML=Je,K=n(),d(Z.$$.fragment),O=n(),k=p("p"),k.innerHTML=ge,ee=n(),d(G.$$.fragment),te=n(),d(b.$$.fragment),se=n(),d(I.$$.fragment),le=n(),E=p("p"),E.innerHTML=$e,ne=n(),P=p("p"),P.innerHTML=_e,ie=n(),d(C.$$.fragment),ae=n(),H=p("p"),H.innerHTML=Ue,re=n(),W=p("p"),W.innerHTML=ve,pe=n(),d(R.$$.fragment),oe=n(),X=p("p"),X.innerHTML=Ze,ce=n(),d(z.$$.fragment),de=n(),B=p("p"),B.innerHTML=ke,ue=n(),d(N.$$.fragment),fe=n(),d(T.$$.fragment),me=n(),d(A.$$.fragment),he=n(),x=p("p"),this.h()},l(e){const t=Be("svelte-u9bgzb",document.head);a=o(t,"META",{name:!0,content:!0}),t.forEach(s),w=i(e),r=o(e,"P",{}),Ee(r).forEach(s),y=i(e),u(j.$$.fragment,e),Y=i(e),J=o(e,"P",{"data-svelte-h":!0}),c(J)!=="svelte-a7bv7i"&&(J.innerHTML=ye),S=i(e),g=o(e,"P",{"data-svelte-h":!0}),c(g)!=="svelte-1qu3csy"&&(g.textContent=be),V=i(e),u($.$$.fragment,e),D=i(e),_=o(e,"P",{"data-svelte-h":!0}),c(_)!=="svelte-13uq1g2"&&(_.innerHTML=Te),F=i(e),U=o(e,"P",{"data-svelte-h":!0}),c(U)!=="svelte-16zfifw"&&(U.innerHTML=je),q=i(e),v=o(e,"P",{"data-svelte-h":!0}),c(v)!=="svelte-1iuwz8b"&&(v.innerHTML=Je),K=i(e),u(Z.$$.fragment,e),O=i(e),k=o(e,"P",{"data-svelte-h":!0}),c(k)!=="svelte-1ohh8as"&&(k.innerHTML=ge),ee=i(e),u(G.$$.fragment,e),te=i(e),u(b.$$.fragment,e),se=i(e),u(I.$$.fragment,e),le=i(e),E=o(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-jtiddl"&&(E.innerHTML=$e),ne=i(e),P=o(e,"P",{"data-svelte-h":!0}),c(P)!=="svelte-1nda841"&&(P.innerHTML=_e),ie=i(e),u(C.$$.fragment,e),ae=i(e),H=o(e,"P",{"data-svelte-h":!0}),c(H)!=="svelte-qkdvuf"&&(H.innerHTML=Ue),re=i(e),W=o(e,"P",{"data-svelte-h":!0}),c(W)!=="svelte-1ylqai8"&&(W.innerHTML=ve),pe=i(e),u(R.$$.fragment,e),oe=i(e),X=o(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-1ecd3vq"&&(X.innerHTML=Ze),ce=i(e),u(z.$$.fragment,e),de=i(e),B=o(e,"P",{"data-svelte-h":!0}),c(B)!=="svelte-ykaora"&&(B.innerHTML=ke),ue=i(e),u(N.$$.fragment,e),fe=i(e),u(T.$$.fragment,e),me=i(e),u(A.$$.fragment,e),he=i(e),x=o(e,"P",{}),Ee(x).forEach(s),this.h()},h(){Pe(a,"name","hf:doc:metadata"),Pe(a,"content",Ye)},m(e,t){Ne(document.head,a),l(e,w,t),l(e,r,t),l(e,y,t),f(j,e,t),l(e,Y,t),l(e,J,t),l(e,S,t),l(e,g,t),l(e,V,t),f($,e,t),l(e,D,t),l(e,_,t),l(e,F,t),l(e,U,t),l(e,q,t),l(e,v,t),l(e,K,t),f(Z,e,t),l(e,O,t),l(e,k,t),l(e,ee,t),f(G,e,t),l(e,te,t),f(b,e,t),l(e,se,t),f(I,e,t),l(e,le,t),l(e,E,t),l(e,ne,t),l(e,P,t),l(e,ie,t),f(C,e,t),l(e,ae,t),l(e,H,t),l(e,re,t),l(e,W,t),l(e,pe,t),f(R,e,t),l(e,oe,t),l(e,X,t),l(e,ce,t),f(z,e,t),l(e,de,t),l(e,B,t),l(e,ue,t),f(N,e,t),l(e,fe,t),f(T,e,t),l(e,me,t),f(A,e,t),l(e,he,t),l(e,x,t),Me=!0},p(e,[t]){const Ge={};t&2&&(Ge.$$scope={dirty:t,ctx:e}),b.$set(Ge);const Ie={};t&2&&(Ie.$$scope={dirty:t,ctx:e}),T.$set(Ie)},i(e){Me||(m(j.$$.fragment,e),m($.$$.fragment,e),m(Z.$$.fragment,e),m(G.$$.fragment,e),m(b.$$.fragment,e),m(I.$$.fragment,e),m(C.$$.fragment,e),m(R.$$.fragment,e),m(z.$$.fragment,e),m(N.$$.fragment,e),m(T.$$.fragment,e),m(A.$$.fragment,e),Me=!0)},o(e){h(j.$$.fragment,e),h($.$$.fragment,e),h(Z.$$.fragment,e),h(G.$$.fragment,e),h(b.$$.fragment,e),h(I.$$.fragment,e),h(C.$$.fragment,e),h(R.$$.fragment,e),h(z.$$.fragment,e),h(N.$$.fragment,e),h(T.$$.fragment,e),h(A.$$.fragment,e),Me=!1},d(e){e&&(s(w),s(r),s(y),s(Y),s(J),s(S),s(g),s(V),s(D),s(_),s(F),s(U),s(q),s(v),s(K),s(O),s(k),s(ee),s(te),s(se),s(le),s(E),s(ne),s(P),s(ie),s(ae),s(H),s(re),s(W),s(pe),s(oe),s(X),s(ce),s(de),s(B),s(ue),s(fe),s(me),s(he),s(x)),s(a),M(j,e),M($,e),M(Z,e),M(G,e),M(b,e),M(I,e),M(C,e),M(R,e),M(z,e),M(N,e),M(T,e),M(A,e)}}}const Ye='{"title":"Distributed inference with multiple GPUs","local":"distributed-inference-with-multiple-gpus","sections":[{"title":"🤗 Accelerate","local":"-accelerate","sections":[],"depth":2},{"title":"PyTorch Distributed","local":"pytorch-distributed","sections":[],"depth":2}],"depth":1}';function Se(L){return Re(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Oe extends Xe{constructor(a){super(),ze(this,a,Se,xe,We,{})}}export{Oe as component};
