import{s as es,n as ss,o as ls}from"../chunks/scheduler.8c3d61f6.js";import{S as ts,i as ns,g as a,s as n,r as p,A as os,h as i,f as l,c as o,j as Ke,u,x as b,k as Oe,y as as,a as t,v as r,d as h,t as M,w as c}from"../chunks/index.589a98e8.js";import{C as m}from"../chunks/CodeBlock.36627b28.js";import{D as is}from"../chunks/DocNotebookDropdown.108e4998.js";import{H as K,E as ps}from"../chunks/EditOnGithub.e5a8d9cb.js";function us(De){let J,O,F,ee,T,se,f,le,d,Ee='🤗 Diffusers provides a <a href="/docs/diffusers/pr_7359/en/api/schedulers/overview#diffusers.utils.PushToHubMixin">PushToHubMixin</a> for uploading your model, scheduler, or pipeline to the Hub. It is an easy way to store your files on the Hub, and also allows you to share your work with others. Under the hood, the <a href="/docs/diffusers/pr_7359/en/api/schedulers/overview#diffusers.utils.PushToHubMixin">PushToHubMixin</a>:',te,y,Xe="<li>creates a repository on the Hub</li> <li>saves your model, scheduler, or pipeline files so they can be reloaded later</li> <li>uploads folder containing these files to the Hub</li>",ne,w,Ne='This guide will show you how to use the <a href="/docs/diffusers/pr_7359/en/api/schedulers/overview#diffusers.utils.PushToHubMixin">PushToHubMixin</a> to upload your files to the Hub.',oe,j,Re='You’ll need to log in to your Hub account with your access <a href="https://huggingface.co/settings/tokens" rel="nofollow">token</a> first:',ae,I,ie,_,pe,U,We='To push a model to the Hub, call <a href="/docs/diffusers/pr_7359/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> and specify the repository id of the model to be stored on the Hub:',ue,v,re,k,He='For models, you can also specify the <a href="loading#checkpoint-variants"><em>variant</em></a> of the weights to push to the Hub. For example, to push <code>fp16</code> weights:',he,g,Me,$,xe='The <a href="/docs/diffusers/pr_7359/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> function saves the model’s <code>config.json</code> file and the weights are automatically saved in the <code>safetensors</code> format.',ce,B,Ye="Now you can reload the model from your repository on the Hub:",be,Z,me,C,Je,G,ze='To push a scheduler to the Hub, call <a href="/docs/diffusers/pr_7359/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> and specify the repository id of the scheduler to be stored on the Hub:',Te,V,fe,D,Qe='The <a href="/docs/diffusers/pr_7359/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> function saves the scheduler’s <code>scheduler_config.json</code> file to the specified repository.',de,E,Se="Now you can reload the scheduler from your repository on the Hub:",ye,X,we,N,je,R,qe='You can also push an entire pipeline with all it’s components to the Hub. For example, initialize the components of a <a href="/docs/diffusers/pr_7359/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> with the parameters you want:',Ie,W,_e,H,Ae='Pass all of the components to the <a href="/docs/diffusers/pr_7359/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> and call <a href="/docs/diffusers/pr_7359/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> to push the pipeline to the Hub:',Ue,x,ve,Y,Pe='The <a href="/docs/diffusers/pr_7359/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> function saves each component to a subfolder in the repository. Now you can reload the pipeline from your repository on the Hub:',ke,z,ge,Q,$e,S,Fe='Set <code>private=True</code> in the <a href="/docs/diffusers/pr_7359/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> function to keep your model, scheduler, or pipeline files private:',Be,q,Ze,A,Le='Private repositories are only visible to you, and other users won’t be able to clone the repository and your repository won’t appear in search results. Even if a user has the URL to your private repository, they’ll receive a <code>404 - Sorry, we can&#39;t find the page you are looking for</code>. You must be <a href="https://huggingface.co/docs/huggingface_hub/quick-start#login" rel="nofollow">logged in</a> to load a model from a private repository.',Ce,P,Ge,L,Ve;return T=new K({props:{title:"Push files to the Hub",local:"push-files-to-the-hub",headingTag:"h1"}}),f=new is({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/push_to_hub.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/push_to_hub.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/push_to_hub.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/push_to_hub.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/push_to_hub.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/push_to_hub.ipynb"}]}}),I=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),_=new K({props:{title:"Models",local:"models",headingTag:"h2"}}),v=new m({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMENvbnRyb2xOZXRNb2RlbCUwQSUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwoJTBBJTIwJTIwJTIwJTIwYmxvY2tfb3V0X2NoYW5uZWxzJTNEKDMyJTJDJTIwNjQpJTJDJTBBJTIwJTIwJTIwJTIwbGF5ZXJzX3Blcl9ibG9jayUzRDIlMkMlMEElMjAlMjAlMjAlMjBpbl9jaGFubmVscyUzRDQlMkMlMEElMjAlMjAlMjAlMjBkb3duX2Jsb2NrX3R5cGVzJTNEKCUyMkRvd25CbG9jazJEJTIyJTJDJTIwJTIyQ3Jvc3NBdHRuRG93bkJsb2NrMkQlMjIpJTJDJTBBJTIwJTIwJTIwJTIwY3Jvc3NfYXR0ZW50aW9uX2RpbSUzRDMyJTJDJTBBJTIwJTIwJTIwJTIwY29uZGl0aW9uaW5nX2VtYmVkZGluZ19vdXRfY2hhbm5lbHMlM0QoMTYlMkMlMjAzMiklMkMlMEEpJTBBY29udHJvbG5ldC5wdXNoX3RvX2h1YiglMjJteS1jb250cm9sbmV0LW1vZGVsJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ControlNetModel

controlnet = ControlNetModel(
    block_out_channels=(<span class="hljs-number">32</span>, <span class="hljs-number">64</span>),
    layers_per_block=<span class="hljs-number">2</span>,
    in_channels=<span class="hljs-number">4</span>,
    down_block_types=(<span class="hljs-string">&quot;DownBlock2D&quot;</span>, <span class="hljs-string">&quot;CrossAttnDownBlock2D&quot;</span>),
    cross_attention_dim=<span class="hljs-number">32</span>,
    conditioning_embedding_out_channels=(<span class="hljs-number">16</span>, <span class="hljs-number">32</span>),
)
controlnet.push_to_hub(<span class="hljs-string">&quot;my-controlnet-model&quot;</span>)`,wrap:!1}}),g=new m({props:{code:"Y29udHJvbG5ldC5wdXNoX3RvX2h1YiglMjJteS1jb250cm9sbmV0LW1vZGVsJTIyJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIp",highlighted:'controlnet.push_to_hub(<span class="hljs-string">&quot;my-controlnet-model&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>)',wrap:!1}}),Z=new m({props:{code:"bW9kZWwlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnlvdXItbmFtZXNwYWNlJTJGbXktY29udHJvbG5ldC1tb2RlbCUyMik=",highlighted:'model = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;your-namespace/my-controlnet-model&quot;</span>)',wrap:!1}}),C=new K({props:{title:"Scheduler",local:"scheduler",headingTag:"h2"}}),V=new m({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERESU1TY2hlZHVsZXIlMEElMEFzY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMGJldGFfc3RhcnQlM0QwLjAwMDg1JTJDJTBBJTIwJTIwJTIwJTIwYmV0YV9lbmQlM0QwLjAxMiUyQyUwQSUyMCUyMCUyMCUyMGJldGFfc2NoZWR1bGUlM0QlMjJzY2FsZWRfbGluZWFyJTIyJTJDJTBBJTIwJTIwJTIwJTIwY2xpcF9zYW1wbGUlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHNldF9hbHBoYV90b19vbmUlM0RGYWxzZSUyQyUwQSklMEFzY2hlZHVsZXIucHVzaF90b19odWIoJTIybXktY29udHJvbG5ldC1zY2hlZHVsZXIlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMScheduler

scheduler = DDIMScheduler(
    beta_start=<span class="hljs-number">0.00085</span>,
    beta_end=<span class="hljs-number">0.012</span>,
    beta_schedule=<span class="hljs-string">&quot;scaled_linear&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    set_alpha_to_one=<span class="hljs-literal">False</span>,
)
scheduler.push_to_hub(<span class="hljs-string">&quot;my-controlnet-scheduler&quot;</span>)`,wrap:!1}}),X=new m({props:{code:"c2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQoJTIyeW91ci1uYW1lcHNhY2UlMkZteS1jb250cm9sbmV0LXNjaGVkdWxlciUyMik=",highlighted:'scheduler = DDIMScheduler.from_pretrained(<span class="hljs-string">&quot;your-namepsace/my-controlnet-scheduler&quot;</span>)',wrap:!1}}),N=new K({props:{title:"Pipeline",local:"pipeline",headingTag:"h2"}}),W=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
    UNet2DConditionModel,
    AutoencoderKL,
    DDIMScheduler,
    StableDiffusionPipeline,
)
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPTextModel, CLIPTextConfig, CLIPTokenizer

unet = UNet2DConditionModel(
    block_out_channels=(<span class="hljs-number">32</span>, <span class="hljs-number">64</span>),
    layers_per_block=<span class="hljs-number">2</span>,
    sample_size=<span class="hljs-number">32</span>,
    in_channels=<span class="hljs-number">4</span>,
    out_channels=<span class="hljs-number">4</span>,
    down_block_types=(<span class="hljs-string">&quot;DownBlock2D&quot;</span>, <span class="hljs-string">&quot;CrossAttnDownBlock2D&quot;</span>),
    up_block_types=(<span class="hljs-string">&quot;CrossAttnUpBlock2D&quot;</span>, <span class="hljs-string">&quot;UpBlock2D&quot;</span>),
    cross_attention_dim=<span class="hljs-number">32</span>,
)

scheduler = DDIMScheduler(
    beta_start=<span class="hljs-number">0.00085</span>,
    beta_end=<span class="hljs-number">0.012</span>,
    beta_schedule=<span class="hljs-string">&quot;scaled_linear&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    set_alpha_to_one=<span class="hljs-literal">False</span>,
)

vae = AutoencoderKL(
    block_out_channels=[<span class="hljs-number">32</span>, <span class="hljs-number">64</span>],
    in_channels=<span class="hljs-number">3</span>,
    out_channels=<span class="hljs-number">3</span>,
    down_block_types=[<span class="hljs-string">&quot;DownEncoderBlock2D&quot;</span>, <span class="hljs-string">&quot;DownEncoderBlock2D&quot;</span>],
    up_block_types=[<span class="hljs-string">&quot;UpDecoderBlock2D&quot;</span>, <span class="hljs-string">&quot;UpDecoderBlock2D&quot;</span>],
    latent_channels=<span class="hljs-number">4</span>,
)

text_encoder_config = CLIPTextConfig(
    bos_token_id=<span class="hljs-number">0</span>,
    eos_token_id=<span class="hljs-number">2</span>,
    hidden_size=<span class="hljs-number">32</span>,
    intermediate_size=<span class="hljs-number">37</span>,
    layer_norm_eps=<span class="hljs-number">1e-05</span>,
    num_attention_heads=<span class="hljs-number">4</span>,
    num_hidden_layers=<span class="hljs-number">5</span>,
    pad_token_id=<span class="hljs-number">1</span>,
    vocab_size=<span class="hljs-number">1000</span>,
)
text_encoder = CLIPTextModel(text_encoder_config)
tokenizer = CLIPTokenizer.from_pretrained(<span class="hljs-string">&quot;hf-internal-testing/tiny-random-clip&quot;</span>)`,wrap:!1}}),x=new m({props:{code:"Y29tcG9uZW50cyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnVuZXQlMjIlM0ElMjB1bmV0JTJDJTBBJTIwJTIwJTIwJTIwJTIyc2NoZWR1bGVyJTIyJTNBJTIwc2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwJTIydmFlJTIyJTNBJTIwdmFlJTJDJTBBJTIwJTIwJTIwJTIwJTIydGV4dF9lbmNvZGVyJTIyJTNBJTIwdGV4dF9lbmNvZGVyJTJDJTBBJTIwJTIwJTIwJTIwJTIydG9rZW5pemVyJTIyJTNBJTIwdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwJTIyc2FmZXR5X2NoZWNrZXIlMjIlM0ElMjBOb25lJTJDJTBBJTIwJTIwJTIwJTIwJTIyZmVhdHVyZV9leHRyYWN0b3IlMjIlM0ElMjBOb25lJTJDJTBBJTdEJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZSgqKmNvbXBvbmVudHMpJTBBcGlwZWxpbmUucHVzaF90b19odWIoJTIybXktcGlwZWxpbmUlMjIp",highlighted:`components = {
    <span class="hljs-string">&quot;unet&quot;</span>: unet,
    <span class="hljs-string">&quot;scheduler&quot;</span>: scheduler,
    <span class="hljs-string">&quot;vae&quot;</span>: vae,
    <span class="hljs-string">&quot;text_encoder&quot;</span>: text_encoder,
    <span class="hljs-string">&quot;tokenizer&quot;</span>: tokenizer,
    <span class="hljs-string">&quot;safety_checker&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;feature_extractor&quot;</span>: <span class="hljs-literal">None</span>,
}

pipeline = StableDiffusionPipeline(**components)
pipeline.push_to_hub(<span class="hljs-string">&quot;my-pipeline&quot;</span>)`,wrap:!1}}),z=new m({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyeW91ci1uYW1lc3BhY2UlMkZteS1waXBlbGluZSUyMik=",highlighted:'pipeline = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;your-namespace/my-pipeline&quot;</span>)',wrap:!1}}),Q=new K({props:{title:"Privacy",local:"privacy",headingTag:"h2"}}),q=new m({props:{code:"Y29udHJvbG5ldC5wdXNoX3RvX2h1YiglMjJteS1jb250cm9sbmV0LW1vZGVsLXByaXZhdGUlMjIlMkMlMjBwcml2YXRlJTNEVHJ1ZSk=",highlighted:'controlnet.push_to_hub(<span class="hljs-string">&quot;my-controlnet-model-private&quot;</span>, private=<span class="hljs-literal">True</span>)',wrap:!1}}),P=new ps({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/push_to_hub.md"}}),{c(){J=a("meta"),O=n(),F=a("p"),ee=n(),p(T.$$.fragment),se=n(),p(f.$$.fragment),le=n(),d=a("p"),d.innerHTML=Ee,te=n(),y=a("ol"),y.innerHTML=Xe,ne=n(),w=a("p"),w.innerHTML=Ne,oe=n(),j=a("p"),j.innerHTML=Re,ae=n(),p(I.$$.fragment),ie=n(),p(_.$$.fragment),pe=n(),U=a("p"),U.innerHTML=We,ue=n(),p(v.$$.fragment),re=n(),k=a("p"),k.innerHTML=He,he=n(),p(g.$$.fragment),Me=n(),$=a("p"),$.innerHTML=xe,ce=n(),B=a("p"),B.textContent=Ye,be=n(),p(Z.$$.fragment),me=n(),p(C.$$.fragment),Je=n(),G=a("p"),G.innerHTML=ze,Te=n(),p(V.$$.fragment),fe=n(),D=a("p"),D.innerHTML=Qe,de=n(),E=a("p"),E.textContent=Se,ye=n(),p(X.$$.fragment),we=n(),p(N.$$.fragment),je=n(),R=a("p"),R.innerHTML=qe,Ie=n(),p(W.$$.fragment),_e=n(),H=a("p"),H.innerHTML=Ae,Ue=n(),p(x.$$.fragment),ve=n(),Y=a("p"),Y.innerHTML=Pe,ke=n(),p(z.$$.fragment),ge=n(),p(Q.$$.fragment),$e=n(),S=a("p"),S.innerHTML=Fe,Be=n(),p(q.$$.fragment),Ze=n(),A=a("p"),A.innerHTML=Le,Ce=n(),p(P.$$.fragment),Ge=n(),L=a("p"),this.h()},l(e){const s=os("svelte-u9bgzb",document.head);J=i(s,"META",{name:!0,content:!0}),s.forEach(l),O=o(e),F=i(e,"P",{}),Ke(F).forEach(l),ee=o(e),u(T.$$.fragment,e),se=o(e),u(f.$$.fragment,e),le=o(e),d=i(e,"P",{"data-svelte-h":!0}),b(d)!=="svelte-wq7c0y"&&(d.innerHTML=Ee),te=o(e),y=i(e,"OL",{"data-svelte-h":!0}),b(y)!=="svelte-11ocvlf"&&(y.innerHTML=Xe),ne=o(e),w=i(e,"P",{"data-svelte-h":!0}),b(w)!=="svelte-b03nzm"&&(w.innerHTML=Ne),oe=o(e),j=i(e,"P",{"data-svelte-h":!0}),b(j)!=="svelte-1bojsgz"&&(j.innerHTML=Re),ae=o(e),u(I.$$.fragment,e),ie=o(e),u(_.$$.fragment,e),pe=o(e),U=i(e,"P",{"data-svelte-h":!0}),b(U)!=="svelte-1imse3z"&&(U.innerHTML=We),ue=o(e),u(v.$$.fragment,e),re=o(e),k=i(e,"P",{"data-svelte-h":!0}),b(k)!=="svelte-1eiubrc"&&(k.innerHTML=He),he=o(e),u(g.$$.fragment,e),Me=o(e),$=i(e,"P",{"data-svelte-h":!0}),b($)!=="svelte-10t72ei"&&($.innerHTML=xe),ce=o(e),B=i(e,"P",{"data-svelte-h":!0}),b(B)!=="svelte-1bcc50k"&&(B.textContent=Ye),be=o(e),u(Z.$$.fragment,e),me=o(e),u(C.$$.fragment,e),Je=o(e),G=i(e,"P",{"data-svelte-h":!0}),b(G)!=="svelte-13cr1cn"&&(G.innerHTML=ze),Te=o(e),u(V.$$.fragment,e),fe=o(e),D=i(e,"P",{"data-svelte-h":!0}),b(D)!=="svelte-1mai5ty"&&(D.innerHTML=Qe),de=o(e),E=i(e,"P",{"data-svelte-h":!0}),b(E)!=="svelte-rpu5q4"&&(E.textContent=Se),ye=o(e),u(X.$$.fragment,e),we=o(e),u(N.$$.fragment,e),je=o(e),R=i(e,"P",{"data-svelte-h":!0}),b(R)!=="svelte-1608oqu"&&(R.innerHTML=qe),Ie=o(e),u(W.$$.fragment,e),_e=o(e),H=i(e,"P",{"data-svelte-h":!0}),b(H)!=="svelte-1mp4p5n"&&(H.innerHTML=Ae),Ue=o(e),u(x.$$.fragment,e),ve=o(e),Y=i(e,"P",{"data-svelte-h":!0}),b(Y)!=="svelte-1r7j8ki"&&(Y.innerHTML=Pe),ke=o(e),u(z.$$.fragment,e),ge=o(e),u(Q.$$.fragment,e),$e=o(e),S=i(e,"P",{"data-svelte-h":!0}),b(S)!=="svelte-3wovsn"&&(S.innerHTML=Fe),Be=o(e),u(q.$$.fragment,e),Ze=o(e),A=i(e,"P",{"data-svelte-h":!0}),b(A)!=="svelte-ckklvi"&&(A.innerHTML=Le),Ce=o(e),u(P.$$.fragment,e),Ge=o(e),L=i(e,"P",{}),Ke(L).forEach(l),this.h()},h(){Oe(J,"name","hf:doc:metadata"),Oe(J,"content",rs)},m(e,s){as(document.head,J),t(e,O,s),t(e,F,s),t(e,ee,s),r(T,e,s),t(e,se,s),r(f,e,s),t(e,le,s),t(e,d,s),t(e,te,s),t(e,y,s),t(e,ne,s),t(e,w,s),t(e,oe,s),t(e,j,s),t(e,ae,s),r(I,e,s),t(e,ie,s),r(_,e,s),t(e,pe,s),t(e,U,s),t(e,ue,s),r(v,e,s),t(e,re,s),t(e,k,s),t(e,he,s),r(g,e,s),t(e,Me,s),t(e,$,s),t(e,ce,s),t(e,B,s),t(e,be,s),r(Z,e,s),t(e,me,s),r(C,e,s),t(e,Je,s),t(e,G,s),t(e,Te,s),r(V,e,s),t(e,fe,s),t(e,D,s),t(e,de,s),t(e,E,s),t(e,ye,s),r(X,e,s),t(e,we,s),r(N,e,s),t(e,je,s),t(e,R,s),t(e,Ie,s),r(W,e,s),t(e,_e,s),t(e,H,s),t(e,Ue,s),r(x,e,s),t(e,ve,s),t(e,Y,s),t(e,ke,s),r(z,e,s),t(e,ge,s),r(Q,e,s),t(e,$e,s),t(e,S,s),t(e,Be,s),r(q,e,s),t(e,Ze,s),t(e,A,s),t(e,Ce,s),r(P,e,s),t(e,Ge,s),t(e,L,s),Ve=!0},p:ss,i(e){Ve||(h(T.$$.fragment,e),h(f.$$.fragment,e),h(I.$$.fragment,e),h(_.$$.fragment,e),h(v.$$.fragment,e),h(g.$$.fragment,e),h(Z.$$.fragment,e),h(C.$$.fragment,e),h(V.$$.fragment,e),h(X.$$.fragment,e),h(N.$$.fragment,e),h(W.$$.fragment,e),h(x.$$.fragment,e),h(z.$$.fragment,e),h(Q.$$.fragment,e),h(q.$$.fragment,e),h(P.$$.fragment,e),Ve=!0)},o(e){M(T.$$.fragment,e),M(f.$$.fragment,e),M(I.$$.fragment,e),M(_.$$.fragment,e),M(v.$$.fragment,e),M(g.$$.fragment,e),M(Z.$$.fragment,e),M(C.$$.fragment,e),M(V.$$.fragment,e),M(X.$$.fragment,e),M(N.$$.fragment,e),M(W.$$.fragment,e),M(x.$$.fragment,e),M(z.$$.fragment,e),M(Q.$$.fragment,e),M(q.$$.fragment,e),M(P.$$.fragment,e),Ve=!1},d(e){e&&(l(O),l(F),l(ee),l(se),l(le),l(d),l(te),l(y),l(ne),l(w),l(oe),l(j),l(ae),l(ie),l(pe),l(U),l(ue),l(re),l(k),l(he),l(Me),l($),l(ce),l(B),l(be),l(me),l(Je),l(G),l(Te),l(fe),l(D),l(de),l(E),l(ye),l(we),l(je),l(R),l(Ie),l(_e),l(H),l(Ue),l(ve),l(Y),l(ke),l(ge),l($e),l(S),l(Be),l(Ze),l(A),l(Ce),l(Ge),l(L)),l(J),c(T,e),c(f,e),c(I,e),c(_,e),c(v,e),c(g,e),c(Z,e),c(C,e),c(V,e),c(X,e),c(N,e),c(W,e),c(x,e),c(z,e),c(Q,e),c(q,e),c(P,e)}}}const rs='{"title":"Push files to the Hub","local":"push-files-to-the-hub","sections":[{"title":"Models","local":"models","sections":[],"depth":2},{"title":"Scheduler","local":"scheduler","sections":[],"depth":2},{"title":"Pipeline","local":"pipeline","sections":[],"depth":2},{"title":"Privacy","local":"privacy","sections":[],"depth":2}],"depth":1}';function hs(De){return ls(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ts extends ts{constructor(J){super(),ns(this,J,hs,us,es,{})}}export{Ts as component};
