import{s as ol,n as pl,o as rl}from"../chunks/scheduler.f6b352c8.js";import{S as ul,i as Ml,g as a,s,r as u,m as xe,A as cl,h as o,f as l,c as i,j as g,u as M,x as r,n as Se,k as Be,y as p,a as n,v as c,d as h,t as m,w as y}from"../chunks/index.b90df637.js";import{C as b}from"../chunks/CodeBlock.e5718f9d.js";import{H as U,E as hl}from"../chunks/index.46a12c71.js";function ml(He){let w,It,Jt,$t,v,xt,I,_e="In this section, we’ll create our sentiment analysis MCP server using Gradio. This server will expose a sentiment analysis tool that can be used by both human users through a web interface and AI models through the MCP protocol.",St,$,Bt,x,Ze="Gradio provides a straightforward way to create MCP servers by automatically converting your Python functions into MCP tools. When you set <code>mcp_server=True</code> in <code>launch()</code>, Gradio:",Ht,S,We="<li>Automatically converts your functions into MCP Tools</li> <li>Maps input components to tool argument schemas</li> <li>Determines response formats from output components</li> <li>Sets up JSON-RPC over HTTP+SSE for client-server communication</li> <li>Creates both a web interface and an MCP server endpoint</li>",_t,B,Zt,H,Ge="First, let’s create a new directory for our project and set up the required dependencies:",Wt,_,Gt,Z,Rt,W,Re="Create a new file called <code>server.py</code> with the following code:",At,G,Et,R,Lt,A,Ae="Let’s break down the key components:",Vt,T,ut,Ee="<p><strong>Function Definition</strong>:</p> <ul><li>The <code>sentiment_analysis</code> function takes a text input and returns a dictionary</li> <li>It uses TextBlob to analyze the sentiment</li> <li>The docstring is crucial as it helps Gradio generate the MCP tool schema</li> <li>Type hints (<code>str</code> and <code>dict</code>) help define the input/output schema</li></ul>",ye,Mt,Le="<p><strong>Gradio Interface</strong>:</p> <ul><li><code>gr.Interface</code> creates both the web UI and MCP server</li> <li>The function is exposed as an MCP tool automatically</li> <li>Input and output components define the tool’s schema</li> <li>The JSON output component ensures proper serialization</li></ul>",de,E,ct,Ve="<strong>MCP Server</strong>:",Te,C,ht,ke="Setting <code>mcp_server=True</code> enables the MCP server",ge,mt,Qe="The server will be available at <code>http://localhost:7860/gradio_api/mcp/sse</code>",Ue,yt,we,L,kt,V,Qt,k,Pe="Start the server by running:",Pt,Q,qt,P,qe="You should see output indicating that both the web interface and MCP server are running. The web interface will be available at <code>http://localhost:7860</code>, and the MCP server at <code>http://localhost:7860/gradio_api/mcp/sse</code>.",Nt,q,Xt,N,Ne="You can test the server in two ways:",Yt,X,Xe="<li><p><strong>Web Interface</strong>:</p> <ul><li>Open <code>http://localhost:7860</code> in your browser</li> <li>Enter some text and click “Submit”</li> <li>You should see the sentiment analysis results</li></ul></li> <li><p><strong>MCP Schema</strong>:</p> <ul><li>Visit <code>http://localhost:7860/gradio_api/mcp/schema</code></li> <li>This shows the MCP tool schema that clients will use</li> <li>You can also find this in the “View API” link in the footer of your Gradio app</li></ul></li>",zt,Y,Ft,d,dt,Ye="<p><strong>Type Hints and Docstrings</strong>:</p> <ul><li>Always provide type hints for your function parameters and return values</li> <li>Include a docstring with an “Args:” block for each parameter</li> <li>This helps Gradio generate accurate MCP tool schemas</li></ul>",Ce,Tt,ze="<p><strong>String Inputs</strong>:</p> <ul><li>When in doubt, accept input arguments as <code>str</code></li> <li>Convert them to the desired type inside the function</li> <li>This provides better compatibility with MCP clients</li></ul>",je,z,gt,Fe="<strong>SSE Support</strong>:",fe,F,Ut,Oe="Some MCP clients don’t support SSE-based MCP Servers",Je,j,be,wt,De="mcp-remote",ve,O,Ie,Ct,Ke="<p><strong>Connection Issues</strong>:</p> <ul><li>If you encounter connection problems, try restarting both the client and server</li> <li>Check that the server is running and accessible</li> <li>Verify that the MCP schema is available at the expected URL</li></ul>",Ot,D,Dt,K,tl="To make your server available to others, you can deploy it to Hugging Face Spaces:",Kt,tt,el="<li><p>Create a new Space on Hugging Face:</p> <ul><li>Go to huggingface.co/spaces</li> <li>Click “Create new Space”</li> <li>Choose “Gradio” as the SDK</li> <li>Name your space (e.g., “mcp-sentiment”)</li></ul></li> <li><p>Create a <code>requirements.txt</code> file:</p></li>",te,et,ee,f,ll="<li>Push your code to the Space:</li>",le,lt,ne,nt,nl="Your MCP server will now be available at:",se,st,ie,it,ae,at,sl="Now that we have our MCP server running, we’ll create clients to interact with it. In the next sections, we’ll:",oe,ot,il="<li>Create a HuggingFace.js-based client inspired by Tiny Agents</li> <li>Implement a SmolAgents-based Python client</li> <li>Test both clients with our deployed server</li>",pe,pt,al="Let’s move on to building our first client!",re,rt,ue,bt,Me;return v=new U({props:{title:"Building the Gradio MCP Server",local:"building-the-gradio-mcp-server",headingTag:"h1"}}),$=new U({props:{title:"Introduction to Gradio MCP Integration",local:"introduction-to-gradio-mcp-integration",headingTag:"h2"}}),B=new U({props:{title:"Setting Up the Project",local:"setting-up-the-project",headingTag:"h2"}}),_=new b({props:{code:"bWtkaXIlMjBtY3Atc2VudGltZW50JTBBY2QlMjBtY3Atc2VudGltZW50JTBBcHl0aG9uJTIwLW0lMjB2ZW52JTIwdmVudiUwQXNvdXJjZSUyMHZlbnYlMkZiaW4lMkZhY3RpdmF0ZSUyMCUyMCUyMyUyME9uJTIwV2luZG93cyUzQSUyMHZlbnYlNUNTY3JpcHRzJTVDYWN0aXZhdGUlMEFwaXAlMjBpbnN0YWxsJTIwJTIyZ3JhZGlvJTVCbWNwJTVEJTIyJTIwdGV4dGJsb2I=",highlighted:`<span class="hljs-built_in">mkdir</span> mcp-sentiment
<span class="hljs-built_in">cd</span> mcp-sentiment
python -m venv venv
<span class="hljs-built_in">source</span> venv/bin/activate  <span class="hljs-comment"># On Windows: venv\\Scripts\\activate</span>
pip install <span class="hljs-string">&quot;gradio[mcp]&quot;</span> textblob`,wrap:!1}}),Z=new U({props:{title:"Creating the Server",local:"creating-the-server",headingTag:"h2"}}),G=new b({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> textblob <span class="hljs-keyword">import</span> TextBlob

<span class="hljs-keyword">def</span> <span class="hljs-title function_">sentiment_analysis</span>(<span class="hljs-params">text: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">dict</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Analyze the sentiment of the given text.

    Args:
        text (str): The text to analyze

    Returns:
        dict: A dictionary containing polarity, subjectivity, and assessment
    &quot;&quot;&quot;</span>
    blob = TextBlob(text)
    sentiment = blob.sentiment
    
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;polarity&quot;</span>: <span class="hljs-built_in">round</span>(sentiment.polarity, <span class="hljs-number">2</span>),  <span class="hljs-comment"># -1 (negative) to 1 (positive)</span>
        <span class="hljs-string">&quot;subjectivity&quot;</span>: <span class="hljs-built_in">round</span>(sentiment.subjectivity, <span class="hljs-number">2</span>),  <span class="hljs-comment"># 0 (objective) to 1 (subjective)</span>
        <span class="hljs-string">&quot;assessment&quot;</span>: <span class="hljs-string">&quot;positive&quot;</span> <span class="hljs-keyword">if</span> sentiment.polarity &gt; <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;negative&quot;</span> <span class="hljs-keyword">if</span> sentiment.polarity &lt; <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;neutral&quot;</span>
    }

<span class="hljs-comment"># Create the Gradio interface</span>
demo = gr.Interface(
    fn=sentiment_analysis,
    inputs=gr.Textbox(placeholder=<span class="hljs-string">&quot;Enter text to analyze...&quot;</span>),
    outputs=gr.JSON(),
    title=<span class="hljs-string">&quot;Text Sentiment Analysis&quot;</span>,
    description=<span class="hljs-string">&quot;Analyze the sentiment of text using TextBlob&quot;</span>
)

<span class="hljs-comment"># Launch the interface and MCP server</span>
<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    demo.launch(mcp_server=<span class="hljs-literal">True</span>)`,wrap:!1}}),R=new U({props:{title:"Understanding the Code",local:"understanding-the-code",headingTag:"h2"}}),L=new b({props:{code:"ZXhwb3J0JTIwR1JBRElPX01DUF9TRVJWRVIlM0RUcnVl",highlighted:'<span class="hljs-built_in">export</span> GRADIO_MCP_SERVER=True',wrap:!1}}),V=new U({props:{title:"Running the Server",local:"running-the-server",headingTag:"h2"}}),Q=new b({props:{code:"cHl0aG9uJTIwc2VydmVyLnB5",highlighted:"python server.py",wrap:!1}}),q=new U({props:{title:"Testing the Server",local:"testing-the-server",headingTag:"h2"}}),Y=new U({props:{title:"Troubleshooting Tips",local:"troubleshooting-tips",headingTag:"h2"}}),O=new b({props:{code:"JTdCJTBBJTIwJTIwJTIybWNwU2VydmVycyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmdyYWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbW1hbmQlMjIlM0ElMjAlMjJucHglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJhcmdzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWNwLXJlbW90ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E3ODYwJTJGZ3JhZGlvX2FwaSUyRm1jcCUyRnNzZSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;mcpServers&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;gradio&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;command&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;npx&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;args&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;mcp-remote&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-string">&quot;http://localhost:7860/gradio_api/mcp/sse&quot;</span>
      <span class="hljs-punctuation">]</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),D=new U({props:{title:"Deploying to Hugging Face Spaces",local:"deploying-to-hugging-face-spaces",headingTag:"h2"}}),et=new b({props:{code:"Z3JhZGlvJTVCbWNwJTVEJTBBdGV4dGJsb2I=",highlighted:`gradio[mcp]
textblob`,wrap:!1}}),lt=new b({props:{code:"Z2l0JTIwaW5pdCUwQWdpdCUyMGFkZCUyMHNlcnZlci5weSUyMHJlcXVpcmVtZW50cy50eHQlMEFnaXQlMjBjb21taXQlMjAtbSUyMCUyMkluaXRpYWwlMjBjb21taXQlMjIlMEFnaXQlMjByZW1vdGUlMjBhZGQlMjBvcmlnaW4lMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3BhY2VzJTJGWU9VUl9VU0VSTkFNRSUyRm1jcC1zZW50aW1lbnQlMEFnaXQlMjBwdXNoJTIwLXUlMjBvcmlnaW4lMjBtYWlu",highlighted:`git init
git add server.py requirements.txt
git commit -m <span class="hljs-string">&quot;Initial commit&quot;</span>
git remote add origin https://huggingface.co/spaces/YOUR_USERNAME/mcp-sentiment
git push -u origin main`,wrap:!1}}),st=new b({props:{code:"aHR0cHMlM0ElMkYlMkZZT1VSX1VTRVJOQU1FLW1jcC1zZW50aW1lbnQuaGYuc3BhY2UlMkZncmFkaW9fYXBpJTJGbWNwJTJGc3Nl",highlighted:'https:<span class="hljs-regexp">//</span>YOUR_USERNAME-mcp-sentiment.hf.space<span class="hljs-regexp">/gradio_api/m</span>cp/sse',wrap:!1}}),it=new U({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),rt=new hl({props:{source:"https://github.com/huggingface/mcp-course/blob/main/units/en/unit2/gradio-server.mdx"}}),{c(){w=a("meta"),It=s(),Jt=a("p"),$t=s(),u(v.$$.fragment),xt=s(),I=a("p"),I.textContent=_e,St=s(),u($.$$.fragment),Bt=s(),x=a("p"),x.innerHTML=Ze,Ht=s(),S=a("ol"),S.innerHTML=We,_t=s(),u(B.$$.fragment),Zt=s(),H=a("p"),H.textContent=Ge,Wt=s(),u(_.$$.fragment),Gt=s(),u(Z.$$.fragment),Rt=s(),W=a("p"),W.innerHTML=Re,At=s(),u(G.$$.fragment),Et=s(),u(R.$$.fragment),Lt=s(),A=a("p"),A.textContent=Ae,Vt=s(),T=a("ol"),ut=a("li"),ut.innerHTML=Ee,ye=s(),Mt=a("li"),Mt.innerHTML=Le,de=s(),E=a("li"),ct=a("p"),ct.innerHTML=Ve,Te=s(),C=a("ul"),ht=a("li"),ht.innerHTML=ke,ge=s(),mt=a("li"),mt.innerHTML=Qe,Ue=s(),yt=a("li"),we=xe(`You can also enable it using the environment variable:
	`),u(L.$$.fragment),kt=s(),u(V.$$.fragment),Qt=s(),k=a("p"),k.textContent=Pe,Pt=s(),u(Q.$$.fragment),qt=s(),P=a("p"),P.innerHTML=qe,Nt=s(),u(q.$$.fragment),Xt=s(),N=a("p"),N.textContent=Ne,Yt=s(),X=a("ol"),X.innerHTML=Xe,zt=s(),u(Y.$$.fragment),Ft=s(),d=a("ol"),dt=a("li"),dt.innerHTML=Ye,Ce=s(),Tt=a("li"),Tt.innerHTML=ze,je=s(),z=a("li"),gt=a("p"),gt.innerHTML=Fe,fe=s(),F=a("ul"),Ut=a("li"),Ut.textContent=Oe,Je=s(),j=a("li"),be=xe("In those cases, use "),wt=a("code"),wt.textContent=De,ve=xe(`:
	`),u(O.$$.fragment),Ie=s(),Ct=a("li"),Ct.innerHTML=Ke,Ot=s(),u(D.$$.fragment),Dt=s(),K=a("p"),K.textContent=tl,Kt=s(),tt=a("ol"),tt.innerHTML=el,te=s(),u(et.$$.fragment),ee=s(),f=a("ol"),f.innerHTML=ll,le=s(),u(lt.$$.fragment),ne=s(),nt=a("p"),nt.textContent=nl,se=s(),u(st.$$.fragment),ie=s(),u(it.$$.fragment),ae=s(),at=a("p"),at.textContent=sl,oe=s(),ot=a("ol"),ot.innerHTML=il,pe=s(),pt=a("p"),pt.textContent=al,re=s(),u(rt.$$.fragment),ue=s(),bt=a("p"),this.h()},l(t){const e=cl("svelte-u9bgzb",document.head);w=o(e,"META",{name:!0,content:!0}),e.forEach(l),It=i(t),Jt=o(t,"P",{}),g(Jt).forEach(l),$t=i(t),M(v.$$.fragment,t),xt=i(t),I=o(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-15g2s94"&&(I.textContent=_e),St=i(t),M($.$$.fragment,t),Bt=i(t),x=o(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1yi0ix"&&(x.innerHTML=Ze),Ht=i(t),S=o(t,"OL",{"data-svelte-h":!0}),r(S)!=="svelte-g4mq16"&&(S.innerHTML=We),_t=i(t),M(B.$$.fragment,t),Zt=i(t),H=o(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-mmri3o"&&(H.textContent=Ge),Wt=i(t),M(_.$$.fragment,t),Gt=i(t),M(Z.$$.fragment,t),Rt=i(t),W=o(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-wsv55y"&&(W.innerHTML=Re),At=i(t),M(G.$$.fragment,t),Et=i(t),M(R.$$.fragment,t),Lt=i(t),A=o(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-ccttqs"&&(A.textContent=Ae),Vt=i(t),T=o(t,"OL",{});var jt=g(T);ut=o(jt,"LI",{"data-svelte-h":!0}),r(ut)!=="svelte-1r6ud1j"&&(ut.innerHTML=Ee),ye=i(jt),Mt=o(jt,"LI",{"data-svelte-h":!0}),r(Mt)!=="svelte-1zxric"&&(Mt.innerHTML=Le),de=i(jt),E=o(jt,"LI",{});var ce=g(E);ct=o(ce,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-9494xm"&&(ct.innerHTML=Ve),Te=i(ce),C=o(ce,"UL",{});var ft=g(C);ht=o(ft,"LI",{"data-svelte-h":!0}),r(ht)!=="svelte-1habxzw"&&(ht.innerHTML=ke),ge=i(ft),mt=o(ft,"LI",{"data-svelte-h":!0}),r(mt)!=="svelte-hwrhz1"&&(mt.innerHTML=Qe),Ue=i(ft),yt=o(ft,"LI",{});var $e=g(yt);we=Se($e,`You can also enable it using the environment variable:
	`),M(L.$$.fragment,$e),$e.forEach(l),ft.forEach(l),ce.forEach(l),jt.forEach(l),kt=i(t),M(V.$$.fragment,t),Qt=i(t),k=o(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-tq7guq"&&(k.textContent=Pe),Pt=i(t),M(Q.$$.fragment,t),qt=i(t),P=o(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-16j4roj"&&(P.innerHTML=qe),Nt=i(t),M(q.$$.fragment,t),Xt=i(t),N=o(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1hexqja"&&(N.textContent=Ne),Yt=i(t),X=o(t,"OL",{"data-svelte-h":!0}),r(X)!=="svelte-1prsps9"&&(X.innerHTML=Xe),zt=i(t),M(Y.$$.fragment,t),Ft=i(t),d=o(t,"OL",{});var J=g(d);dt=o(J,"LI",{"data-svelte-h":!0}),r(dt)!=="svelte-1kjwfqe"&&(dt.innerHTML=Ye),Ce=i(J),Tt=o(J,"LI",{"data-svelte-h":!0}),r(Tt)!=="svelte-mxigd7"&&(Tt.innerHTML=ze),je=i(J),z=o(J,"LI",{});var he=g(z);gt=o(he,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-pauept"&&(gt.innerHTML=Fe),fe=i(he),F=o(he,"UL",{});var me=g(F);Ut=o(me,"LI",{"data-svelte-h":!0}),r(Ut)!=="svelte-18matxo"&&(Ut.textContent=Oe),Je=i(me),j=o(me,"LI",{});var vt=g(j);be=Se(vt,"In those cases, use "),wt=o(vt,"CODE",{"data-svelte-h":!0}),r(wt)!=="svelte-32a5p1"&&(wt.textContent=De),ve=Se(vt,`:
	`),M(O.$$.fragment,vt),vt.forEach(l),me.forEach(l),he.forEach(l),Ie=i(J),Ct=o(J,"LI",{"data-svelte-h":!0}),r(Ct)!=="svelte-46q023"&&(Ct.innerHTML=Ke),J.forEach(l),Ot=i(t),M(D.$$.fragment,t),Dt=i(t),K=o(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1itkhgv"&&(K.textContent=tl),Kt=i(t),tt=o(t,"OL",{"data-svelte-h":!0}),r(tt)!=="svelte-1thxdu2"&&(tt.innerHTML=el),te=i(t),M(et.$$.fragment,t),ee=i(t),f=o(t,"OL",{start:!0,"data-svelte-h":!0}),r(f)!=="svelte-ok99j"&&(f.innerHTML=ll),le=i(t),M(lt.$$.fragment,t),ne=i(t),nt=o(t,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-rjtj0p"&&(nt.textContent=nl),se=i(t),M(st.$$.fragment,t),ie=i(t),M(it.$$.fragment,t),ae=i(t),at=o(t,"P",{"data-svelte-h":!0}),r(at)!=="svelte-p1bgao"&&(at.textContent=sl),oe=i(t),ot=o(t,"OL",{"data-svelte-h":!0}),r(ot)!=="svelte-6w66tp"&&(ot.innerHTML=il),pe=i(t),pt=o(t,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-19wsvhm"&&(pt.textContent=al),re=i(t),M(rt.$$.fragment,t),ue=i(t),bt=o(t,"P",{}),g(bt).forEach(l),this.h()},h(){Be(w,"name","hf:doc:metadata"),Be(w,"content",yl),Be(f,"start","3")},m(t,e){p(document.head,w),n(t,It,e),n(t,Jt,e),n(t,$t,e),c(v,t,e),n(t,xt,e),n(t,I,e),n(t,St,e),c($,t,e),n(t,Bt,e),n(t,x,e),n(t,Ht,e),n(t,S,e),n(t,_t,e),c(B,t,e),n(t,Zt,e),n(t,H,e),n(t,Wt,e),c(_,t,e),n(t,Gt,e),c(Z,t,e),n(t,Rt,e),n(t,W,e),n(t,At,e),c(G,t,e),n(t,Et,e),c(R,t,e),n(t,Lt,e),n(t,A,e),n(t,Vt,e),n(t,T,e),p(T,ut),p(T,ye),p(T,Mt),p(T,de),p(T,E),p(E,ct),p(E,Te),p(E,C),p(C,ht),p(C,ge),p(C,mt),p(C,Ue),p(C,yt),p(yt,we),c(L,yt,null),n(t,kt,e),c(V,t,e),n(t,Qt,e),n(t,k,e),n(t,Pt,e),c(Q,t,e),n(t,qt,e),n(t,P,e),n(t,Nt,e),c(q,t,e),n(t,Xt,e),n(t,N,e),n(t,Yt,e),n(t,X,e),n(t,zt,e),c(Y,t,e),n(t,Ft,e),n(t,d,e),p(d,dt),p(d,Ce),p(d,Tt),p(d,je),p(d,z),p(z,gt),p(z,fe),p(z,F),p(F,Ut),p(F,Je),p(F,j),p(j,be),p(j,wt),p(j,ve),c(O,j,null),p(d,Ie),p(d,Ct),n(t,Ot,e),c(D,t,e),n(t,Dt,e),n(t,K,e),n(t,Kt,e),n(t,tt,e),n(t,te,e),c(et,t,e),n(t,ee,e),n(t,f,e),n(t,le,e),c(lt,t,e),n(t,ne,e),n(t,nt,e),n(t,se,e),c(st,t,e),n(t,ie,e),c(it,t,e),n(t,ae,e),n(t,at,e),n(t,oe,e),n(t,ot,e),n(t,pe,e),n(t,pt,e),n(t,re,e),c(rt,t,e),n(t,ue,e),n(t,bt,e),Me=!0},p:pl,i(t){Me||(h(v.$$.fragment,t),h($.$$.fragment,t),h(B.$$.fragment,t),h(_.$$.fragment,t),h(Z.$$.fragment,t),h(G.$$.fragment,t),h(R.$$.fragment,t),h(L.$$.fragment,t),h(V.$$.fragment,t),h(Q.$$.fragment,t),h(q.$$.fragment,t),h(Y.$$.fragment,t),h(O.$$.fragment,t),h(D.$$.fragment,t),h(et.$$.fragment,t),h(lt.$$.fragment,t),h(st.$$.fragment,t),h(it.$$.fragment,t),h(rt.$$.fragment,t),Me=!0)},o(t){m(v.$$.fragment,t),m($.$$.fragment,t),m(B.$$.fragment,t),m(_.$$.fragment,t),m(Z.$$.fragment,t),m(G.$$.fragment,t),m(R.$$.fragment,t),m(L.$$.fragment,t),m(V.$$.fragment,t),m(Q.$$.fragment,t),m(q.$$.fragment,t),m(Y.$$.fragment,t),m(O.$$.fragment,t),m(D.$$.fragment,t),m(et.$$.fragment,t),m(lt.$$.fragment,t),m(st.$$.fragment,t),m(it.$$.fragment,t),m(rt.$$.fragment,t),Me=!1},d(t){t&&(l(It),l(Jt),l($t),l(xt),l(I),l(St),l(Bt),l(x),l(Ht),l(S),l(_t),l(Zt),l(H),l(Wt),l(Gt),l(Rt),l(W),l(At),l(Et),l(Lt),l(A),l(Vt),l(T),l(kt),l(Qt),l(k),l(Pt),l(qt),l(P),l(Nt),l(Xt),l(N),l(Yt),l(X),l(zt),l(Ft),l(d),l(Ot),l(Dt),l(K),l(Kt),l(tt),l(te),l(ee),l(f),l(le),l(ne),l(nt),l(se),l(ie),l(ae),l(at),l(oe),l(ot),l(pe),l(pt),l(re),l(ue),l(bt)),l(w),y(v,t),y($,t),y(B,t),y(_,t),y(Z,t),y(G,t),y(R,t),y(L),y(V,t),y(Q,t),y(q,t),y(Y,t),y(O),y(D,t),y(et,t),y(lt,t),y(st,t),y(it,t),y(rt,t)}}}const yl='{"title":"Building the Gradio MCP Server","local":"building-the-gradio-mcp-server","sections":[{"title":"Introduction to Gradio MCP Integration","local":"introduction-to-gradio-mcp-integration","sections":[],"depth":2},{"title":"Setting Up the Project","local":"setting-up-the-project","sections":[],"depth":2},{"title":"Creating the Server","local":"creating-the-server","sections":[],"depth":2},{"title":"Understanding the Code","local":"understanding-the-code","sections":[],"depth":2},{"title":"Running the Server","local":"running-the-server","sections":[],"depth":2},{"title":"Testing the Server","local":"testing-the-server","sections":[],"depth":2},{"title":"Troubleshooting Tips","local":"troubleshooting-tips","sections":[],"depth":2},{"title":"Deploying to Hugging Face Spaces","local":"deploying-to-hugging-face-spaces","sections":[],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function dl(He){return rl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Cl extends ul{constructor(w){super(),Ml(this,w,dl,ml,ol,{})}}export{Cl as component};
