import{s as $s,f as F,n as ei,o as ti}from"../chunks/scheduler.048ce5c2.js";import{S as Ai,i as li,g as s,s as a,r as p,A as ai,h as i,f as A,c as n,j as _s,u as r,x as o,k as m,y as ni,a as l,v as u,d,t as f,w as U}from"../chunks/index.2633050f.js";import{C as j}from"../chunks/CodeBlock.b34ffc90.js";import{D as si}from"../chunks/DocNotebookDropdown.2a84b269.js";import{H as c,E as ii}from"../chunks/EditOnGithub.336973dd.js";function oi(nn){let w,dA,rA,fA,b,UA,R,jA,g,sn='<img src="https://github.com/huggingface/diffusers/raw/main/docs/source/en/imgs/diffusers_library.jpg" alt="diffusers_library"/>',cA,K,on="In this notebook, you’ll train your first diffusion model to <strong>generate images of cute butterflies 🦋.</strong> Along the way, you’ll learn about the core components of the 🤗 Diffusers library, which will provide a good foundation for the more advanced applications that we’ll cover later in the course.",mA,h,pn="Let’s dive in!",wA,M,FA,I,rn="In this notebook you will:",bA,B,un="<li>See a powerful custom diffusion model pipeline in action (with information on how to make your own version)</li> <li>Create your own mini pipeline by:<ul><li>Recapping the core ideas behind diffusion models</li> <li>Loading in data from the Hub for training</li> <li>Exploring how we add noise to this data with a scheduler</li> <li>Creating and training the UNet model</li> <li>Putting the pieces together into a working pipeline</li></ul></li> <li>Edit and run a script for initializing longer training runs, that will handle<ul><li>Multi-GPU training via 🤗 Accelerate</li> <li>Experiment logging to track critical stats</li> <li>Uploading the final model to the Hugging Face Hub</li></ul></li>",RA,y,dn='❓If you have any questions, please post them on the <code>#diffusion-models-class</code> channel on the Hugging Face Discord server. If you haven’t signed up yet, you can do so here: <a href="https://huggingface.co/join/discord" rel="nofollow">https://huggingface.co/join/discord</a>',gA,X,KA,H,fn="Before diving into the notebook, you should:",hA,P,Un='<li>📖 Read the Unit 1 materials</li> <li>🤗 Create an account on the Hugging Face Hub. If you haven’t done so yet, you can do so here: <a href="https://huggingface.co/join" rel="nofollow">https://huggingface.co/join</a></li>',MA,T,IA,C,jn="Run the following cell to install the diffusers library as well as a few other requirements:",BA,x,yA,J,cn='Next, head over to <a href="https://huggingface.co/settings/tokens" rel="nofollow">https://huggingface.co/settings/tokens</a> and create an access token with write permission if you don’t already have one:',XA,z,mn='<img src="data:image/png;base64,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" alt="Screenshot from 2022-11-10 12-23-34.png"/>',HA,k,wn="You can login with this token using the command line (<code>huggingface-cli login</code>) or by running the following cell:",PA,Q,TA,S,Fn=`Login successful
Your token has been saved to /root/.huggingface/token
`,CA,v,bn="Then you need to install Git-LFS to upload your model checkpoints:",xA,V,JA,Z,Rn="Finally, let’s import the libraries we’ll be using and define a few convenience functions which we’ll use later in the notebook:",zA,G,kA,W,gn="OK, we’re all set!",QA,N,SA,D,Kn="If you’ve looked at AI-related social media at all in the past few months, you’ve heard about Stable Diffusion. It’s a powerful text-conditioned latent diffusion model (don’t worry, we’ll learn what all that means). But it has a flaw: it doesn’t know what you or I look like unless we’re famous enough to have our images plastered around the internet.",vA,O,hn="Dreambooth let’s us create our own model variant with some extra knowledge of a specific face, object or style. The Corridor Crew made an excellent video using this to tell stories with consistent characters, which is a great example of what this technique can do:",VA,q,ZA,tA,Mn,GA,Y,In='Here’s an example using <a href="https://huggingface.co/sd-dreambooth-library/mr-potato-head" rel="nofollow">a model</a> trained on 5 photos of a popular children’s toy called “Mr Potato Head”.',WA,E,Bn="First, we load the pipeline. This will download model weights etc. from the Hub. Since this will download several gigabytes of data for a one-line demo, you are welcome to skip this cell and simply admire the example output!",NA,L,DA,_,yn="Once the pipeline has finished loading, we can generate images with:",OA,$,qA,AA,Xn,YA,ee,Hn="<strong>Exercise:</strong> Try it yourself with different prompts. The <code>sks</code> token represents a unique identifier for the novel concept in this case - what happens if you leave that out? You can also experiment with changing the number of sampling steps (how low can you go?) and the <code>guidance_scale</code>, which determines how much the model will try to match the prompt.",EA,te,Pn="There’s a lot going on in that magical pipeline! By the end of the course you’ll know how it all works. For now, let’s take a look at how we can train a diffusion model from scratch.",LA,Ae,_A,le,Tn="The core API of 🤗 Diffusers is divided into three main components:",$A,ae,Cn='<li><strong>Pipelines</strong>: high-level classes designed to rapidly generate samples from popular trained diffusion models in a user-friendly fashion.</li> <li><strong>Models</strong>: popular architectures for training new diffusion models, <em>e.g.</em> <a href="https://arxiv.org/abs/1505.04597" rel="nofollow">UNet</a>.</li> <li><strong>Schedulers</strong>: various techniques for generating images from noise during <em>inference</em> as well as to generate noisy images for <em>training</em>.</li>',el,ne,xn="Pipelines are great for end-users, but if you’re here for this course we assume you want to know what is going on under the hood! So, over the rest of this notebook we’re going to build our own pipeline capable of generating small butterfly pictures. Here’s the final result in action:",tl,se,Al,lA,Jn,ll,ie,zn="Not as impressive as the DreamBooth example perhaps, but then we’re training from scratch with ~0.0001% of the data used to train Stable Diffusion. Speaking of training, recall from the introduction to this unit that training a diffusion model looks something like this:",al,oe,kn="<li>Load in some images from the training data</li> <li>Add noise, in different amounts.</li> <li>Feed the noisy versions of the inputs into the model</li> <li>Evaluate how well the model does at denoising these inputs</li> <li>Use this information to update the model weights, and repeat</li>",nl,pe,Qn="We’ll explore these steps one by one in the next few sections until we have a complete training loop working, and then we’ll explore how to sample from the trained model and how to package everything up into a pipeline for easy sharing. Let’s begin with the data…",sl,re,il,ue,Sn='For this example, we’ll use a dataset of images from the Hugging Face Hub. Specifically, <a href="https://huggingface.co/datasets/huggan/smithsonian_butterflies_subset" rel="nofollow">this collection of 1000 butterfly pictures</a>. This is a very small dataset, so we’ve also included commented out lines for a few larger options. If you’d prefer to use your own collection of images, you can also use the commented-out code example to load in pictures from a folder instead.',ol,de,pl,fe,vn="We can grab a batch of images and view some of them like so:",rl,Ue,ul,je,Vn=`X shape: torch.Size([8, 3, 32, 32])
`,dl,ce,Zn="We’re sticking to a small dataset with 32 pixel images to keep training times manageable in this notebook.",fl,me,Ul,we,Gn="Our plan for training is to take these input images and add noise to them, then feed the noisy images to the model. And during inference, we will use the model predictions to iteratively remove noise. In <code>diffusers</code>,  these processes are both handled by the <strong>scheduler</strong>.",jl,Fe,Wn='The noise schedule determines how much noise is added at different timesteps. Here’s how we might create a scheduler using the default settings for ‘DDPM’ training and sampling (based on the paper <a href="https://arxiv.org/abs/2006.11239" rel="nofollow">“Denoising Diffusion Probabilistic Models”</a>):',cl,be,ml,Re,Nn="The DDPM paper describes a corruption process that adds a small amount of noise for every ‘timestep’. Given $x_{t-1}$ for some timestep, we can get the next (slightly more noisy) version $x_t$ with:<br/><br/>",wl,ge,Dn=`$q(\\mathbf{x}<em>t \\vert \\mathbf{x}</em>{t-1}) = \\mathcal{N}(\\mathbf{x}<em>t; \\sqrt{1 - \\beta_t} \\mathbf{x}</em>{t-1}, \\beta<em>t\\mathbf{I}) \\quad
q(\\mathbf{x}</em>{1:T} \\vert \\mathbf{x}<em>0) = \\prod^T</em>{t=1} q(\\mathbf{x}<em>t \\vert \\mathbf{x}</em>{t-1})$<br/><br/>`,Fl,Ke,On="That is, we take $x<em>{t-1}$, scale it by $\\sqrt{1 - \\beta_t}$ and add noise scaled by $\\beta_t$. This $\\beta$ is defined for every t according to some schedule, and determines how much noise is added per timestep. Now, we don’t necessarily want to do this operation 500 times to get $x</em>{500}$ so we have another formula to get $x_t$ for any t given $x_0$: <br/><br/>",bl,he,qn=`$\\begin{aligned}
q(\\mathbf{x}<em>t \\vert \\mathbf{x}_0) &amp;= \\mathcal{N}(\\mathbf{x}_t; \\sqrt{\\bar{\\alpha}_t} \\mathbf{x}_0, {(1 - \\bar{\\alpha}_t)} \\mathbf{I})
\\end{aligned}$ where $\\bar{\\alpha}_t = \\prod</em>{i=1}^T \\alpha_i$ and $\\alpha_i = 1-\\beta_i$<br/><br/>`,Rl,Me,Yn="The maths notation always looks scary! Luckily the scheduler handles all that for us. We can plot $\\sqrt{\\bar{\\alpha}_t}$ (labelled as <code>sqrt_alpha_prod</code>) and $\\sqrt{(1 - \\bar{\\alpha}_t)}$ (labelled as <code>sqrt_one_minus_alpha_prod</code>) to view how the input (x) and the noise are scaled and mixed across different timesteps:",gl,Ie,Kl,aA,En,hl,Be,Ln="<strong>Exercise:</strong> You can explore how this plot changes with different settings for beta_start, beta_end and beta_schedule by swapping in one of the commented-out options here:",Ml,ye,Il,Xe,_n="Whichever scheduler you’ve chosen, we can now use it to add noise in different amounts using the <code>noise_scheduler.add_noise</code> function like so:",Bl,He,yl,Pe,$n=`Noisy X shape torch.Size([8, 3, 32, 32])
`,Xl,Te,es='Again, explore the effect of using different noise schedules and parameters here. <a href="https://www.youtube.com/watch?v=fbLgFrlTnGU" rel="nofollow">This video</a> does a great job explaining some of the maths above in more detail, and is a great introduction to some of these concepts.',Hl,Ce,Pl,xe,ts="Now we come to the core component: the model itself.",Tl,Je,As='Most diffusion models use architectures that are some variant of a <a href="https://arxiv.org/abs/1505.04597" rel="nofollow">U-net</a> and that’s what we’ll use here.',Cl,ze,ls='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/unet-model.png"/>',xl,ke,as="In a nutshell:",Jl,Qe,ns="<li>the model has the input image go through several blocks of ResNet layers, each of which halves the image size by 2</li> <li>then through the same number of blocks that upsample it again.</li> <li>there are skip connections linking the features on the downsample path to the corresponding layers in the upsample path.</li>",zl,Se,ss="A key feature of this model is that it predicts images of the same size as the input, which is exactly what we need here.",kl,ve,is="Diffusers provides us a handy <code>UNet2DModel</code> class which creates the desired architecture in PyTorch.",Ql,Ve,os=`Let’s create a U-net for our desired image size.
Note that <code>down_block_types</code> correspond to the downsampling blocks (green on the diagram above), and <code>up_block_types</code> are the upsampling blocks (red on the diagram):`,Sl,Ze,vl,Ge,ps="When dealing with higher-resolution inputs you may want to use more down and up-blocks, and keep the attention layers only at the lowest resolution (bottom) layers to reduce memory usage. We’ll talk later about how you might experiment to find the best settings for your use-case.",Vl,We,rs="We can check that passing in a batch of data and some random timesteps produces an output the same shape as the input data:",Zl,Ne,Gl,De,us="In the next section we’ll see how to train this model.",Wl,Oe,Nl,qe,ds="Time to train! Below is a typical optimization loop in PyTorch, where we run through the data batch by batch and update the parameters of our model each step using an optimizer - in this case the AdamW optimizer with a learning rate of 0.0004.",Dl,Ye,fs="For each batch of data, we",Ol,Ee,Us="<li>Sample some random timesteps</li> <li>Noise the data accordingly</li> <li>Feed the noisy data through the model</li> <li>Compare the model predictions with the target (i.e. the noise in this case) using mean squared error as our loss function</li> <li>Update the model parameters via <code>loss.backward()</code> and <code>optimizer.step()</code></li>",ql,Le,js="During this process we also log the losses over time for later plotting.",Yl,_e,cs="NB: This code takes nearly 10 minutes to run - feel free to skip these two cells and use the pretrained model if you are in a hurry. Alternatively, you can explore how reducing the number of channels in each layer via the model definition above can speed things up.",El,$e,ms='The <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers/training_example.ipynb" rel="nofollow">official diffusers training example</a> trains a larger model on this dataset at higher resolution, and is a good reference for what a less minimal training loop looks like:',Ll,et,_l,tt,ws=`Epoch:5, loss: 0.16273280512541533
Epoch:10, loss: 0.11161588924005628
Epoch:15, loss: 0.10206522420048714
Epoch:20, loss: 0.08302505919709802
Epoch:25, loss: 0.07805309211835265
Epoch:30, loss: 0.07474562455900013
`,$l,At,Fs="Plotting the loss, we see that the model rapidly improves initially and then continues to get better at a slower rate (which is more obvious if we use a log scale as shown on the right):",ea,lt,ta,nA,bs,Aa,at,Rs="As an alternative to running the training code above, you can use the model from the pipeline like so:",la,nt,aa,st,na,it,gs="How do we get images with this model?",sa,ot,ia,pt,oa,rt,pa,sA,Ks,ra,ut,hs="We can save a pipeline to a local folder like so:",ua,dt,da,ft,Ms="Inspecting the folder contents:",fa,Ut,Ua,jt,Is=`model_index.json  scheduler  unet
`,ja,ct,Bs="The <code>scheduler</code> and <code>unet</code> subfolders contain everything needed to re-create those components. For example, inside the <code>unet</code> folder you’ll find the model weights (<code>diffusion_pytorch_model.bin</code>) alongside a config file which specifies the UNet architecture.",ca,mt,ma,wt,ys=`config.json  diffusion_pytorch_model.bin
`,wa,Ft,Xs="Together, these files contain everything needed to recreate the pipeline. You can manually upload them to the hub to share the pipeline with others, or check out the code to do this via the API in the next section.",Fa,bt,ba,Rt,Hs="If you inspect the forward method of the pipeline you’ll be able to see what is happening when we run <code>image_pipe()</code>:",Ra,gt,ga,Kt,Ps="We begin with random noise, and run through the scheduler timesteps from most to least noisy, removing a small amount of noise each step based on the model prediction:",Ka,ht,ha,iA,Ts,Ma,Mt,Cs="The <code>noise_scheduler.step()</code> function does the maths required to update <code>sample</code> appropriately. There are a number of sampling methods - in the next unit we’ll see how we can swap in a different sampler to speed up image generation with existing models, and talk more about the theory behind sampling from diffusion models.",Ia,It,Ba,Bt,xs="In the example above we saved our pipeline to a local folder. To push our model to the Hub, we will need to model repository to push our files to. We’ll determine the repository name from the model ID we want to give our model (feel free to replace the <code>model_name</code> with your own choice; it just needs to contain your username, which is what the function <code>get_full_repo_name()</code> does):",ya,yt,Xa,Xt,Js="Next, create a model repository on the 🤗 Hub and push our model:",Ha,Ht,Pa,Pt,zs="The last thing to do is create a nice model card so that our butterfly generator can easily be found on the Hub (feel free to expand and edit the description!):",Ta,Tt,Ca,Ct,ks='"""',xa,xt,Qs=`card = ModelCard(content)
card.push_to_hub(hub_model_id)`,Ja,Jt,za,oA,Ss,ka,zt,vs="Great it works!",Qa,kt,Sa,Qt,Vs='This notebook was made for learning purposes, and as such I tried to keep the code as minimal and clean as possible. Because of this, we omitted some of the things you might want if you were to try training a larger model on much more data, such as multi-GPU support, logging of progress and example images, gradient checkpointing to support larger batch sizes, automatic uploading of models and so on. Thankfully most of these features are available in the example training script <a href="https://github.com/huggingface/diffusers/raw/main/examples/unconditional_image_generation/train_unconditional.py" rel="nofollow">here</a>.',va,St,Zs="You can download the file like so:",Va,vt,Za,Vt,Gs="Open up the file and you’ll see where the model is defined and what settings are available. I ran the script with the following command:",Ga,Zt,Wa,Gt,Na,Wt,Ws="As before, let’s push the model to the Hub and create a nice model card (and feel free to edit it as you wish!):",Da,Nt,Oa,Dt,Ns='"""',qa,Ot,Ds=`card = ModelCard(content)
card.push_to_hub(hub_model_id)`,Ya,qt,Ea,pA,Os,La,Yt,qs="<strong>Exercise:</strong> See if you can find training/model settings that give good results in as little time as possible, and share your findings with the community. Dig around in the script to see if you can understand the code, and ask for clarification on anything that looks confusing.",_a,Et,$a,Lt,Ys="Hopefully this has given you a taste of what you can do with the 🤗 Diffusers library! Some possible next steps:",en,_t,Es='<li>Try training an unconditional diffusion model on a new dataset - bonus points if you <a href="https://huggingface.co/docs/datasets/image_dataset" rel="nofollow">create one yourself</a>. You can find some great image datasets for this task in the <a href="https://huggingface.co/huggan" rel="nofollow">HugGan organization</a> on the Hub. Just make sure you downsample them if you don’t want to wait a very long time for the model to train!</li> <li>Try out DreamBooth to create your own customized Stable Diffusion pipeline using either <a href="https://huggingface.co/spaces/multimodalart/dreambooth-training" rel="nofollow">this Space</a> or <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers/sd_dreambooth_training.ipynb" rel="nofollow">this notebook</a></li> <li>Modify the training script to explore different UNet hyperparameters (number of layers, channels etc), different noise schedules etc.</li> <li>Check out the <a href="https://github.com/huggingface/diffusion-models-class/blob/main/unit1/02_diffusion_models_from_scratch.ipynb" rel="nofollow">Diffusion Models from Scratch</a> notebook for a different take on the core ideas we’ve covered in this unit</li>',tn,$t,Ls="Good luck, and stay tuned for Unit 2!",An,eA,ln,uA,an;return b=new si({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/diffusion-models-class/blob/unit3/implement_img2img_inpaint/unit1/01_introduction_to_diffusers.ipynb"}]}}),R=new c({props:{title:"Introduction to 🤗 Diffusers",local:"introduction-to--diffusers",headingTag:"h1"}}),M=new c({props:{title:"What You Will Learn",local:"what-you-will-learn",headingTag:"h2"}}),X=new c({props:{title:"Prerequisites",local:"prerequisites",headingTag:"h2"}}),T=new c({props:{title:"Step 1: Setup",local:"step-1-setup",headingTag:"h2"}}),x=new j({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMC1xcSUyMC1VJTIwZGlmZnVzZXJzJTIwZGF0YXNldHMlMjB0cmFuc2Zvcm1lcnMlMjBhY2NlbGVyYXRlJTIwZnRmeSUyMHB5YXJyb3clM0QlM0Q5LjAuMA==",highlighted:'%pip install -qq -U diffusers datasets transformers accelerate ftfy pyarrow==<span class="hljs-number">9.0</span><span class="hljs-number">.0</span>',wrap:!1}}),Q=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),V=new j({props:{code:"JTI1JTI1Y2FwdHVyZSUwQSFzdWRvJTIwYXB0JTIwLXFxJTIwaW5zdGFsbCUyMGdpdC1sZnMlMEEhZ2l0JTIwY29uZmlnJTIwLS1nbG9iYWwlMjBjcmVkZW50aWFsLmhlbHBlciUyMHN0b3Jl",highlighted:`%%capture
!sudo apt -qq install git-lfs
!git config --<span class="hljs-keyword">global</span> credential.helper store`,wrap:!1}}),G=new j({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubi5mdW5jdGlvbmFsJTIwYXMlMjBGJTBBZnJvbSUyMG1hdHBsb3RsaWIlMjBpbXBvcnQlMjBweXBsb3QlMjBhcyUyMHBsdCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQSUwQSUwQWRlZiUyMHNob3dfaW1hZ2VzKHgpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyR2l2ZW4lMjBhJTIwYmF0Y2glMjBvZiUyMGltYWdlcyUyMHglMkMlMjBtYWtlJTIwYSUyMGdyaWQlMjBhbmQlMjBjb252ZXJ0JTIwdG8lMjBQSUwlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjB4JTIwJTNEJTIweCUyMColMjAwLjUlMjAlMkIlMjAwLjUlMjAlMjAlMjMlMjBNYXAlMjBmcm9tJTIwKC0xJTJDJTIwMSklMjBiYWNrJTIwdG8lMjAoMCUyQyUyMDEpJTBBJTIwJTIwJTIwJTIwZ3JpZCUyMCUzRCUyMHRvcmNodmlzaW9uLnV0aWxzLm1ha2VfZ3JpZCh4KSUwQSUyMCUyMCUyMCUyMGdyaWRfaW0lMjAlM0QlMjBncmlkLmRldGFjaCgpLmNwdSgpLnBlcm11dGUoMSUyQyUyMDIlMkMlMjAwKS5jbGlwKDAlMkMlMjAxKSUyMColMjAyNTUlMEElMjAlMjAlMjAlMjBncmlkX2ltJTIwJTNEJTIwSW1hZ2UuZnJvbWFycmF5KG5wLmFycmF5KGdyaWRfaW0pLmFzdHlwZShucC51aW50OCkpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZ3JpZF9pbSUwQSUwQSUwQWRlZiUyMG1ha2VfZ3JpZChpbWFnZXMlMkMlMjBzaXplJTNENjQpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyR2l2ZW4lMjBhJTIwbGlzdCUyMG9mJTIwUElMJTIwaW1hZ2VzJTJDJTIwc3RhY2slMjB0aGVtJTIwdG9nZXRoZXIlMjBpbnRvJTIwYSUyMGxpbmUlMjBmb3IlMjBlYXN5JTIwdmlld2luZyUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMG91dHB1dF9pbSUyMCUzRCUyMEltYWdlLm5ldyglMjJSR0IlMjIlMkMlMjAoc2l6ZSUyMColMjBsZW4oaW1hZ2VzKSUyQyUyMHNpemUpKSUwQSUyMCUyMCUyMCUyMGZvciUyMGklMkMlMjBpbSUyMGluJTIwZW51bWVyYXRlKGltYWdlcyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRfaW0ucGFzdGUoaW0ucmVzaXplKChzaXplJTJDJTIwc2l6ZSkpJTJDJTIwKGklMjAqJTIwc2l6ZSUyQyUyMDApKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dF9pbSUwQSUwQSUwQSUyMyUyME1hYyUyMHVzZXJzJTIwbWF5JTIwbmVlZCUyMGRldmljZSUyMCUzRCUyMCdtcHMnJTIwKHVudGVzdGVkKSUwQWRldmljZSUyMCUzRCUyMHRvcmNoLmRldmljZSglMjJjdWRhJTIyJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCUyMmNwdSUyMik=",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F
<span class="hljs-keyword">from</span> matplotlib <span class="hljs-keyword">import</span> pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image


<span class="hljs-keyword">def</span> <span class="hljs-title function_">show_images</span>(<span class="hljs-params">x</span>):
    <span class="hljs-string">&quot;&quot;&quot;Given a batch of images x, make a grid and convert to PIL&quot;&quot;&quot;</span>
    x = x * <span class="hljs-number">0.5</span> + <span class="hljs-number">0.5</span>  <span class="hljs-comment"># Map from (-1, 1) back to (0, 1)</span>
    grid = torchvision.utils.make_grid(x)
    grid_im = grid.detach().cpu().permute(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>).clip(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>) * <span class="hljs-number">255</span>
    grid_im = Image.fromarray(np.array(grid_im).astype(np.uint8))
    <span class="hljs-keyword">return</span> grid_im


<span class="hljs-keyword">def</span> <span class="hljs-title function_">make_grid</span>(<span class="hljs-params">images, size=<span class="hljs-number">64</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;Given a list of PIL images, stack them together into a line for easy viewing&quot;&quot;&quot;</span>
    output_im = Image.new(<span class="hljs-string">&quot;RGB&quot;</span>, (size * <span class="hljs-built_in">len</span>(images), size))
    <span class="hljs-keyword">for</span> i, im <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(images):
        output_im.paste(im.resize((size, size)), (i * size, <span class="hljs-number">0</span>))
    <span class="hljs-keyword">return</span> output_im


<span class="hljs-comment"># Mac users may need device = &#x27;mps&#x27; (untested)</span>
device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)`,wrap:!1}}),N=new c({props:{title:"Dreambooth: A Sneak Peak at What’s to Come",local:"dreambooth-a-sneak-peak-at-whats-to-come",headingTag:"h2"}}),q=new j({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMFlvdVR1YmVWaWRlbyUwQSUwQVlvdVR1YmVWaWRlbyglMjJXNE1jdWgzOHd5TSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> YouTubeVideo

<span class="hljs-meta">&gt;&gt;&gt; </span>YouTubeVideo(<span class="hljs-string">&quot;W4Mcuh38wyM&quot;</span>)`,wrap:!1}}),L=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwQ2hlY2slMjBvdXQlMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc2QtZHJlYW1ib290aC1saWJyYXJ5JTIwZm9yJTIwbG9hZHMlMjBvZiUyMG1vZGVscyUyMGZyb20lMjB0aGUlMjBjb21tdW5pdHklMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnNkLWRyZWFtYm9vdGgtbGlicmFyeSUyRm1yLXBvdGF0by1oZWFkJTIyJTBBJTBBJTIzJTIwTG9hZCUyMHRoZSUyMHBpcGVsaW5lJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oZGV2aWNlKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-comment"># Check out https://huggingface.co/sd-dreambooth-library for loads of models from the community</span>
model_id = <span class="hljs-string">&quot;sd-dreambooth-library/mr-potato-head&quot;</span>

<span class="hljs-comment"># Load the pipeline</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(device)`,wrap:!1}}),$=new j({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYW4lMjBhYnN0cmFjdCUyMG9pbCUyMHBhaW50aW5nJTIwb2YlMjBza3MlMjBtciUyMHBvdGF0byUyMGhlYWQlMjBieSUyMHBpY2Fzc28lMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q3LjUpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;an abstract oil painting of sks mr potato head by picasso&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>, guidance_scale=<span class="hljs-number">7.5</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),Ae=new c({props:{title:"MVP (Minimum Viable Pipeline)",local:"mvp-minimum-viable-pipeline",headingTag:"h2"}}),se=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1QaXBlbGluZSUwQSUwQSUyMyUyMExvYWQlMjB0aGUlMjBidXR0ZXJmbHklMjBwaXBlbGluZSUwQWJ1dHRlcmZseV9waXBlbGluZSUyMCUzRCUyMEREUE1QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyam9obm93aGl0YWtlciUyRmRkcG0tYnV0dGVyZmxpZXMtMzJweCUyMikudG8oZGV2aWNlKSUwQSUwQSUyMyUyMENyZWF0ZSUyMDglMjBpbWFnZXMlMEFpbWFnZXMlMjAlM0QlMjBidXR0ZXJmbHlfcGlwZWxpbmUoYmF0Y2hfc2l6ZSUzRDgpLmltYWdlcyUwQSUwQSUyMyUyMFZpZXclMjB0aGUlMjByZXN1bHQlMEFtYWtlX2dyaWQoaW1hZ2VzKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the butterfly pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>butterfly_pipeline = DDPMPipeline.from_pretrained(<span class="hljs-string">&quot;johnowhitaker/ddpm-butterflies-32px&quot;</span>).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create 8 images</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = butterfly_pipeline(batch_size=<span class="hljs-number">8</span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># View the result</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>make_grid(images)`,wrap:!1}}),re=new c({props:{title:"Step 2: Download a training dataset",local:"step-2-download-a-training-dataset",headingTag:"h2"}}),de=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torchvision
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> torchvision <span class="hljs-keyword">import</span> transforms

dataset = load_dataset(<span class="hljs-string">&quot;huggan/smithsonian_butterflies_subset&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-comment"># Or load images from a local folder</span>
<span class="hljs-comment"># dataset = load_dataset(&quot;imagefolder&quot;, data_dir=&quot;path/to/folder&quot;)</span>

<span class="hljs-comment"># We&#x27;ll train on 32-pixel square images, but you can try larger sizes too</span>
image_size = <span class="hljs-number">32</span>
<span class="hljs-comment"># You can lower your batch size if you&#x27;re running out of GPU memory</span>
batch_size = <span class="hljs-number">64</span>

<span class="hljs-comment"># Define data augmentations</span>
preprocess = transforms.Compose(
    [
        transforms.Resize((image_size, image_size)),  <span class="hljs-comment"># Resize</span>
        transforms.RandomHorizontalFlip(),  <span class="hljs-comment"># Randomly flip (data augmentation)</span>
        transforms.ToTensor(),  <span class="hljs-comment"># Convert to tensor (0, 1)</span>
        transforms.Normalize([<span class="hljs-number">0.5</span>], [<span class="hljs-number">0.5</span>]),  <span class="hljs-comment"># Map to (-1, 1)</span>
    ]
)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transform</span>(<span class="hljs-params">examples</span>):
    images = [preprocess(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;image&quot;</span>]]
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;images&quot;</span>: images}


dataset.set_transform(transform)

<span class="hljs-comment"># Create a dataloader from the dataset to serve up the transformed images in batches</span>
train_dataloader = torch.utils.data.DataLoader(dataset, batch_size=batch_size, shuffle=<span class="hljs-literal">True</span>)`,wrap:!1}}),Ue=new j({props:{code:"eGIlMjAlM0QlMjBuZXh0KGl0ZXIodHJhaW5fZGF0YWxvYWRlcikpJTVCJTIyaW1hZ2VzJTIyJTVELnRvKGRldmljZSklNUIlM0E4JTVEJTBBcHJpbnQoJTIyWCUyMHNoYXBlJTNBJTIyJTJDJTIweGIuc2hhcGUpJTBBc2hvd19pbWFnZXMoeGIpLnJlc2l6ZSgoOCUyMColMjA2NCUyQyUyMDY0KSUyQyUyMHJlc2FtcGxlJTNESW1hZ2UuTkVBUkVTVCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>xb = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(train_dataloader))[<span class="hljs-string">&quot;images&quot;</span>].to(device)[:<span class="hljs-number">8</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;X shape:&quot;</span>, xb.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span>show_images(xb).resize((<span class="hljs-number">8</span> * <span class="hljs-number">64</span>, <span class="hljs-number">64</span>), resample=Image.NEAREST)`,wrap:!1}}),me=new c({props:{title:"Step 3: Define the Scheduler",local:"step-3-define-the-scheduler",headingTag:"h2"}}),be=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1TY2hlZHVsZXIlMEElMEFub2lzZV9zY2hlZHVsZXIlMjAlM0QlMjBERFBNU2NoZWR1bGVyKG51bV90cmFpbl90aW1lc3RlcHMlM0QxMDAwKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMScheduler

noise_scheduler = DDPMScheduler(num_train_timesteps=<span class="hljs-number">1000</span>)`,wrap:!1}}),Ie=new j({props:{code:"cGx0LnBsb3Qobm9pc2Vfc2NoZWR1bGVyLmFscGhhc19jdW1wcm9kLmNwdSgpJTIwKiolMjAwLjUlMkMlMjBsYWJlbCUzRHIlMjIlMjQlN0IlNUNzcXJ0JTdCJTVDYmFyJTdCJTVDYWxwaGElN0RfdCU3RCU3RCUyNCUyMiklMEFwbHQucGxvdCgoMSUyMC0lMjBub2lzZV9zY2hlZHVsZXIuYWxwaGFzX2N1bXByb2QuY3B1KCkpJTIwKiolMjAwLjUlMkMlMjBsYWJlbCUzRHIlMjIlMjQlNUNzcXJ0JTdCKDElMjAtJTIwJTVDYmFyJTdCJTVDYWxwaGElN0RfdCklN0QlMjQlMjIpJTBBcGx0LmxlZ2VuZChmb250c2l6ZSUzRCUyMngtbGFyZ2UlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>plt.plot(noise_scheduler.alphas_cumprod.cpu() ** <span class="hljs-number">0.5</span>, label=<span class="hljs-string">r&quot;\${\\sqrt{\\bar{\\alpha}_t}}$&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.plot((<span class="hljs-number">1</span> - noise_scheduler.alphas_cumprod.cpu()) ** <span class="hljs-number">0.5</span>, label=<span class="hljs-string">r&quot;$\\sqrt{(1 - \\bar{\\alpha}_t)}$&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.legend(fontsize=<span class="hljs-string">&quot;x-large&quot;</span>)`,wrap:!1}}),ye=new j({props:{code:"JTIzJTIwT25lJTIwd2l0aCUyMHRvbyUyMGxpdHRsZSUyMG5vaXNlJTIwYWRkZWQlM0ElMEElMjMlMjBub2lzZV9zY2hlZHVsZXIlMjAlM0QlMjBERFBNU2NoZWR1bGVyKG51bV90cmFpbl90aW1lc3RlcHMlM0QxMDAwJTJDJTIwYmV0YV9zdGFydCUzRDAuMDAxJTJDJTIwYmV0YV9lbmQlM0QwLjAwNCklMEElMjMlMjBUaGUlMjAnY29zaW5lJyUyMHNjaGVkdWxlJTJDJTIwd2hpY2glMjBtYXklMjBiZSUyMGJldHRlciUyMGZvciUyMHNtYWxsJTIwaW1hZ2UlMjBzaXplcyUzQSUwQSUyMyUyMG5vaXNlX3NjaGVkdWxlciUyMCUzRCUyMEREUE1TY2hlZHVsZXIobnVtX3RyYWluX3RpbWVzdGVwcyUzRDEwMDAlMkMlMjBiZXRhX3NjaGVkdWxlJTNEJ3NxdWFyZWRjb3NfY2FwX3YyJyk=",highlighted:`<span class="hljs-comment"># One with too little noise added:</span>
<span class="hljs-comment"># noise_scheduler = DDPMScheduler(num_train_timesteps=1000, beta_start=0.001, beta_end=0.004)</span>
<span class="hljs-comment"># The &#x27;cosine&#x27; schedule, which may be better for small image sizes:</span>
<span class="hljs-comment"># noise_scheduler = DDPMScheduler(num_train_timesteps=1000, beta_schedule=&#x27;squaredcos_cap_v2&#x27;)</span>`,wrap:!1}}),He=new j({props:{code:"dGltZXN0ZXBzJTIwJTNEJTIwdG9yY2gubGluc3BhY2UoMCUyQyUyMDk5OSUyQyUyMDgpLmxvbmcoKS50byhkZXZpY2UpJTBBbm9pc2UlMjAlM0QlMjB0b3JjaC5yYW5kbl9saWtlKHhiKSUwQW5vaXN5X3hiJTIwJTNEJTIwbm9pc2Vfc2NoZWR1bGVyLmFkZF9ub2lzZSh4YiUyQyUyMG5vaXNlJTJDJTIwdGltZXN0ZXBzKSUwQXByaW50KCUyMk5vaXN5JTIwWCUyMHNoYXBlJTIyJTJDJTIwbm9pc3lfeGIuc2hhcGUpJTBBc2hvd19pbWFnZXMobm9pc3lfeGIpLnJlc2l6ZSgoOCUyMColMjA2NCUyQyUyMDY0KSUyQyUyMHJlc2FtcGxlJTNESW1hZ2UuTkVBUkVTVCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>timesteps = torch.linspace(<span class="hljs-number">0</span>, <span class="hljs-number">999</span>, <span class="hljs-number">8</span>).long().to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>noise = torch.randn_like(xb)
<span class="hljs-meta">&gt;&gt;&gt; </span>noisy_xb = noise_scheduler.add_noise(xb, noise, timesteps)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Noisy X shape&quot;</span>, noisy_xb.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span>show_images(noisy_xb).resize((<span class="hljs-number">8</span> * <span class="hljs-number">64</span>, <span class="hljs-number">64</span>), resample=Image.NEAREST)`,wrap:!1}}),Ce=new c({props:{title:"Step 4: Define the Model",local:"step-4-define-the-model",headingTag:"h2"}}),Ze=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRE1vZGVsJTBBJTBBJTIzJTIwQ3JlYXRlJTIwYSUyMG1vZGVsJTBBbW9kZWwlMjAlM0QlMjBVTmV0MkRNb2RlbCglMEElMjAlMjAlMjAlMjBzYW1wbGVfc2l6ZSUzRGltYWdlX3NpemUlMkMlMjAlMjAlMjMlMjB0aGUlMjB0YXJnZXQlMjBpbWFnZSUyMHJlc29sdXRpb24lMEElMjAlMjAlMjAlMjBpbl9jaGFubmVscyUzRDMlMkMlMjAlMjAlMjMlMjB0aGUlMjBudW1iZXIlMjBvZiUyMGlucHV0JTIwY2hhbm5lbHMlMkMlMjAzJTIwZm9yJTIwUkdCJTIwaW1hZ2VzJTBBJTIwJTIwJTIwJTIwb3V0X2NoYW5uZWxzJTNEMyUyQyUyMCUyMCUyMyUyMHRoZSUyMG51bWJlciUyMG9mJTIwb3V0cHV0JTIwY2hhbm5lbHMlMEElMjAlMjAlMjAlMjBsYXllcnNfcGVyX2Jsb2NrJTNEMiUyQyUyMCUyMCUyMyUyMGhvdyUyMG1hbnklMjBSZXNOZXQlMjBsYXllcnMlMjB0byUyMHVzZSUyMHBlciUyMFVOZXQlMjBibG9jayUwQSUyMCUyMCUyMCUyMGJsb2NrX291dF9jaGFubmVscyUzRCg2NCUyQyUyMDEyOCUyQyUyMDEyOCUyQyUyMDI1NiklMkMlMjAlMjAlMjMlMjBNb3JlJTIwY2hhbm5lbHMlMjAtJTNFJTIwbW9yZSUyMHBhcmFtZXRlcnMlMEElMjAlMjAlMjAlMjBkb3duX2Jsb2NrX3R5cGVzJTNEKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkRvd25CbG9jazJEJTIyJTJDJTIwJTIwJTIzJTIwYSUyMHJlZ3VsYXIlMjBSZXNOZXQlMjBkb3duc2FtcGxpbmclMjBibG9jayUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkRvd25CbG9jazJEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyQXR0bkRvd25CbG9jazJEJTIyJTJDJTIwJTIwJTIzJTIwYSUyMFJlc05ldCUyMGRvd25zYW1wbGluZyUyMGJsb2NrJTIwd2l0aCUyMHNwYXRpYWwlMjBzZWxmLWF0dGVudGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkF0dG5Eb3duQmxvY2syRCUyMiUyQyUwQSUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjB1cF9ibG9ja190eXBlcyUzRCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJBdHRuVXBCbG9jazJEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyQXR0blVwQmxvY2syRCUyMiUyQyUyMCUyMCUyMyUyMGElMjBSZXNOZXQlMjB1cHNhbXBsaW5nJTIwYmxvY2slMjB3aXRoJTIwc3BhdGlhbCUyMHNlbGYtYXR0ZW50aW9uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyVXBCbG9jazJEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyVXBCbG9jazJEJTIyJTJDJTIwJTIwJTIzJTIwYSUyMHJlZ3VsYXIlMjBSZXNOZXQlMjB1cHNhbXBsaW5nJTIwYmxvY2slMEElMjAlMjAlMjAlMjApJTJDJTBBKSUwQW1vZGVsLnRvKGRldmljZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DModel

<span class="hljs-comment"># Create a model</span>
model = UNet2DModel(
    sample_size=image_size,  <span class="hljs-comment"># the target image resolution</span>
    in_channels=<span class="hljs-number">3</span>,  <span class="hljs-comment"># the number of input channels, 3 for RGB images</span>
    out_channels=<span class="hljs-number">3</span>,  <span class="hljs-comment"># the number of output channels</span>
    layers_per_block=<span class="hljs-number">2</span>,  <span class="hljs-comment"># how many ResNet layers to use per UNet block</span>
    block_out_channels=(<span class="hljs-number">64</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>, <span class="hljs-number">256</span>),  <span class="hljs-comment"># More channels -&gt; more parameters</span>
    down_block_types=(
        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,  <span class="hljs-comment"># a regular ResNet downsampling block</span>
        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,
        <span class="hljs-string">&quot;AttnDownBlock2D&quot;</span>,  <span class="hljs-comment"># a ResNet downsampling block with spatial self-attention</span>
        <span class="hljs-string">&quot;AttnDownBlock2D&quot;</span>,
    ),
    up_block_types=(
        <span class="hljs-string">&quot;AttnUpBlock2D&quot;</span>,
        <span class="hljs-string">&quot;AttnUpBlock2D&quot;</span>,  <span class="hljs-comment"># a ResNet upsampling block with spatial self-attention</span>
        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,
        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,  <span class="hljs-comment"># a regular ResNet upsampling block</span>
    ),
)
model.to(device)`,wrap:!1}}),Ne=new j({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG1vZGVsX3ByZWRpY3Rpb24lMjAlM0QlMjBtb2RlbChub2lzeV94YiUyQyUyMHRpbWVzdGVwcykuc2FtcGxlJTBBbW9kZWxfcHJlZGljdGlvbi5zaGFwZQ==",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    model_prediction = model(noisy_xb, timesteps).sample
model_prediction.shape`,wrap:!1}}),Oe=new c({props:{title:"Step 5: Create a Training Loop",local:"step-5-create-a-training-loop",headingTag:"h2"}}),et=new j({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Set the noise scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>noise_scheduler = DDPMScheduler(num_train_timesteps=<span class="hljs-number">1000</span>, beta_schedule=<span class="hljs-string">&quot;squaredcos_cap_v2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Training loop</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = torch.optim.AdamW(model.parameters(), lr=<span class="hljs-number">4e-4</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>losses = []

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">30</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(train_dataloader):
<span class="hljs-meta">... </span>        clean_images = batch[<span class="hljs-string">&quot;images&quot;</span>].to(device)
<span class="hljs-meta">... </span>        <span class="hljs-comment"># Sample noise to add to the images</span>
<span class="hljs-meta">... </span>        noise = torch.randn(clean_images.shape).to(clean_images.device)
<span class="hljs-meta">... </span>        bs = clean_images.shape[<span class="hljs-number">0</span>]

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Sample a random timestep for each image</span>
<span class="hljs-meta">... </span>        timesteps = torch.randint(<span class="hljs-number">0</span>, noise_scheduler.num_train_timesteps, (bs,), device=clean_images.device).long()

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Add noise to the clean images according to the noise magnitude at each timestep</span>
<span class="hljs-meta">... </span>        noisy_images = noise_scheduler.add_noise(clean_images, noise, timesteps)

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Get the model prediction</span>
<span class="hljs-meta">... </span>        noise_pred = model(noisy_images, timesteps, return_dict=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Calculate the loss</span>
<span class="hljs-meta">... </span>        loss = F.mse_loss(noise_pred, noise)
<span class="hljs-meta">... </span>        loss.backward(loss)
<span class="hljs-meta">... </span>        losses.append(loss.item())

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Update the model parameters with the optimizer</span>
<span class="hljs-meta">... </span>        optimizer.step()
<span class="hljs-meta">... </span>        optimizer.zero_grad()

<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> (epoch + <span class="hljs-number">1</span>) % <span class="hljs-number">5</span> == <span class="hljs-number">0</span>:
<span class="hljs-meta">... </span>        loss_last_epoch = <span class="hljs-built_in">sum</span>(losses[-<span class="hljs-built_in">len</span>(train_dataloader) :]) / <span class="hljs-built_in">len</span>(train_dataloader)
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Epoch:<span class="hljs-subst">{epoch+<span class="hljs-number">1</span>}</span>, loss: <span class="hljs-subst">{loss_last_epoch}</span>&quot;</span>)`,wrap:!1}}),lt=new j({props:{code:"ZmlnJTJDJTIwYXhzJTIwJTNEJTIwcGx0LnN1YnBsb3RzKDElMkMlMjAyJTJDJTIwZmlnc2l6ZSUzRCgxMiUyQyUyMDQpKSUwQWF4cyU1QjAlNUQucGxvdChsb3NzZXMpJTBBYXhzJTVCMSU1RC5wbG90KG5wLmxvZyhsb3NzZXMpKSUwQXBsdC5zaG93KCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>fig, axs = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, figsize=(<span class="hljs-number">12</span>, <span class="hljs-number">4</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">0</span>].plot(losses)
<span class="hljs-meta">&gt;&gt;&gt; </span>axs[<span class="hljs-number">1</span>].plot(np.log(losses))
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`,wrap:!1}}),nt=new j({props:{code:"JTIzJTIwVW5jb21tZW50JTIwdG8lMjBpbnN0ZWFkJTIwbG9hZCUyMHRoZSUyMG1vZGVsJTIwSSUyMHRyYWluZWQlMjBlYXJsaWVyJTNBJTBBJTIzJTIwbW9kZWwlMjAlM0QlMjBidXR0ZXJmbHlfcGlwZWxpbmUudW5ldA==",highlighted:`<span class="hljs-comment"># Uncomment to instead load the model I trained earlier:</span>
<span class="hljs-comment"># model = butterfly_pipeline.unet</span>`,wrap:!1}}),st=new c({props:{title:"Step 6: Generate Images",local:"step-6-generate-images",headingTag:"h2"}}),ot=new c({props:{title:"Option 1: Creating a pipeline:",local:"option-1-creating-a-pipeline",headingTag:"h3"}}),pt=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1QaXBlbGluZSUwQSUwQWltYWdlX3BpcGUlMjAlM0QlMjBERFBNUGlwZWxpbmUodW5ldCUzRG1vZGVsJTJDJTIwc2NoZWR1bGVyJTNEbm9pc2Vfc2NoZWR1bGVyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMPipeline

image_pipe = DDPMPipeline(unet=model, scheduler=noise_scheduler)`,wrap:!1}}),rt=new j({props:{code:"cGlwZWxpbmVfb3V0cHV0JTIwJTNEJTIwaW1hZ2VfcGlwZSgpJTBBcGlwZWxpbmVfb3V0cHV0LmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline_output = image_pipe()
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline_output.images[<span class="hljs-number">0</span>]`,wrap:!1}}),dt=new j({props:{code:"aW1hZ2VfcGlwZS5zYXZlX3ByZXRyYWluZWQoJTIybXlfcGlwZWxpbmUlMjIp",highlighted:'image_pipe.save_pretrained(<span class="hljs-string">&quot;my_pipeline&quot;</span>)',wrap:!1}}),Ut=new j({props:{code:"IWxzJTIwbXlfcGlwZWxpbmUlMkY=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>!ls my_pipeline/',wrap:!1}}),mt=new j({props:{code:"IWxzJTIwbXlfcGlwZWxpbmUlMkZ1bmV0JTJG",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>!ls my_pipeline/unet/',wrap:!1}}),bt=new c({props:{title:"Option 2: Writing a Sampling Loop",local:"option-2-writing-a-sampling-loop",headingTag:"h3"}}),gt=new j({props:{code:"JTIzJTIwJTNGJTNGaW1hZ2VfcGlwZS5mb3J3YXJk",highlighted:'<span class="hljs-comment"># ??image_pipe.forward</span>',wrap:!1}}),ht=new j({props:{code:"JTIzJTIwUmFuZG9tJTIwc3RhcnRpbmclMjBwb2ludCUyMCg4JTIwcmFuZG9tJTIwaW1hZ2VzKSUzQSUwQXNhbXBsZSUyMCUzRCUyMHRvcmNoLnJhbmRuKDglMkMlMjAzJTJDJTIwMzIlMkMlMjAzMikudG8oZGV2aWNlKSUwQSUwQWZvciUyMGklMkMlMjB0JTIwaW4lMjBlbnVtZXJhdGUobm9pc2Vfc2NoZWR1bGVyLnRpbWVzdGVwcyklM0ElMEElMEElMjAlMjAlMjAlMjAlMjMlMjBHZXQlMjBtb2RlbCUyMHByZWQlMEElMjAlMjAlMjAlMjB3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzaWR1YWwlMjAlM0QlMjBtb2RlbChzYW1wbGUlMkMlMjB0KS5zYW1wbGUlMEElMEElMjAlMjAlMjAlMjAlMjMlMjBVcGRhdGUlMjBzYW1wbGUlMjB3aXRoJTIwc3RlcCUwQSUyMCUyMCUyMCUyMHNhbXBsZSUyMCUzRCUyMG5vaXNlX3NjaGVkdWxlci5zdGVwKHJlc2lkdWFsJTJDJTIwdCUyQyUyMHNhbXBsZSkucHJldl9zYW1wbGUlMEElMEFzaG93X2ltYWdlcyhzYW1wbGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Random starting point (8 random images):</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sample = torch.randn(<span class="hljs-number">8</span>, <span class="hljs-number">3</span>, <span class="hljs-number">32</span>, <span class="hljs-number">32</span>).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, t <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(noise_scheduler.timesteps):

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Get model pred</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        residual = model(sample, t).sample

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Update sample with step</span>
<span class="hljs-meta">... </span>    sample = noise_scheduler.step(residual, t, sample).prev_sample

<span class="hljs-meta">&gt;&gt;&gt; </span>show_images(sample)`,wrap:!1}}),It=new c({props:{title:"Step 7: Push your model to the Hub",local:"step-7-push-your-model-to-the-hub",headingTag:"h2"}}),yt=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9mdWxsX3JlcG9fbmFtZSUwQSUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJzZC1jbGFzcy1idXR0ZXJmbGllcy0zMiUyMiUwQWh1Yl9tb2RlbF9pZCUyMCUzRCUyMGdldF9mdWxsX3JlcG9fbmFtZShtb2RlbF9uYW1lKSUwQWh1Yl9tb2RlbF9pZA==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_full_repo_name

model_name = <span class="hljs-string">&quot;sd-class-butterflies-32&quot;</span>
hub_model_id = get_full_repo_name(model_name)
hub_model_id`,wrap:!1}}),Ht=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTJDJTIwY3JlYXRlX3JlcG8lMEElMEFjcmVhdGVfcmVwbyhodWJfbW9kZWxfaWQpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWFwaS51cGxvYWRfZm9sZGVyKGZvbGRlcl9wYXRoJTNEJTIybXlfcGlwZWxpbmUlMkZzY2hlZHVsZXIlMjIlMkMlMjBwYXRoX2luX3JlcG8lM0QlMjIlMjIlMkMlMjByZXBvX2lkJTNEaHViX21vZGVsX2lkKSUwQWFwaS51cGxvYWRfZm9sZGVyKGZvbGRlcl9wYXRoJTNEJTIybXlfcGlwZWxpbmUlMkZ1bmV0JTIyJTJDJTIwcGF0aF9pbl9yZXBvJTNEJTIyJTIyJTJDJTIwcmVwb19pZCUzRGh1Yl9tb2RlbF9pZCklMEFhcGkudXBsb2FkX2ZpbGUoJTBBJTIwJTIwJTIwJTIwcGF0aF9vcl9maWxlb2JqJTNEJTIybXlfcGlwZWxpbmUlMkZtb2RlbF9pbmRleC5qc29uJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGF0aF9pbl9yZXBvJTNEJTIybW9kZWxfaW5kZXguanNvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0RodWJfbW9kZWxfaWQlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi, create_repo

create_repo(hub_model_id)
api = HfApi()
api.upload_folder(folder_path=<span class="hljs-string">&quot;my_pipeline/scheduler&quot;</span>, path_in_repo=<span class="hljs-string">&quot;&quot;</span>, repo_id=hub_model_id)
api.upload_folder(folder_path=<span class="hljs-string">&quot;my_pipeline/unet&quot;</span>, path_in_repo=<span class="hljs-string">&quot;&quot;</span>, repo_id=hub_model_id)
api.upload_file(
    path_or_fileobj=<span class="hljs-string">&quot;my_pipeline/model_index.json&quot;</span>,
    path_in_repo=<span class="hljs-string">&quot;model_index.json&quot;</span>,
    repo_id=hub_model_id,
)`,wrap:!1}}),Tt=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsQ2FyZCUwQSUwQWNvbnRlbnQlMjAlM0QlMjBmJTIyJTIyJTIyJTBBLS0tJTBBbGljZW5zZSUzQSUyMG1pdCUwQXRhZ3MlM0ElMEEtJTIwcHl0b3JjaCUwQS0lMjBkaWZmdXNlcnMlMEEtJTIwdW5jb25kaXRpb25hbC1pbWFnZS1nZW5lcmF0aW9uJTBBLSUyMGRpZmZ1c2lvbi1tb2RlbHMtY2xhc3MlMEEtLS0lMEElMEElMjMlMjBNb2RlbCUyMENhcmQlMjBmb3IlMjBVbml0JTIwMSUyMG9mJTIwdGhlJTIwJTVCRGlmZnVzaW9uJTIwTW9kZWxzJTIwQ2xhc3MlMjAlRjAlOUYlQTclQTglNUQoaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZkaWZmdXNpb24tbW9kZWxzLWNsYXNzKSUwQSUwQVRoaXMlMjBtb2RlbCUyMGlzJTIwYSUyMGRpZmZ1c2lvbiUyMG1vZGVsJTIwZm9yJTIwdW5jb25kaXRpb25hbCUyMGltYWdlJTIwZ2VuZXJhdGlvbiUyMG9mJTIwY3V0ZSUyMCVGMCU5RiVBNiU4Qi4lMEElMEElMjMlMjMlMjBVc2FnZSUwQSUwQSU2MCU2MCU2MHB5dGhvbiUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBERFBNUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMEREUE1QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJyU3Qmh1Yl9tb2RlbF9pZCU3RCcpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSgpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCard

content = <span class="hljs-string">f&quot;&quot;&quot;
---
license: mit
tags:
- pytorch
- diffusers
- unconditional-image-generation
- diffusion-models-class
---

# Model Card for Unit 1 of the [Diffusion Models Class 🧨](https://github.com/huggingface/diffusion-models-class)

This model is a diffusion model for unconditional image generation of cute 🦋.

## Usage

\`\`\`python
from diffusers import DDPMPipeline

pipeline = DDPMPipeline.from_pretrained(&#x27;<span class="hljs-subst">{hub_model_id}</span>&#x27;)
image = pipeline().images[0]
image</span>`,wrap:!1}}),Jt=new j({props:{code:"JTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1QaXBlbGluZSUwQSUwQWltYWdlX3BpcGUlMjAlM0QlMjBERFBNUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKGh1Yl9tb2RlbF9pZCklMEFwaXBlbGluZV9vdXRwdXQlMjAlM0QlMjBpbWFnZV9waXBlKCklMEFwaXBlbGluZV9vdXRwdXQuaW1hZ2VzJTVCMCU1RA==",highlighted:`
Now that the model <span class="hljs-keyword">is</span> <span class="hljs-keyword">on</span> the Hub, you can download it <span class="hljs-keyword">from</span> anywhere <span class="hljs-keyword">by</span> <span class="hljs-keyword">using</span> the \`from_pretrained()\` <span class="hljs-keyword">method</span> <span class="hljs-title function_">of</span> <span class="hljs-title function_">the</span> \`<span class="hljs-title function_">DDPMPipeline</span>\` <span class="hljs-title function_">as</span> <span class="hljs-title function_">follows</span>&quot;

\`\`\`<span class="hljs-title function_">python</span>
&gt;&gt;&gt; <span class="hljs-title function_">from</span> <span class="hljs-title function_">diffusers</span> <span class="hljs-title function_">import</span> <span class="hljs-title function_">DDPMPipeline</span>

&gt;&gt;&gt; <span class="hljs-title function_">image_pipe</span> = <span class="hljs-title function_">DDPMPipeline</span>.<span class="hljs-title function_">from_pretrained</span><span class="hljs-params">(hub_model_id)</span>
&gt;&gt;&gt; <span class="hljs-title function_">pipeline_output</span> = <span class="hljs-title function_">image_pipe</span><span class="hljs-params">()</span>
&gt;&gt;&gt; <span class="hljs-title function_">pipeline_output</span>.<span class="hljs-title function_">images</span>[0]`,wrap:!1}}),kt=new c({props:{title:"Scaling up with 🤗 Accelerate",local:"scaling-up-with--accelerate",headingTag:"h1"}}),vt=new j({props:{code:"IXdnZXQlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUyRnJhdyUyRm1haW4lMkZleGFtcGxlcyUyRnVuY29uZGl0aW9uYWxfaW1hZ2VfZ2VuZXJhdGlvbiUyRnRyYWluX3VuY29uZGl0aW9uYWwucHk=",highlighted:"!wget https://github.com/huggingface/diffusers/raw/main/examples/unconditional_image_generation/train_unconditional.py",wrap:!1}}),Zt=new j({props:{code:"JTIzJTIwTGV0J3MlMjBnaXZlJTIwb3VyJTIwbmV3JTIwbW9kZWwlMjBhJTIwbmFtZSUyMGZvciUyMHRoZSUyMEh1YiUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJzZC1jbGFzcy1idXR0ZXJmbGllcy02NCUyMiUwQWh1Yl9tb2RlbF9pZCUyMCUzRCUyMGdldF9mdWxsX3JlcG9fbmFtZShtb2RlbF9uYW1lKSUwQWh1Yl9tb2RlbF9pZA==",highlighted:`<span class="hljs-comment"># Let&#x27;s give our new model a name for the Hub</span>
model_name = <span class="hljs-string">&quot;sd-class-butterflies-64&quot;</span>
hub_model_id = get_full_repo_name(model_name)
hub_model_id`,wrap:!1}}),Gt=new j({props:{code:"IWFjY2VsZXJhdGUlMjBsYXVuY2glMjB0cmFpbl91bmNvbmRpdGlvbmFsLnB5JTIwJTVDJTBBJTIwJTIwLS1kYXRhc2V0X25hbWUlM0QlMjJodWdnYW4lMkZzbWl0aHNvbmlhbl9idXR0ZXJmbGllc19zdWJzZXQlMjIlMjAlNUMlMEElMjAlMjAtLXJlc29sdXRpb24lM0Q2NCUyMCU1QyUwQSUyMCUyMC0tb3V0cHV0X2RpciUzRCU3Qm1vZGVsX25hbWUlN0QlMjAlNUMlMEElMjAlMjAtLXRyYWluX2JhdGNoX3NpemUlM0QzMiUyMCU1QyUwQSUyMCUyMC0tbnVtX2Vwb2NocyUzRDUwJTIwJTVDJTBBJTIwJTIwLS1ncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0QxJTIwJTVDJTBBJTIwJTIwLS1sZWFybmluZ19yYXRlJTNEMWUtNCUyMCU1QyUwQSUyMCUyMC0tbHJfd2FybXVwX3N0ZXBzJTNENTAwJTIwJTVDJTBBJTIwJTIwLS1taXhlZF9wcmVjaXNpb24lM0QlMjJubyUyMg==",highlighted:`!accelerate launch train_unconditional.py \\
  --dataset_name=<span class="hljs-string">&quot;huggan/smithsonian_butterflies_subset&quot;</span> \\
  --resolution=<span class="hljs-number">64</span> \\
  --output_dir={model_name} \\
  --train_batch_size=<span class="hljs-number">32</span> \\
  --num_epochs=<span class="hljs-number">50</span> \\
  --gradient_accumulation_steps=<span class="hljs-number">1</span> \\
  --learning_rate=<span class="hljs-number">1e-4</span> \\
  --lr_warmup_steps=<span class="hljs-number">500</span> \\
  --mixed_precision=<span class="hljs-string">&quot;no&quot;</span>`,wrap:!1}}),Nt=new j({props:{code:"Y3JlYXRlX3JlcG8oaHViX21vZGVsX2lkKSUwQWFwaSUyMCUzRCUyMEhmQXBpKCklMEFhcGkudXBsb2FkX2ZvbGRlcihmb2xkZXJfcGF0aCUzRGYlMjIlN0Jtb2RlbF9uYW1lJTdEJTJGc2NoZWR1bGVyJTIyJTJDJTIwcGF0aF9pbl9yZXBvJTNEJTIyJTIyJTJDJTIwcmVwb19pZCUzRGh1Yl9tb2RlbF9pZCklMEFhcGkudXBsb2FkX2ZvbGRlcihmb2xkZXJfcGF0aCUzRGYlMjIlN0Jtb2RlbF9uYW1lJTdEJTJGdW5ldCUyMiUyQyUyMHBhdGhfaW5fcmVwbyUzRCUyMiUyMiUyQyUyMHJlcG9faWQlM0RodWJfbW9kZWxfaWQpJTBBYXBpLnVwbG9hZF9maWxlKCUwQSUyMCUyMCUyMCUyMHBhdGhfb3JfZmlsZW9iaiUzRGYlMjIlN0Jtb2RlbF9uYW1lJTdEJTJGbW9kZWxfaW5kZXguanNvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhdGhfaW5fcmVwbyUzRCUyMm1vZGVsX2luZGV4Lmpzb24lMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEaHViX21vZGVsX2lkJTJDJTBBKSUwQSUwQWNvbnRlbnQlMjAlM0QlMjBmJTIyJTIyJTIyJTBBLS0tJTBBbGljZW5zZSUzQSUyMG1pdCUwQXRhZ3MlM0ElMEEtJTIwcHl0b3JjaCUwQS0lMjBkaWZmdXNlcnMlMEEtJTIwdW5jb25kaXRpb25hbC1pbWFnZS1nZW5lcmF0aW9uJTBBLSUyMGRpZmZ1c2lvbi1tb2RlbHMtY2xhc3MlMEEtLS0lMEElMEElMjMlMjBNb2RlbCUyMENhcmQlMjBmb3IlMjBVbml0JTIwMSUyMG9mJTIwdGhlJTIwJTVCRGlmZnVzaW9uJTIwTW9kZWxzJTIwQ2xhc3MlMjAlRjAlOUYlQTclQTglNUQoaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZkaWZmdXNpb24tbW9kZWxzLWNsYXNzKSUwQSUwQVRoaXMlMjBtb2RlbCUyMGlzJTIwYSUyMGRpZmZ1c2lvbiUyMG1vZGVsJTIwZm9yJTIwdW5jb25kaXRpb25hbCUyMGltYWdlJTIwZ2VuZXJhdGlvbiUyMG9mJTIwY3V0ZSUyMCVGMCU5RiVBNiU4Qi4lMEElMEElMjMlMjMlMjBVc2FnZSUwQSUwQSU2MCU2MCU2MHB5dGhvbiUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBERFBNUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMEREUE1QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJyU3Qmh1Yl9tb2RlbF9pZCU3RCcpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSgpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`create_repo(hub_model_id)
api = HfApi()
api.upload_folder(folder_path=<span class="hljs-string">f&quot;<span class="hljs-subst">{model_name}</span>/scheduler&quot;</span>, path_in_repo=<span class="hljs-string">&quot;&quot;</span>, repo_id=hub_model_id)
api.upload_folder(folder_path=<span class="hljs-string">f&quot;<span class="hljs-subst">{model_name}</span>/unet&quot;</span>, path_in_repo=<span class="hljs-string">&quot;&quot;</span>, repo_id=hub_model_id)
api.upload_file(
    path_or_fileobj=<span class="hljs-string">f&quot;<span class="hljs-subst">{model_name}</span>/model_index.json&quot;</span>,
    path_in_repo=<span class="hljs-string">&quot;model_index.json&quot;</span>,
    repo_id=hub_model_id,
)

content = <span class="hljs-string">f&quot;&quot;&quot;
---
license: mit
tags:
- pytorch
- diffusers
- unconditional-image-generation
- diffusion-models-class
---

# Model Card for Unit 1 of the [Diffusion Models Class 🧨](https://github.com/huggingface/diffusion-models-class)

This model is a diffusion model for unconditional image generation of cute 🦋.

## Usage

\`\`\`python
from diffusers import DDPMPipeline

pipeline = DDPMPipeline.from_pretrained(&#x27;<span class="hljs-subst">{hub_model_id}</span>&#x27;)
image = pipeline().images[0]
image</span>`,wrap:!1}}),qt=new j({props:{code:"JTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBERFBNUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKGh1Yl9tb2RlbF9pZCkudG8oZGV2aWNlKSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKGJhdGNoX3NpemUlM0Q4KS5pbWFnZXMlMEFtYWtlX2dyaWQoaW1hZ2VzKQ==",highlighted:`
About 45 minutes later, this is the result:

\`\`\`python
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">pipeline = DDPMPipeline.from_pretrained(hub_model_id).to(device)</span>
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">images = pipeline(batch_size=<span class="hljs-number">8</span>).images</span>
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">make_grid(images)</span>`,wrap:!1}}),Et=new c({props:{title:"Avenues for Further Exploration",local:"avenues-for-further-exploration",headingTag:"h1"}}),eA=new ii({props:{source:"https://github.com/huggingface/diffusion-models-class/blob/main/unit1/01_introduction_to_diffusers.md"}}),{c(){w=s("meta"),dA=a(),rA=s("p"),fA=a(),p(b.$$.fragment),UA=a(),p(R.$$.fragment),jA=a(),g=s("p"),g.innerHTML=sn,cA=a(),K=s("p"),K.innerHTML=on,mA=a(),h=s("p"),h.textContent=pn,wA=a(),p(M.$$.fragment),FA=a(),I=s("p"),I.textContent=rn,bA=a(),B=s("ul"),B.innerHTML=un,RA=a(),y=s("p"),y.innerHTML=dn,gA=a(),p(X.$$.fragment),KA=a(),H=s("p"),H.textContent=fn,hA=a(),P=s("ul"),P.innerHTML=Un,MA=a(),p(T.$$.fragment),IA=a(),C=s("p"),C.textContent=jn,BA=a(),p(x.$$.fragment),yA=a(),J=s("p"),J.innerHTML=cn,XA=a(),z=s("p"),z.innerHTML=mn,HA=a(),k=s("p"),k.innerHTML=wn,PA=a(),p(Q.$$.fragment),TA=a(),S=s("pre"),S.textContent=Fn,CA=a(),v=s("p"),v.textContent=bn,xA=a(),p(V.$$.fragment),JA=a(),Z=s("p"),Z.textContent=Rn,zA=a(),p(G.$$.fragment),kA=a(),W=s("p"),W.textContent=gn,QA=a(),p(N.$$.fragment),SA=a(),D=s("p"),D.textContent=Kn,vA=a(),O=s("p"),O.textContent=hn,VA=a(),p(q.$$.fragment),ZA=a(),tA=s("img"),GA=a(),Y=s("p"),Y.innerHTML=In,WA=a(),E=s("p"),E.textContent=Bn,NA=a(),p(L.$$.fragment),DA=a(),_=s("p"),_.textContent=yn,OA=a(),p($.$$.fragment),qA=a(),AA=s("img"),YA=a(),ee=s("p"),ee.innerHTML=Hn,EA=a(),te=s("p"),te.textContent=Pn,LA=a(),p(Ae.$$.fragment),_A=a(),le=s("p"),le.textContent=Tn,$A=a(),ae=s("ol"),ae.innerHTML=Cn,el=a(),ne=s("p"),ne.textContent=xn,tl=a(),p(se.$$.fragment),Al=a(),lA=s("img"),ll=a(),ie=s("p"),ie.textContent=zn,al=a(),oe=s("ol"),oe.innerHTML=kn,nl=a(),pe=s("p"),pe.textContent=Qn,sl=a(),p(re.$$.fragment),il=a(),ue=s("p"),ue.innerHTML=Sn,ol=a(),p(de.$$.fragment),pl=a(),fe=s("p"),fe.textContent=vn,rl=a(),p(Ue.$$.fragment),ul=a(),je=s("pre"),je.textContent=Vn,dl=a(),ce=s("p"),ce.textContent=Zn,fl=a(),p(me.$$.fragment),Ul=a(),we=s("p"),we.innerHTML=Gn,jl=a(),Fe=s("p"),Fe.innerHTML=Wn,cl=a(),p(be.$$.fragment),ml=a(),Re=s("p"),Re.innerHTML=Nn,wl=a(),ge=s("p"),ge.innerHTML=Dn,Fl=a(),Ke=s("p"),Ke.innerHTML=On,bl=a(),he=s("p"),he.innerHTML=qn,Rl=a(),Me=s("p"),Me.innerHTML=Yn,gl=a(),p(Ie.$$.fragment),Kl=a(),aA=s("img"),hl=a(),Be=s("p"),Be.innerHTML=Ln,Ml=a(),p(ye.$$.fragment),Il=a(),Xe=s("p"),Xe.innerHTML=_n,Bl=a(),p(He.$$.fragment),yl=a(),Pe=s("pre"),Pe.textContent=$n,Xl=a(),Te=s("p"),Te.innerHTML=es,Hl=a(),p(Ce.$$.fragment),Pl=a(),xe=s("p"),xe.textContent=ts,Tl=a(),Je=s("p"),Je.innerHTML=As,Cl=a(),ze=s("p"),ze.innerHTML=ls,xl=a(),ke=s("p"),ke.textContent=as,Jl=a(),Qe=s("ul"),Qe.innerHTML=ns,zl=a(),Se=s("p"),Se.textContent=ss,kl=a(),ve=s("p"),ve.innerHTML=is,Ql=a(),Ve=s("p"),Ve.innerHTML=os,Sl=a(),p(Ze.$$.fragment),vl=a(),Ge=s("p"),Ge.textContent=ps,Vl=a(),We=s("p"),We.textContent=rs,Zl=a(),p(Ne.$$.fragment),Gl=a(),De=s("p"),De.textContent=us,Wl=a(),p(Oe.$$.fragment),Nl=a(),qe=s("p"),qe.textContent=ds,Dl=a(),Ye=s("p"),Ye.textContent=fs,Ol=a(),Ee=s("ul"),Ee.innerHTML=Us,ql=a(),Le=s("p"),Le.textContent=js,Yl=a(),_e=s("p"),_e.textContent=cs,El=a(),$e=s("p"),$e.innerHTML=ms,Ll=a(),p(et.$$.fragment),_l=a(),tt=s("pre"),tt.textContent=ws,$l=a(),At=s("p"),At.textContent=Fs,ea=a(),p(lt.$$.fragment),ta=a(),nA=s("img"),Aa=a(),at=s("p"),at.textContent=Rs,la=a(),p(nt.$$.fragment),aa=a(),p(st.$$.fragment),na=a(),it=s("p"),it.textContent=gs,sa=a(),p(ot.$$.fragment),ia=a(),p(pt.$$.fragment),oa=a(),p(rt.$$.fragment),pa=a(),sA=s("img"),ra=a(),ut=s("p"),ut.textContent=hs,ua=a(),p(dt.$$.fragment),da=a(),ft=s("p"),ft.textContent=Ms,fa=a(),p(Ut.$$.fragment),Ua=a(),jt=s("pre"),jt.textContent=Is,ja=a(),ct=s("p"),ct.innerHTML=Bs,ca=a(),p(mt.$$.fragment),ma=a(),wt=s("pre"),wt.textContent=ys,wa=a(),Ft=s("p"),Ft.textContent=Xs,Fa=a(),p(bt.$$.fragment),ba=a(),Rt=s("p"),Rt.innerHTML=Hs,Ra=a(),p(gt.$$.fragment),ga=a(),Kt=s("p"),Kt.textContent=Ps,Ka=a(),p(ht.$$.fragment),ha=a(),iA=s("img"),Ma=a(),Mt=s("p"),Mt.innerHTML=Cs,Ia=a(),p(It.$$.fragment),Ba=a(),Bt=s("p"),Bt.innerHTML=xs,ya=a(),p(yt.$$.fragment),Xa=a(),Xt=s("p"),Xt.textContent=Js,Ha=a(),p(Ht.$$.fragment),Pa=a(),Pt=s("p"),Pt.textContent=zs,Ta=a(),p(Tt.$$.fragment),Ca=a(),Ct=s("p"),Ct.textContent=ks,xa=a(),xt=s("p"),xt.textContent=Qs,Ja=a(),p(Jt.$$.fragment),za=a(),oA=s("img"),ka=a(),zt=s("p"),zt.textContent=vs,Qa=a(),p(kt.$$.fragment),Sa=a(),Qt=s("p"),Qt.innerHTML=Vs,va=a(),St=s("p"),St.textContent=Zs,Va=a(),p(vt.$$.fragment),Za=a(),Vt=s("p"),Vt.textContent=Gs,Ga=a(),p(Zt.$$.fragment),Wa=a(),p(Gt.$$.fragment),Na=a(),Wt=s("p"),Wt.textContent=Ws,Da=a(),p(Nt.$$.fragment),Oa=a(),Dt=s("p"),Dt.textContent=Ns,qa=a(),Ot=s("p"),Ot.textContent=Ds,Ya=a(),p(qt.$$.fragment),Ea=a(),pA=s("img"),La=a(),Yt=s("p"),Yt.innerHTML=qs,_a=a(),p(Et.$$.fragment),$a=a(),Lt=s("p"),Lt.textContent=Ys,en=a(),_t=s("ul"),_t.innerHTML=Es,tn=a(),$t=s("p"),$t.textContent=Ls,An=a(),p(eA.$$.fragment),ln=a(),uA=s("p"),this.h()},l(e){const t=ai("svelte-u9bgzb",document.head);w=i(t,"META",{name:!0,content:!0}),t.forEach(A),dA=n(e),rA=i(e,"P",{}),_s(rA).forEach(A),fA=n(e),r(b.$$.fragment,e),UA=n(e),r(R.$$.fragment,e),jA=n(e),g=i(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1ellde6"&&(g.innerHTML=sn),cA=n(e),K=i(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1qijnby"&&(K.innerHTML=on),mA=n(e),h=i(e,"P",{"data-svelte-h":!0}),o(h)!=="svelte-1tyjc61"&&(h.textContent=pn),wA=n(e),r(M.$$.fragment,e),FA=n(e),I=i(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1st3pyt"&&(I.textContent=rn),bA=n(e),B=i(e,"UL",{"data-svelte-h":!0}),o(B)!=="svelte-1mn6251"&&(B.innerHTML=un),RA=n(e),y=i(e,"P",{"data-svelte-h":!0}),o(y)!=="svelte-1hvsyk8"&&(y.innerHTML=dn),gA=n(e),r(X.$$.fragment,e),KA=n(e),H=i(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1w8x5lm"&&(H.textContent=fn),hA=n(e),P=i(e,"UL",{"data-svelte-h":!0}),o(P)!=="svelte-4248et"&&(P.innerHTML=Un),MA=n(e),r(T.$$.fragment,e),IA=n(e),C=i(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-jjbntx"&&(C.textContent=jn),BA=n(e),r(x.$$.fragment,e),yA=n(e),J=i(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-gubkv2"&&(J.innerHTML=cn),XA=n(e),z=i(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-w8yie8"&&(z.innerHTML=mn),HA=n(e),k=i(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1l53vqg"&&(k.innerHTML=wn),PA=n(e),r(Q.$$.fragment,e),TA=n(e),S=i(e,"PRE",{"data-svelte-h":!0}),o(S)!=="svelte-1recgkl"&&(S.textContent=Fn),CA=n(e),v=i(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-ydl2wl"&&(v.textContent=bn),xA=n(e),r(V.$$.fragment,e),JA=n(e),Z=i(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-vbg44i"&&(Z.textContent=Rn),zA=n(e),r(G.$$.fragment,e),kA=n(e),W=i(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1if1wli"&&(W.textContent=gn),QA=n(e),r(N.$$.fragment,e),SA=n(e),D=i(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-635hqz"&&(D.textContent=Kn),vA=n(e),O=i(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-10xou5"&&(O.textContent=hn),VA=n(e),r(q.$$.fragment,e),ZA=n(e),tA=i(e,"IMG",{src:!0}),GA=n(e),Y=i(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-xurcx0"&&(Y.innerHTML=In),WA=n(e),E=i(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-4fpmek"&&(E.textContent=Bn),NA=n(e),r(L.$$.fragment,e),DA=n(e),_=i(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-smnof7"&&(_.textContent=yn),OA=n(e),r($.$$.fragment,e),qA=n(e),AA=i(e,"IMG",{src:!0}),YA=n(e),ee=i(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1la6c50"&&(ee.innerHTML=Hn),EA=n(e),te=i(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-1v26bse"&&(te.textContent=Pn),LA=n(e),r(Ae.$$.fragment,e),_A=n(e),le=i(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1xh0p6f"&&(le.textContent=Tn),$A=n(e),ae=i(e,"OL",{"data-svelte-h":!0}),o(ae)!=="svelte-thruap"&&(ae.innerHTML=Cn),el=n(e),ne=i(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1gtbzr5"&&(ne.textContent=xn),tl=n(e),r(se.$$.fragment,e),Al=n(e),lA=i(e,"IMG",{src:!0}),ll=n(e),ie=i(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-1famlj8"&&(ie.textContent=zn),al=n(e),oe=i(e,"OL",{"data-svelte-h":!0}),o(oe)!=="svelte-1b8dai1"&&(oe.innerHTML=kn),nl=n(e),pe=i(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-1x62mi"&&(pe.textContent=Qn),sl=n(e),r(re.$$.fragment,e),il=n(e),ue=i(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-1dcu5pf"&&(ue.innerHTML=Sn),ol=n(e),r(de.$$.fragment,e),pl=n(e),fe=i(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-udpvfc"&&(fe.textContent=vn),rl=n(e),r(Ue.$$.fragment,e),ul=n(e),je=i(e,"PRE",{"data-svelte-h":!0}),o(je)!=="svelte-1yh53qq"&&(je.textContent=Vn),dl=n(e),ce=i(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-1q35gp7"&&(ce.textContent=Zn),fl=n(e),r(me.$$.fragment,e),Ul=n(e),we=i(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-13n9uf2"&&(we.innerHTML=Gn),jl=n(e),Fe=i(e,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-d5b6fx"&&(Fe.innerHTML=Wn),cl=n(e),r(be.$$.fragment,e),ml=n(e),Re=i(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-1frxnc3"&&(Re.innerHTML=Nn),wl=n(e),ge=i(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-ktr7ft"&&(ge.innerHTML=Dn),Fl=n(e),Ke=i(e,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-1577x24"&&(Ke.innerHTML=On),bl=n(e),he=i(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-u5wyzm"&&(he.innerHTML=qn),Rl=n(e),Me=i(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-dcfubc"&&(Me.innerHTML=Yn),gl=n(e),r(Ie.$$.fragment,e),Kl=n(e),aA=i(e,"IMG",{src:!0}),hl=n(e),Be=i(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-136uvfe"&&(Be.innerHTML=Ln),Ml=n(e),r(ye.$$.fragment,e),Il=n(e),Xe=i(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-wst0cx"&&(Xe.innerHTML=_n),Bl=n(e),r(He.$$.fragment,e),yl=n(e),Pe=i(e,"PRE",{"data-svelte-h":!0}),o(Pe)!=="svelte-ep4542"&&(Pe.textContent=$n),Xl=n(e),Te=i(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-lf0u2s"&&(Te.innerHTML=es),Hl=n(e),r(Ce.$$.fragment,e),Pl=n(e),xe=i(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-chlwsb"&&(xe.textContent=ts),Tl=n(e),Je=i(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-on68x0"&&(Je.innerHTML=As),Cl=n(e),ze=i(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-1ygz2gl"&&(ze.innerHTML=ls),xl=n(e),ke=i(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-1cva3rl"&&(ke.textContent=as),Jl=n(e),Qe=i(e,"UL",{"data-svelte-h":!0}),o(Qe)!=="svelte-ywp6qy"&&(Qe.innerHTML=ns),zl=n(e),Se=i(e,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-1ymw2z9"&&(Se.textContent=ss),kl=n(e),ve=i(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-5kd4ay"&&(ve.innerHTML=is),Ql=n(e),Ve=i(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-kyixi9"&&(Ve.innerHTML=os),Sl=n(e),r(Ze.$$.fragment,e),vl=n(e),Ge=i(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-1unccnk"&&(Ge.textContent=ps),Vl=n(e),We=i(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-16rqz6l"&&(We.textContent=rs),Zl=n(e),r(Ne.$$.fragment,e),Gl=n(e),De=i(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-h70d6e"&&(De.textContent=us),Wl=n(e),r(Oe.$$.fragment,e),Nl=n(e),qe=i(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-d7eubx"&&(qe.textContent=ds),Dl=n(e),Ye=i(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-qjf17p"&&(Ye.textContent=fs),Ol=n(e),Ee=i(e,"UL",{"data-svelte-h":!0}),o(Ee)!=="svelte-fk2bsi"&&(Ee.innerHTML=Us),ql=n(e),Le=i(e,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-65m7pu"&&(Le.textContent=js),Yl=n(e),_e=i(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-198eozz"&&(_e.textContent=cs),El=n(e),$e=i(e,"P",{"data-svelte-h":!0}),o($e)!=="svelte-48j9jd"&&($e.innerHTML=ms),Ll=n(e),r(et.$$.fragment,e),_l=n(e),tt=i(e,"PRE",{"data-svelte-h":!0}),o(tt)!=="svelte-t848hu"&&(tt.textContent=ws),$l=n(e),At=i(e,"P",{"data-svelte-h":!0}),o(At)!=="svelte-1wd5k43"&&(At.textContent=Fs),ea=n(e),r(lt.$$.fragment,e),ta=n(e),nA=i(e,"IMG",{src:!0}),Aa=n(e),at=i(e,"P",{"data-svelte-h":!0}),o(at)!=="svelte-aq8iy3"&&(at.textContent=Rs),la=n(e),r(nt.$$.fragment,e),aa=n(e),r(st.$$.fragment,e),na=n(e),it=i(e,"P",{"data-svelte-h":!0}),o(it)!=="svelte-ejo3wx"&&(it.textContent=gs),sa=n(e),r(ot.$$.fragment,e),ia=n(e),r(pt.$$.fragment,e),oa=n(e),r(rt.$$.fragment,e),pa=n(e),sA=i(e,"IMG",{src:!0}),ra=n(e),ut=i(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-1elep04"&&(ut.textContent=hs),ua=n(e),r(dt.$$.fragment,e),da=n(e),ft=i(e,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-1jdpjbh"&&(ft.textContent=Ms),fa=n(e),r(Ut.$$.fragment,e),Ua=n(e),jt=i(e,"PRE",{"data-svelte-h":!0}),o(jt)!=="svelte-1a2j1bv"&&(jt.textContent=Is),ja=n(e),ct=i(e,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-n1w9x6"&&(ct.innerHTML=Bs),ca=n(e),r(mt.$$.fragment,e),ma=n(e),wt=i(e,"PRE",{"data-svelte-h":!0}),o(wt)!=="svelte-1ys5ub0"&&(wt.textContent=ys),wa=n(e),Ft=i(e,"P",{"data-svelte-h":!0}),o(Ft)!=="svelte-1mm6k5j"&&(Ft.textContent=Xs),Fa=n(e),r(bt.$$.fragment,e),ba=n(e),Rt=i(e,"P",{"data-svelte-h":!0}),o(Rt)!=="svelte-qfq5hp"&&(Rt.innerHTML=Hs),Ra=n(e),r(gt.$$.fragment,e),ga=n(e),Kt=i(e,"P",{"data-svelte-h":!0}),o(Kt)!=="svelte-gdoalu"&&(Kt.textContent=Ps),Ka=n(e),r(ht.$$.fragment,e),ha=n(e),iA=i(e,"IMG",{src:!0}),Ma=n(e),Mt=i(e,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-scgizw"&&(Mt.innerHTML=Cs),Ia=n(e),r(It.$$.fragment,e),Ba=n(e),Bt=i(e,"P",{"data-svelte-h":!0}),o(Bt)!=="svelte-1dyodm3"&&(Bt.innerHTML=xs),ya=n(e),r(yt.$$.fragment,e),Xa=n(e),Xt=i(e,"P",{"data-svelte-h":!0}),o(Xt)!=="svelte-2wrr8h"&&(Xt.textContent=Js),Ha=n(e),r(Ht.$$.fragment,e),Pa=n(e),Pt=i(e,"P",{"data-svelte-h":!0}),o(Pt)!=="svelte-2870qv"&&(Pt.textContent=zs),Ta=n(e),r(Tt.$$.fragment,e),Ca=n(e),Ct=i(e,"P",{"data-svelte-h":!0}),o(Ct)!=="svelte-m1z6vm"&&(Ct.textContent=ks),xa=n(e),xt=i(e,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-mu78ou"&&(xt.textContent=Qs),Ja=n(e),r(Jt.$$.fragment,e),za=n(e),oA=i(e,"IMG",{src:!0}),ka=n(e),zt=i(e,"P",{"data-svelte-h":!0}),o(zt)!=="svelte-el0clj"&&(zt.textContent=vs),Qa=n(e),r(kt.$$.fragment,e),Sa=n(e),Qt=i(e,"P",{"data-svelte-h":!0}),o(Qt)!=="svelte-1ujsfz4"&&(Qt.innerHTML=Vs),va=n(e),St=i(e,"P",{"data-svelte-h":!0}),o(St)!=="svelte-1mbytej"&&(St.textContent=Zs),Va=n(e),r(vt.$$.fragment,e),Za=n(e),Vt=i(e,"P",{"data-svelte-h":!0}),o(Vt)!=="svelte-mtqwvc"&&(Vt.textContent=Gs),Ga=n(e),r(Zt.$$.fragment,e),Wa=n(e),r(Gt.$$.fragment,e),Na=n(e),Wt=i(e,"P",{"data-svelte-h":!0}),o(Wt)!=="svelte-4flvpc"&&(Wt.textContent=Ws),Da=n(e),r(Nt.$$.fragment,e),Oa=n(e),Dt=i(e,"P",{"data-svelte-h":!0}),o(Dt)!=="svelte-m1z6vm"&&(Dt.textContent=Ns),qa=n(e),Ot=i(e,"P",{"data-svelte-h":!0}),o(Ot)!=="svelte-mu78ou"&&(Ot.textContent=Ds),Ya=n(e),r(qt.$$.fragment,e),Ea=n(e),pA=i(e,"IMG",{src:!0}),La=n(e),Yt=i(e,"P",{"data-svelte-h":!0}),o(Yt)!=="svelte-steh6u"&&(Yt.innerHTML=qs),_a=n(e),r(Et.$$.fragment,e),$a=n(e),Lt=i(e,"P",{"data-svelte-h":!0}),o(Lt)!=="svelte-2eg4hd"&&(Lt.textContent=Ys),en=n(e),_t=i(e,"UL",{"data-svelte-h":!0}),o(_t)!=="svelte-5jmngg"&&(_t.innerHTML=Es),tn=n(e),$t=i(e,"P",{"data-svelte-h":!0}),o($t)!=="svelte-8xkgoe"&&($t.textContent=Ls),An=n(e),r(eA.$$.fragment,e),ln=n(e),uA=i(e,"P",{}),_s(uA).forEach(A),this.h()},h(){m(w,"name","hf:doc:metadata"),m(w,"content",pi),F(tA.src,Mn="data:image/jpeg;base64,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")||m(tA,"src",Mn),F(AA.src,Xn="data:image/jpeg;base64,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")||m(AA,"src",Xn),F(lA.src,Jn="data:image/jpeg;base64,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")||m(lA,"src",Jn),F(aA.src,En="data:image/jpeg;base64,/9j/4AAQSkZJRgABAQAAAQABAAD/2wBDAAgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0aHBwgJC4nICIsIxwcKDcpLDAxNDQ0Hyc5PTgyPC4zNDL/2wBDAQkJCQwLDBgNDRgyIRwhMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjL/wAARCAGdAiMDASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwD3+iiigAooooAKKK462ttW1rX/ABCq+JtSsYLK+S3hgtorYqFNvDIeXiYk7pG70AdjRXOf8I1qv/Q665/35s//AIxR/wAI1qv/AEOuuf8Afmz/APjFAHR0Vzn/AAjWq/8AQ665/wB+bP8A+MUf8I1qv/Q665/35s//AIxQB0dFc5/wjWq/9Drrn/fmz/8AjFH/AAjWq/8AQ665/wB+bP8A+MUAdHRXOf8ACNar/wBDrrn/AH5s/wD4xR/wjWq/9Drrn/fmz/8AjFAHR0Vzn/CNar/0Ouuf9+bP/wCMUf8ACNar/wBDrrn/AH5s/wD4xQB0dFc5/wAI1qv/AEOuuf8Afmz/APjFH/CNar/0Ouuf9+bP/wCMUAdHRXOf8I1qv/Q665/35s//AIxR/wAI1qv/AEOuuf8Afmz/APjFAHR0Vzn/AAjWq/8AQ665/wB+bP8A+MUf8I1qv/Q665/35s//AIxQB0dFc5/wjWq/9Drrn/fmz/8AjFH/AAjWq/8AQ665/wB+bP8A+MUAdHRXOf8ACNar/wBDrrn/AH5s/wD4xR/wjWq/9Drrn/fmz/8AjFAHR0Vzn/CNar/0Ouuf9+bP/wCMUf8ACNar/wBDrrn/AH5s/wD4xQB0dFc5/wAI1qv/AEOuuf8Afmz/APjFH/CNar/0Ouuf9+bP/wCMUAdHRXOf8I1qv/Q665/35s//AIxR/wAI1qv/AEOuuf8Afmz/APjFAHR0Vzn/AAjWq/8AQ665/wB+bP8A+MUf8I1qv/Q665/35s//AIxQB0dFc5/wjWq/9Drrn/fmz/8AjFH/AAjWq/8AQ665/wB+bP8A+MUAdHRXOf8ACNar/wBDrrn/AH5s/wD4xR/wjWq/9Drrn/fmz/8AjFAHR0Vzn/CNar/0Ouuf9+bP/wCMUf8ACNar/wBDrrn/AH5s/wD4xQB0dFc5/wAI1qv/AEOuuf8Afmz/APjFH/CNar/0Ouuf9+bP/wCMUAdHRXOf8I1qv/Q665/35s//AIxR/wAI1qv/AEOuuf8Afmz/APjFAHR0Vzn/AAjWq/8AQ665/wB+bP8A+MUf8I1qv/Q665/35s//AIxQB0dFc5/wjWq/9Drrn/fmz/8AjFH/AAjWq/8AQ665/wB+bP8A+MUAdHRXOf8ACNar/wBDrrn/AH5s/wD4xR/wjWq/9Drrn/fmz/8AjFAHR0Vzn/CNar/0Ouuf9+bP/wCMUf8ACNar/wBDrrn/AH5s/wD4xQB0dFc5/wAI1qv/AEOuuf8Afmz/APjFH/CNar/0Ouuf9+bP/wCMUAdHRXOf8I1qv/Q665/35s//AIxR/wAI1qv/AEOuuf8Afmz/APjFAHR0Vzn/AAjWq/8AQ665/wB+bP8A+MUf8I1qv/Q665/35s//AIxQB0dFc5/wjWq/9Drrn/fmz/8AjFH/AAjWq/8AQ665/wB+bP8A+MUAdHRXOf8ACNar/wBDrrn/AH5s/wD4xR/wjWq/9Drrn/fmz/8AjFAHR0Vzn/CNar/0Ouuf9+bP/wCMUf8ACNar/wBDrrn/AH5s/wD4xQB0dFc5/wAI1qv/AEOuuf8Afmz/APjFH/CNar/0Ouuf9+bP/wCMUAdHRXOf8I1qv/Q665/35s//AIxSeFJb77Vr9lfalcah9h1BYYZrhI1fYbeGTB8tVH3nbtQB0lFFFABWXrniHS/Ddn9r1W4eGDn5lheTAAyThATgDnNalcp8SNTsdO+H+ure3kNu11p9xBAJXC+ZIYmwq56k+lAHUxSJNEksZyjqGU46g9KxoPF2hXGr/wBlxX4a6MjQr+6cRtIuSyLIRsZhg5UEkYPHFR6H4l0W9sNKitNSguGukMcPktvDNGgLjI4BA9a4PTrmGTw54b8LISdfstYie5ttp8yIRzl5JW9FZQSG6HePWgD1uuc8Nf8AIe8Xf9hVP/SO2rY1GznvrQw2+oXNhISD59ssZce37xWX9K57wXbS2eo+KoJ72e9kTVVzcThA75tLc8hFVeOnAHSgDrKKKjnjaa3liSRomdCokXqpI6j6UASUVy3/AAj3iKHm28WzZHae1RwfxpPN8a6fy9vpuqRjtExhkP5/LWvsk9pL8vzMfatfFF/n+R1VFcxB43sUmW31e1utJnPAF1GdjfRxxj34rpIpop4llhkSSNhlXRgQR7EVMqco/Ei4VIz+Fj6KKKgsKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiq02o2Vv8A668gjPo0gBqjJ4o0eI4N6rH0RGb+QrKeIpQ+KSXzNYUKs/hi38jXorE/4Se2f/UWWoT/APXO3Jo/ty9f/VaFeH/roQlZ/XKPR39E3+Rp9UrdVb1aX5m3RWJ/aOuv9zQ1Qer3S0faPEbdLKxT/elJ/lR9aj0jL/wF/qg+rS6tf+BL/M26KxP+Knb/AKBaf9/CaPI8SHrd2C/SNjR9ZfSEvu/4IfV11nH7/wDgG3RWJ9k8Qnrqlsv0gzR9g189dajH0tVo+sS/59y/D/MPYR/5+R/H/I26KxP7N1w9dfA+lolH9laz38QP/wCAq/40e3qf8+n/AOS//JB7Cn/z8X/k3/yJt0Vif2Tq3fX5f/Adf8aP7H1Tvr8//flaPb1P+fb++P8AmHsaf/PxfdL/ACNuisT+xtS/6D1x/wB+lo/sbUf+g9c/9+1o9tV/59v74/5h7Gn/AM/F9z/yNuisT+xdR/6D1z/3wKP7F1D/AKDt1/3wKPbVf+fb+9f5h7Gl/wA/F9z/AMjborE/sS//AOg7d/8AfIo/sS+/6Dt3/wB8ij21X/n2/vX+Yexpf8/F9z/yNuisT+xL7/oO3f5Cj+xL7/oO3n5Cj21X/n2/vX+Yexpf8/F9z/yNuisT+xL7/oO3n5Cj+xL7/oO3n5Cj21X/AJ9v71/mHsaX/Pxfc/8AI26Ko6fYz2bSGa/mutwGBIB8v0q9W8JOUbyVjCaSdk7hXOeGv+Q94u/7Cqf+kdtXR1znhr/kPeLv+wqn/pHbVRJ0dFFFABRRRQAUUUUAFc54a/5D3i7/ALCqf+kdtXR1znhr/kPeLv8AsKp/6R21AHR0UUUAFFFFAEc9vBdQtDcQxzRN95JFDA/ga5mbwhJp8rXXhq+fTpSctbsS8Eh91PT6j8K6qirhUlHYidOM90cxZeLGt7pNP8RWv9m3jcJITmCb/dbt9D+ddP1GRVe+sLXUrV7W9gSeF+qOM/iPQ+9cqYNW8GHfa+dqehj70BOZrYeqn+JR6fy61fLGp8Oj7dPkZ806fxarv1+Z2VFVNO1K01ayS7sp1mhfoR2PoR2PtVusmmnZmyaaugooopDCiiigAooooAKKKKACiiigAooooAKKKKACiiigAooqlf6tY6av+kzqrHog5Y/gKmc4wXNJ2RUISm+WKuy7SMwVSzEADqTWH/aGsaj/AMeFiLSE/wDLa7+8foopV8OLcEPql7cXrddhbZGPoorn+sSn/Cjfzei/z/A39hGH8WVvJav/AC/EnufEemW7+WLjz5eyQDeT+XFQf2rq11/x5aO0anpJdvs/8d61q21nbWabba3jiH+woGanp+zrS+OdvRfq7/oHtKMfhhf1f6K36mH9h165/wCPjVIrde6W0Wf1PNL/AMIxbS83l3e3Z7iWY4/IVt0UfVKT+L3vVt/8APrdVfDp6JL/AIJmw+H9Jg+5YQH/AH13fzzV6OCGEYiiSMf7KgVJRWsKVOHwxS+RjOrOfxSbCiiitCAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACuc8Nf8h7xd/wBhVP8A0jtq6Ouc8Nf8h7xd/wBhVP8A0jtqAOjooooAKKKKACiiigArnPDX/Ie8Xf8AYVT/ANI7aujrnPDX/Ie8Xf8AYVT/ANI7agDo6KKKACiiigAooooAKKKKAOV1LQLvS719Z8N7Unbm5sScR3A9h2b/AD651tD120120MsG6OaM7ZreTh4m9CP61qVzeu+H52uxrWiOsGrRj5l6Jcr/AHHH8j/9YjZSVRcs9+j/AMzBxdN80Nuq/wAjpKKydB1+DXLVyqNBdwnZcWz8PE3ofb0Na1ZSi4uzNYyUldBRRRSKCiiigAooooAKKKKACiiigAoopGZUUs7BVAySTgAUALVO/wBUtNMjDXMoUn7qDlm+grNk1e61OVrfRUBQHD3kg+Rf90dzVvT9DtrKQ3EjNc3jfenl5b8PSuX28qmlFad3t8u/5eZ1exjT1rPXst/n2/PyKm7WdY+4Dploe7DMzD6fw1dsNEsdPbfFFvmPJmlO5yfr/hWjRVQw0U+afvS7v9Oi+RE8RJrlj7q7L9er+YUUUV0GAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAVznhr/kPeLv+wqn/pHbV0dc54a/5D3i7/sKp/6R21AHR0UUUAFFFFABRRRQAVznhr/kPeLv+wqn/pHbV0dc54a/5D3i7/sKp/6R21AHR0UUUAFFFFABRRRQAUUUUAFFFFAHN6/oVw10ut6KRFq0Iwyn7tyn9xvf0P8A9YjQ0LXLfXbDz4gY5kOyeB/vROOoNalctr2lXWn33/CRaImbtBi6th0uYx1/4EO3+c7RamuSW/R/oYSTpvnjt1X6/wBbnU0VS0nVbXWdOivrN90Ug6Hqp7qfQirtZNNOzNk01dBRRRSGFFFFABRRRQAUUVn6pq0WmoqBTNdS8RQJ95z/AEHvUTqRpx5pOyLhCU5csVqTX+oW2m2xnuZNq9AByWPoB3rJSyvNeYTakGt7HOUtFOGf3c/0qew0iV7kajqrCa8P3EH3IR6KPX3/AP11s1zqnKvrU0j27+v+X3nQ5xoaU9Zd+3p/n9wyKKOGJY4kVEUYVVGAKfRRXWlbRHI3fVhRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFc54a/5D3i7/sKp/wCkdtXR1znhr/kPeLv+wqn/AKR21AHR0UUUAFFFcz4hvdRl8QaRoOm3psGvI57ie6SNXdY4tg2qHBXJaReSDwDQB01Fc/4R1O81CwvYNQkWa70++lspJ1QIJtpBV9o4BKsuQOM5xXHab4u1efXbCKTVZHup9Uktbiwa0RbRIlZx+7uNvzOAAcB2JOQVHOAD1Guc8Nf8h7xd/wBhVP8A0jtq2NR1GDS7Q3Nwly8YIXFtbSTvz/sxqW/HFc94LvYtR1HxVdwJOkcmqrhZ4HhcYtLcco4DDp3HvQB1lFFFABRRRQAUUUUAFFFFABRRRQAUUUUAcdqlvL4T1V9csI2fTLhv+JhbIPuH/nqo/n/nHW29xFdW8dxBIskUihkdTkEGnuiyIyOoZWGCpGQR6VxtszeC9ZWxlY/2FeyH7NIx4tpD/AT/AHT2/wD1mt/4q/vL8f8AgmH8KV/sv8H/AJM7OiiisDcKKKKACiis3VtVGnxpHEnnXkx2wwjufU+wqKlSNOLlLYunTlUkox3E1XVhY7LeCPz76biKEfzPoKTStJNo7Xd2/n38v+slPRf9lfQUaTpRsy91dP51/NzLKe3+yvoK1Kwp05VJe1q/Jdv+D+XQ2qVIwj7Ol833/wCB+YUUUV1HMFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFc54a/5D3i7/sKp/wCkdtXR1znhr/kPeLv+wqn/AKR21AHR0UUUAFYmu6FPqV5YajYXwsdRsTIIpXh81GRwA6Mm5SQdqngggqK26KAMDRvDt1owgEeqtKGmnudQ3wLm7lk53A5+QKegGeMDtmsu18DXVvFYadJrfmaLYXa3cFt9kAmyj70Vpd2CobHRQTjk12dFABXOeGv+Q94u/wCwqn/pHbV0dc54a/5D3i7/ALCqf+kdtQB0dFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFVdS0621XT5rK7j3wyrgjuPQj3FWqKabTuhNJqzOW8N6jc2F6/hrVpN11Au61nb/AJeIe3/Ah3+nsTXU1i+JNDOs2SPbyeTqNq3m2s46q47H2Pel8Oa4NasGMyeTfW7eVdQHqjj+h7f/AFq1mlNe0Xz/AK8zKDcH7N/L+vI2aKKhurqGytZLidwkcYyTWDairs3SbdkQapqUWmWhlcF5GO2KNert2AqrpGmSxSPqF+Q9/MOfSJf7oqHS7WbUbv8Atm/QqSMWsJ/5Zp6/U/59t2uWnF1pKrLZbL9X59uyOmo1Ri6Ud3u/0Xl37sKKKK6zlCiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigArnPDX/Ie8Xf8AYVT/ANI7aujrnPDX/Ie8Xf8AYVT/ANI7agDo6KKKACiiigAooooAK5zw1/yHvF3/AGFU/wDSO2ro65zw1/yHvF3/AGFU/wDSO2oA6OiiigAooooAKKKKACiiigAooooAKKKKACiiigArlPEdnPpGoL4n02Mu8a7b6Bf+W0X97/eX+ntz1dBAIIIyDVwnyO5FSHOrEFne29/ZRXltIHglXerD0rEUHxHqXmH/AJBdq/yjtPIO/wBBXPXCf2Dq8+hQXyQaXfyoQDnNuz53ID2Bx+v1Nd9bW8VpbR28KBY4xtUCuSrFVqnLH4F+L7fLr56dzqoydGnzS+N/gu/z6eWvYloooroMAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACuc8Nf8h7xd/2FU/9I7aujrnPDX/Ie8Xf9hVP/SO2oA6OiiigAooooAKKKKACuc8Nf8h7xd/2FU/9I7aujrnPDX/Ie8Xf9hVP/SO2oA6OiiigAooooAKKKKACiiigAooooAKKKKACiiigAqhq+pDTbIyBd87nZDGOruegq8zKiM7EKqjJJ6AVg6YrazqTavMp+zxZjs0Pp3f8f89K569SStTh8T/BdX8vzN6EIu9Sfwr8ey+f5AnhmC60K4stR/ez3nzzy9w/Yj6dv/r1D4X1S5Ek2g6q3/EysRgOf+W8X8Lj17Zrpa53xRpFxcpDq2mfLqtgd8X/AE1X+KM+uRn/ACa6sPGMIex6dPX/AIPX7zlxEpSn7br19P8AgdPuOiorP0XV7fXNKhvrfgOMOh6ow6qfpWhSacXZlRakroKKKKQwooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAK5zw1/yHvF3/YVT/wBI7aujrnPDX/Ie8Xf9hVP/AEjtqAOjooooAKKKz9X1zTtDhil1Ccx+c/lxIkbyvI2CcKiAs3AJ4FAGhRVXTdSs9XsIr6wnWe2lztdcjocEEHkEEEEHkEVRTxRpEurHTIbiWW5WQxMYraV41cdVaQLsDD0LZoA2K5zw1/yHvF3/AGFU/wDSO2ro65zw1/yHvF3/AGFU/wDSO2oA6OiiigAooooAKKKKACiiigAooooAKKKKACiiqmpX8em2Et1JztHyr/ebsKmclCLlLZFRi5yUY7szdZlfUbyPRLdiN433Tj+CP0+praiiSCJIo1CogCqo7AVm6HYSWts9xdc3t03mTH09F/CtWsMPFu9We8vwXRf5+ZtXklalDZfi+r/y8gooorpOc47UFPhHxB/a0QI0i/cLeoOkMh6SfQ9//wBVdgrBlDKQQRkEd6iu7WG+tJbW5jEkMqlHU9wa5nw3dT6PqL+F9QkLGJd9hM3/AC1h/u/Vf6e1bP8AeRv1X4r/AIBgv3crdH+D/wCCdZRRRWJuFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABXOeGv+Q94u/wCwqn/pHbV0dc54a/5D3i7/ALCqf+kdtQB0dFFFABXH+KLqDSPGXh3WNRkWHTIobu3e4k4SGV/LKFj0XIRxk+uO9dhRQBxXgrUbWMXe9zGNZ1S7utORkYGWIbcuOOASCwzjIbPeuP8AC7zaTbaNYQ6vfv4lj1Uw32mNKxQQGZvMYxfdC7CXEnUkjk5xXstFAFTUbOe+tDDb6hc2EhIPn2yxlx7fvFZf0rnvBdtLZ6j4qgnvZ72RNVXNxOEDvm0tzyEVV46cAdK6yuc8Nf8AIe8Xf9hVP/SO2oA6OiiigAooooAKKKKACiiigAooooAKKKKACsAf8TvX89bHT2/CSb/63+etW9dv5LSzWK25vLlvKhHuep/CrOmWEem6fFax87R8zf3m7muWp+9qKn0Wr/Rfq/l3Oqn+6pup1ei/V/ovn2LdFFFdRyhRRRQAVi+JdEbWLBXtn8rUbVvNtJhwVcdvoelbVFVGTi7omUVJcrMjw5ra65pvmunlXcLGK5hPBjkHUY9PSteuR1+CXw9q6+JrJGaBgI9ShX+JO0gHqP8APeuqgniubeOeFxJFIoZHXoQehq6kV8Udn/ViKcn8Et1+PmSUUUVkahRRRQAUUUUAFFFMlcRRPIRkKCcUAPoquBdMoJkiXPbYTj9aXZdf89Yv++D/AI0AT0VBsuv+esX/AHwf8aNl1/z1i/74P+NAE9FQbLr/AJ6xf98H/GjZdf8APWL/AL4P+NAE9FQbLr/nrF/3wf8AGjZdf89Yv++D/jQBPRUGy6/56xf98H/GjZdf89Yv++D/AI0AT0VBsuv+esX/AHwf8aNl1/z1i/74P+NAE9FQbLr/AJ6xf98H/GjZdf8APWL/AL4P+NAE9FQbLr/nrF/3wf8AGjZdf89Yv++D/jQBPRUGy6/56xf98H/GjZdf89Yv++D/AI0AT0VBsuv+esX/AHwf8aNl1/z1i/74P+NAE9FQbLr/AJ6xf98H/GjZdf8APWL/AL4P+NAE9FQbLr/nrF/3wf8AGjZdf89Yv++D/jQBPRUGy6/56xf98H/GjZdf89Yv++D/AI0AT0VBsuv+esX/AHwf8aNl1/z1i/74P+NAE9FQbLr/AJ6xf98H/GjZdf8APWL/AL4P+NAE9c54a/5D3i7/ALCqf+kdtW7DJIZHil2llAIK9CD/APqrC8Nf8h7xd/2FU/8ASO2oA6OiiigAooooAKKKKACuc8Nf8h7xd/2FU/8ASO2ro65zw1/yHvF3/YVT/wBI7agDo6KKKACiiigAooooAKKKKACiiigAoJABJOAO9FY3iC4keOHS7Y4uL07Mj+BP4j+X9azrVFTg5P8Ap9EaUqbqTUURaWDq2rTau4zBHmG0B9P4m/Gt6ora3jtLaO3hXEcahVFS1NCm6cLS3er9f6/AqvUVSd1stF6BRRRWxiFFFFABRRRQA2SNJY2jkUMjgqysMgg9Qa5HR5H8La5/YFwxOnXRMmnSsfun+KIn+X/167CszX9Fi13SpLSRtkgO+GUdY5B0YVpTkl7stn/VzKpBv3o7r+rGnRWD4Y1qXUbaWyv18vVbJvKuU/vejj2P+e1b1TOLi7MuElOPMgoooqSgooooAKhu/wDjzm/3DU1Q3f8Ax5zf7hoAoat4i0vQVg/tK58jzgfL/ds2cYz90H1FZn/Cw/C//QTP/gPJ/wDE104AKjI7UbR6CtIunbVP7/8AgGclUv7rVvT/AIJzH/Cw/C//AEEz/wCA8n/xNH/Cw/C//QTP/gPJ/wDE10+0ego2j0FO9L+V/f8A8Anlq/zL7n/mVtO1G11axjvbKXzbeTO19pXOCQeCM9Qay/FPiQeG7WzcQRSyXdyLaM3FwIIUJVmy8hB2j5cDg5JAre6Vm61Y39/aLFY3ltbHd+8FzafaI5Fx0K7l/nWbtfQ1V7amKfFWrSXsGnWuhQXGofZvtdyiagPKiiLsqbZNnzs21iBhRxyRVO28f3d/ZeHZLHQTJc62LgpDJdBBD5R/jbaeCPQcdMGk034f3WhSJcaPri2t1Ijx3RNkGidWkaQCOMMBHtLvt5YYPINM8FeGbiLRfC91dPPbzaUl2jQTxEO/mOQCScY4APTnNIZa8N614lv/ABZrtlqFlZLZWlzHH8l2WaDNuj7VHlDeCWySSMbiBkAZ6q+uHtLCe4jjSR4kLhXkEanA7seFHvWE+ny6Brmp6+L/AP4l140ct3aLYPPLvWNYlMZQ5x8q5Gxuh6doNSu9L8caVd6BDJqNu9xGCJJtMniVdrBhkyIqkZAyueRkUAZM3joax4f8U2kT2kOoWWlS3KTabqIuUwUcAiRQpV1K9CBjIIJq8nirVlv7XRNO0YajdLpEF+88155SncWUqTtY7spkeuTnGMlP+EFvLibVri+1mKSbUNJbTMQWIijhB3YZV3kn73Qnn1AwBWfQNbTx276XqDWSw6Da2ouZbPzYZSJZsjG5fnHyn73G7kHNAEcniq/1PxD4Yu9FtZpkv9NvHaymuPJjV1eEEyEBuVO9chW5PHBJrW/4TJ38Lx6ulpZ28guJLa4i1DUFt44JI2ZGBk2nPzIcYHIOeKm0rwdDpF7os1vdu0emWU9rtkTLTNK0btIWzwcoTjH8XbFUZPAkqLay2uqRLd2uo3d9G09n5sX+kMzFSm8ZK7sBgw6dOcUAbPhbxJb+KNHN/AqKUmeCVY5llQOhwdrrwyngg+h7VD4g8RXek6tpOmWOli+udS84JuuPKWPy1DZY7TxgnkDPHQ5qjpcdr4DtLiDUL29vpb+8lvPNg02WTBbbkERKwXnpnHt0qhq73PibxP4bvdCkvbUWhuw9zcabKqIxjTAdJAhKkEjqOehyKALU3jyeLTrdl0R31J9W/smazFwMRS7C4YPjDLjac4HDeoxUlx4u1iOe8t7fw9Fcz6bCsuoKl/hULAsEiJj/AHjbQG5CjkDNSW/gpo4rN5tSM15Hq/8Aa11P5O0TyeW0e0Ln5AFKgcnhe+c0/VfCt9canqF3pWtf2cupwrFeI1sJi20FQ8Z3DY204yQw4HFADT4xmvruGHQNKOpIbGK/mdrgQ7Ipc+WFBU7nYKxwdo45IzUvw8u57/4f6JdXU8s88tsGeSZizscnkk8k1EfB01jdwzeH9V/s1BYxWEyPbibfFFnyypLDa6hmGTkc8g4rV8MaJ/wjfhnT9GFwbgWcQi80pt3474ycfnQBrUUUUAFFFFABRRRQAUUUUAFFFFAECf8AH9L/ALi/zNYfhr/kPeLv+wqn/pHbVuJ/x/S/7i/zNYfhr/kPeLv+wqn/AKR21AHR0UUUAFFFFABRRRQAVznhr/kPeLv+wqn/AKR21dHXOeGv+Q94u/7Cqf8ApHbUAdHRRRQAUUUUAFFFFABRRRQAUUUUANd1jRndgqqMknsKxNDRr+6uNamBHnfu7dT/AAxg/wBTTtfle5a30eBiJLs5kI/giHU/j0rYiiSCFIo1CoihVA7AVyv97W8ofn/wF+fkdX8KjfrL8v8Agv8AIfRRRXUcoUUUUAFFFFABRRRQAUUUUAcv4n064tbmLxHpSZvbRcTxD/l4h7qfcdR/+qt7TdRttW06G+tH3wzLuB7j1B9weKtVxrf8UZr5kHy6FqUnzeltMe/sp/z052j+8jy9Vt/l/kYS/dy5uj3/AM/8zsqKKKxNwooooAKhu/8Ajzm/3DU1Q3f/AB5zf7hoAlX7o+lLVC+/tTbF/Zv2TofM+0bvbGMfjVP/AIqf/qE/+RKwnX5ZW5W/RG0KPMr8yXzNuisT/ip/+oT/AORKP+Kn/wCoT/5EqfrP9yX3FfV/78fvNuioLP7V9lT7b5P2jnd5OdvXjGeemKwfGVvqN1ZWUen3QjIuQ09ut6bSS5jCt8iSqMqclW4xkLjIroi7pMwkrOx0tFeWaRqVvr+sjT5tX1fTbCxsXkRZNRIkadZ5ElLTBj5qx7VxkkYbmoNBuNR1zTvAcE+t6j5d5HfNdSxXLxvcBT8uWByO3TkDgYpiPVYrq3mmnhiniklgYLMiOC0ZIDAMOxIIPPYg1LXA+EtFtLXx34qkW6v2lt7uEIkuoTOGDWsfLqWw/JOCwOMADGBjd8c6hdaZ4N1C7s5jBKojUzqMmFGkVXkH+6pZvwoA6GivMNXuZtFXxPYaTrV9dWyeGp73zJbxp3tpwGCMshJZdwycZ/gyMVb36j4e1bSza39/qEt/o93PLDdTtKsk8SxMjKp4TJdhhcDkcUAeiUV5f4OfxBdXGg6ob+B4LtS12Zdbe4+0gxkkJAY1WNg2DhSMAMDmu78TzSW/hPWZoZHjljsZ3R0YhlYRkggjoRQBq1DLcxwzQROJC07FE2xMwBALfMQMKMA8nAzgdSBXnFpp96NV8K2r6/rDxavpsst+GvHzIyLEylDnMXLnOzGR+dP0nU9RNx4atJL+6lWLX9RsHd5SWniiS4CCQ/xY2r17qD1oA9KorynTpNQg0DSNfbWdTlupfEH2Ro5LpmiMD3jQlChODhTkE8jAAOABU2p6/PaeDfFRfVZYr2LW3ghzcESIpljKovOQNp4A7Z7UAeoUV55qk9xpXiuXUdTury5097+CK2ex1RkFtu2II5LbID5ckk/McN0GK9DJwM0AFVdP1K01S3eeyl82NJpIGbaVw6MUccgdGUivLtK8Q3b+IvDOoWklxHYa1cyJ5d1rDXLyxmN2BMBXbFhlX7rcdCOeGR3Dx2WhWx1W4062u/FOowzyQTGIupe4whI9SAPY4IwQDQB6pf6laaZHDJeS+Ws08dvGdpOZHYKo4HckDPSrVeS6m089peaRDqd1cWdp4m0+C1vJJfNlj3NEzpvbO4ozHBOSM4OcVp3OpHw1L4tsprzU7mwtbeylhD3jNMjzs8ZAlckquVU5J+XJIoA9Horz7wXf6hF4y1bRLqQmGOzhuVhbU3vzC7M4I8x1DDICnac46g81qfEu9n0/wJeXNvfS2Ei3FqPtMTbWjU3EYY59ME5HQjINAHW0V5brd3caNF4rstK1q+ubdPDz3vmSXjTPbT/MFKyE5XcATjPG3IxWheWUlrqvh3SLnXNUS11GOaa6uDfSI80yIm2NXBHlg7nbam0HZ9aAPQqq2upWl7c3tvby75bKUQ3C7SNjlFcDkc/KynjPWvN7bU7y9h0zSbjWbsaVJrd1ZjUUuCks8UaM0aecMHlgV3Agt5fXJNbPw8Ea6j4uSG9kvY01YIs8j72IEEQwW7kY25PJxzzQB2Sf8f0v+4v8zWH4a/5D3i7/ALCqf+kdtW4n/H9L/uL/ADNYfhr/AJD3i7/sKp/6R21AHR0UUUAFFFFABRRRQAVznhr/AJD3i7/sKp/6R21dHXOeGv8AkPeLv+wqn/pHbUAdHRRRQAUUUUAFFFFABRRRQAU2SRYo2kdgqKCzE9gKdWHr8j3T2+jwMRJdtmUj+GIdT+NZVqns4OXXp69DWjT9pNR6dfTqGgxteTXOszKQ1ydsIP8ADEOn51uU2KNIYkijUKiKFUDsBTqKNP2cFF79fXqFap7Sbl06enQKKKK1MgooooAKKKKACiiigAooooAKrX9jb6nYzWd1GHgmXay/1HvVmimnZ3Qmk1ZnK+G7640y+fwzqkhaeFd1nO3/AC3h7f8AAh/T2zXVVi+JNDOs2SNbyeTqFs3m2s46o47H2Pel8Oa5/bViwmj8m/tm8q6gPVHHf6HtWs1zr2i+f9eZjTbg/Zv5f5fI2aKKKxNwqG7/AOPOb/cNTUjKHUqwyCMEUAC/dH0pari2dRhbmUAdBwf6UvkSf8/Mv5L/AIUAT0VB5En/AD8y/kv+FHkSf8/Mv5L/AIUAT1U1DS9O1aAQalYWt7CDuEdzCsig+uGBFSeRJ/z8y/kv+FHkSf8APzL+S/4UAVZvD+i3FvbW82kWEsFqc28b2yMsJ/2ARhfwqt4f8OW+h6TY2chiup7PzfKuWhCsu9ix28kr1AODzitPyJP+fmX8l/wo8iT/AJ+ZfyX/AAoApajo0M051GytNNTWkXbBfXNoJWjHQjIKtjBI4YdfwqKwtvEJnZdXvdJubRkKtFb2EkbEn1LSuMdeMVpeRJ/z8y/kv+FHkSf8/Mv5L/hQBWttB0eysriytdJsYLS4BE8EVuipKCMEMoGDkcc1aNnameCY20JlgVkhfYN0anGQp7A7RkD0HpSeRJ/z8y/kv+FHkSf8/Mv5L/hQBRbw/p1vPcX+m6ZpltqsittuzZqW3EdWK4Zh6jcM+tVray8SSzCPVr7RbqwdWWeCLTpEZ1IIxlpmGPXKnIyK1/Ik/wCfmX8l/wAKPIk/5+ZfyX/CgAFjaCS3kFrAHtkKQMIxmJTgEKf4QcDgegpiaZp8bxuljbK0czzowiUFZHzvcccM25snqcnPWn+RJ/z8y/kv+FHkSf8APzL+S/4UAMGmaettHbCxthBHL5yRCJdqybt+8DGA275s9c89aguNA0a8u3u7nSLCe5dQrzS2yM7AdAWIyRwPyq15En/PzL+S/wCFHkSf8/Mv5L/hQBVbQdIbUv7T/sqw/tEci7NshlB/38Z/WqMFt4vFxEbjVdDeAOPMWPTZVYrnkAmcgHHfB+lbHkSf8/Mv5L/hR5En/PzL+S/4UAVIfD2iW90bmDR9PiuDL5xlS2RXMmCN+QM7sMwz15PrVPU/CljqN1pbeVbx21ldTXMtt9nUpcGSORGBHTkyFiSDk/XNa/kSf8/Mv5L/AIUeRJ/z8y/kv+FAEMWj6Zb2cNnDp1nHawuJIoEgUJG4OQyqBgEHkEd6kk06xma4aWzt3a5QRzlolJlQZwrcfMBubAPqfWneRJ/z8y/kv+FHkSf8/Mv5L/hQBnNocWnWpHhyz0nTbraI1kNkCgTJJXajIcZJPXGTmsy/8P6/rmnS2Gr6rphgaSCVTa6fIjBo5kkwd0zAghCPxz2wek8iT/n5l/Jf8KPIk/5+ZfyX/CgCtBoOj2tncWdvpNjDa3OfPgjt0VJcjB3KBhsj1qa+0yw1O0+yX9jbXdtkHyZ4lkTjp8pGKf5En/PzL+S/4UeRJ/z8y/kv+FAEUukaZcaaNNm060ksAAotXhUxADoNhGP0p9np1jpyOljZ29qrkFlgiVAxChRnA5wAB9ABTvIk/wCfmX8l/wAKPIk/5+ZfyX/CgAT/AI/pf9xf5msPw1/yHvF3/YVT/wBI7at+KERFjuZmbqzdawPDX/Ie8Xf9hVP/AEjtqAOjooooAK5TxI09/wCKdD0EXl1a2lzDc3Vw1rM0UknleWFQOuGAzJk4I+6K6usnWtAg1prWY3N1Z3do7Nb3VqyiSPcMMPmDKQR1BB6D0oAz/Bl5cPp2p2t5dSXP9m6jPaJcTHLvGuGUse5AbBPfbmuPtPG9prHj3Qr6PxLbJY3Uk8EWnpeqBsCYjaVAf9Y7ngHkDaMZzXeab4ZttJFmtrd3oW3eaSRWmyLqSU5Z5ePmbOSOmM+nFTXWgWN1q+nakylJrAyGJUChW3rtO7jJx2wRQBZ1G8nsbQzW+n3N/ICB5Fs0Yc+/7xlX9a57wXcy3mo+Kp57KeykfVVzbzlC6YtLcclGZeevBPWusrnPDX/Ie8Xf9hVP/SO2oA6OiiigAooooAKKKKACiiigBGZURnYgKoySewrD0FWvbi61mUHNw2yAH+GIf4n+VO8QzPLHBpUDYmvW2sR/DGPvH/PvWxDClvBHDEu2ONQqj0Arlf72vbpD83/kvzOlfu6N+svyX+b/ACH0UUV1HMFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFcr4j0+506+TxLpMZa4hXbdwL/AMvEXf8A4EP6e2K6qirhNwdyJwU1Yq6dqFtqthDe2kgeGVcqe49QfcVarjLhW8FaybyJT/YN9J/pCKOLWU/xgf3T3/8A1CuyVldFdGDKwyCDkEU6kEtY7MVOblpLdC0UUVmaBRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABXOeGv8AkPeLv+wqn/pHbV0dc54a/wCQ94u/7Cqf+kdtQB0dFFFABRRRQAUUUUAFc54a/wCQ94u/7Cqf+kdtXR1znhr/AJD3i7/sKp/6R21AHR0UUUAFFFFABRRRQAUE4GT0orH8Q3MiWSWduf8ASbxvJT2B+8fy/nWdWoqcHN9DSlTdSagupFoo/tHUrvWG5Rj5Ftn+4Op/E/1rdqG0to7O0itohhI1CipqmhTdOCUt936vcqvUU5trbZei2CiiitjEKKKKACiiigAooooAKKKKACiiigAooooAKKKKAIri3hu7aS3uI1khkUq6MOCDXKaTcTeFdVTQL+Rn0+cn+zrlz0/6ZMfX0/yB2FUdY0m11vTZbG7XKPyrD7yN2Ye4rSnNL3ZbP+rmVSDfvR3X9WL1Fcx4e1e6tr1vD2tN/wATCFcwTnpdR9mH+0O//wCuunpTg4OzKhNTV0FFFFQWFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAVznhr/kPeLv8AsKp/6R21dHXOeGv+Q94u/wCwqn/pHbUAdHRRRQAUUUUAFFFFABXOeGv+Q94u/wCwqn/pHbV0dc54a/5D3i7/ALCqf+kdtQB0dFFFABRRRQAUUUUAFYNh/wATTxBc6geYLX/R4PQt/E39Pxq5rt81jpbtFzcSkRQgdS7cD/Gp9LsV07TYLVcHYvzH1bqT+dcs/wB5WUOkdX69P8/uOmH7ui59ZaL06/5feW6KKK6jmCiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKAMjxBoMWuWaqJDBeQN5ltcr96J/8PUVX8Oa9LfGXTdSQQavacTR9pB2dfUGt+sLxFoDamIr2xl+zata/Nbzjv/sN6qf6/XOsJJrklt08v+AYzi4vnhv1Xf8A4Ju0VieHtfXWIZILiL7NqVsdlzbN1U+o9VNbdRKLi7M0jJSV0FFFFSUFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABXOeGv8AkPeLv+wqn/pHbV0dc54a/wCQ94u/7Cqf+kdtQB0dFFFABRRRQAUUUUAFc54a/wCQ94u/7Cqf+kdtXR1znhr/AJD3i7/sKp/6R21AHR0UUUAFFFFABRRVTU75dO02e6bH7tflHq3QD86mclCLlLZFRi5SUVuzM/5Cnij1ttOX8DK3+A/UVvVm6FYtY6XGJcm4lJlmJ6lm5P8AhWlWOGi1DnlvLV/5fJaG2IknPljtHRf5/N6hRRRXQc4UUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAc/4g0CW8lj1TS5Bb6xbj93J/DKv9x/UGp/D/AIgi1qB0eM29/bnZc2r/AHo2/qPetmuf1/w/JeTpqulSi21iAfJJ/DKP7j+oraMlJck/k/66GMouD54fNf11/M6CisTQPEMesLJbzxG11K34uLV+qn1HqvvW3WcouLszSMlJXQUUUVJQUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAVznhr/kPeLv+wqn/AKR21dHXOeGv+Q94u/7Cqf8ApHbUAdHRRRQAVk61r8GitaQm2ury7u3Zbe1tVVpJNoyx+YqoAHUkjqPWtauU8SLPYeKdD14Wd1dWltDc2twtrC00kfm+WVcIuWIzHg4B+8KANvRtYtdd04XlqJEAd4pIpl2yRSKSrIw7EEEVnW/i6F9RtbO70nVNPF5IYrae7hVUlcKW28MWUkKSAwXOKo+EXubMzm602+hbWtRuryNWi4t4/lC+af4GYAED1JHUVnabq58R+LILvVNO1m0htJmXTbSXS7hVD4KmeWQpsBIJCjOFBJPJ4APQK5zw1/yHvF3/AGFU/wDSO2rY1HToNUtDbXD3KRkhs21zJA/H+1Gwb8M1z3guyi07UfFVpA87xx6quGnneZzm0tzy7ksevc+1AHWUUUUAFFFFABWFqX/Ez16000cw2/8ApNx6E/wr/n1rZnmS3t5J5DhI1LMfYVk+HIXa1m1GcYnvn80+yfwj8v51y1/flGj31fov83b8Tpoe5GVXtovV/wCSv+BtUUUV1HMFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAYWv8Ah0ao8d9ZTfZNWt+YLle/+y3qp/z3BZoXiNr24bS9UhFnq8I+eE/dlH95D3FdBWTrnh+0123USlormI7oLmPh4m9QfT2rWM01yz279v8AgGMoNPnhv27/APBNaiuV07xDdaXeJpHiULHO3FvfAYiuB7n+Fv8APpnqqmcHB6lwmprQKKKKgsKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigArnPDX/Ie8Xf9hVP/SO2ro65zw1/yHvF3/YVT/0jtqAOjooooAKKKKACiiigArnPDX/Ie8Xf9hVP/SO2ro65zw1/yHvF3/YVT/0jtqAOjooooAKKKKAMPxAzXT2mkRkhrp8ykdo15NbaKqIqKAFUYAHYVh6L/wATDUr3V25Rj5Fv/uL1P4n+tbtcuH99yrd9vRbffq/mdOI9xRpdt/V7/dovkFFFFdRzBRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQBV1DTrTVbN7S9gWaF+qt29wex965cTap4LIS483UtBHCzAZmtR/tf3lHr/LpXZUEAggjINaQqcqs9UZzp8z5lo+5BZ3ttqFql1aTpNC4yrocip65W88M3OmXT6j4YlS2mY5lsn/ANRN+H8J+n6Vb0fxTbajcGwvIn0/VE4e1n4J90P8Qpyp3XNDVfiiY1bPlno/wZv0UUVkbBRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAVznhr/kPeLv8AsKp/6R21dHXOeGv+Q94u/wCwqn/pHbUAdHRRRQAUUUUAFFFFABXOeGv+Q94u/wCwqn/pHbV0dc54a/5D3i7/ALCqf+kdtQB0dFFFABWT4hu3t9MMMH/HxdMIIh7t1P5VrVhR/wDEz8UvJ1g05di+hlbr+Q4rmxMnyckd5af5v5K50YaK5+eW0df8vvZrWVoljZQ2sf3YkC59fU1PRRXRGKilFbIwlJybb3CiiimIKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigArN1jQtP1y3EV9AGK/ckXh4z6q3atKimpOLuhSipKzOQE3iHwtxOsmtaUv/LVB/pMQ9x/H/npW/pWt6drdv51hdJKB95ejJ9R1FaFYOq+E7DUbj7ZbtJYagOVurU7Wz/tDo3+ea15oT+LR91/l/kY8s4fBquz/AEf+ZvUVyX9reIfD/wAusWX9pWY/5fbJfnA9Xj/w4rd0rXNN1qLzNPu45sDLIDhl+qnkVMqUoq+67lxqxk7bPszQooorM0CiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAK5zw1/yHvF3/YVT/wBI7aujrnPDX/Ie8Xf9hVP/AEjtqAOjooooAKKKKACiiigArnPDX/Ie8Xf9hVP/AEjtq6Ouc8Nf8h7xd/2FU/8ASO2oA6OiiigCpqd6unabPdNj92uVB7t0A/OoNBsmsdKjWXPny5llJ6lm5Of5fhVTVf8AiY63Y6YOYo/9Jn+g4UfnW7XLD95Wc+kdF67v9F950z/d0VHrLV+nT9X9wUUUV1HMFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAVh6p4S0nVJvtDQtbXgORc2reXID65HX8a3KKqMpRd4smUIyVpK5yfleLdE/1UsGuWq/wynypwPr0P481Pa+N9LeYW+oCfS7rvFeRlB+DdMe/FdLUN1Z219CYbu3injPVJEDD9a09pGXxr7tP+AZ+zlH4Jffr/AMEfHLHNGskTq6NyGU5B/Gn1y8ngeyhkabR7y80qU8/6PKShPup6/Sm/8Vnpnew1mIf9sJT/AOy0ezi/hl9+n/A/EPaSj8Ufu1/4P4HVUVyo8bw2h26xpWo6ae7vCXj/AAZev5Vr2XiPRtRwLTU7aRj0TzAG/wC+TzUypTjq0VGtCWiZp0UUVmaBRRRQAUUUUAFFFFABRRRQAUUUUAFc54a/5D3i7/sKp/6R21dHXOeGv+Q94u/7Cqf+kdtQB0dFFFABRRXH+KLWDV/GXh3R9RjE2mSw3dw9u/KTSp5YQMOjYDucH0z2oA7CiuU8Bkxafqtijs1rY6rcW1ruYttiBBCAnspLKPQLjtXH6Vaww+HfCXiiMEa9qGqQrd3O475hK7LLG3qqjOF6LsGMYoA9brnPDX/Ie8Xf9hVP/SO2rY1G8nsbQzW+n3N/ICB5Fs0Yc+/7xlX9a57wXcy3mo+Kp57KeykfVVzbzlC6YtLcclGZeevBPWgDrKQkAEk4A6mlpksazRPE4JR1Ktg44NJ3toNb6mN4dBujeas45u5SI89o14FblRW1tFZ20dvCu2ONdqipayoU3TpqL36+vX8TSvUVSo5Lbp6dPwCiiitjIKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAIyMHpWTe+F9D1HJudLtmY9WVNjH8Vwa1qKcZOOqdiZRjJWkrnLf8INbW/Omapqmn46LFcEp+R6/nR/ZXi60/49vEFrdqOi3dqF/Vea6mitPbT66+qM/YQW2no7HLf2j4ytf9foVjeAdTa3Xl/wDodH/CX3cH/H74Y1eL1MMQlA/EEV1NFHtIveK/EPZyW0n+By4+IGgqdtzLc2jek9s4P6A1ch8Y+HZ/uavaj/ffZ/6FitsqGGGAIPY1Tm0fS7n/AF+m2cuf78Cn+YovSfR/f/wAtVXVfd/wQi1jTJ/9TqNpJ/uTqf5GraurjKMGHqDmsWXwd4dm+9pFqP8AcXb/ACxVRvh94aJ3JYvE3rHPIP60Wpd393/BC9bsvvf+R09Fct/wgenL/qb7VYP+ud2R/Oj/AIQyRP8AU+JteX2a63D+VHJT/m/AOep/L+J1NFZWj6Rc6Y0xn1a7v1cAKLjB2Yz0+v8AStWs5JJ2TuaRbau1YK5zw1/yHvF3/YVT/wBI7aujrnPDX/Ie8Xf9hVP/AEjtqRR0dFFFABWfq+h6drkMUWoQNJ5L+ZE6SvFJG2CMq6EMvBI4NaFFAGVaeHNJsfsH2WzEX9niQWwV2wnmffJ5+YnqS2TnnrUNt4R0K01b+04LELdCR5V/euY0ds7nWMnYrHJyQATk+tbdFABXOeGv+Q94u/7Cqf8ApHbV0dcudC8Q2msard6VrOmwwahcLcGK5055WRhFHHjcsyDGIwenegDqKK5z7F4z/wCg9of/AIJ5f/kmkaz8ZhSf7e0Pgf8AQHl/+SaAOkori9Bn8Z654d03Vv7Y0OH7bax3Hlf2TK2zeobGftAzjPXFaP2Lxn/0HtD/APBPL/8AJNAHR0Vzn2Lxn/0HtD/8E8v/AMk0fYvGf/Qe0P8A8E8v/wAk0AdHRXOfYvGf/Qe0P/wTy/8AyTR9i8Z/9B7Q/wDwTy//ACTQB0dFc59i8Z/9B7Q//BPL/wDJNH2Lxn/0HtD/APBPL/8AJNAHR0Vzn2Lxn/0HtD/8E8v/AMk0fYvGf/Qe0P8A8E8v/wAk0AdHRXOfYvGf/Qe0P/wTy/8AyTWbDceM5vEd7pH9saGPs1rBc+b/AGTL83mNKu3H2jjHldc87vbkA7Wiuc+xeM/+g9of/gnl/wDkmj7F4z/6D2h/+CeX/wCSaAOjornPsXjP/oPaH/4J5f8A5Jo+xeM/+g9of/gnl/8AkmgDo6K5z7F4z/6D2h/+CeX/AOSaPsXjP/oPaH/4J5f/AJJoA6Oiuc+xeM/+g9of/gnl/wDkmj7F4z/6D2h/+CeX/wCSaAOjornPsXjP/oPaH/4J5f8A5Jo+xeM/+g9of/gnl/8AkmgDo6K4rUrjxnp1/pFr/bGhyf2jdNbbv7JlHl4hkl3Y+0c/6vGOOue1aX2Lxn/0HtD/APBPL/8AJNAHR0Vzn2Lxn/0HtD/8E8v/AMk0fYvGf/Qe0P8A8E8v/wAk0AdHRXOfYvGf/Qe0P/wTy/8AyTR9i8Z/9B7Q/wDwTy//ACTQB0dFc59i8Z/9B7Q//BPL/wDJNH2Lxn/0HtD/APBPL/8AJNAHR0Vzn2Lxn/0HtD/8E8v/AMk0fYvGf/Qe0P8A8E8v/wAk0AdHRXOfYvGf/Qe0P/wTy/8AyTWdr0/jPQ/Dupat/bGhzfYrWS48r+yZV37FLYz9oOM464oA7SiubWz8ZlQf7e0Pkf8AQHl/+SaX7F4z/wCg9of/AIJ5f/kmgDo6K5z7F4z/AOg9of8A4J5f/kmj7F4z/wCg9of/AIJ5f/kmgDo6K5z7F4z/AOg9of8A4J5f/kmj7F4z/wCg9of/AIJ5f/kmgDo6K5z7F4z/AOg9of8A4J5f/kmj7F4z/wCg9of/AIJ5f/kmgDo6K5z7F4z/AOg9of8A4J5f/kmj7F4z/wCg9of/AIJ5f/kmgDo6K5z7F4z/AOg9of8A4J5f/kms3RLjxnrNhLdf2xocOy6uLbb/AGTK2fKmeLdn7QOuzOO2cc0AdrRXOfYvGf8A0HtD/wDBPL/8k0fYvGf/AEHtD/8ABPL/APJNAHR0Vzn2Lxn/ANB7Q/8AwTy//JNH2Lxn/wBB7Q//AATy/wDyTQB0dFc59i8Z/wDQe0P/AME8v/yTR9i8Z/8AQe0P/wAE8v8A8k0AdHRXOfYvGf8A0HtD/wDBPL/8k0fYvGf/AEHtD/8ABPL/APJNAHR0Vzn2Lxn/ANB7Q/8AwTy//JNH2Lxn/wBB7Q//AATy/wDyTQB0dFcVNceM4fEdlpH9saGftNrPc+b/AGTL8vltEu3H2jnPm9c8bffjS+xeM/8AoPaH/wCCeX/5JoA6Ouc8Nf8AIe8Xf9hVP/SO2o+xeM/+g9of/gnl/wDkmrHh3R77Sn1SfUb23u7nULsXLtb25hRcRRxgBS7npGD170AbdFFFABRRRQAUUUUAFFFFABUF7eW2n2U15eTJBbQoXkkkOFVR1JqeuY+IMEs/g258qJ5hDPbzyxIpZnijnR3AA6/Krcd6ANHQ9e0jWI5IdLlP+jBQ8DwPC0akfL8jqpCkDg4wccVrVxej6haa/wDESfVdInS6sIdKW2luYuUaUyllQHuVAJPpv967SgAooooAKKKKACiiigAqtqGoWul2Ml7eSGOCPG5gpY8kAAAAkkkgYA71ZrP13W7Hw5ol1q+pS+VaWy7pGAyeSAAB6kkAe5oAi03xJpOqxXT2t0R9kANwk8TwPECMgssgVgCATkjHBqHRvE2ha7dyLptyJLnylkO+B4mkiycMu9RvTJPIyOfeuGZ08XeFvF2oWWpWN5rmoaaYVsbG5SY20KhykRKk5di75PTJwOBk3bjULTxd4h04+G5RJ9l0m8Sd0G0QGVY1jiY9m3KTt6jbQB1mm+LtC1e/+xWN+JZyGaPMTqsoU4YxuwCyAd9pNbdeX6PqFnqw8BaXpuft+lEPfQhCGs0S2eJ0kH8JLsqgHr1HFeoUAFFFFABRRRQAUUUUAFZuoa/pelX9hY3t2sV1fyeXbRbWYu34A4HI5OBzWlXk3iK18TWmtWF9daVp1xcXGuw+RP8A2iwzGok8qLb5R2Lgkk5b5iTjngA7yTxV4fOtJpkl4hvEn8lSYXKLMR9zzNuwPgkbd2ecYp194u0LTdT/ALOu78R3AKK/7p2SIv8AdDuAVQnjG4jORXn8l1CPCtx4SJP/AAkj64zrb7T5jZvfOE/+55eG3dOMdak1m8trLR/HXh+7BOsapczNY220l7oSxIsTJ/eCkYOPu7DnFAHq9FRwI8dvEkjbnVAGb1OOTUlABRRRQAUUUUAFFFFAGbq2v6bonki+ndZJyRFFFC80j46lUQFiBkZOOMioNQ8RaNa6Zb3F7Kxt70bIojbSPJNkEkCIKXPGcjbx3rkfFcVrb/EeC+1rVrrS9Jl0jyYp4Z2gBnWUsVMi8glWUhc/Nt74xVew1S4srjwjr/iaZ4rb7DeWzXdymwI7PGYnk4AUvHGeuOTjvQB28nijRYtDh1g36NYTMEikRWcyMTjYqAFi2QRtAzweOKt6Vq9jrdn9r0+cTQhzG2VKMjDgqysAVI9CAa80tHFmdK8R3SvFoh8Q3t15joQscUqSJHMwP3VLHOT08wGur8GSJfan4m1a0502+v0a1kAwsuyCNHkX1BZSM99uaAOtooooAKKKKACiiigAqnqmq2OjWRvNQnEMIZUB2lizE4CqoBLEnoACauVyHxFYJounsztbxrqMLPfqpY2IGT52OnBAX5sr8+SCOKANe28VaLdabeagt8I7eyyLozxtC0PGfnRwGHBGMjntSaV4i0TUba7ksbhY47XMlyssLQNEGy25lcKQDydxGDzzXnLBrvSPElzbXMmuWkWo6fdS6kseWu445EaSMBAEYRqn8AAOcYznNrxC48XTeKLvw63262/sAWhlg5WeXzHfy1P8TBcggdN4FAHe6P4o0fXpnh067aSVEEuySF4mZDwHUOo3Kf7wyPetiuGs9W0/xL4+0e80OVZ7ex065F3LGuFj8xotkTejfIx2nkba7mgAooooAKKKKACiiigDL1zxDpfhuz+16rcPDBz8ywvJgAZJwgJwBzmjUvEOl6Ra29xeXDKtyQIEjieSSU4z8qICx45OBxWR8SNTsdO+H+ure3kNu11p9xBAJXC+ZIYmwq56k+lYh1/SF1rwv4gbULeTRorG5snvFcNFBO3ksAzDhSQjDn6d6AOsl8SaCmkW+uteRNaSnyoJkjZ3cscbFUAsWyvKgZyvTinJ4p0WTQ5dZF+gsIWKSSOrKyODjYUI3BskDaRnJHHNef2jizOleI7pXi0Q+Ib268x0IWOKVJEjmYH7qljnJ6eYDRcuLo6n4jtleTQ/+Eks7vzEQlXiiijjkmAHVQ4zkdkJoA9H0jXNO1yGWTT52k8l/LlSSJ4pI2xnDI4DLwQeRWjXHeGbu31fxp4g1jTZFm0yS3tLdbiPmOaVPNLFT0bAdBkfTtXY0AFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAf/2Q==")||m(aA,"src",En),F(nA.src,bs="data:image/jpeg;base64,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")||m(nA,"src",bs),F(sA.src,Ks="data:image/jpeg;base64,/9j/4AAQSkZJRgABAQAAAQABAAD/2wBDAAgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0aHBwgJC4nICIsIxwcKDcpLDAxNDQ0Hyc5PTgyPC4zNDL/2wBDAQkJCQwLDBgNDRgyIRwhMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjL/wAARCAAgACADASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwB3h69v4LiN1v7hZHY4fziSxPqD1Feq6TrMt0qQXJH2gAbmAwD7/wD1q5TRLaK1tb60vYkhurSQgblXdjqCPrmlkv5dJuTcD96VG5toyGB6V87TrTo1LOW/Q1mlUVkjrNe186TYlkjaS4k+SFAM5b1+grk7/UNRjitri7uJTdiUKqoThiTwABx+dM07VX11zeXQdZUbKxM2FUZ7Vr6doyajra3c1xO8VvKJVjkxyw6c+lb1pzxNaMYSsk9iIpQjqhmuS21zevcQW4EwzE8oPzHA4GAff+VYcNzEbB0xly2JPX/69bHijSdSg+13tgDLbuA5jjHzKcfN9c1zfh83OtXL2HkywzEgSOY8GNcdTmvNq4etPFuUl6HRGUVR0Z0awRIAyoFKnFbOjXIm1ARQ48mKM5x/eyPz71y+rzy6bNNZyJIjpjyyRnzQT2xXV+FtMktLMXFypW4lUDB6qOvP511YGlV+taq1tzGrb2dz/9k=")||m(sA,"src",Ks),F(iA.src,Ts="data:image/jpeg;base64,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")||m(iA,"src",Ts),F(oA.src,Ss="data:image/jpeg;base64,/9j/4AAQSkZJRgABAQAAAQABAAD/2wBDAAgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0aHBwgJC4nICIsIxwcKDcpLDAxNDQ0Hyc5PTgyPC4zNDL/2wBDAQkJCQwLDBgNDRgyIRwhMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjL/wAARCAAgACADASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwDe0vUrqHy7g3tx9oc7tsxzvBOTkfSu8gv/AO1NOcQTCGYjBJGSv4VwthHBo1s/2lHe+klMccTdlBI3D2qjr+q3GmxR6pZP5UgDIyjgEY9O9fOUsVOnNQnszz5a3aPRtV1N9NsT5AEk6rkKx6+5rzK5u9dtvEVpJe3U8gnlSQFmOwZYcADoOelWfC+pf2tJd6nfF3kuThY8EhQBwB7V2SWyaheW6NFG0alZA5QNwpBx7dKVXF1J4iNOO17AtEYHifWLaTWpYxAGmt/3Qdl/EgfnVOe2XUo4NLKbi6E4Oc5wTwfrXS+K9Ge4uYdRXDxQg+ZFt5z65/SqPhOx+2Xh1Jw5ijY7N4PB54H0pzw7liLS73G37uhn6SsNro9tZpGY2WIMxK4ySMk5rU8JXrxajNbGUSQyN+7b1wOQPzqDxJp13baxLdtE1zp0yACOIEFD0wfbnNS+DNLkkuv7QlgWG0jjC2qc5JycsQf881dGjKOJ/rYV1Y//2Q==")||m(oA,"src",Ss),F(pA.src,Os="data:image/jpeg;base64,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")||m(pA,"src",Os)},m(e,t){ni(document.head,w),l(e,dA,t),l(e,rA,t),l(e,fA,t),u(b,e,t),l(e,UA,t),u(R,e,t),l(e,jA,t),l(e,g,t),l(e,cA,t),l(e,K,t),l(e,mA,t),l(e,h,t),l(e,wA,t),u(M,e,t),l(e,FA,t),l(e,I,t),l(e,bA,t),l(e,B,t),l(e,RA,t),l(e,y,t),l(e,gA,t),u(X,e,t),l(e,KA,t),l(e,H,t),l(e,hA,t),l(e,P,t),l(e,MA,t),u(T,e,t),l(e,IA,t),l(e,C,t),l(e,BA,t),u(x,e,t),l(e,yA,t),l(e,J,t),l(e,XA,t),l(e,z,t),l(e,HA,t),l(e,k,t),l(e,PA,t),u(Q,e,t),l(e,TA,t),l(e,S,t),l(e,CA,t),l(e,v,t),l(e,xA,t),u(V,e,t),l(e,JA,t),l(e,Z,t),l(e,zA,t),u(G,e,t),l(e,kA,t),l(e,W,t),l(e,QA,t),u(N,e,t),l(e,SA,t),l(e,D,t),l(e,vA,t),l(e,O,t),l(e,VA,t),u(q,e,t),l(e,ZA,t),l(e,tA,t),l(e,GA,t),l(e,Y,t),l(e,WA,t),l(e,E,t),l(e,NA,t),u(L,e,t),l(e,DA,t),l(e,_,t),l(e,OA,t),u($,e,t),l(e,qA,t),l(e,AA,t),l(e,YA,t),l(e,ee,t),l(e,EA,t),l(e,te,t),l(e,LA,t),u(Ae,e,t),l(e,_A,t),l(e,le,t),l(e,$A,t),l(e,ae,t),l(e,el,t),l(e,ne,t),l(e,tl,t),u(se,e,t),l(e,Al,t),l(e,lA,t),l(e,ll,t),l(e,ie,t),l(e,al,t),l(e,oe,t),l(e,nl,t),l(e,pe,t),l(e,sl,t),u(re,e,t),l(e,il,t),l(e,ue,t),l(e,ol,t),u(de,e,t),l(e,pl,t),l(e,fe,t),l(e,rl,t),u(Ue,e,t),l(e,ul,t),l(e,je,t),l(e,dl,t),l(e,ce,t),l(e,fl,t),u(me,e,t),l(e,Ul,t),l(e,we,t),l(e,jl,t),l(e,Fe,t),l(e,cl,t),u(be,e,t),l(e,ml,t),l(e,Re,t),l(e,wl,t),l(e,ge,t),l(e,Fl,t),l(e,Ke,t),l(e,bl,t),l(e,he,t),l(e,Rl,t),l(e,Me,t),l(e,gl,t),u(Ie,e,t),l(e,Kl,t),l(e,aA,t),l(e,hl,t),l(e,Be,t),l(e,Ml,t),u(ye,e,t),l(e,Il,t),l(e,Xe,t),l(e,Bl,t),u(He,e,t),l(e,yl,t),l(e,Pe,t),l(e,Xl,t),l(e,Te,t),l(e,Hl,t),u(Ce,e,t),l(e,Pl,t),l(e,xe,t),l(e,Tl,t),l(e,Je,t),l(e,Cl,t),l(e,ze,t),l(e,xl,t),l(e,ke,t),l(e,Jl,t),l(e,Qe,t),l(e,zl,t),l(e,Se,t),l(e,kl,t),l(e,ve,t),l(e,Ql,t),l(e,Ve,t),l(e,Sl,t),u(Ze,e,t),l(e,vl,t),l(e,Ge,t),l(e,Vl,t),l(e,We,t),l(e,Zl,t),u(Ne,e,t),l(e,Gl,t),l(e,De,t),l(e,Wl,t),u(Oe,e,t),l(e,Nl,t),l(e,qe,t),l(e,Dl,t),l(e,Ye,t),l(e,Ol,t),l(e,Ee,t),l(e,ql,t),l(e,Le,t),l(e,Yl,t),l(e,_e,t),l(e,El,t),l(e,$e,t),l(e,Ll,t),u(et,e,t),l(e,_l,t),l(e,tt,t),l(e,$l,t),l(e,At,t),l(e,ea,t),u(lt,e,t),l(e,ta,t),l(e,nA,t),l(e,Aa,t),l(e,at,t),l(e,la,t),u(nt,e,t),l(e,aa,t),u(st,e,t),l(e,na,t),l(e,it,t),l(e,sa,t),u(ot,e,t),l(e,ia,t),u(pt,e,t),l(e,oa,t),u(rt,e,t),l(e,pa,t),l(e,sA,t),l(e,ra,t),l(e,ut,t),l(e,ua,t),u(dt,e,t),l(e,da,t),l(e,ft,t),l(e,fa,t),u(Ut,e,t),l(e,Ua,t),l(e,jt,t),l(e,ja,t),l(e,ct,t),l(e,ca,t),u(mt,e,t),l(e,ma,t),l(e,wt,t),l(e,wa,t),l(e,Ft,t),l(e,Fa,t),u(bt,e,t),l(e,ba,t),l(e,Rt,t),l(e,Ra,t),u(gt,e,t),l(e,ga,t),l(e,Kt,t),l(e,Ka,t),u(ht,e,t),l(e,ha,t),l(e,iA,t),l(e,Ma,t),l(e,Mt,t),l(e,Ia,t),u(It,e,t),l(e,Ba,t),l(e,Bt,t),l(e,ya,t),u(yt,e,t),l(e,Xa,t),l(e,Xt,t),l(e,Ha,t),u(Ht,e,t),l(e,Pa,t),l(e,Pt,t),l(e,Ta,t),u(Tt,e,t),l(e,Ca,t),l(e,Ct,t),l(e,xa,t),l(e,xt,t),l(e,Ja,t),u(Jt,e,t),l(e,za,t),l(e,oA,t),l(e,ka,t),l(e,zt,t),l(e,Qa,t),u(kt,e,t),l(e,Sa,t),l(e,Qt,t),l(e,va,t),l(e,St,t),l(e,Va,t),u(vt,e,t),l(e,Za,t),l(e,Vt,t),l(e,Ga,t),u(Zt,e,t),l(e,Wa,t),u(Gt,e,t),l(e,Na,t),l(e,Wt,t),l(e,Da,t),u(Nt,e,t),l(e,Oa,t),l(e,Dt,t),l(e,qa,t),l(e,Ot,t),l(e,Ya,t),u(qt,e,t),l(e,Ea,t),l(e,pA,t),l(e,La,t),l(e,Yt,t),l(e,_a,t),u(Et,e,t),l(e,$a,t),l(e,Lt,t),l(e,en,t),l(e,_t,t),l(e,tn,t),l(e,$t,t),l(e,An,t),u(eA,e,t),l(e,ln,t),l(e,uA,t),an=!0},p:ei,i(e){an||(d(b.$$.fragment,e),d(R.$$.fragment,e),d(M.$$.fragment,e),d(X.$$.fragment,e),d(T.$$.fragment,e),d(x.$$.fragment,e),d(Q.$$.fragment,e),d(V.$$.fragment,e),d(G.$$.fragment,e),d(N.$$.fragment,e),d(q.$$.fragment,e),d(L.$$.fragment,e),d($.$$.fragment,e),d(Ae.$$.fragment,e),d(se.$$.fragment,e),d(re.$$.fragment,e),d(de.$$.fragment,e),d(Ue.$$.fragment,e),d(me.$$.fragment,e),d(be.$$.fragment,e),d(Ie.$$.fragment,e),d(ye.$$.fragment,e),d(He.$$.fragment,e),d(Ce.$$.fragment,e),d(Ze.$$.fragment,e),d(Ne.$$.fragment,e),d(Oe.$$.fragment,e),d(et.$$.fragment,e),d(lt.$$.fragment,e),d(nt.$$.fragment,e),d(st.$$.fragment,e),d(ot.$$.fragment,e),d(pt.$$.fragment,e),d(rt.$$.fragment,e),d(dt.$$.fragment,e),d(Ut.$$.fragment,e),d(mt.$$.fragment,e),d(bt.$$.fragment,e),d(gt.$$.fragment,e),d(ht.$$.fragment,e),d(It.$$.fragment,e),d(yt.$$.fragment,e),d(Ht.$$.fragment,e),d(Tt.$$.fragment,e),d(Jt.$$.fragment,e),d(kt.$$.fragment,e),d(vt.$$.fragment,e),d(Zt.$$.fragment,e),d(Gt.$$.fragment,e),d(Nt.$$.fragment,e),d(qt.$$.fragment,e),d(Et.$$.fragment,e),d(eA.$$.fragment,e),an=!0)},o(e){f(b.$$.fragment,e),f(R.$$.fragment,e),f(M.$$.fragment,e),f(X.$$.fragment,e),f(T.$$.fragment,e),f(x.$$.fragment,e),f(Q.$$.fragment,e),f(V.$$.fragment,e),f(G.$$.fragment,e),f(N.$$.fragment,e),f(q.$$.fragment,e),f(L.$$.fragment,e),f($.$$.fragment,e),f(Ae.$$.fragment,e),f(se.$$.fragment,e),f(re.$$.fragment,e),f(de.$$.fragment,e),f(Ue.$$.fragment,e),f(me.$$.fragment,e),f(be.$$.fragment,e),f(Ie.$$.fragment,e),f(ye.$$.fragment,e),f(He.$$.fragment,e),f(Ce.$$.fragment,e),f(Ze.$$.fragment,e),f(Ne.$$.fragment,e),f(Oe.$$.fragment,e),f(et.$$.fragment,e),f(lt.$$.fragment,e),f(nt.$$.fragment,e),f(st.$$.fragment,e),f(ot.$$.fragment,e),f(pt.$$.fragment,e),f(rt.$$.fragment,e),f(dt.$$.fragment,e),f(Ut.$$.fragment,e),f(mt.$$.fragment,e),f(bt.$$.fragment,e),f(gt.$$.fragment,e),f(ht.$$.fragment,e),f(It.$$.fragment,e),f(yt.$$.fragment,e),f(Ht.$$.fragment,e),f(Tt.$$.fragment,e),f(Jt.$$.fragment,e),f(kt.$$.fragment,e),f(vt.$$.fragment,e),f(Zt.$$.fragment,e),f(Gt.$$.fragment,e),f(Nt.$$.fragment,e),f(qt.$$.fragment,e),f(Et.$$.fragment,e),f(eA.$$.fragment,e),an=!1},d(e){e&&(A(dA),A(rA),A(fA),A(UA),A(jA),A(g),A(cA),A(K),A(mA),A(h),A(wA),A(FA),A(I),A(bA),A(B),A(RA),A(y),A(gA),A(KA),A(H),A(hA),A(P),A(MA),A(IA),A(C),A(BA),A(yA),A(J),A(XA),A(z),A(HA),A(k),A(PA),A(TA),A(S),A(CA),A(v),A(xA),A(JA),A(Z),A(zA),A(kA),A(W),A(QA),A(SA),A(D),A(vA),A(O),A(VA),A(ZA),A(tA),A(GA),A(Y),A(WA),A(E),A(NA),A(DA),A(_),A(OA),A(qA),A(AA),A(YA),A(ee),A(EA),A(te),A(LA),A(_A),A(le),A($A),A(ae),A(el),A(ne),A(tl),A(Al),A(lA),A(ll),A(ie),A(al),A(oe),A(nl),A(pe),A(sl),A(il),A(ue),A(ol),A(pl),A(fe),A(rl),A(ul),A(je),A(dl),A(ce),A(fl),A(Ul),A(we),A(jl),A(Fe),A(cl),A(ml),A(Re),A(wl),A(ge),A(Fl),A(Ke),A(bl),A(he),A(Rl),A(Me),A(gl),A(Kl),A(aA),A(hl),A(Be),A(Ml),A(Il),A(Xe),A(Bl),A(yl),A(Pe),A(Xl),A(Te),A(Hl),A(Pl),A(xe),A(Tl),A(Je),A(Cl),A(ze),A(xl),A(ke),A(Jl),A(Qe),A(zl),A(Se),A(kl),A(ve),A(Ql),A(Ve),A(Sl),A(vl),A(Ge),A(Vl),A(We),A(Zl),A(Gl),A(De),A(Wl),A(Nl),A(qe),A(Dl),A(Ye),A(Ol),A(Ee),A(ql),A(Le),A(Yl),A(_e),A(El),A($e),A(Ll),A(_l),A(tt),A($l),A(At),A(ea),A(ta),A(nA),A(Aa),A(at),A(la),A(aa),A(na),A(it),A(sa),A(ia),A(oa),A(pa),A(sA),A(ra),A(ut),A(ua),A(da),A(ft),A(fa),A(Ua),A(jt),A(ja),A(ct),A(ca),A(ma),A(wt),A(wa),A(Ft),A(Fa),A(ba),A(Rt),A(Ra),A(ga),A(Kt),A(Ka),A(ha),A(iA),A(Ma),A(Mt),A(Ia),A(Ba),A(Bt),A(ya),A(Xa),A(Xt),A(Ha),A(Pa),A(Pt),A(Ta),A(Ca),A(Ct),A(xa),A(xt),A(Ja),A(za),A(oA),A(ka),A(zt),A(Qa),A(Sa),A(Qt),A(va),A(St),A(Va),A(Za),A(Vt),A(Ga),A(Wa),A(Na),A(Wt),A(Da),A(Oa),A(Dt),A(qa),A(Ot),A(Ya),A(Ea),A(pA),A(La),A(Yt),A(_a),A($a),A(Lt),A(en),A(_t),A(tn),A($t),A(An),A(ln),A(uA)),A(w),U(b,e),U(R,e),U(M,e),U(X,e),U(T,e),U(x,e),U(Q,e),U(V,e),U(G,e),U(N,e),U(q,e),U(L,e),U($,e),U(Ae,e),U(se,e),U(re,e),U(de,e),U(Ue,e),U(me,e),U(be,e),U(Ie,e),U(ye,e),U(He,e),U(Ce,e),U(Ze,e),U(Ne,e),U(Oe,e),U(et,e),U(lt,e),U(nt,e),U(st,e),U(ot,e),U(pt,e),U(rt,e),U(dt,e),U(Ut,e),U(mt,e),U(bt,e),U(gt,e),U(ht,e),U(It,e),U(yt,e),U(Ht,e),U(Tt,e),U(Jt,e),U(kt,e),U(vt,e),U(Zt,e),U(Gt,e),U(Nt,e),U(qt,e),U(Et,e),U(eA,e)}}}const pi='{"title":"Introduction to 🤗 Diffusers","local":"introduction-to--diffusers","sections":[{"title":"What You Will Learn","local":"what-you-will-learn","sections":[],"depth":2},{"title":"Prerequisites","local":"prerequisites","sections":[],"depth":2},{"title":"Step 1: Setup","local":"step-1-setup","sections":[],"depth":2},{"title":"Dreambooth: A Sneak Peak at What’s to Come","local":"dreambooth-a-sneak-peak-at-whats-to-come","sections":[],"depth":2},{"title":"MVP (Minimum Viable Pipeline)","local":"mvp-minimum-viable-pipeline","sections":[],"depth":2},{"title":"Step 2: Download a training dataset","local":"step-2-download-a-training-dataset","sections":[],"depth":2},{"title":"Step 3: Define the Scheduler","local":"step-3-define-the-scheduler","sections":[],"depth":2},{"title":"Step 4: Define the Model","local":"step-4-define-the-model","sections":[],"depth":2},{"title":"Step 5: Create a Training Loop","local":"step-5-create-a-training-loop","sections":[],"depth":2},{"title":"Step 6: Generate Images","local":"step-6-generate-images","sections":[{"title":"Option 1: Creating a pipeline:","local":"option-1-creating-a-pipeline","sections":[],"depth":3},{"title":"Option 2: Writing a Sampling Loop","local":"option-2-writing-a-sampling-loop","sections":[],"depth":3}],"depth":2},{"title":"Step 7: Push your model to the Hub","local":"step-7-push-your-model-to-the-hub","sections":[],"depth":2}],"depth":1}';function ri(nn){return ti(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ci extends Ai{constructor(w){super(),li(this,w,ri,oi,$s,{})}}export{ci as component};
