import{s as Fe,n as Ke,o as Ve}from"../chunks/scheduler.25b97de1.js";import{S as Je,i as Qe,g as o,s as n,r as d,A as Ze,h as a,f as l,c as s,j as Ne,u as m,x as r,k as Be,y as et,a as i,v as p,d as u,t as f,w as h}from"../chunks/index.d9030fc9.js";import{H as $,E as tt}from"../chunks/EditOnGithub.91d95064.js";function lt(Le){let c,F,N,K,g,V,v,ke="In this file, we would like to sum up the core philosophy amd coding standards that we go by when reviewing PRs.",J,y,Q,x,Z,b,Me="<li>All models and their building blocks should be prefixed with the model name (camel-cased).</li> <li>All models should take <strong>the config in their init</strong> instead of multiple keyword arguments. Keyword arguments are only allowed in a building block for arguments that can change (example: hidden size changes in a ResNet depending on the layer index).</li> <li><code>XxxxxConfig</code>’s names should almost never be new. Ex: for a MoE, look at other MoEs and use the same config names like <code>router_jitter_noise</code> or <code>num_experts</code>.</li> <li>All public models should return a <code>ModelOutput</code> or a tuple (depending on <code>return_dict</code>).</li> <li>If a model is added in an Auto class, its API (inputs/outputs) should be fully compatible with other models in the same auto class.</li> <li>As little code paths as possible. <code>if self.config.use_swin_norm</code> should not exist. Either use <code>ALL_LAYER_NORM</code> or make sure pretrained checkpoints all use it / don’t. We are not providing a research codebase.</li>",ee,w,te,_,le,C,Pe="<li>Simplicity</li>",ie,T,He="Aim for simple code, and help our contributors with your knowledge of the library, of torch, of python etc. Doubt them, think about vectorizing, think about our API in general etc.",ne,L,Ee="We probably already have EVERYTHING implemented in <code>transformers</code> let’s not re-invent boiling water, and look for the closest model / closest implementation.",se,k,Ae="<li>Readability</li>",oe,M,Ie="Let’s make the code readable. Once you simplify you should ask to split in 2 lines wherever possible, and look at <code>Gemma</code> or <code>Llava</code> for what an almost ideal model looks like",ae,P,Oe="<li>Explainability</li>",re,H,Se="Code to be self-explanatory, easy to debug, easy to re-use. This means, <strong>no single letter variables</strong>, <strong>variable names that explain what is happening.</strong>",de,E,Re="But also <strong>sources of new class / code</strong>. If there is a new <code>MyAwesomeAttention</code> , should link to the original implementation, code or repo where it was introduced. We don’t add Mr XXX’s custom design code.",me,A,pe,I,qe="Don’t try to make the code shorter if it harms readability. A lot of users dive into the source code and tweak it (that’s why we have the one file per model policy), so we really want the code to be as clear as possible. That means:",ue,O,De="<li>don’t use one-letter variable names except in short loops, always use meaningful names.</li> <li>don’t use refactor one/two lines of code behind a separate function a reader will have to look for.</li> <li>a function that is used only once is probably unhelpful and you can put the same code where the function is used.</li> <li>a function that does its result in one line should probably not exist.</li> <li>use comments whenever you write a line that is obscure to explain its goal.</li> <li>use ternary operators in the obvious cases only (<code>variable = this if condition else that</code> ), for more complex tests with several elif branches, revert to the usual syntax.</li>",fe,S,he,R,Ue="[CODE STYLE]",ce,q,Ye="It’s easier to debug code when each line does one operation instead of adding multiple <code>.do_this()</code> , <code>.and_that()</code> , <code>also_this()</code> , <code>and_let_us_not_forget_that()</code> in a single line. Similarly, avoid using lambda functions (except maybe when sorting things and providing a <code>key</code> function).",$e,D,We="This will also make your code easier to read, in accordance with the previous point.",ge,U,ve,Y,Xe="[CODE STYLE]",ye,W,je="We always use f-strings because they make code easier to read and are faster than any other option for formatting. The only exception is if a given string needs to be formatted with values that are not available right now.",xe,X,be,j,ze="[CODE STYLE]",we,z,Ge="Asserts can be disabled by the user if they execute their script with a flag. Therefore, they aren’t suitable for errors you want to raise all the time. In general in the source code, use a test and raise the appropriate exception with a clear message. In tests however, you can use assert statements.",_e,G,Ce,B,Te;return g=new $({props:{title:"transformers philosophy",local:"transformers-philosophy",headingTag:"h1"}}),y=new $({props:{title:"API",local:"api",headingTag:"h1"}}),x=new $({props:{title:"Transformers API",local:"transformers-api",headingTag:"h3"}}),w=new $({props:{title:"Code",local:"code",headingTag:"h1"}}),_=new $({props:{title:"Code style/quality",local:"code-stylequality",headingTag:"h3"}}),A=new $({props:{title:"Understandable code >> short code",local:"understandable-code--short-code",headingTag:"h2"}}),S=new $({props:{title:"Fragment code for easy debugging",local:"fragment-code-for-easy-debugging",headingTag:"h2"}}),U=new $({props:{title:"f-string >> everything else",local:"f-string--everything-else",headingTag:"h2"}}),X=new $({props:{title:"Use proper errors in code, no asserts",local:"use-proper-errors-in-code-no-asserts",headingTag:"h2"}}),G=new tt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/transformers_philosophy.md"}}),{c(){c=o("meta"),F=n(),N=o("p"),K=n(),d(g.$$.fragment),V=n(),v=o("p"),v.textContent=ke,J=n(),d(y.$$.fragment),Q=n(),d(x.$$.fragment),Z=n(),b=o("ul"),b.innerHTML=Me,ee=n(),d(w.$$.fragment),te=n(),d(_.$$.fragment),le=n(),C=o("ol"),C.innerHTML=Pe,ie=n(),T=o("p"),T.textContent=He,ne=n(),L=o("p"),L.innerHTML=Ee,se=n(),k=o("ol"),k.innerHTML=Ae,oe=n(),M=o("p"),M.innerHTML=Ie,ae=n(),P=o("ol"),P.innerHTML=Oe,re=n(),H=o("p"),H.innerHTML=Se,de=n(),E=o("p"),E.innerHTML=Re,me=n(),d(A.$$.fragment),pe=n(),I=o("p"),I.textContent=qe,ue=n(),O=o("ul"),O.innerHTML=De,fe=n(),d(S.$$.fragment),he=n(),R=o("p"),R.textContent=Ue,ce=n(),q=o("p"),q.innerHTML=Ye,$e=n(),D=o("p"),D.textContent=We,ge=n(),d(U.$$.fragment),ve=n(),Y=o("p"),Y.textContent=Xe,ye=n(),W=o("p"),W.textContent=je,xe=n(),d(X.$$.fragment),be=n(),j=o("p"),j.textContent=ze,we=n(),z=o("p"),z.textContent=Ge,_e=n(),d(G.$$.fragment),Ce=n(),B=o("p"),this.h()},l(e){const t=Ze("svelte-u9bgzb",document.head);c=a(t,"META",{name:!0,content:!0}),t.forEach(l),F=s(e),N=a(e,"P",{}),Ne(N).forEach(l),K=s(e),m(g.$$.fragment,e),V=s(e),v=a(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1ruaxym"&&(v.textContent=ke),J=s(e),m(y.$$.fragment,e),Q=s(e),m(x.$$.fragment,e),Z=s(e),b=a(e,"UL",{"data-svelte-h":!0}),r(b)!=="svelte-fwnmmp"&&(b.innerHTML=Me),ee=s(e),m(w.$$.fragment,e),te=s(e),m(_.$$.fragment,e),le=s(e),C=a(e,"OL",{"data-svelte-h":!0}),r(C)!=="svelte-tbvk1o"&&(C.innerHTML=Pe),ie=s(e),T=a(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-5lsr26"&&(T.textContent=He),ne=s(e),L=a(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-8ici8p"&&(L.innerHTML=Ee),se=s(e),k=a(e,"OL",{"data-svelte-h":!0}),r(k)!=="svelte-hrm147"&&(k.innerHTML=Ae),oe=s(e),M=a(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-56c7u9"&&(M.innerHTML=Ie),ae=s(e),P=a(e,"OL",{"data-svelte-h":!0}),r(P)!=="svelte-fxmooq"&&(P.innerHTML=Oe),re=s(e),H=a(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1gq2y8f"&&(H.innerHTML=Se),de=s(e),E=a(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1e56aem"&&(E.innerHTML=Re),me=s(e),m(A.$$.fragment,e),pe=s(e),I=a(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-11sfyor"&&(I.textContent=qe),ue=s(e),O=a(e,"UL",{"data-svelte-h":!0}),r(O)!=="svelte-14jrc2p"&&(O.innerHTML=De),fe=s(e),m(S.$$.fragment,e),he=s(e),R=a(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1m3sed0"&&(R.textContent=Ue),ce=s(e),q=a(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-ehhqr9"&&(q.innerHTML=Ye),$e=s(e),D=a(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-15a2xa3"&&(D.textContent=We),ge=s(e),m(U.$$.fragment,e),ve=s(e),Y=a(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1m3sed0"&&(Y.textContent=Xe),ye=s(e),W=a(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-77hepo"&&(W.textContent=je),xe=s(e),m(X.$$.fragment,e),be=s(e),j=a(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1m3sed0"&&(j.textContent=ze),we=s(e),z=a(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1pkvl2y"&&(z.textContent=Ge),_e=s(e),m(G.$$.fragment,e),Ce=s(e),B=a(e,"P",{}),Ne(B).forEach(l),this.h()},h(){Be(c,"name","hf:doc:metadata"),Be(c,"content",it)},m(e,t){et(document.head,c),i(e,F,t),i(e,N,t),i(e,K,t),p(g,e,t),i(e,V,t),i(e,v,t),i(e,J,t),p(y,e,t),i(e,Q,t),p(x,e,t),i(e,Z,t),i(e,b,t),i(e,ee,t),p(w,e,t),i(e,te,t),p(_,e,t),i(e,le,t),i(e,C,t),i(e,ie,t),i(e,T,t),i(e,ne,t),i(e,L,t),i(e,se,t),i(e,k,t),i(e,oe,t),i(e,M,t),i(e,ae,t),i(e,P,t),i(e,re,t),i(e,H,t),i(e,de,t),i(e,E,t),i(e,me,t),p(A,e,t),i(e,pe,t),i(e,I,t),i(e,ue,t),i(e,O,t),i(e,fe,t),p(S,e,t),i(e,he,t),i(e,R,t),i(e,ce,t),i(e,q,t),i(e,$e,t),i(e,D,t),i(e,ge,t),p(U,e,t),i(e,ve,t),i(e,Y,t),i(e,ye,t),i(e,W,t),i(e,xe,t),p(X,e,t),i(e,be,t),i(e,j,t),i(e,we,t),i(e,z,t),i(e,_e,t),p(G,e,t),i(e,Ce,t),i(e,B,t),Te=!0},p:Ke,i(e){Te||(u(g.$$.fragment,e),u(y.$$.fragment,e),u(x.$$.fragment,e),u(w.$$.fragment,e),u(_.$$.fragment,e),u(A.$$.fragment,e),u(S.$$.fragment,e),u(U.$$.fragment,e),u(X.$$.fragment,e),u(G.$$.fragment,e),Te=!0)},o(e){f(g.$$.fragment,e),f(y.$$.fragment,e),f(x.$$.fragment,e),f(w.$$.fragment,e),f(_.$$.fragment,e),f(A.$$.fragment,e),f(S.$$.fragment,e),f(U.$$.fragment,e),f(X.$$.fragment,e),f(G.$$.fragment,e),Te=!1},d(e){e&&(l(F),l(N),l(K),l(V),l(v),l(J),l(Q),l(Z),l(b),l(ee),l(te),l(le),l(C),l(ie),l(T),l(ne),l(L),l(se),l(k),l(oe),l(M),l(ae),l(P),l(re),l(H),l(de),l(E),l(me),l(pe),l(I),l(ue),l(O),l(fe),l(he),l(R),l(ce),l(q),l($e),l(D),l(ge),l(ve),l(Y),l(ye),l(W),l(xe),l(be),l(j),l(we),l(z),l(_e),l(Ce),l(B)),l(c),h(g,e),h(y,e),h(x,e),h(w,e),h(_,e),h(A,e),h(S,e),h(U,e),h(X,e),h(G,e)}}}const it='{"title":"transformers philosophy","local":"transformers-philosophy","sections":[],"depth":1}';function nt(Le){return Ve(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rt extends Je{constructor(c){super(),Qe(this,c,nt,lt,Fe,{})}}export{rt as component};
