import{s as ct,o as ut,n as Ee}from"../chunks/scheduler.d6170356.js";import{S as ht,i as dt,g as o,s as l,r as h,A as ft,h as p,f as a,c as n,j as ot,u as d,x as r,k as pt,y as mt,a as s,v as f,d as m,t as g,w}from"../chunks/index.fcd4cc08.js";import{T as ke}from"../chunks/Tip.b09c67cf.js";import{C as rt}from"../chunks/CodeBlock.7b16bdef.js";import{H as K,E as gt}from"../chunks/EditOnGithub.da2b595c.js";function wt(T){let i,u='This guide will take you through the process of integrating a <em>Sign-In with HF</em> button into any Space. If you’re seeking a fast and simple method to implement this in a <strong>Gradio</strong> Space, take a look at its <a href="https://www.gradio.app/guides/sharing-your-app#o-auth-login-via-hugging-face" rel="nofollow">built-in integration</a>.';return{c(){i=o("p"),i.innerHTML=u},l(c){i=p(c,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1nqltc0"&&(i.innerHTML=u)},m(c,M){s(c,i,M)},p:Ee,d(c){c&&a(i)}}}function Mt(T){let i,u='You can also use the HF OAuth flow to create a “Sign in with HF” flow in any website or App, outside of Spaces. <a href="./oauth">Read our general OAuth page</a>.';return{c(){i=o("p"),i.innerHTML=u},l(c){i=p(c,"P",{"data-svelte-h":!0}),r(i)!=="svelte-138wjpm"&&(i.innerHTML=u)},m(c,M){s(c,i,M)},p:Ee,d(c){c&&a(i)}}}function Tt(T){let i,u="You should use <code>target=_blank</code> on the button to open the sign-in page in a new tab, unless you run the space outside its <code>iframe</code>. Otherwise, you might encounter issues with cookies on some browsers.";return{c(){i=o("p"),i.innerHTML=u},l(c){i=p(c,"P",{"data-svelte-h":!0}),r(i)!=="svelte-9c51kn"&&(i.innerHTML=u)},m(c,M){s(c,i,M)},p:Ee,d(c){c&&a(i)}}}function bt(T){let i,u,c,M,v,te,j,Be='You can enable a built-in sign-in flow in your Space by seamlessly creating and associating an <a href="https://developer.okta.com/blog/2019/10/21/illustrated-guide-to-oauth-and-oidc" rel="nofollow">OAuth/OpenID connect</a> app so users can log in with their HF account.',ae,_,Re='This enables new use cases for your Space. For instance, when combined with <a href="https://huggingface.co/docs/hub/spaces-storage" rel="nofollow">Persistent Storage</a>, a generative AI Space could allow users to log in to access their previous generations, only accessible to them.',se,b,le,y,ne,J,ie,C,Ze="All you need to do is add <code>hf_oauth: true</code> to your Space’s metadata inside your <code>README.md</code> file.",oe,I,Ae="Here’s an example of metadata for a Gradio Space:",pe,H,re,U,Pe='You can check out the <a href="./spaces-config-reference">configuration reference docs</a> for more information.',ce,S,We='This will add the following <a href="https://huggingface.co/docs/hub/spaces-overview#helper-environment-variables" rel="nofollow">environment variables</a> to your space:',ue,L,Xe='<li><code>OAUTH_CLIENT_ID</code>: the client ID of your OAuth app (public)</li> <li><code>OAUTH_CLIENT_SECRET</code>: the client secret of your OAuth app</li> <li><code>OAUTH_SCOPES</code>: scopes accessible by your OAuth app.</li> <li><code>OPENID_PROVIDER_URL</code>: The URL of the OpenID provider. The OpenID metadata will be available at <a href="https://huggingface.co/.well-known/openid-configuration" rel="nofollow"><code>{OPENID_PROVIDER_URL}/.well-known/openid-configuration</code></a>.</li>',he,x,Fe="As for any other environment variable, you can use them in your code by using <code>os.getenv(&quot;OAUTH_CLIENT_ID&quot;)</code>, for example.",de,G,fe,k,Ne="You can use any redirect URL you want, as long as it targets your Space.",me,E,Oe='Note that <code>SPACE_HOST</code> is <a href="https://huggingface.co/docs/hub/spaces-overview#helper-environment-variables" rel="nofollow">available</a> as an environment variable.',ge,B,Ye="For example, you can use <code>https://{SPACE_HOST}/login/callback</code> as a redirect URI.",we,R,Me,Z,Ve="The following scopes are always included for Spaces:",Te,A,ze="<li><code>openid</code>: Get the ID token in addition to the access token.</li> <li><code>profile</code>: Get the user’s profile information (username, avatar, etc.)</li>",be,P,Qe="Those scopes are optional and can be added by setting <code>hf_oauth_scopes</code> in your Space’s metadata:",ye,W,qe='<li><code>email</code>: Get the user’s email address.</li> <li><code>read-repos</code>: Get read access to the user’s personal repos.</li> <li><code>write-repos</code>: Get write/read access to the user’s personal repos.</li> <li><code>manage-repos</code>: Get full access to the user’s personal repos. Also grants repo creation and deletion.</li> <li><code>inference-api</code>: Get access to the <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a>, you will be able to make inference requests on behalf of the user.</li> <li><code>write-discussions</code>: Open discussions and Pull Requests on behalf of the user as well as interact with discussions (including reactions, posting/editing comments, closing discussions, …). To open Pull Requests on private repos, you need to request the <code>read-repos</code> scope as well.</li>',$e,X,ve,F,De='You now have all the information to add a “Sign-in with HF” button to your Space. Some libraries (<a href="https://github.com/lepture/authlib" rel="nofollow">Python</a>, <a href="https://github.com/panva/node-openid-client" rel="nofollow">NodeJS</a>) can help you implement the OpenID/OAuth protocol.',je,N,Ke='Gradio and hugginface.js also provide <strong>built-in support</strong>, making implementing the Sign-in with HF button a breeze; you can check out the associated guides with <a href="https://www.gradio.app/guides/sharing-your-app#o-auth-login-via-hugging-face" rel="nofollow">gradio</a> and with <a href="https://huggingface.co/docs/huggingface.js/hub/README#oauth-login" rel="nofollow">hugginface.js</a>.',_e,O,et="Basically, you need to:",Je,Y,tt="<li>Redirect the user to <code>https://huggingface.co/oauth/authorize?redirect_uri={REDIRECT_URI}&amp;scope=openid%20profile&amp;client_id={CLIENT_ID}&amp;state={STATE}</code>, where <code>STATE</code> is a random string that you will need to verify later.</li> <li>Handle the callback on <code>/auth/callback</code> or <code>/login/callback</code> (or your own custom callback URL) and verify the <code>state</code> parameter.</li> <li>Use the <code>code</code> query parameter to get an access token and id token from <code>https://huggingface.co/oauth/token</code> (POST request with <code>client_id</code>, <code>code</code>, <code>grant_type=authorization_code</code> and <code>redirect_uri</code> as form data, and with <code>Authorization: Basic {base64(client_id:client_secret)}</code> as a header).</li>",Ce,$,Ie,V,He,z,at='<li><a href="https://huggingface.co/spaces/Wauplin/gradio-oauth-test" rel="nofollow">Gradio test app</a></li> <li><a href="https://huggingface.co/spaces/huggingchat/chat-ui" rel="nofollow">Hugging Chat (NodeJS/SvelteKit)</a></li> <li><a href="https://huggingface.co/spaces/huggingfacejs/inference-widgets" rel="nofollow">Inference Widgets (Auth.js/SvelteKit)</a>, uses the <code>inference-api</code> scope to make inference requests on behalf of the user.</li> <li><a href="https://huggingface.co/spaces/huggingfacejs/client-side-oauth" rel="nofollow">Client-Side in a Static Space (huggingface.js)</a> - very simple JavaScript example.</li>',Ue,Q,st="JS Code example:",Se,q,Le,D,xe,ee,Ge;return v=new K({props:{title:"Adding a Sign-In with HF button to your Space",local:"adding-a-sign-in-with-hf-button-to-your-space",headingTag:"h1"}}),b=new ke({props:{$$slots:{default:[wt]},$$scope:{ctx:T}}}),y=new ke({props:{$$slots:{default:[Mt]},$$scope:{ctx:T}}}),J=new K({props:{title:"Create an OAuth app",local:"create-an-oauth-app",headingTag:"h2"}}),H=new rt({props:{code:"dGl0bGUlM0ElMjBHcmFkaW8lMjBPYXV0aCUyMFRlc3QlMEFlbW9qaSUzQSUyMCVGMCU5RiU4RiU4NiUwQWNvbG9yRnJvbSUzQSUyMHBpbmslMEFjb2xvclRvJTNBJTIwcGluayUwQXNkayUzQSUyMGdyYWRpbyUwQXNka192ZXJzaW9uJTNBJTIwMy40MC4wJTBBcHl0aG9uX3ZlcnNpb24lM0ElMjAzLjEwLjYlMEFhcHBfZmlsZSUzQSUyMGFwcC5weSUwQSUwQWhmX29hdXRoJTNBJTIwdHJ1ZSUwQSUyMyUyMG9wdGlvbmFsJTJDJTIwZGVmYXVsdCUyMGR1cmF0aW9uJTIwaXMlMjA4JTIwaG91cnMlMkY0ODAlMjBtaW51dGVzLiUyME1heCUyMGR1cmF0aW9uJTIwaXMlMjAzMCUyMGRheXMlMkY0MzIwMCUyMG1pbnV0ZXMuJTBBaGZfb2F1dGhfZXhwaXJhdGlvbl9taW51dGVzJTNBJTIwNDgwJTBBJTIzJTIwb3B0aW9uYWwlMkMlMjBzZWUlMjAlMjJTY29wZXMlMjIlMjBiZWxvdy4lMjAlMjJvcGVuaWQlMjBwcm9maWxlJTIyJTIwaXMlMjBhbHdheXMlMjBpbmNsdWRlZC4lMEFoZl9vYXV0aF9zY29wZXMlM0ElMEElMjAtJTIwcmVhZC1yZXBvcyUwQSUyMC0lMjB3cml0ZS1yZXBvcyUwQSUyMC0lMjBtYW5hZ2UtcmVwb3MlMEElMjAtJTIwaW5mZXJlbmNlLWFwaQ==",highlighted:`<span class="hljs-attr">title:</span> <span class="hljs-string">Gradio</span> <span class="hljs-string">Oauth</span> <span class="hljs-string">Test</span>
<span class="hljs-attr">emoji:</span> <span class="hljs-string">🏆</span>
<span class="hljs-attr">colorFrom:</span> <span class="hljs-string">pink</span>
<span class="hljs-attr">colorTo:</span> <span class="hljs-string">pink</span>
<span class="hljs-attr">sdk:</span> <span class="hljs-string">gradio</span>
<span class="hljs-attr">sdk_version:</span> <span class="hljs-number">3.40</span><span class="hljs-number">.0</span>
<span class="hljs-attr">python_version:</span> <span class="hljs-number">3.10</span><span class="hljs-number">.6</span>
<span class="hljs-attr">app_file:</span> <span class="hljs-string">app.py</span>

<span class="hljs-attr">hf_oauth:</span> <span class="hljs-literal">true</span>
<span class="hljs-comment"># optional, default duration is 8 hours/480 minutes. Max duration is 30 days/43200 minutes.</span>
<span class="hljs-attr">hf_oauth_expiration_minutes:</span> <span class="hljs-number">480</span>
<span class="hljs-comment"># optional, see &quot;Scopes&quot; below. &quot;openid profile&quot; is always included.</span>
<span class="hljs-attr">hf_oauth_scopes:</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">read-repos</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">write-repos</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">manage-repos</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">inference-api</span>`,wrap:!1}}),G=new K({props:{title:"Redirect URLs",local:"redirect-urls",headingTag:"h2"}}),R=new K({props:{title:"Scopes",local:"scopes",headingTag:"h2"}}),X=new K({props:{title:"Adding the button to your Space",local:"adding-the-button-to-your-space",headingTag:"h2"}}),$=new ke({props:{warning:!0,$$slots:{default:[Tt]},$$scope:{ctx:T}}}),V=new K({props:{title:"Examples:",local:"examples",headingTag:"h2"}}),q=new rt({props:{code:"aW1wb3J0JTIwJTdCJTIwb2F1dGhMb2dpblVybCUyQyUyMG9hdXRoSGFuZGxlUmVkaXJlY3RJZlByZXNlbnQlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlM0IlMEElMEFjb25zdCUyMG9hdXRoUmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBvYXV0aEhhbmRsZVJlZGlyZWN0SWZQcmVzZW50KCklM0IlMEElMEFpZiUyMCghb2F1dGhSZXN1bHQpJTIwJTdCJTBBJTIwJTIwJTJGJTJGJTIwSWYlMjB0aGUlMjB1c2VyJTIwaXMlMjBub3QlMjBsb2dnZWQlMjBpbiUyQyUyMHJlZGlyZWN0JTIwdG8lMjB0aGUlMjBsb2dpbiUyMHBhZ2UlMEElMjAlMjB3aW5kb3cubG9jYXRpb24uaHJlZiUyMCUzRCUyMGF3YWl0JTIwb2F1dGhMb2dpblVybCgpJTNCJTBBJTdEJTBBJTBBJTJGJTJGJTIwWW91JTIwY2FuJTIwdXNlJTIwb2F1dGhSZXN1bHQuYWNjZXNzVG9rZW4lMkMlMjBvYXV0aFJlc3VsdC51c2VySW5mbyUyMGFtb25nJTIwb3RoZXIlMjB0aGluZ3MlMEFjb25zb2xlLmxvZyhvYXV0aFJlc3VsdCklM0I=",highlighted:`<span class="hljs-keyword">import</span> { oauthLoginUrl, oauthHandleRedirectIfPresent } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> oauthResult = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthHandleRedirectIfPresent</span>();

<span class="hljs-keyword">if</span> (!oauthResult) {
  <span class="hljs-comment">// If the user is not logged in, redirect to the login page</span>
  <span class="hljs-variable language_">window</span>.<span class="hljs-property">location</span>.<span class="hljs-property">href</span> = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthLoginUrl</span>();
}

<span class="hljs-comment">// You can use oauthResult.accessToken, oauthResult.userInfo among other things</span>
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(oauthResult);`,wrap:!1}}),D=new gt({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/spaces-oauth.md"}}),{c(){i=o("meta"),u=l(),c=o("p"),M=l(),h(v.$$.fragment),te=l(),j=o("p"),j.innerHTML=Be,ae=l(),_=o("p"),_.innerHTML=Re,se=l(),h(b.$$.fragment),le=l(),h(y.$$.fragment),ne=l(),h(J.$$.fragment),ie=l(),C=o("p"),C.innerHTML=Ze,oe=l(),I=o("p"),I.textContent=Ae,pe=l(),h(H.$$.fragment),re=l(),U=o("p"),U.innerHTML=Pe,ce=l(),S=o("p"),S.innerHTML=We,ue=l(),L=o("ul"),L.innerHTML=Xe,he=l(),x=o("p"),x.innerHTML=Fe,de=l(),h(G.$$.fragment),fe=l(),k=o("p"),k.textContent=Ne,me=l(),E=o("p"),E.innerHTML=Oe,ge=l(),B=o("p"),B.innerHTML=Ye,we=l(),h(R.$$.fragment),Me=l(),Z=o("p"),Z.textContent=Ve,Te=l(),A=o("ul"),A.innerHTML=ze,be=l(),P=o("p"),P.innerHTML=Qe,ye=l(),W=o("ul"),W.innerHTML=qe,$e=l(),h(X.$$.fragment),ve=l(),F=o("p"),F.innerHTML=De,je=l(),N=o("p"),N.innerHTML=Ke,_e=l(),O=o("p"),O.textContent=et,Je=l(),Y=o("ul"),Y.innerHTML=tt,Ce=l(),h($.$$.fragment),Ie=l(),h(V.$$.fragment),He=l(),z=o("ul"),z.innerHTML=at,Ue=l(),Q=o("p"),Q.textContent=st,Se=l(),h(q.$$.fragment),Le=l(),h(D.$$.fragment),xe=l(),ee=o("p"),this.h()},l(e){const t=ft("svelte-u9bgzb",document.head);i=p(t,"META",{name:!0,content:!0}),t.forEach(a),u=n(e),c=p(e,"P",{}),ot(c).forEach(a),M=n(e),d(v.$$.fragment,e),te=n(e),j=p(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1nfjaew"&&(j.innerHTML=Be),ae=n(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1t83yje"&&(_.innerHTML=Re),se=n(e),d(b.$$.fragment,e),le=n(e),d(y.$$.fragment,e),ne=n(e),d(J.$$.fragment,e),ie=n(e),C=p(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1u00faw"&&(C.innerHTML=Ze),oe=n(e),I=p(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-vlpqut"&&(I.textContent=Ae),pe=n(e),d(H.$$.fragment,e),re=n(e),U=p(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-ml9rcy"&&(U.innerHTML=Pe),ce=n(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-12m1u10"&&(S.innerHTML=We),ue=n(e),L=p(e,"UL",{"data-svelte-h":!0}),r(L)!=="svelte-k73zcv"&&(L.innerHTML=Xe),he=n(e),x=p(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-qqxlx3"&&(x.innerHTML=Fe),de=n(e),d(G.$$.fragment,e),fe=n(e),k=p(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-eoih5g"&&(k.textContent=Ne),me=n(e),E=p(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1a014a5"&&(E.innerHTML=Oe),ge=n(e),B=p(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-4fyftp"&&(B.innerHTML=Ye),we=n(e),d(R.$$.fragment,e),Me=n(e),Z=p(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-sd96qs"&&(Z.textContent=Ve),Te=n(e),A=p(e,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-3wn6r0"&&(A.innerHTML=ze),be=n(e),P=p(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-181zoj"&&(P.innerHTML=Qe),ye=n(e),W=p(e,"UL",{"data-svelte-h":!0}),r(W)!=="svelte-4t92ri"&&(W.innerHTML=qe),$e=n(e),d(X.$$.fragment,e),ve=n(e),F=p(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1a3vuj4"&&(F.innerHTML=De),je=n(e),N=p(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1ox841a"&&(N.innerHTML=Ke),_e=n(e),O=p(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-g0kxak"&&(O.textContent=et),Je=n(e),Y=p(e,"UL",{"data-svelte-h":!0}),r(Y)!=="svelte-159xo4d"&&(Y.innerHTML=tt),Ce=n(e),d($.$$.fragment,e),Ie=n(e),d(V.$$.fragment,e),He=n(e),z=p(e,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-lipo2y"&&(z.innerHTML=at),Ue=n(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1g8zr10"&&(Q.textContent=st),Se=n(e),d(q.$$.fragment,e),Le=n(e),d(D.$$.fragment,e),xe=n(e),ee=p(e,"P",{}),ot(ee).forEach(a),this.h()},h(){pt(i,"name","hf:doc:metadata"),pt(i,"content",yt)},m(e,t){mt(document.head,i),s(e,u,t),s(e,c,t),s(e,M,t),f(v,e,t),s(e,te,t),s(e,j,t),s(e,ae,t),s(e,_,t),s(e,se,t),f(b,e,t),s(e,le,t),f(y,e,t),s(e,ne,t),f(J,e,t),s(e,ie,t),s(e,C,t),s(e,oe,t),s(e,I,t),s(e,pe,t),f(H,e,t),s(e,re,t),s(e,U,t),s(e,ce,t),s(e,S,t),s(e,ue,t),s(e,L,t),s(e,he,t),s(e,x,t),s(e,de,t),f(G,e,t),s(e,fe,t),s(e,k,t),s(e,me,t),s(e,E,t),s(e,ge,t),s(e,B,t),s(e,we,t),f(R,e,t),s(e,Me,t),s(e,Z,t),s(e,Te,t),s(e,A,t),s(e,be,t),s(e,P,t),s(e,ye,t),s(e,W,t),s(e,$e,t),f(X,e,t),s(e,ve,t),s(e,F,t),s(e,je,t),s(e,N,t),s(e,_e,t),s(e,O,t),s(e,Je,t),s(e,Y,t),s(e,Ce,t),f($,e,t),s(e,Ie,t),f(V,e,t),s(e,He,t),s(e,z,t),s(e,Ue,t),s(e,Q,t),s(e,Se,t),f(q,e,t),s(e,Le,t),f(D,e,t),s(e,xe,t),s(e,ee,t),Ge=!0},p(e,[t]){const lt={};t&2&&(lt.$$scope={dirty:t,ctx:e}),b.$set(lt);const nt={};t&2&&(nt.$$scope={dirty:t,ctx:e}),y.$set(nt);const it={};t&2&&(it.$$scope={dirty:t,ctx:e}),$.$set(it)},i(e){Ge||(m(v.$$.fragment,e),m(b.$$.fragment,e),m(y.$$.fragment,e),m(J.$$.fragment,e),m(H.$$.fragment,e),m(G.$$.fragment,e),m(R.$$.fragment,e),m(X.$$.fragment,e),m($.$$.fragment,e),m(V.$$.fragment,e),m(q.$$.fragment,e),m(D.$$.fragment,e),Ge=!0)},o(e){g(v.$$.fragment,e),g(b.$$.fragment,e),g(y.$$.fragment,e),g(J.$$.fragment,e),g(H.$$.fragment,e),g(G.$$.fragment,e),g(R.$$.fragment,e),g(X.$$.fragment,e),g($.$$.fragment,e),g(V.$$.fragment,e),g(q.$$.fragment,e),g(D.$$.fragment,e),Ge=!1},d(e){e&&(a(u),a(c),a(M),a(te),a(j),a(ae),a(_),a(se),a(le),a(ne),a(ie),a(C),a(oe),a(I),a(pe),a(re),a(U),a(ce),a(S),a(ue),a(L),a(he),a(x),a(de),a(fe),a(k),a(me),a(E),a(ge),a(B),a(we),a(Me),a(Z),a(Te),a(A),a(be),a(P),a(ye),a(W),a($e),a(ve),a(F),a(je),a(N),a(_e),a(O),a(Je),a(Y),a(Ce),a(Ie),a(He),a(z),a(Ue),a(Q),a(Se),a(Le),a(xe),a(ee)),a(i),w(v,e),w(b,e),w(y,e),w(J,e),w(H,e),w(G,e),w(R,e),w(X,e),w($,e),w(V,e),w(q,e),w(D,e)}}}const yt='{"title":"Adding a Sign-In with HF button to your Space","local":"adding-a-sign-in-with-hf-button-to-your-space","sections":[{"title":"Create an OAuth app","local":"create-an-oauth-app","sections":[],"depth":2},{"title":"Redirect URLs","local":"redirect-urls","sections":[],"depth":2},{"title":"Scopes","local":"scopes","sections":[],"depth":2},{"title":"Adding the button to your Space","local":"adding-the-button-to-your-space","sections":[],"depth":2},{"title":"Examples:","local":"examples","sections":[],"depth":2}],"depth":1}';function $t(T){return ut(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class It extends ht{constructor(i){super(),dt(this,i,$t,bt,ct,{})}}export{It as component};
